#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_SCREENBROKER_SERVICE_H
#define BOSCH_CM_AI_HMI_SCREENBROKER_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "bosch.cm.ai.hmi.screenbroker.Service" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

// method IDs
static const uint16 ID_ClientTermination = 0;
static const uint16 ID_GetDisplayId = 1;
static const uint16 ID_GetPreferredDimensions = 2;
static const uint16 ID_RegisterSurface = 3;
static const uint16 ID_DeregisterSurface = 4;
static const uint16 ID_ActivateApplication = 5;
static const uint16 ID_StartAnimation = 6;
static const uint16 ID_AttachandAnimateLayer = 7;
static const uint16 ID_ShowPopup = 8;
static const uint16 ID_HidePopup = 9;
static const uint16 ID_CloseOnExternalTouch = 10;
static const uint16 ID_SetPopupFilter = 11;
static const uint16 ID_ClearPopupFilter = 12;
static const uint16 ID_KeyFeedback = 13;
static const uint16 ID_Action = 14;
static const uint16 ID_SetInputFocus = 15;
static const uint16 ID_RequestCurrentStatus = 16;

// signal IDs
static const uint16 ID_OnGetDisplayId = 17;
static const uint16 ID_OnGetPreferredDimensions = 18;
static const uint16 ID_OnSurfaceStateChanged = 19;
static const uint16 ID_OnError = 20;
static const uint16 ID_OnKeyEvent = 21;
static const uint16 ID_OnCurrentStatus = 22;
static const uint16 ID_OnCloseOnExternalTouch = 23;
static const uint16 ID_OnLayerStateChanged = 24;

// property IDs
static const uint16 ID_Version = 25;
static const uint16 ID_BuildInLayers = 26;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class ClientTerminationRequest;

class ClientTerminationResponse;

class GetDisplayIdRequest;

class GetPreferredDimensionsRequest;

class RegisterSurfaceRequest;

class DeregisterSurfaceRequest;

class ActivateApplicationRequest;

class StartAnimationRequest;

class AttachandAnimateLayerRequest;

class ShowPopupRequest;

class HidePopupRequest;

class CloseOnExternalTouchRequest;

class SetPopupFilterRequest;

class ClearPopupFilterRequest;

class KeyFeedbackRequest;

class ActionRequest;

class SetInputFocusRequest;

class RequestCurrentStatusRequest;

class VersionUpdate;

class VersionRegister;

class BuildInLayersUpdate;

class BuildInLayersRegister;

class OnGetDisplayIdSignal;

class OnGetPreferredDimensionsSignal;

class OnSurfaceStateChangedSignal;

class OnErrorSignal;

class OnKeyEventSignal;

class OnCurrentStatusSignal;

class OnCloseOnExternalTouchSignal;

class OnLayerStateChangedSignal;

// type definitions
/**
 * If the meaning of "ClientTerminationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClientTerminationError;

/**
 * Requests the alpha-numerical ID (name) of the display the addressed screen area is configured to.
 * 		Requested values are provided by response "OnGetDisplayId".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetDisplayIdResponse;

/**
 * If the meaning of "GetDisplayIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetDisplayIdError;

/**
 * Requests the dimensions a "full area surface" should have to fit to the screen area identified by "screenAreaId".
 * 		Requested values are provided by response "OnGetPreferredDimensions".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPreferredDimensionsResponse;

/**
 * If the meaning of "GetPreferredDimensionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPreferredDimensionsError;

/**
 * Registers the ILM surface addressed by "surfaceId" to the screen area addressed by "screenAreaId".
 * 		Surface specific hinting information is provided in field "userData"
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RegisterSurfaceResponse;

/**
 * If the meaning of "RegisterSurfaceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterSurfaceError;

/**
 * Deregisters the surface addressed by "surfaceId".
 * 		Surface specific hinting information is provided in field "userData"
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeregisterSurfaceResponse;

/**
 * If the meaning of "DeregisterSurfaceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeregisterSurfaceError;

/**
 * Requests the activation of the requesting client application and applies the keyboard focus to the surface addressed by "surfaceId".
 * 		Activation status is provided by response "OnActivateApplication".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActivateApplicationResponse;

/**
 * If the meaning of "ActivateApplicationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateApplicationError;

/**
 * Requests the client application and applies animation Entry/Exit for the same surface "surfaceId".
 * 		Activation status is provided by response "OnStartAnimation".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartAnimationResponse;

/**
 * If the meaning of "StartAnimationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartAnimationError;

/**
 * Requests the client application and applies animation to the Layer with surfaces.
 * 		Activation status is provided by response "OnAttachandAnimateLayer".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AttachandAnimateLayerResponse;

/**
 * If the meaning of "AttachandAnimateLayerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AttachandAnimateLayerError;

/**
 * Requests the presentation of the surface pop-up overlay addressed by "surfaceId". The surface must be registered on a screen area dedicated for pop-ups in order to be presented as pop-up. Additional arguments are passed to activator plug-ins.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowPopupResponse;

/**
 * If the meaning of "ShowPopupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowPopupError;

/**
 * Requests the concealing of the surface pop-up overlay addressed by "surfaceId".
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HidePopupResponse;

/**
 * If the meaning of "HidePopupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HidePopupError;

/**
 * Requests closing popup based on external touch.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CloseOnExternalTouchResponse;

/**
 * If the meaning of "CloseOnExternalTouchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CloseOnExternalTouchError;

/**
 * Filters the presentation of popups matching the given popup presentation arguments. Filter arguments are passed to activator plug-ins.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetPopupFilterResponse;

/**
 * If the meaning of "SetPopupFilterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPopupFilterError;

/**
 * Clears a previous set popup filter. Additional arguments are passed to activator plug-ins.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ClearPopupFilterResponse;

/**
 * If the meaning of "ClearPopupFilterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClearPopupFilterError;

/**
 * Returns the feedback from the client, whether it has consumed the respective event or not.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage KeyFeedbackResponse;

/**
 * If the meaning of "KeyFeedbackError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyFeedbackError;

/**
 * Interface for requesting a generic action towards screenbroker service resp. its plugins.
 * 		The generic action request is routed to all attached plugins.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActionResponse;

/**
 * If the meaning of "ActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActionError;

/**
 * set input focus
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetInputFocusResponse;

/**
 * If the meaning of "SetInputFocusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetInputFocusError;

/**
 * Generic interface for requesting the current status based on the request ID,
 * 		which defines the details of the status requests nature.
 * 		The status request is routed to all attached plugins.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestCurrentStatusResponse;

/**
 * If the meaning of "RequestCurrentStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestCurrentStatusError;

/**
 * If the meaning of "Version" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionSet;

/**
 * If the meaning of "Version" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionGet;

/**
 * If the meaning of "VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionError;

/**
 * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
 */
typedef BuildInLayersUpdate BuildInLayersSet;

/**
 * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
 */
typedef BuildInLayersUpdate BuildInLayersGet;

/**
 * If the meaning of "BuildInLayersError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BuildInLayersError;

/**
 * If the meaning of "OnGetDisplayIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnGetDisplayIdError;

/**
 * If the meaning of "OnGetPreferredDimensionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnGetPreferredDimensionsError;

/**
 * If the meaning of "OnSurfaceStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnSurfaceStateChangedError;

/**
 * If the meaning of "OnErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnErrorError;

/**
 * If the meaning of "OnKeyEventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnKeyEventError;

/**
 * If the meaning of "OnCurrentStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnCurrentStatusError;

/**
 * If the meaning of "OnCloseOnExternalTouchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnCloseOnExternalTouchError;

/**
 * If the meaning of "OnLayerStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnLayerStateChangedError;


/**
 * Informs service about a client shutdown.
 */
class ClientTerminationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClientTerminationRequest ();

    /**
     * Copy constructor
     */
    inline  ClientTerminationRequest (const ClientTerminationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ClientTerminationRequest (const ::std::string& clientId_);

    /**
     * Destructor
     */
    inline virtual  ~ClientTerminationRequest();

    /**
     * Assignment operator
     */
    inline ClientTerminationRequest& operator = (const ClientTerminationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClientTerminationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClientTerminationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClientTerminationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClientTerminationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    static const ClientTerminationRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _clientId;

};

/**
 * Informs service about a client shutdown.
 */
class ClientTerminationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClientTerminationResponse ();

    /**
     * Copy constructor
     */
    inline  ClientTerminationResponse (const ClientTerminationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ClientTerminationResponse (bool success_);

    /**
     * Destructor
     */
    inline virtual  ~ClientTerminationResponse();

    /**
     * Assignment operator
     */
    inline ClientTerminationResponse& operator = (const ClientTerminationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClientTerminationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClientTerminationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClientTerminationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClientTerminationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "success"

    static const int kSuccess = 0;

    /**
     * Clears the field "success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "success".
     *
     * Informs if the client shutdown has succeeded.
     *
     * @return The value of the field "success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "success".
     *
     * Informs if the client shutdown has succeeded.
     *
     * @param success The value which will be set
     */
    inline void setSuccess (bool success_);

    static const ClientTerminationResponse &getDefaultInstance();

private:

    inline void set_has_success ();

    inline void clear_has_success ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _success;

};

/**
 * Requests the alpha-numerical ID (name) of the display the addressed screen area is configured to.
 * 		Requested values are provided by response "OnGetDisplayId".
 */
class GetDisplayIdRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDisplayIdRequest ();

    /**
     * Copy constructor
     */
    inline  GetDisplayIdRequest (const GetDisplayIdRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetDisplayIdRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_);

    /**
     * Destructor
     */
    inline virtual  ~GetDisplayIdRequest();

    /**
     * Assignment operator
     */
    inline GetDisplayIdRequest& operator = (const GetDisplayIdRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDisplayIdRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDisplayIdRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDisplayIdRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDisplayIdRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "screenAreaId"

    static const int kScreenAreaId = 2;

    /**
     * Clears the field "screenAreaId".
     *
     * The field will be set to its default value. The hasScreenAreaId()
     * method will return false.
     */
    inline void clearScreenAreaId();

    /**
     * Checks whether the field "screenAreaId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenAreaId()). Otherwise it will return false.
     */
    inline bool hasScreenAreaId () const;

    /**
     * Returns the value of the member "screenAreaId".
     *
     * ID of screen area, for which the request is issued.
     *
     * @return The value of the field "screenAreaId"
     */
    inline uint32 getScreenAreaId () const;

    /**
     * Sets the value of the member "screenAreaId".
     *
     * ID of screen area, for which the request is issued.
     *
     * @param screenAreaId The value which will be set
     */
    inline void setScreenAreaId (uint32 screenAreaId_);

    static const GetDisplayIdRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_screenAreaId ();

    inline void clear_has_screenAreaId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _screenAreaId;

};

/**
 * Requests the dimensions a "full area surface" should have to fit to the screen area identified by "screenAreaId".
 * 		Requested values are provided by response "OnGetPreferredDimensions".
 */
class GetPreferredDimensionsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPreferredDimensionsRequest ();

    /**
     * Copy constructor
     */
    inline  GetPreferredDimensionsRequest (const GetPreferredDimensionsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetPreferredDimensionsRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_);

    /**
     * Destructor
     */
    inline virtual  ~GetPreferredDimensionsRequest();

    /**
     * Assignment operator
     */
    inline GetPreferredDimensionsRequest& operator = (const GetPreferredDimensionsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPreferredDimensionsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPreferredDimensionsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPreferredDimensionsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPreferredDimensionsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "screenAreaId"

    static const int kScreenAreaId = 2;

    /**
     * Clears the field "screenAreaId".
     *
     * The field will be set to its default value. The hasScreenAreaId()
     * method will return false.
     */
    inline void clearScreenAreaId();

    /**
     * Checks whether the field "screenAreaId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenAreaId()). Otherwise it will return false.
     */
    inline bool hasScreenAreaId () const;

    /**
     * Returns the value of the member "screenAreaId".
     *
     * ID of screen area, for which the request is issued.
     *
     * @return The value of the field "screenAreaId"
     */
    inline uint32 getScreenAreaId () const;

    /**
     * Sets the value of the member "screenAreaId".
     *
     * ID of screen area, for which the request is issued.
     *
     * @param screenAreaId The value which will be set
     */
    inline void setScreenAreaId (uint32 screenAreaId_);

    static const GetPreferredDimensionsRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_screenAreaId ();

    inline void clear_has_screenAreaId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _screenAreaId;

};

/**
 * Registers the ILM surface addressed by "surfaceId" to the screen area addressed by "screenAreaId".
 * 		Surface specific hinting information is provided in field "userData"
 */
class RegisterSurfaceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterSurfaceRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterSurfaceRequest (const RegisterSurfaceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterSurfaceRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_, uint32 surfaceId_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterSurfaceRequest();

    /**
     * Assignment operator
     */
    inline RegisterSurfaceRequest& operator = (const RegisterSurfaceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterSurfaceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterSurfaceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterSurfaceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterSurfaceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "screenAreaId"

    static const int kScreenAreaId = 2;

    /**
     * Clears the field "screenAreaId".
     *
     * The field will be set to its default value. The hasScreenAreaId()
     * method will return false.
     */
    inline void clearScreenAreaId();

    /**
     * Checks whether the field "screenAreaId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenAreaId()). Otherwise it will return false.
     */
    inline bool hasScreenAreaId () const;

    /**
     * Returns the value of the member "screenAreaId".
     *
     * The ID of the screen area to address.
     *
     * @return The value of the field "screenAreaId"
     */
    inline uint32 getScreenAreaId () const;

    /**
     * Sets the value of the member "screenAreaId".
     *
     * The ID of the screen area to address.
     *
     * @param screenAreaId The value which will be set
     */
    inline void setScreenAreaId (uint32 screenAreaId_);

    // API of field "surfaceId"

    static const int kSurfaceId = 3;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    static const RegisterSurfaceRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_screenAreaId ();

    inline void clear_has_screenAreaId ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _screenAreaId;

    uint32 _surfaceId;

};

/**
 * Deregisters the surface addressed by "surfaceId".
 * 		Surface specific hinting information is provided in field "userData"
 */
class DeregisterSurfaceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeregisterSurfaceRequest ();

    /**
     * Copy constructor
     */
    inline  DeregisterSurfaceRequest (const DeregisterSurfaceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeregisterSurfaceRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, bool sendToIlm_);

    /**
     * Destructor
     */
    inline virtual  ~DeregisterSurfaceRequest();

    /**
     * Assignment operator
     */
    inline DeregisterSurfaceRequest& operator = (const DeregisterSurfaceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeregisterSurfaceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeregisterSurfaceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeregisterSurfaceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeregisterSurfaceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "sendToIlm"

    static const int kSendToIlm = 3;

    /**
     * Clears the field "sendToIlm".
     *
     * The field will be set to its default value. The hasSendToIlm()
     * method will return false.
     */
    inline void clearSendToIlm();

    /**
     * Checks whether the field "sendToIlm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSendToIlm()). Otherwise it will return false.
     */
    inline bool hasSendToIlm () const;

    /**
     * Returns the value of the member "sendToIlm".
     *
     * If remove surface should be send to ILM.
     *
     * @return The value of the field "sendToIlm"
     */
    inline bool getSendToIlm () const;

    /**
     * Sets the value of the member "sendToIlm".
     *
     * If remove surface should be send to ILM.
     *
     * @param sendToIlm The value which will be set
     */
    inline void setSendToIlm (bool sendToIlm_);

    static const DeregisterSurfaceRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_sendToIlm ();

    inline void clear_has_sendToIlm ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _surfaceId;

    bool _sendToIlm;

};

/**
 * Requests the activation of the requesting client application and applies the keyboard focus to the surface addressed by "surfaceId".
 * 		Activation status is provided by response "OnActivateApplication".
 */
class ActivateApplicationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateApplicationRequest ();

    /**
     * Copy constructor
     */
    inline  ActivateApplicationRequest (const ActivateApplicationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateApplicationRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, uint32 entryCustomAnimationType_, uint32 exitCustomAnimationType_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateApplicationRequest();

    /**
     * Assignment operator
     */
    inline ActivateApplicationRequest& operator = (const ActivateApplicationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateApplicationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateApplicationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateApplicationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateApplicationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "entryCustomAnimationType"

    static const int kEntryCustomAnimationType = 3;

    /**
     * Clears the field "entryCustomAnimationType".
     *
     * The field will be set to its default value. The hasEntryCustomAnimationType()
     * method will return false.
     */
    inline void clearEntryCustomAnimationType();

    /**
     * Checks whether the field "entryCustomAnimationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntryCustomAnimationType()). Otherwise it will return false.
     */
    inline bool hasEntryCustomAnimationType () const;

    /**
     * Returns the value of the member "entryCustomAnimationType".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "entryCustomAnimationType"
     */
    inline uint32 getEntryCustomAnimationType () const;

    /**
     * Sets the value of the member "entryCustomAnimationType".
     *
     * The ID of the surface to address.
     *
     * @param entryCustomAnimationType The value which will be set
     */
    inline void setEntryCustomAnimationType (uint32 entryCustomAnimationType_);

    // API of field "exitCustomAnimationType"

    static const int kExitCustomAnimationType = 4;

    /**
     * Clears the field "exitCustomAnimationType".
     *
     * The field will be set to its default value. The hasExitCustomAnimationType()
     * method will return false.
     */
    inline void clearExitCustomAnimationType();

    /**
     * Checks whether the field "exitCustomAnimationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExitCustomAnimationType()). Otherwise it will return false.
     */
    inline bool hasExitCustomAnimationType () const;

    /**
     * Returns the value of the member "exitCustomAnimationType".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "exitCustomAnimationType"
     */
    inline uint32 getExitCustomAnimationType () const;

    /**
     * Sets the value of the member "exitCustomAnimationType".
     *
     * The ID of the surface to address.
     *
     * @param exitCustomAnimationType The value which will be set
     */
    inline void setExitCustomAnimationType (uint32 exitCustomAnimationType_);

    static const ActivateApplicationRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_entryCustomAnimationType ();

    inline void clear_has_entryCustomAnimationType ();

    inline void set_has_exitCustomAnimationType ();

    inline void clear_has_exitCustomAnimationType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _surfaceId;

    uint32 _entryCustomAnimationType;

    uint32 _exitCustomAnimationType;

};

/**
 * Requests the client application and applies animation Entry/Exit for the same surface "surfaceId".
 * 		Activation status is provided by response "OnStartAnimation".
 */
class StartAnimationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartAnimationRequest ();

    /**
     * Copy constructor
     */
    inline  StartAnimationRequest (const StartAnimationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartAnimationRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, uint32 animationType_, uint32 hint_);

    /**
     * Destructor
     */
    inline virtual  ~StartAnimationRequest();

    /**
     * Assignment operator
     */
    inline StartAnimationRequest& operator = (const StartAnimationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAnimationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAnimationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAnimationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAnimationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "animationType"

    static const int kAnimationType = 3;

    /**
     * Clears the field "animationType".
     *
     * The field will be set to its default value. The hasAnimationType()
     * method will return false.
     */
    inline void clearAnimationType();

    /**
     * Checks whether the field "animationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnimationType()). Otherwise it will return false.
     */
    inline bool hasAnimationType () const;

    /**
     * Returns the value of the member "animationType".
     *
     * The value of animationType. It could be customeAnimation
     *
     * @return The value of the field "animationType"
     */
    inline uint32 getAnimationType () const;

    /**
     * Sets the value of the member "animationType".
     *
     * The value of animationType. It could be customeAnimation
     *
     * @param animationType The value which will be set
     */
    inline void setAnimationType (uint32 animationType_);

    // API of field "hint"

    static const int kHint = 4;

    /**
     * Clears the field "hint".
     *
     * The field will be set to its default value. The hasHint()
     * method will return false.
     */
    inline void clearHint();

    /**
     * Checks whether the field "hint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHint()). Otherwise it will return false.
     */
    inline bool hasHint () const;

    /**
     * Returns the value of the member "hint".
     *
     * The value of hint. used to perform animation
     *
     * @return The value of the field "hint"
     */
    inline uint32 getHint () const;

    /**
     * Sets the value of the member "hint".
     *
     * The value of hint. used to perform animation
     *
     * @param hint The value which will be set
     */
    inline void setHint (uint32 hint_);

    static const StartAnimationRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_animationType ();

    inline void clear_has_animationType ();

    inline void set_has_hint ();

    inline void clear_has_hint ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _surfaceId;

    uint32 _animationType;

    uint32 _hint;

};

/**
 * Requests the client application and applies animation to the Layer with surfaces.
 * 		Activation status is provided by response "OnAttachandAnimateLayer".
 */
class AttachandAnimateLayerRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AttachandAnimateLayerRequest ();

    /**
     * Copy constructor
     */
    inline  AttachandAnimateLayerRequest (const AttachandAnimateLayerRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AttachandAnimateLayerRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 layerID_, const ::std::vector< uint32 >& surfaceID_, uint32 animationType_, uint32 hint_);

    /**
     * Destructor
     */
    inline virtual  ~AttachandAnimateLayerRequest();

    /**
     * Assignment operator
     */
    inline AttachandAnimateLayerRequest& operator = (const AttachandAnimateLayerRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AttachandAnimateLayerRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AttachandAnimateLayerRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AttachandAnimateLayerRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AttachandAnimateLayerRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "layerID"

    static const int kLayerID = 2;

    /**
     * Clears the field "layerID".
     *
     * The field will be set to its default value. The hasLayerID()
     * method will return false.
     */
    inline void clearLayerID();

    /**
     * Checks whether the field "layerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLayerID()). Otherwise it will return false.
     */
    inline bool hasLayerID () const;

    /**
     * Returns the value of the member "layerID".
     *
     * The ID of the Layer to address.
     *
     * @return The value of the field "layerID"
     */
    inline uint32 getLayerID () const;

    /**
     * Sets the value of the member "layerID".
     *
     * The ID of the Layer to address.
     *
     * @param layerID The value which will be set
     */
    inline void setLayerID (uint32 layerID_);

    // API of field "surfaceID"

    static const int kSurfaceID = 3;

    /**
     * Clears the field "surfaceID".
     *
     * The field will be set to its default value. The hasSurfaceID()
     * method will return false.
     */
    inline void clearSurfaceID();

    /**
     * Checks whether the field "surfaceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceID()). Otherwise it will return false.
     */
    inline bool hasSurfaceID () const;

    /**
     * Returns the value of the member "surfaceID".
     *
     * The list of surface to be attached
     *
     * @return The value of the field "surfaceID"
     */
    inline const ::std::vector< uint32 >& getSurfaceID () const;

    /**
     * Retrieves the value of the field "surfaceID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "surfaceID".
     */
    inline ::std::vector< uint32 >& getSurfaceIDMutable ();

    /**
     * Sets the value of the member "surfaceID".
     *
     * The list of surface to be attached
     *
     * @param surfaceID The value which will be set
     */
    inline void setSurfaceID (const ::std::vector< uint32 >& surfaceID_);

    // API of field "animationType"

    static const int kAnimationType = 4;

    /**
     * Clears the field "animationType".
     *
     * The field will be set to its default value. The hasAnimationType()
     * method will return false.
     */
    inline void clearAnimationType();

    /**
     * Checks whether the field "animationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnimationType()). Otherwise it will return false.
     */
    inline bool hasAnimationType () const;

    /**
     * Returns the value of the member "animationType".
     *
     * The value of animationType
     *
     * @return The value of the field "animationType"
     */
    inline uint32 getAnimationType () const;

    /**
     * Sets the value of the member "animationType".
     *
     * The value of animationType
     *
     * @param animationType The value which will be set
     */
    inline void setAnimationType (uint32 animationType_);

    // API of field "hint"

    static const int kHint = 5;

    /**
     * Clears the field "hint".
     *
     * The field will be set to its default value. The hasHint()
     * method will return false.
     */
    inline void clearHint();

    /**
     * Checks whether the field "hint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHint()). Otherwise it will return false.
     */
    inline bool hasHint () const;

    /**
     * Returns the value of the member "hint".
     *
     * The value of hint. used to perform animation
     *
     * @return The value of the field "hint"
     */
    inline uint32 getHint () const;

    /**
     * Sets the value of the member "hint".
     *
     * The value of hint. used to perform animation
     *
     * @param hint The value which will be set
     */
    inline void setHint (uint32 hint_);

    static const AttachandAnimateLayerRequest &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_layerID ();

    inline void clear_has_layerID ();

    inline void set_has_surfaceID ();

    inline void clear_has_surfaceID ();

    inline void set_has_animationType ();

    inline void clear_has_animationType ();

    inline void set_has_hint ();

    inline void clear_has_hint ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _layerID;

    ::std::vector< uint32 > _surfaceID;

    uint32 _animationType;

    uint32 _hint;

};

/**
 * Requests the presentation of the surface pop-up overlay addressed by "surfaceId". The surface must be registered on a screen area dedicated for pop-ups in order to be presented as pop-up. Additional arguments are passed to activator plug-ins.
 */
class ShowPopupRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowPopupRequest ();

    /**
     * Copy constructor
     */
    inline  ShowPopupRequest (const ShowPopupRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowPopupRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_);

    /**
     * Destructor
     */
    inline virtual  ~ShowPopupRequest();

    /**
     * Assignment operator
     */
    inline ShowPopupRequest& operator = (const ShowPopupRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowPopupRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowPopupRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowPopupRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowPopupRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "popupPresentationArg"

    static const int kPopupPresentationArg = 3;

    /**
     * Clears the field "popupPresentationArg".
     *
     * The field will be set to its default value. The hasPopupPresentationArg()
     * method will return false.
     */
    inline void clearPopupPresentationArg();

    /**
     * Checks whether the field "popupPresentationArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPopupPresentationArg()). Otherwise it will return false.
     */
    inline bool hasPopupPresentationArg () const;

    /**
     * Returns the value of the member "popupPresentationArg".
     *
     * The presentation arguments for pop-up overlays.
     *
     * @return The value of the field "popupPresentationArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& getPopupPresentationArg () const;

    /**
     * Retrieves the value of the field "popupPresentationArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "popupPresentationArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& getPopupPresentationArgMutable ();

    /**
     * Sets the value of the member "popupPresentationArg".
     *
     * The presentation arguments for pop-up overlays.
     *
     * @param popupPresentationArg The value which will be set
     */
    inline void setPopupPresentationArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_);

    static const ShowPopupRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_popupPresentationArg ();

    inline void clear_has_popupPresentationArg ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _surfaceId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg _popupPresentationArg;

};

/**
 * Requests the concealing of the surface pop-up overlay addressed by "surfaceId".
 */
class HidePopupRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HidePopupRequest ();

    /**
     * Copy constructor
     */
    inline  HidePopupRequest (const HidePopupRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HidePopupRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_);

    /**
     * Destructor
     */
    inline virtual  ~HidePopupRequest();

    /**
     * Assignment operator
     */
    inline HidePopupRequest& operator = (const HidePopupRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HidePopupRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HidePopupRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HidePopupRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HidePopupRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    static const HidePopupRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _surfaceId;

};

/**
 * Requests closing popup based on external touch.
 */
class CloseOnExternalTouchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CloseOnExternalTouchRequest ();

    /**
     * Copy constructor
     */
    inline  CloseOnExternalTouchRequest (const CloseOnExternalTouchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CloseOnExternalTouchRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    /**
     * Destructor
     */
    inline virtual  ~CloseOnExternalTouchRequest();

    /**
     * Assignment operator
     */
    inline CloseOnExternalTouchRequest& operator = (const CloseOnExternalTouchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CloseOnExternalTouchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CloseOnExternalTouchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CloseOnExternalTouchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CloseOnExternalTouchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    static const CloseOnExternalTouchRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

};

/**
 * Filters the presentation of popups matching the given popup presentation arguments. Filter arguments are passed to activator plug-ins.
 */
class SetPopupFilterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPopupFilterRequest ();

    /**
     * Copy constructor
     */
    inline  SetPopupFilterRequest (const SetPopupFilterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPopupFilterRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, bool disableAll_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_);

    /**
     * Destructor
     */
    inline virtual  ~SetPopupFilterRequest();

    /**
     * Assignment operator
     */
    inline SetPopupFilterRequest& operator = (const SetPopupFilterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPopupFilterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPopupFilterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPopupFilterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPopupFilterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "disableAll"

    static const int kDisableAll = 2;

    /**
     * Clears the field "disableAll".
     *
     * The field will be set to its default value. The hasDisableAll()
     * method will return false.
     */
    inline void clearDisableAll();

    /**
     * Checks whether the field "disableAll" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisableAll()). Otherwise it will return false.
     */
    inline bool hasDisableAll () const;

    /**
     * Returns the value of the member "disableAll".
     *
     * If true, presentation of all popups shall be disabled. In this case the argument popupPresentationArg is "don't care".
     *
     * @return The value of the field "disableAll"
     */
    inline bool getDisableAll () const;

    /**
     * Sets the value of the member "disableAll".
     *
     * If true, presentation of all popups shall be disabled. In this case the argument popupPresentationArg is "don't care".
     *
     * @param disableAll The value which will be set
     */
    inline void setDisableAll (bool disableAll_);

    // API of field "popupPresentationArg"

    static const int kPopupPresentationArg = 3;

    /**
     * Clears the field "popupPresentationArg".
     *
     * The field will be set to its default value. The hasPopupPresentationArg()
     * method will return false.
     */
    inline void clearPopupPresentationArg();

    /**
     * Checks whether the field "popupPresentationArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPopupPresentationArg()). Otherwise it will return false.
     */
    inline bool hasPopupPresentationArg () const;

    /**
     * Returns the value of the member "popupPresentationArg".
     *
     * The presentation arguments presenting the filter arguments. Only valid if argument "disableAll" is false.
     *
     * @return The value of the field "popupPresentationArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& getPopupPresentationArg () const;

    /**
     * Retrieves the value of the field "popupPresentationArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "popupPresentationArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& getPopupPresentationArgMutable ();

    /**
     * Sets the value of the member "popupPresentationArg".
     *
     * The presentation arguments presenting the filter arguments. Only valid if argument "disableAll" is false.
     *
     * @param popupPresentationArg The value which will be set
     */
    inline void setPopupPresentationArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_);

    static const SetPopupFilterRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_disableAll ();

    inline void clear_has_disableAll ();

    inline void set_has_popupPresentationArg ();

    inline void clear_has_popupPresentationArg ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    bool _disableAll;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg _popupPresentationArg;

};

/**
 * Clears a previous set popup filter. Additional arguments are passed to activator plug-ins.
 */
class ClearPopupFilterRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearPopupFilterRequest ();

    /**
     * Copy constructor
     */
    inline  ClearPopupFilterRequest (const ClearPopupFilterRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ClearPopupFilterRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    /**
     * Destructor
     */
    inline virtual  ~ClearPopupFilterRequest();

    /**
     * Assignment operator
     */
    inline ClearPopupFilterRequest& operator = (const ClearPopupFilterRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearPopupFilterRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearPopupFilterRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearPopupFilterRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearPopupFilterRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    static const ClearPopupFilterRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

};

/**
 * Returns the feedback from the client, whether it has consumed the respective event or not.
 */
class KeyFeedbackRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyFeedbackRequest ();

    /**
     * Copy constructor
     */
    inline  KeyFeedbackRequest (const KeyFeedbackRequest &rhs);

    /**
     * All fields constructor
     */
    inline  KeyFeedbackRequest (const ::std::string& clientId_, uint32 userData_, uint32 keyCode_, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_, bool consumed_);

    /**
     * Destructor
     */
    inline virtual  ~KeyFeedbackRequest();

    /**
     * Assignment operator
     */
    inline KeyFeedbackRequest& operator = (const KeyFeedbackRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyFeedbackRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyFeedbackRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyFeedbackRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyFeedbackRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    // API of field "keyCode"

    static const int kKeyCode = 2;

    /**
     * Clears the field "keyCode".
     *
     * The field will be set to its default value. The hasKeyCode()
     * method will return false.
     */
    inline void clearKeyCode();

    /**
     * Checks whether the field "keyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCode()). Otherwise it will return false.
     */
    inline bool hasKeyCode () const;

    /**
     * Returns the value of the member "keyCode".
     *
     * 32bit code of the key event.
     *
     * @return The value of the field "keyCode"
     */
    inline uint32 getKeyCode () const;

    /**
     * Sets the value of the member "keyCode".
     *
     * 32bit code of the key event.
     *
     * @param keyCode The value which will be set
     */
    inline void setKeyCode (uint32 keyCode_);

    // API of field "keyState"

    static const int kKeyState = 3;

    /**
     * Clears the field "keyState".
     *
     * The field will be set to its default value. The hasKeyState()
     * method will return false.
     */
    inline void clearKeyState();

    /**
     * Checks whether the field "keyState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyState()). Otherwise it will return false.
     */
    inline bool hasKeyState () const;

    /**
     * Returns the value of the member "keyState".
     *
     * The state of the key event.
     *
     * @return The value of the field "keyState"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::KeyState getKeyState () const;

    /**
     * Sets the value of the member "keyState".
     *
     * The state of the key event.
     *
     * @param keyState The value which will be set
     */
    inline void setKeyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_);

    // API of field "consumed"

    static const int kConsumed = 4;

    /**
     * Clears the field "consumed".
     *
     * The field will be set to its default value. The hasConsumed()
     * method will return false.
     */
    inline void clearConsumed();

    /**
     * Checks whether the field "consumed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumed()). Otherwise it will return false.
     */
    inline bool hasConsumed () const;

    /**
     * Returns the value of the member "consumed".
     *
     * True, if the key event was already consumed, false otherwise.
     *
     * @return The value of the field "consumed"
     */
    inline bool getConsumed () const;

    /**
     * Sets the value of the member "consumed".
     *
     * True, if the key event was already consumed, false otherwise.
     *
     * @param consumed The value which will be set
     */
    inline void setConsumed (bool consumed_);

    static const KeyFeedbackRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    inline void set_has_keyCode ();

    inline void clear_has_keyCode ();

    inline void set_has_keyState ();

    inline void clear_has_keyState ();

    inline void set_has_consumed ();

    inline void clear_has_consumed ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _clientId;

    uint32 _userData;

    uint32 _keyCode;

    ::bosch::cm::ai::hmi::screenbroker::Types::KeyState _keyState;

    bool _consumed;

};

/**
 * Interface for requesting a generic action towards screenbroker service resp. its plugins.
 * 		The generic action request is routed to all attached plugins.
 */
class ActionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActionRequest ();

    /**
     * Copy constructor
     */
    inline  ActionRequest (const ActionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ActionRequest (const ::std::string& clientId_, uint32 actionId_, uint32 actionData_);

    /**
     * Destructor
     */
    inline virtual  ~ActionRequest();

    /**
     * Assignment operator
     */
    inline ActionRequest& operator = (const ActionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "actionId"

    static const int kActionId = 1;

    /**
     * Clears the field "actionId".
     *
     * The field will be set to its default value. The hasActionId()
     * method will return false.
     */
    inline void clearActionId();

    /**
     * Checks whether the field "actionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionId()). Otherwise it will return false.
     */
    inline bool hasActionId () const;

    /**
     * Returns the value of the member "actionId".
     *
     * 32bit information to transport details of the kind of action.
     *
     * @return The value of the field "actionId"
     */
    inline uint32 getActionId () const;

    /**
     * Sets the value of the member "actionId".
     *
     * 32bit information to transport details of the kind of action.
     *
     * @param actionId The value which will be set
     */
    inline void setActionId (uint32 actionId_);

    // API of field "actionData"

    static const int kActionData = 2;

    /**
     * Clears the field "actionData".
     *
     * The field will be set to its default value. The hasActionData()
     * method will return false.
     */
    inline void clearActionData();

    /**
     * Checks whether the field "actionData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionData()). Otherwise it will return false.
     */
    inline bool hasActionData () const;

    /**
     * Returns the value of the member "actionData".
     *
     * 32bit information to transport action specific data.
     *
     * @return The value of the field "actionData"
     */
    inline uint32 getActionData () const;

    /**
     * Sets the value of the member "actionData".
     *
     * 32bit information to transport action specific data.
     *
     * @param actionData The value which will be set
     */
    inline void setActionData (uint32 actionData_);

    static const ActionRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_actionId ();

    inline void clear_has_actionId ();

    inline void set_has_actionData ();

    inline void clear_has_actionData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    uint32 _actionId;

    uint32 _actionData;

};

/**
 * set input focus
 */
class SetInputFocusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetInputFocusRequest ();

    /**
     * Copy constructor
     */
    inline  SetInputFocusRequest (const SetInputFocusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetInputFocusRequest (const ::std::string& clientId_, uint32 surfaceId_, bool keyboardFocus_, bool pointerFocus_, int32 priority_, uint32 focusData_);

    /**
     * Destructor
     */
    inline virtual  ~SetInputFocusRequest();

    /**
     * Assignment operator
     */
    inline SetInputFocusRequest& operator = (const SetInputFocusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetInputFocusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetInputFocusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetInputFocusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetInputFocusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "surfaceId"

    static const int kSurfaceId = 1;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface to address.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "keyboardFocus"

    static const int kKeyboardFocus = 2;

    /**
     * Clears the field "keyboardFocus".
     *
     * The field will be set to its default value. The hasKeyboardFocus()
     * method will return false.
     */
    inline void clearKeyboardFocus();

    /**
     * Checks whether the field "keyboardFocus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyboardFocus()). Otherwise it will return false.
     */
    inline bool hasKeyboardFocus () const;

    /**
     * Returns the value of the member "keyboardFocus".
     *
     * keyboard focus
     *
     * @return The value of the field "keyboardFocus"
     */
    inline bool getKeyboardFocus () const;

    /**
     * Sets the value of the member "keyboardFocus".
     *
     * keyboard focus
     *
     * @param keyboardFocus The value which will be set
     */
    inline void setKeyboardFocus (bool keyboardFocus_);

    // API of field "pointerFocus"

    static const int kPointerFocus = 3;

    /**
     * Clears the field "pointerFocus".
     *
     * The field will be set to its default value. The hasPointerFocus()
     * method will return false.
     */
    inline void clearPointerFocus();

    /**
     * Checks whether the field "pointerFocus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPointerFocus()). Otherwise it will return false.
     */
    inline bool hasPointerFocus () const;

    /**
     * Returns the value of the member "pointerFocus".
     *
     * pointer focus
     *
     * @return The value of the field "pointerFocus"
     */
    inline bool getPointerFocus () const;

    /**
     * Sets the value of the member "pointerFocus".
     *
     * pointer focus
     *
     * @param pointerFocus The value which will be set
     */
    inline void setPointerFocus (bool pointerFocus_);

    // API of field "priority"

    static const int kPriority = 4;

    /**
     * Clears the field "priority".
     *
     * The field will be set to its default value. The hasPriority()
     * method will return false.
     */
    inline void clearPriority();

    /**
     * Checks whether the field "priority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPriority()). Otherwise it will return false.
     */
    inline bool hasPriority () const;

    /**
     * Returns the value of the member "priority".
     *
     * focus priority
     *
     * @return The value of the field "priority"
     */
    inline int32 getPriority () const;

    /**
     * Sets the value of the member "priority".
     *
     * focus priority
     *
     * @param priority The value which will be set
     */
    inline void setPriority (int32 priority_);

    // API of field "focusData"

    static const int kFocusData = 5;

    /**
     * Clears the field "focusData".
     *
     * The field will be set to its default value. The hasFocusData()
     * method will return false.
     */
    inline void clearFocusData();

    /**
     * Checks whether the field "focusData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFocusData()). Otherwise it will return false.
     */
    inline bool hasFocusData () const;

    /**
     * Returns the value of the member "focusData".
     *
     * 32bit information to transport focus specific data.
     *
     * @return The value of the field "focusData"
     */
    inline uint32 getFocusData () const;

    /**
     * Sets the value of the member "focusData".
     *
     * 32bit information to transport focus specific data.
     *
     * @param focusData The value which will be set
     */
    inline void setFocusData (uint32 focusData_);

    static const SetInputFocusRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_keyboardFocus ();

    inline void clear_has_keyboardFocus ();

    inline void set_has_pointerFocus ();

    inline void clear_has_pointerFocus ();

    inline void set_has_priority ();

    inline void clear_has_priority ();

    inline void set_has_focusData ();

    inline void clear_has_focusData ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _clientId;

    uint32 _surfaceId;

    bool _keyboardFocus;

    bool _pointerFocus;

    int32 _priority;

    uint32 _focusData;

};

/**
 * Generic interface for requesting the current status based on the request ID,
 * 		which defines the details of the status requests nature.
 * 		The status request is routed to all attached plugins.
 */
class RequestCurrentStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestCurrentStatusRequest ();

    /**
     * Copy constructor
     */
    inline  RequestCurrentStatusRequest (const RequestCurrentStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestCurrentStatusRequest (const ::std::string& clientId_, uint32 requestId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestCurrentStatusRequest();

    /**
     * Assignment operator
     */
    inline RequestCurrentStatusRequest& operator = (const RequestCurrentStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestCurrentStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestCurrentStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestCurrentStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestCurrentStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the sender of the request.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestId"

    static const int kRequestId = 1;

    /**
     * Clears the field "requestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "requestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "requestId".
     *
     * 32bit information to transport details of the requests nature.
     *
     * @return The value of the field "requestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "requestId".
     *
     * 32bit information to transport details of the requests nature.
     *
     * @param requestId The value which will be set
     */
    inline void setRequestId (uint32 requestId_);

    static const RequestCurrentStatusRequest &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestId ();

    inline void clear_has_requestId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _clientId;

    uint32 _requestId;

};

/**
 * If the meaning of "Version" isn't clear, then there should be a description here.
 */
class VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionUpdate (const VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionUpdate (const ::std::string& Version_);

    /**
     * Destructor
     */
    inline virtual  ~VersionUpdate();

    /**
     * Assignment operator
     */
    inline VersionUpdate& operator = (const VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline const ::std::string& getVersion () const;

    /**
     * Retrieves the value of the field "Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Version".
     */
    inline ::std::string& getVersionMutable ();

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const ::std::string& Version_);

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* Version_);

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (const char* value, size_t size);

    static const VersionUpdate &getDefaultInstance();

private:

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Version;

};

/**
 * If the meaning of "Version" isn't clear, then there should be a description here.
 */
class VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionRegister ();

    /**
     * Copy constructor
     */
    inline  VersionRegister (const VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionRegister();

    /**
     * Assignment operator
     */
    inline VersionRegister& operator = (const VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
 */
class BuildInLayersUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BuildInLayersUpdate ();

    /**
     * Copy constructor
     */
    inline  BuildInLayersUpdate (const BuildInLayersUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInLayersUpdate (const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayers_);

    /**
     * Destructor
     */
    inline virtual  ~BuildInLayersUpdate();

    /**
     * Assignment operator
     */
    inline BuildInLayersUpdate& operator = (const BuildInLayersUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInLayersUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInLayersUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInLayersUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInLayersUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BuildInLayers"

    static const int kBuildInLayers = 0;

    /**
     * Clears the field "BuildInLayers".
     *
     * The field will be set to its default value. The hasBuildInLayers()
     * method will return false.
     */
    inline void clearBuildInLayers();

    /**
     * Checks whether the field "BuildInLayers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuildInLayers()). Otherwise it will return false.
     */
    inline bool hasBuildInLayers () const;

    /**
     * Returns the value of the member "BuildInLayers".
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BuildInLayers"
     */
    inline const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayers () const;

    /**
     * Retrieves the value of the field "BuildInLayers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BuildInLayers".
     */
    inline ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayersMutable ();

    /**
     * Sets the value of the member "BuildInLayers".
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     *
     * @param BuildInLayers The value which will be set
     */
    inline void setBuildInLayers (const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayers_);

    static const BuildInLayersUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayerInfoList_DefaultInstance ();

    inline void set_has_BuildInLayers ();

    inline void clear_has_BuildInLayers ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo > _BuildInLayers;

};

/**
 * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
 */
class BuildInLayersRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BuildInLayersRegister ();

    /**
     * Copy constructor
     */
    inline  BuildInLayersRegister (const BuildInLayersRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BuildInLayersRegister();

    /**
     * Assignment operator
     */
    inline BuildInLayersRegister& operator = (const BuildInLayersRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInLayersRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInLayersRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInLayersRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInLayersRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BuildInLayersRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * The response to "GetDisplayId" request providing the requested display ID (name).
 */
class OnGetDisplayIdSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnGetDisplayIdSignal ();

    /**
     * Copy constructor
     */
    inline  OnGetDisplayIdSignal (const OnGetDisplayIdSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnGetDisplayIdSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 displayId_);

    /**
     * Destructor
     */
    inline virtual  ~OnGetDisplayIdSignal();

    /**
     * Assignment operator
     */
    inline OnGetDisplayIdSignal& operator = (const OnGetDisplayIdSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnGetDisplayIdSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnGetDisplayIdSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnGetDisplayIdSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnGetDisplayIdSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "displayId"

    static const int kDisplayId = 2;

    /**
     * Clears the field "displayId".
     *
     * The field will be set to its default value. The hasDisplayId()
     * method will return false.
     */
    inline void clearDisplayId();

    /**
     * Checks whether the field "displayId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayId()). Otherwise it will return false.
     */
    inline bool hasDisplayId () const;

    /**
     * Returns the value of the member "displayId".
     *
     * The display ID, where the screen area (from request) is linked to.
     *
     * @return The value of the field "displayId"
     */
    inline uint32 getDisplayId () const;

    /**
     * Sets the value of the member "displayId".
     *
     * The display ID, where the screen area (from request) is linked to.
     *
     * @param displayId The value which will be set
     */
    inline void setDisplayId (uint32 displayId_);

    static const OnGetDisplayIdSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_displayId ();

    inline void clear_has_displayId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    uint32 _displayId;

};

/**
 * The response to "GetPreferredDimensions" request providing the requested dimensions (width/height).
 */
class OnGetPreferredDimensionsSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnGetPreferredDimensionsSignal ();

    /**
     * Copy constructor
     */
    inline  OnGetPreferredDimensionsSignal (const OnGetPreferredDimensionsSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnGetPreferredDimensionsSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg_);

    /**
     * Destructor
     */
    inline virtual  ~OnGetPreferredDimensionsSignal();

    /**
     * Assignment operator
     */
    inline OnGetPreferredDimensionsSignal& operator = (const OnGetPreferredDimensionsSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnGetPreferredDimensionsSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnGetPreferredDimensionsSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnGetPreferredDimensionsSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnGetPreferredDimensionsSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "dimensionArg"

    static const int kDimensionArg = 2;

    /**
     * Clears the field "dimensionArg".
     *
     * The field will be set to its default value. The hasDimensionArg()
     * method will return false.
     */
    inline void clearDimensionArg();

    /**
     * Checks whether the field "dimensionArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimensionArg()). Otherwise it will return false.
     */
    inline bool hasDimensionArg () const;

    /**
     * Returns the value of the member "dimensionArg".
     *
     * The dimensions of the screen area (from request).
     *
     * @return The value of the field "dimensionArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& getDimensionArg () const;

    /**
     * Retrieves the value of the field "dimensionArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dimensionArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& getDimensionArgMutable ();

    /**
     * Sets the value of the member "dimensionArg".
     *
     * The dimensions of the screen area (from request).
     *
     * @param dimensionArg The value which will be set
     */
    inline void setDimensionArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg_);

    static const OnGetPreferredDimensionsSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_dimensionArg ();

    inline void clear_has_dimensionArg ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg _dimensionArg;

};

/**
 * Notifies clients that the state of the indicated surface has changed.
 */
class OnSurfaceStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnSurfaceStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  OnSurfaceStateChangedSignal (const OnSurfaceStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnSurfaceStateChangedSignal (const ::std::string& clientId_, uint32 userData_, uint32 surfaceId_, uint32 displayId_, uint32 displayAlias_, ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState_);

    /**
     * Destructor
     */
    inline virtual  ~OnSurfaceStateChangedSignal();

    /**
     * Assignment operator
     */
    inline OnSurfaceStateChangedSignal& operator = (const OnSurfaceStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnSurfaceStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnSurfaceStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnSurfaceStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnSurfaceStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * The user defined data.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * The user defined data.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the affected surface.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the affected surface.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "displayId"

    static const int kDisplayId = 3;

    /**
     * Clears the field "displayId".
     *
     * The field will be set to its default value. The hasDisplayId()
     * method will return false.
     */
    inline void clearDisplayId();

    /**
     * Checks whether the field "displayId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayId()). Otherwise it will return false.
     */
    inline bool hasDisplayId () const;

    /**
     * Returns the value of the member "displayId".
     *
     * DEPRECATED: The ID of the affected display.
     *
     * @return The value of the field "displayId"
     */
    inline uint32 getDisplayId () const;

    /**
     * Sets the value of the member "displayId".
     *
     * DEPRECATED: The ID of the affected display.
     *
     * @param displayId The value which will be set
     */
    inline void setDisplayId (uint32 displayId_);

    // API of field "displayAlias"

    static const int kDisplayAlias = 4;

    /**
     * Clears the field "displayAlias".
     *
     * The field will be set to its default value. The hasDisplayAlias()
     * method will return false.
     */
    inline void clearDisplayAlias();

    /**
     * Checks whether the field "displayAlias" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayAlias()). Otherwise it will return false.
     */
    inline bool hasDisplayAlias () const;

    /**
     * Returns the value of the member "displayAlias".
     *
     * The alias of the affected display.
     *
     * @return The value of the field "displayAlias"
     */
    inline uint32 getDisplayAlias () const;

    /**
     * Sets the value of the member "displayAlias".
     *
     * The alias of the affected display.
     *
     * @param displayAlias The value which will be set
     */
    inline void setDisplayAlias (uint32 displayAlias_);

    // API of field "surfaceState"

    static const int kSurfaceState = 5;

    /**
     * Clears the field "surfaceState".
     *
     * The field will be set to its default value. The hasSurfaceState()
     * method will return false.
     */
    inline void clearSurfaceState();

    /**
     * Checks whether the field "surfaceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceState()). Otherwise it will return false.
     */
    inline bool hasSurfaceState () const;

    /**
     * Returns the value of the member "surfaceState".
     *
     * The new state of the surface.
     *
     * @return The value of the field "surfaceState"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState getSurfaceState () const;

    /**
     * Sets the value of the member "surfaceState".
     *
     * The new state of the surface.
     *
     * @param surfaceState The value which will be set
     */
    inline void setSurfaceState (::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState_);

    static const OnSurfaceStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_displayId ();

    inline void clear_has_displayId ();

    inline void set_has_displayAlias ();

    inline void clear_has_displayAlias ();

    inline void set_has_surfaceState ();

    inline void clear_has_surfaceState ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _clientId;

    uint32 _userData;

    uint32 _surfaceId;

    uint32 _displayId;

    uint32 _displayAlias;

    ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState _surfaceState;

};

/**
 * The error response to any failed request providing information about the error.
 */
class OnErrorSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnErrorSignal ();

    /**
     * Copy constructor
     */
    inline  OnErrorSignal (const OnErrorSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnErrorSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, int32 systemErrno_, int32 presentationErrno_);

    /**
     * Destructor
     */
    inline virtual  ~OnErrorSignal();

    /**
     * Assignment operator
     */
    inline OnErrorSignal& operator = (const OnErrorSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnErrorSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnErrorSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnErrorSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnErrorSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestArg"

    static const int kRequestArg = 1;

    /**
     * Clears the field "requestArg".
     *
     * The field will be set to its default value. The hasRequestArg()
     * method will return false.
     */
    inline void clearRequestArg();

    /**
     * Checks whether the field "requestArg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestArg()). Otherwise it will return false.
     */
    inline bool hasRequestArg () const;

    /**
     * Returns the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @return The value of the field "requestArg"
     */
    inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArg () const;

    /**
     * Retrieves the value of the field "requestArg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestArg".
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& getRequestArgMutable ();

    /**
     * Sets the value of the member "requestArg".
     *
     * General application specific request information.
     *
     * @param requestArg The value which will be set
     */
    inline void setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_);

    // API of field "systemErrno"

    static const int kSystemErrno = 2;

    /**
     * Clears the field "systemErrno".
     *
     * The field will be set to its default value. The hasSystemErrno()
     * method will return false.
     */
    inline void clearSystemErrno();

    /**
     * Checks whether the field "systemErrno" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemErrno()). Otherwise it will return false.
     */
    inline bool hasSystemErrno () const;

    /**
     * Returns the value of the member "systemErrno".
     *
     * System error codes (like linux extended error codes defined in linux/errno.h).
     *
     * @return The value of the field "systemErrno"
     */
    inline int32 getSystemErrno () const;

    /**
     * Sets the value of the member "systemErrno".
     *
     * System error codes (like linux extended error codes defined in linux/errno.h).
     *
     * @param systemErrno The value which will be set
     */
    inline void setSystemErrno (int32 systemErrno_);

    // API of field "presentationErrno"

    static const int kPresentationErrno = 3;

    /**
     * Clears the field "presentationErrno".
     *
     * The field will be set to its default value. The hasPresentationErrno()
     * method will return false.
     */
    inline void clearPresentationErrno();

    /**
     * Checks whether the field "presentationErrno" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresentationErrno()). Otherwise it will return false.
     */
    inline bool hasPresentationErrno () const;

    /**
     * Returns the value of the member "presentationErrno".
     *
     * Error codes specific to the visual presentation module screen broker is connected to (e.g. layer manager).
     *
     * @return The value of the field "presentationErrno"
     */
    inline int32 getPresentationErrno () const;

    /**
     * Sets the value of the member "presentationErrno".
     *
     * Error codes specific to the visual presentation module screen broker is connected to (e.g. layer manager).
     *
     * @param presentationErrno The value which will be set
     */
    inline void setPresentationErrno (int32 presentationErrno_);

    static const OnErrorSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestArg ();

    inline void clear_has_requestArg ();

    inline void set_has_systemErrno ();

    inline void clear_has_systemErrno ();

    inline void set_has_presentationErrno ();

    inline void clear_has_presentationErrno ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

    int32 _systemErrno;

    int32 _presentationErrno;

};

/**
 * Notifies clients that a key event has occurred.
 */
class OnKeyEventSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnKeyEventSignal ();

    /**
     * Copy constructor
     */
    inline  OnKeyEventSignal (const OnKeyEventSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnKeyEventSignal (const ::std::string& clientId_, uint32 userData_, uint32 surfaceId_, uint32 keyCode_, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_);

    /**
     * Destructor
     */
    inline virtual  ~OnKeyEventSignal();

    /**
     * Assignment operator
     */
    inline OnKeyEventSignal& operator = (const OnKeyEventSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnKeyEventSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnKeyEventSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnKeyEventSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnKeyEventSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "userData"

    static const int kUserData = 1;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * The user defined data.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * The user defined data.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface, which is currently focused.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface, which is currently focused.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "keyCode"

    static const int kKeyCode = 3;

    /**
     * Clears the field "keyCode".
     *
     * The field will be set to its default value. The hasKeyCode()
     * method will return false.
     */
    inline void clearKeyCode();

    /**
     * Checks whether the field "keyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyCode()). Otherwise it will return false.
     */
    inline bool hasKeyCode () const;

    /**
     * Returns the value of the member "keyCode".
     *
     * 32bit code of the key event.
     *
     * @return The value of the field "keyCode"
     */
    inline uint32 getKeyCode () const;

    /**
     * Sets the value of the member "keyCode".
     *
     * 32bit code of the key event.
     *
     * @param keyCode The value which will be set
     */
    inline void setKeyCode (uint32 keyCode_);

    // API of field "keyState"

    static const int kKeyState = 4;

    /**
     * Clears the field "keyState".
     *
     * The field will be set to its default value. The hasKeyState()
     * method will return false.
     */
    inline void clearKeyState();

    /**
     * Checks whether the field "keyState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyState()). Otherwise it will return false.
     */
    inline bool hasKeyState () const;

    /**
     * Returns the value of the member "keyState".
     *
     * The state of the key event.
     *
     * @return The value of the field "keyState"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::KeyState getKeyState () const;

    /**
     * Sets the value of the member "keyState".
     *
     * The state of the key event.
     *
     * @param keyState The value which will be set
     */
    inline void setKeyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_);

    static const OnKeyEventSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_keyCode ();

    inline void clear_has_keyCode ();

    inline void set_has_keyState ();

    inline void clear_has_keyState ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _clientId;

    uint32 _userData;

    uint32 _surfaceId;

    uint32 _keyCode;

    ::bosch::cm::ai::hmi::screenbroker::Types::KeyState _keyState;

};

/**
 * The response to "RequestCurrentStatus" request providing the status details based on
 *                 the request.
 */
class OnCurrentStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnCurrentStatusSignal ();

    /**
     * Copy constructor
     */
    inline  OnCurrentStatusSignal (const OnCurrentStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnCurrentStatusSignal (const ::std::string& clientId_, uint32 requestId_, uint32 surfaceId_, uint32 status_, uint32 userData_);

    /**
     * Destructor
     */
    inline virtual  ~OnCurrentStatusSignal();

    /**
     * Assignment operator
     */
    inline OnCurrentStatusSignal& operator = (const OnCurrentStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnCurrentStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnCurrentStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnCurrentStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnCurrentStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestId"

    static const int kRequestId = 1;

    /**
     * Clears the field "requestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "requestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "requestId".
     *
     * 32bit information to inform about details of the requests nature.
     *
     * @return The value of the field "requestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "requestId".
     *
     * 32bit information to inform about details of the requests nature.
     *
     * @param requestId The value which will be set
     */
    inline void setRequestId (uint32 requestId_);

    // API of field "surfaceId"

    static const int kSurfaceId = 2;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     * The ID of the surface, which identifies the response path, may also be part of the status response.
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     * The ID of the surface, which identifies the response path, may also be part of the status response.
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "status"

    static const int kStatus = 3;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * 32bit of response data carrying the status information.
     *
     * @return The value of the field "status"
     */
    inline uint32 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * 32bit of response data carrying the status information.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint32 status_);

    // API of field "userData"

    static const int kUserData = 4;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * Additional 32bit of user data for whatever use.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * Additional 32bit of user data for whatever use.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const OnCurrentStatusSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestId ();

    inline void clear_has_requestId ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _clientId;

    uint32 _requestId;

    uint32 _surfaceId;

    uint32 _status;

    uint32 _userData;

};

/**
 * Notifies clients that close on external touch is enabled or disabled.
 */
class OnCloseOnExternalTouchSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnCloseOnExternalTouchSignal ();

    /**
     * Copy constructor
     */
    inline  OnCloseOnExternalTouchSignal (const OnCloseOnExternalTouchSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnCloseOnExternalTouchSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~OnCloseOnExternalTouchSignal();

    /**
     * Assignment operator
     */
    inline OnCloseOnExternalTouchSignal& operator = (const OnCloseOnExternalTouchSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnCloseOnExternalTouchSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnCloseOnExternalTouchSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnCloseOnExternalTouchSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnCloseOnExternalTouchSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Enabled or Disabled
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Enabled or Disabled
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const OnCloseOnExternalTouchSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * Notifies clients that about Layer with layer animation state.
 */
class OnLayerStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnLayerStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  OnLayerStateChangedSignal (const OnLayerStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnLayerStateChangedSignal (const ::std::string& clientId_, uint32 requestId_, uint32 layerID_, ::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState_);

    /**
     * Destructor
     */
    inline virtual  ~OnLayerStateChangedSignal();

    /**
     * Assignment operator
     */
    inline OnLayerStateChangedSignal& operator = (const OnLayerStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnLayerStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnLayerStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnLayerStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnLayerStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "clientId"

    static const int kClientId = 0;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @return The value of the field "clientId"
     */
    inline const ::std::string& getClientId () const;

    /**
     * Retrieves the value of the field "clientId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientId".
     */
    inline ::std::string& getClientIdMutable ();

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const ::std::string& clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* clientId_);

    /**
     * Sets the value of the member "clientId".
     *
     * Unique client identification, identifies the receiver of the response.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (const char* value, size_t size);

    // API of field "requestId"

    static const int kRequestId = 1;

    /**
     * Clears the field "requestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "requestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "requestId".
     *
     * 32bit information to inform about details of the requests nature.
     *
     * @return The value of the field "requestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "requestId".
     *
     * 32bit information to inform about details of the requests nature.
     *
     * @param requestId The value which will be set
     */
    inline void setRequestId (uint32 requestId_);

    // API of field "layerID"

    static const int kLayerID = 2;

    /**
     * Clears the field "layerID".
     *
     * The field will be set to its default value. The hasLayerID()
     * method will return false.
     */
    inline void clearLayerID();

    /**
     * Checks whether the field "layerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLayerID()). Otherwise it will return false.
     */
    inline bool hasLayerID () const;

    /**
     * Returns the value of the member "layerID".
     *
     * Value of Layer
     *
     * @return The value of the field "layerID"
     */
    inline uint32 getLayerID () const;

    /**
     * Sets the value of the member "layerID".
     *
     * Value of Layer
     *
     * @param layerID The value which will be set
     */
    inline void setLayerID (uint32 layerID_);

    // API of field "layerState"

    static const int kLayerState = 3;

    /**
     * Clears the field "layerState".
     *
     * The field will be set to its default value. The hasLayerState()
     * method will return false.
     */
    inline void clearLayerState();

    /**
     * Checks whether the field "layerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLayerState()). Otherwise it will return false.
     */
    inline bool hasLayerState () const;

    /**
     * Returns the value of the member "layerState".
     *
     * State of the Layer
     *
     * @return The value of the field "layerState"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::LayerState getLayerState () const;

    /**
     * Sets the value of the member "layerState".
     *
     * State of the Layer
     *
     * @param layerState The value which will be set
     */
    inline void setLayerState (::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState_);

    static const OnLayerStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    inline void set_has_requestId ();

    inline void clear_has_requestId ();

    inline void set_has_layerID ();

    inline void clear_has_layerID ();

    inline void set_has_layerState ();

    inline void clear_has_layerState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _clientId;

    uint32 _requestId;

    uint32 _layerID;

    ::bosch::cm::ai::hmi::screenbroker::Types::LayerState _layerState;

};

inline  ClientTerminationRequest::ClientTerminationRequest ()  :
    _clientId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClientTerminationRequest::ClientTerminationRequest (const ClientTerminationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClientTerminationRequest::ClientTerminationRequest (const ::std::string& clientId_)  :
    _clientId (clientId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClientTerminationRequest::~ClientTerminationRequest() {
}

inline ClientTerminationRequest& ClientTerminationRequest::operator = (const ClientTerminationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
    }
    return *this;
}

inline bool ClientTerminationRequest::operator == (const ClientTerminationRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()));
}

inline bool ClientTerminationRequest::operator != (const ClientTerminationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ClientTerminationRequest::operator < (const ClientTerminationRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClientTerminationRequest::clone() {
    return new ClientTerminationRequest(*this);
}

inline bool ClientTerminationRequest::operator > (const ClientTerminationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClientTerminationRequest::clear() {
    clearClientId();
}

inline void ClientTerminationRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool ClientTerminationRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ClientTerminationRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& ClientTerminationRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void ClientTerminationRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void ClientTerminationRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void ClientTerminationRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void ClientTerminationRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClientTerminationRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ClientTerminationResponse::ClientTerminationResponse ()  :
    _success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClientTerminationResponse::ClientTerminationResponse (const ClientTerminationResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _success (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClientTerminationResponse::ClientTerminationResponse (bool success_)  :
    _success (success_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClientTerminationResponse::~ClientTerminationResponse() {
}

inline ClientTerminationResponse& ClientTerminationResponse::operator = (const ClientTerminationResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
    }
    return *this;
}

inline bool ClientTerminationResponse::operator == (const ClientTerminationResponse& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()));
}

inline bool ClientTerminationResponse::operator != (const ClientTerminationResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ClientTerminationResponse::operator < (const ClientTerminationResponse& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClientTerminationResponse::clone() {
    return new ClientTerminationResponse(*this);
}

inline bool ClientTerminationResponse::operator > (const ClientTerminationResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClientTerminationResponse::clear() {
    clearSuccess();
}

inline void ClientTerminationResponse::clearSuccess() {
    if (hasSuccess()) {
         clear_has_success();
        _success = false;
     }
}

inline bool ClientTerminationResponse::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ClientTerminationResponse::getSuccess () const {
    return _success;
}

inline void ClientTerminationResponse::setSuccess (bool success_) {
    set_has_success();
    this->_success = success_;
}

inline void ClientTerminationResponse::set_has_success () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClientTerminationResponse::clear_has_success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetDisplayIdRequest::GetDisplayIdRequest ()  :
    _clientId (),
    _requestArg (),
    _screenAreaId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDisplayIdRequest::GetDisplayIdRequest (const GetDisplayIdRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _screenAreaId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDisplayIdRequest::GetDisplayIdRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _screenAreaId (screenAreaId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDisplayIdRequest::~GetDisplayIdRequest() {
}

inline GetDisplayIdRequest& GetDisplayIdRequest::operator = (const GetDisplayIdRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasScreenAreaId()) {
            setScreenAreaId(rhs.getScreenAreaId());
        } else {
            clearScreenAreaId();
        }
    }
    return *this;
}

inline bool GetDisplayIdRequest::operator == (const GetDisplayIdRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasScreenAreaId() && !rhs.hasScreenAreaId()) || getScreenAreaId() == rhs.getScreenAreaId()));
}

inline bool GetDisplayIdRequest::operator != (const GetDisplayIdRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDisplayIdRequest::operator < (const GetDisplayIdRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasScreenAreaId() || rhs.hasScreenAreaId()) {
        if (getScreenAreaId() < rhs.getScreenAreaId()) return true;
        if (getScreenAreaId() > rhs.getScreenAreaId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDisplayIdRequest::clone() {
    return new GetDisplayIdRequest(*this);
}

inline bool GetDisplayIdRequest::operator > (const GetDisplayIdRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDisplayIdRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearScreenAreaId();
}

inline void GetDisplayIdRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool GetDisplayIdRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetDisplayIdRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& GetDisplayIdRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void GetDisplayIdRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void GetDisplayIdRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void GetDisplayIdRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void GetDisplayIdRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool GetDisplayIdRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& GetDisplayIdRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& GetDisplayIdRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void GetDisplayIdRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void GetDisplayIdRequest::clearScreenAreaId() {
    if (hasScreenAreaId()) {
         clear_has_screenAreaId();
        _screenAreaId = 0u;
     }
}

inline bool GetDisplayIdRequest::hasScreenAreaId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetDisplayIdRequest::getScreenAreaId () const {
    return _screenAreaId;
}

inline void GetDisplayIdRequest::setScreenAreaId (uint32 screenAreaId_) {
    set_has_screenAreaId();
    this->_screenAreaId = screenAreaId_;
}

inline void GetDisplayIdRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDisplayIdRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetDisplayIdRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetDisplayIdRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetDisplayIdRequest::set_has_screenAreaId () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetDisplayIdRequest::clear_has_screenAreaId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetPreferredDimensionsRequest::GetPreferredDimensionsRequest ()  :
    _clientId (),
    _requestArg (),
    _screenAreaId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPreferredDimensionsRequest::GetPreferredDimensionsRequest (const GetPreferredDimensionsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _screenAreaId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPreferredDimensionsRequest::GetPreferredDimensionsRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _screenAreaId (screenAreaId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPreferredDimensionsRequest::~GetPreferredDimensionsRequest() {
}

inline GetPreferredDimensionsRequest& GetPreferredDimensionsRequest::operator = (const GetPreferredDimensionsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasScreenAreaId()) {
            setScreenAreaId(rhs.getScreenAreaId());
        } else {
            clearScreenAreaId();
        }
    }
    return *this;
}

inline bool GetPreferredDimensionsRequest::operator == (const GetPreferredDimensionsRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasScreenAreaId() && !rhs.hasScreenAreaId()) || getScreenAreaId() == rhs.getScreenAreaId()));
}

inline bool GetPreferredDimensionsRequest::operator != (const GetPreferredDimensionsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPreferredDimensionsRequest::operator < (const GetPreferredDimensionsRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasScreenAreaId() || rhs.hasScreenAreaId()) {
        if (getScreenAreaId() < rhs.getScreenAreaId()) return true;
        if (getScreenAreaId() > rhs.getScreenAreaId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPreferredDimensionsRequest::clone() {
    return new GetPreferredDimensionsRequest(*this);
}

inline bool GetPreferredDimensionsRequest::operator > (const GetPreferredDimensionsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPreferredDimensionsRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearScreenAreaId();
}

inline void GetPreferredDimensionsRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool GetPreferredDimensionsRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetPreferredDimensionsRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& GetPreferredDimensionsRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void GetPreferredDimensionsRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void GetPreferredDimensionsRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void GetPreferredDimensionsRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void GetPreferredDimensionsRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool GetPreferredDimensionsRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& GetPreferredDimensionsRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& GetPreferredDimensionsRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void GetPreferredDimensionsRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void GetPreferredDimensionsRequest::clearScreenAreaId() {
    if (hasScreenAreaId()) {
         clear_has_screenAreaId();
        _screenAreaId = 0u;
     }
}

inline bool GetPreferredDimensionsRequest::hasScreenAreaId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetPreferredDimensionsRequest::getScreenAreaId () const {
    return _screenAreaId;
}

inline void GetPreferredDimensionsRequest::setScreenAreaId (uint32 screenAreaId_) {
    set_has_screenAreaId();
    this->_screenAreaId = screenAreaId_;
}

inline void GetPreferredDimensionsRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPreferredDimensionsRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPreferredDimensionsRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPreferredDimensionsRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetPreferredDimensionsRequest::set_has_screenAreaId () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetPreferredDimensionsRequest::clear_has_screenAreaId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RegisterSurfaceRequest::RegisterSurfaceRequest ()  :
    _clientId (),
    _requestArg (),
    _screenAreaId (0u),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterSurfaceRequest::RegisterSurfaceRequest (const RegisterSurfaceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _screenAreaId (0u),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterSurfaceRequest::RegisterSurfaceRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 screenAreaId_, uint32 surfaceId_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _screenAreaId (screenAreaId_),
    _surfaceId (surfaceId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterSurfaceRequest::~RegisterSurfaceRequest() {
}

inline RegisterSurfaceRequest& RegisterSurfaceRequest::operator = (const RegisterSurfaceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasScreenAreaId()) {
            setScreenAreaId(rhs.getScreenAreaId());
        } else {
            clearScreenAreaId();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
    }
    return *this;
}

inline bool RegisterSurfaceRequest::operator == (const RegisterSurfaceRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasScreenAreaId() && !rhs.hasScreenAreaId()) || getScreenAreaId() == rhs.getScreenAreaId()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()));
}

inline bool RegisterSurfaceRequest::operator != (const RegisterSurfaceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterSurfaceRequest::operator < (const RegisterSurfaceRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasScreenAreaId() || rhs.hasScreenAreaId()) {
        if (getScreenAreaId() < rhs.getScreenAreaId()) return true;
        if (getScreenAreaId() > rhs.getScreenAreaId()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterSurfaceRequest::clone() {
    return new RegisterSurfaceRequest(*this);
}

inline bool RegisterSurfaceRequest::operator > (const RegisterSurfaceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterSurfaceRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearScreenAreaId();
    clearSurfaceId();
}

inline void RegisterSurfaceRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool RegisterSurfaceRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterSurfaceRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& RegisterSurfaceRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void RegisterSurfaceRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void RegisterSurfaceRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void RegisterSurfaceRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void RegisterSurfaceRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool RegisterSurfaceRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& RegisterSurfaceRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& RegisterSurfaceRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void RegisterSurfaceRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void RegisterSurfaceRequest::clearScreenAreaId() {
    if (hasScreenAreaId()) {
         clear_has_screenAreaId();
        _screenAreaId = 0u;
     }
}

inline bool RegisterSurfaceRequest::hasScreenAreaId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RegisterSurfaceRequest::getScreenAreaId () const {
    return _screenAreaId;
}

inline void RegisterSurfaceRequest::setScreenAreaId (uint32 screenAreaId_) {
    set_has_screenAreaId();
    this->_screenAreaId = screenAreaId_;
}

inline void RegisterSurfaceRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool RegisterSurfaceRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 RegisterSurfaceRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void RegisterSurfaceRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void RegisterSurfaceRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterSurfaceRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterSurfaceRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterSurfaceRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegisterSurfaceRequest::set_has_screenAreaId () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegisterSurfaceRequest::clear_has_screenAreaId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RegisterSurfaceRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 3;
}

inline void RegisterSurfaceRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DeregisterSurfaceRequest::DeregisterSurfaceRequest ()  :
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _sendToIlm (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeregisterSurfaceRequest::DeregisterSurfaceRequest (const DeregisterSurfaceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _sendToIlm (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeregisterSurfaceRequest::DeregisterSurfaceRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, bool sendToIlm_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _surfaceId (surfaceId_),
    _sendToIlm (sendToIlm_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeregisterSurfaceRequest::~DeregisterSurfaceRequest() {
}

inline DeregisterSurfaceRequest& DeregisterSurfaceRequest::operator = (const DeregisterSurfaceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasSendToIlm()) {
            setSendToIlm(rhs.getSendToIlm());
        } else {
            clearSendToIlm();
        }
    }
    return *this;
}

inline bool DeregisterSurfaceRequest::operator == (const DeregisterSurfaceRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasSendToIlm() && !rhs.hasSendToIlm()) || getSendToIlm() == rhs.getSendToIlm()));
}

inline bool DeregisterSurfaceRequest::operator != (const DeregisterSurfaceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeregisterSurfaceRequest::operator < (const DeregisterSurfaceRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasSendToIlm() || rhs.hasSendToIlm()) {
        if (getSendToIlm() < rhs.getSendToIlm()) return true;
        if (getSendToIlm() > rhs.getSendToIlm()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeregisterSurfaceRequest::clone() {
    return new DeregisterSurfaceRequest(*this);
}

inline bool DeregisterSurfaceRequest::operator > (const DeregisterSurfaceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeregisterSurfaceRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearSurfaceId();
    clearSendToIlm();
}

inline void DeregisterSurfaceRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool DeregisterSurfaceRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeregisterSurfaceRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& DeregisterSurfaceRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void DeregisterSurfaceRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void DeregisterSurfaceRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void DeregisterSurfaceRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void DeregisterSurfaceRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool DeregisterSurfaceRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& DeregisterSurfaceRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& DeregisterSurfaceRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void DeregisterSurfaceRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void DeregisterSurfaceRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool DeregisterSurfaceRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 DeregisterSurfaceRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void DeregisterSurfaceRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void DeregisterSurfaceRequest::clearSendToIlm() {
    if (hasSendToIlm()) {
         clear_has_sendToIlm();
        _sendToIlm = false;
     }
}

inline bool DeregisterSurfaceRequest::hasSendToIlm () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool DeregisterSurfaceRequest::getSendToIlm () const {
    return _sendToIlm;
}

inline void DeregisterSurfaceRequest::setSendToIlm (bool sendToIlm_) {
    set_has_sendToIlm();
    this->_sendToIlm = sendToIlm_;
}

inline void DeregisterSurfaceRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeregisterSurfaceRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeregisterSurfaceRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeregisterSurfaceRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DeregisterSurfaceRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void DeregisterSurfaceRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DeregisterSurfaceRequest::set_has_sendToIlm () {
    _has_bits_[0] |= 1u << 3;
}

inline void DeregisterSurfaceRequest::clear_has_sendToIlm () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ActivateApplicationRequest::ActivateApplicationRequest ()  :
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _entryCustomAnimationType (0u),
    _exitCustomAnimationType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateApplicationRequest::ActivateApplicationRequest (const ActivateApplicationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _entryCustomAnimationType (0u),
    _exitCustomAnimationType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateApplicationRequest::ActivateApplicationRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, uint32 entryCustomAnimationType_, uint32 exitCustomAnimationType_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _surfaceId (surfaceId_),
    _entryCustomAnimationType (entryCustomAnimationType_),
    _exitCustomAnimationType (exitCustomAnimationType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateApplicationRequest::~ActivateApplicationRequest() {
}

inline ActivateApplicationRequest& ActivateApplicationRequest::operator = (const ActivateApplicationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasEntryCustomAnimationType()) {
            setEntryCustomAnimationType(rhs.getEntryCustomAnimationType());
        } else {
            clearEntryCustomAnimationType();
        }
        if (rhs.hasExitCustomAnimationType()) {
            setExitCustomAnimationType(rhs.getExitCustomAnimationType());
        } else {
            clearExitCustomAnimationType();
        }
    }
    return *this;
}

inline bool ActivateApplicationRequest::operator == (const ActivateApplicationRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasEntryCustomAnimationType() && !rhs.hasEntryCustomAnimationType()) || getEntryCustomAnimationType() == rhs.getEntryCustomAnimationType()) &&
        ((!hasExitCustomAnimationType() && !rhs.hasExitCustomAnimationType()) || getExitCustomAnimationType() == rhs.getExitCustomAnimationType()));
}

inline bool ActivateApplicationRequest::operator != (const ActivateApplicationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateApplicationRequest::operator < (const ActivateApplicationRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasEntryCustomAnimationType() || rhs.hasEntryCustomAnimationType()) {
        if (getEntryCustomAnimationType() < rhs.getEntryCustomAnimationType()) return true;
        if (getEntryCustomAnimationType() > rhs.getEntryCustomAnimationType()) return false;
    }
    if (hasExitCustomAnimationType() || rhs.hasExitCustomAnimationType()) {
        if (getExitCustomAnimationType() < rhs.getExitCustomAnimationType()) return true;
        if (getExitCustomAnimationType() > rhs.getExitCustomAnimationType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateApplicationRequest::clone() {
    return new ActivateApplicationRequest(*this);
}

inline bool ActivateApplicationRequest::operator > (const ActivateApplicationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateApplicationRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearSurfaceId();
    clearEntryCustomAnimationType();
    clearExitCustomAnimationType();
}

inline void ActivateApplicationRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool ActivateApplicationRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActivateApplicationRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& ActivateApplicationRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void ActivateApplicationRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void ActivateApplicationRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void ActivateApplicationRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void ActivateApplicationRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool ActivateApplicationRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ActivateApplicationRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ActivateApplicationRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void ActivateApplicationRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void ActivateApplicationRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool ActivateApplicationRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ActivateApplicationRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void ActivateApplicationRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void ActivateApplicationRequest::clearEntryCustomAnimationType() {
    if (hasEntryCustomAnimationType()) {
         clear_has_entryCustomAnimationType();
        _entryCustomAnimationType = 0u;
     }
}

inline bool ActivateApplicationRequest::hasEntryCustomAnimationType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 ActivateApplicationRequest::getEntryCustomAnimationType () const {
    return _entryCustomAnimationType;
}

inline void ActivateApplicationRequest::setEntryCustomAnimationType (uint32 entryCustomAnimationType_) {
    set_has_entryCustomAnimationType();
    this->_entryCustomAnimationType = entryCustomAnimationType_;
}

inline void ActivateApplicationRequest::clearExitCustomAnimationType() {
    if (hasExitCustomAnimationType()) {
         clear_has_exitCustomAnimationType();
        _exitCustomAnimationType = 0u;
     }
}

inline bool ActivateApplicationRequest::hasExitCustomAnimationType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 ActivateApplicationRequest::getExitCustomAnimationType () const {
    return _exitCustomAnimationType;
}

inline void ActivateApplicationRequest::setExitCustomAnimationType (uint32 exitCustomAnimationType_) {
    set_has_exitCustomAnimationType();
    this->_exitCustomAnimationType = exitCustomAnimationType_;
}

inline void ActivateApplicationRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateApplicationRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActivateApplicationRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActivateApplicationRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ActivateApplicationRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ActivateApplicationRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ActivateApplicationRequest::set_has_entryCustomAnimationType () {
    _has_bits_[0] |= 1u << 3;
}

inline void ActivateApplicationRequest::clear_has_entryCustomAnimationType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ActivateApplicationRequest::set_has_exitCustomAnimationType () {
    _has_bits_[0] |= 1u << 4;
}

inline void ActivateApplicationRequest::clear_has_exitCustomAnimationType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  StartAnimationRequest::StartAnimationRequest ()  :
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _animationType (0u),
    _hint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartAnimationRequest::StartAnimationRequest (const StartAnimationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _animationType (0u),
    _hint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartAnimationRequest::StartAnimationRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, uint32 animationType_, uint32 hint_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _surfaceId (surfaceId_),
    _animationType (animationType_),
    _hint (hint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartAnimationRequest::~StartAnimationRequest() {
}

inline StartAnimationRequest& StartAnimationRequest::operator = (const StartAnimationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasAnimationType()) {
            setAnimationType(rhs.getAnimationType());
        } else {
            clearAnimationType();
        }
        if (rhs.hasHint()) {
            setHint(rhs.getHint());
        } else {
            clearHint();
        }
    }
    return *this;
}

inline bool StartAnimationRequest::operator == (const StartAnimationRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasAnimationType() && !rhs.hasAnimationType()) || getAnimationType() == rhs.getAnimationType()) &&
        ((!hasHint() && !rhs.hasHint()) || getHint() == rhs.getHint()));
}

inline bool StartAnimationRequest::operator != (const StartAnimationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartAnimationRequest::operator < (const StartAnimationRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasAnimationType() || rhs.hasAnimationType()) {
        if (getAnimationType() < rhs.getAnimationType()) return true;
        if (getAnimationType() > rhs.getAnimationType()) return false;
    }
    if (hasHint() || rhs.hasHint()) {
        if (getHint() < rhs.getHint()) return true;
        if (getHint() > rhs.getHint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartAnimationRequest::clone() {
    return new StartAnimationRequest(*this);
}

inline bool StartAnimationRequest::operator > (const StartAnimationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartAnimationRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearSurfaceId();
    clearAnimationType();
    clearHint();
}

inline void StartAnimationRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool StartAnimationRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartAnimationRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& StartAnimationRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void StartAnimationRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void StartAnimationRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void StartAnimationRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void StartAnimationRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool StartAnimationRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& StartAnimationRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& StartAnimationRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void StartAnimationRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void StartAnimationRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool StartAnimationRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartAnimationRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void StartAnimationRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void StartAnimationRequest::clearAnimationType() {
    if (hasAnimationType()) {
         clear_has_animationType();
        _animationType = 0u;
     }
}

inline bool StartAnimationRequest::hasAnimationType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 StartAnimationRequest::getAnimationType () const {
    return _animationType;
}

inline void StartAnimationRequest::setAnimationType (uint32 animationType_) {
    set_has_animationType();
    this->_animationType = animationType_;
}

inline void StartAnimationRequest::clearHint() {
    if (hasHint()) {
         clear_has_hint();
        _hint = 0u;
     }
}

inline bool StartAnimationRequest::hasHint () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 StartAnimationRequest::getHint () const {
    return _hint;
}

inline void StartAnimationRequest::setHint (uint32 hint_) {
    set_has_hint();
    this->_hint = hint_;
}

inline void StartAnimationRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartAnimationRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartAnimationRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartAnimationRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartAnimationRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartAnimationRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void StartAnimationRequest::set_has_animationType () {
    _has_bits_[0] |= 1u << 3;
}

inline void StartAnimationRequest::clear_has_animationType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void StartAnimationRequest::set_has_hint () {
    _has_bits_[0] |= 1u << 4;
}

inline void StartAnimationRequest::clear_has_hint () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  AttachandAnimateLayerRequest::AttachandAnimateLayerRequest ()  :
    _clientId (),
    _requestArg (),
    _layerID (0u),
    _surfaceID (),
    _animationType (0u),
    _hint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AttachandAnimateLayerRequest::AttachandAnimateLayerRequest (const AttachandAnimateLayerRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _layerID (0u),
    _surfaceID (),
    _animationType (0u),
    _hint (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AttachandAnimateLayerRequest::AttachandAnimateLayerRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 layerID_, const ::std::vector< uint32 >& surfaceID_, uint32 animationType_, uint32 hint_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _layerID (layerID_),
    _surfaceID (surfaceID_),
    _animationType (animationType_),
    _hint (hint_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AttachandAnimateLayerRequest::~AttachandAnimateLayerRequest() {
}

inline AttachandAnimateLayerRequest& AttachandAnimateLayerRequest::operator = (const AttachandAnimateLayerRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasLayerID()) {
            setLayerID(rhs.getLayerID());
        } else {
            clearLayerID();
        }
        if (rhs.hasSurfaceID()) {
            setSurfaceID(rhs.getSurfaceID());
        } else {
            clearSurfaceID();
        }
        if (rhs.hasAnimationType()) {
            setAnimationType(rhs.getAnimationType());
        } else {
            clearAnimationType();
        }
        if (rhs.hasHint()) {
            setHint(rhs.getHint());
        } else {
            clearHint();
        }
    }
    return *this;
}

inline bool AttachandAnimateLayerRequest::operator == (const AttachandAnimateLayerRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasLayerID() && !rhs.hasLayerID()) || getLayerID() == rhs.getLayerID()) &&
        ((!hasSurfaceID() && !rhs.hasSurfaceID()) || getSurfaceID() == rhs.getSurfaceID()) &&
        ((!hasAnimationType() && !rhs.hasAnimationType()) || getAnimationType() == rhs.getAnimationType()) &&
        ((!hasHint() && !rhs.hasHint()) || getHint() == rhs.getHint()));
}

inline bool AttachandAnimateLayerRequest::operator != (const AttachandAnimateLayerRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AttachandAnimateLayerRequest::operator < (const AttachandAnimateLayerRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasLayerID() || rhs.hasLayerID()) {
        if (getLayerID() < rhs.getLayerID()) return true;
        if (getLayerID() > rhs.getLayerID()) return false;
    }
    if (hasSurfaceID() || rhs.hasSurfaceID()) {
        if (getSurfaceID() < rhs.getSurfaceID()) return true;
        if (getSurfaceID() > rhs.getSurfaceID()) return false;
    }
    if (hasAnimationType() || rhs.hasAnimationType()) {
        if (getAnimationType() < rhs.getAnimationType()) return true;
        if (getAnimationType() > rhs.getAnimationType()) return false;
    }
    if (hasHint() || rhs.hasHint()) {
        if (getHint() < rhs.getHint()) return true;
        if (getHint() > rhs.getHint()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AttachandAnimateLayerRequest::clone() {
    return new AttachandAnimateLayerRequest(*this);
}

inline bool AttachandAnimateLayerRequest::operator > (const AttachandAnimateLayerRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AttachandAnimateLayerRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearLayerID();
    clearSurfaceID();
    clearAnimationType();
    clearHint();
}

inline void AttachandAnimateLayerRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool AttachandAnimateLayerRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AttachandAnimateLayerRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& AttachandAnimateLayerRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void AttachandAnimateLayerRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void AttachandAnimateLayerRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void AttachandAnimateLayerRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void AttachandAnimateLayerRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool AttachandAnimateLayerRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& AttachandAnimateLayerRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& AttachandAnimateLayerRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void AttachandAnimateLayerRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void AttachandAnimateLayerRequest::clearLayerID() {
    if (hasLayerID()) {
         clear_has_layerID();
        _layerID = 0u;
     }
}

inline bool AttachandAnimateLayerRequest::hasLayerID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 AttachandAnimateLayerRequest::getLayerID () const {
    return _layerID;
}

inline void AttachandAnimateLayerRequest::setLayerID (uint32 layerID_) {
    set_has_layerID();
    this->_layerID = layerID_;
}

inline void AttachandAnimateLayerRequest::clearSurfaceID() {
    if (hasSurfaceID()) {
         clear_has_surfaceID();
        _surfaceID.clear();
     }
}

inline bool AttachandAnimateLayerRequest::hasSurfaceID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint32 >& AttachandAnimateLayerRequest::getSurfaceID () const {
    return _surfaceID;
}

inline ::std::vector< uint32 >& AttachandAnimateLayerRequest::getSurfaceIDMutable () {
    set_has_surfaceID();
    return _surfaceID;
}

inline void AttachandAnimateLayerRequest::setSurfaceID (const ::std::vector< uint32 >& surfaceID_) {
    set_has_surfaceID();
    this->_surfaceID = surfaceID_;
}

inline void AttachandAnimateLayerRequest::clearAnimationType() {
    if (hasAnimationType()) {
         clear_has_animationType();
        _animationType = 0u;
     }
}

inline bool AttachandAnimateLayerRequest::hasAnimationType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 AttachandAnimateLayerRequest::getAnimationType () const {
    return _animationType;
}

inline void AttachandAnimateLayerRequest::setAnimationType (uint32 animationType_) {
    set_has_animationType();
    this->_animationType = animationType_;
}

inline void AttachandAnimateLayerRequest::clearHint() {
    if (hasHint()) {
         clear_has_hint();
        _hint = 0u;
     }
}

inline bool AttachandAnimateLayerRequest::hasHint () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 AttachandAnimateLayerRequest::getHint () const {
    return _hint;
}

inline void AttachandAnimateLayerRequest::setHint (uint32 hint_) {
    set_has_hint();
    this->_hint = hint_;
}

inline void AttachandAnimateLayerRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AttachandAnimateLayerRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AttachandAnimateLayerRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void AttachandAnimateLayerRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AttachandAnimateLayerRequest::set_has_layerID () {
    _has_bits_[0] |= 1u << 2;
}

inline void AttachandAnimateLayerRequest::clear_has_layerID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AttachandAnimateLayerRequest::set_has_surfaceID () {
    _has_bits_[0] |= 1u << 3;
}

inline void AttachandAnimateLayerRequest::clear_has_surfaceID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AttachandAnimateLayerRequest::set_has_animationType () {
    _has_bits_[0] |= 1u << 4;
}

inline void AttachandAnimateLayerRequest::clear_has_animationType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void AttachandAnimateLayerRequest::set_has_hint () {
    _has_bits_[0] |= 1u << 5;
}

inline void AttachandAnimateLayerRequest::clear_has_hint () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  ShowPopupRequest::ShowPopupRequest ()  :
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _popupPresentationArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ShowPopupRequest::ShowPopupRequest (const ShowPopupRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _surfaceId (0u),
    _popupPresentationArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ShowPopupRequest::ShowPopupRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _surfaceId (surfaceId_),
    _popupPresentationArg (popupPresentationArg_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ShowPopupRequest::~ShowPopupRequest() {
}

inline ShowPopupRequest& ShowPopupRequest::operator = (const ShowPopupRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasPopupPresentationArg()) {
            setPopupPresentationArg(rhs.getPopupPresentationArg());
        } else {
            clearPopupPresentationArg();
        }
    }
    return *this;
}

inline bool ShowPopupRequest::operator == (const ShowPopupRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasPopupPresentationArg() && !rhs.hasPopupPresentationArg()) || getPopupPresentationArg() == rhs.getPopupPresentationArg()));
}

inline bool ShowPopupRequest::operator != (const ShowPopupRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ShowPopupRequest::operator < (const ShowPopupRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasPopupPresentationArg() || rhs.hasPopupPresentationArg()) {
        if (getPopupPresentationArg() < rhs.getPopupPresentationArg()) return true;
        if (getPopupPresentationArg() > rhs.getPopupPresentationArg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ShowPopupRequest::clone() {
    return new ShowPopupRequest(*this);
}

inline bool ShowPopupRequest::operator > (const ShowPopupRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ShowPopupRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearSurfaceId();
    clearPopupPresentationArg();
}

inline void ShowPopupRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool ShowPopupRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ShowPopupRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& ShowPopupRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void ShowPopupRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void ShowPopupRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void ShowPopupRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void ShowPopupRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool ShowPopupRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ShowPopupRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ShowPopupRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void ShowPopupRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void ShowPopupRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool ShowPopupRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ShowPopupRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void ShowPopupRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void ShowPopupRequest::clearPopupPresentationArg() {
    if (hasPopupPresentationArg()) {
         clear_has_popupPresentationArg();
        _popupPresentationArg.clear();
     }
}

inline bool ShowPopupRequest::hasPopupPresentationArg () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& ShowPopupRequest::getPopupPresentationArg () const {
    return _popupPresentationArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& ShowPopupRequest::getPopupPresentationArgMutable () {
    set_has_popupPresentationArg();
    return _popupPresentationArg;
}

inline void ShowPopupRequest::setPopupPresentationArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_) {
    set_has_popupPresentationArg();
    this->_popupPresentationArg = popupPresentationArg_;
}

inline void ShowPopupRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ShowPopupRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ShowPopupRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void ShowPopupRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ShowPopupRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ShowPopupRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ShowPopupRequest::set_has_popupPresentationArg () {
    _has_bits_[0] |= 1u << 3;
}

inline void ShowPopupRequest::clear_has_popupPresentationArg () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  HidePopupRequest::HidePopupRequest ()  :
    _clientId (),
    _requestArg (),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HidePopupRequest::HidePopupRequest (const HidePopupRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _surfaceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HidePopupRequest::HidePopupRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 surfaceId_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _surfaceId (surfaceId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HidePopupRequest::~HidePopupRequest() {
}

inline HidePopupRequest& HidePopupRequest::operator = (const HidePopupRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
    }
    return *this;
}

inline bool HidePopupRequest::operator == (const HidePopupRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()));
}

inline bool HidePopupRequest::operator != (const HidePopupRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool HidePopupRequest::operator < (const HidePopupRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HidePopupRequest::clone() {
    return new HidePopupRequest(*this);
}

inline bool HidePopupRequest::operator > (const HidePopupRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HidePopupRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearSurfaceId();
}

inline void HidePopupRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool HidePopupRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& HidePopupRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& HidePopupRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void HidePopupRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void HidePopupRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void HidePopupRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void HidePopupRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool HidePopupRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& HidePopupRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& HidePopupRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void HidePopupRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void HidePopupRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool HidePopupRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 HidePopupRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void HidePopupRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void HidePopupRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void HidePopupRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void HidePopupRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void HidePopupRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void HidePopupRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void HidePopupRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CloseOnExternalTouchRequest::CloseOnExternalTouchRequest ()  :
    _clientId (),
    _requestArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CloseOnExternalTouchRequest::CloseOnExternalTouchRequest (const CloseOnExternalTouchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CloseOnExternalTouchRequest::CloseOnExternalTouchRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_)  :
    _clientId (clientId_),
    _requestArg (requestArg_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CloseOnExternalTouchRequest::~CloseOnExternalTouchRequest() {
}

inline CloseOnExternalTouchRequest& CloseOnExternalTouchRequest::operator = (const CloseOnExternalTouchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
    }
    return *this;
}

inline bool CloseOnExternalTouchRequest::operator == (const CloseOnExternalTouchRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()));
}

inline bool CloseOnExternalTouchRequest::operator != (const CloseOnExternalTouchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CloseOnExternalTouchRequest::operator < (const CloseOnExternalTouchRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CloseOnExternalTouchRequest::clone() {
    return new CloseOnExternalTouchRequest(*this);
}

inline bool CloseOnExternalTouchRequest::operator > (const CloseOnExternalTouchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CloseOnExternalTouchRequest::clear() {
    clearClientId();
    clearRequestArg();
}

inline void CloseOnExternalTouchRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool CloseOnExternalTouchRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CloseOnExternalTouchRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& CloseOnExternalTouchRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void CloseOnExternalTouchRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void CloseOnExternalTouchRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void CloseOnExternalTouchRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void CloseOnExternalTouchRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool CloseOnExternalTouchRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& CloseOnExternalTouchRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& CloseOnExternalTouchRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void CloseOnExternalTouchRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void CloseOnExternalTouchRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CloseOnExternalTouchRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CloseOnExternalTouchRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void CloseOnExternalTouchRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetPopupFilterRequest::SetPopupFilterRequest ()  :
    _clientId (),
    _requestArg (),
    _disableAll (false),
    _popupPresentationArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPopupFilterRequest::SetPopupFilterRequest (const SetPopupFilterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _disableAll (false),
    _popupPresentationArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPopupFilterRequest::SetPopupFilterRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, bool disableAll_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _disableAll (disableAll_),
    _popupPresentationArg (popupPresentationArg_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPopupFilterRequest::~SetPopupFilterRequest() {
}

inline SetPopupFilterRequest& SetPopupFilterRequest::operator = (const SetPopupFilterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasDisableAll()) {
            setDisableAll(rhs.getDisableAll());
        } else {
            clearDisableAll();
        }
        if (rhs.hasPopupPresentationArg()) {
            setPopupPresentationArg(rhs.getPopupPresentationArg());
        } else {
            clearPopupPresentationArg();
        }
    }
    return *this;
}

inline bool SetPopupFilterRequest::operator == (const SetPopupFilterRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasDisableAll() && !rhs.hasDisableAll()) || getDisableAll() == rhs.getDisableAll()) &&
        ((!hasPopupPresentationArg() && !rhs.hasPopupPresentationArg()) || getPopupPresentationArg() == rhs.getPopupPresentationArg()));
}

inline bool SetPopupFilterRequest::operator != (const SetPopupFilterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPopupFilterRequest::operator < (const SetPopupFilterRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasDisableAll() || rhs.hasDisableAll()) {
        if (getDisableAll() < rhs.getDisableAll()) return true;
        if (getDisableAll() > rhs.getDisableAll()) return false;
    }
    if (hasPopupPresentationArg() || rhs.hasPopupPresentationArg()) {
        if (getPopupPresentationArg() < rhs.getPopupPresentationArg()) return true;
        if (getPopupPresentationArg() > rhs.getPopupPresentationArg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPopupFilterRequest::clone() {
    return new SetPopupFilterRequest(*this);
}

inline bool SetPopupFilterRequest::operator > (const SetPopupFilterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPopupFilterRequest::clear() {
    clearClientId();
    clearRequestArg();
    clearDisableAll();
    clearPopupPresentationArg();
}

inline void SetPopupFilterRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool SetPopupFilterRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPopupFilterRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& SetPopupFilterRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void SetPopupFilterRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void SetPopupFilterRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void SetPopupFilterRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void SetPopupFilterRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool SetPopupFilterRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& SetPopupFilterRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& SetPopupFilterRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void SetPopupFilterRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void SetPopupFilterRequest::clearDisableAll() {
    if (hasDisableAll()) {
         clear_has_disableAll();
        _disableAll = false;
     }
}

inline bool SetPopupFilterRequest::hasDisableAll () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetPopupFilterRequest::getDisableAll () const {
    return _disableAll;
}

inline void SetPopupFilterRequest::setDisableAll (bool disableAll_) {
    set_has_disableAll();
    this->_disableAll = disableAll_;
}

inline void SetPopupFilterRequest::clearPopupPresentationArg() {
    if (hasPopupPresentationArg()) {
         clear_has_popupPresentationArg();
        _popupPresentationArg.clear();
     }
}

inline bool SetPopupFilterRequest::hasPopupPresentationArg () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& SetPopupFilterRequest::getPopupPresentationArg () const {
    return _popupPresentationArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& SetPopupFilterRequest::getPopupPresentationArgMutable () {
    set_has_popupPresentationArg();
    return _popupPresentationArg;
}

inline void SetPopupFilterRequest::setPopupPresentationArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg_) {
    set_has_popupPresentationArg();
    this->_popupPresentationArg = popupPresentationArg_;
}

inline void SetPopupFilterRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPopupFilterRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPopupFilterRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPopupFilterRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetPopupFilterRequest::set_has_disableAll () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetPopupFilterRequest::clear_has_disableAll () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetPopupFilterRequest::set_has_popupPresentationArg () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetPopupFilterRequest::clear_has_popupPresentationArg () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ClearPopupFilterRequest::ClearPopupFilterRequest ()  :
    _clientId (),
    _requestArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearPopupFilterRequest::ClearPopupFilterRequest (const ClearPopupFilterRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearPopupFilterRequest::ClearPopupFilterRequest (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_)  :
    _clientId (clientId_),
    _requestArg (requestArg_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearPopupFilterRequest::~ClearPopupFilterRequest() {
}

inline ClearPopupFilterRequest& ClearPopupFilterRequest::operator = (const ClearPopupFilterRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
    }
    return *this;
}

inline bool ClearPopupFilterRequest::operator == (const ClearPopupFilterRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()));
}

inline bool ClearPopupFilterRequest::operator != (const ClearPopupFilterRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearPopupFilterRequest::operator < (const ClearPopupFilterRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearPopupFilterRequest::clone() {
    return new ClearPopupFilterRequest(*this);
}

inline bool ClearPopupFilterRequest::operator > (const ClearPopupFilterRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearPopupFilterRequest::clear() {
    clearClientId();
    clearRequestArg();
}

inline void ClearPopupFilterRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool ClearPopupFilterRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ClearPopupFilterRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& ClearPopupFilterRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void ClearPopupFilterRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void ClearPopupFilterRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void ClearPopupFilterRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void ClearPopupFilterRequest::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool ClearPopupFilterRequest::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ClearPopupFilterRequest::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& ClearPopupFilterRequest::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void ClearPopupFilterRequest::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void ClearPopupFilterRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearPopupFilterRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ClearPopupFilterRequest::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void ClearPopupFilterRequest::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  KeyFeedbackRequest::KeyFeedbackRequest ()  :
    _clientId (),
    _userData (0u),
    _keyCode (0u),
    _keyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release),
    _consumed (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyFeedbackRequest::KeyFeedbackRequest (const KeyFeedbackRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _userData (0u),
    _keyCode (0u),
    _keyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release),
    _consumed (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyFeedbackRequest::KeyFeedbackRequest (const ::std::string& clientId_, uint32 userData_, uint32 keyCode_, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_, bool consumed_)  :
    _clientId (clientId_),
    _userData (userData_),
    _keyCode (keyCode_),
    _keyState (keyState_),
    _consumed (consumed_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::KeyState_IsValid(keyState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", keyState_, "KeyState", "keyState", "KeyFeedbackRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyFeedbackRequest::~KeyFeedbackRequest() {
}

inline KeyFeedbackRequest& KeyFeedbackRequest::operator = (const KeyFeedbackRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
        if (rhs.hasKeyCode()) {
            setKeyCode(rhs.getKeyCode());
        } else {
            clearKeyCode();
        }
        if (rhs.hasKeyState()) {
            setKeyState(rhs.getKeyState());
        } else {
            clearKeyState();
        }
        if (rhs.hasConsumed()) {
            setConsumed(rhs.getConsumed());
        } else {
            clearConsumed();
        }
    }
    return *this;
}

inline bool KeyFeedbackRequest::operator == (const KeyFeedbackRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()) &&
        ((!hasKeyCode() && !rhs.hasKeyCode()) || getKeyCode() == rhs.getKeyCode()) &&
        ((!hasKeyState() && !rhs.hasKeyState()) || getKeyState() == rhs.getKeyState()) &&
        ((!hasConsumed() && !rhs.hasConsumed()) || getConsumed() == rhs.getConsumed()));
}

inline bool KeyFeedbackRequest::operator != (const KeyFeedbackRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyFeedbackRequest::operator < (const KeyFeedbackRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    if (hasKeyCode() || rhs.hasKeyCode()) {
        if (getKeyCode() < rhs.getKeyCode()) return true;
        if (getKeyCode() > rhs.getKeyCode()) return false;
    }
    if (hasKeyState() || rhs.hasKeyState()) {
        if ((uint32)getKeyState() < (uint32)rhs.getKeyState()) return true;
        if ((uint32)getKeyState() > (uint32)rhs.getKeyState()) return false;
    }
    if (hasConsumed() || rhs.hasConsumed()) {
        if (getConsumed() < rhs.getConsumed()) return true;
        if (getConsumed() > rhs.getConsumed()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyFeedbackRequest::clone() {
    return new KeyFeedbackRequest(*this);
}

inline bool KeyFeedbackRequest::operator > (const KeyFeedbackRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyFeedbackRequest::clear() {
    clearClientId();
    clearUserData();
    clearKeyCode();
    clearKeyState();
    clearConsumed();
}

inline void KeyFeedbackRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool KeyFeedbackRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& KeyFeedbackRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& KeyFeedbackRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void KeyFeedbackRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void KeyFeedbackRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void KeyFeedbackRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void KeyFeedbackRequest::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool KeyFeedbackRequest::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 KeyFeedbackRequest::getUserData () const {
    return _userData;
}

inline void KeyFeedbackRequest::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void KeyFeedbackRequest::clearKeyCode() {
    if (hasKeyCode()) {
         clear_has_keyCode();
        _keyCode = 0u;
     }
}

inline bool KeyFeedbackRequest::hasKeyCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 KeyFeedbackRequest::getKeyCode () const {
    return _keyCode;
}

inline void KeyFeedbackRequest::setKeyCode (uint32 keyCode_) {
    set_has_keyCode();
    this->_keyCode = keyCode_;
}

inline void KeyFeedbackRequest::clearKeyState() {
    if (hasKeyState()) {
         clear_has_keyState();
        _keyState = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release;
     }
}

inline bool KeyFeedbackRequest::hasKeyState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::KeyState KeyFeedbackRequest::getKeyState () const {
    return _keyState;
}

inline void KeyFeedbackRequest::setKeyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::KeyState_IsValid(keyState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", keyState_, "KeyState", "keyState", "KeyFeedbackRequest");
    }
    set_has_keyState();
    this->_keyState = keyState_;
}

inline void KeyFeedbackRequest::clearConsumed() {
    if (hasConsumed()) {
         clear_has_consumed();
        _consumed = false;
     }
}

inline bool KeyFeedbackRequest::hasConsumed () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool KeyFeedbackRequest::getConsumed () const {
    return _consumed;
}

inline void KeyFeedbackRequest::setConsumed (bool consumed_) {
    set_has_consumed();
    this->_consumed = consumed_;
}

inline void KeyFeedbackRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyFeedbackRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void KeyFeedbackRequest::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void KeyFeedbackRequest::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void KeyFeedbackRequest::set_has_keyCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void KeyFeedbackRequest::clear_has_keyCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void KeyFeedbackRequest::set_has_keyState () {
    _has_bits_[0] |= 1u << 3;
}

inline void KeyFeedbackRequest::clear_has_keyState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void KeyFeedbackRequest::set_has_consumed () {
    _has_bits_[0] |= 1u << 4;
}

inline void KeyFeedbackRequest::clear_has_consumed () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ActionRequest::ActionRequest ()  :
    _clientId (),
    _actionId (0u),
    _actionData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActionRequest::ActionRequest (const ActionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _actionId (0u),
    _actionData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActionRequest::ActionRequest (const ::std::string& clientId_, uint32 actionId_, uint32 actionData_)  :
    _clientId (clientId_),
    _actionId (actionId_),
    _actionData (actionData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActionRequest::~ActionRequest() {
}

inline ActionRequest& ActionRequest::operator = (const ActionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasActionId()) {
            setActionId(rhs.getActionId());
        } else {
            clearActionId();
        }
        if (rhs.hasActionData()) {
            setActionData(rhs.getActionData());
        } else {
            clearActionData();
        }
    }
    return *this;
}

inline bool ActionRequest::operator == (const ActionRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasActionId() && !rhs.hasActionId()) || getActionId() == rhs.getActionId()) &&
        ((!hasActionData() && !rhs.hasActionData()) || getActionData() == rhs.getActionData()));
}

inline bool ActionRequest::operator != (const ActionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ActionRequest::operator < (const ActionRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasActionId() || rhs.hasActionId()) {
        if (getActionId() < rhs.getActionId()) return true;
        if (getActionId() > rhs.getActionId()) return false;
    }
    if (hasActionData() || rhs.hasActionData()) {
        if (getActionData() < rhs.getActionData()) return true;
        if (getActionData() > rhs.getActionData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActionRequest::clone() {
    return new ActionRequest(*this);
}

inline bool ActionRequest::operator > (const ActionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActionRequest::clear() {
    clearClientId();
    clearActionId();
    clearActionData();
}

inline void ActionRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool ActionRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActionRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& ActionRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void ActionRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void ActionRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void ActionRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void ActionRequest::clearActionId() {
    if (hasActionId()) {
         clear_has_actionId();
        _actionId = 0u;
     }
}

inline bool ActionRequest::hasActionId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ActionRequest::getActionId () const {
    return _actionId;
}

inline void ActionRequest::setActionId (uint32 actionId_) {
    set_has_actionId();
    this->_actionId = actionId_;
}

inline void ActionRequest::clearActionData() {
    if (hasActionData()) {
         clear_has_actionData();
        _actionData = 0u;
     }
}

inline bool ActionRequest::hasActionData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ActionRequest::getActionData () const {
    return _actionData;
}

inline void ActionRequest::setActionData (uint32 actionData_) {
    set_has_actionData();
    this->_actionData = actionData_;
}

inline void ActionRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActionRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActionRequest::set_has_actionId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActionRequest::clear_has_actionId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ActionRequest::set_has_actionData () {
    _has_bits_[0] |= 1u << 2;
}

inline void ActionRequest::clear_has_actionData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetInputFocusRequest::SetInputFocusRequest ()  :
    _clientId (),
    _surfaceId (0u),
    _keyboardFocus (false),
    _pointerFocus (false),
    _priority (0),
    _focusData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetInputFocusRequest::SetInputFocusRequest (const SetInputFocusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _surfaceId (0u),
    _keyboardFocus (false),
    _pointerFocus (false),
    _priority (0),
    _focusData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetInputFocusRequest::SetInputFocusRequest (const ::std::string& clientId_, uint32 surfaceId_, bool keyboardFocus_, bool pointerFocus_, int32 priority_, uint32 focusData_)  :
    _clientId (clientId_),
    _surfaceId (surfaceId_),
    _keyboardFocus (keyboardFocus_),
    _pointerFocus (pointerFocus_),
    _priority (priority_),
    _focusData (focusData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetInputFocusRequest::~SetInputFocusRequest() {
}

inline SetInputFocusRequest& SetInputFocusRequest::operator = (const SetInputFocusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasKeyboardFocus()) {
            setKeyboardFocus(rhs.getKeyboardFocus());
        } else {
            clearKeyboardFocus();
        }
        if (rhs.hasPointerFocus()) {
            setPointerFocus(rhs.getPointerFocus());
        } else {
            clearPointerFocus();
        }
        if (rhs.hasPriority()) {
            setPriority(rhs.getPriority());
        } else {
            clearPriority();
        }
        if (rhs.hasFocusData()) {
            setFocusData(rhs.getFocusData());
        } else {
            clearFocusData();
        }
    }
    return *this;
}

inline bool SetInputFocusRequest::operator == (const SetInputFocusRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasKeyboardFocus() && !rhs.hasKeyboardFocus()) || getKeyboardFocus() == rhs.getKeyboardFocus()) &&
        ((!hasPointerFocus() && !rhs.hasPointerFocus()) || getPointerFocus() == rhs.getPointerFocus()) &&
        ((!hasPriority() && !rhs.hasPriority()) || getPriority() == rhs.getPriority()) &&
        ((!hasFocusData() && !rhs.hasFocusData()) || getFocusData() == rhs.getFocusData()));
}

inline bool SetInputFocusRequest::operator != (const SetInputFocusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetInputFocusRequest::operator < (const SetInputFocusRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasKeyboardFocus() || rhs.hasKeyboardFocus()) {
        if (getKeyboardFocus() < rhs.getKeyboardFocus()) return true;
        if (getKeyboardFocus() > rhs.getKeyboardFocus()) return false;
    }
    if (hasPointerFocus() || rhs.hasPointerFocus()) {
        if (getPointerFocus() < rhs.getPointerFocus()) return true;
        if (getPointerFocus() > rhs.getPointerFocus()) return false;
    }
    if (hasPriority() || rhs.hasPriority()) {
        if (getPriority() < rhs.getPriority()) return true;
        if (getPriority() > rhs.getPriority()) return false;
    }
    if (hasFocusData() || rhs.hasFocusData()) {
        if (getFocusData() < rhs.getFocusData()) return true;
        if (getFocusData() > rhs.getFocusData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetInputFocusRequest::clone() {
    return new SetInputFocusRequest(*this);
}

inline bool SetInputFocusRequest::operator > (const SetInputFocusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetInputFocusRequest::clear() {
    clearClientId();
    clearSurfaceId();
    clearKeyboardFocus();
    clearPointerFocus();
    clearPriority();
    clearFocusData();
}

inline void SetInputFocusRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool SetInputFocusRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetInputFocusRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& SetInputFocusRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void SetInputFocusRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void SetInputFocusRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void SetInputFocusRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void SetInputFocusRequest::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool SetInputFocusRequest::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SetInputFocusRequest::getSurfaceId () const {
    return _surfaceId;
}

inline void SetInputFocusRequest::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void SetInputFocusRequest::clearKeyboardFocus() {
    if (hasKeyboardFocus()) {
         clear_has_keyboardFocus();
        _keyboardFocus = false;
     }
}

inline bool SetInputFocusRequest::hasKeyboardFocus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetInputFocusRequest::getKeyboardFocus () const {
    return _keyboardFocus;
}

inline void SetInputFocusRequest::setKeyboardFocus (bool keyboardFocus_) {
    set_has_keyboardFocus();
    this->_keyboardFocus = keyboardFocus_;
}

inline void SetInputFocusRequest::clearPointerFocus() {
    if (hasPointerFocus()) {
         clear_has_pointerFocus();
        _pointerFocus = false;
     }
}

inline bool SetInputFocusRequest::hasPointerFocus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool SetInputFocusRequest::getPointerFocus () const {
    return _pointerFocus;
}

inline void SetInputFocusRequest::setPointerFocus (bool pointerFocus_) {
    set_has_pointerFocus();
    this->_pointerFocus = pointerFocus_;
}

inline void SetInputFocusRequest::clearPriority() {
    if (hasPriority()) {
         clear_has_priority();
        _priority = 0;
     }
}

inline bool SetInputFocusRequest::hasPriority () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 SetInputFocusRequest::getPriority () const {
    return _priority;
}

inline void SetInputFocusRequest::setPriority (int32 priority_) {
    set_has_priority();
    this->_priority = priority_;
}

inline void SetInputFocusRequest::clearFocusData() {
    if (hasFocusData()) {
         clear_has_focusData();
        _focusData = 0u;
     }
}

inline bool SetInputFocusRequest::hasFocusData () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 SetInputFocusRequest::getFocusData () const {
    return _focusData;
}

inline void SetInputFocusRequest::setFocusData (uint32 focusData_) {
    set_has_focusData();
    this->_focusData = focusData_;
}

inline void SetInputFocusRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetInputFocusRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetInputFocusRequest::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetInputFocusRequest::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetInputFocusRequest::set_has_keyboardFocus () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetInputFocusRequest::clear_has_keyboardFocus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetInputFocusRequest::set_has_pointerFocus () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetInputFocusRequest::clear_has_pointerFocus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SetInputFocusRequest::set_has_priority () {
    _has_bits_[0] |= 1u << 4;
}

inline void SetInputFocusRequest::clear_has_priority () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void SetInputFocusRequest::set_has_focusData () {
    _has_bits_[0] |= 1u << 5;
}

inline void SetInputFocusRequest::clear_has_focusData () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  RequestCurrentStatusRequest::RequestCurrentStatusRequest ()  :
    _clientId (),
    _requestId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestCurrentStatusRequest::RequestCurrentStatusRequest (const RequestCurrentStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestCurrentStatusRequest::RequestCurrentStatusRequest (const ::std::string& clientId_, uint32 requestId_)  :
    _clientId (clientId_),
    _requestId (requestId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestCurrentStatusRequest::~RequestCurrentStatusRequest() {
}

inline RequestCurrentStatusRequest& RequestCurrentStatusRequest::operator = (const RequestCurrentStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
    }
    return *this;
}

inline bool RequestCurrentStatusRequest::operator == (const RequestCurrentStatusRequest& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()));
}

inline bool RequestCurrentStatusRequest::operator != (const RequestCurrentStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestCurrentStatusRequest::operator < (const RequestCurrentStatusRequest& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestCurrentStatusRequest::clone() {
    return new RequestCurrentStatusRequest(*this);
}

inline bool RequestCurrentStatusRequest::operator > (const RequestCurrentStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestCurrentStatusRequest::clear() {
    clearClientId();
    clearRequestId();
}

inline void RequestCurrentStatusRequest::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool RequestCurrentStatusRequest::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestCurrentStatusRequest::getClientId () const {
    return _clientId;
}

inline ::std::string& RequestCurrentStatusRequest::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void RequestCurrentStatusRequest::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void RequestCurrentStatusRequest::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void RequestCurrentStatusRequest::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void RequestCurrentStatusRequest::clearRequestId() {
    if (hasRequestId()) {
         clear_has_requestId();
        _requestId = 0u;
     }
}

inline bool RequestCurrentStatusRequest::hasRequestId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestCurrentStatusRequest::getRequestId () const {
    return _requestId;
}

inline void RequestCurrentStatusRequest::setRequestId (uint32 requestId_) {
    set_has_requestId();
    this->_requestId = requestId_;
}

inline void RequestCurrentStatusRequest::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestCurrentStatusRequest::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestCurrentStatusRequest::set_has_requestId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestCurrentStatusRequest::clear_has_requestId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  VersionUpdate::VersionUpdate ()  :
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionUpdate::VersionUpdate (const VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionUpdate::VersionUpdate (const ::std::string& Version_)  :
    _Version (Version_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VersionUpdate::~VersionUpdate() {
}

inline VersionUpdate& VersionUpdate::operator = (const VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool VersionUpdate::operator == (const VersionUpdate& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool VersionUpdate::operator != (const VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionUpdate::operator < (const VersionUpdate& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VersionUpdate::clone() {
    return new VersionUpdate(*this);
}

inline bool VersionUpdate::operator > (const VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionUpdate::clear() {
    clearVersion();
}

inline void VersionUpdate::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version.clear();
     }
}

inline bool VersionUpdate::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& VersionUpdate::getVersion () const {
    return _Version;
}

inline ::std::string& VersionUpdate::getVersionMutable () {
    set_has_Version();
    return _Version;
}

inline void VersionUpdate::setVersion (const ::std::string& Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version = Version_;
}

inline void VersionUpdate::setVersion (const char* Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version.assign(Version_);
}

inline void VersionUpdate::setVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Version();
    this->_Version.assign(value, size);
}

inline void VersionUpdate::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void VersionUpdate::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VersionRegister::VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionRegister::VersionRegister (const VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionRegister::~VersionRegister() {
}

inline VersionRegister& VersionRegister::operator = (const VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VersionRegister::operator == (const VersionRegister& ) const {
    return true;
}

inline bool VersionRegister::operator != (const VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionRegister::operator < (const VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VersionRegister::clone() {
    return new VersionRegister(*this);
}

inline bool VersionRegister::operator > (const VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionRegister::clear() {
}

inline  BuildInLayersUpdate::BuildInLayersUpdate ()  :
    _BuildInLayers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInLayersUpdate::BuildInLayersUpdate (const BuildInLayersUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BuildInLayers ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInLayersUpdate::BuildInLayersUpdate (const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayers_)  :
    _BuildInLayers (BuildInLayers_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInLayersUpdate::~BuildInLayersUpdate() {
}

inline BuildInLayersUpdate& BuildInLayersUpdate::operator = (const BuildInLayersUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBuildInLayers()) {
            setBuildInLayers(rhs.getBuildInLayers());
        } else {
            clearBuildInLayers();
        }
    }
    return *this;
}

inline bool BuildInLayersUpdate::operator == (const BuildInLayersUpdate& rhs) const {
    return (((!hasBuildInLayers() && !rhs.hasBuildInLayers()) || getBuildInLayers() == rhs.getBuildInLayers()));
}

inline bool BuildInLayersUpdate::operator != (const BuildInLayersUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInLayersUpdate::operator < (const BuildInLayersUpdate& rhs) const {
    if (hasBuildInLayers() || rhs.hasBuildInLayers()) {
        if (getBuildInLayers() < rhs.getBuildInLayers()) return true;
        if (getBuildInLayers() > rhs.getBuildInLayers()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BuildInLayersUpdate::clone() {
    return new BuildInLayersUpdate(*this);
}

inline bool BuildInLayersUpdate::operator > (const BuildInLayersUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInLayersUpdate::clear() {
    clearBuildInLayers();
}

inline void BuildInLayersUpdate::clearBuildInLayers() {
    if (hasBuildInLayers()) {
         clear_has_BuildInLayers();
        _BuildInLayers.clear();
     }
}

inline bool BuildInLayersUpdate::hasBuildInLayers () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayersUpdate::getBuildInLayers () const {
    return _BuildInLayers;
}

inline ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayersUpdate::getBuildInLayersMutable () {
    set_has_BuildInLayers();
    return _BuildInLayers;
}

inline void BuildInLayersUpdate::setBuildInLayers (const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& BuildInLayers_) {
    set_has_BuildInLayers();
    this->_BuildInLayers = BuildInLayers_;
}

inline void BuildInLayersUpdate::set_has_BuildInLayers () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInLayersUpdate::clear_has_BuildInLayers () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BuildInLayersRegister::BuildInLayersRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInLayersRegister::BuildInLayersRegister (const BuildInLayersRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInLayersRegister::~BuildInLayersRegister() {
}

inline BuildInLayersRegister& BuildInLayersRegister::operator = (const BuildInLayersRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BuildInLayersRegister::operator == (const BuildInLayersRegister& ) const {
    return true;
}

inline bool BuildInLayersRegister::operator != (const BuildInLayersRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInLayersRegister::operator < (const BuildInLayersRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BuildInLayersRegister::clone() {
    return new BuildInLayersRegister(*this);
}

inline bool BuildInLayersRegister::operator > (const BuildInLayersRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInLayersRegister::clear() {
}

inline  OnGetDisplayIdSignal::OnGetDisplayIdSignal ()  :
    _clientId (),
    _requestArg (),
    _displayId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnGetDisplayIdSignal::OnGetDisplayIdSignal (const OnGetDisplayIdSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _displayId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnGetDisplayIdSignal::OnGetDisplayIdSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, uint32 displayId_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _displayId (displayId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnGetDisplayIdSignal::~OnGetDisplayIdSignal() {
}

inline OnGetDisplayIdSignal& OnGetDisplayIdSignal::operator = (const OnGetDisplayIdSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasDisplayId()) {
            setDisplayId(rhs.getDisplayId());
        } else {
            clearDisplayId();
        }
    }
    return *this;
}

inline bool OnGetDisplayIdSignal::operator == (const OnGetDisplayIdSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasDisplayId() && !rhs.hasDisplayId()) || getDisplayId() == rhs.getDisplayId()));
}

inline bool OnGetDisplayIdSignal::operator != (const OnGetDisplayIdSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnGetDisplayIdSignal::operator < (const OnGetDisplayIdSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasDisplayId() || rhs.hasDisplayId()) {
        if (getDisplayId() < rhs.getDisplayId()) return true;
        if (getDisplayId() > rhs.getDisplayId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnGetDisplayIdSignal::clone() {
    return new OnGetDisplayIdSignal(*this);
}

inline bool OnGetDisplayIdSignal::operator > (const OnGetDisplayIdSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnGetDisplayIdSignal::clear() {
    clearClientId();
    clearRequestArg();
    clearDisplayId();
}

inline void OnGetDisplayIdSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnGetDisplayIdSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnGetDisplayIdSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnGetDisplayIdSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnGetDisplayIdSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnGetDisplayIdSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnGetDisplayIdSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnGetDisplayIdSignal::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool OnGetDisplayIdSignal::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnGetDisplayIdSignal::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnGetDisplayIdSignal::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void OnGetDisplayIdSignal::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void OnGetDisplayIdSignal::clearDisplayId() {
    if (hasDisplayId()) {
         clear_has_displayId();
        _displayId = 0u;
     }
}

inline bool OnGetDisplayIdSignal::hasDisplayId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 OnGetDisplayIdSignal::getDisplayId () const {
    return _displayId;
}

inline void OnGetDisplayIdSignal::setDisplayId (uint32 displayId_) {
    set_has_displayId();
    this->_displayId = displayId_;
}

inline void OnGetDisplayIdSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnGetDisplayIdSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnGetDisplayIdSignal::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnGetDisplayIdSignal::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnGetDisplayIdSignal::set_has_displayId () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnGetDisplayIdSignal::clear_has_displayId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  OnGetPreferredDimensionsSignal::OnGetPreferredDimensionsSignal ()  :
    _clientId (),
    _requestArg (),
    _dimensionArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnGetPreferredDimensionsSignal::OnGetPreferredDimensionsSignal (const OnGetPreferredDimensionsSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _dimensionArg ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnGetPreferredDimensionsSignal::OnGetPreferredDimensionsSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _dimensionArg (dimensionArg_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnGetPreferredDimensionsSignal::~OnGetPreferredDimensionsSignal() {
}

inline OnGetPreferredDimensionsSignal& OnGetPreferredDimensionsSignal::operator = (const OnGetPreferredDimensionsSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasDimensionArg()) {
            setDimensionArg(rhs.getDimensionArg());
        } else {
            clearDimensionArg();
        }
    }
    return *this;
}

inline bool OnGetPreferredDimensionsSignal::operator == (const OnGetPreferredDimensionsSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasDimensionArg() && !rhs.hasDimensionArg()) || getDimensionArg() == rhs.getDimensionArg()));
}

inline bool OnGetPreferredDimensionsSignal::operator != (const OnGetPreferredDimensionsSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnGetPreferredDimensionsSignal::operator < (const OnGetPreferredDimensionsSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasDimensionArg() || rhs.hasDimensionArg()) {
        if (getDimensionArg() < rhs.getDimensionArg()) return true;
        if (getDimensionArg() > rhs.getDimensionArg()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnGetPreferredDimensionsSignal::clone() {
    return new OnGetPreferredDimensionsSignal(*this);
}

inline bool OnGetPreferredDimensionsSignal::operator > (const OnGetPreferredDimensionsSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnGetPreferredDimensionsSignal::clear() {
    clearClientId();
    clearRequestArg();
    clearDimensionArg();
}

inline void OnGetPreferredDimensionsSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnGetPreferredDimensionsSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnGetPreferredDimensionsSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnGetPreferredDimensionsSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnGetPreferredDimensionsSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnGetPreferredDimensionsSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnGetPreferredDimensionsSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnGetPreferredDimensionsSignal::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool OnGetPreferredDimensionsSignal::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnGetPreferredDimensionsSignal::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnGetPreferredDimensionsSignal::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void OnGetPreferredDimensionsSignal::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void OnGetPreferredDimensionsSignal::clearDimensionArg() {
    if (hasDimensionArg()) {
         clear_has_dimensionArg();
        _dimensionArg.clear();
     }
}

inline bool OnGetPreferredDimensionsSignal::hasDimensionArg () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& OnGetPreferredDimensionsSignal::getDimensionArg () const {
    return _dimensionArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& OnGetPreferredDimensionsSignal::getDimensionArgMutable () {
    set_has_dimensionArg();
    return _dimensionArg;
}

inline void OnGetPreferredDimensionsSignal::setDimensionArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg_) {
    set_has_dimensionArg();
    this->_dimensionArg = dimensionArg_;
}

inline void OnGetPreferredDimensionsSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnGetPreferredDimensionsSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnGetPreferredDimensionsSignal::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnGetPreferredDimensionsSignal::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnGetPreferredDimensionsSignal::set_has_dimensionArg () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnGetPreferredDimensionsSignal::clear_has_dimensionArg () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  OnSurfaceStateChangedSignal::OnSurfaceStateChangedSignal ()  :
    _clientId (),
    _userData (0u),
    _surfaceId (0u),
    _displayId (0u),
    _displayAlias (0u),
    _surfaceState (::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState__Registered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnSurfaceStateChangedSignal::OnSurfaceStateChangedSignal (const OnSurfaceStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _userData (0u),
    _surfaceId (0u),
    _displayId (0u),
    _displayAlias (0u),
    _surfaceState (::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState__Registered)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnSurfaceStateChangedSignal::OnSurfaceStateChangedSignal (const ::std::string& clientId_, uint32 userData_, uint32 surfaceId_, uint32 displayId_, uint32 displayAlias_, ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState_)  :
    _clientId (clientId_),
    _userData (userData_),
    _surfaceId (surfaceId_),
    _displayId (displayId_),
    _displayAlias (displayAlias_),
    _surfaceState (surfaceState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState_IsValid(surfaceState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", surfaceState_, "SurfaceState", "surfaceState", "OnSurfaceStateChangedSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnSurfaceStateChangedSignal::~OnSurfaceStateChangedSignal() {
}

inline OnSurfaceStateChangedSignal& OnSurfaceStateChangedSignal::operator = (const OnSurfaceStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasDisplayId()) {
            setDisplayId(rhs.getDisplayId());
        } else {
            clearDisplayId();
        }
        if (rhs.hasDisplayAlias()) {
            setDisplayAlias(rhs.getDisplayAlias());
        } else {
            clearDisplayAlias();
        }
        if (rhs.hasSurfaceState()) {
            setSurfaceState(rhs.getSurfaceState());
        } else {
            clearSurfaceState();
        }
    }
    return *this;
}

inline bool OnSurfaceStateChangedSignal::operator == (const OnSurfaceStateChangedSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasDisplayId() && !rhs.hasDisplayId()) || getDisplayId() == rhs.getDisplayId()) &&
        ((!hasDisplayAlias() && !rhs.hasDisplayAlias()) || getDisplayAlias() == rhs.getDisplayAlias()) &&
        ((!hasSurfaceState() && !rhs.hasSurfaceState()) || getSurfaceState() == rhs.getSurfaceState()));
}

inline bool OnSurfaceStateChangedSignal::operator != (const OnSurfaceStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnSurfaceStateChangedSignal::operator < (const OnSurfaceStateChangedSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasDisplayId() || rhs.hasDisplayId()) {
        if (getDisplayId() < rhs.getDisplayId()) return true;
        if (getDisplayId() > rhs.getDisplayId()) return false;
    }
    if (hasDisplayAlias() || rhs.hasDisplayAlias()) {
        if (getDisplayAlias() < rhs.getDisplayAlias()) return true;
        if (getDisplayAlias() > rhs.getDisplayAlias()) return false;
    }
    if (hasSurfaceState() || rhs.hasSurfaceState()) {
        if ((uint32)getSurfaceState() < (uint32)rhs.getSurfaceState()) return true;
        if ((uint32)getSurfaceState() > (uint32)rhs.getSurfaceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnSurfaceStateChangedSignal::clone() {
    return new OnSurfaceStateChangedSignal(*this);
}

inline bool OnSurfaceStateChangedSignal::operator > (const OnSurfaceStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnSurfaceStateChangedSignal::clear() {
    clearClientId();
    clearUserData();
    clearSurfaceId();
    clearDisplayId();
    clearDisplayAlias();
    clearSurfaceState();
}

inline void OnSurfaceStateChangedSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnSurfaceStateChangedSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnSurfaceStateChangedSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnSurfaceStateChangedSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnSurfaceStateChangedSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnSurfaceStateChangedSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnSurfaceStateChangedSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnSurfaceStateChangedSignal::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool OnSurfaceStateChangedSignal::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 OnSurfaceStateChangedSignal::getUserData () const {
    return _userData;
}

inline void OnSurfaceStateChangedSignal::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void OnSurfaceStateChangedSignal::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool OnSurfaceStateChangedSignal::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 OnSurfaceStateChangedSignal::getSurfaceId () const {
    return _surfaceId;
}

inline void OnSurfaceStateChangedSignal::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void OnSurfaceStateChangedSignal::clearDisplayId() {
    if (hasDisplayId()) {
         clear_has_displayId();
        _displayId = 0u;
     }
}

inline bool OnSurfaceStateChangedSignal::hasDisplayId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 OnSurfaceStateChangedSignal::getDisplayId () const {
    return _displayId;
}

inline void OnSurfaceStateChangedSignal::setDisplayId (uint32 displayId_) {
    set_has_displayId();
    this->_displayId = displayId_;
}

inline void OnSurfaceStateChangedSignal::clearDisplayAlias() {
    if (hasDisplayAlias()) {
         clear_has_displayAlias();
        _displayAlias = 0u;
     }
}

inline bool OnSurfaceStateChangedSignal::hasDisplayAlias () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 OnSurfaceStateChangedSignal::getDisplayAlias () const {
    return _displayAlias;
}

inline void OnSurfaceStateChangedSignal::setDisplayAlias (uint32 displayAlias_) {
    set_has_displayAlias();
    this->_displayAlias = displayAlias_;
}

inline void OnSurfaceStateChangedSignal::clearSurfaceState() {
    if (hasSurfaceState()) {
         clear_has_surfaceState();
        _surfaceState = ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState__Registered;
     }
}

inline bool OnSurfaceStateChangedSignal::hasSurfaceState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState OnSurfaceStateChangedSignal::getSurfaceState () const {
    return _surfaceState;
}

inline void OnSurfaceStateChangedSignal::setSurfaceState (::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState_IsValid(surfaceState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", surfaceState_, "SurfaceState", "surfaceState", "OnSurfaceStateChangedSignal");
    }
    set_has_surfaceState();
    this->_surfaceState = surfaceState_;
}

inline void OnSurfaceStateChangedSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnSurfaceStateChangedSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnSurfaceStateChangedSignal::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnSurfaceStateChangedSignal::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnSurfaceStateChangedSignal::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnSurfaceStateChangedSignal::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void OnSurfaceStateChangedSignal::set_has_displayId () {
    _has_bits_[0] |= 1u << 3;
}

inline void OnSurfaceStateChangedSignal::clear_has_displayId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void OnSurfaceStateChangedSignal::set_has_displayAlias () {
    _has_bits_[0] |= 1u << 4;
}

inline void OnSurfaceStateChangedSignal::clear_has_displayAlias () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void OnSurfaceStateChangedSignal::set_has_surfaceState () {
    _has_bits_[0] |= 1u << 5;
}

inline void OnSurfaceStateChangedSignal::clear_has_surfaceState () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  OnErrorSignal::OnErrorSignal ()  :
    _clientId (),
    _requestArg (),
    _systemErrno (0),
    _presentationErrno (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnErrorSignal::OnErrorSignal (const OnErrorSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestArg (),
    _systemErrno (0),
    _presentationErrno (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnErrorSignal::OnErrorSignal (const ::std::string& clientId_, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_, int32 systemErrno_, int32 presentationErrno_)  :
    _clientId (clientId_),
    _requestArg (requestArg_),
    _systemErrno (systemErrno_),
    _presentationErrno (presentationErrno_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnErrorSignal::~OnErrorSignal() {
}

inline OnErrorSignal& OnErrorSignal::operator = (const OnErrorSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestArg()) {
            setRequestArg(rhs.getRequestArg());
        } else {
            clearRequestArg();
        }
        if (rhs.hasSystemErrno()) {
            setSystemErrno(rhs.getSystemErrno());
        } else {
            clearSystemErrno();
        }
        if (rhs.hasPresentationErrno()) {
            setPresentationErrno(rhs.getPresentationErrno());
        } else {
            clearPresentationErrno();
        }
    }
    return *this;
}

inline bool OnErrorSignal::operator == (const OnErrorSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestArg() && !rhs.hasRequestArg()) || getRequestArg() == rhs.getRequestArg()) &&
        ((!hasSystemErrno() && !rhs.hasSystemErrno()) || getSystemErrno() == rhs.getSystemErrno()) &&
        ((!hasPresentationErrno() && !rhs.hasPresentationErrno()) || getPresentationErrno() == rhs.getPresentationErrno()));
}

inline bool OnErrorSignal::operator != (const OnErrorSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnErrorSignal::operator < (const OnErrorSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestArg() || rhs.hasRequestArg()) {
        if (getRequestArg() < rhs.getRequestArg()) return true;
        if (getRequestArg() > rhs.getRequestArg()) return false;
    }
    if (hasSystemErrno() || rhs.hasSystemErrno()) {
        if (getSystemErrno() < rhs.getSystemErrno()) return true;
        if (getSystemErrno() > rhs.getSystemErrno()) return false;
    }
    if (hasPresentationErrno() || rhs.hasPresentationErrno()) {
        if (getPresentationErrno() < rhs.getPresentationErrno()) return true;
        if (getPresentationErrno() > rhs.getPresentationErrno()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnErrorSignal::clone() {
    return new OnErrorSignal(*this);
}

inline bool OnErrorSignal::operator > (const OnErrorSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnErrorSignal::clear() {
    clearClientId();
    clearRequestArg();
    clearSystemErrno();
    clearPresentationErrno();
}

inline void OnErrorSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnErrorSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnErrorSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnErrorSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnErrorSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnErrorSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnErrorSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnErrorSignal::clearRequestArg() {
    if (hasRequestArg()) {
         clear_has_requestArg();
        _requestArg.clear();
     }
}

inline bool OnErrorSignal::hasRequestArg () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnErrorSignal::getRequestArg () const {
    return _requestArg;
}

inline ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& OnErrorSignal::getRequestArgMutable () {
    set_has_requestArg();
    return _requestArg;
}

inline void OnErrorSignal::setRequestArg (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg_) {
    set_has_requestArg();
    this->_requestArg = requestArg_;
}

inline void OnErrorSignal::clearSystemErrno() {
    if (hasSystemErrno()) {
         clear_has_systemErrno();
        _systemErrno = 0;
     }
}

inline bool OnErrorSignal::hasSystemErrno () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 OnErrorSignal::getSystemErrno () const {
    return _systemErrno;
}

inline void OnErrorSignal::setSystemErrno (int32 systemErrno_) {
    set_has_systemErrno();
    this->_systemErrno = systemErrno_;
}

inline void OnErrorSignal::clearPresentationErrno() {
    if (hasPresentationErrno()) {
         clear_has_presentationErrno();
        _presentationErrno = 0;
     }
}

inline bool OnErrorSignal::hasPresentationErrno () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 OnErrorSignal::getPresentationErrno () const {
    return _presentationErrno;
}

inline void OnErrorSignal::setPresentationErrno (int32 presentationErrno_) {
    set_has_presentationErrno();
    this->_presentationErrno = presentationErrno_;
}

inline void OnErrorSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnErrorSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnErrorSignal::set_has_requestArg () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnErrorSignal::clear_has_requestArg () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnErrorSignal::set_has_systemErrno () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnErrorSignal::clear_has_systemErrno () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void OnErrorSignal::set_has_presentationErrno () {
    _has_bits_[0] |= 1u << 3;
}

inline void OnErrorSignal::clear_has_presentationErrno () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  OnKeyEventSignal::OnKeyEventSignal ()  :
    _clientId (),
    _userData (0u),
    _surfaceId (0u),
    _keyCode (0u),
    _keyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnKeyEventSignal::OnKeyEventSignal (const OnKeyEventSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _userData (0u),
    _surfaceId (0u),
    _keyCode (0u),
    _keyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnKeyEventSignal::OnKeyEventSignal (const ::std::string& clientId_, uint32 userData_, uint32 surfaceId_, uint32 keyCode_, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_)  :
    _clientId (clientId_),
    _userData (userData_),
    _surfaceId (surfaceId_),
    _keyCode (keyCode_),
    _keyState (keyState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::KeyState_IsValid(keyState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", keyState_, "KeyState", "keyState", "OnKeyEventSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnKeyEventSignal::~OnKeyEventSignal() {
}

inline OnKeyEventSignal& OnKeyEventSignal::operator = (const OnKeyEventSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasKeyCode()) {
            setKeyCode(rhs.getKeyCode());
        } else {
            clearKeyCode();
        }
        if (rhs.hasKeyState()) {
            setKeyState(rhs.getKeyState());
        } else {
            clearKeyState();
        }
    }
    return *this;
}

inline bool OnKeyEventSignal::operator == (const OnKeyEventSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasKeyCode() && !rhs.hasKeyCode()) || getKeyCode() == rhs.getKeyCode()) &&
        ((!hasKeyState() && !rhs.hasKeyState()) || getKeyState() == rhs.getKeyState()));
}

inline bool OnKeyEventSignal::operator != (const OnKeyEventSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnKeyEventSignal::operator < (const OnKeyEventSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasKeyCode() || rhs.hasKeyCode()) {
        if (getKeyCode() < rhs.getKeyCode()) return true;
        if (getKeyCode() > rhs.getKeyCode()) return false;
    }
    if (hasKeyState() || rhs.hasKeyState()) {
        if ((uint32)getKeyState() < (uint32)rhs.getKeyState()) return true;
        if ((uint32)getKeyState() > (uint32)rhs.getKeyState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnKeyEventSignal::clone() {
    return new OnKeyEventSignal(*this);
}

inline bool OnKeyEventSignal::operator > (const OnKeyEventSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnKeyEventSignal::clear() {
    clearClientId();
    clearUserData();
    clearSurfaceId();
    clearKeyCode();
    clearKeyState();
}

inline void OnKeyEventSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnKeyEventSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnKeyEventSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnKeyEventSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnKeyEventSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnKeyEventSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnKeyEventSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnKeyEventSignal::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool OnKeyEventSignal::hasUserData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 OnKeyEventSignal::getUserData () const {
    return _userData;
}

inline void OnKeyEventSignal::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void OnKeyEventSignal::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool OnKeyEventSignal::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 OnKeyEventSignal::getSurfaceId () const {
    return _surfaceId;
}

inline void OnKeyEventSignal::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void OnKeyEventSignal::clearKeyCode() {
    if (hasKeyCode()) {
         clear_has_keyCode();
        _keyCode = 0u;
     }
}

inline bool OnKeyEventSignal::hasKeyCode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 OnKeyEventSignal::getKeyCode () const {
    return _keyCode;
}

inline void OnKeyEventSignal::setKeyCode (uint32 keyCode_) {
    set_has_keyCode();
    this->_keyCode = keyCode_;
}

inline void OnKeyEventSignal::clearKeyState() {
    if (hasKeyState()) {
         clear_has_keyState();
        _keyState = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release;
     }
}

inline bool OnKeyEventSignal::hasKeyState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::KeyState OnKeyEventSignal::getKeyState () const {
    return _keyState;
}

inline void OnKeyEventSignal::setKeyState (::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::KeyState_IsValid(keyState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", keyState_, "KeyState", "keyState", "OnKeyEventSignal");
    }
    set_has_keyState();
    this->_keyState = keyState_;
}

inline void OnKeyEventSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnKeyEventSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnKeyEventSignal::set_has_userData () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnKeyEventSignal::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnKeyEventSignal::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnKeyEventSignal::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void OnKeyEventSignal::set_has_keyCode () {
    _has_bits_[0] |= 1u << 3;
}

inline void OnKeyEventSignal::clear_has_keyCode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void OnKeyEventSignal::set_has_keyState () {
    _has_bits_[0] |= 1u << 4;
}

inline void OnKeyEventSignal::clear_has_keyState () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  OnCurrentStatusSignal::OnCurrentStatusSignal ()  :
    _clientId (),
    _requestId (0u),
    _surfaceId (0u),
    _status (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnCurrentStatusSignal::OnCurrentStatusSignal (const OnCurrentStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestId (0u),
    _surfaceId (0u),
    _status (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnCurrentStatusSignal::OnCurrentStatusSignal (const ::std::string& clientId_, uint32 requestId_, uint32 surfaceId_, uint32 status_, uint32 userData_)  :
    _clientId (clientId_),
    _requestId (requestId_),
    _surfaceId (surfaceId_),
    _status (status_),
    _userData (userData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnCurrentStatusSignal::~OnCurrentStatusSignal() {
}

inline OnCurrentStatusSignal& OnCurrentStatusSignal::operator = (const OnCurrentStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool OnCurrentStatusSignal::operator == (const OnCurrentStatusSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool OnCurrentStatusSignal::operator != (const OnCurrentStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnCurrentStatusSignal::operator < (const OnCurrentStatusSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnCurrentStatusSignal::clone() {
    return new OnCurrentStatusSignal(*this);
}

inline bool OnCurrentStatusSignal::operator > (const OnCurrentStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnCurrentStatusSignal::clear() {
    clearClientId();
    clearRequestId();
    clearSurfaceId();
    clearStatus();
    clearUserData();
}

inline void OnCurrentStatusSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnCurrentStatusSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnCurrentStatusSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnCurrentStatusSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnCurrentStatusSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnCurrentStatusSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnCurrentStatusSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnCurrentStatusSignal::clearRequestId() {
    if (hasRequestId()) {
         clear_has_requestId();
        _requestId = 0u;
     }
}

inline bool OnCurrentStatusSignal::hasRequestId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 OnCurrentStatusSignal::getRequestId () const {
    return _requestId;
}

inline void OnCurrentStatusSignal::setRequestId (uint32 requestId_) {
    set_has_requestId();
    this->_requestId = requestId_;
}

inline void OnCurrentStatusSignal::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool OnCurrentStatusSignal::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 OnCurrentStatusSignal::getSurfaceId () const {
    return _surfaceId;
}

inline void OnCurrentStatusSignal::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void OnCurrentStatusSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool OnCurrentStatusSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 OnCurrentStatusSignal::getStatus () const {
    return _status;
}

inline void OnCurrentStatusSignal::setStatus (uint32 status_) {
    set_has_status();
    this->_status = status_;
}

inline void OnCurrentStatusSignal::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool OnCurrentStatusSignal::hasUserData () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 OnCurrentStatusSignal::getUserData () const {
    return _userData;
}

inline void OnCurrentStatusSignal::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void OnCurrentStatusSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnCurrentStatusSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnCurrentStatusSignal::set_has_requestId () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnCurrentStatusSignal::clear_has_requestId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnCurrentStatusSignal::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnCurrentStatusSignal::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void OnCurrentStatusSignal::set_has_status () {
    _has_bits_[0] |= 1u << 3;
}

inline void OnCurrentStatusSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void OnCurrentStatusSignal::set_has_userData () {
    _has_bits_[0] |= 1u << 4;
}

inline void OnCurrentStatusSignal::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  OnCloseOnExternalTouchSignal::OnCloseOnExternalTouchSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnCloseOnExternalTouchSignal::OnCloseOnExternalTouchSignal (const OnCloseOnExternalTouchSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnCloseOnExternalTouchSignal::OnCloseOnExternalTouchSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnCloseOnExternalTouchSignal::~OnCloseOnExternalTouchSignal() {
}

inline OnCloseOnExternalTouchSignal& OnCloseOnExternalTouchSignal::operator = (const OnCloseOnExternalTouchSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool OnCloseOnExternalTouchSignal::operator == (const OnCloseOnExternalTouchSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool OnCloseOnExternalTouchSignal::operator != (const OnCloseOnExternalTouchSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnCloseOnExternalTouchSignal::operator < (const OnCloseOnExternalTouchSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnCloseOnExternalTouchSignal::clone() {
    return new OnCloseOnExternalTouchSignal(*this);
}

inline bool OnCloseOnExternalTouchSignal::operator > (const OnCloseOnExternalTouchSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnCloseOnExternalTouchSignal::clear() {
    clearStatus();
}

inline void OnCloseOnExternalTouchSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool OnCloseOnExternalTouchSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool OnCloseOnExternalTouchSignal::getStatus () const {
    return _status;
}

inline void OnCloseOnExternalTouchSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void OnCloseOnExternalTouchSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnCloseOnExternalTouchSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnLayerStateChangedSignal::OnLayerStateChangedSignal ()  :
    _clientId (),
    _requestId (0u),
    _layerID (0u),
    _layerState (::bosch::cm::ai::hmi::screenbroker::Types::LayerState__Created)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnLayerStateChangedSignal::OnLayerStateChangedSignal (const OnLayerStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _clientId (),
    _requestId (0u),
    _layerID (0u),
    _layerState (::bosch::cm::ai::hmi::screenbroker::Types::LayerState__Created)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnLayerStateChangedSignal::OnLayerStateChangedSignal (const ::std::string& clientId_, uint32 requestId_, uint32 layerID_, ::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState_)  :
    _clientId (clientId_),
    _requestId (requestId_),
    _layerID (layerID_),
    _layerState (layerState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::LayerState_IsValid(layerState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", layerState_, "LayerState", "layerState", "OnLayerStateChangedSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnLayerStateChangedSignal::~OnLayerStateChangedSignal() {
}

inline OnLayerStateChangedSignal& OnLayerStateChangedSignal::operator = (const OnLayerStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
        if (rhs.hasLayerID()) {
            setLayerID(rhs.getLayerID());
        } else {
            clearLayerID();
        }
        if (rhs.hasLayerState()) {
            setLayerState(rhs.getLayerState());
        } else {
            clearLayerState();
        }
    }
    return *this;
}

inline bool OnLayerStateChangedSignal::operator == (const OnLayerStateChangedSignal& rhs) const {
    return (((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()) &&
        ((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()) &&
        ((!hasLayerID() && !rhs.hasLayerID()) || getLayerID() == rhs.getLayerID()) &&
        ((!hasLayerState() && !rhs.hasLayerState()) || getLayerState() == rhs.getLayerState()));
}

inline bool OnLayerStateChangedSignal::operator != (const OnLayerStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnLayerStateChangedSignal::operator < (const OnLayerStateChangedSignal& rhs) const {
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    if (hasLayerID() || rhs.hasLayerID()) {
        if (getLayerID() < rhs.getLayerID()) return true;
        if (getLayerID() > rhs.getLayerID()) return false;
    }
    if (hasLayerState() || rhs.hasLayerState()) {
        if ((uint32)getLayerState() < (uint32)rhs.getLayerState()) return true;
        if ((uint32)getLayerState() > (uint32)rhs.getLayerState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnLayerStateChangedSignal::clone() {
    return new OnLayerStateChangedSignal(*this);
}

inline bool OnLayerStateChangedSignal::operator > (const OnLayerStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnLayerStateChangedSignal::clear() {
    clearClientId();
    clearRequestId();
    clearLayerID();
    clearLayerState();
}

inline void OnLayerStateChangedSignal::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId.clear();
     }
}

inline bool OnLayerStateChangedSignal::hasClientId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnLayerStateChangedSignal::getClientId () const {
    return _clientId;
}

inline ::std::string& OnLayerStateChangedSignal::getClientIdMutable () {
    set_has_clientId();
    return _clientId;
}

inline void OnLayerStateChangedSignal::setClientId (const ::std::string& clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void OnLayerStateChangedSignal::setClientId (const char* clientId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(clientId_);
}

inline void OnLayerStateChangedSignal::setClientId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientId();
    this->_clientId.assign(value, size);
}

inline void OnLayerStateChangedSignal::clearRequestId() {
    if (hasRequestId()) {
         clear_has_requestId();
        _requestId = 0u;
     }
}

inline bool OnLayerStateChangedSignal::hasRequestId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 OnLayerStateChangedSignal::getRequestId () const {
    return _requestId;
}

inline void OnLayerStateChangedSignal::setRequestId (uint32 requestId_) {
    set_has_requestId();
    this->_requestId = requestId_;
}

inline void OnLayerStateChangedSignal::clearLayerID() {
    if (hasLayerID()) {
         clear_has_layerID();
        _layerID = 0u;
     }
}

inline bool OnLayerStateChangedSignal::hasLayerID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 OnLayerStateChangedSignal::getLayerID () const {
    return _layerID;
}

inline void OnLayerStateChangedSignal::setLayerID (uint32 layerID_) {
    set_has_layerID();
    this->_layerID = layerID_;
}

inline void OnLayerStateChangedSignal::clearLayerState() {
    if (hasLayerState()) {
         clear_has_layerState();
        _layerState = ::bosch::cm::ai::hmi::screenbroker::Types::LayerState__Created;
     }
}

inline bool OnLayerStateChangedSignal::hasLayerState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::LayerState OnLayerStateChangedSignal::getLayerState () const {
    return _layerState;
}

inline void OnLayerStateChangedSignal::setLayerState (::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::LayerState_IsValid(layerState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", layerState_, "LayerState", "layerState", "OnLayerStateChangedSignal");
    }
    set_has_layerState();
    this->_layerState = layerState_;
}

inline void OnLayerStateChangedSignal::set_has_clientId () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnLayerStateChangedSignal::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnLayerStateChangedSignal::set_has_requestId () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnLayerStateChangedSignal::clear_has_requestId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void OnLayerStateChangedSignal::set_has_layerID () {
    _has_bits_[0] |= 1u << 2;
}

inline void OnLayerStateChangedSignal::clear_has_layerID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void OnLayerStateChangedSignal::set_has_layerState () {
    _has_bits_[0] |= 1u << 3;
}

inline void OnLayerStateChangedSignal::clear_has_layerState () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_SCREENBROKER_SERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
