/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/ArgumentsJson.h"
#include "bosch/cm/ai/hmi/screenbroker/ArgumentsJsonPrivate.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "RequestArg"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequestId()) {
        yajl_gen_string(g, (const unsigned char*)  "requestId" , 9);
        yajl_gen_integer(g, (long long)value.getRequestId());
    }
    if (!isSparse || value.hasAppId()) {
        yajl_gen_string(g, (const unsigned char*)  "appId" , 5);
        yajl_gen_integer(g, (long long)value.getAppId());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DimensionArg"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "width" , 5);
        yajl_gen_integer(g, (long long)value.getWidth());
    }
    if (!isSparse || value.hasHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "height" , 6);
        yajl_gen_integer(g, (long long)value.getHeight());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PopupPresentationArg"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPriority()) {
        yajl_gen_string(g, (const unsigned char*)  "priority" , 8);
        yajl_gen_integer(g, (long long)value.getPriority());
    }
    if (!isSparse || value.hasModality()) {
        yajl_gen_string(g, (const unsigned char*)  "modality" , 8);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::Modality_Name(value.getModality());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getModality());
    }
    if (!isSparse || value.hasPresentationTime()) {
        yajl_gen_string(g, (const unsigned char*)  "presentationTime" , 16);
        yajl_gen_integer(g, (long long)value.getPresentationTime());
    }
    if (!isSparse || value.hasMinimumPresentationTime()) {
        yajl_gen_string(g, (const unsigned char*)  "minimumPresentationTime" , 23);
        yajl_gen_integer(g, (long long)value.getMinimumPresentationTime());
    }
    if (!isSparse || value.hasValidityPeriod()) {
        yajl_gen_string(g, (const unsigned char*)  "validityPeriod" , 14);
        yajl_gen_integer(g, (long long)value.getValidityPeriod());
    }
    if (!isSparse || value.hasHorizontalAlignment()) {
        yajl_gen_string(g, (const unsigned char*)  "horizontalAlignment" , 19);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment_Name(value.getHorizontalAlignment());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getHorizontalAlignment());
    }
    if (!isSparse || value.hasVerticalAlignment()) {
        yajl_gen_string(g, (const unsigned char*)  "verticalAlignment" , 17);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment_Name(value.getVerticalAlignment());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getVerticalAlignment());
    }
    if (!isSparse || value.hasScaling()) {
        yajl_gen_string(g, (const unsigned char*)  "scaling" , 7);
        const char* s = ::bosch::cm::ai::hmi::screenbroker::Types::Scaling_Name(value.getScaling());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getScaling());
    }
    if (!isSparse || value.hasFocusPriority()) {
        yajl_gen_string(g, (const unsigned char*)  "focusPriority" , 13);
        yajl_gen_integer(g, (long long)value.getFocusPriority());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BuildInLayerInfo"

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLayerId()) {
        yajl_gen_string(g, (const unsigned char*)  "layerId" , 7);
        yajl_gen_integer(g, (long long)value.getLayerId());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasScreenId()) {
        yajl_gen_string(g, (const unsigned char*)  "screenId" , 8);
        yajl_gen_integer(g, (long long)value.getScreenId());
    }
    if (!isSparse || value.hasConnectorName()) {
        yajl_gen_string(g, (const unsigned char*)  "connectorName" , 13);
        const char *s = value.getConnectorName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDimensions()) {
        yajl_gen_string(g, (const unsigned char*)  "dimensions" , 10);
        serializeJson(value.getDimensions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Arguments {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Arguments
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Arguments {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Arguments
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Arguments {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Arguments
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Arguments {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Arguments
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

