/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/ProcDiagnosis.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusExportedPort.h"
#include "asf/dbus/DBusImportedPort.h"
#include "asf/dia_AILComponent.h"
#include "asf/dia_ASFComponentAppLauncher.h"
#include "asf/dia_ASFComponentAudioManager.h"
#include "asf/dia_ASFComponentAuthorizationLevel.h"
#include "asf/dia_ASFComponentDiagClient.h"
#include "asf/dia_ASFComponentErrorLog.h"
#include "asf/dia_ASFComponentHmiMonitor.h"
#include "asf/dia_ASFComponentHmiNavigation.h"
#include "asf/dia_ASFComponentHmiNavigationDataUpdate.h"
#include "asf/dia_ASFComponentPhoneConnectionSetting.h"
#include "asf/dia_ASFComponentSWUpdatePrj.h"
#include "asf/dia_ASFComponentSdsDiagnosisService.h"
#include "asf/dia_ASFComponentSdsGuiPopup.h"
#include "asf/dia_ASFComponentServer.h"
#include "asf/dia_ASFComponentSubsystemDiagnosisClient.h"
#include "asf/dia_ASFComponentSystemSettingsPrj.h"
#include "asf/dia_ASFComponentWifiBL.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ProcDiagnosis" isn't clear, then there should be a description here.
 */

namespace asf {

DEFINE_LOGGER_AND_LEVEL (_logger, "/asf/ProcDiagnosis", Info);

/* static */ const char* ProcDiagnosis::appLauncher = "appLauncher";
/* static */ const char* ProcDiagnosis::dia_Ail = "dia_Ail";
/* static */ const char* ProcDiagnosis::audioManager = "audioManager";
/* static */ const char* ProcDiagnosis::authorizationLevel = "authorizationLevel";
/* static */ const char* ProcDiagnosis::diagServer = "diagServer";
/* static */ const char* ProcDiagnosis::diagSystemSettings = "diagSystemSettings";
/* static */ const char* ProcDiagnosis::diagSWUpdate = "diagSWUpdate";
/* static */ const char* ProcDiagnosis::diagHmiMonitor = "diagHmiMonitor";
/* static */ const char* ProcDiagnosis::diagSdsGuiPopup = "diagSdsGuiPopup";
/* static */ const char* ProcDiagnosis::diagHmiNavigation = "diagHmiNavigation";
/* static */ const char* ProcDiagnosis::diagHmiNavigationDataUpdate = "diagHmiNavigationDataUpdate";
/* static */ const char* ProcDiagnosis::diagPhoneConnectionSetting = "diagPhoneConnectionSetting";
/* static */ const char* ProcDiagnosis::diagErrorLog = "diagErrorLog";
/* static */ const char* ProcDiagnosis::diagClient = "diagClient";
/* static */ const char* ProcDiagnosis::diagSdsDiagnosisService = "diagSdsDiagnosisService";
/* static */ const char* ProcDiagnosis::diagWifiBL = "diagWifiBL";
/* static */ const char* ProcDiagnosis::SubsystemDiagnosisClient = "SubsystemDiagnosisClient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ProcDiagnosis_enabledASFSignalHandler = false;

void importProcDiagnosis() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProcDiagnosis, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnectorSystem;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusConnectorSystem = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnectorSystem, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnectorSystem", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnectorSystem_(new ::asf::dbus::DBusConnector(*app, dbusConnectorSystem));
    app->addStarter(dbusConnectorSystem_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(20);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'dia_asf_thread'

    ::asf::core::ComponentContainerSharedPtr Dia_asf_thread(new ::asf::core::ComponentContainer("dia_asf_thread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Dia_asf_thread);

        // Component 'dia_ASFComponentAppLauncher appLauncher'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAppLauncher > > appLauncherFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAppLauncher >);
        ::asf::core::ComponentDescriptionSharedPtr appLauncherDescription(new ::asf::core::ComponentDescription(1, "appLauncher", /* immediate = */ true, /* threadBridge = */ false, appLauncherFactory));
        Dia_asf_thread->addComponentDescription(appLauncherDescription);

        // Component 'dia_AILComponent dia_Ail'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_AILComponent > > dia_AilFactory(new ::asf::core::ComponentFactory< ::asf::dia_AILComponent >);
        ::asf::core::ComponentDescriptionSharedPtr dia_AilDescription(new ::asf::core::ComponentDescription(2, "dia_Ail", /* immediate = */ true, /* threadBridge = */ false, dia_AilFactory));
        Dia_asf_thread->addComponentDescription(dia_AilDescription);

        // Component 'dia_ASFComponentAudioManager audioManager'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAudioManager > > audioManagerFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAudioManager >);
        ::asf::core::ComponentDescriptionSharedPtr audioManagerDescription(new ::asf::core::ComponentDescription(3, "audioManager", /* immediate = */ true, /* threadBridge = */ false, audioManagerFactory));
        Dia_asf_thread->addComponentDescription(audioManagerDescription);

            // Port 'audioManagerPort'

            ::asf::core::RequiredPort& audioManager_audioManagerPort = audioManagerDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "audioManagerPort"));
            (void)audioManager_audioManagerPort; // prevent unused variable warning

        // Component 'dia_ASFComponentAuthorizationLevel authorizationLevel'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAuthorizationLevel > > authorizationLevelFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentAuthorizationLevel >);
        ::asf::core::ComponentDescriptionSharedPtr authorizationLevelDescription(new ::asf::core::ComponentDescription(4, "authorizationLevel", /* immediate = */ true, /* threadBridge = */ false, authorizationLevelFactory));
        Dia_asf_thread->addComponentDescription(authorizationLevelDescription);

            // Port 'portALDChangeLevel'

            ::asf::core::RequiredPort& authorizationLevel_portALDChangeLevel = authorizationLevelDescription->addRequiredPort (::asf::core::RequiredPort ("com.adit.de.ALD.change_level", "portALDChangeLevel"));
            (void)authorizationLevel_portALDChangeLevel; // prevent unused variable warning

            // Port 'portALDLevelStatus'

            ::asf::core::RequiredPort& authorizationLevel_portALDLevelStatus = authorizationLevelDescription->addRequiredPort (::asf::core::RequiredPort ("com.adit.de.ALD.level_status", "portALDLevelStatus"));
            (void)authorizationLevel_portALDLevelStatus; // prevent unused variable warning

        // Component 'dia_ASFComponentServer diagServer'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentServer > > diagServerFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentServer >);
        ::asf::core::ComponentDescriptionSharedPtr diagServerDescription(new ::asf::core::ComponentDescription(5, "diagServer", /* immediate = */ true, /* threadBridge = */ false, diagServerFactory));
        Dia_asf_thread->addComponentDescription(diagServerDescription);

            // Port 'diagServerPort'

            ::asf::core::ProvidedPort& diagServer_diagServerPort = diagServerDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1", "diagServerPort", false, false));
            (void)diagServer_diagServerPort; // prevent unused variable warning

        // Component 'dia_ASFComponentSystemSettingsPrj diagSystemSettings'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSystemSettingsPrj > > diagSystemSettingsFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSystemSettingsPrj >);
        ::asf::core::ComponentDescriptionSharedPtr diagSystemSettingsDescription(new ::asf::core::ComponentDescription(6, "diagSystemSettings", /* immediate = */ true, /* threadBridge = */ false, diagSystemSettingsFactory));
        Dia_asf_thread->addComponentDescription(diagSystemSettingsDescription);

            // Port 'diagSystemSettingLoopbackClientPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagSystemSettingLoopbackClientPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingLoopbackClientPort"));
            (void)diagSystemSettings_diagSystemSettingLoopbackClientPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppMediaPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppMediaPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppMediaPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppMediaPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppPhonePort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppPhonePort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppPhonePort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppPhonePort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppSxmPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppSxmPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppSxmPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppSxmPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppSystemPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppSystemPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppSystemPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppSystemPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppTelematicsPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppTelematicsPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppTelematicsPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppTelematicsPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppTestmodePort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppTestmodePort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppTestmodePort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppTestmodePort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppTunerPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppTunerPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppTunerPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppTunerPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppVehiclePort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppVehiclePort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppVehiclePort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppVehiclePort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppNavigationPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppNavigationPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppNavigationPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppNavigationPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppSdsPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppSdsPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppSdsPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppSdsPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppHomeScreenPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppHomeScreenPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppHomeScreenPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppHomeScreenPort; // prevent unused variable warning

            // Port 'diagsystemSettingHMIAppMasterPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingHMIAppMasterPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingHMIAppMasterPort"));
            (void)diagSystemSettings_diagsystemSettingHMIAppMasterPort; // prevent unused variable warning

            // Port 'diasystemSettingCfgmgrPort'

            ::asf::core::RequiredPort& diagSystemSettings_diasystemSettingCfgmgrPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diasystemSettingCfgmgrPort"));
            (void)diagSystemSettings_diasystemSettingCfgmgrPort; // prevent unused variable warning

            // Port 'diagsystemSettingSWUpdatePort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingSWUpdatePort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingSWUpdatePort"));
            (void)diagSystemSettings_diagsystemSettingSWUpdatePort; // prevent unused variable warning

            // Port 'diagSystemSettingProfileMngrPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagSystemSettingProfileMngrPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingProfileMngrPort"));
            (void)diagSystemSettings_diagSystemSettingProfileMngrPort; // prevent unused variable warning

            // Port 'diagSystemSettingGatewayPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagSystemSettingGatewayPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingGatewayPort"));
            (void)diagSystemSettings_diagSystemSettingGatewayPort; // prevent unused variable warning

            // Port 'diagSystemSettingSuggestionManagerServerPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagSystemSettingSuggestionManagerServerPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingSuggestionManagerServerPort"));
            (void)diagSystemSettings_diagSystemSettingSuggestionManagerServerPort; // prevent unused variable warning

            // Port 'diagSystemSettingSuggestionManagerClientMQTTPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagSystemSettingSuggestionManagerClientMQTTPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingSuggestionManagerClientMQTTPort"));
            (void)diagSystemSettings_diagSystemSettingSuggestionManagerClientMQTTPort; // prevent unused variable warning

            // Port 'diagsystemSettingPmAppPort'

            ::asf::core::RequiredPort& diagSystemSettings_diagsystemSettingPmAppPort = diagSystemSettingsDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagsystemSettingPmAppPort"));
            (void)diagSystemSettings_diagsystemSettingPmAppPort; // prevent unused variable warning

            // Port 'diagSystemSettingLoopbackServerPort'

            ::asf::core::ProvidedPort& diagSystemSettings_diagSystemSettingLoopbackServerPort = diagSystemSettingsDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "diagSystemSettingLoopbackServerPort", false, false));
            (void)diagSystemSettings_diagSystemSettingLoopbackServerPort; // prevent unused variable warning

        // Component 'dia_ASFComponentSWUpdatePrj diagSWUpdate'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSWUpdatePrj > > diagSWUpdateFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSWUpdatePrj >);
        ::asf::core::ComponentDescriptionSharedPtr diagSWUpdateDescription(new ::asf::core::ComponentDescription(7, "diagSWUpdate", /* immediate = */ true, /* threadBridge = */ false, diagSWUpdateFactory));
        Dia_asf_thread->addComponentDescription(diagSWUpdateDescription);

            // Port 'fcSwUpdatePort'

            ::asf::core::RequiredPort& diagSWUpdate_fcSwUpdatePort = diagSWUpdateDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort"));
            (void)diagSWUpdate_fcSwUpdatePort; // prevent unused variable warning

        // Component 'dia_ASFComponentHmiMonitor diagHmiMonitor'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiMonitor > > diagHmiMonitorFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiMonitor >);
        ::asf::core::ComponentDescriptionSharedPtr diagHmiMonitorDescription(new ::asf::core::ComponentDescription(8, "diagHmiMonitor", /* immediate = */ true, /* threadBridge = */ false, diagHmiMonitorFactory));
        Dia_asf_thread->addComponentDescription(diagHmiMonitorDescription);

            // Port 'hmiMonitorPort'

            ::asf::core::RequiredPort& diagHmiMonitor_hmiMonitorPort = diagHmiMonitorDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", "hmiMonitorPort"));
            (void)diagHmiMonitor_hmiMonitorPort; // prevent unused variable warning

        // Component 'dia_ASFComponentSdsGuiPopup diagSdsGuiPopup'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSdsGuiPopup > > diagSdsGuiPopupFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSdsGuiPopup >);
        ::asf::core::ComponentDescriptionSharedPtr diagSdsGuiPopupDescription(new ::asf::core::ComponentDescription(9, "diagSdsGuiPopup", /* immediate = */ true, /* threadBridge = */ false, diagSdsGuiPopupFactory));
        Dia_asf_thread->addComponentDescription(diagSdsGuiPopupDescription);

            // Port 'sdsGuiPopupPort'

            ::asf::core::RequiredPort& diagSdsGuiPopup_sdsGuiPopupPort = diagSdsGuiPopupDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.PopUpService", "sdsGuiPopupPort"));
            (void)diagSdsGuiPopup_sdsGuiPopupPort; // prevent unused variable warning

        // Component 'dia_ASFComponentHmiNavigation diagHmiNavigation'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiNavigation > > diagHmiNavigationFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiNavigation >);
        ::asf::core::ComponentDescriptionSharedPtr diagHmiNavigationDescription(new ::asf::core::ComponentDescription(10, "diagHmiNavigation", /* immediate = */ true, /* threadBridge = */ false, diagHmiNavigationFactory));
        Dia_asf_thread->addComponentDescription(diagHmiNavigationDescription);

            // Port 'hmiNavigationPort'

            ::asf::core::RequiredPort& diagHmiNavigation_hmiNavigationPort = diagHmiNavigationDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.navigation.NavigationService", "hmiNavigationPort"));
            (void)diagHmiNavigation_hmiNavigationPort; // prevent unused variable warning

        // Component 'dia_ASFComponentHmiNavigationDataUpdate diagHmiNavigationDataUpdate'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiNavigationDataUpdate > > diagHmiNavigationDataUpdateFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentHmiNavigationDataUpdate >);
        ::asf::core::ComponentDescriptionSharedPtr diagHmiNavigationDataUpdateDescription(new ::asf::core::ComponentDescription(11, "diagHmiNavigationDataUpdate", /* immediate = */ true, /* threadBridge = */ false, diagHmiNavigationDataUpdateFactory));
        Dia_asf_thread->addComponentDescription(diagHmiNavigationDataUpdateDescription);

            // Port 'hmiNavigationDataUpdatePort'

            ::asf::core::RequiredPort& diagHmiNavigationDataUpdate_hmiNavigationDataUpdatePort = diagHmiNavigationDataUpdateDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.navigation.NavigationDataUpdateService", "hmiNavigationDataUpdatePort"));
            (void)diagHmiNavigationDataUpdate_hmiNavigationDataUpdatePort; // prevent unused variable warning

        // Component 'dia_ASFComponentPhoneConnectionSetting diagPhoneConnectionSetting'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentPhoneConnectionSetting > > diagPhoneConnectionSettingFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentPhoneConnectionSetting >);
        ::asf::core::ComponentDescriptionSharedPtr diagPhoneConnectionSettingDescription(new ::asf::core::ComponentDescription(12, "diagPhoneConnectionSetting", /* immediate = */ true, /* threadBridge = */ false, diagPhoneConnectionSettingFactory));
        Dia_asf_thread->addComponentDescription(diagPhoneConnectionSettingDescription);

            // Port 'phoneConnectionSettingPort'

            ::asf::core::RequiredPort& diagPhoneConnectionSetting_phoneConnectionSettingPort = diagPhoneConnectionSettingDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.phoneconnectionduration.PhoneConnectionDuration", "phoneConnectionSettingPort"));
            (void)diagPhoneConnectionSetting_phoneConnectionSettingPort; // prevent unused variable warning

        // Component 'dia_ASFComponentErrorLog diagErrorLog'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentErrorLog > > diagErrorLogFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentErrorLog >);
        ::asf::core::ComponentDescriptionSharedPtr diagErrorLogDescription(new ::asf::core::ComponentDescription(13, "diagErrorLog", /* immediate = */ true, /* threadBridge = */ false, diagErrorLogFactory));
        Dia_asf_thread->addComponentDescription(diagErrorLogDescription);

            // Port 'errorLogPort'

            ::asf::core::RequiredPort& diagErrorLog_errorLogPort = diagErrorLogDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diaglog", "errorLogPort"));
            (void)diagErrorLog_errorLogPort; // prevent unused variable warning

        // Component 'dia_ASFComponentDiagClient diagClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentDiagClient > > diagClientFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentDiagClient >);
        ::asf::core::ComponentDescriptionSharedPtr diagClientDescription(new ::asf::core::ComponentDescription(14, "diagClient", /* immediate = */ true, /* threadBridge = */ false, diagClientFactory));
        Dia_asf_thread->addComponentDescription(diagClientDescription);

            // Port 'diagClientPort'

            ::asf::core::RequiredPort& diagClient_diagClientPort = diagClientDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagClientPort"));
            (void)diagClient_diagClientPort; // prevent unused variable warning

        // Component 'dia_ASFComponentSdsDiagnosisService diagSdsDiagnosisService'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSdsDiagnosisService > > diagSdsDiagnosisServiceFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSdsDiagnosisService >);
        ::asf::core::ComponentDescriptionSharedPtr diagSdsDiagnosisServiceDescription(new ::asf::core::ComponentDescription(15, "diagSdsDiagnosisService", /* immediate = */ true, /* threadBridge = */ false, diagSdsDiagnosisServiceFactory));
        Dia_asf_thread->addComponentDescription(diagSdsDiagnosisServiceDescription);

            // Port 'SdsDiagnosisServicePort'

            ::asf::core::RequiredPort& diagSdsDiagnosisService_SdsDiagnosisServicePort = diagSdsDiagnosisServiceDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SdsDiagnosisService", "SdsDiagnosisServicePort"));
            (void)diagSdsDiagnosisService_SdsDiagnosisServicePort; // prevent unused variable warning

        // Component 'dia_ASFComponentWifiBL diagWifiBL'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentWifiBL > > diagWifiBLFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentWifiBL >);
        ::asf::core::ComponentDescriptionSharedPtr diagWifiBLDescription(new ::asf::core::ComponentDescription(16, "diagWifiBL", /* immediate = */ true, /* threadBridge = */ false, diagWifiBLFactory));
        Dia_asf_thread->addComponentDescription(diagWifiBLDescription);

            // Port 'wifiBLPort'

            ::asf::core::RequiredPort& diagWifiBL_wifiBLPort = diagWifiBLDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wbl.conflictmanagement", "wifiBLPort"));
            (void)diagWifiBL_wifiBLPort; // prevent unused variable warning

            // Port 'connmanManagerPort'

            ::asf::core::RequiredPort& diagWifiBL_connmanManagerPort = diagWifiBLDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Manager", "connmanManagerPort"));
            (void)diagWifiBL_connmanManagerPort; // prevent unused variable warning

        // Component 'dia_ASFComponentSubsystemDiagnosisClient SubsystemDiagnosisClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSubsystemDiagnosisClient > > subsystemDiagnosisClientFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSubsystemDiagnosisClient >);
        ::asf::core::ComponentDescriptionSharedPtr subsystemDiagnosisClientDescription(new ::asf::core::ComponentDescription(17, "SubsystemDiagnosisClient", /* immediate = */ true, /* threadBridge = */ false, subsystemDiagnosisClientFactory));
        Dia_asf_thread->addComponentDescription(subsystemDiagnosisClientDescription);

            // Port 'SubsystemDiagnosisClientPort'

            ::asf::core::RequiredPort& SubsystemDiagnosisClient_SubsystemDiagnosisClientPort = subsystemDiagnosisClientDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis", "SubsystemDiagnosisClientPort"));
            (void)SubsystemDiagnosisClient_SubsystemDiagnosisClientPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& AMCommandInterface = dbusConnectorSystem_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    AMCommandInterface.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (audioManager_audioManagerPort, AMCommandInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& ALDChangeLevel = dbusConnectorSystem_->importByName (::std::string("com.adit.de.ALD"), ::std::string("/com/adit/de/ALD/change_level"));
    ALDChangeLevel.setServiceName("com.adit.de.ALD.change_level");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (authorizationLevel_portALDChangeLevel, ALDChangeLevel);

    // Expression

    ::asf::dbus::DBusImportedPort& ALDLevelStatus = dbusConnectorSystem_->importByName (::std::string("com.adit.de.ALD"), ::std::string("/com/adit/de/ALD/level_status"));
    ALDLevelStatus.setServiceName("com.adit.de.ALD.level_status");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (authorizationLevel_portALDLevelStatus, ALDLevelStatus);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingLoopbackInterface = dbusConnector_->importByName (::std::string("asf.ProcDiagnosis"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/DiagnosisLoopback"));
    systemSettingLoopbackInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagSystemSettingLoopbackClientPort, systemSettingLoopbackInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppMediaInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Media"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/mediaservice"));
    systemSettingHMIAppMediaInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppMediaPort, systemSettingHMIAppMediaInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppPhoneInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Phone"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/Phoneservice"));
    systemSettingHMIAppPhoneInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppPhonePort, systemSettingHMIAppPhoneInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppSxmInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Sxm"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/sxmservice"));
    systemSettingHMIAppSxmInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppSxmPort, systemSettingHMIAppSxmInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppSystemInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_System"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/systemservice"));
    systemSettingHMIAppSystemInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppSystemPort, systemSettingHMIAppSystemInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppTelematicsInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Telematics"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/telematicsservice"));
    systemSettingHMIAppTelematicsInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppTelematicsPort, systemSettingHMIAppTelematicsInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppTestmodeInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Testmode"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/testmodeservice"));
    systemSettingHMIAppTestmodeInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppTestmodePort, systemSettingHMIAppTestmodeInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppTunerInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Tuner"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/tunerservice"));
    systemSettingHMIAppTunerInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppTunerPort, systemSettingHMIAppTunerInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppVehicleInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Vehicle"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/Vehicleservice"));
    systemSettingHMIAppVehicleInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppVehiclePort, systemSettingHMIAppVehicleInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppNavigationInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/HmiNavigationService"));
    systemSettingHMIAppNavigationInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppNavigationPort, systemSettingHMIAppNavigationInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppSdsInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Sds"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/HmiSdsService"));
    systemSettingHMIAppSdsInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppSdsPort, systemSettingHMIAppSdsInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppHomeScreenInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_HomeScreen"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/HmiHomescreenService"));
    systemSettingHMIAppHomeScreenInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppHomeScreenPort, systemSettingHMIAppHomeScreenInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingHMIAppMasterInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/masterservice"));
    systemSettingHMIAppMasterInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingHMIAppMasterPort, systemSettingHMIAppMasterInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingSWUpdateInterface = dbusConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));
    systemSettingSWUpdateInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingSWUpdatePort, systemSettingSWUpdateInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingProfileMngrInterface = dbusConnector_->importByName (::std::string("app.core.ProfileMngr"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/ProfileMngrSysSettingsService"));
    systemSettingProfileMngrInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagSystemSettingProfileMngrPort, systemSettingProfileMngrInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingGatewayInterface = dbusConnector_->importByName (::std::string("automotivegateway.AutomotiveGateway"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/AutomotiveGateway"));
    systemSettingGatewayInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagSystemSettingGatewayPort, systemSettingGatewayInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingSuggestionManagerServerInterface = dbusConnector_->importByName (::std::string("com.bosch.server.SuggestionManagerServer"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/SuggestionManagerSystemSettings1Service"));
    systemSettingSuggestionManagerServerInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagSystemSettingSuggestionManagerServerPort, systemSettingSuggestionManagerServerInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& systemSettingSuggestionManagerClientMQTTInterface = dbusConnector_->importByName (::std::string("com.bosch.clientsuggestiongeneratormqtt.SuggestionManagerClientMQTT"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/SuggestionManagerClientMQTTSystemSettings1Service"));
    systemSettingSuggestionManagerClientMQTTInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagSystemSettingSuggestionManagerClientMQTTPort, systemSettingSuggestionManagerClientMQTTInterface);

    // Expression

    ::asf::dbus::DBusExportedPort& diagServerInterface = dbusConnector_->exportByName (diagServer_diagServerPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1"));
    diagServerInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1");

    // Expression

    ::asf::dbus::DBusExportedPort& diagSystemSettingsInterface = dbusConnector_->exportByName (diagSystemSettings_diagSystemSettingLoopbackServerPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/DiagnosisLoopback"));
    diagSystemSettingsInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Expression

    ::asf::dbus::DBusImportedPort& fcswupdatesrvImport = dbusConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));
    fcswupdatesrvImport.setServiceName("fcswupdatesrv.FcSwUpdateSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSWUpdate_fcSwUpdatePort, fcswupdatesrvImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diagHmiMonitorserviceImport = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Testmode"), ::std::string("/bosch/cm/ai/nissan/hmi/hmimonitorservice"));
    diagHmiMonitorserviceImport.setServiceName("bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagHmiMonitor_hmiMonitorPort, diagHmiMonitorserviceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diagSdsGuiPopupServiceImport = dbusConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/PopUpService/SdsAdapter"));
    diagSdsGuiPopupServiceImport.setServiceName("sds_gui_fi.PopUpService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSdsGuiPopup_sdsGuiPopupPort, diagSdsGuiPopupServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diasystemSettingCfgmgrImport = dbusConnector_->importByName (::std::string("asf.ProcConfigManager"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));
    diasystemSettingCfgmgrImport.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diasystemSettingCfgmgrPort, diasystemSettingCfgmgrImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diagHmiNavigationServiceImport = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/com/bosch/cm/ai/navigation"));
    diagHmiNavigationServiceImport.setServiceName("org.bosch.cm.navigation.NavigationService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagHmiNavigation_hmiNavigationPort, diagHmiNavigationServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diagHmiNavigationDataUpdateServiceImport = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/com/bosch/cm/ai/navigationDataUpdate"));
    diagHmiNavigationDataUpdateServiceImport.setServiceName("org.bosch.cm.navigation.NavigationDataUpdateService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagHmiNavigationDataUpdate_hmiNavigationDataUpdatePort, diagHmiNavigationDataUpdateServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& phoneConnectionSettingPhoneHallInterface = dbusConnector_->importByName (::std::string("App.Core.AppHmi_Phone"), ::std::string("/bosch/cm/ai/nissan/hmi/phoneconnectionduration"));
    phoneConnectionSettingPhoneHallInterface.setServiceName("bosch.cm.ai.nissan.hmi.phoneconnectionduration.PhoneConnectionDuration");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagPhoneConnectionSetting_phoneConnectionSettingPort, phoneConnectionSettingPhoneHallInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& errorLogInterface = dbusConnector_->importByName (::std::string("asf.ProcDiaglog"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diaglog"));
    errorLogInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diaglog");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagErrorLog_errorLogPort, errorLogInterface);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagClient_diagClientPort, diagnosticsFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& diagSdsDiagnosisServiceImport = dbusConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SdsDiagnosisService/SdsAdapter"));
    diagSdsDiagnosisServiceImport.setServiceName("sds_gui_fi.SdsDiagnosisService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSdsDiagnosisService_SdsDiagnosisServicePort, diagSdsDiagnosisServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& wifiBLImport = dbusConnectorSystem_->importByName (::std::string("org.bosch.Wbl"), ::std::string("/org/bosch/wbl/conflictmanagement"));
    wifiBLImport.setServiceName("org.bosch.wbl.conflictmanagement");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagWifiBL_wifiBLPort, wifiBLImport);

    // Expression

    ::asf::dbus::DBusImportedPort& connmanManagerImport = dbusConnectorSystem_->importByName (::std::string("net.connman"), ::std::string("/"));
    connmanManagerImport.setServiceName("net.connman.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagWifiBL_connmanManagerPort, connmanManagerImport);

    // Expression

    ::asf::dbus::DBusImportedPort& SubsystemDiagnosisInterface = dbusConnector_->importByName (::std::string("asf.ProcDiagnosisSlave"), ::std::string("/org/bosch/cm/diagnosis/dbus/SubsystemDiagnosis"));
    SubsystemDiagnosisInterface.setServiceName("org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (SubsystemDiagnosisClient_SubsystemDiagnosisClientPort, SubsystemDiagnosisInterface);

    // Expression

    ::asf::dbus::DBusImportedPort& diagsystemSettingPmAppInterface = dbusConnector_->importByName (::std::string("com.bosch.PmApp"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));
    diagsystemSettingPmAppInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (diagSystemSettings_diagsystemSettingPmAppPort, diagsystemSettingPmAppInterface);


    LOG_INFO_STATIC("Starting application 'ProcDiagnosis' version 0.0.1");

    app->start();
}

int executeProcDiagnosis(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiagnosis");
    } else {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiagnosis", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ProcDiagnosis_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("asf", "ProcDiagnosis", ::asf::core::Version(0, 0, 1, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProcDiagnosis");

    app->enableExceptionHandler(true);

    importProcDiagnosis();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace asf

int main(int argc, char* argv[]) {
    ::asf::ProcDiagnosis_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::asf::executeProcDiagnosis(argc, argv);
}

