/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/DiaglogService.h"
#include "asf/ProcDiaglog.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusExportedPort.h"
#include "asf/vd_asf_VehicleClient.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ProcDiaglog" isn't clear, then there should be a description here.
 */

namespace asf {

DEFINE_LOGGER_AND_LEVEL (_logger, "/asf/ProcDiaglog", Info);

/* static */ const char* ProcDiaglog::diaglogServer = "diaglogServer";
/* static */ const char* ProcDiaglog::vehicleClient = "vehicleClient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ProcDiaglog_enabledASFSignalHandler = false;

void importProcDiaglog() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProcDiaglog, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression1;
        {
            __expression1.setApplicationId(903);
        }
        ccaConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'diaglog_asf_thread'

    ::asf::core::ComponentContainerSharedPtr Diaglog_asf_thread(new ::asf::core::ComponentContainer("diaglog_asf_thread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (Diaglog_asf_thread);

        // Component 'DiaglogService diaglogServer'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::DiaglogService > > diaglogServerFactory(new ::asf::core::ComponentFactory< ::asf::DiaglogService >);
        ::asf::core::ComponentDescriptionSharedPtr diaglogServerDescription(new ::asf::core::ComponentDescription(1, "diaglogServer", /* immediate = */ true, /* threadBridge = */ false, diaglogServerFactory));
        Diaglog_asf_thread->addComponentDescription(diaglogServerDescription);

            // Port 'diaglogServerPort'

            ::asf::core::ProvidedPort& diaglogServer_diaglogServerPort = diaglogServerDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diaglog", "diaglogServerPort", false, false));
            (void)diaglogServer_diaglogServerPort; // prevent unused variable warning

        // Component 'vd_asf_VehicleClient vehicleClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::vd_asf_VehicleClient > > vehicleClientFactory(new ::asf::core::ComponentFactory< ::asf::vd_asf_VehicleClient >);
        ::asf::core::ComponentDescriptionSharedPtr vehicleClientDescription(new ::asf::core::ComponentDescription(2, "vehicleClient", /* immediate = */ true, /* threadBridge = */ false, vehicleClientFactory));
        Diaglog_asf_thread->addComponentDescription(vehicleClientDescription);

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& vehicleClient_vehicleMainFiPort = vehicleClientDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)vehicleClient_vehicleMainFiPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusExportedPort& diaglogServerInterface = dbusConnector_->exportByName (diaglogServer_diaglogServerPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diaglog"));
    diaglogServerInterface.setServiceName("org.bosch.cm.diagnosis.dbus.Diaglog");

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (vehicleClient_vehicleMainFiPort, vehicleMainFiImport);


    LOG_INFO_STATIC("Starting application 'ProcDiaglog' version 0.0.1");

    app->start();
}

int executeProcDiaglog(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiaglog");
    } else {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiaglog", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ProcDiaglog_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("asf", "ProcDiaglog", ::asf::core::Version(0, 0, 1, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProcDiaglog");

    app->enableExceptionHandler(true);

    importProcDiaglog();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace asf

int main(int argc, char* argv[]) {
    ::asf::ProcDiaglog_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::asf::executeProcDiaglog(argc, argv);
}

