/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceRecognition.h"
#include "com/bosch/pmapp/VoiceRecognitionDBus.h"
#include "com/bosch/pmapp/VoiceRecognitionJson.h"
#include "com/bosch/pmapp/VoiceRecognitionStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceRecognition {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceRecognition", VoiceRecognitionStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "GetProperties", 0 },
    { 25, "StartStopVoiceRecognition", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 22, "VoiceRecognitionStatus", 0 },
    { 31, "EnhancedVoiceRecognitionFeature", 1 },
};

class VoiceRecognitionStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    VoiceRecognitionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    VoiceRecognitionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    VoiceRecognitionStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.pmapp.VoiceRecognition"),
          _logger(logger) {}

    virtual ~VoiceRecognitionStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void VoiceRecognitionStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceRecognitionStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'StartStopVoiceRecognition'

            LOG_DEBUG_STUB("process method '%s'", "StartStopVoiceRecognition");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopVoiceRecognitionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartStopVoiceRecognition", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartStopVoiceRecognitionRequest > payload = ::boost::static_pointer_cast<StartStopVoiceRecognitionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceRecognitionStub*>(getStub())->onStartStopVoiceRecognitionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* VoiceRecognitionStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.pmapp.VoiceRecognition\">\n"
            "    <property access=\"read\" name=\"VoiceRecognitionStatus\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"EnhancedVoiceRecognitionFeature\" type=\"a{s(uv)}\"/>\n"
            "    <method name=\"GetProperties\">\n"
            "      <doc>\n"
            "        <line>GetProperties = Get the properties of the Voice Recognition Interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>---</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoiceRecognitionProperties\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>VoiceRecognitionProperties (of type VoiceRecognitionPropertiesList) = Type representation of the parameter - Dict:</line>\n"
            "          <line>{ PropertyName : PropertyValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;VoiceRecognitionStatus&quot; : 0x01}</line>\n"
            "          <line>{&quot;EnhancedVoiceRecognitionFeature&quot; : {{&quot;Feature&quot; : &quot;Siri&quot;}, {&quot;Status&quot; : 0x00}}}</line>\n"
            "          <line>}</line>\n"
            "          <line>VoiceRecognitionPropertiesList = dictionary(key=STRING,value=VoiceRecognitionVariant)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartStopVoiceRecognition\">\n"
            "      <doc>\n"
            "        <line>StartStopVoiceRecognition = Activate and deactivate the internal voice recognition of the Audio Gateway.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"VRAction\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>VRAction = The possible values are:</line>\n"
            "          <line>0x00 - Stop the VR session</line>\n"
            "          <line>0x01 - Start the VR session</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void VoiceRecognitionStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<VoiceRecognitionStub*>(getStub()))->onGetAll (properties);
}

void VoiceRecognitionStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "VoiceRecognitionStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "EnhancedVoiceRecognitionFeature");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void VoiceRecognitionStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "VoiceRecognitionStatus");
            ::boost::shared_ptr< VoiceRecognitionStatusGet > payload(new VoiceRecognitionStatusGet());
            payload->setAct(act);
            static_cast<VoiceRecognitionStub*>(getStub())->onVoiceRecognitionStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "EnhancedVoiceRecognitionFeature");
            ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureGet > payload(new EnhancedVoiceRecognitionFeatureGet());
            payload->setAct(act);
            static_cast<VoiceRecognitionStub*>(getStub())->onEnhancedVoiceRecognitionFeatureGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

VoiceRecognitionStub::VoiceRecognitionStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceRecognitionStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceRecognitionStub::VoiceRecognitionStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceRecognitionStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceRecognitionStub::~VoiceRecognitionStub() {
    delete _stubDelegate;
}

void VoiceRecognitionStub::sendVoiceRecognitionStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VoiceRecognitionStatusUpdate payload(_VoiceRecognitionStatusProperty);

        LOG_INFO ("-> send%s", "VoiceRecognitionStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VoiceRecognitionStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceRecognition", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VoiceRecognitionStatusUpdate");
    }
}

void VoiceRecognitionStub::onVoiceRecognitionStatusGet(const ::boost::shared_ptr< VoiceRecognitionStatusGet >& voiceRecognitionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoiceRecognitionStatusGet", voiceRecognitionStatus->getAct());
    sendVoiceRecognitionStatusGetUpdate(_VoiceRecognitionStatusProperty.getVoiceRecognitionStatus(), voiceRecognitionStatus->getAct());
}

void VoiceRecognitionStub::sendVoiceRecognitionStatusGetUpdate(uint8 voiceRecognitionStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VoiceRecognitionStatusGet payload(voiceRecognitionStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoiceRecognitionStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceRecognitionStub::setVoiceRecognitionStatus(uint8 voiceRecognitionStatus) {
    if(voiceRecognitionStatus!=_VoiceRecognitionStatusProperty.getVoiceRecognitionStatus()) {
        _VoiceRecognitionStatusProperty.setVoiceRecognitionStatus(voiceRecognitionStatus);
        sendVoiceRecognitionStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 VoiceRecognitionStub::getVoiceRecognitionStatus() const {
    return _VoiceRecognitionStatusProperty.getVoiceRecognitionStatus();
}

void VoiceRecognitionStub::sendEnhancedVoiceRecognitionFeatureUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EnhancedVoiceRecognitionFeatureUpdate payload(_EnhancedVoiceRecognitionFeatureProperty);

        LOG_INFO ("-> send%s", "EnhancedVoiceRecognitionFeatureUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EnhancedVoiceRecognitionFeature", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceRecognition", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EnhancedVoiceRecognitionFeatureUpdate");
    }
}

void VoiceRecognitionStub::onEnhancedVoiceRecognitionFeatureGet(const ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureGet >& enhancedVoiceRecognitionFeature) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnhancedVoiceRecognitionFeatureGet", enhancedVoiceRecognitionFeature->getAct());
    sendEnhancedVoiceRecognitionFeatureGetUpdate(_EnhancedVoiceRecognitionFeatureProperty.getEnhancedVoiceRecognitionFeature(), enhancedVoiceRecognitionFeature->getAct());
}

void VoiceRecognitionStub::sendEnhancedVoiceRecognitionFeatureGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& enhancedVoiceRecognitionFeature, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EnhancedVoiceRecognitionFeatureGet payload(enhancedVoiceRecognitionFeature);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnhancedVoiceRecognitionFeatureGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceRecognitionStub::setEnhancedVoiceRecognitionFeature(const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& enhancedVoiceRecognitionFeature) {
    if(enhancedVoiceRecognitionFeature!=_EnhancedVoiceRecognitionFeatureProperty.getEnhancedVoiceRecognitionFeature()) {
        _EnhancedVoiceRecognitionFeatureProperty.setEnhancedVoiceRecognitionFeature(enhancedVoiceRecognitionFeature);
        sendEnhancedVoiceRecognitionFeatureUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& VoiceRecognitionStub::getEnhancedVoiceRecognitionFeature() const {
    return _EnhancedVoiceRecognitionFeatureProperty.getEnhancedVoiceRecognitionFeature();
}

::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& VoiceRecognitionStub::getEnhancedVoiceRecognitionFeatureMutable() {
    return _EnhancedVoiceRecognitionFeatureProperty.getEnhancedVoiceRecognitionFeatureMutable();
}

void  VoiceRecognitionStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& voiceRecognitionProperties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(voiceRecognitionProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceRecognitionStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceRecognitionStub::sendStartStopVoiceRecognitionResponse (act_t act) {
    StartStopVoiceRecognitionResponse* payload = new StartStopVoiceRecognitionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartStopVoiceRecognition", StartStopVoiceRecognitionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartStopVoiceRecognition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceRecognitionStub::sendStartStopVoiceRecognitionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartStopVoiceRecognitionError* payload = new StartStopVoiceRecognitionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartStopVoiceRecognition", StartStopVoiceRecognitionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartStopVoiceRecognition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void VoiceRecognitionStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'VoiceRecognitionStatus'
    {
        ::asf::dbus::DBusVariant variant;
        VoiceRecognitionStatusGet payload(_VoiceRecognitionStatusProperty.getVoiceRecognitionStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VoiceRecognitionStatus", variant));
    }

    //property 'EnhancedVoiceRecognitionFeature'
    {
        ::asf::dbus::DBusVariant variant;
        EnhancedVoiceRecognitionFeatureGet payload(_EnhancedVoiceRecognitionFeatureProperty.getEnhancedVoiceRecognitionFeature());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EnhancedVoiceRecognitionFeature", variant));
    }
}

} // namespace VoiceRecognition
} // namespace pmapp
} // namespace bosch
} // namespace com
