/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceRecognition.h"
#include "com/bosch/pmapp/VoiceRecognitionDBus.h"
#include "com/bosch/pmapp/VoiceRecognitionJson.h"
#include "com/bosch/pmapp/VoiceRecognitionProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceRecognition {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceRecognition", VoiceRecognitionProxy);

class VoiceRecognitionProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    VoiceRecognitionProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< VoiceRecognitionProxy >& proxyShared = ::boost::static_pointer_cast< VoiceRecognitionProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_VoiceRecognitionStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceRecognitionStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoiceRecognitionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceRecognitionStatusError> payload = ::boost::static_pointer_cast<VoiceRecognitionStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VoiceRecognitionStatusCallbackIF*) _callback)->onVoiceRecognitionStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceRecognitionStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VoiceRecognitionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceRecognitionStatusUpdate> payload = ::boost::static_pointer_cast<VoiceRecognitionStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VoiceRecognitionStatusCallbackIF*) _callback)->onVoiceRecognitionStatusUpdate(proxyShared, payload);
                        proxyShared->_voiceRecognitionStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_EnhancedVoiceRecognitionFeature:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnhancedVoiceRecognitionFeatureError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnhancedVoiceRecognitionFeature", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnhancedVoiceRecognitionFeatureError> payload = ::boost::static_pointer_cast<EnhancedVoiceRecognitionFeatureError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EnhancedVoiceRecognitionFeatureCallbackIF*) _callback)->onEnhancedVoiceRecognitionFeatureError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnhancedVoiceRecognitionFeatureUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnhancedVoiceRecognitionFeature", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnhancedVoiceRecognitionFeatureUpdate> payload = ::boost::static_pointer_cast<EnhancedVoiceRecognitionFeatureUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EnhancedVoiceRecognitionFeatureCallbackIF*) _callback)->onEnhancedVoiceRecognitionFeatureUpdate(proxyShared, payload);
                        proxyShared->_enhancedVoiceRecognitionFeature = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartStopVoiceRecognition:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartStopVoiceRecognitionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopVoiceRecognition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopVoiceRecognitionError> payload = ::boost::static_pointer_cast<StartStopVoiceRecognitionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopVoiceRecognitionCallbackIF*) _callback)->onStartStopVoiceRecognitionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopVoiceRecognitionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopVoiceRecognition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopVoiceRecognitionResponse> payload = ::boost::static_pointer_cast<StartStopVoiceRecognitionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopVoiceRecognitionCallbackIF*) _callback)->onStartStopVoiceRecognitionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_VoiceRecognitionStatus: {
                ::boost::shared_ptr< VoiceRecognitionStatusError > payload = ::boost::shared_ptr< VoiceRecognitionStatusError >
                (new VoiceRecognitionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceRecognition is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VoiceRecognitionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceRecognitionProxy> proxyShared = ::boost::static_pointer_cast<VoiceRecognitionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VoiceRecognitionStatusCallbackIF*) _callback)->onVoiceRecognitionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnhancedVoiceRecognitionFeature: {
                ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureError > payload = ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureError >
                (new EnhancedVoiceRecognitionFeatureError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceRecognition is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnhancedVoiceRecognitionFeature", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceRecognitionProxy> proxyShared = ::boost::static_pointer_cast<VoiceRecognitionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnhancedVoiceRecognitionFeatureCallbackIF*) _callback)->onEnhancedVoiceRecognitionFeatureError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceRecognition is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceRecognitionProxy> proxyShared = ::boost::static_pointer_cast<VoiceRecognitionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartStopVoiceRecognition: {
                ::boost::shared_ptr< StartStopVoiceRecognitionError > payload = ::boost::shared_ptr< StartStopVoiceRecognitionError >
                (new StartStopVoiceRecognitionError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceRecognition is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartStopVoiceRecognition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceRecognitionProxy> proxyShared = ::boost::static_pointer_cast<VoiceRecognitionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartStopVoiceRecognitionCallbackIF*) _callback)->onStartStopVoiceRecognitionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& VoiceRecognitionProxyCallback::_logger (VoiceRecognitionProxy::_logger);

VoiceRecognitionProxy::VoiceRecognitionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.pmapp.VoiceRecognition", serviceAvailable, _logger) {
}

VoiceRecognitionProxy::~VoiceRecognitionProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< VoiceRecognitionProxy > VoiceRecognitionProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<VoiceRecognitionProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< VoiceRecognitionProxy > proxyNew(new VoiceRecognitionProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t VoiceRecognitionProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    VoiceRecognitionProxyCallback* callback = new VoiceRecognitionProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t VoiceRecognitionProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    VoiceRecognitionProxyCallback* callback = new VoiceRecognitionProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void VoiceRecognitionProxy::clearAllProperties ()
{
    _voiceRecognitionStatus = ::asf::core::nullable< VoiceRecognitionStatusUpdate >();
    _enhancedVoiceRecognitionFeature = ::asf::core::nullable< EnhancedVoiceRecognitionFeatureUpdate >();
}

void VoiceRecognitionProxy::sendDeregisterAll () const
{
    sendVoiceRecognitionStatusDeregisterAll();
    sendEnhancedVoiceRecognitionFeatureDeregisterAll();
}

act_t VoiceRecognitionProxy::sendVoiceRecognitionStatusRegister(VoiceRecognitionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_VoiceRecognitionStatus, "VoiceRecognitionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VoiceRecognitionStatus", &cb, act);
    return act;
}

bool VoiceRecognitionProxy::sendVoiceRecognitionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VoiceRecognitionStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VoiceRecognitionStatus", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceRecognitionProxy::sendVoiceRecognitionStatusGet(VoiceRecognitionStatusCallbackIF& cb) {
    VoiceRecognitionProxyCallback* callback = new VoiceRecognitionProxyCallback(ID_VoiceRecognitionStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "VoiceRecognitionStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("VoiceRecognitionStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 VoiceRecognitionProxy::getVoiceRecognitionStatus() const {
    return _voiceRecognitionStatus.get().getVoiceRecognitionStatus();
}

bool VoiceRecognitionProxy::hasVoiceRecognitionStatus() const {
    return _voiceRecognitionStatus.hasValue();
}

void VoiceRecognitionProxy::sendVoiceRecognitionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VoiceRecognitionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("VoiceRecognitionStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceRecognitionProxy::sendEnhancedVoiceRecognitionFeatureRegister(EnhancedVoiceRecognitionFeatureCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_EnhancedVoiceRecognitionFeature, "EnhancedVoiceRecognitionFeature", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EnhancedVoiceRecognitionFeature", &cb, act);
    return act;
}

bool VoiceRecognitionProxy::sendEnhancedVoiceRecognitionFeatureDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EnhancedVoiceRecognitionFeature", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EnhancedVoiceRecognitionFeature", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceRecognitionProxy::sendEnhancedVoiceRecognitionFeatureGet(EnhancedVoiceRecognitionFeatureCallbackIF& cb) {
    VoiceRecognitionProxyCallback* callback = new VoiceRecognitionProxyCallback(ID_EnhancedVoiceRecognitionFeature, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EnhancedVoiceRecognitionFeature", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("EnhancedVoiceRecognitionFeature", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& VoiceRecognitionProxy::getEnhancedVoiceRecognitionFeature() const {
    return _enhancedVoiceRecognitionFeature.get().getEnhancedVoiceRecognitionFeature();
}

bool VoiceRecognitionProxy::hasEnhancedVoiceRecognitionFeature() const {
    return _enhancedVoiceRecognitionFeature.hasValue();
}

void VoiceRecognitionProxy::sendEnhancedVoiceRecognitionFeatureDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EnhancedVoiceRecognitionFeature");
    _dbusProxyDelegate->deregisterSignalCallback("EnhancedVoiceRecognitionFeature", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceRecognitionProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceRecognitionProxy::sendStartStopVoiceRecognitionRequest(StartStopVoiceRecognitionCallbackIF& cb, uint8 vRAction) const {
    StartStopVoiceRecognitionRequest* payload = new StartStopVoiceRecognitionRequest();
    CHECK_ALLOCATION(payload);
    payload->setVRAction(vRAction);
    DBUS_MESSAGE_CALL(dbusMessage, "StartStopVoiceRecognition", StartStopVoiceRecognitionRequest, payload, true)
    act_t act = addMethodCallback(ID_StartStopVoiceRecognition, dbusMessage.getUniqueSerial(), "StartStopVoiceRecognition", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartStopVoiceRecognition", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace VoiceRecognition
} // namespace pmapp
} // namespace bosch
} // namespace com
