#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICERECOGNITION_H
#define COM_BOSCH_PMAPP_VOICERECOGNITION_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <cstring>
#include <map>
#include <string>

/**
 * The interface shall be exposed in the object path: /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of connected HFP device is - "aabbccddeeff", then the corresponding VoiceRecognition
 *     interface will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceRecognition {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_StartStopVoiceRecognition = 1;

// signal IDs

// property IDs
static const uint16 ID_VoiceRecognitionStatus = 2;
static const uint16 ID_EnhancedVoiceRecognitionFeature = 3;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPropertiesResponse;

class StartStopVoiceRecognitionRequest;

class VoiceRecognitionStatusUpdate;

class VoiceRecognitionStatusRegister;

class EnhancedVoiceRecognitionFeatureUpdate;

class EnhancedVoiceRecognitionFeatureRegister;

// type definitions
/**
 * Get the properties of the Voice Recognition Interface.
 *
 *         Possible errors:
 *         ---
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * Activate and deactivate the internal voice recognition of the Audio Gateway.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartStopVoiceRecognitionResponse;

/**
 * If the meaning of "StartStopVoiceRecognitionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartStopVoiceRecognitionError;

/**
 * Provides the current status of the Voice Recognition Session. The possible values are:
 *
 *             0x00 - VR_IDLE [Default],
 *             0x01 - VR_STARTING,
 *             0x02 - VR_ACTIVE,
 *             0x03 - VR_ENDING.
 */
typedef VoiceRecognitionStatusUpdate VoiceRecognitionStatusSet;

/**
 * Provides the current status of the Voice Recognition Session. The possible values are:
 *
 *             0x00 - VR_IDLE [Default],
 *             0x01 - VR_STARTING,
 *             0x02 - VR_ACTIVE,
 *             0x03 - VR_ENDING.
 */
typedef VoiceRecognitionStatusUpdate VoiceRecognitionStatusGet;

/**
 * If the meaning of "VoiceRecognitionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoiceRecognitionStatusError;

/**
 * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
 *         device. E.x. Siri - IPhone..
 *
 *         Type representation - Dict:
 *           { ParameterName : ParameterValue }
 *
 *         Example:
 *           {
 *             {"Feature" : "Siri"}
 *             {"Status" : 0x00}
 *           }
 */
typedef EnhancedVoiceRecognitionFeatureUpdate EnhancedVoiceRecognitionFeatureSet;

/**
 * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
 *         device. E.x. Siri - IPhone..
 *
 *         Type representation - Dict:
 *           { ParameterName : ParameterValue }
 *
 *         Example:
 *           {
 *             {"Feature" : "Siri"}
 *             {"Status" : 0x00}
 *           }
 */
typedef EnhancedVoiceRecognitionFeatureUpdate EnhancedVoiceRecognitionFeatureGet;

/**
 * If the meaning of "EnhancedVoiceRecognitionFeatureError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EnhancedVoiceRecognitionFeatureError;


/**
 * Get the properties of the Voice Recognition Interface.
 *
 *         Possible errors:
 *         ---
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& VoiceRecognitionProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceRecognitionProperties"

    static const int kVoiceRecognitionProperties = 0;

    /**
     * Clears the field "VoiceRecognitionProperties".
     *
     * The field will be set to its default value. The hasVoiceRecognitionProperties()
     * method will return false.
     */
    inline void clearVoiceRecognitionProperties();

    /**
     * Checks whether the field "VoiceRecognitionProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceRecognitionProperties()). Otherwise it will return false.
     */
    inline bool hasVoiceRecognitionProperties () const;

    /**
     * Returns the value of the member "VoiceRecognitionProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"VoiceRecognitionStatus" : 0x01}
     *                     {"EnhancedVoiceRecognitionFeature" : {{"Feature" : "Siri"}, {"Status" : 0x00}}}
     *                 }
     *
     * @return The value of the field "VoiceRecognitionProperties"
     */
    inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& getVoiceRecognitionProperties () const;

    /**
     * Retrieves the value of the field "VoiceRecognitionProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceRecognitionProperties".
     */
    inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& getVoiceRecognitionPropertiesMutable ();

    /**
     * Sets the value of the member "VoiceRecognitionProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"VoiceRecognitionStatus" : 0x01}
     *                     {"EnhancedVoiceRecognitionFeature" : {{"Feature" : "Siri"}, {"Status" : 0x00}}}
     *                 }
     *
     * @param VoiceRecognitionProperties The value which will be set
     */
    inline void setVoiceRecognitionProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& VoiceRecognitionProperties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& getStringToVoiceRecognitionVariantMap_DefaultInstance ();

    inline void set_has_VoiceRecognitionProperties ();

    inline void clear_has_VoiceRecognitionProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant > _VoiceRecognitionProperties;

};

/**
 * Activate and deactivate the internal voice recognition of the Audio Gateway.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class StartStopVoiceRecognitionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartStopVoiceRecognitionRequest ();

    /**
     * Copy constructor
     */
    inline  StartStopVoiceRecognitionRequest (const StartStopVoiceRecognitionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartStopVoiceRecognitionRequest (uint8 VRAction_);

    /**
     * Destructor
     */
    inline virtual  ~StartStopVoiceRecognitionRequest();

    /**
     * Assignment operator
     */
    inline StartStopVoiceRecognitionRequest& operator = (const StartStopVoiceRecognitionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartStopVoiceRecognitionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartStopVoiceRecognitionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartStopVoiceRecognitionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartStopVoiceRecognitionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VRAction"

    static const int kVRAction = 0;

    /**
     * Clears the field "VRAction".
     *
     * The field will be set to its default value. The hasVRAction()
     * method will return false.
     */
    inline void clearVRAction();

    /**
     * Checks whether the field "VRAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVRAction()). Otherwise it will return false.
     */
    inline bool hasVRAction () const;

    /**
     * Returns the value of the member "VRAction".
     *
     * The possible values are:
     *                     0x00 - Stop the VR session
     *                     0x01 - Start the VR session
     *
     * @return The value of the field "VRAction"
     */
    inline uint8 getVRAction () const;

    /**
     * Sets the value of the member "VRAction".
     *
     * The possible values are:
     *                     0x00 - Stop the VR session
     *                     0x01 - Start the VR session
     *
     * @param VRAction The value which will be set
     */
    inline void setVRAction (uint8 VRAction_);

    static const StartStopVoiceRecognitionRequest &getDefaultInstance();

private:

    inline void set_has_VRAction ();

    inline void clear_has_VRAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _VRAction;

};

/**
 * Provides the current status of the Voice Recognition Session. The possible values are:
 *
 *             0x00 - VR_IDLE [Default],
 *             0x01 - VR_STARTING,
 *             0x02 - VR_ACTIVE,
 *             0x03 - VR_ENDING.
 */
class VoiceRecognitionStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceRecognitionStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  VoiceRecognitionStatusUpdate (const VoiceRecognitionStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceRecognitionStatusUpdate (uint8 VoiceRecognitionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceRecognitionStatusUpdate();

    /**
     * Assignment operator
     */
    inline VoiceRecognitionStatusUpdate& operator = (const VoiceRecognitionStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceRecognitionStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceRecognitionStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceRecognitionStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceRecognitionStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceRecognitionStatus"

    static const int kVoiceRecognitionStatus = 0;

    /**
     * Clears the field "VoiceRecognitionStatus".
     *
     * The field will be set to its default value. The hasVoiceRecognitionStatus()
     * method will return false.
     */
    inline void clearVoiceRecognitionStatus();

    /**
     * Checks whether the field "VoiceRecognitionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceRecognitionStatus()). Otherwise it will return false.
     */
    inline bool hasVoiceRecognitionStatus () const;

    /**
     * Returns the value of the member "VoiceRecognitionStatus".
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @return The value of the field "VoiceRecognitionStatus"
     */
    inline uint8 getVoiceRecognitionStatus () const;

    /**
     * Sets the value of the member "VoiceRecognitionStatus".
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @param VoiceRecognitionStatus The value which will be set
     */
    inline void setVoiceRecognitionStatus (uint8 VoiceRecognitionStatus_);

    static const VoiceRecognitionStatusUpdate &getDefaultInstance();

private:

    inline void set_has_VoiceRecognitionStatus ();

    inline void clear_has_VoiceRecognitionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _VoiceRecognitionStatus;

};

/**
 * Provides the current status of the Voice Recognition Session. The possible values are:
 *
 *             0x00 - VR_IDLE [Default],
 *             0x01 - VR_STARTING,
 *             0x02 - VR_ACTIVE,
 *             0x03 - VR_ENDING.
 */
class VoiceRecognitionStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceRecognitionStatusRegister ();

    /**
     * Copy constructor
     */
    inline  VoiceRecognitionStatusRegister (const VoiceRecognitionStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VoiceRecognitionStatusRegister();

    /**
     * Assignment operator
     */
    inline VoiceRecognitionStatusRegister& operator = (const VoiceRecognitionStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceRecognitionStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceRecognitionStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceRecognitionStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceRecognitionStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VoiceRecognitionStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
 *         device. E.x. Siri - IPhone..
 *
 *         Type representation - Dict:
 *           { ParameterName : ParameterValue }
 *
 *         Example:
 *           {
 *             {"Feature" : "Siri"}
 *             {"Status" : 0x00}
 *           }
 */
class EnhancedVoiceRecognitionFeatureUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnhancedVoiceRecognitionFeatureUpdate ();

    /**
     * Copy constructor
     */
    inline  EnhancedVoiceRecognitionFeatureUpdate (const EnhancedVoiceRecognitionFeatureUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EnhancedVoiceRecognitionFeatureUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeature_);

    /**
     * Destructor
     */
    inline virtual  ~EnhancedVoiceRecognitionFeatureUpdate();

    /**
     * Assignment operator
     */
    inline EnhancedVoiceRecognitionFeatureUpdate& operator = (const EnhancedVoiceRecognitionFeatureUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EnhancedVoiceRecognitionFeature"

    static const int kEnhancedVoiceRecognitionFeature = 0;

    /**
     * Clears the field "EnhancedVoiceRecognitionFeature".
     *
     * The field will be set to its default value. The hasEnhancedVoiceRecognitionFeature()
     * method will return false.
     */
    inline void clearEnhancedVoiceRecognitionFeature();

    /**
     * Checks whether the field "EnhancedVoiceRecognitionFeature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnhancedVoiceRecognitionFeature()). Otherwise it will return false.
     */
    inline bool hasEnhancedVoiceRecognitionFeature () const;

    /**
     * Returns the value of the member "EnhancedVoiceRecognitionFeature".
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @return The value of the field "EnhancedVoiceRecognitionFeature"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeature () const;

    /**
     * Retrieves the value of the field "EnhancedVoiceRecognitionFeature" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnhancedVoiceRecognitionFeature".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeatureMutable ();

    /**
     * Sets the value of the member "EnhancedVoiceRecognitionFeature".
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @param EnhancedVoiceRecognitionFeature The value which will be set
     */
    inline void setEnhancedVoiceRecognitionFeature (const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeature_);

    static const EnhancedVoiceRecognitionFeatureUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >& getStringToBaseTypesVariantMap_DefaultInstance ();

    inline void set_has_EnhancedVoiceRecognitionFeature ();

    inline void clear_has_EnhancedVoiceRecognitionFeature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType _EnhancedVoiceRecognitionFeature;

};

/**
 * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
 *         device. E.x. Siri - IPhone..
 *
 *         Type representation - Dict:
 *           { ParameterName : ParameterValue }
 *
 *         Example:
 *           {
 *             {"Feature" : "Siri"}
 *             {"Status" : 0x00}
 *           }
 */
class EnhancedVoiceRecognitionFeatureRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnhancedVoiceRecognitionFeatureRegister ();

    /**
     * Copy constructor
     */
    inline  EnhancedVoiceRecognitionFeatureRegister (const EnhancedVoiceRecognitionFeatureRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EnhancedVoiceRecognitionFeatureRegister();

    /**
     * Assignment operator
     */
    inline EnhancedVoiceRecognitionFeatureRegister& operator = (const EnhancedVoiceRecognitionFeatureRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnhancedVoiceRecognitionFeatureRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnhancedVoiceRecognitionFeatureRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnhancedVoiceRecognitionFeatureRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnhancedVoiceRecognitionFeatureRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EnhancedVoiceRecognitionFeatureRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _VoiceRecognitionProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _VoiceRecognitionProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& VoiceRecognitionProperties_)  :
    _VoiceRecognitionProperties (VoiceRecognitionProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceRecognitionProperties()) {
            setVoiceRecognitionProperties(rhs.getVoiceRecognitionProperties());
        } else {
            clearVoiceRecognitionProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasVoiceRecognitionProperties() && !rhs.hasVoiceRecognitionProperties()) || getVoiceRecognitionProperties() == rhs.getVoiceRecognitionProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasVoiceRecognitionProperties() || rhs.hasVoiceRecognitionProperties()) {
        if (getVoiceRecognitionProperties() < rhs.getVoiceRecognitionProperties()) return true;
        if (getVoiceRecognitionProperties() > rhs.getVoiceRecognitionProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearVoiceRecognitionProperties();
}

inline void GetPropertiesResponse::clearVoiceRecognitionProperties() {
    if (hasVoiceRecognitionProperties()) {
         clear_has_VoiceRecognitionProperties();
        _VoiceRecognitionProperties.clear();
     }
}

inline bool GetPropertiesResponse::hasVoiceRecognitionProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& GetPropertiesResponse::getVoiceRecognitionProperties () const {
    return _VoiceRecognitionProperties;
}

inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& GetPropertiesResponse::getVoiceRecognitionPropertiesMutable () {
    set_has_VoiceRecognitionProperties();
    return _VoiceRecognitionProperties;
}

inline void GetPropertiesResponse::setVoiceRecognitionProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& VoiceRecognitionProperties_) {
    set_has_VoiceRecognitionProperties();
    this->_VoiceRecognitionProperties = VoiceRecognitionProperties_;
}

inline void GetPropertiesResponse::set_has_VoiceRecognitionProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_VoiceRecognitionProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartStopVoiceRecognitionRequest::StartStopVoiceRecognitionRequest ()  :
    _VRAction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartStopVoiceRecognitionRequest::StartStopVoiceRecognitionRequest (const StartStopVoiceRecognitionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _VRAction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartStopVoiceRecognitionRequest::StartStopVoiceRecognitionRequest (uint8 VRAction_)  :
    _VRAction (VRAction_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartStopVoiceRecognitionRequest::~StartStopVoiceRecognitionRequest() {
}

inline StartStopVoiceRecognitionRequest& StartStopVoiceRecognitionRequest::operator = (const StartStopVoiceRecognitionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVRAction()) {
            setVRAction(rhs.getVRAction());
        } else {
            clearVRAction();
        }
    }
    return *this;
}

inline bool StartStopVoiceRecognitionRequest::operator == (const StartStopVoiceRecognitionRequest& rhs) const {
    return (((!hasVRAction() && !rhs.hasVRAction()) || getVRAction() == rhs.getVRAction()));
}

inline bool StartStopVoiceRecognitionRequest::operator != (const StartStopVoiceRecognitionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartStopVoiceRecognitionRequest::operator < (const StartStopVoiceRecognitionRequest& rhs) const {
    if (hasVRAction() || rhs.hasVRAction()) {
        if (getVRAction() < rhs.getVRAction()) return true;
        if (getVRAction() > rhs.getVRAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartStopVoiceRecognitionRequest::clone() {
    return new StartStopVoiceRecognitionRequest(*this);
}

inline bool StartStopVoiceRecognitionRequest::operator > (const StartStopVoiceRecognitionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartStopVoiceRecognitionRequest::clear() {
    clearVRAction();
}

inline void StartStopVoiceRecognitionRequest::clearVRAction() {
    if (hasVRAction()) {
         clear_has_VRAction();
        _VRAction = 0u;
     }
}

inline bool StartStopVoiceRecognitionRequest::hasVRAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 StartStopVoiceRecognitionRequest::getVRAction () const {
    return _VRAction;
}

inline void StartStopVoiceRecognitionRequest::setVRAction (uint8 VRAction_) {
    set_has_VRAction();
    this->_VRAction = VRAction_;
}

inline void StartStopVoiceRecognitionRequest::set_has_VRAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartStopVoiceRecognitionRequest::clear_has_VRAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceRecognitionStatusUpdate::VoiceRecognitionStatusUpdate ()  :
    _VoiceRecognitionStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceRecognitionStatusUpdate::VoiceRecognitionStatusUpdate (const VoiceRecognitionStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _VoiceRecognitionStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceRecognitionStatusUpdate::VoiceRecognitionStatusUpdate (uint8 VoiceRecognitionStatus_)  :
    _VoiceRecognitionStatus (VoiceRecognitionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceRecognitionStatusUpdate::~VoiceRecognitionStatusUpdate() {
}

inline VoiceRecognitionStatusUpdate& VoiceRecognitionStatusUpdate::operator = (const VoiceRecognitionStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceRecognitionStatus()) {
            setVoiceRecognitionStatus(rhs.getVoiceRecognitionStatus());
        } else {
            clearVoiceRecognitionStatus();
        }
    }
    return *this;
}

inline bool VoiceRecognitionStatusUpdate::operator == (const VoiceRecognitionStatusUpdate& rhs) const {
    return (((!hasVoiceRecognitionStatus() && !rhs.hasVoiceRecognitionStatus()) || getVoiceRecognitionStatus() == rhs.getVoiceRecognitionStatus()));
}

inline bool VoiceRecognitionStatusUpdate::operator != (const VoiceRecognitionStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceRecognitionStatusUpdate::operator < (const VoiceRecognitionStatusUpdate& rhs) const {
    if (hasVoiceRecognitionStatus() || rhs.hasVoiceRecognitionStatus()) {
        if (getVoiceRecognitionStatus() < rhs.getVoiceRecognitionStatus()) return true;
        if (getVoiceRecognitionStatus() > rhs.getVoiceRecognitionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceRecognitionStatusUpdate::clone() {
    return new VoiceRecognitionStatusUpdate(*this);
}

inline bool VoiceRecognitionStatusUpdate::operator > (const VoiceRecognitionStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceRecognitionStatusUpdate::clear() {
    clearVoiceRecognitionStatus();
}

inline void VoiceRecognitionStatusUpdate::clearVoiceRecognitionStatus() {
    if (hasVoiceRecognitionStatus()) {
         clear_has_VoiceRecognitionStatus();
        _VoiceRecognitionStatus = 0u;
     }
}

inline bool VoiceRecognitionStatusUpdate::hasVoiceRecognitionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 VoiceRecognitionStatusUpdate::getVoiceRecognitionStatus () const {
    return _VoiceRecognitionStatus;
}

inline void VoiceRecognitionStatusUpdate::setVoiceRecognitionStatus (uint8 VoiceRecognitionStatus_) {
    set_has_VoiceRecognitionStatus();
    this->_VoiceRecognitionStatus = VoiceRecognitionStatus_;
}

inline void VoiceRecognitionStatusUpdate::set_has_VoiceRecognitionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceRecognitionStatusUpdate::clear_has_VoiceRecognitionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceRecognitionStatusRegister::VoiceRecognitionStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceRecognitionStatusRegister::VoiceRecognitionStatusRegister (const VoiceRecognitionStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceRecognitionStatusRegister::~VoiceRecognitionStatusRegister() {
}

inline VoiceRecognitionStatusRegister& VoiceRecognitionStatusRegister::operator = (const VoiceRecognitionStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VoiceRecognitionStatusRegister::operator == (const VoiceRecognitionStatusRegister& ) const {
    return true;
}

inline bool VoiceRecognitionStatusRegister::operator != (const VoiceRecognitionStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceRecognitionStatusRegister::operator < (const VoiceRecognitionStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VoiceRecognitionStatusRegister::clone() {
    return new VoiceRecognitionStatusRegister(*this);
}

inline bool VoiceRecognitionStatusRegister::operator > (const VoiceRecognitionStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceRecognitionStatusRegister::clear() {
}

inline  EnhancedVoiceRecognitionFeatureUpdate::EnhancedVoiceRecognitionFeatureUpdate ()  :
    _EnhancedVoiceRecognitionFeature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnhancedVoiceRecognitionFeatureUpdate::EnhancedVoiceRecognitionFeatureUpdate (const EnhancedVoiceRecognitionFeatureUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _EnhancedVoiceRecognitionFeature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnhancedVoiceRecognitionFeatureUpdate::EnhancedVoiceRecognitionFeatureUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeature_)  :
    _EnhancedVoiceRecognitionFeature (EnhancedVoiceRecognitionFeature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnhancedVoiceRecognitionFeatureUpdate::~EnhancedVoiceRecognitionFeatureUpdate() {
}

inline EnhancedVoiceRecognitionFeatureUpdate& EnhancedVoiceRecognitionFeatureUpdate::operator = (const EnhancedVoiceRecognitionFeatureUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnhancedVoiceRecognitionFeature()) {
            setEnhancedVoiceRecognitionFeature(rhs.getEnhancedVoiceRecognitionFeature());
        } else {
            clearEnhancedVoiceRecognitionFeature();
        }
    }
    return *this;
}

inline bool EnhancedVoiceRecognitionFeatureUpdate::operator == (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const {
    return (((!hasEnhancedVoiceRecognitionFeature() && !rhs.hasEnhancedVoiceRecognitionFeature()) || getEnhancedVoiceRecognitionFeature() == rhs.getEnhancedVoiceRecognitionFeature()));
}

inline bool EnhancedVoiceRecognitionFeatureUpdate::operator != (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EnhancedVoiceRecognitionFeatureUpdate::operator < (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const {
    if (hasEnhancedVoiceRecognitionFeature() || rhs.hasEnhancedVoiceRecognitionFeature()) {
        if (getEnhancedVoiceRecognitionFeature() < rhs.getEnhancedVoiceRecognitionFeature()) return true;
        if (getEnhancedVoiceRecognitionFeature() > rhs.getEnhancedVoiceRecognitionFeature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnhancedVoiceRecognitionFeatureUpdate::clone() {
    return new EnhancedVoiceRecognitionFeatureUpdate(*this);
}

inline bool EnhancedVoiceRecognitionFeatureUpdate::operator > (const EnhancedVoiceRecognitionFeatureUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnhancedVoiceRecognitionFeatureUpdate::clear() {
    clearEnhancedVoiceRecognitionFeature();
}

inline void EnhancedVoiceRecognitionFeatureUpdate::clearEnhancedVoiceRecognitionFeature() {
    if (hasEnhancedVoiceRecognitionFeature()) {
         clear_has_EnhancedVoiceRecognitionFeature();
        _EnhancedVoiceRecognitionFeature.clear();
     }
}

inline bool EnhancedVoiceRecognitionFeatureUpdate::hasEnhancedVoiceRecognitionFeature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeatureUpdate::getEnhancedVoiceRecognitionFeature () const {
    return _EnhancedVoiceRecognitionFeature;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeatureUpdate::getEnhancedVoiceRecognitionFeatureMutable () {
    set_has_EnhancedVoiceRecognitionFeature();
    return _EnhancedVoiceRecognitionFeature;
}

inline void EnhancedVoiceRecognitionFeatureUpdate::setEnhancedVoiceRecognitionFeature (const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& EnhancedVoiceRecognitionFeature_) {
    set_has_EnhancedVoiceRecognitionFeature();
    this->_EnhancedVoiceRecognitionFeature = EnhancedVoiceRecognitionFeature_;
}

inline void EnhancedVoiceRecognitionFeatureUpdate::set_has_EnhancedVoiceRecognitionFeature () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnhancedVoiceRecognitionFeatureUpdate::clear_has_EnhancedVoiceRecognitionFeature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EnhancedVoiceRecognitionFeatureRegister::EnhancedVoiceRecognitionFeatureRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnhancedVoiceRecognitionFeatureRegister::EnhancedVoiceRecognitionFeatureRegister (const EnhancedVoiceRecognitionFeatureRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnhancedVoiceRecognitionFeatureRegister::~EnhancedVoiceRecognitionFeatureRegister() {
}

inline EnhancedVoiceRecognitionFeatureRegister& EnhancedVoiceRecognitionFeatureRegister::operator = (const EnhancedVoiceRecognitionFeatureRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EnhancedVoiceRecognitionFeatureRegister::operator == (const EnhancedVoiceRecognitionFeatureRegister& ) const {
    return true;
}

inline bool EnhancedVoiceRecognitionFeatureRegister::operator != (const EnhancedVoiceRecognitionFeatureRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EnhancedVoiceRecognitionFeatureRegister::operator < (const EnhancedVoiceRecognitionFeatureRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EnhancedVoiceRecognitionFeatureRegister::clone() {
    return new EnhancedVoiceRecognitionFeatureRegister(*this);
}

inline bool EnhancedVoiceRecognitionFeatureRegister::operator > (const EnhancedVoiceRecognitionFeatureRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnhancedVoiceRecognitionFeatureRegister::clear() {
}

} // namespace VoiceRecognition
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICERECOGNITION_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
