/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALLSTUB_H
#define COM_BOSCH_PMAPP_VOICECALLSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCall.h"
#include <map>
#include <string>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCall {

class VoiceCallStubDelegate;

class VoiceCallStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the VoiceCallStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    VoiceCallStub (const std::string& portName);

    /**
     * Create an instance of the VoiceCallStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    VoiceCallStub (const std::string& portName, const std::string& objectPath);

    virtual ~VoiceCallStub();

    // property 'SCOConnection'

    /**
     * The method onSCOConnectionGet() is called by ASF when a client invokes
     * the read method for the property 'SCOConnection'. The
     * onSCOConnectionGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     */
    virtual void onSCOConnectionGet(const ::boost::shared_ptr< SCOConnectionGet >& payload);

    /**
     * Sends back the update to a previous onSCOConnectionGet().
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @param act Identifies a previous invocation of onSCOConnectionGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSCOConnectionGetUpdate(uint8 sCOConnection, act_t act = 0);

    /**
     * Set the value of the property 'SCOConnection' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     */
    void setSCOConnection(uint8 sCOConnection);

    /**
     * Returns the current value of the property 'SCOConnection'.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     */
    uint8 getSCOConnection() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSCOConnectionUpdate().
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     */
    void sendSCOConnectionUpdate();

    // property 'RingtoneMuteState'

    /**
     * The method onRingtoneMuteStateGet() is called by ASF when a client
     * invokes the read method for the property 'RingtoneMuteState'. The
     * onRingtoneMuteStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     */
    virtual void onRingtoneMuteStateGet(const ::boost::shared_ptr< RingtoneMuteStateGet >& payload);

    /**
     * Sends back the update to a previous onRingtoneMuteStateGet().
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @param act Identifies a previous invocation of
     * onRingtoneMuteStateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRingtoneMuteStateGetUpdate(bool ringtoneMuteState, act_t act = 0);

    /**
     * Set the value of the property 'RingtoneMuteState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     */
    void setRingtoneMuteState(bool ringtoneMuteState);

    /**
     * Returns the current value of the property 'RingtoneMuteState'.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     */
    bool getRingtoneMuteState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRingtoneMuteStateUpdate().
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     */
    void sendRingtoneMuteStateUpdate();

    // property 'WaitingModeState'

    /**
     * The method onWaitingModeStateGet() is called by ASF when a client
     * invokes the read method for the property 'WaitingModeState'. The
     * onWaitingModeStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     */
    virtual void onWaitingModeStateGet(const ::boost::shared_ptr< WaitingModeStateGet >& payload);

    /**
     * Sends back the update to a previous onWaitingModeStateGet().
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @param act Identifies a previous invocation of onWaitingModeStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWaitingModeStateGetUpdate(uint8 waitingModeState, act_t act = 0);

    /**
     * Set the value of the property 'WaitingModeState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     */
    void setWaitingModeState(uint8 waitingModeState);

    /**
     * Returns the current value of the property 'WaitingModeState'.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     */
    uint8 getWaitingModeState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWaitingModeStateUpdate().
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     */
    void sendWaitingModeStateUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the VoiceCall Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the VoiceCall Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param VoiceCallProperties Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SCOConnection" : 0x01},
     *                     {"RingtoneMuteState" : true},
     *                     {"WaitingModeState" : 0x01}
     *                   }
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& voiceCallProperties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the VoiceCall Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MuteUnmuteRingtone'

    /**
     * The method onMuteUnmuteRingtone() is called by ASF when a client
     * invokes the method 'MuteUnmuteRingtone'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendMuteUnmuteRingtone() or sendMuteUnmuteRingtoneError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'MuteUnmuteRingtone'</b>:
     *
     * This method allows the client to Mute / Unmute the playing ringtone.
     *         The updated change will be provided by the property - 'RingtoneMuteState'.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMuteUnmuteRingtoneRequest (const ::boost::shared_ptr< MuteUnmuteRingtoneRequest >& request) = 0;

    /**
     * The method sendMuteUnmuteRingtoneResponse() sends a response of a
     * previous method invocation of 'MuteUnmuteRingtone' back to the client.
     *
     * <b>Documentation of 'MuteUnmuteRingtone'</b>:
     *
     * This method allows the client to Mute / Unmute the playing ringtone.
     *         The updated change will be provided by the property - 'RingtoneMuteState'.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *
     * @param act The parameter act identifies a previous invocation of
     * onMuteUnmuteRingtone(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMuteUnmuteRingtoneResponse (act_t act = 0);

    /**
     * The method sendMuteUnmuteRingtoneError() sends an error response of a
     * previous method invocation of 'MuteUnmuteRingtone' back to the client.
     *
     * <b>Documentation of 'MuteUnmuteRingtone'</b>:
     *
     * This method allows the client to Mute / Unmute the playing ringtone.
     *         The updated change will be provided by the property - 'RingtoneMuteState'.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onMuteUnmuteRingtone().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMuteUnmuteRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Dial'

    /**
     * The method onDial() is called by ASF when a client invokes the method
     * 'Dial'. A subclass has to implement this method and send back a
     * response to the client either with the sendDial() or sendDialError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * Initiates a new outgoing call.
     *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDialRequest (const ::boost::shared_ptr< DialRequest >& request) = 0;

    /**
     * The method sendDialResponse() sends a response of a previous method
     * invocation of 'Dial' back to the client.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * Initiates a new outgoing call.
     *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param CallInstance Instance of the outgoing call placed
     *
     * @param act The parameter act identifies a previous invocation of
     * onDial(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDialResponse (uint8 callInstance, act_t act = 0);

    /**
     * The method sendDialError() sends an error response of a previous method
     * invocation of 'Dial' back to the client.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * Initiates a new outgoing call.
     *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDial(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AcceptCall'

    /**
     * The method onAcceptCall() is called by ASF when a client invokes the
     * method 'AcceptCall'. A subclass has to implement this method and send
     * back a response to the client either with the sendAcceptCall() or
     * sendAcceptCallError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'AcceptCall'</b>:
     *
     * This method could be invoked to:
     *             - Answer an Incoming call (OR)
     *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
     *             - Put the current call on hold and answer the waiting call
     *
     *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAcceptCallRequest (const ::boost::shared_ptr< AcceptCallRequest >& request) = 0;

    /**
     * The method sendAcceptCallResponse() sends a response of a previous
     * method invocation of 'AcceptCall' back to the client.
     *
     * <b>Documentation of 'AcceptCall'</b>:
     *
     * This method could be invoked to:
     *             - Answer an Incoming call (OR)
     *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
     *             - Put the current call on hold and answer the waiting call
     *
     *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param CallInstanceOut Instance of the accepted call.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAcceptCall(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAcceptCallResponse (uint8 callInstanceOut, act_t act = 0);

    /**
     * The method sendAcceptCallError() sends an error response of a previous
     * method invocation of 'AcceptCall' back to the client.
     *
     * <b>Documentation of 'AcceptCall'</b>:
     *
     * This method could be invoked to:
     *             - Answer an Incoming call (OR)
     *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
     *             - Put the current call on hold and answer the waiting call
     *
     *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAcceptCall(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAcceptCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SwapCall'

    /**
     * The method onSwapCall() is called by ASF when a client invokes the
     * method 'SwapCall'. A subclass has to implement this method and send
     * back a response to the client either with the sendSwapCall() or
     * sendSwapCallError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SwapCall'</b>:
     *
     * This method could be invoked to:
     *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
     *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
     *              - Release the currently active call (0 or more) and activate any currently held calls.
     *
     *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
     *         calls exist.
     *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
     *         the case of Held, Active and Waiting calls.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSwapCallRequest (const ::boost::shared_ptr< SwapCallRequest >& request) = 0;

    /**
     * The method sendSwapCallResponse() sends a response of a previous method
     * invocation of 'SwapCall' back to the client.
     *
     * <b>Documentation of 'SwapCall'</b>:
     *
     * This method could be invoked to:
     *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
     *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
     *              - Release the currently active call (0 or more) and activate any currently held calls.
     *
     *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
     *         calls exist.
     *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
     *         the case of Held, Active and Waiting calls.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param act The parameter act identifies a previous invocation of
     * onSwapCall(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSwapCallResponse (act_t act = 0);

    /**
     * The method sendSwapCallError() sends an error response of a previous
     * method invocation of 'SwapCall' back to the client.
     *
     * <b>Documentation of 'SwapCall'</b>:
     *
     * This method could be invoked to:
     *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
     *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
     *              - Release the currently active call (0 or more) and activate any currently held calls.
     *
     *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
     *         calls exist.
     *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
     *         the case of Held, Active and Waiting calls.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSwapCall(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSwapCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HangUpCall'

    /**
     * The method onHangUpCall() is called by ASF when a client invokes the
     * method 'HangUpCall'. A subclass has to implement this method and send
     * back a response to the client either with the sendHangUpCall() or
     * sendHangUpCallError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'HangUpCall'</b>:
     *
     * This method is used to hangup a specific call in the device.
     *
     *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHangUpCallRequest (const ::boost::shared_ptr< HangUpCallRequest >& request) = 0;

    /**
     * The method sendHangUpCallResponse() sends a response of a previous
     * method invocation of 'HangUpCall' back to the client.
     *
     * <b>Documentation of 'HangUpCall'</b>:
     *
     * This method is used to hangup a specific call in the device.
     *
     *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param CallInstanceOut Instance of the call that is terminated.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHangUpCall(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHangUpCallResponse (uint8 callInstanceOut, act_t act = 0);

    /**
     * The method sendHangUpCallError() sends an error response of a previous
     * method invocation of 'HangUpCall' back to the client.
     *
     * <b>Documentation of 'HangUpCall'</b>:
     *
     * This method is used to hangup a specific call in the device.
     *
     *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHangUpCall(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHangUpCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SpeedDial'

    /**
     * The method onSpeedDial() is called by ASF when a client invokes the
     * method 'SpeedDial'. A subclass has to implement this method and send
     * back a response to the client either with the sendSpeedDial() or
     * sendSpeedDialError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SpeedDial'</b>:
     *
     * Initiates a new outgoing call by number index.
     *
     *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSpeedDialRequest (const ::boost::shared_ptr< SpeedDialRequest >& request) = 0;

    /**
     * The method sendSpeedDialResponse() sends a response of a previous
     * method invocation of 'SpeedDial' back to the client.
     *
     * <b>Documentation of 'SpeedDial'</b>:
     *
     * Initiates a new outgoing call by number index.
     *
     *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param CallInstance Instance of the speed - dialed call.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSpeedDial(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSpeedDialResponse (uint8 callInstance, act_t act = 0);

    /**
     * The method sendSpeedDialError() sends an error response of a previous
     * method invocation of 'SpeedDial' back to the client.
     *
     * <b>Documentation of 'SpeedDial'</b>:
     *
     * Initiates a new outgoing call by number index.
     *
     *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSpeedDial(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSpeedDialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SendDTMF'

    /**
     * The method onSendDTMF() is called by ASF when a client invokes the
     * method 'SendDTMF'. A subclass has to implement this method and send
     * back a response to the client either with the sendSendDTMF() or
     * sendSendDTMFError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SendDTMF'</b>:
     *
     * Sends DTMF tones to the network. The tones have a fixed duration.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendDTMFRequest (const ::boost::shared_ptr< SendDTMFRequest >& request) = 0;

    /**
     * The method sendSendDTMFResponse() sends a response of a previous method
     * invocation of 'SendDTMF' back to the client.
     *
     * <b>Documentation of 'SendDTMF'</b>:
     *
     * Sends DTMF tones to the network. The tones have a fixed duration.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendDTMF(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendDTMFResponse (act_t act = 0);

    /**
     * The method sendSendDTMFError() sends an error response of a previous
     * method invocation of 'SendDTMF' back to the client.
     *
     * <b>Documentation of 'SendDTMF'</b>:
     *
     * Sends DTMF tones to the network. The tones have a fixed duration.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendDTMF(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSendDTMFError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartStopWaitingMode'

    /**
     * The method onStartStopWaitingMode() is called by ASF when a client
     * invokes the method 'StartStopWaitingMode'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartStopWaitingMode() or sendStartStopWaitingModeError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'StartStopWaitingMode'</b>:
     *
     * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartStopWaitingModeRequest (const ::boost::shared_ptr< StartStopWaitingModeRequest >& request) = 0;

    /**
     * The method sendStartStopWaitingModeResponse() sends a response of a
     * previous method invocation of 'StartStopWaitingMode' back to the
     * client.
     *
     * <b>Documentation of 'StartStopWaitingMode'</b>:
     *
     * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartStopWaitingMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartStopWaitingModeResponse (act_t act = 0);

    /**
     * The method sendStartStopWaitingModeError() sends an error response of a
     * previous method invocation of 'StartStopWaitingMode' back to the
     * client.
     *
     * <b>Documentation of 'StartStopWaitingMode'</b>:
     *
     * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartStopWaitingMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartStopWaitingModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'TransferAudio'

    /**
     * The method onTransferAudio() is called by ASF when a client invokes the
     * method 'TransferAudio'. A subclass has to implement this method and
     * send back a response to the client either with the sendTransferAudio()
     * or sendTransferAudioError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'TransferAudio'</b>:
     *
     * Transfers the audio to AG or HF.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onTransferAudioRequest (const ::boost::shared_ptr< TransferAudioRequest >& request) = 0;

    /**
     * The method sendTransferAudioResponse() sends a response of a previous
     * method invocation of 'TransferAudio' back to the client.
     *
     * <b>Documentation of 'TransferAudio'</b>:
     *
     * Transfers the audio to AG or HF.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onTransferAudio(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendTransferAudioResponse (act_t act = 0);

    /**
     * The method sendTransferAudioError() sends an error response of a
     * previous method invocation of 'TransferAudio' back to the client.
     *
     * <b>Documentation of 'TransferAudio'</b>:
     *
     * Transfers the audio to AG or HF.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onTransferAudio(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTransferAudioError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SCOConnectionUpdate _SCOConnectionProperty;

    RingtoneMuteStateUpdate _RingtoneMuteStateProperty;

    WaitingModeStateUpdate _WaitingModeStateProperty;

    friend class VoiceCallStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace VoiceCall
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALLSTUB_H
