/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCall.h"
#include "com/bosch/pmapp/VoiceCallDBus.h"
#include "com/bosch/pmapp/VoiceCallJson.h"
#include "com/bosch/pmapp/VoiceCallStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCall {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceCall", VoiceCallStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Dial", 2 },
    { 8, "SendDTMF", 7 },
    { 8, "SwapCall", 4 },
    { 9, "SpeedDial", 6 },
    { 10, "AcceptCall", 3 },
    { 10, "HangUpCall", 5 },
    { 13, "GetProperties", 0 },
    { 13, "TransferAudio", 9 },
    { 18, "MuteUnmuteRingtone", 1 },
    { 20, "StartStopWaitingMode", 8 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 13, "SCOConnection", 0 },
    { 16, "WaitingModeState", 2 },
    { 17, "RingtoneMuteState", 1 },
};

class VoiceCallStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.pmapp.VoiceCall"),
          _logger(logger) {}

    virtual ~VoiceCallStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void VoiceCallStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 10, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'MuteUnmuteRingtone'

            LOG_DEBUG_STUB("process method '%s'", "MuteUnmuteRingtone");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteRingtoneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MuteUnmuteRingtone", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MuteUnmuteRingtoneRequest > payload = ::boost::static_pointer_cast<MuteUnmuteRingtoneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onMuteUnmuteRingtoneRequest(payload);
            return;
        }
        case 2: {

            // method 'Dial'

            LOG_DEBUG_STUB("process method '%s'", "Dial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Dial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DialRequest > payload = ::boost::static_pointer_cast<DialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onDialRequest(payload);
            return;
        }
        case 3: {

            // method 'AcceptCall'

            LOG_DEBUG_STUB("process method '%s'", "AcceptCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AcceptCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AcceptCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AcceptCallRequest > payload = ::boost::static_pointer_cast<AcceptCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onAcceptCallRequest(payload);
            return;
        }
        case 4: {

            // method 'SwapCall'

            LOG_DEBUG_STUB("process method '%s'", "SwapCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SwapCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SwapCallRequest > payload = ::boost::static_pointer_cast<SwapCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onSwapCallRequest(payload);
            return;
        }
        case 5: {

            // method 'HangUpCall'

            LOG_DEBUG_STUB("process method '%s'", "HangUpCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangUpCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HangUpCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HangUpCallRequest > payload = ::boost::static_pointer_cast<HangUpCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onHangUpCallRequest(payload);
            return;
        }
        case 6: {

            // method 'SpeedDial'

            LOG_DEBUG_STUB("process method '%s'", "SpeedDial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedDialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SpeedDial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SpeedDialRequest > payload = ::boost::static_pointer_cast<SpeedDialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onSpeedDialRequest(payload);
            return;
        }
        case 7: {

            // method 'SendDTMF'

            LOG_DEBUG_STUB("process method '%s'", "SendDTMF");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendDTMFRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendDTMF", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendDTMFRequest > payload = ::boost::static_pointer_cast<SendDTMFRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onSendDTMFRequest(payload);
            return;
        }
        case 8: {

            // method 'StartStopWaitingMode'

            LOG_DEBUG_STUB("process method '%s'", "StartStopWaitingMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopWaitingModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartStopWaitingMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartStopWaitingModeRequest > payload = ::boost::static_pointer_cast<StartStopWaitingModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onStartStopWaitingModeRequest(payload);
            return;
        }
        case 9: {

            // method 'TransferAudio'

            LOG_DEBUG_STUB("process method '%s'", "TransferAudio");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransferAudioRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "TransferAudio", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< TransferAudioRequest > payload = ::boost::static_pointer_cast<TransferAudioRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onTransferAudioRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* VoiceCallStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.pmapp.VoiceCall\">\n"
            "    <property access=\"read\" name=\"SCOConnection\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"RingtoneMuteState\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"WaitingModeState\" type=\"y\"/>\n"
            "    <method name=\"GetProperties\">\n"
            "      <doc>\n"
            "        <line>GetProperties = Get the properties of the VoiceCall Interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>---</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoiceCallProperties\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>VoiceCallProperties (of type VoiceCallPropertiesList) = Type representation of the parameter- Dict:</line>\n"
            "          <line>{ PropertyName : PropertyValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;SCOConnection&quot; : 0x01},</line>\n"
            "          <line>{&quot;RingtoneMuteState&quot; : true},</line>\n"
            "          <line>{&quot;WaitingModeState&quot; : 0x01}</line>\n"
            "          <line>}</line>\n"
            "          <line>VoiceCallPropertiesList = dictionary(key=STRING,value=VoiceCallVariant)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"MuteUnmuteRingtone\">\n"
            "      <doc>\n"
            "        <line>MuteUnmuteRingtone = This method allows the client to Mute / Unmute the playing ringtone.</line>\n"
            "        <line>The updated change will be provided by the property - 'RingtoneMuteState'.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"MuteState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>MuteState = TRUE - Enable ringtone mute.</line>\n"
            "          <line>FALSE - Disable ringtone mute.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Dial\">\n"
            "      <doc>\n"
            "        <line>Dial = Initiates a new outgoing call.</line>\n"
            "        <line>The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidFormat</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"dialInfo\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>dialInfo (of type DialInfo) = Type representation of the parameter- Dict:</line>\n"
            "          <line>{ ParamaterName : ParameterValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;TelephoneNumber:&quot; : &quot;9988774455&quot;}</line>\n"
            "          <line>{&quot;FirstName&quot; : &quot;AABBCCDD&quot;}</line>\n"
            "          <line>{&quot;LastName&quot; : &quot;EEFFGGHH&quot;}</line>\n"
            "          <line>{&quot;HideCallerID&quot; : 0x01}</line>\n"
            "          <line>{&quot;ContactId&quot; : 0x56}</line>\n"
            "          <line>}</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"CallInstance\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstance = Instance of the outgoing call placed</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AcceptCall\">\n"
            "      <doc>\n"
            "        <line>AcceptCall = This method could be invoked to:</line>\n"
            "        <line>- Answer an Incoming call (OR)</line>\n"
            "        <line>- Release currently active call (0 or more) and answer the currently waiting call (OR)</line>\n"
            "        <line>- Put the current call on hold and answer the waiting call</line>\n"
            "        <line></line>\n"
            "        <line>The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CallInstanceIn\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstanceIn = Instance of the incoming call that shall be accepted</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Operation\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Operation = The possible values are:</line>\n"
            "          <line>0x00 : ACCEPT - Answers the incoming call,</line>\n"
            "          <line>0x01 : RELEASE_AND_ACCEPT - Releases current active call (0 or more) and answer the</line>\n"
            "          <line>currently waiting call,</line>\n"
            "          <line>0x02 : HOLD_AND_ACCEPT - Puts the current call (including multi-party calls) on hold and</line>\n"
            "          <line>answers the currently waiting call.</line>\n"
            "          <line></line>\n"
            "          <line>When there exists an active call and then arrives a waiting call and if client invokes AcceptCall API</line>\n"
            "          <line>with the attribute - Operation as ACCEPT (0x00), then the accept request will be posted to stack for</line>\n"
            "          <line>the waiting call and the behavior would be: current active call will be put on hold and the waiting</line>\n"
            "          <line>call will be switched to active.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"CallInstanceOut\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstanceOut = Instance of the accepted call.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SwapCall\">\n"
            "      <doc>\n"
            "        <line>SwapCall = This method could be invoked to:</line>\n"
            "        <line>- Place all the calls (0 or more including calls in a multi-party conversation) that are</line>\n"
            "        <line>Active to Held, and all calls (0 or more) that are Held to Active (OR)</line>\n"
            "        <line>- Release the currently active call (0 or more) and activate any currently held calls.</line>\n"
            "        <line></line>\n"
            "        <line>After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.</line>\n"
            "        <line></line>\n"
            "        <line>Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting</line>\n"
            "        <line>calls exist.</line>\n"
            "        <line>Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in</line>\n"
            "        <line>the case of Held, Active and Waiting calls.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Operation\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Operation = The possible values of the parameter are:</line>\n"
            "          <line>0x00 - SWAP_CALLS - Swaps Active and Held calls,</line>\n"
            "          <line>0x01 - RELEASE_AND_SWAP - Releases currently active call (0 or more) and activates any currently held calls.</line>\n"
            "          <line>If the current active call is a multiparty call, then all parties in the multi-party call will be released.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"HangUpCall\">\n"
            "      <doc>\n"
            "        <line>HangUpCall = This method is used to hangup a specific call in the device.</line>\n"
            "        <line></line>\n"
            "        <line>After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CallInstanceIn\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstanceIn = Instance of the call that shall be terminated</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"CallInstanceOut\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstanceOut = Instance of the call that is terminated.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SpeedDial\">\n"
            "      <doc>\n"
            "        <line>SpeedDial = Initiates a new outgoing call by number index.</line>\n"
            "        <line></line>\n"
            "        <line>Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidFormat</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"MemDialIndex\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>MemDialIndex = The number index which stands for the quick dial key in the cellphone.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"HideCallerID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>HideCallerID = The possible values are:</line>\n"
            "          <line>0x00- Shows the CallerID,</line>\n"
            "          <line>0x01- Hides the CallerID,</line>\n"
            "          <line>0xFF- Default (Network) mode is used.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"CallInstance\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstance = Instance of the speed - dialed call.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SendDTMF\">\n"
            "      <doc>\n"
            "        <line>SendDTMF = Sends DTMF tones to the network. The tones have a fixed duration.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidFormat</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Tones\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>Tones = Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.</line>\n"
            "          <line>Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in</line>\n"
            "          <line>the description section.</line>\n"
            "          <line>Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartStopWaitingMode\">\n"
            "      <doc>\n"
            "        <line>StartStopWaitingMode = Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"WaitingModeAction\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>WaitingModeAction = The possible values are:</line>\n"
            "          <line>0x00 - Start waiting mode</line>\n"
            "          <line>0x01 - Stop waiting mode.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"TransferAudio\">\n"
            "      <doc>\n"
            "        <line>TransferAudio = Transfers the audio to AG or HF.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Path\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Path = The possible values are:</line>\n"
            "          <line>0x00 - Transfer the call to Handsfree(Vehicle)</line>\n"
            "          <line>0x01 - Transfer the call to Audio Gateway.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void VoiceCallStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<VoiceCallStub*>(getStub()))->onGetAll (properties);
}

void VoiceCallStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SCOConnection");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "RingtoneMuteState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "WaitingModeState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void VoiceCallStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SCOConnection");
            ::boost::shared_ptr< SCOConnectionGet > payload(new SCOConnectionGet());
            payload->setAct(act);
            static_cast<VoiceCallStub*>(getStub())->onSCOConnectionGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "RingtoneMuteState");
            ::boost::shared_ptr< RingtoneMuteStateGet > payload(new RingtoneMuteStateGet());
            payload->setAct(act);
            static_cast<VoiceCallStub*>(getStub())->onRingtoneMuteStateGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "WaitingModeState");
            ::boost::shared_ptr< WaitingModeStateGet > payload(new WaitingModeStateGet());
            payload->setAct(act);
            static_cast<VoiceCallStub*>(getStub())->onWaitingModeStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

VoiceCallStub::VoiceCallStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallStub::VoiceCallStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallStub::~VoiceCallStub() {
    delete _stubDelegate;
}

void VoiceCallStub::sendSCOConnectionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SCOConnectionUpdate payload(_SCOConnectionProperty);

        LOG_INFO ("-> send%s", "SCOConnectionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SCOConnection", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceCall", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SCOConnectionUpdate");
    }
}

void VoiceCallStub::onSCOConnectionGet(const ::boost::shared_ptr< SCOConnectionGet >& sCOConnection) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SCOConnectionGet", sCOConnection->getAct());
    sendSCOConnectionGetUpdate(_SCOConnectionProperty.getSCOConnection(), sCOConnection->getAct());
}

void VoiceCallStub::sendSCOConnectionGetUpdate(uint8 sCOConnection, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SCOConnectionGet payload(sCOConnection);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SCOConnectionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceCallStub::setSCOConnection(uint8 sCOConnection) {
    if(sCOConnection!=_SCOConnectionProperty.getSCOConnection()) {
        _SCOConnectionProperty.setSCOConnection(sCOConnection);
        sendSCOConnectionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 VoiceCallStub::getSCOConnection() const {
    return _SCOConnectionProperty.getSCOConnection();
}

void VoiceCallStub::sendRingtoneMuteStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RingtoneMuteStateUpdate payload(_RingtoneMuteStateProperty);

        LOG_INFO ("-> send%s", "RingtoneMuteStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RingtoneMuteState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceCall", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RingtoneMuteStateUpdate");
    }
}

void VoiceCallStub::onRingtoneMuteStateGet(const ::boost::shared_ptr< RingtoneMuteStateGet >& ringtoneMuteState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RingtoneMuteStateGet", ringtoneMuteState->getAct());
    sendRingtoneMuteStateGetUpdate(_RingtoneMuteStateProperty.getRingtoneMuteState(), ringtoneMuteState->getAct());
}

void VoiceCallStub::sendRingtoneMuteStateGetUpdate(bool ringtoneMuteState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RingtoneMuteStateGet payload(ringtoneMuteState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RingtoneMuteStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceCallStub::setRingtoneMuteState(bool ringtoneMuteState) {
    if(ringtoneMuteState!=_RingtoneMuteStateProperty.getRingtoneMuteState()) {
        _RingtoneMuteStateProperty.setRingtoneMuteState(ringtoneMuteState);
        sendRingtoneMuteStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool VoiceCallStub::getRingtoneMuteState() const {
    return _RingtoneMuteStateProperty.getRingtoneMuteState();
}

void VoiceCallStub::sendWaitingModeStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WaitingModeStateUpdate payload(_WaitingModeStateProperty);

        LOG_INFO ("-> send%s", "WaitingModeStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WaitingModeState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceCall", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WaitingModeStateUpdate");
    }
}

void VoiceCallStub::onWaitingModeStateGet(const ::boost::shared_ptr< WaitingModeStateGet >& waitingModeState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WaitingModeStateGet", waitingModeState->getAct());
    sendWaitingModeStateGetUpdate(_WaitingModeStateProperty.getWaitingModeState(), waitingModeState->getAct());
}

void VoiceCallStub::sendWaitingModeStateGetUpdate(uint8 waitingModeState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WaitingModeStateGet payload(waitingModeState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WaitingModeStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceCallStub::setWaitingModeState(uint8 waitingModeState) {
    if(waitingModeState!=_WaitingModeStateProperty.getWaitingModeState()) {
        _WaitingModeStateProperty.setWaitingModeState(waitingModeState);
        sendWaitingModeStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 VoiceCallStub::getWaitingModeState() const {
    return _WaitingModeStateProperty.getWaitingModeState();
}

void  VoiceCallStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& voiceCallProperties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(voiceCallProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendMuteUnmuteRingtoneResponse (act_t act) {
    MuteUnmuteRingtoneResponse* payload = new MuteUnmuteRingtoneResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "MuteUnmuteRingtone", MuteUnmuteRingtoneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MuteUnmuteRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendMuteUnmuteRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MuteUnmuteRingtoneError* payload = new MuteUnmuteRingtoneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MuteUnmuteRingtone", MuteUnmuteRingtoneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MuteUnmuteRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendDialResponse (uint8 callInstance, act_t act) {
    DialResponse* payload = new DialResponse(callInstance);
    DBUS_MESSAGE_REPLY(dbusMessage, "Dial", DialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Dial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendDialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DialError* payload = new DialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Dial", DialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Dial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendAcceptCallResponse (uint8 callInstanceOut, act_t act) {
    AcceptCallResponse* payload = new AcceptCallResponse(callInstanceOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "AcceptCall", AcceptCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AcceptCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendAcceptCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AcceptCallError* payload = new AcceptCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AcceptCall", AcceptCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AcceptCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSwapCallResponse (act_t act) {
    SwapCallResponse* payload = new SwapCallResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SwapCall", SwapCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SwapCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSwapCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SwapCallError* payload = new SwapCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SwapCall", SwapCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SwapCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHangUpCallResponse (uint8 callInstanceOut, act_t act) {
    HangUpCallResponse* payload = new HangUpCallResponse(callInstanceOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "HangUpCall", HangUpCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HangUpCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHangUpCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HangUpCallError* payload = new HangUpCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HangUpCall", HangUpCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HangUpCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSpeedDialResponse (uint8 callInstance, act_t act) {
    SpeedDialResponse* payload = new SpeedDialResponse(callInstance);
    DBUS_MESSAGE_REPLY(dbusMessage, "SpeedDial", SpeedDialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SpeedDial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSpeedDialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SpeedDialError* payload = new SpeedDialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SpeedDial", SpeedDialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SpeedDial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSendDTMFResponse (act_t act) {
    SendDTMFResponse* payload = new SendDTMFResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendDTMF", SendDTMFResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendDTMF", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendSendDTMFError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendDTMFError* payload = new SendDTMFError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendDTMF", SendDTMFError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendDTMF", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendStartStopWaitingModeResponse (act_t act) {
    StartStopWaitingModeResponse* payload = new StartStopWaitingModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartStopWaitingMode", StartStopWaitingModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartStopWaitingMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendStartStopWaitingModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartStopWaitingModeError* payload = new StartStopWaitingModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartStopWaitingMode", StartStopWaitingModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartStopWaitingMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendTransferAudioResponse (act_t act) {
    TransferAudioResponse* payload = new TransferAudioResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "TransferAudio", TransferAudioResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "TransferAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendTransferAudioError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    TransferAudioError* payload = new TransferAudioError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "TransferAudio", TransferAudioError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "TransferAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void VoiceCallStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SCOConnection'
    {
        ::asf::dbus::DBusVariant variant;
        SCOConnectionGet payload(_SCOConnectionProperty.getSCOConnection());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SCOConnection", variant));
    }

    //property 'RingtoneMuteState'
    {
        ::asf::dbus::DBusVariant variant;
        RingtoneMuteStateGet payload(_RingtoneMuteStateProperty.getRingtoneMuteState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RingtoneMuteState", variant));
    }

    //property 'WaitingModeState'
    {
        ::asf::dbus::DBusVariant variant;
        WaitingModeStateGet payload(_WaitingModeStateProperty.getWaitingModeState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WaitingModeState", variant));
    }
}

} // namespace VoiceCall
} // namespace pmapp
} // namespace bosch
} // namespace com
