/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALLPROXY_H
#define COM_BOSCH_PMAPP_VOICECALLPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCall.h"
#include <dbus/dbus.h>
#include <string>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCall {

class VoiceCallProxy;

class AcceptCallCallbackIF {
public:
    virtual ~AcceptCallCallbackIF() {}

    virtual void onAcceptCallError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AcceptCallError >& error) = 0;

    virtual void onAcceptCallResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AcceptCallResponse >& response) = 0;
};

class DialCallbackIF {
public:
    virtual ~DialCallbackIF() {}

    virtual void onDialError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< DialError >& error) = 0;

    virtual void onDialResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< DialResponse >& response) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class HangUpCallCallbackIF {
public:
    virtual ~HangUpCallCallbackIF() {}

    virtual void onHangUpCallError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangUpCallError >& error) = 0;

    virtual void onHangUpCallResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangUpCallResponse >& response) = 0;
};

class MuteUnmuteRingtoneCallbackIF {
public:
    virtual ~MuteUnmuteRingtoneCallbackIF() {}

    virtual void onMuteUnmuteRingtoneError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< MuteUnmuteRingtoneError >& error) = 0;

    virtual void onMuteUnmuteRingtoneResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< MuteUnmuteRingtoneResponse >& response) = 0;
};

class RingtoneMuteStateCallbackIF {
public:
    virtual ~RingtoneMuteStateCallbackIF() {}

    virtual void onRingtoneMuteStateError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< RingtoneMuteStateError >& error) = 0;

    virtual void onRingtoneMuteStateUpdate(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< RingtoneMuteStateUpdate >& update) = 0;
};

class SCOConnectionCallbackIF {
public:
    virtual ~SCOConnectionCallbackIF() {}

    virtual void onSCOConnectionError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SCOConnectionError >& error) = 0;

    virtual void onSCOConnectionUpdate(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SCOConnectionUpdate >& update) = 0;
};

class SendDTMFCallbackIF {
public:
    virtual ~SendDTMFCallbackIF() {}

    virtual void onSendDTMFError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SendDTMFError >& error) = 0;

    virtual void onSendDTMFResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SendDTMFResponse >& response) = 0;
};

class SpeedDialCallbackIF {
public:
    virtual ~SpeedDialCallbackIF() {}

    virtual void onSpeedDialError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SpeedDialError >& error) = 0;

    virtual void onSpeedDialResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SpeedDialResponse >& response) = 0;
};

class StartStopWaitingModeCallbackIF {
public:
    virtual ~StartStopWaitingModeCallbackIF() {}

    virtual void onStartStopWaitingModeError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< StartStopWaitingModeError >& error) = 0;

    virtual void onStartStopWaitingModeResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< StartStopWaitingModeResponse >& response) = 0;
};

class SwapCallCallbackIF {
public:
    virtual ~SwapCallCallbackIF() {}

    virtual void onSwapCallError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SwapCallError >& error) = 0;

    virtual void onSwapCallResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< SwapCallResponse >& response) = 0;
};

class TransferAudioCallbackIF {
public:
    virtual ~TransferAudioCallbackIF() {}

    virtual void onTransferAudioError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< TransferAudioError >& error) = 0;

    virtual void onTransferAudioResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< TransferAudioResponse >& response) = 0;
};

class WaitingModeStateCallbackIF {
public:
    virtual ~WaitingModeStateCallbackIF() {}

    virtual void onWaitingModeStateError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< WaitingModeStateError >& error) = 0;

    virtual void onWaitingModeStateUpdate(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< WaitingModeStateUpdate >& update) = 0;
};


/**
 * VoiceCallProxy is the client side representation of the D-Bus service
 * interface 'com.bosch.pmapp.VoiceCall' (specified in file
 * pmapp_voice_call_.xml).
 *
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of the HFP connected device is - "aabbccddeeff", then the corresponding  VoiceCall interface
 *     will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */
class VoiceCallProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of VoiceCallProxy.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of VoiceCallProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of VoiceCallProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< VoiceCallProxy > proxyNew(new VoiceCallProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~VoiceCallProxy ();



    // Property 'SCOConnection'

    /**
     * Notify on the property 'SCOConnection'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSCOConnectionRegister(SCOConnectionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SCOConnection'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @param act The act which was previously returned by the
     * sendSCOConnectionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSCOConnectionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SCOConnection'.
     */
    void sendSCOConnectionDeregisterAll() const;

    /**
     * Request the value of the property 'SCOConnection' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SCOConnection'</b>:
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSCOConnectionGet(SCOConnectionCallbackIF& cb);


    /**
     * Returns the current value of the property 'SCOConnection' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSCOConnection() returns true.
     *
     * @return the previously received value of the property 'SCOConnection'.
     */
    uint8 getSCOConnection() const;

    /**
     * Determines whether a status message for the property 'SCOConnection'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSCOConnection() const;

    // Property 'RingtoneMuteState'

    /**
     * Notify on the property 'RingtoneMuteState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtoneMuteStateRegister(RingtoneMuteStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RingtoneMuteState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @param act The act which was previously returned by the
     * sendRingtoneMuteStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRingtoneMuteStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RingtoneMuteState'.
     */
    void sendRingtoneMuteStateDeregisterAll() const;

    /**
     * Request the value of the property 'RingtoneMuteState' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RingtoneMuteState'</b>:
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRingtoneMuteStateGet(RingtoneMuteStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'RingtoneMuteState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRingtoneMuteState() returns true.
     *
     * @return the previously received value of the property 'RingtoneMuteState'.
     */
    bool getRingtoneMuteState() const;

    /**
     * Determines whether a status message for the property
     * 'RingtoneMuteState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRingtoneMuteState() const;

    // Property 'WaitingModeState'

    /**
     * Notify on the property 'WaitingModeState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeStateRegister(WaitingModeStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WaitingModeState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @param act The act which was previously returned by the
     * sendWaitingModeStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWaitingModeStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WaitingModeState'.
     */
    void sendWaitingModeStateDeregisterAll() const;

    /**
     * Request the value of the property 'WaitingModeState' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WaitingModeState'</b>:
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeStateGet(WaitingModeStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'WaitingModeState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWaitingModeState() returns true.
     *
     * @return the previously received value of the property 'WaitingModeState'.
     */
    uint8 getWaitingModeState() const;

    /**
     * Determines whether a status message for the property 'WaitingModeState'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWaitingModeState() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the VoiceCall Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'MuteUnmuteRingtone'

    /**
     * Call the method 'MuteUnmuteRingtone'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'MuteUnmuteRingtone'</b>:
     *
     * This method allows the client to Mute / Unmute the playing ringtone.
     *         The updated change will be provided by the property - 'RingtoneMuteState'.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param MuteState TRUE - Enable ringtone mute.
     *                 FALSE - Disable ringtone mute.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteUnmuteRingtoneRequest(MuteUnmuteRingtoneCallbackIF& cb, bool muteState) const;

    // Method 'Dial'

    /**
     * Call the method 'Dial'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * Initiates a new outgoing call.
     *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param dialInfo Type representation of the parameter- Dict:
     *                   { ParamaterName : ParameterValue }
     *
     *                 Example:
     *                   {
     *                   {"TelephoneNumber:" : "9988774455"}
     *                   {"FirstName" : "AABBCCDD"}
     *                   {"LastName" : "EEFFGGHH"}
     *                   {"HideCallerID" : 0x01}
     *                   {"ContactId" : 0x56}
     *                 }
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDialRequest(DialCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo) const;

    // Method 'AcceptCall'

    /**
     * Call the method 'AcceptCall'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'AcceptCall'</b>:
     *
     * This method could be invoked to:
     *             - Answer an Incoming call (OR)
     *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
     *             - Put the current call on hold and answer the waiting call
     *
     *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param CallInstanceIn Instance of the incoming call that shall be accepted
     *
     * @param Operation The possible values are:
     *                     0x00 : ACCEPT - Answers the incoming call,
     *                     0x01 : RELEASE_AND_ACCEPT - Releases current active call (0 or more) and answer the
     *                     currently waiting call,
     *                     0x02 : HOLD_AND_ACCEPT - Puts the current call (including multi-party calls) on hold and
     *                     answers the currently waiting call.
     *
     *                 When there exists an active call and then arrives a waiting call and if client invokes AcceptCall API
     *                 with the attribute - Operation as ACCEPT (0x00), then the accept request will be posted to stack for
     *                 the waiting call and the behavior would be: current active call will be put on hold and the waiting
     *                 call will be switched to active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcceptCallRequest(AcceptCallCallbackIF& cb, uint8 callInstanceIn, uint8 operation) const;

    // Method 'SwapCall'

    /**
     * Call the method 'SwapCall'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SwapCall'</b>:
     *
     * This method could be invoked to:
     *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
     *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
     *              - Release the currently active call (0 or more) and activate any currently held calls.
     *
     *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
     *         calls exist.
     *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
     *         the case of Held, Active and Waiting calls.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Operation The possible values of the parameter are:
     *                     0x00 - SWAP_CALLS - Swaps Active and Held calls,
     *                     0x01 - RELEASE_AND_SWAP - Releases currently active call (0 or more) and activates any currently held calls.
     *                     If the current active call is a multiparty call, then all parties in the multi-party call will be released.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwapCallRequest(SwapCallCallbackIF& cb, uint8 operation) const;

    // Method 'HangUpCall'

    /**
     * Call the method 'HangUpCall'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'HangUpCall'</b>:
     *
     * This method is used to hangup a specific call in the device.
     *
     *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param CallInstanceIn Instance of the call that shall be terminated
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHangUpCallRequest(HangUpCallCallbackIF& cb, uint8 callInstanceIn) const;

    // Method 'SpeedDial'

    /**
     * Call the method 'SpeedDial'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SpeedDial'</b>:
     *
     * Initiates a new outgoing call by number index.
     *
     *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param MemDialIndex The number index which stands for the quick dial key in the cellphone.
     *
     * @param HideCallerID The possible values are:
     *                     0x00- Shows the CallerID,
     *                     0x01- Hides the CallerID,
     *                     0xFF- Default (Network) mode is used.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedDialRequest(SpeedDialCallbackIF& cb, uint8 memDialIndex, uint8 hideCallerID) const;

    // Method 'SendDTMF'

    /**
     * Call the method 'SendDTMF'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SendDTMF'</b>:
     *
     * Sends DTMF tones to the network. The tones have a fixed duration.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Tones Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.
     *                 Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in
     *                 the description section.
     *                 Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendDTMFRequest(SendDTMFCallbackIF& cb, const ::std::string& tones) const;

    // Method 'StartStopWaitingMode'

    /**
     * Call the method 'StartStopWaitingMode'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'StartStopWaitingMode'</b>:
     *
     * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param WaitingModeAction The possible values are:
     *                 0x00 - Start waiting mode
     *                 0x01 - Stop waiting mode.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartStopWaitingModeRequest(StartStopWaitingModeCallbackIF& cb, uint8 waitingModeAction) const;

    // Method 'TransferAudio'

    /**
     * Call the method 'TransferAudio'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'TransferAudio'</b>:
     *
     * Transfers the audio to AG or HF.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Path The possible values are:
     *                 0x00 - Transfer the call to Handsfree(Vehicle)
     *                 0x01 - Transfer the call to Audio Gateway.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransferAudioRequest(TransferAudioCallbackIF& cb, uint8 path) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    VoiceCallProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'SCOConnection'

    ::asf::core::nullable< SCOConnectionUpdate > _sCOConnection;

    // Property 'RingtoneMuteState'

    ::asf::core::nullable< RingtoneMuteStateUpdate > _ringtoneMuteState;

    // Property 'WaitingModeState'

    ::asf::core::nullable< WaitingModeStateUpdate > _waitingModeState;

    DECLARE_CLASS_LOGGER();

    friend class VoiceCallProxyCallback;
};

} // namespace VoiceCall
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALLPROXY_H
