/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCall.h"
#include "com/bosch/pmapp/VoiceCallDBus.h"
#include "com/bosch/pmapp/VoiceCallJson.h"
#include "com/bosch/pmapp/VoiceCallProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCall {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceCall", VoiceCallProxy);

class VoiceCallProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    VoiceCallProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< VoiceCallProxy >& proxyShared = ::boost::static_pointer_cast< VoiceCallProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SCOConnection:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SCOConnectionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SCOConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SCOConnectionError> payload = ::boost::static_pointer_cast<SCOConnectionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SCOConnectionCallbackIF*) _callback)->onSCOConnectionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SCOConnectionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SCOConnection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SCOConnectionUpdate> payload = ::boost::static_pointer_cast<SCOConnectionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SCOConnectionCallbackIF*) _callback)->onSCOConnectionUpdate(proxyShared, payload);
                        proxyShared->_sCOConnection = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RingtoneMuteState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RingtoneMuteStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RingtoneMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RingtoneMuteStateError> payload = ::boost::static_pointer_cast<RingtoneMuteStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RingtoneMuteStateCallbackIF*) _callback)->onRingtoneMuteStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RingtoneMuteStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RingtoneMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RingtoneMuteStateUpdate> payload = ::boost::static_pointer_cast<RingtoneMuteStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RingtoneMuteStateCallbackIF*) _callback)->onRingtoneMuteStateUpdate(proxyShared, payload);
                        proxyShared->_ringtoneMuteState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WaitingModeState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaitingModeStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaitingModeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaitingModeStateError> payload = ::boost::static_pointer_cast<WaitingModeStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WaitingModeStateCallbackIF*) _callback)->onWaitingModeStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaitingModeStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaitingModeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaitingModeStateUpdate> payload = ::boost::static_pointer_cast<WaitingModeStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WaitingModeStateCallbackIF*) _callback)->onWaitingModeStateUpdate(proxyShared, payload);
                        proxyShared->_waitingModeState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MuteUnmuteRingtone:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteRingtoneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteUnmuteRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteUnmuteRingtoneError> payload = ::boost::static_pointer_cast<MuteUnmuteRingtoneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteUnmuteRingtoneCallbackIF*) _callback)->onMuteUnmuteRingtoneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteRingtoneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteUnmuteRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteUnmuteRingtoneResponse> payload = ::boost::static_pointer_cast<MuteUnmuteRingtoneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteUnmuteRingtoneCallbackIF*) _callback)->onMuteUnmuteRingtoneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Dial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DialError> payload = ::boost::static_pointer_cast<DialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DialCallbackIF*) _callback)->onDialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DialResponse> payload = ::boost::static_pointer_cast<DialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DialCallbackIF*) _callback)->onDialResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AcceptCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AcceptCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AcceptCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AcceptCallError> payload = ::boost::static_pointer_cast<AcceptCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AcceptCallCallbackIF*) _callback)->onAcceptCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AcceptCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AcceptCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AcceptCallResponse> payload = ::boost::static_pointer_cast<AcceptCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AcceptCallCallbackIF*) _callback)->onAcceptCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SwapCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwapCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwapCallError> payload = ::boost::static_pointer_cast<SwapCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwapCallCallbackIF*) _callback)->onSwapCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwapCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwapCallResponse> payload = ::boost::static_pointer_cast<SwapCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwapCallCallbackIF*) _callback)->onSwapCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HangUpCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HangUpCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangUpCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangUpCallError> payload = ::boost::static_pointer_cast<HangUpCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangUpCallCallbackIF*) _callback)->onHangUpCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangUpCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangUpCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangUpCallResponse> payload = ::boost::static_pointer_cast<HangUpCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangUpCallCallbackIF*) _callback)->onHangUpCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SpeedDial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SpeedDialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeedDial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedDialError> payload = ::boost::static_pointer_cast<SpeedDialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeedDialCallbackIF*) _callback)->onSpeedDialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedDialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeedDial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedDialResponse> payload = ::boost::static_pointer_cast<SpeedDialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeedDialCallbackIF*) _callback)->onSpeedDialResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SendDTMF:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendDTMFError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendDTMF", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendDTMFError> payload = ::boost::static_pointer_cast<SendDTMFError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendDTMFCallbackIF*) _callback)->onSendDTMFError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendDTMFResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendDTMF", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendDTMFResponse> payload = ::boost::static_pointer_cast<SendDTMFResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendDTMFCallbackIF*) _callback)->onSendDTMFResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartStopWaitingMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartStopWaitingModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopWaitingMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopWaitingModeError> payload = ::boost::static_pointer_cast<StartStopWaitingModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopWaitingModeCallbackIF*) _callback)->onStartStopWaitingModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopWaitingModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopWaitingMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopWaitingModeResponse> payload = ::boost::static_pointer_cast<StartStopWaitingModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopWaitingModeCallbackIF*) _callback)->onStartStopWaitingModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_TransferAudio:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), TransferAudioError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TransferAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransferAudioError> payload = ::boost::static_pointer_cast<TransferAudioError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TransferAudioCallbackIF*) _callback)->onTransferAudioError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransferAudioResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "TransferAudio", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransferAudioResponse> payload = ::boost::static_pointer_cast<TransferAudioResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TransferAudioCallbackIF*) _callback)->onTransferAudioResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SCOConnection: {
                ::boost::shared_ptr< SCOConnectionError > payload = ::boost::shared_ptr< SCOConnectionError >
                (new SCOConnectionError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SCOConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SCOConnectionCallbackIF*) _callback)->onSCOConnectionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RingtoneMuteState: {
                ::boost::shared_ptr< RingtoneMuteStateError > payload = ::boost::shared_ptr< RingtoneMuteStateError >
                (new RingtoneMuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RingtoneMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RingtoneMuteStateCallbackIF*) _callback)->onRingtoneMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WaitingModeState: {
                ::boost::shared_ptr< WaitingModeStateError > payload = ::boost::shared_ptr< WaitingModeStateError >
                (new WaitingModeStateError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WaitingModeState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WaitingModeStateCallbackIF*) _callback)->onWaitingModeStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MuteUnmuteRingtone: {
                ::boost::shared_ptr< MuteUnmuteRingtoneError > payload = ::boost::shared_ptr< MuteUnmuteRingtoneError >
                (new MuteUnmuteRingtoneError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MuteUnmuteRingtone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MuteUnmuteRingtoneCallbackIF*) _callback)->onMuteUnmuteRingtoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Dial: {
                ::boost::shared_ptr< DialError > payload = ::boost::shared_ptr< DialError >
                (new DialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Dial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DialCallbackIF*) _callback)->onDialError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AcceptCall: {
                ::boost::shared_ptr< AcceptCallError > payload = ::boost::shared_ptr< AcceptCallError >
                (new AcceptCallError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AcceptCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AcceptCallCallbackIF*) _callback)->onAcceptCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SwapCall: {
                ::boost::shared_ptr< SwapCallError > payload = ::boost::shared_ptr< SwapCallError >
                (new SwapCallError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SwapCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SwapCallCallbackIF*) _callback)->onSwapCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HangUpCall: {
                ::boost::shared_ptr< HangUpCallError > payload = ::boost::shared_ptr< HangUpCallError >
                (new HangUpCallError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HangUpCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HangUpCallCallbackIF*) _callback)->onHangUpCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SpeedDial: {
                ::boost::shared_ptr< SpeedDialError > payload = ::boost::shared_ptr< SpeedDialError >
                (new SpeedDialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeedDial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeedDialCallbackIF*) _callback)->onSpeedDialError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendDTMF: {
                ::boost::shared_ptr< SendDTMFError > payload = ::boost::shared_ptr< SendDTMFError >
                (new SendDTMFError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendDTMF", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendDTMFCallbackIF*) _callback)->onSendDTMFError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartStopWaitingMode: {
                ::boost::shared_ptr< StartStopWaitingModeError > payload = ::boost::shared_ptr< StartStopWaitingModeError >
                (new StartStopWaitingModeError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartStopWaitingMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartStopWaitingModeCallbackIF*) _callback)->onStartStopWaitingModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TransferAudio: {
                ::boost::shared_ptr< TransferAudioError > payload = ::boost::shared_ptr< TransferAudioError >
                (new TransferAudioError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCall is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TransferAudio", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TransferAudioCallbackIF*) _callback)->onTransferAudioError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& VoiceCallProxyCallback::_logger (VoiceCallProxy::_logger);

VoiceCallProxy::VoiceCallProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.pmapp.VoiceCall", serviceAvailable, _logger) {
}

VoiceCallProxy::~VoiceCallProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< VoiceCallProxy > VoiceCallProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<VoiceCallProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< VoiceCallProxy > proxyNew(new VoiceCallProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t VoiceCallProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t VoiceCallProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void VoiceCallProxy::clearAllProperties ()
{
    _sCOConnection = ::asf::core::nullable< SCOConnectionUpdate >();
    _ringtoneMuteState = ::asf::core::nullable< RingtoneMuteStateUpdate >();
    _waitingModeState = ::asf::core::nullable< WaitingModeStateUpdate >();
}

void VoiceCallProxy::sendDeregisterAll () const
{
    sendSCOConnectionDeregisterAll();
    sendRingtoneMuteStateDeregisterAll();
    sendWaitingModeStateDeregisterAll();
}

act_t VoiceCallProxy::sendSCOConnectionRegister(SCOConnectionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SCOConnection, "SCOConnection", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SCOConnection", &cb, act);
    return act;
}

bool VoiceCallProxy::sendSCOConnectionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SCOConnection", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SCOConnection", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceCallProxy::sendSCOConnectionGet(SCOConnectionCallbackIF& cb) {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(ID_SCOConnection, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SCOConnection", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SCOConnection", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 VoiceCallProxy::getSCOConnection() const {
    return _sCOConnection.get().getSCOConnection();
}

bool VoiceCallProxy::hasSCOConnection() const {
    return _sCOConnection.hasValue();
}

void VoiceCallProxy::sendSCOConnectionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SCOConnection");
    _dbusProxyDelegate->deregisterSignalCallback("SCOConnection", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceCallProxy::sendRingtoneMuteStateRegister(RingtoneMuteStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RingtoneMuteState, "RingtoneMuteState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RingtoneMuteState", &cb, act);
    return act;
}

bool VoiceCallProxy::sendRingtoneMuteStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RingtoneMuteState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RingtoneMuteState", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceCallProxy::sendRingtoneMuteStateGet(RingtoneMuteStateCallbackIF& cb) {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(ID_RingtoneMuteState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RingtoneMuteState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RingtoneMuteState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool VoiceCallProxy::getRingtoneMuteState() const {
    return _ringtoneMuteState.get().getRingtoneMuteState();
}

bool VoiceCallProxy::hasRingtoneMuteState() const {
    return _ringtoneMuteState.hasValue();
}

void VoiceCallProxy::sendRingtoneMuteStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RingtoneMuteState");
    _dbusProxyDelegate->deregisterSignalCallback("RingtoneMuteState", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceCallProxy::sendWaitingModeStateRegister(WaitingModeStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WaitingModeState, "WaitingModeState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WaitingModeState", &cb, act);
    return act;
}

bool VoiceCallProxy::sendWaitingModeStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WaitingModeState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WaitingModeState", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceCallProxy::sendWaitingModeStateGet(WaitingModeStateCallbackIF& cb) {
    VoiceCallProxyCallback* callback = new VoiceCallProxyCallback(ID_WaitingModeState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WaitingModeState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WaitingModeState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 VoiceCallProxy::getWaitingModeState() const {
    return _waitingModeState.get().getWaitingModeState();
}

bool VoiceCallProxy::hasWaitingModeState() const {
    return _waitingModeState.hasValue();
}

void VoiceCallProxy::sendWaitingModeStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WaitingModeState");
    _dbusProxyDelegate->deregisterSignalCallback("WaitingModeState", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceCallProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendMuteUnmuteRingtoneRequest(MuteUnmuteRingtoneCallbackIF& cb, bool muteState) const {
    MuteUnmuteRingtoneRequest* payload = new MuteUnmuteRingtoneRequest();
    CHECK_ALLOCATION(payload);
    payload->setMuteState(muteState);
    DBUS_MESSAGE_CALL(dbusMessage, "MuteUnmuteRingtone", MuteUnmuteRingtoneRequest, payload, true)
    act_t act = addMethodCallback(ID_MuteUnmuteRingtone, dbusMessage.getUniqueSerial(), "MuteUnmuteRingtone", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MuteUnmuteRingtone", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendDialRequest(DialCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo) const {
    DialRequest* payload = new DialRequest();
    CHECK_ALLOCATION(payload);
    payload->setDialInfo(dialInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "Dial", DialRequest, payload, true)
    act_t act = addMethodCallback(ID_Dial, dbusMessage.getUniqueSerial(), "Dial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Dial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendAcceptCallRequest(AcceptCallCallbackIF& cb, uint8 callInstanceIn, uint8 operation) const {
    AcceptCallRequest* payload = new AcceptCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setCallInstanceIn(callInstanceIn);
    payload->setOperation(operation);
    DBUS_MESSAGE_CALL(dbusMessage, "AcceptCall", AcceptCallRequest, payload, true)
    act_t act = addMethodCallback(ID_AcceptCall, dbusMessage.getUniqueSerial(), "AcceptCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AcceptCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendSwapCallRequest(SwapCallCallbackIF& cb, uint8 operation) const {
    SwapCallRequest* payload = new SwapCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setOperation(operation);
    DBUS_MESSAGE_CALL(dbusMessage, "SwapCall", SwapCallRequest, payload, true)
    act_t act = addMethodCallback(ID_SwapCall, dbusMessage.getUniqueSerial(), "SwapCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SwapCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendHangUpCallRequest(HangUpCallCallbackIF& cb, uint8 callInstanceIn) const {
    HangUpCallRequest* payload = new HangUpCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setCallInstanceIn(callInstanceIn);
    DBUS_MESSAGE_CALL(dbusMessage, "HangUpCall", HangUpCallRequest, payload, true)
    act_t act = addMethodCallback(ID_HangUpCall, dbusMessage.getUniqueSerial(), "HangUpCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HangUpCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendSpeedDialRequest(SpeedDialCallbackIF& cb, uint8 memDialIndex, uint8 hideCallerID) const {
    SpeedDialRequest* payload = new SpeedDialRequest();
    CHECK_ALLOCATION(payload);
    payload->setMemDialIndex(memDialIndex);
    payload->setHideCallerID(hideCallerID);
    DBUS_MESSAGE_CALL(dbusMessage, "SpeedDial", SpeedDialRequest, payload, true)
    act_t act = addMethodCallback(ID_SpeedDial, dbusMessage.getUniqueSerial(), "SpeedDial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SpeedDial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendSendDTMFRequest(SendDTMFCallbackIF& cb, const ::std::string& tones) const {
    SendDTMFRequest* payload = new SendDTMFRequest();
    CHECK_ALLOCATION(payload);
    payload->setTones(tones);
    DBUS_MESSAGE_CALL(dbusMessage, "SendDTMF", SendDTMFRequest, payload, true)
    act_t act = addMethodCallback(ID_SendDTMF, dbusMessage.getUniqueSerial(), "SendDTMF", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendDTMF", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendStartStopWaitingModeRequest(StartStopWaitingModeCallbackIF& cb, uint8 waitingModeAction) const {
    StartStopWaitingModeRequest* payload = new StartStopWaitingModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setWaitingModeAction(waitingModeAction);
    DBUS_MESSAGE_CALL(dbusMessage, "StartStopWaitingMode", StartStopWaitingModeRequest, payload, true)
    act_t act = addMethodCallback(ID_StartStopWaitingMode, dbusMessage.getUniqueSerial(), "StartStopWaitingMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartStopWaitingMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallProxy::sendTransferAudioRequest(TransferAudioCallbackIF& cb, uint8 path) const {
    TransferAudioRequest* payload = new TransferAudioRequest();
    CHECK_ALLOCATION(payload);
    payload->setPath(path);
    DBUS_MESSAGE_CALL(dbusMessage, "TransferAudio", TransferAudioRequest, payload, true)
    act_t act = addMethodCallback(ID_TransferAudio, dbusMessage.getUniqueSerial(), "TransferAudio", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "TransferAudio", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace VoiceCall
} // namespace pmapp
} // namespace bosch
} // namespace com
