/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALLMANAGERSTUB_H
#define COM_BOSCH_PMAPP_VOICECALLMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCallManager.h"
#include <map>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCallManager {

class VoiceCallManagerStubDelegate;

class VoiceCallManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the VoiceCallManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    VoiceCallManagerStub (const std::string& portName);

    /**
     * Create an instance of the VoiceCallManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    VoiceCallManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~VoiceCallManagerStub();

    // property 'CallStatusList'

    /**
     * The method onCallStatusListGet() is called by ASF when a client invokes
     * the read method for the property 'CallStatusList'. The
     * onCallStatusListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     */
    virtual void onCallStatusListGet(const ::boost::shared_ptr< CallStatusListGet >& payload);

    /**
     * Sends back the update to a previous onCallStatusListGet().
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @param act Identifies a previous invocation of onCallStatusListGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCallStatusListGetUpdate(const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& callStatusList, act_t act = 0);

    /**
     * Set the value of the property 'CallStatusList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     */
    void setCallStatusList(const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& callStatusList);

    /**
     * Returns the current value of the property 'CallStatusList'.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     */
    const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getCallStatusList() const;

    /**
     * Returns the current value of the property 'CallStatusList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCallStatusListUpdate() method.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     */
    ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getCallStatusListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCallStatusListUpdate().
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     */
    void sendCallStatusListUpdate();

    // property 'MicrophoneMuteState'

    /**
     * The method onMicrophoneMuteStateGet() is called by ASF when a client
     * invokes the read method for the property 'MicrophoneMuteState'. The
     * onMicrophoneMuteStateGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     */
    virtual void onMicrophoneMuteStateGet(const ::boost::shared_ptr< MicrophoneMuteStateGet >& payload);

    /**
     * Sends back the update to a previous onMicrophoneMuteStateGet().
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @param act Identifies a previous invocation of
     * onMicrophoneMuteStateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMicrophoneMuteStateGetUpdate(bool microphoneMuteState, act_t act = 0);

    /**
     * Set the value of the property 'MicrophoneMuteState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     */
    void setMicrophoneMuteState(bool microphoneMuteState);

    /**
     * Returns the current value of the property 'MicrophoneMuteState'.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     */
    bool getMicrophoneMuteState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMicrophoneMuteStateUpdate().
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     */
    void sendMicrophoneMuteStateUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all properties of the VoiceCallManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all properties of the VoiceCallManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param VoiceCallManagerProperties Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"MicrophoneMuteState" : false},
     *                   {"CallStatusList" : Refer callStatusList Property}
     *                 }
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& voiceCallManagerProperties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all properties of the VoiceCallManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MuteUnmuteMicrophone'

    /**
     * The method onMuteUnmuteMicrophone() is called by ASF when a client
     * invokes the method 'MuteUnmuteMicrophone'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendMuteUnmuteMicrophone() or sendMuteUnmuteMicrophoneError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'MuteUnmuteMicrophone'</b>:
     *
     * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
     *         The updated change will be provided by the property - 'MicrophoneMuteState'.
     *
     *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotAvailable
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMuteUnmuteMicrophoneRequest (const ::boost::shared_ptr< MuteUnmuteMicrophoneRequest >& request) = 0;

    /**
     * The method sendMuteUnmuteMicrophoneResponse() sends a response of a
     * previous method invocation of 'MuteUnmuteMicrophone' back to the
     * client.
     *
     * <b>Documentation of 'MuteUnmuteMicrophone'</b>:
     *
     * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
     *         The updated change will be provided by the property - 'MicrophoneMuteState'.
     *
     *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotAvailable
     *
     * @param act The parameter act identifies a previous invocation of
     * onMuteUnmuteMicrophone(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMuteUnmuteMicrophoneResponse (act_t act = 0);

    /**
     * The method sendMuteUnmuteMicrophoneError() sends an error response of a
     * previous method invocation of 'MuteUnmuteMicrophone' back to the
     * client.
     *
     * <b>Documentation of 'MuteUnmuteMicrophone'</b>:
     *
     * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
     *         The updated change will be provided by the property - 'MicrophoneMuteState'.
     *
     *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotAvailable
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onMuteUnmuteMicrophone(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMuteUnmuteMicrophoneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MergeCalls'

    /**
     * The method onMergeCalls() is called by ASF when a client invokes the
     * method 'MergeCalls'. A subclass has to implement this method and send
     * back a response to the client either with the sendMergeCalls() or
     * sendMergeCallsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'MergeCalls'</b>:
     *
     * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
     *         into a multi-party call.
     *         Returns the new list of calls participating in a multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotAvailable
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMergeCallsRequest (const ::boost::shared_ptr< MergeCallsRequest >& request) = 0;

    /**
     * The method sendMergeCallsResponse() sends a response of a previous
     * method invocation of 'MergeCalls' back to the client.
     *
     * <b>Documentation of 'MergeCalls'</b>:
     *
     * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
     *         into a multi-party call.
     *         Returns the new list of calls participating in a multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotAvailable
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param MultipartyCallsList Type representation of the parameter- Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param act The parameter act identifies a previous invocation of
     * onMergeCalls(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendMergeCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& multipartyCallsList, act_t act = 0);

    /**
     * The method sendMergeCallsError() sends an error response of a previous
     * method invocation of 'MergeCalls' back to the client.
     *
     * <b>Documentation of 'MergeCalls'</b>:
     *
     * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
     *         into a multi-party call.
     *         Returns the new list of calls participating in a multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotAvailable
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onMergeCalls(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMergeCallsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SplitCalls'

    /**
     * The method onSplitCalls() is called by ASF when a client invokes the
     * method 'SplitCalls'. A subclass has to implement this method and send
     * back a response to the client either with the sendSplitCalls() or
     * sendSplitCallsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SplitCalls'</b>:
     *
     * Places the Conference call on hold and makes desired call active.
     *         Returns the new list of calls participating in the multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotFound
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSplitCallsRequest (const ::boost::shared_ptr< SplitCallsRequest >& request) = 0;

    /**
     * The method sendSplitCallsResponse() sends a response of a previous
     * method invocation of 'SplitCalls' back to the client.
     *
     * <b>Documentation of 'SplitCalls'</b>:
     *
     * Places the Conference call on hold and makes desired call active.
     *         Returns the new list of calls participating in the multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotFound
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param SplitCallsList Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param act The parameter act identifies a previous invocation of
     * onSplitCalls(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSplitCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& splitCallsList, act_t act = 0);

    /**
     * The method sendSplitCallsError() sends an error response of a previous
     * method invocation of 'SplitCalls' back to the client.
     *
     * <b>Documentation of 'SplitCalls'</b>:
     *
     * Places the Conference call on hold and makes desired call active.
     *         Returns the new list of calls participating in the multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotFound
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSplitCalls(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSplitCallsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HangupAll'

    /**
     * The method onHangupAll() is called by ASF when a client invokes the
     * method 'HangupAll'. A subclass has to implement this method and send
     * back a response to the client either with the sendHangupAll() or
     * sendHangupAllError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * Releases all calls including waiting call and multi party calls in a device for the given device address.
     *
     *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHangupAllRequest (const ::boost::shared_ptr< HangupAllRequest >& request) = 0;

    /**
     * The method sendHangupAllResponse() sends a response of a previous
     * method invocation of 'HangupAll' back to the client.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * Releases all calls including waiting call and multi party calls in a device for the given device address.
     *
     *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param act The parameter act identifies a previous invocation of
     * onHangupAll(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHangupAllResponse (act_t act = 0);

    /**
     * The method sendHangupAllError() sends an error response of a previous
     * method invocation of 'HangupAll' back to the client.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * Releases all calls including waiting call and multi party calls in a device for the given device address.
     *
     *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHangupAll(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHangupAllError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Redial'

    /**
     * The method onRedial() is called by ASF when a client invokes the method
     * 'Redial'. A subclass has to implement this method and send back a
     * response to the client either with the sendRedial() or
     * sendRedialError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * Initiates a new outgoing call to the number that was previously dialed.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRedialRequest (const ::boost::shared_ptr< RedialRequest >& request) = 0;

    /**
     * The method sendRedialResponse() sends a response of a previous method
     * invocation of 'Redial' back to the client.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * Initiates a new outgoing call to the number that was previously dialed.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param DeviceAddressOut BT Address of the HFP connected device for which the redial is triggered.
     *
     * @param CallInstance Call Instance of the outgoing call
     *
     * @param act The parameter act identifies a previous invocation of
     * onRedial(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRedialResponse (const ::std::string& deviceAddressOut, uint8 callInstance, act_t act = 0);

    /**
     * The method sendRedialError() sends an error response of a previous
     * method invocation of 'Redial' back to the client.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * Initiates a new outgoing call to the number that was previously dialed.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRedial(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRedialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    CallStatusListUpdate _CallStatusListProperty;

    MicrophoneMuteStateUpdate _MicrophoneMuteStateProperty;

    friend class VoiceCallManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace VoiceCallManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALLMANAGERSTUB_H
