/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCallManager.h"
#include "com/bosch/pmapp/VoiceCallManagerDBus.h"
#include "com/bosch/pmapp/VoiceCallManagerJson.h"
#include "com/bosch/pmapp/VoiceCallManagerStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCallManager {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceCallManager", VoiceCallManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Redial", 5 },
    { 9, "HangupAll", 4 },
    { 10, "MergeCalls", 2 },
    { 10, "SplitCalls", 3 },
    { 13, "GetProperties", 0 },
    { 20, "MuteUnmuteMicrophone", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 14, "CallStatusList", 0 },
    { 19, "MicrophoneMuteState", 1 },
};

class VoiceCallManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.pmapp.VoiceCallManager"),
          _logger(logger) {}

    virtual ~VoiceCallManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void VoiceCallManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'MuteUnmuteMicrophone'

            LOG_DEBUG_STUB("process method '%s'", "MuteUnmuteMicrophone");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteMicrophoneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MuteUnmuteMicrophone", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MuteUnmuteMicrophoneRequest > payload = ::boost::static_pointer_cast<MuteUnmuteMicrophoneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onMuteUnmuteMicrophoneRequest(payload);
            return;
        }
        case 2: {

            // method 'MergeCalls'

            LOG_DEBUG_STUB("process method '%s'", "MergeCalls");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MergeCallsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MergeCalls", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MergeCallsRequest > payload = ::boost::static_pointer_cast<MergeCallsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onMergeCallsRequest(payload);
            return;
        }
        case 3: {

            // method 'SplitCalls'

            LOG_DEBUG_STUB("process method '%s'", "SplitCalls");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SplitCallsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SplitCalls", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SplitCallsRequest > payload = ::boost::static_pointer_cast<SplitCallsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onSplitCallsRequest(payload);
            return;
        }
        case 4: {

            // method 'HangupAll'

            LOG_DEBUG_STUB("process method '%s'", "HangupAll");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HangupAll", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HangupAllRequest > payload = ::boost::static_pointer_cast<HangupAllRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onHangupAllRequest(payload);
            return;
        }
        case 5: {

            // method 'Redial'

            LOG_DEBUG_STUB("process method '%s'", "Redial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RedialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Redial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RedialRequest > payload = ::boost::static_pointer_cast<RedialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onRedialRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* VoiceCallManagerStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.pmapp.VoiceCallManager\">\n"
            "    <property access=\"read\" name=\"CallStatusList\" type=\"aa{s(uv)}\"/>\n"
            "    <property access=\"read\" name=\"MicrophoneMuteState\" type=\"b\"/>\n"
            "    <method name=\"GetProperties\">\n"
            "      <doc>\n"
            "        <line>GetProperties = Returns all properties of the VoiceCallManager Interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>---</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoiceCallManagerProperties\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>VoiceCallManagerProperties (of type VoiceCallManagerPropertiesList) = Type representation of the parameter- Dict:</line>\n"
            "          <line>{ PropertyName : PropertyValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;MicrophoneMuteState&quot; : false},</line>\n"
            "          <line>{&quot;CallStatusList&quot; : Refer callStatusList Property}</line>\n"
            "          <line>}</line>\n"
            "          <line>VoiceCallManagerPropertiesList = dictionary(key=STRING,value=VoiceCallManagerVariant)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"MuteUnmuteMicrophone\">\n"
            "      <doc>\n"
            "        <line>MuteUnmuteMicrophone = Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.</line>\n"
            "        <line>The updated change will be provided by the property - 'MicrophoneMuteState'.</line>\n"
            "        <line></line>\n"
            "        <line>Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.NotAvailable</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"MuteState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>MuteState = The Input parameter values for MuteState are-</line>\n"
            "          <line>TRUE - Enable microphone mute state</line>\n"
            "          <line>FALSE - Disable microphone mute state</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"MergeCalls\">\n"
            "      <doc>\n"
            "        <line>MergeCalls = Joins or conferences in all active and held calls of a single or multiple HFP connected devices together</line>\n"
            "        <line>into a multi-party call.</line>\n"
            "        <line>Returns the new list of calls participating in a multiparty call.</line>\n"
            "        <line>The change in call states will be notified by the CallStatusList property.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.NotAvailable</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CallsToMerge\" type=\"a(say)\">\n"
            "        <doc>\n"
            "          <line>CallsToMerge = Type representation of the parameter - Array of struct - [(String, [UInt8])]</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>[(&quot;aabbccddeeff&quot;, [1, 2]), (&quot;gghhiijjkkll&quot;, [2])]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"MultipartyCallsList\" type=\"a(say)\">\n"
            "        <doc>\n"
            "          <line>MultipartyCallsList = Type representation of the parameter- Array of struct - [(String, [UInt8])]</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>[(&quot;aabbccddeeff&quot;, [1, 2]), (&quot;gghhiijjkkll&quot;, [2])]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SplitCalls\">\n"
            "      <doc>\n"
            "        <line>SplitCalls = Places the Conference call on hold and makes desired call active.</line>\n"
            "        <line>Returns the new list of calls participating in the multiparty call.</line>\n"
            "        <line>The change in call states will be notified by the CallStatusList property.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidFormat</line>\n"
            "        <line>com.bosch.pmapp.Error.NotFound</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CallsToSplit\" type=\"a(say)\">\n"
            "        <doc>\n"
            "          <line>CallsToSplit = Type representation of the parameter - Array of struct - [(String, [UInt8])]</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>[(&quot;aabbccddeeff&quot;, [1, 2]), (&quot;gghhiijjkkll&quot;, [2])]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SplitCallsList\" type=\"a(say)\">\n"
            "        <doc>\n"
            "          <line>SplitCallsList = Type representation of the parameter - Array of struct - [(String, [UInt8])]</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>[(&quot;aabbccddeeff&quot;, [1, 2]), (&quot;gghhiijjkkll&quot;, [2])]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"HangupAll\">\n"
            "      <doc>\n"
            "        <line>HangupAll = Releases all calls including waiting call and multi party calls in a device for the given device address.</line>\n"
            "        <line></line>\n"
            "        <line>If the DeviceAddress is set as &quot;ALL&quot;3, then all the calls in all the HFP connected devices will be disconnected.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"deviceAddressList\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>deviceAddressList (of type DeviceAddressList) = BT Address of the HFP connected devices, for which the calls has to be terminated.</line>\n"
            "          <line></line>\n"
            "          <line>Type representation of the parameter - Array - [String]</line>\n"
            "          <line></line>\n"
            "          <line>Example 1:</line>\n"
            "          <line>[&quot;aabbccddeeff&quot;, &quot;ggggiijjkkll&quot;]</line>\n"
            "          <line></line>\n"
            "          <line>Example 2:</line>\n"
            "          <line>[&quot;ALL&quot;]</line>\n"
            "          <line>DeviceAddressList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Redial\">\n"
            "      <doc>\n"
            "        <line>Redial = Initiates a new outgoing call to the number that was previously dialed.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidFormat</line>\n"
            "        <line>com.bosch.pmapp.Error.NotImplemented</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"DeviceAddressIn\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DeviceAddressIn = The client has the option to specify the:</line>\n"
            "          <line>1. DeviceAddress as &quot;System&quot;[3], then outgoing call will be initiated from the active</line>\n"
            "          <line>phone[2] for the last dialled number in the vehicle.</line>\n"
            "          <line>OR</line>\n"
            "          <line>2. Valid device address, to redial the number that was last dialed in that device.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"HideCallerID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>HideCallerID = The possible values are-</line>\n"
            "          <line>0x00 - Shows the CallerID</line>\n"
            "          <line>0x01 - Hides the CallerID</line>\n"
            "          <line>0xFF - Default (Network) mode is used</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DeviceAddressOut\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DeviceAddressOut = BT Address of the HFP connected device for which the redial is triggered.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"CallInstance\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>CallInstance = Call Instance of the outgoing call</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void VoiceCallManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<VoiceCallManagerStub*>(getStub()))->onGetAll (properties);
}

void VoiceCallManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "CallStatusList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "MicrophoneMuteState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void VoiceCallManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "CallStatusList");
            ::boost::shared_ptr< CallStatusListGet > payload(new CallStatusListGet());
            payload->setAct(act);
            static_cast<VoiceCallManagerStub*>(getStub())->onCallStatusListGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "MicrophoneMuteState");
            ::boost::shared_ptr< MicrophoneMuteStateGet > payload(new MicrophoneMuteStateGet());
            payload->setAct(act);
            static_cast<VoiceCallManagerStub*>(getStub())->onMicrophoneMuteStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

VoiceCallManagerStub::VoiceCallManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallManagerStub::VoiceCallManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallManagerStub::~VoiceCallManagerStub() {
    delete _stubDelegate;
}

void VoiceCallManagerStub::sendCallStatusListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CallStatusListUpdate payload(_CallStatusListProperty);

        LOG_INFO ("-> send%s", "CallStatusListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CallStatusList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceCallManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CallStatusListUpdate");
    }
}

void VoiceCallManagerStub::onCallStatusListGet(const ::boost::shared_ptr< CallStatusListGet >& callStatusList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CallStatusListGet", callStatusList->getAct());
    sendCallStatusListGetUpdate(_CallStatusListProperty.getCallStatusList(), callStatusList->getAct());
}

void VoiceCallManagerStub::sendCallStatusListGetUpdate(const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& callStatusList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CallStatusListGet payload(callStatusList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CallStatusListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceCallManagerStub::setCallStatusList(const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& callStatusList) {
    if(callStatusList!=_CallStatusListProperty.getCallStatusList()) {
        _CallStatusListProperty.setCallStatusList(callStatusList);
        sendCallStatusListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& VoiceCallManagerStub::getCallStatusList() const {
    return _CallStatusListProperty.getCallStatusList();
}

::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& VoiceCallManagerStub::getCallStatusListMutable() {
    return _CallStatusListProperty.getCallStatusListMutable();
}

void VoiceCallManagerStub::sendMicrophoneMuteStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MicrophoneMuteStateUpdate payload(_MicrophoneMuteStateProperty);

        LOG_INFO ("-> send%s", "MicrophoneMuteStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MicrophoneMuteState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.VoiceCallManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MicrophoneMuteStateUpdate");
    }
}

void VoiceCallManagerStub::onMicrophoneMuteStateGet(const ::boost::shared_ptr< MicrophoneMuteStateGet >& microphoneMuteState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MicrophoneMuteStateGet", microphoneMuteState->getAct());
    sendMicrophoneMuteStateGetUpdate(_MicrophoneMuteStateProperty.getMicrophoneMuteState(), microphoneMuteState->getAct());
}

void VoiceCallManagerStub::sendMicrophoneMuteStateGetUpdate(bool microphoneMuteState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MicrophoneMuteStateGet payload(microphoneMuteState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MicrophoneMuteStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void VoiceCallManagerStub::setMicrophoneMuteState(bool microphoneMuteState) {
    if(microphoneMuteState!=_MicrophoneMuteStateProperty.getMicrophoneMuteState()) {
        _MicrophoneMuteStateProperty.setMicrophoneMuteState(microphoneMuteState);
        sendMicrophoneMuteStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool VoiceCallManagerStub::getMicrophoneMuteState() const {
    return _MicrophoneMuteStateProperty.getMicrophoneMuteState();
}

void  VoiceCallManagerStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& voiceCallManagerProperties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(voiceCallManagerProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMuteUnmuteMicrophoneResponse (act_t act) {
    MuteUnmuteMicrophoneResponse* payload = new MuteUnmuteMicrophoneResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "MuteUnmuteMicrophone", MuteUnmuteMicrophoneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MuteUnmuteMicrophone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMuteUnmuteMicrophoneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MuteUnmuteMicrophoneError* payload = new MuteUnmuteMicrophoneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MuteUnmuteMicrophone", MuteUnmuteMicrophoneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MuteUnmuteMicrophone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMergeCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& multipartyCallsList, act_t act) {
    MergeCallsResponse* payload = new MergeCallsResponse(multipartyCallsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "MergeCalls", MergeCallsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MergeCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMergeCallsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MergeCallsError* payload = new MergeCallsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MergeCalls", MergeCallsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MergeCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSplitCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& splitCallsList, act_t act) {
    SplitCallsResponse* payload = new SplitCallsResponse(splitCallsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "SplitCalls", SplitCallsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SplitCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSplitCallsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SplitCallsError* payload = new SplitCallsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SplitCalls", SplitCallsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SplitCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupAllResponse (act_t act) {
    HangupAllResponse* payload = new HangupAllResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HangupAll", HangupAllResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HangupAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupAllError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HangupAllError* payload = new HangupAllError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HangupAll", HangupAllError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HangupAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendRedialResponse (const ::std::string& deviceAddressOut, uint8 callInstance, act_t act) {
    RedialResponse* payload = new RedialResponse(deviceAddressOut, callInstance);
    DBUS_MESSAGE_REPLY(dbusMessage, "Redial", RedialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Redial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendRedialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RedialError* payload = new RedialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Redial", RedialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Redial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void VoiceCallManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'CallStatusList'
    {
        ::asf::dbus::DBusVariant variant;
        CallStatusListGet payload(_CallStatusListProperty.getCallStatusList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CallStatusList", variant));
    }

    //property 'MicrophoneMuteState'
    {
        ::asf::dbus::DBusVariant variant;
        MicrophoneMuteStateGet payload(_MicrophoneMuteStateProperty.getMicrophoneMuteState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MicrophoneMuteState", variant));
    }
}

} // namespace VoiceCallManager
} // namespace pmapp
} // namespace bosch
} // namespace com
