/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALLMANAGERPROXY_H
#define COM_BOSCH_PMAPP_VOICECALLMANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCallManager.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCallManager {

class VoiceCallManagerProxy;

class CallStatusListCallbackIF {
public:
    virtual ~CallStatusListCallbackIF() {}

    virtual void onCallStatusListError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallStatusListError >& error) = 0;

    virtual void onCallStatusListUpdate(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallStatusListUpdate >& update) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class HangupAllCallbackIF {
public:
    virtual ~HangupAllCallbackIF() {}

    virtual void onHangupAllError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllError >& error) = 0;

    virtual void onHangupAllResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllResponse >& response) = 0;
};

class MergeCallsCallbackIF {
public:
    virtual ~MergeCallsCallbackIF() {}

    virtual void onMergeCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MergeCallsError >& error) = 0;

    virtual void onMergeCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MergeCallsResponse >& response) = 0;
};

class MicrophoneMuteStateCallbackIF {
public:
    virtual ~MicrophoneMuteStateCallbackIF() {}

    virtual void onMicrophoneMuteStateError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MicrophoneMuteStateError >& error) = 0;

    virtual void onMicrophoneMuteStateUpdate(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MicrophoneMuteStateUpdate >& update) = 0;
};

class MuteUnmuteMicrophoneCallbackIF {
public:
    virtual ~MuteUnmuteMicrophoneCallbackIF() {}

    virtual void onMuteUnmuteMicrophoneError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MuteUnmuteMicrophoneError >& error) = 0;

    virtual void onMuteUnmuteMicrophoneResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MuteUnmuteMicrophoneResponse >& response) = 0;
};

class RedialCallbackIF {
public:
    virtual ~RedialCallbackIF() {}

    virtual void onRedialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialError >& error) = 0;

    virtual void onRedialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialResponse >& response) = 0;
};

class SplitCallsCallbackIF {
public:
    virtual ~SplitCallsCallbackIF() {}

    virtual void onSplitCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SplitCallsError >& error) = 0;

    virtual void onSplitCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SplitCallsResponse >& response) = 0;
};


/**
 * VoiceCallManagerProxy is the client side representation of the D-Bus
 * service interface 'com.bosch.pmapp.VoiceCallManager' (specified in file
 * pmapp_voice_call_manager_.xml).
 *
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/
 *
 *     Note:
 *     [2]
 *         - Active device:
 *             It is a HFP connected device for which
 *               -the SCO(Synchronous Connection Oriented) link could be established and
 *               -the phone call audio or Bluetooth Voice Recognition(BT-VR) audio shall be streamed
 *             between the AG and the HU speakers.
 *         - Passive device:
 *             It is a HFP connected device for which the SCO link shall not be established between AG and vehicle HU and
 *             hence the audio streaming is not possible.
 *     [3] - The string "ALL" / "System" is case insensitive.
 *
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */
class VoiceCallManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of VoiceCallManagerProxy.
     */
    static ::boost::shared_ptr< VoiceCallManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of VoiceCallManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< VoiceCallManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of VoiceCallManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< VoiceCallManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< VoiceCallManagerProxy > proxyNew(new VoiceCallManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~VoiceCallManagerProxy ();



    // Property 'CallStatusList'

    /**
     * Notify on the property 'CallStatusList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusListRegister(CallStatusListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CallStatusList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @param act The act which was previously returned by the
     * sendCallStatusListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCallStatusListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CallStatusList'.
     */
    void sendCallStatusListDeregisterAll() const;

    /**
     * Request the value of the property 'CallStatusList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CallStatusList'</b>:
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStatusListGet(CallStatusListCallbackIF& cb);


    /**
     * Returns the current value of the property 'CallStatusList' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCallStatusList() returns true.
     *
     * @return the previously received value of the property 'CallStatusList'.
     */
    const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getCallStatusList() const;

    /**
     * Determines whether a status message for the property 'CallStatusList'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCallStatusList() const;

    // Property 'MicrophoneMuteState'

    /**
     * Notify on the property 'MicrophoneMuteState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophoneMuteStateRegister(MicrophoneMuteStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'MicrophoneMuteState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @param act The act which was previously returned by the
     * sendMicrophoneMuteStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMicrophoneMuteStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'MicrophoneMuteState'.
     */
    void sendMicrophoneMuteStateDeregisterAll() const;

    /**
     * Request the value of the property 'MicrophoneMuteState' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'MicrophoneMuteState'</b>:
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophoneMuteStateGet(MicrophoneMuteStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'MicrophoneMuteState' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMicrophoneMuteState() returns true.
     *
     * @return the previously received value of the property 'MicrophoneMuteState'.
     */
    bool getMicrophoneMuteState() const;

    /**
     * Determines whether a status message for the property
     * 'MicrophoneMuteState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMicrophoneMuteState() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all properties of the VoiceCallManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'MuteUnmuteMicrophone'

    /**
     * Call the method 'MuteUnmuteMicrophone'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'MuteUnmuteMicrophone'</b>:
     *
     * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
     *         The updated change will be provided by the property - 'MicrophoneMuteState'.
     *
     *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotAvailable
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param MuteState The Input parameter values for MuteState are-
     *                   TRUE - Enable microphone mute state
     *                   FALSE - Disable microphone mute state
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMuteUnmuteMicrophoneRequest(MuteUnmuteMicrophoneCallbackIF& cb, bool muteState) const;

    // Method 'MergeCalls'

    /**
     * Call the method 'MergeCalls'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'MergeCalls'</b>:
     *
     * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
     *         into a multi-party call.
     *         Returns the new list of calls participating in a multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotAvailable
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param CallsToMerge Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMergeCallsRequest(MergeCallsCallbackIF& cb, const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& callsToMerge) const;

    // Method 'SplitCalls'

    /**
     * Call the method 'SplitCalls'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SplitCalls'</b>:
     *
     * Places the Conference call on hold and makes desired call active.
     *         Returns the new list of calls participating in the multiparty call.
     *         The change in call states will be notified by the CallStatusList property.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotFound
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param CallsToSplit Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSplitCallsRequest(SplitCallsCallbackIF& cb, const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& callsToSplit) const;

    // Method 'HangupAll'

    /**
     * Call the method 'HangupAll'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * Releases all calls including waiting call and multi party calls in a device for the given device address.
     *
     *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param deviceAddressList BT Address of the HFP connected devices, for which the calls has to be terminated.
     *
     *                 Type representation of the parameter - Array - [String]
     *
     *                 Example 1:
     *                 ["aabbccddeeff", "ggggiijjkkll"]
     *
     *                 Example 2:
     *                 ["ALL"]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHangupAllRequest(HangupAllCallbackIF& cb, const ::std::vector< ::std::string >& deviceAddressList) const;

    // Method 'Redial'

    /**
     * Call the method 'Redial'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * Initiates a new outgoing call to the number that was previously dialed.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *         com.bosch.pmapp.Error.InvalidFormat
     *         com.bosch.pmapp.Error.NotImplemented
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param DeviceAddressIn The client has the option to specify the:
     *                  1. DeviceAddress as "System"[3], then outgoing call will be initiated from the active
     *                  phone[2] for the last dialled number in the vehicle.
     *                  OR
     *                  2. Valid device address, to redial the number that was last dialed in that device.
     *
     * @param HideCallerID The possible values are-
     *                 0x00 - Shows the CallerID
     *                 0x01 - Hides the CallerID
     *                 0xFF - Default (Network) mode is used
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRedialRequest(RedialCallbackIF& cb, const ::std::string& deviceAddressIn, uint8 hideCallerID) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    VoiceCallManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'CallStatusList'

    ::asf::core::nullable< CallStatusListUpdate > _callStatusList;

    // Property 'MicrophoneMuteState'

    ::asf::core::nullable< MicrophoneMuteStateUpdate > _microphoneMuteState;

    DECLARE_CLASS_LOGGER();

    friend class VoiceCallManagerProxyCallback;
};

} // namespace VoiceCallManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALLMANAGERPROXY_H
