#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALLMANAGER_H
#define COM_BOSCH_PMAPP_VOICECALLMANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/
 *
 *     Note:
 *     [2]
 *         - Active device:
 *             It is a HFP connected device for which
 *               -the SCO(Synchronous Connection Oriented) link could be established and
 *               -the phone call audio or Bluetooth Voice Recognition(BT-VR) audio shall be streamed
 *             between the AG and the HU speakers.
 *         - Passive device:
 *             It is a HFP connected device for which the SCO link shall not be established between AG and vehicle HU and
 *             hence the audio streaming is not possible.
 *     [3] - The string "ALL" / "System" is case insensitive.
 *
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCallManager {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_MuteUnmuteMicrophone = 1;
static const uint16 ID_MergeCalls = 2;
static const uint16 ID_SplitCalls = 3;
static const uint16 ID_HangupAll = 4;
static const uint16 ID_Redial = 5;

// signal IDs

// property IDs
static const uint16 ID_CallStatusList = 6;
static const uint16 ID_MicrophoneMuteState = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPropertiesResponse;

class MuteUnmuteMicrophoneRequest;

class MergeCallsRequest;

class MergeCallsResponse;

class SplitCallsRequest;

class SplitCallsResponse;

class HangupAllRequest;

class RedialRequest;

class RedialResponse;

class CallStatusListUpdate;

class CallStatusListRegister;

class MicrophoneMuteStateUpdate;

class MicrophoneMuteStateRegister;

// type definitions
/**
 * Returns all properties of the VoiceCallManager Interface.
 *
 *         Possible errors:
 *         ---
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
 *         The updated change will be provided by the property - 'MicrophoneMuteState'.
 *
 *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.NotAvailable
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage MuteUnmuteMicrophoneResponse;

/**
 * If the meaning of "MuteUnmuteMicrophoneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MuteUnmuteMicrophoneError;

/**
 * If the meaning of "MergeCallsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MergeCallsError;

/**
 * If the meaning of "SplitCallsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SplitCallsError;

/**
 * Releases all calls including waiting call and multi party calls in a device for the given device address.
 *
 *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HangupAllResponse;

/**
 * If the meaning of "HangupAllError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HangupAllError;

/**
 * If the meaning of "RedialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RedialError;

/**
 * Updates the status of the calls in the HFP connected devices.
 *
 *         Type representation- Array of Dict:
 *            [
 *               {
 *                  "DeviceAddress" : string
 *                  "Multiparty" : Boolean,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : uint8,
 *                                          "Status"          : string,
 *                                          "DurationHr"      : uint8,
 *                                          "DurationMin"     : uint8,
 *                                          "DurationSec"     : uint8,
 *                                          "TelephoneNumber" : string,
 *                                          "FirstName"       : string,
 *                                          "lastName"        : string,
 *                                          "ContactId"       : uint64,
 *                                          "Mode"            : uint8,
 *                                          "Type"            : uint8,
 *                                          "Direction"       : uint8
 *                                       }
 *                                    ]
 *               }
 *            ]
 *
 *            Example:
 *            [
 *               {
 *                  "DeviceAddress" : "aabbccddeeff",
 *                  "Multiparty"    : false,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Held",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "1234567890",
 *                                          "FirstName"       : "XX",
 *                                          "LastName"        : "YY",
 *                                          "ContactId"       : 0x123,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                       }
 *                                    ]
 *               },
 *               {
 *                  "DeviceAddress" : "gghhiijjkkll",
 *                  "Multiparty"    : true,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "9876543210",
 *                                          "FirstName"       : "AA",
 *                                          "LastName"        : "BB",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         },
 *                                         {
 *                                          "Instance"        : 02,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "6789012345",
 *                                          "FirstName"       : "CC",
 *                                          "LastName"        : "DD",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         }
 *                                       ]
 *               }
 *            ]
 */
typedef CallStatusListUpdate CallStatusListSet;

/**
 * Updates the status of the calls in the HFP connected devices.
 *
 *         Type representation- Array of Dict:
 *            [
 *               {
 *                  "DeviceAddress" : string
 *                  "Multiparty" : Boolean,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : uint8,
 *                                          "Status"          : string,
 *                                          "DurationHr"      : uint8,
 *                                          "DurationMin"     : uint8,
 *                                          "DurationSec"     : uint8,
 *                                          "TelephoneNumber" : string,
 *                                          "FirstName"       : string,
 *                                          "lastName"        : string,
 *                                          "ContactId"       : uint64,
 *                                          "Mode"            : uint8,
 *                                          "Type"            : uint8,
 *                                          "Direction"       : uint8
 *                                       }
 *                                    ]
 *               }
 *            ]
 *
 *            Example:
 *            [
 *               {
 *                  "DeviceAddress" : "aabbccddeeff",
 *                  "Multiparty"    : false,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Held",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "1234567890",
 *                                          "FirstName"       : "XX",
 *                                          "LastName"        : "YY",
 *                                          "ContactId"       : 0x123,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                       }
 *                                    ]
 *               },
 *               {
 *                  "DeviceAddress" : "gghhiijjkkll",
 *                  "Multiparty"    : true,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "9876543210",
 *                                          "FirstName"       : "AA",
 *                                          "LastName"        : "BB",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         },
 *                                         {
 *                                          "Instance"        : 02,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "6789012345",
 *                                          "FirstName"       : "CC",
 *                                          "LastName"        : "DD",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         }
 *                                       ]
 *               }
 *            ]
 */
typedef CallStatusListUpdate CallStatusListGet;

/**
 * If the meaning of "CallStatusListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CallStatusListError;

/**
 * Provides the current mute state of the Microphone.
 *
 *         TRUE - Microphone mute state enabled.
 *         FALSE - Microphone mute state disabled [Default].
 */
typedef MicrophoneMuteStateUpdate MicrophoneMuteStateSet;

/**
 * Provides the current mute state of the Microphone.
 *
 *         TRUE - Microphone mute state enabled.
 *         FALSE - Microphone mute state disabled [Default].
 */
typedef MicrophoneMuteStateUpdate MicrophoneMuteStateGet;

/**
 * If the meaning of "MicrophoneMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MicrophoneMuteStateError;


/**
 * Returns all properties of the VoiceCallManager Interface.
 *
 *         Possible errors:
 *         ---
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& VoiceCallManagerProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceCallManagerProperties"

    static const int kVoiceCallManagerProperties = 0;

    /**
     * Clears the field "VoiceCallManagerProperties".
     *
     * The field will be set to its default value. The hasVoiceCallManagerProperties()
     * method will return false.
     */
    inline void clearVoiceCallManagerProperties();

    /**
     * Checks whether the field "VoiceCallManagerProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceCallManagerProperties()). Otherwise it will return false.
     */
    inline bool hasVoiceCallManagerProperties () const;

    /**
     * Returns the value of the member "VoiceCallManagerProperties".
     *
     * Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"MicrophoneMuteState" : false},
     *                   {"CallStatusList" : Refer callStatusList Property}
     *                 }
     *
     * @return The value of the field "VoiceCallManagerProperties"
     */
    inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& getVoiceCallManagerProperties () const;

    /**
     * Retrieves the value of the field "VoiceCallManagerProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceCallManagerProperties".
     */
    inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& getVoiceCallManagerPropertiesMutable ();

    /**
     * Sets the value of the member "VoiceCallManagerProperties".
     *
     * Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"MicrophoneMuteState" : false},
     *                   {"CallStatusList" : Refer callStatusList Property}
     *                 }
     *
     * @param VoiceCallManagerProperties The value which will be set
     */
    inline void setVoiceCallManagerProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& VoiceCallManagerProperties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& getStringToVoiceCallManagerVariantMap_DefaultInstance ();

    inline void set_has_VoiceCallManagerProperties ();

    inline void clear_has_VoiceCallManagerProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant > _VoiceCallManagerProperties;

};

/**
 * Provides the ability to Mute or Unmute the Microphone of the vehicle during an ongoing call.
 *         The updated change will be provided by the property - 'MicrophoneMuteState'.
 *
 *         Note:- The mute operation will neither mute the microphone in AG nor transfer the call from HF to AG.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.NotAvailable
 */
class MuteUnmuteMicrophoneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteUnmuteMicrophoneRequest ();

    /**
     * Copy constructor
     */
    inline  MuteUnmuteMicrophoneRequest (const MuteUnmuteMicrophoneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MuteUnmuteMicrophoneRequest (bool MuteState_);

    /**
     * Destructor
     */
    inline virtual  ~MuteUnmuteMicrophoneRequest();

    /**
     * Assignment operator
     */
    inline MuteUnmuteMicrophoneRequest& operator = (const MuteUnmuteMicrophoneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteUnmuteMicrophoneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteUnmuteMicrophoneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteUnmuteMicrophoneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteUnmuteMicrophoneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MuteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "MuteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "MuteState".
     *
     * The Input parameter values for MuteState are-
     *                   TRUE - Enable microphone mute state
     *                   FALSE - Disable microphone mute state
     *
     * @return The value of the field "MuteState"
     */
    inline bool getMuteState () const;

    /**
     * Sets the value of the member "MuteState".
     *
     * The Input parameter values for MuteState are-
     *                   TRUE - Enable microphone mute state
     *                   FALSE - Disable microphone mute state
     *
     * @param MuteState The value which will be set
     */
    inline void setMuteState (bool MuteState_);

    static const MuteUnmuteMicrophoneRequest &getDefaultInstance();

private:

    inline void set_has_MuteState ();

    inline void clear_has_MuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _MuteState;

};

/**
 * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
 *         into a multi-party call.
 *         Returns the new list of calls participating in a multiparty call.
 *         The change in call states will be notified by the CallStatusList property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotAvailable
 *         com.bosch.pmapp.Error.NotImplemented
 */
class MergeCallsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MergeCallsRequest ();

    /**
     * Copy constructor
     */
    inline  MergeCallsRequest (const MergeCallsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MergeCallsRequest (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToMerge_);

    /**
     * Destructor
     */
    inline virtual  ~MergeCallsRequest();

    /**
     * Assignment operator
     */
    inline MergeCallsRequest& operator = (const MergeCallsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MergeCallsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MergeCallsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MergeCallsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MergeCallsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallsToMerge"

    static const int kCallsToMerge = 0;

    /**
     * Clears the field "CallsToMerge".
     *
     * The field will be set to its default value. The hasCallsToMerge()
     * method will return false.
     */
    inline void clearCallsToMerge();

    /**
     * Checks whether the field "CallsToMerge" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallsToMerge()). Otherwise it will return false.
     */
    inline bool hasCallsToMerge () const;

    /**
     * Returns the value of the member "CallsToMerge".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return The value of the field "CallsToMerge"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getCallsToMerge () const;

    /**
     * Retrieves the value of the field "CallsToMerge" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallsToMerge".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getCallsToMergeMutable ();

    /**
     * Sets the value of the member "CallsToMerge".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param CallsToMerge The value which will be set
     */
    inline void setCallsToMerge (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToMerge_);

    static const MergeCallsRequest &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getDeviceCallsListList_DefaultInstance ();

    inline void set_has_CallsToMerge ();

    inline void clear_has_CallsToMerge ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList > _CallsToMerge;

};

/**
 * Joins or conferences in all active and held calls of a single or multiple HFP connected devices together
 *         into a multi-party call.
 *         Returns the new list of calls participating in a multiparty call.
 *         The change in call states will be notified by the CallStatusList property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotAvailable
 *         com.bosch.pmapp.Error.NotImplemented
 */
class MergeCallsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MergeCallsResponse ();

    /**
     * Copy constructor
     */
    inline  MergeCallsResponse (const MergeCallsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  MergeCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MultipartyCallsList_);

    /**
     * Destructor
     */
    inline virtual  ~MergeCallsResponse();

    /**
     * Assignment operator
     */
    inline MergeCallsResponse& operator = (const MergeCallsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MergeCallsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MergeCallsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MergeCallsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MergeCallsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MultipartyCallsList"

    static const int kMultipartyCallsList = 0;

    /**
     * Clears the field "MultipartyCallsList".
     *
     * The field will be set to its default value. The hasMultipartyCallsList()
     * method will return false.
     */
    inline void clearMultipartyCallsList();

    /**
     * Checks whether the field "MultipartyCallsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMultipartyCallsList()). Otherwise it will return false.
     */
    inline bool hasMultipartyCallsList () const;

    /**
     * Returns the value of the member "MultipartyCallsList".
     *
     * Type representation of the parameter- Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return The value of the field "MultipartyCallsList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getMultipartyCallsList () const;

    /**
     * Retrieves the value of the field "MultipartyCallsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MultipartyCallsList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getMultipartyCallsListMutable ();

    /**
     * Sets the value of the member "MultipartyCallsList".
     *
     * Type representation of the parameter- Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param MultipartyCallsList The value which will be set
     */
    inline void setMultipartyCallsList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MultipartyCallsList_);

    static const MergeCallsResponse &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getDeviceCallsListList_DefaultInstance ();

    inline void set_has_MultipartyCallsList ();

    inline void clear_has_MultipartyCallsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList > _MultipartyCallsList;

};

/**
 * Places the Conference call on hold and makes desired call active.
 *         Returns the new list of calls participating in the multiparty call.
 *         The change in call states will be notified by the CallStatusList property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotFound
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SplitCallsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SplitCallsRequest ();

    /**
     * Copy constructor
     */
    inline  SplitCallsRequest (const SplitCallsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SplitCallsRequest (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToSplit_);

    /**
     * Destructor
     */
    inline virtual  ~SplitCallsRequest();

    /**
     * Assignment operator
     */
    inline SplitCallsRequest& operator = (const SplitCallsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallsToSplit"

    static const int kCallsToSplit = 0;

    /**
     * Clears the field "CallsToSplit".
     *
     * The field will be set to its default value. The hasCallsToSplit()
     * method will return false.
     */
    inline void clearCallsToSplit();

    /**
     * Checks whether the field "CallsToSplit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallsToSplit()). Otherwise it will return false.
     */
    inline bool hasCallsToSplit () const;

    /**
     * Returns the value of the member "CallsToSplit".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return The value of the field "CallsToSplit"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getCallsToSplit () const;

    /**
     * Retrieves the value of the field "CallsToSplit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallsToSplit".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getCallsToSplitMutable ();

    /**
     * Sets the value of the member "CallsToSplit".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param CallsToSplit The value which will be set
     */
    inline void setCallsToSplit (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToSplit_);

    static const SplitCallsRequest &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getDeviceCallsListList_DefaultInstance ();

    inline void set_has_CallsToSplit ();

    inline void clear_has_CallsToSplit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList > _CallsToSplit;

};

/**
 * Places the Conference call on hold and makes desired call active.
 *         Returns the new list of calls participating in the multiparty call.
 *         The change in call states will be notified by the CallStatusList property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotFound
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SplitCallsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SplitCallsResponse ();

    /**
     * Copy constructor
     */
    inline  SplitCallsResponse (const SplitCallsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SplitCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsList_);

    /**
     * Destructor
     */
    inline virtual  ~SplitCallsResponse();

    /**
     * Assignment operator
     */
    inline SplitCallsResponse& operator = (const SplitCallsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SplitCallsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SplitCallsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SplitCallsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SplitCallsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SplitCallsList"

    static const int kSplitCallsList = 0;

    /**
     * Clears the field "SplitCallsList".
     *
     * The field will be set to its default value. The hasSplitCallsList()
     * method will return false.
     */
    inline void clearSplitCallsList();

    /**
     * Checks whether the field "SplitCallsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSplitCallsList()). Otherwise it will return false.
     */
    inline bool hasSplitCallsList () const;

    /**
     * Returns the value of the member "SplitCallsList".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @return The value of the field "SplitCallsList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getSplitCallsList () const;

    /**
     * Retrieves the value of the field "SplitCallsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SplitCallsList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getSplitCallsListMutable ();

    /**
     * Sets the value of the member "SplitCallsList".
     *
     * Type representation of the parameter - Array of struct - [(String, [UInt8])]
     *
     *                 Example:
     *                 [("aabbccddeeff", [1, 2]), ("gghhiijjkkll", [2])]
     *
     * @param SplitCallsList The value which will be set
     */
    inline void setSplitCallsList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsList_);

    static const SplitCallsResponse &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& getDeviceCallsListList_DefaultInstance ();

    inline void set_has_SplitCallsList ();

    inline void clear_has_SplitCallsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList > _SplitCallsList;

};

/**
 * Releases all calls including waiting call and multi party calls in a device for the given device address.
 *
 *         If the DeviceAddress is set as "ALL"3, then all the calls in all the HFP connected devices will be disconnected.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class HangupAllRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HangupAllRequest ();

    /**
     * Copy constructor
     */
    inline  HangupAllRequest (const HangupAllRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HangupAllRequest (const ::std::vector< ::std::string >& deviceAddressList_);

    /**
     * Destructor
     */
    inline virtual  ~HangupAllRequest();

    /**
     * Assignment operator
     */
    inline HangupAllRequest& operator = (const HangupAllRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangupAllRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangupAllRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangupAllRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangupAllRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deviceAddressList"

    static const int kDeviceAddressList = 0;

    /**
     * Clears the field "deviceAddressList".
     *
     * The field will be set to its default value. The hasDeviceAddressList()
     * method will return false.
     */
    inline void clearDeviceAddressList();

    /**
     * Checks whether the field "deviceAddressList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddressList()). Otherwise it will return false.
     */
    inline bool hasDeviceAddressList () const;

    /**
     * Returns the value of the member "deviceAddressList".
     *
     * BT Address of the HFP connected devices, for which the calls has to be terminated.
     *
     *                 Type representation of the parameter - Array - [String]
     *
     *                 Example 1:
     *                 ["aabbccddeeff", "ggggiijjkkll"]
     *
     *                 Example 2:
     *                 ["ALL"]
     *
     * @return The value of the field "deviceAddressList"
     */
    inline const ::std::vector< ::std::string >& getDeviceAddressList () const;

    /**
     * Retrieves the value of the field "deviceAddressList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deviceAddressList".
     */
    inline ::std::vector< ::std::string >& getDeviceAddressListMutable ();

    /**
     * Sets the value of the member "deviceAddressList".
     *
     * BT Address of the HFP connected devices, for which the calls has to be terminated.
     *
     *                 Type representation of the parameter - Array - [String]
     *
     *                 Example 1:
     *                 ["aabbccddeeff", "ggggiijjkkll"]
     *
     *                 Example 2:
     *                 ["ALL"]
     *
     * @param deviceAddressList The value which will be set
     */
    inline void setDeviceAddressList (const ::std::vector< ::std::string >& deviceAddressList_);

    static const HangupAllRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_deviceAddressList ();

    inline void clear_has_deviceAddressList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _deviceAddressList;

};

/**
 * Initiates a new outgoing call to the number that was previously dialed.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class RedialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialRequest ();

    /**
     * Copy constructor
     */
    inline  RedialRequest (const RedialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RedialRequest (const ::std::string& DeviceAddressIn_, uint8 HideCallerID_);

    /**
     * Destructor
     */
    inline virtual  ~RedialRequest();

    /**
     * Assignment operator
     */
    inline RedialRequest& operator = (const RedialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddressIn"

    static const int kDeviceAddressIn = 0;

    /**
     * Clears the field "DeviceAddressIn".
     *
     * The field will be set to its default value. The hasDeviceAddressIn()
     * method will return false.
     */
    inline void clearDeviceAddressIn();

    /**
     * Checks whether the field "DeviceAddressIn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddressIn()). Otherwise it will return false.
     */
    inline bool hasDeviceAddressIn () const;

    /**
     * Returns the value of the member "DeviceAddressIn".
     *
     * The client has the option to specify the:
     *                  1. DeviceAddress as "System"[3], then outgoing call will be initiated from the active
     *                  phone[2] for the last dialled number in the vehicle.
     *                  OR
     *                  2. Valid device address, to redial the number that was last dialed in that device.
     *
     * @return The value of the field "DeviceAddressIn"
     */
    inline const ::std::string& getDeviceAddressIn () const;

    /**
     * Retrieves the value of the field "DeviceAddressIn" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddressIn".
     */
    inline ::std::string& getDeviceAddressInMutable ();

    /**
     * Sets the value of the member "DeviceAddressIn".
     *
     * The client has the option to specify the:
     *                  1. DeviceAddress as "System"[3], then outgoing call will be initiated from the active
     *                  phone[2] for the last dialled number in the vehicle.
     *                  OR
     *                  2. Valid device address, to redial the number that was last dialed in that device.
     *
     * @param DeviceAddressIn The value which will be set
     */
    inline void setDeviceAddressIn (const ::std::string& DeviceAddressIn_);

    /**
     * Sets the value of the member "DeviceAddressIn".
     *
     * The client has the option to specify the:
     *                  1. DeviceAddress as "System"[3], then outgoing call will be initiated from the active
     *                  phone[2] for the last dialled number in the vehicle.
     *                  OR
     *                  2. Valid device address, to redial the number that was last dialed in that device.
     *
     * @param DeviceAddressIn The value which will be set
     */
    inline void setDeviceAddressIn (const char* DeviceAddressIn_);

    /**
     * Sets the value of the member "DeviceAddressIn".
     *
     * The client has the option to specify the:
     *                  1. DeviceAddress as "System"[3], then outgoing call will be initiated from the active
     *                  phone[2] for the last dialled number in the vehicle.
     *                  OR
     *                  2. Valid device address, to redial the number that was last dialed in that device.
     *
     * @param DeviceAddressIn The value which will be set
     */
    inline void setDeviceAddressIn (const char* value, size_t size);

    // API of field "HideCallerID"

    static const int kHideCallerID = 1;

    /**
     * Clears the field "HideCallerID".
     *
     * The field will be set to its default value. The hasHideCallerID()
     * method will return false.
     */
    inline void clearHideCallerID();

    /**
     * Checks whether the field "HideCallerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHideCallerID()). Otherwise it will return false.
     */
    inline bool hasHideCallerID () const;

    /**
     * Returns the value of the member "HideCallerID".
     *
     * The possible values are-
     *                 0x00 - Shows the CallerID
     *                 0x01 - Hides the CallerID
     *                 0xFF - Default (Network) mode is used
     *
     * @return The value of the field "HideCallerID"
     */
    inline uint8 getHideCallerID () const;

    /**
     * Sets the value of the member "HideCallerID".
     *
     * The possible values are-
     *                 0x00 - Shows the CallerID
     *                 0x01 - Hides the CallerID
     *                 0xFF - Default (Network) mode is used
     *
     * @param HideCallerID The value which will be set
     */
    inline void setHideCallerID (uint8 HideCallerID_);

    static const RedialRequest &getDefaultInstance();

private:

    inline void set_has_DeviceAddressIn ();

    inline void clear_has_DeviceAddressIn ();

    inline void set_has_HideCallerID ();

    inline void clear_has_HideCallerID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddressIn;

    uint8 _HideCallerID;

};

/**
 * Initiates a new outgoing call to the number that was previously dialed.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class RedialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialResponse ();

    /**
     * Copy constructor
     */
    inline  RedialResponse (const RedialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RedialResponse (const ::std::string& DeviceAddressOut_, uint8 CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~RedialResponse();

    /**
     * Assignment operator
     */
    inline RedialResponse& operator = (const RedialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddressOut"

    static const int kDeviceAddressOut = 0;

    /**
     * Clears the field "DeviceAddressOut".
     *
     * The field will be set to its default value. The hasDeviceAddressOut()
     * method will return false.
     */
    inline void clearDeviceAddressOut();

    /**
     * Checks whether the field "DeviceAddressOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddressOut()). Otherwise it will return false.
     */
    inline bool hasDeviceAddressOut () const;

    /**
     * Returns the value of the member "DeviceAddressOut".
     *
     * BT Address of the HFP connected device for which the redial is triggered.
     *
     * @return The value of the field "DeviceAddressOut"
     */
    inline const ::std::string& getDeviceAddressOut () const;

    /**
     * Retrieves the value of the field "DeviceAddressOut" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddressOut".
     */
    inline ::std::string& getDeviceAddressOutMutable ();

    /**
     * Sets the value of the member "DeviceAddressOut".
     *
     * BT Address of the HFP connected device for which the redial is triggered.
     *
     * @param DeviceAddressOut The value which will be set
     */
    inline void setDeviceAddressOut (const ::std::string& DeviceAddressOut_);

    /**
     * Sets the value of the member "DeviceAddressOut".
     *
     * BT Address of the HFP connected device for which the redial is triggered.
     *
     * @param DeviceAddressOut The value which will be set
     */
    inline void setDeviceAddressOut (const char* DeviceAddressOut_);

    /**
     * Sets the value of the member "DeviceAddressOut".
     *
     * BT Address of the HFP connected device for which the redial is triggered.
     *
     * @param DeviceAddressOut The value which will be set
     */
    inline void setDeviceAddressOut (const char* value, size_t size);

    // API of field "CallInstance"

    static const int kCallInstance = 1;

    /**
     * Clears the field "CallInstance".
     *
     * The field will be set to its default value. The hasCallInstance()
     * method will return false.
     */
    inline void clearCallInstance();

    /**
     * Checks whether the field "CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstance()). Otherwise it will return false.
     */
    inline bool hasCallInstance () const;

    /**
     * Returns the value of the member "CallInstance".
     *
     * Call Instance of the outgoing call
     *
     * @return The value of the field "CallInstance"
     */
    inline uint8 getCallInstance () const;

    /**
     * Sets the value of the member "CallInstance".
     *
     * Call Instance of the outgoing call
     *
     * @param CallInstance The value which will be set
     */
    inline void setCallInstance (uint8 CallInstance_);

    static const RedialResponse &getDefaultInstance();

private:

    inline void set_has_DeviceAddressOut ();

    inline void clear_has_DeviceAddressOut ();

    inline void set_has_CallInstance ();

    inline void clear_has_CallInstance ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddressOut;

    uint8 _CallInstance;

};

/**
 * Updates the status of the calls in the HFP connected devices.
 *
 *         Type representation- Array of Dict:
 *            [
 *               {
 *                  "DeviceAddress" : string
 *                  "Multiparty" : Boolean,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : uint8,
 *                                          "Status"          : string,
 *                                          "DurationHr"      : uint8,
 *                                          "DurationMin"     : uint8,
 *                                          "DurationSec"     : uint8,
 *                                          "TelephoneNumber" : string,
 *                                          "FirstName"       : string,
 *                                          "lastName"        : string,
 *                                          "ContactId"       : uint64,
 *                                          "Mode"            : uint8,
 *                                          "Type"            : uint8,
 *                                          "Direction"       : uint8
 *                                       }
 *                                    ]
 *               }
 *            ]
 *
 *            Example:
 *            [
 *               {
 *                  "DeviceAddress" : "aabbccddeeff",
 *                  "Multiparty"    : false,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Held",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "1234567890",
 *                                          "FirstName"       : "XX",
 *                                          "LastName"        : "YY",
 *                                          "ContactId"       : 0x123,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                       }
 *                                    ]
 *               },
 *               {
 *                  "DeviceAddress" : "gghhiijjkkll",
 *                  "Multiparty"    : true,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "9876543210",
 *                                          "FirstName"       : "AA",
 *                                          "LastName"        : "BB",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         },
 *                                         {
 *                                          "Instance"        : 02,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "6789012345",
 *                                          "FirstName"       : "CC",
 *                                          "LastName"        : "DD",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         }
 *                                       ]
 *               }
 *            ]
 */
class CallStatusListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallStatusListUpdate ();

    /**
     * Copy constructor
     */
    inline  CallStatusListUpdate (const CallStatusListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CallStatusListUpdate (const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~CallStatusListUpdate();

    /**
     * Assignment operator
     */
    inline CallStatusListUpdate& operator = (const CallStatusListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallStatusList"

    static const int kCallStatusList = 0;

    /**
     * Clears the field "CallStatusList".
     *
     * The field will be set to its default value. The hasCallStatusList()
     * method will return false.
     */
    inline void clearCallStatusList();

    /**
     * Checks whether the field "CallStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStatusList()). Otherwise it will return false.
     */
    inline bool hasCallStatusList () const;

    /**
     * Returns the value of the member "CallStatusList".
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @return The value of the field "CallStatusList"
     */
    inline const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getCallStatusList () const;

    /**
     * Retrieves the value of the field "CallStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallStatusList".
     */
    inline ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getCallStatusListMutable ();

    /**
     * Sets the value of the member "CallStatusList".
     *
     * Updates the status of the calls in the HFP connected devices.
     *
     *         Type representation- Array of Dict:
     *            [
     *               {
     *                  "DeviceAddress" : string
     *                  "Multiparty" : Boolean,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : uint8,
     *                                          "Status"          : string,
     *                                          "DurationHr"      : uint8,
     *                                          "DurationMin"     : uint8,
     *                                          "DurationSec"     : uint8,
     *                                          "TelephoneNumber" : string,
     *                                          "FirstName"       : string,
     *                                          "lastName"        : string,
     *                                          "ContactId"       : uint64,
     *                                          "Mode"            : uint8,
     *                                          "Type"            : uint8,
     *                                          "Direction"       : uint8
     *                                       }
     *                                    ]
     *               }
     *            ]
     *
     *            Example:
     *            [
     *               {
     *                  "DeviceAddress" : "aabbccddeeff",
     *                  "Multiparty"    : false,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Held",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "1234567890",
     *                                          "FirstName"       : "XX",
     *                                          "LastName"        : "YY",
     *                                          "ContactId"       : 0x123,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                       }
     *                                    ]
     *               },
     *               {
     *                  "DeviceAddress" : "gghhiijjkkll",
     *                  "Multiparty"    : true,
     *                  "CallInfoList"     : [
     *                                         {
     *                                          "Instance"        : 01,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "9876543210",
     *                                          "FirstName"       : "AA",
     *                                          "LastName"        : "BB",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         },
     *                                         {
     *                                          "Instance"        : 02,
     *                                          "Status"          : "Active",
     *                                          "DurationHr"      : 0x00,
     *                                          "DurationMin"     : 0x02,
     *                                          "DurationSec"     : 0x25,
     *                                          "TelephoneNumber" : "6789012345",
     *                                          "FirstName"       : "CC",
     *                                          "LastName"        : "DD",
     *                                          "ContactId"       : 0x223,
     *                                          "Mode"            : 0x01,
     *                                          "Type"            : 0x02,
     *                                          "Direction"       : 0x01
     *                                         }
     *                                       ]
     *               }
     *            ]
     *
     * @param CallStatusList The value which will be set
     */
    inline void setCallStatusList (const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusList_);

    static const CallStatusListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& getStringToCallStatusVariantMap_List_DefaultInstance ();

    inline void set_has_CallStatusList ();

    inline void clear_has_CallStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > > _CallStatusList;

};

/**
 * Updates the status of the calls in the HFP connected devices.
 *
 *         Type representation- Array of Dict:
 *            [
 *               {
 *                  "DeviceAddress" : string
 *                  "Multiparty" : Boolean,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : uint8,
 *                                          "Status"          : string,
 *                                          "DurationHr"      : uint8,
 *                                          "DurationMin"     : uint8,
 *                                          "DurationSec"     : uint8,
 *                                          "TelephoneNumber" : string,
 *                                          "FirstName"       : string,
 *                                          "lastName"        : string,
 *                                          "ContactId"       : uint64,
 *                                          "Mode"            : uint8,
 *                                          "Type"            : uint8,
 *                                          "Direction"       : uint8
 *                                       }
 *                                    ]
 *               }
 *            ]
 *
 *            Example:
 *            [
 *               {
 *                  "DeviceAddress" : "aabbccddeeff",
 *                  "Multiparty"    : false,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Held",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "1234567890",
 *                                          "FirstName"       : "XX",
 *                                          "LastName"        : "YY",
 *                                          "ContactId"       : 0x123,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                       }
 *                                    ]
 *               },
 *               {
 *                  "DeviceAddress" : "gghhiijjkkll",
 *                  "Multiparty"    : true,
 *                  "CallInfoList"     : [
 *                                         {
 *                                          "Instance"        : 01,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "9876543210",
 *                                          "FirstName"       : "AA",
 *                                          "LastName"        : "BB",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         },
 *                                         {
 *                                          "Instance"        : 02,
 *                                          "Status"          : "Active",
 *                                          "DurationHr"      : 0x00,
 *                                          "DurationMin"     : 0x02,
 *                                          "DurationSec"     : 0x25,
 *                                          "TelephoneNumber" : "6789012345",
 *                                          "FirstName"       : "CC",
 *                                          "LastName"        : "DD",
 *                                          "ContactId"       : 0x223,
 *                                          "Mode"            : 0x01,
 *                                          "Type"            : 0x02,
 *                                          "Direction"       : 0x01
 *                                         }
 *                                       ]
 *               }
 *            ]
 */
class CallStatusListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallStatusListRegister ();

    /**
     * Copy constructor
     */
    inline  CallStatusListRegister (const CallStatusListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CallStatusListRegister();

    /**
     * Assignment operator
     */
    inline CallStatusListRegister& operator = (const CallStatusListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CallStatusListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current mute state of the Microphone.
 *
 *         TRUE - Microphone mute state enabled.
 *         FALSE - Microphone mute state disabled [Default].
 */
class MicrophoneMuteStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneMuteStateUpdate ();

    /**
     * Copy constructor
     */
    inline  MicrophoneMuteStateUpdate (const MicrophoneMuteStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneMuteStateUpdate (bool MicrophoneMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneMuteStateUpdate();

    /**
     * Assignment operator
     */
    inline MicrophoneMuteStateUpdate& operator = (const MicrophoneMuteStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MicrophoneMuteState"

    static const int kMicrophoneMuteState = 0;

    /**
     * Clears the field "MicrophoneMuteState".
     *
     * The field will be set to its default value. The hasMicrophoneMuteState()
     * method will return false.
     */
    inline void clearMicrophoneMuteState();

    /**
     * Checks whether the field "MicrophoneMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicrophoneMuteState()). Otherwise it will return false.
     */
    inline bool hasMicrophoneMuteState () const;

    /**
     * Returns the value of the member "MicrophoneMuteState".
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @return The value of the field "MicrophoneMuteState"
     */
    inline bool getMicrophoneMuteState () const;

    /**
     * Sets the value of the member "MicrophoneMuteState".
     *
     * Provides the current mute state of the Microphone.
     *
     *         TRUE - Microphone mute state enabled.
     *         FALSE - Microphone mute state disabled [Default].
     *
     * @param MicrophoneMuteState The value which will be set
     */
    inline void setMicrophoneMuteState (bool MicrophoneMuteState_);

    static const MicrophoneMuteStateUpdate &getDefaultInstance();

private:

    inline void set_has_MicrophoneMuteState ();

    inline void clear_has_MicrophoneMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _MicrophoneMuteState;

};

/**
 * Provides the current mute state of the Microphone.
 *
 *         TRUE - Microphone mute state enabled.
 *         FALSE - Microphone mute state disabled [Default].
 */
class MicrophoneMuteStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneMuteStateRegister ();

    /**
     * Copy constructor
     */
    inline  MicrophoneMuteStateRegister (const MicrophoneMuteStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneMuteStateRegister();

    /**
     * Assignment operator
     */
    inline MicrophoneMuteStateRegister& operator = (const MicrophoneMuteStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneMuteStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneMuteStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneMuteStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneMuteStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MicrophoneMuteStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _VoiceCallManagerProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _VoiceCallManagerProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& VoiceCallManagerProperties_)  :
    _VoiceCallManagerProperties (VoiceCallManagerProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceCallManagerProperties()) {
            setVoiceCallManagerProperties(rhs.getVoiceCallManagerProperties());
        } else {
            clearVoiceCallManagerProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasVoiceCallManagerProperties() && !rhs.hasVoiceCallManagerProperties()) || getVoiceCallManagerProperties() == rhs.getVoiceCallManagerProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasVoiceCallManagerProperties() || rhs.hasVoiceCallManagerProperties()) {
        if (getVoiceCallManagerProperties() < rhs.getVoiceCallManagerProperties()) return true;
        if (getVoiceCallManagerProperties() > rhs.getVoiceCallManagerProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearVoiceCallManagerProperties();
}

inline void GetPropertiesResponse::clearVoiceCallManagerProperties() {
    if (hasVoiceCallManagerProperties()) {
         clear_has_VoiceCallManagerProperties();
        _VoiceCallManagerProperties.clear();
     }
}

inline bool GetPropertiesResponse::hasVoiceCallManagerProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& GetPropertiesResponse::getVoiceCallManagerProperties () const {
    return _VoiceCallManagerProperties;
}

inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& GetPropertiesResponse::getVoiceCallManagerPropertiesMutable () {
    set_has_VoiceCallManagerProperties();
    return _VoiceCallManagerProperties;
}

inline void GetPropertiesResponse::setVoiceCallManagerProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant >& VoiceCallManagerProperties_) {
    set_has_VoiceCallManagerProperties();
    this->_VoiceCallManagerProperties = VoiceCallManagerProperties_;
}

inline void GetPropertiesResponse::set_has_VoiceCallManagerProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_VoiceCallManagerProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MuteUnmuteMicrophoneRequest::MuteUnmuteMicrophoneRequest ()  :
    _MuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteUnmuteMicrophoneRequest::MuteUnmuteMicrophoneRequest (const MuteUnmuteMicrophoneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _MuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteUnmuteMicrophoneRequest::MuteUnmuteMicrophoneRequest (bool MuteState_)  :
    _MuteState (MuteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MuteUnmuteMicrophoneRequest::~MuteUnmuteMicrophoneRequest() {
}

inline MuteUnmuteMicrophoneRequest& MuteUnmuteMicrophoneRequest::operator = (const MuteUnmuteMicrophoneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
    }
    return *this;
}

inline bool MuteUnmuteMicrophoneRequest::operator == (const MuteUnmuteMicrophoneRequest& rhs) const {
    return (((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()));
}

inline bool MuteUnmuteMicrophoneRequest::operator != (const MuteUnmuteMicrophoneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteUnmuteMicrophoneRequest::operator < (const MuteUnmuteMicrophoneRequest& rhs) const {
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MuteUnmuteMicrophoneRequest::clone() {
    return new MuteUnmuteMicrophoneRequest(*this);
}

inline bool MuteUnmuteMicrophoneRequest::operator > (const MuteUnmuteMicrophoneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteUnmuteMicrophoneRequest::clear() {
    clearMuteState();
}

inline void MuteUnmuteMicrophoneRequest::clearMuteState() {
    if (hasMuteState()) {
         clear_has_MuteState();
        _MuteState = false;
     }
}

inline bool MuteUnmuteMicrophoneRequest::hasMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool MuteUnmuteMicrophoneRequest::getMuteState () const {
    return _MuteState;
}

inline void MuteUnmuteMicrophoneRequest::setMuteState (bool MuteState_) {
    set_has_MuteState();
    this->_MuteState = MuteState_;
}

inline void MuteUnmuteMicrophoneRequest::set_has_MuteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void MuteUnmuteMicrophoneRequest::clear_has_MuteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MergeCallsRequest::MergeCallsRequest ()  :
    _CallsToMerge ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MergeCallsRequest::MergeCallsRequest (const MergeCallsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CallsToMerge ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MergeCallsRequest::MergeCallsRequest (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToMerge_)  :
    _CallsToMerge (CallsToMerge_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MergeCallsRequest::~MergeCallsRequest() {
}

inline MergeCallsRequest& MergeCallsRequest::operator = (const MergeCallsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallsToMerge()) {
            setCallsToMerge(rhs.getCallsToMerge());
        } else {
            clearCallsToMerge();
        }
    }
    return *this;
}

inline bool MergeCallsRequest::operator == (const MergeCallsRequest& rhs) const {
    return (((!hasCallsToMerge() && !rhs.hasCallsToMerge()) || getCallsToMerge() == rhs.getCallsToMerge()));
}

inline bool MergeCallsRequest::operator != (const MergeCallsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MergeCallsRequest::operator < (const MergeCallsRequest& rhs) const {
    if (hasCallsToMerge() || rhs.hasCallsToMerge()) {
        if (getCallsToMerge() < rhs.getCallsToMerge()) return true;
        if (getCallsToMerge() > rhs.getCallsToMerge()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MergeCallsRequest::clone() {
    return new MergeCallsRequest(*this);
}

inline bool MergeCallsRequest::operator > (const MergeCallsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MergeCallsRequest::clear() {
    clearCallsToMerge();
}

inline void MergeCallsRequest::clearCallsToMerge() {
    if (hasCallsToMerge()) {
         clear_has_CallsToMerge();
        _CallsToMerge.clear();
     }
}

inline bool MergeCallsRequest::hasCallsToMerge () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MergeCallsRequest::getCallsToMerge () const {
    return _CallsToMerge;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MergeCallsRequest::getCallsToMergeMutable () {
    set_has_CallsToMerge();
    return _CallsToMerge;
}

inline void MergeCallsRequest::setCallsToMerge (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToMerge_) {
    set_has_CallsToMerge();
    this->_CallsToMerge = CallsToMerge_;
}

inline void MergeCallsRequest::set_has_CallsToMerge () {
    _has_bits_[0] |= 1u << 0;
}

inline void MergeCallsRequest::clear_has_CallsToMerge () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MergeCallsResponse::MergeCallsResponse ()  :
    _MultipartyCallsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MergeCallsResponse::MergeCallsResponse (const MergeCallsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _MultipartyCallsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MergeCallsResponse::MergeCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MultipartyCallsList_)  :
    _MultipartyCallsList (MultipartyCallsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MergeCallsResponse::~MergeCallsResponse() {
}

inline MergeCallsResponse& MergeCallsResponse::operator = (const MergeCallsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMultipartyCallsList()) {
            setMultipartyCallsList(rhs.getMultipartyCallsList());
        } else {
            clearMultipartyCallsList();
        }
    }
    return *this;
}

inline bool MergeCallsResponse::operator == (const MergeCallsResponse& rhs) const {
    return (((!hasMultipartyCallsList() && !rhs.hasMultipartyCallsList()) || getMultipartyCallsList() == rhs.getMultipartyCallsList()));
}

inline bool MergeCallsResponse::operator != (const MergeCallsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool MergeCallsResponse::operator < (const MergeCallsResponse& rhs) const {
    if (hasMultipartyCallsList() || rhs.hasMultipartyCallsList()) {
        if (getMultipartyCallsList() < rhs.getMultipartyCallsList()) return true;
        if (getMultipartyCallsList() > rhs.getMultipartyCallsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MergeCallsResponse::clone() {
    return new MergeCallsResponse(*this);
}

inline bool MergeCallsResponse::operator > (const MergeCallsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MergeCallsResponse::clear() {
    clearMultipartyCallsList();
}

inline void MergeCallsResponse::clearMultipartyCallsList() {
    if (hasMultipartyCallsList()) {
         clear_has_MultipartyCallsList();
        _MultipartyCallsList.clear();
     }
}

inline bool MergeCallsResponse::hasMultipartyCallsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MergeCallsResponse::getMultipartyCallsList () const {
    return _MultipartyCallsList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MergeCallsResponse::getMultipartyCallsListMutable () {
    set_has_MultipartyCallsList();
    return _MultipartyCallsList;
}

inline void MergeCallsResponse::setMultipartyCallsList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& MultipartyCallsList_) {
    set_has_MultipartyCallsList();
    this->_MultipartyCallsList = MultipartyCallsList_;
}

inline void MergeCallsResponse::set_has_MultipartyCallsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void MergeCallsResponse::clear_has_MultipartyCallsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SplitCallsRequest::SplitCallsRequest ()  :
    _CallsToSplit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SplitCallsRequest::SplitCallsRequest (const SplitCallsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CallsToSplit ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SplitCallsRequest::SplitCallsRequest (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToSplit_)  :
    _CallsToSplit (CallsToSplit_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SplitCallsRequest::~SplitCallsRequest() {
}

inline SplitCallsRequest& SplitCallsRequest::operator = (const SplitCallsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallsToSplit()) {
            setCallsToSplit(rhs.getCallsToSplit());
        } else {
            clearCallsToSplit();
        }
    }
    return *this;
}

inline bool SplitCallsRequest::operator == (const SplitCallsRequest& rhs) const {
    return (((!hasCallsToSplit() && !rhs.hasCallsToSplit()) || getCallsToSplit() == rhs.getCallsToSplit()));
}

inline bool SplitCallsRequest::operator != (const SplitCallsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SplitCallsRequest::operator < (const SplitCallsRequest& rhs) const {
    if (hasCallsToSplit() || rhs.hasCallsToSplit()) {
        if (getCallsToSplit() < rhs.getCallsToSplit()) return true;
        if (getCallsToSplit() > rhs.getCallsToSplit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SplitCallsRequest::clone() {
    return new SplitCallsRequest(*this);
}

inline bool SplitCallsRequest::operator > (const SplitCallsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SplitCallsRequest::clear() {
    clearCallsToSplit();
}

inline void SplitCallsRequest::clearCallsToSplit() {
    if (hasCallsToSplit()) {
         clear_has_CallsToSplit();
        _CallsToSplit.clear();
     }
}

inline bool SplitCallsRequest::hasCallsToSplit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsRequest::getCallsToSplit () const {
    return _CallsToSplit;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsRequest::getCallsToSplitMutable () {
    set_has_CallsToSplit();
    return _CallsToSplit;
}

inline void SplitCallsRequest::setCallsToSplit (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& CallsToSplit_) {
    set_has_CallsToSplit();
    this->_CallsToSplit = CallsToSplit_;
}

inline void SplitCallsRequest::set_has_CallsToSplit () {
    _has_bits_[0] |= 1u << 0;
}

inline void SplitCallsRequest::clear_has_CallsToSplit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SplitCallsResponse::SplitCallsResponse ()  :
    _SplitCallsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SplitCallsResponse::SplitCallsResponse (const SplitCallsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _SplitCallsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SplitCallsResponse::SplitCallsResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsList_)  :
    _SplitCallsList (SplitCallsList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SplitCallsResponse::~SplitCallsResponse() {
}

inline SplitCallsResponse& SplitCallsResponse::operator = (const SplitCallsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSplitCallsList()) {
            setSplitCallsList(rhs.getSplitCallsList());
        } else {
            clearSplitCallsList();
        }
    }
    return *this;
}

inline bool SplitCallsResponse::operator == (const SplitCallsResponse& rhs) const {
    return (((!hasSplitCallsList() && !rhs.hasSplitCallsList()) || getSplitCallsList() == rhs.getSplitCallsList()));
}

inline bool SplitCallsResponse::operator != (const SplitCallsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SplitCallsResponse::operator < (const SplitCallsResponse& rhs) const {
    if (hasSplitCallsList() || rhs.hasSplitCallsList()) {
        if (getSplitCallsList() < rhs.getSplitCallsList()) return true;
        if (getSplitCallsList() > rhs.getSplitCallsList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SplitCallsResponse::clone() {
    return new SplitCallsResponse(*this);
}

inline bool SplitCallsResponse::operator > (const SplitCallsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SplitCallsResponse::clear() {
    clearSplitCallsList();
}

inline void SplitCallsResponse::clearSplitCallsList() {
    if (hasSplitCallsList()) {
         clear_has_SplitCallsList();
        _SplitCallsList.clear();
     }
}

inline bool SplitCallsResponse::hasSplitCallsList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsResponse::getSplitCallsList () const {
    return _SplitCallsList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsResponse::getSplitCallsListMutable () {
    set_has_SplitCallsList();
    return _SplitCallsList;
}

inline void SplitCallsResponse::setSplitCallsList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& SplitCallsList_) {
    set_has_SplitCallsList();
    this->_SplitCallsList = SplitCallsList_;
}

inline void SplitCallsResponse::set_has_SplitCallsList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SplitCallsResponse::clear_has_SplitCallsList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HangupAllRequest::HangupAllRequest ()  :
    _deviceAddressList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HangupAllRequest::HangupAllRequest (const HangupAllRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _deviceAddressList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HangupAllRequest::HangupAllRequest (const ::std::vector< ::std::string >& deviceAddressList_)  :
    _deviceAddressList (deviceAddressList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HangupAllRequest::~HangupAllRequest() {
}

inline HangupAllRequest& HangupAllRequest::operator = (const HangupAllRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddressList()) {
            setDeviceAddressList(rhs.getDeviceAddressList());
        } else {
            clearDeviceAddressList();
        }
    }
    return *this;
}

inline bool HangupAllRequest::operator == (const HangupAllRequest& rhs) const {
    return (((!hasDeviceAddressList() && !rhs.hasDeviceAddressList()) || getDeviceAddressList() == rhs.getDeviceAddressList()));
}

inline bool HangupAllRequest::operator != (const HangupAllRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool HangupAllRequest::operator < (const HangupAllRequest& rhs) const {
    if (hasDeviceAddressList() || rhs.hasDeviceAddressList()) {
        if (getDeviceAddressList() < rhs.getDeviceAddressList()) return true;
        if (getDeviceAddressList() > rhs.getDeviceAddressList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HangupAllRequest::clone() {
    return new HangupAllRequest(*this);
}

inline bool HangupAllRequest::operator > (const HangupAllRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HangupAllRequest::clear() {
    clearDeviceAddressList();
}

inline void HangupAllRequest::clearDeviceAddressList() {
    if (hasDeviceAddressList()) {
         clear_has_deviceAddressList();
        _deviceAddressList.clear();
     }
}

inline bool HangupAllRequest::hasDeviceAddressList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& HangupAllRequest::getDeviceAddressList () const {
    return _deviceAddressList;
}

inline ::std::vector< ::std::string >& HangupAllRequest::getDeviceAddressListMutable () {
    set_has_deviceAddressList();
    return _deviceAddressList;
}

inline void HangupAllRequest::setDeviceAddressList (const ::std::vector< ::std::string >& deviceAddressList_) {
    set_has_deviceAddressList();
    this->_deviceAddressList = deviceAddressList_;
}

inline void HangupAllRequest::set_has_deviceAddressList () {
    _has_bits_[0] |= 1u << 0;
}

inline void HangupAllRequest::clear_has_deviceAddressList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RedialRequest::RedialRequest ()  :
    _DeviceAddressIn (),
    _HideCallerID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RedialRequest::RedialRequest (const RedialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceAddressIn (),
    _HideCallerID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RedialRequest::RedialRequest (const ::std::string& DeviceAddressIn_, uint8 HideCallerID_)  :
    _DeviceAddressIn (DeviceAddressIn_),
    _HideCallerID (HideCallerID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressIn_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RedialRequest::~RedialRequest() {
}

inline RedialRequest& RedialRequest::operator = (const RedialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddressIn()) {
            setDeviceAddressIn(rhs.getDeviceAddressIn());
        } else {
            clearDeviceAddressIn();
        }
        if (rhs.hasHideCallerID()) {
            setHideCallerID(rhs.getHideCallerID());
        } else {
            clearHideCallerID();
        }
    }
    return *this;
}

inline bool RedialRequest::operator == (const RedialRequest& rhs) const {
    return (((!hasDeviceAddressIn() && !rhs.hasDeviceAddressIn()) || getDeviceAddressIn() == rhs.getDeviceAddressIn()) &&
        ((!hasHideCallerID() && !rhs.hasHideCallerID()) || getHideCallerID() == rhs.getHideCallerID()));
}

inline bool RedialRequest::operator != (const RedialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RedialRequest::operator < (const RedialRequest& rhs) const {
    if (hasDeviceAddressIn() || rhs.hasDeviceAddressIn()) {
        if (getDeviceAddressIn() < rhs.getDeviceAddressIn()) return true;
        if (getDeviceAddressIn() > rhs.getDeviceAddressIn()) return false;
    }
    if (hasHideCallerID() || rhs.hasHideCallerID()) {
        if (getHideCallerID() < rhs.getHideCallerID()) return true;
        if (getHideCallerID() > rhs.getHideCallerID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RedialRequest::clone() {
    return new RedialRequest(*this);
}

inline bool RedialRequest::operator > (const RedialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RedialRequest::clear() {
    clearDeviceAddressIn();
    clearHideCallerID();
}

inline void RedialRequest::clearDeviceAddressIn() {
    if (hasDeviceAddressIn()) {
         clear_has_DeviceAddressIn();
        _DeviceAddressIn.clear();
     }
}

inline bool RedialRequest::hasDeviceAddressIn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RedialRequest::getDeviceAddressIn () const {
    return _DeviceAddressIn;
}

inline ::std::string& RedialRequest::getDeviceAddressInMutable () {
    set_has_DeviceAddressIn();
    return _DeviceAddressIn;
}

inline void RedialRequest::setDeviceAddressIn (const ::std::string& DeviceAddressIn_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressIn_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressIn();
    this->_DeviceAddressIn = DeviceAddressIn_;
}

inline void RedialRequest::setDeviceAddressIn (const char* DeviceAddressIn_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressIn_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressIn();
    this->_DeviceAddressIn.assign(DeviceAddressIn_);
}

inline void RedialRequest::setDeviceAddressIn (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressIn();
    this->_DeviceAddressIn.assign(value, size);
}

inline void RedialRequest::clearHideCallerID() {
    if (hasHideCallerID()) {
         clear_has_HideCallerID();
        _HideCallerID = 0u;
     }
}

inline bool RedialRequest::hasHideCallerID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 RedialRequest::getHideCallerID () const {
    return _HideCallerID;
}

inline void RedialRequest::setHideCallerID (uint8 HideCallerID_) {
    set_has_HideCallerID();
    this->_HideCallerID = HideCallerID_;
}

inline void RedialRequest::set_has_DeviceAddressIn () {
    _has_bits_[0] |= 1u << 0;
}

inline void RedialRequest::clear_has_DeviceAddressIn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RedialRequest::set_has_HideCallerID () {
    _has_bits_[0] |= 1u << 1;
}

inline void RedialRequest::clear_has_HideCallerID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RedialResponse::RedialResponse ()  :
    _DeviceAddressOut (),
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RedialResponse::RedialResponse (const RedialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceAddressOut (),
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RedialResponse::RedialResponse (const ::std::string& DeviceAddressOut_, uint8 CallInstance_)  :
    _DeviceAddressOut (DeviceAddressOut_),
    _CallInstance (CallInstance_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressOut_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RedialResponse::~RedialResponse() {
}

inline RedialResponse& RedialResponse::operator = (const RedialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddressOut()) {
            setDeviceAddressOut(rhs.getDeviceAddressOut());
        } else {
            clearDeviceAddressOut();
        }
        if (rhs.hasCallInstance()) {
            setCallInstance(rhs.getCallInstance());
        } else {
            clearCallInstance();
        }
    }
    return *this;
}

inline bool RedialResponse::operator == (const RedialResponse& rhs) const {
    return (((!hasDeviceAddressOut() && !rhs.hasDeviceAddressOut()) || getDeviceAddressOut() == rhs.getDeviceAddressOut()) &&
        ((!hasCallInstance() && !rhs.hasCallInstance()) || getCallInstance() == rhs.getCallInstance()));
}

inline bool RedialResponse::operator != (const RedialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RedialResponse::operator < (const RedialResponse& rhs) const {
    if (hasDeviceAddressOut() || rhs.hasDeviceAddressOut()) {
        if (getDeviceAddressOut() < rhs.getDeviceAddressOut()) return true;
        if (getDeviceAddressOut() > rhs.getDeviceAddressOut()) return false;
    }
    if (hasCallInstance() || rhs.hasCallInstance()) {
        if (getCallInstance() < rhs.getCallInstance()) return true;
        if (getCallInstance() > rhs.getCallInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RedialResponse::clone() {
    return new RedialResponse(*this);
}

inline bool RedialResponse::operator > (const RedialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RedialResponse::clear() {
    clearDeviceAddressOut();
    clearCallInstance();
}

inline void RedialResponse::clearDeviceAddressOut() {
    if (hasDeviceAddressOut()) {
         clear_has_DeviceAddressOut();
        _DeviceAddressOut.clear();
     }
}

inline bool RedialResponse::hasDeviceAddressOut () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RedialResponse::getDeviceAddressOut () const {
    return _DeviceAddressOut;
}

inline ::std::string& RedialResponse::getDeviceAddressOutMutable () {
    set_has_DeviceAddressOut();
    return _DeviceAddressOut;
}

inline void RedialResponse::setDeviceAddressOut (const ::std::string& DeviceAddressOut_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressOut_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressOut();
    this->_DeviceAddressOut = DeviceAddressOut_;
}

inline void RedialResponse::setDeviceAddressOut (const char* DeviceAddressOut_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddressOut_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressOut();
    this->_DeviceAddressOut.assign(DeviceAddressOut_);
}

inline void RedialResponse::setDeviceAddressOut (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddressOut();
    this->_DeviceAddressOut.assign(value, size);
}

inline void RedialResponse::clearCallInstance() {
    if (hasCallInstance()) {
         clear_has_CallInstance();
        _CallInstance = 0u;
     }
}

inline bool RedialResponse::hasCallInstance () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 RedialResponse::getCallInstance () const {
    return _CallInstance;
}

inline void RedialResponse::setCallInstance (uint8 CallInstance_) {
    set_has_CallInstance();
    this->_CallInstance = CallInstance_;
}

inline void RedialResponse::set_has_DeviceAddressOut () {
    _has_bits_[0] |= 1u << 0;
}

inline void RedialResponse::clear_has_DeviceAddressOut () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RedialResponse::set_has_CallInstance () {
    _has_bits_[0] |= 1u << 1;
}

inline void RedialResponse::clear_has_CallInstance () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CallStatusListUpdate::CallStatusListUpdate ()  :
    _CallStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallStatusListUpdate::CallStatusListUpdate (const CallStatusListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CallStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallStatusListUpdate::CallStatusListUpdate (const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusList_)  :
    _CallStatusList (CallStatusList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CallStatusListUpdate::~CallStatusListUpdate() {
}

inline CallStatusListUpdate& CallStatusListUpdate::operator = (const CallStatusListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallStatusList()) {
            setCallStatusList(rhs.getCallStatusList());
        } else {
            clearCallStatusList();
        }
    }
    return *this;
}

inline bool CallStatusListUpdate::operator == (const CallStatusListUpdate& rhs) const {
    return (((!hasCallStatusList() && !rhs.hasCallStatusList()) || getCallStatusList() == rhs.getCallStatusList()));
}

inline bool CallStatusListUpdate::operator != (const CallStatusListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CallStatusListUpdate::operator < (const CallStatusListUpdate& rhs) const {
    if (hasCallStatusList() || rhs.hasCallStatusList()) {
        if (getCallStatusList() < rhs.getCallStatusList()) return true;
        if (getCallStatusList() > rhs.getCallStatusList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CallStatusListUpdate::clone() {
    return new CallStatusListUpdate(*this);
}

inline bool CallStatusListUpdate::operator > (const CallStatusListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallStatusListUpdate::clear() {
    clearCallStatusList();
}

inline void CallStatusListUpdate::clearCallStatusList() {
    if (hasCallStatusList()) {
         clear_has_CallStatusList();
        _CallStatusList.clear();
     }
}

inline bool CallStatusListUpdate::hasCallStatusList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusListUpdate::getCallStatusList () const {
    return _CallStatusList;
}

inline ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusListUpdate::getCallStatusListMutable () {
    set_has_CallStatusList();
    return _CallStatusList;
}

inline void CallStatusListUpdate::setCallStatusList (const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& CallStatusList_) {
    set_has_CallStatusList();
    this->_CallStatusList = CallStatusList_;
}

inline void CallStatusListUpdate::set_has_CallStatusList () {
    _has_bits_[0] |= 1u << 0;
}

inline void CallStatusListUpdate::clear_has_CallStatusList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CallStatusListRegister::CallStatusListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallStatusListRegister::CallStatusListRegister (const CallStatusListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallStatusListRegister::~CallStatusListRegister() {
}

inline CallStatusListRegister& CallStatusListRegister::operator = (const CallStatusListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CallStatusListRegister::operator == (const CallStatusListRegister& ) const {
    return true;
}

inline bool CallStatusListRegister::operator != (const CallStatusListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CallStatusListRegister::operator < (const CallStatusListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CallStatusListRegister::clone() {
    return new CallStatusListRegister(*this);
}

inline bool CallStatusListRegister::operator > (const CallStatusListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallStatusListRegister::clear() {
}

inline  MicrophoneMuteStateUpdate::MicrophoneMuteStateUpdate ()  :
    _MicrophoneMuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MicrophoneMuteStateUpdate::MicrophoneMuteStateUpdate (const MicrophoneMuteStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _MicrophoneMuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MicrophoneMuteStateUpdate::MicrophoneMuteStateUpdate (bool MicrophoneMuteState_)  :
    _MicrophoneMuteState (MicrophoneMuteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MicrophoneMuteStateUpdate::~MicrophoneMuteStateUpdate() {
}

inline MicrophoneMuteStateUpdate& MicrophoneMuteStateUpdate::operator = (const MicrophoneMuteStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMicrophoneMuteState()) {
            setMicrophoneMuteState(rhs.getMicrophoneMuteState());
        } else {
            clearMicrophoneMuteState();
        }
    }
    return *this;
}

inline bool MicrophoneMuteStateUpdate::operator == (const MicrophoneMuteStateUpdate& rhs) const {
    return (((!hasMicrophoneMuteState() && !rhs.hasMicrophoneMuteState()) || getMicrophoneMuteState() == rhs.getMicrophoneMuteState()));
}

inline bool MicrophoneMuteStateUpdate::operator != (const MicrophoneMuteStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MicrophoneMuteStateUpdate::operator < (const MicrophoneMuteStateUpdate& rhs) const {
    if (hasMicrophoneMuteState() || rhs.hasMicrophoneMuteState()) {
        if (getMicrophoneMuteState() < rhs.getMicrophoneMuteState()) return true;
        if (getMicrophoneMuteState() > rhs.getMicrophoneMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MicrophoneMuteStateUpdate::clone() {
    return new MicrophoneMuteStateUpdate(*this);
}

inline bool MicrophoneMuteStateUpdate::operator > (const MicrophoneMuteStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MicrophoneMuteStateUpdate::clear() {
    clearMicrophoneMuteState();
}

inline void MicrophoneMuteStateUpdate::clearMicrophoneMuteState() {
    if (hasMicrophoneMuteState()) {
         clear_has_MicrophoneMuteState();
        _MicrophoneMuteState = false;
     }
}

inline bool MicrophoneMuteStateUpdate::hasMicrophoneMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool MicrophoneMuteStateUpdate::getMicrophoneMuteState () const {
    return _MicrophoneMuteState;
}

inline void MicrophoneMuteStateUpdate::setMicrophoneMuteState (bool MicrophoneMuteState_) {
    set_has_MicrophoneMuteState();
    this->_MicrophoneMuteState = MicrophoneMuteState_;
}

inline void MicrophoneMuteStateUpdate::set_has_MicrophoneMuteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void MicrophoneMuteStateUpdate::clear_has_MicrophoneMuteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MicrophoneMuteStateRegister::MicrophoneMuteStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MicrophoneMuteStateRegister::MicrophoneMuteStateRegister (const MicrophoneMuteStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MicrophoneMuteStateRegister::~MicrophoneMuteStateRegister() {
}

inline MicrophoneMuteStateRegister& MicrophoneMuteStateRegister::operator = (const MicrophoneMuteStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MicrophoneMuteStateRegister::operator == (const MicrophoneMuteStateRegister& ) const {
    return true;
}

inline bool MicrophoneMuteStateRegister::operator != (const MicrophoneMuteStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MicrophoneMuteStateRegister::operator < (const MicrophoneMuteStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MicrophoneMuteStateRegister::clone() {
    return new MicrophoneMuteStateRegister(*this);
}

inline bool MicrophoneMuteStateRegister::operator > (const MicrophoneMuteStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MicrophoneMuteStateRegister::clear() {
}

} // namespace VoiceCallManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALLMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
