/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/PMAppTypeCollectionsDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of StructofStringUInt8

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::StructofStringUInt8& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint8 o1 = in.getUInt8Value();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BYTE, &o1));
        const char* o2 = in.getStringValue().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o2));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::StructofStringUInt8& out) {
    {
        DBusMessageIter o3;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o3);
                {
                    uint8 UInt8ValueValue;
                    uint8 &UInt8ValueTmpValue = UInt8ValueValue;
                    dbus_message_iter_get_basic(&o3, &UInt8ValueTmpValue);
                    out.setUInt8Value(UInt8ValueValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

                {
                    ::std::string StringValueValue;
                    ::std::string &StringValueTmpValue = StringValueValue;
                    {
                        char* o4 = 0;
                        dbus_message_iter_get_basic(&o3, &o4);
                        StringValueTmpValue.assign (o4);
                    }
                    out.setStringValue(StringValueValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SystemWideRingtonesListType

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& in, DBusMessageIter* out) {
    {
        DBusMessageIter o5Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o5Struct));
        uint8 o6 = in.getActiveSystemRingtoneID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_BYTE, &o6));
        DBusMessageIter o7ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o5Struct, DBUS_TYPE_ARRAY, "(ys)", &o7ArrayIter));
        const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo >* o8 = &in.getSystemRingtoneList();
        ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo >::const_iterator o9 = o8->end();
        for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo >::const_iterator o10 = o8->begin(); o10 != o9; ++o10) {
            serializeDBus((*o10), &o7ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o5Struct, &o7ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o5Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& out) {
    {
        DBusMessageIter o11;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o11);
                {
                    uint8 ActiveSystemRingtoneIDValue;
                    uint8 &ActiveSystemRingtoneIDTmpValue = ActiveSystemRingtoneIDValue;
                    dbus_message_iter_get_basic(&o11, &ActiveSystemRingtoneIDTmpValue);
                    out.setActiveSystemRingtoneID(ActiveSystemRingtoneIDValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo > systemRingtoneListValue;

                    if (dbus_message_iter_get_arg_type(&o11) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o12ArrayIter;
                        dbus_message_iter_recurse (&o11, &o12ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o12ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo o13;
                                if (!deserializeDBus(&o12ArrayIter, o13)) {
                                    return false;
                                }
                                systemRingtoneListValue.push_back(o13);
                            } while (dbus_message_iter_next(&o12ArrayIter));
                        }
                    }
                    out.setSystemRingtoneList(systemRingtoneListValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DeviceRingtoneInfo

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        const char* o15 = in.getDeviceAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_STRING, &o15));
        serializeDBus(in.getRingtoneInfo(), &o14Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo& out) {
    {
        DBusMessageIter o16;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o16);
                {
                    ::std::string DeviceAddressValue;
                    ::std::string &DeviceAddressTmpValue = DeviceAddressValue;
                    {
                        char* o17 = 0;
                        dbus_message_iter_get_basic(&o16, &o17);
                        DeviceAddressTmpValue.assign (o17);
                    }
                    out.setDeviceAddress(DeviceAddressValue);
                }

                if (dbus_message_iter_has_next(&o16)) {
                    dbus_message_iter_next(&o16);
                } else {
                    return true;
                }

                {
                    ::com::bosch::pmapp::PMAppTypeCollections::RingtoneInfo ringtoneInfoValue;
                    if (!deserializeDBus(&o16, ringtoneInfoValue)) {
                        return false;
                    }
                    out.setRingtoneInfo(ringtoneInfoValue);
                }

                if (dbus_message_iter_has_next(&o16)) {
                    dbus_message_iter_next(&o16);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of OnOffSetting

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& in, DBusMessageIter* out) {
    {
        DBusMessageIter o18Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o18Struct));
        const char* o19 = in.getDeviceAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o18Struct, DBUS_TYPE_STRING, &o19));
        dbus_bool_t o20 = in.getOnOffValue() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o18Struct, DBUS_TYPE_BOOLEAN, &o20));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o18Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& out) {
    {
        DBusMessageIter o21;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o21);
                {
                    ::std::string DeviceAddressValue;
                    ::std::string &DeviceAddressTmpValue = DeviceAddressValue;
                    {
                        char* o22 = 0;
                        dbus_message_iter_get_basic(&o21, &o22);
                        DeviceAddressTmpValue.assign (o22);
                    }
                    out.setDeviceAddress(DeviceAddressValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    bool OnOffValueValue;
                    bool &OnOffValueTmpValue = OnOffValueValue;
                    {
                        dbus_bool_t o23;
                        dbus_message_iter_get_basic(&o21, &o23);
                        OnOffValueTmpValue = o23 ? true : false;
                    }
                    out.setOnOffValue(OnOffValueValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DeviceObjectPathInfo

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o24Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o24Struct));
        const char* o25 = in.getDeviceAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o24Struct, DBUS_TYPE_STRING, &o25));
        const char* o26 = in.getObjectPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o24Struct, DBUS_TYPE_STRING, &o26));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o24Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo& out) {
    {
        DBusMessageIter o27;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o27);
                {
                    ::std::string DeviceAddressValue;
                    ::std::string &DeviceAddressTmpValue = DeviceAddressValue;
                    {
                        char* o28 = 0;
                        dbus_message_iter_get_basic(&o27, &o28);
                        DeviceAddressTmpValue.assign (o28);
                    }
                    out.setDeviceAddress(DeviceAddressValue);
                }

                if (dbus_message_iter_has_next(&o27)) {
                    dbus_message_iter_next(&o27);
                } else {
                    return true;
                }

                {
                    ::std::string ObjectPathValue;
                    ::std::string &ObjectPathTmpValue = ObjectPathValue;
                    {
                        char* o29 = 0;
                        dbus_message_iter_get_basic(&o27, &o29);
                        ObjectPathTmpValue.assign (o29);
                    }
                    out.setObjectPath(ObjectPathValue);
                }

                if (dbus_message_iter_has_next(&o27)) {
                    dbus_message_iter_next(&o27);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of HfpManagerVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant& in, DBusMessageIter* out) {
    DBusMessageIter o30Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o30Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_BOOLEAN:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o31Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "b", &o31Variant));
                dbus_bool_t o32 = in.getBoolean() ? TRUE : FALSE;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o31Variant, DBUS_TYPE_BOOLEAN, &o32));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o31Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_SYSTEM_WIDE_RINGTONES_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o33Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "(ya(ys))", &o33Variant));
                serializeDBus(in.getSystemWideRingtonesListType(), &o33Variant);
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o33Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_DEVICE_RINGTONE_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 2;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o34Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a(s(ys))", &o34Variant));
                DBusMessageIter o35ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o34Variant, DBUS_TYPE_ARRAY, "(s(ys))", &o35ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >* o36 = &in.getDeviceRingtoneListType();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >::const_iterator o37 = o36->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >::const_iterator o38 = o36->begin(); o38 != o37; ++o38) {
                    serializeDBus((*o38), &o35ArrayIter);
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o34Variant, &o35ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o34Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_SUPPRESS_RINGTONE_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 3;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o39Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a(sb)", &o39Variant));
                DBusMessageIter o40ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o39Variant, DBUS_TYPE_ARRAY, "(sb)", &o40ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >* o41 = &in.getSuppressRingtoneListType();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >::const_iterator o42 = o41->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >::const_iterator o43 = o41->begin(); o43 != o42; ++o43) {
                    serializeDBus((*o43), &o40ArrayIter);
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o39Variant, &o40ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o39Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_AUTO_WAITING_MODE_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 4;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o44Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a(sb)", &o44Variant));
                DBusMessageIter o45ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o44Variant, DBUS_TYPE_ARRAY, "(sb)", &o45ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >* o46 = &in.getAutoWaitingModeListType();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >::const_iterator o47 = o46->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >::const_iterator o48 = o46->begin(); o48 != o47; ++o48) {
                    serializeDBus((*o48), &o45ArrayIter);
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o44Variant, &o45ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o44Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_WAITING_MODE_FILE_PATH_TYPE:
            {
                uint32 enumSelector = (uint32) 5;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o49Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a{ss}", &o49Variant));
                DBusMessageIter o50ArrayIter;
                DBusMessageIter o51DictIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o49Variant, DBUS_TYPE_ARRAY, "{ss}", &o50ArrayIter));
                const ::std::map< ::std::string, ::std::string >* o52 = &in.getWaitingModeFilePathType();
                ::std::map< ::std::string, ::std::string >::const_iterator o53 = o52->end();
                for (::std::map< ::std::string, ::std::string >::const_iterator o54 = o52->begin(); o54 != o53; ++o54) {
                    DBUS_ASSERT(dbus_message_iter_open_container(&o50ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o51DictIter));
                    const char* o55 = o54->first.c_str();
                    DBUS_ASSERT(dbus_message_iter_append_basic(&o51DictIter, DBUS_TYPE_STRING, &o55));
                    const char* o56 = o54->second.c_str();
                    DBUS_ASSERT(dbus_message_iter_append_basic(&o51DictIter, DBUS_TYPE_STRING, &o56));
                    DBUS_ASSERT(dbus_message_iter_close_container(&o50ArrayIter, &o51DictIter)); // close dict container
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o49Variant, &o50ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o49Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 6;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o57Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a(ys)", &o57Variant));
                DBusMessageIter o58ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o57Variant, DBUS_TYPE_ARRAY, "(ys)", &o58ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >* o59 = &in.getActivePassiveDeviceListType();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >::const_iterator o60 = o59->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >::const_iterator o61 = o59->begin(); o61 != o60; ++o61) {
                    serializeDBus((*o61), &o58ArrayIter);
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o57Variant, &o58ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o57Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_DEVICE_OBJECT_PATH_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 7;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o30Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o62Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o30Struct, DBUS_TYPE_VARIANT, "a(ss)", &o62Variant));
                DBusMessageIter o63ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o62Variant, DBUS_TYPE_ARRAY, "(ss)", &o63ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >* o64 = &in.getDeviceObjectPathListType();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >::const_iterator o65 = o64->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >::const_iterator o66 = o64->begin(); o66 != o65; ++o66) {
                    serializeDBus((*o66), &o63ArrayIter);
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o62Variant, &o63ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o30Struct, &o62Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o30Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o67Struct;
        uint32 HfpManagerVariantFieldId;
        dbus_message_iter_recurse (in, &o67Struct);
        dbus_message_iter_get_basic(&o67Struct, &HfpManagerVariantFieldId);
        dbus_message_iter_next(&o67Struct);

        if (dbus_message_iter_get_arg_type(&o67Struct) != DBUS_TYPE_INVALID) {
            switch (HfpManagerVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o68Variant;
                        dbus_message_iter_recurse (&o67Struct, &o68Variant);
                        {
                            bool booleanValue;
                            bool &booleanTmpValue = booleanValue;
                            {
                                dbus_bool_t o69;
                                dbus_message_iter_get_basic(&o68Variant, &o69);
                                booleanTmpValue = o69 ? true : false;
                            }
                            out.setBoolean(booleanValue);
                        }

                        if (dbus_message_iter_has_next(&o68Variant)) {
                            dbus_message_iter_next(&o68Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o70Variant;
                        dbus_message_iter_recurse (&o67Struct, &o70Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_SYSTEM_WIDE_RINGTONES_LIST_TYPE);
                        if (!deserializeDBus(&o70Variant, out.getSystemWideRingtonesListTypeMutable())) {
                            return false;
                        }
                        break;
                    }
                case 2:
                    {
                        DBusMessageIter o71Variant;
                        dbus_message_iter_recurse (&o67Struct, &o71Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_DEVICE_RINGTONE_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o71Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o72ArrayIter;
                            dbus_message_iter_recurse (&o71Variant, &o72ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o72ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo o73;
                                    if (!deserializeDBus(&o72ArrayIter, o73)) {
                                        return false;
                                    }
                                    out.getDeviceRingtoneListTypeMutable().push_back(o73);
                                } while (dbus_message_iter_next(&o72ArrayIter));
                            }
                        }
                        break;
                    }
                case 3:
                    {
                        DBusMessageIter o74Variant;
                        dbus_message_iter_recurse (&o67Struct, &o74Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_SUPPRESS_RINGTONE_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o74Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o75ArrayIter;
                            dbus_message_iter_recurse (&o74Variant, &o75ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o75ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting o76;
                                    if (!deserializeDBus(&o75ArrayIter, o76)) {
                                        return false;
                                    }
                                    out.getSuppressRingtoneListTypeMutable().push_back(o76);
                                } while (dbus_message_iter_next(&o75ArrayIter));
                            }
                        }
                        break;
                    }
                case 4:
                    {
                        DBusMessageIter o77Variant;
                        dbus_message_iter_recurse (&o67Struct, &o77Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_AUTO_WAITING_MODE_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o77Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o78ArrayIter;
                            dbus_message_iter_recurse (&o77Variant, &o78ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o78ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting o79;
                                    if (!deserializeDBus(&o78ArrayIter, o79)) {
                                        return false;
                                    }
                                    out.getAutoWaitingModeListTypeMutable().push_back(o79);
                                } while (dbus_message_iter_next(&o78ArrayIter));
                            }
                        }
                        break;
                    }
                case 5:
                    {
                        DBusMessageIter o80Variant;
                        dbus_message_iter_recurse (&o67Struct, &o80Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_WAITING_MODE_FILE_PATH_TYPE);

                        if (dbus_message_iter_get_arg_type(&o80Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o81ArrayIter;
                            DBusMessageIter o82DictIter;
                            dbus_message_iter_recurse (&o80Variant, &o81ArrayIter);

                            if (dbus_message_iter_get_arg_type(&o81ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::std::string o83Key;
                                    ::std::string o83Value;
                                    dbus_message_iter_recurse (&o81ArrayIter, &o82DictIter);
                                    {
                                        char* o84 = 0;
                                        dbus_message_iter_get_basic(&o82DictIter, &o84);
                                        o83Key.assign (o84);
                                    }
                                    dbus_message_iter_next(&o82DictIter);
                                    {
                                        char* o85 = 0;
                                        dbus_message_iter_get_basic(&o82DictIter, &o85);
                                        o83Value.assign (o85);
                                    }
                                    out.getWaitingModeFilePathTypeMutable().insert(std::pair< ::std::string, ::std::string >(o83Key, o83Value));
                                } while (dbus_message_iter_next(&o81ArrayIter));
                            }
                        }
                        break;
                    }
                case 6:
                    {
                        DBusMessageIter o86Variant;
                        dbus_message_iter_recurse (&o67Struct, &o86Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o86Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o87ArrayIter;
                            dbus_message_iter_recurse (&o86Variant, &o87ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o87ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo o88;
                                    if (!deserializeDBus(&o87ArrayIter, o88)) {
                                        return false;
                                    }
                                    out.getActivePassiveDeviceListTypeMutable().push_back(o88);
                                } while (dbus_message_iter_next(&o87ArrayIter));
                            }
                        }
                        break;
                    }
                case 7:
                    {
                        DBusMessageIter o89Variant;
                        dbus_message_iter_recurse (&o67Struct, &o89Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant::E_DEVICE_OBJECT_PATH_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o89Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o90ArrayIter;
                            dbus_message_iter_recurse (&o89Variant, &o90ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o90ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo o91;
                                    if (!deserializeDBus(&o90ArrayIter, o91)) {
                                        return false;
                                    }
                                    out.getDeviceObjectPathListTypeMutable().push_back(o91);
                                } while (dbus_message_iter_next(&o90ArrayIter));
                            }
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceInfoVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant& in, DBusMessageIter* out) {
    DBusMessageIter o92Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o92Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant::E_UINT8:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o92Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o93Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o92Struct, DBUS_TYPE_VARIANT, "y", &o93Variant));
                uint8 o94 = in.getUint8();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o93Variant, DBUS_TYPE_BYTE, &o94));
                DBUS_ASSERT(dbus_message_iter_close_container(&o92Struct, &o93Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant::E_STRING:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o92Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o95Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o92Struct, DBUS_TYPE_VARIANT, "s", &o95Variant));
                const char* o96 = in.getString().c_str();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o95Variant, DBUS_TYPE_STRING, &o96));
                DBUS_ASSERT(dbus_message_iter_close_container(&o92Struct, &o95Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant::E_SUPPORTED_FEATURES_LIST:
            {
                uint32 enumSelector = (uint32) 2;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o92Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o97Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o92Struct, DBUS_TYPE_VARIANT, "as", &o97Variant));
                DBusMessageIter o98ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o97Variant, DBUS_TYPE_ARRAY, "s", &o98ArrayIter));
                const ::std::vector< ::std::string >* o99 = &in.getSupportedFeaturesList();
                ::std::vector< ::std::string >::const_iterator o100 = o99->end();
                for (::std::vector< ::std::string >::const_iterator o101 = o99->begin(); o101 != o100; ++o101) {
                    const char* o102 = (*o101).c_str();
                    DBUS_ASSERT(dbus_message_iter_append_basic(&o98ArrayIter, DBUS_TYPE_STRING, &o102));
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o97Variant, &o98ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o92Struct, &o97Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o92Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o103Struct;
        uint32 DeviceInfoVariantFieldId;
        dbus_message_iter_recurse (in, &o103Struct);
        dbus_message_iter_get_basic(&o103Struct, &DeviceInfoVariantFieldId);
        dbus_message_iter_next(&o103Struct);

        if (dbus_message_iter_get_arg_type(&o103Struct) != DBUS_TYPE_INVALID) {
            switch (DeviceInfoVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o104Variant;
                        dbus_message_iter_recurse (&o103Struct, &o104Variant);
                        {
                            uint8 uint8Value;
                            uint8 &uint8TmpValue = uint8Value;
                            dbus_message_iter_get_basic(&o104Variant, &uint8TmpValue);
                            out.setUint8(uint8Value);
                        }

                        if (dbus_message_iter_has_next(&o104Variant)) {
                            dbus_message_iter_next(&o104Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o105Variant;
                        dbus_message_iter_recurse (&o103Struct, &o105Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant::E_STRING);
                        {
                            char* o106 = 0;
                            dbus_message_iter_get_basic(&o105Variant, &o106);
                            out.getStringMutable().assign (o106);
                        }
                        break;
                    }
                case 2:
                    {
                        DBusMessageIter o107Variant;
                        dbus_message_iter_recurse (&o103Struct, &o107Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant::E_SUPPORTED_FEATURES_LIST);

                        if (dbus_message_iter_get_arg_type(&o107Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o108ArrayIter;
                            dbus_message_iter_recurse (&o107Variant, &o108ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o108ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::std::string o109;
                                    {
                                        char* o110 = 0;
                                        dbus_message_iter_get_basic(&o108ArrayIter, &o110);
                                        o109.assign (o110);
                                    }
                                    out.getSupportedFeaturesListMutable().push_back(o109);
                                } while (dbus_message_iter_next(&o108ArrayIter));
                            }
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of BaseTypesVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant& in, DBusMessageIter* out) {
    DBusMessageIter o111Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o111Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant::E_UINT8:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o111Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o112Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o111Struct, DBUS_TYPE_VARIANT, "y", &o112Variant));
                uint8 o113 = in.getUint8();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o112Variant, DBUS_TYPE_BYTE, &o113));
                DBUS_ASSERT(dbus_message_iter_close_container(&o111Struct, &o112Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant::E_UINT64:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o111Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o114Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o111Struct, DBUS_TYPE_VARIANT, "t", &o114Variant));
                uint64 o115 = in.getUint64();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o114Variant, DBUS_TYPE_UINT64, &o115));
                DBUS_ASSERT(dbus_message_iter_close_container(&o111Struct, &o114Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant::E_BOOLEAN:
            {
                uint32 enumSelector = (uint32) 2;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o111Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o116Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o111Struct, DBUS_TYPE_VARIANT, "b", &o116Variant));
                dbus_bool_t o117 = in.getBoolean() ? TRUE : FALSE;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o116Variant, DBUS_TYPE_BOOLEAN, &o117));
                DBUS_ASSERT(dbus_message_iter_close_container(&o111Struct, &o116Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant::E_STRING:
            {
                uint32 enumSelector = (uint32) 3;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o111Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o118Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o111Struct, DBUS_TYPE_VARIANT, "s", &o118Variant));
                const char* o119 = in.getString().c_str();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o118Variant, DBUS_TYPE_STRING, &o119));
                DBUS_ASSERT(dbus_message_iter_close_container(&o111Struct, &o118Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o111Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o120Struct;
        uint32 BaseTypesVariantFieldId;
        dbus_message_iter_recurse (in, &o120Struct);
        dbus_message_iter_get_basic(&o120Struct, &BaseTypesVariantFieldId);
        dbus_message_iter_next(&o120Struct);

        if (dbus_message_iter_get_arg_type(&o120Struct) != DBUS_TYPE_INVALID) {
            switch (BaseTypesVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o121Variant;
                        dbus_message_iter_recurse (&o120Struct, &o121Variant);
                        {
                            uint8 uint8Value;
                            uint8 &uint8TmpValue = uint8Value;
                            dbus_message_iter_get_basic(&o121Variant, &uint8TmpValue);
                            out.setUint8(uint8Value);
                        }

                        if (dbus_message_iter_has_next(&o121Variant)) {
                            dbus_message_iter_next(&o121Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o122Variant;
                        dbus_message_iter_recurse (&o120Struct, &o122Variant);
                        {
                            uint64 uint64Value;
                            uint64 &uint64TmpValue = uint64Value;
                            dbus_message_iter_get_basic(&o122Variant, &uint64TmpValue);
                            out.setUint64(uint64Value);
                        }

                        if (dbus_message_iter_has_next(&o122Variant)) {
                            dbus_message_iter_next(&o122Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 2:
                    {
                        DBusMessageIter o123Variant;
                        dbus_message_iter_recurse (&o120Struct, &o123Variant);
                        {
                            bool booleanValue;
                            bool &booleanTmpValue = booleanValue;
                            {
                                dbus_bool_t o124;
                                dbus_message_iter_get_basic(&o123Variant, &o124);
                                booleanTmpValue = o124 ? true : false;
                            }
                            out.setBoolean(booleanValue);
                        }

                        if (dbus_message_iter_has_next(&o123Variant)) {
                            dbus_message_iter_next(&o123Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 3:
                    {
                        DBusMessageIter o125Variant;
                        dbus_message_iter_recurse (&o120Struct, &o125Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant::E_STRING);
                        {
                            char* o126 = 0;
                            dbus_message_iter_get_basic(&o125Variant, &o126);
                            out.getStringMutable().assign (o126);
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceCallsList

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList& in, DBusMessageIter* out) {
    {
        DBusMessageIter o127Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o127Struct));
        const char* o128 = in.getDeviceAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o127Struct, DBUS_TYPE_STRING, &o128));
        DBusMessageIter o129ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o127Struct, DBUS_TYPE_ARRAY, "y", &o129ArrayIter));
        const ::std::vector< uint8 >* o130 = &in.getCallsList();
        ::std::vector< uint8 >::const_iterator o131 = o130->end();
        for (::std::vector< uint8 >::const_iterator o132 = o130->begin(); o132 != o131; ++o132) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o129ArrayIter, DBUS_TYPE_BYTE, &(*o132)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o127Struct, &o129ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o127Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList& out) {
    {
        DBusMessageIter o133;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o133);
                {
                    ::std::string DeviceAddressValue;
                    ::std::string &DeviceAddressTmpValue = DeviceAddressValue;
                    {
                        char* o134 = 0;
                        dbus_message_iter_get_basic(&o133, &o134);
                        DeviceAddressTmpValue.assign (o134);
                    }
                    out.setDeviceAddress(DeviceAddressValue);
                }

                if (dbus_message_iter_has_next(&o133)) {
                    dbus_message_iter_next(&o133);
                } else {
                    return true;
                }

                {
                    ::std::vector< uint8 > callsListValue;

                    if (dbus_message_iter_get_arg_type(&o133) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o135ArrayIter;
                        dbus_message_iter_recurse (&o133, &o135ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o135ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint8 o136;
                                dbus_message_iter_get_basic(&o135ArrayIter, &o136);
                                callsListValue.push_back(o136);
                            } while (dbus_message_iter_next(&o135ArrayIter));
                        }
                    }
                    out.setCallsList(callsListValue);
                }

                if (dbus_message_iter_has_next(&o133)) {
                    dbus_message_iter_next(&o133);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CallStatusVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant& in, DBusMessageIter* out) {
    DBusMessageIter o137Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o137Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_UINT8:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o137Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o138Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o137Struct, DBUS_TYPE_VARIANT, "y", &o138Variant));
                uint8 o139 = in.getUint8();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o138Variant, DBUS_TYPE_BYTE, &o139));
                DBUS_ASSERT(dbus_message_iter_close_container(&o137Struct, &o138Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_UINT64:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o137Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o140Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o137Struct, DBUS_TYPE_VARIANT, "t", &o140Variant));
                uint64 o141 = in.getUint64();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o140Variant, DBUS_TYPE_UINT64, &o141));
                DBUS_ASSERT(dbus_message_iter_close_container(&o137Struct, &o140Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_BOOLEAN:
            {
                uint32 enumSelector = (uint32) 2;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o137Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o142Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o137Struct, DBUS_TYPE_VARIANT, "b", &o142Variant));
                dbus_bool_t o143 = in.getBoolean() ? TRUE : FALSE;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o142Variant, DBUS_TYPE_BOOLEAN, &o143));
                DBUS_ASSERT(dbus_message_iter_close_container(&o137Struct, &o142Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_STRING:
            {
                uint32 enumSelector = (uint32) 3;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o137Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o144Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o137Struct, DBUS_TYPE_VARIANT, "s", &o144Variant));
                const char* o145 = in.getString().c_str();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o144Variant, DBUS_TYPE_STRING, &o145));
                DBUS_ASSERT(dbus_message_iter_close_container(&o137Struct, &o144Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_CALL_INFO_LIST:
            {
                uint32 enumSelector = (uint32) 4;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o137Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o146Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o137Struct, DBUS_TYPE_VARIANT, "aa{s(uv)}", &o146Variant));
                DBusMessageIter o147ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o146Variant, DBUS_TYPE_ARRAY, "a{s(uv)}", &o147ArrayIter));
                const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::CallInfo >* o148 = &in.getCallInfoList();
                ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::CallInfo >::const_iterator o149 = o148->end();
                for (::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::CallInfo >::const_iterator o150 = o148->begin(); o150 != o149; ++o150) {
                    DBusMessageIter o151ArrayIter;
                    DBusMessageIter o152DictIter;
                    DBUS_ASSERT(dbus_message_iter_open_container(&o147ArrayIter, DBUS_TYPE_ARRAY, "{s(uv)}", &o151ArrayIter));
                    const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >* o153 = &(*o150);
                    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >::const_iterator o154 = o153->end();
                    for (::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >::const_iterator o155 = o153->begin(); o155 != o154; ++o155) {
                        DBUS_ASSERT(dbus_message_iter_open_container(&o151ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o152DictIter));
                        const char* o156 = o155->first.c_str();
                        DBUS_ASSERT(dbus_message_iter_append_basic(&o152DictIter, DBUS_TYPE_STRING, &o156));
                        serializeDBus(o155->second, &o152DictIter);
                        DBUS_ASSERT(dbus_message_iter_close_container(&o151ArrayIter, &o152DictIter)); // close dict container
                    }
                    DBUS_ASSERT(dbus_message_iter_close_container(&o147ArrayIter, &o151ArrayIter));
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o146Variant, &o147ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o137Struct, &o146Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o137Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o157Struct;
        uint32 CallStatusVariantFieldId;
        dbus_message_iter_recurse (in, &o157Struct);
        dbus_message_iter_get_basic(&o157Struct, &CallStatusVariantFieldId);
        dbus_message_iter_next(&o157Struct);

        if (dbus_message_iter_get_arg_type(&o157Struct) != DBUS_TYPE_INVALID) {
            switch (CallStatusVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o158Variant;
                        dbus_message_iter_recurse (&o157Struct, &o158Variant);
                        {
                            uint8 uint8Value;
                            uint8 &uint8TmpValue = uint8Value;
                            dbus_message_iter_get_basic(&o158Variant, &uint8TmpValue);
                            out.setUint8(uint8Value);
                        }

                        if (dbus_message_iter_has_next(&o158Variant)) {
                            dbus_message_iter_next(&o158Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o159Variant;
                        dbus_message_iter_recurse (&o157Struct, &o159Variant);
                        {
                            uint64 uint64Value;
                            uint64 &uint64TmpValue = uint64Value;
                            dbus_message_iter_get_basic(&o159Variant, &uint64TmpValue);
                            out.setUint64(uint64Value);
                        }

                        if (dbus_message_iter_has_next(&o159Variant)) {
                            dbus_message_iter_next(&o159Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 2:
                    {
                        DBusMessageIter o160Variant;
                        dbus_message_iter_recurse (&o157Struct, &o160Variant);
                        {
                            bool booleanValue;
                            bool &booleanTmpValue = booleanValue;
                            {
                                dbus_bool_t o161;
                                dbus_message_iter_get_basic(&o160Variant, &o161);
                                booleanTmpValue = o161 ? true : false;
                            }
                            out.setBoolean(booleanValue);
                        }

                        if (dbus_message_iter_has_next(&o160Variant)) {
                            dbus_message_iter_next(&o160Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 3:
                    {
                        DBusMessageIter o162Variant;
                        dbus_message_iter_recurse (&o157Struct, &o162Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_STRING);
                        {
                            char* o163 = 0;
                            dbus_message_iter_get_basic(&o162Variant, &o163);
                            out.getStringMutable().assign (o163);
                        }
                        break;
                    }
                case 4:
                    {
                        DBusMessageIter o164Variant;
                        dbus_message_iter_recurse (&o157Struct, &o164Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant::E_CALL_INFO_LIST);

                        if (dbus_message_iter_get_arg_type(&o164Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o165ArrayIter;
                            dbus_message_iter_recurse (&o164Variant, &o165ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o165ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::com::bosch::pmapp::PMAppTypeCollections::CallInfo o166;

                                    if (dbus_message_iter_get_arg_type(&o165ArrayIter) != DBUS_TYPE_INVALID) {
                                        DBusMessageIter o167ArrayIter;
                                        DBusMessageIter o168DictIter;
                                        dbus_message_iter_recurse (&o165ArrayIter, &o167ArrayIter);

                                        if (dbus_message_iter_get_arg_type(&o167ArrayIter) != DBUS_TYPE_INVALID) {
                                            do {
                                                ::std::string o169Key;
                                                ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant o169Value;
                                                dbus_message_iter_recurse (&o167ArrayIter, &o168DictIter);
                                                {
                                                    char* o170 = 0;
                                                    dbus_message_iter_get_basic(&o168DictIter, &o170);
                                                    o169Key.assign (o170);
                                                }
                                                dbus_message_iter_next(&o168DictIter);
                                                if (!deserializeDBus(&o168DictIter, o169Value)) {
                                                    return false;
                                                }
                                                o166.insert(std::pair< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >(o169Key, o169Value));
                                            } while (dbus_message_iter_next(&o167ArrayIter));
                                        }
                                    }
                                    out.getCallInfoListMutable().push_back(o166);
                                } while (dbus_message_iter_next(&o165ArrayIter));
                            }
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of VoiceCallManagerVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant& in, DBusMessageIter* out) {
    DBusMessageIter o171Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o171Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant::E_BOOLEAN:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o171Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o172Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o171Struct, DBUS_TYPE_VARIANT, "b", &o172Variant));
                dbus_bool_t o173 = in.getBoolean() ? TRUE : FALSE;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o172Variant, DBUS_TYPE_BOOLEAN, &o173));
                DBUS_ASSERT(dbus_message_iter_close_container(&o171Struct, &o172Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant::E_CALL_STATUS_LIST_TYPE:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o171Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o174Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o171Struct, DBUS_TYPE_VARIANT, "aa{s(uv)}", &o174Variant));
                DBusMessageIter o175ArrayIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o174Variant, DBUS_TYPE_ARRAY, "a{s(uv)}", &o175ArrayIter));
                const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >* o176 = &in.getCallStatusListType();
                ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >::const_iterator o177 = o176->end();
                for (::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >::const_iterator o178 = o176->begin(); o178 != o177; ++o178) {
                    DBusMessageIter o179ArrayIter;
                    DBusMessageIter o180DictIter;
                    DBUS_ASSERT(dbus_message_iter_open_container(&o175ArrayIter, DBUS_TYPE_ARRAY, "{s(uv)}", &o179ArrayIter));
                    const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant >* o181 = &(*o178);
                    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant >::const_iterator o182 = o181->end();
                    for (::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant >::const_iterator o183 = o181->begin(); o183 != o182; ++o183) {
                        DBUS_ASSERT(dbus_message_iter_open_container(&o179ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o180DictIter));
                        const char* o184 = o183->first.c_str();
                        DBUS_ASSERT(dbus_message_iter_append_basic(&o180DictIter, DBUS_TYPE_STRING, &o184));
                        serializeDBus(o183->second, &o180DictIter);
                        DBUS_ASSERT(dbus_message_iter_close_container(&o179ArrayIter, &o180DictIter)); // close dict container
                    }
                    DBUS_ASSERT(dbus_message_iter_close_container(&o175ArrayIter, &o179ArrayIter));
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o174Variant, &o175ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o171Struct, &o174Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o171Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o185Struct;
        uint32 VoiceCallManagerVariantFieldId;
        dbus_message_iter_recurse (in, &o185Struct);
        dbus_message_iter_get_basic(&o185Struct, &VoiceCallManagerVariantFieldId);
        dbus_message_iter_next(&o185Struct);

        if (dbus_message_iter_get_arg_type(&o185Struct) != DBUS_TYPE_INVALID) {
            switch (VoiceCallManagerVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o186Variant;
                        dbus_message_iter_recurse (&o185Struct, &o186Variant);
                        {
                            bool booleanValue;
                            bool &booleanTmpValue = booleanValue;
                            {
                                dbus_bool_t o187;
                                dbus_message_iter_get_basic(&o186Variant, &o187);
                                booleanTmpValue = o187 ? true : false;
                            }
                            out.setBoolean(booleanValue);
                        }

                        if (dbus_message_iter_has_next(&o186Variant)) {
                            dbus_message_iter_next(&o186Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o188Variant;
                        dbus_message_iter_recurse (&o185Struct, &o188Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::VoiceCallManagerVariant::E_CALL_STATUS_LIST_TYPE);

                        if (dbus_message_iter_get_arg_type(&o188Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o189ArrayIter;
                            dbus_message_iter_recurse (&o188Variant, &o189ArrayIter);

                            if(dbus_message_iter_get_arg_type(&o189ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > o190;

                                    if (dbus_message_iter_get_arg_type(&o189ArrayIter) != DBUS_TYPE_INVALID) {
                                        DBusMessageIter o191ArrayIter;
                                        DBusMessageIter o192DictIter;
                                        dbus_message_iter_recurse (&o189ArrayIter, &o191ArrayIter);

                                        if (dbus_message_iter_get_arg_type(&o191ArrayIter) != DBUS_TYPE_INVALID) {
                                            do {
                                                ::std::string o193Key;
                                                ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant o193Value;
                                                dbus_message_iter_recurse (&o191ArrayIter, &o192DictIter);
                                                {
                                                    char* o194 = 0;
                                                    dbus_message_iter_get_basic(&o192DictIter, &o194);
                                                    o193Key.assign (o194);
                                                }
                                                dbus_message_iter_next(&o192DictIter);
                                                if (!deserializeDBus(&o192DictIter, o193Value)) {
                                                    return false;
                                                }
                                                o190.insert(std::pair< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant >(o193Key, o193Value));
                                            } while (dbus_message_iter_next(&o191ArrayIter));
                                        }
                                    }
                                    out.getCallStatusListTypeMutable().push_back(o190);
                                } while (dbus_message_iter_next(&o189ArrayIter));
                            }
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of VoiceCallVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant& in, DBusMessageIter* out) {
    DBusMessageIter o195Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o195Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant::E_UINT8:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o195Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o196Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o195Struct, DBUS_TYPE_VARIANT, "y", &o196Variant));
                uint8 o197 = in.getUint8();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o196Variant, DBUS_TYPE_BYTE, &o197));
                DBUS_ASSERT(dbus_message_iter_close_container(&o195Struct, &o196Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant::E_BOOLEAN:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o195Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o198Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o195Struct, DBUS_TYPE_VARIANT, "b", &o198Variant));
                dbus_bool_t o199 = in.getBoolean() ? TRUE : FALSE;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o198Variant, DBUS_TYPE_BOOLEAN, &o199));
                DBUS_ASSERT(dbus_message_iter_close_container(&o195Struct, &o198Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o195Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o200Struct;
        uint32 VoiceCallVariantFieldId;
        dbus_message_iter_recurse (in, &o200Struct);
        dbus_message_iter_get_basic(&o200Struct, &VoiceCallVariantFieldId);
        dbus_message_iter_next(&o200Struct);

        if (dbus_message_iter_get_arg_type(&o200Struct) != DBUS_TYPE_INVALID) {
            switch (VoiceCallVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o201Variant;
                        dbus_message_iter_recurse (&o200Struct, &o201Variant);
                        {
                            uint8 uint8Value;
                            uint8 &uint8TmpValue = uint8Value;
                            dbus_message_iter_get_basic(&o201Variant, &uint8TmpValue);
                            out.setUint8(uint8Value);
                        }

                        if (dbus_message_iter_has_next(&o201Variant)) {
                            dbus_message_iter_next(&o201Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o202Variant;
                        dbus_message_iter_recurse (&o200Struct, &o202Variant);
                        {
                            bool booleanValue;
                            bool &booleanTmpValue = booleanValue;
                            {
                                dbus_bool_t o203;
                                dbus_message_iter_get_basic(&o202Variant, &o203);
                                booleanTmpValue = o203 ? true : false;
                            }
                            out.setBoolean(booleanValue);
                        }

                        if (dbus_message_iter_has_next(&o202Variant)) {
                            dbus_message_iter_next(&o202Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

// D-Bus serialize and deserialize functions of VoiceRecognitionVariant

void serializeDBus (const ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant& in, DBusMessageIter* out) {
    DBusMessageIter o204Struct;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o204Struct));
    switch (in.getField()) {
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant::E_UINT8:
            {
                uint32 enumSelector = (uint32) 0;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o204Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o205Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o204Struct, DBUS_TYPE_VARIANT, "y", &o205Variant));
                uint8 o206 = in.getUint8();
                DBUS_ASSERT(dbus_message_iter_append_basic(&o205Variant, DBUS_TYPE_BYTE, &o206));
                DBUS_ASSERT(dbus_message_iter_close_container(&o204Struct, &o205Variant));
                break;
            }
        case ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant::E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE:
            {
                uint32 enumSelector = (uint32) 1;
                DBUS_ASSERT(dbus_message_iter_append_basic(&o204Struct, DBUS_TYPE_UINT32, &enumSelector));
                DBusMessageIter o207Variant;
                DBUS_ASSERT(dbus_message_iter_open_container(&o204Struct, DBUS_TYPE_VARIANT, "a{s(uv)}", &o207Variant));
                DBusMessageIter o208ArrayIter;
                DBusMessageIter o209DictIter;
                DBUS_ASSERT(dbus_message_iter_open_container(&o207Variant, DBUS_TYPE_ARRAY, "{s(uv)}", &o208ArrayIter));
                const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >* o210 = &in.getEnhancedVoiceRecognitionFeatureType();
                ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >::const_iterator o211 = o210->end();
                for (::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >::const_iterator o212 = o210->begin(); o212 != o211; ++o212) {
                    DBUS_ASSERT(dbus_message_iter_open_container(&o208ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o209DictIter));
                    const char* o213 = o212->first.c_str();
                    DBUS_ASSERT(dbus_message_iter_append_basic(&o209DictIter, DBUS_TYPE_STRING, &o213));
                    serializeDBus(o212->second, &o209DictIter);
                    DBUS_ASSERT(dbus_message_iter_close_container(&o208ArrayIter, &o209DictIter)); // close dict container
                }
                DBUS_ASSERT(dbus_message_iter_close_container(&o207Variant, &o208ArrayIter));
                DBUS_ASSERT(dbus_message_iter_close_container(&o204Struct, &o207Variant));
                break;
            }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o204Struct));
}

bool deserializeDBus (DBusMessageIter* in, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant& out) {

    if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
        DBusMessageIter o214Struct;
        uint32 VoiceRecognitionVariantFieldId;
        dbus_message_iter_recurse (in, &o214Struct);
        dbus_message_iter_get_basic(&o214Struct, &VoiceRecognitionVariantFieldId);
        dbus_message_iter_next(&o214Struct);

        if (dbus_message_iter_get_arg_type(&o214Struct) != DBUS_TYPE_INVALID) {
            switch (VoiceRecognitionVariantFieldId) {
                case 0:
                    {
                        DBusMessageIter o215Variant;
                        dbus_message_iter_recurse (&o214Struct, &o215Variant);
                        {
                            uint8 uint8Value;
                            uint8 &uint8TmpValue = uint8Value;
                            dbus_message_iter_get_basic(&o215Variant, &uint8TmpValue);
                            out.setUint8(uint8Value);
                        }

                        if (dbus_message_iter_has_next(&o215Variant)) {
                            dbus_message_iter_next(&o215Variant);
                        } else {
                            return true;
                        }
                        break;
                    }
                case 1:
                    {
                        DBusMessageIter o216Variant;
                        dbus_message_iter_recurse (&o214Struct, &o216Variant);
                        out.setField(::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant::E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE);

                        if (dbus_message_iter_get_arg_type(&o216Variant) != DBUS_TYPE_INVALID) {
                            DBusMessageIter o217ArrayIter;
                            DBusMessageIter o218DictIter;
                            dbus_message_iter_recurse (&o216Variant, &o217ArrayIter);

                            if (dbus_message_iter_get_arg_type(&o217ArrayIter) != DBUS_TYPE_INVALID) {
                                do {
                                    ::std::string o219Key;
                                    ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant o219Value;
                                    dbus_message_iter_recurse (&o217ArrayIter, &o218DictIter);
                                    {
                                        char* o220 = 0;
                                        dbus_message_iter_get_basic(&o218DictIter, &o220);
                                        o219Key.assign (o220);
                                    }
                                    dbus_message_iter_next(&o218DictIter);
                                    if (!deserializeDBus(&o218DictIter, o219Value)) {
                                        return false;
                                    }
                                    out.getEnhancedVoiceRecognitionFeatureTypeMutable().insert(std::pair< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >(o219Key, o219Value));
                                } while (dbus_message_iter_next(&o217ArrayIter));
                            }
                        }
                        break;
                    }
                default:
                    // wrong field id
                    return false;
            }
        }
    }

    return true;
}

