/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_HFPMANAGERSTUB_H
#define COM_BOSCH_PMAPP_HFPMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/HfpManager.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <map>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace HfpManager {

class HfpManagerStubDelegate;

class HfpManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HfpManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HfpManagerStub (const std::string& portName);

    /**
     * Create an instance of the HfpManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HfpManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~HfpManagerStub();

    // signal 'NotificationEvent'

    /**
     * Raise the signal 'NotificationEvent' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'NotificationEvent'</b>:
     *
     * Indicate different phone call manager related events.
     *
     * @param EventDetails Refer Type Definition and Comment of the parameter "EventDetails" for more information.
     *                 Example:
     *                 {
     *                   {"EventName" : "OutgoingCallFailed"}
     *                   {"Reason" : "Operation not allowed"}
     *                   {"DeviceAddress" : "aabbccddeeff"}
     *                 }
     */
    void sendNotificationEventSignal(const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& eventDetails);

    // property 'SystemWideRingtonesList'

    /**
     * The method onSystemWideRingtonesListGet() is called by ASF when a
     * client invokes the read method for the property
     * 'SystemWideRingtonesList'. The onSystemWideRingtonesListGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     */
    virtual void onSystemWideRingtonesListGet(const ::boost::shared_ptr< SystemWideRingtonesListGet >& payload);

    /**
     * Sends back the update to a previous onSystemWideRingtonesListGet().
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @param act Identifies a previous invocation of
     * onSystemWideRingtonesListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSystemWideRingtonesListGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& systemWideRingtonesList, act_t act = 0);

    /**
     * Set the value of the property 'SystemWideRingtonesList' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     */
    void setSystemWideRingtonesList(const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& systemWideRingtonesList);

    /**
     * Returns the current value of the property 'SystemWideRingtonesList'.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& getSystemWideRingtonesList() const;

    /**
     * Returns the current value of the property 'SystemWideRingtonesList' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendSystemWideRingtonesListUpdate() method.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     */
    ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& getSystemWideRingtonesListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemWideRingtonesListUpdate().
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     */
    void sendSystemWideRingtonesListUpdate();

    // property 'DeviceRingtoneList'

    /**
     * The method onDeviceRingtoneListGet() is called by ASF when a client
     * invokes the read method for the property 'DeviceRingtoneList'. The
     * onDeviceRingtoneListGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     */
    virtual void onDeviceRingtoneListGet(const ::boost::shared_ptr< DeviceRingtoneListGet >& payload);

    /**
     * Sends back the update to a previous onDeviceRingtoneListGet().
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @param act Identifies a previous invocation of
     * onDeviceRingtoneListGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeviceRingtoneListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& deviceRingtoneList, act_t act = 0);

    /**
     * Set the value of the property 'DeviceRingtoneList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     */
    void setDeviceRingtoneList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& deviceRingtoneList);

    /**
     * Returns the current value of the property 'DeviceRingtoneList'.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneList() const;

    /**
     * Returns the current value of the property 'DeviceRingtoneList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDeviceRingtoneListUpdate() method.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     */
    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceRingtoneListUpdate().
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     */
    void sendDeviceRingtoneListUpdate();

    // property 'SuppressRingtoneOnOffList'

    /**
     * The method onSuppressRingtoneOnOffListGet() is called by ASF when a
     * client invokes the read method for the property
     * 'SuppressRingtoneOnOffList'. The onSuppressRingtoneOnOffListGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    virtual void onSuppressRingtoneOnOffListGet(const ::boost::shared_ptr< SuppressRingtoneOnOffListGet >& payload);

    /**
     * Sends back the update to a previous onSuppressRingtoneOnOffListGet().
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param act Identifies a previous invocation of
     * onSuppressRingtoneOnOffListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSuppressRingtoneOnOffListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& suppressRingtoneOnOffList, act_t act = 0);

    /**
     * Set the value of the property 'SuppressRingtoneOnOffList' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    void setSuppressRingtoneOnOffList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& suppressRingtoneOnOffList);

    /**
     * Returns the current value of the property 'SuppressRingtoneOnOffList'.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getSuppressRingtoneOnOffList() const;

    /**
     * Returns the current value of the property 'SuppressRingtoneOnOffList'
     * as a mutable reference. If you change the content of the returned
     * object you have to send updates to registered clients by yourself with
     * the help of the sendSuppressRingtoneOnOffListUpdate() method.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getSuppressRingtoneOnOffListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSuppressRingtoneOnOffListUpdate().
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    void sendSuppressRingtoneOnOffListUpdate();

    // property 'AutoWaitingModeOnOffList'

    /**
     * The method onAutoWaitingModeOnOffListGet() is called by ASF when a
     * client invokes the read method for the property
     * 'AutoWaitingModeOnOffList'. The onAutoWaitingModeOnOffListGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    virtual void onAutoWaitingModeOnOffListGet(const ::boost::shared_ptr< AutoWaitingModeOnOffListGet >& payload);

    /**
     * Sends back the update to a previous onAutoWaitingModeOnOffListGet().
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param act Identifies a previous invocation of
     * onAutoWaitingModeOnOffListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAutoWaitingModeOnOffListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& autoWaitingModeOnOffList, act_t act = 0);

    /**
     * Set the value of the property 'AutoWaitingModeOnOffList' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    void setAutoWaitingModeOnOffList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& autoWaitingModeOnOffList);

    /**
     * Returns the current value of the property 'AutoWaitingModeOnOffList'.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getAutoWaitingModeOnOffList() const;

    /**
     * Returns the current value of the property 'AutoWaitingModeOnOffList' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendAutoWaitingModeOnOffListUpdate() method.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getAutoWaitingModeOnOffListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAutoWaitingModeOnOffListUpdate().
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     */
    void sendAutoWaitingModeOnOffListUpdate();

    // property 'WaitingModeFilePath'

    /**
     * The method onWaitingModeFilePathGet() is called by ASF when a client
     * invokes the read method for the property 'WaitingModeFilePath'. The
     * onWaitingModeFilePathGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    virtual void onWaitingModeFilePathGet(const ::boost::shared_ptr< WaitingModeFilePathGet >& payload);

    /**
     * Sends back the update to a previous onWaitingModeFilePathGet().
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param act Identifies a previous invocation of
     * onWaitingModeFilePathGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWaitingModeFilePathGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath, act_t act = 0);

    /**
     * The method onWaitingModeFilePathSet() is called by ASF when a client
     * invokes the write method for the property 'WaitingModeFilePath'. The
     * onWaitingModeFilePathSet() method set property value to the given
     * parameter WaitingModeFilePath by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    virtual void onWaitingModeFilePathSet(const ::boost::shared_ptr< WaitingModeFilePathSet >& payload);

    /**
     * Sends back the update to a previous onWaitingModeFilePathSet().
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param act Identifies a previous invocation of
     * onWaitingModeFilePathSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWaitingModeFilePathSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'WaitingModeFilePath' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    void setWaitingModeFilePath(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath);

    /**
     * Returns the current value of the property 'WaitingModeFilePath'.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& getWaitingModeFilePath() const;

    /**
     * Returns the current value of the property 'WaitingModeFilePath' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendWaitingModeFilePathUpdate() method.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& getWaitingModeFilePathMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWaitingModeFilePathUpdate().
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    void sendWaitingModeFilePathUpdate();

    // property 'PhoneCallAudioActive'

    /**
     * The method onPhoneCallAudioActiveGet() is called by ASF when a client
     * invokes the read method for the property 'PhoneCallAudioActive'. The
     * onPhoneCallAudioActiveGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     */
    virtual void onPhoneCallAudioActiveGet(const ::boost::shared_ptr< PhoneCallAudioActiveGet >& payload);

    /**
     * Sends back the update to a previous onPhoneCallAudioActiveGet().
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @param act Identifies a previous invocation of
     * onPhoneCallAudioActiveGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPhoneCallAudioActiveGetUpdate(bool phoneCallAudioActive, act_t act = 0);

    /**
     * Set the value of the property 'PhoneCallAudioActive' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     */
    void setPhoneCallAudioActive(bool phoneCallAudioActive);

    /**
     * Returns the current value of the property 'PhoneCallAudioActive'.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     */
    bool getPhoneCallAudioActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPhoneCallAudioActiveUpdate().
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     */
    void sendPhoneCallAudioActiveUpdate();

    // property 'ActivePassiveDeviceList'

    /**
     * The method onActivePassiveDeviceListGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ActivePassiveDeviceList'. The onActivePassiveDeviceListGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     */
    virtual void onActivePassiveDeviceListGet(const ::boost::shared_ptr< ActivePassiveDeviceListGet >& payload);

    /**
     * Sends back the update to a previous onActivePassiveDeviceListGet().
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @param act Identifies a previous invocation of
     * onActivePassiveDeviceListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActivePassiveDeviceListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& activePassiveDeviceList, act_t act = 0);

    /**
     * Set the value of the property 'ActivePassiveDeviceList' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     */
    void setActivePassiveDeviceList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& activePassiveDeviceList);

    /**
     * Returns the current value of the property 'ActivePassiveDeviceList'.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getActivePassiveDeviceList() const;

    /**
     * Returns the current value of the property 'ActivePassiveDeviceList' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendActivePassiveDeviceListUpdate() method.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     */
    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getActivePassiveDeviceListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActivePassiveDeviceListUpdate().
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     */
    void sendActivePassiveDeviceListUpdate();

    // property 'DeviceObjectPathList'

    /**
     * The method onDeviceObjectPathListGet() is called by ASF when a client
     * invokes the read method for the property 'DeviceObjectPathList'. The
     * onDeviceObjectPathListGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     */
    virtual void onDeviceObjectPathListGet(const ::boost::shared_ptr< DeviceObjectPathListGet >& payload);

    /**
     * Sends back the update to a previous onDeviceObjectPathListGet().
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @param act Identifies a previous invocation of
     * onDeviceObjectPathListGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeviceObjectPathListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& deviceObjectPathList, act_t act = 0);

    /**
     * Set the value of the property 'DeviceObjectPathList' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     */
    void setDeviceObjectPathList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& deviceObjectPathList);

    /**
     * Returns the current value of the property 'DeviceObjectPathList'.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathList() const;

    /**
     * Returns the current value of the property 'DeviceObjectPathList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDeviceObjectPathListUpdate() method.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     */
    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceObjectPathListUpdate().
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     */
    void sendDeviceObjectPathListUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the HfpManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the HfpManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param HfpManagerProperties Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SystemWideRingtonesList" : (0x02, [( 0x02, "RingtoneA" ), (0x03,"RingtoneB")])}
     *                     {"DeviceRingtoneList" : [("aabbccddeeff", 0x02, "RingtoneA"), ("ggggiijjkkll", 0x03, "RingtoneB")]}
     *                     {"SuppressRingtoneOnOffList" : [("aabbccddeeff", false)("ggggiijjkkll", true)]}
     *                     {"AutoWaitingModeOnOffList" : [("aabbccddeeff", true)("ggggiijjkkll", false)]}
     *                     {"WaitingModeFilePath" : {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3", "FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}}
     *                     {"PhoneCallAudioActive" : true}
     *                     {"ActivePassiveDeviceList" : [("aabbccddeeff", 0x01), ("ggggiijjkkll", 0x00)]}
     *                     {"DeviceObjectPathList" : [("aabbccddeeff", "/com/bosch/pmapp/device1"), ("ggggiijjkkll", "/com/bosch/pmapp/device2")]}
     *                   }
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& hfpManagerProperties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the HfpManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartStopRingtone'

    /**
     * The method onStartStopRingtone() is called by ASF when a client invokes
     * the method 'StartStopRingtone'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStartStopRingtone() or sendStartStopRingtoneError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'StartStopRingtone'</b>:
     *
     * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InUse
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartStopRingtoneRequest (const ::boost::shared_ptr< StartStopRingtoneRequest >& request) = 0;

    /**
     * The method sendStartStopRingtoneResponse() sends a response of a
     * previous method invocation of 'StartStopRingtone' back to the client.
     *
     * <b>Documentation of 'StartStopRingtone'</b>:
     *
     * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InUse
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartStopRingtone(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartStopRingtoneResponse (act_t act = 0);

    /**
     * The method sendStartStopRingtoneError() sends an error response of a
     * previous method invocation of 'StartStopRingtone' back to the client.
     *
     * <b>Documentation of 'StartStopRingtone'</b>:
     *
     * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InUse
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartStopRingtone().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartStopRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetRingtone'

    /**
     * The method onSetRingtone() is called by ASF when a client invokes the
     * method 'SetRingtone'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetRingtone() or
     * sendSetRingtoneError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetRingtone'</b>:
     *
     * Set the active ringtone for system wide or device specific.
     *
     *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
     *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetRingtoneRequest (const ::boost::shared_ptr< SetRingtoneRequest >& request) = 0;

    /**
     * The method sendSetRingtoneResponse() sends a response of a previous
     * method invocation of 'SetRingtone' back to the client.
     *
     * <b>Documentation of 'SetRingtone'</b>:
     *
     * Set the active ringtone for system wide or device specific.
     *
     *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
     *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetRingtone(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetRingtoneResponse (act_t act = 0);

    /**
     * The method sendSetRingtoneError() sends an error response of a previous
     * method invocation of 'SetRingtone' back to the client.
     *
     * <b>Documentation of 'SetRingtone'</b>:
     *
     * Set the active ringtone for system wide or device specific.
     *
     *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
     *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetRingtone(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SuppressRingtoneOnOff'

    /**
     * The method onSuppressRingtoneOnOff() is called by ASF when a client
     * invokes the method 'SuppressRingtoneOnOff'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSuppressRingtoneOnOff() or sendSuppressRingtoneOnOffError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'SuppressRingtoneOnOff'</b>:
     *
     * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
     *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
     *
     *         The updated changes will be available in the SuppressRingtoneOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSuppressRingtoneOnOffRequest (const ::boost::shared_ptr< SuppressRingtoneOnOffRequest >& request) = 0;

    /**
     * The method sendSuppressRingtoneOnOffResponse() sends a response of a
     * previous method invocation of 'SuppressRingtoneOnOff' back to the
     * client.
     *
     * <b>Documentation of 'SuppressRingtoneOnOff'</b>:
     *
     * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
     *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
     *
     *         The updated changes will be available in the SuppressRingtoneOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onSuppressRingtoneOnOff(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSuppressRingtoneOnOffResponse (act_t act = 0);

    /**
     * The method sendSuppressRingtoneOnOffError() sends an error response of
     * a previous method invocation of 'SuppressRingtoneOnOff' back to the
     * client.
     *
     * <b>Documentation of 'SuppressRingtoneOnOff'</b>:
     *
     * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
     *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
     *
     *         The updated changes will be available in the SuppressRingtoneOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSuppressRingtoneOnOff(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSuppressRingtoneOnOffError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AutoWaitingModeOnOff'

    /**
     * The method onAutoWaitingModeOnOff() is called by ASF when a client
     * invokes the method 'AutoWaitingModeOnOff'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendAutoWaitingModeOnOff() or sendAutoWaitingModeOnOffError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'AutoWaitingModeOnOff'</b>:
     *
     * Provides the ability to enable or disable the auto waiting mode setting.
     *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
     *         mode tone will be heard in the far end.
     *
     *         The updated changes will be available in the AutoWaitingModeOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAutoWaitingModeOnOffRequest (const ::boost::shared_ptr< AutoWaitingModeOnOffRequest >& request) = 0;

    /**
     * The method sendAutoWaitingModeOnOffResponse() sends a response of a
     * previous method invocation of 'AutoWaitingModeOnOff' back to the
     * client.
     *
     * <b>Documentation of 'AutoWaitingModeOnOff'</b>:
     *
     * Provides the ability to enable or disable the auto waiting mode setting.
     *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
     *         mode tone will be heard in the far end.
     *
     *         The updated changes will be available in the AutoWaitingModeOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onAutoWaitingModeOnOff(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAutoWaitingModeOnOffResponse (act_t act = 0);

    /**
     * The method sendAutoWaitingModeOnOffError() sends an error response of a
     * previous method invocation of 'AutoWaitingModeOnOff' back to the
     * client.
     *
     * <b>Documentation of 'AutoWaitingModeOnOff'</b>:
     *
     * Provides the ability to enable or disable the auto waiting mode setting.
     *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
     *         mode tone will be heard in the far end.
     *
     *         The updated changes will be available in the AutoWaitingModeOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onAutoWaitingModeOnOff(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAutoWaitingModeOnOffError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetActivePhone'

    /**
     * The method onSetActivePhone() is called by ASF when a client invokes
     * the method 'SetActivePhone'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetActivePhone() or sendSetActivePhoneError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'SetActivePhone'</b>:
     *
     * Provides the ability to set a device as an active device[2].
     *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
     *
     *         Note: - This API is meant to be invoked only for HFP connected devices.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetActivePhoneRequest (const ::boost::shared_ptr< SetActivePhoneRequest >& request) = 0;

    /**
     * The method sendSetActivePhoneResponse() sends a response of a previous
     * method invocation of 'SetActivePhone' back to the client.
     *
     * <b>Documentation of 'SetActivePhone'</b>:
     *
     * Provides the ability to set a device as an active device[2].
     *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
     *
     *         Note: - This API is meant to be invoked only for HFP connected devices.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetActivePhone(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetActivePhoneResponse (act_t act = 0);

    /**
     * The method sendSetActivePhoneError() sends an error response of a
     * previous method invocation of 'SetActivePhone' back to the client.
     *
     * <b>Documentation of 'SetActivePhone'</b>:
     *
     * Provides the ability to set a device as an active device[2].
     *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
     *
     *         Note: - This API is meant to be invoked only for HFP connected devices.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetActivePhone(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetActivePhoneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestoreFactorySetting'

    /**
     * The method onRestoreFactorySetting() is called by ASF when a client
     * invokes the method 'RestoreFactorySetting'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRestoreFactorySetting() or sendRestoreFactorySettingError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'RestoreFactorySetting'</b>:
     *
     * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestoreFactorySettingRequest (const ::boost::shared_ptr< RestoreFactorySettingRequest >& request) = 0;

    /**
     * The method sendRestoreFactorySettingResponse() sends a response of a
     * previous method invocation of 'RestoreFactorySetting' back to the
     * client.
     *
     * <b>Documentation of 'RestoreFactorySetting'</b>:
     *
     * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestoreFactorySetting(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreFactorySettingResponse (act_t act = 0);

    /**
     * The method sendRestoreFactorySettingError() sends an error response of
     * a previous method invocation of 'RestoreFactorySetting' back to the
     * client.
     *
     * <b>Documentation of 'RestoreFactorySetting'</b>:
     *
     * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRestoreFactorySetting(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreFactorySettingError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SystemWideRingtonesListUpdate _SystemWideRingtonesListProperty;

    DeviceRingtoneListUpdate _DeviceRingtoneListProperty;

    SuppressRingtoneOnOffListUpdate _SuppressRingtoneOnOffListProperty;

    AutoWaitingModeOnOffListUpdate _AutoWaitingModeOnOffListProperty;

    WaitingModeFilePathUpdate _WaitingModeFilePathProperty;

    PhoneCallAudioActiveUpdate _PhoneCallAudioActiveProperty;

    ActivePassiveDeviceListUpdate _ActivePassiveDeviceListProperty;

    DeviceObjectPathListUpdate _DeviceObjectPathListProperty;

    friend class HfpManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HfpManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_HFPMANAGERSTUB_H
