/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_HFPMANAGERPROXY_H
#define COM_BOSCH_PMAPP_HFPMANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/pmapp/HfpManager.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace HfpManager {

class HfpManagerProxy;

class ActivePassiveDeviceListCallbackIF {
public:
    virtual ~ActivePassiveDeviceListCallbackIF() {}

    virtual void onActivePassiveDeviceListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< ActivePassiveDeviceListError >& error) = 0;

    virtual void onActivePassiveDeviceListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< ActivePassiveDeviceListUpdate >& update) = 0;
};

class AutoWaitingModeOnOffCallbackIF {
public:
    virtual ~AutoWaitingModeOnOffCallbackIF() {}

    virtual void onAutoWaitingModeOnOffError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffError >& error) = 0;

    virtual void onAutoWaitingModeOnOffResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffResponse >& response) = 0;
};

class AutoWaitingModeOnOffListCallbackIF {
public:
    virtual ~AutoWaitingModeOnOffListCallbackIF() {}

    virtual void onAutoWaitingModeOnOffListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffListError >& error) = 0;

    virtual void onAutoWaitingModeOnOffListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< AutoWaitingModeOnOffListUpdate >& update) = 0;
};

class DeviceObjectPathListCallbackIF {
public:
    virtual ~DeviceObjectPathListCallbackIF() {}

    virtual void onDeviceObjectPathListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< DeviceObjectPathListError >& error) = 0;

    virtual void onDeviceObjectPathListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< DeviceObjectPathListUpdate >& update) = 0;
};

class DeviceRingtoneListCallbackIF {
public:
    virtual ~DeviceRingtoneListCallbackIF() {}

    virtual void onDeviceRingtoneListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListError >& error) = 0;

    virtual void onDeviceRingtoneListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< DeviceRingtoneListUpdate >& update) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class NotificationEventCallbackIF {
public:
    virtual ~NotificationEventCallbackIF() {}

    virtual void onNotificationEventError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< NotificationEventError >& error) = 0;

    virtual void onNotificationEventSignal(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< NotificationEventSignal >& signal) = 0;
};

class PhoneCallAudioActiveCallbackIF {
public:
    virtual ~PhoneCallAudioActiveCallbackIF() {}

    virtual void onPhoneCallAudioActiveError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< PhoneCallAudioActiveError >& error) = 0;

    virtual void onPhoneCallAudioActiveUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< PhoneCallAudioActiveUpdate >& update) = 0;
};

class RestoreFactorySettingCallbackIF {
public:
    virtual ~RestoreFactorySettingCallbackIF() {}

    virtual void onRestoreFactorySettingError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingError >& error) = 0;

    virtual void onRestoreFactorySettingResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingResponse >& response) = 0;
};

class SetActivePhoneCallbackIF {
public:
    virtual ~SetActivePhoneCallbackIF() {}

    virtual void onSetActivePhoneError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneError >& error) = 0;

    virtual void onSetActivePhoneResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SetActivePhoneResponse >& response) = 0;
};

class SetRingtoneCallbackIF {
public:
    virtual ~SetRingtoneCallbackIF() {}

    virtual void onSetRingtoneError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SetRingtoneError >& error) = 0;

    virtual void onSetRingtoneResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SetRingtoneResponse >& response) = 0;
};

class StartStopRingtoneCallbackIF {
public:
    virtual ~StartStopRingtoneCallbackIF() {}

    virtual void onStartStopRingtoneError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< StartStopRingtoneError >& error) = 0;

    virtual void onStartStopRingtoneResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< StartStopRingtoneResponse >& response) = 0;
};

class SuppressRingtoneOnOffCallbackIF {
public:
    virtual ~SuppressRingtoneOnOffCallbackIF() {}

    virtual void onSuppressRingtoneOnOffError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffError >& error) = 0;

    virtual void onSuppressRingtoneOnOffResponse(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffResponse >& response) = 0;
};

class SuppressRingtoneOnOffListCallbackIF {
public:
    virtual ~SuppressRingtoneOnOffListCallbackIF() {}

    virtual void onSuppressRingtoneOnOffListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffListError >& error) = 0;

    virtual void onSuppressRingtoneOnOffListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SuppressRingtoneOnOffListUpdate >& update) = 0;
};

class SystemWideRingtonesListCallbackIF {
public:
    virtual ~SystemWideRingtonesListCallbackIF() {}

    virtual void onSystemWideRingtonesListError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListError >& error) = 0;

    virtual void onSystemWideRingtonesListUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< SystemWideRingtonesListUpdate >& update) = 0;
};

class WaitingModeFilePathCallbackIF {
public:
    virtual ~WaitingModeFilePathCallbackIF() {}

    virtual void onWaitingModeFilePathError(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< WaitingModeFilePathError >& error) = 0;

    virtual void onWaitingModeFilePathUpdate(const ::boost::shared_ptr< HfpManagerProxy >& proxy, const ::boost::shared_ptr< WaitingModeFilePathUpdate >& update) = 0;
};


/**
 * HfpManagerProxy is the client side representation of the D-Bus service
 * interface 'com.bosch.pmapp.HfpManager' (specified in file
 * pmapp_hfp_manager_.xml).
 *
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/
 *
 *     Note:
 *     [1]
 *         TODO: Definition of the "Paired device" to be rephrased.
 *         - Paired device:
 *             From Phone Call Manager perspective, the paired device is the one which is paired and
 *             was HFP connected at least once with the vehicle HU.
 *     [2]
 *         - Active device:
 *             It is a HFP connected device for which
 *               -the SCO(Synchronous Connection Oriented) link could be established and
 *               -the phone call audio or Bluetooth Voice Recognition(BT-VR) audio shall be streamed
 *             between the AG and the HU speakers.
 *         - Passive device:
 *             It is a HFP connected device for which the SCO link shall not be established between AG and vehicle HU and
 *             hence the audio streaming is not possible.
 *     [3]- The string "All" is case-insensitive.
 *
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */
class HfpManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HfpManagerProxy.
     */
    static ::boost::shared_ptr< HfpManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HfpManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HfpManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HfpManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HfpManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HfpManagerProxy > proxyNew(new HfpManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~HfpManagerProxy ();


    // Signal 'NotificationEvent'

    /**
     * Notify on the signal 'NotificationEvent'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'NotificationEvent'</b>:
     *
     * Indicate different phone call manager related events.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotificationEventRegister(NotificationEventCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NotificationEvent'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NotificationEvent'</b>:
     *
     * Indicate different phone call manager related events.
     *
     * @param act The act which was previously returned by the
     * sendNotificationEventRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNotificationEventDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NotificationEvent'.
     */
    void sendNotificationEventDeregisterAll () const;


    // Property 'SystemWideRingtonesList'

    /**
     * Notify on the property 'SystemWideRingtonesList'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemWideRingtonesListRegister(SystemWideRingtonesListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SystemWideRingtonesList'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @param act The act which was previously returned by the
     * sendSystemWideRingtonesListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSystemWideRingtonesListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'SystemWideRingtonesList'.
     */
    void sendSystemWideRingtonesListDeregisterAll() const;

    /**
     * Request the value of the property 'SystemWideRingtonesList' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SystemWideRingtonesList'</b>:
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemWideRingtonesListGet(SystemWideRingtonesListCallbackIF& cb);


    /**
     * Returns the current value of the property 'SystemWideRingtonesList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSystemWideRingtonesList() returns true.
     *
     * @return the previously received value of the property 'SystemWideRingtonesList'.
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& getSystemWideRingtonesList() const;

    /**
     * Determines whether a status message for the property
     * 'SystemWideRingtonesList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemWideRingtonesList() const;

    // Property 'DeviceRingtoneList'

    /**
     * Notify on the property 'DeviceRingtoneList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRingtoneListRegister(DeviceRingtoneListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DeviceRingtoneList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @param act The act which was previously returned by the
     * sendDeviceRingtoneListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceRingtoneListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DeviceRingtoneList'.
     */
    void sendDeviceRingtoneListDeregisterAll() const;

    /**
     * Request the value of the property 'DeviceRingtoneList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DeviceRingtoneList'</b>:
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRingtoneListGet(DeviceRingtoneListCallbackIF& cb);


    /**
     * Returns the current value of the property 'DeviceRingtoneList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceRingtoneList() returns true.
     *
     * @return the previously received value of the property 'DeviceRingtoneList'.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneList() const;

    /**
     * Determines whether a status message for the property
     * 'DeviceRingtoneList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceRingtoneList() const;

    // Property 'SuppressRingtoneOnOffList'

    /**
     * Notify on the property 'SuppressRingtoneOnOffList'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffListRegister(SuppressRingtoneOnOffListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SuppressRingtoneOnOffList'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param act The act which was previously returned by the
     * sendSuppressRingtoneOnOffListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSuppressRingtoneOnOffListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'SuppressRingtoneOnOffList'.
     */
    void sendSuppressRingtoneOnOffListDeregisterAll() const;

    /**
     * Request the value of the property 'SuppressRingtoneOnOffList' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOffList'</b>:
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffListGet(SuppressRingtoneOnOffListCallbackIF& cb);


    /**
     * Returns the current value of the property 'SuppressRingtoneOnOffList'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSuppressRingtoneOnOffList() returns true.
     *
     * @return the previously received value of the property 'SuppressRingtoneOnOffList'.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getSuppressRingtoneOnOffList() const;

    /**
     * Determines whether a status message for the property
     * 'SuppressRingtoneOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSuppressRingtoneOnOffList() const;

    // Property 'AutoWaitingModeOnOffList'

    /**
     * Notify on the property 'AutoWaitingModeOnOffList'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffListRegister(AutoWaitingModeOnOffListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AutoWaitingModeOnOffList'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param act The act which was previously returned by the
     * sendAutoWaitingModeOnOffListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAutoWaitingModeOnOffListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'AutoWaitingModeOnOffList'.
     */
    void sendAutoWaitingModeOnOffListDeregisterAll() const;

    /**
     * Request the value of the property 'AutoWaitingModeOnOffList' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOffList'</b>:
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffListGet(AutoWaitingModeOnOffListCallbackIF& cb);


    /**
     * Returns the current value of the property 'AutoWaitingModeOnOffList'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAutoWaitingModeOnOffList() returns true.
     *
     * @return the previously received value of the property 'AutoWaitingModeOnOffList'.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getAutoWaitingModeOnOffList() const;

    /**
     * Determines whether a status message for the property
     * 'AutoWaitingModeOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoWaitingModeOnOffList() const;

    // Property 'WaitingModeFilePath'

    /**
     * Notify on the property 'WaitingModeFilePath'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeFilePathRegister(WaitingModeFilePathCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WaitingModeFilePath'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param act The act which was previously returned by the
     * sendWaitingModeFilePathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWaitingModeFilePathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WaitingModeFilePath'.
     */
    void sendWaitingModeFilePathDeregisterAll() const;

    /**
     * Request the value of the property 'WaitingModeFilePath' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeFilePathGet(WaitingModeFilePathCallbackIF& cb);

    /**
     * Set the value of the property 'WaitingModeFilePath'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendWaitingModeFilePathSet(WaitingModeFilePathCallbackIF& cb, const
     * ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType&
     * waitingModeFilePath) method instead.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     */
    void sendWaitingModeFilePathSet(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath);

    /**
     * Set the value of the property 'WaitingModeFilePath'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'WaitingModeFilePath'</b>:
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWaitingModeFilePathSet(WaitingModeFilePathCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath);

    /**
     * Returns the current value of the property 'WaitingModeFilePath' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasWaitingModeFilePath() returns true.
     *
     * @return the previously received value of the property 'WaitingModeFilePath'.
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& getWaitingModeFilePath() const;

    /**
     * Determines whether a status message for the property
     * 'WaitingModeFilePath' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWaitingModeFilePath() const;

    // Property 'PhoneCallAudioActive'

    /**
     * Notify on the property 'PhoneCallAudioActive'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhoneCallAudioActiveRegister(PhoneCallAudioActiveCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PhoneCallAudioActive'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @param act The act which was previously returned by the
     * sendPhoneCallAudioActiveRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPhoneCallAudioActiveDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PhoneCallAudioActive'.
     */
    void sendPhoneCallAudioActiveDeregisterAll() const;

    /**
     * Request the value of the property 'PhoneCallAudioActive' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PhoneCallAudioActive'</b>:
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPhoneCallAudioActiveGet(PhoneCallAudioActiveCallbackIF& cb);


    /**
     * Returns the current value of the property 'PhoneCallAudioActive' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPhoneCallAudioActive() returns true.
     *
     * @return the previously received value of the property 'PhoneCallAudioActive'.
     */
    bool getPhoneCallAudioActive() const;

    /**
     * Determines whether a status message for the property
     * 'PhoneCallAudioActive' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPhoneCallAudioActive() const;

    // Property 'ActivePassiveDeviceList'

    /**
     * Notify on the property 'ActivePassiveDeviceList'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivePassiveDeviceListRegister(ActivePassiveDeviceListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActivePassiveDeviceList'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @param act The act which was previously returned by the
     * sendActivePassiveDeviceListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActivePassiveDeviceListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'ActivePassiveDeviceList'.
     */
    void sendActivePassiveDeviceListDeregisterAll() const;

    /**
     * Request the value of the property 'ActivePassiveDeviceList' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActivePassiveDeviceList'</b>:
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivePassiveDeviceListGet(ActivePassiveDeviceListCallbackIF& cb);


    /**
     * Returns the current value of the property 'ActivePassiveDeviceList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasActivePassiveDeviceList() returns true.
     *
     * @return the previously received value of the property 'ActivePassiveDeviceList'.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getActivePassiveDeviceList() const;

    /**
     * Determines whether a status message for the property
     * 'ActivePassiveDeviceList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActivePassiveDeviceList() const;

    // Property 'DeviceObjectPathList'

    /**
     * Notify on the property 'DeviceObjectPathList'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceObjectPathListRegister(DeviceObjectPathListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DeviceObjectPathList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @param act The act which was previously returned by the
     * sendDeviceObjectPathListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceObjectPathListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DeviceObjectPathList'.
     */
    void sendDeviceObjectPathListDeregisterAll() const;

    /**
     * Request the value of the property 'DeviceObjectPathList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DeviceObjectPathList'</b>:
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceObjectPathListGet(DeviceObjectPathListCallbackIF& cb);


    /**
     * Returns the current value of the property 'DeviceObjectPathList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceObjectPathList() returns true.
     *
     * @return the previously received value of the property 'DeviceObjectPathList'.
     */
    const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathList() const;

    /**
     * Determines whether a status message for the property
     * 'DeviceObjectPathList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceObjectPathList() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the HfpManager Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'StartStopRingtone'

    /**
     * Call the method 'StartStopRingtone'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'StartStopRingtone'</b>:
     *
     * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InUse
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param StartStop TRUE - Start playing ringtone
     *                 FALSE - Stop playing the ringtone
     *
     * @param RingtoneID Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *                 Note:-
     *                 1. RingtoneID - 0x01 is forbidden for this method,
     *                 2. The clients need not set the ringtone ID, when the interface is invoked with the parameter StartStop as FALSE.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartStopRingtoneRequest(StartStopRingtoneCallbackIF& cb, bool startStop, uint8 ringtoneID) const;

    // Method 'SetRingtone'

    /**
     * Call the method 'SetRingtone'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetRingtone'</b>:
     *
     * Set the active ringtone for system wide or device specific.
     *
     *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
     *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param DeviceAddress BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the received RingtoneID is set for all the
     *                 paired devices[1] treating it as a system wide ringtone.
     *
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param RingtoneID Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRingtoneRequest(SetRingtoneCallbackIF& cb, const ::std::string& deviceAddress, uint8 ringtoneID) const;

    // Method 'SuppressRingtoneOnOff'

    /**
     * Call the method 'SuppressRingtoneOnOff'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'SuppressRingtoneOnOff'</b>:
     *
     * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
     *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
     *
     *         The updated changes will be available in the SuppressRingtoneOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param onOffSetting Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all the
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSuppressRingtoneOnOffRequest(SuppressRingtoneOnOffCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting) const;

    // Method 'AutoWaitingModeOnOff'

    /**
     * Call the method 'AutoWaitingModeOnOff'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'AutoWaitingModeOnOff'</b>:
     *
     * Provides the ability to enable or disable the auto waiting mode setting.
     *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
     *         mode tone will be heard in the far end.
     *
     *         The updated changes will be available in the AutoWaitingModeOnOffList property.
     *
     *         Note: - The setting will be retained persistently by Phone call Manager(PM).
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param onOffSetting Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoWaitingModeOnOffRequest(AutoWaitingModeOnOffCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting) const;

    // Method 'SetActivePhone'

    /**
     * Call the method 'SetActivePhone'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetActivePhone'</b>:
     *
     * Provides the ability to set a device as an active device[2].
     *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
     *
     *         Note: - This API is meant to be invoked only for HFP connected devices.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param DeviceAddressList List of BT Addresses of the HFP connected devices that shall be made Active[2].
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetActivePhoneRequest(SetActivePhoneCallbackIF& cb, const ::std::vector< ::std::string >& deviceAddressList) const;

    // Method 'RestoreFactorySetting'

    /**
     * Call the method 'RestoreFactorySetting'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RestoreFactorySetting'</b>:
     *
     * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param DeviceAddress BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the settings for all the devices will be reset to default.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestoreFactorySettingRequest(RestoreFactorySettingCallbackIF& cb, const ::std::string& deviceAddress) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HfpManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'SystemWideRingtonesList'

    ::asf::core::nullable< SystemWideRingtonesListUpdate > _systemWideRingtonesList;

    // Property 'DeviceRingtoneList'

    ::asf::core::nullable< DeviceRingtoneListUpdate > _deviceRingtoneList;

    // Property 'SuppressRingtoneOnOffList'

    ::asf::core::nullable< SuppressRingtoneOnOffListUpdate > _suppressRingtoneOnOffList;

    // Property 'AutoWaitingModeOnOffList'

    ::asf::core::nullable< AutoWaitingModeOnOffListUpdate > _autoWaitingModeOnOffList;

    // Property 'WaitingModeFilePath'

    ::asf::core::nullable< WaitingModeFilePathUpdate > _waitingModeFilePath;

    // Property 'PhoneCallAudioActive'

    ::asf::core::nullable< PhoneCallAudioActiveUpdate > _phoneCallAudioActive;

    // Property 'ActivePassiveDeviceList'

    ::asf::core::nullable< ActivePassiveDeviceListUpdate > _activePassiveDeviceList;

    // Property 'DeviceObjectPathList'

    ::asf::core::nullable< DeviceObjectPathListUpdate > _deviceObjectPathList;

    DECLARE_CLASS_LOGGER();

    friend class HfpManagerProxyCallback;
};

} // namespace HfpManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_HFPMANAGERPROXY_H
