/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_DEVICEINFOSTUB_H
#define COM_BOSCH_PMAPP_DEVICEINFOSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/DeviceInfo.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <map>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace DeviceInfo {

class DeviceInfoStubDelegate;

class DeviceInfoStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DeviceInfoStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DeviceInfoStub (const std::string& portName);

    /**
     * Create an instance of the DeviceInfoStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DeviceInfoStub (const std::string& portName, const std::string& objectPath);

    virtual ~DeviceInfoStub();

    // property 'SupportedFeatures'

    /**
     * The method onSupportedFeaturesGet() is called by ASF when a client
     * invokes the read method for the property 'SupportedFeatures'. The
     * onSupportedFeaturesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     */
    virtual void onSupportedFeaturesGet(const ::boost::shared_ptr< SupportedFeaturesGet >& payload);

    /**
     * Sends back the update to a previous onSupportedFeaturesGet().
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @param act Identifies a previous invocation of
     * onSupportedFeaturesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSupportedFeaturesGetUpdate(const ::std::vector< ::std::string >& supportedFeatures, act_t act = 0);

    /**
     * Set the value of the property 'SupportedFeatures' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     */
    void setSupportedFeatures(const ::std::vector< ::std::string >& supportedFeatures);

    /**
     * Returns the current value of the property 'SupportedFeatures'.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     */
    const ::std::vector< ::std::string >& getSupportedFeatures() const;

    /**
     * Returns the current value of the property 'SupportedFeatures' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSupportedFeaturesUpdate() method.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     */
    ::std::vector< ::std::string >& getSupportedFeaturesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSupportedFeaturesUpdate().
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     */
    void sendSupportedFeaturesUpdate();

    // property 'FriendlyName'

    /**
     * The method onFriendlyNameGet() is called by ASF when a client invokes
     * the read method for the property 'FriendlyName'. The
     * onFriendlyNameGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     */
    virtual void onFriendlyNameGet(const ::boost::shared_ptr< FriendlyNameGet >& payload);

    /**
     * Sends back the update to a previous onFriendlyNameGet().
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param act Identifies a previous invocation of onFriendlyNameGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFriendlyNameGetUpdate(const ::std::string& friendlyName, act_t act = 0);

    /**
     * Set the value of the property 'FriendlyName' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     */
    void setFriendlyName(const ::std::string& friendlyName);

    /**
     * Returns the current value of the property 'FriendlyName'.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     */
    const ::std::string& getFriendlyName() const;

    /**
     * Returns the current value of the property 'FriendlyName' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFriendlyNameUpdate() method.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     */
    ::std::string& getFriendlyNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFriendlyNameUpdate().
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     */
    void sendFriendlyNameUpdate();

    // property 'NetworkStatus'

    /**
     * The method onNetworkStatusGet() is called by ASF when a client invokes
     * the read method for the property 'NetworkStatus'. The
     * onNetworkStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     */
    virtual void onNetworkStatusGet(const ::boost::shared_ptr< NetworkStatusGet >& payload);

    /**
     * Sends back the update to a previous onNetworkStatusGet().
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @param act Identifies a previous invocation of onNetworkStatusGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNetworkStatusGetUpdate(uint8 networkStatus, act_t act = 0);

    /**
     * Set the value of the property 'NetworkStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     */
    void setNetworkStatus(uint8 networkStatus);

    /**
     * Returns the current value of the property 'NetworkStatus'.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     */
    uint8 getNetworkStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNetworkStatusUpdate().
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     */
    void sendNetworkStatusUpdate();

    // property 'SignalStrength'

    /**
     * The method onSignalStrengthGet() is called by ASF when a client invokes
     * the read method for the property 'SignalStrength'. The
     * onSignalStrengthGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    virtual void onSignalStrengthGet(const ::boost::shared_ptr< SignalStrengthGet >& payload);

    /**
     * Sends back the update to a previous onSignalStrengthGet().
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param act Identifies a previous invocation of onSignalStrengthGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSignalStrengthGetUpdate(uint8 signalStrength, act_t act = 0);

    /**
     * Set the value of the property 'SignalStrength' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    void setSignalStrength(uint8 signalStrength);

    /**
     * Returns the current value of the property 'SignalStrength'.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    uint8 getSignalStrength() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSignalStrengthUpdate().
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    void sendSignalStrengthUpdate();

    // property 'BatteryChargeLevel'

    /**
     * The method onBatteryChargeLevelGet() is called by ASF when a client
     * invokes the read method for the property 'BatteryChargeLevel'. The
     * onBatteryChargeLevelGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    virtual void onBatteryChargeLevelGet(const ::boost::shared_ptr< BatteryChargeLevelGet >& payload);

    /**
     * Sends back the update to a previous onBatteryChargeLevelGet().
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param act Identifies a previous invocation of
     * onBatteryChargeLevelGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBatteryChargeLevelGetUpdate(uint8 batteryChargeLevel, act_t act = 0);

    /**
     * Set the value of the property 'BatteryChargeLevel' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    void setBatteryChargeLevel(uint8 batteryChargeLevel);

    /**
     * Returns the current value of the property 'BatteryChargeLevel'.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    uint8 getBatteryChargeLevel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBatteryChargeLevelUpdate().
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     */
    void sendBatteryChargeLevelUpdate();

    // property 'NetworkOperator'

    /**
     * The method onNetworkOperatorGet() is called by ASF when a client
     * invokes the read method for the property 'NetworkOperator'. The
     * onNetworkOperatorGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     */
    virtual void onNetworkOperatorGet(const ::boost::shared_ptr< NetworkOperatorGet >& payload);

    /**
     * Sends back the update to a previous onNetworkOperatorGet().
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param act Identifies a previous invocation of onNetworkOperatorGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNetworkOperatorGetUpdate(const ::std::string& networkOperator, act_t act = 0);

    /**
     * Set the value of the property 'NetworkOperator' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     */
    void setNetworkOperator(const ::std::string& networkOperator);

    /**
     * Returns the current value of the property 'NetworkOperator'.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     */
    const ::std::string& getNetworkOperator() const;

    /**
     * Returns the current value of the property 'NetworkOperator' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendNetworkOperatorUpdate() method.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     */
    ::std::string& getNetworkOperatorMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNetworkOperatorUpdate().
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     */
    void sendNetworkOperatorUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all the properties of the DeviceInfo Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all the properties of the DeviceInfo Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param DeviceInfoProperties Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"FriendlyName","My Phone"},
     *                   {"SignalStrength", 0x04},
     *                   ...
     *                 }
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& deviceInfoProperties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all the properties of the DeviceInfo Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'VoiceMailList'

    /**
     * The method onVoiceMailList() is called by ASF when a client invokes the
     * method 'VoiceMailList'. A subclass has to implement this method and
     * send back a response to the client either with the sendVoiceMailList()
     * or sendVoiceMailListError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'VoiceMailList'</b>:
     *
     * Provides the voice mail numbers of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotSupported
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onVoiceMailListRequest (const ::boost::shared_ptr< VoiceMailListRequest >& request) = 0;

    /**
     * The method sendVoiceMailListResponse() sends a response of a previous
     * method invocation of 'VoiceMailList' back to the client.
     *
     * <b>Documentation of 'VoiceMailList'</b>:
     *
     * Provides the voice mail numbers of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotSupported
     *
     * @param VoiceMailList Type Representation- Array:
     *                 [(String, UInt8)]
     *
     *                 Example:
     *                 [
     *                   ("1122334455", 0x01),
     *                   ("6677889900", 0x03)
     *                 ]
     *
     * @param act The parameter act identifies a previous invocation of
     * onVoiceMailList(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendVoiceMailListResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& voiceMailList, act_t act = 0);

    /**
     * The method sendVoiceMailListError() sends an error response of a
     * previous method invocation of 'VoiceMailList' back to the client.
     *
     * <b>Documentation of 'VoiceMailList'</b>:
     *
     * Provides the voice mail numbers of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotSupported
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onVoiceMailList(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendVoiceMailListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SupportedFeaturesUpdate _SupportedFeaturesProperty;

    FriendlyNameUpdate _FriendlyNameProperty;

    NetworkStatusUpdate _NetworkStatusProperty;

    SignalStrengthUpdate _SignalStrengthProperty;

    BatteryChargeLevelUpdate _BatteryChargeLevelProperty;

    NetworkOperatorUpdate _NetworkOperatorProperty;

    friend class DeviceInfoStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DeviceInfo
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_DEVICEINFOSTUB_H
