/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/DeviceInfo.h"
#include "com/bosch/pmapp/DeviceInfoDBus.h"
#include "com/bosch/pmapp/DeviceInfoJson.h"
#include "com/bosch/pmapp/DeviceInfoStub.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace DeviceInfo {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/DeviceInfo", DeviceInfoStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "GetProperties", 0 },
    { 13, "VoiceMailList", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 12, "FriendlyName", 1 },
    { 13, "NetworkStatus", 2 },
    { 14, "SignalStrength", 3 },
    { 15, "NetworkOperator", 5 },
    { 17, "SupportedFeatures", 0 },
    { 18, "BatteryChargeLevel", 4 },
};

class DeviceInfoStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DeviceInfoStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DeviceInfoStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DeviceInfoStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.pmapp.DeviceInfo"),
          _logger(logger) {}

    virtual ~DeviceInfoStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DeviceInfoStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DeviceInfoStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'VoiceMailList'

            LOG_DEBUG_STUB("process method '%s'", "VoiceMailList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceMailListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "VoiceMailList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< VoiceMailListRequest > payload = ::boost::static_pointer_cast<VoiceMailListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DeviceInfoStub*>(getStub())->onVoiceMailListRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DeviceInfoStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.pmapp.DeviceInfo\">\n"
            "    <property access=\"read\" name=\"SupportedFeatures\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"FriendlyName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"NetworkStatus\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"SignalStrength\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"BatteryChargeLevel\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"NetworkOperator\" type=\"s\"/>\n"
            "    <method name=\"GetProperties\">\n"
            "      <doc>\n"
            "        <line>GetProperties = Returns all the properties of the DeviceInfo Interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>---</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DeviceInfoProperties\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>DeviceInfoProperties (of type DeviceInfoPropertiesList) = Type representation of the parameter - Dict:</line>\n"
            "          <line>{ PropertyName : PropertyValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;FriendlyName&quot;,&quot;My Phone&quot;},</line>\n"
            "          <line>{&quot;SignalStrength&quot;, 0x04},</line>\n"
            "          <line>...</line>\n"
            "          <line>}</line>\n"
            "          <line>DeviceInfoPropertiesList = dictionary(key=STRING,value=DeviceInfoVariant)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"VoiceMailList\">\n"
            "      <doc>\n"
            "        <line>VoiceMailList = Provides the voice mail numbers of the Audio Gateway.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.AG.XXX</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.NotSupported</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"VoiceMailList\" type=\"a(ys)\">\n"
            "        <doc>\n"
            "          <line>VoiceMailList (of type VoiceMailListType) = Type Representation- Array:</line>\n"
            "          <line>[(String, UInt8)]</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>[</line>\n"
            "          <line>(&quot;1122334455&quot;, 0x01),</line>\n"
            "          <line>(&quot;6677889900&quot;, 0x03)</line>\n"
            "          <line>]</line>\n"
            "          <line>VoiceMailListType = array[VoiceMail]</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void DeviceInfoStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DeviceInfoStub*>(getStub()))->onGetAll (properties);
}

void DeviceInfoStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 6, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedFeatures");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "FriendlyName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "NetworkStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "SignalStrength");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "BatteryChargeLevel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "NetworkOperator");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DeviceInfoStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 6, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedFeatures");
            ::boost::shared_ptr< SupportedFeaturesGet > payload(new SupportedFeaturesGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onSupportedFeaturesGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "FriendlyName");
            ::boost::shared_ptr< FriendlyNameGet > payload(new FriendlyNameGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onFriendlyNameGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "NetworkStatus");
            ::boost::shared_ptr< NetworkStatusGet > payload(new NetworkStatusGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onNetworkStatusGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "SignalStrength");
            ::boost::shared_ptr< SignalStrengthGet > payload(new SignalStrengthGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onSignalStrengthGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "BatteryChargeLevel");
            ::boost::shared_ptr< BatteryChargeLevelGet > payload(new BatteryChargeLevelGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onBatteryChargeLevelGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "NetworkOperator");
            ::boost::shared_ptr< NetworkOperatorGet > payload(new NetworkOperatorGet());
            payload->setAct(act);
            static_cast<DeviceInfoStub*>(getStub())->onNetworkOperatorGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DeviceInfoStub::DeviceInfoStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DeviceInfoStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DeviceInfoStub::DeviceInfoStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DeviceInfoStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DeviceInfoStub::~DeviceInfoStub() {
    delete _stubDelegate;
}

void DeviceInfoStub::sendSupportedFeaturesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SupportedFeaturesUpdate payload(_SupportedFeaturesProperty);

        LOG_INFO ("-> send%s", "SupportedFeaturesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SupportedFeatures", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SupportedFeaturesUpdate");
    }
}

void DeviceInfoStub::onSupportedFeaturesGet(const ::boost::shared_ptr< SupportedFeaturesGet >& supportedFeatures) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SupportedFeaturesGet", supportedFeatures->getAct());
    sendSupportedFeaturesGetUpdate(_SupportedFeaturesProperty.getSupportedFeatures(), supportedFeatures->getAct());
}

void DeviceInfoStub::sendSupportedFeaturesGetUpdate(const ::std::vector< ::std::string >& supportedFeatures, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SupportedFeaturesGet payload(supportedFeatures);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SupportedFeaturesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setSupportedFeatures(const ::std::vector< ::std::string >& supportedFeatures) {
    if(supportedFeatures!=_SupportedFeaturesProperty.getSupportedFeatures()) {
        _SupportedFeaturesProperty.setSupportedFeatures(supportedFeatures);
        sendSupportedFeaturesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& DeviceInfoStub::getSupportedFeatures() const {
    return _SupportedFeaturesProperty.getSupportedFeatures();
}

::std::vector< ::std::string >& DeviceInfoStub::getSupportedFeaturesMutable() {
    return _SupportedFeaturesProperty.getSupportedFeaturesMutable();
}

void DeviceInfoStub::sendFriendlyNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FriendlyNameUpdate payload(_FriendlyNameProperty);

        LOG_INFO ("-> send%s", "FriendlyNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FriendlyName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FriendlyNameUpdate");
    }
}

void DeviceInfoStub::onFriendlyNameGet(const ::boost::shared_ptr< FriendlyNameGet >& friendlyName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FriendlyNameGet", friendlyName->getAct());
    sendFriendlyNameGetUpdate(_FriendlyNameProperty.getFriendlyName(), friendlyName->getAct());
}

void DeviceInfoStub::sendFriendlyNameGetUpdate(const ::std::string& friendlyName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FriendlyNameGet payload(friendlyName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FriendlyNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setFriendlyName(const ::std::string& friendlyName) {
    if(friendlyName!=_FriendlyNameProperty.getFriendlyName()) {
        _FriendlyNameProperty.setFriendlyName(friendlyName);
        sendFriendlyNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& DeviceInfoStub::getFriendlyName() const {
    return _FriendlyNameProperty.getFriendlyName();
}

::std::string& DeviceInfoStub::getFriendlyNameMutable() {
    return _FriendlyNameProperty.getFriendlyNameMutable();
}

void DeviceInfoStub::sendNetworkStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NetworkStatusUpdate payload(_NetworkStatusProperty);

        LOG_INFO ("-> send%s", "NetworkStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NetworkStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NetworkStatusUpdate");
    }
}

void DeviceInfoStub::onNetworkStatusGet(const ::boost::shared_ptr< NetworkStatusGet >& networkStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NetworkStatusGet", networkStatus->getAct());
    sendNetworkStatusGetUpdate(_NetworkStatusProperty.getNetworkStatus(), networkStatus->getAct());
}

void DeviceInfoStub::sendNetworkStatusGetUpdate(uint8 networkStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NetworkStatusGet payload(networkStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NetworkStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setNetworkStatus(uint8 networkStatus) {
    if(networkStatus!=_NetworkStatusProperty.getNetworkStatus()) {
        _NetworkStatusProperty.setNetworkStatus(networkStatus);
        sendNetworkStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 DeviceInfoStub::getNetworkStatus() const {
    return _NetworkStatusProperty.getNetworkStatus();
}

void DeviceInfoStub::sendSignalStrengthUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SignalStrengthUpdate payload(_SignalStrengthProperty);

        LOG_INFO ("-> send%s", "SignalStrengthUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SignalStrength", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SignalStrengthUpdate");
    }
}

void DeviceInfoStub::onSignalStrengthGet(const ::boost::shared_ptr< SignalStrengthGet >& signalStrength) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SignalStrengthGet", signalStrength->getAct());
    sendSignalStrengthGetUpdate(_SignalStrengthProperty.getSignalStrength(), signalStrength->getAct());
}

void DeviceInfoStub::sendSignalStrengthGetUpdate(uint8 signalStrength, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SignalStrengthGet payload(signalStrength);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SignalStrengthGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setSignalStrength(uint8 signalStrength) {
    if(signalStrength!=_SignalStrengthProperty.getSignalStrength()) {
        _SignalStrengthProperty.setSignalStrength(signalStrength);
        sendSignalStrengthUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 DeviceInfoStub::getSignalStrength() const {
    return _SignalStrengthProperty.getSignalStrength();
}

void DeviceInfoStub::sendBatteryChargeLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BatteryChargeLevelUpdate payload(_BatteryChargeLevelProperty);

        LOG_INFO ("-> send%s", "BatteryChargeLevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BatteryChargeLevel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BatteryChargeLevelUpdate");
    }
}

void DeviceInfoStub::onBatteryChargeLevelGet(const ::boost::shared_ptr< BatteryChargeLevelGet >& batteryChargeLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BatteryChargeLevelGet", batteryChargeLevel->getAct());
    sendBatteryChargeLevelGetUpdate(_BatteryChargeLevelProperty.getBatteryChargeLevel(), batteryChargeLevel->getAct());
}

void DeviceInfoStub::sendBatteryChargeLevelGetUpdate(uint8 batteryChargeLevel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BatteryChargeLevelGet payload(batteryChargeLevel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BatteryChargeLevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setBatteryChargeLevel(uint8 batteryChargeLevel) {
    if(batteryChargeLevel!=_BatteryChargeLevelProperty.getBatteryChargeLevel()) {
        _BatteryChargeLevelProperty.setBatteryChargeLevel(batteryChargeLevel);
        sendBatteryChargeLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 DeviceInfoStub::getBatteryChargeLevel() const {
    return _BatteryChargeLevelProperty.getBatteryChargeLevel();
}

void DeviceInfoStub::sendNetworkOperatorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NetworkOperatorUpdate payload(_NetworkOperatorProperty);

        LOG_INFO ("-> send%s", "NetworkOperatorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NetworkOperator", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.DeviceInfo", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NetworkOperatorUpdate");
    }
}

void DeviceInfoStub::onNetworkOperatorGet(const ::boost::shared_ptr< NetworkOperatorGet >& networkOperator) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NetworkOperatorGet", networkOperator->getAct());
    sendNetworkOperatorGetUpdate(_NetworkOperatorProperty.getNetworkOperator(), networkOperator->getAct());
}

void DeviceInfoStub::sendNetworkOperatorGetUpdate(const ::std::string& networkOperator, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NetworkOperatorGet payload(networkOperator);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NetworkOperatorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DeviceInfoStub::setNetworkOperator(const ::std::string& networkOperator) {
    if(networkOperator!=_NetworkOperatorProperty.getNetworkOperator()) {
        _NetworkOperatorProperty.setNetworkOperator(networkOperator);
        sendNetworkOperatorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& DeviceInfoStub::getNetworkOperator() const {
    return _NetworkOperatorProperty.getNetworkOperator();
}

::std::string& DeviceInfoStub::getNetworkOperatorMutable() {
    return _NetworkOperatorProperty.getNetworkOperatorMutable();
}

void  DeviceInfoStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& deviceInfoProperties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(deviceInfoProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DeviceInfoStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DeviceInfoStub::sendVoiceMailListResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& voiceMailList, act_t act) {
    VoiceMailListResponse* payload = new VoiceMailListResponse(voiceMailList);
    DBUS_MESSAGE_REPLY(dbusMessage, "VoiceMailList", VoiceMailListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "VoiceMailList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DeviceInfoStub::sendVoiceMailListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    VoiceMailListError* payload = new VoiceMailListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "VoiceMailList", VoiceMailListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "VoiceMailList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DeviceInfoStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SupportedFeatures'
    {
        ::asf::dbus::DBusVariant variant;
        SupportedFeaturesGet payload(_SupportedFeaturesProperty.getSupportedFeatures());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SupportedFeatures", variant));
    }

    //property 'FriendlyName'
    {
        ::asf::dbus::DBusVariant variant;
        FriendlyNameGet payload(_FriendlyNameProperty.getFriendlyName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FriendlyName", variant));
    }

    //property 'NetworkStatus'
    {
        ::asf::dbus::DBusVariant variant;
        NetworkStatusGet payload(_NetworkStatusProperty.getNetworkStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NetworkStatus", variant));
    }

    //property 'SignalStrength'
    {
        ::asf::dbus::DBusVariant variant;
        SignalStrengthGet payload(_SignalStrengthProperty.getSignalStrength());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SignalStrength", variant));
    }

    //property 'BatteryChargeLevel'
    {
        ::asf::dbus::DBusVariant variant;
        BatteryChargeLevelGet payload(_BatteryChargeLevelProperty.getBatteryChargeLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BatteryChargeLevel", variant));
    }

    //property 'NetworkOperator'
    {
        ::asf::dbus::DBusVariant variant;
        NetworkOperatorGet payload(_NetworkOperatorProperty.getNetworkOperator());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NetworkOperator", variant));
    }
}

} // namespace DeviceInfo
} // namespace pmapp
} // namespace bosch
} // namespace com
