/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/DeviceInfo.h"
#include "com/bosch/pmapp/DeviceInfoDBus.h"
#include "com/bosch/pmapp/DeviceInfoJson.h"
#include "com/bosch/pmapp/DeviceInfoProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace DeviceInfo {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/DeviceInfo", DeviceInfoProxy);

class DeviceInfoProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DeviceInfoProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DeviceInfoProxy >& proxyShared = ::boost::static_pointer_cast< DeviceInfoProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SupportedFeatures:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedFeaturesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedFeatures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedFeaturesError> payload = ::boost::static_pointer_cast<SupportedFeaturesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SupportedFeaturesCallbackIF*) _callback)->onSupportedFeaturesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedFeaturesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedFeatures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedFeaturesUpdate> payload = ::boost::static_pointer_cast<SupportedFeaturesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SupportedFeaturesCallbackIF*) _callback)->onSupportedFeaturesUpdate(proxyShared, payload);
                        proxyShared->_supportedFeatures = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FriendlyName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FriendlyNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FriendlyName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FriendlyNameError> payload = ::boost::static_pointer_cast<FriendlyNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FriendlyNameCallbackIF*) _callback)->onFriendlyNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FriendlyNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FriendlyName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FriendlyNameUpdate> payload = ::boost::static_pointer_cast<FriendlyNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FriendlyNameCallbackIF*) _callback)->onFriendlyNameUpdate(proxyShared, payload);
                        proxyShared->_friendlyName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NetworkStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NetworkStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NetworkStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NetworkStatusError> payload = ::boost::static_pointer_cast<NetworkStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NetworkStatusCallbackIF*) _callback)->onNetworkStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NetworkStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NetworkStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NetworkStatusUpdate> payload = ::boost::static_pointer_cast<NetworkStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NetworkStatusCallbackIF*) _callback)->onNetworkStatusUpdate(proxyShared, payload);
                        proxyShared->_networkStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SignalStrength:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SignalStrengthError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SignalStrength", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SignalStrengthError> payload = ::boost::static_pointer_cast<SignalStrengthError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SignalStrengthCallbackIF*) _callback)->onSignalStrengthError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SignalStrengthUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SignalStrength", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SignalStrengthUpdate> payload = ::boost::static_pointer_cast<SignalStrengthUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SignalStrengthCallbackIF*) _callback)->onSignalStrengthUpdate(proxyShared, payload);
                        proxyShared->_signalStrength = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BatteryChargeLevel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BatteryChargeLevelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BatteryChargeLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BatteryChargeLevelError> payload = ::boost::static_pointer_cast<BatteryChargeLevelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BatteryChargeLevelCallbackIF*) _callback)->onBatteryChargeLevelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BatteryChargeLevelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BatteryChargeLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BatteryChargeLevelUpdate> payload = ::boost::static_pointer_cast<BatteryChargeLevelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BatteryChargeLevelCallbackIF*) _callback)->onBatteryChargeLevelUpdate(proxyShared, payload);
                        proxyShared->_batteryChargeLevel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NetworkOperator:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NetworkOperatorError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NetworkOperator", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NetworkOperatorError> payload = ::boost::static_pointer_cast<NetworkOperatorError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NetworkOperatorCallbackIF*) _callback)->onNetworkOperatorError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NetworkOperatorUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NetworkOperator", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NetworkOperatorUpdate> payload = ::boost::static_pointer_cast<NetworkOperatorUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NetworkOperatorCallbackIF*) _callback)->onNetworkOperatorUpdate(proxyShared, payload);
                        proxyShared->_networkOperator = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_VoiceMailList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), VoiceMailListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoiceMailList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceMailListError> payload = ::boost::static_pointer_cast<VoiceMailListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VoiceMailListCallbackIF*) _callback)->onVoiceMailListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VoiceMailListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoiceMailList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VoiceMailListResponse> payload = ::boost::static_pointer_cast<VoiceMailListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((VoiceMailListCallbackIF*) _callback)->onVoiceMailListResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SupportedFeatures: {
                ::boost::shared_ptr< SupportedFeaturesError > payload = ::boost::shared_ptr< SupportedFeaturesError >
                (new SupportedFeaturesError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SupportedFeatures", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SupportedFeaturesCallbackIF*) _callback)->onSupportedFeaturesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FriendlyName: {
                ::boost::shared_ptr< FriendlyNameError > payload = ::boost::shared_ptr< FriendlyNameError >
                (new FriendlyNameError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FriendlyName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FriendlyNameCallbackIF*) _callback)->onFriendlyNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NetworkStatus: {
                ::boost::shared_ptr< NetworkStatusError > payload = ::boost::shared_ptr< NetworkStatusError >
                (new NetworkStatusError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NetworkStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NetworkStatusCallbackIF*) _callback)->onNetworkStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SignalStrength: {
                ::boost::shared_ptr< SignalStrengthError > payload = ::boost::shared_ptr< SignalStrengthError >
                (new SignalStrengthError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SignalStrength", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SignalStrengthCallbackIF*) _callback)->onSignalStrengthError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BatteryChargeLevel: {
                ::boost::shared_ptr< BatteryChargeLevelError > payload = ::boost::shared_ptr< BatteryChargeLevelError >
                (new BatteryChargeLevelError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BatteryChargeLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BatteryChargeLevelCallbackIF*) _callback)->onBatteryChargeLevelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NetworkOperator: {
                ::boost::shared_ptr< NetworkOperatorError > payload = ::boost::shared_ptr< NetworkOperatorError >
                (new NetworkOperatorError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NetworkOperator", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NetworkOperatorCallbackIF*) _callback)->onNetworkOperatorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VoiceMailList: {
                ::boost::shared_ptr< VoiceMailListError > payload = ::boost::shared_ptr< VoiceMailListError >
                (new VoiceMailListError(DBUS_ERROR_NO_SERVER, "The DBus service DeviceInfo is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VoiceMailList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DeviceInfoProxy> proxyShared = ::boost::static_pointer_cast<DeviceInfoProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VoiceMailListCallbackIF*) _callback)->onVoiceMailListError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DeviceInfoProxyCallback::_logger (DeviceInfoProxy::_logger);

DeviceInfoProxy::DeviceInfoProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.pmapp.DeviceInfo", serviceAvailable, _logger) {
}

DeviceInfoProxy::~DeviceInfoProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DeviceInfoProxy > DeviceInfoProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DeviceInfoProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DeviceInfoProxy > proxyNew(new DeviceInfoProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t DeviceInfoProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DeviceInfoProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void DeviceInfoProxy::clearAllProperties ()
{
    _supportedFeatures = ::asf::core::nullable< SupportedFeaturesUpdate >();
    _friendlyName = ::asf::core::nullable< FriendlyNameUpdate >();
    _networkStatus = ::asf::core::nullable< NetworkStatusUpdate >();
    _signalStrength = ::asf::core::nullable< SignalStrengthUpdate >();
    _batteryChargeLevel = ::asf::core::nullable< BatteryChargeLevelUpdate >();
    _networkOperator = ::asf::core::nullable< NetworkOperatorUpdate >();
}

void DeviceInfoProxy::sendDeregisterAll () const
{
    sendSupportedFeaturesDeregisterAll();
    sendFriendlyNameDeregisterAll();
    sendNetworkStatusDeregisterAll();
    sendSignalStrengthDeregisterAll();
    sendBatteryChargeLevelDeregisterAll();
    sendNetworkOperatorDeregisterAll();
}

act_t DeviceInfoProxy::sendSupportedFeaturesRegister(SupportedFeaturesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SupportedFeatures, "SupportedFeatures", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SupportedFeatures", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendSupportedFeaturesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SupportedFeatures", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SupportedFeatures", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendSupportedFeaturesGet(SupportedFeaturesCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_SupportedFeatures, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SupportedFeatures", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SupportedFeatures", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& DeviceInfoProxy::getSupportedFeatures() const {
    return _supportedFeatures.get().getSupportedFeatures();
}

bool DeviceInfoProxy::hasSupportedFeatures() const {
    return _supportedFeatures.hasValue();
}

void DeviceInfoProxy::sendSupportedFeaturesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SupportedFeatures");
    _dbusProxyDelegate->deregisterSignalCallback("SupportedFeatures", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendFriendlyNameRegister(FriendlyNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FriendlyName, "FriendlyName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FriendlyName", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendFriendlyNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FriendlyName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FriendlyName", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendFriendlyNameGet(FriendlyNameCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_FriendlyName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FriendlyName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FriendlyName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& DeviceInfoProxy::getFriendlyName() const {
    return _friendlyName.get().getFriendlyName();
}

bool DeviceInfoProxy::hasFriendlyName() const {
    return _friendlyName.hasValue();
}

void DeviceInfoProxy::sendFriendlyNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FriendlyName");
    _dbusProxyDelegate->deregisterSignalCallback("FriendlyName", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendNetworkStatusRegister(NetworkStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NetworkStatus, "NetworkStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NetworkStatus", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendNetworkStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NetworkStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NetworkStatus", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendNetworkStatusGet(NetworkStatusCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_NetworkStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NetworkStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NetworkStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 DeviceInfoProxy::getNetworkStatus() const {
    return _networkStatus.get().getNetworkStatus();
}

bool DeviceInfoProxy::hasNetworkStatus() const {
    return _networkStatus.hasValue();
}

void DeviceInfoProxy::sendNetworkStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NetworkStatus");
    _dbusProxyDelegate->deregisterSignalCallback("NetworkStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendSignalStrengthRegister(SignalStrengthCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SignalStrength, "SignalStrength", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SignalStrength", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendSignalStrengthDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SignalStrength", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SignalStrength", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendSignalStrengthGet(SignalStrengthCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_SignalStrength, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SignalStrength", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SignalStrength", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 DeviceInfoProxy::getSignalStrength() const {
    return _signalStrength.get().getSignalStrength();
}

bool DeviceInfoProxy::hasSignalStrength() const {
    return _signalStrength.hasValue();
}

void DeviceInfoProxy::sendSignalStrengthDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SignalStrength");
    _dbusProxyDelegate->deregisterSignalCallback("SignalStrength", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendBatteryChargeLevelRegister(BatteryChargeLevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BatteryChargeLevel, "BatteryChargeLevel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BatteryChargeLevel", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendBatteryChargeLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BatteryChargeLevel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BatteryChargeLevel", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendBatteryChargeLevelGet(BatteryChargeLevelCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_BatteryChargeLevel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BatteryChargeLevel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BatteryChargeLevel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 DeviceInfoProxy::getBatteryChargeLevel() const {
    return _batteryChargeLevel.get().getBatteryChargeLevel();
}

bool DeviceInfoProxy::hasBatteryChargeLevel() const {
    return _batteryChargeLevel.hasValue();
}

void DeviceInfoProxy::sendBatteryChargeLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BatteryChargeLevel");
    _dbusProxyDelegate->deregisterSignalCallback("BatteryChargeLevel", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendNetworkOperatorRegister(NetworkOperatorCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NetworkOperator, "NetworkOperator", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NetworkOperator", &cb, act);
    return act;
}

bool DeviceInfoProxy::sendNetworkOperatorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NetworkOperator", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NetworkOperator", act, static_cast<int>(rv));
    return rv;
}

act_t DeviceInfoProxy::sendNetworkOperatorGet(NetworkOperatorCallbackIF& cb) {
    DeviceInfoProxyCallback* callback = new DeviceInfoProxyCallback(ID_NetworkOperator, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NetworkOperator", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NetworkOperator", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& DeviceInfoProxy::getNetworkOperator() const {
    return _networkOperator.get().getNetworkOperator();
}

bool DeviceInfoProxy::hasNetworkOperator() const {
    return _networkOperator.hasValue();
}

void DeviceInfoProxy::sendNetworkOperatorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NetworkOperator");
    _dbusProxyDelegate->deregisterSignalCallback("NetworkOperator", 0, _dbusDaemonProxy.get(), true);
}

act_t DeviceInfoProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DeviceInfoProxy::sendVoiceMailListRequest(VoiceMailListCallbackIF& cb) const {
    VoiceMailListRequest* payload = new VoiceMailListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "VoiceMailList", VoiceMailListRequest, payload, true)
    act_t act = addMethodCallback(ID_VoiceMailList, dbusMessage.getUniqueSerial(), "VoiceMailList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "VoiceMailList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DeviceInfo
} // namespace pmapp
} // namespace bosch
} // namespace com
