#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_DEVICEINFO_H
#define COM_BOSCH_PMAPP_DEVICEINFO_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of the HFP connected device is - "aabbccddeeff", then the corresponding DeviceInfo interface
 *     will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace DeviceInfo {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_VoiceMailList = 1;

// signal IDs

// property IDs
static const uint16 ID_SupportedFeatures = 2;
static const uint16 ID_FriendlyName = 3;
static const uint16 ID_NetworkStatus = 4;
static const uint16 ID_SignalStrength = 5;
static const uint16 ID_BatteryChargeLevel = 6;
static const uint16 ID_NetworkOperator = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPropertiesResponse;

class VoiceMailListResponse;

class SupportedFeaturesUpdate;

class SupportedFeaturesRegister;

class FriendlyNameUpdate;

class FriendlyNameRegister;

class NetworkStatusUpdate;

class NetworkStatusRegister;

class SignalStrengthUpdate;

class SignalStrengthRegister;

class BatteryChargeLevelUpdate;

class BatteryChargeLevelRegister;

class NetworkOperatorUpdate;

class NetworkOperatorRegister;

// type definitions
/**
 * Returns all the properties of the DeviceInfo Interface.
 *
 *         Possible errors:
 *         ---
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * Provides the voice mail numbers of the Audio Gateway.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.NotSupported
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage VoiceMailListRequest;

/**
 * If the meaning of "VoiceMailListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoiceMailListError;

/**
 * Provides the supported features of Audio Gateway.
 *
 *         List of features supported by Audio Gateway:-
 *           3way: 3 way calling,
 *           ecnr: ECNR function,
 *           voice_recognition: Voice Recognition is supported,
 *           inband_ringtone: Inband Ringtone is supported,
 *           attach_voice_tag: Attaching a phone number to a voice tag,
 *           reject_incoming_call: Ability to reject an incoming call,
 *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
 *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
 *           extended_error_codes: Extended Audio Gateway error,
 *           codec_negotiation: Codec negotiation between HF and AG.
 *
 *         Type Representation - [String]
 *
 *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
 */
typedef SupportedFeaturesUpdate SupportedFeaturesSet;

/**
 * Provides the supported features of Audio Gateway.
 *
 *         List of features supported by Audio Gateway:-
 *           3way: 3 way calling,
 *           ecnr: ECNR function,
 *           voice_recognition: Voice Recognition is supported,
 *           inband_ringtone: Inband Ringtone is supported,
 *           attach_voice_tag: Attaching a phone number to a voice tag,
 *           reject_incoming_call: Ability to reject an incoming call,
 *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
 *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
 *           extended_error_codes: Extended Audio Gateway error,
 *           codec_negotiation: Codec negotiation between HF and AG.
 *
 *         Type Representation - [String]
 *
 *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
 */
typedef SupportedFeaturesUpdate SupportedFeaturesGet;

/**
 * If the meaning of "SupportedFeaturesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SupportedFeaturesError;

/**
 * Provides the friendly name of the Audio Gateway.
 *         The name would have been set in Audio Gateway by the user.
 *
 *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
 */
typedef FriendlyNameUpdate FriendlyNameSet;

/**
 * Provides the friendly name of the Audio Gateway.
 *         The name would have been set in Audio Gateway by the user.
 *
 *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
 */
typedef FriendlyNameUpdate FriendlyNameGet;

/**
 * If the meaning of "FriendlyNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FriendlyNameError;

/**
 * Provides the current network registration status of Audio Gateway.
 *
 *         The possible values are:
 *             0x00 : Unknown - Status is unknown
 *             0x01 : Unregistered - Not registered to any network
 *             0x02 : Registered - Registered to home network
 *             0x03 : Searching - Not registered, but searching
 *             0x04 : Denied - Registration has been denied
 *             0x05 : Roaming - Registered, but roaming
 *             0xFF : Default
 */
typedef NetworkStatusUpdate NetworkStatusSet;

/**
 * Provides the current network registration status of Audio Gateway.
 *
 *         The possible values are:
 *             0x00 : Unknown - Status is unknown
 *             0x01 : Unregistered - Not registered to any network
 *             0x02 : Registered - Registered to home network
 *             0x03 : Searching - Not registered, but searching
 *             0x04 : Denied - Registration has been denied
 *             0x05 : Roaming - Registered, but roaming
 *             0xFF : Default
 */
typedef NetworkStatusUpdate NetworkStatusGet;

/**
 * If the meaning of "NetworkStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NetworkStatusError;

/**
 * Provides the current signal strength of Audio Gateway.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
typedef SignalStrengthUpdate SignalStrengthSet;

/**
 * Provides the current signal strength of Audio Gateway.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
typedef SignalStrengthUpdate SignalStrengthGet;

/**
 * If the meaning of "SignalStrengthError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SignalStrengthError;

/**
 * Provides the current charge level of the battery.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
typedef BatteryChargeLevelUpdate BatteryChargeLevelSet;

/**
 * Provides the current charge level of the battery.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
typedef BatteryChargeLevelUpdate BatteryChargeLevelGet;

/**
 * If the meaning of "BatteryChargeLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BatteryChargeLevelError;

/**
 * Provides the current network operator name of Audio Gateway.
 *
 *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
 */
typedef NetworkOperatorUpdate NetworkOperatorSet;

/**
 * Provides the current network operator name of Audio Gateway.
 *
 *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
 */
typedef NetworkOperatorUpdate NetworkOperatorGet;

/**
 * If the meaning of "NetworkOperatorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NetworkOperatorError;


/**
 * Returns all the properties of the DeviceInfo Interface.
 *
 *         Possible errors:
 *         ---
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& DeviceInfoProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceInfoProperties"

    static const int kDeviceInfoProperties = 0;

    /**
     * Clears the field "DeviceInfoProperties".
     *
     * The field will be set to its default value. The hasDeviceInfoProperties()
     * method will return false.
     */
    inline void clearDeviceInfoProperties();

    /**
     * Checks whether the field "DeviceInfoProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceInfoProperties()). Otherwise it will return false.
     */
    inline bool hasDeviceInfoProperties () const;

    /**
     * Returns the value of the member "DeviceInfoProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"FriendlyName","My Phone"},
     *                   {"SignalStrength", 0x04},
     *                   ...
     *                 }
     *
     * @return The value of the field "DeviceInfoProperties"
     */
    inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& getDeviceInfoProperties () const;

    /**
     * Retrieves the value of the field "DeviceInfoProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceInfoProperties".
     */
    inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& getDeviceInfoPropertiesMutable ();

    /**
     * Sets the value of the member "DeviceInfoProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                 {
     *                   {"FriendlyName","My Phone"},
     *                   {"SignalStrength", 0x04},
     *                   ...
     *                 }
     *
     * @param DeviceInfoProperties The value which will be set
     */
    inline void setDeviceInfoProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& DeviceInfoProperties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& getStringToDeviceInfoVariantMap_DefaultInstance ();

    inline void set_has_DeviceInfoProperties ();

    inline void clear_has_DeviceInfoProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant > _DeviceInfoProperties;

};

/**
 * Provides the voice mail numbers of the Audio Gateway.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.NotSupported
 */
class VoiceMailListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceMailListResponse ();

    /**
     * Copy constructor
     */
    inline  VoiceMailListResponse (const VoiceMailListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceMailListResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailList_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceMailListResponse();

    /**
     * Assignment operator
     */
    inline VoiceMailListResponse& operator = (const VoiceMailListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceMailListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceMailListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceMailListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceMailListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceMailList"

    static const int kVoiceMailList = 0;

    /**
     * Clears the field "VoiceMailList".
     *
     * The field will be set to its default value. The hasVoiceMailList()
     * method will return false.
     */
    inline void clearVoiceMailList();

    /**
     * Checks whether the field "VoiceMailList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceMailList()). Otherwise it will return false.
     */
    inline bool hasVoiceMailList () const;

    /**
     * Returns the value of the member "VoiceMailList".
     *
     * Type Representation- Array:
     *                 [(String, UInt8)]
     *
     *                 Example:
     *                 [
     *                   ("1122334455", 0x01),
     *                   ("6677889900", 0x03)
     *                 ]
     *
     * @return The value of the field "VoiceMailList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& getVoiceMailList () const;

    /**
     * Retrieves the value of the field "VoiceMailList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceMailList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& getVoiceMailListMutable ();

    /**
     * Sets the value of the member "VoiceMailList".
     *
     * Type Representation- Array:
     *                 [(String, UInt8)]
     *
     *                 Example:
     *                 [
     *                   ("1122334455", 0x01),
     *                   ("6677889900", 0x03)
     *                 ]
     *
     * @param VoiceMailList The value which will be set
     */
    inline void setVoiceMailList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailList_);

    static const VoiceMailListResponse &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& getVoiceMailList_DefaultInstance ();

    inline void set_has_VoiceMailList ();

    inline void clear_has_VoiceMailList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail > _VoiceMailList;

};

/**
 * Provides the supported features of Audio Gateway.
 *
 *         List of features supported by Audio Gateway:-
 *           3way: 3 way calling,
 *           ecnr: ECNR function,
 *           voice_recognition: Voice Recognition is supported,
 *           inband_ringtone: Inband Ringtone is supported,
 *           attach_voice_tag: Attaching a phone number to a voice tag,
 *           reject_incoming_call: Ability to reject an incoming call,
 *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
 *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
 *           extended_error_codes: Extended Audio Gateway error,
 *           codec_negotiation: Codec negotiation between HF and AG.
 *
 *         Type Representation - [String]
 *
 *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
 */
class SupportedFeaturesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedFeaturesUpdate ();

    /**
     * Copy constructor
     */
    inline  SupportedFeaturesUpdate (const SupportedFeaturesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SupportedFeaturesUpdate (const ::std::vector< ::std::string >& SupportedFeatures_);

    /**
     * Destructor
     */
    inline virtual  ~SupportedFeaturesUpdate();

    /**
     * Assignment operator
     */
    inline SupportedFeaturesUpdate& operator = (const SupportedFeaturesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedFeaturesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedFeaturesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedFeaturesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedFeaturesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SupportedFeatures"

    static const int kSupportedFeatures = 0;

    /**
     * Clears the field "SupportedFeatures".
     *
     * The field will be set to its default value. The hasSupportedFeatures()
     * method will return false.
     */
    inline void clearSupportedFeatures();

    /**
     * Checks whether the field "SupportedFeatures" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupportedFeatures()). Otherwise it will return false.
     */
    inline bool hasSupportedFeatures () const;

    /**
     * Returns the value of the member "SupportedFeatures".
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @return The value of the field "SupportedFeatures"
     */
    inline const ::std::vector< ::std::string >& getSupportedFeatures () const;

    /**
     * Retrieves the value of the field "SupportedFeatures" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SupportedFeatures".
     */
    inline ::std::vector< ::std::string >& getSupportedFeaturesMutable ();

    /**
     * Sets the value of the member "SupportedFeatures".
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @param SupportedFeatures The value which will be set
     */
    inline void setSupportedFeatures (const ::std::vector< ::std::string >& SupportedFeatures_);

    static const SupportedFeaturesUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_SupportedFeatures ();

    inline void clear_has_SupportedFeatures ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _SupportedFeatures;

};

/**
 * Provides the supported features of Audio Gateway.
 *
 *         List of features supported by Audio Gateway:-
 *           3way: 3 way calling,
 *           ecnr: ECNR function,
 *           voice_recognition: Voice Recognition is supported,
 *           inband_ringtone: Inband Ringtone is supported,
 *           attach_voice_tag: Attaching a phone number to a voice tag,
 *           reject_incoming_call: Ability to reject an incoming call,
 *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
 *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
 *           extended_error_codes: Extended Audio Gateway error,
 *           codec_negotiation: Codec negotiation between HF and AG.
 *
 *         Type Representation - [String]
 *
 *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
 */
class SupportedFeaturesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedFeaturesRegister ();

    /**
     * Copy constructor
     */
    inline  SupportedFeaturesRegister (const SupportedFeaturesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SupportedFeaturesRegister();

    /**
     * Assignment operator
     */
    inline SupportedFeaturesRegister& operator = (const SupportedFeaturesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedFeaturesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedFeaturesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedFeaturesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedFeaturesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SupportedFeaturesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the friendly name of the Audio Gateway.
 *         The name would have been set in Audio Gateway by the user.
 *
 *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
 */
class FriendlyNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FriendlyNameUpdate ();

    /**
     * Copy constructor
     */
    inline  FriendlyNameUpdate (const FriendlyNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FriendlyNameUpdate (const ::std::string& FriendlyName_);

    /**
     * Destructor
     */
    inline virtual  ~FriendlyNameUpdate();

    /**
     * Assignment operator
     */
    inline FriendlyNameUpdate& operator = (const FriendlyNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FriendlyNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FriendlyNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FriendlyNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FriendlyNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FriendlyName"

    static const int kFriendlyName = 0;

    /**
     * Clears the field "FriendlyName".
     *
     * The field will be set to its default value. The hasFriendlyName()
     * method will return false.
     */
    inline void clearFriendlyName();

    /**
     * Checks whether the field "FriendlyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFriendlyName()). Otherwise it will return false.
     */
    inline bool hasFriendlyName () const;

    /**
     * Returns the value of the member "FriendlyName".
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @return The value of the field "FriendlyName"
     */
    inline const ::std::string& getFriendlyName () const;

    /**
     * Retrieves the value of the field "FriendlyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FriendlyName".
     */
    inline ::std::string& getFriendlyNameMutable ();

    /**
     * Sets the value of the member "FriendlyName".
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param FriendlyName The value which will be set
     */
    inline void setFriendlyName (const ::std::string& FriendlyName_);

    /**
     * Sets the value of the member "FriendlyName".
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param FriendlyName The value which will be set
     */
    inline void setFriendlyName (const char* FriendlyName_);

    /**
     * Sets the value of the member "FriendlyName".
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param FriendlyName The value which will be set
     */
    inline void setFriendlyName (const char* value, size_t size);

    static const FriendlyNameUpdate &getDefaultInstance();

private:

    inline void set_has_FriendlyName ();

    inline void clear_has_FriendlyName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FriendlyName;

};

/**
 * Provides the friendly name of the Audio Gateway.
 *         The name would have been set in Audio Gateway by the user.
 *
 *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
 */
class FriendlyNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FriendlyNameRegister ();

    /**
     * Copy constructor
     */
    inline  FriendlyNameRegister (const FriendlyNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FriendlyNameRegister();

    /**
     * Assignment operator
     */
    inline FriendlyNameRegister& operator = (const FriendlyNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FriendlyNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FriendlyNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FriendlyNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FriendlyNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FriendlyNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current network registration status of Audio Gateway.
 *
 *         The possible values are:
 *             0x00 : Unknown - Status is unknown
 *             0x01 : Unregistered - Not registered to any network
 *             0x02 : Registered - Registered to home network
 *             0x03 : Searching - Not registered, but searching
 *             0x04 : Denied - Registration has been denied
 *             0x05 : Roaming - Registered, but roaming
 *             0xFF : Default
 */
class NetworkStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  NetworkStatusUpdate (const NetworkStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkStatusUpdate (uint8 NetworkStatus_);

    /**
     * Destructor
     */
    inline virtual  ~NetworkStatusUpdate();

    /**
     * Assignment operator
     */
    inline NetworkStatusUpdate& operator = (const NetworkStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NetworkStatus"

    static const int kNetworkStatus = 0;

    /**
     * Clears the field "NetworkStatus".
     *
     * The field will be set to its default value. The hasNetworkStatus()
     * method will return false.
     */
    inline void clearNetworkStatus();

    /**
     * Checks whether the field "NetworkStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNetworkStatus()). Otherwise it will return false.
     */
    inline bool hasNetworkStatus () const;

    /**
     * Returns the value of the member "NetworkStatus".
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @return The value of the field "NetworkStatus"
     */
    inline uint8 getNetworkStatus () const;

    /**
     * Sets the value of the member "NetworkStatus".
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @param NetworkStatus The value which will be set
     */
    inline void setNetworkStatus (uint8 NetworkStatus_);

    static const NetworkStatusUpdate &getDefaultInstance();

private:

    inline void set_has_NetworkStatus ();

    inline void clear_has_NetworkStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _NetworkStatus;

};

/**
 * Provides the current network registration status of Audio Gateway.
 *
 *         The possible values are:
 *             0x00 : Unknown - Status is unknown
 *             0x01 : Unregistered - Not registered to any network
 *             0x02 : Registered - Registered to home network
 *             0x03 : Searching - Not registered, but searching
 *             0x04 : Denied - Registration has been denied
 *             0x05 : Roaming - Registered, but roaming
 *             0xFF : Default
 */
class NetworkStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkStatusRegister ();

    /**
     * Copy constructor
     */
    inline  NetworkStatusRegister (const NetworkStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NetworkStatusRegister();

    /**
     * Assignment operator
     */
    inline NetworkStatusRegister& operator = (const NetworkStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NetworkStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current signal strength of Audio Gateway.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
class SignalStrengthUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SignalStrengthUpdate ();

    /**
     * Copy constructor
     */
    inline  SignalStrengthUpdate (const SignalStrengthUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SignalStrengthUpdate (uint8 SignalStrength_);

    /**
     * Destructor
     */
    inline virtual  ~SignalStrengthUpdate();

    /**
     * Assignment operator
     */
    inline SignalStrengthUpdate& operator = (const SignalStrengthUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignalStrengthUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignalStrengthUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignalStrengthUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignalStrengthUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SignalStrength"

    static const int kSignalStrength = 0;

    /**
     * Clears the field "SignalStrength".
     *
     * The field will be set to its default value. The hasSignalStrength()
     * method will return false.
     */
    inline void clearSignalStrength();

    /**
     * Checks whether the field "SignalStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignalStrength()). Otherwise it will return false.
     */
    inline bool hasSignalStrength () const;

    /**
     * Returns the value of the member "SignalStrength".
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @return The value of the field "SignalStrength"
     */
    inline uint8 getSignalStrength () const;

    /**
     * Sets the value of the member "SignalStrength".
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param SignalStrength The value which will be set
     */
    inline void setSignalStrength (uint8 SignalStrength_);

    static const SignalStrengthUpdate &getDefaultInstance();

private:

    inline void set_has_SignalStrength ();

    inline void clear_has_SignalStrength ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SignalStrength;

};

/**
 * Provides the current signal strength of Audio Gateway.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
class SignalStrengthRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SignalStrengthRegister ();

    /**
     * Copy constructor
     */
    inline  SignalStrengthRegister (const SignalStrengthRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SignalStrengthRegister();

    /**
     * Assignment operator
     */
    inline SignalStrengthRegister& operator = (const SignalStrengthRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignalStrengthRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignalStrengthRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignalStrengthRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignalStrengthRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SignalStrengthRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current charge level of the battery.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
class BatteryChargeLevelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BatteryChargeLevelUpdate ();

    /**
     * Copy constructor
     */
    inline  BatteryChargeLevelUpdate (const BatteryChargeLevelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BatteryChargeLevelUpdate (uint8 BatteryChargeLevel_);

    /**
     * Destructor
     */
    inline virtual  ~BatteryChargeLevelUpdate();

    /**
     * Assignment operator
     */
    inline BatteryChargeLevelUpdate& operator = (const BatteryChargeLevelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BatteryChargeLevelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BatteryChargeLevelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BatteryChargeLevelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BatteryChargeLevelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BatteryChargeLevel"

    static const int kBatteryChargeLevel = 0;

    /**
     * Clears the field "BatteryChargeLevel".
     *
     * The field will be set to its default value. The hasBatteryChargeLevel()
     * method will return false.
     */
    inline void clearBatteryChargeLevel();

    /**
     * Checks whether the field "BatteryChargeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBatteryChargeLevel()). Otherwise it will return false.
     */
    inline bool hasBatteryChargeLevel () const;

    /**
     * Returns the value of the member "BatteryChargeLevel".
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @return The value of the field "BatteryChargeLevel"
     */
    inline uint8 getBatteryChargeLevel () const;

    /**
     * Sets the value of the member "BatteryChargeLevel".
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param BatteryChargeLevel The value which will be set
     */
    inline void setBatteryChargeLevel (uint8 BatteryChargeLevel_);

    static const BatteryChargeLevelUpdate &getDefaultInstance();

private:

    inline void set_has_BatteryChargeLevel ();

    inline void clear_has_BatteryChargeLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BatteryChargeLevel;

};

/**
 * Provides the current charge level of the battery.
 *
 *         The possible values are:
 *         0x00 - 0x05 - Normal Range
 *         0xFF - Default
 */
class BatteryChargeLevelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BatteryChargeLevelRegister ();

    /**
     * Copy constructor
     */
    inline  BatteryChargeLevelRegister (const BatteryChargeLevelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BatteryChargeLevelRegister();

    /**
     * Assignment operator
     */
    inline BatteryChargeLevelRegister& operator = (const BatteryChargeLevelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BatteryChargeLevelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BatteryChargeLevelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BatteryChargeLevelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BatteryChargeLevelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BatteryChargeLevelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current network operator name of Audio Gateway.
 *
 *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
 */
class NetworkOperatorUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkOperatorUpdate ();

    /**
     * Copy constructor
     */
    inline  NetworkOperatorUpdate (const NetworkOperatorUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkOperatorUpdate (const ::std::string& NetworkOperator_);

    /**
     * Destructor
     */
    inline virtual  ~NetworkOperatorUpdate();

    /**
     * Assignment operator
     */
    inline NetworkOperatorUpdate& operator = (const NetworkOperatorUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkOperatorUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkOperatorUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkOperatorUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkOperatorUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NetworkOperator"

    static const int kNetworkOperator = 0;

    /**
     * Clears the field "NetworkOperator".
     *
     * The field will be set to its default value. The hasNetworkOperator()
     * method will return false.
     */
    inline void clearNetworkOperator();

    /**
     * Checks whether the field "NetworkOperator" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNetworkOperator()). Otherwise it will return false.
     */
    inline bool hasNetworkOperator () const;

    /**
     * Returns the value of the member "NetworkOperator".
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @return The value of the field "NetworkOperator"
     */
    inline const ::std::string& getNetworkOperator () const;

    /**
     * Retrieves the value of the field "NetworkOperator" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NetworkOperator".
     */
    inline ::std::string& getNetworkOperatorMutable ();

    /**
     * Sets the value of the member "NetworkOperator".
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param NetworkOperator The value which will be set
     */
    inline void setNetworkOperator (const ::std::string& NetworkOperator_);

    /**
     * Sets the value of the member "NetworkOperator".
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param NetworkOperator The value which will be set
     */
    inline void setNetworkOperator (const char* NetworkOperator_);

    /**
     * Sets the value of the member "NetworkOperator".
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param NetworkOperator The value which will be set
     */
    inline void setNetworkOperator (const char* value, size_t size);

    static const NetworkOperatorUpdate &getDefaultInstance();

private:

    inline void set_has_NetworkOperator ();

    inline void clear_has_NetworkOperator ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _NetworkOperator;

};

/**
 * Provides the current network operator name of Audio Gateway.
 *
 *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
 */
class NetworkOperatorRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkOperatorRegister ();

    /**
     * Copy constructor
     */
    inline  NetworkOperatorRegister (const NetworkOperatorRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NetworkOperatorRegister();

    /**
     * Assignment operator
     */
    inline NetworkOperatorRegister& operator = (const NetworkOperatorRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkOperatorRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkOperatorRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkOperatorRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkOperatorRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NetworkOperatorRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _DeviceInfoProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceInfoProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& DeviceInfoProperties_)  :
    _DeviceInfoProperties (DeviceInfoProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceInfoProperties()) {
            setDeviceInfoProperties(rhs.getDeviceInfoProperties());
        } else {
            clearDeviceInfoProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasDeviceInfoProperties() && !rhs.hasDeviceInfoProperties()) || getDeviceInfoProperties() == rhs.getDeviceInfoProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasDeviceInfoProperties() || rhs.hasDeviceInfoProperties()) {
        if (getDeviceInfoProperties() < rhs.getDeviceInfoProperties()) return true;
        if (getDeviceInfoProperties() > rhs.getDeviceInfoProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearDeviceInfoProperties();
}

inline void GetPropertiesResponse::clearDeviceInfoProperties() {
    if (hasDeviceInfoProperties()) {
         clear_has_DeviceInfoProperties();
        _DeviceInfoProperties.clear();
     }
}

inline bool GetPropertiesResponse::hasDeviceInfoProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& GetPropertiesResponse::getDeviceInfoProperties () const {
    return _DeviceInfoProperties;
}

inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& GetPropertiesResponse::getDeviceInfoPropertiesMutable () {
    set_has_DeviceInfoProperties();
    return _DeviceInfoProperties;
}

inline void GetPropertiesResponse::setDeviceInfoProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::DeviceInfoVariant >& DeviceInfoProperties_) {
    set_has_DeviceInfoProperties();
    this->_DeviceInfoProperties = DeviceInfoProperties_;
}

inline void GetPropertiesResponse::set_has_DeviceInfoProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_DeviceInfoProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceMailListResponse::VoiceMailListResponse ()  :
    _VoiceMailList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceMailListResponse::VoiceMailListResponse (const VoiceMailListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _VoiceMailList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceMailListResponse::VoiceMailListResponse (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailList_)  :
    _VoiceMailList (VoiceMailList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceMailListResponse::~VoiceMailListResponse() {
}

inline VoiceMailListResponse& VoiceMailListResponse::operator = (const VoiceMailListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceMailList()) {
            setVoiceMailList(rhs.getVoiceMailList());
        } else {
            clearVoiceMailList();
        }
    }
    return *this;
}

inline bool VoiceMailListResponse::operator == (const VoiceMailListResponse& rhs) const {
    return (((!hasVoiceMailList() && !rhs.hasVoiceMailList()) || getVoiceMailList() == rhs.getVoiceMailList()));
}

inline bool VoiceMailListResponse::operator != (const VoiceMailListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceMailListResponse::operator < (const VoiceMailListResponse& rhs) const {
    if (hasVoiceMailList() || rhs.hasVoiceMailList()) {
        if (getVoiceMailList() < rhs.getVoiceMailList()) return true;
        if (getVoiceMailList() > rhs.getVoiceMailList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceMailListResponse::clone() {
    return new VoiceMailListResponse(*this);
}

inline bool VoiceMailListResponse::operator > (const VoiceMailListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceMailListResponse::clear() {
    clearVoiceMailList();
}

inline void VoiceMailListResponse::clearVoiceMailList() {
    if (hasVoiceMailList()) {
         clear_has_VoiceMailList();
        _VoiceMailList.clear();
     }
}

inline bool VoiceMailListResponse::hasVoiceMailList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailListResponse::getVoiceMailList () const {
    return _VoiceMailList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailListResponse::getVoiceMailListMutable () {
    set_has_VoiceMailList();
    return _VoiceMailList;
}

inline void VoiceMailListResponse::setVoiceMailList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::VoiceMail >& VoiceMailList_) {
    set_has_VoiceMailList();
    this->_VoiceMailList = VoiceMailList_;
}

inline void VoiceMailListResponse::set_has_VoiceMailList () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceMailListResponse::clear_has_VoiceMailList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupportedFeaturesUpdate::SupportedFeaturesUpdate ()  :
    _SupportedFeatures ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedFeaturesUpdate::SupportedFeaturesUpdate (const SupportedFeaturesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SupportedFeatures ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedFeaturesUpdate::SupportedFeaturesUpdate (const ::std::vector< ::std::string >& SupportedFeatures_)  :
    _SupportedFeatures (SupportedFeatures_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SupportedFeaturesUpdate::~SupportedFeaturesUpdate() {
}

inline SupportedFeaturesUpdate& SupportedFeaturesUpdate::operator = (const SupportedFeaturesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSupportedFeatures()) {
            setSupportedFeatures(rhs.getSupportedFeatures());
        } else {
            clearSupportedFeatures();
        }
    }
    return *this;
}

inline bool SupportedFeaturesUpdate::operator == (const SupportedFeaturesUpdate& rhs) const {
    return (((!hasSupportedFeatures() && !rhs.hasSupportedFeatures()) || getSupportedFeatures() == rhs.getSupportedFeatures()));
}

inline bool SupportedFeaturesUpdate::operator != (const SupportedFeaturesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedFeaturesUpdate::operator < (const SupportedFeaturesUpdate& rhs) const {
    if (hasSupportedFeatures() || rhs.hasSupportedFeatures()) {
        if (getSupportedFeatures() < rhs.getSupportedFeatures()) return true;
        if (getSupportedFeatures() > rhs.getSupportedFeatures()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SupportedFeaturesUpdate::clone() {
    return new SupportedFeaturesUpdate(*this);
}

inline bool SupportedFeaturesUpdate::operator > (const SupportedFeaturesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedFeaturesUpdate::clear() {
    clearSupportedFeatures();
}

inline void SupportedFeaturesUpdate::clearSupportedFeatures() {
    if (hasSupportedFeatures()) {
         clear_has_SupportedFeatures();
        _SupportedFeatures.clear();
     }
}

inline bool SupportedFeaturesUpdate::hasSupportedFeatures () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& SupportedFeaturesUpdate::getSupportedFeatures () const {
    return _SupportedFeatures;
}

inline ::std::vector< ::std::string >& SupportedFeaturesUpdate::getSupportedFeaturesMutable () {
    set_has_SupportedFeatures();
    return _SupportedFeatures;
}

inline void SupportedFeaturesUpdate::setSupportedFeatures (const ::std::vector< ::std::string >& SupportedFeatures_) {
    set_has_SupportedFeatures();
    this->_SupportedFeatures = SupportedFeatures_;
}

inline void SupportedFeaturesUpdate::set_has_SupportedFeatures () {
    _has_bits_[0] |= 1u << 0;
}

inline void SupportedFeaturesUpdate::clear_has_SupportedFeatures () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupportedFeaturesRegister::SupportedFeaturesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedFeaturesRegister::SupportedFeaturesRegister (const SupportedFeaturesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedFeaturesRegister::~SupportedFeaturesRegister() {
}

inline SupportedFeaturesRegister& SupportedFeaturesRegister::operator = (const SupportedFeaturesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SupportedFeaturesRegister::operator == (const SupportedFeaturesRegister& ) const {
    return true;
}

inline bool SupportedFeaturesRegister::operator != (const SupportedFeaturesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedFeaturesRegister::operator < (const SupportedFeaturesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SupportedFeaturesRegister::clone() {
    return new SupportedFeaturesRegister(*this);
}

inline bool SupportedFeaturesRegister::operator > (const SupportedFeaturesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedFeaturesRegister::clear() {
}

inline  FriendlyNameUpdate::FriendlyNameUpdate ()  :
    _FriendlyName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FriendlyNameUpdate::FriendlyNameUpdate (const FriendlyNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FriendlyName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FriendlyNameUpdate::FriendlyNameUpdate (const ::std::string& FriendlyName_)  :
    _FriendlyName (FriendlyName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FriendlyName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FriendlyNameUpdate::~FriendlyNameUpdate() {
}

inline FriendlyNameUpdate& FriendlyNameUpdate::operator = (const FriendlyNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFriendlyName()) {
            setFriendlyName(rhs.getFriendlyName());
        } else {
            clearFriendlyName();
        }
    }
    return *this;
}

inline bool FriendlyNameUpdate::operator == (const FriendlyNameUpdate& rhs) const {
    return (((!hasFriendlyName() && !rhs.hasFriendlyName()) || getFriendlyName() == rhs.getFriendlyName()));
}

inline bool FriendlyNameUpdate::operator != (const FriendlyNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FriendlyNameUpdate::operator < (const FriendlyNameUpdate& rhs) const {
    if (hasFriendlyName() || rhs.hasFriendlyName()) {
        if (getFriendlyName() < rhs.getFriendlyName()) return true;
        if (getFriendlyName() > rhs.getFriendlyName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FriendlyNameUpdate::clone() {
    return new FriendlyNameUpdate(*this);
}

inline bool FriendlyNameUpdate::operator > (const FriendlyNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FriendlyNameUpdate::clear() {
    clearFriendlyName();
}

inline void FriendlyNameUpdate::clearFriendlyName() {
    if (hasFriendlyName()) {
         clear_has_FriendlyName();
        _FriendlyName.clear();
     }
}

inline bool FriendlyNameUpdate::hasFriendlyName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FriendlyNameUpdate::getFriendlyName () const {
    return _FriendlyName;
}

inline ::std::string& FriendlyNameUpdate::getFriendlyNameMutable () {
    set_has_FriendlyName();
    return _FriendlyName;
}

inline void FriendlyNameUpdate::setFriendlyName (const ::std::string& FriendlyName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FriendlyName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FriendlyName();
    this->_FriendlyName = FriendlyName_;
}

inline void FriendlyNameUpdate::setFriendlyName (const char* FriendlyName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FriendlyName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FriendlyName();
    this->_FriendlyName.assign(FriendlyName_);
}

inline void FriendlyNameUpdate::setFriendlyName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FriendlyName();
    this->_FriendlyName.assign(value, size);
}

inline void FriendlyNameUpdate::set_has_FriendlyName () {
    _has_bits_[0] |= 1u << 0;
}

inline void FriendlyNameUpdate::clear_has_FriendlyName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FriendlyNameRegister::FriendlyNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FriendlyNameRegister::FriendlyNameRegister (const FriendlyNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FriendlyNameRegister::~FriendlyNameRegister() {
}

inline FriendlyNameRegister& FriendlyNameRegister::operator = (const FriendlyNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FriendlyNameRegister::operator == (const FriendlyNameRegister& ) const {
    return true;
}

inline bool FriendlyNameRegister::operator != (const FriendlyNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FriendlyNameRegister::operator < (const FriendlyNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FriendlyNameRegister::clone() {
    return new FriendlyNameRegister(*this);
}

inline bool FriendlyNameRegister::operator > (const FriendlyNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FriendlyNameRegister::clear() {
}

inline  NetworkStatusUpdate::NetworkStatusUpdate ()  :
    _NetworkStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NetworkStatusUpdate::NetworkStatusUpdate (const NetworkStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _NetworkStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NetworkStatusUpdate::NetworkStatusUpdate (uint8 NetworkStatus_)  :
    _NetworkStatus (NetworkStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NetworkStatusUpdate::~NetworkStatusUpdate() {
}

inline NetworkStatusUpdate& NetworkStatusUpdate::operator = (const NetworkStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNetworkStatus()) {
            setNetworkStatus(rhs.getNetworkStatus());
        } else {
            clearNetworkStatus();
        }
    }
    return *this;
}

inline bool NetworkStatusUpdate::operator == (const NetworkStatusUpdate& rhs) const {
    return (((!hasNetworkStatus() && !rhs.hasNetworkStatus()) || getNetworkStatus() == rhs.getNetworkStatus()));
}

inline bool NetworkStatusUpdate::operator != (const NetworkStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NetworkStatusUpdate::operator < (const NetworkStatusUpdate& rhs) const {
    if (hasNetworkStatus() || rhs.hasNetworkStatus()) {
        if (getNetworkStatus() < rhs.getNetworkStatus()) return true;
        if (getNetworkStatus() > rhs.getNetworkStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NetworkStatusUpdate::clone() {
    return new NetworkStatusUpdate(*this);
}

inline bool NetworkStatusUpdate::operator > (const NetworkStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NetworkStatusUpdate::clear() {
    clearNetworkStatus();
}

inline void NetworkStatusUpdate::clearNetworkStatus() {
    if (hasNetworkStatus()) {
         clear_has_NetworkStatus();
        _NetworkStatus = 0u;
     }
}

inline bool NetworkStatusUpdate::hasNetworkStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 NetworkStatusUpdate::getNetworkStatus () const {
    return _NetworkStatus;
}

inline void NetworkStatusUpdate::setNetworkStatus (uint8 NetworkStatus_) {
    set_has_NetworkStatus();
    this->_NetworkStatus = NetworkStatus_;
}

inline void NetworkStatusUpdate::set_has_NetworkStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void NetworkStatusUpdate::clear_has_NetworkStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NetworkStatusRegister::NetworkStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NetworkStatusRegister::NetworkStatusRegister (const NetworkStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NetworkStatusRegister::~NetworkStatusRegister() {
}

inline NetworkStatusRegister& NetworkStatusRegister::operator = (const NetworkStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NetworkStatusRegister::operator == (const NetworkStatusRegister& ) const {
    return true;
}

inline bool NetworkStatusRegister::operator != (const NetworkStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NetworkStatusRegister::operator < (const NetworkStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NetworkStatusRegister::clone() {
    return new NetworkStatusRegister(*this);
}

inline bool NetworkStatusRegister::operator > (const NetworkStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NetworkStatusRegister::clear() {
}

inline  SignalStrengthUpdate::SignalStrengthUpdate ()  :
    _SignalStrength (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SignalStrengthUpdate::SignalStrengthUpdate (const SignalStrengthUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SignalStrength (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SignalStrengthUpdate::SignalStrengthUpdate (uint8 SignalStrength_)  :
    _SignalStrength (SignalStrength_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SignalStrengthUpdate::~SignalStrengthUpdate() {
}

inline SignalStrengthUpdate& SignalStrengthUpdate::operator = (const SignalStrengthUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSignalStrength()) {
            setSignalStrength(rhs.getSignalStrength());
        } else {
            clearSignalStrength();
        }
    }
    return *this;
}

inline bool SignalStrengthUpdate::operator == (const SignalStrengthUpdate& rhs) const {
    return (((!hasSignalStrength() && !rhs.hasSignalStrength()) || getSignalStrength() == rhs.getSignalStrength()));
}

inline bool SignalStrengthUpdate::operator != (const SignalStrengthUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SignalStrengthUpdate::operator < (const SignalStrengthUpdate& rhs) const {
    if (hasSignalStrength() || rhs.hasSignalStrength()) {
        if (getSignalStrength() < rhs.getSignalStrength()) return true;
        if (getSignalStrength() > rhs.getSignalStrength()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SignalStrengthUpdate::clone() {
    return new SignalStrengthUpdate(*this);
}

inline bool SignalStrengthUpdate::operator > (const SignalStrengthUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SignalStrengthUpdate::clear() {
    clearSignalStrength();
}

inline void SignalStrengthUpdate::clearSignalStrength() {
    if (hasSignalStrength()) {
         clear_has_SignalStrength();
        _SignalStrength = 0u;
     }
}

inline bool SignalStrengthUpdate::hasSignalStrength () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SignalStrengthUpdate::getSignalStrength () const {
    return _SignalStrength;
}

inline void SignalStrengthUpdate::setSignalStrength (uint8 SignalStrength_) {
    set_has_SignalStrength();
    this->_SignalStrength = SignalStrength_;
}

inline void SignalStrengthUpdate::set_has_SignalStrength () {
    _has_bits_[0] |= 1u << 0;
}

inline void SignalStrengthUpdate::clear_has_SignalStrength () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SignalStrengthRegister::SignalStrengthRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SignalStrengthRegister::SignalStrengthRegister (const SignalStrengthRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SignalStrengthRegister::~SignalStrengthRegister() {
}

inline SignalStrengthRegister& SignalStrengthRegister::operator = (const SignalStrengthRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SignalStrengthRegister::operator == (const SignalStrengthRegister& ) const {
    return true;
}

inline bool SignalStrengthRegister::operator != (const SignalStrengthRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SignalStrengthRegister::operator < (const SignalStrengthRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SignalStrengthRegister::clone() {
    return new SignalStrengthRegister(*this);
}

inline bool SignalStrengthRegister::operator > (const SignalStrengthRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SignalStrengthRegister::clear() {
}

inline  BatteryChargeLevelUpdate::BatteryChargeLevelUpdate ()  :
    _BatteryChargeLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BatteryChargeLevelUpdate::BatteryChargeLevelUpdate (const BatteryChargeLevelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _BatteryChargeLevel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BatteryChargeLevelUpdate::BatteryChargeLevelUpdate (uint8 BatteryChargeLevel_)  :
    _BatteryChargeLevel (BatteryChargeLevel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BatteryChargeLevelUpdate::~BatteryChargeLevelUpdate() {
}

inline BatteryChargeLevelUpdate& BatteryChargeLevelUpdate::operator = (const BatteryChargeLevelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBatteryChargeLevel()) {
            setBatteryChargeLevel(rhs.getBatteryChargeLevel());
        } else {
            clearBatteryChargeLevel();
        }
    }
    return *this;
}

inline bool BatteryChargeLevelUpdate::operator == (const BatteryChargeLevelUpdate& rhs) const {
    return (((!hasBatteryChargeLevel() && !rhs.hasBatteryChargeLevel()) || getBatteryChargeLevel() == rhs.getBatteryChargeLevel()));
}

inline bool BatteryChargeLevelUpdate::operator != (const BatteryChargeLevelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool BatteryChargeLevelUpdate::operator < (const BatteryChargeLevelUpdate& rhs) const {
    if (hasBatteryChargeLevel() || rhs.hasBatteryChargeLevel()) {
        if (getBatteryChargeLevel() < rhs.getBatteryChargeLevel()) return true;
        if (getBatteryChargeLevel() > rhs.getBatteryChargeLevel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BatteryChargeLevelUpdate::clone() {
    return new BatteryChargeLevelUpdate(*this);
}

inline bool BatteryChargeLevelUpdate::operator > (const BatteryChargeLevelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BatteryChargeLevelUpdate::clear() {
    clearBatteryChargeLevel();
}

inline void BatteryChargeLevelUpdate::clearBatteryChargeLevel() {
    if (hasBatteryChargeLevel()) {
         clear_has_BatteryChargeLevel();
        _BatteryChargeLevel = 0u;
     }
}

inline bool BatteryChargeLevelUpdate::hasBatteryChargeLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BatteryChargeLevelUpdate::getBatteryChargeLevel () const {
    return _BatteryChargeLevel;
}

inline void BatteryChargeLevelUpdate::setBatteryChargeLevel (uint8 BatteryChargeLevel_) {
    set_has_BatteryChargeLevel();
    this->_BatteryChargeLevel = BatteryChargeLevel_;
}

inline void BatteryChargeLevelUpdate::set_has_BatteryChargeLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void BatteryChargeLevelUpdate::clear_has_BatteryChargeLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BatteryChargeLevelRegister::BatteryChargeLevelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BatteryChargeLevelRegister::BatteryChargeLevelRegister (const BatteryChargeLevelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BatteryChargeLevelRegister::~BatteryChargeLevelRegister() {
}

inline BatteryChargeLevelRegister& BatteryChargeLevelRegister::operator = (const BatteryChargeLevelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool BatteryChargeLevelRegister::operator == (const BatteryChargeLevelRegister& ) const {
    return true;
}

inline bool BatteryChargeLevelRegister::operator != (const BatteryChargeLevelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool BatteryChargeLevelRegister::operator < (const BatteryChargeLevelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* BatteryChargeLevelRegister::clone() {
    return new BatteryChargeLevelRegister(*this);
}

inline bool BatteryChargeLevelRegister::operator > (const BatteryChargeLevelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BatteryChargeLevelRegister::clear() {
}

inline  NetworkOperatorUpdate::NetworkOperatorUpdate ()  :
    _NetworkOperator ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NetworkOperatorUpdate::NetworkOperatorUpdate (const NetworkOperatorUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _NetworkOperator ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NetworkOperatorUpdate::NetworkOperatorUpdate (const ::std::string& NetworkOperator_)  :
    _NetworkOperator (NetworkOperator_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NetworkOperator_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NetworkOperatorUpdate::~NetworkOperatorUpdate() {
}

inline NetworkOperatorUpdate& NetworkOperatorUpdate::operator = (const NetworkOperatorUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNetworkOperator()) {
            setNetworkOperator(rhs.getNetworkOperator());
        } else {
            clearNetworkOperator();
        }
    }
    return *this;
}

inline bool NetworkOperatorUpdate::operator == (const NetworkOperatorUpdate& rhs) const {
    return (((!hasNetworkOperator() && !rhs.hasNetworkOperator()) || getNetworkOperator() == rhs.getNetworkOperator()));
}

inline bool NetworkOperatorUpdate::operator != (const NetworkOperatorUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NetworkOperatorUpdate::operator < (const NetworkOperatorUpdate& rhs) const {
    if (hasNetworkOperator() || rhs.hasNetworkOperator()) {
        if (getNetworkOperator() < rhs.getNetworkOperator()) return true;
        if (getNetworkOperator() > rhs.getNetworkOperator()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NetworkOperatorUpdate::clone() {
    return new NetworkOperatorUpdate(*this);
}

inline bool NetworkOperatorUpdate::operator > (const NetworkOperatorUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NetworkOperatorUpdate::clear() {
    clearNetworkOperator();
}

inline void NetworkOperatorUpdate::clearNetworkOperator() {
    if (hasNetworkOperator()) {
         clear_has_NetworkOperator();
        _NetworkOperator.clear();
     }
}

inline bool NetworkOperatorUpdate::hasNetworkOperator () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NetworkOperatorUpdate::getNetworkOperator () const {
    return _NetworkOperator;
}

inline ::std::string& NetworkOperatorUpdate::getNetworkOperatorMutable () {
    set_has_NetworkOperator();
    return _NetworkOperator;
}

inline void NetworkOperatorUpdate::setNetworkOperator (const ::std::string& NetworkOperator_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NetworkOperator_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NetworkOperator();
    this->_NetworkOperator = NetworkOperator_;
}

inline void NetworkOperatorUpdate::setNetworkOperator (const char* NetworkOperator_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NetworkOperator_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NetworkOperator();
    this->_NetworkOperator.assign(NetworkOperator_);
}

inline void NetworkOperatorUpdate::setNetworkOperator (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NetworkOperator();
    this->_NetworkOperator.assign(value, size);
}

inline void NetworkOperatorUpdate::set_has_NetworkOperator () {
    _has_bits_[0] |= 1u << 0;
}

inline void NetworkOperatorUpdate::clear_has_NetworkOperator () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NetworkOperatorRegister::NetworkOperatorRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NetworkOperatorRegister::NetworkOperatorRegister (const NetworkOperatorRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NetworkOperatorRegister::~NetworkOperatorRegister() {
}

inline NetworkOperatorRegister& NetworkOperatorRegister::operator = (const NetworkOperatorRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NetworkOperatorRegister::operator == (const NetworkOperatorRegister& ) const {
    return true;
}

inline bool NetworkOperatorRegister::operator != (const NetworkOperatorRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NetworkOperatorRegister::operator < (const NetworkOperatorRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NetworkOperatorRegister::clone() {
    return new NetworkOperatorRegister(*this);
}

inline bool NetworkOperatorRegister::operator > (const NetworkOperatorRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NetworkOperatorRegister::clear() {
}

} // namespace DeviceInfo
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_DEVICEINFO_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
