/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/PmApp.h"
#include "com/bosch/PmComponent.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "PmApp" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {

DEFINE_LOGGER_AND_LEVEL (_logger, "/com/bosch/PmApp", Info);

/* static */ const char* PmApp::pmComponent = "pmComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool PmApp_enabledASFSignalHandler = false;

void importPmApp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach PmApp, because no Application is instantiated");

    // Expression

    cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(10);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'ConnPmAppThread'

    ::asf::core::ComponentContainerSharedPtr ConnPmAppThread(new ::asf::core::ComponentContainer("ConnPmAppThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ConnPmAppThread);

        // Component 'PmComponent pmComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::com::bosch::PmComponent > > pmComponentFactory(new ::asf::core::ComponentFactory< ::com::bosch::PmComponent >);
        ::asf::core::ComponentDescriptionSharedPtr pmComponentDescription(new ::asf::core::ComponentDescription(1, "pmComponent", /* immediate = */ true, /* threadBridge = */ false, pmComponentFactory));
        ConnPmAppThread->addComponentDescription(pmComponentDescription);

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& pmComponent_LifeCycleConsumerPort = pmComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)pmComponent_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'pmSystemSettingsPort'

            ::asf::core::ProvidedPort& pmComponent_pmSystemSettingsPort = pmComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "pmSystemSettingsPort", false, false));
            (void)pmComponent_pmSystemSettingsPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpCallVolumePort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpCallVolumePort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.CallVolume", "pmAppEvoHfpCallVolumePort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpCallVolumePort; // prevent unused variable warning

            // Port 'pmAppEvoHfpHandsfreePort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpHandsfreePort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Handsfree", "pmAppEvoHfpHandsfreePort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpHandsfreePort; // prevent unused variable warning

            // Port 'pmAppEvoHfpManagerPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpManagerPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Manager", "pmAppEvoHfpManagerPort"));
            (void)pmComponent_pmAppEvoHfpManagerPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpModemPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpModemPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Modem", "pmAppEvoHfpModemPort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpModemPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpNetworkOperatorPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpNetworkOperatorPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.NetworkOperator", "pmAppEvoHfpNetworkOperatorPort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpNetworkOperatorPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpNetworkRegistrationPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpNetworkRegistrationPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.NetworkRegistration", "pmAppEvoHfpNetworkRegistrationPort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpNetworkRegistrationPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpSiri'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpSiri = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.evo.Siri", "pmAppEvoHfpSiri", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpSiri; // prevent unused variable warning

            // Port 'pmAppEvoHfpVoiceCallPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpVoiceCallPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.VoiceCall", "pmAppEvoHfpVoiceCallPort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpVoiceCallPort; // prevent unused variable warning

            // Port 'pmAppEvoHfpVoiceCallManagerPort'

            ::asf::core::RequiredPort& pmComponent_pmAppEvoHfpVoiceCallManagerPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.VoiceCallManager", "pmAppEvoHfpVoiceCallManagerPort", /* wired at runtime */ true));
            (void)pmComponent_pmAppEvoHfpVoiceCallManagerPort; // prevent unused variable warning

            // Port 'strFiPort'

            ::asf::core::RequiredPort& pmComponent_strFiPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("midw_streamrouter_fi", "strFiPort"));
            (void)pmComponent_strFiPort; // prevent unused variable warning

            // Port 'geniviAmCmdIfPort'

            ::asf::core::RequiredPort& pmComponent_geniviAmCmdIfPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "geniviAmCmdIfPort"));
            (void)pmComponent_geniviAmCmdIfPort; // prevent unused variable warning

            // Port 'ecnrServicePort'

            ::asf::core::RequiredPort& pmComponent_ecnrServicePort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.ecnr.service", "ecnrServicePort"));
            (void)pmComponent_ecnrServicePort; // prevent unused variable warning

            // Port 'lcmPort'

            ::asf::core::RequiredPort& pmComponent_lcmPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", "lcmPort"));
            (void)pmComponent_lcmPort; // prevent unused variable warning

            // Port 'mostBtSetFiPort'

            ::asf::core::RequiredPort& pmComponent_mostBtSetFiPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "mostBtSetFiPort"));
            (void)pmComponent_mostBtSetFiPort; // prevent unused variable warning

            // Port 'mostPbkFiPort'

            ::asf::core::RequiredPort& pmComponent_mostPbkFiPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_PhonBk_FI", "mostPbkFiPort"));
            (void)pmComponent_mostPbkFiPort; // prevent unused variable warning

            // Port 'mostMediaPlayerPort'

            ::asf::core::RequiredPort& pmComponent_mostMediaPlayerPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_MediaPlayer_FI", "mostMediaPlayerPort"));
            (void)pmComponent_mostMediaPlayerPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& pmComponent_ConsumerPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)pmComponent_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& pmComponent_LifecycleControlPort = pmComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)pmComponent_LifecycleControlPort; // prevent unused variable warning

    // Expression

    ::asf::cca::CcaImportedPort& mostBtSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    mostBtSetFiImport.setServiceName("MOST_BTSet_FI");

    // Expression

    ::asf::cca::CcaImportedPort& phoneBookFiImport = ccaConnector_->importByName (97, 3, 0, 2);
    phoneBookFiImport.setServiceName("MOST_PhonBk_FI");

    // Expression

    ::asf::cca::CcaImportedPort& mediaPlayerFiImport = ccaConnector_->importByName (89, 4, 4, 2);
    mediaPlayerFiImport.setServiceName("mplay_MediaPlayer_FI");

    // Expression

    ::asf::dbus::DBusImportedPort& lcmService = dbusSystemConnector_->importByName (::std::string("org.bosch.cm.lcmccadbusgw.LcmccadbusgwAsf"), ::std::string("/com/bosch/cm/lcmccadbusgw/server/LcmDbusFi"));
    lcmService.setServiceName("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service");

    // Expression

    ::asf::dbus::DBusImportedPort& evoHfManagerService = dbusSystemConnector_->importByName (::std::string("org.ofono"), ::std::string("/"));
    evoHfManagerService.setServiceName("org.ofono.Manager");

    // Expression

    ::asf::cca::CcaImportedPort& strFiImport = ccaConnector_->importByName (82, 1, 0, 2);
    strFiImport.setServiceName("midw_streamrouter_fi");

    // Expression

    ::asf::dbus::DBusImportedPort& ecnrService = dbusSystemConnector_->importByName (::std::string("org.bosch.ecnr.service"), ::std::string("/"));
    ecnrService.setServiceName("org.bosch.ecnr.service");

    // Expression

    ::asf::dbus::DBusImportedPort& geniviAMCmdIf = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    geniviAMCmdIf.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_mostBtSetFiPort, mostBtSetFiImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_mostPbkFiPort, phoneBookFiImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_mostMediaPlayerPort, mediaPlayerFiImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_lcmPort, lcmService);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_strFiPort, strFiImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_ecnrServicePort, ecnrService);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_geniviAmCmdIfPort, geniviAMCmdIf);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_pmAppEvoHfpManagerPort, evoHfManagerService);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (pmComponent_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (pmComponent_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/PmApp"));

    // Expression

    dbusSessionConnector_->exportByName (pmComponent_pmSystemSettingsPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));


    LOG_INFO_STATIC("Starting application 'PmApp' version 1.0.0");

    app->start();
}

int executePmApp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("com.bosch", "PmApp");
    } else {
        ::asf::core::Logger::setupLogging ("com.bosch", "PmApp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", PmApp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("com.bosch", "PmApp", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create PmApp");

    app->enableExceptionHandler(false);

    importPmApp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace bosch
} // namespace com

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::com::bosch::executePmApp(argc, argv);
}

