/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "PluginServer/PluginServer.h"
#include "PluginServer/PluginServerComponent.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "PluginServer" isn't clear, then there should be a description here.
 */

namespace PluginServer {

DEFINE_LOGGER_AND_LEVEL (_logger, "/PluginServer/PluginServer", Info);

/* static */ const char* PluginServer::pluginServerComponent = "pluginServerComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool PluginServer_enabledASFSignalHandler = false;

void importPluginServer() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach PluginServer, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'T_PluginServer'

    ::asf::core::ComponentContainerSharedPtr T_PluginServer(new ::asf::core::ComponentContainer("T_PluginServer", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T_PluginServer);

        // Component 'PluginServerComponent pluginServerComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::PluginServer::PluginServerComponent > > pluginServerComponentFactory(new ::asf::core::ComponentFactory< ::PluginServer::PluginServerComponent >);
        ::asf::core::ComponentDescriptionSharedPtr pluginServerComponentDescription(new ::asf::core::ComponentDescription(1, "pluginServerComponent", /* immediate = */ true, /* threadBridge = */ false, pluginServerComponentFactory));
        T_PluginServer->addComponentDescription(pluginServerComponentDescription);

            // Port 'PluginDbusServerPort'

            ::asf::core::ProvidedPort& pluginServerComponent_PluginDbusServerPort = pluginServerComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusServerPort", false, false));
            (void)pluginServerComponent_PluginDbusServerPort; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (pluginServerComponent_PluginDbusServerPort, ::std::string("/bosch/cm/ai/PluginDbusInterface"));


    LOG_INFO_STATIC("Starting application 'PluginServer' version 1.0.0");

    app->start();
}

int executePluginServer(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("PluginServer", "PluginServer");
    } else {
        ::asf::core::Logger::setupLogging ("PluginServer", "PluginServer", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", PluginServer_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("PluginServer", "PluginServer", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create PluginServer");

    app->enableExceptionHandler(true);

    importPluginServer();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace PluginServer
