/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/PluginDbusInterface.h"
#include "bosch/cm/ai/PluginDbusInterfaceDBus.h"
#include "bosch/cm/ai/PluginDbusInterfaceJson.h"
#include "bosch/cm/ai/PluginDbusInterfaceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace PluginDbusInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/bosch/cm/ai/PluginDbusInterface", PluginDbusInterfaceProxy);

class PluginDbusInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    PluginDbusInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< PluginDbusInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PluginUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PluginUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PluginUpdateSignal> payload = ::boost::static_pointer_cast<PluginUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PluginUpdateCallbackIF*) _callback)->onPluginUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PluginListUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginListUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PluginListUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PluginListUpdateSignal> payload = ::boost::static_pointer_cast<PluginListUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PluginListUpdateCallbackIF*) _callback)->onPluginListUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_DBStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_DBStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_DBStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_DBStatusSignal> payload = ::boost::static_pointer_cast<Sig_DBStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_DBStatusCallbackIF*) _callback)->onSig_DBStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_PlayStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_PlayStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_PlayStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_PlayStatusSignal> payload = ::boost::static_pointer_cast<Sig_PlayStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_PlayStatusCallbackIF*) _callback)->onSig_PlayStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_ReqTrackIndex:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_ReqTrackIndexSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_ReqTrackIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_ReqTrackIndexSignal> payload = ::boost::static_pointer_cast<Sig_ReqTrackIndexSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_ReqTrackIndexCallbackIF*) _callback)->onSig_ReqTrackIndexSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_CRCCheckStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_CRCCheckStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_CRCCheckStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_CRCCheckStatusSignal> payload = ::boost::static_pointer_cast<Sig_CRCCheckStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_CRCCheckStatusCallbackIF*) _callback)->onSig_CRCCheckStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EndStationListUpdate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EndStationListUpdateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EndStationListUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EndStationListUpdateError> payload = ::boost::static_pointer_cast<EndStationListUpdateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EndStationListUpdateCallbackIF*) _callback)->onEndStationListUpdateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EndStationListUpdateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EndStationListUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EndStationListUpdateUpdate> payload = ::boost::static_pointer_cast<EndStationListUpdateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EndStationListUpdateCallbackIF*) _callback)->onEndStationListUpdateUpdate(proxyShared, payload);
                        proxyShared->_endStationListUpdate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_EntityDetailsUpdate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EntityDetailsUpdateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EntityDetailsUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EntityDetailsUpdateError> payload = ::boost::static_pointer_cast<EntityDetailsUpdateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EntityDetailsUpdateCallbackIF*) _callback)->onEntityDetailsUpdateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EntityDetailsUpdateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EntityDetailsUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EntityDetailsUpdateUpdate> payload = ::boost::static_pointer_cast<EntityDetailsUpdateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EntityDetailsUpdateCallbackIF*) _callback)->onEntityDetailsUpdateUpdate(proxyShared, payload);
                        proxyShared->_entityDetailsUpdate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PlayBackMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PlayBackModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PlayBackMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PlayBackModeError> payload = ::boost::static_pointer_cast<PlayBackModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PlayBackModeCallbackIF*) _callback)->onPlayBackModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PlayBackModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PlayBackMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PlayBackModeUpdate> payload = ::boost::static_pointer_cast<PlayBackModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PlayBackModeCallbackIF*) _callback)->onPlayBackModeUpdate(proxyShared, payload);
                        proxyShared->_playBackMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ListAbsoluteTrackIndex:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListAbsoluteTrackIndexError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ListAbsoluteTrackIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListAbsoluteTrackIndexError> payload = ::boost::static_pointer_cast<ListAbsoluteTrackIndexError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ListAbsoluteTrackIndexCallbackIF*) _callback)->onListAbsoluteTrackIndexError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListAbsoluteTrackIndexUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ListAbsoluteTrackIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListAbsoluteTrackIndexUpdate> payload = ::boost::static_pointer_cast<ListAbsoluteTrackIndexUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ListAbsoluteTrackIndexCallbackIF*) _callback)->onListAbsoluteTrackIndexUpdate(proxyShared, payload);
                        proxyShared->_listAbsoluteTrackIndex = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DBState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DBStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DBState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DBStateError> payload = ::boost::static_pointer_cast<DBStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DBStateCallbackIF*) _callback)->onDBStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DBStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DBState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DBStateUpdate> payload = ::boost::static_pointer_cast<DBStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DBStateCallbackIF*) _callback)->onDBStateUpdate(proxyShared, payload);
                        proxyShared->_dBState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PluginCommand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PluginCommandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PluginCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PluginCommandError> payload = ::boost::static_pointer_cast<PluginCommandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PluginCommandCallbackIF*) _callback)->onPluginCommandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginCommandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PluginCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PluginCommandResponse> payload = ::boost::static_pointer_cast<PluginCommandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PluginCommandCallbackIF*) _callback)->onPluginCommandResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PluginListCommand:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PluginListCommandError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PluginListCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PluginListCommandError> payload = ::boost::static_pointer_cast<PluginListCommandError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PluginListCommandCallbackIF*) _callback)->onPluginListCommandError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginListCommandResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PluginListCommand", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PluginListCommandResponse> payload = ::boost::static_pointer_cast<PluginListCommandResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PluginListCommandCallbackIF*) _callback)->onPluginListCommandResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PluginUpdate: {
                ::boost::shared_ptr< PluginUpdateError > payload = ::boost::shared_ptr< PluginUpdateError >
                (new PluginUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PluginUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PluginUpdateCallbackIF*) _callback)->onPluginUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PluginListUpdate: {
                ::boost::shared_ptr< PluginListUpdateError > payload = ::boost::shared_ptr< PluginListUpdateError >
                (new PluginListUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PluginListUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PluginListUpdateCallbackIF*) _callback)->onPluginListUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_DBStatus: {
                ::boost::shared_ptr< Sig_DBStatusError > payload = ::boost::shared_ptr< Sig_DBStatusError >
                (new Sig_DBStatusError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_DBStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_DBStatusCallbackIF*) _callback)->onSig_DBStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_PlayStatus: {
                ::boost::shared_ptr< Sig_PlayStatusError > payload = ::boost::shared_ptr< Sig_PlayStatusError >
                (new Sig_PlayStatusError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_PlayStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_PlayStatusCallbackIF*) _callback)->onSig_PlayStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_ReqTrackIndex: {
                ::boost::shared_ptr< Sig_ReqTrackIndexError > payload = ::boost::shared_ptr< Sig_ReqTrackIndexError >
                (new Sig_ReqTrackIndexError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_ReqTrackIndex", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_ReqTrackIndexCallbackIF*) _callback)->onSig_ReqTrackIndexError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_CRCCheckStatus: {
                ::boost::shared_ptr< Sig_CRCCheckStatusError > payload = ::boost::shared_ptr< Sig_CRCCheckStatusError >
                (new Sig_CRCCheckStatusError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_CRCCheckStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_CRCCheckStatusCallbackIF*) _callback)->onSig_CRCCheckStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EndStationListUpdate: {
                ::boost::shared_ptr< EndStationListUpdateError > payload = ::boost::shared_ptr< EndStationListUpdateError >
                (new EndStationListUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EndStationListUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EndStationListUpdateCallbackIF*) _callback)->onEndStationListUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EntityDetailsUpdate: {
                ::boost::shared_ptr< EntityDetailsUpdateError > payload = ::boost::shared_ptr< EntityDetailsUpdateError >
                (new EntityDetailsUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EntityDetailsUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EntityDetailsUpdateCallbackIF*) _callback)->onEntityDetailsUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PlayBackMode: {
                ::boost::shared_ptr< PlayBackModeError > payload = ::boost::shared_ptr< PlayBackModeError >
                (new PlayBackModeError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PlayBackMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PlayBackModeCallbackIF*) _callback)->onPlayBackModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListAbsoluteTrackIndex: {
                ::boost::shared_ptr< ListAbsoluteTrackIndexError > payload = ::boost::shared_ptr< ListAbsoluteTrackIndexError >
                (new ListAbsoluteTrackIndexError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListAbsoluteTrackIndex", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListAbsoluteTrackIndexCallbackIF*) _callback)->onListAbsoluteTrackIndexError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DBState: {
                ::boost::shared_ptr< DBStateError > payload = ::boost::shared_ptr< DBStateError >
                (new DBStateError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DBState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DBStateCallbackIF*) _callback)->onDBStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PluginCommand: {
                ::boost::shared_ptr< PluginCommandError > payload = ::boost::shared_ptr< PluginCommandError >
                (new PluginCommandError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PluginCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PluginCommandCallbackIF*) _callback)->onPluginCommandError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PluginListCommand: {
                ::boost::shared_ptr< PluginListCommandError > payload = ::boost::shared_ptr< PluginListCommandError >
                (new PluginListCommandError(DBUS_ERROR_NO_SERVER, "The DBus service PluginDbusInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PluginListCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PluginDbusInterfaceProxy> proxyShared = ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PluginListCommandCallbackIF*) _callback)->onPluginListCommandError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& PluginDbusInterfaceProxyCallback::_logger (PluginDbusInterfaceProxy::_logger);

PluginDbusInterfaceProxy::PluginDbusInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.PluginDbusInterface", serviceAvailable, _logger) {
}

PluginDbusInterfaceProxy::~PluginDbusInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< PluginDbusInterfaceProxy > PluginDbusInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<PluginDbusInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< PluginDbusInterfaceProxy > proxyNew(new PluginDbusInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t PluginDbusInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t PluginDbusInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void PluginDbusInterfaceProxy::clearAllProperties ()
{
    _endStationListUpdate = ::asf::core::nullable< EndStationListUpdateUpdate >();
    _entityDetailsUpdate = ::asf::core::nullable< EntityDetailsUpdateUpdate >();
    _playBackMode = ::asf::core::nullable< PlayBackModeUpdate >();
    _listAbsoluteTrackIndex = ::asf::core::nullable< ListAbsoluteTrackIndexUpdate >();
    _dBState = ::asf::core::nullable< DBStateUpdate >();
}

void PluginDbusInterfaceProxy::sendDeregisterAll () const
{
    sendEndStationListUpdateDeregisterAll();
    sendEntityDetailsUpdateDeregisterAll();
    sendPlayBackModeDeregisterAll();
    sendListAbsoluteTrackIndexDeregisterAll();
    sendDBStateDeregisterAll();
    sendPluginUpdateDeregisterAll();
    sendPluginListUpdateDeregisterAll();
    sendSig_DBStatusDeregisterAll();
    sendSig_PlayStatusDeregisterAll();
    sendSig_ReqTrackIndexDeregisterAll();
    sendSig_CRCCheckStatusDeregisterAll();
}

act_t PluginDbusInterfaceProxy::sendPluginUpdateRegister(PluginUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PluginUpdate");
    act_t act = addSignalCallback(ID_PluginUpdate, "PluginUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PluginUpdate", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendPluginUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PluginUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PluginUpdate", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendPluginUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PluginUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("PluginUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendPluginListUpdateRegister(PluginListUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PluginListUpdate");
    act_t act = addSignalCallback(ID_PluginListUpdate, "PluginListUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PluginListUpdate", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendPluginListUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PluginListUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PluginListUpdate", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendPluginListUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PluginListUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("PluginListUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendSig_DBStatusRegister(Sig_DBStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_DBStatus");
    act_t act = addSignalCallback(ID_sig_DBStatus, "sig_DBStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_DBStatus", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendSig_DBStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_DBStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_DBStatus", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendSig_DBStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_DBStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sig_DBStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendSig_PlayStatusRegister(Sig_PlayStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_PlayStatus");
    act_t act = addSignalCallback(ID_sig_PlayStatus, "sig_PlayStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_PlayStatus", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendSig_PlayStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_PlayStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_PlayStatus", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendSig_PlayStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_PlayStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sig_PlayStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendSig_ReqTrackIndexRegister(Sig_ReqTrackIndexCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_ReqTrackIndex");
    act_t act = addSignalCallback(ID_sig_ReqTrackIndex, "sig_ReqTrackIndex", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_ReqTrackIndex", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendSig_ReqTrackIndexDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_ReqTrackIndex", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_ReqTrackIndex", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendSig_ReqTrackIndexDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_ReqTrackIndex");
    _dbusProxyDelegate->deregisterSignalCallback("sig_ReqTrackIndex", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendSig_CRCCheckStatusRegister(Sig_CRCCheckStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_CRCCheckStatus");
    act_t act = addSignalCallback(ID_sig_CRCCheckStatus, "sig_CRCCheckStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_CRCCheckStatus", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendSig_CRCCheckStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_CRCCheckStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_CRCCheckStatus", act, static_cast<int>(rv));
    return rv;
}

void PluginDbusInterfaceProxy::sendSig_CRCCheckStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_CRCCheckStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sig_CRCCheckStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t PluginDbusInterfaceProxy::sendEndStationListUpdateRegister(EndStationListUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_EndStationListUpdate, "EndStationListUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EndStationListUpdate", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendEndStationListUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EndStationListUpdate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EndStationListUpdate", act, static_cast<int>(rv));
    return rv;
}

act_t PluginDbusInterfaceProxy::sendEndStationListUpdateGet(EndStationListUpdateCallbackIF& cb) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_EndStationListUpdate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EndStationListUpdate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("EndStationListUpdate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::asf::dbus::DBusVariant& PluginDbusInterfaceProxy::getEndStationListUpdate() const {
    return _endStationListUpdate.get().getEndStationListUpdate();
}

bool PluginDbusInterfaceProxy::hasEndStationListUpdate() const {
    return _endStationListUpdate.hasValue();
}

void PluginDbusInterfaceProxy::sendEndStationListUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EndStationListUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("EndStationListUpdate", 0, _dbusDaemonProxy.get(), true);
}

act_t PluginDbusInterfaceProxy::sendEntityDetailsUpdateRegister(EntityDetailsUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_EntityDetailsUpdate, "EntityDetailsUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EntityDetailsUpdate", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendEntityDetailsUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EntityDetailsUpdate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EntityDetailsUpdate", act, static_cast<int>(rv));
    return rv;
}

act_t PluginDbusInterfaceProxy::sendEntityDetailsUpdateGet(EntityDetailsUpdateCallbackIF& cb) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_EntityDetailsUpdate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EntityDetailsUpdate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("EntityDetailsUpdate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::asf::dbus::DBusVariant& PluginDbusInterfaceProxy::getEntityDetailsUpdate() const {
    return _entityDetailsUpdate.get().getEntityDetailsUpdate();
}

bool PluginDbusInterfaceProxy::hasEntityDetailsUpdate() const {
    return _entityDetailsUpdate.hasValue();
}

void PluginDbusInterfaceProxy::sendEntityDetailsUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EntityDetailsUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("EntityDetailsUpdate", 0, _dbusDaemonProxy.get(), true);
}

act_t PluginDbusInterfaceProxy::sendPlayBackModeRegister(PlayBackModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PlayBackMode, "PlayBackMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PlayBackMode", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendPlayBackModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PlayBackMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PlayBackMode", act, static_cast<int>(rv));
    return rv;
}

act_t PluginDbusInterfaceProxy::sendPlayBackModeGet(PlayBackModeCallbackIF& cb) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_PlayBackMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PlayBackMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PlayBackMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const PlayBackModeStruct& PluginDbusInterfaceProxy::getPlayBackMode() const {
    return _playBackMode.get().getPlayBackMode();
}

bool PluginDbusInterfaceProxy::hasPlayBackMode() const {
    return _playBackMode.hasValue();
}

void PluginDbusInterfaceProxy::sendPlayBackModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PlayBackMode");
    _dbusProxyDelegate->deregisterSignalCallback("PlayBackMode", 0, _dbusDaemonProxy.get(), true);
}

act_t PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexRegister(ListAbsoluteTrackIndexCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ListAbsoluteTrackIndex, "ListAbsoluteTrackIndex", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ListAbsoluteTrackIndex", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ListAbsoluteTrackIndex", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ListAbsoluteTrackIndex", act, static_cast<int>(rv));
    return rv;
}

act_t PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexGet(ListAbsoluteTrackIndexCallbackIF& cb) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_ListAbsoluteTrackIndex, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ListAbsoluteTrackIndex", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ListAbsoluteTrackIndex", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexSet(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex) {
    ListAbsoluteTrackIndexSet parameter(listAbsoluteTrackIndex);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ListAbsoluteTrackIndex");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ListAbsoluteTrackIndex", propertyContent);
}

act_t PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexSet(ListAbsoluteTrackIndexCallbackIF& cb, const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_ListAbsoluteTrackIndex, &cb);
    ListAbsoluteTrackIndexSet parameter(listAbsoluteTrackIndex);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ListAbsoluteTrackIndex", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ListAbsoluteTrackIndex", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ListAbsoluteTrackIndexStruct& PluginDbusInterfaceProxy::getListAbsoluteTrackIndex() const {
    return _listAbsoluteTrackIndex.get().getListAbsoluteTrackIndex();
}

bool PluginDbusInterfaceProxy::hasListAbsoluteTrackIndex() const {
    return _listAbsoluteTrackIndex.hasValue();
}

void PluginDbusInterfaceProxy::sendListAbsoluteTrackIndexDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ListAbsoluteTrackIndex");
    _dbusProxyDelegate->deregisterSignalCallback("ListAbsoluteTrackIndex", 0, _dbusDaemonProxy.get(), true);
}

act_t PluginDbusInterfaceProxy::sendDBStateRegister(DBStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DBState, "DBState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DBState", &cb, act);
    return act;
}

bool PluginDbusInterfaceProxy::sendDBStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DBState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DBState", act, static_cast<int>(rv));
    return rv;
}

act_t PluginDbusInterfaceProxy::sendDBStateGet(DBStateCallbackIF& cb) {
    PluginDbusInterfaceProxyCallback* callback = new PluginDbusInterfaceProxyCallback(ID_DBState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DBState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DBState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const DBStateStruct& PluginDbusInterfaceProxy::getDBState() const {
    return _dBState.get().getDBState();
}

bool PluginDbusInterfaceProxy::hasDBState() const {
    return _dBState.hasValue();
}

void PluginDbusInterfaceProxy::sendDBStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DBState");
    _dbusProxyDelegate->deregisterSignalCallback("DBState", 0, _dbusDaemonProxy.get(), true);
}

act_t PluginDbusInterfaceProxy::sendPluginCommandRequest(PluginCommandCallbackIF& cb, const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data) const {
    PluginCommandRequest* payload = new PluginCommandRequest();
    CHECK_ALLOCATION(payload);
    payload->setPlugin_name(plugin_name);
    payload->setControlblock_name(controlblock_name);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "PluginCommand", PluginCommandRequest, payload, true)
    act_t act = addMethodCallback(ID_PluginCommand, dbusMessage.getUniqueSerial(), "PluginCommand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PluginCommand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PluginDbusInterfaceProxy::sendPluginListCommandRequest(PluginListCommandCallbackIF& cb, const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data, const ::asf::dbus::DBusVariant& listData) const {
    PluginListCommandRequest* payload = new PluginListCommandRequest();
    CHECK_ALLOCATION(payload);
    payload->setPlugin_name(plugin_name);
    payload->setControlblock_name(controlblock_name);
    payload->setData(data);
    payload->setListData(listData);
    DBUS_MESSAGE_CALL(dbusMessage, "PluginListCommand", PluginListCommandRequest, payload, true)
    act_t act = addMethodCallback(ID_PluginListCommand, dbusMessage.getUniqueSerial(), "PluginListCommand", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PluginListCommand", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace PluginDbusInterface
} // namespace ai
} // namespace cm
} // namespace bosch
