/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvDBus.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvJson.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvStub.h"

#include "asf/dbus/DBusMessage.h"

namespace fcota_descmo_ecu_srv {
namespace FcOtaDescmoEcuSrv {

DEFINE_CLASS_LOGGER("/fcota_descmo_ecu_srv/fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv", FcOtaDescmoEcuSrvStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "RegisterEcu", 0 },
    { 15, "SetDescmoResult", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "DescmoState", 0 },
};

class FcOtaDescmoEcuSrvStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    FcOtaDescmoEcuSrvStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    FcOtaDescmoEcuSrvStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    FcOtaDescmoEcuSrvStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv"),
          _logger(logger) {}

    virtual ~FcOtaDescmoEcuSrvStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void FcOtaDescmoEcuSrvStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'RegisterEcu'

            LOG_DEBUG_STUB("process method '%s'", "RegisterEcu");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterEcuRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterEcu", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterEcuRequest > payload = ::boost::static_pointer_cast<RegisterEcuRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcOtaDescmoEcuSrvStub*>(getStub())->onRegisterEcuRequest(payload);
            return;
        }
        case 1: {

            // method 'SetDescmoResult'

            LOG_DEBUG_STUB("process method '%s'", "SetDescmoResult");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDescmoResultRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetDescmoResult", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetDescmoResultRequest > payload = ::boost::static_pointer_cast<SetDescmoResultRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<FcOtaDescmoEcuSrvStub*>(getStub())->onSetDescmoResultRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* FcOtaDescmoEcuSrvStubDelegate::introspect() const {
    return     "<interface name=\"fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv\">\n"
            "    <property access=\"readwrite\" name=\"DescmoState\" type=\"(uusss)\"/>\n"
            "    <method name=\"RegisterEcu\">\n"
            "      <doc>\n"
            "        <line>RegisterEcu = Existing ecu updaters have to register through this method.</line>\n"
            "        <line>FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"info\" type=\"(us)\">\n"
            "        <doc>\n"
            "          <line>info (of type trRegisterEcuInfo) = Description missing</line>\n"
            "          <line>trRegisterEcuInfo struct[ecuId, name] = Register ecu client.</line>\n"
            "          <line>0: trRegisterEcuInfo.ecuId ('u') = Description missing</line>\n"
            "          <line>1: trRegisterEcuInfo.name ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"(u)\">\n"
            "        <doc>\n"
            "          <line>response (of type trRegisterEcuResponse) = Description missing</line>\n"
            "          <line>trRegisterEcuResponse struct[result] = FcOta's response, after an ecu updater registered with it.</line>\n"
            "          <line>0: trRegisterEcuResponse.result ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetDescmoResult\">\n"
            "      <doc>\n"
            "        <line>SetDescmoResult = Ecu-client will send result of descmo-request received via DescmoState using this method.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"info\" type=\"(uuus)\">\n"
            "        <doc>\n"
            "          <line>info (of type trSetDescmoResultInfo) = Description missing</line>\n"
            "          <line>trSetDescmoResultInfo struct[ecuId, correlatorId, errorCode, xmlData] = Result of the update of one SW component.</line>\n"
            "          <line>0: trSetDescmoResultInfo.ecuId ('u') = Description missing</line>\n"
            "          <line>1: trSetDescmoResultInfo.correlatorId ('u') = Description missing</line>\n"
            "          <line>2: trSetDescmoResultInfo.errorCode ('u') = Description missing</line>\n"
            "          <line>3: trSetDescmoResultInfo.xmlData ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"(uu)\">\n"
            "        <doc>\n"
            "          <line>response (of type trSetDescmoResultResponse) = Description missing</line>\n"
            "          <line>trSetDescmoResultResponse struct[ecuId, correlatorId] = FcOta's response, after an ecu updater sent its update result. \n"
            "   Current Decision: sending of the message on receipt of trSetDescmoResultInfo is not mandatory</line>\n"
            "          <line>0: trSetDescmoResultResponse.ecuId ('u') = Description missing</line>\n"
            "          <line>1: trSetDescmoResultResponse.correlatorId ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void FcOtaDescmoEcuSrvStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<FcOtaDescmoEcuSrvStub*>(getStub()))->onGetAll (properties);
}

void FcOtaDescmoEcuSrvStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "DescmoState");
            ::boost::shared_ptr< DescmoStateSet > payload(new DescmoStateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<FcOtaDescmoEcuSrvStub*>(getStub())->onDescmoStateSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void FcOtaDescmoEcuSrvStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "DescmoState");
            ::boost::shared_ptr< DescmoStateGet > payload(new DescmoStateGet());
            payload->setAct(act);
            static_cast<FcOtaDescmoEcuSrvStub*>(getStub())->onDescmoStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

FcOtaDescmoEcuSrvStub::FcOtaDescmoEcuSrvStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new FcOtaDescmoEcuSrvStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

FcOtaDescmoEcuSrvStub::FcOtaDescmoEcuSrvStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new FcOtaDescmoEcuSrvStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

FcOtaDescmoEcuSrvStub::~FcOtaDescmoEcuSrvStub() {
    delete _stubDelegate;
}

void FcOtaDescmoEcuSrvStub::sendDescmoStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DescmoStateUpdate payload(_DescmoStateProperty);

        LOG_INFO ("-> send%s", "DescmoStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DescmoState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DescmoStateUpdate");
    }
}

void FcOtaDescmoEcuSrvStub::onDescmoStateGet(const ::boost::shared_ptr< DescmoStateGet >& descmoState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DescmoStateGet", descmoState->getAct());
    sendDescmoStateGetUpdate(_DescmoStateProperty.getDescmoState(), descmoState->getAct());
}

void FcOtaDescmoEcuSrvStub::sendDescmoStateGetUpdate(const trDescmoState& descmoState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DescmoStateGet payload(descmoState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DescmoStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void FcOtaDescmoEcuSrvStub::onDescmoStateSet(const ::boost::shared_ptr< DescmoStateSet >& descmoState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DescmoStateSet", descmoState->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*descmoState, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDescmoState (descmoState->getDescmoState());
    sendDescmoStateSetUpdate(descmoState->getAct());
}

void FcOtaDescmoEcuSrvStub::sendDescmoStateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DescmoStateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void FcOtaDescmoEcuSrvStub::setDescmoState(const trDescmoState& descmoState) {
    if(descmoState!=_DescmoStateProperty.getDescmoState()) {
        _DescmoStateProperty.setDescmoState(descmoState);
        sendDescmoStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const trDescmoState& FcOtaDescmoEcuSrvStub::getDescmoState() const {
    return _DescmoStateProperty.getDescmoState();
}

trDescmoState& FcOtaDescmoEcuSrvStub::getDescmoStateMutable() {
    return _DescmoStateProperty.getDescmoStateMutable();
}

void  FcOtaDescmoEcuSrvStub::sendRegisterEcuResponse (const trRegisterEcuResponse& response, act_t act) {
    RegisterEcuResponse* payload = new RegisterEcuResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterEcu", RegisterEcuResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterEcu", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcOtaDescmoEcuSrvStub::sendRegisterEcuError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterEcuError* payload = new RegisterEcuError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterEcu", RegisterEcuError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterEcu", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcOtaDescmoEcuSrvStub::sendSetDescmoResultResponse (const trSetDescmoResultResponse& response, act_t act) {
    SetDescmoResultResponse* payload = new SetDescmoResultResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetDescmoResult", SetDescmoResultResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetDescmoResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  FcOtaDescmoEcuSrvStub::sendSetDescmoResultError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetDescmoResultError* payload = new SetDescmoResultError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetDescmoResult", SetDescmoResultError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetDescmoResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void FcOtaDescmoEcuSrvStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'DescmoState'
    {
        ::asf::dbus::DBusVariant variant;
        DescmoStateGet payload(_DescmoStateProperty.getDescmoState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DescmoState", variant));
    }
}

} // namespace FcOtaDescmoEcuSrv
} // namespace fcota_descmo_ecu_srv
