/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvDBus.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvJson.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace fcota_descmo_ecu_srv {
namespace FcOtaDescmoEcuSrv {

DEFINE_CLASS_LOGGER("/fcota_descmo_ecu_srv/fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv", FcOtaDescmoEcuSrvProxy);

class FcOtaDescmoEcuSrvProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    FcOtaDescmoEcuSrvProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxyShared = ::boost::static_pointer_cast< FcOtaDescmoEcuSrvProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_DescmoState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DescmoStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DescmoState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DescmoStateError> payload = ::boost::static_pointer_cast<DescmoStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DescmoStateCallbackIF*) _callback)->onDescmoStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DescmoStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DescmoState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DescmoStateUpdate> payload = ::boost::static_pointer_cast<DescmoStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DescmoStateCallbackIF*) _callback)->onDescmoStateUpdate(proxyShared, payload);
                        proxyShared->_descmoState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RegisterEcu:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterEcuError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterEcu", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterEcuError> payload = ::boost::static_pointer_cast<RegisterEcuError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterEcuCallbackIF*) _callback)->onRegisterEcuError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterEcuResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterEcu", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterEcuResponse> payload = ::boost::static_pointer_cast<RegisterEcuResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterEcuCallbackIF*) _callback)->onRegisterEcuResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetDescmoResult:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetDescmoResultError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDescmoResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDescmoResultError> payload = ::boost::static_pointer_cast<SetDescmoResultError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDescmoResultCallbackIF*) _callback)->onSetDescmoResultError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDescmoResultResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetDescmoResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetDescmoResultResponse> payload = ::boost::static_pointer_cast<SetDescmoResultResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetDescmoResultCallbackIF*) _callback)->onSetDescmoResultResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_DescmoState: {
                ::boost::shared_ptr< DescmoStateError > payload = ::boost::shared_ptr< DescmoStateError >
                (new DescmoStateError(DBUS_ERROR_NO_SERVER, "The DBus service FcOtaDescmoEcuSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DescmoState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcOtaDescmoEcuSrvProxy> proxyShared = ::boost::static_pointer_cast<FcOtaDescmoEcuSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DescmoStateCallbackIF*) _callback)->onDescmoStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterEcu: {
                ::boost::shared_ptr< RegisterEcuError > payload = ::boost::shared_ptr< RegisterEcuError >
                (new RegisterEcuError(DBUS_ERROR_NO_SERVER, "The DBus service FcOtaDescmoEcuSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterEcu", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcOtaDescmoEcuSrvProxy> proxyShared = ::boost::static_pointer_cast<FcOtaDescmoEcuSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterEcuCallbackIF*) _callback)->onRegisterEcuError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetDescmoResult: {
                ::boost::shared_ptr< SetDescmoResultError > payload = ::boost::shared_ptr< SetDescmoResultError >
                (new SetDescmoResultError(DBUS_ERROR_NO_SERVER, "The DBus service FcOtaDescmoEcuSrv is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetDescmoResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<FcOtaDescmoEcuSrvProxy> proxyShared = ::boost::static_pointer_cast<FcOtaDescmoEcuSrvProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetDescmoResultCallbackIF*) _callback)->onSetDescmoResultError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& FcOtaDescmoEcuSrvProxyCallback::_logger (FcOtaDescmoEcuSrvProxy::_logger);

FcOtaDescmoEcuSrvProxy::FcOtaDescmoEcuSrvProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv", serviceAvailable, _logger) {
}

FcOtaDescmoEcuSrvProxy::~FcOtaDescmoEcuSrvProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > FcOtaDescmoEcuSrvProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<FcOtaDescmoEcuSrvProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > proxyNew(new FcOtaDescmoEcuSrvProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t FcOtaDescmoEcuSrvProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    FcOtaDescmoEcuSrvProxyCallback* callback = new FcOtaDescmoEcuSrvProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t FcOtaDescmoEcuSrvProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    FcOtaDescmoEcuSrvProxyCallback* callback = new FcOtaDescmoEcuSrvProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcOtaDescmoEcuSrvProxy::clearAllProperties ()
{
    _descmoState = ::asf::core::nullable< DescmoStateUpdate >();
}

void FcOtaDescmoEcuSrvProxy::sendDeregisterAll () const
{
    sendDescmoStateDeregisterAll();
}

act_t FcOtaDescmoEcuSrvProxy::sendDescmoStateRegister(DescmoStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DescmoState, "DescmoState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DescmoState", &cb, act);
    return act;
}

bool FcOtaDescmoEcuSrvProxy::sendDescmoStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DescmoState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DescmoState", act, static_cast<int>(rv));
    return rv;
}

act_t FcOtaDescmoEcuSrvProxy::sendDescmoStateGet(DescmoStateCallbackIF& cb) {
    FcOtaDescmoEcuSrvProxyCallback* callback = new FcOtaDescmoEcuSrvProxyCallback(ID_DescmoState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DescmoState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DescmoState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void FcOtaDescmoEcuSrvProxy::sendDescmoStateSet(const trDescmoState& descmoState) {
    DescmoStateSet parameter(descmoState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DescmoState");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DescmoState", propertyContent);
}

act_t FcOtaDescmoEcuSrvProxy::sendDescmoStateSet(DescmoStateCallbackIF& cb, const trDescmoState& descmoState) {
    FcOtaDescmoEcuSrvProxyCallback* callback = new FcOtaDescmoEcuSrvProxyCallback(ID_DescmoState, &cb);
    DescmoStateSet parameter(descmoState);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DescmoState", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DescmoState", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const trDescmoState& FcOtaDescmoEcuSrvProxy::getDescmoState() const {
    return _descmoState.get().getDescmoState();
}

bool FcOtaDescmoEcuSrvProxy::hasDescmoState() const {
    return _descmoState.hasValue();
}

void FcOtaDescmoEcuSrvProxy::sendDescmoStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DescmoState");
    _dbusProxyDelegate->deregisterSignalCallback("DescmoState", 0, _dbusDaemonProxy.get(), true);
}

act_t FcOtaDescmoEcuSrvProxy::sendRegisterEcuRequest(RegisterEcuCallbackIF& cb, const trRegisterEcuInfo& info) const {
    RegisterEcuRequest* payload = new RegisterEcuRequest();
    CHECK_ALLOCATION(payload);
    payload->setInfo(info);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterEcu", RegisterEcuRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterEcu, dbusMessage.getUniqueSerial(), "RegisterEcu", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterEcu", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t FcOtaDescmoEcuSrvProxy::sendSetDescmoResultRequest(SetDescmoResultCallbackIF& cb, const trSetDescmoResultInfo& info) const {
    SetDescmoResultRequest* payload = new SetDescmoResultRequest();
    CHECK_ALLOCATION(payload);
    payload->setInfo(info);
    DBUS_MESSAGE_CALL(dbusMessage, "SetDescmoResult", SetDescmoResultRequest, payload, true)
    act_t act = addMethodCallback(ID_SetDescmoResult, dbusMessage.getUniqueSerial(), "SetDescmoResult", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetDescmoResult", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace FcOtaDescmoEcuSrv
} // namespace fcota_descmo_ecu_srv
