#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRV_H
#define FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRV_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * Interface to connect ecus to descmo-functionality.
 */

namespace fcota_descmo_ecu_srv {
namespace FcOtaDescmoEcuSrv {

// method IDs
static const uint16 ID_RegisterEcu = 0;
static const uint16 ID_SetDescmoResult = 1;

// signal IDs

// property IDs
static const uint16 ID_DescmoState = 2;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class trDescmoState;

class trRegisterEcuInfo;

class trRegisterEcuResponse;

class trSetDescmoResultInfo;

class trSetDescmoResultResponse;

class RegisterEcuRequest;

class RegisterEcuResponse;

class SetDescmoResultRequest;

class SetDescmoResultResponse;

class DescmoStateUpdate;

class DescmoStateRegister;

// type definitions
/**
 * If the meaning of "RegisterEcuError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterEcuError;

/**
 * If the meaning of "SetDescmoResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetDescmoResultError;

/**
 * Global current state.
 */
typedef DescmoStateUpdate DescmoStateSet;

/**
 * Global current state.
 */
typedef DescmoStateUpdate DescmoStateGet;

/**
 * If the meaning of "DescmoStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DescmoStateError;


/**
 * State, used to give commands to the ecu-clients.
 */
class trDescmoState {
public:

    /**
     * Default constructor
     */
    inline  trDescmoState ();

    /**
     * Copy constructor
     */
    inline  trDescmoState (const trDescmoState &rhs);

    /**
     * All fields constructor
     */
    inline  trDescmoState (uint32 ecuId_, uint32 correlatorId_, const ::std::string& profileName_, const ::std::string& xmlData_, const ::std::string& xmlDataSignature_);

    /**
     * Destructor
     */
    inline  ~trDescmoState();

    /**
     * Assignment operator
     */
    inline trDescmoState& operator = (const trDescmoState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trDescmoState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trDescmoState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trDescmoState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trDescmoState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecuId"

    static const int kEcuId = 0;

    /**
     * Clears the field "ecuId".
     *
     * The field will be set to its default value. The hasEcuId()
     * method will return false.
     */
    inline void clearEcuId();

    /**
     * Checks whether the field "ecuId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcuId()). Otherwise it will return false.
     */
    inline bool hasEcuId () const;

    /**
     * Returns the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecuId"
     */
    inline uint32 getEcuId () const;

    /**
     * Sets the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @param ecuId The value which will be set
     */
    inline void setEcuId (uint32 ecuId_);

    // API of field "correlatorId"

    static const int kCorrelatorId = 1;

    /**
     * Clears the field "correlatorId".
     *
     * The field will be set to its default value. The hasCorrelatorId()
     * method will return false.
     */
    inline void clearCorrelatorId();

    /**
     * Checks whether the field "correlatorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelatorId()). Otherwise it will return false.
     */
    inline bool hasCorrelatorId () const;

    /**
     * Returns the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "correlatorId"
     */
    inline uint32 getCorrelatorId () const;

    /**
     * Sets the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @param correlatorId The value which will be set
     */
    inline void setCorrelatorId (uint32 correlatorId_);

    // API of field "profileName"

    static const int kProfileName = 2;

    /**
     * Clears the field "profileName".
     *
     * The field will be set to its default value. The hasProfileName()
     * method will return false.
     */
    inline void clearProfileName();

    /**
     * Checks whether the field "profileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileName()). Otherwise it will return false.
     */
    inline bool hasProfileName () const;

    /**
     * Returns the value of the member "profileName".
     *
     * If the meaning of "profileName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileName"
     */
    inline const ::std::string& getProfileName () const;

    /**
     * Retrieves the value of the field "profileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "profileName".
     */
    inline ::std::string& getProfileNameMutable ();

    /**
     * Sets the value of the member "profileName".
     *
     * If the meaning of "profileName" isn't clear, then there should be a description here.
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const ::std::string& profileName_);

    /**
     * Sets the value of the member "profileName".
     *
     * If the meaning of "profileName" isn't clear, then there should be a description here.
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const char* profileName_);

    /**
     * Sets the value of the member "profileName".
     *
     * If the meaning of "profileName" isn't clear, then there should be a description here.
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const char* value, size_t size);

    // API of field "xmlData"

    static const int kXmlData = 3;

    /**
     * Clears the field "xmlData".
     *
     * The field will be set to its default value. The hasXmlData()
     * method will return false.
     */
    inline void clearXmlData();

    /**
     * Checks whether the field "xmlData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXmlData()). Otherwise it will return false.
     */
    inline bool hasXmlData () const;

    /**
     * Returns the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xmlData"
     */
    inline const ::std::string& getXmlData () const;

    /**
     * Retrieves the value of the field "xmlData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "xmlData".
     */
    inline ::std::string& getXmlDataMutable ();

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const ::std::string& xmlData_);

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const char* xmlData_);

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const char* value, size_t size);

    // API of field "xmlDataSignature"

    static const int kXmlDataSignature = 4;

    /**
     * Clears the field "xmlDataSignature".
     *
     * The field will be set to its default value. The hasXmlDataSignature()
     * method will return false.
     */
    inline void clearXmlDataSignature();

    /**
     * Checks whether the field "xmlDataSignature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXmlDataSignature()). Otherwise it will return false.
     */
    inline bool hasXmlDataSignature () const;

    /**
     * Returns the value of the member "xmlDataSignature".
     *
     * If the meaning of "xmlDataSignature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xmlDataSignature"
     */
    inline const ::std::string& getXmlDataSignature () const;

    /**
     * Retrieves the value of the field "xmlDataSignature" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "xmlDataSignature".
     */
    inline ::std::string& getXmlDataSignatureMutable ();

    /**
     * Sets the value of the member "xmlDataSignature".
     *
     * If the meaning of "xmlDataSignature" isn't clear, then there should be a description here.
     *
     * @param xmlDataSignature The value which will be set
     */
    inline void setXmlDataSignature (const ::std::string& xmlDataSignature_);

    /**
     * Sets the value of the member "xmlDataSignature".
     *
     * If the meaning of "xmlDataSignature" isn't clear, then there should be a description here.
     *
     * @param xmlDataSignature The value which will be set
     */
    inline void setXmlDataSignature (const char* xmlDataSignature_);

    /**
     * Sets the value of the member "xmlDataSignature".
     *
     * If the meaning of "xmlDataSignature" isn't clear, then there should be a description here.
     *
     * @param xmlDataSignature The value which will be set
     */
    inline void setXmlDataSignature (const char* value, size_t size);

    static const trDescmoState &getDefaultInstance();

private:

    inline void set_has_ecuId ();

    inline void clear_has_ecuId ();

    inline void set_has_correlatorId ();

    inline void clear_has_correlatorId ();

    inline void set_has_profileName ();

    inline void clear_has_profileName ();

    inline void set_has_xmlData ();

    inline void clear_has_xmlData ();

    inline void set_has_xmlDataSignature ();

    inline void clear_has_xmlDataSignature ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _ecuId;

    uint32 _correlatorId;

    ::std::string _profileName;

    ::std::string _xmlData;

    ::std::string _xmlDataSignature;

};

/**
 * Register ecu client.
 */
class trRegisterEcuInfo {
public:

    /**
     * Default constructor
     */
    inline  trRegisterEcuInfo ();

    /**
     * Copy constructor
     */
    inline  trRegisterEcuInfo (const trRegisterEcuInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trRegisterEcuInfo (uint32 ecuId_, const ::std::string& name_);

    /**
     * Destructor
     */
    inline  ~trRegisterEcuInfo();

    /**
     * Assignment operator
     */
    inline trRegisterEcuInfo& operator = (const trRegisterEcuInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trRegisterEcuInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trRegisterEcuInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trRegisterEcuInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trRegisterEcuInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecuId"

    static const int kEcuId = 0;

    /**
     * Clears the field "ecuId".
     *
     * The field will be set to its default value. The hasEcuId()
     * method will return false.
     */
    inline void clearEcuId();

    /**
     * Checks whether the field "ecuId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcuId()). Otherwise it will return false.
     */
    inline bool hasEcuId () const;

    /**
     * Returns the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecuId"
     */
    inline uint32 getEcuId () const;

    /**
     * Sets the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @param ecuId The value which will be set
     */
    inline void setEcuId (uint32 ecuId_);

    // API of field "name"

    static const int kName = 1;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const trRegisterEcuInfo &getDefaultInstance();

private:

    inline void set_has_ecuId ();

    inline void clear_has_ecuId ();

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ecuId;

    ::std::string _name;

};

/**
 * FcOta's response, after an ecu updater registered with it.
 */
class trRegisterEcuResponse {
public:

    /**
     * Default constructor
     */
    inline  trRegisterEcuResponse ();

    /**
     * Copy constructor
     */
    inline  trRegisterEcuResponse (const trRegisterEcuResponse &rhs);

    /**
     * All fields constructor
     */
    inline  trRegisterEcuResponse (tenRegisterEcuResponse result_);

    /**
     * Destructor
     */
    inline  ~trRegisterEcuResponse();

    /**
     * Assignment operator
     */
    inline trRegisterEcuResponse& operator = (const trRegisterEcuResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trRegisterEcuResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trRegisterEcuResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trRegisterEcuResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trRegisterEcuResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline tenRegisterEcuResponse getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (tenRegisterEcuResponse result_);

    static const trRegisterEcuResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    tenRegisterEcuResponse _result;

};

/**
 * Result of the update of one SW component.
 */
class trSetDescmoResultInfo {
public:

    /**
     * Default constructor
     */
    inline  trSetDescmoResultInfo ();

    /**
     * Copy constructor
     */
    inline  trSetDescmoResultInfo (const trSetDescmoResultInfo &rhs);

    /**
     * All fields constructor
     */
    inline  trSetDescmoResultInfo (uint32 ecuId_, uint32 correlatorId_, uint32 errorCode_, const ::std::string& xmlData_);

    /**
     * Destructor
     */
    inline  ~trSetDescmoResultInfo();

    /**
     * Assignment operator
     */
    inline trSetDescmoResultInfo& operator = (const trSetDescmoResultInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trSetDescmoResultInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trSetDescmoResultInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trSetDescmoResultInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trSetDescmoResultInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecuId"

    static const int kEcuId = 0;

    /**
     * Clears the field "ecuId".
     *
     * The field will be set to its default value. The hasEcuId()
     * method will return false.
     */
    inline void clearEcuId();

    /**
     * Checks whether the field "ecuId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcuId()). Otherwise it will return false.
     */
    inline bool hasEcuId () const;

    /**
     * Returns the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecuId"
     */
    inline uint32 getEcuId () const;

    /**
     * Sets the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @param ecuId The value which will be set
     */
    inline void setEcuId (uint32 ecuId_);

    // API of field "correlatorId"

    static const int kCorrelatorId = 1;

    /**
     * Clears the field "correlatorId".
     *
     * The field will be set to its default value. The hasCorrelatorId()
     * method will return false.
     */
    inline void clearCorrelatorId();

    /**
     * Checks whether the field "correlatorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelatorId()). Otherwise it will return false.
     */
    inline bool hasCorrelatorId () const;

    /**
     * Returns the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "correlatorId"
     */
    inline uint32 getCorrelatorId () const;

    /**
     * Sets the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @param correlatorId The value which will be set
     */
    inline void setCorrelatorId (uint32 correlatorId_);

    // API of field "errorCode"

    static const int kErrorCode = 2;

    /**
     * Clears the field "errorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "errorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "errorCode".
     *
     * If the meaning of "errorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "errorCode".
     *
     * If the meaning of "errorCode" isn't clear, then there should be a description here.
     *
     * @param errorCode The value which will be set
     */
    inline void setErrorCode (uint32 errorCode_);

    // API of field "xmlData"

    static const int kXmlData = 3;

    /**
     * Clears the field "xmlData".
     *
     * The field will be set to its default value. The hasXmlData()
     * method will return false.
     */
    inline void clearXmlData();

    /**
     * Checks whether the field "xmlData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXmlData()). Otherwise it will return false.
     */
    inline bool hasXmlData () const;

    /**
     * Returns the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xmlData"
     */
    inline const ::std::string& getXmlData () const;

    /**
     * Retrieves the value of the field "xmlData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "xmlData".
     */
    inline ::std::string& getXmlDataMutable ();

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const ::std::string& xmlData_);

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const char* xmlData_);

    /**
     * Sets the value of the member "xmlData".
     *
     * If the meaning of "xmlData" isn't clear, then there should be a description here.
     *
     * @param xmlData The value which will be set
     */
    inline void setXmlData (const char* value, size_t size);

    static const trSetDescmoResultInfo &getDefaultInstance();

private:

    inline void set_has_ecuId ();

    inline void clear_has_ecuId ();

    inline void set_has_correlatorId ();

    inline void clear_has_correlatorId ();

    inline void set_has_errorCode ();

    inline void clear_has_errorCode ();

    inline void set_has_xmlData ();

    inline void clear_has_xmlData ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ecuId;

    uint32 _correlatorId;

    uint32 _errorCode;

    ::std::string _xmlData;

};

/**
 * FcOta's response, after an ecu updater sent its update result.
 *    Current Decision: sending of the message on receipt of trSetDescmoResultInfo is not mandatory
 */
class trSetDescmoResultResponse {
public:

    /**
     * Default constructor
     */
    inline  trSetDescmoResultResponse ();

    /**
     * Copy constructor
     */
    inline  trSetDescmoResultResponse (const trSetDescmoResultResponse &rhs);

    /**
     * All fields constructor
     */
    inline  trSetDescmoResultResponse (uint32 ecuId_, uint32 correlatorId_);

    /**
     * Destructor
     */
    inline  ~trSetDescmoResultResponse();

    /**
     * Assignment operator
     */
    inline trSetDescmoResultResponse& operator = (const trSetDescmoResultResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const trSetDescmoResultResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const trSetDescmoResultResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const trSetDescmoResultResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const trSetDescmoResultResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ecuId"

    static const int kEcuId = 0;

    /**
     * Clears the field "ecuId".
     *
     * The field will be set to its default value. The hasEcuId()
     * method will return false.
     */
    inline void clearEcuId();

    /**
     * Checks whether the field "ecuId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEcuId()). Otherwise it will return false.
     */
    inline bool hasEcuId () const;

    /**
     * Returns the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ecuId"
     */
    inline uint32 getEcuId () const;

    /**
     * Sets the value of the member "ecuId".
     *
     * If the meaning of "ecuId" isn't clear, then there should be a description here.
     *
     * @param ecuId The value which will be set
     */
    inline void setEcuId (uint32 ecuId_);

    // API of field "correlatorId"

    static const int kCorrelatorId = 1;

    /**
     * Clears the field "correlatorId".
     *
     * The field will be set to its default value. The hasCorrelatorId()
     * method will return false.
     */
    inline void clearCorrelatorId();

    /**
     * Checks whether the field "correlatorId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelatorId()). Otherwise it will return false.
     */
    inline bool hasCorrelatorId () const;

    /**
     * Returns the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "correlatorId"
     */
    inline uint32 getCorrelatorId () const;

    /**
     * Sets the value of the member "correlatorId".
     *
     * If the meaning of "correlatorId" isn't clear, then there should be a description here.
     *
     * @param correlatorId The value which will be set
     */
    inline void setCorrelatorId (uint32 correlatorId_);

    static const trSetDescmoResultResponse &getDefaultInstance();

private:

    inline void set_has_ecuId ();

    inline void clear_has_ecuId ();

    inline void set_has_correlatorId ();

    inline void clear_has_correlatorId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ecuId;

    uint32 _correlatorId;

};

/**
 * Existing ecu updaters have to register through this method.
 *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
 */
class RegisterEcuRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterEcuRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterEcuRequest (const RegisterEcuRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterEcuRequest (const trRegisterEcuInfo& info_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterEcuRequest();

    /**
     * Assignment operator
     */
    inline RegisterEcuRequest& operator = (const RegisterEcuRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterEcuRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterEcuRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterEcuRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterEcuRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "info"

    static const int kInfo = 0;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const trRegisterEcuInfo& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline trRegisterEcuInfo& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const trRegisterEcuInfo& info_);

    static const RegisterEcuRequest &getDefaultInstance();

private:

    inline void set_has_info ();

    inline void clear_has_info ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trRegisterEcuInfo _info;

};

/**
 * Existing ecu updaters have to register through this method.
 *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
 */
class RegisterEcuResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterEcuResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterEcuResponse (const RegisterEcuResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterEcuResponse (const trRegisterEcuResponse& response_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterEcuResponse();

    /**
     * Assignment operator
     */
    inline RegisterEcuResponse& operator = (const RegisterEcuResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterEcuResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterEcuResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterEcuResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterEcuResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline const trRegisterEcuResponse& getResponse () const;

    /**
     * Retrieves the value of the field "response" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "response".
     */
    inline trRegisterEcuResponse& getResponseMutable ();

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (const trRegisterEcuResponse& response_);

    static const RegisterEcuResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trRegisterEcuResponse _response;

};

/**
 * Ecu-client will send result of descmo-request received via DescmoState using this method.
 */
class SetDescmoResultRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDescmoResultRequest ();

    /**
     * Copy constructor
     */
    inline  SetDescmoResultRequest (const SetDescmoResultRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetDescmoResultRequest (const trSetDescmoResultInfo& info_);

    /**
     * Destructor
     */
    inline virtual  ~SetDescmoResultRequest();

    /**
     * Assignment operator
     */
    inline SetDescmoResultRequest& operator = (const SetDescmoResultRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDescmoResultRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDescmoResultRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDescmoResultRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDescmoResultRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "info"

    static const int kInfo = 0;

    /**
     * Clears the field "info".
     *
     * The field will be set to its default value. The hasInfo()
     * method will return false.
     */
    inline void clearInfo();

    /**
     * Checks whether the field "info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfo()). Otherwise it will return false.
     */
    inline bool hasInfo () const;

    /**
     * Returns the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "info"
     */
    inline const trSetDescmoResultInfo& getInfo () const;

    /**
     * Retrieves the value of the field "info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "info".
     */
    inline trSetDescmoResultInfo& getInfoMutable ();

    /**
     * Sets the value of the member "info".
     *
     * If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @param info The value which will be set
     */
    inline void setInfo (const trSetDescmoResultInfo& info_);

    static const SetDescmoResultRequest &getDefaultInstance();

private:

    inline void set_has_info ();

    inline void clear_has_info ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trSetDescmoResultInfo _info;

};

/**
 * Ecu-client will send result of descmo-request received via DescmoState using this method.
 */
class SetDescmoResultResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDescmoResultResponse ();

    /**
     * Copy constructor
     */
    inline  SetDescmoResultResponse (const SetDescmoResultResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetDescmoResultResponse (const trSetDescmoResultResponse& response_);

    /**
     * Destructor
     */
    inline virtual  ~SetDescmoResultResponse();

    /**
     * Assignment operator
     */
    inline SetDescmoResultResponse& operator = (const SetDescmoResultResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDescmoResultResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDescmoResultResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDescmoResultResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDescmoResultResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline const trSetDescmoResultResponse& getResponse () const;

    /**
     * Retrieves the value of the field "response" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "response".
     */
    inline trSetDescmoResultResponse& getResponseMutable ();

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (const trSetDescmoResultResponse& response_);

    static const SetDescmoResultResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trSetDescmoResultResponse _response;

};

/**
 * Global current state.
 */
class DescmoStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DescmoStateUpdate ();

    /**
     * Copy constructor
     */
    inline  DescmoStateUpdate (const DescmoStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DescmoStateUpdate (const trDescmoState& DescmoState_);

    /**
     * Destructor
     */
    inline virtual  ~DescmoStateUpdate();

    /**
     * Assignment operator
     */
    inline DescmoStateUpdate& operator = (const DescmoStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DescmoStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DescmoStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DescmoStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DescmoStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DescmoState"

    static const int kDescmoState = 0;

    /**
     * Clears the field "DescmoState".
     *
     * The field will be set to its default value. The hasDescmoState()
     * method will return false.
     */
    inline void clearDescmoState();

    /**
     * Checks whether the field "DescmoState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDescmoState()). Otherwise it will return false.
     */
    inline bool hasDescmoState () const;

    /**
     * Returns the value of the member "DescmoState".
     *
     * Global current state.
     *
     * @return The value of the field "DescmoState"
     */
    inline const trDescmoState& getDescmoState () const;

    /**
     * Retrieves the value of the field "DescmoState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DescmoState".
     */
    inline trDescmoState& getDescmoStateMutable ();

    /**
     * Sets the value of the member "DescmoState".
     *
     * Global current state.
     *
     * @param DescmoState The value which will be set
     */
    inline void setDescmoState (const trDescmoState& DescmoState_);

    static const DescmoStateUpdate &getDefaultInstance();

private:

    inline void set_has_DescmoState ();

    inline void clear_has_DescmoState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    trDescmoState _DescmoState;

};

/**
 * Global current state.
 */
class DescmoStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DescmoStateRegister ();

    /**
     * Copy constructor
     */
    inline  DescmoStateRegister (const DescmoStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DescmoStateRegister();

    /**
     * Assignment operator
     */
    inline DescmoStateRegister& operator = (const DescmoStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DescmoStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DescmoStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DescmoStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DescmoStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DescmoStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  trDescmoState::trDescmoState ()  :
    _ecuId (0u),
    _correlatorId (0u),
    _profileName (),
    _xmlData (),
    _xmlDataSignature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trDescmoState::trDescmoState (const trDescmoState &rhs)  :
    _ecuId (0u),
    _correlatorId (0u),
    _profileName (),
    _xmlData (),
    _xmlDataSignature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trDescmoState::trDescmoState (uint32 ecuId_, uint32 correlatorId_, const ::std::string& profileName_, const ::std::string& xmlData_, const ::std::string& xmlDataSignature_)  :
    _ecuId (ecuId_),
    _correlatorId (correlatorId_),
    _profileName (profileName_),
    _xmlData (xmlData_),
    _xmlDataSignature (xmlDataSignature_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlDataSignature_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trDescmoState::~trDescmoState() {
}

inline trDescmoState& trDescmoState::operator = (const trDescmoState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEcuId()) {
            setEcuId(rhs.getEcuId());
        } else {
            clearEcuId();
        }
        if (rhs.hasCorrelatorId()) {
            setCorrelatorId(rhs.getCorrelatorId());
        } else {
            clearCorrelatorId();
        }
        if (rhs.hasProfileName()) {
            setProfileName(rhs.getProfileName());
        } else {
            clearProfileName();
        }
        if (rhs.hasXmlData()) {
            setXmlData(rhs.getXmlData());
        } else {
            clearXmlData();
        }
        if (rhs.hasXmlDataSignature()) {
            setXmlDataSignature(rhs.getXmlDataSignature());
        } else {
            clearXmlDataSignature();
        }
    }
    return *this;
}

inline bool trDescmoState::operator == (const trDescmoState& rhs) const {
    return (((!hasEcuId() && !rhs.hasEcuId()) || getEcuId() == rhs.getEcuId()) &&
        ((!hasCorrelatorId() && !rhs.hasCorrelatorId()) || getCorrelatorId() == rhs.getCorrelatorId()) &&
        ((!hasProfileName() && !rhs.hasProfileName()) || getProfileName() == rhs.getProfileName()) &&
        ((!hasXmlData() && !rhs.hasXmlData()) || getXmlData() == rhs.getXmlData()) &&
        ((!hasXmlDataSignature() && !rhs.hasXmlDataSignature()) || getXmlDataSignature() == rhs.getXmlDataSignature()));
}

inline bool trDescmoState::operator != (const trDescmoState& rhs) const {
    return ! (*this == rhs);
}

inline bool trDescmoState::operator < (const trDescmoState& rhs) const {
    if (hasEcuId() || rhs.hasEcuId()) {
        if (getEcuId() < rhs.getEcuId()) return true;
        if (getEcuId() > rhs.getEcuId()) return false;
    }
    if (hasCorrelatorId() || rhs.hasCorrelatorId()) {
        if (getCorrelatorId() < rhs.getCorrelatorId()) return true;
        if (getCorrelatorId() > rhs.getCorrelatorId()) return false;
    }
    if (hasProfileName() || rhs.hasProfileName()) {
        if (getProfileName() < rhs.getProfileName()) return true;
        if (getProfileName() > rhs.getProfileName()) return false;
    }
    if (hasXmlData() || rhs.hasXmlData()) {
        if (getXmlData() < rhs.getXmlData()) return true;
        if (getXmlData() > rhs.getXmlData()) return false;
    }
    if (hasXmlDataSignature() || rhs.hasXmlDataSignature()) {
        if (getXmlDataSignature() < rhs.getXmlDataSignature()) return true;
        if (getXmlDataSignature() > rhs.getXmlDataSignature()) return false;
    }
    return false;
}

inline bool trDescmoState::operator > (const trDescmoState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trDescmoState::clear() {
    clearEcuId();
    clearCorrelatorId();
    clearProfileName();
    clearXmlData();
    clearXmlDataSignature();
}

inline void trDescmoState::clearEcuId() {
    if (hasEcuId()) {
         clear_has_ecuId();
        _ecuId = 0u;
     }
}

inline bool trDescmoState::hasEcuId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trDescmoState::getEcuId () const {
    return _ecuId;
}

inline void trDescmoState::setEcuId (uint32 ecuId_) {
    set_has_ecuId();
    this->_ecuId = ecuId_;
}

inline void trDescmoState::clearCorrelatorId() {
    if (hasCorrelatorId()) {
         clear_has_correlatorId();
        _correlatorId = 0u;
     }
}

inline bool trDescmoState::hasCorrelatorId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trDescmoState::getCorrelatorId () const {
    return _correlatorId;
}

inline void trDescmoState::setCorrelatorId (uint32 correlatorId_) {
    set_has_correlatorId();
    this->_correlatorId = correlatorId_;
}

inline void trDescmoState::clearProfileName() {
    if (hasProfileName()) {
         clear_has_profileName();
        _profileName.clear();
     }
}

inline bool trDescmoState::hasProfileName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& trDescmoState::getProfileName () const {
    return _profileName;
}

inline ::std::string& trDescmoState::getProfileNameMutable () {
    set_has_profileName();
    return _profileName;
}

inline void trDescmoState::setProfileName (const ::std::string& profileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName = profileName_;
}

inline void trDescmoState::setProfileName (const char* profileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName.assign(profileName_);
}

inline void trDescmoState::setProfileName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName.assign(value, size);
}

inline void trDescmoState::clearXmlData() {
    if (hasXmlData()) {
         clear_has_xmlData();
        _xmlData.clear();
     }
}

inline bool trDescmoState::hasXmlData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trDescmoState::getXmlData () const {
    return _xmlData;
}

inline ::std::string& trDescmoState::getXmlDataMutable () {
    set_has_xmlData();
    return _xmlData;
}

inline void trDescmoState::setXmlData (const ::std::string& xmlData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData = xmlData_;
}

inline void trDescmoState::setXmlData (const char* xmlData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData.assign(xmlData_);
}

inline void trDescmoState::setXmlData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData.assign(value, size);
}

inline void trDescmoState::clearXmlDataSignature() {
    if (hasXmlDataSignature()) {
         clear_has_xmlDataSignature();
        _xmlDataSignature.clear();
     }
}

inline bool trDescmoState::hasXmlDataSignature () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& trDescmoState::getXmlDataSignature () const {
    return _xmlDataSignature;
}

inline ::std::string& trDescmoState::getXmlDataSignatureMutable () {
    set_has_xmlDataSignature();
    return _xmlDataSignature;
}

inline void trDescmoState::setXmlDataSignature (const ::std::string& xmlDataSignature_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlDataSignature_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlDataSignature();
    this->_xmlDataSignature = xmlDataSignature_;
}

inline void trDescmoState::setXmlDataSignature (const char* xmlDataSignature_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlDataSignature_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlDataSignature();
    this->_xmlDataSignature.assign(xmlDataSignature_);
}

inline void trDescmoState::setXmlDataSignature (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlDataSignature();
    this->_xmlDataSignature.assign(value, size);
}

inline void trDescmoState::set_has_ecuId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trDescmoState::clear_has_ecuId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trDescmoState::set_has_correlatorId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trDescmoState::clear_has_correlatorId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trDescmoState::set_has_profileName () {
    _has_bits_[0] |= 1u << 2;
}

inline void trDescmoState::clear_has_profileName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trDescmoState::set_has_xmlData () {
    _has_bits_[0] |= 1u << 3;
}

inline void trDescmoState::clear_has_xmlData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void trDescmoState::set_has_xmlDataSignature () {
    _has_bits_[0] |= 1u << 4;
}

inline void trDescmoState::clear_has_xmlDataSignature () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  trRegisterEcuInfo::trRegisterEcuInfo ()  :
    _ecuId (0u),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trRegisterEcuInfo::trRegisterEcuInfo (const trRegisterEcuInfo &rhs)  :
    _ecuId (0u),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trRegisterEcuInfo::trRegisterEcuInfo (uint32 ecuId_, const ::std::string& name_)  :
    _ecuId (ecuId_),
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trRegisterEcuInfo::~trRegisterEcuInfo() {
}

inline trRegisterEcuInfo& trRegisterEcuInfo::operator = (const trRegisterEcuInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEcuId()) {
            setEcuId(rhs.getEcuId());
        } else {
            clearEcuId();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool trRegisterEcuInfo::operator == (const trRegisterEcuInfo& rhs) const {
    return (((!hasEcuId() && !rhs.hasEcuId()) || getEcuId() == rhs.getEcuId()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool trRegisterEcuInfo::operator != (const trRegisterEcuInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trRegisterEcuInfo::operator < (const trRegisterEcuInfo& rhs) const {
    if (hasEcuId() || rhs.hasEcuId()) {
        if (getEcuId() < rhs.getEcuId()) return true;
        if (getEcuId() > rhs.getEcuId()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline bool trRegisterEcuInfo::operator > (const trRegisterEcuInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trRegisterEcuInfo::clear() {
    clearEcuId();
    clearName();
}

inline void trRegisterEcuInfo::clearEcuId() {
    if (hasEcuId()) {
         clear_has_ecuId();
        _ecuId = 0u;
     }
}

inline bool trRegisterEcuInfo::hasEcuId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trRegisterEcuInfo::getEcuId () const {
    return _ecuId;
}

inline void trRegisterEcuInfo::setEcuId (uint32 ecuId_) {
    set_has_ecuId();
    this->_ecuId = ecuId_;
}

inline void trRegisterEcuInfo::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool trRegisterEcuInfo::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& trRegisterEcuInfo::getName () const {
    return _name;
}

inline ::std::string& trRegisterEcuInfo::getNameMutable () {
    set_has_name();
    return _name;
}

inline void trRegisterEcuInfo::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void trRegisterEcuInfo::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void trRegisterEcuInfo::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void trRegisterEcuInfo::set_has_ecuId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trRegisterEcuInfo::clear_has_ecuId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trRegisterEcuInfo::set_has_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void trRegisterEcuInfo::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  trRegisterEcuResponse::trRegisterEcuResponse ()  :
    _result (::fcota_descmo_ecu_srv::FcOtaDescmoEcuSrv::tenRegisterEcuResponse__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trRegisterEcuResponse::trRegisterEcuResponse (const trRegisterEcuResponse &rhs)  :
    _result (::fcota_descmo_ecu_srv::FcOtaDescmoEcuSrv::tenRegisterEcuResponse__OK)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trRegisterEcuResponse::trRegisterEcuResponse (tenRegisterEcuResponse result_)  :
    _result (result_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenRegisterEcuResponse_IsValid(result_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "tenRegisterEcuResponse", "result", "trRegisterEcuResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trRegisterEcuResponse::~trRegisterEcuResponse() {
}

inline trRegisterEcuResponse& trRegisterEcuResponse::operator = (const trRegisterEcuResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool trRegisterEcuResponse::operator == (const trRegisterEcuResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool trRegisterEcuResponse::operator != (const trRegisterEcuResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool trRegisterEcuResponse::operator < (const trRegisterEcuResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline bool trRegisterEcuResponse::operator > (const trRegisterEcuResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trRegisterEcuResponse::clear() {
    clearResult();
}

inline void trRegisterEcuResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::fcota_descmo_ecu_srv::FcOtaDescmoEcuSrv::tenRegisterEcuResponse__OK;
     }
}

inline bool trRegisterEcuResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline tenRegisterEcuResponse trRegisterEcuResponse::getResult () const {
    return _result;
}

inline void trRegisterEcuResponse::setResult (tenRegisterEcuResponse result_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(tenRegisterEcuResponse_IsValid(result_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "tenRegisterEcuResponse", "result", "trRegisterEcuResponse");
    }
    set_has_result();
    this->_result = result_;
}

inline void trRegisterEcuResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void trRegisterEcuResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  trSetDescmoResultInfo::trSetDescmoResultInfo ()  :
    _ecuId (0u),
    _correlatorId (0u),
    _errorCode (0u),
    _xmlData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trSetDescmoResultInfo::trSetDescmoResultInfo (const trSetDescmoResultInfo &rhs)  :
    _ecuId (0u),
    _correlatorId (0u),
    _errorCode (0u),
    _xmlData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trSetDescmoResultInfo::trSetDescmoResultInfo (uint32 ecuId_, uint32 correlatorId_, uint32 errorCode_, const ::std::string& xmlData_)  :
    _ecuId (ecuId_),
    _correlatorId (correlatorId_),
    _errorCode (errorCode_),
    _xmlData (xmlData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trSetDescmoResultInfo::~trSetDescmoResultInfo() {
}

inline trSetDescmoResultInfo& trSetDescmoResultInfo::operator = (const trSetDescmoResultInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEcuId()) {
            setEcuId(rhs.getEcuId());
        } else {
            clearEcuId();
        }
        if (rhs.hasCorrelatorId()) {
            setCorrelatorId(rhs.getCorrelatorId());
        } else {
            clearCorrelatorId();
        }
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
        if (rhs.hasXmlData()) {
            setXmlData(rhs.getXmlData());
        } else {
            clearXmlData();
        }
    }
    return *this;
}

inline bool trSetDescmoResultInfo::operator == (const trSetDescmoResultInfo& rhs) const {
    return (((!hasEcuId() && !rhs.hasEcuId()) || getEcuId() == rhs.getEcuId()) &&
        ((!hasCorrelatorId() && !rhs.hasCorrelatorId()) || getCorrelatorId() == rhs.getCorrelatorId()) &&
        ((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()) &&
        ((!hasXmlData() && !rhs.hasXmlData()) || getXmlData() == rhs.getXmlData()));
}

inline bool trSetDescmoResultInfo::operator != (const trSetDescmoResultInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool trSetDescmoResultInfo::operator < (const trSetDescmoResultInfo& rhs) const {
    if (hasEcuId() || rhs.hasEcuId()) {
        if (getEcuId() < rhs.getEcuId()) return true;
        if (getEcuId() > rhs.getEcuId()) return false;
    }
    if (hasCorrelatorId() || rhs.hasCorrelatorId()) {
        if (getCorrelatorId() < rhs.getCorrelatorId()) return true;
        if (getCorrelatorId() > rhs.getCorrelatorId()) return false;
    }
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    if (hasXmlData() || rhs.hasXmlData()) {
        if (getXmlData() < rhs.getXmlData()) return true;
        if (getXmlData() > rhs.getXmlData()) return false;
    }
    return false;
}

inline bool trSetDescmoResultInfo::operator > (const trSetDescmoResultInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trSetDescmoResultInfo::clear() {
    clearEcuId();
    clearCorrelatorId();
    clearErrorCode();
    clearXmlData();
}

inline void trSetDescmoResultInfo::clearEcuId() {
    if (hasEcuId()) {
         clear_has_ecuId();
        _ecuId = 0u;
     }
}

inline bool trSetDescmoResultInfo::hasEcuId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trSetDescmoResultInfo::getEcuId () const {
    return _ecuId;
}

inline void trSetDescmoResultInfo::setEcuId (uint32 ecuId_) {
    set_has_ecuId();
    this->_ecuId = ecuId_;
}

inline void trSetDescmoResultInfo::clearCorrelatorId() {
    if (hasCorrelatorId()) {
         clear_has_correlatorId();
        _correlatorId = 0u;
     }
}

inline bool trSetDescmoResultInfo::hasCorrelatorId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trSetDescmoResultInfo::getCorrelatorId () const {
    return _correlatorId;
}

inline void trSetDescmoResultInfo::setCorrelatorId (uint32 correlatorId_) {
    set_has_correlatorId();
    this->_correlatorId = correlatorId_;
}

inline void trSetDescmoResultInfo::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_errorCode();
        _errorCode = 0u;
     }
}

inline bool trSetDescmoResultInfo::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 trSetDescmoResultInfo::getErrorCode () const {
    return _errorCode;
}

inline void trSetDescmoResultInfo::setErrorCode (uint32 errorCode_) {
    set_has_errorCode();
    this->_errorCode = errorCode_;
}

inline void trSetDescmoResultInfo::clearXmlData() {
    if (hasXmlData()) {
         clear_has_xmlData();
        _xmlData.clear();
     }
}

inline bool trSetDescmoResultInfo::hasXmlData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& trSetDescmoResultInfo::getXmlData () const {
    return _xmlData;
}

inline ::std::string& trSetDescmoResultInfo::getXmlDataMutable () {
    set_has_xmlData();
    return _xmlData;
}

inline void trSetDescmoResultInfo::setXmlData (const ::std::string& xmlData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData = xmlData_;
}

inline void trSetDescmoResultInfo::setXmlData (const char* xmlData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xmlData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData.assign(xmlData_);
}

inline void trSetDescmoResultInfo::setXmlData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xmlData();
    this->_xmlData.assign(value, size);
}

inline void trSetDescmoResultInfo::set_has_ecuId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trSetDescmoResultInfo::clear_has_ecuId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trSetDescmoResultInfo::set_has_correlatorId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trSetDescmoResultInfo::clear_has_correlatorId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void trSetDescmoResultInfo::set_has_errorCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void trSetDescmoResultInfo::clear_has_errorCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void trSetDescmoResultInfo::set_has_xmlData () {
    _has_bits_[0] |= 1u << 3;
}

inline void trSetDescmoResultInfo::clear_has_xmlData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  trSetDescmoResultResponse::trSetDescmoResultResponse ()  :
    _ecuId (0u),
    _correlatorId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  trSetDescmoResultResponse::trSetDescmoResultResponse (const trSetDescmoResultResponse &rhs)  :
    _ecuId (0u),
    _correlatorId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  trSetDescmoResultResponse::trSetDescmoResultResponse (uint32 ecuId_, uint32 correlatorId_)  :
    _ecuId (ecuId_),
    _correlatorId (correlatorId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  trSetDescmoResultResponse::~trSetDescmoResultResponse() {
}

inline trSetDescmoResultResponse& trSetDescmoResultResponse::operator = (const trSetDescmoResultResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEcuId()) {
            setEcuId(rhs.getEcuId());
        } else {
            clearEcuId();
        }
        if (rhs.hasCorrelatorId()) {
            setCorrelatorId(rhs.getCorrelatorId());
        } else {
            clearCorrelatorId();
        }
    }
    return *this;
}

inline bool trSetDescmoResultResponse::operator == (const trSetDescmoResultResponse& rhs) const {
    return (((!hasEcuId() && !rhs.hasEcuId()) || getEcuId() == rhs.getEcuId()) &&
        ((!hasCorrelatorId() && !rhs.hasCorrelatorId()) || getCorrelatorId() == rhs.getCorrelatorId()));
}

inline bool trSetDescmoResultResponse::operator != (const trSetDescmoResultResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool trSetDescmoResultResponse::operator < (const trSetDescmoResultResponse& rhs) const {
    if (hasEcuId() || rhs.hasEcuId()) {
        if (getEcuId() < rhs.getEcuId()) return true;
        if (getEcuId() > rhs.getEcuId()) return false;
    }
    if (hasCorrelatorId() || rhs.hasCorrelatorId()) {
        if (getCorrelatorId() < rhs.getCorrelatorId()) return true;
        if (getCorrelatorId() > rhs.getCorrelatorId()) return false;
    }
    return false;
}

inline bool trSetDescmoResultResponse::operator > (const trSetDescmoResultResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void trSetDescmoResultResponse::clear() {
    clearEcuId();
    clearCorrelatorId();
}

inline void trSetDescmoResultResponse::clearEcuId() {
    if (hasEcuId()) {
         clear_has_ecuId();
        _ecuId = 0u;
     }
}

inline bool trSetDescmoResultResponse::hasEcuId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 trSetDescmoResultResponse::getEcuId () const {
    return _ecuId;
}

inline void trSetDescmoResultResponse::setEcuId (uint32 ecuId_) {
    set_has_ecuId();
    this->_ecuId = ecuId_;
}

inline void trSetDescmoResultResponse::clearCorrelatorId() {
    if (hasCorrelatorId()) {
         clear_has_correlatorId();
        _correlatorId = 0u;
     }
}

inline bool trSetDescmoResultResponse::hasCorrelatorId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 trSetDescmoResultResponse::getCorrelatorId () const {
    return _correlatorId;
}

inline void trSetDescmoResultResponse::setCorrelatorId (uint32 correlatorId_) {
    set_has_correlatorId();
    this->_correlatorId = correlatorId_;
}

inline void trSetDescmoResultResponse::set_has_ecuId () {
    _has_bits_[0] |= 1u << 0;
}

inline void trSetDescmoResultResponse::clear_has_ecuId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void trSetDescmoResultResponse::set_has_correlatorId () {
    _has_bits_[0] |= 1u << 1;
}

inline void trSetDescmoResultResponse::clear_has_correlatorId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegisterEcuRequest::RegisterEcuRequest ()  :
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterEcuRequest::RegisterEcuRequest (const RegisterEcuRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterEcuRequest::RegisterEcuRequest (const trRegisterEcuInfo& info_)  :
    _info (info_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterEcuRequest::~RegisterEcuRequest() {
}

inline RegisterEcuRequest& RegisterEcuRequest::operator = (const RegisterEcuRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInfo()) {
            setInfo(rhs.getInfo());
        } else {
            clearInfo();
        }
    }
    return *this;
}

inline bool RegisterEcuRequest::operator == (const RegisterEcuRequest& rhs) const {
    return (((!hasInfo() && !rhs.hasInfo()) || getInfo() == rhs.getInfo()));
}

inline bool RegisterEcuRequest::operator != (const RegisterEcuRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterEcuRequest::operator < (const RegisterEcuRequest& rhs) const {
    if (hasInfo() || rhs.hasInfo()) {
        if (getInfo() < rhs.getInfo()) return true;
        if (getInfo() > rhs.getInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterEcuRequest::clone() {
    return new RegisterEcuRequest(*this);
}

inline bool RegisterEcuRequest::operator > (const RegisterEcuRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterEcuRequest::clear() {
    clearInfo();
}

inline void RegisterEcuRequest::clearInfo() {
    if (hasInfo()) {
         clear_has_info();
        _info.clear();
     }
}

inline bool RegisterEcuRequest::hasInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trRegisterEcuInfo& RegisterEcuRequest::getInfo () const {
    return _info;
}

inline trRegisterEcuInfo& RegisterEcuRequest::getInfoMutable () {
    set_has_info();
    return _info;
}

inline void RegisterEcuRequest::setInfo (const trRegisterEcuInfo& info_) {
    set_has_info();
    this->_info = info_;
}

inline void RegisterEcuRequest::set_has_info () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterEcuRequest::clear_has_info () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterEcuResponse::RegisterEcuResponse ()  :
    _response ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterEcuResponse::RegisterEcuResponse (const RegisterEcuResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterEcuResponse::RegisterEcuResponse (const trRegisterEcuResponse& response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterEcuResponse::~RegisterEcuResponse() {
}

inline RegisterEcuResponse& RegisterEcuResponse::operator = (const RegisterEcuResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool RegisterEcuResponse::operator == (const RegisterEcuResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool RegisterEcuResponse::operator != (const RegisterEcuResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterEcuResponse::operator < (const RegisterEcuResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterEcuResponse::clone() {
    return new RegisterEcuResponse(*this);
}

inline bool RegisterEcuResponse::operator > (const RegisterEcuResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterEcuResponse::clear() {
    clearResponse();
}

inline void RegisterEcuResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response.clear();
     }
}

inline bool RegisterEcuResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trRegisterEcuResponse& RegisterEcuResponse::getResponse () const {
    return _response;
}

inline trRegisterEcuResponse& RegisterEcuResponse::getResponseMutable () {
    set_has_response();
    return _response;
}

inline void RegisterEcuResponse::setResponse (const trRegisterEcuResponse& response_) {
    set_has_response();
    this->_response = response_;
}

inline void RegisterEcuResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterEcuResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDescmoResultRequest::SetDescmoResultRequest ()  :
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDescmoResultRequest::SetDescmoResultRequest (const SetDescmoResultRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDescmoResultRequest::SetDescmoResultRequest (const trSetDescmoResultInfo& info_)  :
    _info (info_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDescmoResultRequest::~SetDescmoResultRequest() {
}

inline SetDescmoResultRequest& SetDescmoResultRequest::operator = (const SetDescmoResultRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInfo()) {
            setInfo(rhs.getInfo());
        } else {
            clearInfo();
        }
    }
    return *this;
}

inline bool SetDescmoResultRequest::operator == (const SetDescmoResultRequest& rhs) const {
    return (((!hasInfo() && !rhs.hasInfo()) || getInfo() == rhs.getInfo()));
}

inline bool SetDescmoResultRequest::operator != (const SetDescmoResultRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDescmoResultRequest::operator < (const SetDescmoResultRequest& rhs) const {
    if (hasInfo() || rhs.hasInfo()) {
        if (getInfo() < rhs.getInfo()) return true;
        if (getInfo() > rhs.getInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDescmoResultRequest::clone() {
    return new SetDescmoResultRequest(*this);
}

inline bool SetDescmoResultRequest::operator > (const SetDescmoResultRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDescmoResultRequest::clear() {
    clearInfo();
}

inline void SetDescmoResultRequest::clearInfo() {
    if (hasInfo()) {
         clear_has_info();
        _info.clear();
     }
}

inline bool SetDescmoResultRequest::hasInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trSetDescmoResultInfo& SetDescmoResultRequest::getInfo () const {
    return _info;
}

inline trSetDescmoResultInfo& SetDescmoResultRequest::getInfoMutable () {
    set_has_info();
    return _info;
}

inline void SetDescmoResultRequest::setInfo (const trSetDescmoResultInfo& info_) {
    set_has_info();
    this->_info = info_;
}

inline void SetDescmoResultRequest::set_has_info () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDescmoResultRequest::clear_has_info () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetDescmoResultResponse::SetDescmoResultResponse ()  :
    _response ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetDescmoResultResponse::SetDescmoResultResponse (const SetDescmoResultResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetDescmoResultResponse::SetDescmoResultResponse (const trSetDescmoResultResponse& response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetDescmoResultResponse::~SetDescmoResultResponse() {
}

inline SetDescmoResultResponse& SetDescmoResultResponse::operator = (const SetDescmoResultResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SetDescmoResultResponse::operator == (const SetDescmoResultResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SetDescmoResultResponse::operator != (const SetDescmoResultResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetDescmoResultResponse::operator < (const SetDescmoResultResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetDescmoResultResponse::clone() {
    return new SetDescmoResultResponse(*this);
}

inline bool SetDescmoResultResponse::operator > (const SetDescmoResultResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetDescmoResultResponse::clear() {
    clearResponse();
}

inline void SetDescmoResultResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response.clear();
     }
}

inline bool SetDescmoResultResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trSetDescmoResultResponse& SetDescmoResultResponse::getResponse () const {
    return _response;
}

inline trSetDescmoResultResponse& SetDescmoResultResponse::getResponseMutable () {
    set_has_response();
    return _response;
}

inline void SetDescmoResultResponse::setResponse (const trSetDescmoResultResponse& response_) {
    set_has_response();
    this->_response = response_;
}

inline void SetDescmoResultResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetDescmoResultResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DescmoStateUpdate::DescmoStateUpdate ()  :
    _DescmoState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DescmoStateUpdate::DescmoStateUpdate (const DescmoStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DescmoState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DescmoStateUpdate::DescmoStateUpdate (const trDescmoState& DescmoState_)  :
    _DescmoState (DescmoState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DescmoStateUpdate::~DescmoStateUpdate() {
}

inline DescmoStateUpdate& DescmoStateUpdate::operator = (const DescmoStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDescmoState()) {
            setDescmoState(rhs.getDescmoState());
        } else {
            clearDescmoState();
        }
    }
    return *this;
}

inline bool DescmoStateUpdate::operator == (const DescmoStateUpdate& rhs) const {
    return (((!hasDescmoState() && !rhs.hasDescmoState()) || getDescmoState() == rhs.getDescmoState()));
}

inline bool DescmoStateUpdate::operator != (const DescmoStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DescmoStateUpdate::operator < (const DescmoStateUpdate& rhs) const {
    if (hasDescmoState() || rhs.hasDescmoState()) {
        if (getDescmoState() < rhs.getDescmoState()) return true;
        if (getDescmoState() > rhs.getDescmoState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DescmoStateUpdate::clone() {
    return new DescmoStateUpdate(*this);
}

inline bool DescmoStateUpdate::operator > (const DescmoStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DescmoStateUpdate::clear() {
    clearDescmoState();
}

inline void DescmoStateUpdate::clearDescmoState() {
    if (hasDescmoState()) {
         clear_has_DescmoState();
        _DescmoState.clear();
     }
}

inline bool DescmoStateUpdate::hasDescmoState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const trDescmoState& DescmoStateUpdate::getDescmoState () const {
    return _DescmoState;
}

inline trDescmoState& DescmoStateUpdate::getDescmoStateMutable () {
    set_has_DescmoState();
    return _DescmoState;
}

inline void DescmoStateUpdate::setDescmoState (const trDescmoState& DescmoState_) {
    set_has_DescmoState();
    this->_DescmoState = DescmoState_;
}

inline void DescmoStateUpdate::set_has_DescmoState () {
    _has_bits_[0] |= 1u << 0;
}

inline void DescmoStateUpdate::clear_has_DescmoState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DescmoStateRegister::DescmoStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DescmoStateRegister::DescmoStateRegister (const DescmoStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DescmoStateRegister::~DescmoStateRegister() {
}

inline DescmoStateRegister& DescmoStateRegister::operator = (const DescmoStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DescmoStateRegister::operator == (const DescmoStateRegister& ) const {
    return true;
}

inline bool DescmoStateRegister::operator != (const DescmoStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DescmoStateRegister::operator < (const DescmoStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DescmoStateRegister::clone() {
    return new DescmoStateRegister(*this);
}

inline bool DescmoStateRegister::operator > (const DescmoStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DescmoStateRegister::clear() {
}

} // namespace FcOtaDescmoEcuSrv
} // namespace fcota_descmo_ecu_srv

#endif // FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRV_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
