/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include "org/bosch/cm/navigation/NavigationServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationServiceJson.h"
#include "org/bosch/cm/navigation/NavigationServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationService", NavigationServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 9, "showOnMap", 9 },
    { 12, "setZoomLevel", 21 },
    { 13, "setZoomInStep", 19 },
    { 13, "startGuidance", 24 },
    { 14, "cancelJamAhead", 70 },
    { 14, "insertWaypoint", 30 },
    { 14, "seekTripReplay", 61 },
    { 14, "setZoomOutStep", 20 },
    { 14, "stopTripReplay", 60 },
    { 15, "deleteWaypoints", 33 },
    { 15, "replaceWaypoint", 32 },
    { 15, "sdsCheckAddress", 44 },
    { 15, "setMapLightMode", 58 },
    { 15, "startTripReplay", 59 },
    { 16, "getVersionString", 22 },
    { 16, "setVoiceGuidance", 54 },
    { 17, "sdsUpdateVoiceTag", 56 },
    { 17, "setRouteCriterion", 53 },
    { 17, "setTripReplayMode", 62 },
    { 17, "showCalculateTour", 8 },
    { 17, "speakSamplePhrase", 52 },
    { 18, "showWhereAmIScreen", 14 },
    { 19, "cancelRouteGuidance", 29 },
    { 19, "releaseJamAheadList", 66 },
    { 19, "requestJamAheadList", 65 },
    { 19, "requestWaypointList", 35 },
    { 19, "selectSdsRefinement", 46 },
    { 20, "sdsGetRefinementList", 45 },
    { 20, "setMapRepresentation", 49 },
    { 21, "activateNonPremiumTMC", 68 },
    { 21, "showTrafficInfoScreen", 15 },
    { 22, "setLocationWithDetails", 3 },
    { 22, "showPOILocationFromTCU", 4 },
    { 23, "applyWaypointListChange", 34 },
    { 23, "deactivateNonPremiumTMC", 69 },
    { 23, "getPoiCategoryShortcuts", 1 },
    { 23, "retriggerAcousticOutput", 51 },
    { 23, "selectJamAheadListEntry", 67 },
    { 23, "setLocationWithSdsInput", 47 },
    { 23, "showCarsorLocationOnMap", 10 },
    { 23, "startGuidanceToPosWGS84", 25 },
    { 24, "sdsGetHouseNumberPattern", 57 },
    { 25, "CheckNavDataCompatibility", 55 },
    { 25, "selectPoiCategoryShortcut", 0 },
    { 26, "setLocationWithCoordinates", 2 },
    { 26, "storeLocationToAddressBook", 6 },
    { 27, "showMapScreenCarsorLockMode", 17 },
    { 27, "startGuidanceToHomeLocation", 26 },
    { 27, "startGuidanceToWorkLocation", 27 },
    { 28, "requestFreeTextSearchResults", 37 },
    { 28, "requestSetFreeTextSearchType", 36 },
    { 28, "showDeleteWaypointListScreen", 18 },
    { 28, "showMapScreenWithMapViewMode", 16 },
    { 29, "showAndSetLocationWithDetails", 72 },
    { 29, "storePOILocationToAddressBook", 5 },
    { 30, "showDestinationOverviewFromTCU", 7 },
    { 31, "insertWaypointAtDefaultPosition", 31 },
    { 31, "requestDestinationMemoryEntries", 48 },
    { 31, "showAdjustCurrentLocationScreen", 13 },
    { 33, "requestDetailsForSelectedLocation", 50 },
    { 33, "showRouteCalculationToDestination", 64 },
    { 34, "setLocationWithFreeTextSearchInput", 39 },
    { 34, "setSXMTravelLinkSubscriptionStatus", 23 },
    { 34, "showCityInputAndGetCityCoordinates", 11 },
    { 34, "showDestinationFreeTextSearchInput", 40 },
    { 34, "undoFreeTextSearchElementSelection", 38 },
    { 36, "requestFixedPOICategorySearchResults", 41 },
    { 36, "requestLocationDetailsForCoordinates", 12 },
    { 36, "setLocationWithFixedPOICategoryInput", 43 },
    { 37, "setLocationWithDestinationMemoryEntry", 28 },
    { 40, "undoSetLocationWithFixedPOICategoryInput", 42 },
    { 41, "showLocationSelectionAndGetAddressDetails", 63 },
    { 45, "requestDetailsForSelectedCoordinateWithRadius", 71 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 9, "etcStatus", 38 },
    { 9, "navStatus", 0 },
    { 10, "speedLimit", 22 },
    { 12, "barGraphInfo", 10 },
    { 12, "homeLocation", 15 },
    { 12, "jamAheadList", 44 },
    { 12, "maneuverView", 20 },
    { 12, "turntoStreet", 7 },
    { 12, "waypointList", 19 },
    { 12, "workLocation", 16 },
    { 13, "currentStreet", 6 },
    { 13, "mapCameraData", 48 },
    { 13, "satelliteInfo", 12 },
    { 14, "datasetVersion", 1 },
    { 14, "maneuverSymbol", 11 },
    { 15, "intersectionMap", 27 },
    { 15, "lightModeStatus", 47 },
    { 16, "nextTurntoStreet", 9 },
    { 17, "mapRepresentation", 17 },
    { 18, "trafficEnforcement", 23 },
    { 19, "nextManeuverDetails", 24 },
    { 19, "nonPremiumTMCStatus", 2 },
    { 19, "positionInformation", 4 },
    { 20, "isAddressBookChanged", 28 },
    { 20, "roundaboutExitNumber", 8 },
    { 20, "trafficMessagesCount", 33 },
    { 20, "tripReplayStatusInfo", 37 },
    { 21, "TrafficSignInfoActive", 39 },
    { 21, "distanceToDestination", 5 },
    { 21, "isVoiceGuidanceActive", 31 },
    { 21, "sdsAddressWithOptions", 18 },
    { 22, "arrivalInformationList", 26 },
    { 22, "destinationInformation", 13 },
    { 22, "laneRecommendationList", 25 },
    { 22, "sdsVoiceTagWithOptions", 32 },
    { 23, "sdsPOICategoryShortcuts", 35 },
    { 24, "destinationReachedStatus", 46 },
    { 24, "menuPoiCategoryShortcuts", 36 },
    { 24, "routeCalculationDuration", 14 },
    { 24, "routeRecalculationReason", 41 },
    { 25, "RiskAreaDisplayInfoActive", 42 },
    { 25, "currentFreeTextSearchInfo", 3 },
    { 27, "waypointOperationStatusList", 45 },
    { 28, "RiskAreaSoundAlertInfoActive", 43 },
    { 28, "isLastDestinationListChanged", 30 },
    { 29, "OverSpeedSoundAlertInfoActive", 40 },
    { 29, "intersectionMapCarsorPosition", 21 },
    { 29, "trafficServiceReceptionStatus", 34 },
    { 36, "isMaxAllowedAddressBookEntriesStored", 29 },
};

class NavigationServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NavigationServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NavigationServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NavigationServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.navigation.NavigationService"),
          _logger(logger) {}

    virtual ~NavigationServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NavigationServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 73, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'selectPoiCategoryShortcut'

            LOG_DEBUG_STUB("process method '%s'", "selectPoiCategoryShortcut");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectPoiCategoryShortcutRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SelectPoiCategoryShortcut", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectPoiCategoryShortcutRequest > payload = ::boost::static_pointer_cast<SelectPoiCategoryShortcutRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSelectPoiCategoryShortcutRequest(payload);
            return;
        }
        case 1: {

            // method 'getPoiCategoryShortcuts'

            LOG_DEBUG_STUB("process method '%s'", "getPoiCategoryShortcuts");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPoiCategoryShortcutsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPoiCategoryShortcuts", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPoiCategoryShortcutsRequest > payload = ::boost::static_pointer_cast<GetPoiCategoryShortcutsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onGetPoiCategoryShortcutsRequest(payload);
            return;
        }
        case 2: {

            // method 'setLocationWithCoordinates'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithCoordinates");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithCoordinatesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithCoordinates", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithCoordinatesRequest > payload = ::boost::static_pointer_cast<SetLocationWithCoordinatesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithCoordinatesRequest(payload);
            return;
        }
        case 3: {

            // method 'setLocationWithDetails'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithDetails");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDetailsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithDetails", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithDetailsRequest > payload = ::boost::static_pointer_cast<SetLocationWithDetailsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithDetailsRequest(payload);
            return;
        }
        case 4: {

            // method 'showPOILocationFromTCU'

            LOG_DEBUG_STUB("process method '%s'", "showPOILocationFromTCU");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowPOILocationFromTCURequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowPOILocationFromTCU", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowPOILocationFromTCURequest > payload = ::boost::static_pointer_cast<ShowPOILocationFromTCURequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowPOILocationFromTCURequest(payload);
            return;
        }
        case 5: {

            // method 'storePOILocationToAddressBook'

            LOG_DEBUG_STUB("process method '%s'", "storePOILocationToAddressBook");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StorePOILocationToAddressBookRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StorePOILocationToAddressBook", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StorePOILocationToAddressBookRequest > payload = ::boost::static_pointer_cast<StorePOILocationToAddressBookRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStorePOILocationToAddressBookRequest(payload);
            return;
        }
        case 6: {

            // method 'storeLocationToAddressBook'

            LOG_DEBUG_STUB("process method '%s'", "storeLocationToAddressBook");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreLocationToAddressBookRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StoreLocationToAddressBook", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StoreLocationToAddressBookRequest > payload = ::boost::static_pointer_cast<StoreLocationToAddressBookRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStoreLocationToAddressBookRequest(payload);
            return;
        }
        case 7: {

            // method 'showDestinationOverviewFromTCU'

            LOG_DEBUG_STUB("process method '%s'", "showDestinationOverviewFromTCU");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationOverviewFromTCURequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowDestinationOverviewFromTCU", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowDestinationOverviewFromTCURequest > payload = ::boost::static_pointer_cast<ShowDestinationOverviewFromTCURequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowDestinationOverviewFromTCURequest(payload);
            return;
        }
        case 8: {

            // method 'showCalculateTour'

            LOG_DEBUG_STUB("process method '%s'", "showCalculateTour");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCalculateTourRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowCalculateTour", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowCalculateTourRequest > payload = ::boost::static_pointer_cast<ShowCalculateTourRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowCalculateTourRequest(payload);
            return;
        }
        case 9: {

            // method 'showOnMap'

            LOG_DEBUG_STUB("process method '%s'", "showOnMap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowOnMapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowOnMap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowOnMapRequest > payload = ::boost::static_pointer_cast<ShowOnMapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowOnMapRequest(payload);
            return;
        }
        case 10: {

            // method 'showCarsorLocationOnMap'

            LOG_DEBUG_STUB("process method '%s'", "showCarsorLocationOnMap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCarsorLocationOnMapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowCarsorLocationOnMap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowCarsorLocationOnMapRequest > payload = ::boost::static_pointer_cast<ShowCarsorLocationOnMapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowCarsorLocationOnMapRequest(payload);
            return;
        }
        case 11: {

            // method 'showCityInputAndGetCityCoordinates'

            LOG_DEBUG_STUB("process method '%s'", "showCityInputAndGetCityCoordinates");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCityInputAndGetCityCoordinatesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowCityInputAndGetCityCoordinates", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowCityInputAndGetCityCoordinatesRequest > payload = ::boost::static_pointer_cast<ShowCityInputAndGetCityCoordinatesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowCityInputAndGetCityCoordinatesRequest(payload);
            return;
        }
        case 12: {

            // method 'requestLocationDetailsForCoordinates'

            LOG_DEBUG_STUB("process method '%s'", "requestLocationDetailsForCoordinates");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestLocationDetailsForCoordinatesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestLocationDetailsForCoordinates", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestLocationDetailsForCoordinatesRequest > payload = ::boost::static_pointer_cast<RequestLocationDetailsForCoordinatesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestLocationDetailsForCoordinatesRequest(payload);
            return;
        }
        case 13: {

            // method 'showAdjustCurrentLocationScreen'

            LOG_DEBUG_STUB("process method '%s'", "showAdjustCurrentLocationScreen");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowAdjustCurrentLocationScreenRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowAdjustCurrentLocationScreen", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowAdjustCurrentLocationScreenRequest > payload = ::boost::static_pointer_cast<ShowAdjustCurrentLocationScreenRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowAdjustCurrentLocationScreenRequest(payload);
            return;
        }
        case 14: {

            // method 'showWhereAmIScreen'

            LOG_DEBUG_STUB("process method '%s'", "showWhereAmIScreen");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowWhereAmIScreenRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowWhereAmIScreen", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowWhereAmIScreenRequest > payload = ::boost::static_pointer_cast<ShowWhereAmIScreenRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowWhereAmIScreenRequest(payload);
            return;
        }
        case 15: {

            // method 'showTrafficInfoScreen'

            LOG_DEBUG_STUB("process method '%s'", "showTrafficInfoScreen");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowTrafficInfoScreenRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowTrafficInfoScreen", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowTrafficInfoScreenRequest > payload = ::boost::static_pointer_cast<ShowTrafficInfoScreenRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowTrafficInfoScreenRequest(payload);
            return;
        }
        case 16: {

            // method 'showMapScreenWithMapViewMode'

            LOG_DEBUG_STUB("process method '%s'", "showMapScreenWithMapViewMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenWithMapViewModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowMapScreenWithMapViewMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowMapScreenWithMapViewModeRequest > payload = ::boost::static_pointer_cast<ShowMapScreenWithMapViewModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowMapScreenWithMapViewModeRequest(payload);
            return;
        }
        case 17: {

            // method 'showMapScreenCarsorLockMode'

            LOG_DEBUG_STUB("process method '%s'", "showMapScreenCarsorLockMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenCarsorLockModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowMapScreenCarsorLockMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowMapScreenCarsorLockModeRequest > payload = ::boost::static_pointer_cast<ShowMapScreenCarsorLockModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowMapScreenCarsorLockModeRequest(payload);
            return;
        }
        case 18: {

            // method 'showDeleteWaypointListScreen'

            LOG_DEBUG_STUB("process method '%s'", "showDeleteWaypointListScreen");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDeleteWaypointListScreenRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowDeleteWaypointListScreen", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowDeleteWaypointListScreenRequest > payload = ::boost::static_pointer_cast<ShowDeleteWaypointListScreenRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowDeleteWaypointListScreenRequest(payload);
            return;
        }
        case 19: {

            // method 'setZoomInStep'

            LOG_DEBUG_STUB("process method '%s'", "setZoomInStep");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomInStepRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetZoomInStep", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetZoomInStepRequest > payload = ::boost::static_pointer_cast<SetZoomInStepRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetZoomInStepRequest(payload);
            return;
        }
        case 20: {

            // method 'setZoomOutStep'

            LOG_DEBUG_STUB("process method '%s'", "setZoomOutStep");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomOutStepRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetZoomOutStep", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetZoomOutStepRequest > payload = ::boost::static_pointer_cast<SetZoomOutStepRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetZoomOutStepRequest(payload);
            return;
        }
        case 21: {

            // method 'setZoomLevel'

            LOG_DEBUG_STUB("process method '%s'", "setZoomLevel");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomLevelRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetZoomLevel", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetZoomLevelRequest > payload = ::boost::static_pointer_cast<SetZoomLevelRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetZoomLevelRequest(payload);
            return;
        }
        case 22: {

            // method 'getVersionString'

            LOG_DEBUG_STUB("process method '%s'", "getVersionString");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetVersionStringRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetVersionString", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetVersionStringRequest > payload = ::boost::static_pointer_cast<GetVersionStringRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onGetVersionStringRequest(payload);
            return;
        }
        case 23: {

            // method 'setSXMTravelLinkSubscriptionStatus'

            LOG_DEBUG_STUB("process method '%s'", "setSXMTravelLinkSubscriptionStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSXMTravelLinkSubscriptionStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSXMTravelLinkSubscriptionStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSXMTravelLinkSubscriptionStatusRequest > payload = ::boost::static_pointer_cast<SetSXMTravelLinkSubscriptionStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetSXMTravelLinkSubscriptionStatusRequest(payload);
            return;
        }
        case 24: {

            // method 'startGuidance'

            LOG_DEBUG_STUB("process method '%s'", "startGuidance");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartGuidance", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartGuidanceRequest > payload = ::boost::static_pointer_cast<StartGuidanceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStartGuidanceRequest(payload);
            return;
        }
        case 25: {

            // method 'startGuidanceToPosWGS84'

            LOG_DEBUG_STUB("process method '%s'", "startGuidanceToPosWGS84");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToPosWGS84Request);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartGuidanceToPosWGS84", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartGuidanceToPosWGS84Request > payload = ::boost::static_pointer_cast<StartGuidanceToPosWGS84Request>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStartGuidanceToPosWGS84Request(payload);
            return;
        }
        case 26: {

            // method 'startGuidanceToHomeLocation'

            LOG_DEBUG_STUB("process method '%s'", "startGuidanceToHomeLocation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToHomeLocationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartGuidanceToHomeLocation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartGuidanceToHomeLocationRequest > payload = ::boost::static_pointer_cast<StartGuidanceToHomeLocationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStartGuidanceToHomeLocationRequest(payload);
            return;
        }
        case 27: {

            // method 'startGuidanceToWorkLocation'

            LOG_DEBUG_STUB("process method '%s'", "startGuidanceToWorkLocation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToWorkLocationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartGuidanceToWorkLocation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartGuidanceToWorkLocationRequest > payload = ::boost::static_pointer_cast<StartGuidanceToWorkLocationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStartGuidanceToWorkLocationRequest(payload);
            return;
        }
        case 28: {

            // method 'setLocationWithDestinationMemoryEntry'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithDestinationMemoryEntry");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDestinationMemoryEntryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithDestinationMemoryEntry", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithDestinationMemoryEntryRequest > payload = ::boost::static_pointer_cast<SetLocationWithDestinationMemoryEntryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithDestinationMemoryEntryRequest(payload);
            return;
        }
        case 29: {

            // method 'cancelRouteGuidance'

            LOG_DEBUG_STUB("process method '%s'", "cancelRouteGuidance");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRouteGuidanceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelRouteGuidance", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRouteGuidanceRequest > payload = ::boost::static_pointer_cast<CancelRouteGuidanceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onCancelRouteGuidanceRequest(payload);
            return;
        }
        case 30: {

            // method 'insertWaypoint'

            LOG_DEBUG_STUB("process method '%s'", "insertWaypoint");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "InsertWaypoint", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< InsertWaypointRequest > payload = ::boost::static_pointer_cast<InsertWaypointRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onInsertWaypointRequest(payload);
            return;
        }
        case 31: {

            // method 'insertWaypointAtDefaultPosition'

            LOG_DEBUG_STUB("process method '%s'", "insertWaypointAtDefaultPosition");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointAtDefaultPositionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "InsertWaypointAtDefaultPosition", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< InsertWaypointAtDefaultPositionRequest > payload = ::boost::static_pointer_cast<InsertWaypointAtDefaultPositionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onInsertWaypointAtDefaultPositionRequest(payload);
            return;
        }
        case 32: {

            // method 'replaceWaypoint'

            LOG_DEBUG_STUB("process method '%s'", "replaceWaypoint");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReplaceWaypointRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReplaceWaypoint", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReplaceWaypointRequest > payload = ::boost::static_pointer_cast<ReplaceWaypointRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onReplaceWaypointRequest(payload);
            return;
        }
        case 33: {

            // method 'deleteWaypoints'

            LOG_DEBUG_STUB("process method '%s'", "deleteWaypoints");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteWaypointsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeleteWaypoints", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeleteWaypointsRequest > payload = ::boost::static_pointer_cast<DeleteWaypointsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onDeleteWaypointsRequest(payload);
            return;
        }
        case 34: {

            // method 'applyWaypointListChange'

            LOG_DEBUG_STUB("process method '%s'", "applyWaypointListChange");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyWaypointListChangeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ApplyWaypointListChange", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ApplyWaypointListChangeRequest > payload = ::boost::static_pointer_cast<ApplyWaypointListChangeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onApplyWaypointListChangeRequest(payload);
            return;
        }
        case 35: {

            // method 'requestWaypointList'

            LOG_DEBUG_STUB("process method '%s'", "requestWaypointList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestWaypointListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestWaypointList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestWaypointListRequest > payload = ::boost::static_pointer_cast<RequestWaypointListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestWaypointListRequest(payload);
            return;
        }
        case 36: {

            // method 'requestSetFreeTextSearchType'

            LOG_DEBUG_STUB("process method '%s'", "requestSetFreeTextSearchType");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestSetFreeTextSearchTypeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestSetFreeTextSearchType", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestSetFreeTextSearchTypeRequest > payload = ::boost::static_pointer_cast<RequestSetFreeTextSearchTypeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestSetFreeTextSearchTypeRequest(payload);
            return;
        }
        case 37: {

            // method 'requestFreeTextSearchResults'

            LOG_DEBUG_STUB("process method '%s'", "requestFreeTextSearchResults");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestFreeTextSearchResultsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestFreeTextSearchResults", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestFreeTextSearchResultsRequest > payload = ::boost::static_pointer_cast<RequestFreeTextSearchResultsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestFreeTextSearchResultsRequest(payload);
            return;
        }
        case 38: {

            // method 'undoFreeTextSearchElementSelection'

            LOG_DEBUG_STUB("process method '%s'", "undoFreeTextSearchElementSelection");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UndoFreeTextSearchElementSelectionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UndoFreeTextSearchElementSelection", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UndoFreeTextSearchElementSelectionRequest > payload = ::boost::static_pointer_cast<UndoFreeTextSearchElementSelectionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onUndoFreeTextSearchElementSelectionRequest(payload);
            return;
        }
        case 39: {

            // method 'setLocationWithFreeTextSearchInput'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithFreeTextSearchInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFreeTextSearchInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithFreeTextSearchInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithFreeTextSearchInputRequest > payload = ::boost::static_pointer_cast<SetLocationWithFreeTextSearchInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithFreeTextSearchInputRequest(payload);
            return;
        }
        case 40: {

            // method 'showDestinationFreeTextSearchInput'

            LOG_DEBUG_STUB("process method '%s'", "showDestinationFreeTextSearchInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationFreeTextSearchInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowDestinationFreeTextSearchInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowDestinationFreeTextSearchInputRequest > payload = ::boost::static_pointer_cast<ShowDestinationFreeTextSearchInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowDestinationFreeTextSearchInputRequest(payload);
            return;
        }
        case 41: {

            // method 'requestFixedPOICategorySearchResults'

            LOG_DEBUG_STUB("process method '%s'", "requestFixedPOICategorySearchResults");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestFixedPOICategorySearchResultsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestFixedPOICategorySearchResults", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestFixedPOICategorySearchResultsRequest > payload = ::boost::static_pointer_cast<RequestFixedPOICategorySearchResultsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestFixedPOICategorySearchResultsRequest(payload);
            return;
        }
        case 42: {

            // method 'undoSetLocationWithFixedPOICategoryInput'

            LOG_DEBUG_STUB("process method '%s'", "undoSetLocationWithFixedPOICategoryInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UndoSetLocationWithFixedPOICategoryInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UndoSetLocationWithFixedPOICategoryInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UndoSetLocationWithFixedPOICategoryInputRequest > payload = ::boost::static_pointer_cast<UndoSetLocationWithFixedPOICategoryInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onUndoSetLocationWithFixedPOICategoryInputRequest(payload);
            return;
        }
        case 43: {

            // method 'setLocationWithFixedPOICategoryInput'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithFixedPOICategoryInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFixedPOICategoryInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithFixedPOICategoryInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithFixedPOICategoryInputRequest > payload = ::boost::static_pointer_cast<SetLocationWithFixedPOICategoryInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithFixedPOICategoryInputRequest(payload);
            return;
        }
        case 44: {

            // method 'sdsCheckAddress'

            LOG_DEBUG_STUB("process method '%s'", "sdsCheckAddress");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsCheckAddress", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsCheckAddressRequest > payload = ::boost::static_pointer_cast<SdsCheckAddressRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSdsCheckAddressRequest(payload);
            return;
        }
        case 45: {

            // method 'sdsGetRefinementList'

            LOG_DEBUG_STUB("process method '%s'", "sdsGetRefinementList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsGetRefinementList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsGetRefinementListRequest > payload = ::boost::static_pointer_cast<SdsGetRefinementListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSdsGetRefinementListRequest(payload);
            return;
        }
        case 46: {

            // method 'selectSdsRefinement'

            LOG_DEBUG_STUB("process method '%s'", "selectSdsRefinement");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SelectSdsRefinement", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectSdsRefinementRequest > payload = ::boost::static_pointer_cast<SelectSdsRefinementRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSelectSdsRefinementRequest(payload);
            return;
        }
        case 47: {

            // method 'setLocationWithSdsInput'

            LOG_DEBUG_STUB("process method '%s'", "setLocationWithSdsInput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLocationWithSdsInput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLocationWithSdsInputRequest > payload = ::boost::static_pointer_cast<SetLocationWithSdsInputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetLocationWithSdsInputRequest(payload);
            return;
        }
        case 48: {

            // method 'requestDestinationMemoryEntries'

            LOG_DEBUG_STUB("process method '%s'", "requestDestinationMemoryEntries");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDestinationMemoryEntriesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestDestinationMemoryEntries", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestDestinationMemoryEntriesRequest > payload = ::boost::static_pointer_cast<RequestDestinationMemoryEntriesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestDestinationMemoryEntriesRequest(payload);
            return;
        }
        case 49: {

            // method 'setMapRepresentation'

            LOG_DEBUG_STUB("process method '%s'", "setMapRepresentation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMapRepresentationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMapRepresentation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMapRepresentationRequest > payload = ::boost::static_pointer_cast<SetMapRepresentationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetMapRepresentationRequest(payload);
            return;
        }
        case 50: {

            // method 'requestDetailsForSelectedLocation'

            LOG_DEBUG_STUB("process method '%s'", "requestDetailsForSelectedLocation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedLocationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestDetailsForSelectedLocation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestDetailsForSelectedLocationRequest > payload = ::boost::static_pointer_cast<RequestDetailsForSelectedLocationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestDetailsForSelectedLocationRequest(payload);
            return;
        }
        case 51: {

            // method 'retriggerAcousticOutput'

            LOG_DEBUG_STUB("process method '%s'", "retriggerAcousticOutput");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RetriggerAcousticOutputRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RetriggerAcousticOutput", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RetriggerAcousticOutputRequest > payload = ::boost::static_pointer_cast<RetriggerAcousticOutputRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRetriggerAcousticOutputRequest(payload);
            return;
        }
        case 52: {

            // method 'speakSamplePhrase'

            LOG_DEBUG_STUB("process method '%s'", "speakSamplePhrase");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeakSamplePhraseRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SpeakSamplePhrase", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SpeakSamplePhraseRequest > payload = ::boost::static_pointer_cast<SpeakSamplePhraseRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSpeakSamplePhraseRequest(payload);
            return;
        }
        case 53: {

            // method 'setRouteCriterion'

            LOG_DEBUG_STUB("process method '%s'", "setRouteCriterion");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRouteCriterionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetRouteCriterion", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRouteCriterionRequest > payload = ::boost::static_pointer_cast<SetRouteCriterionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetRouteCriterionRequest(payload);
            return;
        }
        case 54: {

            // method 'setVoiceGuidance'

            LOG_DEBUG_STUB("process method '%s'", "setVoiceGuidance");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVoiceGuidanceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetVoiceGuidance", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetVoiceGuidanceRequest > payload = ::boost::static_pointer_cast<SetVoiceGuidanceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetVoiceGuidanceRequest(payload);
            return;
        }
        case 55: {

            // method 'CheckNavDataCompatibility'

            LOG_DEBUG_STUB("process method '%s'", "CheckNavDataCompatibility");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckNavDataCompatibilityRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CheckNavDataCompatibility", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CheckNavDataCompatibilityRequest > payload = ::boost::static_pointer_cast<CheckNavDataCompatibilityRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onCheckNavDataCompatibilityRequest(payload);
            return;
        }
        case 56: {

            // method 'sdsUpdateVoiceTag'

            LOG_DEBUG_STUB("process method '%s'", "sdsUpdateVoiceTag");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsUpdateVoiceTag", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsUpdateVoiceTagRequest > payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSdsUpdateVoiceTagRequest(payload);
            return;
        }
        case 57: {

            // method 'sdsGetHouseNumberPattern'

            LOG_DEBUG_STUB("process method '%s'", "sdsGetHouseNumberPattern");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SdsGetHouseNumberPattern", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SdsGetHouseNumberPatternRequest > payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSdsGetHouseNumberPatternRequest(payload);
            return;
        }
        case 58: {

            // method 'setMapLightMode'

            LOG_DEBUG_STUB("process method '%s'", "setMapLightMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMapLightModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMapLightMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMapLightModeRequest > payload = ::boost::static_pointer_cast<SetMapLightModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetMapLightModeRequest(payload);
            return;
        }
        case 59: {

            // method 'startTripReplay'

            LOG_DEBUG_STUB("process method '%s'", "startTripReplay");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartTripReplayRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartTripReplay", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartTripReplayRequest > payload = ::boost::static_pointer_cast<StartTripReplayRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStartTripReplayRequest(payload);
            return;
        }
        case 60: {

            // method 'stopTripReplay'

            LOG_DEBUG_STUB("process method '%s'", "stopTripReplay");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopTripReplayRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopTripReplay", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopTripReplayRequest > payload = ::boost::static_pointer_cast<StopTripReplayRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onStopTripReplayRequest(payload);
            return;
        }
        case 61: {

            // method 'seekTripReplay'

            LOG_DEBUG_STUB("process method '%s'", "seekTripReplay");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SeekTripReplayRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SeekTripReplay", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SeekTripReplayRequest > payload = ::boost::static_pointer_cast<SeekTripReplayRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSeekTripReplayRequest(payload);
            return;
        }
        case 62: {

            // method 'setTripReplayMode'

            LOG_DEBUG_STUB("process method '%s'", "setTripReplayMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetTripReplayModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetTripReplayMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetTripReplayModeRequest > payload = ::boost::static_pointer_cast<SetTripReplayModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSetTripReplayModeRequest(payload);
            return;
        }
        case 63: {

            // method 'showLocationSelectionAndGetAddressDetails'

            LOG_DEBUG_STUB("process method '%s'", "showLocationSelectionAndGetAddressDetails");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowLocationSelectionAndGetAddressDetailsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowLocationSelectionAndGetAddressDetails", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowLocationSelectionAndGetAddressDetailsRequest > payload = ::boost::static_pointer_cast<ShowLocationSelectionAndGetAddressDetailsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowLocationSelectionAndGetAddressDetailsRequest(payload);
            return;
        }
        case 64: {

            // method 'showRouteCalculationToDestination'

            LOG_DEBUG_STUB("process method '%s'", "showRouteCalculationToDestination");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowRouteCalculationToDestinationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowRouteCalculationToDestination", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowRouteCalculationToDestinationRequest > payload = ::boost::static_pointer_cast<ShowRouteCalculationToDestinationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowRouteCalculationToDestinationRequest(payload);
            return;
        }
        case 65: {

            // method 'requestJamAheadList'

            LOG_DEBUG_STUB("process method '%s'", "requestJamAheadList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestJamAheadListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestJamAheadList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestJamAheadListRequest > payload = ::boost::static_pointer_cast<RequestJamAheadListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestJamAheadListRequest(payload);
            return;
        }
        case 66: {

            // method 'releaseJamAheadList'

            LOG_DEBUG_STUB("process method '%s'", "releaseJamAheadList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseJamAheadListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReleaseJamAheadList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseJamAheadListRequest > payload = ::boost::static_pointer_cast<ReleaseJamAheadListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onReleaseJamAheadListRequest(payload);
            return;
        }
        case 67: {

            // method 'selectJamAheadListEntry'

            LOG_DEBUG_STUB("process method '%s'", "selectJamAheadListEntry");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectJamAheadListEntryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SelectJamAheadListEntry", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectJamAheadListEntryRequest > payload = ::boost::static_pointer_cast<SelectJamAheadListEntryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onSelectJamAheadListEntryRequest(payload);
            return;
        }
        case 68: {

            // method 'activateNonPremiumTMC'

            LOG_DEBUG_STUB("process method '%s'", "activateNonPremiumTMC");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateNonPremiumTMCRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ActivateNonPremiumTMC", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActivateNonPremiumTMCRequest > payload = ::boost::static_pointer_cast<ActivateNonPremiumTMCRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onActivateNonPremiumTMCRequest(payload);
            return;
        }
        case 69: {

            // method 'deactivateNonPremiumTMC'

            LOG_DEBUG_STUB("process method '%s'", "deactivateNonPremiumTMC");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateNonPremiumTMCRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeactivateNonPremiumTMC", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeactivateNonPremiumTMCRequest > payload = ::boost::static_pointer_cast<DeactivateNonPremiumTMCRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onDeactivateNonPremiumTMCRequest(payload);
            return;
        }
        case 70: {

            // method 'cancelJamAhead'

            LOG_DEBUG_STUB("process method '%s'", "cancelJamAhead");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelJamAheadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelJamAhead", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelJamAheadRequest > payload = ::boost::static_pointer_cast<CancelJamAheadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onCancelJamAheadRequest(payload);
            return;
        }
        case 71: {

            // method 'requestDetailsForSelectedCoordinateWithRadius'

            LOG_DEBUG_STUB("process method '%s'", "requestDetailsForSelectedCoordinateWithRadius");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedCoordinateWithRadiusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestDetailsForSelectedCoordinateWithRadius", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestDetailsForSelectedCoordinateWithRadiusRequest > payload = ::boost::static_pointer_cast<RequestDetailsForSelectedCoordinateWithRadiusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onRequestDetailsForSelectedCoordinateWithRadiusRequest(payload);
            return;
        }
        case 72: {

            // method 'showAndSetLocationWithDetails'

            LOG_DEBUG_STUB("process method '%s'", "showAndSetLocationWithDetails");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowAndSetLocationWithDetailsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowAndSetLocationWithDetails", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowAndSetLocationWithDetailsRequest > payload = ::boost::static_pointer_cast<ShowAndSetLocationWithDetailsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NavigationServiceStub*>(getStub())->onShowAndSetLocationWithDetailsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NavigationServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.navigation.NavigationService\">\n"
            "    <property access=\"read\" name=\"navStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"datasetVersion\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"nonPremiumTMCStatus\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"currentFreeTextSearchInfo\" type=\"((dd)s)\"/>\n"
            "    <property access=\"read\" name=\"positionInformation\" type=\"((dd)dssuddissssss)\"/>\n"
            "    <property access=\"read\" name=\"distanceToDestination\" type=\"(suu)\"/>\n"
            "    <property access=\"read\" name=\"currentStreet\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"turntoStreet\" type=\"(us)\"/>\n"
            "    <property access=\"read\" name=\"roundaboutExitNumber\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"nextTurntoStreet\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"barGraphInfo\" type=\"(bqquss)\"/>\n"
            "    <property access=\"read\" name=\"maneuverSymbol\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"satelliteInfo\" type=\"(yyysqy(dd))\"/>\n"
            "    <property access=\"read\" name=\"destinationInformation\" type=\"a((dd)sss)\"/>\n"
            "    <property access=\"readwrite\" name=\"routeCalculationDuration\" type=\"(uu)\"/>\n"
            "    <property access=\"read\" name=\"homeLocation\" type=\"(s(dd)b)\"/>\n"
            "    <property access=\"read\" name=\"workLocation\" type=\"(s(dd)b)\"/>\n"
            "    <property access=\"read\" name=\"mapRepresentation\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"sdsAddressWithOptions\" type=\"(a(us(b))(bbbbbb)au)\"/>\n"
            "    <property access=\"read\" name=\"waypointList\" type=\"a((dd)us)\"/>\n"
            "    <property access=\"read\" name=\"maneuverView\" type=\"(uu(buu))\"/>\n"
            "    <property access=\"read\" name=\"intersectionMapCarsorPosition\" type=\"(uu(uu)i)\"/>\n"
            "    <property access=\"read\" name=\"speedLimit\" type=\"(bsqu)\"/>\n"
            "    <property access=\"readwrite\" name=\"trafficEnforcement\" type=\"(uusuuu)\"/>\n"
            "    <property access=\"read\" name=\"nextManeuverDetails\" type=\"(suubb)\"/>\n"
            "    <property access=\"read\" name=\"laneRecommendationList\" type=\"a(uii)\"/>\n"
            "    <property access=\"read\" name=\"arrivalInformationList\" type=\"a((suu)sisiiuuuiuus)\"/>\n"
            "    <property access=\"read\" name=\"intersectionMap\" type=\"(ua(a(uu)u)a(a(uu)u)a(uu))\"/>\n"
            "    <property access=\"read\" name=\"isAddressBookChanged\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"isMaxAllowedAddressBookEntriesStored\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"isLastDestinationListChanged\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"isVoiceGuidanceActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"sdsVoiceTagWithOptions\" type=\"(tsuu)\"/>\n"
            "    <property access=\"readwrite\" name=\"trafficMessagesCount\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"trafficServiceReceptionStatus\" type=\"(sbuuu)\"/>\n"
            "    <property access=\"read\" name=\"sdsPOICategoryShortcuts\" type=\"a(su(ayu)y((nin)ub))\"/>\n"
            "    <property access=\"read\" name=\"menuPoiCategoryShortcuts\" type=\"a(su(ayu)y((nin)ub))\"/>\n"
            "    <property access=\"read\" name=\"tripReplayStatusInfo\" type=\"(ubsyyyy)\"/>\n"
            "    <property access=\"read\" name=\"etcStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"TrafficSignInfoActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"OverSpeedSoundAlertInfoActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"routeRecalculationReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"RiskAreaDisplayInfoActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"RiskAreaSoundAlertInfoActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"jamAheadList\" type=\"(ua(ssub))\"/>\n"
            "    <property access=\"read\" name=\"waypointOperationStatusList\" type=\"au\"/>\n"
            "    <property access=\"read\" name=\"destinationReachedStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"lightModeStatus\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"mapCameraData\" type=\"(qsd)\"/>\n"
            "    <method name=\"selectPoiCategoryShortcut\">\n"
            "      <doc>\n"
            "        <line>selectPoiCategoryShortcut = Request to show the nearby POI category</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"shortcutIndex\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>shortcutIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getPoiCategoryShortcuts\">\n"
            "      <doc>\n"
            "        <line>getPoiCategoryShortcuts = Returns the customized preferred category shortcuts</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"poiCategoryShortcuts\" type=\"a(su(ayu)y((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>poiCategoryShortcuts = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithCoordinates\">\n"
            "      <doc>\n"
            "        <line>setLocationWithCoordinates = Request to set the latitude and longitude value</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithDetails\">\n"
            "      <doc>\n"
            "        <line>setLocationWithDetails = Request to set the latitude and longitude value and location details for further processing</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"((s(dd)b)ss(ayu))\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showPOILocationFromTCU\">\n"
            "      <doc>\n"
            "        <line>showPOILocationFromTCU = Request will provide the &quot;Show POI location&quot; from TCU</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"poiLocations\" type=\"a((s(dd)b)ss(ayu))\">\n"
            "        <doc>\n"
            "          <line>poiLocations = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"storePOILocationToAddressBook\">\n"
            "      <doc>\n"
            "        <line>storePOILocationToAddressBook = Request to store POI location to navigation address book</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"poiLocation\" type=\"((s(dd)b)ss(ayu))\">\n"
            "        <doc>\n"
            "          <line>poiLocation = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"storeLocationToAddressBook\">\n"
            "      <doc>\n"
            "        <line>storeLocationToAddressBook = Request to store location to navigation address book</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"(s(dd)b)\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showDestinationOverviewFromTCU\">\n"
            "      <doc>\n"
            "        <line>showDestinationOverviewFromTCU = Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"currentPosition\" type=\"(s(dd)b)\">\n"
            "        <doc>\n"
            "          <line>currentPosition = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"destination\" type=\"(s(dd)b)\">\n"
            "        <doc>\n"
            "          <line>destination = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showCalculateTour\">\n"
            "      <doc>\n"
            "        <line>showCalculateTour = Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"tour\" type=\"a(((s(dd)b)ss(ayu))bu)\">\n"
            "        <doc>\n"
            "          <line>tour = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"screenTransition\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenTransition (of type ScreenTransition) = switches the screen to different screens based on enum value</line>\n"
            "          <line>enum[ROUTE_INFO_SCREEN (1), MAIN_MAP_SCREEN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showOnMap\">\n"
            "      <doc>\n"
            "        <line>showOnMap = Request shows the given location on map</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showCarsorLocationOnMap\">\n"
            "      <doc>\n"
            "        <line>showCarsorLocationOnMap = Request shows the carsor Location on map</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"showCityInputAndGetCityCoordinates\">\n"
            "      <doc>\n"
            "        <line>showCityInputAndGetCityCoordinates = Request will respond with City center coordinates</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"cityCenterCoordinate\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>cityCenterCoordinate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"isValidAddress\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>isValidAddress = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"requestLocationDetailsForCoordinates\">\n"
            "      <doc>\n"
            "        <line>requestLocationDetailsForCoordinates = Request will respond with location details belonging to given lat/long coordinates</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"cityCoordinate\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>cityCoordinate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"locationDetails\" type=\"(sssssssss(dd))\">\n"
            "        <doc>\n"
            "          <line>locationDetails (of type LocationDetails) = Description missing</line>\n"
            "          <line>LocationDetails struct[cityName, countryName, countryCode, stateName, stateCode, phoneNumber, poiAddress, streetName, zipCode, coordinate] = struct contain location details of the requested location</line>\n"
            "          <line>0: LocationDetails.cityName ('s') = String cityName contain city name</line>\n"
            "          <line>1: LocationDetails.countryName ('s') = String countryName contain country full name</line>\n"
            "          <line>2: LocationDetails.countryCode ('s') = String countryCode contain country short name</line>\n"
            "          <line>3: LocationDetails.stateName ('s') = String stateName contain state full name</line>\n"
            "          <line>4: LocationDetails.stateCode ('s') = String stateCode contain state short name</line>\n"
            "          <line>5: LocationDetails.phoneNumber ('s') = String phoneNumber contains phone number</line>\n"
            "          <line>6: LocationDetails.poiAddress ('s') = String poiAddress contains poi address</line>\n"
            "          <line>7: LocationDetails.streetName ('s') = String streetName contains street name</line>\n"
            "          <line>8: LocationDetails.zipCode ('s') = String zipCode contains ZIP code</line>\n"
            "          <line>9: LocationDetails.coordinate ('?') = coordinate contains location's Latitude and Longitude information. (0.0,0.0) means its Invalid data</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showAdjustCurrentLocationScreen\">\n"
            "      <doc>\n"
            "        <line>showAdjustCurrentLocationScreen = Method shows the screen to adjust the current location</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"showWhereAmIScreen\">\n"
            "      <doc>\n"
            "        <line>showWhereAmIScreen = method to show the current position</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"showTrafficInfoScreen\">\n"
            "      <doc>\n"
            "        <line>showTrafficInfoScreen = method to handle traffic data validation to show error pop up or traffic info screen</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"showMapScreenWithMapViewMode\">\n"
            "      <doc>\n"
            "        <line>showMapScreenWithMapViewMode = Request to show map screen with the given settings for MapViewMode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"MapViewMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>MapViewMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showMapScreenCarsorLockMode\">\n"
            "      <doc>\n"
            "        <line>showMapScreenCarsorLockMode = Request to show map screen with carsor locked mode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mapCameraMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>mapCameraMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showDeleteWaypointListScreen\">\n"
            "      <doc>\n"
            "        <line>showDeleteWaypointListScreen = Method shows the screen to modify  waypoint list</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"setZoomInStep\">\n"
            "      <doc>\n"
            "        <line>setZoomInStep = Request to zoom in the given step count</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"zoomInStep\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>zoomInStep = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setZoomOutStep\">\n"
            "      <doc>\n"
            "        <line>setZoomOutStep = Request to zoom out the given step count</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"zoomOutStep\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>zoomOutStep = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setZoomLevel\">\n"
            "      <doc>\n"
            "        <line>setZoomLevel = Request zooms to the given zoom level</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"zoomLevel\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>zoomLevel = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getVersionString\">\n"
            "      <doc>\n"
            "        <line>getVersionString = Request will respond with the current NavMiddleware version string</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"versionString\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>versionString = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setSXMTravelLinkSubscriptionStatus\">\n"
            "      <doc>\n"
            "        <line>setSXMTravelLinkSubscriptionStatus = Request will set the SXM travel link subscription status</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"startGuidance\">\n"
            "      <doc>\n"
            "        <line>startGuidance = method to start the guidance with the current LI / SDS destination</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"startGuidanceToPosWGS84\">\n"
            "      <doc>\n"
            "        <line>startGuidanceToPosWGS84 = Request will start a guidance to the given WGS84 position</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"destination\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>destination = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"startGuidanceToHomeLocation\">\n"
            "      <doc>\n"
            "        <line>startGuidanceToHomeLocation = method to start the guidance to home location</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"startGuidanceToWorkLocation\">\n"
            "      <doc>\n"
            "        <line>startGuidanceToWorkLocation = method to start the guidance to work location</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithDestinationMemoryEntry\">\n"
            "      <doc>\n"
            "        <line>setLocationWithDestinationMemoryEntry = Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"cancelRouteGuidance\">\n"
            "      <doc>\n"
            "        <line>cancelRouteGuidance = Request will stop the guidance</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"insertWaypoint\">\n"
            "      <doc>\n"
            "        <line>insertWaypoint = Inserts current location as new waypoint in current waypoint list.</line>\n"
            "        <line>Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"newIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>newIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"insertWaypointAtDefaultPosition\">\n"
            "      <doc>\n"
            "        <line>insertWaypointAtDefaultPosition = Inserts current location as new waypoint in current waypoint list.</line>\n"
            "        <line>Index: Index internally defined by navigation application.</line>\n"
            "        <line>Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"replaceWaypoint\">\n"
            "      <doc>\n"
            "        <line>replaceWaypoint = Uses current location to replace waypoint</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"index\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>index = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"deleteWaypoints\">\n"
            "      <doc>\n"
            "        <line>deleteWaypoints = Delete the waypoints (including firstIndex and lastIndex)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"firstIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>firstIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"lastIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>lastIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"applyWaypointListChange\">\n"
            "      <doc>\n"
            "        <line>applyWaypointListChange = Uses modified waypoint list and trigger new route calculation</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestWaypointList\">\n"
            "      <doc>\n"
            "        <line>requestWaypointList = Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestSetFreeTextSearchType\">\n"
            "      <doc>\n"
            "        <line>requestSetFreeTextSearchType = Request for the free text search location type</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"locationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationType (of type FTSLocationType) = Description missing</line>\n"
            "          <line>enum[FREETEXT_SEARCH_TYPE_COMBINED (null), FREETEXT_SEARCH_TYPE_ADDRESS (null), FREETEXT_SEARCH_TYPE_POI (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"requestFreeTextSearchResults\">\n"
            "      <doc>\n"
            "        <line>requestFreeTextSearchResults = Requests the specified range of free text search results for the search string and scope</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"searchString\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>searchString = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"searchScope\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>searchScope (of type FreeTextSearchScope) = Description missing</line>\n"
            "          <line>enum[FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION (null), FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE (null), FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"destinationIndex\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>destinationIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"startIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>startIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"numElements\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numElements = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"searchResults\" type=\"a(stssu(dd)((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>searchResults = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"undoFreeTextSearchElementSelection\">\n"
            "      <doc>\n"
            "        <line>undoFreeTextSearchElementSelection = Request to clear the free text search elements</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithFreeTextSearchInput\">\n"
            "      <doc>\n"
            "        <line>setLocationWithFreeTextSearchInput = Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showDestinationFreeTextSearchInput\">\n"
            "      <doc>\n"
            "        <line>showDestinationFreeTextSearchInput = Request will respond with a contextSwitch to Navigation Destination Free text search</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"locationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationType (of type FTSLocationType) = Description missing</line>\n"
            "          <line>enum[FREETEXT_SEARCH_TYPE_COMBINED (null), FREETEXT_SEARCH_TYPE_ADDRESS (null), FREETEXT_SEARCH_TYPE_POI (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"locationSearchScope\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationSearchScope (of type FreeTextSearchScope) = Description missing</line>\n"
            "          <line>enum[FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION (null), FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE (null), FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"searchString\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>searchString = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"requestFixedPOICategorySearchResults\">\n"
            "      <doc>\n"
            "        <line>requestFixedPOICategorySearchResults = Requests POI elements for the given fixed POI category and scope</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"fixedPOICategory\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>fixedPOICategory = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"locationSearchScope\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>locationSearchScope (of type FreeTextSearchScope) = Description missing</line>\n"
            "          <line>enum[FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION (null), FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION (null), FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE (null), FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA (null), FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"destinationIndex\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>destinationIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"startIndex\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>startIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"numElements\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>numElements = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"searchResults\" type=\"a(stssu(dd)((nin)ub))\">\n"
            "        <doc>\n"
            "          <line>searchResults = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"undoSetLocationWithFixedPOICategoryInput\">\n"
            "      <doc>\n"
            "        <line>undoSetLocationWithFixedPOICategoryInput = Request to clear the selected element from FixedPOISearch Results list</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithFixedPOICategoryInput\">\n"
            "      <doc>\n"
            "        <line>setLocationWithFixedPOICategoryInput = Method to choose the selected POI for starting guidance and requesting details</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"index\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>index = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsCheckAddress\">\n"
            "      <doc>\n"
            "        <line>sdsCheckAddress = Request will validate the given address,</line>\n"
            "        <line>as result it update the attribute sdsAddressWithOptions</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"requestedAddress\" type=\"a(us(b))\">\n"
            "        <doc>\n"
            "          <line>requestedAddress = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsGetRefinementList\">\n"
            "      <doc>\n"
            "        <line>sdsGetRefinementList = Request will get refinement list for the validated address</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sdsAddressElementType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sdsAddressElementType (of type SDSAddressElementType) = Description missing</line>\n"
            "          <line>enum[SDS_ADDRESS_ELEMENT_TYPE_COUNTRY (null), SDS_ADDRESS_ELEMENT_TYPE_PLACE (null), SDS_ADDRESS_ELEMENT_TYPE_ROAD (null), SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD (null), SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER (null), SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT (null), SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT (null), SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT (null), SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT (null), SDS_ADDRESS_ELEMENT_TYPE_STATE (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"refinements\" type=\"a(susu)\">\n"
            "        <doc>\n"
            "          <line>refinements = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"selectSdsRefinement\">\n"
            "      <doc>\n"
            "        <line>selectSdsRefinement = Request will select the refinement with the id from refinement list and add internal to SDSAddress.</line>\n"
            "        <line>As result it update the attribute sdsAddressWithOptions</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setLocationWithSdsInput\">\n"
            "      <doc>\n"
            "        <line>setLocationWithSdsInput = Request will set the SDS Address as destination or waypoint</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestDestinationMemoryEntries\">\n"
            "      <doc>\n"
            "        <line>requestDestinationMemoryEntries = Request will return DestinationMemory entries for the given category</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"categoryType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>categoryType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"destinationMemoryEntries\" type=\"a((stu)(sssssssssssa(sus))(dd))\">\n"
            "        <doc>\n"
            "          <line>destinationMemoryEntries = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setMapRepresentation\">\n"
            "      <doc>\n"
            "        <line>setMapRepresentation = method to select map representation:  dimension/heading combination</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"representation\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>representation = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"requestDetailsForSelectedLocation\">\n"
            "      <doc>\n"
            "        <line>requestDetailsForSelectedLocation = Request will respond with location details for the selected location set via setLocationWithXYZ interface</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"locationDetail\" type=\"(sssssssss(dd))\">\n"
            "        <doc>\n"
            "          <line>locationDetail (of type LocationDetails) = Description missing</line>\n"
            "          <line>LocationDetails struct[cityName, countryName, countryCode, stateName, stateCode, phoneNumber, poiAddress, streetName, zipCode, coordinate] = struct contain location details of the requested location</line>\n"
            "          <line>0: LocationDetails.cityName ('s') = String cityName contain city name</line>\n"
            "          <line>1: LocationDetails.countryName ('s') = String countryName contain country full name</line>\n"
            "          <line>2: LocationDetails.countryCode ('s') = String countryCode contain country short name</line>\n"
            "          <line>3: LocationDetails.stateName ('s') = String stateName contain state full name</line>\n"
            "          <line>4: LocationDetails.stateCode ('s') = String stateCode contain state short name</line>\n"
            "          <line>5: LocationDetails.phoneNumber ('s') = String phoneNumber contains phone number</line>\n"
            "          <line>6: LocationDetails.poiAddress ('s') = String poiAddress contains poi address</line>\n"
            "          <line>7: LocationDetails.streetName ('s') = String streetName contains street name</line>\n"
            "          <line>8: LocationDetails.zipCode ('s') = String zipCode contains ZIP code</line>\n"
            "          <line>9: LocationDetails.coordinate ('?') = coordinate contains location's Latitude and Longitude information. (0.0,0.0) means its Invalid data</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"retriggerAcousticOutput\">\n"
            "      <doc>\n"
            "        <line>retriggerAcousticOutput = method to retrigger the last voice output (guidance)</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"speakSamplePhrase\">\n"
            "      <doc>\n"
            "        <line>speakSamplePhrase = method to trigger the sample voice Phrase</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sampleVoicePhrase\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sampleVoicePhrase = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setRouteCriterion\">\n"
            "      <doc>\n"
            "        <line>setRouteCriterion = set RouteCriterion settings and apply them to recalculate</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"routeCriterion\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>routeCriterion (of type RouteCriterion) = Description missing</line>\n"
            "          <line>enum[ROUTE_CRITERION_ECONOMIC (null), ROUTE_CRITERION_FAST (null), ROUTE_CRITERION_SHORT (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setVoiceGuidance\">\n"
            "      <doc>\n"
            "        <line>setVoiceGuidance = method to set and get the guidance settings element for voice</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"active\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>active = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"CheckNavDataCompatibility\">\n"
            "      <doc>\n"
            "        <line>CheckNavDataCompatibility = NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"navDataVersion\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>navDataVersion = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"compatibilityInfo\" type=\"ay\">\n"
            "        <doc>\n"
            "          <line>compatibilityInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"compatibility\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>compatibility (of type NavDataCompatibility) = Description missing</line>\n"
            "          <line>enum[NAVDATA_COMPATIBLE (0), NAVDATA_INCOMPATIBLE (1), NAVDATA_COMPATIBILITY_UNKNOWN (2)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsUpdateVoiceTag\">\n"
            "      <doc>\n"
            "        <line>sdsUpdateVoiceTag = Method used to store/delete the VoiceTagId in the destination memory database</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"voiceTagID\" type=\"(tsuu)\">\n"
            "        <doc>\n"
            "          <line>voiceTagID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sdsGetHouseNumberPattern\">\n"
            "      <doc>\n"
            "        <line>sdsGetHouseNumberPattern = Request will get house number patterns and the minimum and maximum values of the current SDSAddress</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"minHouseNumber\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>minHouseNumber = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"maxHouseNumber\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>maxHouseNumber = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"patterns\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>patterns = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setMapLightMode\">\n"
            "      <doc>\n"
            "        <line>setMapLightMode = method to change the MAP color based on light mode request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"active\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>active = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"startTripReplay\">\n"
            "      <doc>\n"
            "        <line>startTripReplay = Starts the trip-replay for the given trip-file</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"tripFileName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>tripFileName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"stopTripReplay\">\n"
            "      <doc>\n"
            "        <line>stopTripReplay = Stops the trip-replay</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"seekTripReplay\">\n"
            "      <doc>\n"
            "        <line>seekTripReplay = Seeks to the specified location, in the trip-replay</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"seekValue\" type=\"n\">\n"
            "        <doc>\n"
            "          <line>seekValue = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setTripReplayMode\">\n"
            "      <doc>\n"
            "        <line>setTripReplayMode = Sets the mode of the trip-replay</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"loopModeActive\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>loopModeActive = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"speed\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>speed = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showLocationSelectionAndGetAddressDetails\">\n"
            "      <doc>\n"
            "        <line>showLocationSelectionAndGetAddressDetails = Request will respond with Address Details along with Destination Memory Id</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"destinationMemoryDetailListElement\" type=\"((stu)(sssssssssssa(sus))(dd))\">\n"
            "        <doc>\n"
            "          <line>destinationMemoryDetailListElement = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showRouteCalculationToDestination\">\n"
            "      <doc>\n"
            "        <line>showRouteCalculationToDestination = Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestJamAheadList\">\n"
            "      <doc>\n"
            "        <line>requestJamAheadList = Fetch the Possible options to block ahead along with continuous updates</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"releaseJamAheadList\">\n"
            "      <doc>\n"
            "        <line>releaseJamAheadList = Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"selectJamAheadListEntry\">\n"
            "      <doc>\n"
            "        <line>selectJamAheadListEntry = Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"index\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>index = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"activateNonPremiumTMC\">\n"
            "      <doc>\n"
            "        <line>activateNonPremiumTMC = Request to activate Non Premium TMC</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"deactivateNonPremiumTMC\">\n"
            "      <doc>\n"
            "        <line>deactivateNonPremiumTMC = Request to deactivate Non Premium TMC</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"cancelJamAhead\">\n"
            "      <doc>\n"
            "        <line>cancelJamAhead = Deleting already defined JamAhead</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"requestDetailsForSelectedCoordinateWithRadius\">\n"
            "      <doc>\n"
            "        <line>requestDetailsForSelectedCoordinateWithRadius = Request will respond with list of location details for the given location and radius.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"(dd)\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"radius\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>radius = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"locationDetailsList\" type=\"a(sssssssss(dd))\">\n"
            "        <doc>\n"
            "          <line>locationDetailsList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"showAndSetLocationWithDetails\">\n"
            "      <doc>\n"
            "        <line>showAndSetLocationWithDetails = Request to set the latitude and longitude value and location details for showing them and for further processing</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"location\" type=\"((s(dd)b)ss(ayu))\">\n"
            "        <doc>\n"
            "          <line>location = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void NavigationServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NavigationServiceStub*>(getStub()))->onGetAll (properties);
}

void NavigationServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 49, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "navStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "datasetVersion");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "nonPremiumTMCStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "currentFreeTextSearchInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "positionInformation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "distanceToDestination");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "currentStreet");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "turntoStreet");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "roundaboutExitNumber");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "nextTurntoStreet");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "barGraphInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "maneuverSymbol");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "satelliteInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "destinationInformation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "routeCalculationDuration");
            ::boost::shared_ptr< RouteCalculationDurationSet > payload(new RouteCalculationDurationSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<NavigationServiceStub*>(getStub())->onRouteCalculationDurationSet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "homeLocation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "workLocation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "mapRepresentation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "sdsAddressWithOptions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "waypointList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "maneuverView");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "intersectionMapCarsorPosition");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "speedLimit");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "trafficEnforcement");
            ::boost::shared_ptr< TrafficEnforcementSet > payload(new TrafficEnforcementSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficEnforcementSet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "nextManeuverDetails");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "laneRecommendationList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "arrivalInformationList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "intersectionMap");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "isAddressBookChanged");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "isMaxAllowedAddressBookEntriesStored");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "isLastDestinationListChanged");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "isVoiceGuidanceActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "sdsVoiceTagWithOptions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "trafficMessagesCount");
            ::boost::shared_ptr< TrafficMessagesCountSet > payload(new TrafficMessagesCountSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficMessagesCountSet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "trafficServiceReceptionStatus");
            ::boost::shared_ptr< TrafficServiceReceptionStatusSet > payload(new TrafficServiceReceptionStatusSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficServiceReceptionStatusSet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "sdsPOICategoryShortcuts");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "menuPoiCategoryShortcuts");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "tripReplayStatusInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "etcStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "TrafficSignInfoActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "OverSpeedSoundAlertInfoActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "routeRecalculationReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "RiskAreaDisplayInfoActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "RiskAreaSoundAlertInfoActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "jamAheadList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "waypointOperationStatusList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "destinationReachedStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "lightModeStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "mapCameraData");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NavigationServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 49, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "navStatus");
            ::boost::shared_ptr< NavStatusGet > payload(new NavStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onNavStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "datasetVersion");
            ::boost::shared_ptr< DatasetVersionGet > payload(new DatasetVersionGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onDatasetVersionGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "nonPremiumTMCStatus");
            ::boost::shared_ptr< NonPremiumTMCStatusGet > payload(new NonPremiumTMCStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onNonPremiumTMCStatusGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "currentFreeTextSearchInfo");
            ::boost::shared_ptr< CurrentFreeTextSearchInfoGet > payload(new CurrentFreeTextSearchInfoGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onCurrentFreeTextSearchInfoGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "positionInformation");
            ::boost::shared_ptr< PositionInformationGet > payload(new PositionInformationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onPositionInformationGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "distanceToDestination");
            ::boost::shared_ptr< DistanceToDestinationGet > payload(new DistanceToDestinationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onDistanceToDestinationGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "currentStreet");
            ::boost::shared_ptr< CurrentStreetGet > payload(new CurrentStreetGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onCurrentStreetGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "turntoStreet");
            ::boost::shared_ptr< TurntoStreetGet > payload(new TurntoStreetGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTurntoStreetGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "roundaboutExitNumber");
            ::boost::shared_ptr< RoundaboutExitNumberGet > payload(new RoundaboutExitNumberGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onRoundaboutExitNumberGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "nextTurntoStreet");
            ::boost::shared_ptr< NextTurntoStreetGet > payload(new NextTurntoStreetGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onNextTurntoStreetGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "barGraphInfo");
            ::boost::shared_ptr< BarGraphInfoGet > payload(new BarGraphInfoGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onBarGraphInfoGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "maneuverSymbol");
            ::boost::shared_ptr< ManeuverSymbolGet > payload(new ManeuverSymbolGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onManeuverSymbolGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "satelliteInfo");
            ::boost::shared_ptr< SatelliteInfoGet > payload(new SatelliteInfoGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onSatelliteInfoGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "destinationInformation");
            ::boost::shared_ptr< DestinationInformationGet > payload(new DestinationInformationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onDestinationInformationGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "routeCalculationDuration");
            ::boost::shared_ptr< RouteCalculationDurationGet > payload(new RouteCalculationDurationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onRouteCalculationDurationGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "homeLocation");
            ::boost::shared_ptr< HomeLocationGet > payload(new HomeLocationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onHomeLocationGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "workLocation");
            ::boost::shared_ptr< WorkLocationGet > payload(new WorkLocationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onWorkLocationGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "mapRepresentation");
            ::boost::shared_ptr< MapRepresentationGet > payload(new MapRepresentationGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onMapRepresentationGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "sdsAddressWithOptions");
            ::boost::shared_ptr< SdsAddressWithOptionsGet > payload(new SdsAddressWithOptionsGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onSdsAddressWithOptionsGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "waypointList");
            ::boost::shared_ptr< WaypointListGet > payload(new WaypointListGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onWaypointListGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "maneuverView");
            ::boost::shared_ptr< ManeuverViewGet > payload(new ManeuverViewGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onManeuverViewGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "intersectionMapCarsorPosition");
            ::boost::shared_ptr< IntersectionMapCarsorPositionGet > payload(new IntersectionMapCarsorPositionGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIntersectionMapCarsorPositionGet (payload);
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "speedLimit");
            ::boost::shared_ptr< SpeedLimitGet > payload(new SpeedLimitGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onSpeedLimitGet (payload);
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "trafficEnforcement");
            ::boost::shared_ptr< TrafficEnforcementGet > payload(new TrafficEnforcementGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficEnforcementGet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "nextManeuverDetails");
            ::boost::shared_ptr< NextManeuverDetailsGet > payload(new NextManeuverDetailsGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onNextManeuverDetailsGet (payload);
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "laneRecommendationList");
            ::boost::shared_ptr< LaneRecommendationListGet > payload(new LaneRecommendationListGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onLaneRecommendationListGet (payload);
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "arrivalInformationList");
            ::boost::shared_ptr< ArrivalInformationListGet > payload(new ArrivalInformationListGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onArrivalInformationListGet (payload);
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "intersectionMap");
            ::boost::shared_ptr< IntersectionMapGet > payload(new IntersectionMapGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIntersectionMapGet (payload);
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "isAddressBookChanged");
            ::boost::shared_ptr< IsAddressBookChangedGet > payload(new IsAddressBookChangedGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIsAddressBookChangedGet (payload);
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "isMaxAllowedAddressBookEntriesStored");
            ::boost::shared_ptr< IsMaxAllowedAddressBookEntriesStoredGet > payload(new IsMaxAllowedAddressBookEntriesStoredGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIsMaxAllowedAddressBookEntriesStoredGet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "isLastDestinationListChanged");
            ::boost::shared_ptr< IsLastDestinationListChangedGet > payload(new IsLastDestinationListChangedGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIsLastDestinationListChangedGet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "isVoiceGuidanceActive");
            ::boost::shared_ptr< IsVoiceGuidanceActiveGet > payload(new IsVoiceGuidanceActiveGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onIsVoiceGuidanceActiveGet (payload);
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "sdsVoiceTagWithOptions");
            ::boost::shared_ptr< SdsVoiceTagWithOptionsGet > payload(new SdsVoiceTagWithOptionsGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onSdsVoiceTagWithOptionsGet (payload);
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "trafficMessagesCount");
            ::boost::shared_ptr< TrafficMessagesCountGet > payload(new TrafficMessagesCountGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficMessagesCountGet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "trafficServiceReceptionStatus");
            ::boost::shared_ptr< TrafficServiceReceptionStatusGet > payload(new TrafficServiceReceptionStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficServiceReceptionStatusGet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "sdsPOICategoryShortcuts");
            ::boost::shared_ptr< SdsPOICategoryShortcutsGet > payload(new SdsPOICategoryShortcutsGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onSdsPOICategoryShortcutsGet (payload);
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "menuPoiCategoryShortcuts");
            ::boost::shared_ptr< MenuPoiCategoryShortcutsGet > payload(new MenuPoiCategoryShortcutsGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onMenuPoiCategoryShortcutsGet (payload);
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "tripReplayStatusInfo");
            ::boost::shared_ptr< TripReplayStatusInfoGet > payload(new TripReplayStatusInfoGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTripReplayStatusInfoGet (payload);
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "etcStatus");
            ::boost::shared_ptr< EtcStatusGet > payload(new EtcStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onEtcStatusGet (payload);
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "TrafficSignInfoActive");
            ::boost::shared_ptr< TrafficSignInfoActiveGet > payload(new TrafficSignInfoActiveGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onTrafficSignInfoActiveGet (payload);
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "OverSpeedSoundAlertInfoActive");
            ::boost::shared_ptr< OverSpeedSoundAlertInfoActiveGet > payload(new OverSpeedSoundAlertInfoActiveGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onOverSpeedSoundAlertInfoActiveGet (payload);
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "routeRecalculationReason");
            ::boost::shared_ptr< RouteRecalculationReasonGet > payload(new RouteRecalculationReasonGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onRouteRecalculationReasonGet (payload);
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "RiskAreaDisplayInfoActive");
            ::boost::shared_ptr< RiskAreaDisplayInfoActiveGet > payload(new RiskAreaDisplayInfoActiveGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onRiskAreaDisplayInfoActiveGet (payload);
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "RiskAreaSoundAlertInfoActive");
            ::boost::shared_ptr< RiskAreaSoundAlertInfoActiveGet > payload(new RiskAreaSoundAlertInfoActiveGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onRiskAreaSoundAlertInfoActiveGet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "jamAheadList");
            ::boost::shared_ptr< JamAheadListGet > payload(new JamAheadListGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onJamAheadListGet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "waypointOperationStatusList");
            ::boost::shared_ptr< WaypointOperationStatusListGet > payload(new WaypointOperationStatusListGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onWaypointOperationStatusListGet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "destinationReachedStatus");
            ::boost::shared_ptr< DestinationReachedStatusGet > payload(new DestinationReachedStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onDestinationReachedStatusGet (payload);
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "lightModeStatus");
            ::boost::shared_ptr< LightModeStatusGet > payload(new LightModeStatusGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onLightModeStatusGet (payload);
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "mapCameraData");
            ::boost::shared_ptr< MapCameraDataGet > payload(new MapCameraDataGet());
            payload->setAct(act);
            static_cast<NavigationServiceStub*>(getStub())->onMapCameraDataGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NavigationServiceStub::NavigationServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationServiceStub::NavigationServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NavigationServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NavigationServiceStub::~NavigationServiceStub() {
    delete _stubDelegate;
}

void NavigationServiceStub::sendNavStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NavStatusUpdate payload(_navStatusProperty);

        LOG_INFO ("-> send%s", "NavStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("navStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NavStatusUpdate");
    }
}

void NavigationServiceStub::onNavStatusGet(const ::boost::shared_ptr< NavStatusGet >& navStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NavStatusGet", navStatus->getAct());
    sendNavStatusGetUpdate(_navStatusProperty.getNavStatus(), navStatus->getAct());
}

void NavigationServiceStub::sendNavStatusGetUpdate(NavStatus navStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NavStatusGet payload(navStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NavStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setNavStatus(NavStatus navStatus) {
    if(navStatus!=_navStatusProperty.getNavStatus()) {
        _navStatusProperty.setNavStatus(navStatus);
        sendNavStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

NavStatus NavigationServiceStub::getNavStatus() const {
    return _navStatusProperty.getNavStatus();
}

void NavigationServiceStub::sendDatasetVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DatasetVersionUpdate payload(_datasetVersionProperty);

        LOG_INFO ("-> send%s", "DatasetVersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("datasetVersion", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DatasetVersionUpdate");
    }
}

void NavigationServiceStub::onDatasetVersionGet(const ::boost::shared_ptr< DatasetVersionGet >& datasetVersion) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DatasetVersionGet", datasetVersion->getAct());
    sendDatasetVersionGetUpdate(_datasetVersionProperty.getDatasetVersion(), datasetVersion->getAct());
}

void NavigationServiceStub::sendDatasetVersionGetUpdate(const ::std::string& datasetVersion, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DatasetVersionGet payload(datasetVersion);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DatasetVersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setDatasetVersion(const ::std::string& datasetVersion) {
    if(datasetVersion!=_datasetVersionProperty.getDatasetVersion()) {
        _datasetVersionProperty.setDatasetVersion(datasetVersion);
        sendDatasetVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& NavigationServiceStub::getDatasetVersion() const {
    return _datasetVersionProperty.getDatasetVersion();
}

::std::string& NavigationServiceStub::getDatasetVersionMutable() {
    return _datasetVersionProperty.getDatasetVersionMutable();
}

void NavigationServiceStub::sendNonPremiumTMCStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NonPremiumTMCStatusUpdate payload(_nonPremiumTMCStatusProperty);

        LOG_INFO ("-> send%s", "NonPremiumTMCStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("nonPremiumTMCStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NonPremiumTMCStatusUpdate");
    }
}

void NavigationServiceStub::onNonPremiumTMCStatusGet(const ::boost::shared_ptr< NonPremiumTMCStatusGet >& nonPremiumTMCStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NonPremiumTMCStatusGet", nonPremiumTMCStatus->getAct());
    sendNonPremiumTMCStatusGetUpdate(_nonPremiumTMCStatusProperty.getNonPremiumTMCStatus(), nonPremiumTMCStatus->getAct());
}

void NavigationServiceStub::sendNonPremiumTMCStatusGetUpdate(bool nonPremiumTMCStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NonPremiumTMCStatusGet payload(nonPremiumTMCStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NonPremiumTMCStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setNonPremiumTMCStatus(bool nonPremiumTMCStatus) {
    if(nonPremiumTMCStatus!=_nonPremiumTMCStatusProperty.getNonPremiumTMCStatus()) {
        _nonPremiumTMCStatusProperty.setNonPremiumTMCStatus(nonPremiumTMCStatus);
        sendNonPremiumTMCStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getNonPremiumTMCStatus() const {
    return _nonPremiumTMCStatusProperty.getNonPremiumTMCStatus();
}

void NavigationServiceStub::sendCurrentFreeTextSearchInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentFreeTextSearchInfoUpdate payload(_currentFreeTextSearchInfoProperty);

        LOG_INFO ("-> send%s", "CurrentFreeTextSearchInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("currentFreeTextSearchInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentFreeTextSearchInfoUpdate");
    }
}

void NavigationServiceStub::onCurrentFreeTextSearchInfoGet(const ::boost::shared_ptr< CurrentFreeTextSearchInfoGet >& currentFreeTextSearchInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentFreeTextSearchInfoGet", currentFreeTextSearchInfo->getAct());
    sendCurrentFreeTextSearchInfoGetUpdate(_currentFreeTextSearchInfoProperty.getCurrentFreeTextSearchInfo(), currentFreeTextSearchInfo->getAct());
}

void NavigationServiceStub::sendCurrentFreeTextSearchInfoGetUpdate(const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentFreeTextSearchInfoGet payload(currentFreeTextSearchInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentFreeTextSearchInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setCurrentFreeTextSearchInfo(const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo) {
    if(currentFreeTextSearchInfo!=_currentFreeTextSearchInfoProperty.getCurrentFreeTextSearchInfo()) {
        _currentFreeTextSearchInfoProperty.setCurrentFreeTextSearchInfo(currentFreeTextSearchInfo);
        sendCurrentFreeTextSearchInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const CurrentFreeTextSearchInfo& NavigationServiceStub::getCurrentFreeTextSearchInfo() const {
    return _currentFreeTextSearchInfoProperty.getCurrentFreeTextSearchInfo();
}

CurrentFreeTextSearchInfo& NavigationServiceStub::getCurrentFreeTextSearchInfoMutable() {
    return _currentFreeTextSearchInfoProperty.getCurrentFreeTextSearchInfoMutable();
}

void NavigationServiceStub::sendPositionInformationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PositionInformationUpdate payload(_positionInformationProperty);

        LOG_INFO ("-> send%s", "PositionInformationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("positionInformation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PositionInformationUpdate");
    }
}

void NavigationServiceStub::onPositionInformationGet(const ::boost::shared_ptr< PositionInformationGet >& positionInformation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PositionInformationGet", positionInformation->getAct());
    sendPositionInformationGetUpdate(_positionInformationProperty.getPositionInformation(), positionInformation->getAct());
}

void NavigationServiceStub::sendPositionInformationGetUpdate(const PositionInformation& positionInformation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PositionInformationGet payload(positionInformation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PositionInformationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setPositionInformation(const PositionInformation& positionInformation) {
    if(positionInformation!=_positionInformationProperty.getPositionInformation()) {
        _positionInformationProperty.setPositionInformation(positionInformation);
        sendPositionInformationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const PositionInformation& NavigationServiceStub::getPositionInformation() const {
    return _positionInformationProperty.getPositionInformation();
}

PositionInformation& NavigationServiceStub::getPositionInformationMutable() {
    return _positionInformationProperty.getPositionInformationMutable();
}

void NavigationServiceStub::sendDistanceToDestinationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DistanceToDestinationUpdate payload(_distanceToDestinationProperty);

        LOG_INFO ("-> send%s", "DistanceToDestinationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("distanceToDestination", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DistanceToDestinationUpdate");
    }
}

void NavigationServiceStub::onDistanceToDestinationGet(const ::boost::shared_ptr< DistanceToDestinationGet >& distanceToDestination) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DistanceToDestinationGet", distanceToDestination->getAct());
    sendDistanceToDestinationGetUpdate(_distanceToDestinationProperty.getDistanceToDestination(), distanceToDestination->getAct());
}

void NavigationServiceStub::sendDistanceToDestinationGetUpdate(const DistanceToDestination& distanceToDestination, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DistanceToDestinationGet payload(distanceToDestination);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DistanceToDestinationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setDistanceToDestination(const DistanceToDestination& distanceToDestination) {
    if(distanceToDestination!=_distanceToDestinationProperty.getDistanceToDestination()) {
        _distanceToDestinationProperty.setDistanceToDestination(distanceToDestination);
        sendDistanceToDestinationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const DistanceToDestination& NavigationServiceStub::getDistanceToDestination() const {
    return _distanceToDestinationProperty.getDistanceToDestination();
}

DistanceToDestination& NavigationServiceStub::getDistanceToDestinationMutable() {
    return _distanceToDestinationProperty.getDistanceToDestinationMutable();
}

void NavigationServiceStub::sendCurrentStreetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentStreetUpdate payload(_currentStreetProperty);

        LOG_INFO ("-> send%s", "CurrentStreetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("currentStreet", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentStreetUpdate");
    }
}

void NavigationServiceStub::onCurrentStreetGet(const ::boost::shared_ptr< CurrentStreetGet >& currentStreet) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentStreetGet", currentStreet->getAct());
    sendCurrentStreetGetUpdate(_currentStreetProperty.getCurrentStreet(), currentStreet->getAct());
}

void NavigationServiceStub::sendCurrentStreetGetUpdate(const ::std::string& currentStreet, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentStreetGet payload(currentStreet);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentStreetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setCurrentStreet(const ::std::string& currentStreet) {
    if(currentStreet!=_currentStreetProperty.getCurrentStreet()) {
        _currentStreetProperty.setCurrentStreet(currentStreet);
        sendCurrentStreetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& NavigationServiceStub::getCurrentStreet() const {
    return _currentStreetProperty.getCurrentStreet();
}

::std::string& NavigationServiceStub::getCurrentStreetMutable() {
    return _currentStreetProperty.getCurrentStreetMutable();
}

void NavigationServiceStub::sendTurntoStreetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TurntoStreetUpdate payload(_turntoStreetProperty);

        LOG_INFO ("-> send%s", "TurntoStreetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("turntoStreet", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TurntoStreetUpdate");
    }
}

void NavigationServiceStub::onTurntoStreetGet(const ::boost::shared_ptr< TurntoStreetGet >& turntoStreet) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TurntoStreetGet", turntoStreet->getAct());
    sendTurntoStreetGetUpdate(_turntoStreetProperty.getTurntoStreet(), turntoStreet->getAct());
}

void NavigationServiceStub::sendTurntoStreetGetUpdate(const TurnToStreet& turntoStreet, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TurntoStreetGet payload(turntoStreet);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TurntoStreetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setTurntoStreet(const TurnToStreet& turntoStreet) {
    if(turntoStreet!=_turntoStreetProperty.getTurntoStreet()) {
        _turntoStreetProperty.setTurntoStreet(turntoStreet);
        sendTurntoStreetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TurnToStreet& NavigationServiceStub::getTurntoStreet() const {
    return _turntoStreetProperty.getTurntoStreet();
}

TurnToStreet& NavigationServiceStub::getTurntoStreetMutable() {
    return _turntoStreetProperty.getTurntoStreetMutable();
}

void NavigationServiceStub::sendRoundaboutExitNumberUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RoundaboutExitNumberUpdate payload(_roundaboutExitNumberProperty);

        LOG_INFO ("-> send%s", "RoundaboutExitNumberUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("roundaboutExitNumber", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RoundaboutExitNumberUpdate");
    }
}

void NavigationServiceStub::onRoundaboutExitNumberGet(const ::boost::shared_ptr< RoundaboutExitNumberGet >& roundaboutExitNumber) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RoundaboutExitNumberGet", roundaboutExitNumber->getAct());
    sendRoundaboutExitNumberGetUpdate(_roundaboutExitNumberProperty.getRoundaboutExitNumber(), roundaboutExitNumber->getAct());
}

void NavigationServiceStub::sendRoundaboutExitNumberGetUpdate(uint16 roundaboutExitNumber, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RoundaboutExitNumberGet payload(roundaboutExitNumber);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RoundaboutExitNumberGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setRoundaboutExitNumber(uint16 roundaboutExitNumber) {
    if(roundaboutExitNumber!=_roundaboutExitNumberProperty.getRoundaboutExitNumber()) {
        _roundaboutExitNumberProperty.setRoundaboutExitNumber(roundaboutExitNumber);
        sendRoundaboutExitNumberUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 NavigationServiceStub::getRoundaboutExitNumber() const {
    return _roundaboutExitNumberProperty.getRoundaboutExitNumber();
}

void NavigationServiceStub::sendNextTurntoStreetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NextTurntoStreetUpdate payload(_nextTurntoStreetProperty);

        LOG_INFO ("-> send%s", "NextTurntoStreetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("nextTurntoStreet", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NextTurntoStreetUpdate");
    }
}

void NavigationServiceStub::onNextTurntoStreetGet(const ::boost::shared_ptr< NextTurntoStreetGet >& nextTurntoStreet) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NextTurntoStreetGet", nextTurntoStreet->getAct());
    sendNextTurntoStreetGetUpdate(_nextTurntoStreetProperty.getNextTurntoStreet(), nextTurntoStreet->getAct());
}

void NavigationServiceStub::sendNextTurntoStreetGetUpdate(const ::std::string& nextTurntoStreet, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NextTurntoStreetGet payload(nextTurntoStreet);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NextTurntoStreetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setNextTurntoStreet(const ::std::string& nextTurntoStreet) {
    if(nextTurntoStreet!=_nextTurntoStreetProperty.getNextTurntoStreet()) {
        _nextTurntoStreetProperty.setNextTurntoStreet(nextTurntoStreet);
        sendNextTurntoStreetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& NavigationServiceStub::getNextTurntoStreet() const {
    return _nextTurntoStreetProperty.getNextTurntoStreet();
}

::std::string& NavigationServiceStub::getNextTurntoStreetMutable() {
    return _nextTurntoStreetProperty.getNextTurntoStreetMutable();
}

void NavigationServiceStub::sendBarGraphInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BarGraphInfoUpdate payload(_barGraphInfoProperty);

        LOG_INFO ("-> send%s", "BarGraphInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("barGraphInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BarGraphInfoUpdate");
    }
}

void NavigationServiceStub::onBarGraphInfoGet(const ::boost::shared_ptr< BarGraphInfoGet >& barGraphInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BarGraphInfoGet", barGraphInfo->getAct());
    sendBarGraphInfoGetUpdate(_barGraphInfoProperty.getBarGraphInfo(), barGraphInfo->getAct());
}

void NavigationServiceStub::sendBarGraphInfoGetUpdate(const BarGraphInfo& barGraphInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BarGraphInfoGet payload(barGraphInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BarGraphInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setBarGraphInfo(const BarGraphInfo& barGraphInfo) {
    if(barGraphInfo!=_barGraphInfoProperty.getBarGraphInfo()) {
        _barGraphInfoProperty.setBarGraphInfo(barGraphInfo);
        sendBarGraphInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const BarGraphInfo& NavigationServiceStub::getBarGraphInfo() const {
    return _barGraphInfoProperty.getBarGraphInfo();
}

BarGraphInfo& NavigationServiceStub::getBarGraphInfoMutable() {
    return _barGraphInfoProperty.getBarGraphInfoMutable();
}

void NavigationServiceStub::sendManeuverSymbolUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ManeuverSymbolUpdate payload(_maneuverSymbolProperty);

        LOG_INFO ("-> send%s", "ManeuverSymbolUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("maneuverSymbol", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ManeuverSymbolUpdate");
    }
}

void NavigationServiceStub::onManeuverSymbolGet(const ::boost::shared_ptr< ManeuverSymbolGet >& maneuverSymbol) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ManeuverSymbolGet", maneuverSymbol->getAct());
    sendManeuverSymbolGetUpdate(_maneuverSymbolProperty.getManeuverSymbol(), maneuverSymbol->getAct());
}

void NavigationServiceStub::sendManeuverSymbolGetUpdate(ManeuverSymbol maneuverSymbol, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ManeuverSymbolGet payload(maneuverSymbol);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ManeuverSymbolGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setManeuverSymbol(ManeuverSymbol maneuverSymbol) {
    if(maneuverSymbol!=_maneuverSymbolProperty.getManeuverSymbol()) {
        _maneuverSymbolProperty.setManeuverSymbol(maneuverSymbol);
        sendManeuverSymbolUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

ManeuverSymbol NavigationServiceStub::getManeuverSymbol() const {
    return _maneuverSymbolProperty.getManeuverSymbol();
}

void NavigationServiceStub::sendSatelliteInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SatelliteInfoUpdate payload(_satelliteInfoProperty);

        LOG_INFO ("-> send%s", "SatelliteInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("satelliteInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SatelliteInfoUpdate");
    }
}

void NavigationServiceStub::onSatelliteInfoGet(const ::boost::shared_ptr< SatelliteInfoGet >& satelliteInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SatelliteInfoGet", satelliteInfo->getAct());
    sendSatelliteInfoGetUpdate(_satelliteInfoProperty.getSatelliteInfo(), satelliteInfo->getAct());
}

void NavigationServiceStub::sendSatelliteInfoGetUpdate(const SatelliteInfo& satelliteInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SatelliteInfoGet payload(satelliteInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SatelliteInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setSatelliteInfo(const SatelliteInfo& satelliteInfo) {
    if(satelliteInfo!=_satelliteInfoProperty.getSatelliteInfo()) {
        _satelliteInfoProperty.setSatelliteInfo(satelliteInfo);
        sendSatelliteInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SatelliteInfo& NavigationServiceStub::getSatelliteInfo() const {
    return _satelliteInfoProperty.getSatelliteInfo();
}

SatelliteInfo& NavigationServiceStub::getSatelliteInfoMutable() {
    return _satelliteInfoProperty.getSatelliteInfoMutable();
}

void NavigationServiceStub::sendDestinationInformationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DestinationInformationUpdate payload(_destinationInformationProperty);

        LOG_INFO ("-> send%s", "DestinationInformationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("destinationInformation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DestinationInformationUpdate");
    }
}

void NavigationServiceStub::onDestinationInformationGet(const ::boost::shared_ptr< DestinationInformationGet >& destinationInformation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DestinationInformationGet", destinationInformation->getAct());
    sendDestinationInformationGetUpdate(_destinationInformationProperty.getDestinationInformation(), destinationInformation->getAct());
}

void NavigationServiceStub::sendDestinationInformationGetUpdate(const ::std::vector< DestinationInfoElement >& destinationInformation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DestinationInformationGet payload(destinationInformation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DestinationInformationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setDestinationInformation(const ::std::vector< DestinationInfoElement >& destinationInformation) {
    if(destinationInformation!=_destinationInformationProperty.getDestinationInformation()) {
        _destinationInformationProperty.setDestinationInformation(destinationInformation);
        sendDestinationInformationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< DestinationInfoElement >& NavigationServiceStub::getDestinationInformation() const {
    return _destinationInformationProperty.getDestinationInformation();
}

::std::vector< DestinationInfoElement >& NavigationServiceStub::getDestinationInformationMutable() {
    return _destinationInformationProperty.getDestinationInformationMutable();
}

void NavigationServiceStub::sendRouteCalculationDurationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RouteCalculationDurationUpdate payload(_routeCalculationDurationProperty);

        LOG_INFO ("-> send%s", "RouteCalculationDurationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("routeCalculationDuration", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RouteCalculationDurationUpdate");
    }
}

void NavigationServiceStub::onRouteCalculationDurationGet(const ::boost::shared_ptr< RouteCalculationDurationGet >& routeCalculationDuration) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RouteCalculationDurationGet", routeCalculationDuration->getAct());
    sendRouteCalculationDurationGetUpdate(_routeCalculationDurationProperty.getRouteCalculationDuration(), routeCalculationDuration->getAct());
}

void NavigationServiceStub::sendRouteCalculationDurationGetUpdate(const RouteCalculationDuration& routeCalculationDuration, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RouteCalculationDurationGet payload(routeCalculationDuration);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RouteCalculationDurationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::onRouteCalculationDurationSet(const ::boost::shared_ptr< RouteCalculationDurationSet >& routeCalculationDuration) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RouteCalculationDurationSet", routeCalculationDuration->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*routeCalculationDuration, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setRouteCalculationDuration (routeCalculationDuration->getRouteCalculationDuration());
    sendRouteCalculationDurationSetUpdate(routeCalculationDuration->getAct());
}

void NavigationServiceStub::sendRouteCalculationDurationSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RouteCalculationDurationSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void NavigationServiceStub::setRouteCalculationDuration(const RouteCalculationDuration& routeCalculationDuration) {
    if(routeCalculationDuration!=_routeCalculationDurationProperty.getRouteCalculationDuration()) {
        _routeCalculationDurationProperty.setRouteCalculationDuration(routeCalculationDuration);
        sendRouteCalculationDurationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const RouteCalculationDuration& NavigationServiceStub::getRouteCalculationDuration() const {
    return _routeCalculationDurationProperty.getRouteCalculationDuration();
}

RouteCalculationDuration& NavigationServiceStub::getRouteCalculationDurationMutable() {
    return _routeCalculationDurationProperty.getRouteCalculationDurationMutable();
}

void NavigationServiceStub::sendHomeLocationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HomeLocationUpdate payload(_homeLocationProperty);

        LOG_INFO ("-> send%s", "HomeLocationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("homeLocation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HomeLocationUpdate");
    }
}

void NavigationServiceStub::onHomeLocationGet(const ::boost::shared_ptr< HomeLocationGet >& homeLocation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HomeLocationGet", homeLocation->getAct());
    sendHomeLocationGetUpdate(_homeLocationProperty.getHomeLocation(), homeLocation->getAct());
}

void NavigationServiceStub::sendHomeLocationGetUpdate(const Location& homeLocation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HomeLocationGet payload(homeLocation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HomeLocationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setHomeLocation(const Location& homeLocation) {
    if(homeLocation!=_homeLocationProperty.getHomeLocation()) {
        _homeLocationProperty.setHomeLocation(homeLocation);
        sendHomeLocationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const Location& NavigationServiceStub::getHomeLocation() const {
    return _homeLocationProperty.getHomeLocation();
}

Location& NavigationServiceStub::getHomeLocationMutable() {
    return _homeLocationProperty.getHomeLocationMutable();
}

void NavigationServiceStub::sendWorkLocationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WorkLocationUpdate payload(_workLocationProperty);

        LOG_INFO ("-> send%s", "WorkLocationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("workLocation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WorkLocationUpdate");
    }
}

void NavigationServiceStub::onWorkLocationGet(const ::boost::shared_ptr< WorkLocationGet >& workLocation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WorkLocationGet", workLocation->getAct());
    sendWorkLocationGetUpdate(_workLocationProperty.getWorkLocation(), workLocation->getAct());
}

void NavigationServiceStub::sendWorkLocationGetUpdate(const Location& workLocation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WorkLocationGet payload(workLocation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WorkLocationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setWorkLocation(const Location& workLocation) {
    if(workLocation!=_workLocationProperty.getWorkLocation()) {
        _workLocationProperty.setWorkLocation(workLocation);
        sendWorkLocationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const Location& NavigationServiceStub::getWorkLocation() const {
    return _workLocationProperty.getWorkLocation();
}

Location& NavigationServiceStub::getWorkLocationMutable() {
    return _workLocationProperty.getWorkLocationMutable();
}

void NavigationServiceStub::sendMapRepresentationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapRepresentationUpdate payload(_mapRepresentationProperty);

        LOG_INFO ("-> send%s", "MapRepresentationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("mapRepresentation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapRepresentationUpdate");
    }
}

void NavigationServiceStub::onMapRepresentationGet(const ::boost::shared_ptr< MapRepresentationGet >& mapRepresentation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapRepresentationGet", mapRepresentation->getAct());
    sendMapRepresentationGetUpdate(_mapRepresentationProperty.getMapRepresentation(), mapRepresentation->getAct());
}

void NavigationServiceStub::sendMapRepresentationGetUpdate(MapRepresentation mapRepresentation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapRepresentationGet payload(mapRepresentation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapRepresentationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setMapRepresentation(MapRepresentation mapRepresentation) {
    if(mapRepresentation!=_mapRepresentationProperty.getMapRepresentation()) {
        _mapRepresentationProperty.setMapRepresentation(mapRepresentation);
        sendMapRepresentationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

MapRepresentation NavigationServiceStub::getMapRepresentation() const {
    return _mapRepresentationProperty.getMapRepresentation();
}

void NavigationServiceStub::sendSdsAddressWithOptionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsAddressWithOptionsUpdate payload(_sdsAddressWithOptionsProperty);

        LOG_INFO ("-> send%s", "SdsAddressWithOptionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsAddressWithOptions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsAddressWithOptionsUpdate");
    }
}

void NavigationServiceStub::onSdsAddressWithOptionsGet(const ::boost::shared_ptr< SdsAddressWithOptionsGet >& sdsAddressWithOptions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsAddressWithOptionsGet", sdsAddressWithOptions->getAct());
    sendSdsAddressWithOptionsGetUpdate(_sdsAddressWithOptionsProperty.getSdsAddressWithOptions(), sdsAddressWithOptions->getAct());
}

void NavigationServiceStub::sendSdsAddressWithOptionsGetUpdate(const SDSAddressWithOptions& sdsAddressWithOptions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsAddressWithOptionsGet payload(sdsAddressWithOptions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsAddressWithOptionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setSdsAddressWithOptions(const SDSAddressWithOptions& sdsAddressWithOptions) {
    if(sdsAddressWithOptions!=_sdsAddressWithOptionsProperty.getSdsAddressWithOptions()) {
        _sdsAddressWithOptionsProperty.setSdsAddressWithOptions(sdsAddressWithOptions);
        sendSdsAddressWithOptionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SDSAddressWithOptions& NavigationServiceStub::getSdsAddressWithOptions() const {
    return _sdsAddressWithOptionsProperty.getSdsAddressWithOptions();
}

SDSAddressWithOptions& NavigationServiceStub::getSdsAddressWithOptionsMutable() {
    return _sdsAddressWithOptionsProperty.getSdsAddressWithOptionsMutable();
}

void NavigationServiceStub::sendWaypointListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WaypointListUpdate payload(_waypointListProperty);

        LOG_INFO ("-> send%s", "WaypointListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("waypointList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WaypointListUpdate");
    }
}

void NavigationServiceStub::onWaypointListGet(const ::boost::shared_ptr< WaypointListGet >& waypointList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WaypointListGet", waypointList->getAct());
    sendWaypointListGetUpdate(_waypointListProperty.getWaypointList(), waypointList->getAct());
}

void NavigationServiceStub::sendWaypointListGetUpdate(const ::std::vector< WaypointListElement >& waypointList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WaypointListGet payload(waypointList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WaypointListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setWaypointList(const ::std::vector< WaypointListElement >& waypointList) {
    if(waypointList!=_waypointListProperty.getWaypointList()) {
        _waypointListProperty.setWaypointList(waypointList);
        sendWaypointListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< WaypointListElement >& NavigationServiceStub::getWaypointList() const {
    return _waypointListProperty.getWaypointList();
}

::std::vector< WaypointListElement >& NavigationServiceStub::getWaypointListMutable() {
    return _waypointListProperty.getWaypointListMutable();
}

void NavigationServiceStub::sendManeuverViewUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ManeuverViewUpdate payload(_maneuverViewProperty);

        LOG_INFO ("-> send%s", "ManeuverViewUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("maneuverView", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ManeuverViewUpdate");
    }
}

void NavigationServiceStub::onManeuverViewGet(const ::boost::shared_ptr< ManeuverViewGet >& maneuverView) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ManeuverViewGet", maneuverView->getAct());
    sendManeuverViewGetUpdate(_maneuverViewProperty.getManeuverView(), maneuverView->getAct());
}

void NavigationServiceStub::sendManeuverViewGetUpdate(const ManeuverView& maneuverView, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ManeuverViewGet payload(maneuverView);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ManeuverViewGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setManeuverView(const ManeuverView& maneuverView) {
    if(maneuverView!=_maneuverViewProperty.getManeuverView()) {
        _maneuverViewProperty.setManeuverView(maneuverView);
        sendManeuverViewUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ManeuverView& NavigationServiceStub::getManeuverView() const {
    return _maneuverViewProperty.getManeuverView();
}

ManeuverView& NavigationServiceStub::getManeuverViewMutable() {
    return _maneuverViewProperty.getManeuverViewMutable();
}

void NavigationServiceStub::sendIntersectionMapCarsorPositionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IntersectionMapCarsorPositionUpdate payload(_intersectionMapCarsorPositionProperty);

        LOG_INFO ("-> send%s", "IntersectionMapCarsorPositionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("intersectionMapCarsorPosition", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IntersectionMapCarsorPositionUpdate");
    }
}

void NavigationServiceStub::onIntersectionMapCarsorPositionGet(const ::boost::shared_ptr< IntersectionMapCarsorPositionGet >& intersectionMapCarsorPosition) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IntersectionMapCarsorPositionGet", intersectionMapCarsorPosition->getAct());
    sendIntersectionMapCarsorPositionGetUpdate(_intersectionMapCarsorPositionProperty.getIntersectionMapCarsorPosition(), intersectionMapCarsorPosition->getAct());
}

void NavigationServiceStub::sendIntersectionMapCarsorPositionGetUpdate(const IntersectionMapCarsorPosition& intersectionMapCarsorPosition, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IntersectionMapCarsorPositionGet payload(intersectionMapCarsorPosition);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IntersectionMapCarsorPositionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIntersectionMapCarsorPosition(const IntersectionMapCarsorPosition& intersectionMapCarsorPosition) {
    if(intersectionMapCarsorPosition!=_intersectionMapCarsorPositionProperty.getIntersectionMapCarsorPosition()) {
        _intersectionMapCarsorPositionProperty.setIntersectionMapCarsorPosition(intersectionMapCarsorPosition);
        sendIntersectionMapCarsorPositionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const IntersectionMapCarsorPosition& NavigationServiceStub::getIntersectionMapCarsorPosition() const {
    return _intersectionMapCarsorPositionProperty.getIntersectionMapCarsorPosition();
}

IntersectionMapCarsorPosition& NavigationServiceStub::getIntersectionMapCarsorPositionMutable() {
    return _intersectionMapCarsorPositionProperty.getIntersectionMapCarsorPositionMutable();
}

void NavigationServiceStub::sendSpeedLimitUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpeedLimitUpdate payload(_speedLimitProperty);

        LOG_INFO ("-> send%s", "SpeedLimitUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("speedLimit", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpeedLimitUpdate");
    }
}

void NavigationServiceStub::onSpeedLimitGet(const ::boost::shared_ptr< SpeedLimitGet >& speedLimit) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpeedLimitGet", speedLimit->getAct());
    sendSpeedLimitGetUpdate(_speedLimitProperty.getSpeedLimit(), speedLimit->getAct());
}

void NavigationServiceStub::sendSpeedLimitGetUpdate(const SpeedLimit& speedLimit, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpeedLimitGet payload(speedLimit);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpeedLimitGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setSpeedLimit(const SpeedLimit& speedLimit) {
    if(speedLimit!=_speedLimitProperty.getSpeedLimit()) {
        _speedLimitProperty.setSpeedLimit(speedLimit);
        sendSpeedLimitUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SpeedLimit& NavigationServiceStub::getSpeedLimit() const {
    return _speedLimitProperty.getSpeedLimit();
}

SpeedLimit& NavigationServiceStub::getSpeedLimitMutable() {
    return _speedLimitProperty.getSpeedLimitMutable();
}

void NavigationServiceStub::sendTrafficEnforcementUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TrafficEnforcementUpdate payload(_trafficEnforcementProperty);

        LOG_INFO ("-> send%s", "TrafficEnforcementUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("trafficEnforcement", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TrafficEnforcementUpdate");
    }
}

void NavigationServiceStub::onTrafficEnforcementGet(const ::boost::shared_ptr< TrafficEnforcementGet >& trafficEnforcement) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficEnforcementGet", trafficEnforcement->getAct());
    sendTrafficEnforcementGetUpdate(_trafficEnforcementProperty.getTrafficEnforcement(), trafficEnforcement->getAct());
}

void NavigationServiceStub::sendTrafficEnforcementGetUpdate(const TrafficEnforcement& trafficEnforcement, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TrafficEnforcementGet payload(trafficEnforcement);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficEnforcementGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::onTrafficEnforcementSet(const ::boost::shared_ptr< TrafficEnforcementSet >& trafficEnforcement) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficEnforcementSet", trafficEnforcement->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*trafficEnforcement, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTrafficEnforcement (trafficEnforcement->getTrafficEnforcement());
    sendTrafficEnforcementSetUpdate(trafficEnforcement->getAct());
}

void NavigationServiceStub::sendTrafficEnforcementSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficEnforcementSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void NavigationServiceStub::setTrafficEnforcement(const TrafficEnforcement& trafficEnforcement) {
    if(trafficEnforcement!=_trafficEnforcementProperty.getTrafficEnforcement()) {
        _trafficEnforcementProperty.setTrafficEnforcement(trafficEnforcement);
        sendTrafficEnforcementUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TrafficEnforcement& NavigationServiceStub::getTrafficEnforcement() const {
    return _trafficEnforcementProperty.getTrafficEnforcement();
}

TrafficEnforcement& NavigationServiceStub::getTrafficEnforcementMutable() {
    return _trafficEnforcementProperty.getTrafficEnforcementMutable();
}

void NavigationServiceStub::sendNextManeuverDetailsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NextManeuverDetailsUpdate payload(_nextManeuverDetailsProperty);

        LOG_INFO ("-> send%s", "NextManeuverDetailsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("nextManeuverDetails", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NextManeuverDetailsUpdate");
    }
}

void NavigationServiceStub::onNextManeuverDetailsGet(const ::boost::shared_ptr< NextManeuverDetailsGet >& nextManeuverDetails) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NextManeuverDetailsGet", nextManeuverDetails->getAct());
    sendNextManeuverDetailsGetUpdate(_nextManeuverDetailsProperty.getNextManeuverDetails(), nextManeuverDetails->getAct());
}

void NavigationServiceStub::sendNextManeuverDetailsGetUpdate(const NextManeuverDetails& nextManeuverDetails, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NextManeuverDetailsGet payload(nextManeuverDetails);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NextManeuverDetailsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setNextManeuverDetails(const NextManeuverDetails& nextManeuverDetails) {
    if(nextManeuverDetails!=_nextManeuverDetailsProperty.getNextManeuverDetails()) {
        _nextManeuverDetailsProperty.setNextManeuverDetails(nextManeuverDetails);
        sendNextManeuverDetailsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const NextManeuverDetails& NavigationServiceStub::getNextManeuverDetails() const {
    return _nextManeuverDetailsProperty.getNextManeuverDetails();
}

NextManeuverDetails& NavigationServiceStub::getNextManeuverDetailsMutable() {
    return _nextManeuverDetailsProperty.getNextManeuverDetailsMutable();
}

void NavigationServiceStub::sendLaneRecommendationListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LaneRecommendationListUpdate payload(_laneRecommendationListProperty);

        LOG_INFO ("-> send%s", "LaneRecommendationListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("laneRecommendationList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LaneRecommendationListUpdate");
    }
}

void NavigationServiceStub::onLaneRecommendationListGet(const ::boost::shared_ptr< LaneRecommendationListGet >& laneRecommendationList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LaneRecommendationListGet", laneRecommendationList->getAct());
    sendLaneRecommendationListGetUpdate(_laneRecommendationListProperty.getLaneRecommendationList(), laneRecommendationList->getAct());
}

void NavigationServiceStub::sendLaneRecommendationListGetUpdate(const ::std::vector< LaneRecommendation >& laneRecommendationList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LaneRecommendationListGet payload(laneRecommendationList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LaneRecommendationListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setLaneRecommendationList(const ::std::vector< LaneRecommendation >& laneRecommendationList) {
    if(laneRecommendationList!=_laneRecommendationListProperty.getLaneRecommendationList()) {
        _laneRecommendationListProperty.setLaneRecommendationList(laneRecommendationList);
        sendLaneRecommendationListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< LaneRecommendation >& NavigationServiceStub::getLaneRecommendationList() const {
    return _laneRecommendationListProperty.getLaneRecommendationList();
}

::std::vector< LaneRecommendation >& NavigationServiceStub::getLaneRecommendationListMutable() {
    return _laneRecommendationListProperty.getLaneRecommendationListMutable();
}

void NavigationServiceStub::sendArrivalInformationListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ArrivalInformationListUpdate payload(_arrivalInformationListProperty);

        LOG_INFO ("-> send%s", "ArrivalInformationListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("arrivalInformationList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ArrivalInformationListUpdate");
    }
}

void NavigationServiceStub::onArrivalInformationListGet(const ::boost::shared_ptr< ArrivalInformationListGet >& arrivalInformationList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ArrivalInformationListGet", arrivalInformationList->getAct());
    sendArrivalInformationListGetUpdate(_arrivalInformationListProperty.getArrivalInformationList(), arrivalInformationList->getAct());
}

void NavigationServiceStub::sendArrivalInformationListGetUpdate(const ::std::vector< ArrivalInformation >& arrivalInformationList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ArrivalInformationListGet payload(arrivalInformationList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ArrivalInformationListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setArrivalInformationList(const ::std::vector< ArrivalInformation >& arrivalInformationList) {
    if(arrivalInformationList!=_arrivalInformationListProperty.getArrivalInformationList()) {
        _arrivalInformationListProperty.setArrivalInformationList(arrivalInformationList);
        sendArrivalInformationListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ArrivalInformation >& NavigationServiceStub::getArrivalInformationList() const {
    return _arrivalInformationListProperty.getArrivalInformationList();
}

::std::vector< ArrivalInformation >& NavigationServiceStub::getArrivalInformationListMutable() {
    return _arrivalInformationListProperty.getArrivalInformationListMutable();
}

void NavigationServiceStub::sendIntersectionMapUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IntersectionMapUpdate payload(_intersectionMapProperty);

        LOG_INFO ("-> send%s", "IntersectionMapUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("intersectionMap", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IntersectionMapUpdate");
    }
}

void NavigationServiceStub::onIntersectionMapGet(const ::boost::shared_ptr< IntersectionMapGet >& intersectionMap) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IntersectionMapGet", intersectionMap->getAct());
    sendIntersectionMapGetUpdate(_intersectionMapProperty.getIntersectionMap(), intersectionMap->getAct());
}

void NavigationServiceStub::sendIntersectionMapGetUpdate(const IntersectionMap& intersectionMap, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IntersectionMapGet payload(intersectionMap);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IntersectionMapGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIntersectionMap(const IntersectionMap& intersectionMap) {
    if(intersectionMap!=_intersectionMapProperty.getIntersectionMap()) {
        _intersectionMapProperty.setIntersectionMap(intersectionMap);
        sendIntersectionMapUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const IntersectionMap& NavigationServiceStub::getIntersectionMap() const {
    return _intersectionMapProperty.getIntersectionMap();
}

IntersectionMap& NavigationServiceStub::getIntersectionMapMutable() {
    return _intersectionMapProperty.getIntersectionMapMutable();
}

void NavigationServiceStub::sendIsAddressBookChangedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IsAddressBookChangedUpdate payload(_isAddressBookChangedProperty);

        LOG_INFO ("-> send%s", "IsAddressBookChangedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("isAddressBookChanged", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IsAddressBookChangedUpdate");
    }
}

void NavigationServiceStub::onIsAddressBookChangedGet(const ::boost::shared_ptr< IsAddressBookChangedGet >& isAddressBookChanged) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IsAddressBookChangedGet", isAddressBookChanged->getAct());
    sendIsAddressBookChangedGetUpdate(_isAddressBookChangedProperty.getIsAddressBookChanged(), isAddressBookChanged->getAct());
}

void NavigationServiceStub::sendIsAddressBookChangedGetUpdate(bool isAddressBookChanged, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IsAddressBookChangedGet payload(isAddressBookChanged);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IsAddressBookChangedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIsAddressBookChanged(bool isAddressBookChanged) {
    if(isAddressBookChanged!=_isAddressBookChangedProperty.getIsAddressBookChanged()) {
        _isAddressBookChangedProperty.setIsAddressBookChanged(isAddressBookChanged);
        sendIsAddressBookChangedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getIsAddressBookChanged() const {
    return _isAddressBookChangedProperty.getIsAddressBookChanged();
}

void NavigationServiceStub::sendIsMaxAllowedAddressBookEntriesStoredUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IsMaxAllowedAddressBookEntriesStoredUpdate payload(_isMaxAllowedAddressBookEntriesStoredProperty);

        LOG_INFO ("-> send%s", "IsMaxAllowedAddressBookEntriesStoredUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("isMaxAllowedAddressBookEntriesStored", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IsMaxAllowedAddressBookEntriesStoredUpdate");
    }
}

void NavigationServiceStub::onIsMaxAllowedAddressBookEntriesStoredGet(const ::boost::shared_ptr< IsMaxAllowedAddressBookEntriesStoredGet >& isMaxAllowedAddressBookEntriesStored) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IsMaxAllowedAddressBookEntriesStoredGet", isMaxAllowedAddressBookEntriesStored->getAct());
    sendIsMaxAllowedAddressBookEntriesStoredGetUpdate(_isMaxAllowedAddressBookEntriesStoredProperty.getIsMaxAllowedAddressBookEntriesStored(), isMaxAllowedAddressBookEntriesStored->getAct());
}

void NavigationServiceStub::sendIsMaxAllowedAddressBookEntriesStoredGetUpdate(bool isMaxAllowedAddressBookEntriesStored, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IsMaxAllowedAddressBookEntriesStoredGet payload(isMaxAllowedAddressBookEntriesStored);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IsMaxAllowedAddressBookEntriesStoredGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIsMaxAllowedAddressBookEntriesStored(bool isMaxAllowedAddressBookEntriesStored) {
    if(isMaxAllowedAddressBookEntriesStored!=_isMaxAllowedAddressBookEntriesStoredProperty.getIsMaxAllowedAddressBookEntriesStored()) {
        _isMaxAllowedAddressBookEntriesStoredProperty.setIsMaxAllowedAddressBookEntriesStored(isMaxAllowedAddressBookEntriesStored);
        sendIsMaxAllowedAddressBookEntriesStoredUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getIsMaxAllowedAddressBookEntriesStored() const {
    return _isMaxAllowedAddressBookEntriesStoredProperty.getIsMaxAllowedAddressBookEntriesStored();
}

void NavigationServiceStub::sendIsLastDestinationListChangedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IsLastDestinationListChangedUpdate payload(_isLastDestinationListChangedProperty);

        LOG_INFO ("-> send%s", "IsLastDestinationListChangedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("isLastDestinationListChanged", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IsLastDestinationListChangedUpdate");
    }
}

void NavigationServiceStub::onIsLastDestinationListChangedGet(const ::boost::shared_ptr< IsLastDestinationListChangedGet >& isLastDestinationListChanged) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IsLastDestinationListChangedGet", isLastDestinationListChanged->getAct());
    sendIsLastDestinationListChangedGetUpdate(_isLastDestinationListChangedProperty.getIsLastDestinationListChanged(), isLastDestinationListChanged->getAct());
}

void NavigationServiceStub::sendIsLastDestinationListChangedGetUpdate(bool isLastDestinationListChanged, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IsLastDestinationListChangedGet payload(isLastDestinationListChanged);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IsLastDestinationListChangedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIsLastDestinationListChanged(bool isLastDestinationListChanged) {
    if(isLastDestinationListChanged!=_isLastDestinationListChangedProperty.getIsLastDestinationListChanged()) {
        _isLastDestinationListChangedProperty.setIsLastDestinationListChanged(isLastDestinationListChanged);
        sendIsLastDestinationListChangedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getIsLastDestinationListChanged() const {
    return _isLastDestinationListChangedProperty.getIsLastDestinationListChanged();
}

void NavigationServiceStub::sendIsVoiceGuidanceActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IsVoiceGuidanceActiveUpdate payload(_isVoiceGuidanceActiveProperty);

        LOG_INFO ("-> send%s", "IsVoiceGuidanceActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("isVoiceGuidanceActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IsVoiceGuidanceActiveUpdate");
    }
}

void NavigationServiceStub::onIsVoiceGuidanceActiveGet(const ::boost::shared_ptr< IsVoiceGuidanceActiveGet >& isVoiceGuidanceActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IsVoiceGuidanceActiveGet", isVoiceGuidanceActive->getAct());
    sendIsVoiceGuidanceActiveGetUpdate(_isVoiceGuidanceActiveProperty.getIsVoiceGuidanceActive(), isVoiceGuidanceActive->getAct());
}

void NavigationServiceStub::sendIsVoiceGuidanceActiveGetUpdate(bool isVoiceGuidanceActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IsVoiceGuidanceActiveGet payload(isVoiceGuidanceActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IsVoiceGuidanceActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setIsVoiceGuidanceActive(bool isVoiceGuidanceActive) {
    if(isVoiceGuidanceActive!=_isVoiceGuidanceActiveProperty.getIsVoiceGuidanceActive()) {
        _isVoiceGuidanceActiveProperty.setIsVoiceGuidanceActive(isVoiceGuidanceActive);
        sendIsVoiceGuidanceActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getIsVoiceGuidanceActive() const {
    return _isVoiceGuidanceActiveProperty.getIsVoiceGuidanceActive();
}

void NavigationServiceStub::sendSdsVoiceTagWithOptionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsVoiceTagWithOptionsUpdate payload(_sdsVoiceTagWithOptionsProperty);

        LOG_INFO ("-> send%s", "SdsVoiceTagWithOptionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsVoiceTagWithOptions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsVoiceTagWithOptionsUpdate");
    }
}

void NavigationServiceStub::onSdsVoiceTagWithOptionsGet(const ::boost::shared_ptr< SdsVoiceTagWithOptionsGet >& sdsVoiceTagWithOptions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsVoiceTagWithOptionsGet", sdsVoiceTagWithOptions->getAct());
    sendSdsVoiceTagWithOptionsGetUpdate(_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions(), sdsVoiceTagWithOptions->getAct());
}

void NavigationServiceStub::sendSdsVoiceTagWithOptionsGetUpdate(const SDSVoiceTagId& sdsVoiceTagWithOptions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsVoiceTagWithOptionsGet payload(sdsVoiceTagWithOptions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsVoiceTagWithOptionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setSdsVoiceTagWithOptions(const SDSVoiceTagId& sdsVoiceTagWithOptions) {
    if(sdsVoiceTagWithOptions!=_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions()) {
        _sdsVoiceTagWithOptionsProperty.setSdsVoiceTagWithOptions(sdsVoiceTagWithOptions);
        sendSdsVoiceTagWithOptionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const SDSVoiceTagId& NavigationServiceStub::getSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions();
}

SDSVoiceTagId& NavigationServiceStub::getSdsVoiceTagWithOptionsMutable() {
    return _sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptionsMutable();
}

void NavigationServiceStub::sendTrafficMessagesCountUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TrafficMessagesCountUpdate payload(_trafficMessagesCountProperty);

        LOG_INFO ("-> send%s", "TrafficMessagesCountUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("trafficMessagesCount", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TrafficMessagesCountUpdate");
    }
}

void NavigationServiceStub::onTrafficMessagesCountGet(const ::boost::shared_ptr< TrafficMessagesCountGet >& trafficMessagesCount) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficMessagesCountGet", trafficMessagesCount->getAct());
    sendTrafficMessagesCountGetUpdate(_trafficMessagesCountProperty.getTrafficMessagesCount(), trafficMessagesCount->getAct());
}

void NavigationServiceStub::sendTrafficMessagesCountGetUpdate(uint8 trafficMessagesCount, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TrafficMessagesCountGet payload(trafficMessagesCount);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficMessagesCountGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::onTrafficMessagesCountSet(const ::boost::shared_ptr< TrafficMessagesCountSet >& trafficMessagesCount) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficMessagesCountSet", trafficMessagesCount->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*trafficMessagesCount, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTrafficMessagesCount (trafficMessagesCount->getTrafficMessagesCount());
    sendTrafficMessagesCountSetUpdate(trafficMessagesCount->getAct());
}

void NavigationServiceStub::sendTrafficMessagesCountSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficMessagesCountSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void NavigationServiceStub::setTrafficMessagesCount(uint8 trafficMessagesCount) {
    if(trafficMessagesCount!=_trafficMessagesCountProperty.getTrafficMessagesCount()) {
        _trafficMessagesCountProperty.setTrafficMessagesCount(trafficMessagesCount);
        sendTrafficMessagesCountUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 NavigationServiceStub::getTrafficMessagesCount() const {
    return _trafficMessagesCountProperty.getTrafficMessagesCount();
}

void NavigationServiceStub::sendTrafficServiceReceptionStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TrafficServiceReceptionStatusUpdate payload(_trafficServiceReceptionStatusProperty);

        LOG_INFO ("-> send%s", "TrafficServiceReceptionStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("trafficServiceReceptionStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TrafficServiceReceptionStatusUpdate");
    }
}

void NavigationServiceStub::onTrafficServiceReceptionStatusGet(const ::boost::shared_ptr< TrafficServiceReceptionStatusGet >& trafficServiceReceptionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficServiceReceptionStatusGet", trafficServiceReceptionStatus->getAct());
    sendTrafficServiceReceptionStatusGetUpdate(_trafficServiceReceptionStatusProperty.getTrafficServiceReceptionStatus(), trafficServiceReceptionStatus->getAct());
}

void NavigationServiceStub::sendTrafficServiceReceptionStatusGetUpdate(const TrafficServiceReceptionStatus& trafficServiceReceptionStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TrafficServiceReceptionStatusGet payload(trafficServiceReceptionStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficServiceReceptionStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::onTrafficServiceReceptionStatusSet(const ::boost::shared_ptr< TrafficServiceReceptionStatusSet >& trafficServiceReceptionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficServiceReceptionStatusSet", trafficServiceReceptionStatus->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*trafficServiceReceptionStatus, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTrafficServiceReceptionStatus (trafficServiceReceptionStatus->getTrafficServiceReceptionStatus());
    sendTrafficServiceReceptionStatusSetUpdate(trafficServiceReceptionStatus->getAct());
}

void NavigationServiceStub::sendTrafficServiceReceptionStatusSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficServiceReceptionStatusSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void NavigationServiceStub::setTrafficServiceReceptionStatus(const TrafficServiceReceptionStatus& trafficServiceReceptionStatus) {
    if(trafficServiceReceptionStatus!=_trafficServiceReceptionStatusProperty.getTrafficServiceReceptionStatus()) {
        _trafficServiceReceptionStatusProperty.setTrafficServiceReceptionStatus(trafficServiceReceptionStatus);
        sendTrafficServiceReceptionStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TrafficServiceReceptionStatus& NavigationServiceStub::getTrafficServiceReceptionStatus() const {
    return _trafficServiceReceptionStatusProperty.getTrafficServiceReceptionStatus();
}

TrafficServiceReceptionStatus& NavigationServiceStub::getTrafficServiceReceptionStatusMutable() {
    return _trafficServiceReceptionStatusProperty.getTrafficServiceReceptionStatusMutable();
}

void NavigationServiceStub::sendSdsPOICategoryShortcutsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SdsPOICategoryShortcutsUpdate payload(_sdsPOICategoryShortcutsProperty);

        LOG_INFO ("-> send%s", "SdsPOICategoryShortcutsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("sdsPOICategoryShortcuts", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SdsPOICategoryShortcutsUpdate");
    }
}

void NavigationServiceStub::onSdsPOICategoryShortcutsGet(const ::boost::shared_ptr< SdsPOICategoryShortcutsGet >& sdsPOICategoryShortcuts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SdsPOICategoryShortcutsGet", sdsPOICategoryShortcuts->getAct());
    sendSdsPOICategoryShortcutsGetUpdate(_sdsPOICategoryShortcutsProperty.getSdsPOICategoryShortcuts(), sdsPOICategoryShortcuts->getAct());
}

void NavigationServiceStub::sendSdsPOICategoryShortcutsGetUpdate(const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SdsPOICategoryShortcutsGet payload(sdsPOICategoryShortcuts);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SdsPOICategoryShortcutsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setSdsPOICategoryShortcuts(const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts) {
    if(sdsPOICategoryShortcuts!=_sdsPOICategoryShortcutsProperty.getSdsPOICategoryShortcuts()) {
        _sdsPOICategoryShortcutsProperty.setSdsPOICategoryShortcuts(sdsPOICategoryShortcuts);
        sendSdsPOICategoryShortcutsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< PoiCategoryShortcut >& NavigationServiceStub::getSdsPOICategoryShortcuts() const {
    return _sdsPOICategoryShortcutsProperty.getSdsPOICategoryShortcuts();
}

::std::vector< PoiCategoryShortcut >& NavigationServiceStub::getSdsPOICategoryShortcutsMutable() {
    return _sdsPOICategoryShortcutsProperty.getSdsPOICategoryShortcutsMutable();
}

void NavigationServiceStub::sendMenuPoiCategoryShortcutsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MenuPoiCategoryShortcutsUpdate payload(_menuPoiCategoryShortcutsProperty);

        LOG_INFO ("-> send%s", "MenuPoiCategoryShortcutsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("menuPoiCategoryShortcuts", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MenuPoiCategoryShortcutsUpdate");
    }
}

void NavigationServiceStub::onMenuPoiCategoryShortcutsGet(const ::boost::shared_ptr< MenuPoiCategoryShortcutsGet >& menuPoiCategoryShortcuts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MenuPoiCategoryShortcutsGet", menuPoiCategoryShortcuts->getAct());
    sendMenuPoiCategoryShortcutsGetUpdate(_menuPoiCategoryShortcutsProperty.getMenuPoiCategoryShortcuts(), menuPoiCategoryShortcuts->getAct());
}

void NavigationServiceStub::sendMenuPoiCategoryShortcutsGetUpdate(const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MenuPoiCategoryShortcutsGet payload(menuPoiCategoryShortcuts);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MenuPoiCategoryShortcutsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setMenuPoiCategoryShortcuts(const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts) {
    if(menuPoiCategoryShortcuts!=_menuPoiCategoryShortcutsProperty.getMenuPoiCategoryShortcuts()) {
        _menuPoiCategoryShortcutsProperty.setMenuPoiCategoryShortcuts(menuPoiCategoryShortcuts);
        sendMenuPoiCategoryShortcutsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< PoiCategoryShortcut >& NavigationServiceStub::getMenuPoiCategoryShortcuts() const {
    return _menuPoiCategoryShortcutsProperty.getMenuPoiCategoryShortcuts();
}

::std::vector< PoiCategoryShortcut >& NavigationServiceStub::getMenuPoiCategoryShortcutsMutable() {
    return _menuPoiCategoryShortcutsProperty.getMenuPoiCategoryShortcutsMutable();
}

void NavigationServiceStub::sendTripReplayStatusInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TripReplayStatusInfoUpdate payload(_tripReplayStatusInfoProperty);

        LOG_INFO ("-> send%s", "TripReplayStatusInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("tripReplayStatusInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TripReplayStatusInfoUpdate");
    }
}

void NavigationServiceStub::onTripReplayStatusInfoGet(const ::boost::shared_ptr< TripReplayStatusInfoGet >& tripReplayStatusInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TripReplayStatusInfoGet", tripReplayStatusInfo->getAct());
    sendTripReplayStatusInfoGetUpdate(_tripReplayStatusInfoProperty.getTripReplayStatusInfo(), tripReplayStatusInfo->getAct());
}

void NavigationServiceStub::sendTripReplayStatusInfoGetUpdate(const TripReplayStatusInfo& tripReplayStatusInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TripReplayStatusInfoGet payload(tripReplayStatusInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TripReplayStatusInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setTripReplayStatusInfo(const TripReplayStatusInfo& tripReplayStatusInfo) {
    if(tripReplayStatusInfo!=_tripReplayStatusInfoProperty.getTripReplayStatusInfo()) {
        _tripReplayStatusInfoProperty.setTripReplayStatusInfo(tripReplayStatusInfo);
        sendTripReplayStatusInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TripReplayStatusInfo& NavigationServiceStub::getTripReplayStatusInfo() const {
    return _tripReplayStatusInfoProperty.getTripReplayStatusInfo();
}

TripReplayStatusInfo& NavigationServiceStub::getTripReplayStatusInfoMutable() {
    return _tripReplayStatusInfoProperty.getTripReplayStatusInfoMutable();
}

void NavigationServiceStub::sendEtcStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EtcStatusUpdate payload(_etcStatusProperty);

        LOG_INFO ("-> send%s", "EtcStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("etcStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EtcStatusUpdate");
    }
}

void NavigationServiceStub::onEtcStatusGet(const ::boost::shared_ptr< EtcStatusGet >& etcStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EtcStatusGet", etcStatus->getAct());
    sendEtcStatusGetUpdate(_etcStatusProperty.getEtcStatus(), etcStatus->getAct());
}

void NavigationServiceStub::sendEtcStatusGetUpdate(ETCStatus etcStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EtcStatusGet payload(etcStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EtcStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setEtcStatus(ETCStatus etcStatus) {
    if(etcStatus!=_etcStatusProperty.getEtcStatus()) {
        _etcStatusProperty.setEtcStatus(etcStatus);
        sendEtcStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

ETCStatus NavigationServiceStub::getEtcStatus() const {
    return _etcStatusProperty.getEtcStatus();
}

void NavigationServiceStub::sendTrafficSignInfoActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TrafficSignInfoActiveUpdate payload(_TrafficSignInfoActiveProperty);

        LOG_INFO ("-> send%s", "TrafficSignInfoActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TrafficSignInfoActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TrafficSignInfoActiveUpdate");
    }
}

void NavigationServiceStub::onTrafficSignInfoActiveGet(const ::boost::shared_ptr< TrafficSignInfoActiveGet >& trafficSignInfoActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrafficSignInfoActiveGet", trafficSignInfoActive->getAct());
    sendTrafficSignInfoActiveGetUpdate(_TrafficSignInfoActiveProperty.getTrafficSignInfoActive(), trafficSignInfoActive->getAct());
}

void NavigationServiceStub::sendTrafficSignInfoActiveGetUpdate(bool trafficSignInfoActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TrafficSignInfoActiveGet payload(trafficSignInfoActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrafficSignInfoActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setTrafficSignInfoActive(bool trafficSignInfoActive) {
    if(trafficSignInfoActive!=_TrafficSignInfoActiveProperty.getTrafficSignInfoActive()) {
        _TrafficSignInfoActiveProperty.setTrafficSignInfoActive(trafficSignInfoActive);
        sendTrafficSignInfoActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getTrafficSignInfoActive() const {
    return _TrafficSignInfoActiveProperty.getTrafficSignInfoActive();
}

void NavigationServiceStub::sendOverSpeedSoundAlertInfoActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OverSpeedSoundAlertInfoActiveUpdate payload(_OverSpeedSoundAlertInfoActiveProperty);

        LOG_INFO ("-> send%s", "OverSpeedSoundAlertInfoActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OverSpeedSoundAlertInfoActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OverSpeedSoundAlertInfoActiveUpdate");
    }
}

void NavigationServiceStub::onOverSpeedSoundAlertInfoActiveGet(const ::boost::shared_ptr< OverSpeedSoundAlertInfoActiveGet >& overSpeedSoundAlertInfoActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OverSpeedSoundAlertInfoActiveGet", overSpeedSoundAlertInfoActive->getAct());
    sendOverSpeedSoundAlertInfoActiveGetUpdate(_OverSpeedSoundAlertInfoActiveProperty.getOverSpeedSoundAlertInfoActive(), overSpeedSoundAlertInfoActive->getAct());
}

void NavigationServiceStub::sendOverSpeedSoundAlertInfoActiveGetUpdate(bool overSpeedSoundAlertInfoActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OverSpeedSoundAlertInfoActiveGet payload(overSpeedSoundAlertInfoActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OverSpeedSoundAlertInfoActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setOverSpeedSoundAlertInfoActive(bool overSpeedSoundAlertInfoActive) {
    if(overSpeedSoundAlertInfoActive!=_OverSpeedSoundAlertInfoActiveProperty.getOverSpeedSoundAlertInfoActive()) {
        _OverSpeedSoundAlertInfoActiveProperty.setOverSpeedSoundAlertInfoActive(overSpeedSoundAlertInfoActive);
        sendOverSpeedSoundAlertInfoActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getOverSpeedSoundAlertInfoActive() const {
    return _OverSpeedSoundAlertInfoActiveProperty.getOverSpeedSoundAlertInfoActive();
}

void NavigationServiceStub::sendRouteRecalculationReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RouteRecalculationReasonUpdate payload(_routeRecalculationReasonProperty);

        LOG_INFO ("-> send%s", "RouteRecalculationReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("routeRecalculationReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RouteRecalculationReasonUpdate");
    }
}

void NavigationServiceStub::onRouteRecalculationReasonGet(const ::boost::shared_ptr< RouteRecalculationReasonGet >& routeRecalculationReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RouteRecalculationReasonGet", routeRecalculationReason->getAct());
    sendRouteRecalculationReasonGetUpdate(_routeRecalculationReasonProperty.getRouteRecalculationReason(), routeRecalculationReason->getAct());
}

void NavigationServiceStub::sendRouteRecalculationReasonGetUpdate(RouteRecalculationReason routeRecalculationReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RouteRecalculationReasonGet payload(routeRecalculationReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RouteRecalculationReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setRouteRecalculationReason(RouteRecalculationReason routeRecalculationReason) {
    if(routeRecalculationReason!=_routeRecalculationReasonProperty.getRouteRecalculationReason()) {
        _routeRecalculationReasonProperty.setRouteRecalculationReason(routeRecalculationReason);
        sendRouteRecalculationReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

RouteRecalculationReason NavigationServiceStub::getRouteRecalculationReason() const {
    return _routeRecalculationReasonProperty.getRouteRecalculationReason();
}

void NavigationServiceStub::sendRiskAreaDisplayInfoActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RiskAreaDisplayInfoActiveUpdate payload(_RiskAreaDisplayInfoActiveProperty);

        LOG_INFO ("-> send%s", "RiskAreaDisplayInfoActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RiskAreaDisplayInfoActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RiskAreaDisplayInfoActiveUpdate");
    }
}

void NavigationServiceStub::onRiskAreaDisplayInfoActiveGet(const ::boost::shared_ptr< RiskAreaDisplayInfoActiveGet >& riskAreaDisplayInfoActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RiskAreaDisplayInfoActiveGet", riskAreaDisplayInfoActive->getAct());
    sendRiskAreaDisplayInfoActiveGetUpdate(_RiskAreaDisplayInfoActiveProperty.getRiskAreaDisplayInfoActive(), riskAreaDisplayInfoActive->getAct());
}

void NavigationServiceStub::sendRiskAreaDisplayInfoActiveGetUpdate(bool riskAreaDisplayInfoActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RiskAreaDisplayInfoActiveGet payload(riskAreaDisplayInfoActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RiskAreaDisplayInfoActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setRiskAreaDisplayInfoActive(bool riskAreaDisplayInfoActive) {
    if(riskAreaDisplayInfoActive!=_RiskAreaDisplayInfoActiveProperty.getRiskAreaDisplayInfoActive()) {
        _RiskAreaDisplayInfoActiveProperty.setRiskAreaDisplayInfoActive(riskAreaDisplayInfoActive);
        sendRiskAreaDisplayInfoActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getRiskAreaDisplayInfoActive() const {
    return _RiskAreaDisplayInfoActiveProperty.getRiskAreaDisplayInfoActive();
}

void NavigationServiceStub::sendRiskAreaSoundAlertInfoActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RiskAreaSoundAlertInfoActiveUpdate payload(_RiskAreaSoundAlertInfoActiveProperty);

        LOG_INFO ("-> send%s", "RiskAreaSoundAlertInfoActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RiskAreaSoundAlertInfoActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RiskAreaSoundAlertInfoActiveUpdate");
    }
}

void NavigationServiceStub::onRiskAreaSoundAlertInfoActiveGet(const ::boost::shared_ptr< RiskAreaSoundAlertInfoActiveGet >& riskAreaSoundAlertInfoActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RiskAreaSoundAlertInfoActiveGet", riskAreaSoundAlertInfoActive->getAct());
    sendRiskAreaSoundAlertInfoActiveGetUpdate(_RiskAreaSoundAlertInfoActiveProperty.getRiskAreaSoundAlertInfoActive(), riskAreaSoundAlertInfoActive->getAct());
}

void NavigationServiceStub::sendRiskAreaSoundAlertInfoActiveGetUpdate(bool riskAreaSoundAlertInfoActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RiskAreaSoundAlertInfoActiveGet payload(riskAreaSoundAlertInfoActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RiskAreaSoundAlertInfoActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setRiskAreaSoundAlertInfoActive(bool riskAreaSoundAlertInfoActive) {
    if(riskAreaSoundAlertInfoActive!=_RiskAreaSoundAlertInfoActiveProperty.getRiskAreaSoundAlertInfoActive()) {
        _RiskAreaSoundAlertInfoActiveProperty.setRiskAreaSoundAlertInfoActive(riskAreaSoundAlertInfoActive);
        sendRiskAreaSoundAlertInfoActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool NavigationServiceStub::getRiskAreaSoundAlertInfoActive() const {
    return _RiskAreaSoundAlertInfoActiveProperty.getRiskAreaSoundAlertInfoActive();
}

void NavigationServiceStub::sendJamAheadListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JamAheadListUpdate payload(_jamAheadListProperty);

        LOG_INFO ("-> send%s", "JamAheadListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("jamAheadList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JamAheadListUpdate");
    }
}

void NavigationServiceStub::onJamAheadListGet(const ::boost::shared_ptr< JamAheadListGet >& jamAheadList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JamAheadListGet", jamAheadList->getAct());
    sendJamAheadListGetUpdate(_jamAheadListProperty.getJamAheadList(), jamAheadList->getAct());
}

void NavigationServiceStub::sendJamAheadListGetUpdate(const JamAheadList& jamAheadList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JamAheadListGet payload(jamAheadList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JamAheadListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setJamAheadList(const JamAheadList& jamAheadList) {
    if(jamAheadList!=_jamAheadListProperty.getJamAheadList()) {
        _jamAheadListProperty.setJamAheadList(jamAheadList);
        sendJamAheadListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const JamAheadList& NavigationServiceStub::getJamAheadList() const {
    return _jamAheadListProperty.getJamAheadList();
}

JamAheadList& NavigationServiceStub::getJamAheadListMutable() {
    return _jamAheadListProperty.getJamAheadListMutable();
}

void NavigationServiceStub::sendWaypointOperationStatusListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WaypointOperationStatusListUpdate payload(_waypointOperationStatusListProperty);

        LOG_INFO ("-> send%s", "WaypointOperationStatusListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("waypointOperationStatusList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WaypointOperationStatusListUpdate");
    }
}

void NavigationServiceStub::onWaypointOperationStatusListGet(const ::boost::shared_ptr< WaypointOperationStatusListGet >& waypointOperationStatusList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WaypointOperationStatusListGet", waypointOperationStatusList->getAct());
    sendWaypointOperationStatusListGetUpdate(_waypointOperationStatusListProperty.getWaypointOperationStatusList(), waypointOperationStatusList->getAct());
}

void NavigationServiceStub::sendWaypointOperationStatusListGetUpdate(const ::std::vector< WaypointOperationStatus >& waypointOperationStatusList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WaypointOperationStatusListGet payload(waypointOperationStatusList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WaypointOperationStatusListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setWaypointOperationStatusList(const ::std::vector< WaypointOperationStatus >& waypointOperationStatusList) {
    if(waypointOperationStatusList!=_waypointOperationStatusListProperty.getWaypointOperationStatusList()) {
        _waypointOperationStatusListProperty.setWaypointOperationStatusList(waypointOperationStatusList);
        sendWaypointOperationStatusListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< WaypointOperationStatus >& NavigationServiceStub::getWaypointOperationStatusList() const {
    return _waypointOperationStatusListProperty.getWaypointOperationStatusList();
}

::std::vector< WaypointOperationStatus >& NavigationServiceStub::getWaypointOperationStatusListMutable() {
    return _waypointOperationStatusListProperty.getWaypointOperationStatusListMutable();
}

void NavigationServiceStub::sendDestinationReachedStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DestinationReachedStatusUpdate payload(_destinationReachedStatusProperty);

        LOG_INFO ("-> send%s", "DestinationReachedStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("destinationReachedStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DestinationReachedStatusUpdate");
    }
}

void NavigationServiceStub::onDestinationReachedStatusGet(const ::boost::shared_ptr< DestinationReachedStatusGet >& destinationReachedStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DestinationReachedStatusGet", destinationReachedStatus->getAct());
    sendDestinationReachedStatusGetUpdate(_destinationReachedStatusProperty.getDestinationReachedStatus(), destinationReachedStatus->getAct());
}

void NavigationServiceStub::sendDestinationReachedStatusGetUpdate(DestinationReachedStatus destinationReachedStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DestinationReachedStatusGet payload(destinationReachedStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DestinationReachedStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setDestinationReachedStatus(DestinationReachedStatus destinationReachedStatus) {
    if(destinationReachedStatus!=_destinationReachedStatusProperty.getDestinationReachedStatus()) {
        _destinationReachedStatusProperty.setDestinationReachedStatus(destinationReachedStatus);
        sendDestinationReachedStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

DestinationReachedStatus NavigationServiceStub::getDestinationReachedStatus() const {
    return _destinationReachedStatusProperty.getDestinationReachedStatus();
}

void NavigationServiceStub::sendLightModeStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LightModeStatusUpdate payload(_lightModeStatusProperty);

        LOG_INFO ("-> send%s", "LightModeStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("lightModeStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LightModeStatusUpdate");
    }
}

void NavigationServiceStub::onLightModeStatusGet(const ::boost::shared_ptr< LightModeStatusGet >& lightModeStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LightModeStatusGet", lightModeStatus->getAct());
    sendLightModeStatusGetUpdate(_lightModeStatusProperty.getLightModeStatus(), lightModeStatus->getAct());
}

void NavigationServiceStub::sendLightModeStatusGetUpdate(LightModeStatus lightModeStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LightModeStatusGet payload(lightModeStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LightModeStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setLightModeStatus(LightModeStatus lightModeStatus) {
    if(lightModeStatus!=_lightModeStatusProperty.getLightModeStatus()) {
        _lightModeStatusProperty.setLightModeStatus(lightModeStatus);
        sendLightModeStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

LightModeStatus NavigationServiceStub::getLightModeStatus() const {
    return _lightModeStatusProperty.getLightModeStatus();
}

void NavigationServiceStub::sendMapCameraDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapCameraDataUpdate payload(_mapCameraDataProperty);

        LOG_INFO ("-> send%s", "MapCameraDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("mapCameraData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.navigation.NavigationService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapCameraDataUpdate");
    }
}

void NavigationServiceStub::onMapCameraDataGet(const ::boost::shared_ptr< MapCameraDataGet >& mapCameraData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapCameraDataGet", mapCameraData->getAct());
    sendMapCameraDataGetUpdate(_mapCameraDataProperty.getMapCameraData(), mapCameraData->getAct());
}

void NavigationServiceStub::sendMapCameraDataGetUpdate(const MapCameraData& mapCameraData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapCameraDataGet payload(mapCameraData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapCameraDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void NavigationServiceStub::setMapCameraData(const MapCameraData& mapCameraData) {
    if(mapCameraData!=_mapCameraDataProperty.getMapCameraData()) {
        _mapCameraDataProperty.setMapCameraData(mapCameraData);
        sendMapCameraDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const MapCameraData& NavigationServiceStub::getMapCameraData() const {
    return _mapCameraDataProperty.getMapCameraData();
}

MapCameraData& NavigationServiceStub::getMapCameraDataMutable() {
    return _mapCameraDataProperty.getMapCameraDataMutable();
}

void  NavigationServiceStub::sendSelectPoiCategoryShortcutResponse (act_t act) {
    SelectPoiCategoryShortcutResponse* payload = new SelectPoiCategoryShortcutResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "selectPoiCategoryShortcut", SelectPoiCategoryShortcutResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SelectPoiCategoryShortcut", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSelectPoiCategoryShortcutError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectPoiCategoryShortcutError* payload = new SelectPoiCategoryShortcutError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "selectPoiCategoryShortcut", SelectPoiCategoryShortcutError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SelectPoiCategoryShortcut", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendGetPoiCategoryShortcutsResponse (const ::std::vector< PoiCategoryShortcut >& poiCategoryShortcuts, act_t act) {
    GetPoiCategoryShortcutsResponse* payload = new GetPoiCategoryShortcutsResponse(poiCategoryShortcuts);
    DBUS_MESSAGE_REPLY(dbusMessage, "getPoiCategoryShortcuts", GetPoiCategoryShortcutsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetPoiCategoryShortcuts", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendGetPoiCategoryShortcutsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPoiCategoryShortcutsError* payload = new GetPoiCategoryShortcutsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getPoiCategoryShortcuts", GetPoiCategoryShortcutsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetPoiCategoryShortcuts", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithCoordinatesResponse (act_t act) {
    SetLocationWithCoordinatesResponse* payload = new SetLocationWithCoordinatesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithCoordinates", SetLocationWithCoordinatesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithCoordinatesError* payload = new SetLocationWithCoordinatesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithCoordinates", SetLocationWithCoordinatesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithDetailsResponse (act_t act) {
    SetLocationWithDetailsResponse* payload = new SetLocationWithDetailsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithDetails", SetLocationWithDetailsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithDetailsError* payload = new SetLocationWithDetailsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithDetails", SetLocationWithDetailsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowPOILocationFromTCUResponse (act_t act) {
    ShowPOILocationFromTCUResponse* payload = new ShowPOILocationFromTCUResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showPOILocationFromTCU", ShowPOILocationFromTCUResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowPOILocationFromTCU", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowPOILocationFromTCUError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowPOILocationFromTCUError* payload = new ShowPOILocationFromTCUError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showPOILocationFromTCU", ShowPOILocationFromTCUError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowPOILocationFromTCU", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStorePOILocationToAddressBookResponse (act_t act) {
    StorePOILocationToAddressBookResponse* payload = new StorePOILocationToAddressBookResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storePOILocationToAddressBook", StorePOILocationToAddressBookResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StorePOILocationToAddressBook", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStorePOILocationToAddressBookError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StorePOILocationToAddressBookError* payload = new StorePOILocationToAddressBookError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storePOILocationToAddressBook", StorePOILocationToAddressBookError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StorePOILocationToAddressBook", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStoreLocationToAddressBookResponse (act_t act) {
    StoreLocationToAddressBookResponse* payload = new StoreLocationToAddressBookResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "storeLocationToAddressBook", StoreLocationToAddressBookResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StoreLocationToAddressBook", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStoreLocationToAddressBookError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StoreLocationToAddressBookError* payload = new StoreLocationToAddressBookError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "storeLocationToAddressBook", StoreLocationToAddressBookError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StoreLocationToAddressBook", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDestinationOverviewFromTCUResponse (act_t act) {
    ShowDestinationOverviewFromTCUResponse* payload = new ShowDestinationOverviewFromTCUResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showDestinationOverviewFromTCU", ShowDestinationOverviewFromTCUResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowDestinationOverviewFromTCU", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDestinationOverviewFromTCUError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowDestinationOverviewFromTCUError* payload = new ShowDestinationOverviewFromTCUError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showDestinationOverviewFromTCU", ShowDestinationOverviewFromTCUError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowDestinationOverviewFromTCU", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCalculateTourResponse (act_t act) {
    ShowCalculateTourResponse* payload = new ShowCalculateTourResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showCalculateTour", ShowCalculateTourResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowCalculateTour", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCalculateTourError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowCalculateTourError* payload = new ShowCalculateTourError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showCalculateTour", ShowCalculateTourError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowCalculateTour", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowOnMapResponse (act_t act) {
    ShowOnMapResponse* payload = new ShowOnMapResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showOnMap", ShowOnMapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowOnMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowOnMapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowOnMapError* payload = new ShowOnMapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showOnMap", ShowOnMapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowOnMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCarsorLocationOnMapResponse (act_t act) {
    ShowCarsorLocationOnMapResponse* payload = new ShowCarsorLocationOnMapResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showCarsorLocationOnMap", ShowCarsorLocationOnMapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowCarsorLocationOnMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCarsorLocationOnMapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowCarsorLocationOnMapError* payload = new ShowCarsorLocationOnMapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showCarsorLocationOnMap", ShowCarsorLocationOnMapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowCarsorLocationOnMap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCityInputAndGetCityCoordinatesResponse (const PositionWGS84& cityCenterCoordinate, bool isValidAddress, act_t act) {
    ShowCityInputAndGetCityCoordinatesResponse* payload = new ShowCityInputAndGetCityCoordinatesResponse(cityCenterCoordinate, isValidAddress);
    DBUS_MESSAGE_REPLY(dbusMessage, "showCityInputAndGetCityCoordinates", ShowCityInputAndGetCityCoordinatesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowCityInputAndGetCityCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowCityInputAndGetCityCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowCityInputAndGetCityCoordinatesError* payload = new ShowCityInputAndGetCityCoordinatesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showCityInputAndGetCityCoordinates", ShowCityInputAndGetCityCoordinatesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowCityInputAndGetCityCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestLocationDetailsForCoordinatesResponse (const LocationDetails& locationDetails, act_t act) {
    RequestLocationDetailsForCoordinatesResponse* payload = new RequestLocationDetailsForCoordinatesResponse(locationDetails);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestLocationDetailsForCoordinates", RequestLocationDetailsForCoordinatesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestLocationDetailsForCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestLocationDetailsForCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestLocationDetailsForCoordinatesError* payload = new RequestLocationDetailsForCoordinatesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestLocationDetailsForCoordinates", RequestLocationDetailsForCoordinatesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestLocationDetailsForCoordinates", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowAdjustCurrentLocationScreenResponse (act_t act) {
    ShowAdjustCurrentLocationScreenResponse* payload = new ShowAdjustCurrentLocationScreenResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showAdjustCurrentLocationScreen", ShowAdjustCurrentLocationScreenResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowAdjustCurrentLocationScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowAdjustCurrentLocationScreenError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowAdjustCurrentLocationScreenError* payload = new ShowAdjustCurrentLocationScreenError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showAdjustCurrentLocationScreen", ShowAdjustCurrentLocationScreenError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowAdjustCurrentLocationScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowWhereAmIScreenResponse (act_t act) {
    ShowWhereAmIScreenResponse* payload = new ShowWhereAmIScreenResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showWhereAmIScreen", ShowWhereAmIScreenResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowWhereAmIScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowWhereAmIScreenError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowWhereAmIScreenError* payload = new ShowWhereAmIScreenError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showWhereAmIScreen", ShowWhereAmIScreenError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowWhereAmIScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowTrafficInfoScreenResponse (act_t act) {
    ShowTrafficInfoScreenResponse* payload = new ShowTrafficInfoScreenResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showTrafficInfoScreen", ShowTrafficInfoScreenResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowTrafficInfoScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowTrafficInfoScreenError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowTrafficInfoScreenError* payload = new ShowTrafficInfoScreenError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showTrafficInfoScreen", ShowTrafficInfoScreenError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowTrafficInfoScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowMapScreenWithMapViewModeResponse (act_t act) {
    ShowMapScreenWithMapViewModeResponse* payload = new ShowMapScreenWithMapViewModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showMapScreenWithMapViewMode", ShowMapScreenWithMapViewModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowMapScreenWithMapViewMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowMapScreenWithMapViewModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowMapScreenWithMapViewModeError* payload = new ShowMapScreenWithMapViewModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showMapScreenWithMapViewMode", ShowMapScreenWithMapViewModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowMapScreenWithMapViewMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowMapScreenCarsorLockModeResponse (act_t act) {
    ShowMapScreenCarsorLockModeResponse* payload = new ShowMapScreenCarsorLockModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showMapScreenCarsorLockMode", ShowMapScreenCarsorLockModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowMapScreenCarsorLockMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowMapScreenCarsorLockModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowMapScreenCarsorLockModeError* payload = new ShowMapScreenCarsorLockModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showMapScreenCarsorLockMode", ShowMapScreenCarsorLockModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowMapScreenCarsorLockMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDeleteWaypointListScreenResponse (act_t act) {
    ShowDeleteWaypointListScreenResponse* payload = new ShowDeleteWaypointListScreenResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showDeleteWaypointListScreen", ShowDeleteWaypointListScreenResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowDeleteWaypointListScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDeleteWaypointListScreenError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowDeleteWaypointListScreenError* payload = new ShowDeleteWaypointListScreenError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showDeleteWaypointListScreen", ShowDeleteWaypointListScreenError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowDeleteWaypointListScreen", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomInStepResponse (act_t act) {
    SetZoomInStepResponse* payload = new SetZoomInStepResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setZoomInStep", SetZoomInStepResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetZoomInStep", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomInStepError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetZoomInStepError* payload = new SetZoomInStepError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setZoomInStep", SetZoomInStepError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetZoomInStep", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomOutStepResponse (act_t act) {
    SetZoomOutStepResponse* payload = new SetZoomOutStepResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setZoomOutStep", SetZoomOutStepResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetZoomOutStep", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomOutStepError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetZoomOutStepError* payload = new SetZoomOutStepError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setZoomOutStep", SetZoomOutStepError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetZoomOutStep", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomLevelResponse (act_t act) {
    SetZoomLevelResponse* payload = new SetZoomLevelResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setZoomLevel", SetZoomLevelResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetZoomLevel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetZoomLevelError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetZoomLevelError* payload = new SetZoomLevelError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setZoomLevel", SetZoomLevelError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetZoomLevel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendGetVersionStringResponse (const ::std::string& versionString, act_t act) {
    GetVersionStringResponse* payload = new GetVersionStringResponse(versionString);
    DBUS_MESSAGE_REPLY(dbusMessage, "getVersionString", GetVersionStringResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetVersionString", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendGetVersionStringError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetVersionStringError* payload = new GetVersionStringError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getVersionString", GetVersionStringError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetVersionString", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetSXMTravelLinkSubscriptionStatusResponse (act_t act) {
    SetSXMTravelLinkSubscriptionStatusResponse* payload = new SetSXMTravelLinkSubscriptionStatusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setSXMTravelLinkSubscriptionStatus", SetSXMTravelLinkSubscriptionStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSXMTravelLinkSubscriptionStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetSXMTravelLinkSubscriptionStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSXMTravelLinkSubscriptionStatusError* payload = new SetSXMTravelLinkSubscriptionStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setSXMTravelLinkSubscriptionStatus", SetSXMTravelLinkSubscriptionStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSXMTravelLinkSubscriptionStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceResponse (act_t act) {
    StartGuidanceResponse* payload = new StartGuidanceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "startGuidance", StartGuidanceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartGuidanceError* payload = new StartGuidanceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startGuidance", StartGuidanceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToPosWGS84Response (act_t act) {
    StartGuidanceToPosWGS84Response* payload = new StartGuidanceToPosWGS84Response;
    DBUS_MESSAGE_REPLY(dbusMessage, "startGuidanceToPosWGS84", StartGuidanceToPosWGS84Response, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartGuidanceToPosWGS84", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToPosWGS84Error (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartGuidanceToPosWGS84Error* payload = new StartGuidanceToPosWGS84Error(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startGuidanceToPosWGS84", StartGuidanceToPosWGS84Error, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartGuidanceToPosWGS84", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToHomeLocationResponse (act_t act) {
    StartGuidanceToHomeLocationResponse* payload = new StartGuidanceToHomeLocationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "startGuidanceToHomeLocation", StartGuidanceToHomeLocationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartGuidanceToHomeLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToHomeLocationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartGuidanceToHomeLocationError* payload = new StartGuidanceToHomeLocationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startGuidanceToHomeLocation", StartGuidanceToHomeLocationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartGuidanceToHomeLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToWorkLocationResponse (act_t act) {
    StartGuidanceToWorkLocationResponse* payload = new StartGuidanceToWorkLocationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "startGuidanceToWorkLocation", StartGuidanceToWorkLocationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartGuidanceToWorkLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartGuidanceToWorkLocationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartGuidanceToWorkLocationError* payload = new StartGuidanceToWorkLocationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startGuidanceToWorkLocation", StartGuidanceToWorkLocationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartGuidanceToWorkLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithDestinationMemoryEntryResponse (act_t act) {
    SetLocationWithDestinationMemoryEntryResponse* payload = new SetLocationWithDestinationMemoryEntryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithDestinationMemoryEntry", SetLocationWithDestinationMemoryEntryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithDestinationMemoryEntry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithDestinationMemoryEntryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithDestinationMemoryEntryError* payload = new SetLocationWithDestinationMemoryEntryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithDestinationMemoryEntry", SetLocationWithDestinationMemoryEntryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithDestinationMemoryEntry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCancelRouteGuidanceResponse (act_t act) {
    CancelRouteGuidanceResponse* payload = new CancelRouteGuidanceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "cancelRouteGuidance", CancelRouteGuidanceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelRouteGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCancelRouteGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelRouteGuidanceError* payload = new CancelRouteGuidanceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "cancelRouteGuidance", CancelRouteGuidanceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelRouteGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendInsertWaypointResponse (act_t act) {
    InsertWaypointResponse* payload = new InsertWaypointResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "insertWaypoint", InsertWaypointResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "InsertWaypoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendInsertWaypointError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    InsertWaypointError* payload = new InsertWaypointError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "insertWaypoint", InsertWaypointError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "InsertWaypoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendInsertWaypointAtDefaultPositionResponse (act_t act) {
    InsertWaypointAtDefaultPositionResponse* payload = new InsertWaypointAtDefaultPositionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "insertWaypointAtDefaultPosition", InsertWaypointAtDefaultPositionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "InsertWaypointAtDefaultPosition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendInsertWaypointAtDefaultPositionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    InsertWaypointAtDefaultPositionError* payload = new InsertWaypointAtDefaultPositionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "insertWaypointAtDefaultPosition", InsertWaypointAtDefaultPositionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "InsertWaypointAtDefaultPosition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendReplaceWaypointResponse (act_t act) {
    ReplaceWaypointResponse* payload = new ReplaceWaypointResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "replaceWaypoint", ReplaceWaypointResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReplaceWaypoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendReplaceWaypointError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReplaceWaypointError* payload = new ReplaceWaypointError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "replaceWaypoint", ReplaceWaypointError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReplaceWaypoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendDeleteWaypointsResponse (act_t act) {
    DeleteWaypointsResponse* payload = new DeleteWaypointsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "deleteWaypoints", DeleteWaypointsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeleteWaypoints", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendDeleteWaypointsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeleteWaypointsError* payload = new DeleteWaypointsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "deleteWaypoints", DeleteWaypointsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeleteWaypoints", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendApplyWaypointListChangeResponse (act_t act) {
    ApplyWaypointListChangeResponse* payload = new ApplyWaypointListChangeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "applyWaypointListChange", ApplyWaypointListChangeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ApplyWaypointListChange", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendApplyWaypointListChangeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ApplyWaypointListChangeError* payload = new ApplyWaypointListChangeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "applyWaypointListChange", ApplyWaypointListChangeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ApplyWaypointListChange", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestWaypointListResponse (act_t act) {
    RequestWaypointListResponse* payload = new RequestWaypointListResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "requestWaypointList", RequestWaypointListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestWaypointList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestWaypointListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestWaypointListError* payload = new RequestWaypointListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestWaypointList", RequestWaypointListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestWaypointList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestSetFreeTextSearchTypeResponse (act_t act) {
    RequestSetFreeTextSearchTypeResponse* payload = new RequestSetFreeTextSearchTypeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "requestSetFreeTextSearchType", RequestSetFreeTextSearchTypeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestSetFreeTextSearchType", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestSetFreeTextSearchTypeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestSetFreeTextSearchTypeError* payload = new RequestSetFreeTextSearchTypeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestSetFreeTextSearchType", RequestSetFreeTextSearchTypeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestSetFreeTextSearchType", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestFreeTextSearchResultsResponse (const ::std::vector< AddressListElement >& searchResults, act_t act) {
    RequestFreeTextSearchResultsResponse* payload = new RequestFreeTextSearchResultsResponse(searchResults);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestFreeTextSearchResults", RequestFreeTextSearchResultsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestFreeTextSearchResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestFreeTextSearchResultsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestFreeTextSearchResultsError* payload = new RequestFreeTextSearchResultsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestFreeTextSearchResults", RequestFreeTextSearchResultsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestFreeTextSearchResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendUndoFreeTextSearchElementSelectionResponse (act_t act) {
    UndoFreeTextSearchElementSelectionResponse* payload = new UndoFreeTextSearchElementSelectionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "undoFreeTextSearchElementSelection", UndoFreeTextSearchElementSelectionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UndoFreeTextSearchElementSelection", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendUndoFreeTextSearchElementSelectionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UndoFreeTextSearchElementSelectionError* payload = new UndoFreeTextSearchElementSelectionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "undoFreeTextSearchElementSelection", UndoFreeTextSearchElementSelectionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UndoFreeTextSearchElementSelection", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithFreeTextSearchInputResponse (act_t act) {
    SetLocationWithFreeTextSearchInputResponse* payload = new SetLocationWithFreeTextSearchInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithFreeTextSearchInput", SetLocationWithFreeTextSearchInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithFreeTextSearchInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithFreeTextSearchInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithFreeTextSearchInputError* payload = new SetLocationWithFreeTextSearchInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithFreeTextSearchInput", SetLocationWithFreeTextSearchInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithFreeTextSearchInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDestinationFreeTextSearchInputResponse (act_t act) {
    ShowDestinationFreeTextSearchInputResponse* payload = new ShowDestinationFreeTextSearchInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showDestinationFreeTextSearchInput", ShowDestinationFreeTextSearchInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowDestinationFreeTextSearchInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowDestinationFreeTextSearchInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowDestinationFreeTextSearchInputError* payload = new ShowDestinationFreeTextSearchInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showDestinationFreeTextSearchInput", ShowDestinationFreeTextSearchInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowDestinationFreeTextSearchInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestFixedPOICategorySearchResultsResponse (const ::std::vector< AddressListElement >& searchResults, act_t act) {
    RequestFixedPOICategorySearchResultsResponse* payload = new RequestFixedPOICategorySearchResultsResponse(searchResults);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestFixedPOICategorySearchResults", RequestFixedPOICategorySearchResultsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestFixedPOICategorySearchResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestFixedPOICategorySearchResultsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestFixedPOICategorySearchResultsError* payload = new RequestFixedPOICategorySearchResultsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestFixedPOICategorySearchResults", RequestFixedPOICategorySearchResultsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestFixedPOICategorySearchResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendUndoSetLocationWithFixedPOICategoryInputResponse (act_t act) {
    UndoSetLocationWithFixedPOICategoryInputResponse* payload = new UndoSetLocationWithFixedPOICategoryInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "undoSetLocationWithFixedPOICategoryInput", UndoSetLocationWithFixedPOICategoryInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UndoSetLocationWithFixedPOICategoryInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendUndoSetLocationWithFixedPOICategoryInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UndoSetLocationWithFixedPOICategoryInputError* payload = new UndoSetLocationWithFixedPOICategoryInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "undoSetLocationWithFixedPOICategoryInput", UndoSetLocationWithFixedPOICategoryInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UndoSetLocationWithFixedPOICategoryInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithFixedPOICategoryInputResponse (act_t act) {
    SetLocationWithFixedPOICategoryInputResponse* payload = new SetLocationWithFixedPOICategoryInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithFixedPOICategoryInput", SetLocationWithFixedPOICategoryInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithFixedPOICategoryInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithFixedPOICategoryInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithFixedPOICategoryInputError* payload = new SetLocationWithFixedPOICategoryInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithFixedPOICategoryInput", SetLocationWithFixedPOICategoryInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithFixedPOICategoryInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsCheckAddressResponse (act_t act) {
    SdsCheckAddressResponse* payload = new SdsCheckAddressResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsCheckAddress", SdsCheckAddressResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsCheckAddress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsCheckAddressError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsCheckAddressError* payload = new SdsCheckAddressError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsCheckAddress", SdsCheckAddressError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsCheckAddress", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements, act_t act) {
    SdsGetRefinementListResponse* payload = new SdsGetRefinementListResponse(refinements);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsGetRefinementList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsGetRefinementListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsGetRefinementListError* payload = new SdsGetRefinementListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsGetRefinementList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSelectSdsRefinementResponse (act_t act) {
    SelectSdsRefinementResponse* payload = new SelectSdsRefinementResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "selectSdsRefinement", SelectSdsRefinementResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SelectSdsRefinement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSelectSdsRefinementError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectSdsRefinementError* payload = new SelectSdsRefinementError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "selectSdsRefinement", SelectSdsRefinementError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SelectSdsRefinement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithSdsInputResponse (act_t act) {
    SetLocationWithSdsInputResponse* payload = new SetLocationWithSdsInputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLocationWithSdsInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetLocationWithSdsInputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLocationWithSdsInputError* payload = new SetLocationWithSdsInputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLocationWithSdsInput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDestinationMemoryEntriesResponse (const ::std::vector< DestinationMemoryDetailListElement >& destinationMemoryEntries, act_t act) {
    RequestDestinationMemoryEntriesResponse* payload = new RequestDestinationMemoryEntriesResponse(destinationMemoryEntries);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestDestinationMemoryEntries", RequestDestinationMemoryEntriesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestDestinationMemoryEntries", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDestinationMemoryEntriesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestDestinationMemoryEntriesError* payload = new RequestDestinationMemoryEntriesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestDestinationMemoryEntries", RequestDestinationMemoryEntriesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestDestinationMemoryEntries", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetMapRepresentationResponse (act_t act) {
    SetMapRepresentationResponse* payload = new SetMapRepresentationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setMapRepresentation", SetMapRepresentationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMapRepresentation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetMapRepresentationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMapRepresentationError* payload = new SetMapRepresentationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setMapRepresentation", SetMapRepresentationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMapRepresentation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDetailsForSelectedLocationResponse (const LocationDetails& locationDetail, act_t act) {
    RequestDetailsForSelectedLocationResponse* payload = new RequestDetailsForSelectedLocationResponse(locationDetail);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestDetailsForSelectedLocation", RequestDetailsForSelectedLocationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestDetailsForSelectedLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDetailsForSelectedLocationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestDetailsForSelectedLocationError* payload = new RequestDetailsForSelectedLocationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestDetailsForSelectedLocation", RequestDetailsForSelectedLocationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestDetailsForSelectedLocation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRetriggerAcousticOutputResponse (act_t act) {
    RetriggerAcousticOutputResponse* payload = new RetriggerAcousticOutputResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "retriggerAcousticOutput", RetriggerAcousticOutputResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RetriggerAcousticOutput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRetriggerAcousticOutputError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RetriggerAcousticOutputError* payload = new RetriggerAcousticOutputError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "retriggerAcousticOutput", RetriggerAcousticOutputError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RetriggerAcousticOutput", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSpeakSamplePhraseResponse (act_t act) {
    SpeakSamplePhraseResponse* payload = new SpeakSamplePhraseResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "speakSamplePhrase", SpeakSamplePhraseResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SpeakSamplePhrase", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSpeakSamplePhraseError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SpeakSamplePhraseError* payload = new SpeakSamplePhraseError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "speakSamplePhrase", SpeakSamplePhraseError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SpeakSamplePhrase", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetRouteCriterionResponse (act_t act) {
    SetRouteCriterionResponse* payload = new SetRouteCriterionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setRouteCriterion", SetRouteCriterionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetRouteCriterion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetRouteCriterionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetRouteCriterionError* payload = new SetRouteCriterionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setRouteCriterion", SetRouteCriterionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetRouteCriterion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetVoiceGuidanceResponse (act_t act) {
    SetVoiceGuidanceResponse* payload = new SetVoiceGuidanceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setVoiceGuidance", SetVoiceGuidanceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetVoiceGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetVoiceGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetVoiceGuidanceError* payload = new SetVoiceGuidanceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setVoiceGuidance", SetVoiceGuidanceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetVoiceGuidance", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCheckNavDataCompatibilityResponse (NavDataCompatibility compatibility, act_t act) {
    CheckNavDataCompatibilityResponse* payload = new CheckNavDataCompatibilityResponse(compatibility);
    DBUS_MESSAGE_REPLY(dbusMessage, "CheckNavDataCompatibility", CheckNavDataCompatibilityResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CheckNavDataCompatibility", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCheckNavDataCompatibilityError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CheckNavDataCompatibilityError* payload = new CheckNavDataCompatibilityError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CheckNavDataCompatibility", CheckNavDataCompatibilityError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CheckNavDataCompatibility", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsUpdateVoiceTagResponse (act_t act) {
    SdsUpdateVoiceTagResponse* payload = new SdsUpdateVoiceTagResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsUpdateVoiceTag", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsUpdateVoiceTagError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsUpdateVoiceTagError* payload = new SdsUpdateVoiceTagError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsUpdateVoiceTag", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber, const ::std::string& maxHouseNumber, const ::std::vector< ::std::string >& patterns, act_t act) {
    SdsGetHouseNumberPatternResponse* payload = new SdsGetHouseNumberPatternResponse(minHouseNumber, maxHouseNumber, patterns);
    DBUS_MESSAGE_REPLY(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SdsGetHouseNumberPattern", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSdsGetHouseNumberPatternError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SdsGetHouseNumberPatternError* payload = new SdsGetHouseNumberPatternError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SdsGetHouseNumberPattern", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetMapLightModeResponse (act_t act) {
    SetMapLightModeResponse* payload = new SetMapLightModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setMapLightMode", SetMapLightModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMapLightMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetMapLightModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMapLightModeError* payload = new SetMapLightModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setMapLightMode", SetMapLightModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMapLightMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartTripReplayResponse (act_t act) {
    StartTripReplayResponse* payload = new StartTripReplayResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "startTripReplay", StartTripReplayResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStartTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartTripReplayError* payload = new StartTripReplayError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "startTripReplay", StartTripReplayError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStopTripReplayResponse (act_t act) {
    StopTripReplayResponse* payload = new StopTripReplayResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "stopTripReplay", StopTripReplayResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendStopTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopTripReplayError* payload = new StopTripReplayError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "stopTripReplay", StopTripReplayError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSeekTripReplayResponse (act_t act) {
    SeekTripReplayResponse* payload = new SeekTripReplayResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "seekTripReplay", SeekTripReplayResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SeekTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSeekTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SeekTripReplayError* payload = new SeekTripReplayError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "seekTripReplay", SeekTripReplayError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SeekTripReplay", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetTripReplayModeResponse (act_t act) {
    SetTripReplayModeResponse* payload = new SetTripReplayModeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setTripReplayMode", SetTripReplayModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetTripReplayMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSetTripReplayModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetTripReplayModeError* payload = new SetTripReplayModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setTripReplayMode", SetTripReplayModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetTripReplayMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowLocationSelectionAndGetAddressDetailsResponse (const DestinationMemoryDetailListElement& destinationMemoryDetailListElement, act_t act) {
    ShowLocationSelectionAndGetAddressDetailsResponse* payload = new ShowLocationSelectionAndGetAddressDetailsResponse(destinationMemoryDetailListElement);
    DBUS_MESSAGE_REPLY(dbusMessage, "showLocationSelectionAndGetAddressDetails", ShowLocationSelectionAndGetAddressDetailsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowLocationSelectionAndGetAddressDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowLocationSelectionAndGetAddressDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowLocationSelectionAndGetAddressDetailsError* payload = new ShowLocationSelectionAndGetAddressDetailsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showLocationSelectionAndGetAddressDetails", ShowLocationSelectionAndGetAddressDetailsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowLocationSelectionAndGetAddressDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowRouteCalculationToDestinationResponse (act_t act) {
    ShowRouteCalculationToDestinationResponse* payload = new ShowRouteCalculationToDestinationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showRouteCalculationToDestination", ShowRouteCalculationToDestinationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowRouteCalculationToDestination", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowRouteCalculationToDestinationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowRouteCalculationToDestinationError* payload = new ShowRouteCalculationToDestinationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showRouteCalculationToDestination", ShowRouteCalculationToDestinationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowRouteCalculationToDestination", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestJamAheadListResponse (act_t act) {
    RequestJamAheadListResponse* payload = new RequestJamAheadListResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "requestJamAheadList", RequestJamAheadListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestJamAheadList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestJamAheadListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestJamAheadListError* payload = new RequestJamAheadListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestJamAheadList", RequestJamAheadListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestJamAheadList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendReleaseJamAheadListResponse (act_t act) {
    ReleaseJamAheadListResponse* payload = new ReleaseJamAheadListResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "releaseJamAheadList", ReleaseJamAheadListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReleaseJamAheadList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendReleaseJamAheadListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseJamAheadListError* payload = new ReleaseJamAheadListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "releaseJamAheadList", ReleaseJamAheadListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReleaseJamAheadList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSelectJamAheadListEntryResponse (act_t act) {
    SelectJamAheadListEntryResponse* payload = new SelectJamAheadListEntryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "selectJamAheadListEntry", SelectJamAheadListEntryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SelectJamAheadListEntry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendSelectJamAheadListEntryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectJamAheadListEntryError* payload = new SelectJamAheadListEntryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "selectJamAheadListEntry", SelectJamAheadListEntryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SelectJamAheadListEntry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendActivateNonPremiumTMCResponse (act_t act) {
    ActivateNonPremiumTMCResponse* payload = new ActivateNonPremiumTMCResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "activateNonPremiumTMC", ActivateNonPremiumTMCResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ActivateNonPremiumTMC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendActivateNonPremiumTMCError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ActivateNonPremiumTMCError* payload = new ActivateNonPremiumTMCError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "activateNonPremiumTMC", ActivateNonPremiumTMCError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ActivateNonPremiumTMC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendDeactivateNonPremiumTMCResponse (act_t act) {
    DeactivateNonPremiumTMCResponse* payload = new DeactivateNonPremiumTMCResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "deactivateNonPremiumTMC", DeactivateNonPremiumTMCResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeactivateNonPremiumTMC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendDeactivateNonPremiumTMCError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeactivateNonPremiumTMCError* payload = new DeactivateNonPremiumTMCError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "deactivateNonPremiumTMC", DeactivateNonPremiumTMCError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeactivateNonPremiumTMC", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCancelJamAheadResponse (act_t act) {
    CancelJamAheadResponse* payload = new CancelJamAheadResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "cancelJamAhead", CancelJamAheadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelJamAhead", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendCancelJamAheadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelJamAheadError* payload = new CancelJamAheadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "cancelJamAhead", CancelJamAheadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelJamAhead", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDetailsForSelectedCoordinateWithRadiusResponse (const ::std::vector< LocationDetails >& locationDetailsList, act_t act) {
    RequestDetailsForSelectedCoordinateWithRadiusResponse* payload = new RequestDetailsForSelectedCoordinateWithRadiusResponse(locationDetailsList);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestDetailsForSelectedCoordinateWithRadius", RequestDetailsForSelectedCoordinateWithRadiusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestDetailsForSelectedCoordinateWithRadius", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendRequestDetailsForSelectedCoordinateWithRadiusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestDetailsForSelectedCoordinateWithRadiusError* payload = new RequestDetailsForSelectedCoordinateWithRadiusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestDetailsForSelectedCoordinateWithRadius", RequestDetailsForSelectedCoordinateWithRadiusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestDetailsForSelectedCoordinateWithRadius", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowAndSetLocationWithDetailsResponse (act_t act) {
    ShowAndSetLocationWithDetailsResponse* payload = new ShowAndSetLocationWithDetailsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "showAndSetLocationWithDetails", ShowAndSetLocationWithDetailsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowAndSetLocationWithDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NavigationServiceStub::sendShowAndSetLocationWithDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowAndSetLocationWithDetailsError* payload = new ShowAndSetLocationWithDetailsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "showAndSetLocationWithDetails", ShowAndSetLocationWithDetailsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowAndSetLocationWithDetails", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NavigationServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'navStatus'
    {
        ::asf::dbus::DBusVariant variant;
        NavStatusGet payload(_navStatusProperty.getNavStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("navStatus", variant));
    }

    //property 'datasetVersion'
    {
        ::asf::dbus::DBusVariant variant;
        DatasetVersionGet payload(_datasetVersionProperty.getDatasetVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("datasetVersion", variant));
    }

    //property 'nonPremiumTMCStatus'
    {
        ::asf::dbus::DBusVariant variant;
        NonPremiumTMCStatusGet payload(_nonPremiumTMCStatusProperty.getNonPremiumTMCStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("nonPremiumTMCStatus", variant));
    }

    //property 'currentFreeTextSearchInfo'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentFreeTextSearchInfoGet payload(_currentFreeTextSearchInfoProperty.getCurrentFreeTextSearchInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("currentFreeTextSearchInfo", variant));
    }

    //property 'positionInformation'
    {
        ::asf::dbus::DBusVariant variant;
        PositionInformationGet payload(_positionInformationProperty.getPositionInformation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("positionInformation", variant));
    }

    //property 'distanceToDestination'
    {
        ::asf::dbus::DBusVariant variant;
        DistanceToDestinationGet payload(_distanceToDestinationProperty.getDistanceToDestination());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("distanceToDestination", variant));
    }

    //property 'currentStreet'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentStreetGet payload(_currentStreetProperty.getCurrentStreet());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("currentStreet", variant));
    }

    //property 'turntoStreet'
    {
        ::asf::dbus::DBusVariant variant;
        TurntoStreetGet payload(_turntoStreetProperty.getTurntoStreet());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("turntoStreet", variant));
    }

    //property 'roundaboutExitNumber'
    {
        ::asf::dbus::DBusVariant variant;
        RoundaboutExitNumberGet payload(_roundaboutExitNumberProperty.getRoundaboutExitNumber());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("roundaboutExitNumber", variant));
    }

    //property 'nextTurntoStreet'
    {
        ::asf::dbus::DBusVariant variant;
        NextTurntoStreetGet payload(_nextTurntoStreetProperty.getNextTurntoStreet());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("nextTurntoStreet", variant));
    }

    //property 'barGraphInfo'
    {
        ::asf::dbus::DBusVariant variant;
        BarGraphInfoGet payload(_barGraphInfoProperty.getBarGraphInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("barGraphInfo", variant));
    }

    //property 'maneuverSymbol'
    {
        ::asf::dbus::DBusVariant variant;
        ManeuverSymbolGet payload(_maneuverSymbolProperty.getManeuverSymbol());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("maneuverSymbol", variant));
    }

    //property 'satelliteInfo'
    {
        ::asf::dbus::DBusVariant variant;
        SatelliteInfoGet payload(_satelliteInfoProperty.getSatelliteInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("satelliteInfo", variant));
    }

    //property 'destinationInformation'
    {
        ::asf::dbus::DBusVariant variant;
        DestinationInformationGet payload(_destinationInformationProperty.getDestinationInformation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("destinationInformation", variant));
    }

    //property 'routeCalculationDuration'
    {
        ::asf::dbus::DBusVariant variant;
        RouteCalculationDurationGet payload(_routeCalculationDurationProperty.getRouteCalculationDuration());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("routeCalculationDuration", variant));
    }

    //property 'homeLocation'
    {
        ::asf::dbus::DBusVariant variant;
        HomeLocationGet payload(_homeLocationProperty.getHomeLocation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("homeLocation", variant));
    }

    //property 'workLocation'
    {
        ::asf::dbus::DBusVariant variant;
        WorkLocationGet payload(_workLocationProperty.getWorkLocation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("workLocation", variant));
    }

    //property 'mapRepresentation'
    {
        ::asf::dbus::DBusVariant variant;
        MapRepresentationGet payload(_mapRepresentationProperty.getMapRepresentation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("mapRepresentation", variant));
    }

    //property 'sdsAddressWithOptions'
    {
        ::asf::dbus::DBusVariant variant;
        SdsAddressWithOptionsGet payload(_sdsAddressWithOptionsProperty.getSdsAddressWithOptions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsAddressWithOptions", variant));
    }

    //property 'waypointList'
    {
        ::asf::dbus::DBusVariant variant;
        WaypointListGet payload(_waypointListProperty.getWaypointList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("waypointList", variant));
    }

    //property 'maneuverView'
    {
        ::asf::dbus::DBusVariant variant;
        ManeuverViewGet payload(_maneuverViewProperty.getManeuverView());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("maneuverView", variant));
    }

    //property 'intersectionMapCarsorPosition'
    {
        ::asf::dbus::DBusVariant variant;
        IntersectionMapCarsorPositionGet payload(_intersectionMapCarsorPositionProperty.getIntersectionMapCarsorPosition());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("intersectionMapCarsorPosition", variant));
    }

    //property 'speedLimit'
    {
        ::asf::dbus::DBusVariant variant;
        SpeedLimitGet payload(_speedLimitProperty.getSpeedLimit());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("speedLimit", variant));
    }

    //property 'trafficEnforcement'
    {
        ::asf::dbus::DBusVariant variant;
        TrafficEnforcementGet payload(_trafficEnforcementProperty.getTrafficEnforcement());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("trafficEnforcement", variant));
    }

    //property 'nextManeuverDetails'
    {
        ::asf::dbus::DBusVariant variant;
        NextManeuverDetailsGet payload(_nextManeuverDetailsProperty.getNextManeuverDetails());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("nextManeuverDetails", variant));
    }

    //property 'laneRecommendationList'
    {
        ::asf::dbus::DBusVariant variant;
        LaneRecommendationListGet payload(_laneRecommendationListProperty.getLaneRecommendationList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("laneRecommendationList", variant));
    }

    //property 'arrivalInformationList'
    {
        ::asf::dbus::DBusVariant variant;
        ArrivalInformationListGet payload(_arrivalInformationListProperty.getArrivalInformationList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("arrivalInformationList", variant));
    }

    //property 'intersectionMap'
    {
        ::asf::dbus::DBusVariant variant;
        IntersectionMapGet payload(_intersectionMapProperty.getIntersectionMap());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("intersectionMap", variant));
    }

    //property 'isAddressBookChanged'
    {
        ::asf::dbus::DBusVariant variant;
        IsAddressBookChangedGet payload(_isAddressBookChangedProperty.getIsAddressBookChanged());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("isAddressBookChanged", variant));
    }

    //property 'isMaxAllowedAddressBookEntriesStored'
    {
        ::asf::dbus::DBusVariant variant;
        IsMaxAllowedAddressBookEntriesStoredGet payload(_isMaxAllowedAddressBookEntriesStoredProperty.getIsMaxAllowedAddressBookEntriesStored());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("isMaxAllowedAddressBookEntriesStored", variant));
    }

    //property 'isLastDestinationListChanged'
    {
        ::asf::dbus::DBusVariant variant;
        IsLastDestinationListChangedGet payload(_isLastDestinationListChangedProperty.getIsLastDestinationListChanged());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("isLastDestinationListChanged", variant));
    }

    //property 'isVoiceGuidanceActive'
    {
        ::asf::dbus::DBusVariant variant;
        IsVoiceGuidanceActiveGet payload(_isVoiceGuidanceActiveProperty.getIsVoiceGuidanceActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("isVoiceGuidanceActive", variant));
    }

    //property 'sdsVoiceTagWithOptions'
    {
        ::asf::dbus::DBusVariant variant;
        SdsVoiceTagWithOptionsGet payload(_sdsVoiceTagWithOptionsProperty.getSdsVoiceTagWithOptions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsVoiceTagWithOptions", variant));
    }

    //property 'trafficMessagesCount'
    {
        ::asf::dbus::DBusVariant variant;
        TrafficMessagesCountGet payload(_trafficMessagesCountProperty.getTrafficMessagesCount());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("trafficMessagesCount", variant));
    }

    //property 'trafficServiceReceptionStatus'
    {
        ::asf::dbus::DBusVariant variant;
        TrafficServiceReceptionStatusGet payload(_trafficServiceReceptionStatusProperty.getTrafficServiceReceptionStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("trafficServiceReceptionStatus", variant));
    }

    //property 'sdsPOICategoryShortcuts'
    {
        ::asf::dbus::DBusVariant variant;
        SdsPOICategoryShortcutsGet payload(_sdsPOICategoryShortcutsProperty.getSdsPOICategoryShortcuts());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("sdsPOICategoryShortcuts", variant));
    }

    //property 'menuPoiCategoryShortcuts'
    {
        ::asf::dbus::DBusVariant variant;
        MenuPoiCategoryShortcutsGet payload(_menuPoiCategoryShortcutsProperty.getMenuPoiCategoryShortcuts());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("menuPoiCategoryShortcuts", variant));
    }

    //property 'tripReplayStatusInfo'
    {
        ::asf::dbus::DBusVariant variant;
        TripReplayStatusInfoGet payload(_tripReplayStatusInfoProperty.getTripReplayStatusInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("tripReplayStatusInfo", variant));
    }

    //property 'etcStatus'
    {
        ::asf::dbus::DBusVariant variant;
        EtcStatusGet payload(_etcStatusProperty.getEtcStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("etcStatus", variant));
    }

    //property 'TrafficSignInfoActive'
    {
        ::asf::dbus::DBusVariant variant;
        TrafficSignInfoActiveGet payload(_TrafficSignInfoActiveProperty.getTrafficSignInfoActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TrafficSignInfoActive", variant));
    }

    //property 'OverSpeedSoundAlertInfoActive'
    {
        ::asf::dbus::DBusVariant variant;
        OverSpeedSoundAlertInfoActiveGet payload(_OverSpeedSoundAlertInfoActiveProperty.getOverSpeedSoundAlertInfoActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OverSpeedSoundAlertInfoActive", variant));
    }

    //property 'routeRecalculationReason'
    {
        ::asf::dbus::DBusVariant variant;
        RouteRecalculationReasonGet payload(_routeRecalculationReasonProperty.getRouteRecalculationReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("routeRecalculationReason", variant));
    }

    //property 'RiskAreaDisplayInfoActive'
    {
        ::asf::dbus::DBusVariant variant;
        RiskAreaDisplayInfoActiveGet payload(_RiskAreaDisplayInfoActiveProperty.getRiskAreaDisplayInfoActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RiskAreaDisplayInfoActive", variant));
    }

    //property 'RiskAreaSoundAlertInfoActive'
    {
        ::asf::dbus::DBusVariant variant;
        RiskAreaSoundAlertInfoActiveGet payload(_RiskAreaSoundAlertInfoActiveProperty.getRiskAreaSoundAlertInfoActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RiskAreaSoundAlertInfoActive", variant));
    }

    //property 'jamAheadList'
    {
        ::asf::dbus::DBusVariant variant;
        JamAheadListGet payload(_jamAheadListProperty.getJamAheadList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("jamAheadList", variant));
    }

    //property 'waypointOperationStatusList'
    {
        ::asf::dbus::DBusVariant variant;
        WaypointOperationStatusListGet payload(_waypointOperationStatusListProperty.getWaypointOperationStatusList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("waypointOperationStatusList", variant));
    }

    //property 'destinationReachedStatus'
    {
        ::asf::dbus::DBusVariant variant;
        DestinationReachedStatusGet payload(_destinationReachedStatusProperty.getDestinationReachedStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("destinationReachedStatus", variant));
    }

    //property 'lightModeStatus'
    {
        ::asf::dbus::DBusVariant variant;
        LightModeStatusGet payload(_lightModeStatusProperty.getLightModeStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("lightModeStatus", variant));
    }

    //property 'mapCameraData'
    {
        ::asf::dbus::DBusVariant variant;
        MapCameraDataGet payload(_mapCameraDataProperty.getMapCameraData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("mapCameraData", variant));
    }
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
