/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include "org/bosch/cm/navigation/NavigationServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationServiceJson.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationService", NavigationServiceProxy);

class NavigationServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NavigationServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NavigationServiceProxy >& proxyShared = ::boost::static_pointer_cast< NavigationServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_navStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavStatusError> payload = ::boost::static_pointer_cast<NavStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NavStatusCallbackIF*) _callback)->onNavStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavStatusUpdate> payload = ::boost::static_pointer_cast<NavStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NavStatusCallbackIF*) _callback)->onNavStatusUpdate(proxyShared, payload);
                        proxyShared->_navStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_datasetVersion:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DatasetVersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DatasetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DatasetVersionError> payload = ::boost::static_pointer_cast<DatasetVersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DatasetVersionCallbackIF*) _callback)->onDatasetVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DatasetVersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DatasetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DatasetVersionUpdate> payload = ::boost::static_pointer_cast<DatasetVersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DatasetVersionCallbackIF*) _callback)->onDatasetVersionUpdate(proxyShared, payload);
                        proxyShared->_datasetVersion = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_nonPremiumTMCStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NonPremiumTMCStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NonPremiumTMCStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NonPremiumTMCStatusError> payload = ::boost::static_pointer_cast<NonPremiumTMCStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NonPremiumTMCStatusCallbackIF*) _callback)->onNonPremiumTMCStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NonPremiumTMCStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NonPremiumTMCStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NonPremiumTMCStatusUpdate> payload = ::boost::static_pointer_cast<NonPremiumTMCStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NonPremiumTMCStatusCallbackIF*) _callback)->onNonPremiumTMCStatusUpdate(proxyShared, payload);
                        proxyShared->_nonPremiumTMCStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_currentFreeTextSearchInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentFreeTextSearchInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentFreeTextSearchInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentFreeTextSearchInfoError> payload = ::boost::static_pointer_cast<CurrentFreeTextSearchInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentFreeTextSearchInfoCallbackIF*) _callback)->onCurrentFreeTextSearchInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentFreeTextSearchInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentFreeTextSearchInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentFreeTextSearchInfoUpdate> payload = ::boost::static_pointer_cast<CurrentFreeTextSearchInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentFreeTextSearchInfoCallbackIF*) _callback)->onCurrentFreeTextSearchInfoUpdate(proxyShared, payload);
                        proxyShared->_currentFreeTextSearchInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_positionInformation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionInformationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionInformationError> payload = ::boost::static_pointer_cast<PositionInformationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PositionInformationCallbackIF*) _callback)->onPositionInformationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PositionInformationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PositionInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PositionInformationUpdate> payload = ::boost::static_pointer_cast<PositionInformationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PositionInformationCallbackIF*) _callback)->onPositionInformationUpdate(proxyShared, payload);
                        proxyShared->_positionInformation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_distanceToDestination:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DistanceToDestinationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DistanceToDestination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DistanceToDestinationError> payload = ::boost::static_pointer_cast<DistanceToDestinationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DistanceToDestinationCallbackIF*) _callback)->onDistanceToDestinationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DistanceToDestinationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DistanceToDestination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DistanceToDestinationUpdate> payload = ::boost::static_pointer_cast<DistanceToDestinationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DistanceToDestinationCallbackIF*) _callback)->onDistanceToDestinationUpdate(proxyShared, payload);
                        proxyShared->_distanceToDestination = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_currentStreet:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentStreetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentStreetError> payload = ::boost::static_pointer_cast<CurrentStreetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentStreetCallbackIF*) _callback)->onCurrentStreetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentStreetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentStreetUpdate> payload = ::boost::static_pointer_cast<CurrentStreetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentStreetCallbackIF*) _callback)->onCurrentStreetUpdate(proxyShared, payload);
                        proxyShared->_currentStreet = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_turntoStreet:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TurntoStreetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TurntoStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TurntoStreetError> payload = ::boost::static_pointer_cast<TurntoStreetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TurntoStreetCallbackIF*) _callback)->onTurntoStreetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TurntoStreetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TurntoStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TurntoStreetUpdate> payload = ::boost::static_pointer_cast<TurntoStreetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TurntoStreetCallbackIF*) _callback)->onTurntoStreetUpdate(proxyShared, payload);
                        proxyShared->_turntoStreet = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_roundaboutExitNumber:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RoundaboutExitNumberError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RoundaboutExitNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RoundaboutExitNumberError> payload = ::boost::static_pointer_cast<RoundaboutExitNumberError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RoundaboutExitNumberCallbackIF*) _callback)->onRoundaboutExitNumberError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RoundaboutExitNumberUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RoundaboutExitNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RoundaboutExitNumberUpdate> payload = ::boost::static_pointer_cast<RoundaboutExitNumberUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RoundaboutExitNumberCallbackIF*) _callback)->onRoundaboutExitNumberUpdate(proxyShared, payload);
                        proxyShared->_roundaboutExitNumber = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_nextTurntoStreet:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextTurntoStreetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextTurntoStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextTurntoStreetError> payload = ::boost::static_pointer_cast<NextTurntoStreetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NextTurntoStreetCallbackIF*) _callback)->onNextTurntoStreetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextTurntoStreetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextTurntoStreet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextTurntoStreetUpdate> payload = ::boost::static_pointer_cast<NextTurntoStreetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NextTurntoStreetCallbackIF*) _callback)->onNextTurntoStreetUpdate(proxyShared, payload);
                        proxyShared->_nextTurntoStreet = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_barGraphInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BarGraphInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BarGraphInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BarGraphInfoError> payload = ::boost::static_pointer_cast<BarGraphInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BarGraphInfoCallbackIF*) _callback)->onBarGraphInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BarGraphInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BarGraphInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BarGraphInfoUpdate> payload = ::boost::static_pointer_cast<BarGraphInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BarGraphInfoCallbackIF*) _callback)->onBarGraphInfoUpdate(proxyShared, payload);
                        proxyShared->_barGraphInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_maneuverSymbol:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManeuverSymbolError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManeuverSymbol", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManeuverSymbolError> payload = ::boost::static_pointer_cast<ManeuverSymbolError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ManeuverSymbolCallbackIF*) _callback)->onManeuverSymbolError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManeuverSymbolUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManeuverSymbol", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManeuverSymbolUpdate> payload = ::boost::static_pointer_cast<ManeuverSymbolUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ManeuverSymbolCallbackIF*) _callback)->onManeuverSymbolUpdate(proxyShared, payload);
                        proxyShared->_maneuverSymbol = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_satelliteInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SatelliteInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SatelliteInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SatelliteInfoError> payload = ::boost::static_pointer_cast<SatelliteInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SatelliteInfoCallbackIF*) _callback)->onSatelliteInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SatelliteInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SatelliteInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SatelliteInfoUpdate> payload = ::boost::static_pointer_cast<SatelliteInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SatelliteInfoCallbackIF*) _callback)->onSatelliteInfoUpdate(proxyShared, payload);
                        proxyShared->_satelliteInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_destinationInformation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationInformationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DestinationInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationInformationError> payload = ::boost::static_pointer_cast<DestinationInformationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DestinationInformationCallbackIF*) _callback)->onDestinationInformationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationInformationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DestinationInformation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationInformationUpdate> payload = ::boost::static_pointer_cast<DestinationInformationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DestinationInformationCallbackIF*) _callback)->onDestinationInformationUpdate(proxyShared, payload);
                        proxyShared->_destinationInformation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_routeCalculationDuration:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RouteCalculationDurationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RouteCalculationDuration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RouteCalculationDurationError> payload = ::boost::static_pointer_cast<RouteCalculationDurationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RouteCalculationDurationCallbackIF*) _callback)->onRouteCalculationDurationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RouteCalculationDurationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RouteCalculationDuration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RouteCalculationDurationUpdate> payload = ::boost::static_pointer_cast<RouteCalculationDurationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RouteCalculationDurationCallbackIF*) _callback)->onRouteCalculationDurationUpdate(proxyShared, payload);
                        proxyShared->_routeCalculationDuration = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_homeLocation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HomeLocationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HomeLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HomeLocationError> payload = ::boost::static_pointer_cast<HomeLocationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HomeLocationCallbackIF*) _callback)->onHomeLocationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HomeLocationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HomeLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HomeLocationUpdate> payload = ::boost::static_pointer_cast<HomeLocationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HomeLocationCallbackIF*) _callback)->onHomeLocationUpdate(proxyShared, payload);
                        proxyShared->_homeLocation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_workLocation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WorkLocationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WorkLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WorkLocationError> payload = ::boost::static_pointer_cast<WorkLocationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WorkLocationCallbackIF*) _callback)->onWorkLocationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WorkLocationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WorkLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WorkLocationUpdate> payload = ::boost::static_pointer_cast<WorkLocationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WorkLocationCallbackIF*) _callback)->onWorkLocationUpdate(proxyShared, payload);
                        proxyShared->_workLocation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_mapRepresentation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapRepresentationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapRepresentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapRepresentationError> payload = ::boost::static_pointer_cast<MapRepresentationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MapRepresentationCallbackIF*) _callback)->onMapRepresentationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapRepresentationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapRepresentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapRepresentationUpdate> payload = ::boost::static_pointer_cast<MapRepresentationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MapRepresentationCallbackIF*) _callback)->onMapRepresentationUpdate(proxyShared, payload);
                        proxyShared->_mapRepresentation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsAddressWithOptions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsAddressWithOptionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsAddressWithOptionsError> payload = ::boost::static_pointer_cast<SdsAddressWithOptionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsAddressWithOptionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsAddressWithOptionsUpdate> payload = ::boost::static_pointer_cast<SdsAddressWithOptionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsUpdate(proxyShared, payload);
                        proxyShared->_sdsAddressWithOptions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_waypointList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaypointListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaypointList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaypointListError> payload = ::boost::static_pointer_cast<WaypointListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WaypointListCallbackIF*) _callback)->onWaypointListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaypointListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaypointList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaypointListUpdate> payload = ::boost::static_pointer_cast<WaypointListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WaypointListCallbackIF*) _callback)->onWaypointListUpdate(proxyShared, payload);
                        proxyShared->_waypointList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_maneuverView:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManeuverViewError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManeuverView", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManeuverViewError> payload = ::boost::static_pointer_cast<ManeuverViewError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ManeuverViewCallbackIF*) _callback)->onManeuverViewError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManeuverViewUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManeuverView", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManeuverViewUpdate> payload = ::boost::static_pointer_cast<ManeuverViewUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ManeuverViewCallbackIF*) _callback)->onManeuverViewUpdate(proxyShared, payload);
                        proxyShared->_maneuverView = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_intersectionMapCarsorPosition:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntersectionMapCarsorPositionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IntersectionMapCarsorPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntersectionMapCarsorPositionError> payload = ::boost::static_pointer_cast<IntersectionMapCarsorPositionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IntersectionMapCarsorPositionCallbackIF*) _callback)->onIntersectionMapCarsorPositionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntersectionMapCarsorPositionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IntersectionMapCarsorPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntersectionMapCarsorPositionUpdate> payload = ::boost::static_pointer_cast<IntersectionMapCarsorPositionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IntersectionMapCarsorPositionCallbackIF*) _callback)->onIntersectionMapCarsorPositionUpdate(proxyShared, payload);
                        proxyShared->_intersectionMapCarsorPosition = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_speedLimit:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedLimitError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeedLimit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedLimitError> payload = ::boost::static_pointer_cast<SpeedLimitError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SpeedLimitCallbackIF*) _callback)->onSpeedLimitError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeedLimitUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SpeedLimit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeedLimitUpdate> payload = ::boost::static_pointer_cast<SpeedLimitUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SpeedLimitCallbackIF*) _callback)->onSpeedLimitUpdate(proxyShared, payload);
                        proxyShared->_speedLimit = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_trafficEnforcement:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficEnforcementError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficEnforcement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficEnforcementError> payload = ::boost::static_pointer_cast<TrafficEnforcementError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TrafficEnforcementCallbackIF*) _callback)->onTrafficEnforcementError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficEnforcementUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficEnforcement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficEnforcementUpdate> payload = ::boost::static_pointer_cast<TrafficEnforcementUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TrafficEnforcementCallbackIF*) _callback)->onTrafficEnforcementUpdate(proxyShared, payload);
                        proxyShared->_trafficEnforcement = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_nextManeuverDetails:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextManeuverDetailsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextManeuverDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextManeuverDetailsError> payload = ::boost::static_pointer_cast<NextManeuverDetailsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NextManeuverDetailsCallbackIF*) _callback)->onNextManeuverDetailsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextManeuverDetailsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextManeuverDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextManeuverDetailsUpdate> payload = ::boost::static_pointer_cast<NextManeuverDetailsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NextManeuverDetailsCallbackIF*) _callback)->onNextManeuverDetailsUpdate(proxyShared, payload);
                        proxyShared->_nextManeuverDetails = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_laneRecommendationList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LaneRecommendationListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LaneRecommendationList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LaneRecommendationListError> payload = ::boost::static_pointer_cast<LaneRecommendationListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LaneRecommendationListCallbackIF*) _callback)->onLaneRecommendationListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LaneRecommendationListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LaneRecommendationList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LaneRecommendationListUpdate> payload = ::boost::static_pointer_cast<LaneRecommendationListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LaneRecommendationListCallbackIF*) _callback)->onLaneRecommendationListUpdate(proxyShared, payload);
                        proxyShared->_laneRecommendationList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_arrivalInformationList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ArrivalInformationListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ArrivalInformationList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ArrivalInformationListError> payload = ::boost::static_pointer_cast<ArrivalInformationListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ArrivalInformationListCallbackIF*) _callback)->onArrivalInformationListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ArrivalInformationListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ArrivalInformationList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ArrivalInformationListUpdate> payload = ::boost::static_pointer_cast<ArrivalInformationListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ArrivalInformationListCallbackIF*) _callback)->onArrivalInformationListUpdate(proxyShared, payload);
                        proxyShared->_arrivalInformationList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_intersectionMap:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntersectionMapError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IntersectionMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntersectionMapError> payload = ::boost::static_pointer_cast<IntersectionMapError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IntersectionMapCallbackIF*) _callback)->onIntersectionMapError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntersectionMapUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IntersectionMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IntersectionMapUpdate> payload = ::boost::static_pointer_cast<IntersectionMapUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IntersectionMapCallbackIF*) _callback)->onIntersectionMapUpdate(proxyShared, payload);
                        proxyShared->_intersectionMap = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_isAddressBookChanged:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsAddressBookChangedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsAddressBookChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsAddressBookChangedError> payload = ::boost::static_pointer_cast<IsAddressBookChangedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IsAddressBookChangedCallbackIF*) _callback)->onIsAddressBookChangedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsAddressBookChangedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsAddressBookChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsAddressBookChangedUpdate> payload = ::boost::static_pointer_cast<IsAddressBookChangedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IsAddressBookChangedCallbackIF*) _callback)->onIsAddressBookChangedUpdate(proxyShared, payload);
                        proxyShared->_isAddressBookChanged = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_isMaxAllowedAddressBookEntriesStored:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsMaxAllowedAddressBookEntriesStoredError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsMaxAllowedAddressBookEntriesStored", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsMaxAllowedAddressBookEntriesStoredError> payload = ::boost::static_pointer_cast<IsMaxAllowedAddressBookEntriesStoredError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IsMaxAllowedAddressBookEntriesStoredCallbackIF*) _callback)->onIsMaxAllowedAddressBookEntriesStoredError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsMaxAllowedAddressBookEntriesStoredUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsMaxAllowedAddressBookEntriesStored", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsMaxAllowedAddressBookEntriesStoredUpdate> payload = ::boost::static_pointer_cast<IsMaxAllowedAddressBookEntriesStoredUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IsMaxAllowedAddressBookEntriesStoredCallbackIF*) _callback)->onIsMaxAllowedAddressBookEntriesStoredUpdate(proxyShared, payload);
                        proxyShared->_isMaxAllowedAddressBookEntriesStored = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_isLastDestinationListChanged:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsLastDestinationListChangedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsLastDestinationListChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsLastDestinationListChangedError> payload = ::boost::static_pointer_cast<IsLastDestinationListChangedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IsLastDestinationListChangedCallbackIF*) _callback)->onIsLastDestinationListChangedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsLastDestinationListChangedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsLastDestinationListChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsLastDestinationListChangedUpdate> payload = ::boost::static_pointer_cast<IsLastDestinationListChangedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IsLastDestinationListChangedCallbackIF*) _callback)->onIsLastDestinationListChangedUpdate(proxyShared, payload);
                        proxyShared->_isLastDestinationListChanged = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_isVoiceGuidanceActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsVoiceGuidanceActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsVoiceGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsVoiceGuidanceActiveError> payload = ::boost::static_pointer_cast<IsVoiceGuidanceActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IsVoiceGuidanceActiveCallbackIF*) _callback)->onIsVoiceGuidanceActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsVoiceGuidanceActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsVoiceGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsVoiceGuidanceActiveUpdate> payload = ::boost::static_pointer_cast<IsVoiceGuidanceActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IsVoiceGuidanceActiveCallbackIF*) _callback)->onIsVoiceGuidanceActiveUpdate(proxyShared, payload);
                        proxyShared->_isVoiceGuidanceActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsVoiceTagWithOptions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsVoiceTagWithOptionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsVoiceTagWithOptionsError> payload = ::boost::static_pointer_cast<SdsVoiceTagWithOptionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsVoiceTagWithOptionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsVoiceTagWithOptionsUpdate> payload = ::boost::static_pointer_cast<SdsVoiceTagWithOptionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsUpdate(proxyShared, payload);
                        proxyShared->_sdsVoiceTagWithOptions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_trafficMessagesCount:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficMessagesCountError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficMessagesCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficMessagesCountError> payload = ::boost::static_pointer_cast<TrafficMessagesCountError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TrafficMessagesCountCallbackIF*) _callback)->onTrafficMessagesCountError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficMessagesCountUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficMessagesCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficMessagesCountUpdate> payload = ::boost::static_pointer_cast<TrafficMessagesCountUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TrafficMessagesCountCallbackIF*) _callback)->onTrafficMessagesCountUpdate(proxyShared, payload);
                        proxyShared->_trafficMessagesCount = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_trafficServiceReceptionStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficServiceReceptionStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficServiceReceptionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficServiceReceptionStatusError> payload = ::boost::static_pointer_cast<TrafficServiceReceptionStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TrafficServiceReceptionStatusCallbackIF*) _callback)->onTrafficServiceReceptionStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficServiceReceptionStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficServiceReceptionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficServiceReceptionStatusUpdate> payload = ::boost::static_pointer_cast<TrafficServiceReceptionStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TrafficServiceReceptionStatusCallbackIF*) _callback)->onTrafficServiceReceptionStatusUpdate(proxyShared, payload);
                        proxyShared->_trafficServiceReceptionStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_sdsPOICategoryShortcuts:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsPOICategoryShortcutsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsPOICategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsPOICategoryShortcutsError> payload = ::boost::static_pointer_cast<SdsPOICategoryShortcutsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SdsPOICategoryShortcutsCallbackIF*) _callback)->onSdsPOICategoryShortcutsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsPOICategoryShortcutsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SdsPOICategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsPOICategoryShortcutsUpdate> payload = ::boost::static_pointer_cast<SdsPOICategoryShortcutsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SdsPOICategoryShortcutsCallbackIF*) _callback)->onSdsPOICategoryShortcutsUpdate(proxyShared, payload);
                        proxyShared->_sdsPOICategoryShortcuts = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_menuPoiCategoryShortcuts:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MenuPoiCategoryShortcutsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MenuPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MenuPoiCategoryShortcutsError> payload = ::boost::static_pointer_cast<MenuPoiCategoryShortcutsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MenuPoiCategoryShortcutsCallbackIF*) _callback)->onMenuPoiCategoryShortcutsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MenuPoiCategoryShortcutsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MenuPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MenuPoiCategoryShortcutsUpdate> payload = ::boost::static_pointer_cast<MenuPoiCategoryShortcutsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MenuPoiCategoryShortcutsCallbackIF*) _callback)->onMenuPoiCategoryShortcutsUpdate(proxyShared, payload);
                        proxyShared->_menuPoiCategoryShortcuts = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_tripReplayStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TripReplayStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TripReplayStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TripReplayStatusInfoError> payload = ::boost::static_pointer_cast<TripReplayStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TripReplayStatusInfoCallbackIF*) _callback)->onTripReplayStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TripReplayStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TripReplayStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TripReplayStatusInfoUpdate> payload = ::boost::static_pointer_cast<TripReplayStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TripReplayStatusInfoCallbackIF*) _callback)->onTripReplayStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_tripReplayStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_etcStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EtcStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EtcStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EtcStatusError> payload = ::boost::static_pointer_cast<EtcStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EtcStatusCallbackIF*) _callback)->onEtcStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EtcStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EtcStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EtcStatusUpdate> payload = ::boost::static_pointer_cast<EtcStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EtcStatusCallbackIF*) _callback)->onEtcStatusUpdate(proxyShared, payload);
                        proxyShared->_etcStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TrafficSignInfoActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficSignInfoActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficSignInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficSignInfoActiveError> payload = ::boost::static_pointer_cast<TrafficSignInfoActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TrafficSignInfoActiveCallbackIF*) _callback)->onTrafficSignInfoActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TrafficSignInfoActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TrafficSignInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TrafficSignInfoActiveUpdate> payload = ::boost::static_pointer_cast<TrafficSignInfoActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TrafficSignInfoActiveCallbackIF*) _callback)->onTrafficSignInfoActiveUpdate(proxyShared, payload);
                        proxyShared->_trafficSignInfoActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_OverSpeedSoundAlertInfoActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OverSpeedSoundAlertInfoActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OverSpeedSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OverSpeedSoundAlertInfoActiveError> payload = ::boost::static_pointer_cast<OverSpeedSoundAlertInfoActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((OverSpeedSoundAlertInfoActiveCallbackIF*) _callback)->onOverSpeedSoundAlertInfoActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OverSpeedSoundAlertInfoActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OverSpeedSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OverSpeedSoundAlertInfoActiveUpdate> payload = ::boost::static_pointer_cast<OverSpeedSoundAlertInfoActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((OverSpeedSoundAlertInfoActiveCallbackIF*) _callback)->onOverSpeedSoundAlertInfoActiveUpdate(proxyShared, payload);
                        proxyShared->_overSpeedSoundAlertInfoActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_routeRecalculationReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RouteRecalculationReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RouteRecalculationReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RouteRecalculationReasonError> payload = ::boost::static_pointer_cast<RouteRecalculationReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RouteRecalculationReasonCallbackIF*) _callback)->onRouteRecalculationReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RouteRecalculationReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RouteRecalculationReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RouteRecalculationReasonUpdate> payload = ::boost::static_pointer_cast<RouteRecalculationReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RouteRecalculationReasonCallbackIF*) _callback)->onRouteRecalculationReasonUpdate(proxyShared, payload);
                        proxyShared->_routeRecalculationReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RiskAreaDisplayInfoActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RiskAreaDisplayInfoActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RiskAreaDisplayInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RiskAreaDisplayInfoActiveError> payload = ::boost::static_pointer_cast<RiskAreaDisplayInfoActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RiskAreaDisplayInfoActiveCallbackIF*) _callback)->onRiskAreaDisplayInfoActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RiskAreaDisplayInfoActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RiskAreaDisplayInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RiskAreaDisplayInfoActiveUpdate> payload = ::boost::static_pointer_cast<RiskAreaDisplayInfoActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RiskAreaDisplayInfoActiveCallbackIF*) _callback)->onRiskAreaDisplayInfoActiveUpdate(proxyShared, payload);
                        proxyShared->_riskAreaDisplayInfoActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RiskAreaSoundAlertInfoActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RiskAreaSoundAlertInfoActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RiskAreaSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RiskAreaSoundAlertInfoActiveError> payload = ::boost::static_pointer_cast<RiskAreaSoundAlertInfoActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RiskAreaSoundAlertInfoActiveCallbackIF*) _callback)->onRiskAreaSoundAlertInfoActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RiskAreaSoundAlertInfoActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RiskAreaSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RiskAreaSoundAlertInfoActiveUpdate> payload = ::boost::static_pointer_cast<RiskAreaSoundAlertInfoActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RiskAreaSoundAlertInfoActiveCallbackIF*) _callback)->onRiskAreaSoundAlertInfoActiveUpdate(proxyShared, payload);
                        proxyShared->_riskAreaSoundAlertInfoActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_jamAheadList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JamAheadListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JamAheadListError> payload = ::boost::static_pointer_cast<JamAheadListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JamAheadListCallbackIF*) _callback)->onJamAheadListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JamAheadListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JamAheadListUpdate> payload = ::boost::static_pointer_cast<JamAheadListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JamAheadListCallbackIF*) _callback)->onJamAheadListUpdate(proxyShared, payload);
                        proxyShared->_jamAheadList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_waypointOperationStatusList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaypointOperationStatusListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaypointOperationStatusList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaypointOperationStatusListError> payload = ::boost::static_pointer_cast<WaypointOperationStatusListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WaypointOperationStatusListCallbackIF*) _callback)->onWaypointOperationStatusListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaypointOperationStatusListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaypointOperationStatusList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaypointOperationStatusListUpdate> payload = ::boost::static_pointer_cast<WaypointOperationStatusListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WaypointOperationStatusListCallbackIF*) _callback)->onWaypointOperationStatusListUpdate(proxyShared, payload);
                        proxyShared->_waypointOperationStatusList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_destinationReachedStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationReachedStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DestinationReachedStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationReachedStatusError> payload = ::boost::static_pointer_cast<DestinationReachedStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DestinationReachedStatusCallbackIF*) _callback)->onDestinationReachedStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestinationReachedStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DestinationReachedStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestinationReachedStatusUpdate> payload = ::boost::static_pointer_cast<DestinationReachedStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DestinationReachedStatusCallbackIF*) _callback)->onDestinationReachedStatusUpdate(proxyShared, payload);
                        proxyShared->_destinationReachedStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_lightModeStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LightModeStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LightModeStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LightModeStatusError> payload = ::boost::static_pointer_cast<LightModeStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LightModeStatusCallbackIF*) _callback)->onLightModeStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LightModeStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LightModeStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LightModeStatusUpdate> payload = ::boost::static_pointer_cast<LightModeStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LightModeStatusCallbackIF*) _callback)->onLightModeStatusUpdate(proxyShared, payload);
                        proxyShared->_lightModeStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_mapCameraData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapCameraDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapCameraData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapCameraDataError> payload = ::boost::static_pointer_cast<MapCameraDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MapCameraDataCallbackIF*) _callback)->onMapCameraDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapCameraDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapCameraData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapCameraDataUpdate> payload = ::boost::static_pointer_cast<MapCameraDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MapCameraDataCallbackIF*) _callback)->onMapCameraDataUpdate(proxyShared, payload);
                        proxyShared->_mapCameraData = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_selectPoiCategoryShortcut:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectPoiCategoryShortcutError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectPoiCategoryShortcut", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectPoiCategoryShortcutError> payload = ::boost::static_pointer_cast<SelectPoiCategoryShortcutError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectPoiCategoryShortcutCallbackIF*) _callback)->onSelectPoiCategoryShortcutError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectPoiCategoryShortcutResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectPoiCategoryShortcut", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectPoiCategoryShortcutResponse> payload = ::boost::static_pointer_cast<SelectPoiCategoryShortcutResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectPoiCategoryShortcutCallbackIF*) _callback)->onSelectPoiCategoryShortcutResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getPoiCategoryShortcuts:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPoiCategoryShortcutsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPoiCategoryShortcutsError> payload = ::boost::static_pointer_cast<GetPoiCategoryShortcutsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPoiCategoryShortcutsCallbackIF*) _callback)->onGetPoiCategoryShortcutsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPoiCategoryShortcutsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPoiCategoryShortcutsResponse> payload = ::boost::static_pointer_cast<GetPoiCategoryShortcutsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPoiCategoryShortcutsCallbackIF*) _callback)->onGetPoiCategoryShortcutsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithCoordinates:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithCoordinatesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithCoordinatesError> payload = ::boost::static_pointer_cast<SetLocationWithCoordinatesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithCoordinatesCallbackIF*) _callback)->onSetLocationWithCoordinatesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithCoordinatesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithCoordinatesResponse> payload = ::boost::static_pointer_cast<SetLocationWithCoordinatesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithCoordinatesCallbackIF*) _callback)->onSetLocationWithCoordinatesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithDetails:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDetailsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithDetailsError> payload = ::boost::static_pointer_cast<SetLocationWithDetailsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithDetailsCallbackIF*) _callback)->onSetLocationWithDetailsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDetailsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithDetailsResponse> payload = ::boost::static_pointer_cast<SetLocationWithDetailsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithDetailsCallbackIF*) _callback)->onSetLocationWithDetailsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showPOILocationFromTCU:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowPOILocationFromTCUError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowPOILocationFromTCU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowPOILocationFromTCUError> payload = ::boost::static_pointer_cast<ShowPOILocationFromTCUError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowPOILocationFromTCUCallbackIF*) _callback)->onShowPOILocationFromTCUError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowPOILocationFromTCUResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowPOILocationFromTCU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowPOILocationFromTCUResponse> payload = ::boost::static_pointer_cast<ShowPOILocationFromTCUResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowPOILocationFromTCUCallbackIF*) _callback)->onShowPOILocationFromTCUResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_storePOILocationToAddressBook:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StorePOILocationToAddressBookError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StorePOILocationToAddressBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StorePOILocationToAddressBookError> payload = ::boost::static_pointer_cast<StorePOILocationToAddressBookError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StorePOILocationToAddressBookCallbackIF*) _callback)->onStorePOILocationToAddressBookError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StorePOILocationToAddressBookResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StorePOILocationToAddressBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StorePOILocationToAddressBookResponse> payload = ::boost::static_pointer_cast<StorePOILocationToAddressBookResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StorePOILocationToAddressBookCallbackIF*) _callback)->onStorePOILocationToAddressBookResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_storeLocationToAddressBook:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StoreLocationToAddressBookError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreLocationToAddressBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreLocationToAddressBookError> payload = ::boost::static_pointer_cast<StoreLocationToAddressBookError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreLocationToAddressBookCallbackIF*) _callback)->onStoreLocationToAddressBookError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StoreLocationToAddressBookResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StoreLocationToAddressBook", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StoreLocationToAddressBookResponse> payload = ::boost::static_pointer_cast<StoreLocationToAddressBookResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StoreLocationToAddressBookCallbackIF*) _callback)->onStoreLocationToAddressBookResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showDestinationOverviewFromTCU:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationOverviewFromTCUError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDestinationOverviewFromTCU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDestinationOverviewFromTCUError> payload = ::boost::static_pointer_cast<ShowDestinationOverviewFromTCUError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDestinationOverviewFromTCUCallbackIF*) _callback)->onShowDestinationOverviewFromTCUError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationOverviewFromTCUResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDestinationOverviewFromTCU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDestinationOverviewFromTCUResponse> payload = ::boost::static_pointer_cast<ShowDestinationOverviewFromTCUResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDestinationOverviewFromTCUCallbackIF*) _callback)->onShowDestinationOverviewFromTCUResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showCalculateTour:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowCalculateTourError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCalculateTour", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCalculateTourError> payload = ::boost::static_pointer_cast<ShowCalculateTourError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCalculateTourCallbackIF*) _callback)->onShowCalculateTourError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCalculateTourResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCalculateTour", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCalculateTourResponse> payload = ::boost::static_pointer_cast<ShowCalculateTourResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCalculateTourCallbackIF*) _callback)->onShowCalculateTourResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showOnMap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowOnMapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowOnMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowOnMapError> payload = ::boost::static_pointer_cast<ShowOnMapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowOnMapCallbackIF*) _callback)->onShowOnMapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowOnMapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowOnMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowOnMapResponse> payload = ::boost::static_pointer_cast<ShowOnMapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowOnMapCallbackIF*) _callback)->onShowOnMapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showCarsorLocationOnMap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowCarsorLocationOnMapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCarsorLocationOnMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCarsorLocationOnMapError> payload = ::boost::static_pointer_cast<ShowCarsorLocationOnMapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCarsorLocationOnMapCallbackIF*) _callback)->onShowCarsorLocationOnMapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCarsorLocationOnMapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCarsorLocationOnMap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCarsorLocationOnMapResponse> payload = ::boost::static_pointer_cast<ShowCarsorLocationOnMapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCarsorLocationOnMapCallbackIF*) _callback)->onShowCarsorLocationOnMapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showCityInputAndGetCityCoordinates:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowCityInputAndGetCityCoordinatesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCityInputAndGetCityCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCityInputAndGetCityCoordinatesError> payload = ::boost::static_pointer_cast<ShowCityInputAndGetCityCoordinatesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCityInputAndGetCityCoordinatesCallbackIF*) _callback)->onShowCityInputAndGetCityCoordinatesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowCityInputAndGetCityCoordinatesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowCityInputAndGetCityCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowCityInputAndGetCityCoordinatesResponse> payload = ::boost::static_pointer_cast<ShowCityInputAndGetCityCoordinatesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowCityInputAndGetCityCoordinatesCallbackIF*) _callback)->onShowCityInputAndGetCityCoordinatesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestLocationDetailsForCoordinates:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestLocationDetailsForCoordinatesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestLocationDetailsForCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestLocationDetailsForCoordinatesError> payload = ::boost::static_pointer_cast<RequestLocationDetailsForCoordinatesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestLocationDetailsForCoordinatesCallbackIF*) _callback)->onRequestLocationDetailsForCoordinatesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestLocationDetailsForCoordinatesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestLocationDetailsForCoordinates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestLocationDetailsForCoordinatesResponse> payload = ::boost::static_pointer_cast<RequestLocationDetailsForCoordinatesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestLocationDetailsForCoordinatesCallbackIF*) _callback)->onRequestLocationDetailsForCoordinatesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showAdjustCurrentLocationScreen:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowAdjustCurrentLocationScreenError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowAdjustCurrentLocationScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowAdjustCurrentLocationScreenError> payload = ::boost::static_pointer_cast<ShowAdjustCurrentLocationScreenError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowAdjustCurrentLocationScreenCallbackIF*) _callback)->onShowAdjustCurrentLocationScreenError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowAdjustCurrentLocationScreenResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowAdjustCurrentLocationScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowAdjustCurrentLocationScreenResponse> payload = ::boost::static_pointer_cast<ShowAdjustCurrentLocationScreenResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowAdjustCurrentLocationScreenCallbackIF*) _callback)->onShowAdjustCurrentLocationScreenResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showWhereAmIScreen:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowWhereAmIScreenError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowWhereAmIScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowWhereAmIScreenError> payload = ::boost::static_pointer_cast<ShowWhereAmIScreenError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowWhereAmIScreenCallbackIF*) _callback)->onShowWhereAmIScreenError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowWhereAmIScreenResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowWhereAmIScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowWhereAmIScreenResponse> payload = ::boost::static_pointer_cast<ShowWhereAmIScreenResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowWhereAmIScreenCallbackIF*) _callback)->onShowWhereAmIScreenResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showTrafficInfoScreen:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowTrafficInfoScreenError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowTrafficInfoScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowTrafficInfoScreenError> payload = ::boost::static_pointer_cast<ShowTrafficInfoScreenError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowTrafficInfoScreenCallbackIF*) _callback)->onShowTrafficInfoScreenError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowTrafficInfoScreenResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowTrafficInfoScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowTrafficInfoScreenResponse> payload = ::boost::static_pointer_cast<ShowTrafficInfoScreenResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowTrafficInfoScreenCallbackIF*) _callback)->onShowTrafficInfoScreenResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showMapScreenWithMapViewMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenWithMapViewModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowMapScreenWithMapViewMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowMapScreenWithMapViewModeError> payload = ::boost::static_pointer_cast<ShowMapScreenWithMapViewModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowMapScreenWithMapViewModeCallbackIF*) _callback)->onShowMapScreenWithMapViewModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenWithMapViewModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowMapScreenWithMapViewMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowMapScreenWithMapViewModeResponse> payload = ::boost::static_pointer_cast<ShowMapScreenWithMapViewModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowMapScreenWithMapViewModeCallbackIF*) _callback)->onShowMapScreenWithMapViewModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showMapScreenCarsorLockMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenCarsorLockModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowMapScreenCarsorLockMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowMapScreenCarsorLockModeError> payload = ::boost::static_pointer_cast<ShowMapScreenCarsorLockModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowMapScreenCarsorLockModeCallbackIF*) _callback)->onShowMapScreenCarsorLockModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowMapScreenCarsorLockModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowMapScreenCarsorLockMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowMapScreenCarsorLockModeResponse> payload = ::boost::static_pointer_cast<ShowMapScreenCarsorLockModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowMapScreenCarsorLockModeCallbackIF*) _callback)->onShowMapScreenCarsorLockModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showDeleteWaypointListScreen:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowDeleteWaypointListScreenError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDeleteWaypointListScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDeleteWaypointListScreenError> payload = ::boost::static_pointer_cast<ShowDeleteWaypointListScreenError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDeleteWaypointListScreenCallbackIF*) _callback)->onShowDeleteWaypointListScreenError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDeleteWaypointListScreenResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDeleteWaypointListScreen", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDeleteWaypointListScreenResponse> payload = ::boost::static_pointer_cast<ShowDeleteWaypointListScreenResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDeleteWaypointListScreenCallbackIF*) _callback)->onShowDeleteWaypointListScreenResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setZoomInStep:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomInStepError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomInStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomInStepError> payload = ::boost::static_pointer_cast<SetZoomInStepError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomInStepCallbackIF*) _callback)->onSetZoomInStepError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomInStepResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomInStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomInStepResponse> payload = ::boost::static_pointer_cast<SetZoomInStepResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomInStepCallbackIF*) _callback)->onSetZoomInStepResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setZoomOutStep:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomOutStepError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomOutStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomOutStepError> payload = ::boost::static_pointer_cast<SetZoomOutStepError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomOutStepCallbackIF*) _callback)->onSetZoomOutStepError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomOutStepResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomOutStep", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomOutStepResponse> payload = ::boost::static_pointer_cast<SetZoomOutStepResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomOutStepCallbackIF*) _callback)->onSetZoomOutStepResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setZoomLevel:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomLevelError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomLevelError> payload = ::boost::static_pointer_cast<SetZoomLevelError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomLevelCallbackIF*) _callback)->onSetZoomLevelError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetZoomLevelResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetZoomLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetZoomLevelResponse> payload = ::boost::static_pointer_cast<SetZoomLevelResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetZoomLevelCallbackIF*) _callback)->onSetZoomLevelResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getVersionString:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetVersionStringError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetVersionString", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetVersionStringError> payload = ::boost::static_pointer_cast<GetVersionStringError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetVersionStringCallbackIF*) _callback)->onGetVersionStringError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetVersionStringResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetVersionString", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetVersionStringResponse> payload = ::boost::static_pointer_cast<GetVersionStringResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetVersionStringCallbackIF*) _callback)->onGetVersionStringResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setSXMTravelLinkSubscriptionStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSXMTravelLinkSubscriptionStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSXMTravelLinkSubscriptionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSXMTravelLinkSubscriptionStatusError> payload = ::boost::static_pointer_cast<SetSXMTravelLinkSubscriptionStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSXMTravelLinkSubscriptionStatusCallbackIF*) _callback)->onSetSXMTravelLinkSubscriptionStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSXMTravelLinkSubscriptionStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSXMTravelLinkSubscriptionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSXMTravelLinkSubscriptionStatusResponse> payload = ::boost::static_pointer_cast<SetSXMTravelLinkSubscriptionStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSXMTravelLinkSubscriptionStatusCallbackIF*) _callback)->onSetSXMTravelLinkSubscriptionStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startGuidance:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceError> payload = ::boost::static_pointer_cast<StartGuidanceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceCallbackIF*) _callback)->onStartGuidanceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceResponse> payload = ::boost::static_pointer_cast<StartGuidanceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceCallbackIF*) _callback)->onStartGuidanceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startGuidanceToPosWGS84:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToPosWGS84Error);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToPosWGS84", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToPosWGS84Error> payload = ::boost::static_pointer_cast<StartGuidanceToPosWGS84Error>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToPosWGS84CallbackIF*) _callback)->onStartGuidanceToPosWGS84Error (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToPosWGS84Response);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToPosWGS84", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToPosWGS84Response> payload = ::boost::static_pointer_cast<StartGuidanceToPosWGS84Response>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToPosWGS84CallbackIF*) _callback)->onStartGuidanceToPosWGS84Response (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startGuidanceToHomeLocation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToHomeLocationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToHomeLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToHomeLocationError> payload = ::boost::static_pointer_cast<StartGuidanceToHomeLocationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToHomeLocationCallbackIF*) _callback)->onStartGuidanceToHomeLocationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToHomeLocationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToHomeLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToHomeLocationResponse> payload = ::boost::static_pointer_cast<StartGuidanceToHomeLocationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToHomeLocationCallbackIF*) _callback)->onStartGuidanceToHomeLocationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startGuidanceToWorkLocation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToWorkLocationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToWorkLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToWorkLocationError> payload = ::boost::static_pointer_cast<StartGuidanceToWorkLocationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToWorkLocationCallbackIF*) _callback)->onStartGuidanceToWorkLocationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartGuidanceToWorkLocationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartGuidanceToWorkLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartGuidanceToWorkLocationResponse> payload = ::boost::static_pointer_cast<StartGuidanceToWorkLocationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartGuidanceToWorkLocationCallbackIF*) _callback)->onStartGuidanceToWorkLocationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithDestinationMemoryEntry:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDestinationMemoryEntryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithDestinationMemoryEntry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithDestinationMemoryEntryError> payload = ::boost::static_pointer_cast<SetLocationWithDestinationMemoryEntryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithDestinationMemoryEntryCallbackIF*) _callback)->onSetLocationWithDestinationMemoryEntryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithDestinationMemoryEntryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithDestinationMemoryEntry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithDestinationMemoryEntryResponse> payload = ::boost::static_pointer_cast<SetLocationWithDestinationMemoryEntryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithDestinationMemoryEntryCallbackIF*) _callback)->onSetLocationWithDestinationMemoryEntryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_cancelRouteGuidance:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelRouteGuidanceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelRouteGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelRouteGuidanceError> payload = ::boost::static_pointer_cast<CancelRouteGuidanceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelRouteGuidanceCallbackIF*) _callback)->onCancelRouteGuidanceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRouteGuidanceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelRouteGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelRouteGuidanceResponse> payload = ::boost::static_pointer_cast<CancelRouteGuidanceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelRouteGuidanceCallbackIF*) _callback)->onCancelRouteGuidanceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_insertWaypoint:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InsertWaypoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InsertWaypointError> payload = ::boost::static_pointer_cast<InsertWaypointError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((InsertWaypointCallbackIF*) _callback)->onInsertWaypointError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "InsertWaypoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InsertWaypointResponse> payload = ::boost::static_pointer_cast<InsertWaypointResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((InsertWaypointCallbackIF*) _callback)->onInsertWaypointResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_insertWaypointAtDefaultPosition:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointAtDefaultPositionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InsertWaypointAtDefaultPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InsertWaypointAtDefaultPositionError> payload = ::boost::static_pointer_cast<InsertWaypointAtDefaultPositionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((InsertWaypointAtDefaultPositionCallbackIF*) _callback)->onInsertWaypointAtDefaultPositionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InsertWaypointAtDefaultPositionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "InsertWaypointAtDefaultPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InsertWaypointAtDefaultPositionResponse> payload = ::boost::static_pointer_cast<InsertWaypointAtDefaultPositionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((InsertWaypointAtDefaultPositionCallbackIF*) _callback)->onInsertWaypointAtDefaultPositionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_replaceWaypoint:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReplaceWaypointError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReplaceWaypoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReplaceWaypointError> payload = ::boost::static_pointer_cast<ReplaceWaypointError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReplaceWaypointCallbackIF*) _callback)->onReplaceWaypointError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReplaceWaypointResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReplaceWaypoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReplaceWaypointResponse> payload = ::boost::static_pointer_cast<ReplaceWaypointResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReplaceWaypointCallbackIF*) _callback)->onReplaceWaypointResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_deleteWaypoints:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeleteWaypointsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteWaypoints", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteWaypointsError> payload = ::boost::static_pointer_cast<DeleteWaypointsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteWaypointsCallbackIF*) _callback)->onDeleteWaypointsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteWaypointsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteWaypoints", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteWaypointsResponse> payload = ::boost::static_pointer_cast<DeleteWaypointsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteWaypointsCallbackIF*) _callback)->onDeleteWaypointsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_applyWaypointListChange:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ApplyWaypointListChangeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyWaypointListChange", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyWaypointListChangeError> payload = ::boost::static_pointer_cast<ApplyWaypointListChangeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyWaypointListChangeCallbackIF*) _callback)->onApplyWaypointListChangeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ApplyWaypointListChangeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ApplyWaypointListChange", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ApplyWaypointListChangeResponse> payload = ::boost::static_pointer_cast<ApplyWaypointListChangeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ApplyWaypointListChangeCallbackIF*) _callback)->onApplyWaypointListChangeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestWaypointList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestWaypointListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestWaypointList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestWaypointListError> payload = ::boost::static_pointer_cast<RequestWaypointListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestWaypointListCallbackIF*) _callback)->onRequestWaypointListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestWaypointListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestWaypointList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestWaypointListResponse> payload = ::boost::static_pointer_cast<RequestWaypointListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestWaypointListCallbackIF*) _callback)->onRequestWaypointListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestSetFreeTextSearchType:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestSetFreeTextSearchTypeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestSetFreeTextSearchType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestSetFreeTextSearchTypeError> payload = ::boost::static_pointer_cast<RequestSetFreeTextSearchTypeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestSetFreeTextSearchTypeCallbackIF*) _callback)->onRequestSetFreeTextSearchTypeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestSetFreeTextSearchTypeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestSetFreeTextSearchType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestSetFreeTextSearchTypeResponse> payload = ::boost::static_pointer_cast<RequestSetFreeTextSearchTypeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestSetFreeTextSearchTypeCallbackIF*) _callback)->onRequestSetFreeTextSearchTypeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestFreeTextSearchResults:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestFreeTextSearchResultsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestFreeTextSearchResults", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestFreeTextSearchResultsError> payload = ::boost::static_pointer_cast<RequestFreeTextSearchResultsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestFreeTextSearchResultsCallbackIF*) _callback)->onRequestFreeTextSearchResultsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestFreeTextSearchResultsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestFreeTextSearchResults", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestFreeTextSearchResultsResponse> payload = ::boost::static_pointer_cast<RequestFreeTextSearchResultsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestFreeTextSearchResultsCallbackIF*) _callback)->onRequestFreeTextSearchResultsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_undoFreeTextSearchElementSelection:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UndoFreeTextSearchElementSelectionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UndoFreeTextSearchElementSelection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UndoFreeTextSearchElementSelectionError> payload = ::boost::static_pointer_cast<UndoFreeTextSearchElementSelectionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UndoFreeTextSearchElementSelectionCallbackIF*) _callback)->onUndoFreeTextSearchElementSelectionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UndoFreeTextSearchElementSelectionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UndoFreeTextSearchElementSelection", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UndoFreeTextSearchElementSelectionResponse> payload = ::boost::static_pointer_cast<UndoFreeTextSearchElementSelectionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UndoFreeTextSearchElementSelectionCallbackIF*) _callback)->onUndoFreeTextSearchElementSelectionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithFreeTextSearchInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFreeTextSearchInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithFreeTextSearchInputError> payload = ::boost::static_pointer_cast<SetLocationWithFreeTextSearchInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithFreeTextSearchInputCallbackIF*) _callback)->onSetLocationWithFreeTextSearchInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFreeTextSearchInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithFreeTextSearchInputResponse> payload = ::boost::static_pointer_cast<SetLocationWithFreeTextSearchInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithFreeTextSearchInputCallbackIF*) _callback)->onSetLocationWithFreeTextSearchInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showDestinationFreeTextSearchInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationFreeTextSearchInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDestinationFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDestinationFreeTextSearchInputError> payload = ::boost::static_pointer_cast<ShowDestinationFreeTextSearchInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDestinationFreeTextSearchInputCallbackIF*) _callback)->onShowDestinationFreeTextSearchInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowDestinationFreeTextSearchInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowDestinationFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowDestinationFreeTextSearchInputResponse> payload = ::boost::static_pointer_cast<ShowDestinationFreeTextSearchInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowDestinationFreeTextSearchInputCallbackIF*) _callback)->onShowDestinationFreeTextSearchInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestFixedPOICategorySearchResults:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestFixedPOICategorySearchResultsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestFixedPOICategorySearchResults", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestFixedPOICategorySearchResultsError> payload = ::boost::static_pointer_cast<RequestFixedPOICategorySearchResultsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestFixedPOICategorySearchResultsCallbackIF*) _callback)->onRequestFixedPOICategorySearchResultsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestFixedPOICategorySearchResultsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestFixedPOICategorySearchResults", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestFixedPOICategorySearchResultsResponse> payload = ::boost::static_pointer_cast<RequestFixedPOICategorySearchResultsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestFixedPOICategorySearchResultsCallbackIF*) _callback)->onRequestFixedPOICategorySearchResultsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_undoSetLocationWithFixedPOICategoryInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UndoSetLocationWithFixedPOICategoryInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UndoSetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UndoSetLocationWithFixedPOICategoryInputError> payload = ::boost::static_pointer_cast<UndoSetLocationWithFixedPOICategoryInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UndoSetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onUndoSetLocationWithFixedPOICategoryInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UndoSetLocationWithFixedPOICategoryInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UndoSetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UndoSetLocationWithFixedPOICategoryInputResponse> payload = ::boost::static_pointer_cast<UndoSetLocationWithFixedPOICategoryInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UndoSetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onUndoSetLocationWithFixedPOICategoryInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithFixedPOICategoryInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFixedPOICategoryInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithFixedPOICategoryInputError> payload = ::boost::static_pointer_cast<SetLocationWithFixedPOICategoryInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onSetLocationWithFixedPOICategoryInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithFixedPOICategoryInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithFixedPOICategoryInputResponse> payload = ::boost::static_pointer_cast<SetLocationWithFixedPOICategoryInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onSetLocationWithFixedPOICategoryInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsCheckAddress:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsCheckAddressError> payload = ::boost::static_pointer_cast<SdsCheckAddressError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsCheckAddressResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsCheckAddressResponse> payload = ::boost::static_pointer_cast<SdsCheckAddressResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsGetRefinementList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetRefinementListError> payload = ::boost::static_pointer_cast<SdsGetRefinementListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetRefinementListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetRefinementListResponse> payload = ::boost::static_pointer_cast<SdsGetRefinementListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_selectSdsRefinement:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectSdsRefinementError> payload = ::boost::static_pointer_cast<SelectSdsRefinementError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectSdsRefinementResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectSdsRefinementResponse> payload = ::boost::static_pointer_cast<SelectSdsRefinementResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLocationWithSdsInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithSdsInputError> payload = ::boost::static_pointer_cast<SetLocationWithSdsInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLocationWithSdsInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLocationWithSdsInputResponse> payload = ::boost::static_pointer_cast<SetLocationWithSdsInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestDestinationMemoryEntries:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestDestinationMemoryEntriesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDestinationMemoryEntries", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDestinationMemoryEntriesError> payload = ::boost::static_pointer_cast<RequestDestinationMemoryEntriesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDestinationMemoryEntriesCallbackIF*) _callback)->onRequestDestinationMemoryEntriesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDestinationMemoryEntriesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDestinationMemoryEntries", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDestinationMemoryEntriesResponse> payload = ::boost::static_pointer_cast<RequestDestinationMemoryEntriesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDestinationMemoryEntriesCallbackIF*) _callback)->onRequestDestinationMemoryEntriesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setMapRepresentation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMapRepresentationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMapRepresentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMapRepresentationError> payload = ::boost::static_pointer_cast<SetMapRepresentationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMapRepresentationCallbackIF*) _callback)->onSetMapRepresentationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMapRepresentationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMapRepresentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMapRepresentationResponse> payload = ::boost::static_pointer_cast<SetMapRepresentationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMapRepresentationCallbackIF*) _callback)->onSetMapRepresentationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestDetailsForSelectedLocation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedLocationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDetailsForSelectedLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDetailsForSelectedLocationError> payload = ::boost::static_pointer_cast<RequestDetailsForSelectedLocationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDetailsForSelectedLocationCallbackIF*) _callback)->onRequestDetailsForSelectedLocationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedLocationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDetailsForSelectedLocation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDetailsForSelectedLocationResponse> payload = ::boost::static_pointer_cast<RequestDetailsForSelectedLocationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDetailsForSelectedLocationCallbackIF*) _callback)->onRequestDetailsForSelectedLocationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_retriggerAcousticOutput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RetriggerAcousticOutputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RetriggerAcousticOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RetriggerAcousticOutputError> payload = ::boost::static_pointer_cast<RetriggerAcousticOutputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RetriggerAcousticOutputCallbackIF*) _callback)->onRetriggerAcousticOutputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RetriggerAcousticOutputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RetriggerAcousticOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RetriggerAcousticOutputResponse> payload = ::boost::static_pointer_cast<RetriggerAcousticOutputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RetriggerAcousticOutputCallbackIF*) _callback)->onRetriggerAcousticOutputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_speakSamplePhrase:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SpeakSamplePhraseError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeakSamplePhrase", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeakSamplePhraseError> payload = ::boost::static_pointer_cast<SpeakSamplePhraseError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeakSamplePhraseCallbackIF*) _callback)->onSpeakSamplePhraseError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeakSamplePhraseResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeakSamplePhrase", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeakSamplePhraseResponse> payload = ::boost::static_pointer_cast<SpeakSamplePhraseResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeakSamplePhraseCallbackIF*) _callback)->onSpeakSamplePhraseResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setRouteCriterion:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetRouteCriterionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRouteCriterion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRouteCriterionError> payload = ::boost::static_pointer_cast<SetRouteCriterionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRouteCriterionCallbackIF*) _callback)->onSetRouteCriterionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRouteCriterionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRouteCriterion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRouteCriterionResponse> payload = ::boost::static_pointer_cast<SetRouteCriterionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRouteCriterionCallbackIF*) _callback)->onSetRouteCriterionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setVoiceGuidance:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetVoiceGuidanceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVoiceGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVoiceGuidanceError> payload = ::boost::static_pointer_cast<SetVoiceGuidanceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVoiceGuidanceCallbackIF*) _callback)->onSetVoiceGuidanceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetVoiceGuidanceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetVoiceGuidance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetVoiceGuidanceResponse> payload = ::boost::static_pointer_cast<SetVoiceGuidanceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetVoiceGuidanceCallbackIF*) _callback)->onSetVoiceGuidanceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CheckNavDataCompatibility:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CheckNavDataCompatibilityError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckNavDataCompatibility", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckNavDataCompatibilityError> payload = ::boost::static_pointer_cast<CheckNavDataCompatibilityError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckNavDataCompatibilityCallbackIF*) _callback)->onCheckNavDataCompatibilityError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckNavDataCompatibilityResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckNavDataCompatibility", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckNavDataCompatibilityResponse> payload = ::boost::static_pointer_cast<CheckNavDataCompatibilityResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckNavDataCompatibilityCallbackIF*) _callback)->onCheckNavDataCompatibilityResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsUpdateVoiceTag:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsUpdateVoiceTagError> payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsUpdateVoiceTagResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsUpdateVoiceTagResponse> payload = ::boost::static_pointer_cast<SdsUpdateVoiceTagResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sdsGetHouseNumberPattern:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetHouseNumberPatternError> payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SdsGetHouseNumberPatternResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SdsGetHouseNumberPatternResponse> payload = ::boost::static_pointer_cast<SdsGetHouseNumberPatternResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setMapLightMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMapLightModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMapLightMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMapLightModeError> payload = ::boost::static_pointer_cast<SetMapLightModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMapLightModeCallbackIF*) _callback)->onSetMapLightModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMapLightModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMapLightMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMapLightModeResponse> payload = ::boost::static_pointer_cast<SetMapLightModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMapLightModeCallbackIF*) _callback)->onSetMapLightModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startTripReplay:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartTripReplayError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartTripReplayError> payload = ::boost::static_pointer_cast<StartTripReplayError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartTripReplayCallbackIF*) _callback)->onStartTripReplayError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartTripReplayResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartTripReplayResponse> payload = ::boost::static_pointer_cast<StartTripReplayResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartTripReplayCallbackIF*) _callback)->onStartTripReplayResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_stopTripReplay:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopTripReplayError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopTripReplayError> payload = ::boost::static_pointer_cast<StopTripReplayError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopTripReplayCallbackIF*) _callback)->onStopTripReplayError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopTripReplayResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopTripReplayResponse> payload = ::boost::static_pointer_cast<StopTripReplayResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopTripReplayCallbackIF*) _callback)->onStopTripReplayResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_seekTripReplay:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SeekTripReplayError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SeekTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SeekTripReplayError> payload = ::boost::static_pointer_cast<SeekTripReplayError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SeekTripReplayCallbackIF*) _callback)->onSeekTripReplayError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SeekTripReplayResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SeekTripReplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SeekTripReplayResponse> payload = ::boost::static_pointer_cast<SeekTripReplayResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SeekTripReplayCallbackIF*) _callback)->onSeekTripReplayResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setTripReplayMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetTripReplayModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetTripReplayMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetTripReplayModeError> payload = ::boost::static_pointer_cast<SetTripReplayModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetTripReplayModeCallbackIF*) _callback)->onSetTripReplayModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetTripReplayModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetTripReplayMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetTripReplayModeResponse> payload = ::boost::static_pointer_cast<SetTripReplayModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetTripReplayModeCallbackIF*) _callback)->onSetTripReplayModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showLocationSelectionAndGetAddressDetails:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowLocationSelectionAndGetAddressDetailsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowLocationSelectionAndGetAddressDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowLocationSelectionAndGetAddressDetailsError> payload = ::boost::static_pointer_cast<ShowLocationSelectionAndGetAddressDetailsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowLocationSelectionAndGetAddressDetailsCallbackIF*) _callback)->onShowLocationSelectionAndGetAddressDetailsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowLocationSelectionAndGetAddressDetailsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowLocationSelectionAndGetAddressDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowLocationSelectionAndGetAddressDetailsResponse> payload = ::boost::static_pointer_cast<ShowLocationSelectionAndGetAddressDetailsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowLocationSelectionAndGetAddressDetailsCallbackIF*) _callback)->onShowLocationSelectionAndGetAddressDetailsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showRouteCalculationToDestination:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowRouteCalculationToDestinationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowRouteCalculationToDestination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowRouteCalculationToDestinationError> payload = ::boost::static_pointer_cast<ShowRouteCalculationToDestinationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowRouteCalculationToDestinationCallbackIF*) _callback)->onShowRouteCalculationToDestinationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowRouteCalculationToDestinationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowRouteCalculationToDestination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowRouteCalculationToDestinationResponse> payload = ::boost::static_pointer_cast<ShowRouteCalculationToDestinationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowRouteCalculationToDestinationCallbackIF*) _callback)->onShowRouteCalculationToDestinationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestJamAheadList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestJamAheadListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestJamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestJamAheadListError> payload = ::boost::static_pointer_cast<RequestJamAheadListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestJamAheadListCallbackIF*) _callback)->onRequestJamAheadListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestJamAheadListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestJamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestJamAheadListResponse> payload = ::boost::static_pointer_cast<RequestJamAheadListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestJamAheadListCallbackIF*) _callback)->onRequestJamAheadListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_releaseJamAheadList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseJamAheadListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseJamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseJamAheadListError> payload = ::boost::static_pointer_cast<ReleaseJamAheadListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseJamAheadListCallbackIF*) _callback)->onReleaseJamAheadListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseJamAheadListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseJamAheadList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseJamAheadListResponse> payload = ::boost::static_pointer_cast<ReleaseJamAheadListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseJamAheadListCallbackIF*) _callback)->onReleaseJamAheadListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_selectJamAheadListEntry:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SelectJamAheadListEntryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectJamAheadListEntry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectJamAheadListEntryError> payload = ::boost::static_pointer_cast<SelectJamAheadListEntryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectJamAheadListEntryCallbackIF*) _callback)->onSelectJamAheadListEntryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectJamAheadListEntryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SelectJamAheadListEntry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SelectJamAheadListEntryResponse> payload = ::boost::static_pointer_cast<SelectJamAheadListEntryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SelectJamAheadListEntryCallbackIF*) _callback)->onSelectJamAheadListEntryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_activateNonPremiumTMC:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ActivateNonPremiumTMCError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateNonPremiumTMCError> payload = ::boost::static_pointer_cast<ActivateNonPremiumTMCError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateNonPremiumTMCCallbackIF*) _callback)->onActivateNonPremiumTMCError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateNonPremiumTMCResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateNonPremiumTMCResponse> payload = ::boost::static_pointer_cast<ActivateNonPremiumTMCResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateNonPremiumTMCCallbackIF*) _callback)->onActivateNonPremiumTMCResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_deactivateNonPremiumTMC:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateNonPremiumTMCError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeactivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeactivateNonPremiumTMCError> payload = ::boost::static_pointer_cast<DeactivateNonPremiumTMCError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeactivateNonPremiumTMCCallbackIF*) _callback)->onDeactivateNonPremiumTMCError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateNonPremiumTMCResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeactivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeactivateNonPremiumTMCResponse> payload = ::boost::static_pointer_cast<DeactivateNonPremiumTMCResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeactivateNonPremiumTMCCallbackIF*) _callback)->onDeactivateNonPremiumTMCResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_cancelJamAhead:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelJamAheadError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelJamAhead", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelJamAheadError> payload = ::boost::static_pointer_cast<CancelJamAheadError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelJamAheadCallbackIF*) _callback)->onCancelJamAheadError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelJamAheadResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelJamAhead", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelJamAheadResponse> payload = ::boost::static_pointer_cast<CancelJamAheadResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelJamAheadCallbackIF*) _callback)->onCancelJamAheadResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestDetailsForSelectedCoordinateWithRadius:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedCoordinateWithRadiusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDetailsForSelectedCoordinateWithRadius", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDetailsForSelectedCoordinateWithRadiusError> payload = ::boost::static_pointer_cast<RequestDetailsForSelectedCoordinateWithRadiusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDetailsForSelectedCoordinateWithRadiusCallbackIF*) _callback)->onRequestDetailsForSelectedCoordinateWithRadiusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDetailsForSelectedCoordinateWithRadiusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDetailsForSelectedCoordinateWithRadius", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDetailsForSelectedCoordinateWithRadiusResponse> payload = ::boost::static_pointer_cast<RequestDetailsForSelectedCoordinateWithRadiusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDetailsForSelectedCoordinateWithRadiusCallbackIF*) _callback)->onRequestDetailsForSelectedCoordinateWithRadiusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_showAndSetLocationWithDetails:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowAndSetLocationWithDetailsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowAndSetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowAndSetLocationWithDetailsError> payload = ::boost::static_pointer_cast<ShowAndSetLocationWithDetailsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowAndSetLocationWithDetailsCallbackIF*) _callback)->onShowAndSetLocationWithDetailsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowAndSetLocationWithDetailsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowAndSetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowAndSetLocationWithDetailsResponse> payload = ::boost::static_pointer_cast<ShowAndSetLocationWithDetailsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowAndSetLocationWithDetailsCallbackIF*) _callback)->onShowAndSetLocationWithDetailsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_navStatus: {
                ::boost::shared_ptr< NavStatusError > payload = ::boost::shared_ptr< NavStatusError >
                (new NavStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NavStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NavStatusCallbackIF*) _callback)->onNavStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_datasetVersion: {
                ::boost::shared_ptr< DatasetVersionError > payload = ::boost::shared_ptr< DatasetVersionError >
                (new DatasetVersionError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DatasetVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DatasetVersionCallbackIF*) _callback)->onDatasetVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_nonPremiumTMCStatus: {
                ::boost::shared_ptr< NonPremiumTMCStatusError > payload = ::boost::shared_ptr< NonPremiumTMCStatusError >
                (new NonPremiumTMCStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NonPremiumTMCStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NonPremiumTMCStatusCallbackIF*) _callback)->onNonPremiumTMCStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_currentFreeTextSearchInfo: {
                ::boost::shared_ptr< CurrentFreeTextSearchInfoError > payload = ::boost::shared_ptr< CurrentFreeTextSearchInfoError >
                (new CurrentFreeTextSearchInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentFreeTextSearchInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentFreeTextSearchInfoCallbackIF*) _callback)->onCurrentFreeTextSearchInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_positionInformation: {
                ::boost::shared_ptr< PositionInformationError > payload = ::boost::shared_ptr< PositionInformationError >
                (new PositionInformationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PositionInformation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PositionInformationCallbackIF*) _callback)->onPositionInformationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_distanceToDestination: {
                ::boost::shared_ptr< DistanceToDestinationError > payload = ::boost::shared_ptr< DistanceToDestinationError >
                (new DistanceToDestinationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DistanceToDestination", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DistanceToDestinationCallbackIF*) _callback)->onDistanceToDestinationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_currentStreet: {
                ::boost::shared_ptr< CurrentStreetError > payload = ::boost::shared_ptr< CurrentStreetError >
                (new CurrentStreetError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentStreet", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentStreetCallbackIF*) _callback)->onCurrentStreetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_turntoStreet: {
                ::boost::shared_ptr< TurntoStreetError > payload = ::boost::shared_ptr< TurntoStreetError >
                (new TurntoStreetError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TurntoStreet", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TurntoStreetCallbackIF*) _callback)->onTurntoStreetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_roundaboutExitNumber: {
                ::boost::shared_ptr< RoundaboutExitNumberError > payload = ::boost::shared_ptr< RoundaboutExitNumberError >
                (new RoundaboutExitNumberError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RoundaboutExitNumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RoundaboutExitNumberCallbackIF*) _callback)->onRoundaboutExitNumberError (proxyShared,payload);
                return true;
            }
            break;
            case ID_nextTurntoStreet: {
                ::boost::shared_ptr< NextTurntoStreetError > payload = ::boost::shared_ptr< NextTurntoStreetError >
                (new NextTurntoStreetError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NextTurntoStreet", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NextTurntoStreetCallbackIF*) _callback)->onNextTurntoStreetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_barGraphInfo: {
                ::boost::shared_ptr< BarGraphInfoError > payload = ::boost::shared_ptr< BarGraphInfoError >
                (new BarGraphInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BarGraphInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BarGraphInfoCallbackIF*) _callback)->onBarGraphInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_maneuverSymbol: {
                ::boost::shared_ptr< ManeuverSymbolError > payload = ::boost::shared_ptr< ManeuverSymbolError >
                (new ManeuverSymbolError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManeuverSymbol", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManeuverSymbolCallbackIF*) _callback)->onManeuverSymbolError (proxyShared,payload);
                return true;
            }
            break;
            case ID_satelliteInfo: {
                ::boost::shared_ptr< SatelliteInfoError > payload = ::boost::shared_ptr< SatelliteInfoError >
                (new SatelliteInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SatelliteInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SatelliteInfoCallbackIF*) _callback)->onSatelliteInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_destinationInformation: {
                ::boost::shared_ptr< DestinationInformationError > payload = ::boost::shared_ptr< DestinationInformationError >
                (new DestinationInformationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DestinationInformation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DestinationInformationCallbackIF*) _callback)->onDestinationInformationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_routeCalculationDuration: {
                ::boost::shared_ptr< RouteCalculationDurationError > payload = ::boost::shared_ptr< RouteCalculationDurationError >
                (new RouteCalculationDurationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RouteCalculationDuration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RouteCalculationDurationCallbackIF*) _callback)->onRouteCalculationDurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_homeLocation: {
                ::boost::shared_ptr< HomeLocationError > payload = ::boost::shared_ptr< HomeLocationError >
                (new HomeLocationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HomeLocation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HomeLocationCallbackIF*) _callback)->onHomeLocationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_workLocation: {
                ::boost::shared_ptr< WorkLocationError > payload = ::boost::shared_ptr< WorkLocationError >
                (new WorkLocationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WorkLocation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WorkLocationCallbackIF*) _callback)->onWorkLocationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_mapRepresentation: {
                ::boost::shared_ptr< MapRepresentationError > payload = ::boost::shared_ptr< MapRepresentationError >
                (new MapRepresentationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapRepresentation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapRepresentationCallbackIF*) _callback)->onMapRepresentationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsAddressWithOptions: {
                ::boost::shared_ptr< SdsAddressWithOptionsError > payload = ::boost::shared_ptr< SdsAddressWithOptionsError >
                (new SdsAddressWithOptionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsAddressWithOptions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsAddressWithOptionsCallbackIF*) _callback)->onSdsAddressWithOptionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_waypointList: {
                ::boost::shared_ptr< WaypointListError > payload = ::boost::shared_ptr< WaypointListError >
                (new WaypointListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WaypointList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WaypointListCallbackIF*) _callback)->onWaypointListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_maneuverView: {
                ::boost::shared_ptr< ManeuverViewError > payload = ::boost::shared_ptr< ManeuverViewError >
                (new ManeuverViewError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManeuverView", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManeuverViewCallbackIF*) _callback)->onManeuverViewError (proxyShared,payload);
                return true;
            }
            break;
            case ID_intersectionMapCarsorPosition: {
                ::boost::shared_ptr< IntersectionMapCarsorPositionError > payload = ::boost::shared_ptr< IntersectionMapCarsorPositionError >
                (new IntersectionMapCarsorPositionError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IntersectionMapCarsorPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IntersectionMapCarsorPositionCallbackIF*) _callback)->onIntersectionMapCarsorPositionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_speedLimit: {
                ::boost::shared_ptr< SpeedLimitError > payload = ::boost::shared_ptr< SpeedLimitError >
                (new SpeedLimitError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeedLimit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeedLimitCallbackIF*) _callback)->onSpeedLimitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_trafficEnforcement: {
                ::boost::shared_ptr< TrafficEnforcementError > payload = ::boost::shared_ptr< TrafficEnforcementError >
                (new TrafficEnforcementError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TrafficEnforcement", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TrafficEnforcementCallbackIF*) _callback)->onTrafficEnforcementError (proxyShared,payload);
                return true;
            }
            break;
            case ID_nextManeuverDetails: {
                ::boost::shared_ptr< NextManeuverDetailsError > payload = ::boost::shared_ptr< NextManeuverDetailsError >
                (new NextManeuverDetailsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NextManeuverDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NextManeuverDetailsCallbackIF*) _callback)->onNextManeuverDetailsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_laneRecommendationList: {
                ::boost::shared_ptr< LaneRecommendationListError > payload = ::boost::shared_ptr< LaneRecommendationListError >
                (new LaneRecommendationListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LaneRecommendationList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LaneRecommendationListCallbackIF*) _callback)->onLaneRecommendationListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_arrivalInformationList: {
                ::boost::shared_ptr< ArrivalInformationListError > payload = ::boost::shared_ptr< ArrivalInformationListError >
                (new ArrivalInformationListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ArrivalInformationList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ArrivalInformationListCallbackIF*) _callback)->onArrivalInformationListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_intersectionMap: {
                ::boost::shared_ptr< IntersectionMapError > payload = ::boost::shared_ptr< IntersectionMapError >
                (new IntersectionMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IntersectionMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IntersectionMapCallbackIF*) _callback)->onIntersectionMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_isAddressBookChanged: {
                ::boost::shared_ptr< IsAddressBookChangedError > payload = ::boost::shared_ptr< IsAddressBookChangedError >
                (new IsAddressBookChangedError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IsAddressBookChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IsAddressBookChangedCallbackIF*) _callback)->onIsAddressBookChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_isMaxAllowedAddressBookEntriesStored: {
                ::boost::shared_ptr< IsMaxAllowedAddressBookEntriesStoredError > payload = ::boost::shared_ptr< IsMaxAllowedAddressBookEntriesStoredError >
                (new IsMaxAllowedAddressBookEntriesStoredError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IsMaxAllowedAddressBookEntriesStored", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IsMaxAllowedAddressBookEntriesStoredCallbackIF*) _callback)->onIsMaxAllowedAddressBookEntriesStoredError (proxyShared,payload);
                return true;
            }
            break;
            case ID_isLastDestinationListChanged: {
                ::boost::shared_ptr< IsLastDestinationListChangedError > payload = ::boost::shared_ptr< IsLastDestinationListChangedError >
                (new IsLastDestinationListChangedError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IsLastDestinationListChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IsLastDestinationListChangedCallbackIF*) _callback)->onIsLastDestinationListChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_isVoiceGuidanceActive: {
                ::boost::shared_ptr< IsVoiceGuidanceActiveError > payload = ::boost::shared_ptr< IsVoiceGuidanceActiveError >
                (new IsVoiceGuidanceActiveError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IsVoiceGuidanceActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IsVoiceGuidanceActiveCallbackIF*) _callback)->onIsVoiceGuidanceActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsVoiceTagWithOptions: {
                ::boost::shared_ptr< SdsVoiceTagWithOptionsError > payload = ::boost::shared_ptr< SdsVoiceTagWithOptionsError >
                (new SdsVoiceTagWithOptionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsVoiceTagWithOptions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsVoiceTagWithOptionsCallbackIF*) _callback)->onSdsVoiceTagWithOptionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_trafficMessagesCount: {
                ::boost::shared_ptr< TrafficMessagesCountError > payload = ::boost::shared_ptr< TrafficMessagesCountError >
                (new TrafficMessagesCountError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TrafficMessagesCount", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TrafficMessagesCountCallbackIF*) _callback)->onTrafficMessagesCountError (proxyShared,payload);
                return true;
            }
            break;
            case ID_trafficServiceReceptionStatus: {
                ::boost::shared_ptr< TrafficServiceReceptionStatusError > payload = ::boost::shared_ptr< TrafficServiceReceptionStatusError >
                (new TrafficServiceReceptionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TrafficServiceReceptionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TrafficServiceReceptionStatusCallbackIF*) _callback)->onTrafficServiceReceptionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsPOICategoryShortcuts: {
                ::boost::shared_ptr< SdsPOICategoryShortcutsError > payload = ::boost::shared_ptr< SdsPOICategoryShortcutsError >
                (new SdsPOICategoryShortcutsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsPOICategoryShortcuts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsPOICategoryShortcutsCallbackIF*) _callback)->onSdsPOICategoryShortcutsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_menuPoiCategoryShortcuts: {
                ::boost::shared_ptr< MenuPoiCategoryShortcutsError > payload = ::boost::shared_ptr< MenuPoiCategoryShortcutsError >
                (new MenuPoiCategoryShortcutsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MenuPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MenuPoiCategoryShortcutsCallbackIF*) _callback)->onMenuPoiCategoryShortcutsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_tripReplayStatusInfo: {
                ::boost::shared_ptr< TripReplayStatusInfoError > payload = ::boost::shared_ptr< TripReplayStatusInfoError >
                (new TripReplayStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TripReplayStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TripReplayStatusInfoCallbackIF*) _callback)->onTripReplayStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_etcStatus: {
                ::boost::shared_ptr< EtcStatusError > payload = ::boost::shared_ptr< EtcStatusError >
                (new EtcStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EtcStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EtcStatusCallbackIF*) _callback)->onEtcStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TrafficSignInfoActive: {
                ::boost::shared_ptr< TrafficSignInfoActiveError > payload = ::boost::shared_ptr< TrafficSignInfoActiveError >
                (new TrafficSignInfoActiveError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TrafficSignInfoActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TrafficSignInfoActiveCallbackIF*) _callback)->onTrafficSignInfoActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OverSpeedSoundAlertInfoActive: {
                ::boost::shared_ptr< OverSpeedSoundAlertInfoActiveError > payload = ::boost::shared_ptr< OverSpeedSoundAlertInfoActiveError >
                (new OverSpeedSoundAlertInfoActiveError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OverSpeedSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OverSpeedSoundAlertInfoActiveCallbackIF*) _callback)->onOverSpeedSoundAlertInfoActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_routeRecalculationReason: {
                ::boost::shared_ptr< RouteRecalculationReasonError > payload = ::boost::shared_ptr< RouteRecalculationReasonError >
                (new RouteRecalculationReasonError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RouteRecalculationReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RouteRecalculationReasonCallbackIF*) _callback)->onRouteRecalculationReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RiskAreaDisplayInfoActive: {
                ::boost::shared_ptr< RiskAreaDisplayInfoActiveError > payload = ::boost::shared_ptr< RiskAreaDisplayInfoActiveError >
                (new RiskAreaDisplayInfoActiveError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RiskAreaDisplayInfoActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RiskAreaDisplayInfoActiveCallbackIF*) _callback)->onRiskAreaDisplayInfoActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RiskAreaSoundAlertInfoActive: {
                ::boost::shared_ptr< RiskAreaSoundAlertInfoActiveError > payload = ::boost::shared_ptr< RiskAreaSoundAlertInfoActiveError >
                (new RiskAreaSoundAlertInfoActiveError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RiskAreaSoundAlertInfoActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RiskAreaSoundAlertInfoActiveCallbackIF*) _callback)->onRiskAreaSoundAlertInfoActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_jamAheadList: {
                ::boost::shared_ptr< JamAheadListError > payload = ::boost::shared_ptr< JamAheadListError >
                (new JamAheadListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JamAheadList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JamAheadListCallbackIF*) _callback)->onJamAheadListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_waypointOperationStatusList: {
                ::boost::shared_ptr< WaypointOperationStatusListError > payload = ::boost::shared_ptr< WaypointOperationStatusListError >
                (new WaypointOperationStatusListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WaypointOperationStatusList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WaypointOperationStatusListCallbackIF*) _callback)->onWaypointOperationStatusListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_destinationReachedStatus: {
                ::boost::shared_ptr< DestinationReachedStatusError > payload = ::boost::shared_ptr< DestinationReachedStatusError >
                (new DestinationReachedStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DestinationReachedStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DestinationReachedStatusCallbackIF*) _callback)->onDestinationReachedStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_lightModeStatus: {
                ::boost::shared_ptr< LightModeStatusError > payload = ::boost::shared_ptr< LightModeStatusError >
                (new LightModeStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LightModeStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LightModeStatusCallbackIF*) _callback)->onLightModeStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_mapCameraData: {
                ::boost::shared_ptr< MapCameraDataError > payload = ::boost::shared_ptr< MapCameraDataError >
                (new MapCameraDataError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapCameraData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapCameraDataCallbackIF*) _callback)->onMapCameraDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_selectPoiCategoryShortcut: {
                ::boost::shared_ptr< SelectPoiCategoryShortcutError > payload = ::boost::shared_ptr< SelectPoiCategoryShortcutError >
                (new SelectPoiCategoryShortcutError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SelectPoiCategoryShortcut", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectPoiCategoryShortcutCallbackIF*) _callback)->onSelectPoiCategoryShortcutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getPoiCategoryShortcuts: {
                ::boost::shared_ptr< GetPoiCategoryShortcutsError > payload = ::boost::shared_ptr< GetPoiCategoryShortcutsError >
                (new GetPoiCategoryShortcutsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetPoiCategoryShortcuts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPoiCategoryShortcutsCallbackIF*) _callback)->onGetPoiCategoryShortcutsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithCoordinates: {
                ::boost::shared_ptr< SetLocationWithCoordinatesError > payload = ::boost::shared_ptr< SetLocationWithCoordinatesError >
                (new SetLocationWithCoordinatesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithCoordinates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithCoordinatesCallbackIF*) _callback)->onSetLocationWithCoordinatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithDetails: {
                ::boost::shared_ptr< SetLocationWithDetailsError > payload = ::boost::shared_ptr< SetLocationWithDetailsError >
                (new SetLocationWithDetailsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithDetailsCallbackIF*) _callback)->onSetLocationWithDetailsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showPOILocationFromTCU: {
                ::boost::shared_ptr< ShowPOILocationFromTCUError > payload = ::boost::shared_ptr< ShowPOILocationFromTCUError >
                (new ShowPOILocationFromTCUError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowPOILocationFromTCU", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowPOILocationFromTCUCallbackIF*) _callback)->onShowPOILocationFromTCUError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storePOILocationToAddressBook: {
                ::boost::shared_ptr< StorePOILocationToAddressBookError > payload = ::boost::shared_ptr< StorePOILocationToAddressBookError >
                (new StorePOILocationToAddressBookError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StorePOILocationToAddressBook", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StorePOILocationToAddressBookCallbackIF*) _callback)->onStorePOILocationToAddressBookError (proxyShared,payload);
                return true;
            }
            break;
            case ID_storeLocationToAddressBook: {
                ::boost::shared_ptr< StoreLocationToAddressBookError > payload = ::boost::shared_ptr< StoreLocationToAddressBookError >
                (new StoreLocationToAddressBookError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StoreLocationToAddressBook", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StoreLocationToAddressBookCallbackIF*) _callback)->onStoreLocationToAddressBookError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showDestinationOverviewFromTCU: {
                ::boost::shared_ptr< ShowDestinationOverviewFromTCUError > payload = ::boost::shared_ptr< ShowDestinationOverviewFromTCUError >
                (new ShowDestinationOverviewFromTCUError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowDestinationOverviewFromTCU", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowDestinationOverviewFromTCUCallbackIF*) _callback)->onShowDestinationOverviewFromTCUError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showCalculateTour: {
                ::boost::shared_ptr< ShowCalculateTourError > payload = ::boost::shared_ptr< ShowCalculateTourError >
                (new ShowCalculateTourError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowCalculateTour", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowCalculateTourCallbackIF*) _callback)->onShowCalculateTourError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showOnMap: {
                ::boost::shared_ptr< ShowOnMapError > payload = ::boost::shared_ptr< ShowOnMapError >
                (new ShowOnMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowOnMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowOnMapCallbackIF*) _callback)->onShowOnMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showCarsorLocationOnMap: {
                ::boost::shared_ptr< ShowCarsorLocationOnMapError > payload = ::boost::shared_ptr< ShowCarsorLocationOnMapError >
                (new ShowCarsorLocationOnMapError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowCarsorLocationOnMap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowCarsorLocationOnMapCallbackIF*) _callback)->onShowCarsorLocationOnMapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showCityInputAndGetCityCoordinates: {
                ::boost::shared_ptr< ShowCityInputAndGetCityCoordinatesError > payload = ::boost::shared_ptr< ShowCityInputAndGetCityCoordinatesError >
                (new ShowCityInputAndGetCityCoordinatesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowCityInputAndGetCityCoordinates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowCityInputAndGetCityCoordinatesCallbackIF*) _callback)->onShowCityInputAndGetCityCoordinatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestLocationDetailsForCoordinates: {
                ::boost::shared_ptr< RequestLocationDetailsForCoordinatesError > payload = ::boost::shared_ptr< RequestLocationDetailsForCoordinatesError >
                (new RequestLocationDetailsForCoordinatesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestLocationDetailsForCoordinates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestLocationDetailsForCoordinatesCallbackIF*) _callback)->onRequestLocationDetailsForCoordinatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showAdjustCurrentLocationScreen: {
                ::boost::shared_ptr< ShowAdjustCurrentLocationScreenError > payload = ::boost::shared_ptr< ShowAdjustCurrentLocationScreenError >
                (new ShowAdjustCurrentLocationScreenError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowAdjustCurrentLocationScreen", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowAdjustCurrentLocationScreenCallbackIF*) _callback)->onShowAdjustCurrentLocationScreenError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showWhereAmIScreen: {
                ::boost::shared_ptr< ShowWhereAmIScreenError > payload = ::boost::shared_ptr< ShowWhereAmIScreenError >
                (new ShowWhereAmIScreenError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowWhereAmIScreen", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowWhereAmIScreenCallbackIF*) _callback)->onShowWhereAmIScreenError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showTrafficInfoScreen: {
                ::boost::shared_ptr< ShowTrafficInfoScreenError > payload = ::boost::shared_ptr< ShowTrafficInfoScreenError >
                (new ShowTrafficInfoScreenError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowTrafficInfoScreen", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowTrafficInfoScreenCallbackIF*) _callback)->onShowTrafficInfoScreenError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showMapScreenWithMapViewMode: {
                ::boost::shared_ptr< ShowMapScreenWithMapViewModeError > payload = ::boost::shared_ptr< ShowMapScreenWithMapViewModeError >
                (new ShowMapScreenWithMapViewModeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowMapScreenWithMapViewMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowMapScreenWithMapViewModeCallbackIF*) _callback)->onShowMapScreenWithMapViewModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showMapScreenCarsorLockMode: {
                ::boost::shared_ptr< ShowMapScreenCarsorLockModeError > payload = ::boost::shared_ptr< ShowMapScreenCarsorLockModeError >
                (new ShowMapScreenCarsorLockModeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowMapScreenCarsorLockMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowMapScreenCarsorLockModeCallbackIF*) _callback)->onShowMapScreenCarsorLockModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showDeleteWaypointListScreen: {
                ::boost::shared_ptr< ShowDeleteWaypointListScreenError > payload = ::boost::shared_ptr< ShowDeleteWaypointListScreenError >
                (new ShowDeleteWaypointListScreenError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowDeleteWaypointListScreen", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowDeleteWaypointListScreenCallbackIF*) _callback)->onShowDeleteWaypointListScreenError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setZoomInStep: {
                ::boost::shared_ptr< SetZoomInStepError > payload = ::boost::shared_ptr< SetZoomInStepError >
                (new SetZoomInStepError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetZoomInStep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetZoomInStepCallbackIF*) _callback)->onSetZoomInStepError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setZoomOutStep: {
                ::boost::shared_ptr< SetZoomOutStepError > payload = ::boost::shared_ptr< SetZoomOutStepError >
                (new SetZoomOutStepError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetZoomOutStep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetZoomOutStepCallbackIF*) _callback)->onSetZoomOutStepError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setZoomLevel: {
                ::boost::shared_ptr< SetZoomLevelError > payload = ::boost::shared_ptr< SetZoomLevelError >
                (new SetZoomLevelError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetZoomLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetZoomLevelCallbackIF*) _callback)->onSetZoomLevelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getVersionString: {
                ::boost::shared_ptr< GetVersionStringError > payload = ::boost::shared_ptr< GetVersionStringError >
                (new GetVersionStringError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetVersionString", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetVersionStringCallbackIF*) _callback)->onGetVersionStringError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setSXMTravelLinkSubscriptionStatus: {
                ::boost::shared_ptr< SetSXMTravelLinkSubscriptionStatusError > payload = ::boost::shared_ptr< SetSXMTravelLinkSubscriptionStatusError >
                (new SetSXMTravelLinkSubscriptionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSXMTravelLinkSubscriptionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSXMTravelLinkSubscriptionStatusCallbackIF*) _callback)->onSetSXMTravelLinkSubscriptionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startGuidance: {
                ::boost::shared_ptr< StartGuidanceError > payload = ::boost::shared_ptr< StartGuidanceError >
                (new StartGuidanceError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartGuidance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartGuidanceCallbackIF*) _callback)->onStartGuidanceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startGuidanceToPosWGS84: {
                ::boost::shared_ptr< StartGuidanceToPosWGS84Error > payload = ::boost::shared_ptr< StartGuidanceToPosWGS84Error >
                (new StartGuidanceToPosWGS84Error(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartGuidanceToPosWGS84", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartGuidanceToPosWGS84CallbackIF*) _callback)->onStartGuidanceToPosWGS84Error (proxyShared,payload);
                return true;
            }
            break;
            case ID_startGuidanceToHomeLocation: {
                ::boost::shared_ptr< StartGuidanceToHomeLocationError > payload = ::boost::shared_ptr< StartGuidanceToHomeLocationError >
                (new StartGuidanceToHomeLocationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartGuidanceToHomeLocation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartGuidanceToHomeLocationCallbackIF*) _callback)->onStartGuidanceToHomeLocationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startGuidanceToWorkLocation: {
                ::boost::shared_ptr< StartGuidanceToWorkLocationError > payload = ::boost::shared_ptr< StartGuidanceToWorkLocationError >
                (new StartGuidanceToWorkLocationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartGuidanceToWorkLocation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartGuidanceToWorkLocationCallbackIF*) _callback)->onStartGuidanceToWorkLocationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithDestinationMemoryEntry: {
                ::boost::shared_ptr< SetLocationWithDestinationMemoryEntryError > payload = ::boost::shared_ptr< SetLocationWithDestinationMemoryEntryError >
                (new SetLocationWithDestinationMemoryEntryError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithDestinationMemoryEntry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithDestinationMemoryEntryCallbackIF*) _callback)->onSetLocationWithDestinationMemoryEntryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cancelRouteGuidance: {
                ::boost::shared_ptr< CancelRouteGuidanceError > payload = ::boost::shared_ptr< CancelRouteGuidanceError >
                (new CancelRouteGuidanceError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelRouteGuidance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelRouteGuidanceCallbackIF*) _callback)->onCancelRouteGuidanceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_insertWaypoint: {
                ::boost::shared_ptr< InsertWaypointError > payload = ::boost::shared_ptr< InsertWaypointError >
                (new InsertWaypointError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InsertWaypoint", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InsertWaypointCallbackIF*) _callback)->onInsertWaypointError (proxyShared,payload);
                return true;
            }
            break;
            case ID_insertWaypointAtDefaultPosition: {
                ::boost::shared_ptr< InsertWaypointAtDefaultPositionError > payload = ::boost::shared_ptr< InsertWaypointAtDefaultPositionError >
                (new InsertWaypointAtDefaultPositionError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InsertWaypointAtDefaultPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InsertWaypointAtDefaultPositionCallbackIF*) _callback)->onInsertWaypointAtDefaultPositionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_replaceWaypoint: {
                ::boost::shared_ptr< ReplaceWaypointError > payload = ::boost::shared_ptr< ReplaceWaypointError >
                (new ReplaceWaypointError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReplaceWaypoint", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReplaceWaypointCallbackIF*) _callback)->onReplaceWaypointError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deleteWaypoints: {
                ::boost::shared_ptr< DeleteWaypointsError > payload = ::boost::shared_ptr< DeleteWaypointsError >
                (new DeleteWaypointsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeleteWaypoints", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeleteWaypointsCallbackIF*) _callback)->onDeleteWaypointsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_applyWaypointListChange: {
                ::boost::shared_ptr< ApplyWaypointListChangeError > payload = ::boost::shared_ptr< ApplyWaypointListChangeError >
                (new ApplyWaypointListChangeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ApplyWaypointListChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ApplyWaypointListChangeCallbackIF*) _callback)->onApplyWaypointListChangeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestWaypointList: {
                ::boost::shared_ptr< RequestWaypointListError > payload = ::boost::shared_ptr< RequestWaypointListError >
                (new RequestWaypointListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestWaypointList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestWaypointListCallbackIF*) _callback)->onRequestWaypointListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestSetFreeTextSearchType: {
                ::boost::shared_ptr< RequestSetFreeTextSearchTypeError > payload = ::boost::shared_ptr< RequestSetFreeTextSearchTypeError >
                (new RequestSetFreeTextSearchTypeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestSetFreeTextSearchType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestSetFreeTextSearchTypeCallbackIF*) _callback)->onRequestSetFreeTextSearchTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestFreeTextSearchResults: {
                ::boost::shared_ptr< RequestFreeTextSearchResultsError > payload = ::boost::shared_ptr< RequestFreeTextSearchResultsError >
                (new RequestFreeTextSearchResultsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestFreeTextSearchResults", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestFreeTextSearchResultsCallbackIF*) _callback)->onRequestFreeTextSearchResultsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_undoFreeTextSearchElementSelection: {
                ::boost::shared_ptr< UndoFreeTextSearchElementSelectionError > payload = ::boost::shared_ptr< UndoFreeTextSearchElementSelectionError >
                (new UndoFreeTextSearchElementSelectionError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UndoFreeTextSearchElementSelection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UndoFreeTextSearchElementSelectionCallbackIF*) _callback)->onUndoFreeTextSearchElementSelectionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithFreeTextSearchInput: {
                ::boost::shared_ptr< SetLocationWithFreeTextSearchInputError > payload = ::boost::shared_ptr< SetLocationWithFreeTextSearchInputError >
                (new SetLocationWithFreeTextSearchInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithFreeTextSearchInputCallbackIF*) _callback)->onSetLocationWithFreeTextSearchInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showDestinationFreeTextSearchInput: {
                ::boost::shared_ptr< ShowDestinationFreeTextSearchInputError > payload = ::boost::shared_ptr< ShowDestinationFreeTextSearchInputError >
                (new ShowDestinationFreeTextSearchInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowDestinationFreeTextSearchInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowDestinationFreeTextSearchInputCallbackIF*) _callback)->onShowDestinationFreeTextSearchInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestFixedPOICategorySearchResults: {
                ::boost::shared_ptr< RequestFixedPOICategorySearchResultsError > payload = ::boost::shared_ptr< RequestFixedPOICategorySearchResultsError >
                (new RequestFixedPOICategorySearchResultsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestFixedPOICategorySearchResults", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestFixedPOICategorySearchResultsCallbackIF*) _callback)->onRequestFixedPOICategorySearchResultsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_undoSetLocationWithFixedPOICategoryInput: {
                ::boost::shared_ptr< UndoSetLocationWithFixedPOICategoryInputError > payload = ::boost::shared_ptr< UndoSetLocationWithFixedPOICategoryInputError >
                (new UndoSetLocationWithFixedPOICategoryInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UndoSetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UndoSetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onUndoSetLocationWithFixedPOICategoryInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithFixedPOICategoryInput: {
                ::boost::shared_ptr< SetLocationWithFixedPOICategoryInputError > payload = ::boost::shared_ptr< SetLocationWithFixedPOICategoryInputError >
                (new SetLocationWithFixedPOICategoryInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithFixedPOICategoryInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithFixedPOICategoryInputCallbackIF*) _callback)->onSetLocationWithFixedPOICategoryInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsCheckAddress: {
                ::boost::shared_ptr< SdsCheckAddressError > payload = ::boost::shared_ptr< SdsCheckAddressError >
                (new SdsCheckAddressError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsCheckAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsCheckAddressCallbackIF*) _callback)->onSdsCheckAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsGetRefinementList: {
                ::boost::shared_ptr< SdsGetRefinementListError > payload = ::boost::shared_ptr< SdsGetRefinementListError >
                (new SdsGetRefinementListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsGetRefinementList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsGetRefinementListCallbackIF*) _callback)->onSdsGetRefinementListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_selectSdsRefinement: {
                ::boost::shared_ptr< SelectSdsRefinementError > payload = ::boost::shared_ptr< SelectSdsRefinementError >
                (new SelectSdsRefinementError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SelectSdsRefinement", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectSdsRefinementCallbackIF*) _callback)->onSelectSdsRefinementError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLocationWithSdsInput: {
                ::boost::shared_ptr< SetLocationWithSdsInputError > payload = ::boost::shared_ptr< SetLocationWithSdsInputError >
                (new SetLocationWithSdsInputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLocationWithSdsInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLocationWithSdsInputCallbackIF*) _callback)->onSetLocationWithSdsInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestDestinationMemoryEntries: {
                ::boost::shared_ptr< RequestDestinationMemoryEntriesError > payload = ::boost::shared_ptr< RequestDestinationMemoryEntriesError >
                (new RequestDestinationMemoryEntriesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestDestinationMemoryEntries", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestDestinationMemoryEntriesCallbackIF*) _callback)->onRequestDestinationMemoryEntriesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setMapRepresentation: {
                ::boost::shared_ptr< SetMapRepresentationError > payload = ::boost::shared_ptr< SetMapRepresentationError >
                (new SetMapRepresentationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMapRepresentation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMapRepresentationCallbackIF*) _callback)->onSetMapRepresentationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestDetailsForSelectedLocation: {
                ::boost::shared_ptr< RequestDetailsForSelectedLocationError > payload = ::boost::shared_ptr< RequestDetailsForSelectedLocationError >
                (new RequestDetailsForSelectedLocationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestDetailsForSelectedLocation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestDetailsForSelectedLocationCallbackIF*) _callback)->onRequestDetailsForSelectedLocationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_retriggerAcousticOutput: {
                ::boost::shared_ptr< RetriggerAcousticOutputError > payload = ::boost::shared_ptr< RetriggerAcousticOutputError >
                (new RetriggerAcousticOutputError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RetriggerAcousticOutput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RetriggerAcousticOutputCallbackIF*) _callback)->onRetriggerAcousticOutputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_speakSamplePhrase: {
                ::boost::shared_ptr< SpeakSamplePhraseError > payload = ::boost::shared_ptr< SpeakSamplePhraseError >
                (new SpeakSamplePhraseError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeakSamplePhrase", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeakSamplePhraseCallbackIF*) _callback)->onSpeakSamplePhraseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setRouteCriterion: {
                ::boost::shared_ptr< SetRouteCriterionError > payload = ::boost::shared_ptr< SetRouteCriterionError >
                (new SetRouteCriterionError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetRouteCriterion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetRouteCriterionCallbackIF*) _callback)->onSetRouteCriterionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setVoiceGuidance: {
                ::boost::shared_ptr< SetVoiceGuidanceError > payload = ::boost::shared_ptr< SetVoiceGuidanceError >
                (new SetVoiceGuidanceError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetVoiceGuidance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetVoiceGuidanceCallbackIF*) _callback)->onSetVoiceGuidanceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CheckNavDataCompatibility: {
                ::boost::shared_ptr< CheckNavDataCompatibilityError > payload = ::boost::shared_ptr< CheckNavDataCompatibilityError >
                (new CheckNavDataCompatibilityError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CheckNavDataCompatibility", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CheckNavDataCompatibilityCallbackIF*) _callback)->onCheckNavDataCompatibilityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsUpdateVoiceTag: {
                ::boost::shared_ptr< SdsUpdateVoiceTagError > payload = ::boost::shared_ptr< SdsUpdateVoiceTagError >
                (new SdsUpdateVoiceTagError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsUpdateVoiceTag", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsUpdateVoiceTagCallbackIF*) _callback)->onSdsUpdateVoiceTagError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sdsGetHouseNumberPattern: {
                ::boost::shared_ptr< SdsGetHouseNumberPatternError > payload = ::boost::shared_ptr< SdsGetHouseNumberPatternError >
                (new SdsGetHouseNumberPatternError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SdsGetHouseNumberPattern", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SdsGetHouseNumberPatternCallbackIF*) _callback)->onSdsGetHouseNumberPatternError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setMapLightMode: {
                ::boost::shared_ptr< SetMapLightModeError > payload = ::boost::shared_ptr< SetMapLightModeError >
                (new SetMapLightModeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMapLightMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMapLightModeCallbackIF*) _callback)->onSetMapLightModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startTripReplay: {
                ::boost::shared_ptr< StartTripReplayError > payload = ::boost::shared_ptr< StartTripReplayError >
                (new StartTripReplayError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartTripReplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartTripReplayCallbackIF*) _callback)->onStartTripReplayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_stopTripReplay: {
                ::boost::shared_ptr< StopTripReplayError > payload = ::boost::shared_ptr< StopTripReplayError >
                (new StopTripReplayError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopTripReplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopTripReplayCallbackIF*) _callback)->onStopTripReplayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_seekTripReplay: {
                ::boost::shared_ptr< SeekTripReplayError > payload = ::boost::shared_ptr< SeekTripReplayError >
                (new SeekTripReplayError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SeekTripReplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SeekTripReplayCallbackIF*) _callback)->onSeekTripReplayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setTripReplayMode: {
                ::boost::shared_ptr< SetTripReplayModeError > payload = ::boost::shared_ptr< SetTripReplayModeError >
                (new SetTripReplayModeError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetTripReplayMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetTripReplayModeCallbackIF*) _callback)->onSetTripReplayModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showLocationSelectionAndGetAddressDetails: {
                ::boost::shared_ptr< ShowLocationSelectionAndGetAddressDetailsError > payload = ::boost::shared_ptr< ShowLocationSelectionAndGetAddressDetailsError >
                (new ShowLocationSelectionAndGetAddressDetailsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowLocationSelectionAndGetAddressDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowLocationSelectionAndGetAddressDetailsCallbackIF*) _callback)->onShowLocationSelectionAndGetAddressDetailsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showRouteCalculationToDestination: {
                ::boost::shared_ptr< ShowRouteCalculationToDestinationError > payload = ::boost::shared_ptr< ShowRouteCalculationToDestinationError >
                (new ShowRouteCalculationToDestinationError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowRouteCalculationToDestination", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowRouteCalculationToDestinationCallbackIF*) _callback)->onShowRouteCalculationToDestinationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestJamAheadList: {
                ::boost::shared_ptr< RequestJamAheadListError > payload = ::boost::shared_ptr< RequestJamAheadListError >
                (new RequestJamAheadListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestJamAheadList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestJamAheadListCallbackIF*) _callback)->onRequestJamAheadListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_releaseJamAheadList: {
                ::boost::shared_ptr< ReleaseJamAheadListError > payload = ::boost::shared_ptr< ReleaseJamAheadListError >
                (new ReleaseJamAheadListError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReleaseJamAheadList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseJamAheadListCallbackIF*) _callback)->onReleaseJamAheadListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_selectJamAheadListEntry: {
                ::boost::shared_ptr< SelectJamAheadListEntryError > payload = ::boost::shared_ptr< SelectJamAheadListEntryError >
                (new SelectJamAheadListEntryError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SelectJamAheadListEntry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SelectJamAheadListEntryCallbackIF*) _callback)->onSelectJamAheadListEntryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activateNonPremiumTMC: {
                ::boost::shared_ptr< ActivateNonPremiumTMCError > payload = ::boost::shared_ptr< ActivateNonPremiumTMCError >
                (new ActivateNonPremiumTMCError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateNonPremiumTMCCallbackIF*) _callback)->onActivateNonPremiumTMCError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deactivateNonPremiumTMC: {
                ::boost::shared_ptr< DeactivateNonPremiumTMCError > payload = ::boost::shared_ptr< DeactivateNonPremiumTMCError >
                (new DeactivateNonPremiumTMCError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeactivateNonPremiumTMC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeactivateNonPremiumTMCCallbackIF*) _callback)->onDeactivateNonPremiumTMCError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cancelJamAhead: {
                ::boost::shared_ptr< CancelJamAheadError > payload = ::boost::shared_ptr< CancelJamAheadError >
                (new CancelJamAheadError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelJamAhead", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelJamAheadCallbackIF*) _callback)->onCancelJamAheadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestDetailsForSelectedCoordinateWithRadius: {
                ::boost::shared_ptr< RequestDetailsForSelectedCoordinateWithRadiusError > payload = ::boost::shared_ptr< RequestDetailsForSelectedCoordinateWithRadiusError >
                (new RequestDetailsForSelectedCoordinateWithRadiusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestDetailsForSelectedCoordinateWithRadius", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestDetailsForSelectedCoordinateWithRadiusCallbackIF*) _callback)->onRequestDetailsForSelectedCoordinateWithRadiusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_showAndSetLocationWithDetails: {
                ::boost::shared_ptr< ShowAndSetLocationWithDetailsError > payload = ::boost::shared_ptr< ShowAndSetLocationWithDetailsError >
                (new ShowAndSetLocationWithDetailsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowAndSetLocationWithDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowAndSetLocationWithDetailsCallbackIF*) _callback)->onShowAndSetLocationWithDetailsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NavigationServiceProxyCallback::_logger (NavigationServiceProxy::_logger);

NavigationServiceProxy::NavigationServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.navigation.NavigationService", serviceAvailable, _logger) {
}

NavigationServiceProxy::~NavigationServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NavigationServiceProxy > NavigationServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NavigationServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NavigationServiceProxy > proxyNew(new NavigationServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t NavigationServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NavigationServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationServiceProxy::clearAllProperties ()
{
    _navStatus = ::asf::core::nullable< NavStatusUpdate >();
    _datasetVersion = ::asf::core::nullable< DatasetVersionUpdate >();
    _nonPremiumTMCStatus = ::asf::core::nullable< NonPremiumTMCStatusUpdate >();
    _currentFreeTextSearchInfo = ::asf::core::nullable< CurrentFreeTextSearchInfoUpdate >();
    _positionInformation = ::asf::core::nullable< PositionInformationUpdate >();
    _distanceToDestination = ::asf::core::nullable< DistanceToDestinationUpdate >();
    _currentStreet = ::asf::core::nullable< CurrentStreetUpdate >();
    _turntoStreet = ::asf::core::nullable< TurntoStreetUpdate >();
    _roundaboutExitNumber = ::asf::core::nullable< RoundaboutExitNumberUpdate >();
    _nextTurntoStreet = ::asf::core::nullable< NextTurntoStreetUpdate >();
    _barGraphInfo = ::asf::core::nullable< BarGraphInfoUpdate >();
    _maneuverSymbol = ::asf::core::nullable< ManeuverSymbolUpdate >();
    _satelliteInfo = ::asf::core::nullable< SatelliteInfoUpdate >();
    _destinationInformation = ::asf::core::nullable< DestinationInformationUpdate >();
    _routeCalculationDuration = ::asf::core::nullable< RouteCalculationDurationUpdate >();
    _homeLocation = ::asf::core::nullable< HomeLocationUpdate >();
    _workLocation = ::asf::core::nullable< WorkLocationUpdate >();
    _mapRepresentation = ::asf::core::nullable< MapRepresentationUpdate >();
    _sdsAddressWithOptions = ::asf::core::nullable< SdsAddressWithOptionsUpdate >();
    _waypointList = ::asf::core::nullable< WaypointListUpdate >();
    _maneuverView = ::asf::core::nullable< ManeuverViewUpdate >();
    _intersectionMapCarsorPosition = ::asf::core::nullable< IntersectionMapCarsorPositionUpdate >();
    _speedLimit = ::asf::core::nullable< SpeedLimitUpdate >();
    _trafficEnforcement = ::asf::core::nullable< TrafficEnforcementUpdate >();
    _nextManeuverDetails = ::asf::core::nullable< NextManeuverDetailsUpdate >();
    _laneRecommendationList = ::asf::core::nullable< LaneRecommendationListUpdate >();
    _arrivalInformationList = ::asf::core::nullable< ArrivalInformationListUpdate >();
    _intersectionMap = ::asf::core::nullable< IntersectionMapUpdate >();
    _isAddressBookChanged = ::asf::core::nullable< IsAddressBookChangedUpdate >();
    _isMaxAllowedAddressBookEntriesStored = ::asf::core::nullable< IsMaxAllowedAddressBookEntriesStoredUpdate >();
    _isLastDestinationListChanged = ::asf::core::nullable< IsLastDestinationListChangedUpdate >();
    _isVoiceGuidanceActive = ::asf::core::nullable< IsVoiceGuidanceActiveUpdate >();
    _sdsVoiceTagWithOptions = ::asf::core::nullable< SdsVoiceTagWithOptionsUpdate >();
    _trafficMessagesCount = ::asf::core::nullable< TrafficMessagesCountUpdate >();
    _trafficServiceReceptionStatus = ::asf::core::nullable< TrafficServiceReceptionStatusUpdate >();
    _sdsPOICategoryShortcuts = ::asf::core::nullable< SdsPOICategoryShortcutsUpdate >();
    _menuPoiCategoryShortcuts = ::asf::core::nullable< MenuPoiCategoryShortcutsUpdate >();
    _tripReplayStatusInfo = ::asf::core::nullable< TripReplayStatusInfoUpdate >();
    _etcStatus = ::asf::core::nullable< EtcStatusUpdate >();
    _trafficSignInfoActive = ::asf::core::nullable< TrafficSignInfoActiveUpdate >();
    _overSpeedSoundAlertInfoActive = ::asf::core::nullable< OverSpeedSoundAlertInfoActiveUpdate >();
    _routeRecalculationReason = ::asf::core::nullable< RouteRecalculationReasonUpdate >();
    _riskAreaDisplayInfoActive = ::asf::core::nullable< RiskAreaDisplayInfoActiveUpdate >();
    _riskAreaSoundAlertInfoActive = ::asf::core::nullable< RiskAreaSoundAlertInfoActiveUpdate >();
    _jamAheadList = ::asf::core::nullable< JamAheadListUpdate >();
    _waypointOperationStatusList = ::asf::core::nullable< WaypointOperationStatusListUpdate >();
    _destinationReachedStatus = ::asf::core::nullable< DestinationReachedStatusUpdate >();
    _lightModeStatus = ::asf::core::nullable< LightModeStatusUpdate >();
    _mapCameraData = ::asf::core::nullable< MapCameraDataUpdate >();
}

void NavigationServiceProxy::sendDeregisterAll () const
{
    sendNavStatusDeregisterAll();
    sendDatasetVersionDeregisterAll();
    sendNonPremiumTMCStatusDeregisterAll();
    sendCurrentFreeTextSearchInfoDeregisterAll();
    sendPositionInformationDeregisterAll();
    sendDistanceToDestinationDeregisterAll();
    sendCurrentStreetDeregisterAll();
    sendTurntoStreetDeregisterAll();
    sendRoundaboutExitNumberDeregisterAll();
    sendNextTurntoStreetDeregisterAll();
    sendBarGraphInfoDeregisterAll();
    sendManeuverSymbolDeregisterAll();
    sendSatelliteInfoDeregisterAll();
    sendDestinationInformationDeregisterAll();
    sendRouteCalculationDurationDeregisterAll();
    sendHomeLocationDeregisterAll();
    sendWorkLocationDeregisterAll();
    sendMapRepresentationDeregisterAll();
    sendSdsAddressWithOptionsDeregisterAll();
    sendWaypointListDeregisterAll();
    sendManeuverViewDeregisterAll();
    sendIntersectionMapCarsorPositionDeregisterAll();
    sendSpeedLimitDeregisterAll();
    sendTrafficEnforcementDeregisterAll();
    sendNextManeuverDetailsDeregisterAll();
    sendLaneRecommendationListDeregisterAll();
    sendArrivalInformationListDeregisterAll();
    sendIntersectionMapDeregisterAll();
    sendIsAddressBookChangedDeregisterAll();
    sendIsMaxAllowedAddressBookEntriesStoredDeregisterAll();
    sendIsLastDestinationListChangedDeregisterAll();
    sendIsVoiceGuidanceActiveDeregisterAll();
    sendSdsVoiceTagWithOptionsDeregisterAll();
    sendTrafficMessagesCountDeregisterAll();
    sendTrafficServiceReceptionStatusDeregisterAll();
    sendSdsPOICategoryShortcutsDeregisterAll();
    sendMenuPoiCategoryShortcutsDeregisterAll();
    sendTripReplayStatusInfoDeregisterAll();
    sendEtcStatusDeregisterAll();
    sendTrafficSignInfoActiveDeregisterAll();
    sendOverSpeedSoundAlertInfoActiveDeregisterAll();
    sendRouteRecalculationReasonDeregisterAll();
    sendRiskAreaDisplayInfoActiveDeregisterAll();
    sendRiskAreaSoundAlertInfoActiveDeregisterAll();
    sendJamAheadListDeregisterAll();
    sendWaypointOperationStatusListDeregisterAll();
    sendDestinationReachedStatusDeregisterAll();
    sendLightModeStatusDeregisterAll();
    sendMapCameraDataDeregisterAll();
}

act_t NavigationServiceProxy::sendNavStatusRegister(NavStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_navStatus, "navStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NavStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendNavStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("navStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NavStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendNavStatusGet(NavStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_navStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NavStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("navStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


NavStatus NavigationServiceProxy::getNavStatus() const {
    return _navStatus.get().getNavStatus();
}

bool NavigationServiceProxy::hasNavStatus() const {
    return _navStatus.hasValue();
}

void NavigationServiceProxy::sendNavStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NavStatus");
    _dbusProxyDelegate->deregisterSignalCallback("navStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendDatasetVersionRegister(DatasetVersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_datasetVersion, "datasetVersion", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DatasetVersion", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendDatasetVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("datasetVersion", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DatasetVersion", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendDatasetVersionGet(DatasetVersionCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_datasetVersion, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DatasetVersion", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("datasetVersion", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& NavigationServiceProxy::getDatasetVersion() const {
    return _datasetVersion.get().getDatasetVersion();
}

bool NavigationServiceProxy::hasDatasetVersion() const {
    return _datasetVersion.hasValue();
}

void NavigationServiceProxy::sendDatasetVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DatasetVersion");
    _dbusProxyDelegate->deregisterSignalCallback("datasetVersion", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendNonPremiumTMCStatusRegister(NonPremiumTMCStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_nonPremiumTMCStatus, "nonPremiumTMCStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NonPremiumTMCStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendNonPremiumTMCStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("nonPremiumTMCStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NonPremiumTMCStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendNonPremiumTMCStatusGet(NonPremiumTMCStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_nonPremiumTMCStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NonPremiumTMCStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("nonPremiumTMCStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getNonPremiumTMCStatus() const {
    return _nonPremiumTMCStatus.get().getNonPremiumTMCStatus();
}

bool NavigationServiceProxy::hasNonPremiumTMCStatus() const {
    return _nonPremiumTMCStatus.hasValue();
}

void NavigationServiceProxy::sendNonPremiumTMCStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NonPremiumTMCStatus");
    _dbusProxyDelegate->deregisterSignalCallback("nonPremiumTMCStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendCurrentFreeTextSearchInfoRegister(CurrentFreeTextSearchInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_currentFreeTextSearchInfo, "currentFreeTextSearchInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentFreeTextSearchInfo", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendCurrentFreeTextSearchInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("currentFreeTextSearchInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentFreeTextSearchInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendCurrentFreeTextSearchInfoGet(CurrentFreeTextSearchInfoCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_currentFreeTextSearchInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentFreeTextSearchInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("currentFreeTextSearchInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const CurrentFreeTextSearchInfo& NavigationServiceProxy::getCurrentFreeTextSearchInfo() const {
    return _currentFreeTextSearchInfo.get().getCurrentFreeTextSearchInfo();
}

bool NavigationServiceProxy::hasCurrentFreeTextSearchInfo() const {
    return _currentFreeTextSearchInfo.hasValue();
}

void NavigationServiceProxy::sendCurrentFreeTextSearchInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentFreeTextSearchInfo");
    _dbusProxyDelegate->deregisterSignalCallback("currentFreeTextSearchInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendPositionInformationRegister(PositionInformationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_positionInformation, "positionInformation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PositionInformation", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendPositionInformationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("positionInformation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PositionInformation", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendPositionInformationGet(PositionInformationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_positionInformation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PositionInformation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("positionInformation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const PositionInformation& NavigationServiceProxy::getPositionInformation() const {
    return _positionInformation.get().getPositionInformation();
}

bool NavigationServiceProxy::hasPositionInformation() const {
    return _positionInformation.hasValue();
}

void NavigationServiceProxy::sendPositionInformationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PositionInformation");
    _dbusProxyDelegate->deregisterSignalCallback("positionInformation", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendDistanceToDestinationRegister(DistanceToDestinationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_distanceToDestination, "distanceToDestination", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DistanceToDestination", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendDistanceToDestinationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("distanceToDestination", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DistanceToDestination", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendDistanceToDestinationGet(DistanceToDestinationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_distanceToDestination, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DistanceToDestination", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("distanceToDestination", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const DistanceToDestination& NavigationServiceProxy::getDistanceToDestination() const {
    return _distanceToDestination.get().getDistanceToDestination();
}

bool NavigationServiceProxy::hasDistanceToDestination() const {
    return _distanceToDestination.hasValue();
}

void NavigationServiceProxy::sendDistanceToDestinationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DistanceToDestination");
    _dbusProxyDelegate->deregisterSignalCallback("distanceToDestination", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendCurrentStreetRegister(CurrentStreetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_currentStreet, "currentStreet", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentStreet", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendCurrentStreetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("currentStreet", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentStreet", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendCurrentStreetGet(CurrentStreetCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_currentStreet, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentStreet", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("currentStreet", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& NavigationServiceProxy::getCurrentStreet() const {
    return _currentStreet.get().getCurrentStreet();
}

bool NavigationServiceProxy::hasCurrentStreet() const {
    return _currentStreet.hasValue();
}

void NavigationServiceProxy::sendCurrentStreetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentStreet");
    _dbusProxyDelegate->deregisterSignalCallback("currentStreet", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTurntoStreetRegister(TurntoStreetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_turntoStreet, "turntoStreet", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TurntoStreet", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTurntoStreetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("turntoStreet", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TurntoStreet", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTurntoStreetGet(TurntoStreetCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_turntoStreet, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TurntoStreet", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("turntoStreet", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const TurnToStreet& NavigationServiceProxy::getTurntoStreet() const {
    return _turntoStreet.get().getTurntoStreet();
}

bool NavigationServiceProxy::hasTurntoStreet() const {
    return _turntoStreet.hasValue();
}

void NavigationServiceProxy::sendTurntoStreetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TurntoStreet");
    _dbusProxyDelegate->deregisterSignalCallback("turntoStreet", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendRoundaboutExitNumberRegister(RoundaboutExitNumberCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_roundaboutExitNumber, "roundaboutExitNumber", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RoundaboutExitNumber", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendRoundaboutExitNumberDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("roundaboutExitNumber", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RoundaboutExitNumber", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendRoundaboutExitNumberGet(RoundaboutExitNumberCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_roundaboutExitNumber, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RoundaboutExitNumber", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("roundaboutExitNumber", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint16 NavigationServiceProxy::getRoundaboutExitNumber() const {
    return _roundaboutExitNumber.get().getRoundaboutExitNumber();
}

bool NavigationServiceProxy::hasRoundaboutExitNumber() const {
    return _roundaboutExitNumber.hasValue();
}

void NavigationServiceProxy::sendRoundaboutExitNumberDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RoundaboutExitNumber");
    _dbusProxyDelegate->deregisterSignalCallback("roundaboutExitNumber", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendNextTurntoStreetRegister(NextTurntoStreetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_nextTurntoStreet, "nextTurntoStreet", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NextTurntoStreet", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendNextTurntoStreetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("nextTurntoStreet", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NextTurntoStreet", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendNextTurntoStreetGet(NextTurntoStreetCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_nextTurntoStreet, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NextTurntoStreet", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("nextTurntoStreet", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& NavigationServiceProxy::getNextTurntoStreet() const {
    return _nextTurntoStreet.get().getNextTurntoStreet();
}

bool NavigationServiceProxy::hasNextTurntoStreet() const {
    return _nextTurntoStreet.hasValue();
}

void NavigationServiceProxy::sendNextTurntoStreetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NextTurntoStreet");
    _dbusProxyDelegate->deregisterSignalCallback("nextTurntoStreet", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendBarGraphInfoRegister(BarGraphInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_barGraphInfo, "barGraphInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BarGraphInfo", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendBarGraphInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("barGraphInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BarGraphInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendBarGraphInfoGet(BarGraphInfoCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_barGraphInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BarGraphInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("barGraphInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const BarGraphInfo& NavigationServiceProxy::getBarGraphInfo() const {
    return _barGraphInfo.get().getBarGraphInfo();
}

bool NavigationServiceProxy::hasBarGraphInfo() const {
    return _barGraphInfo.hasValue();
}

void NavigationServiceProxy::sendBarGraphInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BarGraphInfo");
    _dbusProxyDelegate->deregisterSignalCallback("barGraphInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendManeuverSymbolRegister(ManeuverSymbolCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_maneuverSymbol, "maneuverSymbol", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ManeuverSymbol", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendManeuverSymbolDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("maneuverSymbol", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ManeuverSymbol", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendManeuverSymbolGet(ManeuverSymbolCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_maneuverSymbol, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ManeuverSymbol", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("maneuverSymbol", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


ManeuverSymbol NavigationServiceProxy::getManeuverSymbol() const {
    return _maneuverSymbol.get().getManeuverSymbol();
}

bool NavigationServiceProxy::hasManeuverSymbol() const {
    return _maneuverSymbol.hasValue();
}

void NavigationServiceProxy::sendManeuverSymbolDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ManeuverSymbol");
    _dbusProxyDelegate->deregisterSignalCallback("maneuverSymbol", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSatelliteInfoRegister(SatelliteInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_satelliteInfo, "satelliteInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SatelliteInfo", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendSatelliteInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("satelliteInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SatelliteInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendSatelliteInfoGet(SatelliteInfoCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_satelliteInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SatelliteInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("satelliteInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SatelliteInfo& NavigationServiceProxy::getSatelliteInfo() const {
    return _satelliteInfo.get().getSatelliteInfo();
}

bool NavigationServiceProxy::hasSatelliteInfo() const {
    return _satelliteInfo.hasValue();
}

void NavigationServiceProxy::sendSatelliteInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SatelliteInfo");
    _dbusProxyDelegate->deregisterSignalCallback("satelliteInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendDestinationInformationRegister(DestinationInformationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_destinationInformation, "destinationInformation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DestinationInformation", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendDestinationInformationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("destinationInformation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DestinationInformation", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendDestinationInformationGet(DestinationInformationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_destinationInformation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DestinationInformation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("destinationInformation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< DestinationInfoElement >& NavigationServiceProxy::getDestinationInformation() const {
    return _destinationInformation.get().getDestinationInformation();
}

bool NavigationServiceProxy::hasDestinationInformation() const {
    return _destinationInformation.hasValue();
}

void NavigationServiceProxy::sendDestinationInformationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DestinationInformation");
    _dbusProxyDelegate->deregisterSignalCallback("destinationInformation", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendRouteCalculationDurationRegister(RouteCalculationDurationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_routeCalculationDuration, "routeCalculationDuration", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RouteCalculationDuration", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendRouteCalculationDurationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("routeCalculationDuration", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RouteCalculationDuration", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendRouteCalculationDurationGet(RouteCalculationDurationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_routeCalculationDuration, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RouteCalculationDuration", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("routeCalculationDuration", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationServiceProxy::sendRouteCalculationDurationSet(const RouteCalculationDuration& routeCalculationDuration) {
    RouteCalculationDurationSet parameter(routeCalculationDuration);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "RouteCalculationDuration");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "routeCalculationDuration", propertyContent);
}

act_t NavigationServiceProxy::sendRouteCalculationDurationSet(RouteCalculationDurationCallbackIF& cb, const RouteCalculationDuration& routeCalculationDuration) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_routeCalculationDuration, &cb);
    RouteCalculationDurationSet parameter(routeCalculationDuration);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "RouteCalculationDuration", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "routeCalculationDuration", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const RouteCalculationDuration& NavigationServiceProxy::getRouteCalculationDuration() const {
    return _routeCalculationDuration.get().getRouteCalculationDuration();
}

bool NavigationServiceProxy::hasRouteCalculationDuration() const {
    return _routeCalculationDuration.hasValue();
}

void NavigationServiceProxy::sendRouteCalculationDurationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RouteCalculationDuration");
    _dbusProxyDelegate->deregisterSignalCallback("routeCalculationDuration", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendHomeLocationRegister(HomeLocationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_homeLocation, "homeLocation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HomeLocation", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendHomeLocationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("homeLocation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HomeLocation", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendHomeLocationGet(HomeLocationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_homeLocation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "HomeLocation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("homeLocation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const Location& NavigationServiceProxy::getHomeLocation() const {
    return _homeLocation.get().getHomeLocation();
}

bool NavigationServiceProxy::hasHomeLocation() const {
    return _homeLocation.hasValue();
}

void NavigationServiceProxy::sendHomeLocationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HomeLocation");
    _dbusProxyDelegate->deregisterSignalCallback("homeLocation", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendWorkLocationRegister(WorkLocationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_workLocation, "workLocation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WorkLocation", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendWorkLocationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("workLocation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WorkLocation", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendWorkLocationGet(WorkLocationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_workLocation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WorkLocation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("workLocation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const Location& NavigationServiceProxy::getWorkLocation() const {
    return _workLocation.get().getWorkLocation();
}

bool NavigationServiceProxy::hasWorkLocation() const {
    return _workLocation.hasValue();
}

void NavigationServiceProxy::sendWorkLocationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WorkLocation");
    _dbusProxyDelegate->deregisterSignalCallback("workLocation", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendMapRepresentationRegister(MapRepresentationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_mapRepresentation, "mapRepresentation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapRepresentation", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendMapRepresentationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("mapRepresentation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapRepresentation", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendMapRepresentationGet(MapRepresentationCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_mapRepresentation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MapRepresentation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("mapRepresentation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


MapRepresentation NavigationServiceProxy::getMapRepresentation() const {
    return _mapRepresentation.get().getMapRepresentation();
}

bool NavigationServiceProxy::hasMapRepresentation() const {
    return _mapRepresentation.hasValue();
}

void NavigationServiceProxy::sendMapRepresentationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapRepresentation");
    _dbusProxyDelegate->deregisterSignalCallback("mapRepresentation", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSdsAddressWithOptionsRegister(SdsAddressWithOptionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsAddressWithOptions, "sdsAddressWithOptions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsAddressWithOptions", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendSdsAddressWithOptionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsAddressWithOptions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsAddressWithOptions", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendSdsAddressWithOptionsGet(SdsAddressWithOptionsCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_sdsAddressWithOptions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsAddressWithOptions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsAddressWithOptions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SDSAddressWithOptions& NavigationServiceProxy::getSdsAddressWithOptions() const {
    return _sdsAddressWithOptions.get().getSdsAddressWithOptions();
}

bool NavigationServiceProxy::hasSdsAddressWithOptions() const {
    return _sdsAddressWithOptions.hasValue();
}

void NavigationServiceProxy::sendSdsAddressWithOptionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsAddressWithOptions");
    _dbusProxyDelegate->deregisterSignalCallback("sdsAddressWithOptions", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendWaypointListRegister(WaypointListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_waypointList, "waypointList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WaypointList", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendWaypointListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("waypointList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WaypointList", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendWaypointListGet(WaypointListCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_waypointList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WaypointList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("waypointList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< WaypointListElement >& NavigationServiceProxy::getWaypointList() const {
    return _waypointList.get().getWaypointList();
}

bool NavigationServiceProxy::hasWaypointList() const {
    return _waypointList.hasValue();
}

void NavigationServiceProxy::sendWaypointListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WaypointList");
    _dbusProxyDelegate->deregisterSignalCallback("waypointList", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendManeuverViewRegister(ManeuverViewCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_maneuverView, "maneuverView", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ManeuverView", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendManeuverViewDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("maneuverView", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ManeuverView", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendManeuverViewGet(ManeuverViewCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_maneuverView, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ManeuverView", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("maneuverView", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ManeuverView& NavigationServiceProxy::getManeuverView() const {
    return _maneuverView.get().getManeuverView();
}

bool NavigationServiceProxy::hasManeuverView() const {
    return _maneuverView.hasValue();
}

void NavigationServiceProxy::sendManeuverViewDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ManeuverView");
    _dbusProxyDelegate->deregisterSignalCallback("maneuverView", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIntersectionMapCarsorPositionRegister(IntersectionMapCarsorPositionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_intersectionMapCarsorPosition, "intersectionMapCarsorPosition", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IntersectionMapCarsorPosition", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIntersectionMapCarsorPositionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("intersectionMapCarsorPosition", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IntersectionMapCarsorPosition", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIntersectionMapCarsorPositionGet(IntersectionMapCarsorPositionCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_intersectionMapCarsorPosition, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IntersectionMapCarsorPosition", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("intersectionMapCarsorPosition", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const IntersectionMapCarsorPosition& NavigationServiceProxy::getIntersectionMapCarsorPosition() const {
    return _intersectionMapCarsorPosition.get().getIntersectionMapCarsorPosition();
}

bool NavigationServiceProxy::hasIntersectionMapCarsorPosition() const {
    return _intersectionMapCarsorPosition.hasValue();
}

void NavigationServiceProxy::sendIntersectionMapCarsorPositionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IntersectionMapCarsorPosition");
    _dbusProxyDelegate->deregisterSignalCallback("intersectionMapCarsorPosition", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSpeedLimitRegister(SpeedLimitCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_speedLimit, "speedLimit", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SpeedLimit", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendSpeedLimitDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("speedLimit", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SpeedLimit", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendSpeedLimitGet(SpeedLimitCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_speedLimit, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SpeedLimit", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("speedLimit", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SpeedLimit& NavigationServiceProxy::getSpeedLimit() const {
    return _speedLimit.get().getSpeedLimit();
}

bool NavigationServiceProxy::hasSpeedLimit() const {
    return _speedLimit.hasValue();
}

void NavigationServiceProxy::sendSpeedLimitDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SpeedLimit");
    _dbusProxyDelegate->deregisterSignalCallback("speedLimit", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTrafficEnforcementRegister(TrafficEnforcementCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_trafficEnforcement, "trafficEnforcement", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TrafficEnforcement", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTrafficEnforcementDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("trafficEnforcement", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TrafficEnforcement", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTrafficEnforcementGet(TrafficEnforcementCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficEnforcement, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TrafficEnforcement", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("trafficEnforcement", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationServiceProxy::sendTrafficEnforcementSet(const TrafficEnforcement& trafficEnforcement) {
    TrafficEnforcementSet parameter(trafficEnforcement);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TrafficEnforcement");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficEnforcement", propertyContent);
}

act_t NavigationServiceProxy::sendTrafficEnforcementSet(TrafficEnforcementCallbackIF& cb, const TrafficEnforcement& trafficEnforcement) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficEnforcement, &cb);
    TrafficEnforcementSet parameter(trafficEnforcement);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TrafficEnforcement", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficEnforcement", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const TrafficEnforcement& NavigationServiceProxy::getTrafficEnforcement() const {
    return _trafficEnforcement.get().getTrafficEnforcement();
}

bool NavigationServiceProxy::hasTrafficEnforcement() const {
    return _trafficEnforcement.hasValue();
}

void NavigationServiceProxy::sendTrafficEnforcementDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TrafficEnforcement");
    _dbusProxyDelegate->deregisterSignalCallback("trafficEnforcement", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendNextManeuverDetailsRegister(NextManeuverDetailsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_nextManeuverDetails, "nextManeuverDetails", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NextManeuverDetails", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendNextManeuverDetailsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("nextManeuverDetails", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NextManeuverDetails", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendNextManeuverDetailsGet(NextManeuverDetailsCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_nextManeuverDetails, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NextManeuverDetails", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("nextManeuverDetails", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const NextManeuverDetails& NavigationServiceProxy::getNextManeuverDetails() const {
    return _nextManeuverDetails.get().getNextManeuverDetails();
}

bool NavigationServiceProxy::hasNextManeuverDetails() const {
    return _nextManeuverDetails.hasValue();
}

void NavigationServiceProxy::sendNextManeuverDetailsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NextManeuverDetails");
    _dbusProxyDelegate->deregisterSignalCallback("nextManeuverDetails", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendLaneRecommendationListRegister(LaneRecommendationListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_laneRecommendationList, "laneRecommendationList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LaneRecommendationList", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendLaneRecommendationListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("laneRecommendationList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LaneRecommendationList", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendLaneRecommendationListGet(LaneRecommendationListCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_laneRecommendationList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LaneRecommendationList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("laneRecommendationList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< LaneRecommendation >& NavigationServiceProxy::getLaneRecommendationList() const {
    return _laneRecommendationList.get().getLaneRecommendationList();
}

bool NavigationServiceProxy::hasLaneRecommendationList() const {
    return _laneRecommendationList.hasValue();
}

void NavigationServiceProxy::sendLaneRecommendationListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LaneRecommendationList");
    _dbusProxyDelegate->deregisterSignalCallback("laneRecommendationList", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendArrivalInformationListRegister(ArrivalInformationListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_arrivalInformationList, "arrivalInformationList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ArrivalInformationList", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendArrivalInformationListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("arrivalInformationList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ArrivalInformationList", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendArrivalInformationListGet(ArrivalInformationListCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_arrivalInformationList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ArrivalInformationList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("arrivalInformationList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ArrivalInformation >& NavigationServiceProxy::getArrivalInformationList() const {
    return _arrivalInformationList.get().getArrivalInformationList();
}

bool NavigationServiceProxy::hasArrivalInformationList() const {
    return _arrivalInformationList.hasValue();
}

void NavigationServiceProxy::sendArrivalInformationListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ArrivalInformationList");
    _dbusProxyDelegate->deregisterSignalCallback("arrivalInformationList", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIntersectionMapRegister(IntersectionMapCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_intersectionMap, "intersectionMap", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IntersectionMap", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIntersectionMapDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("intersectionMap", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IntersectionMap", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIntersectionMapGet(IntersectionMapCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_intersectionMap, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IntersectionMap", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("intersectionMap", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const IntersectionMap& NavigationServiceProxy::getIntersectionMap() const {
    return _intersectionMap.get().getIntersectionMap();
}

bool NavigationServiceProxy::hasIntersectionMap() const {
    return _intersectionMap.hasValue();
}

void NavigationServiceProxy::sendIntersectionMapDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IntersectionMap");
    _dbusProxyDelegate->deregisterSignalCallback("intersectionMap", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIsAddressBookChangedRegister(IsAddressBookChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_isAddressBookChanged, "isAddressBookChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IsAddressBookChanged", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIsAddressBookChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("isAddressBookChanged", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IsAddressBookChanged", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIsAddressBookChangedGet(IsAddressBookChangedCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_isAddressBookChanged, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IsAddressBookChanged", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("isAddressBookChanged", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getIsAddressBookChanged() const {
    return _isAddressBookChanged.get().getIsAddressBookChanged();
}

bool NavigationServiceProxy::hasIsAddressBookChanged() const {
    return _isAddressBookChanged.hasValue();
}

void NavigationServiceProxy::sendIsAddressBookChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IsAddressBookChanged");
    _dbusProxyDelegate->deregisterSignalCallback("isAddressBookChanged", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIsMaxAllowedAddressBookEntriesStoredRegister(IsMaxAllowedAddressBookEntriesStoredCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_isMaxAllowedAddressBookEntriesStored, "isMaxAllowedAddressBookEntriesStored", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IsMaxAllowedAddressBookEntriesStored", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIsMaxAllowedAddressBookEntriesStoredDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("isMaxAllowedAddressBookEntriesStored", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IsMaxAllowedAddressBookEntriesStored", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIsMaxAllowedAddressBookEntriesStoredGet(IsMaxAllowedAddressBookEntriesStoredCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_isMaxAllowedAddressBookEntriesStored, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IsMaxAllowedAddressBookEntriesStored", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("isMaxAllowedAddressBookEntriesStored", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getIsMaxAllowedAddressBookEntriesStored() const {
    return _isMaxAllowedAddressBookEntriesStored.get().getIsMaxAllowedAddressBookEntriesStored();
}

bool NavigationServiceProxy::hasIsMaxAllowedAddressBookEntriesStored() const {
    return _isMaxAllowedAddressBookEntriesStored.hasValue();
}

void NavigationServiceProxy::sendIsMaxAllowedAddressBookEntriesStoredDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IsMaxAllowedAddressBookEntriesStored");
    _dbusProxyDelegate->deregisterSignalCallback("isMaxAllowedAddressBookEntriesStored", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIsLastDestinationListChangedRegister(IsLastDestinationListChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_isLastDestinationListChanged, "isLastDestinationListChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IsLastDestinationListChanged", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIsLastDestinationListChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("isLastDestinationListChanged", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IsLastDestinationListChanged", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIsLastDestinationListChangedGet(IsLastDestinationListChangedCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_isLastDestinationListChanged, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IsLastDestinationListChanged", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("isLastDestinationListChanged", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getIsLastDestinationListChanged() const {
    return _isLastDestinationListChanged.get().getIsLastDestinationListChanged();
}

bool NavigationServiceProxy::hasIsLastDestinationListChanged() const {
    return _isLastDestinationListChanged.hasValue();
}

void NavigationServiceProxy::sendIsLastDestinationListChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IsLastDestinationListChanged");
    _dbusProxyDelegate->deregisterSignalCallback("isLastDestinationListChanged", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendIsVoiceGuidanceActiveRegister(IsVoiceGuidanceActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_isVoiceGuidanceActive, "isVoiceGuidanceActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IsVoiceGuidanceActive", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendIsVoiceGuidanceActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("isVoiceGuidanceActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IsVoiceGuidanceActive", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendIsVoiceGuidanceActiveGet(IsVoiceGuidanceActiveCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_isVoiceGuidanceActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IsVoiceGuidanceActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("isVoiceGuidanceActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getIsVoiceGuidanceActive() const {
    return _isVoiceGuidanceActive.get().getIsVoiceGuidanceActive();
}

bool NavigationServiceProxy::hasIsVoiceGuidanceActive() const {
    return _isVoiceGuidanceActive.hasValue();
}

void NavigationServiceProxy::sendIsVoiceGuidanceActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IsVoiceGuidanceActive");
    _dbusProxyDelegate->deregisterSignalCallback("isVoiceGuidanceActive", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSdsVoiceTagWithOptionsRegister(SdsVoiceTagWithOptionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsVoiceTagWithOptions, "sdsVoiceTagWithOptions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsVoiceTagWithOptions", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendSdsVoiceTagWithOptionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsVoiceTagWithOptions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsVoiceTagWithOptions", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendSdsVoiceTagWithOptionsGet(SdsVoiceTagWithOptionsCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_sdsVoiceTagWithOptions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsVoiceTagWithOptions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsVoiceTagWithOptions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const SDSVoiceTagId& NavigationServiceProxy::getSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptions.get().getSdsVoiceTagWithOptions();
}

bool NavigationServiceProxy::hasSdsVoiceTagWithOptions() const {
    return _sdsVoiceTagWithOptions.hasValue();
}

void NavigationServiceProxy::sendSdsVoiceTagWithOptionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsVoiceTagWithOptions");
    _dbusProxyDelegate->deregisterSignalCallback("sdsVoiceTagWithOptions", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTrafficMessagesCountRegister(TrafficMessagesCountCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_trafficMessagesCount, "trafficMessagesCount", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TrafficMessagesCount", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTrafficMessagesCountDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("trafficMessagesCount", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TrafficMessagesCount", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTrafficMessagesCountGet(TrafficMessagesCountCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficMessagesCount, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TrafficMessagesCount", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("trafficMessagesCount", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationServiceProxy::sendTrafficMessagesCountSet(uint8 trafficMessagesCount) {
    TrafficMessagesCountSet parameter(trafficMessagesCount);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TrafficMessagesCount");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficMessagesCount", propertyContent);
}

act_t NavigationServiceProxy::sendTrafficMessagesCountSet(TrafficMessagesCountCallbackIF& cb, uint8 trafficMessagesCount) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficMessagesCount, &cb);
    TrafficMessagesCountSet parameter(trafficMessagesCount);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TrafficMessagesCount", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficMessagesCount", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 NavigationServiceProxy::getTrafficMessagesCount() const {
    return _trafficMessagesCount.get().getTrafficMessagesCount();
}

bool NavigationServiceProxy::hasTrafficMessagesCount() const {
    return _trafficMessagesCount.hasValue();
}

void NavigationServiceProxy::sendTrafficMessagesCountDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TrafficMessagesCount");
    _dbusProxyDelegate->deregisterSignalCallback("trafficMessagesCount", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTrafficServiceReceptionStatusRegister(TrafficServiceReceptionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_trafficServiceReceptionStatus, "trafficServiceReceptionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TrafficServiceReceptionStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTrafficServiceReceptionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("trafficServiceReceptionStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TrafficServiceReceptionStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTrafficServiceReceptionStatusGet(TrafficServiceReceptionStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficServiceReceptionStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TrafficServiceReceptionStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("trafficServiceReceptionStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationServiceProxy::sendTrafficServiceReceptionStatusSet(const TrafficServiceReceptionStatus& trafficServiceReceptionStatus) {
    TrafficServiceReceptionStatusSet parameter(trafficServiceReceptionStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TrafficServiceReceptionStatus");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficServiceReceptionStatus", propertyContent);
}

act_t NavigationServiceProxy::sendTrafficServiceReceptionStatusSet(TrafficServiceReceptionStatusCallbackIF& cb, const TrafficServiceReceptionStatus& trafficServiceReceptionStatus) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_trafficServiceReceptionStatus, &cb);
    TrafficServiceReceptionStatusSet parameter(trafficServiceReceptionStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TrafficServiceReceptionStatus", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "trafficServiceReceptionStatus", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const TrafficServiceReceptionStatus& NavigationServiceProxy::getTrafficServiceReceptionStatus() const {
    return _trafficServiceReceptionStatus.get().getTrafficServiceReceptionStatus();
}

bool NavigationServiceProxy::hasTrafficServiceReceptionStatus() const {
    return _trafficServiceReceptionStatus.hasValue();
}

void NavigationServiceProxy::sendTrafficServiceReceptionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TrafficServiceReceptionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("trafficServiceReceptionStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSdsPOICategoryShortcutsRegister(SdsPOICategoryShortcutsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_sdsPOICategoryShortcuts, "sdsPOICategoryShortcuts", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SdsPOICategoryShortcuts", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendSdsPOICategoryShortcutsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sdsPOICategoryShortcuts", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SdsPOICategoryShortcuts", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendSdsPOICategoryShortcutsGet(SdsPOICategoryShortcutsCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_sdsPOICategoryShortcuts, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SdsPOICategoryShortcuts", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("sdsPOICategoryShortcuts", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< PoiCategoryShortcut >& NavigationServiceProxy::getSdsPOICategoryShortcuts() const {
    return _sdsPOICategoryShortcuts.get().getSdsPOICategoryShortcuts();
}

bool NavigationServiceProxy::hasSdsPOICategoryShortcuts() const {
    return _sdsPOICategoryShortcuts.hasValue();
}

void NavigationServiceProxy::sendSdsPOICategoryShortcutsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SdsPOICategoryShortcuts");
    _dbusProxyDelegate->deregisterSignalCallback("sdsPOICategoryShortcuts", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendMenuPoiCategoryShortcutsRegister(MenuPoiCategoryShortcutsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_menuPoiCategoryShortcuts, "menuPoiCategoryShortcuts", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MenuPoiCategoryShortcuts", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendMenuPoiCategoryShortcutsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("menuPoiCategoryShortcuts", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MenuPoiCategoryShortcuts", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendMenuPoiCategoryShortcutsGet(MenuPoiCategoryShortcutsCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_menuPoiCategoryShortcuts, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MenuPoiCategoryShortcuts", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("menuPoiCategoryShortcuts", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< PoiCategoryShortcut >& NavigationServiceProxy::getMenuPoiCategoryShortcuts() const {
    return _menuPoiCategoryShortcuts.get().getMenuPoiCategoryShortcuts();
}

bool NavigationServiceProxy::hasMenuPoiCategoryShortcuts() const {
    return _menuPoiCategoryShortcuts.hasValue();
}

void NavigationServiceProxy::sendMenuPoiCategoryShortcutsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MenuPoiCategoryShortcuts");
    _dbusProxyDelegate->deregisterSignalCallback("menuPoiCategoryShortcuts", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTripReplayStatusInfoRegister(TripReplayStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_tripReplayStatusInfo, "tripReplayStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TripReplayStatusInfo", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTripReplayStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("tripReplayStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TripReplayStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTripReplayStatusInfoGet(TripReplayStatusInfoCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_tripReplayStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TripReplayStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("tripReplayStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const TripReplayStatusInfo& NavigationServiceProxy::getTripReplayStatusInfo() const {
    return _tripReplayStatusInfo.get().getTripReplayStatusInfo();
}

bool NavigationServiceProxy::hasTripReplayStatusInfo() const {
    return _tripReplayStatusInfo.hasValue();
}

void NavigationServiceProxy::sendTripReplayStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TripReplayStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("tripReplayStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendEtcStatusRegister(EtcStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_etcStatus, "etcStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EtcStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendEtcStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("etcStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EtcStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendEtcStatusGet(EtcStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_etcStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EtcStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("etcStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


ETCStatus NavigationServiceProxy::getEtcStatus() const {
    return _etcStatus.get().getEtcStatus();
}

bool NavigationServiceProxy::hasEtcStatus() const {
    return _etcStatus.hasValue();
}

void NavigationServiceProxy::sendEtcStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EtcStatus");
    _dbusProxyDelegate->deregisterSignalCallback("etcStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendTrafficSignInfoActiveRegister(TrafficSignInfoActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TrafficSignInfoActive, "TrafficSignInfoActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TrafficSignInfoActive", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendTrafficSignInfoActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TrafficSignInfoActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TrafficSignInfoActive", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendTrafficSignInfoActiveGet(TrafficSignInfoActiveCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_TrafficSignInfoActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TrafficSignInfoActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TrafficSignInfoActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getTrafficSignInfoActive() const {
    return _trafficSignInfoActive.get().getTrafficSignInfoActive();
}

bool NavigationServiceProxy::hasTrafficSignInfoActive() const {
    return _trafficSignInfoActive.hasValue();
}

void NavigationServiceProxy::sendTrafficSignInfoActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TrafficSignInfoActive");
    _dbusProxyDelegate->deregisterSignalCallback("TrafficSignInfoActive", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendOverSpeedSoundAlertInfoActiveRegister(OverSpeedSoundAlertInfoActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_OverSpeedSoundAlertInfoActive, "OverSpeedSoundAlertInfoActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OverSpeedSoundAlertInfoActive", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendOverSpeedSoundAlertInfoActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OverSpeedSoundAlertInfoActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OverSpeedSoundAlertInfoActive", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendOverSpeedSoundAlertInfoActiveGet(OverSpeedSoundAlertInfoActiveCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_OverSpeedSoundAlertInfoActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "OverSpeedSoundAlertInfoActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("OverSpeedSoundAlertInfoActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getOverSpeedSoundAlertInfoActive() const {
    return _overSpeedSoundAlertInfoActive.get().getOverSpeedSoundAlertInfoActive();
}

bool NavigationServiceProxy::hasOverSpeedSoundAlertInfoActive() const {
    return _overSpeedSoundAlertInfoActive.hasValue();
}

void NavigationServiceProxy::sendOverSpeedSoundAlertInfoActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OverSpeedSoundAlertInfoActive");
    _dbusProxyDelegate->deregisterSignalCallback("OverSpeedSoundAlertInfoActive", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendRouteRecalculationReasonRegister(RouteRecalculationReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_routeRecalculationReason, "routeRecalculationReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RouteRecalculationReason", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendRouteRecalculationReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("routeRecalculationReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RouteRecalculationReason", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendRouteRecalculationReasonGet(RouteRecalculationReasonCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_routeRecalculationReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RouteRecalculationReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("routeRecalculationReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


RouteRecalculationReason NavigationServiceProxy::getRouteRecalculationReason() const {
    return _routeRecalculationReason.get().getRouteRecalculationReason();
}

bool NavigationServiceProxy::hasRouteRecalculationReason() const {
    return _routeRecalculationReason.hasValue();
}

void NavigationServiceProxy::sendRouteRecalculationReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RouteRecalculationReason");
    _dbusProxyDelegate->deregisterSignalCallback("routeRecalculationReason", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendRiskAreaDisplayInfoActiveRegister(RiskAreaDisplayInfoActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RiskAreaDisplayInfoActive, "RiskAreaDisplayInfoActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RiskAreaDisplayInfoActive", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendRiskAreaDisplayInfoActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RiskAreaDisplayInfoActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RiskAreaDisplayInfoActive", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendRiskAreaDisplayInfoActiveGet(RiskAreaDisplayInfoActiveCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_RiskAreaDisplayInfoActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RiskAreaDisplayInfoActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RiskAreaDisplayInfoActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getRiskAreaDisplayInfoActive() const {
    return _riskAreaDisplayInfoActive.get().getRiskAreaDisplayInfoActive();
}

bool NavigationServiceProxy::hasRiskAreaDisplayInfoActive() const {
    return _riskAreaDisplayInfoActive.hasValue();
}

void NavigationServiceProxy::sendRiskAreaDisplayInfoActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RiskAreaDisplayInfoActive");
    _dbusProxyDelegate->deregisterSignalCallback("RiskAreaDisplayInfoActive", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendRiskAreaSoundAlertInfoActiveRegister(RiskAreaSoundAlertInfoActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RiskAreaSoundAlertInfoActive, "RiskAreaSoundAlertInfoActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RiskAreaSoundAlertInfoActive", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendRiskAreaSoundAlertInfoActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RiskAreaSoundAlertInfoActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RiskAreaSoundAlertInfoActive", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendRiskAreaSoundAlertInfoActiveGet(RiskAreaSoundAlertInfoActiveCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_RiskAreaSoundAlertInfoActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RiskAreaSoundAlertInfoActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RiskAreaSoundAlertInfoActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool NavigationServiceProxy::getRiskAreaSoundAlertInfoActive() const {
    return _riskAreaSoundAlertInfoActive.get().getRiskAreaSoundAlertInfoActive();
}

bool NavigationServiceProxy::hasRiskAreaSoundAlertInfoActive() const {
    return _riskAreaSoundAlertInfoActive.hasValue();
}

void NavigationServiceProxy::sendRiskAreaSoundAlertInfoActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RiskAreaSoundAlertInfoActive");
    _dbusProxyDelegate->deregisterSignalCallback("RiskAreaSoundAlertInfoActive", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendJamAheadListRegister(JamAheadListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_jamAheadList, "jamAheadList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JamAheadList", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendJamAheadListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("jamAheadList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JamAheadList", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendJamAheadListGet(JamAheadListCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_jamAheadList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JamAheadList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("jamAheadList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const JamAheadList& NavigationServiceProxy::getJamAheadList() const {
    return _jamAheadList.get().getJamAheadList();
}

bool NavigationServiceProxy::hasJamAheadList() const {
    return _jamAheadList.hasValue();
}

void NavigationServiceProxy::sendJamAheadListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JamAheadList");
    _dbusProxyDelegate->deregisterSignalCallback("jamAheadList", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendWaypointOperationStatusListRegister(WaypointOperationStatusListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_waypointOperationStatusList, "waypointOperationStatusList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WaypointOperationStatusList", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendWaypointOperationStatusListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("waypointOperationStatusList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WaypointOperationStatusList", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendWaypointOperationStatusListGet(WaypointOperationStatusListCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_waypointOperationStatusList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WaypointOperationStatusList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("waypointOperationStatusList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< WaypointOperationStatus >& NavigationServiceProxy::getWaypointOperationStatusList() const {
    return _waypointOperationStatusList.get().getWaypointOperationStatusList();
}

bool NavigationServiceProxy::hasWaypointOperationStatusList() const {
    return _waypointOperationStatusList.hasValue();
}

void NavigationServiceProxy::sendWaypointOperationStatusListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WaypointOperationStatusList");
    _dbusProxyDelegate->deregisterSignalCallback("waypointOperationStatusList", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendDestinationReachedStatusRegister(DestinationReachedStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_destinationReachedStatus, "destinationReachedStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DestinationReachedStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendDestinationReachedStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("destinationReachedStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DestinationReachedStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendDestinationReachedStatusGet(DestinationReachedStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_destinationReachedStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DestinationReachedStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("destinationReachedStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


DestinationReachedStatus NavigationServiceProxy::getDestinationReachedStatus() const {
    return _destinationReachedStatus.get().getDestinationReachedStatus();
}

bool NavigationServiceProxy::hasDestinationReachedStatus() const {
    return _destinationReachedStatus.hasValue();
}

void NavigationServiceProxy::sendDestinationReachedStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DestinationReachedStatus");
    _dbusProxyDelegate->deregisterSignalCallback("destinationReachedStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendLightModeStatusRegister(LightModeStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_lightModeStatus, "lightModeStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LightModeStatus", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendLightModeStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("lightModeStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LightModeStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendLightModeStatusGet(LightModeStatusCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_lightModeStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LightModeStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("lightModeStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


LightModeStatus NavigationServiceProxy::getLightModeStatus() const {
    return _lightModeStatus.get().getLightModeStatus();
}

bool NavigationServiceProxy::hasLightModeStatus() const {
    return _lightModeStatus.hasValue();
}

void NavigationServiceProxy::sendLightModeStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LightModeStatus");
    _dbusProxyDelegate->deregisterSignalCallback("lightModeStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendMapCameraDataRegister(MapCameraDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_mapCameraData, "mapCameraData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapCameraData", &cb, act);
    return act;
}

bool NavigationServiceProxy::sendMapCameraDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("mapCameraData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapCameraData", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationServiceProxy::sendMapCameraDataGet(MapCameraDataCallbackIF& cb) {
    NavigationServiceProxyCallback* callback = new NavigationServiceProxyCallback(ID_mapCameraData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MapCameraData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("mapCameraData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const MapCameraData& NavigationServiceProxy::getMapCameraData() const {
    return _mapCameraData.get().getMapCameraData();
}

bool NavigationServiceProxy::hasMapCameraData() const {
    return _mapCameraData.hasValue();
}

void NavigationServiceProxy::sendMapCameraDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapCameraData");
    _dbusProxyDelegate->deregisterSignalCallback("mapCameraData", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationServiceProxy::sendSelectPoiCategoryShortcutRequest(SelectPoiCategoryShortcutCallbackIF& cb, uint8 shortcutIndex) const {
    SelectPoiCategoryShortcutRequest* payload = new SelectPoiCategoryShortcutRequest();
    CHECK_ALLOCATION(payload);
    payload->setShortcutIndex(shortcutIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "selectPoiCategoryShortcut", SelectPoiCategoryShortcutRequest, payload, true)
    act_t act = addMethodCallback(ID_selectPoiCategoryShortcut, dbusMessage.getUniqueSerial(), "selectPoiCategoryShortcut", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SelectPoiCategoryShortcut", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendGetPoiCategoryShortcutsRequest(GetPoiCategoryShortcutsCallbackIF& cb) const {
    GetPoiCategoryShortcutsRequest* payload = new GetPoiCategoryShortcutsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getPoiCategoryShortcuts", GetPoiCategoryShortcutsRequest, payload, true)
    act_t act = addMethodCallback(ID_getPoiCategoryShortcuts, dbusMessage.getUniqueSerial(), "getPoiCategoryShortcuts", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetPoiCategoryShortcuts", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithCoordinatesRequest(SetLocationWithCoordinatesCallbackIF& cb, const PositionWGS84& location) const {
    SetLocationWithCoordinatesRequest* payload = new SetLocationWithCoordinatesRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithCoordinates", SetLocationWithCoordinatesRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithCoordinates, dbusMessage.getUniqueSerial(), "setLocationWithCoordinates", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithCoordinates", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithDetailsRequest(SetLocationWithDetailsCallbackIF& cb, const POILocation& location) const {
    SetLocationWithDetailsRequest* payload = new SetLocationWithDetailsRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithDetails", SetLocationWithDetailsRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithDetails, dbusMessage.getUniqueSerial(), "setLocationWithDetails", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithDetails", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowPOILocationFromTCURequest(ShowPOILocationFromTCUCallbackIF& cb, const ::std::vector< POILocation >& poiLocations) const {
    ShowPOILocationFromTCURequest* payload = new ShowPOILocationFromTCURequest();
    CHECK_ALLOCATION(payload);
    payload->setPoiLocations(poiLocations);
    DBUS_MESSAGE_CALL(dbusMessage, "showPOILocationFromTCU", ShowPOILocationFromTCURequest, payload, true)
    act_t act = addMethodCallback(ID_showPOILocationFromTCU, dbusMessage.getUniqueSerial(), "showPOILocationFromTCU", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowPOILocationFromTCU", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStorePOILocationToAddressBookRequest(StorePOILocationToAddressBookCallbackIF& cb, const POILocation& poiLocation) const {
    StorePOILocationToAddressBookRequest* payload = new StorePOILocationToAddressBookRequest();
    CHECK_ALLOCATION(payload);
    payload->setPoiLocation(poiLocation);
    DBUS_MESSAGE_CALL(dbusMessage, "storePOILocationToAddressBook", StorePOILocationToAddressBookRequest, payload, true)
    act_t act = addMethodCallback(ID_storePOILocationToAddressBook, dbusMessage.getUniqueSerial(), "storePOILocationToAddressBook", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StorePOILocationToAddressBook", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStoreLocationToAddressBookRequest(StoreLocationToAddressBookCallbackIF& cb, const Location& location) const {
    StoreLocationToAddressBookRequest* payload = new StoreLocationToAddressBookRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    DBUS_MESSAGE_CALL(dbusMessage, "storeLocationToAddressBook", StoreLocationToAddressBookRequest, payload, true)
    act_t act = addMethodCallback(ID_storeLocationToAddressBook, dbusMessage.getUniqueSerial(), "storeLocationToAddressBook", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StoreLocationToAddressBook", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowDestinationOverviewFromTCURequest(ShowDestinationOverviewFromTCUCallbackIF& cb, const Location& currentPosition, const Location& destination) const {
    ShowDestinationOverviewFromTCURequest* payload = new ShowDestinationOverviewFromTCURequest();
    CHECK_ALLOCATION(payload);
    payload->setCurrentPosition(currentPosition);
    payload->setDestination(destination);
    DBUS_MESSAGE_CALL(dbusMessage, "showDestinationOverviewFromTCU", ShowDestinationOverviewFromTCURequest, payload, true)
    act_t act = addMethodCallback(ID_showDestinationOverviewFromTCU, dbusMessage.getUniqueSerial(), "showDestinationOverviewFromTCU", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowDestinationOverviewFromTCU", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowCalculateTourRequest(ShowCalculateTourCallbackIF& cb, const ::std::vector< TourElement >& tour, ScreenTransition screenTransition) const {
    ShowCalculateTourRequest* payload = new ShowCalculateTourRequest();
    CHECK_ALLOCATION(payload);
    payload->setTour(tour);
    payload->setScreenTransition(screenTransition);
    DBUS_MESSAGE_CALL(dbusMessage, "showCalculateTour", ShowCalculateTourRequest, payload, true)
    act_t act = addMethodCallback(ID_showCalculateTour, dbusMessage.getUniqueSerial(), "showCalculateTour", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowCalculateTour", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowOnMapRequest(ShowOnMapCallbackIF& cb, const PositionWGS84& location) const {
    ShowOnMapRequest* payload = new ShowOnMapRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    DBUS_MESSAGE_CALL(dbusMessage, "showOnMap", ShowOnMapRequest, payload, true)
    act_t act = addMethodCallback(ID_showOnMap, dbusMessage.getUniqueSerial(), "showOnMap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowOnMap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowCarsorLocationOnMapRequest(ShowCarsorLocationOnMapCallbackIF& cb) const {
    ShowCarsorLocationOnMapRequest* payload = new ShowCarsorLocationOnMapRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showCarsorLocationOnMap", ShowCarsorLocationOnMapRequest, payload, true)
    act_t act = addMethodCallback(ID_showCarsorLocationOnMap, dbusMessage.getUniqueSerial(), "showCarsorLocationOnMap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowCarsorLocationOnMap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowCityInputAndGetCityCoordinatesRequest(ShowCityInputAndGetCityCoordinatesCallbackIF& cb) const {
    ShowCityInputAndGetCityCoordinatesRequest* payload = new ShowCityInputAndGetCityCoordinatesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showCityInputAndGetCityCoordinates", ShowCityInputAndGetCityCoordinatesRequest, payload, true)
    act_t act = addMethodCallback(ID_showCityInputAndGetCityCoordinates, dbusMessage.getUniqueSerial(), "showCityInputAndGetCityCoordinates", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowCityInputAndGetCityCoordinates", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestLocationDetailsForCoordinatesRequest(RequestLocationDetailsForCoordinatesCallbackIF& cb, const PositionWGS84& cityCoordinate) const {
    RequestLocationDetailsForCoordinatesRequest* payload = new RequestLocationDetailsForCoordinatesRequest();
    CHECK_ALLOCATION(payload);
    payload->setCityCoordinate(cityCoordinate);
    DBUS_MESSAGE_CALL(dbusMessage, "requestLocationDetailsForCoordinates", RequestLocationDetailsForCoordinatesRequest, payload, true)
    act_t act = addMethodCallback(ID_requestLocationDetailsForCoordinates, dbusMessage.getUniqueSerial(), "requestLocationDetailsForCoordinates", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestLocationDetailsForCoordinates", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowAdjustCurrentLocationScreenRequest(ShowAdjustCurrentLocationScreenCallbackIF& cb) const {
    ShowAdjustCurrentLocationScreenRequest* payload = new ShowAdjustCurrentLocationScreenRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showAdjustCurrentLocationScreen", ShowAdjustCurrentLocationScreenRequest, payload, true)
    act_t act = addMethodCallback(ID_showAdjustCurrentLocationScreen, dbusMessage.getUniqueSerial(), "showAdjustCurrentLocationScreen", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowAdjustCurrentLocationScreen", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowWhereAmIScreenRequest(ShowWhereAmIScreenCallbackIF& cb) const {
    ShowWhereAmIScreenRequest* payload = new ShowWhereAmIScreenRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showWhereAmIScreen", ShowWhereAmIScreenRequest, payload, true)
    act_t act = addMethodCallback(ID_showWhereAmIScreen, dbusMessage.getUniqueSerial(), "showWhereAmIScreen", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowWhereAmIScreen", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowTrafficInfoScreenRequest(ShowTrafficInfoScreenCallbackIF& cb) const {
    ShowTrafficInfoScreenRequest* payload = new ShowTrafficInfoScreenRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showTrafficInfoScreen", ShowTrafficInfoScreenRequest, payload, true)
    act_t act = addMethodCallback(ID_showTrafficInfoScreen, dbusMessage.getUniqueSerial(), "showTrafficInfoScreen", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowTrafficInfoScreen", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowMapScreenWithMapViewModeRequest(ShowMapScreenWithMapViewModeCallbackIF& cb, MapViewMode mapViewMode) const {
    ShowMapScreenWithMapViewModeRequest* payload = new ShowMapScreenWithMapViewModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setMapViewMode(mapViewMode);
    DBUS_MESSAGE_CALL(dbusMessage, "showMapScreenWithMapViewMode", ShowMapScreenWithMapViewModeRequest, payload, true)
    act_t act = addMethodCallback(ID_showMapScreenWithMapViewMode, dbusMessage.getUniqueSerial(), "showMapScreenWithMapViewMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowMapScreenWithMapViewMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowMapScreenCarsorLockModeRequest(ShowMapScreenCarsorLockModeCallbackIF& cb, MapCameraMode mapCameraMode) const {
    ShowMapScreenCarsorLockModeRequest* payload = new ShowMapScreenCarsorLockModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setMapCameraMode(mapCameraMode);
    DBUS_MESSAGE_CALL(dbusMessage, "showMapScreenCarsorLockMode", ShowMapScreenCarsorLockModeRequest, payload, true)
    act_t act = addMethodCallback(ID_showMapScreenCarsorLockMode, dbusMessage.getUniqueSerial(), "showMapScreenCarsorLockMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowMapScreenCarsorLockMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowDeleteWaypointListScreenRequest(ShowDeleteWaypointListScreenCallbackIF& cb) const {
    ShowDeleteWaypointListScreenRequest* payload = new ShowDeleteWaypointListScreenRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showDeleteWaypointListScreen", ShowDeleteWaypointListScreenRequest, payload, true)
    act_t act = addMethodCallback(ID_showDeleteWaypointListScreen, dbusMessage.getUniqueSerial(), "showDeleteWaypointListScreen", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowDeleteWaypointListScreen", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetZoomInStepRequest(SetZoomInStepCallbackIF& cb, uint8 zoomInStep) const {
    SetZoomInStepRequest* payload = new SetZoomInStepRequest();
    CHECK_ALLOCATION(payload);
    payload->setZoomInStep(zoomInStep);
    DBUS_MESSAGE_CALL(dbusMessage, "setZoomInStep", SetZoomInStepRequest, payload, true)
    act_t act = addMethodCallback(ID_setZoomInStep, dbusMessage.getUniqueSerial(), "setZoomInStep", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetZoomInStep", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetZoomOutStepRequest(SetZoomOutStepCallbackIF& cb, uint8 zoomOutStep) const {
    SetZoomOutStepRequest* payload = new SetZoomOutStepRequest();
    CHECK_ALLOCATION(payload);
    payload->setZoomOutStep(zoomOutStep);
    DBUS_MESSAGE_CALL(dbusMessage, "setZoomOutStep", SetZoomOutStepRequest, payload, true)
    act_t act = addMethodCallback(ID_setZoomOutStep, dbusMessage.getUniqueSerial(), "setZoomOutStep", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetZoomOutStep", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetZoomLevelRequest(SetZoomLevelCallbackIF& cb, ZoomLevel zoomLevel) const {
    SetZoomLevelRequest* payload = new SetZoomLevelRequest();
    CHECK_ALLOCATION(payload);
    payload->setZoomLevel(zoomLevel);
    DBUS_MESSAGE_CALL(dbusMessage, "setZoomLevel", SetZoomLevelRequest, payload, true)
    act_t act = addMethodCallback(ID_setZoomLevel, dbusMessage.getUniqueSerial(), "setZoomLevel", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetZoomLevel", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendGetVersionStringRequest(GetVersionStringCallbackIF& cb) const {
    GetVersionStringRequest* payload = new GetVersionStringRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getVersionString", GetVersionStringRequest, payload, true)
    act_t act = addMethodCallback(ID_getVersionString, dbusMessage.getUniqueSerial(), "getVersionString", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetVersionString", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetSXMTravelLinkSubscriptionStatusRequest(SetSXMTravelLinkSubscriptionStatusCallbackIF& cb, bool status) const {
    SetSXMTravelLinkSubscriptionStatusRequest* payload = new SetSXMTravelLinkSubscriptionStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "setSXMTravelLinkSubscriptionStatus", SetSXMTravelLinkSubscriptionStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_setSXMTravelLinkSubscriptionStatus, dbusMessage.getUniqueSerial(), "setSXMTravelLinkSubscriptionStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSXMTravelLinkSubscriptionStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStartGuidanceRequest(StartGuidanceCallbackIF& cb) const {
    StartGuidanceRequest* payload = new StartGuidanceRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "startGuidance", StartGuidanceRequest, payload, true)
    act_t act = addMethodCallback(ID_startGuidance, dbusMessage.getUniqueSerial(), "startGuidance", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartGuidance", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStartGuidanceToPosWGS84Request(StartGuidanceToPosWGS84CallbackIF& cb, const PositionWGS84& destination) const {
    StartGuidanceToPosWGS84Request* payload = new StartGuidanceToPosWGS84Request();
    CHECK_ALLOCATION(payload);
    payload->setDestination(destination);
    DBUS_MESSAGE_CALL(dbusMessage, "startGuidanceToPosWGS84", StartGuidanceToPosWGS84Request, payload, true)
    act_t act = addMethodCallback(ID_startGuidanceToPosWGS84, dbusMessage.getUniqueSerial(), "startGuidanceToPosWGS84", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartGuidanceToPosWGS84", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStartGuidanceToHomeLocationRequest(StartGuidanceToHomeLocationCallbackIF& cb) const {
    StartGuidanceToHomeLocationRequest* payload = new StartGuidanceToHomeLocationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "startGuidanceToHomeLocation", StartGuidanceToHomeLocationRequest, payload, true)
    act_t act = addMethodCallback(ID_startGuidanceToHomeLocation, dbusMessage.getUniqueSerial(), "startGuidanceToHomeLocation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartGuidanceToHomeLocation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStartGuidanceToWorkLocationRequest(StartGuidanceToWorkLocationCallbackIF& cb) const {
    StartGuidanceToWorkLocationRequest* payload = new StartGuidanceToWorkLocationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "startGuidanceToWorkLocation", StartGuidanceToWorkLocationRequest, payload, true)
    act_t act = addMethodCallback(ID_startGuidanceToWorkLocation, dbusMessage.getUniqueSerial(), "startGuidanceToWorkLocation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartGuidanceToWorkLocation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithDestinationMemoryEntryRequest(SetLocationWithDestinationMemoryEntryCallbackIF& cb, uint32 id) const {
    SetLocationWithDestinationMemoryEntryRequest* payload = new SetLocationWithDestinationMemoryEntryRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithDestinationMemoryEntry", SetLocationWithDestinationMemoryEntryRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithDestinationMemoryEntry, dbusMessage.getUniqueSerial(), "setLocationWithDestinationMemoryEntry", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithDestinationMemoryEntry", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendCancelRouteGuidanceRequest(CancelRouteGuidanceCallbackIF& cb) const {
    CancelRouteGuidanceRequest* payload = new CancelRouteGuidanceRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "cancelRouteGuidance", CancelRouteGuidanceRequest, payload, true)
    act_t act = addMethodCallback(ID_cancelRouteGuidance, dbusMessage.getUniqueSerial(), "cancelRouteGuidance", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelRouteGuidance", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendInsertWaypointRequest(InsertWaypointCallbackIF& cb, uint32 newIndex) const {
    InsertWaypointRequest* payload = new InsertWaypointRequest();
    CHECK_ALLOCATION(payload);
    payload->setNewIndex(newIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "insertWaypoint", InsertWaypointRequest, payload, true)
    act_t act = addMethodCallback(ID_insertWaypoint, dbusMessage.getUniqueSerial(), "insertWaypoint", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "InsertWaypoint", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendInsertWaypointAtDefaultPositionRequest(InsertWaypointAtDefaultPositionCallbackIF& cb) const {
    InsertWaypointAtDefaultPositionRequest* payload = new InsertWaypointAtDefaultPositionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "insertWaypointAtDefaultPosition", InsertWaypointAtDefaultPositionRequest, payload, true)
    act_t act = addMethodCallback(ID_insertWaypointAtDefaultPosition, dbusMessage.getUniqueSerial(), "insertWaypointAtDefaultPosition", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "InsertWaypointAtDefaultPosition", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendReplaceWaypointRequest(ReplaceWaypointCallbackIF& cb, uint32 index) const {
    ReplaceWaypointRequest* payload = new ReplaceWaypointRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    DBUS_MESSAGE_CALL(dbusMessage, "replaceWaypoint", ReplaceWaypointRequest, payload, true)
    act_t act = addMethodCallback(ID_replaceWaypoint, dbusMessage.getUniqueSerial(), "replaceWaypoint", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReplaceWaypoint", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendDeleteWaypointsRequest(DeleteWaypointsCallbackIF& cb, uint32 firstIndex, uint32 lastIndex) const {
    DeleteWaypointsRequest* payload = new DeleteWaypointsRequest();
    CHECK_ALLOCATION(payload);
    payload->setFirstIndex(firstIndex);
    payload->setLastIndex(lastIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "deleteWaypoints", DeleteWaypointsRequest, payload, true)
    act_t act = addMethodCallback(ID_deleteWaypoints, dbusMessage.getUniqueSerial(), "deleteWaypoints", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeleteWaypoints", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendApplyWaypointListChangeRequest(ApplyWaypointListChangeCallbackIF& cb) const {
    ApplyWaypointListChangeRequest* payload = new ApplyWaypointListChangeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "applyWaypointListChange", ApplyWaypointListChangeRequest, payload, true)
    act_t act = addMethodCallback(ID_applyWaypointListChange, dbusMessage.getUniqueSerial(), "applyWaypointListChange", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ApplyWaypointListChange", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestWaypointListRequest(RequestWaypointListCallbackIF& cb) const {
    RequestWaypointListRequest* payload = new RequestWaypointListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "requestWaypointList", RequestWaypointListRequest, payload, true)
    act_t act = addMethodCallback(ID_requestWaypointList, dbusMessage.getUniqueSerial(), "requestWaypointList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestWaypointList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestSetFreeTextSearchTypeRequest(RequestSetFreeTextSearchTypeCallbackIF& cb, FTSLocationType locationType) const {
    RequestSetFreeTextSearchTypeRequest* payload = new RequestSetFreeTextSearchTypeRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocationType(locationType);
    DBUS_MESSAGE_CALL(dbusMessage, "requestSetFreeTextSearchType", RequestSetFreeTextSearchTypeRequest, payload, true)
    act_t act = addMethodCallback(ID_requestSetFreeTextSearchType, dbusMessage.getUniqueSerial(), "requestSetFreeTextSearchType", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestSetFreeTextSearchType", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestFreeTextSearchResultsRequest(RequestFreeTextSearchResultsCallbackIF& cb, const ::std::string& searchString, FreeTextSearchScope searchScope, uint8 destinationIndex, uint32 startIndex, uint32 numElements) const {
    RequestFreeTextSearchResultsRequest* payload = new RequestFreeTextSearchResultsRequest();
    CHECK_ALLOCATION(payload);
    payload->setSearchString(searchString);
    payload->setSearchScope(searchScope);
    payload->setDestinationIndex(destinationIndex);
    payload->setStartIndex(startIndex);
    payload->setNumElements(numElements);
    DBUS_MESSAGE_CALL(dbusMessage, "requestFreeTextSearchResults", RequestFreeTextSearchResultsRequest, payload, true)
    act_t act = addMethodCallback(ID_requestFreeTextSearchResults, dbusMessage.getUniqueSerial(), "requestFreeTextSearchResults", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestFreeTextSearchResults", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendUndoFreeTextSearchElementSelectionRequest(UndoFreeTextSearchElementSelectionCallbackIF& cb) const {
    UndoFreeTextSearchElementSelectionRequest* payload = new UndoFreeTextSearchElementSelectionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "undoFreeTextSearchElementSelection", UndoFreeTextSearchElementSelectionRequest, payload, true)
    act_t act = addMethodCallback(ID_undoFreeTextSearchElementSelection, dbusMessage.getUniqueSerial(), "undoFreeTextSearchElementSelection", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UndoFreeTextSearchElementSelection", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithFreeTextSearchInputRequest(SetLocationWithFreeTextSearchInputCallbackIF& cb, uint32 id) const {
    SetLocationWithFreeTextSearchInputRequest* payload = new SetLocationWithFreeTextSearchInputRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithFreeTextSearchInput", SetLocationWithFreeTextSearchInputRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithFreeTextSearchInput, dbusMessage.getUniqueSerial(), "setLocationWithFreeTextSearchInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithFreeTextSearchInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowDestinationFreeTextSearchInputRequest(ShowDestinationFreeTextSearchInputCallbackIF& cb, FTSLocationType locationType, FreeTextSearchScope locationSearchScope, const ::std::string& searchString) const {
    ShowDestinationFreeTextSearchInputRequest* payload = new ShowDestinationFreeTextSearchInputRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocationType(locationType);
    payload->setLocationSearchScope(locationSearchScope);
    payload->setSearchString(searchString);
    DBUS_MESSAGE_CALL(dbusMessage, "showDestinationFreeTextSearchInput", ShowDestinationFreeTextSearchInputRequest, payload, true)
    act_t act = addMethodCallback(ID_showDestinationFreeTextSearchInput, dbusMessage.getUniqueSerial(), "showDestinationFreeTextSearchInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowDestinationFreeTextSearchInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestFixedPOICategorySearchResultsRequest(RequestFixedPOICategorySearchResultsCallbackIF& cb, FixedPOICategory fixedPOICategory, FreeTextSearchScope locationSearchScope, uint8 destinationIndex, uint32 startIndex, uint32 numElements) const {
    RequestFixedPOICategorySearchResultsRequest* payload = new RequestFixedPOICategorySearchResultsRequest();
    CHECK_ALLOCATION(payload);
    payload->setFixedPOICategory(fixedPOICategory);
    payload->setLocationSearchScope(locationSearchScope);
    payload->setDestinationIndex(destinationIndex);
    payload->setStartIndex(startIndex);
    payload->setNumElements(numElements);
    DBUS_MESSAGE_CALL(dbusMessage, "requestFixedPOICategorySearchResults", RequestFixedPOICategorySearchResultsRequest, payload, true)
    act_t act = addMethodCallback(ID_requestFixedPOICategorySearchResults, dbusMessage.getUniqueSerial(), "requestFixedPOICategorySearchResults", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestFixedPOICategorySearchResults", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendUndoSetLocationWithFixedPOICategoryInputRequest(UndoSetLocationWithFixedPOICategoryInputCallbackIF& cb) const {
    UndoSetLocationWithFixedPOICategoryInputRequest* payload = new UndoSetLocationWithFixedPOICategoryInputRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "undoSetLocationWithFixedPOICategoryInput", UndoSetLocationWithFixedPOICategoryInputRequest, payload, true)
    act_t act = addMethodCallback(ID_undoSetLocationWithFixedPOICategoryInput, dbusMessage.getUniqueSerial(), "undoSetLocationWithFixedPOICategoryInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UndoSetLocationWithFixedPOICategoryInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithFixedPOICategoryInputRequest(SetLocationWithFixedPOICategoryInputCallbackIF& cb, uint32 index) const {
    SetLocationWithFixedPOICategoryInputRequest* payload = new SetLocationWithFixedPOICategoryInputRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithFixedPOICategoryInput", SetLocationWithFixedPOICategoryInputRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithFixedPOICategoryInput, dbusMessage.getUniqueSerial(), "setLocationWithFixedPOICategoryInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithFixedPOICategoryInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSdsCheckAddressRequest(SdsCheckAddressCallbackIF& cb, const ::std::vector< SDSAddressElement >& requestedAddress) const {
    SdsCheckAddressRequest* payload = new SdsCheckAddressRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequestedAddress(requestedAddress);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsCheckAddress", SdsCheckAddressRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsCheckAddress, dbusMessage.getUniqueSerial(), "sdsCheckAddress", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsCheckAddress", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSdsGetRefinementListRequest(SdsGetRefinementListCallbackIF& cb, SDSAddressElementType sdsAddressElementType) const {
    SdsGetRefinementListRequest* payload = new SdsGetRefinementListRequest();
    CHECK_ALLOCATION(payload);
    payload->setSdsAddressElementType(sdsAddressElementType);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsGetRefinementList", SdsGetRefinementListRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsGetRefinementList, dbusMessage.getUniqueSerial(), "sdsGetRefinementList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsGetRefinementList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSelectSdsRefinementRequest(SelectSdsRefinementCallbackIF& cb, uint32 id) const {
    SelectSdsRefinementRequest* payload = new SelectSdsRefinementRequest();
    CHECK_ALLOCATION(payload);
    payload->setId(id);
    DBUS_MESSAGE_CALL(dbusMessage, "selectSdsRefinement", SelectSdsRefinementRequest, payload, true)
    act_t act = addMethodCallback(ID_selectSdsRefinement, dbusMessage.getUniqueSerial(), "selectSdsRefinement", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SelectSdsRefinement", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetLocationWithSdsInputRequest(SetLocationWithSdsInputCallbackIF& cb) const {
    SetLocationWithSdsInputRequest* payload = new SetLocationWithSdsInputRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "setLocationWithSdsInput", SetLocationWithSdsInputRequest, payload, true)
    act_t act = addMethodCallback(ID_setLocationWithSdsInput, dbusMessage.getUniqueSerial(), "setLocationWithSdsInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLocationWithSdsInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestDestinationMemoryEntriesRequest(RequestDestinationMemoryEntriesCallbackIF& cb, DestinationMemoryCategoryType categoryType) const {
    RequestDestinationMemoryEntriesRequest* payload = new RequestDestinationMemoryEntriesRequest();
    CHECK_ALLOCATION(payload);
    payload->setCategoryType(categoryType);
    DBUS_MESSAGE_CALL(dbusMessage, "requestDestinationMemoryEntries", RequestDestinationMemoryEntriesRequest, payload, true)
    act_t act = addMethodCallback(ID_requestDestinationMemoryEntries, dbusMessage.getUniqueSerial(), "requestDestinationMemoryEntries", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestDestinationMemoryEntries", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetMapRepresentationRequest(SetMapRepresentationCallbackIF& cb, MapRepresentation representation) const {
    SetMapRepresentationRequest* payload = new SetMapRepresentationRequest();
    CHECK_ALLOCATION(payload);
    payload->setRepresentation(representation);
    DBUS_MESSAGE_CALL(dbusMessage, "setMapRepresentation", SetMapRepresentationRequest, payload, true)
    act_t act = addMethodCallback(ID_setMapRepresentation, dbusMessage.getUniqueSerial(), "setMapRepresentation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMapRepresentation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestDetailsForSelectedLocationRequest(RequestDetailsForSelectedLocationCallbackIF& cb) const {
    RequestDetailsForSelectedLocationRequest* payload = new RequestDetailsForSelectedLocationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "requestDetailsForSelectedLocation", RequestDetailsForSelectedLocationRequest, payload, true)
    act_t act = addMethodCallback(ID_requestDetailsForSelectedLocation, dbusMessage.getUniqueSerial(), "requestDetailsForSelectedLocation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestDetailsForSelectedLocation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRetriggerAcousticOutputRequest(RetriggerAcousticOutputCallbackIF& cb) const {
    RetriggerAcousticOutputRequest* payload = new RetriggerAcousticOutputRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "retriggerAcousticOutput", RetriggerAcousticOutputRequest, payload, true)
    act_t act = addMethodCallback(ID_retriggerAcousticOutput, dbusMessage.getUniqueSerial(), "retriggerAcousticOutput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RetriggerAcousticOutput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSpeakSamplePhraseRequest(SpeakSamplePhraseCallbackIF& cb, SampleVoicePhrase sampleVoicePhrase) const {
    SpeakSamplePhraseRequest* payload = new SpeakSamplePhraseRequest();
    CHECK_ALLOCATION(payload);
    payload->setSampleVoicePhrase(sampleVoicePhrase);
    DBUS_MESSAGE_CALL(dbusMessage, "speakSamplePhrase", SpeakSamplePhraseRequest, payload, true)
    act_t act = addMethodCallback(ID_speakSamplePhrase, dbusMessage.getUniqueSerial(), "speakSamplePhrase", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SpeakSamplePhrase", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetRouteCriterionRequest(SetRouteCriterionCallbackIF& cb, RouteCriterion routeCriterion) const {
    SetRouteCriterionRequest* payload = new SetRouteCriterionRequest();
    CHECK_ALLOCATION(payload);
    payload->setRouteCriterion(routeCriterion);
    DBUS_MESSAGE_CALL(dbusMessage, "setRouteCriterion", SetRouteCriterionRequest, payload, true)
    act_t act = addMethodCallback(ID_setRouteCriterion, dbusMessage.getUniqueSerial(), "setRouteCriterion", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetRouteCriterion", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetVoiceGuidanceRequest(SetVoiceGuidanceCallbackIF& cb, bool active) const {
    SetVoiceGuidanceRequest* payload = new SetVoiceGuidanceRequest();
    CHECK_ALLOCATION(payload);
    payload->setActive(active);
    DBUS_MESSAGE_CALL(dbusMessage, "setVoiceGuidance", SetVoiceGuidanceRequest, payload, true)
    act_t act = addMethodCallback(ID_setVoiceGuidance, dbusMessage.getUniqueSerial(), "setVoiceGuidance", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetVoiceGuidance", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendCheckNavDataCompatibilityRequest(CheckNavDataCompatibilityCallbackIF& cb, const ::std::string& navDataVersion, const ::std::vector< uint8 >& compatibilityInfo) const {
    CheckNavDataCompatibilityRequest* payload = new CheckNavDataCompatibilityRequest();
    CHECK_ALLOCATION(payload);
    payload->setNavDataVersion(navDataVersion);
    payload->setCompatibilityInfo(compatibilityInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "CheckNavDataCompatibility", CheckNavDataCompatibilityRequest, payload, true)
    act_t act = addMethodCallback(ID_CheckNavDataCompatibility, dbusMessage.getUniqueSerial(), "CheckNavDataCompatibility", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CheckNavDataCompatibility", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSdsUpdateVoiceTagRequest(SdsUpdateVoiceTagCallbackIF& cb, const SDSVoiceTagId& voiceTagID) const {
    SdsUpdateVoiceTagRequest* payload = new SdsUpdateVoiceTagRequest();
    CHECK_ALLOCATION(payload);
    payload->setVoiceTagID(voiceTagID);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsUpdateVoiceTag", SdsUpdateVoiceTagRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsUpdateVoiceTag, dbusMessage.getUniqueSerial(), "sdsUpdateVoiceTag", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsUpdateVoiceTag", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSdsGetHouseNumberPatternRequest(SdsGetHouseNumberPatternCallbackIF& cb) const {
    SdsGetHouseNumberPatternRequest* payload = new SdsGetHouseNumberPatternRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "sdsGetHouseNumberPattern", SdsGetHouseNumberPatternRequest, payload, true)
    act_t act = addMethodCallback(ID_sdsGetHouseNumberPattern, dbusMessage.getUniqueSerial(), "sdsGetHouseNumberPattern", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SdsGetHouseNumberPattern", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetMapLightModeRequest(SetMapLightModeCallbackIF& cb, bool active) const {
    SetMapLightModeRequest* payload = new SetMapLightModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setActive(active);
    DBUS_MESSAGE_CALL(dbusMessage, "setMapLightMode", SetMapLightModeRequest, payload, true)
    act_t act = addMethodCallback(ID_setMapLightMode, dbusMessage.getUniqueSerial(), "setMapLightMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMapLightMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStartTripReplayRequest(StartTripReplayCallbackIF& cb, const ::std::string& tripFileName) const {
    StartTripReplayRequest* payload = new StartTripReplayRequest();
    CHECK_ALLOCATION(payload);
    payload->setTripFileName(tripFileName);
    DBUS_MESSAGE_CALL(dbusMessage, "startTripReplay", StartTripReplayRequest, payload, true)
    act_t act = addMethodCallback(ID_startTripReplay, dbusMessage.getUniqueSerial(), "startTripReplay", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartTripReplay", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendStopTripReplayRequest(StopTripReplayCallbackIF& cb) const {
    StopTripReplayRequest* payload = new StopTripReplayRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "stopTripReplay", StopTripReplayRequest, payload, true)
    act_t act = addMethodCallback(ID_stopTripReplay, dbusMessage.getUniqueSerial(), "stopTripReplay", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StopTripReplay", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSeekTripReplayRequest(SeekTripReplayCallbackIF& cb, int16 seekValue) const {
    SeekTripReplayRequest* payload = new SeekTripReplayRequest();
    CHECK_ALLOCATION(payload);
    payload->setSeekValue(seekValue);
    DBUS_MESSAGE_CALL(dbusMessage, "seekTripReplay", SeekTripReplayRequest, payload, true)
    act_t act = addMethodCallback(ID_seekTripReplay, dbusMessage.getUniqueSerial(), "seekTripReplay", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SeekTripReplay", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSetTripReplayModeRequest(SetTripReplayModeCallbackIF& cb, bool loopModeActive, uint16 speed) const {
    SetTripReplayModeRequest* payload = new SetTripReplayModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setLoopModeActive(loopModeActive);
    payload->setSpeed(speed);
    DBUS_MESSAGE_CALL(dbusMessage, "setTripReplayMode", SetTripReplayModeRequest, payload, true)
    act_t act = addMethodCallback(ID_setTripReplayMode, dbusMessage.getUniqueSerial(), "setTripReplayMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetTripReplayMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowLocationSelectionAndGetAddressDetailsRequest(ShowLocationSelectionAndGetAddressDetailsCallbackIF& cb) const {
    ShowLocationSelectionAndGetAddressDetailsRequest* payload = new ShowLocationSelectionAndGetAddressDetailsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showLocationSelectionAndGetAddressDetails", ShowLocationSelectionAndGetAddressDetailsRequest, payload, true)
    act_t act = addMethodCallback(ID_showLocationSelectionAndGetAddressDetails, dbusMessage.getUniqueSerial(), "showLocationSelectionAndGetAddressDetails", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowLocationSelectionAndGetAddressDetails", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowRouteCalculationToDestinationRequest(ShowRouteCalculationToDestinationCallbackIF& cb) const {
    ShowRouteCalculationToDestinationRequest* payload = new ShowRouteCalculationToDestinationRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "showRouteCalculationToDestination", ShowRouteCalculationToDestinationRequest, payload, true)
    act_t act = addMethodCallback(ID_showRouteCalculationToDestination, dbusMessage.getUniqueSerial(), "showRouteCalculationToDestination", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowRouteCalculationToDestination", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestJamAheadListRequest(RequestJamAheadListCallbackIF& cb) const {
    RequestJamAheadListRequest* payload = new RequestJamAheadListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "requestJamAheadList", RequestJamAheadListRequest, payload, true)
    act_t act = addMethodCallback(ID_requestJamAheadList, dbusMessage.getUniqueSerial(), "requestJamAheadList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestJamAheadList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendReleaseJamAheadListRequest(ReleaseJamAheadListCallbackIF& cb) const {
    ReleaseJamAheadListRequest* payload = new ReleaseJamAheadListRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "releaseJamAheadList", ReleaseJamAheadListRequest, payload, true)
    act_t act = addMethodCallback(ID_releaseJamAheadList, dbusMessage.getUniqueSerial(), "releaseJamAheadList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReleaseJamAheadList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendSelectJamAheadListEntryRequest(SelectJamAheadListEntryCallbackIF& cb, int32 index) const {
    SelectJamAheadListEntryRequest* payload = new SelectJamAheadListEntryRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    DBUS_MESSAGE_CALL(dbusMessage, "selectJamAheadListEntry", SelectJamAheadListEntryRequest, payload, true)
    act_t act = addMethodCallback(ID_selectJamAheadListEntry, dbusMessage.getUniqueSerial(), "selectJamAheadListEntry", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SelectJamAheadListEntry", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendActivateNonPremiumTMCRequest(ActivateNonPremiumTMCCallbackIF& cb) const {
    ActivateNonPremiumTMCRequest* payload = new ActivateNonPremiumTMCRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "activateNonPremiumTMC", ActivateNonPremiumTMCRequest, payload, true)
    act_t act = addMethodCallback(ID_activateNonPremiumTMC, dbusMessage.getUniqueSerial(), "activateNonPremiumTMC", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ActivateNonPremiumTMC", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendDeactivateNonPremiumTMCRequest(DeactivateNonPremiumTMCCallbackIF& cb) const {
    DeactivateNonPremiumTMCRequest* payload = new DeactivateNonPremiumTMCRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "deactivateNonPremiumTMC", DeactivateNonPremiumTMCRequest, payload, true)
    act_t act = addMethodCallback(ID_deactivateNonPremiumTMC, dbusMessage.getUniqueSerial(), "deactivateNonPremiumTMC", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeactivateNonPremiumTMC", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendCancelJamAheadRequest(CancelJamAheadCallbackIF& cb) const {
    CancelJamAheadRequest* payload = new CancelJamAheadRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "cancelJamAhead", CancelJamAheadRequest, payload, true)
    act_t act = addMethodCallback(ID_cancelJamAhead, dbusMessage.getUniqueSerial(), "cancelJamAhead", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelJamAhead", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendRequestDetailsForSelectedCoordinateWithRadiusRequest(RequestDetailsForSelectedCoordinateWithRadiusCallbackIF& cb, const PositionWGS84& location, uint16 radius) const {
    RequestDetailsForSelectedCoordinateWithRadiusRequest* payload = new RequestDetailsForSelectedCoordinateWithRadiusRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    payload->setRadius(radius);
    DBUS_MESSAGE_CALL(dbusMessage, "requestDetailsForSelectedCoordinateWithRadius", RequestDetailsForSelectedCoordinateWithRadiusRequest, payload, true)
    act_t act = addMethodCallback(ID_requestDetailsForSelectedCoordinateWithRadius, dbusMessage.getUniqueSerial(), "requestDetailsForSelectedCoordinateWithRadius", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestDetailsForSelectedCoordinateWithRadius", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationServiceProxy::sendShowAndSetLocationWithDetailsRequest(ShowAndSetLocationWithDetailsCallbackIF& cb, const POILocation& location) const {
    ShowAndSetLocationWithDetailsRequest* payload = new ShowAndSetLocationWithDetailsRequest();
    CHECK_ALLOCATION(payload);
    payload->setLocation(location);
    DBUS_MESSAGE_CALL(dbusMessage, "showAndSetLocationWithDetails", ShowAndSetLocationWithDetailsRequest, payload, true)
    act_t act = addMethodCallback(ID_showAndSetLocationWithDetails, dbusMessage.getUniqueSerial(), "showAndSetLocationWithDetails", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowAndSetLocationWithDetails", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
