/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * If the meaning of "org.bosch.cm.navigation.NavigationService" isn't clear, then there should be a description here.
 */

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

bool EstimatedTimeType_Parse (const char *str, size_t length, EstimatedTimeType &value)
{
    static stringEntry entries[] = {
        {8,"WAYPOINT", 1U},
        {11,"DESTINATION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* EstimatedTimeType_Name (EstimatedTimeType value)
{
    static const char* enumerationLiterals[] = {
        "DESTINATION",
        "WAYPOINT",
    };

    if (EstimatedTimeType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool EstimatedTimeType_IsValid (EstimatedTimeType value)
{
    switch (value) {
    case EstimatedTimeType__DESTINATION:
    case EstimatedTimeType__WAYPOINT:
        return true;
    default:
        return false;
    }
}

bool NavDataCompatibility_Parse (const char *str, size_t length, NavDataCompatibility &value)
{
    static stringEntry entries[] = {
        {18,"NAVDATA_COMPATIBLE", 0U},
        {20,"NAVDATA_INCOMPATIBLE", 1U},
        {29,"NAVDATA_COMPATIBILITY_UNKNOWN", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* NavDataCompatibility_Name (NavDataCompatibility value)
{
    static const char* enumerationLiterals[] = {
        "NAVDATA_COMPATIBLE",
        "NAVDATA_INCOMPATIBLE",
        "NAVDATA_COMPATIBILITY_UNKNOWN",
    };

    if (NavDataCompatibility_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool NavDataCompatibility_IsValid (NavDataCompatibility value)
{
    switch (value) {
    case NavDataCompatibility__NAVDATA_COMPATIBLE:
    case NavDataCompatibility__NAVDATA_INCOMPATIBLE:
    case NavDataCompatibility__NAVDATA_COMPATIBILITY_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool NavStatus_Parse (const char *str, size_t length, NavStatus &value)
{
    static stringEntry entries[] = {
        {14,"NAVSTATUS_BUSY", 1U},
        {14,"NAVSTATUS_IDLE", 4U},
        {17,"NAVSTATUS_UNKNOWN", 0U},
        {25,"NAVSTATUS_GUIDANCE_ACTIVE", 5U},
        {26,"NAVSTATUS_NAVDATA_UPDATING", 2U},
        {27,"NAVSTATUS_CALCULATING_ROUTE", 6U},
        {27,"NAVSTATUS_MAP_RECOVERY_MODE", 3U},
        {34,"NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* NavStatus_Name (NavStatus value)
{
    static const char* enumerationLiterals[] = {
        "NAVSTATUS_UNKNOWN",
        "NAVSTATUS_BUSY",
        "NAVSTATUS_NAVDATA_UPDATING",
        "NAVSTATUS_MAP_RECOVERY_MODE",
        "NAVSTATUS_IDLE",
        "NAVSTATUS_GUIDANCE_ACTIVE",
        "NAVSTATUS_CALCULATING_ROUTE",
        "NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD",
    };

    if (NavStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool NavStatus_IsValid (NavStatus value)
{
    switch (value) {
    case NavStatus__NAVSTATUS_UNKNOWN:
    case NavStatus__NAVSTATUS_BUSY:
    case NavStatus__NAVSTATUS_NAVDATA_UPDATING:
    case NavStatus__NAVSTATUS_MAP_RECOVERY_MODE:
    case NavStatus__NAVSTATUS_IDLE:
    case NavStatus__NAVSTATUS_GUIDANCE_ACTIVE:
    case NavStatus__NAVSTATUS_CALCULATING_ROUTE:
    case NavStatus__NAVSTATUS_GUIDANCE_ACTIVE_OFFBOARD:
        return true;
    default:
        return false;
    }
}

bool RoadClass_Parse (const char *str, size_t length, RoadClass &value)
{
    static stringEntry entries[] = {
        {15,"ROAD_CLASS_NONE", 0U},
        {16,"ROAD_CLASS_LOCAL", 6U},
        {16,"ROAD_CLASS_TRAIL", 8U},
        {18,"ROAD_CLASS_FREEWAY", 2U},
        {18,"ROAD_CLASS_HIGHWAY", 3U},
        {19,"ROAD_CLASS_ARTERIAL", 4U},
        {19,"ROAD_CLASS_MOTORWAY", 1U},
        {20,"ROAD_CLASS_COLLECTOR", 5U},
        {28,"ROAD_CLASS_ADDRESSABLESTREET", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* RoadClass_Name (RoadClass value)
{
    static const char* enumerationLiterals[] = {
        "ROAD_CLASS_NONE",
        "ROAD_CLASS_MOTORWAY",
        "ROAD_CLASS_FREEWAY",
        "ROAD_CLASS_HIGHWAY",
        "ROAD_CLASS_ARTERIAL",
        "ROAD_CLASS_COLLECTOR",
        "ROAD_CLASS_LOCAL",
        "ROAD_CLASS_ADDRESSABLESTREET",
        "ROAD_CLASS_TRAIL",
    };

    if (RoadClass_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool RoadClass_IsValid (RoadClass value)
{
    switch (value) {
    case RoadClass__ROAD_CLASS_NONE:
    case RoadClass__ROAD_CLASS_MOTORWAY:
    case RoadClass__ROAD_CLASS_FREEWAY:
    case RoadClass__ROAD_CLASS_HIGHWAY:
    case RoadClass__ROAD_CLASS_ARTERIAL:
    case RoadClass__ROAD_CLASS_COLLECTOR:
    case RoadClass__ROAD_CLASS_LOCAL:
    case RoadClass__ROAD_CLASS_ADDRESSABLESTREET:
    case RoadClass__ROAD_CLASS_TRAIL:
        return true;
    default:
        return false;
    }
}

bool DistanceUnit_Parse (const char *str, size_t length, DistanceUnit &value)
{
    static stringEntry entries[] = {
        {4,"FEET", 2U},
        {4,"YARD", 3U},
        {5,"MILES", 4U},
        {6,"METERS", 0U},
        {7,"INVALID", 99U},
        {10,"KILOMETERS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* DistanceUnit_Name (DistanceUnit value)
{
    static const char* enumerationLiterals[] = {
        "METERS",
        "KILOMETERS",
        "FEET",
        "YARD",
        "MILES",
        "INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        99U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool DistanceUnit_IsValid (DistanceUnit value)
{
    switch (value) {
    case DistanceUnit__METERS:
    case DistanceUnit__KILOMETERS:
    case DistanceUnit__FEET:
    case DistanceUnit__YARD:
    case DistanceUnit__MILES:
    case DistanceUnit__INVALID:
        return true;
    default:
        return false;
    }
}

bool ManeuverSymbol_Parse (const char *str, size_t length, ManeuverSymbol &value)
{
    static stringEntry entries[] = {
        {4,"SIZE", 55U},
        {22,"MANEUVER_SYMBOL_FOLLOW", 2U},
        {22,"MANEUVER_SYMBOL_RECALC", 3U},
        {23,"MANEUVER_SYMBOL_NO_INFO", 1U},
        {24,"MANEUVER_SYMBOL_STRAIGHT", 28U},
        {25,"MANEUVER_SYMBOL_EXIT_LEFT", 10U},
        {25,"MANEUVER_SYMBOL_KEEP_LEFT", 37U},
        {25,"MANEUVER_SYMBOL_NO_SYMBOL", 0U},
        {25,"MANEUVER_SYMBOL_TURN_LEFT", 33U},
        {26,"MANEUVER_SYMBOL_EXIT_RIGHT", 11U},
        {26,"MANEUVER_SYMBOL_KEEP_RIGHT", 38U},
        {26,"MANEUVER_SYMBOL_TURN_RIGHT", 30U},
        {26,"MANEUVER_SYMBOL_UTURN_LEFT", 35U},
        {27,"MANEUVER_SYMBOL_UTURN_RIGHT", 36U},
        {28,"MANEUVER_SYMBOL_DEST_REACHED", 4U},
        {29,"MANEUVER_SYMBOL_TURN_HALFLEFT", 34U},
        {30,"MANEUVER_SYMBOL_TURN_HALFRIGHT", 29U},
        {30,"MANEUVER_SYMBOL_TURN_SHARPLEFT", 32U},
        {31,"MANEUVER_SYMBOL_TURN_SHARPRIGHT", 31U},
        {33,"MANEUVER_SYMBOL_DEST_REACHED_LEFT", 5U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_001", 39U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_009", 40U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_025", 41U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_041", 42U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_057", 43U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_073", 44U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_089", 45U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_105", 46U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_121", 47U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_137", 48U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_153", 49U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_169", 50U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_185", 51U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_201", 52U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_217", 53U},
        {34,"MANEUVER_SYMBOL_DEST_DIRECTION_233", 54U},
        {34,"MANEUVER_SYMBOL_DEST_REACHED_RIGHT", 6U},
        {40,"MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED", 7U},
        {45,"MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT", 8U},
        {46,"MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT", 9U},
        {49,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT", 18U},
        {50,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT", 14U},
        {50,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT", 26U},
        {51,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT", 22U},
        {52,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE", 16U},
        {53,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT", 19U},
        {53,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT", 12U},
        {53,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE", 24U},
        {54,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT", 13U},
        {54,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT", 17U},
        {54,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT", 27U},
        {54,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT", 20U},
        {55,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT", 15U},
        {55,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT", 21U},
        {55,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT", 25U},
        {56,"MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT", 23U},
    };

    return lookupInStringEntryTable (str, length, entries, 56, (unsigned int&) value);
}

const char* ManeuverSymbol_Name (ManeuverSymbol value)
{
    static const char* enumerationLiterals[] = {
        "MANEUVER_SYMBOL_NO_SYMBOL",
        "MANEUVER_SYMBOL_NO_INFO",
        "MANEUVER_SYMBOL_FOLLOW",
        "MANEUVER_SYMBOL_RECALC",
        "MANEUVER_SYMBOL_DEST_REACHED",
        "MANEUVER_SYMBOL_DEST_REACHED_LEFT",
        "MANEUVER_SYMBOL_DEST_REACHED_RIGHT",
        "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED",
        "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT",
        "MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT",
        "MANEUVER_SYMBOL_EXIT_LEFT",
        "MANEUVER_SYMBOL_EXIT_RIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT",
        "MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT",
        "MANEUVER_SYMBOL_STRAIGHT",
        "MANEUVER_SYMBOL_TURN_HALFRIGHT",
        "MANEUVER_SYMBOL_TURN_RIGHT",
        "MANEUVER_SYMBOL_TURN_SHARPRIGHT",
        "MANEUVER_SYMBOL_TURN_SHARPLEFT",
        "MANEUVER_SYMBOL_TURN_LEFT",
        "MANEUVER_SYMBOL_TURN_HALFLEFT",
        "MANEUVER_SYMBOL_UTURN_LEFT",
        "MANEUVER_SYMBOL_UTURN_RIGHT",
        "MANEUVER_SYMBOL_KEEP_LEFT",
        "MANEUVER_SYMBOL_KEEP_RIGHT",
        "MANEUVER_SYMBOL_DEST_DIRECTION_001",
        "MANEUVER_SYMBOL_DEST_DIRECTION_009",
        "MANEUVER_SYMBOL_DEST_DIRECTION_025",
        "MANEUVER_SYMBOL_DEST_DIRECTION_041",
        "MANEUVER_SYMBOL_DEST_DIRECTION_057",
        "MANEUVER_SYMBOL_DEST_DIRECTION_073",
        "MANEUVER_SYMBOL_DEST_DIRECTION_089",
        "MANEUVER_SYMBOL_DEST_DIRECTION_105",
        "MANEUVER_SYMBOL_DEST_DIRECTION_121",
        "MANEUVER_SYMBOL_DEST_DIRECTION_137",
        "MANEUVER_SYMBOL_DEST_DIRECTION_153",
        "MANEUVER_SYMBOL_DEST_DIRECTION_169",
        "MANEUVER_SYMBOL_DEST_DIRECTION_185",
        "MANEUVER_SYMBOL_DEST_DIRECTION_201",
        "MANEUVER_SYMBOL_DEST_DIRECTION_217",
        "MANEUVER_SYMBOL_DEST_DIRECTION_233",
        "SIZE",
    };

    if (ManeuverSymbol_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ManeuverSymbol_IsValid (ManeuverSymbol value)
{
    switch (value) {
    case ManeuverSymbol__MANEUVER_SYMBOL_NO_SYMBOL:
    case ManeuverSymbol__MANEUVER_SYMBOL_NO_INFO:
    case ManeuverSymbol__MANEUVER_SYMBOL_FOLLOW:
    case ManeuverSymbol__MANEUVER_SYMBOL_RECALC:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_REACHED_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED:
    case ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_INTERMEDIATEDEST_REACHED_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_EXIT_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_EXIT_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_STRAIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_REVERSE:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_SHARPLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_LEFT_HALFLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_STRAIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_REVERSE:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_SHARPLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_ROUNDABOUT_TRAFFICSENSE_RIGHT_HALFLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_STRAIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_HALFRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_SHARPRIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_SHARPLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_TURN_HALFLEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_UTURN_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_UTURN_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_KEEP_LEFT:
    case ManeuverSymbol__MANEUVER_SYMBOL_KEEP_RIGHT:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_001:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_009:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_025:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_041:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_057:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_073:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_089:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_105:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_121:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_137:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_153:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_169:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_185:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_201:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_217:
    case ManeuverSymbol__MANEUVER_SYMBOL_DEST_DIRECTION_233:
    case ManeuverSymbol__SIZE:
        return true;
    default:
        return false;
    }
}

bool MapPOIIconCategory_Parse (const char *str, size_t length, MapPOIIconCategory &value)
{
    static stringEntry entries[] = {
        {25,"MAP_POI_ICON_CATEGORY_ATM", 3U},
        {27,"MAP_POI_ICON_CATEGORY_HOTEL", 2U},
        {29,"MAP_POI_ICON_CATEGORY_PARKING", 7U},
        {30,"MAP_POI_ICON_CATEGORY_HOSPITAL", 5U},
        {31,"MAP_POI_ICON_CATEGORY_FAST_FOOD", 12U},
        {31,"MAP_POI_ICON_CATEGORY_REST_AREA", 4U},
        {32,"MAP_POI_ICON_CATEGORY_RESTAURANT", 0U},
        {33,"MAP_POI_ICON_CATEGORY_GAS_STATION", 1U},
        {33,"MAP_POI_ICON_CATEGORY_PARKING_LOT", 6U},
        {33,"MAP_POI_ICON_CATEGORY_POST_OFFICE", 9U},
        {38,"MAP_POI_ICON_CATEGORY_DEPARTMENT_STORE", 10U},
        {39,"MAP_POI_ICON_CATEGORY_CONVENIENCE_STORE", 11U},
        {40,"MAP_POI_ICON_CATEGORY_BANKING_FACILITIES", 13U},
        {43,"MAP_POI_ICON_CATEGORY_FINANCIAL_INSTITUTION", 8U},
    };

    return lookupInStringEntryTable (str, length, entries, 14, (unsigned int&) value);
}

const char* MapPOIIconCategory_Name (MapPOIIconCategory value)
{
    static const char* enumerationLiterals[] = {
        "MAP_POI_ICON_CATEGORY_RESTAURANT",
        "MAP_POI_ICON_CATEGORY_GAS_STATION",
        "MAP_POI_ICON_CATEGORY_HOTEL",
        "MAP_POI_ICON_CATEGORY_ATM",
        "MAP_POI_ICON_CATEGORY_REST_AREA",
        "MAP_POI_ICON_CATEGORY_HOSPITAL",
        "MAP_POI_ICON_CATEGORY_PARKING_LOT",
        "MAP_POI_ICON_CATEGORY_PARKING",
        "MAP_POI_ICON_CATEGORY_FINANCIAL_INSTITUTION",
        "MAP_POI_ICON_CATEGORY_POST_OFFICE",
        "MAP_POI_ICON_CATEGORY_DEPARTMENT_STORE",
        "MAP_POI_ICON_CATEGORY_CONVENIENCE_STORE",
        "MAP_POI_ICON_CATEGORY_FAST_FOOD",
        "MAP_POI_ICON_CATEGORY_BANKING_FACILITIES",
    };

    if (MapPOIIconCategory_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool MapPOIIconCategory_IsValid (MapPOIIconCategory value)
{
    switch (value) {
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_RESTAURANT:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_GAS_STATION:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_HOTEL:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_ATM:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_REST_AREA:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_HOSPITAL:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_PARKING_LOT:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_PARKING:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_FINANCIAL_INSTITUTION:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_POST_OFFICE:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_DEPARTMENT_STORE:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_CONVENIENCE_STORE:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_FAST_FOOD:
    case MapPOIIconCategory__MAP_POI_ICON_CATEGORY_BANKING_FACILITIES:
        return true;
    default:
        return false;
    }
}

bool RouteRecalculationReason_Parse (const char *str, size_t length, RouteRecalculationReason &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {14,"NO_CALCULATION", 2U},
        {14,"OPTIMIZE_ROUTE", 4U},
        {15,"DISREGARD_ROUTE", 6U},
        {17,"FIRST_CALCULATION", 3U},
        {18,"NO_ROUTE_AVAILABLE", 1U},
        {20,"ROUTE_OPTION_CHANGED", 8U},
        {22,"ENTRY_POINT_EVALUATION", 11U},
        {23,"ROUTE_CRITERION_CHANGED", 9U},
        {25,"REGARDING_TRAFFIC_MESSAGE", 5U},
        {30,"REGARDING_USER_TRAFFIC_MESSAGE", 7U},
        {30,"ROUTE_OPTION_CRITERION_CHANGED", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* RouteRecalculationReason_Name (RouteRecalculationReason value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "NO_ROUTE_AVAILABLE",
        "NO_CALCULATION",
        "FIRST_CALCULATION",
        "OPTIMIZE_ROUTE",
        "REGARDING_TRAFFIC_MESSAGE",
        "DISREGARD_ROUTE",
        "REGARDING_USER_TRAFFIC_MESSAGE",
        "ROUTE_OPTION_CHANGED",
        "ROUTE_CRITERION_CHANGED",
        "ROUTE_OPTION_CRITERION_CHANGED",
        "ENTRY_POINT_EVALUATION",
    };

    if (RouteRecalculationReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool RouteRecalculationReason_IsValid (RouteRecalculationReason value)
{
    switch (value) {
    case RouteRecalculationReason__UNKNOWN:
    case RouteRecalculationReason__NO_ROUTE_AVAILABLE:
    case RouteRecalculationReason__NO_CALCULATION:
    case RouteRecalculationReason__FIRST_CALCULATION:
    case RouteRecalculationReason__OPTIMIZE_ROUTE:
    case RouteRecalculationReason__REGARDING_TRAFFIC_MESSAGE:
    case RouteRecalculationReason__DISREGARD_ROUTE:
    case RouteRecalculationReason__REGARDING_USER_TRAFFIC_MESSAGE:
    case RouteRecalculationReason__ROUTE_OPTION_CHANGED:
    case RouteRecalculationReason__ROUTE_CRITERION_CHANGED:
    case RouteRecalculationReason__ROUTE_OPTION_CRITERION_CHANGED:
    case RouteRecalculationReason__ENTRY_POINT_EVALUATION:
        return true;
    default:
        return false;
    }
}

bool RouteCriterion_Parse (const char *str, size_t length, RouteCriterion &value)
{
    static stringEntry entries[] = {
        {20,"ROUTE_CRITERION_FAST", 1U},
        {21,"ROUTE_CRITERION_SHORT", 2U},
        {24,"ROUTE_CRITERION_ECONOMIC", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* RouteCriterion_Name (RouteCriterion value)
{
    static const char* enumerationLiterals[] = {
        "ROUTE_CRITERION_ECONOMIC",
        "ROUTE_CRITERION_FAST",
        "ROUTE_CRITERION_SHORT",
    };

    if (RouteCriterion_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool RouteCriterion_IsValid (RouteCriterion value)
{
    switch (value) {
    case RouteCriterion__ROUTE_CRITERION_ECONOMIC:
    case RouteCriterion__ROUTE_CRITERION_FAST:
    case RouteCriterion__ROUTE_CRITERION_SHORT:
        return true;
    default:
        return false;
    }
}

bool FTSLocationType_Parse (const char *str, size_t length, FTSLocationType &value)
{
    static stringEntry entries[] = {
        {24,"FREETEXT_SEARCH_TYPE_POI", 2U},
        {28,"FREETEXT_SEARCH_TYPE_ADDRESS", 1U},
        {29,"FREETEXT_SEARCH_TYPE_COMBINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* FTSLocationType_Name (FTSLocationType value)
{
    static const char* enumerationLiterals[] = {
        "FREETEXT_SEARCH_TYPE_COMBINED",
        "FREETEXT_SEARCH_TYPE_ADDRESS",
        "FREETEXT_SEARCH_TYPE_POI",
    };

    if (FTSLocationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool FTSLocationType_IsValid (FTSLocationType value)
{
    switch (value) {
    case FTSLocationType__FREETEXT_SEARCH_TYPE_COMBINED:
    case FTSLocationType__FREETEXT_SEARCH_TYPE_ADDRESS:
    case FTSLocationType__FREETEXT_SEARCH_TYPE_POI:
        return true;
    default:
        return false;
    }
}

bool FreeTextSearchScope_Parse (const char *str, size_t length, FreeTextSearchScope &value)
{
    static stringEntry entries[] = {
        {36,"FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA", 4U},
        {37,"FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE", 3U},
        {37,"FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION", 2U},
        {38,"FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET", 7U},
        {40,"FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA", 5U},
        {41,"FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA", 6U},
        {45,"FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION", 0U},
        {49,"FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* FreeTextSearchScope_Name (FreeTextSearchScope value)
{
    static const char* enumerationLiterals[] = {
        "FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION",
        "FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION",
        "FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION",
        "FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE",
        "FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA",
        "FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA",
        "FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA",
        "FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET",
    };

    if (FreeTextSearchScope_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool FreeTextSearchScope_IsValid (FreeTextSearchScope value)
{
    switch (value) {
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_DESTINATION_POSITION:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_LOCATION:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_ALONG_ROUTE:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_WHOLE_DATA:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_ADDRESS_WHOLE_DATA:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_COMBINED_WHOLE_DATA:
    case FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_ON_WHOLE_DATASET:
        return true;
    default:
        return false;
    }
}

bool SDSAddressElementType_Parse (const char *str, size_t length, SDSAddressElementType &value)
{
    static stringEntry entries[] = {
        {29,"SDS_ADDRESS_ELEMENT_TYPE_ROAD", 2U},
        {30,"SDS_ADDRESS_ELEMENT_TYPE_PLACE", 1U},
        {30,"SDS_ADDRESS_ELEMENT_TYPE_STATE", 9U},
        {32,"SDS_ADDRESS_ELEMENT_TYPE_COUNTRY", 0U},
        {34,"SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD", 3U},
        {36,"SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER", 4U},
        {37,"SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT", 6U},
        {39,"SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT", 5U},
        {39,"SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT", 8U},
        {40,"SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* SDSAddressElementType_Name (SDSAddressElementType value)
{
    static const char* enumerationLiterals[] = {
        "SDS_ADDRESS_ELEMENT_TYPE_COUNTRY",
        "SDS_ADDRESS_ELEMENT_TYPE_PLACE",
        "SDS_ADDRESS_ELEMENT_TYPE_ROAD",
        "SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD",
        "SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER",
        "SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT",
        "SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT",
        "SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT",
        "SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT",
        "SDS_ADDRESS_ELEMENT_TYPE_STATE",
    };

    if (SDSAddressElementType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool SDSAddressElementType_IsValid (SDSAddressElementType value)
{
    switch (value) {
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACE:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROAD:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT:
    case SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_STATE:
        return true;
    default:
        return false;
    }
}

bool MapRepresentation_Parse (const char *str, size_t length, MapRepresentation &value)
{
    static stringEntry entries[] = {
        {26,"MAP_REPRESENTATION_NOT_SET", 3U},
        {30,"MAP_REPRESENTATION_2D_NORTH_UP", 0U},
        {33,"MAP_REPRESENTATION_2D_CAR_HEADING", 2U},
        {33,"MAP_REPRESENTATION_3D_CAR_HEADING", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* MapRepresentation_Name (MapRepresentation value)
{
    static const char* enumerationLiterals[] = {
        "MAP_REPRESENTATION_2D_NORTH_UP",
        "MAP_REPRESENTATION_3D_CAR_HEADING",
        "MAP_REPRESENTATION_2D_CAR_HEADING",
        "MAP_REPRESENTATION_NOT_SET",
    };

    if (MapRepresentation_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool MapRepresentation_IsValid (MapRepresentation value)
{
    switch (value) {
    case MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP:
    case MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING:
    case MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING:
    case MapRepresentation__MAP_REPRESENTATION_NOT_SET:
        return true;
    default:
        return false;
    }
}

bool MapMultiViewMode_Parse (const char *str, size_t length, MapMultiViewMode &value)
{
    static stringEntry entries[] = {
        {22,"MAP_MULTI_VIEW_MODE_ON", 2U},
        {23,"MAP_MULTI_VIEW_MODE_OFF", 1U},
        {29,"MAP_MULTI_VIEW_MODE_UNCHANGED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* MapMultiViewMode_Name (MapMultiViewMode value)
{
    static const char* enumerationLiterals[] = {
        "MAP_MULTI_VIEW_MODE_UNCHANGED",
        "MAP_MULTI_VIEW_MODE_OFF",
        "MAP_MULTI_VIEW_MODE_ON",
    };

    if (MapMultiViewMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool MapMultiViewMode_IsValid (MapMultiViewMode value)
{
    switch (value) {
    case MapMultiViewMode__MAP_MULTI_VIEW_MODE_UNCHANGED:
    case MapMultiViewMode__MAP_MULTI_VIEW_MODE_OFF:
    case MapMultiViewMode__MAP_MULTI_VIEW_MODE_ON:
        return true;
    default:
        return false;
    }
}

bool MapViewMode_Parse (const char *str, size_t length, MapViewMode &value)
{
    static stringEntry entries[] = {
        {22,"MAP_VIEW_MODE_FULL_MAP", 0U},
        {23,"MAP_VIEW_MODE_SPLIT_MAP", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* MapViewMode_Name (MapViewMode value)
{
    static const char* enumerationLiterals[] = {
        "MAP_VIEW_MODE_FULL_MAP",
        "MAP_VIEW_MODE_SPLIT_MAP",
    };

    if (MapViewMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool MapViewMode_IsValid (MapViewMode value)
{
    switch (value) {
    case MapViewMode__MAP_VIEW_MODE_FULL_MAP:
    case MapViewMode__MAP_VIEW_MODE_SPLIT_MAP:
        return true;
    default:
        return false;
    }
}

bool MapCameraMode_Parse (const char *str, size_t length, MapCameraMode &value)
{
    static stringEntry entries[] = {
        {15,"MAP_MODE_CARSOR", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* MapCameraMode_Name (MapCameraMode value)
{
    static const char* enumerationLiterals[] = {
        "MAP_MODE_CARSOR",
    };

    if (MapCameraMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool MapCameraMode_IsValid (MapCameraMode value)
{
    switch (value) {
    case MapCameraMode__MAP_MODE_CARSOR:
        return true;
    default:
        return false;
    }
}

bool DeformedImageRoadType_Parse (const char *str, size_t length, DeformedImageRoadType &value)
{
    static stringEntry entries[] = {
        {4,"FORK", 1U},
        {4,"NONE", 0U},
        {9,"EXIT_LEFT", 2U},
        {10,"EXIT_RIGHT", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* DeformedImageRoadType_Name (DeformedImageRoadType value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "FORK",
        "EXIT_LEFT",
        "EXIT_RIGHT",
    };

    if (DeformedImageRoadType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DeformedImageRoadType_IsValid (DeformedImageRoadType value)
{
    switch (value) {
    case DeformedImageRoadType__NONE:
    case DeformedImageRoadType__FORK:
    case DeformedImageRoadType__EXIT_LEFT:
    case DeformedImageRoadType__EXIT_RIGHT:
        return true;
    default:
        return false;
    }
}

bool DeformedImageArrowType_Parse (const char *str, size_t length, DeformedImageArrowType &value)
{
    static stringEntry entries[] = {
        {4,"LEFT", 2U},
        {4,"NONE", 0U},
        {5,"RIGHT", 3U},
        {8,"STRAIGHT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* DeformedImageArrowType_Name (DeformedImageArrowType value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "STRAIGHT",
        "LEFT",
        "RIGHT",
    };

    if (DeformedImageArrowType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DeformedImageArrowType_IsValid (DeformedImageArrowType value)
{
    switch (value) {
    case DeformedImageArrowType__NONE:
    case DeformedImageArrowType__STRAIGHT:
    case DeformedImageArrowType__LEFT:
    case DeformedImageArrowType__RIGHT:
        return true;
    default:
        return false;
    }
}

bool TimeType_Parse (const char *str, size_t length, TimeType &value)
{
    static stringEntry entries[] = {
        {3,"ETA", 1U},
        {13,"REMAININGTIME", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* TimeType_Name (TimeType value)
{
    static const char* enumerationLiterals[] = {
        "REMAININGTIME",
        "ETA",
    };

    if (TimeType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TimeType_IsValid (TimeType value)
{
    switch (value) {
    case TimeType__REMAININGTIME:
    case TimeType__ETA:
        return true;
    default:
        return false;
    }
}

bool TimeFormat_Parse (const char *str, size_t length, TimeFormat &value)
{
    static stringEntry entries[] = {
        {5,"UNSET", 0U},
        {11,"TWELVEHOURS", 1U},
        {15,"TWENTYFOURHOURS", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* TimeFormat_Name (TimeFormat value)
{
    static const char* enumerationLiterals[] = {
        "UNSET",
        "TWELVEHOURS",
        "TWENTYFOURHOURS",
    };

    if (TimeFormat_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TimeFormat_IsValid (TimeFormat value)
{
    switch (value) {
    case TimeFormat__UNSET:
    case TimeFormat__TWELVEHOURS:
    case TimeFormat__TWENTYFOURHOURS:
        return true;
    default:
        return false;
    }
}

bool AdminRoadClass_Parse (const char *str, size_t length, AdminRoadClass &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {14,"MOST_IMPORTANT", 1U},
        {15,"FIFTH_IMPORTANT", 5U},
        {15,"LEAST_IMPORTANT", 7U},
        {15,"SIXTH_IMPORTANT", 6U},
        {15,"THIRD_IMPORTANT", 3U},
        {16,"FOURTH_IMPORTANT", 4U},
        {16,"SECOND_IMPORTANT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* AdminRoadClass_Name (AdminRoadClass value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "MOST_IMPORTANT",
        "SECOND_IMPORTANT",
        "THIRD_IMPORTANT",
        "FOURTH_IMPORTANT",
        "FIFTH_IMPORTANT",
        "SIXTH_IMPORTANT",
        "LEAST_IMPORTANT",
    };

    if (AdminRoadClass_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool AdminRoadClass_IsValid (AdminRoadClass value)
{
    switch (value) {
    case AdminRoadClass__UNKNOWN:
    case AdminRoadClass__MOST_IMPORTANT:
    case AdminRoadClass__SECOND_IMPORTANT:
    case AdminRoadClass__THIRD_IMPORTANT:
    case AdminRoadClass__FOURTH_IMPORTANT:
    case AdminRoadClass__FIFTH_IMPORTANT:
    case AdminRoadClass__SIXTH_IMPORTANT:
    case AdminRoadClass__LEAST_IMPORTANT:
        return true;
    default:
        return false;
    }
}

bool ManeuverRecommendationType_Parse (const char *str, size_t length, ManeuverRecommendationType &value)
{
    static stringEntry entries[] = {
        {7,"PREVIEW", 0U},
        {7,"REGULAR", 2U},
        {8,"REPEATED", 3U},
        {11,"PRELIMINARY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* ManeuverRecommendationType_Name (ManeuverRecommendationType value)
{
    static const char* enumerationLiterals[] = {
        "PREVIEW",
        "PRELIMINARY",
        "REGULAR",
        "REPEATED",
    };

    if (ManeuverRecommendationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ManeuverRecommendationType_IsValid (ManeuverRecommendationType value)
{
    switch (value) {
    case ManeuverRecommendationType__PREVIEW:
    case ManeuverRecommendationType__PRELIMINARY:
    case ManeuverRecommendationType__REGULAR:
    case ManeuverRecommendationType__REPEATED:
        return true;
    default:
        return false;
    }
}

bool SpeedUnit_Parse (const char *str, size_t length, SpeedUnit &value)
{
    static stringEntry entries[] = {
        {11,"KM_PER_HOUR", 0U},
        {11,"MI_PER_HOUR", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* SpeedUnit_Name (SpeedUnit value)
{
    static const char* enumerationLiterals[] = {
        "KM_PER_HOUR",
        "MI_PER_HOUR",
    };

    if (SpeedUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool SpeedUnit_IsValid (SpeedUnit value)
{
    switch (value) {
    case SpeedUnit__KM_PER_HOUR:
    case SpeedUnit__MI_PER_HOUR:
        return true;
    default:
        return false;
    }
}

bool LaneStatus_Parse (const char *str, size_t length, LaneStatus &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {9,"FORBIDDEN", 1U},
        {11,"RECOMMENDED", 3U},
        {15,"NOT_RECOMMENDED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* LaneStatus_Name (LaneStatus value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "FORBIDDEN",
        "NOT_RECOMMENDED",
        "RECOMMENDED",
    };

    if (LaneStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool LaneStatus_IsValid (LaneStatus value)
{
    switch (value) {
    case LaneStatus__UNKNOWN:
    case LaneStatus__FORBIDDEN:
    case LaneStatus__NOT_RECOMMENDED:
    case LaneStatus__RECOMMENDED:
        return true;
    default:
        return false;
    }
}

bool ManeuverViewType_Parse (const char *str, size_t length, ManeuverViewType &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {14,"DEFORMED_IMAGE", 1U},
        {16,"INTERSECTION_MAP", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* ManeuverViewType_Name (ManeuverViewType value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "DEFORMED_IMAGE",
        "INTERSECTION_MAP",
    };

    if (ManeuverViewType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ManeuverViewType_IsValid (ManeuverViewType value)
{
    switch (value) {
    case ManeuverViewType__NONE:
    case ManeuverViewType__DEFORMED_IMAGE:
    case ManeuverViewType__INTERSECTION_MAP:
        return true;
    default:
        return false;
    }
}

bool IntersectionMapCarsorState_Parse (const char *str, size_t length, IntersectionMapCarsorState &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
        {7,"STANDBY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* IntersectionMapCarsorState_Name (IntersectionMapCarsorState value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
        "STANDBY",
    };

    if (IntersectionMapCarsorState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool IntersectionMapCarsorState_IsValid (IntersectionMapCarsorState value)
{
    switch (value) {
    case IntersectionMapCarsorState__OFF:
    case IntersectionMapCarsorState__ON:
    case IntersectionMapCarsorState__STANDBY:
        return true;
    default:
        return false;
    }
}

bool ZoomLevel_Parse (const char *str, size_t length, ZoomLevel &value)
{
    static stringEntry entries[] = {
        {8,"ZOOM_50M", 0U},
        {9,"ZOOM_100M", 1U},
        {9,"ZOOM_200M", 2U},
        {9,"ZOOM_500M", 3U},
        {10,"ZOOM_1000M", 4U},
        {10,"ZOOM_2000M", 5U},
        {10,"ZOOM_5000M", 6U},
        {11,"ZOOM_10000M", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* ZoomLevel_Name (ZoomLevel value)
{
    static const char* enumerationLiterals[] = {
        "ZOOM_50M",
        "ZOOM_100M",
        "ZOOM_200M",
        "ZOOM_500M",
        "ZOOM_1000M",
        "ZOOM_2000M",
        "ZOOM_5000M",
        "ZOOM_10000M",
    };

    if (ZoomLevel_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ZoomLevel_IsValid (ZoomLevel value)
{
    switch (value) {
    case ZoomLevel__ZOOM_50M:
    case ZoomLevel__ZOOM_100M:
    case ZoomLevel__ZOOM_200M:
    case ZoomLevel__ZOOM_500M:
    case ZoomLevel__ZOOM_1000M:
    case ZoomLevel__ZOOM_2000M:
    case ZoomLevel__ZOOM_5000M:
    case ZoomLevel__ZOOM_10000M:
        return true;
    default:
        return false;
    }
}

bool ImageType_Parse (const char *str, size_t length, ImageType &value)
{
    static stringEntry entries[] = {
        {3,"PNG", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* ImageType_Name (ImageType value)
{
    static const char* enumerationLiterals[] = {
        "PNG",
    };

    if (ImageType_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool ImageType_IsValid (ImageType value)
{
    switch (value) {
    case ImageType__PNG:
        return true;
    default:
        return false;
    }
}

bool SDSVoiceTagOptions_Parse (const char *str, size_t length, SDSVoiceTagOptions &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {13,"PLAY_VOICETAG", 2U},
        {15,"DELETE_VOICETAG", 3U},
        {16,"VOICETAG_DELETED", 7U},
        {19,"CREATE_NEW_VOICETAG", 1U},
        {19,"NO_VOICETAG_CREATED", 6U},
        {20,"DELETE_ALL_VOICETAGS", 4U},
        {20,"NEW_VOICETAG_CREATED", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* SDSVoiceTagOptions_Name (SDSVoiceTagOptions value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "CREATE_NEW_VOICETAG",
        "PLAY_VOICETAG",
        "DELETE_VOICETAG",
        "DELETE_ALL_VOICETAGS",
        "NEW_VOICETAG_CREATED",
        "NO_VOICETAG_CREATED",
        "VOICETAG_DELETED",
    };

    if (SDSVoiceTagOptions_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool SDSVoiceTagOptions_IsValid (SDSVoiceTagOptions value)
{
    switch (value) {
    case SDSVoiceTagOptions__NONE:
    case SDSVoiceTagOptions__CREATE_NEW_VOICETAG:
    case SDSVoiceTagOptions__PLAY_VOICETAG:
    case SDSVoiceTagOptions__DELETE_VOICETAG:
    case SDSVoiceTagOptions__DELETE_ALL_VOICETAGS:
    case SDSVoiceTagOptions__NEW_VOICETAG_CREATED:
    case SDSVoiceTagOptions__NO_VOICETAG_CREATED:
    case SDSVoiceTagOptions__VOICETAG_DELETED:
        return true;
    default:
        return false;
    }
}

bool TripReplayStatus_Parse (const char *str, size_t length, TripReplayStatus &value)
{
    static stringEntry entries[] = {
        {6,"ACTIVE", 3U},
        {7,"UNKNOWN", 0U},
        {8,"RESERVED", 1U},
        {10,"NOT_ACTIVE", 2U},
        {14,"INTERNAL_ERROR", 5U},
        {20,"FILE_NOT_FOUND_ERROR", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* TripReplayStatus_Name (TripReplayStatus value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "RESERVED",
        "NOT_ACTIVE",
        "ACTIVE",
        "FILE_NOT_FOUND_ERROR",
        "INTERNAL_ERROR",
    };

    if (TripReplayStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TripReplayStatus_IsValid (TripReplayStatus value)
{
    switch (value) {
    case TripReplayStatus__UNKNOWN:
    case TripReplayStatus__RESERVED:
    case TripReplayStatus__NOT_ACTIVE:
    case TripReplayStatus__ACTIVE:
    case TripReplayStatus__FILE_NOT_FOUND_ERROR:
    case TripReplayStatus__INTERNAL_ERROR:
        return true;
    default:
        return false;
    }
}

bool DestinationMemoryCategoryType_Parse (const char *str, size_t length, DestinationMemoryCategoryType &value)
{
    static stringEntry entries[] = {
        {12,"ADDRESS_BOOK", 0U},
        {17,"LAST_DESTINATIONS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* DestinationMemoryCategoryType_Name (DestinationMemoryCategoryType value)
{
    static const char* enumerationLiterals[] = {
        "ADDRESS_BOOK",
        "LAST_DESTINATIONS",
    };

    if (DestinationMemoryCategoryType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DestinationMemoryCategoryType_IsValid (DestinationMemoryCategoryType value)
{
    switch (value) {
    case DestinationMemoryCategoryType__ADDRESS_BOOK:
    case DestinationMemoryCategoryType__LAST_DESTINATIONS:
        return true;
    default:
        return false;
    }
}

bool DirectionDescription_Parse (const char *str, size_t length, DirectionDescription &value)
{
    static stringEntry entries[] = {
        {4,"EAST", 4U},
        {4,"WEST", 12U},
        {5,"NORTH", 0U},
        {5,"SOUTH", 8U},
        {7,"INVALID", 16U},
        {10,"NORTH_EAST", 2U},
        {10,"NORTH_WEST", 14U},
        {10,"SOUTH_EAST", 6U},
        {10,"SOUTH_WEST", 10U},
        {15,"EAST_NORTH_EAST", 3U},
        {15,"EAST_SOUTH_EAST", 5U},
        {15,"WEST_NORTH_WEST", 13U},
        {15,"WEST_SOUTH_WEST", 11U},
        {16,"NORTH_NORTH_EAST", 1U},
        {16,"NORTH_NORTH_WEST", 15U},
        {16,"SOUTH_SOUTH_EAST", 7U},
        {16,"SOUTH_SOUTH_WEST", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 17, (unsigned int&) value);
}

const char* DirectionDescription_Name (DirectionDescription value)
{
    static const char* enumerationLiterals[] = {
        "NORTH",
        "NORTH_NORTH_EAST",
        "NORTH_EAST",
        "EAST_NORTH_EAST",
        "EAST",
        "EAST_SOUTH_EAST",
        "SOUTH_EAST",
        "SOUTH_SOUTH_EAST",
        "SOUTH",
        "SOUTH_SOUTH_WEST",
        "SOUTH_WEST",
        "WEST_SOUTH_WEST",
        "WEST",
        "WEST_NORTH_WEST",
        "NORTH_WEST",
        "NORTH_NORTH_WEST",
        "INVALID",
    };

    if (DirectionDescription_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DirectionDescription_IsValid (DirectionDescription value)
{
    switch (value) {
    case DirectionDescription__NORTH:
    case DirectionDescription__NORTH_NORTH_EAST:
    case DirectionDescription__NORTH_EAST:
    case DirectionDescription__EAST_NORTH_EAST:
    case DirectionDescription__EAST:
    case DirectionDescription__EAST_SOUTH_EAST:
    case DirectionDescription__SOUTH_EAST:
    case DirectionDescription__SOUTH_SOUTH_EAST:
    case DirectionDescription__SOUTH:
    case DirectionDescription__SOUTH_SOUTH_WEST:
    case DirectionDescription__SOUTH_WEST:
    case DirectionDescription__WEST_SOUTH_WEST:
    case DirectionDescription__WEST:
    case DirectionDescription__WEST_NORTH_WEST:
    case DirectionDescription__NORTH_WEST:
    case DirectionDescription__NORTH_NORTH_WEST:
    case DirectionDescription__INVALID:
        return true;
    default:
        return false;
    }
}

bool TrafficReceptionState_Parse (const char *str, size_t length, TrafficReceptionState &value)
{
    static stringEntry entries[] = {
        {2,"OK", 1U},
        {7,"UNKNOWN", 0U},
        {8,"INACTIVE", 7U},
        {9,"NO_SIGNAL", 5U},
        {10,"NO_ANTENNA", 4U},
        {13,"NOT_AVAILABLE", 3U},
        {14,"NOT_SUBSCRIBED", 2U},
        {15,"CONNECTION_LOST", 10U},
        {22,"AUTHENTICATION_INVALID", 9U},
        {22,"NO_INTERNET_CONNECTION", 8U},
        {25,"TEMPORARILY_NOT_AVAILABLE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* TrafficReceptionState_Name (TrafficReceptionState value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "OK",
        "NOT_SUBSCRIBED",
        "NOT_AVAILABLE",
        "NO_ANTENNA",
        "NO_SIGNAL",
        "TEMPORARILY_NOT_AVAILABLE",
        "INACTIVE",
        "NO_INTERNET_CONNECTION",
        "AUTHENTICATION_INVALID",
        "CONNECTION_LOST",
    };

    if (TrafficReceptionState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TrafficReceptionState_IsValid (TrafficReceptionState value)
{
    switch (value) {
    case TrafficReceptionState__UNKNOWN:
    case TrafficReceptionState__OK:
    case TrafficReceptionState__NOT_SUBSCRIBED:
    case TrafficReceptionState__NOT_AVAILABLE:
    case TrafficReceptionState__NO_ANTENNA:
    case TrafficReceptionState__NO_SIGNAL:
    case TrafficReceptionState__TEMPORARILY_NOT_AVAILABLE:
    case TrafficReceptionState__INACTIVE:
    case TrafficReceptionState__NO_INTERNET_CONNECTION:
    case TrafficReceptionState__AUTHENTICATION_INVALID:
    case TrafficReceptionState__CONNECTION_LOST:
        return true;
    default:
        return false;
    }
}

bool SampleVoicePhrase_Parse (const char *str, size_t length, SampleVoicePhrase &value)
{
    static stringEntry entries[] = {
        {21,"SAMPLE_PHRASE__LOUDER", 1U},
        {22,"SAMPLE_PHRASE__QUIETER", 2U},
        {27,"SAMPLE_PHRASE__VOICE_OUTPUT", 3U},
        {46,"SAMPLE_PHRASE__GUIDANCE_WILL_BE_AT_THIS_VOLUME", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* SampleVoicePhrase_Name (SampleVoicePhrase value)
{
    static const char* enumerationLiterals[] = {
        "SAMPLE_PHRASE__GUIDANCE_WILL_BE_AT_THIS_VOLUME",
        "SAMPLE_PHRASE__LOUDER",
        "SAMPLE_PHRASE__QUIETER",
        "SAMPLE_PHRASE__VOICE_OUTPUT",
    };

    if (SampleVoicePhrase_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool SampleVoicePhrase_IsValid (SampleVoicePhrase value)
{
    switch (value) {
    case SampleVoicePhrase__SAMPLE_PHRASE__GUIDANCE_WILL_BE_AT_THIS_VOLUME:
    case SampleVoicePhrase__SAMPLE_PHRASE__LOUDER:
    case SampleVoicePhrase__SAMPLE_PHRASE__QUIETER:
    case SampleVoicePhrase__SAMPLE_PHRASE__VOICE_OUTPUT:
        return true;
    default:
        return false;
    }
}

bool ETCStatus_Parse (const char *str, size_t length, ETCStatus &value)
{
    static stringEntry entries[] = {
        {5,"ERROR", 2U},
        {6,"ACTIVE", 1U},
        {8,"INACTIVE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* ETCStatus_Name (ETCStatus value)
{
    static const char* enumerationLiterals[] = {
        "INACTIVE",
        "ACTIVE",
        "ERROR",
    };

    if (ETCStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ETCStatus_IsValid (ETCStatus value)
{
    switch (value) {
    case ETCStatus__INACTIVE:
    case ETCStatus__ACTIVE:
    case ETCStatus__ERROR:
        return true;
    default:
        return false;
    }
}

bool TrafficEnforcementAlertState_Parse (const char *str, size_t length, TrafficEnforcementAlertState &value)
{
    static stringEntry entries[] = {
        {5,"ALERT", 2U},
        {8,"NO_ALERT", 0U},
        {9,"PRE_ALERT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* TrafficEnforcementAlertState_Name (TrafficEnforcementAlertState value)
{
    static const char* enumerationLiterals[] = {
        "NO_ALERT",
        "PRE_ALERT",
        "ALERT",
    };

    if (TrafficEnforcementAlertState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TrafficEnforcementAlertState_IsValid (TrafficEnforcementAlertState value)
{
    switch (value) {
    case TrafficEnforcementAlertState__NO_ALERT:
    case TrafficEnforcementAlertState__PRE_ALERT:
    case TrafficEnforcementAlertState__ALERT:
        return true;
    default:
        return false;
    }
}

bool TrafficEnforcementCameraType_Parse (const char *str, size_t length, TrafficEnforcementCameraType &value)
{
    static stringEntry entries[] = {
        {4,"FAKE", 8U},
        {5,"OTHER", 10U},
        {7,"BUSLANE", 7U},
        {8,"PECCANCY", 4U},
        {8,"REDLIGHT", 2U},
        {9,"RISK_ZONE", 16U},
        {9,"TOLL_ROAD", 3U},
        {11,"DANGER_ZONE", 13U},
        {11,"FIXED_SPEED", 0U},
        {12,"MOBILE_SPEED", 1U},
        {12,"SPECIAL_LANE", 5U},
        {17,"PARKING_VIOLATION", 9U},
        {17,"RESTRICTED_ACCESS", 17U},
        {18,"AVERAGE_SPEED_ZONE", 11U},
        {22,"SPEED_ENFORCEMENT_ZONE", 12U},
        {23,"ACCIDENT_BLACKSPOT_ZONE", 15U},
        {24,"FIXED_SPEED_AND_REDLIGHT", 6U},
        {25,"MOBILE_SPEED_HOTSPOT_ZONE", 14U},
    };

    return lookupInStringEntryTable (str, length, entries, 18, (unsigned int&) value);
}

const char* TrafficEnforcementCameraType_Name (TrafficEnforcementCameraType value)
{
    static const char* enumerationLiterals[] = {
        "FIXED_SPEED",
        "MOBILE_SPEED",
        "REDLIGHT",
        "TOLL_ROAD",
        "PECCANCY",
        "SPECIAL_LANE",
        "FIXED_SPEED_AND_REDLIGHT",
        "BUSLANE",
        "FAKE",
        "PARKING_VIOLATION",
        "OTHER",
        "AVERAGE_SPEED_ZONE",
        "SPEED_ENFORCEMENT_ZONE",
        "DANGER_ZONE",
        "MOBILE_SPEED_HOTSPOT_ZONE",
        "ACCIDENT_BLACKSPOT_ZONE",
        "RISK_ZONE",
        "RESTRICTED_ACCESS",
    };

    if (TrafficEnforcementCameraType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TrafficEnforcementCameraType_IsValid (TrafficEnforcementCameraType value)
{
    switch (value) {
    case TrafficEnforcementCameraType__FIXED_SPEED:
    case TrafficEnforcementCameraType__MOBILE_SPEED:
    case TrafficEnforcementCameraType__REDLIGHT:
    case TrafficEnforcementCameraType__TOLL_ROAD:
    case TrafficEnforcementCameraType__PECCANCY:
    case TrafficEnforcementCameraType__SPECIAL_LANE:
    case TrafficEnforcementCameraType__FIXED_SPEED_AND_REDLIGHT:
    case TrafficEnforcementCameraType__BUSLANE:
    case TrafficEnforcementCameraType__FAKE:
    case TrafficEnforcementCameraType__PARKING_VIOLATION:
    case TrafficEnforcementCameraType__OTHER:
    case TrafficEnforcementCameraType__AVERAGE_SPEED_ZONE:
    case TrafficEnforcementCameraType__SPEED_ENFORCEMENT_ZONE:
    case TrafficEnforcementCameraType__DANGER_ZONE:
    case TrafficEnforcementCameraType__MOBILE_SPEED_HOTSPOT_ZONE:
    case TrafficEnforcementCameraType__ACCIDENT_BLACKSPOT_ZONE:
    case TrafficEnforcementCameraType__RISK_ZONE:
    case TrafficEnforcementCameraType__RESTRICTED_ACCESS:
        return true;
    default:
        return false;
    }
}

bool TrafficEnforcementDistanceType_Parse (const char *str, size_t length, TrafficEnforcementDistanceType &value)
{
    static stringEntry entries[] = {
        {11,"TO_ZONE_END", 1U},
        {13,"TO_ZONE_BEGIN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* TrafficEnforcementDistanceType_Name (TrafficEnforcementDistanceType value)
{
    static const char* enumerationLiterals[] = {
        "TO_ZONE_BEGIN",
        "TO_ZONE_END",
    };

    if (TrafficEnforcementDistanceType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TrafficEnforcementDistanceType_IsValid (TrafficEnforcementDistanceType value)
{
    switch (value) {
    case TrafficEnforcementDistanceType__TO_ZONE_BEGIN:
    case TrafficEnforcementDistanceType__TO_ZONE_END:
        return true;
    default:
        return false;
    }
}

bool TrafficMessageSource_Parse (const char *str, size_t length, TrafficMessageSource &value)
{
    static stringEntry entries[] = {
        {6,"UNKOWN", 0U},
        {9,"TMC_TUNER", 2U},
        {15,"CONNECT_TRAFFIC", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* TrafficMessageSource_Name (TrafficMessageSource value)
{
    static const char* enumerationLiterals[] = {
        "UNKOWN",
        "CONNECT_TRAFFIC",
        "TMC_TUNER",
    };

    if (TrafficMessageSource_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool TrafficMessageSource_IsValid (TrafficMessageSource value)
{
    switch (value) {
    case TrafficMessageSource__UNKOWN:
    case TrafficMessageSource__CONNECT_TRAFFIC:
    case TrafficMessageSource__TMC_TUNER:
        return true;
    default:
        return false;
    }
}

bool OSPSettingType_Parse (const char *str, size_t length, OSPSettingType &value)
{
    static stringEntry entries[] = {
        {12,"TRAFFIC_SIGN", 0U},
        {17,"RISK_AREA_DISPLAY", 2U},
        {21,"RISK_AREA_SOUND_ALERT", 3U},
        {22,"OVER_SPEED_SOUND_ALERT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* OSPSettingType_Name (OSPSettingType value)
{
    static const char* enumerationLiterals[] = {
        "TRAFFIC_SIGN",
        "OVER_SPEED_SOUND_ALERT",
        "RISK_AREA_DISPLAY",
        "RISK_AREA_SOUND_ALERT",
    };

    if (OSPSettingType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool OSPSettingType_IsValid (OSPSettingType value)
{
    switch (value) {
    case OSPSettingType__TRAFFIC_SIGN:
    case OSPSettingType__OVER_SPEED_SOUND_ALERT:
    case OSPSettingType__RISK_AREA_DISPLAY:
    case OSPSettingType__RISK_AREA_SOUND_ALERT:
        return true;
    default:
        return false;
    }
}

bool JamAheadActivityStatus_Parse (const char *str, size_t length, JamAheadActivityStatus &value)
{
    static stringEntry entries[] = {
        {6,"ACTIVE", 1U},
        {8,"INACTIVE", 0U},
        {18,"NO_DETOUR_POSSIBLE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* JamAheadActivityStatus_Name (JamAheadActivityStatus value)
{
    static const char* enumerationLiterals[] = {
        "INACTIVE",
        "ACTIVE",
        "NO_DETOUR_POSSIBLE",
    };

    if (JamAheadActivityStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool JamAheadActivityStatus_IsValid (JamAheadActivityStatus value)
{
    switch (value) {
    case JamAheadActivityStatus__INACTIVE:
    case JamAheadActivityStatus__ACTIVE:
    case JamAheadActivityStatus__NO_DETOUR_POSSIBLE:
        return true;
    default:
        return false;
    }
}

bool FixedPOICategory_Parse (const char *str, size_t length, FixedPOICategory &value)
{
    static stringEntry entries[] = {
        {3,"ATM", 1U},
        {7,"PARKING", 7U},
        {8,"HOSPITAL", 3U},
        {9,"UNDEFINED", 0U},
        {10,"RESTAURANT", 9U},
        {11,"HOTEL_MOTEL", 4U},
        {13,"MOTORWAY_EXIT", 6U},
        {14,"MOTORWAY_ENTRY", 5U},
        {14,"PETROL_STATION", 8U},
        {14,"VEHICLE_REPAIR", 10U},
        {19,"EV_CHARGING_STATION", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* FixedPOICategory_Name (FixedPOICategory value)
{
    static const char* enumerationLiterals[] = {
        "UNDEFINED",
        "ATM",
        "EV_CHARGING_STATION",
        "HOSPITAL",
        "HOTEL_MOTEL",
        "MOTORWAY_ENTRY",
        "MOTORWAY_EXIT",
        "PARKING",
        "PETROL_STATION",
        "RESTAURANT",
        "VEHICLE_REPAIR",
    };

    if (FixedPOICategory_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool FixedPOICategory_IsValid (FixedPOICategory value)
{
    switch (value) {
    case FixedPOICategory__UNDEFINED:
    case FixedPOICategory__ATM:
    case FixedPOICategory__EV_CHARGING_STATION:
    case FixedPOICategory__HOSPITAL:
    case FixedPOICategory__HOTEL_MOTEL:
    case FixedPOICategory__MOTORWAY_ENTRY:
    case FixedPOICategory__MOTORWAY_EXIT:
    case FixedPOICategory__PARKING:
    case FixedPOICategory__PETROL_STATION:
    case FixedPOICategory__RESTAURANT:
    case FixedPOICategory__VEHICLE_REPAIR:
        return true;
    default:
        return false;
    }
}

bool LocationType_Parse (const char *str, size_t length, LocationType &value)
{
    static stringEntry entries[] = {
        {8,"WAYPOINT", 1U},
        {11,"DESTINATION", 2U},
        {24,"CURRENT_VEHICLE_POSITION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* LocationType_Name (LocationType value)
{
    static const char* enumerationLiterals[] = {
        "CURRENT_VEHICLE_POSITION",
        "WAYPOINT",
        "DESTINATION",
    };

    if (LocationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool LocationType_IsValid (LocationType value)
{
    switch (value) {
    case LocationType__CURRENT_VEHICLE_POSITION:
    case LocationType__WAYPOINT:
    case LocationType__DESTINATION:
        return true;
    default:
        return false;
    }
}

bool ConsumptionUnit_Parse (const char *str, size_t length, ConsumptionUnit &value)
{
    static stringEntry entries[] = {
        {10,"MICROLITER", 0U},
        {10,"WATTMINUTE", 2U},
        {10,"WATTSECOND", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* ConsumptionUnit_Name (ConsumptionUnit value)
{
    static const char* enumerationLiterals[] = {
        "MICROLITER",
        "WATTSECOND",
        "WATTMINUTE",
    };

    if (ConsumptionUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ConsumptionUnit_IsValid (ConsumptionUnit value)
{
    switch (value) {
    case ConsumptionUnit__MICROLITER:
    case ConsumptionUnit__WATTSECOND:
    case ConsumptionUnit__WATTMINUTE:
        return true;
    default:
        return false;
    }
}

bool ScreenTransition_Parse (const char *str, size_t length, ScreenTransition &value)
{
    static stringEntry entries[] = {
        {15,"MAIN_MAP_SCREEN", 2U},
        {17,"ROUTE_INFO_SCREEN", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* ScreenTransition_Name (ScreenTransition value)
{
    static const char* enumerationLiterals[] = {
        "ROUTE_INFO_SCREEN",
        "MAIN_MAP_SCREEN",
    };

    if (ScreenTransition_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool ScreenTransition_IsValid (ScreenTransition value)
{
    switch (value) {
    case ScreenTransition__ROUTE_INFO_SCREEN:
    case ScreenTransition__MAIN_MAP_SCREEN:
        return true;
    default:
        return false;
    }
}

bool DestinationReachedStatus_Parse (const char *str, size_t length, DestinationReachedStatus &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {8,"WAYPOINT", 1U},
        {16,"WAYPOINT_SKIPPED", 3U},
        {17,"FINAL_DESTINATION", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* DestinationReachedStatus_Name (DestinationReachedStatus value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "WAYPOINT",
        "FINAL_DESTINATION",
        "WAYPOINT_SKIPPED",
    };

    if (DestinationReachedStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DestinationReachedStatus_IsValid (DestinationReachedStatus value)
{
    switch (value) {
    case DestinationReachedStatus__UNKNOWN:
    case DestinationReachedStatus__WAYPOINT:
    case DestinationReachedStatus__FINAL_DESTINATION:
    case DestinationReachedStatus__WAYPOINT_SKIPPED:
        return true;
    default:
        return false;
    }
}

bool WaypointOperationStatus_Parse (const char *str, size_t length, WaypointOperationStatus &value)
{
    static stringEntry entries[] = {
        {5,"MOVED", 2U},
        {7,"DELETED", 1U},
        {8,"INSERTED", 0U},
        {8,"REPLACED", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* WaypointOperationStatus_Name (WaypointOperationStatus value)
{
    static const char* enumerationLiterals[] = {
        "INSERTED",
        "DELETED",
        "MOVED",
        "REPLACED",
    };

    if (WaypointOperationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool WaypointOperationStatus_IsValid (WaypointOperationStatus value)
{
    switch (value) {
    case WaypointOperationStatus__INSERTED:
    case WaypointOperationStatus__DELETED:
    case WaypointOperationStatus__MOVED:
    case WaypointOperationStatus__REPLACED:
        return true;
    default:
        return false;
    }
}

bool LightModeStatus_Parse (const char *str, size_t length, LightModeStatus &value)
{
    static stringEntry entries[] = {
        {3,"DAY", 0U},
        {5,"NIGHT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* LightModeStatus_Name (LightModeStatus value)
{
    static const char* enumerationLiterals[] = {
        "DAY",
        "NIGHT",
    };

    if (LightModeStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool LightModeStatus_IsValid (LightModeStatus value)
{
    switch (value) {
    case LightModeStatus__DAY:
    case LightModeStatus__NIGHT:
        return true;
    default:
        return false;
    }
}

bool DestinationMemoryAddressType_Parse (const char *str, size_t length, DestinationMemoryAddressType &value)
{
    static stringEntry entries[] = {
        {22,"DESTINATION_MEMORY_POI", 6U},
        {23,"DESTINATION_MEMORY_CITY", 2U},
        {24,"DESTINATION_MEMORY_STATE", 1U},
        {25,"DESTINATION_MEMORY_STREET", 3U},
        {26,"DESTINATION_MEMORY_COUNTRY", 0U},
        {26,"DESTINATION_MEMORY_HOUSENO", 4U},
        {27,"DESTINATION_MEMORY_JUNCTION", 5U},
        {28,"DESTINATION_MEMORY_POI_BRAND", 8U},
        {31,"DESTINATION_MEMORY_COUNTRY_CODE", 9U},
        {31,"DESTINATION_MEMORY_POI_CATEGORY", 7U},
        {33,"DESTINATION_MEMORY_ADDRESS_DETAIL", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* DestinationMemoryAddressType_Name (DestinationMemoryAddressType value)
{
    static const char* enumerationLiterals[] = {
        "DESTINATION_MEMORY_COUNTRY",
        "DESTINATION_MEMORY_STATE",
        "DESTINATION_MEMORY_CITY",
        "DESTINATION_MEMORY_STREET",
        "DESTINATION_MEMORY_HOUSENO",
        "DESTINATION_MEMORY_JUNCTION",
        "DESTINATION_MEMORY_POI",
        "DESTINATION_MEMORY_POI_CATEGORY",
        "DESTINATION_MEMORY_POI_BRAND",
        "DESTINATION_MEMORY_COUNTRY_CODE",
        "DESTINATION_MEMORY_ADDRESS_DETAIL",
    };

    if (DestinationMemoryAddressType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool DestinationMemoryAddressType_IsValid (DestinationMemoryAddressType value)
{
    switch (value) {
    case DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_STATE:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_CITY:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_STREET:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_HOUSENO:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_JUNCTION:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_POI:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_POI_CATEGORY:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_POI_BRAND:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY_CODE:
    case DestinationMemoryAddressType__DESTINATION_MEMORY_ADDRESS_DETAIL:
        return true;
    default:
        return false;
    }
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
