#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICE_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICE_H

#include "asf/core/Blob.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "org.bosch.cm.navigation.NavigationService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

// method IDs
static const uint16 ID_selectPoiCategoryShortcut = 0;
static const uint16 ID_getPoiCategoryShortcuts = 1;
static const uint16 ID_setLocationWithCoordinates = 2;
static const uint16 ID_setLocationWithDetails = 3;
static const uint16 ID_showPOILocationFromTCU = 4;
static const uint16 ID_storePOILocationToAddressBook = 5;
static const uint16 ID_storeLocationToAddressBook = 6;
static const uint16 ID_showDestinationOverviewFromTCU = 7;
static const uint16 ID_showCalculateTour = 8;
static const uint16 ID_showOnMap = 9;
static const uint16 ID_showCarsorLocationOnMap = 10;
static const uint16 ID_showCityInputAndGetCityCoordinates = 11;
static const uint16 ID_requestLocationDetailsForCoordinates = 12;
static const uint16 ID_showAdjustCurrentLocationScreen = 13;
static const uint16 ID_showWhereAmIScreen = 14;
static const uint16 ID_showTrafficInfoScreen = 15;
static const uint16 ID_showMapScreenWithMapViewMode = 16;
static const uint16 ID_showMapScreenCarsorLockMode = 17;
static const uint16 ID_showDeleteWaypointListScreen = 18;
static const uint16 ID_setZoomInStep = 19;
static const uint16 ID_setZoomOutStep = 20;
static const uint16 ID_setZoomLevel = 21;
static const uint16 ID_getVersionString = 22;
static const uint16 ID_setSXMTravelLinkSubscriptionStatus = 23;
static const uint16 ID_startGuidance = 24;
static const uint16 ID_startGuidanceToPosWGS84 = 25;
static const uint16 ID_startGuidanceToHomeLocation = 26;
static const uint16 ID_startGuidanceToWorkLocation = 27;
static const uint16 ID_setLocationWithDestinationMemoryEntry = 28;
static const uint16 ID_cancelRouteGuidance = 29;
static const uint16 ID_insertWaypoint = 30;
static const uint16 ID_insertWaypointAtDefaultPosition = 31;
static const uint16 ID_replaceWaypoint = 32;
static const uint16 ID_deleteWaypoints = 33;
static const uint16 ID_applyWaypointListChange = 34;
static const uint16 ID_requestWaypointList = 35;
static const uint16 ID_requestSetFreeTextSearchType = 36;
static const uint16 ID_requestFreeTextSearchResults = 37;
static const uint16 ID_undoFreeTextSearchElementSelection = 38;
static const uint16 ID_setLocationWithFreeTextSearchInput = 39;
static const uint16 ID_showDestinationFreeTextSearchInput = 40;
static const uint16 ID_requestFixedPOICategorySearchResults = 41;
static const uint16 ID_undoSetLocationWithFixedPOICategoryInput = 42;
static const uint16 ID_setLocationWithFixedPOICategoryInput = 43;
static const uint16 ID_sdsCheckAddress = 44;
static const uint16 ID_sdsGetRefinementList = 45;
static const uint16 ID_selectSdsRefinement = 46;
static const uint16 ID_setLocationWithSdsInput = 47;
static const uint16 ID_requestDestinationMemoryEntries = 48;
static const uint16 ID_setMapRepresentation = 49;
static const uint16 ID_requestDetailsForSelectedLocation = 50;
static const uint16 ID_retriggerAcousticOutput = 51;
static const uint16 ID_speakSamplePhrase = 52;
static const uint16 ID_setRouteCriterion = 53;
static const uint16 ID_setVoiceGuidance = 54;
static const uint16 ID_CheckNavDataCompatibility = 55;
static const uint16 ID_sdsUpdateVoiceTag = 56;
static const uint16 ID_sdsGetHouseNumberPattern = 57;
static const uint16 ID_setMapLightMode = 58;
static const uint16 ID_startTripReplay = 59;
static const uint16 ID_stopTripReplay = 60;
static const uint16 ID_seekTripReplay = 61;
static const uint16 ID_setTripReplayMode = 62;
static const uint16 ID_showLocationSelectionAndGetAddressDetails = 63;
static const uint16 ID_showRouteCalculationToDestination = 64;
static const uint16 ID_requestJamAheadList = 65;
static const uint16 ID_releaseJamAheadList = 66;
static const uint16 ID_selectJamAheadListEntry = 67;
static const uint16 ID_activateNonPremiumTMC = 68;
static const uint16 ID_deactivateNonPremiumTMC = 69;
static const uint16 ID_cancelJamAhead = 70;
static const uint16 ID_requestDetailsForSelectedCoordinateWithRadius = 71;
static const uint16 ID_showAndSetLocationWithDetails = 72;

// signal IDs

// property IDs
static const uint16 ID_navStatus = 73;
static const uint16 ID_datasetVersion = 74;
static const uint16 ID_nonPremiumTMCStatus = 75;
static const uint16 ID_currentFreeTextSearchInfo = 76;
static const uint16 ID_positionInformation = 77;
static const uint16 ID_distanceToDestination = 78;
static const uint16 ID_currentStreet = 79;
static const uint16 ID_turntoStreet = 80;
static const uint16 ID_roundaboutExitNumber = 81;
static const uint16 ID_nextTurntoStreet = 82;
static const uint16 ID_barGraphInfo = 83;
static const uint16 ID_maneuverSymbol = 84;
static const uint16 ID_satelliteInfo = 85;
static const uint16 ID_destinationInformation = 86;
static const uint16 ID_routeCalculationDuration = 87;
static const uint16 ID_homeLocation = 88;
static const uint16 ID_workLocation = 89;
static const uint16 ID_mapRepresentation = 90;
static const uint16 ID_sdsAddressWithOptions = 91;
static const uint16 ID_waypointList = 92;
static const uint16 ID_maneuverView = 93;
static const uint16 ID_intersectionMapCarsorPosition = 94;
static const uint16 ID_speedLimit = 95;
static const uint16 ID_trafficEnforcement = 96;
static const uint16 ID_nextManeuverDetails = 97;
static const uint16 ID_laneRecommendationList = 98;
static const uint16 ID_arrivalInformationList = 99;
static const uint16 ID_intersectionMap = 100;
static const uint16 ID_isAddressBookChanged = 101;
static const uint16 ID_isMaxAllowedAddressBookEntriesStored = 102;
static const uint16 ID_isLastDestinationListChanged = 103;
static const uint16 ID_isVoiceGuidanceActive = 104;
static const uint16 ID_sdsVoiceTagWithOptions = 105;
static const uint16 ID_trafficMessagesCount = 106;
static const uint16 ID_trafficServiceReceptionStatus = 107;
static const uint16 ID_sdsPOICategoryShortcuts = 108;
static const uint16 ID_menuPoiCategoryShortcuts = 109;
static const uint16 ID_tripReplayStatusInfo = 110;
static const uint16 ID_etcStatus = 111;
static const uint16 ID_TrafficSignInfoActive = 112;
static const uint16 ID_OverSpeedSoundAlertInfoActive = 113;
static const uint16 ID_routeRecalculationReason = 114;
static const uint16 ID_RiskAreaDisplayInfoActive = 115;
static const uint16 ID_RiskAreaSoundAlertInfoActive = 116;
static const uint16 ID_jamAheadList = 117;
static const uint16 ID_waypointOperationStatusList = 118;
static const uint16 ID_destinationReachedStatus = 119;
static const uint16 ID_lightModeStatus = 120;
static const uint16 ID_mapCameraData = 121;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class OSPSetting;

class TrafficServiceReceptionStatus;

class TurnToStreet;

class DistanceToDestination;

class BarGraphInfo;

class PositionWGS84;

class Location;

class Image;

class POILocation;

class TourElement;

class CurrentFreeTextSearchInfo;

class PositionInformation;

class SatelliteInfo;

class SDSElementOptions;

class SDSAddressOptions;

class SDSAddressElement;

class SDSAddressWithOptions;

class DestinationInfoElement;

class RefinementListElement;

class GlobalUpdateRegionId;

class GlobalNamedObjectId;

class AddressListElement;

class DeformedImage;

class WaypointListElement;

class ManeuverView;

class ScreenCoordinate;

class IntersectionMapRoadLine;

class IntersectionMap;

class IntersectionMapCarsorPosition;

class SpeedLimit;

class TrafficEnforcement;

class RouteCalculationDuration;

class LaneRecommendation;

class ArrivalInformation;

class NextManeuverDetails;

class PoiCategoryShortcut;

class LocationDetails;

class DestinationMemoryEntry;

class DestinationMemoryEntryItem;

class DestinationMemoryEntryDetails;

class DestinationMemoryDetailListElement;

class SDSVoiceTagId;

class TripReplayStatusInfo;

class JamAheadListElement;

class JamAheadList;

class MapCameraData;

class SelectPoiCategoryShortcutRequest;

class GetPoiCategoryShortcutsResponse;

class SetLocationWithCoordinatesRequest;

class SetLocationWithDetailsRequest;

class ShowPOILocationFromTCURequest;

class StorePOILocationToAddressBookRequest;

class StoreLocationToAddressBookRequest;

class ShowDestinationOverviewFromTCURequest;

class ShowCalculateTourRequest;

class ShowOnMapRequest;

class ShowCityInputAndGetCityCoordinatesResponse;

class RequestLocationDetailsForCoordinatesRequest;

class RequestLocationDetailsForCoordinatesResponse;

class ShowMapScreenWithMapViewModeRequest;

class ShowMapScreenCarsorLockModeRequest;

class SetZoomInStepRequest;

class SetZoomOutStepRequest;

class SetZoomLevelRequest;

class GetVersionStringResponse;

class SetSXMTravelLinkSubscriptionStatusRequest;

class StartGuidanceToPosWGS84Request;

class SetLocationWithDestinationMemoryEntryRequest;

class InsertWaypointRequest;

class ReplaceWaypointRequest;

class DeleteWaypointsRequest;

class RequestSetFreeTextSearchTypeRequest;

class RequestFreeTextSearchResultsRequest;

class RequestFreeTextSearchResultsResponse;

class SetLocationWithFreeTextSearchInputRequest;

class ShowDestinationFreeTextSearchInputRequest;

class RequestFixedPOICategorySearchResultsRequest;

class RequestFixedPOICategorySearchResultsResponse;

class SetLocationWithFixedPOICategoryInputRequest;

class SdsCheckAddressRequest;

class SdsGetRefinementListRequest;

class SdsGetRefinementListResponse;

class SelectSdsRefinementRequest;

class RequestDestinationMemoryEntriesRequest;

class RequestDestinationMemoryEntriesResponse;

class SetMapRepresentationRequest;

class RequestDetailsForSelectedLocationResponse;

class SpeakSamplePhraseRequest;

class SetRouteCriterionRequest;

class SetVoiceGuidanceRequest;

class CheckNavDataCompatibilityRequest;

class CheckNavDataCompatibilityResponse;

class SdsUpdateVoiceTagRequest;

class SdsGetHouseNumberPatternResponse;

class SetMapLightModeRequest;

class StartTripReplayRequest;

class SeekTripReplayRequest;

class SetTripReplayModeRequest;

class ShowLocationSelectionAndGetAddressDetailsResponse;

class SelectJamAheadListEntryRequest;

class RequestDetailsForSelectedCoordinateWithRadiusRequest;

class RequestDetailsForSelectedCoordinateWithRadiusResponse;

class ShowAndSetLocationWithDetailsRequest;

class NavStatusUpdate;

class NavStatusRegister;

class DatasetVersionUpdate;

class DatasetVersionRegister;

class NonPremiumTMCStatusUpdate;

class NonPremiumTMCStatusRegister;

class CurrentFreeTextSearchInfoUpdate;

class CurrentFreeTextSearchInfoRegister;

class PositionInformationUpdate;

class PositionInformationRegister;

class DistanceToDestinationUpdate;

class DistanceToDestinationRegister;

class CurrentStreetUpdate;

class CurrentStreetRegister;

class TurntoStreetUpdate;

class TurntoStreetRegister;

class RoundaboutExitNumberUpdate;

class RoundaboutExitNumberRegister;

class NextTurntoStreetUpdate;

class NextTurntoStreetRegister;

class BarGraphInfoUpdate;

class BarGraphInfoRegister;

class ManeuverSymbolUpdate;

class ManeuverSymbolRegister;

class SatelliteInfoUpdate;

class SatelliteInfoRegister;

class DestinationInformationUpdate;

class DestinationInformationRegister;

class RouteCalculationDurationUpdate;

class RouteCalculationDurationRegister;

class HomeLocationUpdate;

class HomeLocationRegister;

class WorkLocationUpdate;

class WorkLocationRegister;

class MapRepresentationUpdate;

class MapRepresentationRegister;

class SdsAddressWithOptionsUpdate;

class SdsAddressWithOptionsRegister;

class WaypointListUpdate;

class WaypointListRegister;

class ManeuverViewUpdate;

class ManeuverViewRegister;

class IntersectionMapCarsorPositionUpdate;

class IntersectionMapCarsorPositionRegister;

class SpeedLimitUpdate;

class SpeedLimitRegister;

class TrafficEnforcementUpdate;

class TrafficEnforcementRegister;

class NextManeuverDetailsUpdate;

class NextManeuverDetailsRegister;

class LaneRecommendationListUpdate;

class LaneRecommendationListRegister;

class ArrivalInformationListUpdate;

class ArrivalInformationListRegister;

class IntersectionMapUpdate;

class IntersectionMapRegister;

class IsAddressBookChangedUpdate;

class IsAddressBookChangedRegister;

class IsMaxAllowedAddressBookEntriesStoredUpdate;

class IsMaxAllowedAddressBookEntriesStoredRegister;

class IsLastDestinationListChangedUpdate;

class IsLastDestinationListChangedRegister;

class IsVoiceGuidanceActiveUpdate;

class IsVoiceGuidanceActiveRegister;

class SdsVoiceTagWithOptionsUpdate;

class SdsVoiceTagWithOptionsRegister;

class TrafficMessagesCountUpdate;

class TrafficMessagesCountRegister;

class TrafficServiceReceptionStatusUpdate;

class TrafficServiceReceptionStatusRegister;

class SdsPOICategoryShortcutsUpdate;

class SdsPOICategoryShortcutsRegister;

class MenuPoiCategoryShortcutsUpdate;

class MenuPoiCategoryShortcutsRegister;

class TripReplayStatusInfoUpdate;

class TripReplayStatusInfoRegister;

class EtcStatusUpdate;

class EtcStatusRegister;

class TrafficSignInfoActiveUpdate;

class TrafficSignInfoActiveRegister;

class OverSpeedSoundAlertInfoActiveUpdate;

class OverSpeedSoundAlertInfoActiveRegister;

class RouteRecalculationReasonUpdate;

class RouteRecalculationReasonRegister;

class RiskAreaDisplayInfoActiveUpdate;

class RiskAreaDisplayInfoActiveRegister;

class RiskAreaSoundAlertInfoActiveUpdate;

class RiskAreaSoundAlertInfoActiveRegister;

class JamAheadListUpdate;

class JamAheadListRegister;

class WaypointOperationStatusListUpdate;

class WaypointOperationStatusListRegister;

class DestinationReachedStatusUpdate;

class DestinationReachedStatusRegister;

class LightModeStatusUpdate;

class LightModeStatusRegister;

class MapCameraDataUpdate;

class MapCameraDataRegister;

// type definitions
/**
 * Request to show the nearby POI category
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectPoiCategoryShortcutResponse;

/**
 * If the meaning of "SelectPoiCategoryShortcutError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectPoiCategoryShortcutError;

/**
 * Returns the customized preferred category shortcuts
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPoiCategoryShortcutsRequest;

/**
 * If the meaning of "GetPoiCategoryShortcutsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPoiCategoryShortcutsError;

/**
 * Request to set the latitude and longitude value
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithCoordinatesResponse;

/**
 * If the meaning of "SetLocationWithCoordinatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithCoordinatesError;

/**
 * Request to set the latitude and longitude value and location details for further processing
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithDetailsResponse;

/**
 * If the meaning of "SetLocationWithDetailsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithDetailsError;

/**
 * Request will provide the "Show POI location" from TCU
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowPOILocationFromTCUResponse;

/**
 * If the meaning of "ShowPOILocationFromTCUError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowPOILocationFromTCUError;

/**
 * Request to store POI location to navigation address book
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StorePOILocationToAddressBookResponse;

/**
 * If the meaning of "StorePOILocationToAddressBookError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StorePOILocationToAddressBookError;

/**
 * Request to store location to navigation address book
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StoreLocationToAddressBookResponse;

/**
 * If the meaning of "StoreLocationToAddressBookError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StoreLocationToAddressBookError;

/**
 * Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowDestinationOverviewFromTCUResponse;

/**
 * If the meaning of "ShowDestinationOverviewFromTCUError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowDestinationOverviewFromTCUError;

/**
 * Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowCalculateTourResponse;

/**
 * If the meaning of "ShowCalculateTourError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowCalculateTourError;

/**
 * Request shows the given location on map
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowOnMapResponse;

/**
 * If the meaning of "ShowOnMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowOnMapError;

/**
 * Request shows the carsor Location on map
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowCarsorLocationOnMapRequest;

/**
 * Request shows the carsor Location on map
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowCarsorLocationOnMapResponse;

/**
 * If the meaning of "ShowCarsorLocationOnMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowCarsorLocationOnMapError;

/**
 * Request will respond with City center coordinates
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowCityInputAndGetCityCoordinatesRequest;

/**
 * If the meaning of "ShowCityInputAndGetCityCoordinatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowCityInputAndGetCityCoordinatesError;

/**
 * If the meaning of "RequestLocationDetailsForCoordinatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestLocationDetailsForCoordinatesError;

/**
 * Method shows the screen to adjust the current location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowAdjustCurrentLocationScreenRequest;

/**
 * Method shows the screen to adjust the current location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowAdjustCurrentLocationScreenResponse;

/**
 * If the meaning of "ShowAdjustCurrentLocationScreenError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowAdjustCurrentLocationScreenError;

/**
 * method to show the current position
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowWhereAmIScreenRequest;

/**
 * method to show the current position
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowWhereAmIScreenResponse;

/**
 * If the meaning of "ShowWhereAmIScreenError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowWhereAmIScreenError;

/**
 * method to handle traffic data validation to show error pop up or traffic info screen
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowTrafficInfoScreenRequest;

/**
 * method to handle traffic data validation to show error pop up or traffic info screen
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowTrafficInfoScreenResponse;

/**
 * If the meaning of "ShowTrafficInfoScreenError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowTrafficInfoScreenError;

/**
 * Request to show map screen with the given settings for MapViewMode
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowMapScreenWithMapViewModeResponse;

/**
 * If the meaning of "ShowMapScreenWithMapViewModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowMapScreenWithMapViewModeError;

/**
 * Request to show map screen with carsor locked mode
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowMapScreenCarsorLockModeResponse;

/**
 * If the meaning of "ShowMapScreenCarsorLockModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowMapScreenCarsorLockModeError;

/**
 * Method shows the screen to modify  waypoint list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowDeleteWaypointListScreenRequest;

/**
 * Method shows the screen to modify  waypoint list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowDeleteWaypointListScreenResponse;

/**
 * If the meaning of "ShowDeleteWaypointListScreenError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowDeleteWaypointListScreenError;

/**
 * Request to zoom in the given step count
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetZoomInStepResponse;

/**
 * If the meaning of "SetZoomInStepError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetZoomInStepError;

/**
 * Request to zoom out the given step count
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetZoomOutStepResponse;

/**
 * If the meaning of "SetZoomOutStepError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetZoomOutStepError;

/**
 * Request zooms to the given zoom level
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetZoomLevelResponse;

/**
 * If the meaning of "SetZoomLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetZoomLevelError;

/**
 * Request will respond with the current NavMiddleware version string
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetVersionStringRequest;

/**
 * If the meaning of "GetVersionStringError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetVersionStringError;

/**
 * Request will set the SXM travel link subscription status
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetSXMTravelLinkSubscriptionStatusResponse;

/**
 * If the meaning of "SetSXMTravelLinkSubscriptionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetSXMTravelLinkSubscriptionStatusError;

/**
 * method to start the guidance with the current LI / SDS destination
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceRequest;

/**
 * method to start the guidance with the current LI / SDS destination
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceResponse;

/**
 * If the meaning of "StartGuidanceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartGuidanceError;

/**
 * Request will start a guidance to the given WGS84 position
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceToPosWGS84Response;

/**
 * If the meaning of "StartGuidanceToPosWGS84Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartGuidanceToPosWGS84Error;

/**
 * method to start the guidance to home location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceToHomeLocationRequest;

/**
 * method to start the guidance to home location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceToHomeLocationResponse;

/**
 * If the meaning of "StartGuidanceToHomeLocationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartGuidanceToHomeLocationError;

/**
 * method to start the guidance to work location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceToWorkLocationRequest;

/**
 * method to start the guidance to work location
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartGuidanceToWorkLocationResponse;

/**
 * If the meaning of "StartGuidanceToWorkLocationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartGuidanceToWorkLocationError;

/**
 * Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithDestinationMemoryEntryResponse;

/**
 * If the meaning of "SetLocationWithDestinationMemoryEntryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithDestinationMemoryEntryError;

/**
 * Request will stop the guidance
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRouteGuidanceRequest;

/**
 * Request will stop the guidance
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRouteGuidanceResponse;

/**
 * If the meaning of "CancelRouteGuidanceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelRouteGuidanceError;

/**
 * Inserts current location as new waypoint in current waypoint list.
 *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage InsertWaypointResponse;

/**
 * If the meaning of "InsertWaypointError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InsertWaypointError;

/**
 * Inserts current location as new waypoint in current waypoint list.
 *        Index: Index internally defined by navigation application.
 *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage InsertWaypointAtDefaultPositionRequest;

/**
 * Inserts current location as new waypoint in current waypoint list.
 *        Index: Index internally defined by navigation application.
 *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage InsertWaypointAtDefaultPositionResponse;

/**
 * If the meaning of "InsertWaypointAtDefaultPositionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InsertWaypointAtDefaultPositionError;

/**
 * Uses current location to replace waypoint
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReplaceWaypointResponse;

/**
 * If the meaning of "ReplaceWaypointError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReplaceWaypointError;

/**
 * Delete the waypoints (including firstIndex and lastIndex)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeleteWaypointsResponse;

/**
 * If the meaning of "DeleteWaypointsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeleteWaypointsError;

/**
 * Uses modified waypoint list and trigger new route calculation
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ApplyWaypointListChangeRequest;

/**
 * Uses modified waypoint list and trigger new route calculation
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ApplyWaypointListChangeResponse;

/**
 * If the meaning of "ApplyWaypointListChangeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ApplyWaypointListChangeError;

/**
 * Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestWaypointListRequest;

/**
 * Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestWaypointListResponse;

/**
 * If the meaning of "RequestWaypointListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestWaypointListError;

/**
 * Request for the free text search location type
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestSetFreeTextSearchTypeResponse;

/**
 * If the meaning of "RequestSetFreeTextSearchTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestSetFreeTextSearchTypeError;

/**
 * If the meaning of "RequestFreeTextSearchResultsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestFreeTextSearchResultsError;

/**
 * Request to clear the free text search elements
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UndoFreeTextSearchElementSelectionRequest;

/**
 * Request to clear the free text search elements
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UndoFreeTextSearchElementSelectionResponse;

/**
 * If the meaning of "UndoFreeTextSearchElementSelectionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UndoFreeTextSearchElementSelectionError;

/**
 * Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithFreeTextSearchInputResponse;

/**
 * If the meaning of "SetLocationWithFreeTextSearchInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithFreeTextSearchInputError;

/**
 * Request will respond with a contextSwitch to Navigation Destination Free text search
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowDestinationFreeTextSearchInputResponse;

/**
 * If the meaning of "ShowDestinationFreeTextSearchInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowDestinationFreeTextSearchInputError;

/**
 * If the meaning of "RequestFixedPOICategorySearchResultsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestFixedPOICategorySearchResultsError;

/**
 * Request to clear the selected element from FixedPOISearch Results list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UndoSetLocationWithFixedPOICategoryInputRequest;

/**
 * Request to clear the selected element from FixedPOISearch Results list
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UndoSetLocationWithFixedPOICategoryInputResponse;

/**
 * If the meaning of "UndoSetLocationWithFixedPOICategoryInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UndoSetLocationWithFixedPOICategoryInputError;

/**
 * Method to choose the selected POI for starting guidance and requesting details
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithFixedPOICategoryInputResponse;

/**
 * If the meaning of "SetLocationWithFixedPOICategoryInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithFixedPOICategoryInputError;

/**
 * Request will validate the given address,
 *        as result it update the attribute sdsAddressWithOptions
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsCheckAddressResponse;

/**
 * If the meaning of "SdsCheckAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsCheckAddressError;

/**
 * If the meaning of "SdsGetRefinementListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsGetRefinementListError;

/**
 * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
 *        As result it update the attribute sdsAddressWithOptions
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectSdsRefinementResponse;

/**
 * If the meaning of "SelectSdsRefinementError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectSdsRefinementError;

/**
 * Request will set the SDS Address as destination or waypoint
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithSdsInputRequest;

/**
 * Request will set the SDS Address as destination or waypoint
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetLocationWithSdsInputResponse;

/**
 * If the meaning of "SetLocationWithSdsInputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLocationWithSdsInputError;

/**
 * If the meaning of "RequestDestinationMemoryEntriesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestDestinationMemoryEntriesError;

/**
 * method to select map representation:  dimension/heading combination
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetMapRepresentationResponse;

/**
 * If the meaning of "SetMapRepresentationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMapRepresentationError;

/**
 * Request will respond with location details for the selected location set via setLocationWithXYZ interface
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestDetailsForSelectedLocationRequest;

/**
 * If the meaning of "RequestDetailsForSelectedLocationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestDetailsForSelectedLocationError;

/**
 * method to retrigger the last voice output (guidance)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RetriggerAcousticOutputRequest;

/**
 * method to retrigger the last voice output (guidance)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RetriggerAcousticOutputResponse;

/**
 * If the meaning of "RetriggerAcousticOutputError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RetriggerAcousticOutputError;

/**
 * method to trigger the sample voice Phrase
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SpeakSamplePhraseResponse;

/**
 * If the meaning of "SpeakSamplePhraseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeakSamplePhraseError;

/**
 * set RouteCriterion settings and apply them to recalculate
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetRouteCriterionResponse;

/**
 * If the meaning of "SetRouteCriterionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetRouteCriterionError;

/**
 * method to set and get the guidance settings element for voice
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetVoiceGuidanceResponse;

/**
 * If the meaning of "SetVoiceGuidanceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetVoiceGuidanceError;

/**
 * If the meaning of "CheckNavDataCompatibilityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CheckNavDataCompatibilityError;

/**
 * Method used to store/delete the VoiceTagId in the destination memory database
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsUpdateVoiceTagResponse;

/**
 * If the meaning of "SdsUpdateVoiceTagError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsUpdateVoiceTagError;

/**
 * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SdsGetHouseNumberPatternRequest;

/**
 * If the meaning of "SdsGetHouseNumberPatternError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsGetHouseNumberPatternError;

/**
 * method to change the MAP color based on light mode request
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetMapLightModeResponse;

/**
 * If the meaning of "SetMapLightModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMapLightModeError;

/**
 * Starts the trip-replay for the given trip-file
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartTripReplayResponse;

/**
 * If the meaning of "StartTripReplayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartTripReplayError;

/**
 * Stops the trip-replay
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopTripReplayRequest;

/**
 * Stops the trip-replay
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StopTripReplayResponse;

/**
 * If the meaning of "StopTripReplayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopTripReplayError;

/**
 * Seeks to the specified location, in the trip-replay
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SeekTripReplayResponse;

/**
 * If the meaning of "SeekTripReplayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SeekTripReplayError;

/**
 * Sets the mode of the trip-replay
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetTripReplayModeResponse;

/**
 * If the meaning of "SetTripReplayModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetTripReplayModeError;

/**
 * Request will respond with Address Details along with Destination Memory Id
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowLocationSelectionAndGetAddressDetailsRequest;

/**
 * If the meaning of "ShowLocationSelectionAndGetAddressDetailsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowLocationSelectionAndGetAddressDetailsError;

/**
 * Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowRouteCalculationToDestinationRequest;

/**
 * Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowRouteCalculationToDestinationResponse;

/**
 * If the meaning of "ShowRouteCalculationToDestinationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowRouteCalculationToDestinationError;

/**
 * Fetch the Possible options to block ahead along with continuous updates
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestJamAheadListRequest;

/**
 * Fetch the Possible options to block ahead along with continuous updates
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestJamAheadListResponse;

/**
 * If the meaning of "RequestJamAheadListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestJamAheadListError;

/**
 * Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseJamAheadListRequest;

/**
 * Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseJamAheadListResponse;

/**
 * If the meaning of "ReleaseJamAheadListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseJamAheadListError;

/**
 * Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SelectJamAheadListEntryResponse;

/**
 * If the meaning of "SelectJamAheadListEntryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SelectJamAheadListEntryError;

/**
 * Request to activate Non Premium TMC
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActivateNonPremiumTMCRequest;

/**
 * Request to activate Non Premium TMC
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActivateNonPremiumTMCResponse;

/**
 * If the meaning of "ActivateNonPremiumTMCError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateNonPremiumTMCError;

/**
 * Request to deactivate Non Premium TMC
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeactivateNonPremiumTMCRequest;

/**
 * Request to deactivate Non Premium TMC
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeactivateNonPremiumTMCResponse;

/**
 * If the meaning of "DeactivateNonPremiumTMCError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeactivateNonPremiumTMCError;

/**
 * Deleting already defined JamAhead
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelJamAheadRequest;

/**
 * Deleting already defined JamAhead
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelJamAheadResponse;

/**
 * If the meaning of "CancelJamAheadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelJamAheadError;

/**
 * If the meaning of "RequestDetailsForSelectedCoordinateWithRadiusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestDetailsForSelectedCoordinateWithRadiusError;

/**
 * Request to set the latitude and longitude value and location details for showing them and for further processing
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ShowAndSetLocationWithDetailsResponse;

/**
 * If the meaning of "ShowAndSetLocationWithDetailsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShowAndSetLocationWithDetailsError;

/**
 * Attribute provides the navigation status like UNKNOWN, BUSY
 */
typedef NavStatusUpdate NavStatusSet;

/**
 * Attribute provides the navigation status like UNKNOWN, BUSY
 */
typedef NavStatusUpdate NavStatusGet;

/**
 * If the meaning of "NavStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NavStatusError;

/**
 * Attribute provides the Navi Data Set version in use
 */
typedef DatasetVersionUpdate DatasetVersionSet;

/**
 * Attribute provides the Navi Data Set version in use
 */
typedef DatasetVersionUpdate DatasetVersionGet;

/**
 * If the meaning of "DatasetVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DatasetVersionError;

/**
 * Attribute provides the non premium TMC status
 */
typedef NonPremiumTMCStatusUpdate NonPremiumTMCStatusSet;

/**
 * Attribute provides the non premium TMC status
 */
typedef NonPremiumTMCStatusUpdate NonPremiumTMCStatusGet;

/**
 * If the meaning of "NonPremiumTMCStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NonPremiumTMCStatusError;

/**
 * Attribute provides freeText search string and position information
 */
typedef CurrentFreeTextSearchInfoUpdate CurrentFreeTextSearchInfoSet;

/**
 * Attribute provides freeText search string and position information
 */
typedef CurrentFreeTextSearchInfoUpdate CurrentFreeTextSearchInfoGet;

/**
 * If the meaning of "CurrentFreeTextSearchInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentFreeTextSearchInfoError;

/**
 * Attribute provides current vehicle position information
 */
typedef PositionInformationUpdate PositionInformationSet;

/**
 * Attribute provides current vehicle position information
 */
typedef PositionInformationUpdate PositionInformationGet;

/**
 * If the meaning of "PositionInformationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PositionInformationError;

/**
 * Attribute provides the distance to destination along with unit information
 */
typedef DistanceToDestinationUpdate DistanceToDestinationSet;

/**
 * Attribute provides the distance to destination along with unit information
 */
typedef DistanceToDestinationUpdate DistanceToDestinationGet;

/**
 * If the meaning of "DistanceToDestinationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DistanceToDestinationError;

/**
 * Attribute provides the current street
 */
typedef CurrentStreetUpdate CurrentStreetSet;

/**
 * Attribute provides the current street
 */
typedef CurrentStreetUpdate CurrentStreetGet;

/**
 * If the meaning of "CurrentStreetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentStreetError;

/**
 * Attribute provides the turn to street info
 */
typedef TurntoStreetUpdate TurntoStreetSet;

/**
 * Attribute provides the turn to street info
 */
typedef TurntoStreetUpdate TurntoStreetGet;

/**
 * If the meaning of "TurntoStreetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TurntoStreetError;

/**
 * Attribute provides the round about Exit Number
 */
typedef RoundaboutExitNumberUpdate RoundaboutExitNumberSet;

/**
 * Attribute provides the round about Exit Number
 */
typedef RoundaboutExitNumberUpdate RoundaboutExitNumberGet;

/**
 * If the meaning of "RoundaboutExitNumberError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RoundaboutExitNumberError;

/**
 * Attribute provides the next turn to street - DEPRECATED (no longer supported)
 */
typedef NextTurntoStreetUpdate NextTurntoStreetSet;

/**
 * Attribute provides the next turn to street - DEPRECATED (no longer supported)
 */
typedef NextTurntoStreetUpdate NextTurntoStreetGet;

/**
 * If the meaning of "NextTurntoStreetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NextTurntoStreetError;

/**
 * Attribute provides barGraph value and state along with unit information
 */
typedef BarGraphInfoUpdate BarGraphInfoSet;

/**
 * Attribute provides barGraph value and state along with unit information
 */
typedef BarGraphInfoUpdate BarGraphInfoGet;

/**
 * If the meaning of "BarGraphInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BarGraphInfoError;

/**
 * Destination straight ahead and further enum values indicate clockwise
 */
typedef ManeuverSymbolUpdate ManeuverSymbolSet;

/**
 * Destination straight ahead and further enum values indicate clockwise
 */
typedef ManeuverSymbolUpdate ManeuverSymbolGet;

/**
 * If the meaning of "ManeuverSymbolError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManeuverSymbolError;

/**
 * Attribute provides satellite sensor information
 */
typedef SatelliteInfoUpdate SatelliteInfoSet;

/**
 * Attribute provides satellite sensor information
 */
typedef SatelliteInfoUpdate SatelliteInfoGet;

/**
 * If the meaning of "SatelliteInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SatelliteInfoError;

/**
 * Attribute provides destination information on the currently guided tour
 */
typedef DestinationInformationUpdate DestinationInformationSet;

/**
 * Attribute provides destination information on the currently guided tour
 */
typedef DestinationInformationUpdate DestinationInformationGet;

/**
 * If the meaning of "DestinationInformationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestinationInformationError;

/**
 * Attribute provides duration of Search and Guidance
 */
typedef RouteCalculationDurationUpdate RouteCalculationDurationSet;

/**
 * Attribute provides duration of Search and Guidance
 */
typedef RouteCalculationDurationUpdate RouteCalculationDurationGet;

/**
 * If the meaning of "RouteCalculationDurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RouteCalculationDurationError;

/**
 * Attribute provides location of the navigation home location, if set
 */
typedef HomeLocationUpdate HomeLocationSet;

/**
 * Attribute provides location of the navigation home location, if set
 */
typedef HomeLocationUpdate HomeLocationGet;

/**
 * If the meaning of "HomeLocationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HomeLocationError;

/**
 * Attribute provides location of the navigation work location, if set
 */
typedef WorkLocationUpdate WorkLocationSet;

/**
 * Attribute provides location of the navigation work location, if set
 */
typedef WorkLocationUpdate WorkLocationGet;

/**
 * If the meaning of "WorkLocationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WorkLocationError;

/**
 * Attribute provides the map representation (orientation and 2D / 3D)
 */
typedef MapRepresentationUpdate MapRepresentationSet;

/**
 * Attribute provides the map representation (orientation and 2D / 3D)
 */
typedef MapRepresentationUpdate MapRepresentationGet;

/**
 * If the meaning of "MapRepresentationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapRepresentationError;

/**
 * Attribute provides the current SDS address entry
 */
typedef SdsAddressWithOptionsUpdate SdsAddressWithOptionsSet;

/**
 * Attribute provides the current SDS address entry
 */
typedef SdsAddressWithOptionsUpdate SdsAddressWithOptionsGet;

/**
 * If the meaning of "SdsAddressWithOptionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsAddressWithOptionsError;

/**
 * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
typedef WaypointListUpdate WaypointListSet;

/**
 * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
typedef WaypointListUpdate WaypointListGet;

/**
 * If the meaning of "WaypointListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WaypointListError;

/**
 * Attribute provides the maneuver view information
 */
typedef ManeuverViewUpdate ManeuverViewSet;

/**
 * Attribute provides the maneuver view information
 */
typedef ManeuverViewUpdate ManeuverViewGet;

/**
 * If the meaning of "ManeuverViewError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManeuverViewError;

/**
 * Attribute provides the carsorPosition in the intersection map
 */
typedef IntersectionMapCarsorPositionUpdate IntersectionMapCarsorPositionSet;

/**
 * Attribute provides the carsorPosition in the intersection map
 */
typedef IntersectionMapCarsorPositionUpdate IntersectionMapCarsorPositionGet;

/**
 * If the meaning of "IntersectionMapCarsorPositionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IntersectionMapCarsorPositionError;

/**
 * Attribute provides the Speed limit details
 */
typedef SpeedLimitUpdate SpeedLimitSet;

/**
 * Attribute provides the Speed limit details
 */
typedef SpeedLimitUpdate SpeedLimitGet;

/**
 * If the meaning of "SpeedLimitError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeedLimitError;

/**
 * Indicates traffic/speed controlled areas
 */
typedef TrafficEnforcementUpdate TrafficEnforcementSet;

/**
 * Indicates traffic/speed controlled areas
 */
typedef TrafficEnforcementUpdate TrafficEnforcementGet;

/**
 * If the meaning of "TrafficEnforcementError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TrafficEnforcementError;

/**
 * Attribute provides the Maneuver details
 */
typedef NextManeuverDetailsUpdate NextManeuverDetailsSet;

/**
 * Attribute provides the Maneuver details
 */
typedef NextManeuverDetailsUpdate NextManeuverDetailsGet;

/**
 * If the meaning of "NextManeuverDetailsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NextManeuverDetailsError;

/**
 * Attribute provides the Lane recommendation list
 */
typedef LaneRecommendationListUpdate LaneRecommendationListSet;

/**
 * Attribute provides the Lane recommendation list
 */
typedef LaneRecommendationListUpdate LaneRecommendationListGet;

/**
 * If the meaning of "LaneRecommendationListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LaneRecommendationListError;

/**
 * Attribute provides the Arrival infos array
 */
typedef ArrivalInformationListUpdate ArrivalInformationListSet;

/**
 * Attribute provides the Arrival infos array
 */
typedef ArrivalInformationListUpdate ArrivalInformationListGet;

/**
 * If the meaning of "ArrivalInformationListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ArrivalInformationListError;

/**
 * Attribute provides intersection map information for cluster
 */
typedef IntersectionMapUpdate IntersectionMapSet;

/**
 * Attribute provides intersection map information for cluster
 */
typedef IntersectionMapUpdate IntersectionMapGet;

/**
 * If the meaning of "IntersectionMapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IntersectionMapError;

/**
 * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
 */
typedef IsAddressBookChangedUpdate IsAddressBookChangedSet;

/**
 * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
 */
typedef IsAddressBookChangedUpdate IsAddressBookChangedGet;

/**
 * If the meaning of "IsAddressBookChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IsAddressBookChangedError;

/**
 * Attribute provides info if max allowed entries stored in addressbook
 */
typedef IsMaxAllowedAddressBookEntriesStoredUpdate IsMaxAllowedAddressBookEntriesStoredSet;

/**
 * Attribute provides info if max allowed entries stored in addressbook
 */
typedef IsMaxAllowedAddressBookEntriesStoredUpdate IsMaxAllowedAddressBookEntriesStoredGet;

/**
 * If the meaning of "IsMaxAllowedAddressBookEntriesStoredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IsMaxAllowedAddressBookEntriesStoredError;

/**
 * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
 */
typedef IsLastDestinationListChangedUpdate IsLastDestinationListChangedSet;

/**
 * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
 */
typedef IsLastDestinationListChangedUpdate IsLastDestinationListChangedGet;

/**
 * If the meaning of "IsLastDestinationListChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IsLastDestinationListChangedError;

/**
 * Attribute provides voice guidance status
 */
typedef IsVoiceGuidanceActiveUpdate IsVoiceGuidanceActiveSet;

/**
 * Attribute provides voice guidance status
 */
typedef IsVoiceGuidanceActiveUpdate IsVoiceGuidanceActiveGet;

/**
 * If the meaning of "IsVoiceGuidanceActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IsVoiceGuidanceActiveError;

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
typedef SdsVoiceTagWithOptionsUpdate SdsVoiceTagWithOptionsSet;

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
typedef SdsVoiceTagWithOptionsUpdate SdsVoiceTagWithOptionsGet;

/**
 * If the meaning of "SdsVoiceTagWithOptionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsVoiceTagWithOptionsError;

/**
 * Attribute provides traffic message count
 */
typedef TrafficMessagesCountUpdate TrafficMessagesCountSet;

/**
 * Attribute provides traffic message count
 */
typedef TrafficMessagesCountUpdate TrafficMessagesCountGet;

/**
 * If the meaning of "TrafficMessagesCountError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TrafficMessagesCountError;

/**
 * Attribute provides Traffic service reception status
 */
typedef TrafficServiceReceptionStatusUpdate TrafficServiceReceptionStatusSet;

/**
 * Attribute provides Traffic service reception status
 */
typedef TrafficServiceReceptionStatusUpdate TrafficServiceReceptionStatusGet;

/**
 * If the meaning of "TrafficServiceReceptionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TrafficServiceReceptionStatusError;

/**
 * Attribute provides POI category shortcut names in current selected language
 */
typedef SdsPOICategoryShortcutsUpdate SdsPOICategoryShortcutsSet;

/**
 * Attribute provides POI category shortcut names in current selected language
 */
typedef SdsPOICategoryShortcutsUpdate SdsPOICategoryShortcutsGet;

/**
 * If the meaning of "SdsPOICategoryShortcutsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SdsPOICategoryShortcutsError;

/**
 * Attribute provides POI Category Shortcut Names in current selected language
 */
typedef MenuPoiCategoryShortcutsUpdate MenuPoiCategoryShortcutsSet;

/**
 * Attribute provides POI Category Shortcut Names in current selected language
 */
typedef MenuPoiCategoryShortcutsUpdate MenuPoiCategoryShortcutsGet;

/**
 * If the meaning of "MenuPoiCategoryShortcutsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MenuPoiCategoryShortcutsError;

/**
 * Attribute provides trip replay status information
 */
typedef TripReplayStatusInfoUpdate TripReplayStatusInfoSet;

/**
 * Attribute provides trip replay status information
 */
typedef TripReplayStatusInfoUpdate TripReplayStatusInfoGet;

/**
 * If the meaning of "TripReplayStatusInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TripReplayStatusInfoError;

/**
 * Attribute provides ETC status information
 */
typedef EtcStatusUpdate EtcStatusSet;

/**
 * Attribute provides ETC status information
 */
typedef EtcStatusUpdate EtcStatusGet;

/**
 * If the meaning of "EtcStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EtcStatusError;

/**
 * Attribute provides traffic sign status information
 */
typedef TrafficSignInfoActiveUpdate TrafficSignInfoActiveSet;

/**
 * Attribute provides traffic sign status information
 */
typedef TrafficSignInfoActiveUpdate TrafficSignInfoActiveGet;

/**
 * If the meaning of "TrafficSignInfoActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TrafficSignInfoActiveError;

/**
 * Attribute provides over speed sound alert status information
 */
typedef OverSpeedSoundAlertInfoActiveUpdate OverSpeedSoundAlertInfoActiveSet;

/**
 * Attribute provides over speed sound alert status information
 */
typedef OverSpeedSoundAlertInfoActiveUpdate OverSpeedSoundAlertInfoActiveGet;

/**
 * If the meaning of "OverSpeedSoundAlertInfoActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OverSpeedSoundAlertInfoActiveError;

/**
 * Attribute provides the reason for the route re-calculation
 */
typedef RouteRecalculationReasonUpdate RouteRecalculationReasonSet;

/**
 * Attribute provides the reason for the route re-calculation
 */
typedef RouteRecalculationReasonUpdate RouteRecalculationReasonGet;

/**
 * If the meaning of "RouteRecalculationReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RouteRecalculationReasonError;

/**
 * Attribute provides Risk area icon info status information
 */
typedef RiskAreaDisplayInfoActiveUpdate RiskAreaDisplayInfoActiveSet;

/**
 * Attribute provides Risk area icon info status information
 */
typedef RiskAreaDisplayInfoActiveUpdate RiskAreaDisplayInfoActiveGet;

/**
 * If the meaning of "RiskAreaDisplayInfoActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RiskAreaDisplayInfoActiveError;

/**
 * Attribute provides Risk Area Acoustic info status information
 */
typedef RiskAreaSoundAlertInfoActiveUpdate RiskAreaSoundAlertInfoActiveSet;

/**
 * Attribute provides Risk Area Acoustic info status information
 */
typedef RiskAreaSoundAlertInfoActiveUpdate RiskAreaSoundAlertInfoActiveGet;

/**
 * If the meaning of "RiskAreaSoundAlertInfoActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RiskAreaSoundAlertInfoActiveError;

/**
 * Attribute to provide JamAheadList Updates
 */
typedef JamAheadListUpdate JamAheadListSet;

/**
 * Attribute to provide JamAheadList Updates
 */
typedef JamAheadListUpdate JamAheadListGet;

/**
 * If the meaning of "JamAheadListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError JamAheadListError;

/**
 * Attribute provides the waypoint operation status
 */
typedef WaypointOperationStatusListUpdate WaypointOperationStatusListSet;

/**
 * Attribute provides the waypoint operation status
 */
typedef WaypointOperationStatusListUpdate WaypointOperationStatusListGet;

/**
 * If the meaning of "WaypointOperationStatusListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WaypointOperationStatusListError;

/**
 * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
 */
typedef DestinationReachedStatusUpdate DestinationReachedStatusSet;

/**
 * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
 */
typedef DestinationReachedStatusUpdate DestinationReachedStatusGet;

/**
 * If the meaning of "DestinationReachedStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestinationReachedStatusError;

/**
 * Attribute to get current map Day/Night settings
 */
typedef LightModeStatusUpdate LightModeStatusSet;

/**
 * Attribute to get current map Day/Night settings
 */
typedef LightModeStatusUpdate LightModeStatusGet;

/**
 * If the meaning of "LightModeStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LightModeStatusError;

/**
 * Attribute provides the map scale and compass data
 */
typedef MapCameraDataUpdate MapCameraDataSet;

/**
 * Attribute provides the map scale and compass data
 */
typedef MapCameraDataUpdate MapCameraDataGet;

/**
 * If the meaning of "MapCameraDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapCameraDataError;


/**
 * If the meaning of "OSPSetting" isn't clear, then there should be a description here.
 */
class OSPSetting {
public:

    /**
     * Default constructor
     */
    inline  OSPSetting ();

    /**
     * Copy constructor
     */
    inline  OSPSetting (const OSPSetting &rhs);

    /**
     * All fields constructor
     */
    inline  OSPSetting (OSPSettingType SettingType_, bool SettingStatus_);

    /**
     * Destructor
     */
    inline  ~OSPSetting();

    /**
     * Assignment operator
     */
    inline OSPSetting& operator = (const OSPSetting& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OSPSetting& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OSPSetting& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OSPSetting& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OSPSetting& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SettingType"

    static const int kSettingType = 0;

    /**
     * Clears the field "SettingType".
     *
     * The field will be set to its default value. The hasSettingType()
     * method will return false.
     */
    inline void clearSettingType();

    /**
     * Checks whether the field "SettingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingType()). Otherwise it will return false.
     */
    inline bool hasSettingType () const;

    /**
     * Returns the value of the member "SettingType".
     *
     * If the meaning of "SettingType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SettingType"
     */
    inline OSPSettingType getSettingType () const;

    /**
     * Sets the value of the member "SettingType".
     *
     * If the meaning of "SettingType" isn't clear, then there should be a description here.
     *
     * @param SettingType The value which will be set
     */
    inline void setSettingType (OSPSettingType SettingType_);

    // API of field "SettingStatus"

    static const int kSettingStatus = 1;

    /**
     * Clears the field "SettingStatus".
     *
     * The field will be set to its default value. The hasSettingStatus()
     * method will return false.
     */
    inline void clearSettingStatus();

    /**
     * Checks whether the field "SettingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingStatus()). Otherwise it will return false.
     */
    inline bool hasSettingStatus () const;

    /**
     * Returns the value of the member "SettingStatus".
     *
     * If the meaning of "SettingStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SettingStatus"
     */
    inline bool getSettingStatus () const;

    /**
     * Sets the value of the member "SettingStatus".
     *
     * If the meaning of "SettingStatus" isn't clear, then there should be a description here.
     *
     * @param SettingStatus The value which will be set
     */
    inline void setSettingStatus (bool SettingStatus_);

    static const OSPSetting &getDefaultInstance();

private:

    inline void set_has_SettingType ();

    inline void clear_has_SettingType ();

    inline void set_has_SettingStatus ();

    inline void clear_has_SettingStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    OSPSettingType _SettingType;

    bool _SettingStatus;

};

/**
 * Attribute provides Traffic service reception status
 */
class TrafficServiceReceptionStatus {
public:

    /**
     * Default constructor
     */
    inline  TrafficServiceReceptionStatus ();

    /**
     * Copy constructor
     */
    inline  TrafficServiceReceptionStatus (const TrafficServiceReceptionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TrafficServiceReceptionStatus (const ::std::string& serviceName_, bool trafficServiceReceptionStatus_, TrafficReceptionState trafficReceptionState_, uint32 trafficMessageCount_, TrafficMessageSource trafficMessageSource_);

    /**
     * Destructor
     */
    inline  ~TrafficServiceReceptionStatus();

    /**
     * Assignment operator
     */
    inline TrafficServiceReceptionStatus& operator = (const TrafficServiceReceptionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficServiceReceptionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficServiceReceptionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficServiceReceptionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficServiceReceptionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceName"

    static const int kServiceName = 0;

    /**
     * Clears the field "serviceName".
     *
     * The field will be set to its default value. The hasServiceName()
     * method will return false.
     */
    inline void clearServiceName();

    /**
     * Checks whether the field "serviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceName()). Otherwise it will return false.
     */
    inline bool hasServiceName () const;

    /**
     * Returns the value of the member "serviceName".
     *
     * String serviceName contain service name
     *
     * @return The value of the field "serviceName"
     */
    inline const ::std::string& getServiceName () const;

    /**
     * Retrieves the value of the field "serviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceName".
     */
    inline ::std::string& getServiceNameMutable ();

    /**
     * Sets the value of the member "serviceName".
     *
     * String serviceName contain service name
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const ::std::string& serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * String serviceName contain service name
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* serviceName_);

    /**
     * Sets the value of the member "serviceName".
     *
     * String serviceName contain service name
     *
     * @param serviceName The value which will be set
     */
    inline void setServiceName (const char* value, size_t size);

    // API of field "trafficServiceReceptionStatus"

    static const int kTrafficServiceReceptionStatus = 1;

    /**
     * Clears the field "trafficServiceReceptionStatus".
     *
     * The field will be set to its default value. The hasTrafficServiceReceptionStatus()
     * method will return false.
     */
    inline void clearTrafficServiceReceptionStatus();

    /**
     * Checks whether the field "trafficServiceReceptionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficServiceReceptionStatus()). Otherwise it will return false.
     */
    inline bool hasTrafficServiceReceptionStatus () const;

    /**
     * Returns the value of the member "trafficServiceReceptionStatus".
     *
     * Boolean trafficServiceReceptionStatus contain traffic service reception status
     *
     * @return The value of the field "trafficServiceReceptionStatus"
     */
    inline bool getTrafficServiceReceptionStatus () const;

    /**
     * Sets the value of the member "trafficServiceReceptionStatus".
     *
     * Boolean trafficServiceReceptionStatus contain traffic service reception status
     *
     * @param trafficServiceReceptionStatus The value which will be set
     */
    inline void setTrafficServiceReceptionStatus (bool trafficServiceReceptionStatus_);

    // API of field "trafficReceptionState"

    static const int kTrafficReceptionState = 2;

    /**
     * Clears the field "trafficReceptionState".
     *
     * The field will be set to its default value. The hasTrafficReceptionState()
     * method will return false.
     */
    inline void clearTrafficReceptionState();

    /**
     * Checks whether the field "trafficReceptionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficReceptionState()). Otherwise it will return false.
     */
    inline bool hasTrafficReceptionState () const;

    /**
     * Returns the value of the member "trafficReceptionState".
     *
     * Enum trafficReceptionState contain traffic reception state
     *
     * @return The value of the field "trafficReceptionState"
     */
    inline TrafficReceptionState getTrafficReceptionState () const;

    /**
     * Sets the value of the member "trafficReceptionState".
     *
     * Enum trafficReceptionState contain traffic reception state
     *
     * @param trafficReceptionState The value which will be set
     */
    inline void setTrafficReceptionState (TrafficReceptionState trafficReceptionState_);

    // API of field "trafficMessageCount"

    static const int kTrafficMessageCount = 3;

    /**
     * Clears the field "trafficMessageCount".
     *
     * The field will be set to its default value. The hasTrafficMessageCount()
     * method will return false.
     */
    inline void clearTrafficMessageCount();

    /**
     * Checks whether the field "trafficMessageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficMessageCount()). Otherwise it will return false.
     */
    inline bool hasTrafficMessageCount () const;

    /**
     * Returns the value of the member "trafficMessageCount".
     *
     * UInt32 trafficMessageCount contain traffic message count
     *
     * @return The value of the field "trafficMessageCount"
     */
    inline uint32 getTrafficMessageCount () const;

    /**
     * Sets the value of the member "trafficMessageCount".
     *
     * UInt32 trafficMessageCount contain traffic message count
     *
     * @param trafficMessageCount The value which will be set
     */
    inline void setTrafficMessageCount (uint32 trafficMessageCount_);

    // API of field "trafficMessageSource"

    static const int kTrafficMessageSource = 4;

    /**
     * Clears the field "trafficMessageSource".
     *
     * The field will be set to its default value. The hasTrafficMessageSource()
     * method will return false.
     */
    inline void clearTrafficMessageSource();

    /**
     * Checks whether the field "trafficMessageSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficMessageSource()). Otherwise it will return false.
     */
    inline bool hasTrafficMessageSource () const;

    /**
     * Returns the value of the member "trafficMessageSource".
     *
     * Enum  TrafficMessageSource contain traffic message source
     *
     * @return The value of the field "trafficMessageSource"
     */
    inline TrafficMessageSource getTrafficMessageSource () const;

    /**
     * Sets the value of the member "trafficMessageSource".
     *
     * Enum  TrafficMessageSource contain traffic message source
     *
     * @param trafficMessageSource The value which will be set
     */
    inline void setTrafficMessageSource (TrafficMessageSource trafficMessageSource_);

    static const TrafficServiceReceptionStatus &getDefaultInstance();

private:

    inline void set_has_serviceName ();

    inline void clear_has_serviceName ();

    inline void set_has_trafficServiceReceptionStatus ();

    inline void clear_has_trafficServiceReceptionStatus ();

    inline void set_has_trafficReceptionState ();

    inline void clear_has_trafficReceptionState ();

    inline void set_has_trafficMessageCount ();

    inline void clear_has_trafficMessageCount ();

    inline void set_has_trafficMessageSource ();

    inline void clear_has_trafficMessageSource ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _serviceName;

    bool _trafficServiceReceptionStatus;

    TrafficReceptionState _trafficReceptionState;

    uint32 _trafficMessageCount;

    TrafficMessageSource _trafficMessageSource;

};

/**
 * If the meaning of "TurnToStreet" isn't clear, then there should be a description here.
 */
class TurnToStreet {
public:

    /**
     * Default constructor
     */
    inline  TurnToStreet ();

    /**
     * Copy constructor
     */
    inline  TurnToStreet (const TurnToStreet &rhs);

    /**
     * All fields constructor
     */
    inline  TurnToStreet (uint32 maneuverId_, const ::std::string& turnToStreet_);

    /**
     * Destructor
     */
    inline  ~TurnToStreet();

    /**
     * Assignment operator
     */
    inline TurnToStreet& operator = (const TurnToStreet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TurnToStreet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TurnToStreet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TurnToStreet& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TurnToStreet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverId"

    static const int kManeuverId = 0;

    /**
     * Clears the field "maneuverId".
     *
     * The field will be set to its default value. The hasManeuverId()
     * method will return false.
     */
    inline void clearManeuverId();

    /**
     * Checks whether the field "maneuverId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverId()). Otherwise it will return false.
     */
    inline bool hasManeuverId () const;

    /**
     * Returns the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maneuverId"
     */
    inline uint32 getManeuverId () const;

    /**
     * Sets the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @param maneuverId The value which will be set
     */
    inline void setManeuverId (uint32 maneuverId_);

    // API of field "turnToStreet"

    static const int kTurnToStreet = 1;

    /**
     * Clears the field "turnToStreet".
     *
     * The field will be set to its default value. The hasTurnToStreet()
     * method will return false.
     */
    inline void clearTurnToStreet();

    /**
     * Checks whether the field "turnToStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurnToStreet()). Otherwise it will return false.
     */
    inline bool hasTurnToStreet () const;

    /**
     * Returns the value of the member "turnToStreet".
     *
     * If the meaning of "turnToStreet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "turnToStreet"
     */
    inline const ::std::string& getTurnToStreet () const;

    /**
     * Retrieves the value of the field "turnToStreet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "turnToStreet".
     */
    inline ::std::string& getTurnToStreetMutable ();

    /**
     * Sets the value of the member "turnToStreet".
     *
     * If the meaning of "turnToStreet" isn't clear, then there should be a description here.
     *
     * @param turnToStreet The value which will be set
     */
    inline void setTurnToStreet (const ::std::string& turnToStreet_);

    /**
     * Sets the value of the member "turnToStreet".
     *
     * If the meaning of "turnToStreet" isn't clear, then there should be a description here.
     *
     * @param turnToStreet The value which will be set
     */
    inline void setTurnToStreet (const char* turnToStreet_);

    /**
     * Sets the value of the member "turnToStreet".
     *
     * If the meaning of "turnToStreet" isn't clear, then there should be a description here.
     *
     * @param turnToStreet The value which will be set
     */
    inline void setTurnToStreet (const char* value, size_t size);

    static const TurnToStreet &getDefaultInstance();

private:

    inline void set_has_maneuverId ();

    inline void clear_has_maneuverId ();

    inline void set_has_turnToStreet ();

    inline void clear_has_turnToStreet ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _maneuverId;

    ::std::string _turnToStreet;

};

/**
 * If the meaning of "DistanceToDestination" isn't clear, then there should be a description here.
 */
class DistanceToDestination {
public:

    /**
     * Default constructor
     */
    inline  DistanceToDestination ();

    /**
     * Copy constructor
     */
    inline  DistanceToDestination (const DistanceToDestination &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceToDestination (const ::std::string& distanceToDestinationAsString_, uint32 distanceToDestination_, DistanceUnit unit_);

    /**
     * Destructor
     */
    inline  ~DistanceToDestination();

    /**
     * Assignment operator
     */
    inline DistanceToDestination& operator = (const DistanceToDestination& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceToDestination& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceToDestination& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceToDestination& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceToDestination& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "distanceToDestinationAsString"

    static const int kDistanceToDestinationAsString = 0;

    /**
     * Clears the field "distanceToDestinationAsString".
     *
     * The field will be set to its default value. The hasDistanceToDestinationAsString()
     * method will return false.
     */
    inline void clearDistanceToDestinationAsString();

    /**
     * Checks whether the field "distanceToDestinationAsString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToDestinationAsString()). Otherwise it will return false.
     */
    inline bool hasDistanceToDestinationAsString () const;

    /**
     * Returns the value of the member "distanceToDestinationAsString".
     *
     * If the meaning of "distanceToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceToDestinationAsString"
     */
    inline const ::std::string& getDistanceToDestinationAsString () const;

    /**
     * Retrieves the value of the field "distanceToDestinationAsString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distanceToDestinationAsString".
     */
    inline ::std::string& getDistanceToDestinationAsStringMutable ();

    /**
     * Sets the value of the member "distanceToDestinationAsString".
     *
     * If the meaning of "distanceToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param distanceToDestinationAsString The value which will be set
     */
    inline void setDistanceToDestinationAsString (const ::std::string& distanceToDestinationAsString_);

    /**
     * Sets the value of the member "distanceToDestinationAsString".
     *
     * If the meaning of "distanceToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param distanceToDestinationAsString The value which will be set
     */
    inline void setDistanceToDestinationAsString (const char* distanceToDestinationAsString_);

    /**
     * Sets the value of the member "distanceToDestinationAsString".
     *
     * If the meaning of "distanceToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param distanceToDestinationAsString The value which will be set
     */
    inline void setDistanceToDestinationAsString (const char* value, size_t size);

    // API of field "distanceToDestination"

    static const int kDistanceToDestination = 1;

    /**
     * Clears the field "distanceToDestination".
     *
     * The field will be set to its default value. The hasDistanceToDestination()
     * method will return false.
     */
    inline void clearDistanceToDestination();

    /**
     * Checks whether the field "distanceToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToDestination()). Otherwise it will return false.
     */
    inline bool hasDistanceToDestination () const;

    /**
     * Returns the value of the member "distanceToDestination".
     *
     * If the meaning of "distanceToDestination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceToDestination"
     */
    inline uint32 getDistanceToDestination () const;

    /**
     * Sets the value of the member "distanceToDestination".
     *
     * If the meaning of "distanceToDestination" isn't clear, then there should be a description here.
     *
     * @param distanceToDestination The value which will be set
     */
    inline void setDistanceToDestination (uint32 distanceToDestination_);

    // API of field "unit"

    static const int kUnit = 2;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline DistanceUnit getUnit () const;

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (DistanceUnit unit_);

    static const DistanceToDestination &getDefaultInstance();

private:

    inline void set_has_distanceToDestinationAsString ();

    inline void clear_has_distanceToDestinationAsString ();

    inline void set_has_distanceToDestination ();

    inline void clear_has_distanceToDestination ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _distanceToDestinationAsString;

    uint32 _distanceToDestination;

    DistanceUnit _unit;

};

/**
 * If the meaning of "BarGraphInfo" isn't clear, then there should be a description here.
 */
class BarGraphInfo {
public:

    /**
     * Default constructor
     */
    inline  BarGraphInfo ();

    /**
     * Copy constructor
     */
    inline  BarGraphInfo (const BarGraphInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BarGraphInfo (bool valid_, uint16 value_, uint16 scale_, DistanceUnit unit_, const ::std::string& barGraphMaxScale_, const ::std::string& barGraphMinScale_);

    /**
     * Destructor
     */
    inline  ~BarGraphInfo();

    /**
     * Assignment operator
     */
    inline BarGraphInfo& operator = (const BarGraphInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BarGraphInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BarGraphInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BarGraphInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BarGraphInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "valid"

    static const int kValid = 0;

    /**
     * Clears the field "valid".
     *
     * The field will be set to its default value. The hasValid()
     * method will return false.
     */
    inline void clearValid();

    /**
     * Checks whether the field "valid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValid()). Otherwise it will return false.
     */
    inline bool hasValid () const;

    /**
     * Returns the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "valid"
     */
    inline bool getValid () const;

    /**
     * Sets the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @param valid The value which will be set
     */
    inline void setValid (bool valid_);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline uint16 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (uint16 value_);

    // API of field "scale"

    static const int kScale = 2;

    /**
     * Clears the field "scale".
     *
     * The field will be set to its default value. The hasScale()
     * method will return false.
     */
    inline void clearScale();

    /**
     * Checks whether the field "scale" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScale()). Otherwise it will return false.
     */
    inline bool hasScale () const;

    /**
     * Returns the value of the member "scale".
     *
     * If the meaning of "scale" isn't clear, then there should be a description here.
     *
     * @return The value of the field "scale"
     */
    inline uint16 getScale () const;

    /**
     * Sets the value of the member "scale".
     *
     * If the meaning of "scale" isn't clear, then there should be a description here.
     *
     * @param scale The value which will be set
     */
    inline void setScale (uint16 scale_);

    // API of field "unit"

    static const int kUnit = 3;

    /**
     * Clears the field "unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unit"
     */
    inline DistanceUnit getUnit () const;

    /**
     * Sets the value of the member "unit".
     *
     * If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param unit The value which will be set
     */
    inline void setUnit (DistanceUnit unit_);

    // API of field "barGraphMaxScale"

    static const int kBarGraphMaxScale = 4;

    /**
     * Clears the field "barGraphMaxScale".
     *
     * The field will be set to its default value. The hasBarGraphMaxScale()
     * method will return false.
     */
    inline void clearBarGraphMaxScale();

    /**
     * Checks whether the field "barGraphMaxScale" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBarGraphMaxScale()). Otherwise it will return false.
     */
    inline bool hasBarGraphMaxScale () const;

    /**
     * Returns the value of the member "barGraphMaxScale".
     *
     * If the meaning of "barGraphMaxScale" isn't clear, then there should be a description here.
     *
     * @return The value of the field "barGraphMaxScale"
     */
    inline const ::std::string& getBarGraphMaxScale () const;

    /**
     * Retrieves the value of the field "barGraphMaxScale" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "barGraphMaxScale".
     */
    inline ::std::string& getBarGraphMaxScaleMutable ();

    /**
     * Sets the value of the member "barGraphMaxScale".
     *
     * If the meaning of "barGraphMaxScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMaxScale The value which will be set
     */
    inline void setBarGraphMaxScale (const ::std::string& barGraphMaxScale_);

    /**
     * Sets the value of the member "barGraphMaxScale".
     *
     * If the meaning of "barGraphMaxScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMaxScale The value which will be set
     */
    inline void setBarGraphMaxScale (const char* barGraphMaxScale_);

    /**
     * Sets the value of the member "barGraphMaxScale".
     *
     * If the meaning of "barGraphMaxScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMaxScale The value which will be set
     */
    inline void setBarGraphMaxScale (const char* value, size_t size);

    // API of field "barGraphMinScale"

    static const int kBarGraphMinScale = 5;

    /**
     * Clears the field "barGraphMinScale".
     *
     * The field will be set to its default value. The hasBarGraphMinScale()
     * method will return false.
     */
    inline void clearBarGraphMinScale();

    /**
     * Checks whether the field "barGraphMinScale" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBarGraphMinScale()). Otherwise it will return false.
     */
    inline bool hasBarGraphMinScale () const;

    /**
     * Returns the value of the member "barGraphMinScale".
     *
     * If the meaning of "barGraphMinScale" isn't clear, then there should be a description here.
     *
     * @return The value of the field "barGraphMinScale"
     */
    inline const ::std::string& getBarGraphMinScale () const;

    /**
     * Retrieves the value of the field "barGraphMinScale" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "barGraphMinScale".
     */
    inline ::std::string& getBarGraphMinScaleMutable ();

    /**
     * Sets the value of the member "barGraphMinScale".
     *
     * If the meaning of "barGraphMinScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMinScale The value which will be set
     */
    inline void setBarGraphMinScale (const ::std::string& barGraphMinScale_);

    /**
     * Sets the value of the member "barGraphMinScale".
     *
     * If the meaning of "barGraphMinScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMinScale The value which will be set
     */
    inline void setBarGraphMinScale (const char* barGraphMinScale_);

    /**
     * Sets the value of the member "barGraphMinScale".
     *
     * If the meaning of "barGraphMinScale" isn't clear, then there should be a description here.
     *
     * @param barGraphMinScale The value which will be set
     */
    inline void setBarGraphMinScale (const char* value, size_t size);

    static const BarGraphInfo &getDefaultInstance();

private:

    inline void set_has_valid ();

    inline void clear_has_valid ();

    inline void set_has_value ();

    inline void clear_has_value ();

    inline void set_has_scale ();

    inline void clear_has_scale ();

    inline void set_has_unit ();

    inline void clear_has_unit ();

    inline void set_has_barGraphMaxScale ();

    inline void clear_has_barGraphMaxScale ();

    inline void set_has_barGraphMinScale ();

    inline void clear_has_barGraphMinScale ();

    uint32 _has_bits_[ (6 + 31) / 32];

    bool _valid;

    uint16 _value;

    uint16 _scale;

    DistanceUnit _unit;

    ::std::string _barGraphMaxScale;

    ::std::string _barGraphMinScale;

};

/**
 * If the meaning of "PositionWGS84" isn't clear, then there should be a description here.
 */
class PositionWGS84 {
public:

    /**
     * Default constructor
     */
    inline  PositionWGS84 ();

    /**
     * Copy constructor
     */
    inline  PositionWGS84 (const PositionWGS84 &rhs);

    /**
     * All fields constructor
     */
    inline  PositionWGS84 (double longitude_, double latitude_);

    /**
     * Destructor
     */
    inline  ~PositionWGS84();

    /**
     * Assignment operator
     */
    inline PositionWGS84& operator = (const PositionWGS84& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionWGS84& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionWGS84& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionWGS84& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionWGS84& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "longitude"

    static const int kLongitude = 0;

    /**
     * Clears the field "longitude".
     *
     * The field will be set to its default value. The hasLongitude()
     * method will return false.
     */
    inline void clearLongitude();

    /**
     * Checks whether the field "longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLongitude()). Otherwise it will return false.
     */
    inline bool hasLongitude () const;

    /**
     * Returns the value of the member "longitude".
     *
     * If the meaning of "longitude" isn't clear, then there should be a description here.
     *
     * @return The value of the field "longitude"
     */
    inline double getLongitude () const;

    /**
     * Sets the value of the member "longitude".
     *
     * If the meaning of "longitude" isn't clear, then there should be a description here.
     *
     * @param longitude The value which will be set
     */
    inline void setLongitude (double longitude_);

    // API of field "latitude"

    static const int kLatitude = 1;

    /**
     * Clears the field "latitude".
     *
     * The field will be set to its default value. The hasLatitude()
     * method will return false.
     */
    inline void clearLatitude();

    /**
     * Checks whether the field "latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLatitude()). Otherwise it will return false.
     */
    inline bool hasLatitude () const;

    /**
     * Returns the value of the member "latitude".
     *
     * If the meaning of "latitude" isn't clear, then there should be a description here.
     *
     * @return The value of the field "latitude"
     */
    inline double getLatitude () const;

    /**
     * Sets the value of the member "latitude".
     *
     * If the meaning of "latitude" isn't clear, then there should be a description here.
     *
     * @param latitude The value which will be set
     */
    inline void setLatitude (double latitude_);

    static const PositionWGS84 &getDefaultInstance();

private:

    inline void set_has_longitude ();

    inline void clear_has_longitude ();

    inline void set_has_latitude ();

    inline void clear_has_latitude ();

    uint32 _has_bits_[ (2 + 31) / 32];

    double _longitude;

    double _latitude;

};

/**
 * If the meaning of "Location" isn't clear, then there should be a description here.
 */
class Location {
public:

    /**
     * Default constructor
     */
    inline  Location ();

    /**
     * Copy constructor
     */
    inline  Location (const Location &rhs);

    /**
     * All fields constructor
     */
    inline  Location (const ::std::string& name_, const PositionWGS84& positionWGS84_, bool valid_);

    /**
     * Destructor
     */
    inline  ~Location();

    /**
     * Assignment operator
     */
    inline Location& operator = (const Location& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Location& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Location& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Location& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Location& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "positionWGS84"

    static const int kPositionWGS84 = 1;

    /**
     * Clears the field "positionWGS84".
     *
     * The field will be set to its default value. The hasPositionWGS84()
     * method will return false.
     */
    inline void clearPositionWGS84();

    /**
     * Checks whether the field "positionWGS84" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionWGS84()). Otherwise it will return false.
     */
    inline bool hasPositionWGS84 () const;

    /**
     * Returns the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @return The value of the field "positionWGS84"
     */
    inline const PositionWGS84& getPositionWGS84 () const;

    /**
     * Retrieves the value of the field "positionWGS84" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionWGS84".
     */
    inline PositionWGS84& getPositionWGS84Mutable ();

    /**
     * Sets the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @param positionWGS84 The value which will be set
     */
    inline void setPositionWGS84 (const PositionWGS84& positionWGS84_);

    // API of field "valid"

    static const int kValid = 2;

    /**
     * Clears the field "valid".
     *
     * The field will be set to its default value. The hasValid()
     * method will return false.
     */
    inline void clearValid();

    /**
     * Checks whether the field "valid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValid()). Otherwise it will return false.
     */
    inline bool hasValid () const;

    /**
     * Returns the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "valid"
     */
    inline bool getValid () const;

    /**
     * Sets the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @param valid The value which will be set
     */
    inline void setValid (bool valid_);

    static const Location &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_positionWGS84 ();

    inline void clear_has_positionWGS84 ();

    inline void set_has_valid ();

    inline void clear_has_valid ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    PositionWGS84 _positionWGS84;

    bool _valid;

};

/**
 * If the meaning of "Image" isn't clear, then there should be a description here.
 */
class Image {
public:

    /**
     * Default constructor
     */
    inline  Image ();

    /**
     * Copy constructor
     */
    inline  Image (const Image &rhs);

    /**
     * All fields constructor
     */
    inline  Image (const ::asf::core::Blob& image_, ImageType imageType_);

    /**
     * Destructor
     */
    inline  ~Image();

    /**
     * Assignment operator
     */
    inline Image& operator = (const Image& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Image& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Image& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Image& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Image& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "image"

    static const int kImage = 0;

    /**
     * Clears the field "image".
     *
     * The field will be set to its default value. The hasImage()
     * method will return false.
     */
    inline void clearImage();

    /**
     * Checks whether the field "image" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImage()). Otherwise it will return false.
     */
    inline bool hasImage () const;

    /**
     * Returns the value of the member "image".
     *
     * If the meaning of "image" isn't clear, then there should be a description here.
     *
     * @return The value of the field "image"
     */
    inline const ::asf::core::Blob& getImage () const;

    /**
     * Retrieves the value of the field "image" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "image".
     */
    inline ::asf::core::Blob& getImageMutable ();

    /**
     * Sets the value of the member "image".
     *
     * If the meaning of "image" isn't clear, then there should be a description here.
     *
     * @param image The value which will be set
     */
    inline void setImage (const ::asf::core::Blob& image_);

    // API of field "imageType"

    static const int kImageType = 1;

    /**
     * Clears the field "imageType".
     *
     * The field will be set to its default value. The hasImageType()
     * method will return false.
     */
    inline void clearImageType();

    /**
     * Checks whether the field "imageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageType()). Otherwise it will return false.
     */
    inline bool hasImageType () const;

    /**
     * Returns the value of the member "imageType".
     *
     * If the meaning of "imageType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "imageType"
     */
    inline ImageType getImageType () const;

    /**
     * Sets the value of the member "imageType".
     *
     * If the meaning of "imageType" isn't clear, then there should be a description here.
     *
     * @param imageType The value which will be set
     */
    inline void setImageType (ImageType imageType_);

    static const Image &getDefaultInstance();

private:

    inline void set_has_image ();

    inline void clear_has_image ();

    inline void set_has_imageType ();

    inline void clear_has_imageType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::asf::core::Blob _image;

    ImageType _imageType;

};

/**
 * If the meaning of "POILocation" isn't clear, then there should be a description here.
 */
class POILocation {
public:

    /**
     * Default constructor
     */
    inline  POILocation ();

    /**
     * Copy constructor
     */
    inline  POILocation (const POILocation &rhs);

    /**
     * All fields constructor
     */
    inline  POILocation (const Location& location_, const ::std::string& phoneNumber_, const ::std::string& address_, const Image& icon_);

    /**
     * Destructor
     */
    inline  ~POILocation();

    /**
     * Assignment operator
     */
    inline POILocation& operator = (const POILocation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const POILocation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const POILocation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const POILocation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const POILocation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const Location& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline Location& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const Location& location_);

    // API of field "phoneNumber"

    static const int kPhoneNumber = 1;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "phoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& phoneNumber_);

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* phoneNumber_);

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "address"

    static const int kAddress = 2;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "icon"

    static const int kIcon = 3;

    /**
     * Clears the field "icon".
     *
     * The field will be set to its default value. The hasIcon()
     * method will return false.
     */
    inline void clearIcon();

    /**
     * Checks whether the field "icon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIcon()). Otherwise it will return false.
     */
    inline bool hasIcon () const;

    /**
     * Returns the value of the member "icon".
     *
     * If the meaning of "icon" isn't clear, then there should be a description here.
     *
     * @return The value of the field "icon"
     */
    inline const Image& getIcon () const;

    /**
     * Retrieves the value of the field "icon" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "icon".
     */
    inline Image& getIconMutable ();

    /**
     * Sets the value of the member "icon".
     *
     * If the meaning of "icon" isn't clear, then there should be a description here.
     *
     * @param icon The value which will be set
     */
    inline void setIcon (const Image& icon_);

    static const POILocation &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_icon ();

    inline void clear_has_icon ();

    uint32 _has_bits_[ (4 + 31) / 32];

    Location _location;

    ::std::string _phoneNumber;

    ::std::string _address;

    Image _icon;

};

/**
 * If the meaning of "TourElement" isn't clear, then there should be a description here.
 */
class TourElement {
public:

    /**
     * Default constructor
     */
    inline  TourElement ();

    /**
     * Copy constructor
     */
    inline  TourElement (const TourElement &rhs);

    /**
     * All fields constructor
     */
    inline  TourElement (const POILocation& location_, bool useDefaultRouteCriterion_, RouteCriterion routeCriterion_);

    /**
     * Destructor
     */
    inline  ~TourElement();

    /**
     * Assignment operator
     */
    inline TourElement& operator = (const TourElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TourElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TourElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TourElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TourElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const POILocation& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline POILocation& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const POILocation& location_);

    // API of field "useDefaultRouteCriterion"

    static const int kUseDefaultRouteCriterion = 1;

    /**
     * Clears the field "useDefaultRouteCriterion".
     *
     * The field will be set to its default value. The hasUseDefaultRouteCriterion()
     * method will return false.
     */
    inline void clearUseDefaultRouteCriterion();

    /**
     * Checks whether the field "useDefaultRouteCriterion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUseDefaultRouteCriterion()). Otherwise it will return false.
     */
    inline bool hasUseDefaultRouteCriterion () const;

    /**
     * Returns the value of the member "useDefaultRouteCriterion".
     *
     * If the meaning of "useDefaultRouteCriterion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "useDefaultRouteCriterion"
     */
    inline bool getUseDefaultRouteCriterion () const;

    /**
     * Sets the value of the member "useDefaultRouteCriterion".
     *
     * If the meaning of "useDefaultRouteCriterion" isn't clear, then there should be a description here.
     *
     * @param useDefaultRouteCriterion The value which will be set
     */
    inline void setUseDefaultRouteCriterion (bool useDefaultRouteCriterion_);

    // API of field "routeCriterion"

    static const int kRouteCriterion = 2;

    /**
     * Clears the field "routeCriterion".
     *
     * The field will be set to its default value. The hasRouteCriterion()
     * method will return false.
     */
    inline void clearRouteCriterion();

    /**
     * Checks whether the field "routeCriterion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCriterion()). Otherwise it will return false.
     */
    inline bool hasRouteCriterion () const;

    /**
     * Returns the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "routeCriterion"
     */
    inline RouteCriterion getRouteCriterion () const;

    /**
     * Sets the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @param routeCriterion The value which will be set
     */
    inline void setRouteCriterion (RouteCriterion routeCriterion_);

    static const TourElement &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_useDefaultRouteCriterion ();

    inline void clear_has_useDefaultRouteCriterion ();

    inline void set_has_routeCriterion ();

    inline void clear_has_routeCriterion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    POILocation _location;

    bool _useDefaultRouteCriterion;

    RouteCriterion _routeCriterion;

};

/**
 * If the meaning of "CurrentFreeTextSearchInfo" isn't clear, then there should be a description here.
 */
class CurrentFreeTextSearchInfo {
public:

    /**
     * Default constructor
     */
    inline  CurrentFreeTextSearchInfo ();

    /**
     * Copy constructor
     */
    inline  CurrentFreeTextSearchInfo (const CurrentFreeTextSearchInfo &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentFreeTextSearchInfo (const PositionWGS84& position_, const ::std::string& searchString_);

    /**
     * Destructor
     */
    inline  ~CurrentFreeTextSearchInfo();

    /**
     * Assignment operator
     */
    inline CurrentFreeTextSearchInfo& operator = (const CurrentFreeTextSearchInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentFreeTextSearchInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentFreeTextSearchInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentFreeTextSearchInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentFreeTextSearchInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "position"

    static const int kPosition = 0;

    /**
     * Clears the field "position".
     *
     * The field will be set to its default value. The hasPosition()
     * method will return false.
     */
    inline void clearPosition();

    /**
     * Checks whether the field "position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPosition()). Otherwise it will return false.
     */
    inline bool hasPosition () const;

    /**
     * Returns the value of the member "position".
     *
     * If the meaning of "position" isn't clear, then there should be a description here.
     *
     * @return The value of the field "position"
     */
    inline const PositionWGS84& getPosition () const;

    /**
     * Retrieves the value of the field "position" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "position".
     */
    inline PositionWGS84& getPositionMutable ();

    /**
     * Sets the value of the member "position".
     *
     * If the meaning of "position" isn't clear, then there should be a description here.
     *
     * @param position The value which will be set
     */
    inline void setPosition (const PositionWGS84& position_);

    // API of field "searchString"

    static const int kSearchString = 1;

    /**
     * Clears the field "searchString".
     *
     * The field will be set to its default value. The hasSearchString()
     * method will return false.
     */
    inline void clearSearchString();

    /**
     * Checks whether the field "searchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchString()). Otherwise it will return false.
     */
    inline bool hasSearchString () const;

    /**
     * Returns the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchString"
     */
    inline const ::std::string& getSearchString () const;

    /**
     * Retrieves the value of the field "searchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchString".
     */
    inline ::std::string& getSearchStringMutable ();

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const ::std::string& searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* value, size_t size);

    static const CurrentFreeTextSearchInfo &getDefaultInstance();

private:

    inline void set_has_position ();

    inline void clear_has_position ();

    inline void set_has_searchString ();

    inline void clear_has_searchString ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PositionWGS84 _position;

    ::std::string _searchString;

};

/**
 * If the meaning of "PositionInformation" isn't clear, then there should be a description here.
 */
class PositionInformation {
public:

    /**
     * Default constructor
     */
    inline  PositionInformation ();

    /**
     * Copy constructor
     */
    inline  PositionInformation (const PositionInformation &rhs);

    /**
     * All fields constructor
     */
    inline  PositionInformation (const PositionWGS84& positionWGS84_, float mapMatchingPositionAccuracy_, const ::std::string& countryCode_, const ::std::string& stateCode_, RoadClass roadClass_, float vehicleSpeed_, float vehicleHeading_, int32 altitude_, const ::std::string& country_, const ::std::string& province_, const ::std::string& city_, const ::std::string& cityDistrict_, const ::std::string& street_, const ::std::string& streetNumber_);

    /**
     * Destructor
     */
    inline  ~PositionInformation();

    /**
     * Assignment operator
     */
    inline PositionInformation& operator = (const PositionInformation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInformation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInformation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInformation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInformation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "positionWGS84"

    static const int kPositionWGS84 = 0;

    /**
     * Clears the field "positionWGS84".
     *
     * The field will be set to its default value. The hasPositionWGS84()
     * method will return false.
     */
    inline void clearPositionWGS84();

    /**
     * Checks whether the field "positionWGS84" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionWGS84()). Otherwise it will return false.
     */
    inline bool hasPositionWGS84 () const;

    /**
     * Returns the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @return The value of the field "positionWGS84"
     */
    inline const PositionWGS84& getPositionWGS84 () const;

    /**
     * Retrieves the value of the field "positionWGS84" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionWGS84".
     */
    inline PositionWGS84& getPositionWGS84Mutable ();

    /**
     * Sets the value of the member "positionWGS84".
     *
     * If the meaning of "positionWGS84" isn't clear, then there should be a description here.
     *
     * @param positionWGS84 The value which will be set
     */
    inline void setPositionWGS84 (const PositionWGS84& positionWGS84_);

    // API of field "mapMatchingPositionAccuracy"

    static const int kMapMatchingPositionAccuracy = 1;

    /**
     * Clears the field "mapMatchingPositionAccuracy".
     *
     * The field will be set to its default value. The hasMapMatchingPositionAccuracy()
     * method will return false.
     */
    inline void clearMapMatchingPositionAccuracy();

    /**
     * Checks whether the field "mapMatchingPositionAccuracy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapMatchingPositionAccuracy()). Otherwise it will return false.
     */
    inline bool hasMapMatchingPositionAccuracy () const;

    /**
     * Returns the value of the member "mapMatchingPositionAccuracy".
     *
     * If the meaning of "mapMatchingPositionAccuracy" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mapMatchingPositionAccuracy"
     */
    inline float getMapMatchingPositionAccuracy () const;

    /**
     * Sets the value of the member "mapMatchingPositionAccuracy".
     *
     * If the meaning of "mapMatchingPositionAccuracy" isn't clear, then there should be a description here.
     *
     * @param mapMatchingPositionAccuracy The value which will be set
     */
    inline void setMapMatchingPositionAccuracy (float mapMatchingPositionAccuracy_);

    // API of field "countryCode"

    static const int kCountryCode = 2;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "stateCode"

    static const int kStateCode = 3;

    /**
     * Clears the field "stateCode".
     *
     * The field will be set to its default value. The hasStateCode()
     * method will return false.
     */
    inline void clearStateCode();

    /**
     * Checks whether the field "stateCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateCode()). Otherwise it will return false.
     */
    inline bool hasStateCode () const;

    /**
     * Returns the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stateCode"
     */
    inline const ::std::string& getStateCode () const;

    /**
     * Retrieves the value of the field "stateCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateCode".
     */
    inline ::std::string& getStateCodeMutable ();

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const ::std::string& stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * If the meaning of "stateCode" isn't clear, then there should be a description here.
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* value, size_t size);

    // API of field "roadClass"

    static const int kRoadClass = 4;

    /**
     * Clears the field "roadClass".
     *
     * The field will be set to its default value. The hasRoadClass()
     * method will return false.
     */
    inline void clearRoadClass();

    /**
     * Checks whether the field "roadClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadClass()). Otherwise it will return false.
     */
    inline bool hasRoadClass () const;

    /**
     * Returns the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @return The value of the field "roadClass"
     */
    inline RoadClass getRoadClass () const;

    /**
     * Sets the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @param roadClass The value which will be set
     */
    inline void setRoadClass (RoadClass roadClass_);

    // API of field "vehicleSpeed"

    static const int kVehicleSpeed = 5;

    /**
     * Clears the field "vehicleSpeed".
     *
     * The field will be set to its default value. The hasVehicleSpeed()
     * method will return false.
     */
    inline void clearVehicleSpeed();

    /**
     * Checks whether the field "vehicleSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleSpeed()). Otherwise it will return false.
     */
    inline bool hasVehicleSpeed () const;

    /**
     * Returns the value of the member "vehicleSpeed".
     *
     * If the meaning of "vehicleSpeed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vehicleSpeed"
     */
    inline float getVehicleSpeed () const;

    /**
     * Sets the value of the member "vehicleSpeed".
     *
     * If the meaning of "vehicleSpeed" isn't clear, then there should be a description here.
     *
     * @param vehicleSpeed The value which will be set
     */
    inline void setVehicleSpeed (float vehicleSpeed_);

    // API of field "vehicleHeading"

    static const int kVehicleHeading = 6;

    /**
     * Clears the field "vehicleHeading".
     *
     * The field will be set to its default value. The hasVehicleHeading()
     * method will return false.
     */
    inline void clearVehicleHeading();

    /**
     * Checks whether the field "vehicleHeading" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleHeading()). Otherwise it will return false.
     */
    inline bool hasVehicleHeading () const;

    /**
     * Returns the value of the member "vehicleHeading".
     *
     * If the meaning of "vehicleHeading" isn't clear, then there should be a description here.
     *
     * @return The value of the field "vehicleHeading"
     */
    inline float getVehicleHeading () const;

    /**
     * Sets the value of the member "vehicleHeading".
     *
     * If the meaning of "vehicleHeading" isn't clear, then there should be a description here.
     *
     * @param vehicleHeading The value which will be set
     */
    inline void setVehicleHeading (float vehicleHeading_);

    // API of field "altitude"

    static const int kAltitude = 7;

    /**
     * Clears the field "altitude".
     *
     * The field will be set to its default value. The hasAltitude()
     * method will return false.
     */
    inline void clearAltitude();

    /**
     * Checks whether the field "altitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAltitude()). Otherwise it will return false.
     */
    inline bool hasAltitude () const;

    /**
     * Returns the value of the member "altitude".
     *
     * If the meaning of "altitude" isn't clear, then there should be a description here.
     *
     * @return The value of the field "altitude"
     */
    inline int32 getAltitude () const;

    /**
     * Sets the value of the member "altitude".
     *
     * If the meaning of "altitude" isn't clear, then there should be a description here.
     *
     * @param altitude The value which will be set
     */
    inline void setAltitude (int32 altitude_);

    // API of field "country"

    static const int kCountry = 8;

    /**
     * Clears the field "country".
     *
     * The field will be set to its default value. The hasCountry()
     * method will return false.
     */
    inline void clearCountry();

    /**
     * Checks whether the field "country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountry()). Otherwise it will return false.
     */
    inline bool hasCountry () const;

    /**
     * Returns the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "country"
     */
    inline const ::std::string& getCountry () const;

    /**
     * Retrieves the value of the field "country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "country".
     */
    inline ::std::string& getCountryMutable ();

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const ::std::string& country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* value, size_t size);

    // API of field "province"

    static const int kProvince = 9;

    /**
     * Clears the field "province".
     *
     * The field will be set to its default value. The hasProvince()
     * method will return false.
     */
    inline void clearProvince();

    /**
     * Checks whether the field "province" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProvince()). Otherwise it will return false.
     */
    inline bool hasProvince () const;

    /**
     * Returns the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @return The value of the field "province"
     */
    inline const ::std::string& getProvince () const;

    /**
     * Retrieves the value of the field "province" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "province".
     */
    inline ::std::string& getProvinceMutable ();

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const ::std::string& province_);

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const char* province_);

    /**
     * Sets the value of the member "province".
     *
     * If the meaning of "province" isn't clear, then there should be a description here.
     *
     * @param province The value which will be set
     */
    inline void setProvince (const char* value, size_t size);

    // API of field "city"

    static const int kCity = 10;

    /**
     * Clears the field "city".
     *
     * The field will be set to its default value. The hasCity()
     * method will return false.
     */
    inline void clearCity();

    /**
     * Checks whether the field "city" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity()). Otherwise it will return false.
     */
    inline bool hasCity () const;

    /**
     * Returns the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @return The value of the field "city"
     */
    inline const ::std::string& getCity () const;

    /**
     * Retrieves the value of the field "city" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "city".
     */
    inline ::std::string& getCityMutable ();

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const ::std::string& city_);

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const char* city_);

    /**
     * Sets the value of the member "city".
     *
     * If the meaning of "city" isn't clear, then there should be a description here.
     *
     * @param city The value which will be set
     */
    inline void setCity (const char* value, size_t size);

    // API of field "cityDistrict"

    static const int kCityDistrict = 11;

    /**
     * Clears the field "cityDistrict".
     *
     * The field will be set to its default value. The hasCityDistrict()
     * method will return false.
     */
    inline void clearCityDistrict();

    /**
     * Checks whether the field "cityDistrict" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityDistrict()). Otherwise it will return false.
     */
    inline bool hasCityDistrict () const;

    /**
     * Returns the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityDistrict"
     */
    inline const ::std::string& getCityDistrict () const;

    /**
     * Retrieves the value of the field "cityDistrict" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityDistrict".
     */
    inline ::std::string& getCityDistrictMutable ();

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const ::std::string& cityDistrict_);

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const char* cityDistrict_);

    /**
     * Sets the value of the member "cityDistrict".
     *
     * If the meaning of "cityDistrict" isn't clear, then there should be a description here.
     *
     * @param cityDistrict The value which will be set
     */
    inline void setCityDistrict (const char* value, size_t size);

    // API of field "street"

    static const int kStreet = 12;

    /**
     * Clears the field "street".
     *
     * The field will be set to its default value. The hasStreet()
     * method will return false.
     */
    inline void clearStreet();

    /**
     * Checks whether the field "street" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreet()). Otherwise it will return false.
     */
    inline bool hasStreet () const;

    /**
     * Returns the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @return The value of the field "street"
     */
    inline const ::std::string& getStreet () const;

    /**
     * Retrieves the value of the field "street" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "street".
     */
    inline ::std::string& getStreetMutable ();

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const ::std::string& street_);

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const char* street_);

    /**
     * Sets the value of the member "street".
     *
     * If the meaning of "street" isn't clear, then there should be a description here.
     *
     * @param street The value which will be set
     */
    inline void setStreet (const char* value, size_t size);

    // API of field "streetNumber"

    static const int kStreetNumber = 13;

    /**
     * Clears the field "streetNumber".
     *
     * The field will be set to its default value. The hasStreetNumber()
     * method will return false.
     */
    inline void clearStreetNumber();

    /**
     * Checks whether the field "streetNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetNumber()). Otherwise it will return false.
     */
    inline bool hasStreetNumber () const;

    /**
     * Returns the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "streetNumber"
     */
    inline const ::std::string& getStreetNumber () const;

    /**
     * Retrieves the value of the field "streetNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "streetNumber".
     */
    inline ::std::string& getStreetNumberMutable ();

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const ::std::string& streetNumber_);

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const char* streetNumber_);

    /**
     * Sets the value of the member "streetNumber".
     *
     * If the meaning of "streetNumber" isn't clear, then there should be a description here.
     *
     * @param streetNumber The value which will be set
     */
    inline void setStreetNumber (const char* value, size_t size);

    static const PositionInformation &getDefaultInstance();

private:

    inline void set_has_positionWGS84 ();

    inline void clear_has_positionWGS84 ();

    inline void set_has_mapMatchingPositionAccuracy ();

    inline void clear_has_mapMatchingPositionAccuracy ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_stateCode ();

    inline void clear_has_stateCode ();

    inline void set_has_roadClass ();

    inline void clear_has_roadClass ();

    inline void set_has_vehicleSpeed ();

    inline void clear_has_vehicleSpeed ();

    inline void set_has_vehicleHeading ();

    inline void clear_has_vehicleHeading ();

    inline void set_has_altitude ();

    inline void clear_has_altitude ();

    inline void set_has_country ();

    inline void clear_has_country ();

    inline void set_has_province ();

    inline void clear_has_province ();

    inline void set_has_city ();

    inline void clear_has_city ();

    inline void set_has_cityDistrict ();

    inline void clear_has_cityDistrict ();

    inline void set_has_street ();

    inline void clear_has_street ();

    inline void set_has_streetNumber ();

    inline void clear_has_streetNumber ();

    uint32 _has_bits_[ (14 + 31) / 32];

    PositionWGS84 _positionWGS84;

    float _mapMatchingPositionAccuracy;

    ::std::string _countryCode;

    ::std::string _stateCode;

    RoadClass _roadClass;

    float _vehicleSpeed;

    float _vehicleHeading;

    int32 _altitude;

    ::std::string _country;

    ::std::string _province;

    ::std::string _city;

    ::std::string _cityDistrict;

    ::std::string _street;

    ::std::string _streetNumber;

};

/**
 * If the meaning of "SatelliteInfo" isn't clear, then there should be a description here.
 */
class SatelliteInfo {
public:

    /**
     * Default constructor
     */
    inline  SatelliteInfo ();

    /**
     * Copy constructor
     */
    inline  SatelliteInfo (const SatelliteInfo &rhs);

    /**
     * All fields constructor
     */
    inline  SatelliteInfo (uint8 visibleSatellites_, uint8 receivedSatellites_, uint8 usedSatellites_, const ::std::string& gnssMode_, uint16 gnssSpeed_, uint8 gnssSpeedReliability_, const PositionWGS84& gnssPosition_);

    /**
     * Destructor
     */
    inline  ~SatelliteInfo();

    /**
     * Assignment operator
     */
    inline SatelliteInfo& operator = (const SatelliteInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SatelliteInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SatelliteInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SatelliteInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SatelliteInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "visibleSatellites"

    static const int kVisibleSatellites = 0;

    /**
     * Clears the field "visibleSatellites".
     *
     * The field will be set to its default value. The hasVisibleSatellites()
     * method will return false.
     */
    inline void clearVisibleSatellites();

    /**
     * Checks whether the field "visibleSatellites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVisibleSatellites()). Otherwise it will return false.
     */
    inline bool hasVisibleSatellites () const;

    /**
     * Returns the value of the member "visibleSatellites".
     *
     * If the meaning of "visibleSatellites" isn't clear, then there should be a description here.
     *
     * @return The value of the field "visibleSatellites"
     */
    inline uint8 getVisibleSatellites () const;

    /**
     * Sets the value of the member "visibleSatellites".
     *
     * If the meaning of "visibleSatellites" isn't clear, then there should be a description here.
     *
     * @param visibleSatellites The value which will be set
     */
    inline void setVisibleSatellites (uint8 visibleSatellites_);

    // API of field "receivedSatellites"

    static const int kReceivedSatellites = 1;

    /**
     * Clears the field "receivedSatellites".
     *
     * The field will be set to its default value. The hasReceivedSatellites()
     * method will return false.
     */
    inline void clearReceivedSatellites();

    /**
     * Checks whether the field "receivedSatellites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceivedSatellites()). Otherwise it will return false.
     */
    inline bool hasReceivedSatellites () const;

    /**
     * Returns the value of the member "receivedSatellites".
     *
     * If the meaning of "receivedSatellites" isn't clear, then there should be a description here.
     *
     * @return The value of the field "receivedSatellites"
     */
    inline uint8 getReceivedSatellites () const;

    /**
     * Sets the value of the member "receivedSatellites".
     *
     * If the meaning of "receivedSatellites" isn't clear, then there should be a description here.
     *
     * @param receivedSatellites The value which will be set
     */
    inline void setReceivedSatellites (uint8 receivedSatellites_);

    // API of field "usedSatellites"

    static const int kUsedSatellites = 2;

    /**
     * Clears the field "usedSatellites".
     *
     * The field will be set to its default value. The hasUsedSatellites()
     * method will return false.
     */
    inline void clearUsedSatellites();

    /**
     * Checks whether the field "usedSatellites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsedSatellites()). Otherwise it will return false.
     */
    inline bool hasUsedSatellites () const;

    /**
     * Returns the value of the member "usedSatellites".
     *
     * If the meaning of "usedSatellites" isn't clear, then there should be a description here.
     *
     * @return The value of the field "usedSatellites"
     */
    inline uint8 getUsedSatellites () const;

    /**
     * Sets the value of the member "usedSatellites".
     *
     * If the meaning of "usedSatellites" isn't clear, then there should be a description here.
     *
     * @param usedSatellites The value which will be set
     */
    inline void setUsedSatellites (uint8 usedSatellites_);

    // API of field "gnssMode"

    static const int kGnssMode = 3;

    /**
     * Clears the field "gnssMode".
     *
     * The field will be set to its default value. The hasGnssMode()
     * method will return false.
     */
    inline void clearGnssMode();

    /**
     * Checks whether the field "gnssMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssMode()). Otherwise it will return false.
     */
    inline bool hasGnssMode () const;

    /**
     * Returns the value of the member "gnssMode".
     *
     * If the meaning of "gnssMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "gnssMode"
     */
    inline const ::std::string& getGnssMode () const;

    /**
     * Retrieves the value of the field "gnssMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "gnssMode".
     */
    inline ::std::string& getGnssModeMutable ();

    /**
     * Sets the value of the member "gnssMode".
     *
     * If the meaning of "gnssMode" isn't clear, then there should be a description here.
     *
     * @param gnssMode The value which will be set
     */
    inline void setGnssMode (const ::std::string& gnssMode_);

    /**
     * Sets the value of the member "gnssMode".
     *
     * If the meaning of "gnssMode" isn't clear, then there should be a description here.
     *
     * @param gnssMode The value which will be set
     */
    inline void setGnssMode (const char* gnssMode_);

    /**
     * Sets the value of the member "gnssMode".
     *
     * If the meaning of "gnssMode" isn't clear, then there should be a description here.
     *
     * @param gnssMode The value which will be set
     */
    inline void setGnssMode (const char* value, size_t size);

    // API of field "gnssSpeed"

    static const int kGnssSpeed = 4;

    /**
     * Clears the field "gnssSpeed".
     *
     * The field will be set to its default value. The hasGnssSpeed()
     * method will return false.
     */
    inline void clearGnssSpeed();

    /**
     * Checks whether the field "gnssSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssSpeed()). Otherwise it will return false.
     */
    inline bool hasGnssSpeed () const;

    /**
     * Returns the value of the member "gnssSpeed".
     *
     * speed value in m/s
     *
     * @return The value of the field "gnssSpeed"
     */
    inline uint16 getGnssSpeed () const;

    /**
     * Sets the value of the member "gnssSpeed".
     *
     * speed value in m/s
     *
     * @param gnssSpeed The value which will be set
     */
    inline void setGnssSpeed (uint16 gnssSpeed_);

    // API of field "gnssSpeedReliability"

    static const int kGnssSpeedReliability = 5;

    /**
     * Clears the field "gnssSpeedReliability".
     *
     * The field will be set to its default value. The hasGnssSpeedReliability()
     * method will return false.
     */
    inline void clearGnssSpeedReliability();

    /**
     * Checks whether the field "gnssSpeedReliability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssSpeedReliability()). Otherwise it will return false.
     */
    inline bool hasGnssSpeedReliability () const;

    /**
     * Returns the value of the member "gnssSpeedReliability".
     *
     * reliability of the speed value in %
     *
     * @return The value of the field "gnssSpeedReliability"
     */
    inline uint8 getGnssSpeedReliability () const;

    /**
     * Sets the value of the member "gnssSpeedReliability".
     *
     * reliability of the speed value in %
     *
     * @param gnssSpeedReliability The value which will be set
     */
    inline void setGnssSpeedReliability (uint8 gnssSpeedReliability_);

    // API of field "gnssPosition"

    static const int kGnssPosition = 6;

    /**
     * Clears the field "gnssPosition".
     *
     * The field will be set to its default value. The hasGnssPosition()
     * method will return false.
     */
    inline void clearGnssPosition();

    /**
     * Checks whether the field "gnssPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGnssPosition()). Otherwise it will return false.
     */
    inline bool hasGnssPosition () const;

    /**
     * Returns the value of the member "gnssPosition".
     *
     * If the meaning of "gnssPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "gnssPosition"
     */
    inline const PositionWGS84& getGnssPosition () const;

    /**
     * Retrieves the value of the field "gnssPosition" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "gnssPosition".
     */
    inline PositionWGS84& getGnssPositionMutable ();

    /**
     * Sets the value of the member "gnssPosition".
     *
     * If the meaning of "gnssPosition" isn't clear, then there should be a description here.
     *
     * @param gnssPosition The value which will be set
     */
    inline void setGnssPosition (const PositionWGS84& gnssPosition_);

    static const SatelliteInfo &getDefaultInstance();

private:

    inline void set_has_visibleSatellites ();

    inline void clear_has_visibleSatellites ();

    inline void set_has_receivedSatellites ();

    inline void clear_has_receivedSatellites ();

    inline void set_has_usedSatellites ();

    inline void clear_has_usedSatellites ();

    inline void set_has_gnssMode ();

    inline void clear_has_gnssMode ();

    inline void set_has_gnssSpeed ();

    inline void clear_has_gnssSpeed ();

    inline void set_has_gnssSpeedReliability ();

    inline void clear_has_gnssSpeedReliability ();

    inline void set_has_gnssPosition ();

    inline void clear_has_gnssPosition ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _visibleSatellites;

    uint8 _receivedSatellites;

    uint8 _usedSatellites;

    ::std::string _gnssMode;

    uint16 _gnssSpeed;

    uint8 _gnssSpeedReliability;

    PositionWGS84 _gnssPosition;

};

/**
 * this struct can transport additional flags per element of the address
 */
class SDSElementOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSElementOptions ();

    /**
     * Copy constructor
     */
    inline  SDSElementOptions (const SDSElementOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSElementOptions (bool isAmbigious_);

    /**
     * Destructor
     */
    inline  ~SDSElementOptions();

    /**
     * Assignment operator
     */
    inline SDSElementOptions& operator = (const SDSElementOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSElementOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSElementOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSElementOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSElementOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isAmbigious"

    static const int kIsAmbigious = 0;

    /**
     * Clears the field "isAmbigious".
     *
     * The field will be set to its default value. The hasIsAmbigious()
     * method will return false.
     */
    inline void clearIsAmbigious();

    /**
     * Checks whether the field "isAmbigious" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAmbigious()). Otherwise it will return false.
     */
    inline bool hasIsAmbigious () const;

    /**
     * Returns the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isAmbigious"
     */
    inline bool getIsAmbigious () const;

    /**
     * Sets the value of the member "isAmbigious".
     *
     * If the meaning of "isAmbigious" isn't clear, then there should be a description here.
     *
     * @param isAmbigious The value which will be set
     */
    inline void setIsAmbigious (bool isAmbigious_);

    static const SDSElementOptions &getDefaultInstance();

private:

    inline void set_has_isAmbigious ();

    inline void clear_has_isAmbigious ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isAmbigious;

};

/**
 * this struct includes addtional flags for the complete address
 */
class SDSAddressOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressOptions ();

    /**
     * Copy constructor
     */
    inline  SDSAddressOptions (const SDSAddressOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressOptions (bool navigable_, bool ambigious_, bool removedInvalidEntry_, bool moreEntriesPossible_, bool houseNumberAvailable_, bool houseNumberValid_);

    /**
     * Destructor
     */
    inline  ~SDSAddressOptions();

    /**
     * Assignment operator
     */
    inline SDSAddressOptions& operator = (const SDSAddressOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navigable"

    static const int kNavigable = 0;

    /**
     * Clears the field "navigable".
     *
     * The field will be set to its default value. The hasNavigable()
     * method will return false.
     */
    inline void clearNavigable();

    /**
     * Checks whether the field "navigable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigable()). Otherwise it will return false.
     */
    inline bool hasNavigable () const;

    /**
     * Returns the value of the member "navigable".
     *
     * If the meaning of "navigable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "navigable"
     */
    inline bool getNavigable () const;

    /**
     * Sets the value of the member "navigable".
     *
     * If the meaning of "navigable" isn't clear, then there should be a description here.
     *
     * @param navigable The value which will be set
     */
    inline void setNavigable (bool navigable_);

    // API of field "ambigious"

    static const int kAmbigious = 1;

    /**
     * Clears the field "ambigious".
     *
     * The field will be set to its default value. The hasAmbigious()
     * method will return false.
     */
    inline void clearAmbigious();

    /**
     * Checks whether the field "ambigious" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmbigious()). Otherwise it will return false.
     */
    inline bool hasAmbigious () const;

    /**
     * Returns the value of the member "ambigious".
     *
     * If the meaning of "ambigious" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ambigious"
     */
    inline bool getAmbigious () const;

    /**
     * Sets the value of the member "ambigious".
     *
     * If the meaning of "ambigious" isn't clear, then there should be a description here.
     *
     * @param ambigious The value which will be set
     */
    inline void setAmbigious (bool ambigious_);

    // API of field "removedInvalidEntry"

    static const int kRemovedInvalidEntry = 2;

    /**
     * Clears the field "removedInvalidEntry".
     *
     * The field will be set to its default value. The hasRemovedInvalidEntry()
     * method will return false.
     */
    inline void clearRemovedInvalidEntry();

    /**
     * Checks whether the field "removedInvalidEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemovedInvalidEntry()). Otherwise it will return false.
     */
    inline bool hasRemovedInvalidEntry () const;

    /**
     * Returns the value of the member "removedInvalidEntry".
     *
     * If the meaning of "removedInvalidEntry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removedInvalidEntry"
     */
    inline bool getRemovedInvalidEntry () const;

    /**
     * Sets the value of the member "removedInvalidEntry".
     *
     * If the meaning of "removedInvalidEntry" isn't clear, then there should be a description here.
     *
     * @param removedInvalidEntry The value which will be set
     */
    inline void setRemovedInvalidEntry (bool removedInvalidEntry_);

    // API of field "moreEntriesPossible"

    static const int kMoreEntriesPossible = 3;

    /**
     * Clears the field "moreEntriesPossible".
     *
     * The field will be set to its default value. The hasMoreEntriesPossible()
     * method will return false.
     */
    inline void clearMoreEntriesPossible();

    /**
     * Checks whether the field "moreEntriesPossible" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMoreEntriesPossible()). Otherwise it will return false.
     */
    inline bool hasMoreEntriesPossible () const;

    /**
     * Returns the value of the member "moreEntriesPossible".
     *
     * If the meaning of "moreEntriesPossible" isn't clear, then there should be a description here.
     *
     * @return The value of the field "moreEntriesPossible"
     */
    inline bool getMoreEntriesPossible () const;

    /**
     * Sets the value of the member "moreEntriesPossible".
     *
     * If the meaning of "moreEntriesPossible" isn't clear, then there should be a description here.
     *
     * @param moreEntriesPossible The value which will be set
     */
    inline void setMoreEntriesPossible (bool moreEntriesPossible_);

    // API of field "houseNumberAvailable"

    static const int kHouseNumberAvailable = 4;

    /**
     * Clears the field "houseNumberAvailable".
     *
     * The field will be set to its default value. The hasHouseNumberAvailable()
     * method will return false.
     */
    inline void clearHouseNumberAvailable();

    /**
     * Checks whether the field "houseNumberAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseNumberAvailable()). Otherwise it will return false.
     */
    inline bool hasHouseNumberAvailable () const;

    /**
     * Returns the value of the member "houseNumberAvailable".
     *
     * If the meaning of "houseNumberAvailable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseNumberAvailable"
     */
    inline bool getHouseNumberAvailable () const;

    /**
     * Sets the value of the member "houseNumberAvailable".
     *
     * If the meaning of "houseNumberAvailable" isn't clear, then there should be a description here.
     *
     * @param houseNumberAvailable The value which will be set
     */
    inline void setHouseNumberAvailable (bool houseNumberAvailable_);

    // API of field "houseNumberValid"

    static const int kHouseNumberValid = 5;

    /**
     * Clears the field "houseNumberValid".
     *
     * The field will be set to its default value. The hasHouseNumberValid()
     * method will return false.
     */
    inline void clearHouseNumberValid();

    /**
     * Checks whether the field "houseNumberValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseNumberValid()). Otherwise it will return false.
     */
    inline bool hasHouseNumberValid () const;

    /**
     * Returns the value of the member "houseNumberValid".
     *
     * If the meaning of "houseNumberValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseNumberValid"
     */
    inline bool getHouseNumberValid () const;

    /**
     * Sets the value of the member "houseNumberValid".
     *
     * If the meaning of "houseNumberValid" isn't clear, then there should be a description here.
     *
     * @param houseNumberValid The value which will be set
     */
    inline void setHouseNumberValid (bool houseNumberValid_);

    static const SDSAddressOptions &getDefaultInstance();

private:

    inline void set_has_navigable ();

    inline void clear_has_navigable ();

    inline void set_has_ambigious ();

    inline void clear_has_ambigious ();

    inline void set_has_removedInvalidEntry ();

    inline void clear_has_removedInvalidEntry ();

    inline void set_has_moreEntriesPossible ();

    inline void clear_has_moreEntriesPossible ();

    inline void set_has_houseNumberAvailable ();

    inline void clear_has_houseNumberAvailable ();

    inline void set_has_houseNumberValid ();

    inline void clear_has_houseNumberValid ();

    uint32 _has_bits_[ (6 + 31) / 32];

    bool _navigable;

    bool _ambigious;

    bool _removedInvalidEntry;

    bool _moreEntriesPossible;

    bool _houseNumberAvailable;

    bool _houseNumberValid;

};

/**
 * struct of an element of the address entries with type and options
 */
class SDSAddressElement {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressElement ();

    /**
     * Copy constructor
     */
    inline  SDSAddressElement (const SDSAddressElement &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressElement (SDSAddressElementType addressElementType_, const ::std::string& data_, const SDSElementOptions& elementOptions_);

    /**
     * Destructor
     */
    inline  ~SDSAddressElement();

    /**
     * Assignment operator
     */
    inline SDSAddressElement& operator = (const SDSAddressElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "addressElementType"

    static const int kAddressElementType = 0;

    /**
     * Clears the field "addressElementType".
     *
     * The field will be set to its default value. The hasAddressElementType()
     * method will return false.
     */
    inline void clearAddressElementType();

    /**
     * Checks whether the field "addressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressElementType()). Otherwise it will return false.
     */
    inline bool hasAddressElementType () const;

    /**
     * Returns the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressElementType"
     */
    inline SDSAddressElementType getAddressElementType () const;

    /**
     * Sets the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @param addressElementType The value which will be set
     */
    inline void setAddressElementType (SDSAddressElementType addressElementType_);

    // API of field "data"

    static const int kData = 1;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "elementOptions"

    static const int kElementOptions = 2;

    /**
     * Clears the field "elementOptions".
     *
     * The field will be set to its default value. The hasElementOptions()
     * method will return false.
     */
    inline void clearElementOptions();

    /**
     * Checks whether the field "elementOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElementOptions()). Otherwise it will return false.
     */
    inline bool hasElementOptions () const;

    /**
     * Returns the value of the member "elementOptions".
     *
     * If the meaning of "elementOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elementOptions"
     */
    inline const SDSElementOptions& getElementOptions () const;

    /**
     * Retrieves the value of the field "elementOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elementOptions".
     */
    inline SDSElementOptions& getElementOptionsMutable ();

    /**
     * Sets the value of the member "elementOptions".
     *
     * If the meaning of "elementOptions" isn't clear, then there should be a description here.
     *
     * @param elementOptions The value which will be set
     */
    inline void setElementOptions (const SDSElementOptions& elementOptions_);

    static const SDSAddressElement &getDefaultInstance();

private:

    inline void set_has_addressElementType ();

    inline void clear_has_addressElementType ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_elementOptions ();

    inline void clear_has_elementOptions ();

    uint32 _has_bits_[ (3 + 31) / 32];

    SDSAddressElementType _addressElementType;

    ::std::string _data;

    SDSElementOptions _elementOptions;

};

/**
 * struct for an address with options and possible extension types
 */
class SDSAddressWithOptions {
public:

    /**
     * Default constructor
     */
    inline  SDSAddressWithOptions ();

    /**
     * Copy constructor
     */
    inline  SDSAddressWithOptions (const SDSAddressWithOptions &rhs);

    /**
     * All fields constructor
     */
    inline  SDSAddressWithOptions (const ::std::vector< SDSAddressElement >& address_, const SDSAddressOptions& addressOptions_, const ::std::vector< SDSAddressElementType >& addressElementType_);

    /**
     * Destructor
     */
    inline  ~SDSAddressWithOptions();

    /**
     * Assignment operator
     */
    inline SDSAddressWithOptions& operator = (const SDSAddressWithOptions& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSAddressWithOptions& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSAddressWithOptions& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSAddressWithOptions& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSAddressWithOptions& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::vector< SDSAddressElement >& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::vector< SDSAddressElement >& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::vector< SDSAddressElement >& address_);

    // API of field "addressOptions"

    static const int kAddressOptions = 1;

    /**
     * Clears the field "addressOptions".
     *
     * The field will be set to its default value. The hasAddressOptions()
     * method will return false.
     */
    inline void clearAddressOptions();

    /**
     * Checks whether the field "addressOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressOptions()). Otherwise it will return false.
     */
    inline bool hasAddressOptions () const;

    /**
     * Returns the value of the member "addressOptions".
     *
     * If the meaning of "addressOptions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressOptions"
     */
    inline const SDSAddressOptions& getAddressOptions () const;

    /**
     * Retrieves the value of the field "addressOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressOptions".
     */
    inline SDSAddressOptions& getAddressOptionsMutable ();

    /**
     * Sets the value of the member "addressOptions".
     *
     * If the meaning of "addressOptions" isn't clear, then there should be a description here.
     *
     * @param addressOptions The value which will be set
     */
    inline void setAddressOptions (const SDSAddressOptions& addressOptions_);

    // API of field "addressElementType"

    static const int kAddressElementType = 2;

    /**
     * Clears the field "addressElementType".
     *
     * The field will be set to its default value. The hasAddressElementType()
     * method will return false.
     */
    inline void clearAddressElementType();

    /**
     * Checks whether the field "addressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressElementType()). Otherwise it will return false.
     */
    inline bool hasAddressElementType () const;

    /**
     * Returns the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressElementType"
     */
    inline const ::std::vector< SDSAddressElementType >& getAddressElementType () const;

    /**
     * Retrieves the value of the field "addressElementType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressElementType".
     */
    inline ::std::vector< SDSAddressElementType >& getAddressElementTypeMutable ();

    /**
     * Sets the value of the member "addressElementType".
     *
     * If the meaning of "addressElementType" isn't clear, then there should be a description here.
     *
     * @param addressElementType The value which will be set
     */
    inline void setAddressElementType (const ::std::vector< SDSAddressElementType >& addressElementType_);

    static const SDSAddressWithOptions &getDefaultInstance();

private:

    static const ::std::vector< SDSAddressElement >& getSDSAddressElementList_DefaultInstance ();

    static const ::std::vector< SDSAddressElementType >& getSDSAddressElementTypeList_DefaultInstance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_addressOptions ();

    inline void clear_has_addressOptions ();

    inline void set_has_addressElementType ();

    inline void clear_has_addressElementType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< SDSAddressElement > _address;

    SDSAddressOptions _addressOptions;

    ::std::vector< SDSAddressElementType > _addressElementType;

};

/**
 * struct contain destination information about currently guided tour
 */
class DestinationInfoElement {
public:

    /**
     * Default constructor
     */
    inline  DestinationInfoElement ();

    /**
     * Copy constructor
     */
    inline  DestinationInfoElement (const DestinationInfoElement &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationInfoElement (const PositionWGS84& location_, const ::std::string& countryCode_, const ::std::string& subCountryCode_, const ::std::string& name_);

    /**
     * Destructor
     */
    inline  ~DestinationInfoElement();

    /**
     * Assignment operator
     */
    inline DestinationInfoElement& operator = (const DestinationInfoElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationInfoElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationInfoElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationInfoElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationInfoElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const PositionWGS84& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline PositionWGS84& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const PositionWGS84& location_);

    // API of field "countryCode"

    static const int kCountryCode = 1;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "subCountryCode"

    static const int kSubCountryCode = 2;

    /**
     * Clears the field "subCountryCode".
     *
     * The field will be set to its default value. The hasSubCountryCode()
     * method will return false.
     */
    inline void clearSubCountryCode();

    /**
     * Checks whether the field "subCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubCountryCode()). Otherwise it will return false.
     */
    inline bool hasSubCountryCode () const;

    /**
     * Returns the value of the member "subCountryCode".
     *
     * If the meaning of "subCountryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subCountryCode"
     */
    inline const ::std::string& getSubCountryCode () const;

    /**
     * Retrieves the value of the field "subCountryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "subCountryCode".
     */
    inline ::std::string& getSubCountryCodeMutable ();

    /**
     * Sets the value of the member "subCountryCode".
     *
     * If the meaning of "subCountryCode" isn't clear, then there should be a description here.
     *
     * @param subCountryCode The value which will be set
     */
    inline void setSubCountryCode (const ::std::string& subCountryCode_);

    /**
     * Sets the value of the member "subCountryCode".
     *
     * If the meaning of "subCountryCode" isn't clear, then there should be a description here.
     *
     * @param subCountryCode The value which will be set
     */
    inline void setSubCountryCode (const char* subCountryCode_);

    /**
     * Sets the value of the member "subCountryCode".
     *
     * If the meaning of "subCountryCode" isn't clear, then there should be a description here.
     *
     * @param subCountryCode The value which will be set
     */
    inline void setSubCountryCode (const char* value, size_t size);

    // API of field "name"

    static const int kName = 3;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const DestinationInfoElement &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_subCountryCode ();

    inline void clear_has_subCountryCode ();

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (4 + 31) / 32];

    PositionWGS84 _location;

    ::std::string _countryCode;

    ::std::string _subCountryCode;

    ::std::string _name;

};

/**
 * If the meaning of "RefinementListElement" isn't clear, then there should be a description here.
 */
class RefinementListElement {
public:

    /**
     * Default constructor
     */
    inline  RefinementListElement ();

    /**
     * Copy constructor
     */
    inline  RefinementListElement (const RefinementListElement &rhs);

    /**
     * All fields constructor
     */
    inline  RefinementListElement (const ::std::string& data_, uint32 id_, const ::std::string& distance_, DirectionDescription direction_);

    /**
     * Destructor
     */
    inline  ~RefinementListElement();

    /**
     * Assignment operator
     */
    inline RefinementListElement& operator = (const RefinementListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RefinementListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RefinementListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RefinementListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RefinementListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * Element Name
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * Element Name
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "id"

    static const int kId = 1;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    // API of field "distance"

    static const int kDistance = 2;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "direction"

    static const int kDirection = 3;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @return The value of the field "direction"
     */
    inline DirectionDescription getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @param direction The value which will be set
     */
    inline void setDirection (DirectionDescription direction_);

    static const RefinementListElement &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _data;

    uint32 _id;

    ::std::string _distance;

    DirectionDescription _direction;

};

/**
 * struct contains Global/common ids of selected elements
 */
class GlobalUpdateRegionId {
public:

    /**
     * Default constructor
     */
    inline  GlobalUpdateRegionId ();

    /**
     * Copy constructor
     */
    inline  GlobalUpdateRegionId (const GlobalUpdateRegionId &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalUpdateRegionId (int16 updateRegionId_, int32 productId_, int8 supplierId_);

    /**
     * Destructor
     */
    inline  ~GlobalUpdateRegionId();

    /**
     * Assignment operator
     */
    inline GlobalUpdateRegionId& operator = (const GlobalUpdateRegionId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalUpdateRegionId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalUpdateRegionId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalUpdateRegionId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalUpdateRegionId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "updateRegionId"

    static const int kUpdateRegionId = 0;

    /**
     * Clears the field "updateRegionId".
     *
     * The field will be set to its default value. The hasUpdateRegionId()
     * method will return false.
     */
    inline void clearUpdateRegionId();

    /**
     * Checks whether the field "updateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasUpdateRegionId () const;

    /**
     * Returns the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "updateRegionId"
     */
    inline int16 getUpdateRegionId () const;

    /**
     * Sets the value of the member "updateRegionId".
     *
     * If the meaning of "updateRegionId" isn't clear, then there should be a description here.
     *
     * @param updateRegionId The value which will be set
     */
    inline void setUpdateRegionId (int16 updateRegionId_);

    // API of field "productId"

    static const int kProductId = 1;

    /**
     * Clears the field "productId".
     *
     * The field will be set to its default value. The hasProductId()
     * method will return false.
     */
    inline void clearProductId();

    /**
     * Checks whether the field "productId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductId()). Otherwise it will return false.
     */
    inline bool hasProductId () const;

    /**
     * Returns the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "productId"
     */
    inline int32 getProductId () const;

    /**
     * Sets the value of the member "productId".
     *
     * If the meaning of "productId" isn't clear, then there should be a description here.
     *
     * @param productId The value which will be set
     */
    inline void setProductId (int32 productId_);

    // API of field "supplierId"

    static const int kSupplierId = 2;

    /**
     * Clears the field "supplierId".
     *
     * The field will be set to its default value. The hasSupplierId()
     * method will return false.
     */
    inline void clearSupplierId();

    /**
     * Checks whether the field "supplierId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupplierId()). Otherwise it will return false.
     */
    inline bool hasSupplierId () const;

    /**
     * Returns the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "supplierId"
     */
    inline int8 getSupplierId () const;

    /**
     * Sets the value of the member "supplierId".
     *
     * If the meaning of "supplierId" isn't clear, then there should be a description here.
     *
     * @param supplierId The value which will be set
     */
    inline void setSupplierId (int8 supplierId_);

    static const GlobalUpdateRegionId &getDefaultInstance();

private:

    inline void set_has_updateRegionId ();

    inline void clear_has_updateRegionId ();

    inline void set_has_productId ();

    inline void clear_has_productId ();

    inline void set_has_supplierId ();

    inline void clear_has_supplierId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int16 _updateRegionId;

    int32 _productId;

    int8 _supplierId;

};

/**
 * Need to move to common type
 */
class GlobalNamedObjectId {
public:

    /**
     * Default constructor
     */
    inline  GlobalNamedObjectId ();

    /**
     * Copy constructor
     */
    inline  GlobalNamedObjectId (const GlobalNamedObjectId &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalNamedObjectId (const GlobalUpdateRegionId& globalUpdateRegionId_, uint32 namedObjectId_, bool isValid_);

    /**
     * Destructor
     */
    inline  ~GlobalNamedObjectId();

    /**
     * Assignment operator
     */
    inline GlobalNamedObjectId& operator = (const GlobalNamedObjectId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalNamedObjectId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalNamedObjectId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalNamedObjectId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalNamedObjectId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "globalUpdateRegionId"

    static const int kGlobalUpdateRegionId = 0;

    /**
     * Clears the field "globalUpdateRegionId".
     *
     * The field will be set to its default value. The hasGlobalUpdateRegionId()
     * method will return false.
     */
    inline void clearGlobalUpdateRegionId();

    /**
     * Checks whether the field "globalUpdateRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobalUpdateRegionId()). Otherwise it will return false.
     */
    inline bool hasGlobalUpdateRegionId () const;

    /**
     * Returns the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "globalUpdateRegionId"
     */
    inline const GlobalUpdateRegionId& getGlobalUpdateRegionId () const;

    /**
     * Retrieves the value of the field "globalUpdateRegionId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "globalUpdateRegionId".
     */
    inline GlobalUpdateRegionId& getGlobalUpdateRegionIdMutable ();

    /**
     * Sets the value of the member "globalUpdateRegionId".
     *
     * If the meaning of "globalUpdateRegionId" isn't clear, then there should be a description here.
     *
     * @param globalUpdateRegionId The value which will be set
     */
    inline void setGlobalUpdateRegionId (const GlobalUpdateRegionId& globalUpdateRegionId_);

    // API of field "namedObjectId"

    static const int kNamedObjectId = 1;

    /**
     * Clears the field "namedObjectId".
     *
     * The field will be set to its default value. The hasNamedObjectId()
     * method will return false.
     */
    inline void clearNamedObjectId();

    /**
     * Checks whether the field "namedObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNamedObjectId()). Otherwise it will return false.
     */
    inline bool hasNamedObjectId () const;

    /**
     * Returns the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "namedObjectId"
     */
    inline uint32 getNamedObjectId () const;

    /**
     * Sets the value of the member "namedObjectId".
     *
     * If the meaning of "namedObjectId" isn't clear, then there should be a description here.
     *
     * @param namedObjectId The value which will be set
     */
    inline void setNamedObjectId (uint32 namedObjectId_);

    // API of field "isValid"

    static const int kIsValid = 2;

    /**
     * Clears the field "isValid".
     *
     * The field will be set to its default value. The hasIsValid()
     * method will return false.
     */
    inline void clearIsValid();

    /**
     * Checks whether the field "isValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsValid()). Otherwise it will return false.
     */
    inline bool hasIsValid () const;

    /**
     * Returns the value of the member "isValid".
     *
     * If the meaning of "isValid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isValid"
     */
    inline bool getIsValid () const;

    /**
     * Sets the value of the member "isValid".
     *
     * If the meaning of "isValid" isn't clear, then there should be a description here.
     *
     * @param isValid The value which will be set
     */
    inline void setIsValid (bool isValid_);

    static const GlobalNamedObjectId &getDefaultInstance();

private:

    inline void set_has_globalUpdateRegionId ();

    inline void clear_has_globalUpdateRegionId ();

    inline void set_has_namedObjectId ();

    inline void clear_has_namedObjectId ();

    inline void set_has_isValid ();

    inline void clear_has_isValid ();

    uint32 _has_bits_[ (3 + 31) / 32];

    GlobalUpdateRegionId _globalUpdateRegionId;

    uint32 _namedObjectId;

    bool _isValid;

};

/**
 * If the meaning of "AddressListElement" isn't clear, then there should be a description here.
 */
class AddressListElement {
public:

    /**
     * Default constructor
     */
    inline  AddressListElement ();

    /**
     * Copy constructor
     */
    inline  AddressListElement (const AddressListElement &rhs);

    /**
     * All fields constructor
     */
    inline  AddressListElement (const ::std::string& data_, uint64 id_, const ::std::string& distance_, const ::std::string& address_, DirectionDescription direction_, const PositionWGS84& coordinates_, const GlobalNamedObjectId& sdsNameObjectId_);

    /**
     * Destructor
     */
    inline  ~AddressListElement();

    /**
     * Assignment operator
     */
    inline AddressListElement& operator = (const AddressListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddressListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddressListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddressListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddressListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @return The value of the field "data"
     */
    inline const ::std::string& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::string& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::string& data_);

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const char* data_);

    /**
     * Sets the value of the member "data".
     *
     * data is the Name for the FTS search result
     *
     * @param data The value which will be set
     */
    inline void setData (const char* value, size_t size);

    // API of field "id"

    static const int kId = 1;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * id is the identifier for the Search item, Should be used when item is selected for Starting Route Guidance
     *
     * @return The value of the field "id"
     */
    inline uint64 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * id is the identifier for the Search item, Should be used when item is selected for Starting Route Guidance
     *
     * @param id The value which will be set
     */
    inline void setId (uint64 id_);

    // API of field "distance"

    static const int kDistance = 2;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Air distance from Current Car Position
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "address"

    static const int kAddress = 3;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * Poi address description
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * Poi address description
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "direction"

    static const int kDirection = 4;

    /**
     * Clears the field "direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @return The value of the field "direction"
     */
    inline DirectionDescription getDirection () const;

    /**
     * Sets the value of the member "direction".
     *
     * direction relative to car heading
     *
     * @param direction The value which will be set
     */
    inline void setDirection (DirectionDescription direction_);

    // API of field "coordinates"

    static const int kCoordinates = 5;

    /**
     * Clears the field "coordinates".
     *
     * The field will be set to its default value. The hasCoordinates()
     * method will return false.
     */
    inline void clearCoordinates();

    /**
     * Checks whether the field "coordinates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoordinates()). Otherwise it will return false.
     */
    inline bool hasCoordinates () const;

    /**
     * Returns the value of the member "coordinates".
     *
     * coordinates consists of longitude and latitude, invalid coordinates is represented with (0.0,0.0)
     *
     * @return The value of the field "coordinates"
     */
    inline const PositionWGS84& getCoordinates () const;

    /**
     * Retrieves the value of the field "coordinates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "coordinates".
     */
    inline PositionWGS84& getCoordinatesMutable ();

    /**
     * Sets the value of the member "coordinates".
     *
     * coordinates consists of longitude and latitude, invalid coordinates is represented with (0.0,0.0)
     *
     * @param coordinates The value which will be set
     */
    inline void setCoordinates (const PositionWGS84& coordinates_);

    // API of field "sdsNameObjectId"

    static const int kSdsNameObjectId = 6;

    /**
     * Clears the field "sdsNameObjectId".
     *
     * The field will be set to its default value. The hasSdsNameObjectId()
     * method will return false.
     */
    inline void clearSdsNameObjectId();

    /**
     * Checks whether the field "sdsNameObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsNameObjectId()). Otherwise it will return false.
     */
    inline bool hasSdsNameObjectId () const;

    /**
     * Returns the value of the member "sdsNameObjectId".
     *
     * GlobalNamedObjectId consists of object ID for SDS
     *
     * @return The value of the field "sdsNameObjectId"
     */
    inline const GlobalNamedObjectId& getSdsNameObjectId () const;

    /**
     * Retrieves the value of the field "sdsNameObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsNameObjectId".
     */
    inline GlobalNamedObjectId& getSdsNameObjectIdMutable ();

    /**
     * Sets the value of the member "sdsNameObjectId".
     *
     * GlobalNamedObjectId consists of object ID for SDS
     *
     * @param sdsNameObjectId The value which will be set
     */
    inline void setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_);

    static const AddressListElement &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_id ();

    inline void clear_has_id ();

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_direction ();

    inline void clear_has_direction ();

    inline void set_has_coordinates ();

    inline void clear_has_coordinates ();

    inline void set_has_sdsNameObjectId ();

    inline void clear_has_sdsNameObjectId ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _data;

    uint64 _id;

    ::std::string _distance;

    ::std::string _address;

    DirectionDescription _direction;

    PositionWGS84 _coordinates;

    GlobalNamedObjectId _sdsNameObjectId;

};

/**
 * If the meaning of "DeformedImage" isn't clear, then there should be a description here.
 */
class DeformedImage {
public:

    /**
     * Default constructor
     */
    inline  DeformedImage ();

    /**
     * Copy constructor
     */
    inline  DeformedImage (const DeformedImage &rhs);

    /**
     * All fields constructor
     */
    inline  DeformedImage (bool valid_, DeformedImageRoadType deformedImageRoadType_, DeformedImageArrowType deformedImageArrowType_);

    /**
     * Destructor
     */
    inline  ~DeformedImage();

    /**
     * Assignment operator
     */
    inline DeformedImage& operator = (const DeformedImage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeformedImage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeformedImage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeformedImage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeformedImage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "valid"

    static const int kValid = 0;

    /**
     * Clears the field "valid".
     *
     * The field will be set to its default value. The hasValid()
     * method will return false.
     */
    inline void clearValid();

    /**
     * Checks whether the field "valid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValid()). Otherwise it will return false.
     */
    inline bool hasValid () const;

    /**
     * Returns the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "valid"
     */
    inline bool getValid () const;

    /**
     * Sets the value of the member "valid".
     *
     * If the meaning of "valid" isn't clear, then there should be a description here.
     *
     * @param valid The value which will be set
     */
    inline void setValid (bool valid_);

    // API of field "deformedImageRoadType"

    static const int kDeformedImageRoadType = 1;

    /**
     * Clears the field "deformedImageRoadType".
     *
     * The field will be set to its default value. The hasDeformedImageRoadType()
     * method will return false.
     */
    inline void clearDeformedImageRoadType();

    /**
     * Checks whether the field "deformedImageRoadType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeformedImageRoadType()). Otherwise it will return false.
     */
    inline bool hasDeformedImageRoadType () const;

    /**
     * Returns the value of the member "deformedImageRoadType".
     *
     * If the meaning of "deformedImageRoadType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deformedImageRoadType"
     */
    inline DeformedImageRoadType getDeformedImageRoadType () const;

    /**
     * Sets the value of the member "deformedImageRoadType".
     *
     * If the meaning of "deformedImageRoadType" isn't clear, then there should be a description here.
     *
     * @param deformedImageRoadType The value which will be set
     */
    inline void setDeformedImageRoadType (DeformedImageRoadType deformedImageRoadType_);

    // API of field "deformedImageArrowType"

    static const int kDeformedImageArrowType = 2;

    /**
     * Clears the field "deformedImageArrowType".
     *
     * The field will be set to its default value. The hasDeformedImageArrowType()
     * method will return false.
     */
    inline void clearDeformedImageArrowType();

    /**
     * Checks whether the field "deformedImageArrowType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeformedImageArrowType()). Otherwise it will return false.
     */
    inline bool hasDeformedImageArrowType () const;

    /**
     * Returns the value of the member "deformedImageArrowType".
     *
     * If the meaning of "deformedImageArrowType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deformedImageArrowType"
     */
    inline DeformedImageArrowType getDeformedImageArrowType () const;

    /**
     * Sets the value of the member "deformedImageArrowType".
     *
     * If the meaning of "deformedImageArrowType" isn't clear, then there should be a description here.
     *
     * @param deformedImageArrowType The value which will be set
     */
    inline void setDeformedImageArrowType (DeformedImageArrowType deformedImageArrowType_);

    static const DeformedImage &getDefaultInstance();

private:

    inline void set_has_valid ();

    inline void clear_has_valid ();

    inline void set_has_deformedImageRoadType ();

    inline void clear_has_deformedImageRoadType ();

    inline void set_has_deformedImageArrowType ();

    inline void clear_has_deformedImageArrowType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _valid;

    DeformedImageRoadType _deformedImageRoadType;

    DeformedImageArrowType _deformedImageArrowType;

};

/**
 * struct contain inserted waypoint
 */
class WaypointListElement {
public:

    /**
     * Default constructor
     */
    inline  WaypointListElement ();

    /**
     * Copy constructor
     */
    inline  WaypointListElement (const WaypointListElement &rhs);

    /**
     * All fields constructor
     */
    inline  WaypointListElement (const PositionWGS84& location_, RouteCriterion routeCriterion_, const ::std::string& name_);

    /**
     * Destructor
     */
    inline  ~WaypointListElement();

    /**
     * Assignment operator
     */
    inline WaypointListElement& operator = (const WaypointListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaypointListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaypointListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaypointListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaypointListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const PositionWGS84& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline PositionWGS84& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const PositionWGS84& location_);

    // API of field "routeCriterion"

    static const int kRouteCriterion = 1;

    /**
     * Clears the field "routeCriterion".
     *
     * The field will be set to its default value. The hasRouteCriterion()
     * method will return false.
     */
    inline void clearRouteCriterion();

    /**
     * Checks whether the field "routeCriterion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCriterion()). Otherwise it will return false.
     */
    inline bool hasRouteCriterion () const;

    /**
     * Returns the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "routeCriterion"
     */
    inline RouteCriterion getRouteCriterion () const;

    /**
     * Sets the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @param routeCriterion The value which will be set
     */
    inline void setRouteCriterion (RouteCriterion routeCriterion_);

    // API of field "name"

    static const int kName = 2;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const WaypointListElement &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_routeCriterion ();

    inline void clear_has_routeCriterion ();

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (3 + 31) / 32];

    PositionWGS84 _location;

    RouteCriterion _routeCriterion;

    ::std::string _name;

};

/**
 * If the meaning of "ManeuverView" isn't clear, then there should be a description here.
 */
class ManeuverView {
public:

    /**
     * Default constructor
     */
    inline  ManeuverView ();

    /**
     * Copy constructor
     */
    inline  ManeuverView (const ManeuverView &rhs);

    /**
     * All fields constructor
     */
    inline  ManeuverView (uint32 maneuverId_, ManeuverViewType maneuverViewType_, const DeformedImage& deformedImage_);

    /**
     * Destructor
     */
    inline  ~ManeuverView();

    /**
     * Assignment operator
     */
    inline ManeuverView& operator = (const ManeuverView& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManeuverView& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManeuverView& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManeuverView& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManeuverView& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverId"

    static const int kManeuverId = 0;

    /**
     * Clears the field "maneuverId".
     *
     * The field will be set to its default value. The hasManeuverId()
     * method will return false.
     */
    inline void clearManeuverId();

    /**
     * Checks whether the field "maneuverId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverId()). Otherwise it will return false.
     */
    inline bool hasManeuverId () const;

    /**
     * Returns the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maneuverId"
     */
    inline uint32 getManeuverId () const;

    /**
     * Sets the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @param maneuverId The value which will be set
     */
    inline void setManeuverId (uint32 maneuverId_);

    // API of field "maneuverViewType"

    static const int kManeuverViewType = 1;

    /**
     * Clears the field "maneuverViewType".
     *
     * The field will be set to its default value. The hasManeuverViewType()
     * method will return false.
     */
    inline void clearManeuverViewType();

    /**
     * Checks whether the field "maneuverViewType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverViewType()). Otherwise it will return false.
     */
    inline bool hasManeuverViewType () const;

    /**
     * Returns the value of the member "maneuverViewType".
     *
     * If the meaning of "maneuverViewType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maneuverViewType"
     */
    inline ManeuverViewType getManeuverViewType () const;

    /**
     * Sets the value of the member "maneuverViewType".
     *
     * If the meaning of "maneuverViewType" isn't clear, then there should be a description here.
     *
     * @param maneuverViewType The value which will be set
     */
    inline void setManeuverViewType (ManeuverViewType maneuverViewType_);

    // API of field "deformedImage"

    static const int kDeformedImage = 2;

    /**
     * Clears the field "deformedImage".
     *
     * The field will be set to its default value. The hasDeformedImage()
     * method will return false.
     */
    inline void clearDeformedImage();

    /**
     * Checks whether the field "deformedImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeformedImage()). Otherwise it will return false.
     */
    inline bool hasDeformedImage () const;

    /**
     * Returns the value of the member "deformedImage".
     *
     * If the meaning of "deformedImage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "deformedImage"
     */
    inline const DeformedImage& getDeformedImage () const;

    /**
     * Retrieves the value of the field "deformedImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "deformedImage".
     */
    inline DeformedImage& getDeformedImageMutable ();

    /**
     * Sets the value of the member "deformedImage".
     *
     * If the meaning of "deformedImage" isn't clear, then there should be a description here.
     *
     * @param deformedImage The value which will be set
     */
    inline void setDeformedImage (const DeformedImage& deformedImage_);

    static const ManeuverView &getDefaultInstance();

private:

    inline void set_has_maneuverId ();

    inline void clear_has_maneuverId ();

    inline void set_has_maneuverViewType ();

    inline void clear_has_maneuverViewType ();

    inline void set_has_deformedImage ();

    inline void clear_has_deformedImage ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _maneuverId;

    ManeuverViewType _maneuverViewType;

    DeformedImage _deformedImage;

};

/**
 * struct contains position in pixel on the screen
 */
class ScreenCoordinate {
public:

    /**
     * Default constructor
     */
    inline  ScreenCoordinate ();

    /**
     * Copy constructor
     */
    inline  ScreenCoordinate (const ScreenCoordinate &rhs);

    /**
     * All fields constructor
     */
    inline  ScreenCoordinate (uint32 xPos_, uint32 yPos_);

    /**
     * Destructor
     */
    inline  ~ScreenCoordinate();

    /**
     * Assignment operator
     */
    inline ScreenCoordinate& operator = (const ScreenCoordinate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScreenCoordinate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScreenCoordinate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScreenCoordinate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScreenCoordinate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "xPos"

    static const int kXPos = 0;

    /**
     * Clears the field "xPos".
     *
     * The field will be set to its default value. The hasXPos()
     * method will return false.
     */
    inline void clearXPos();

    /**
     * Checks whether the field "xPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXPos()). Otherwise it will return false.
     */
    inline bool hasXPos () const;

    /**
     * Returns the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xPos"
     */
    inline uint32 getXPos () const;

    /**
     * Sets the value of the member "xPos".
     *
     * If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param xPos The value which will be set
     */
    inline void setXPos (uint32 xPos_);

    // API of field "yPos"

    static const int kYPos = 1;

    /**
     * Clears the field "yPos".
     *
     * The field will be set to its default value. The hasYPos()
     * method will return false.
     */
    inline void clearYPos();

    /**
     * Checks whether the field "yPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYPos()). Otherwise it will return false.
     */
    inline bool hasYPos () const;

    /**
     * Returns the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @return The value of the field "yPos"
     */
    inline uint32 getYPos () const;

    /**
     * Sets the value of the member "yPos".
     *
     * If the meaning of "yPos" isn't clear, then there should be a description here.
     *
     * @param yPos The value which will be set
     */
    inline void setYPos (uint32 yPos_);

    static const ScreenCoordinate &getDefaultInstance();

private:

    inline void set_has_xPos ();

    inline void clear_has_xPos ();

    inline void set_has_yPos ();

    inline void clear_has_yPos ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _xPos;

    uint32 _yPos;

};

/**
 * If the meaning of "IntersectionMapRoadLine" isn't clear, then there should be a description here.
 */
class IntersectionMapRoadLine {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapRoadLine ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapRoadLine (const IntersectionMapRoadLine &rhs);

    /**
     * All fields constructor
     */
    inline  IntersectionMapRoadLine (const ::std::vector< ScreenCoordinate >& coordinates_, AdminRoadClass roadClass_);

    /**
     * Destructor
     */
    inline  ~IntersectionMapRoadLine();

    /**
     * Assignment operator
     */
    inline IntersectionMapRoadLine& operator = (const IntersectionMapRoadLine& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapRoadLine& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapRoadLine& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapRoadLine& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapRoadLine& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "coordinates"

    static const int kCoordinates = 0;

    /**
     * Clears the field "coordinates".
     *
     * The field will be set to its default value. The hasCoordinates()
     * method will return false.
     */
    inline void clearCoordinates();

    /**
     * Checks whether the field "coordinates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoordinates()). Otherwise it will return false.
     */
    inline bool hasCoordinates () const;

    /**
     * Returns the value of the member "coordinates".
     *
     * If the meaning of "coordinates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "coordinates"
     */
    inline const ::std::vector< ScreenCoordinate >& getCoordinates () const;

    /**
     * Retrieves the value of the field "coordinates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "coordinates".
     */
    inline ::std::vector< ScreenCoordinate >& getCoordinatesMutable ();

    /**
     * Sets the value of the member "coordinates".
     *
     * If the meaning of "coordinates" isn't clear, then there should be a description here.
     *
     * @param coordinates The value which will be set
     */
    inline void setCoordinates (const ::std::vector< ScreenCoordinate >& coordinates_);

    // API of field "roadClass"

    static const int kRoadClass = 1;

    /**
     * Clears the field "roadClass".
     *
     * The field will be set to its default value. The hasRoadClass()
     * method will return false.
     */
    inline void clearRoadClass();

    /**
     * Checks whether the field "roadClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoadClass()). Otherwise it will return false.
     */
    inline bool hasRoadClass () const;

    /**
     * Returns the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @return The value of the field "roadClass"
     */
    inline AdminRoadClass getRoadClass () const;

    /**
     * Sets the value of the member "roadClass".
     *
     * If the meaning of "roadClass" isn't clear, then there should be a description here.
     *
     * @param roadClass The value which will be set
     */
    inline void setRoadClass (AdminRoadClass roadClass_);

    static const IntersectionMapRoadLine &getDefaultInstance();

private:

    static const ::std::vector< ScreenCoordinate >& getScreenCoordinateList_DefaultInstance ();

    inline void set_has_coordinates ();

    inline void clear_has_coordinates ();

    inline void set_has_roadClass ();

    inline void clear_has_roadClass ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ScreenCoordinate > _coordinates;

    AdminRoadClass _roadClass;

};

/**
 * If the meaning of "IntersectionMap" isn't clear, then there should be a description here.
 */
class IntersectionMap {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMap ();

    /**
     * Copy constructor
     */
    inline  IntersectionMap (const IntersectionMap &rhs);

    /**
     * All fields constructor
     */
    inline  IntersectionMap (uint32 maneuverId_, const ::std::vector< IntersectionMapRoadLine >& road_, const ::std::vector< IntersectionMapRoadLine >& route_, const ::std::vector< ScreenCoordinate >& noEntryIcons_);

    /**
     * Destructor
     */
    inline  ~IntersectionMap();

    /**
     * Assignment operator
     */
    inline IntersectionMap& operator = (const IntersectionMap& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMap& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMap& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMap& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMap& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverId"

    static const int kManeuverId = 0;

    /**
     * Clears the field "maneuverId".
     *
     * The field will be set to its default value. The hasManeuverId()
     * method will return false.
     */
    inline void clearManeuverId();

    /**
     * Checks whether the field "maneuverId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverId()). Otherwise it will return false.
     */
    inline bool hasManeuverId () const;

    /**
     * Returns the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maneuverId"
     */
    inline uint32 getManeuverId () const;

    /**
     * Sets the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @param maneuverId The value which will be set
     */
    inline void setManeuverId (uint32 maneuverId_);

    // API of field "road"

    static const int kRoad = 1;

    /**
     * Clears the field "road".
     *
     * The field will be set to its default value. The hasRoad()
     * method will return false.
     */
    inline void clearRoad();

    /**
     * Checks whether the field "road" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoad()). Otherwise it will return false.
     */
    inline bool hasRoad () const;

    /**
     * Returns the value of the member "road".
     *
     * If the meaning of "road" isn't clear, then there should be a description here.
     *
     * @return The value of the field "road"
     */
    inline const ::std::vector< IntersectionMapRoadLine >& getRoad () const;

    /**
     * Retrieves the value of the field "road" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "road".
     */
    inline ::std::vector< IntersectionMapRoadLine >& getRoadMutable ();

    /**
     * Sets the value of the member "road".
     *
     * If the meaning of "road" isn't clear, then there should be a description here.
     *
     * @param road The value which will be set
     */
    inline void setRoad (const ::std::vector< IntersectionMapRoadLine >& road_);

    // API of field "route"

    static const int kRoute = 2;

    /**
     * Clears the field "route".
     *
     * The field will be set to its default value. The hasRoute()
     * method will return false.
     */
    inline void clearRoute();

    /**
     * Checks whether the field "route" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoute()). Otherwise it will return false.
     */
    inline bool hasRoute () const;

    /**
     * Returns the value of the member "route".
     *
     * If the meaning of "route" isn't clear, then there should be a description here.
     *
     * @return The value of the field "route"
     */
    inline const ::std::vector< IntersectionMapRoadLine >& getRoute () const;

    /**
     * Retrieves the value of the field "route" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "route".
     */
    inline ::std::vector< IntersectionMapRoadLine >& getRouteMutable ();

    /**
     * Sets the value of the member "route".
     *
     * If the meaning of "route" isn't clear, then there should be a description here.
     *
     * @param route The value which will be set
     */
    inline void setRoute (const ::std::vector< IntersectionMapRoadLine >& route_);

    // API of field "noEntryIcons"

    static const int kNoEntryIcons = 3;

    /**
     * Clears the field "noEntryIcons".
     *
     * The field will be set to its default value. The hasNoEntryIcons()
     * method will return false.
     */
    inline void clearNoEntryIcons();

    /**
     * Checks whether the field "noEntryIcons" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNoEntryIcons()). Otherwise it will return false.
     */
    inline bool hasNoEntryIcons () const;

    /**
     * Returns the value of the member "noEntryIcons".
     *
     * If the meaning of "noEntryIcons" isn't clear, then there should be a description here.
     *
     * @return The value of the field "noEntryIcons"
     */
    inline const ::std::vector< ScreenCoordinate >& getNoEntryIcons () const;

    /**
     * Retrieves the value of the field "noEntryIcons" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "noEntryIcons".
     */
    inline ::std::vector< ScreenCoordinate >& getNoEntryIconsMutable ();

    /**
     * Sets the value of the member "noEntryIcons".
     *
     * If the meaning of "noEntryIcons" isn't clear, then there should be a description here.
     *
     * @param noEntryIcons The value which will be set
     */
    inline void setNoEntryIcons (const ::std::vector< ScreenCoordinate >& noEntryIcons_);

    static const IntersectionMap &getDefaultInstance();

private:

    static const ::std::vector< IntersectionMapRoadLine >& getIntersectionMapRoadLineList_DefaultInstance ();

    static const ::std::vector< ScreenCoordinate >& getScreenCoordinateList_DefaultInstance ();

    inline void set_has_maneuverId ();

    inline void clear_has_maneuverId ();

    inline void set_has_road ();

    inline void clear_has_road ();

    inline void set_has_route ();

    inline void clear_has_route ();

    inline void set_has_noEntryIcons ();

    inline void clear_has_noEntryIcons ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _maneuverId;

    ::std::vector< IntersectionMapRoadLine > _road;

    ::std::vector< IntersectionMapRoadLine > _route;

    ::std::vector< ScreenCoordinate > _noEntryIcons;

};

/**
 * If the meaning of "IntersectionMapCarsorPosition" isn't clear, then there should be a description here.
 */
class IntersectionMapCarsorPosition {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapCarsorPosition ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapCarsorPosition (const IntersectionMapCarsorPosition &rhs);

    /**
     * All fields constructor
     */
    inline  IntersectionMapCarsorPosition (uint32 maneuverId_, IntersectionMapCarsorState carsorState_, const ScreenCoordinate& carsorPosition_, int32 carsorAngle_);

    /**
     * Destructor
     */
    inline  ~IntersectionMapCarsorPosition();

    /**
     * Assignment operator
     */
    inline IntersectionMapCarsorPosition& operator = (const IntersectionMapCarsorPosition& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapCarsorPosition& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapCarsorPosition& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapCarsorPosition& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapCarsorPosition& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverId"

    static const int kManeuverId = 0;

    /**
     * Clears the field "maneuverId".
     *
     * The field will be set to its default value. The hasManeuverId()
     * method will return false.
     */
    inline void clearManeuverId();

    /**
     * Checks whether the field "maneuverId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverId()). Otherwise it will return false.
     */
    inline bool hasManeuverId () const;

    /**
     * Returns the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maneuverId"
     */
    inline uint32 getManeuverId () const;

    /**
     * Sets the value of the member "maneuverId".
     *
     * If the meaning of "maneuverId" isn't clear, then there should be a description here.
     *
     * @param maneuverId The value which will be set
     */
    inline void setManeuverId (uint32 maneuverId_);

    // API of field "carsorState"

    static const int kCarsorState = 1;

    /**
     * Clears the field "carsorState".
     *
     * The field will be set to its default value. The hasCarsorState()
     * method will return false.
     */
    inline void clearCarsorState();

    /**
     * Checks whether the field "carsorState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarsorState()). Otherwise it will return false.
     */
    inline bool hasCarsorState () const;

    /**
     * Returns the value of the member "carsorState".
     *
     * If the meaning of "carsorState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carsorState"
     */
    inline IntersectionMapCarsorState getCarsorState () const;

    /**
     * Sets the value of the member "carsorState".
     *
     * If the meaning of "carsorState" isn't clear, then there should be a description here.
     *
     * @param carsorState The value which will be set
     */
    inline void setCarsorState (IntersectionMapCarsorState carsorState_);

    // API of field "carsorPosition"

    static const int kCarsorPosition = 2;

    /**
     * Clears the field "carsorPosition".
     *
     * The field will be set to its default value. The hasCarsorPosition()
     * method will return false.
     */
    inline void clearCarsorPosition();

    /**
     * Checks whether the field "carsorPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarsorPosition()). Otherwise it will return false.
     */
    inline bool hasCarsorPosition () const;

    /**
     * Returns the value of the member "carsorPosition".
     *
     * If the meaning of "carsorPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carsorPosition"
     */
    inline const ScreenCoordinate& getCarsorPosition () const;

    /**
     * Retrieves the value of the field "carsorPosition" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "carsorPosition".
     */
    inline ScreenCoordinate& getCarsorPositionMutable ();

    /**
     * Sets the value of the member "carsorPosition".
     *
     * If the meaning of "carsorPosition" isn't clear, then there should be a description here.
     *
     * @param carsorPosition The value which will be set
     */
    inline void setCarsorPosition (const ScreenCoordinate& carsorPosition_);

    // API of field "carsorAngle"

    static const int kCarsorAngle = 3;

    /**
     * Clears the field "carsorAngle".
     *
     * The field will be set to its default value. The hasCarsorAngle()
     * method will return false.
     */
    inline void clearCarsorAngle();

    /**
     * Checks whether the field "carsorAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarsorAngle()). Otherwise it will return false.
     */
    inline bool hasCarsorAngle () const;

    /**
     * Returns the value of the member "carsorAngle".
     *
     * If the meaning of "carsorAngle" isn't clear, then there should be a description here.
     *
     * @return The value of the field "carsorAngle"
     */
    inline int32 getCarsorAngle () const;

    /**
     * Sets the value of the member "carsorAngle".
     *
     * If the meaning of "carsorAngle" isn't clear, then there should be a description here.
     *
     * @param carsorAngle The value which will be set
     */
    inline void setCarsorAngle (int32 carsorAngle_);

    static const IntersectionMapCarsorPosition &getDefaultInstance();

private:

    inline void set_has_maneuverId ();

    inline void clear_has_maneuverId ();

    inline void set_has_carsorState ();

    inline void clear_has_carsorState ();

    inline void set_has_carsorPosition ();

    inline void clear_has_carsorPosition ();

    inline void set_has_carsorAngle ();

    inline void clear_has_carsorAngle ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _maneuverId;

    IntersectionMapCarsorState _carsorState;

    ScreenCoordinate _carsorPosition;

    int32 _carsorAngle;

};

/**
 * If the meaning of "SpeedLimit" isn't clear, then there should be a description here.
 */
class SpeedLimit {
public:

    /**
     * Default constructor
     */
    inline  SpeedLimit ();

    /**
     * Copy constructor
     */
    inline  SpeedLimit (const SpeedLimit &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLimit (bool present_, const ::std::string& countryCode_, uint16 value_, SpeedUnit speedUnit_);

    /**
     * Destructor
     */
    inline  ~SpeedLimit();

    /**
     * Assignment operator
     */
    inline SpeedLimit& operator = (const SpeedLimit& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLimit& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLimit& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLimit& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLimit& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "present"

    static const int kPresent = 0;

    /**
     * Clears the field "present".
     *
     * The field will be set to its default value. The hasPresent()
     * method will return false.
     */
    inline void clearPresent();

    /**
     * Checks whether the field "present" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresent()). Otherwise it will return false.
     */
    inline bool hasPresent () const;

    /**
     * Returns the value of the member "present".
     *
     * If the meaning of "present" isn't clear, then there should be a description here.
     *
     * @return The value of the field "present"
     */
    inline bool getPresent () const;

    /**
     * Sets the value of the member "present".
     *
     * If the meaning of "present" isn't clear, then there should be a description here.
     *
     * @param present The value which will be set
     */
    inline void setPresent (bool present_);

    // API of field "countryCode"

    static const int kCountryCode = 1;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 2;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline uint16 getValue () const;

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (uint16 value_);

    // API of field "speedUnit"

    static const int kSpeedUnit = 3;

    /**
     * Clears the field "speedUnit".
     *
     * The field will be set to its default value. The hasSpeedUnit()
     * method will return false.
     */
    inline void clearSpeedUnit();

    /**
     * Checks whether the field "speedUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedUnit()). Otherwise it will return false.
     */
    inline bool hasSpeedUnit () const;

    /**
     * Returns the value of the member "speedUnit".
     *
     * If the meaning of "speedUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speedUnit"
     */
    inline SpeedUnit getSpeedUnit () const;

    /**
     * Sets the value of the member "speedUnit".
     *
     * If the meaning of "speedUnit" isn't clear, then there should be a description here.
     *
     * @param speedUnit The value which will be set
     */
    inline void setSpeedUnit (SpeedUnit speedUnit_);

    static const SpeedLimit &getDefaultInstance();

private:

    inline void set_has_present ();

    inline void clear_has_present ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_value ();

    inline void clear_has_value ();

    inline void set_has_speedUnit ();

    inline void clear_has_speedUnit ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _present;

    ::std::string _countryCode;

    uint16 _value;

    SpeedUnit _speedUnit;

};

/**
 * If the meaning of "TrafficEnforcement" isn't clear, then there should be a description here.
 */
class TrafficEnforcement {
public:

    /**
     * Default constructor
     */
    inline  TrafficEnforcement ();

    /**
     * Copy constructor
     */
    inline  TrafficEnforcement (const TrafficEnforcement &rhs);

    /**
     * All fields constructor
     */
    inline  TrafficEnforcement (TrafficEnforcementAlertState trafficEnforcementAlertState_, TrafficEnforcementCameraType trafficEnforcementCameraType_, const ::std::string& distance_, DistanceUnit distanceUnit_, TrafficEnforcementDistanceType trafficEnforcementDistanceType_, uint32 speedLimit_);

    /**
     * Destructor
     */
    inline  ~TrafficEnforcement();

    /**
     * Assignment operator
     */
    inline TrafficEnforcement& operator = (const TrafficEnforcement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficEnforcement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficEnforcement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficEnforcement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficEnforcement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "trafficEnforcementAlertState"

    static const int kTrafficEnforcementAlertState = 0;

    /**
     * Clears the field "trafficEnforcementAlertState".
     *
     * The field will be set to its default value. The hasTrafficEnforcementAlertState()
     * method will return false.
     */
    inline void clearTrafficEnforcementAlertState();

    /**
     * Checks whether the field "trafficEnforcementAlertState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficEnforcementAlertState()). Otherwise it will return false.
     */
    inline bool hasTrafficEnforcementAlertState () const;

    /**
     * Returns the value of the member "trafficEnforcementAlertState".
     *
     * Indicates type of alert to be given
     *
     * @return The value of the field "trafficEnforcementAlertState"
     */
    inline TrafficEnforcementAlertState getTrafficEnforcementAlertState () const;

    /**
     * Sets the value of the member "trafficEnforcementAlertState".
     *
     * Indicates type of alert to be given
     *
     * @param trafficEnforcementAlertState The value which will be set
     */
    inline void setTrafficEnforcementAlertState (TrafficEnforcementAlertState trafficEnforcementAlertState_);

    // API of field "trafficEnforcementCameraType"

    static const int kTrafficEnforcementCameraType = 1;

    /**
     * Clears the field "trafficEnforcementCameraType".
     *
     * The field will be set to its default value. The hasTrafficEnforcementCameraType()
     * method will return false.
     */
    inline void clearTrafficEnforcementCameraType();

    /**
     * Checks whether the field "trafficEnforcementCameraType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficEnforcementCameraType()). Otherwise it will return false.
     */
    inline bool hasTrafficEnforcementCameraType () const;

    /**
     * Returns the value of the member "trafficEnforcementCameraType".
     *
     * Type of traffic enforcement ahead
     *
     * @return The value of the field "trafficEnforcementCameraType"
     */
    inline TrafficEnforcementCameraType getTrafficEnforcementCameraType () const;

    /**
     * Sets the value of the member "trafficEnforcementCameraType".
     *
     * Type of traffic enforcement ahead
     *
     * @param trafficEnforcementCameraType The value which will be set
     */
    inline void setTrafficEnforcementCameraType (TrafficEnforcementCameraType trafficEnforcementCameraType_);

    // API of field "distance"

    static const int kDistance = 2;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * Distance to enforcement zone/spot (formatted, without unit)
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * Distance to enforcement zone/spot (formatted, without unit)
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Distance to enforcement zone/spot (formatted, without unit)
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * Distance to enforcement zone/spot (formatted, without unit)
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "distanceUnit"

    static const int kDistanceUnit = 3;

    /**
     * Clears the field "distanceUnit".
     *
     * The field will be set to its default value. The hasDistanceUnit()
     * method will return false.
     */
    inline void clearDistanceUnit();

    /**
     * Checks whether the field "distanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceUnit () const;

    /**
     * Returns the value of the member "distanceUnit".
     *
     * Unit type for formatted distance
     *
     * @return The value of the field "distanceUnit"
     */
    inline DistanceUnit getDistanceUnit () const;

    /**
     * Sets the value of the member "distanceUnit".
     *
     * Unit type for formatted distance
     *
     * @param distanceUnit The value which will be set
     */
    inline void setDistanceUnit (DistanceUnit distanceUnit_);

    // API of field "trafficEnforcementDistanceType"

    static const int kTrafficEnforcementDistanceType = 4;

    /**
     * Clears the field "trafficEnforcementDistanceType".
     *
     * The field will be set to its default value. The hasTrafficEnforcementDistanceType()
     * method will return false.
     */
    inline void clearTrafficEnforcementDistanceType();

    /**
     * Checks whether the field "trafficEnforcementDistanceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficEnforcementDistanceType()). Otherwise it will return false.
     */
    inline bool hasTrafficEnforcementDistanceType () const;

    /**
     * Returns the value of the member "trafficEnforcementDistanceType".
     *
     * Meaning of distance value (begin/end)
     *
     * @return The value of the field "trafficEnforcementDistanceType"
     */
    inline TrafficEnforcementDistanceType getTrafficEnforcementDistanceType () const;

    /**
     * Sets the value of the member "trafficEnforcementDistanceType".
     *
     * Meaning of distance value (begin/end)
     *
     * @param trafficEnforcementDistanceType The value which will be set
     */
    inline void setTrafficEnforcementDistanceType (TrafficEnforcementDistanceType trafficEnforcementDistanceType_);

    // API of field "speedLimit"

    static const int kSpeedLimit = 5;

    /**
     * Clears the field "speedLimit".
     *
     * The field will be set to its default value. The hasSpeedLimit()
     * method will return false.
     */
    inline void clearSpeedLimit();

    /**
     * Checks whether the field "speedLimit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLimit()). Otherwise it will return false.
     */
    inline bool hasSpeedLimit () const;

    /**
     * Returns the value of the member "speedLimit".
     *
     * Speed limit valid in traffic enforcement zone
     *
     * @return The value of the field "speedLimit"
     */
    inline uint32 getSpeedLimit () const;

    /**
     * Sets the value of the member "speedLimit".
     *
     * Speed limit valid in traffic enforcement zone
     *
     * @param speedLimit The value which will be set
     */
    inline void setSpeedLimit (uint32 speedLimit_);

    static const TrafficEnforcement &getDefaultInstance();

private:

    inline void set_has_trafficEnforcementAlertState ();

    inline void clear_has_trafficEnforcementAlertState ();

    inline void set_has_trafficEnforcementCameraType ();

    inline void clear_has_trafficEnforcementCameraType ();

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_distanceUnit ();

    inline void clear_has_distanceUnit ();

    inline void set_has_trafficEnforcementDistanceType ();

    inline void clear_has_trafficEnforcementDistanceType ();

    inline void set_has_speedLimit ();

    inline void clear_has_speedLimit ();

    uint32 _has_bits_[ (6 + 31) / 32];

    TrafficEnforcementAlertState _trafficEnforcementAlertState;

    TrafficEnforcementCameraType _trafficEnforcementCameraType;

    ::std::string _distance;

    DistanceUnit _distanceUnit;

    TrafficEnforcementDistanceType _trafficEnforcementDistanceType;

    uint32 _speedLimit;

};

/**
 * If the meaning of "RouteCalculationDuration" isn't clear, then there should be a description here.
 */
class RouteCalculationDuration {
public:

    /**
     * Default constructor
     */
    inline  RouteCalculationDuration ();

    /**
     * Copy constructor
     */
    inline  RouteCalculationDuration (const RouteCalculationDuration &rhs);

    /**
     * All fields constructor
     */
    inline  RouteCalculationDuration (uint32 routeCalDurationToFinalDest_, uint32 routeCalDurationToNextDest_);

    /**
     * Destructor
     */
    inline  ~RouteCalculationDuration();

    /**
     * Assignment operator
     */
    inline RouteCalculationDuration& operator = (const RouteCalculationDuration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RouteCalculationDuration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RouteCalculationDuration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RouteCalculationDuration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RouteCalculationDuration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "routeCalDurationToFinalDest"

    static const int kRouteCalDurationToFinalDest = 0;

    /**
     * Clears the field "routeCalDurationToFinalDest".
     *
     * The field will be set to its default value. The hasRouteCalDurationToFinalDest()
     * method will return false.
     */
    inline void clearRouteCalDurationToFinalDest();

    /**
     * Checks whether the field "routeCalDurationToFinalDest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCalDurationToFinalDest()). Otherwise it will return false.
     */
    inline bool hasRouteCalDurationToFinalDest () const;

    /**
     * Returns the value of the member "routeCalDurationToFinalDest".
     *
     * If the meaning of "routeCalDurationToFinalDest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "routeCalDurationToFinalDest"
     */
    inline uint32 getRouteCalDurationToFinalDest () const;

    /**
     * Sets the value of the member "routeCalDurationToFinalDest".
     *
     * If the meaning of "routeCalDurationToFinalDest" isn't clear, then there should be a description here.
     *
     * @param routeCalDurationToFinalDest The value which will be set
     */
    inline void setRouteCalDurationToFinalDest (uint32 routeCalDurationToFinalDest_);

    // API of field "routeCalDurationToNextDest"

    static const int kRouteCalDurationToNextDest = 1;

    /**
     * Clears the field "routeCalDurationToNextDest".
     *
     * The field will be set to its default value. The hasRouteCalDurationToNextDest()
     * method will return false.
     */
    inline void clearRouteCalDurationToNextDest();

    /**
     * Checks whether the field "routeCalDurationToNextDest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCalDurationToNextDest()). Otherwise it will return false.
     */
    inline bool hasRouteCalDurationToNextDest () const;

    /**
     * Returns the value of the member "routeCalDurationToNextDest".
     *
     * If the meaning of "routeCalDurationToNextDest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "routeCalDurationToNextDest"
     */
    inline uint32 getRouteCalDurationToNextDest () const;

    /**
     * Sets the value of the member "routeCalDurationToNextDest".
     *
     * If the meaning of "routeCalDurationToNextDest" isn't clear, then there should be a description here.
     *
     * @param routeCalDurationToNextDest The value which will be set
     */
    inline void setRouteCalDurationToNextDest (uint32 routeCalDurationToNextDest_);

    static const RouteCalculationDuration &getDefaultInstance();

private:

    inline void set_has_routeCalDurationToFinalDest ();

    inline void clear_has_routeCalDurationToFinalDest ();

    inline void set_has_routeCalDurationToNextDest ();

    inline void clear_has_routeCalDurationToNextDest ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _routeCalDurationToFinalDest;

    uint32 _routeCalDurationToNextDest;

};

/**
 * If the meaning of "LaneRecommendation" isn't clear, then there should be a description here.
 */
class LaneRecommendation {
public:

    /**
     * Default constructor
     */
    inline  LaneRecommendation ();

    /**
     * Copy constructor
     */
    inline  LaneRecommendation (const LaneRecommendation &rhs);

    /**
     * All fields constructor
     */
    inline  LaneRecommendation (LaneStatus laneStatus_, int32 combinedFollowingLaneDirection_, int32 guidedFollowingLaneDirection_);

    /**
     * Destructor
     */
    inline  ~LaneRecommendation();

    /**
     * Assignment operator
     */
    inline LaneRecommendation& operator = (const LaneRecommendation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LaneRecommendation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LaneRecommendation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LaneRecommendation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LaneRecommendation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "laneStatus"

    static const int kLaneStatus = 0;

    /**
     * Clears the field "laneStatus".
     *
     * The field will be set to its default value. The hasLaneStatus()
     * method will return false.
     */
    inline void clearLaneStatus();

    /**
     * Checks whether the field "laneStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLaneStatus()). Otherwise it will return false.
     */
    inline bool hasLaneStatus () const;

    /**
     * Returns the value of the member "laneStatus".
     *
     * If the meaning of "laneStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "laneStatus"
     */
    inline LaneStatus getLaneStatus () const;

    /**
     * Sets the value of the member "laneStatus".
     *
     * If the meaning of "laneStatus" isn't clear, then there should be a description here.
     *
     * @param laneStatus The value which will be set
     */
    inline void setLaneStatus (LaneStatus laneStatus_);

    // API of field "combinedFollowingLaneDirection"

    static const int kCombinedFollowingLaneDirection = 1;

    /**
     * Clears the field "combinedFollowingLaneDirection".
     *
     * The field will be set to its default value. The hasCombinedFollowingLaneDirection()
     * method will return false.
     */
    inline void clearCombinedFollowingLaneDirection();

    /**
     * Checks whether the field "combinedFollowingLaneDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCombinedFollowingLaneDirection()). Otherwise it will return false.
     */
    inline bool hasCombinedFollowingLaneDirection () const;

    /**
     * Returns the value of the member "combinedFollowingLaneDirection".
     *
     * If the meaning of "combinedFollowingLaneDirection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "combinedFollowingLaneDirection"
     */
    inline int32 getCombinedFollowingLaneDirection () const;

    /**
     * Sets the value of the member "combinedFollowingLaneDirection".
     *
     * If the meaning of "combinedFollowingLaneDirection" isn't clear, then there should be a description here.
     *
     * @param combinedFollowingLaneDirection The value which will be set
     */
    inline void setCombinedFollowingLaneDirection (int32 combinedFollowingLaneDirection_);

    // API of field "guidedFollowingLaneDirection"

    static const int kGuidedFollowingLaneDirection = 2;

    /**
     * Clears the field "guidedFollowingLaneDirection".
     *
     * The field will be set to its default value. The hasGuidedFollowingLaneDirection()
     * method will return false.
     */
    inline void clearGuidedFollowingLaneDirection();

    /**
     * Checks whether the field "guidedFollowingLaneDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGuidedFollowingLaneDirection()). Otherwise it will return false.
     */
    inline bool hasGuidedFollowingLaneDirection () const;

    /**
     * Returns the value of the member "guidedFollowingLaneDirection".
     *
     * If the meaning of "guidedFollowingLaneDirection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "guidedFollowingLaneDirection"
     */
    inline int32 getGuidedFollowingLaneDirection () const;

    /**
     * Sets the value of the member "guidedFollowingLaneDirection".
     *
     * If the meaning of "guidedFollowingLaneDirection" isn't clear, then there should be a description here.
     *
     * @param guidedFollowingLaneDirection The value which will be set
     */
    inline void setGuidedFollowingLaneDirection (int32 guidedFollowingLaneDirection_);

    static const LaneRecommendation &getDefaultInstance();

private:

    inline void set_has_laneStatus ();

    inline void clear_has_laneStatus ();

    inline void set_has_combinedFollowingLaneDirection ();

    inline void clear_has_combinedFollowingLaneDirection ();

    inline void set_has_guidedFollowingLaneDirection ();

    inline void clear_has_guidedFollowingLaneDirection ();

    uint32 _has_bits_[ (3 + 31) / 32];

    LaneStatus _laneStatus;

    int32 _combinedFollowingLaneDirection;

    int32 _guidedFollowingLaneDirection;

};

/**
 * If the meaning of "ArrivalInformation" isn't clear, then there should be a description here.
 */
class ArrivalInformation {
public:

    /**
     * Default constructor
     */
    inline  ArrivalInformation ();

    /**
     * Copy constructor
     */
    inline  ArrivalInformation (const ArrivalInformation &rhs);

    /**
     * All fields constructor
     */
    inline  ArrivalInformation (const DistanceToDestination& distanceToDestination_, const ::std::string& timeToDestinationAsString_, int32 timeToDestination_, const ::std::string& estimatedTimeOfArrivalAsString_, int32 estimatedTimeOfArrivalHour_, int32 estimatedTimeOfArrivalMinute_, EstimatedTimeType estimatedTimeType_, TimeType displayTimeType_, TimeFormat displayTimeFormat_, int32 destinationIndex_, ConsumptionUnit consumptionUnit_, uint32 consumptionToDestinationAsInt_, const ::std::string& consumptionToDestinationAsString_);

    /**
     * Destructor
     */
    inline  ~ArrivalInformation();

    /**
     * Assignment operator
     */
    inline ArrivalInformation& operator = (const ArrivalInformation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ArrivalInformation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ArrivalInformation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ArrivalInformation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ArrivalInformation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "distanceToDestination"

    static const int kDistanceToDestination = 0;

    /**
     * Clears the field "distanceToDestination".
     *
     * The field will be set to its default value. The hasDistanceToDestination()
     * method will return false.
     */
    inline void clearDistanceToDestination();

    /**
     * Checks whether the field "distanceToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToDestination()). Otherwise it will return false.
     */
    inline bool hasDistanceToDestination () const;

    /**
     * Returns the value of the member "distanceToDestination".
     *
     * If the meaning of "distanceToDestination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceToDestination"
     */
    inline const DistanceToDestination& getDistanceToDestination () const;

    /**
     * Retrieves the value of the field "distanceToDestination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distanceToDestination".
     */
    inline DistanceToDestination& getDistanceToDestinationMutable ();

    /**
     * Sets the value of the member "distanceToDestination".
     *
     * If the meaning of "distanceToDestination" isn't clear, then there should be a description here.
     *
     * @param distanceToDestination The value which will be set
     */
    inline void setDistanceToDestination (const DistanceToDestination& distanceToDestination_);

    // API of field "timeToDestinationAsString"

    static const int kTimeToDestinationAsString = 1;

    /**
     * Clears the field "timeToDestinationAsString".
     *
     * The field will be set to its default value. The hasTimeToDestinationAsString()
     * method will return false.
     */
    inline void clearTimeToDestinationAsString();

    /**
     * Checks whether the field "timeToDestinationAsString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeToDestinationAsString()). Otherwise it will return false.
     */
    inline bool hasTimeToDestinationAsString () const;

    /**
     * Returns the value of the member "timeToDestinationAsString".
     *
     * If the meaning of "timeToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeToDestinationAsString"
     */
    inline const ::std::string& getTimeToDestinationAsString () const;

    /**
     * Retrieves the value of the field "timeToDestinationAsString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "timeToDestinationAsString".
     */
    inline ::std::string& getTimeToDestinationAsStringMutable ();

    /**
     * Sets the value of the member "timeToDestinationAsString".
     *
     * If the meaning of "timeToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param timeToDestinationAsString The value which will be set
     */
    inline void setTimeToDestinationAsString (const ::std::string& timeToDestinationAsString_);

    /**
     * Sets the value of the member "timeToDestinationAsString".
     *
     * If the meaning of "timeToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param timeToDestinationAsString The value which will be set
     */
    inline void setTimeToDestinationAsString (const char* timeToDestinationAsString_);

    /**
     * Sets the value of the member "timeToDestinationAsString".
     *
     * If the meaning of "timeToDestinationAsString" isn't clear, then there should be a description here.
     *
     * @param timeToDestinationAsString The value which will be set
     */
    inline void setTimeToDestinationAsString (const char* value, size_t size);

    // API of field "timeToDestination"

    static const int kTimeToDestination = 2;

    /**
     * Clears the field "timeToDestination".
     *
     * The field will be set to its default value. The hasTimeToDestination()
     * method will return false.
     */
    inline void clearTimeToDestination();

    /**
     * Checks whether the field "timeToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeToDestination()). Otherwise it will return false.
     */
    inline bool hasTimeToDestination () const;

    /**
     * Returns the value of the member "timeToDestination".
     *
     * If the meaning of "timeToDestination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeToDestination"
     */
    inline int32 getTimeToDestination () const;

    /**
     * Sets the value of the member "timeToDestination".
     *
     * If the meaning of "timeToDestination" isn't clear, then there should be a description here.
     *
     * @param timeToDestination The value which will be set
     */
    inline void setTimeToDestination (int32 timeToDestination_);

    // API of field "estimatedTimeOfArrivalAsString"

    static const int kEstimatedTimeOfArrivalAsString = 3;

    /**
     * Clears the field "estimatedTimeOfArrivalAsString".
     *
     * The field will be set to its default value. The hasEstimatedTimeOfArrivalAsString()
     * method will return false.
     */
    inline void clearEstimatedTimeOfArrivalAsString();

    /**
     * Checks whether the field "estimatedTimeOfArrivalAsString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedTimeOfArrivalAsString()). Otherwise it will return false.
     */
    inline bool hasEstimatedTimeOfArrivalAsString () const;

    /**
     * Returns the value of the member "estimatedTimeOfArrivalAsString".
     *
     * If the meaning of "estimatedTimeOfArrivalAsString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "estimatedTimeOfArrivalAsString"
     */
    inline const ::std::string& getEstimatedTimeOfArrivalAsString () const;

    /**
     * Retrieves the value of the field "estimatedTimeOfArrivalAsString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "estimatedTimeOfArrivalAsString".
     */
    inline ::std::string& getEstimatedTimeOfArrivalAsStringMutable ();

    /**
     * Sets the value of the member "estimatedTimeOfArrivalAsString".
     *
     * If the meaning of "estimatedTimeOfArrivalAsString" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeOfArrivalAsString The value which will be set
     */
    inline void setEstimatedTimeOfArrivalAsString (const ::std::string& estimatedTimeOfArrivalAsString_);

    /**
     * Sets the value of the member "estimatedTimeOfArrivalAsString".
     *
     * If the meaning of "estimatedTimeOfArrivalAsString" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeOfArrivalAsString The value which will be set
     */
    inline void setEstimatedTimeOfArrivalAsString (const char* estimatedTimeOfArrivalAsString_);

    /**
     * Sets the value of the member "estimatedTimeOfArrivalAsString".
     *
     * If the meaning of "estimatedTimeOfArrivalAsString" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeOfArrivalAsString The value which will be set
     */
    inline void setEstimatedTimeOfArrivalAsString (const char* value, size_t size);

    // API of field "estimatedTimeOfArrivalHour"

    static const int kEstimatedTimeOfArrivalHour = 4;

    /**
     * Clears the field "estimatedTimeOfArrivalHour".
     *
     * The field will be set to its default value. The hasEstimatedTimeOfArrivalHour()
     * method will return false.
     */
    inline void clearEstimatedTimeOfArrivalHour();

    /**
     * Checks whether the field "estimatedTimeOfArrivalHour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedTimeOfArrivalHour()). Otherwise it will return false.
     */
    inline bool hasEstimatedTimeOfArrivalHour () const;

    /**
     * Returns the value of the member "estimatedTimeOfArrivalHour".
     *
     * If the meaning of "estimatedTimeOfArrivalHour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "estimatedTimeOfArrivalHour"
     */
    inline int32 getEstimatedTimeOfArrivalHour () const;

    /**
     * Sets the value of the member "estimatedTimeOfArrivalHour".
     *
     * If the meaning of "estimatedTimeOfArrivalHour" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeOfArrivalHour The value which will be set
     */
    inline void setEstimatedTimeOfArrivalHour (int32 estimatedTimeOfArrivalHour_);

    // API of field "estimatedTimeOfArrivalMinute"

    static const int kEstimatedTimeOfArrivalMinute = 5;

    /**
     * Clears the field "estimatedTimeOfArrivalMinute".
     *
     * The field will be set to its default value. The hasEstimatedTimeOfArrivalMinute()
     * method will return false.
     */
    inline void clearEstimatedTimeOfArrivalMinute();

    /**
     * Checks whether the field "estimatedTimeOfArrivalMinute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedTimeOfArrivalMinute()). Otherwise it will return false.
     */
    inline bool hasEstimatedTimeOfArrivalMinute () const;

    /**
     * Returns the value of the member "estimatedTimeOfArrivalMinute".
     *
     * If the meaning of "estimatedTimeOfArrivalMinute" isn't clear, then there should be a description here.
     *
     * @return The value of the field "estimatedTimeOfArrivalMinute"
     */
    inline int32 getEstimatedTimeOfArrivalMinute () const;

    /**
     * Sets the value of the member "estimatedTimeOfArrivalMinute".
     *
     * If the meaning of "estimatedTimeOfArrivalMinute" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeOfArrivalMinute The value which will be set
     */
    inline void setEstimatedTimeOfArrivalMinute (int32 estimatedTimeOfArrivalMinute_);

    // API of field "estimatedTimeType"

    static const int kEstimatedTimeType = 6;

    /**
     * Clears the field "estimatedTimeType".
     *
     * The field will be set to its default value. The hasEstimatedTimeType()
     * method will return false.
     */
    inline void clearEstimatedTimeType();

    /**
     * Checks whether the field "estimatedTimeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEstimatedTimeType()). Otherwise it will return false.
     */
    inline bool hasEstimatedTimeType () const;

    /**
     * Returns the value of the member "estimatedTimeType".
     *
     * If the meaning of "estimatedTimeType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "estimatedTimeType"
     */
    inline EstimatedTimeType getEstimatedTimeType () const;

    /**
     * Sets the value of the member "estimatedTimeType".
     *
     * If the meaning of "estimatedTimeType" isn't clear, then there should be a description here.
     *
     * @param estimatedTimeType The value which will be set
     */
    inline void setEstimatedTimeType (EstimatedTimeType estimatedTimeType_);

    // API of field "displayTimeType"

    static const int kDisplayTimeType = 7;

    /**
     * Clears the field "displayTimeType".
     *
     * The field will be set to its default value. The hasDisplayTimeType()
     * method will return false.
     */
    inline void clearDisplayTimeType();

    /**
     * Checks whether the field "displayTimeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayTimeType()). Otherwise it will return false.
     */
    inline bool hasDisplayTimeType () const;

    /**
     * Returns the value of the member "displayTimeType".
     *
     * If the meaning of "displayTimeType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayTimeType"
     */
    inline TimeType getDisplayTimeType () const;

    /**
     * Sets the value of the member "displayTimeType".
     *
     * If the meaning of "displayTimeType" isn't clear, then there should be a description here.
     *
     * @param displayTimeType The value which will be set
     */
    inline void setDisplayTimeType (TimeType displayTimeType_);

    // API of field "displayTimeFormat"

    static const int kDisplayTimeFormat = 8;

    /**
     * Clears the field "displayTimeFormat".
     *
     * The field will be set to its default value. The hasDisplayTimeFormat()
     * method will return false.
     */
    inline void clearDisplayTimeFormat();

    /**
     * Checks whether the field "displayTimeFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayTimeFormat()). Otherwise it will return false.
     */
    inline bool hasDisplayTimeFormat () const;

    /**
     * Returns the value of the member "displayTimeFormat".
     *
     * If the meaning of "displayTimeFormat" isn't clear, then there should be a description here.
     *
     * @return The value of the field "displayTimeFormat"
     */
    inline TimeFormat getDisplayTimeFormat () const;

    /**
     * Sets the value of the member "displayTimeFormat".
     *
     * If the meaning of "displayTimeFormat" isn't clear, then there should be a description here.
     *
     * @param displayTimeFormat The value which will be set
     */
    inline void setDisplayTimeFormat (TimeFormat displayTimeFormat_);

    // API of field "destinationIndex"

    static const int kDestinationIndex = 9;

    /**
     * Clears the field "destinationIndex".
     *
     * The field will be set to its default value. The hasDestinationIndex()
     * method will return false.
     */
    inline void clearDestinationIndex();

    /**
     * Checks whether the field "destinationIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationIndex()). Otherwise it will return false.
     */
    inline bool hasDestinationIndex () const;

    /**
     * Returns the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationIndex"
     */
    inline int32 getDestinationIndex () const;

    /**
     * Sets the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @param destinationIndex The value which will be set
     */
    inline void setDestinationIndex (int32 destinationIndex_);

    // API of field "consumptionUnit"

    static const int kConsumptionUnit = 10;

    /**
     * Clears the field "consumptionUnit".
     *
     * The field will be set to its default value. The hasConsumptionUnit()
     * method will return false.
     */
    inline void clearConsumptionUnit();

    /**
     * Checks whether the field "consumptionUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumptionUnit()). Otherwise it will return false.
     */
    inline bool hasConsumptionUnit () const;

    /**
     * Returns the value of the member "consumptionUnit".
     *
     * If the meaning of "consumptionUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "consumptionUnit"
     */
    inline ConsumptionUnit getConsumptionUnit () const;

    /**
     * Sets the value of the member "consumptionUnit".
     *
     * If the meaning of "consumptionUnit" isn't clear, then there should be a description here.
     *
     * @param consumptionUnit The value which will be set
     */
    inline void setConsumptionUnit (ConsumptionUnit consumptionUnit_);

    // API of field "consumptionToDestinationAsInt"

    static const int kConsumptionToDestinationAsInt = 11;

    /**
     * Clears the field "consumptionToDestinationAsInt".
     *
     * The field will be set to its default value. The hasConsumptionToDestinationAsInt()
     * method will return false.
     */
    inline void clearConsumptionToDestinationAsInt();

    /**
     * Checks whether the field "consumptionToDestinationAsInt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumptionToDestinationAsInt()). Otherwise it will return false.
     */
    inline bool hasConsumptionToDestinationAsInt () const;

    /**
     * Returns the value of the member "consumptionToDestinationAsInt".
     *
     * If the meaning of "consumptionToDestinationAsInt" isn't clear, then there should be a description here.
     *
     * @return The value of the field "consumptionToDestinationAsInt"
     */
    inline uint32 getConsumptionToDestinationAsInt () const;

    /**
     * Sets the value of the member "consumptionToDestinationAsInt".
     *
     * If the meaning of "consumptionToDestinationAsInt" isn't clear, then there should be a description here.
     *
     * @param consumptionToDestinationAsInt The value which will be set
     */
    inline void setConsumptionToDestinationAsInt (uint32 consumptionToDestinationAsInt_);

    // API of field "consumptionToDestinationAsString"

    static const int kConsumptionToDestinationAsString = 12;

    /**
     * Clears the field "consumptionToDestinationAsString".
     *
     * The field will be set to its default value. The hasConsumptionToDestinationAsString()
     * method will return false.
     */
    inline void clearConsumptionToDestinationAsString();

    /**
     * Checks whether the field "consumptionToDestinationAsString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConsumptionToDestinationAsString()). Otherwise it will return false.
     */
    inline bool hasConsumptionToDestinationAsString () const;

    /**
     * Returns the value of the member "consumptionToDestinationAsString".
     *
     * contains consumption to destination in string format and is without unit information
     *
     * @return The value of the field "consumptionToDestinationAsString"
     */
    inline const ::std::string& getConsumptionToDestinationAsString () const;

    /**
     * Retrieves the value of the field "consumptionToDestinationAsString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "consumptionToDestinationAsString".
     */
    inline ::std::string& getConsumptionToDestinationAsStringMutable ();

    /**
     * Sets the value of the member "consumptionToDestinationAsString".
     *
     * contains consumption to destination in string format and is without unit information
     *
     * @param consumptionToDestinationAsString The value which will be set
     */
    inline void setConsumptionToDestinationAsString (const ::std::string& consumptionToDestinationAsString_);

    /**
     * Sets the value of the member "consumptionToDestinationAsString".
     *
     * contains consumption to destination in string format and is without unit information
     *
     * @param consumptionToDestinationAsString The value which will be set
     */
    inline void setConsumptionToDestinationAsString (const char* consumptionToDestinationAsString_);

    /**
     * Sets the value of the member "consumptionToDestinationAsString".
     *
     * contains consumption to destination in string format and is without unit information
     *
     * @param consumptionToDestinationAsString The value which will be set
     */
    inline void setConsumptionToDestinationAsString (const char* value, size_t size);

    static const ArrivalInformation &getDefaultInstance();

private:

    inline void set_has_distanceToDestination ();

    inline void clear_has_distanceToDestination ();

    inline void set_has_timeToDestinationAsString ();

    inline void clear_has_timeToDestinationAsString ();

    inline void set_has_timeToDestination ();

    inline void clear_has_timeToDestination ();

    inline void set_has_estimatedTimeOfArrivalAsString ();

    inline void clear_has_estimatedTimeOfArrivalAsString ();

    inline void set_has_estimatedTimeOfArrivalHour ();

    inline void clear_has_estimatedTimeOfArrivalHour ();

    inline void set_has_estimatedTimeOfArrivalMinute ();

    inline void clear_has_estimatedTimeOfArrivalMinute ();

    inline void set_has_estimatedTimeType ();

    inline void clear_has_estimatedTimeType ();

    inline void set_has_displayTimeType ();

    inline void clear_has_displayTimeType ();

    inline void set_has_displayTimeFormat ();

    inline void clear_has_displayTimeFormat ();

    inline void set_has_destinationIndex ();

    inline void clear_has_destinationIndex ();

    inline void set_has_consumptionUnit ();

    inline void clear_has_consumptionUnit ();

    inline void set_has_consumptionToDestinationAsInt ();

    inline void clear_has_consumptionToDestinationAsInt ();

    inline void set_has_consumptionToDestinationAsString ();

    inline void clear_has_consumptionToDestinationAsString ();

    uint32 _has_bits_[ (13 + 31) / 32];

    DistanceToDestination _distanceToDestination;

    ::std::string _timeToDestinationAsString;

    int32 _timeToDestination;

    ::std::string _estimatedTimeOfArrivalAsString;

    int32 _estimatedTimeOfArrivalHour;

    int32 _estimatedTimeOfArrivalMinute;

    EstimatedTimeType _estimatedTimeType;

    TimeType _displayTimeType;

    TimeFormat _displayTimeFormat;

    int32 _destinationIndex;

    ConsumptionUnit _consumptionUnit;

    uint32 _consumptionToDestinationAsInt;

    ::std::string _consumptionToDestinationAsString;

};

/**
 * If the meaning of "NextManeuverDetails" isn't clear, then there should be a description here.
 */
class NextManeuverDetails {
public:

    /**
     * Default constructor
     */
    inline  NextManeuverDetails ();

    /**
     * Copy constructor
     */
    inline  NextManeuverDetails (const NextManeuverDetails &rhs);

    /**
     * All fields constructor
     */
    inline  NextManeuverDetails (const ::std::string& distanceToManeuver_, DistanceUnit distanceToManeuverUnit_, ManeuverRecommendationType recommendationType_, bool isNewManeuver_, bool isReRouted_);

    /**
     * Destructor
     */
    inline  ~NextManeuverDetails();

    /**
     * Assignment operator
     */
    inline NextManeuverDetails& operator = (const NextManeuverDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextManeuverDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextManeuverDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextManeuverDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextManeuverDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "distanceToManeuver"

    static const int kDistanceToManeuver = 0;

    /**
     * Clears the field "distanceToManeuver".
     *
     * The field will be set to its default value. The hasDistanceToManeuver()
     * method will return false.
     */
    inline void clearDistanceToManeuver();

    /**
     * Checks whether the field "distanceToManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToManeuver()). Otherwise it will return false.
     */
    inline bool hasDistanceToManeuver () const;

    /**
     * Returns the value of the member "distanceToManeuver".
     *
     * If the meaning of "distanceToManeuver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceToManeuver"
     */
    inline const ::std::string& getDistanceToManeuver () const;

    /**
     * Retrieves the value of the field "distanceToManeuver" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distanceToManeuver".
     */
    inline ::std::string& getDistanceToManeuverMutable ();

    /**
     * Sets the value of the member "distanceToManeuver".
     *
     * If the meaning of "distanceToManeuver" isn't clear, then there should be a description here.
     *
     * @param distanceToManeuver The value which will be set
     */
    inline void setDistanceToManeuver (const ::std::string& distanceToManeuver_);

    /**
     * Sets the value of the member "distanceToManeuver".
     *
     * If the meaning of "distanceToManeuver" isn't clear, then there should be a description here.
     *
     * @param distanceToManeuver The value which will be set
     */
    inline void setDistanceToManeuver (const char* distanceToManeuver_);

    /**
     * Sets the value of the member "distanceToManeuver".
     *
     * If the meaning of "distanceToManeuver" isn't clear, then there should be a description here.
     *
     * @param distanceToManeuver The value which will be set
     */
    inline void setDistanceToManeuver (const char* value, size_t size);

    // API of field "distanceToManeuverUnit"

    static const int kDistanceToManeuverUnit = 1;

    /**
     * Clears the field "distanceToManeuverUnit".
     *
     * The field will be set to its default value. The hasDistanceToManeuverUnit()
     * method will return false.
     */
    inline void clearDistanceToManeuverUnit();

    /**
     * Checks whether the field "distanceToManeuverUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToManeuverUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceToManeuverUnit () const;

    /**
     * Returns the value of the member "distanceToManeuverUnit".
     *
     * If the meaning of "distanceToManeuverUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceToManeuverUnit"
     */
    inline DistanceUnit getDistanceToManeuverUnit () const;

    /**
     * Sets the value of the member "distanceToManeuverUnit".
     *
     * If the meaning of "distanceToManeuverUnit" isn't clear, then there should be a description here.
     *
     * @param distanceToManeuverUnit The value which will be set
     */
    inline void setDistanceToManeuverUnit (DistanceUnit distanceToManeuverUnit_);

    // API of field "recommendationType"

    static const int kRecommendationType = 2;

    /**
     * Clears the field "recommendationType".
     *
     * The field will be set to its default value. The hasRecommendationType()
     * method will return false.
     */
    inline void clearRecommendationType();

    /**
     * Checks whether the field "recommendationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecommendationType()). Otherwise it will return false.
     */
    inline bool hasRecommendationType () const;

    /**
     * Returns the value of the member "recommendationType".
     *
     * If the meaning of "recommendationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "recommendationType"
     */
    inline ManeuverRecommendationType getRecommendationType () const;

    /**
     * Sets the value of the member "recommendationType".
     *
     * If the meaning of "recommendationType" isn't clear, then there should be a description here.
     *
     * @param recommendationType The value which will be set
     */
    inline void setRecommendationType (ManeuverRecommendationType recommendationType_);

    // API of field "isNewManeuver"

    static const int kIsNewManeuver = 3;

    /**
     * Clears the field "isNewManeuver".
     *
     * The field will be set to its default value. The hasIsNewManeuver()
     * method will return false.
     */
    inline void clearIsNewManeuver();

    /**
     * Checks whether the field "isNewManeuver" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsNewManeuver()). Otherwise it will return false.
     */
    inline bool hasIsNewManeuver () const;

    /**
     * Returns the value of the member "isNewManeuver".
     *
     * If the meaning of "isNewManeuver" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isNewManeuver"
     */
    inline bool getIsNewManeuver () const;

    /**
     * Sets the value of the member "isNewManeuver".
     *
     * If the meaning of "isNewManeuver" isn't clear, then there should be a description here.
     *
     * @param isNewManeuver The value which will be set
     */
    inline void setIsNewManeuver (bool isNewManeuver_);

    // API of field "isReRouted"

    static const int kIsReRouted = 4;

    /**
     * Clears the field "isReRouted".
     *
     * The field will be set to its default value. The hasIsReRouted()
     * method will return false.
     */
    inline void clearIsReRouted();

    /**
     * Checks whether the field "isReRouted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsReRouted()). Otherwise it will return false.
     */
    inline bool hasIsReRouted () const;

    /**
     * Returns the value of the member "isReRouted".
     *
     * If the meaning of "isReRouted" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isReRouted"
     */
    inline bool getIsReRouted () const;

    /**
     * Sets the value of the member "isReRouted".
     *
     * If the meaning of "isReRouted" isn't clear, then there should be a description here.
     *
     * @param isReRouted The value which will be set
     */
    inline void setIsReRouted (bool isReRouted_);

    static const NextManeuverDetails &getDefaultInstance();

private:

    inline void set_has_distanceToManeuver ();

    inline void clear_has_distanceToManeuver ();

    inline void set_has_distanceToManeuverUnit ();

    inline void clear_has_distanceToManeuverUnit ();

    inline void set_has_recommendationType ();

    inline void clear_has_recommendationType ();

    inline void set_has_isNewManeuver ();

    inline void clear_has_isNewManeuver ();

    inline void set_has_isReRouted ();

    inline void clear_has_isReRouted ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _distanceToManeuver;

    DistanceUnit _distanceToManeuverUnit;

    ManeuverRecommendationType _recommendationType;

    bool _isNewManeuver;

    bool _isReRouted;

};

/**
 * If the meaning of "PoiCategoryShortcut" isn't clear, then there should be a description here.
 */
class PoiCategoryShortcut {
public:

    /**
     * Default constructor
     */
    inline  PoiCategoryShortcut ();

    /**
     * Copy constructor
     */
    inline  PoiCategoryShortcut (const PoiCategoryShortcut &rhs);

    /**
     * All fields constructor
     */
    inline  PoiCategoryShortcut (const ::std::string& categoryName_, uint32 poiCategoryId_, const Image& icon_, uint8 shortcutIndex_, const GlobalNamedObjectId& sdsNameObjectId_);

    /**
     * Destructor
     */
    inline  ~PoiCategoryShortcut();

    /**
     * Assignment operator
     */
    inline PoiCategoryShortcut& operator = (const PoiCategoryShortcut& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PoiCategoryShortcut& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PoiCategoryShortcut& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PoiCategoryShortcut& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PoiCategoryShortcut& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "categoryName"

    static const int kCategoryName = 0;

    /**
     * Clears the field "categoryName".
     *
     * The field will be set to its default value. The hasCategoryName()
     * method will return false.
     */
    inline void clearCategoryName();

    /**
     * Checks whether the field "categoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryName()). Otherwise it will return false.
     */
    inline bool hasCategoryName () const;

    /**
     * Returns the value of the member "categoryName".
     *
     * If the meaning of "categoryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "categoryName"
     */
    inline const ::std::string& getCategoryName () const;

    /**
     * Retrieves the value of the field "categoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "categoryName".
     */
    inline ::std::string& getCategoryNameMutable ();

    /**
     * Sets the value of the member "categoryName".
     *
     * If the meaning of "categoryName" isn't clear, then there should be a description here.
     *
     * @param categoryName The value which will be set
     */
    inline void setCategoryName (const ::std::string& categoryName_);

    /**
     * Sets the value of the member "categoryName".
     *
     * If the meaning of "categoryName" isn't clear, then there should be a description here.
     *
     * @param categoryName The value which will be set
     */
    inline void setCategoryName (const char* categoryName_);

    /**
     * Sets the value of the member "categoryName".
     *
     * If the meaning of "categoryName" isn't clear, then there should be a description here.
     *
     * @param categoryName The value which will be set
     */
    inline void setCategoryName (const char* value, size_t size);

    // API of field "poiCategoryId"

    static const int kPoiCategoryId = 1;

    /**
     * Clears the field "poiCategoryId".
     *
     * The field will be set to its default value. The hasPoiCategoryId()
     * method will return false.
     */
    inline void clearPoiCategoryId();

    /**
     * Checks whether the field "poiCategoryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryId()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryId () const;

    /**
     * Returns the value of the member "poiCategoryId".
     *
     * If the meaning of "poiCategoryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryId"
     */
    inline uint32 getPoiCategoryId () const;

    /**
     * Sets the value of the member "poiCategoryId".
     *
     * If the meaning of "poiCategoryId" isn't clear, then there should be a description here.
     *
     * @param poiCategoryId The value which will be set
     */
    inline void setPoiCategoryId (uint32 poiCategoryId_);

    // API of field "icon"

    static const int kIcon = 2;

    /**
     * Clears the field "icon".
     *
     * The field will be set to its default value. The hasIcon()
     * method will return false.
     */
    inline void clearIcon();

    /**
     * Checks whether the field "icon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIcon()). Otherwise it will return false.
     */
    inline bool hasIcon () const;

    /**
     * Returns the value of the member "icon".
     *
     * If the meaning of "icon" isn't clear, then there should be a description here.
     *
     * @return The value of the field "icon"
     */
    inline const Image& getIcon () const;

    /**
     * Retrieves the value of the field "icon" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "icon".
     */
    inline Image& getIconMutable ();

    /**
     * Sets the value of the member "icon".
     *
     * If the meaning of "icon" isn't clear, then there should be a description here.
     *
     * @param icon The value which will be set
     */
    inline void setIcon (const Image& icon_);

    // API of field "shortcutIndex"

    static const int kShortcutIndex = 3;

    /**
     * Clears the field "shortcutIndex".
     *
     * The field will be set to its default value. The hasShortcutIndex()
     * method will return false.
     */
    inline void clearShortcutIndex();

    /**
     * Checks whether the field "shortcutIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShortcutIndex()). Otherwise it will return false.
     */
    inline bool hasShortcutIndex () const;

    /**
     * Returns the value of the member "shortcutIndex".
     *
     * If the meaning of "shortcutIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "shortcutIndex"
     */
    inline uint8 getShortcutIndex () const;

    /**
     * Sets the value of the member "shortcutIndex".
     *
     * If the meaning of "shortcutIndex" isn't clear, then there should be a description here.
     *
     * @param shortcutIndex The value which will be set
     */
    inline void setShortcutIndex (uint8 shortcutIndex_);

    // API of field "sdsNameObjectId"

    static const int kSdsNameObjectId = 4;

    /**
     * Clears the field "sdsNameObjectId".
     *
     * The field will be set to its default value. The hasSdsNameObjectId()
     * method will return false.
     */
    inline void clearSdsNameObjectId();

    /**
     * Checks whether the field "sdsNameObjectId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsNameObjectId()). Otherwise it will return false.
     */
    inline bool hasSdsNameObjectId () const;

    /**
     * Returns the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsNameObjectId"
     */
    inline const GlobalNamedObjectId& getSdsNameObjectId () const;

    /**
     * Retrieves the value of the field "sdsNameObjectId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsNameObjectId".
     */
    inline GlobalNamedObjectId& getSdsNameObjectIdMutable ();

    /**
     * Sets the value of the member "sdsNameObjectId".
     *
     * If the meaning of "sdsNameObjectId" isn't clear, then there should be a description here.
     *
     * @param sdsNameObjectId The value which will be set
     */
    inline void setSdsNameObjectId (const GlobalNamedObjectId& sdsNameObjectId_);

    static const PoiCategoryShortcut &getDefaultInstance();

private:

    inline void set_has_categoryName ();

    inline void clear_has_categoryName ();

    inline void set_has_poiCategoryId ();

    inline void clear_has_poiCategoryId ();

    inline void set_has_icon ();

    inline void clear_has_icon ();

    inline void set_has_shortcutIndex ();

    inline void clear_has_shortcutIndex ();

    inline void set_has_sdsNameObjectId ();

    inline void clear_has_sdsNameObjectId ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _categoryName;

    uint32 _poiCategoryId;

    Image _icon;

    uint8 _shortcutIndex;

    GlobalNamedObjectId _sdsNameObjectId;

};

/**
 * struct contain location details of the requested location
 */
class LocationDetails {
public:

    /**
     * Default constructor
     */
    inline  LocationDetails ();

    /**
     * Copy constructor
     */
    inline  LocationDetails (const LocationDetails &rhs);

    /**
     * All fields constructor
     */
    inline  LocationDetails (const ::std::string& cityName_, const ::std::string& countryName_, const ::std::string& countryCode_, const ::std::string& stateName_, const ::std::string& stateCode_, const ::std::string& phoneNumber_, const ::std::string& poiAddress_, const ::std::string& streetName_, const ::std::string& zipCode_, const PositionWGS84& coordinate_);

    /**
     * Destructor
     */
    inline  ~LocationDetails();

    /**
     * Assignment operator
     */
    inline LocationDetails& operator = (const LocationDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LocationDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LocationDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LocationDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LocationDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cityName"

    static const int kCityName = 0;

    /**
     * Clears the field "cityName".
     *
     * The field will be set to its default value. The hasCityName()
     * method will return false.
     */
    inline void clearCityName();

    /**
     * Checks whether the field "cityName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityName()). Otherwise it will return false.
     */
    inline bool hasCityName () const;

    /**
     * Returns the value of the member "cityName".
     *
     * String cityName contain city name
     *
     * @return The value of the field "cityName"
     */
    inline const ::std::string& getCityName () const;

    /**
     * Retrieves the value of the field "cityName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityName".
     */
    inline ::std::string& getCityNameMutable ();

    /**
     * Sets the value of the member "cityName".
     *
     * String cityName contain city name
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const ::std::string& cityName_);

    /**
     * Sets the value of the member "cityName".
     *
     * String cityName contain city name
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const char* cityName_);

    /**
     * Sets the value of the member "cityName".
     *
     * String cityName contain city name
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const char* value, size_t size);

    // API of field "countryName"

    static const int kCountryName = 1;

    /**
     * Clears the field "countryName".
     *
     * The field will be set to its default value. The hasCountryName()
     * method will return false.
     */
    inline void clearCountryName();

    /**
     * Checks whether the field "countryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryName()). Otherwise it will return false.
     */
    inline bool hasCountryName () const;

    /**
     * Returns the value of the member "countryName".
     *
     * String countryName contain country full name
     *
     * @return The value of the field "countryName"
     */
    inline const ::std::string& getCountryName () const;

    /**
     * Retrieves the value of the field "countryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryName".
     */
    inline ::std::string& getCountryNameMutable ();

    /**
     * Sets the value of the member "countryName".
     *
     * String countryName contain country full name
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const ::std::string& countryName_);

    /**
     * Sets the value of the member "countryName".
     *
     * String countryName contain country full name
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const char* countryName_);

    /**
     * Sets the value of the member "countryName".
     *
     * String countryName contain country full name
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const char* value, size_t size);

    // API of field "countryCode"

    static const int kCountryCode = 2;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * String countryCode contain country short name
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * String countryCode contain country short name
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * String countryCode contain country short name
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * String countryCode contain country short name
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "stateName"

    static const int kStateName = 3;

    /**
     * Clears the field "stateName".
     *
     * The field will be set to its default value. The hasStateName()
     * method will return false.
     */
    inline void clearStateName();

    /**
     * Checks whether the field "stateName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateName()). Otherwise it will return false.
     */
    inline bool hasStateName () const;

    /**
     * Returns the value of the member "stateName".
     *
     * String stateName contain state full name
     *
     * @return The value of the field "stateName"
     */
    inline const ::std::string& getStateName () const;

    /**
     * Retrieves the value of the field "stateName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateName".
     */
    inline ::std::string& getStateNameMutable ();

    /**
     * Sets the value of the member "stateName".
     *
     * String stateName contain state full name
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const ::std::string& stateName_);

    /**
     * Sets the value of the member "stateName".
     *
     * String stateName contain state full name
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const char* stateName_);

    /**
     * Sets the value of the member "stateName".
     *
     * String stateName contain state full name
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const char* value, size_t size);

    // API of field "stateCode"

    static const int kStateCode = 4;

    /**
     * Clears the field "stateCode".
     *
     * The field will be set to its default value. The hasStateCode()
     * method will return false.
     */
    inline void clearStateCode();

    /**
     * Checks whether the field "stateCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateCode()). Otherwise it will return false.
     */
    inline bool hasStateCode () const;

    /**
     * Returns the value of the member "stateCode".
     *
     * String stateCode contain state short name
     *
     * @return The value of the field "stateCode"
     */
    inline const ::std::string& getStateCode () const;

    /**
     * Retrieves the value of the field "stateCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateCode".
     */
    inline ::std::string& getStateCodeMutable ();

    /**
     * Sets the value of the member "stateCode".
     *
     * String stateCode contain state short name
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const ::std::string& stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * String stateCode contain state short name
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* stateCode_);

    /**
     * Sets the value of the member "stateCode".
     *
     * String stateCode contain state short name
     *
     * @param stateCode The value which will be set
     */
    inline void setStateCode (const char* value, size_t size);

    // API of field "phoneNumber"

    static const int kPhoneNumber = 5;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * String phoneNumber contains phone number
     *
     * @return The value of the field "phoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "phoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "phoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "phoneNumber".
     *
     * String phoneNumber contains phone number
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& phoneNumber_);

    /**
     * Sets the value of the member "phoneNumber".
     *
     * String phoneNumber contains phone number
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* phoneNumber_);

    /**
     * Sets the value of the member "phoneNumber".
     *
     * String phoneNumber contains phone number
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "poiAddress"

    static const int kPoiAddress = 6;

    /**
     * Clears the field "poiAddress".
     *
     * The field will be set to its default value. The hasPoiAddress()
     * method will return false.
     */
    inline void clearPoiAddress();

    /**
     * Checks whether the field "poiAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiAddress()). Otherwise it will return false.
     */
    inline bool hasPoiAddress () const;

    /**
     * Returns the value of the member "poiAddress".
     *
     * String poiAddress contains poi address
     *
     * @return The value of the field "poiAddress"
     */
    inline const ::std::string& getPoiAddress () const;

    /**
     * Retrieves the value of the field "poiAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiAddress".
     */
    inline ::std::string& getPoiAddressMutable ();

    /**
     * Sets the value of the member "poiAddress".
     *
     * String poiAddress contains poi address
     *
     * @param poiAddress The value which will be set
     */
    inline void setPoiAddress (const ::std::string& poiAddress_);

    /**
     * Sets the value of the member "poiAddress".
     *
     * String poiAddress contains poi address
     *
     * @param poiAddress The value which will be set
     */
    inline void setPoiAddress (const char* poiAddress_);

    /**
     * Sets the value of the member "poiAddress".
     *
     * String poiAddress contains poi address
     *
     * @param poiAddress The value which will be set
     */
    inline void setPoiAddress (const char* value, size_t size);

    // API of field "streetName"

    static const int kStreetName = 7;

    /**
     * Clears the field "streetName".
     *
     * The field will be set to its default value. The hasStreetName()
     * method will return false.
     */
    inline void clearStreetName();

    /**
     * Checks whether the field "streetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetName()). Otherwise it will return false.
     */
    inline bool hasStreetName () const;

    /**
     * Returns the value of the member "streetName".
     *
     * String streetName contains street name
     *
     * @return The value of the field "streetName"
     */
    inline const ::std::string& getStreetName () const;

    /**
     * Retrieves the value of the field "streetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "streetName".
     */
    inline ::std::string& getStreetNameMutable ();

    /**
     * Sets the value of the member "streetName".
     *
     * String streetName contains street name
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const ::std::string& streetName_);

    /**
     * Sets the value of the member "streetName".
     *
     * String streetName contains street name
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const char* streetName_);

    /**
     * Sets the value of the member "streetName".
     *
     * String streetName contains street name
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const char* value, size_t size);

    // API of field "zipCode"

    static const int kZipCode = 8;

    /**
     * Clears the field "zipCode".
     *
     * The field will be set to its default value. The hasZipCode()
     * method will return false.
     */
    inline void clearZipCode();

    /**
     * Checks whether the field "zipCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZipCode()). Otherwise it will return false.
     */
    inline bool hasZipCode () const;

    /**
     * Returns the value of the member "zipCode".
     *
     * String zipCode contains ZIP code
     *
     * @return The value of the field "zipCode"
     */
    inline const ::std::string& getZipCode () const;

    /**
     * Retrieves the value of the field "zipCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "zipCode".
     */
    inline ::std::string& getZipCodeMutable ();

    /**
     * Sets the value of the member "zipCode".
     *
     * String zipCode contains ZIP code
     *
     * @param zipCode The value which will be set
     */
    inline void setZipCode (const ::std::string& zipCode_);

    /**
     * Sets the value of the member "zipCode".
     *
     * String zipCode contains ZIP code
     *
     * @param zipCode The value which will be set
     */
    inline void setZipCode (const char* zipCode_);

    /**
     * Sets the value of the member "zipCode".
     *
     * String zipCode contains ZIP code
     *
     * @param zipCode The value which will be set
     */
    inline void setZipCode (const char* value, size_t size);

    // API of field "coordinate"

    static const int kCoordinate = 9;

    /**
     * Clears the field "coordinate".
     *
     * The field will be set to its default value. The hasCoordinate()
     * method will return false.
     */
    inline void clearCoordinate();

    /**
     * Checks whether the field "coordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoordinate()). Otherwise it will return false.
     */
    inline bool hasCoordinate () const;

    /**
     * Returns the value of the member "coordinate".
     *
     * coordinate contains location's Latitude and Longitude information. (0.0,0.0) means its Invalid data
     *
     * @return The value of the field "coordinate"
     */
    inline const PositionWGS84& getCoordinate () const;

    /**
     * Retrieves the value of the field "coordinate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "coordinate".
     */
    inline PositionWGS84& getCoordinateMutable ();

    /**
     * Sets the value of the member "coordinate".
     *
     * coordinate contains location's Latitude and Longitude information. (0.0,0.0) means its Invalid data
     *
     * @param coordinate The value which will be set
     */
    inline void setCoordinate (const PositionWGS84& coordinate_);

    static const LocationDetails &getDefaultInstance();

private:

    inline void set_has_cityName ();

    inline void clear_has_cityName ();

    inline void set_has_countryName ();

    inline void clear_has_countryName ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_stateName ();

    inline void clear_has_stateName ();

    inline void set_has_stateCode ();

    inline void clear_has_stateCode ();

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_poiAddress ();

    inline void clear_has_poiAddress ();

    inline void set_has_streetName ();

    inline void clear_has_streetName ();

    inline void set_has_zipCode ();

    inline void clear_has_zipCode ();

    inline void set_has_coordinate ();

    inline void clear_has_coordinate ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::std::string _cityName;

    ::std::string _countryName;

    ::std::string _countryCode;

    ::std::string _stateName;

    ::std::string _stateCode;

    ::std::string _phoneNumber;

    ::std::string _poiAddress;

    ::std::string _streetName;

    ::std::string _zipCode;

    PositionWGS84 _coordinate;

};

/**
 * If the meaning of "DestinationMemoryEntry" isn't clear, then there should be a description here.
 */
class DestinationMemoryEntry {
public:

    /**
     * Default constructor
     */
    inline  DestinationMemoryEntry ();

    /**
     * Copy constructor
     */
    inline  DestinationMemoryEntry (const DestinationMemoryEntry &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationMemoryEntry (const ::std::string& name_, uint64 entryID_, uint32 voiceTagId_);

    /**
     * Destructor
     */
    inline  ~DestinationMemoryEntry();

    /**
     * Assignment operator
     */
    inline DestinationMemoryEntry& operator = (const DestinationMemoryEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationMemoryEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationMemoryEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationMemoryEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationMemoryEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "entryID"

    static const int kEntryID = 1;

    /**
     * Clears the field "entryID".
     *
     * The field will be set to its default value. The hasEntryID()
     * method will return false.
     */
    inline void clearEntryID();

    /**
     * Checks whether the field "entryID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntryID()). Otherwise it will return false.
     */
    inline bool hasEntryID () const;

    /**
     * Returns the value of the member "entryID".
     *
     * If the meaning of "entryID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "entryID"
     */
    inline uint64 getEntryID () const;

    /**
     * Sets the value of the member "entryID".
     *
     * If the meaning of "entryID" isn't clear, then there should be a description here.
     *
     * @param entryID The value which will be set
     */
    inline void setEntryID (uint64 entryID_);

    // API of field "voiceTagId"

    static const int kVoiceTagId = 2;

    /**
     * Clears the field "voiceTagId".
     *
     * The field will be set to its default value. The hasVoiceTagId()
     * method will return false.
     */
    inline void clearVoiceTagId();

    /**
     * Checks whether the field "voiceTagId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceTagId()). Otherwise it will return false.
     */
    inline bool hasVoiceTagId () const;

    /**
     * Returns the value of the member "voiceTagId".
     *
     * If the meaning of "voiceTagId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "voiceTagId"
     */
    inline uint32 getVoiceTagId () const;

    /**
     * Sets the value of the member "voiceTagId".
     *
     * If the meaning of "voiceTagId" isn't clear, then there should be a description here.
     *
     * @param voiceTagId The value which will be set
     */
    inline void setVoiceTagId (uint32 voiceTagId_);

    static const DestinationMemoryEntry &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_entryID ();

    inline void clear_has_entryID ();

    inline void set_has_voiceTagId ();

    inline void clear_has_voiceTagId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    uint64 _entryID;

    uint32 _voiceTagId;

};

/**
 * If the meaning of "DestinationMemoryEntryItem" isn't clear, then there should be a description here.
 */
class DestinationMemoryEntryItem {
public:

    /**
     * Default constructor
     */
    inline  DestinationMemoryEntryItem ();

    /**
     * Copy constructor
     */
    inline  DestinationMemoryEntryItem (const DestinationMemoryEntryItem &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationMemoryEntryItem (const ::std::string& itemString_, DestinationMemoryAddressType addressType_, const ::std::string& itemPhoneme_);

    /**
     * Destructor
     */
    inline  ~DestinationMemoryEntryItem();

    /**
     * Assignment operator
     */
    inline DestinationMemoryEntryItem& operator = (const DestinationMemoryEntryItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationMemoryEntryItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationMemoryEntryItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationMemoryEntryItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationMemoryEntryItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "itemString"

    static const int kItemString = 0;

    /**
     * Clears the field "itemString".
     *
     * The field will be set to its default value. The hasItemString()
     * method will return false.
     */
    inline void clearItemString();

    /**
     * Checks whether the field "itemString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setItemString()). Otherwise it will return false.
     */
    inline bool hasItemString () const;

    /**
     * Returns the value of the member "itemString".
     *
     * If the meaning of "itemString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "itemString"
     */
    inline const ::std::string& getItemString () const;

    /**
     * Retrieves the value of the field "itemString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "itemString".
     */
    inline ::std::string& getItemStringMutable ();

    /**
     * Sets the value of the member "itemString".
     *
     * If the meaning of "itemString" isn't clear, then there should be a description here.
     *
     * @param itemString The value which will be set
     */
    inline void setItemString (const ::std::string& itemString_);

    /**
     * Sets the value of the member "itemString".
     *
     * If the meaning of "itemString" isn't clear, then there should be a description here.
     *
     * @param itemString The value which will be set
     */
    inline void setItemString (const char* itemString_);

    /**
     * Sets the value of the member "itemString".
     *
     * If the meaning of "itemString" isn't clear, then there should be a description here.
     *
     * @param itemString The value which will be set
     */
    inline void setItemString (const char* value, size_t size);

    // API of field "addressType"

    static const int kAddressType = 1;

    /**
     * Clears the field "addressType".
     *
     * The field will be set to its default value. The hasAddressType()
     * method will return false.
     */
    inline void clearAddressType();

    /**
     * Checks whether the field "addressType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressType()). Otherwise it will return false.
     */
    inline bool hasAddressType () const;

    /**
     * Returns the value of the member "addressType".
     *
     * If the meaning of "addressType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressType"
     */
    inline DestinationMemoryAddressType getAddressType () const;

    /**
     * Sets the value of the member "addressType".
     *
     * If the meaning of "addressType" isn't clear, then there should be a description here.
     *
     * @param addressType The value which will be set
     */
    inline void setAddressType (DestinationMemoryAddressType addressType_);

    // API of field "itemPhoneme"

    static const int kItemPhoneme = 2;

    /**
     * Clears the field "itemPhoneme".
     *
     * The field will be set to its default value. The hasItemPhoneme()
     * method will return false.
     */
    inline void clearItemPhoneme();

    /**
     * Checks whether the field "itemPhoneme" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setItemPhoneme()). Otherwise it will return false.
     */
    inline bool hasItemPhoneme () const;

    /**
     * Returns the value of the member "itemPhoneme".
     *
     * If the meaning of "itemPhoneme" isn't clear, then there should be a description here.
     *
     * @return The value of the field "itemPhoneme"
     */
    inline const ::std::string& getItemPhoneme () const;

    /**
     * Retrieves the value of the field "itemPhoneme" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "itemPhoneme".
     */
    inline ::std::string& getItemPhonemeMutable ();

    /**
     * Sets the value of the member "itemPhoneme".
     *
     * If the meaning of "itemPhoneme" isn't clear, then there should be a description here.
     *
     * @param itemPhoneme The value which will be set
     */
    inline void setItemPhoneme (const ::std::string& itemPhoneme_);

    /**
     * Sets the value of the member "itemPhoneme".
     *
     * If the meaning of "itemPhoneme" isn't clear, then there should be a description here.
     *
     * @param itemPhoneme The value which will be set
     */
    inline void setItemPhoneme (const char* itemPhoneme_);

    /**
     * Sets the value of the member "itemPhoneme".
     *
     * If the meaning of "itemPhoneme" isn't clear, then there should be a description here.
     *
     * @param itemPhoneme The value which will be set
     */
    inline void setItemPhoneme (const char* value, size_t size);

    static const DestinationMemoryEntryItem &getDefaultInstance();

private:

    inline void set_has_itemString ();

    inline void clear_has_itemString ();

    inline void set_has_addressType ();

    inline void clear_has_addressType ();

    inline void set_has_itemPhoneme ();

    inline void clear_has_itemPhoneme ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _itemString;

    DestinationMemoryAddressType _addressType;

    ::std::string _itemPhoneme;

};

/**
 * DestinationMemoryEntryDetails contains the details of destination memory entries
 */
class DestinationMemoryEntryDetails {
public:

    /**
     * Default constructor
     */
    inline  DestinationMemoryEntryDetails ();

    /**
     * Copy constructor
     */
    inline  DestinationMemoryEntryDetails (const DestinationMemoryEntryDetails &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationMemoryEntryDetails (const ::std::string& countryName_, const ::std::string& stateName_, const ::std::string& cityName_, const ::std::string& streetName_, const ::std::string& houseno_, const ::std::string& junctionName_, const ::std::string& poiName_, const ::std::string& poiCategoryName_, const ::std::string& poiBrandName_, const ::std::string& countryCode_, const ::std::string& addressDetail_, const ::std::vector< DestinationMemoryEntryItem >& sdsDestinationMemoryEntries_);

    /**
     * Destructor
     */
    inline  ~DestinationMemoryEntryDetails();

    /**
     * Assignment operator
     */
    inline DestinationMemoryEntryDetails& operator = (const DestinationMemoryEntryDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationMemoryEntryDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationMemoryEntryDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationMemoryEntryDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationMemoryEntryDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "countryName"

    static const int kCountryName = 0;

    /**
     * Clears the field "countryName".
     *
     * The field will be set to its default value. The hasCountryName()
     * method will return false.
     */
    inline void clearCountryName();

    /**
     * Checks whether the field "countryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryName()). Otherwise it will return false.
     */
    inline bool hasCountryName () const;

    /**
     * Returns the value of the member "countryName".
     *
     * old implementation still keep to avoid confliction
     *
     * @return The value of the field "countryName"
     */
    inline const ::std::string& getCountryName () const;

    /**
     * Retrieves the value of the field "countryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryName".
     */
    inline ::std::string& getCountryNameMutable ();

    /**
     * Sets the value of the member "countryName".
     *
     * old implementation still keep to avoid confliction
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const ::std::string& countryName_);

    /**
     * Sets the value of the member "countryName".
     *
     * old implementation still keep to avoid confliction
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const char* countryName_);

    /**
     * Sets the value of the member "countryName".
     *
     * old implementation still keep to avoid confliction
     *
     * @param countryName The value which will be set
     */
    inline void setCountryName (const char* value, size_t size);

    // API of field "stateName"

    static const int kStateName = 1;

    /**
     * Clears the field "stateName".
     *
     * The field will be set to its default value. The hasStateName()
     * method will return false.
     */
    inline void clearStateName();

    /**
     * Checks whether the field "stateName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateName()). Otherwise it will return false.
     */
    inline bool hasStateName () const;

    /**
     * Returns the value of the member "stateName".
     *
     * If the meaning of "stateName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stateName"
     */
    inline const ::std::string& getStateName () const;

    /**
     * Retrieves the value of the field "stateName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateName".
     */
    inline ::std::string& getStateNameMutable ();

    /**
     * Sets the value of the member "stateName".
     *
     * If the meaning of "stateName" isn't clear, then there should be a description here.
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const ::std::string& stateName_);

    /**
     * Sets the value of the member "stateName".
     *
     * If the meaning of "stateName" isn't clear, then there should be a description here.
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const char* stateName_);

    /**
     * Sets the value of the member "stateName".
     *
     * If the meaning of "stateName" isn't clear, then there should be a description here.
     *
     * @param stateName The value which will be set
     */
    inline void setStateName (const char* value, size_t size);

    // API of field "cityName"

    static const int kCityName = 2;

    /**
     * Clears the field "cityName".
     *
     * The field will be set to its default value. The hasCityName()
     * method will return false.
     */
    inline void clearCityName();

    /**
     * Checks whether the field "cityName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityName()). Otherwise it will return false.
     */
    inline bool hasCityName () const;

    /**
     * Returns the value of the member "cityName".
     *
     * If the meaning of "cityName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityName"
     */
    inline const ::std::string& getCityName () const;

    /**
     * Retrieves the value of the field "cityName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityName".
     */
    inline ::std::string& getCityNameMutable ();

    /**
     * Sets the value of the member "cityName".
     *
     * If the meaning of "cityName" isn't clear, then there should be a description here.
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const ::std::string& cityName_);

    /**
     * Sets the value of the member "cityName".
     *
     * If the meaning of "cityName" isn't clear, then there should be a description here.
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const char* cityName_);

    /**
     * Sets the value of the member "cityName".
     *
     * If the meaning of "cityName" isn't clear, then there should be a description here.
     *
     * @param cityName The value which will be set
     */
    inline void setCityName (const char* value, size_t size);

    // API of field "streetName"

    static const int kStreetName = 3;

    /**
     * Clears the field "streetName".
     *
     * The field will be set to its default value. The hasStreetName()
     * method will return false.
     */
    inline void clearStreetName();

    /**
     * Checks whether the field "streetName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreetName()). Otherwise it will return false.
     */
    inline bool hasStreetName () const;

    /**
     * Returns the value of the member "streetName".
     *
     * If the meaning of "streetName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "streetName"
     */
    inline const ::std::string& getStreetName () const;

    /**
     * Retrieves the value of the field "streetName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "streetName".
     */
    inline ::std::string& getStreetNameMutable ();

    /**
     * Sets the value of the member "streetName".
     *
     * If the meaning of "streetName" isn't clear, then there should be a description here.
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const ::std::string& streetName_);

    /**
     * Sets the value of the member "streetName".
     *
     * If the meaning of "streetName" isn't clear, then there should be a description here.
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const char* streetName_);

    /**
     * Sets the value of the member "streetName".
     *
     * If the meaning of "streetName" isn't clear, then there should be a description here.
     *
     * @param streetName The value which will be set
     */
    inline void setStreetName (const char* value, size_t size);

    // API of field "houseno"

    static const int kHouseno = 4;

    /**
     * Clears the field "houseno".
     *
     * The field will be set to its default value. The hasHouseno()
     * method will return false.
     */
    inline void clearHouseno();

    /**
     * Checks whether the field "houseno" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHouseno()). Otherwise it will return false.
     */
    inline bool hasHouseno () const;

    /**
     * Returns the value of the member "houseno".
     *
     * If the meaning of "houseno" isn't clear, then there should be a description here.
     *
     * @return The value of the field "houseno"
     */
    inline const ::std::string& getHouseno () const;

    /**
     * Retrieves the value of the field "houseno" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "houseno".
     */
    inline ::std::string& getHousenoMutable ();

    /**
     * Sets the value of the member "houseno".
     *
     * If the meaning of "houseno" isn't clear, then there should be a description here.
     *
     * @param houseno The value which will be set
     */
    inline void setHouseno (const ::std::string& houseno_);

    /**
     * Sets the value of the member "houseno".
     *
     * If the meaning of "houseno" isn't clear, then there should be a description here.
     *
     * @param houseno The value which will be set
     */
    inline void setHouseno (const char* houseno_);

    /**
     * Sets the value of the member "houseno".
     *
     * If the meaning of "houseno" isn't clear, then there should be a description here.
     *
     * @param houseno The value which will be set
     */
    inline void setHouseno (const char* value, size_t size);

    // API of field "junctionName"

    static const int kJunctionName = 5;

    /**
     * Clears the field "junctionName".
     *
     * The field will be set to its default value. The hasJunctionName()
     * method will return false.
     */
    inline void clearJunctionName();

    /**
     * Checks whether the field "junctionName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJunctionName()). Otherwise it will return false.
     */
    inline bool hasJunctionName () const;

    /**
     * Returns the value of the member "junctionName".
     *
     * If the meaning of "junctionName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "junctionName"
     */
    inline const ::std::string& getJunctionName () const;

    /**
     * Retrieves the value of the field "junctionName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "junctionName".
     */
    inline ::std::string& getJunctionNameMutable ();

    /**
     * Sets the value of the member "junctionName".
     *
     * If the meaning of "junctionName" isn't clear, then there should be a description here.
     *
     * @param junctionName The value which will be set
     */
    inline void setJunctionName (const ::std::string& junctionName_);

    /**
     * Sets the value of the member "junctionName".
     *
     * If the meaning of "junctionName" isn't clear, then there should be a description here.
     *
     * @param junctionName The value which will be set
     */
    inline void setJunctionName (const char* junctionName_);

    /**
     * Sets the value of the member "junctionName".
     *
     * If the meaning of "junctionName" isn't clear, then there should be a description here.
     *
     * @param junctionName The value which will be set
     */
    inline void setJunctionName (const char* value, size_t size);

    // API of field "poiName"

    static const int kPoiName = 6;

    /**
     * Clears the field "poiName".
     *
     * The field will be set to its default value. The hasPoiName()
     * method will return false.
     */
    inline void clearPoiName();

    /**
     * Checks whether the field "poiName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiName()). Otherwise it will return false.
     */
    inline bool hasPoiName () const;

    /**
     * Returns the value of the member "poiName".
     *
     * If the meaning of "poiName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiName"
     */
    inline const ::std::string& getPoiName () const;

    /**
     * Retrieves the value of the field "poiName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiName".
     */
    inline ::std::string& getPoiNameMutable ();

    /**
     * Sets the value of the member "poiName".
     *
     * If the meaning of "poiName" isn't clear, then there should be a description here.
     *
     * @param poiName The value which will be set
     */
    inline void setPoiName (const ::std::string& poiName_);

    /**
     * Sets the value of the member "poiName".
     *
     * If the meaning of "poiName" isn't clear, then there should be a description here.
     *
     * @param poiName The value which will be set
     */
    inline void setPoiName (const char* poiName_);

    /**
     * Sets the value of the member "poiName".
     *
     * If the meaning of "poiName" isn't clear, then there should be a description here.
     *
     * @param poiName The value which will be set
     */
    inline void setPoiName (const char* value, size_t size);

    // API of field "poiCategoryName"

    static const int kPoiCategoryName = 7;

    /**
     * Clears the field "poiCategoryName".
     *
     * The field will be set to its default value. The hasPoiCategoryName()
     * method will return false.
     */
    inline void clearPoiCategoryName();

    /**
     * Checks whether the field "poiCategoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryName()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryName () const;

    /**
     * Returns the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryName"
     */
    inline const ::std::string& getPoiCategoryName () const;

    /**
     * Retrieves the value of the field "poiCategoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiCategoryName".
     */
    inline ::std::string& getPoiCategoryNameMutable ();

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const ::std::string& poiCategoryName_);

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const char* poiCategoryName_);

    /**
     * Sets the value of the member "poiCategoryName".
     *
     * If the meaning of "poiCategoryName" isn't clear, then there should be a description here.
     *
     * @param poiCategoryName The value which will be set
     */
    inline void setPoiCategoryName (const char* value, size_t size);

    // API of field "poiBrandName"

    static const int kPoiBrandName = 8;

    /**
     * Clears the field "poiBrandName".
     *
     * The field will be set to its default value. The hasPoiBrandName()
     * method will return false.
     */
    inline void clearPoiBrandName();

    /**
     * Checks whether the field "poiBrandName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiBrandName()). Otherwise it will return false.
     */
    inline bool hasPoiBrandName () const;

    /**
     * Returns the value of the member "poiBrandName".
     *
     * If the meaning of "poiBrandName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiBrandName"
     */
    inline const ::std::string& getPoiBrandName () const;

    /**
     * Retrieves the value of the field "poiBrandName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiBrandName".
     */
    inline ::std::string& getPoiBrandNameMutable ();

    /**
     * Sets the value of the member "poiBrandName".
     *
     * If the meaning of "poiBrandName" isn't clear, then there should be a description here.
     *
     * @param poiBrandName The value which will be set
     */
    inline void setPoiBrandName (const ::std::string& poiBrandName_);

    /**
     * Sets the value of the member "poiBrandName".
     *
     * If the meaning of "poiBrandName" isn't clear, then there should be a description here.
     *
     * @param poiBrandName The value which will be set
     */
    inline void setPoiBrandName (const char* poiBrandName_);

    /**
     * Sets the value of the member "poiBrandName".
     *
     * If the meaning of "poiBrandName" isn't clear, then there should be a description here.
     *
     * @param poiBrandName The value which will be set
     */
    inline void setPoiBrandName (const char* value, size_t size);

    // API of field "countryCode"

    static const int kCountryCode = 9;

    /**
     * Clears the field "countryCode".
     *
     * The field will be set to its default value. The hasCountryCode()
     * method will return false.
     */
    inline void clearCountryCode();

    /**
     * Checks whether the field "countryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryCode()). Otherwise it will return false.
     */
    inline bool hasCountryCode () const;

    /**
     * Returns the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countryCode"
     */
    inline const ::std::string& getCountryCode () const;

    /**
     * Retrieves the value of the field "countryCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "countryCode".
     */
    inline ::std::string& getCountryCodeMutable ();

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const ::std::string& countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* countryCode_);

    /**
     * Sets the value of the member "countryCode".
     *
     * If the meaning of "countryCode" isn't clear, then there should be a description here.
     *
     * @param countryCode The value which will be set
     */
    inline void setCountryCode (const char* value, size_t size);

    // API of field "addressDetail"

    static const int kAddressDetail = 10;

    /**
     * Clears the field "addressDetail".
     *
     * The field will be set to its default value. The hasAddressDetail()
     * method will return false.
     */
    inline void clearAddressDetail();

    /**
     * Checks whether the field "addressDetail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddressDetail()). Otherwise it will return false.
     */
    inline bool hasAddressDetail () const;

    /**
     * Returns the value of the member "addressDetail".
     *
     * If the meaning of "addressDetail" isn't clear, then there should be a description here.
     *
     * @return The value of the field "addressDetail"
     */
    inline const ::std::string& getAddressDetail () const;

    /**
     * Retrieves the value of the field "addressDetail" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "addressDetail".
     */
    inline ::std::string& getAddressDetailMutable ();

    /**
     * Sets the value of the member "addressDetail".
     *
     * If the meaning of "addressDetail" isn't clear, then there should be a description here.
     *
     * @param addressDetail The value which will be set
     */
    inline void setAddressDetail (const ::std::string& addressDetail_);

    /**
     * Sets the value of the member "addressDetail".
     *
     * If the meaning of "addressDetail" isn't clear, then there should be a description here.
     *
     * @param addressDetail The value which will be set
     */
    inline void setAddressDetail (const char* addressDetail_);

    /**
     * Sets the value of the member "addressDetail".
     *
     * If the meaning of "addressDetail" isn't clear, then there should be a description here.
     *
     * @param addressDetail The value which will be set
     */
    inline void setAddressDetail (const char* value, size_t size);

    // API of field "sdsDestinationMemoryEntries"

    static const int kSdsDestinationMemoryEntries = 11;

    /**
     * Clears the field "sdsDestinationMemoryEntries".
     *
     * The field will be set to its default value. The hasSdsDestinationMemoryEntries()
     * method will return false.
     */
    inline void clearSdsDestinationMemoryEntries();

    /**
     * Checks whether the field "sdsDestinationMemoryEntries" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsDestinationMemoryEntries()). Otherwise it will return false.
     */
    inline bool hasSdsDestinationMemoryEntries () const;

    /**
     * Returns the value of the member "sdsDestinationMemoryEntries".
     *
     * If the meaning of "sdsDestinationMemoryEntries" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsDestinationMemoryEntries"
     */
    inline const ::std::vector< DestinationMemoryEntryItem >& getSdsDestinationMemoryEntries () const;

    /**
     * Retrieves the value of the field "sdsDestinationMemoryEntries" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsDestinationMemoryEntries".
     */
    inline ::std::vector< DestinationMemoryEntryItem >& getSdsDestinationMemoryEntriesMutable ();

    /**
     * Sets the value of the member "sdsDestinationMemoryEntries".
     *
     * If the meaning of "sdsDestinationMemoryEntries" isn't clear, then there should be a description here.
     *
     * @param sdsDestinationMemoryEntries The value which will be set
     */
    inline void setSdsDestinationMemoryEntries (const ::std::vector< DestinationMemoryEntryItem >& sdsDestinationMemoryEntries_);

    static const DestinationMemoryEntryDetails &getDefaultInstance();

private:

    static const ::std::vector< DestinationMemoryEntryItem >& getDestinationMemoryEntryItemList_DefaultInstance ();

    inline void set_has_countryName ();

    inline void clear_has_countryName ();

    inline void set_has_stateName ();

    inline void clear_has_stateName ();

    inline void set_has_cityName ();

    inline void clear_has_cityName ();

    inline void set_has_streetName ();

    inline void clear_has_streetName ();

    inline void set_has_houseno ();

    inline void clear_has_houseno ();

    inline void set_has_junctionName ();

    inline void clear_has_junctionName ();

    inline void set_has_poiName ();

    inline void clear_has_poiName ();

    inline void set_has_poiCategoryName ();

    inline void clear_has_poiCategoryName ();

    inline void set_has_poiBrandName ();

    inline void clear_has_poiBrandName ();

    inline void set_has_countryCode ();

    inline void clear_has_countryCode ();

    inline void set_has_addressDetail ();

    inline void clear_has_addressDetail ();

    inline void set_has_sdsDestinationMemoryEntries ();

    inline void clear_has_sdsDestinationMemoryEntries ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::std::string _countryName;

    ::std::string _stateName;

    ::std::string _cityName;

    ::std::string _streetName;

    ::std::string _houseno;

    ::std::string _junctionName;

    ::std::string _poiName;

    ::std::string _poiCategoryName;

    ::std::string _poiBrandName;

    ::std::string _countryCode;

    ::std::string _addressDetail;

    ::std::vector< DestinationMemoryEntryItem > _sdsDestinationMemoryEntries;

};

/**
 * If the meaning of "DestinationMemoryDetailListElement" isn't clear, then there should be a description here.
 */
class DestinationMemoryDetailListElement {
public:

    /**
     * Default constructor
     */
    inline  DestinationMemoryDetailListElement ();

    /**
     * Copy constructor
     */
    inline  DestinationMemoryDetailListElement (const DestinationMemoryDetailListElement &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationMemoryDetailListElement (const DestinationMemoryEntry& entry_, const DestinationMemoryEntryDetails& details_, const PositionWGS84& coordinates_);

    /**
     * Destructor
     */
    inline  ~DestinationMemoryDetailListElement();

    /**
     * Assignment operator
     */
    inline DestinationMemoryDetailListElement& operator = (const DestinationMemoryDetailListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationMemoryDetailListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationMemoryDetailListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationMemoryDetailListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationMemoryDetailListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "entry"

    static const int kEntry = 0;

    /**
     * Clears the field "entry".
     *
     * The field will be set to its default value. The hasEntry()
     * method will return false.
     */
    inline void clearEntry();

    /**
     * Checks whether the field "entry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntry()). Otherwise it will return false.
     */
    inline bool hasEntry () const;

    /**
     * Returns the value of the member "entry".
     *
     * If the meaning of "entry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "entry"
     */
    inline const DestinationMemoryEntry& getEntry () const;

    /**
     * Retrieves the value of the field "entry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "entry".
     */
    inline DestinationMemoryEntry& getEntryMutable ();

    /**
     * Sets the value of the member "entry".
     *
     * If the meaning of "entry" isn't clear, then there should be a description here.
     *
     * @param entry The value which will be set
     */
    inline void setEntry (const DestinationMemoryEntry& entry_);

    // API of field "details"

    static const int kDetails = 1;

    /**
     * Clears the field "details".
     *
     * The field will be set to its default value. The hasDetails()
     * method will return false.
     */
    inline void clearDetails();

    /**
     * Checks whether the field "details" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDetails()). Otherwise it will return false.
     */
    inline bool hasDetails () const;

    /**
     * Returns the value of the member "details".
     *
     * If the meaning of "details" isn't clear, then there should be a description here.
     *
     * @return The value of the field "details"
     */
    inline const DestinationMemoryEntryDetails& getDetails () const;

    /**
     * Retrieves the value of the field "details" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "details".
     */
    inline DestinationMemoryEntryDetails& getDetailsMutable ();

    /**
     * Sets the value of the member "details".
     *
     * If the meaning of "details" isn't clear, then there should be a description here.
     *
     * @param details The value which will be set
     */
    inline void setDetails (const DestinationMemoryEntryDetails& details_);

    // API of field "coordinates"

    static const int kCoordinates = 2;

    /**
     * Clears the field "coordinates".
     *
     * The field will be set to its default value. The hasCoordinates()
     * method will return false.
     */
    inline void clearCoordinates();

    /**
     * Checks whether the field "coordinates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoordinates()). Otherwise it will return false.
     */
    inline bool hasCoordinates () const;

    /**
     * Returns the value of the member "coordinates".
     *
     * If the meaning of "coordinates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "coordinates"
     */
    inline const PositionWGS84& getCoordinates () const;

    /**
     * Retrieves the value of the field "coordinates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "coordinates".
     */
    inline PositionWGS84& getCoordinatesMutable ();

    /**
     * Sets the value of the member "coordinates".
     *
     * If the meaning of "coordinates" isn't clear, then there should be a description here.
     *
     * @param coordinates The value which will be set
     */
    inline void setCoordinates (const PositionWGS84& coordinates_);

    static const DestinationMemoryDetailListElement &getDefaultInstance();

private:

    inline void set_has_entry ();

    inline void clear_has_entry ();

    inline void set_has_details ();

    inline void clear_has_details ();

    inline void set_has_coordinates ();

    inline void clear_has_coordinates ();

    uint32 _has_bits_[ (3 + 31) / 32];

    DestinationMemoryEntry _entry;

    DestinationMemoryEntryDetails _details;

    PositionWGS84 _coordinates;

};

/**
 * If the meaning of "SDSVoiceTagId" isn't clear, then there should be a description here.
 */
class SDSVoiceTagId {
public:

    /**
     * Default constructor
     */
    inline  SDSVoiceTagId ();

    /**
     * Copy constructor
     */
    inline  SDSVoiceTagId (const SDSVoiceTagId &rhs);

    /**
     * All fields constructor
     */
    inline  SDSVoiceTagId (uint64 destinationMemoryEntryId_, const ::std::string& destinationMemoryEntryName_, uint32 sdsVoiceTagId_, SDSVoiceTagOptions options_);

    /**
     * Destructor
     */
    inline  ~SDSVoiceTagId();

    /**
     * Assignment operator
     */
    inline SDSVoiceTagId& operator = (const SDSVoiceTagId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SDSVoiceTagId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SDSVoiceTagId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SDSVoiceTagId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SDSVoiceTagId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destinationMemoryEntryId"

    static const int kDestinationMemoryEntryId = 0;

    /**
     * Clears the field "destinationMemoryEntryId".
     *
     * The field will be set to its default value. The hasDestinationMemoryEntryId()
     * method will return false.
     */
    inline void clearDestinationMemoryEntryId();

    /**
     * Checks whether the field "destinationMemoryEntryId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryEntryId()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryEntryId () const;

    /**
     * Returns the value of the member "destinationMemoryEntryId".
     *
     * If the meaning of "destinationMemoryEntryId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryEntryId"
     */
    inline uint64 getDestinationMemoryEntryId () const;

    /**
     * Sets the value of the member "destinationMemoryEntryId".
     *
     * If the meaning of "destinationMemoryEntryId" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryId The value which will be set
     */
    inline void setDestinationMemoryEntryId (uint64 destinationMemoryEntryId_);

    // API of field "destinationMemoryEntryName"

    static const int kDestinationMemoryEntryName = 1;

    /**
     * Clears the field "destinationMemoryEntryName".
     *
     * The field will be set to its default value. The hasDestinationMemoryEntryName()
     * method will return false.
     */
    inline void clearDestinationMemoryEntryName();

    /**
     * Checks whether the field "destinationMemoryEntryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryEntryName()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryEntryName () const;

    /**
     * Returns the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryEntryName"
     */
    inline const ::std::string& getDestinationMemoryEntryName () const;

    /**
     * Retrieves the value of the field "destinationMemoryEntryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationMemoryEntryName".
     */
    inline ::std::string& getDestinationMemoryEntryNameMutable ();

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const ::std::string& destinationMemoryEntryName_);

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const char* destinationMemoryEntryName_);

    /**
     * Sets the value of the member "destinationMemoryEntryName".
     *
     * If the meaning of "destinationMemoryEntryName" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntryName The value which will be set
     */
    inline void setDestinationMemoryEntryName (const char* value, size_t size);

    // API of field "sdsVoiceTagId"

    static const int kSdsVoiceTagId = 2;

    /**
     * Clears the field "sdsVoiceTagId".
     *
     * The field will be set to its default value. The hasSdsVoiceTagId()
     * method will return false.
     */
    inline void clearSdsVoiceTagId();

    /**
     * Checks whether the field "sdsVoiceTagId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsVoiceTagId()). Otherwise it will return false.
     */
    inline bool hasSdsVoiceTagId () const;

    /**
     * Returns the value of the member "sdsVoiceTagId".
     *
     * If the meaning of "sdsVoiceTagId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsVoiceTagId"
     */
    inline uint32 getSdsVoiceTagId () const;

    /**
     * Sets the value of the member "sdsVoiceTagId".
     *
     * If the meaning of "sdsVoiceTagId" isn't clear, then there should be a description here.
     *
     * @param sdsVoiceTagId The value which will be set
     */
    inline void setSdsVoiceTagId (uint32 sdsVoiceTagId_);

    // API of field "options"

    static const int kOptions = 3;

    /**
     * Clears the field "options".
     *
     * The field will be set to its default value. The hasOptions()
     * method will return false.
     */
    inline void clearOptions();

    /**
     * Checks whether the field "options" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOptions()). Otherwise it will return false.
     */
    inline bool hasOptions () const;

    /**
     * Returns the value of the member "options".
     *
     * If the meaning of "options" isn't clear, then there should be a description here.
     *
     * @return The value of the field "options"
     */
    inline SDSVoiceTagOptions getOptions () const;

    /**
     * Sets the value of the member "options".
     *
     * If the meaning of "options" isn't clear, then there should be a description here.
     *
     * @param options The value which will be set
     */
    inline void setOptions (SDSVoiceTagOptions options_);

    static const SDSVoiceTagId &getDefaultInstance();

private:

    inline void set_has_destinationMemoryEntryId ();

    inline void clear_has_destinationMemoryEntryId ();

    inline void set_has_destinationMemoryEntryName ();

    inline void clear_has_destinationMemoryEntryName ();

    inline void set_has_sdsVoiceTagId ();

    inline void clear_has_sdsVoiceTagId ();

    inline void set_has_options ();

    inline void clear_has_options ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint64 _destinationMemoryEntryId;

    ::std::string _destinationMemoryEntryName;

    uint32 _sdsVoiceTagId;

    SDSVoiceTagOptions _options;

};

/**
 * If the meaning of "TripReplayStatusInfo" isn't clear, then there should be a description here.
 */
class TripReplayStatusInfo {
public:

    /**
     * Default constructor
     */
    inline  TripReplayStatusInfo ();

    /**
     * Copy constructor
     */
    inline  TripReplayStatusInfo (const TripReplayStatusInfo &rhs);

    /**
     * All fields constructor
     */
    inline  TripReplayStatusInfo (TripReplayStatus status_, bool loopModeActive_, const ::std::string& tripFileName_, uint8 progress_, uint8 syncSegment_, uint8 countSyncSegments_, uint8 speed_);

    /**
     * Destructor
     */
    inline  ~TripReplayStatusInfo();

    /**
     * Assignment operator
     */
    inline TripReplayStatusInfo& operator = (const TripReplayStatusInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TripReplayStatusInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TripReplayStatusInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TripReplayStatusInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TripReplayStatusInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline TripReplayStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (TripReplayStatus status_);

    // API of field "loopModeActive"

    static const int kLoopModeActive = 1;

    /**
     * Clears the field "loopModeActive".
     *
     * The field will be set to its default value. The hasLoopModeActive()
     * method will return false.
     */
    inline void clearLoopModeActive();

    /**
     * Checks whether the field "loopModeActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoopModeActive()). Otherwise it will return false.
     */
    inline bool hasLoopModeActive () const;

    /**
     * Returns the value of the member "loopModeActive".
     *
     * If the meaning of "loopModeActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loopModeActive"
     */
    inline bool getLoopModeActive () const;

    /**
     * Sets the value of the member "loopModeActive".
     *
     * If the meaning of "loopModeActive" isn't clear, then there should be a description here.
     *
     * @param loopModeActive The value which will be set
     */
    inline void setLoopModeActive (bool loopModeActive_);

    // API of field "tripFileName"

    static const int kTripFileName = 2;

    /**
     * Clears the field "tripFileName".
     *
     * The field will be set to its default value. The hasTripFileName()
     * method will return false.
     */
    inline void clearTripFileName();

    /**
     * Checks whether the field "tripFileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTripFileName()). Otherwise it will return false.
     */
    inline bool hasTripFileName () const;

    /**
     * Returns the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tripFileName"
     */
    inline const ::std::string& getTripFileName () const;

    /**
     * Retrieves the value of the field "tripFileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tripFileName".
     */
    inline ::std::string& getTripFileNameMutable ();

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const ::std::string& tripFileName_);

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const char* tripFileName_);

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const char* value, size_t size);

    // API of field "progress"

    static const int kProgress = 3;

    /**
     * Clears the field "progress".
     *
     * The field will be set to its default value. The hasProgress()
     * method will return false.
     */
    inline void clearProgress();

    /**
     * Checks whether the field "progress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgress()). Otherwise it will return false.
     */
    inline bool hasProgress () const;

    /**
     * Returns the value of the member "progress".
     *
     * If the meaning of "progress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "progress"
     */
    inline uint8 getProgress () const;

    /**
     * Sets the value of the member "progress".
     *
     * If the meaning of "progress" isn't clear, then there should be a description here.
     *
     * @param progress The value which will be set
     */
    inline void setProgress (uint8 progress_);

    // API of field "syncSegment"

    static const int kSyncSegment = 4;

    /**
     * Clears the field "syncSegment".
     *
     * The field will be set to its default value. The hasSyncSegment()
     * method will return false.
     */
    inline void clearSyncSegment();

    /**
     * Checks whether the field "syncSegment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSyncSegment()). Otherwise it will return false.
     */
    inline bool hasSyncSegment () const;

    /**
     * Returns the value of the member "syncSegment".
     *
     * If the meaning of "syncSegment" isn't clear, then there should be a description here.
     *
     * @return The value of the field "syncSegment"
     */
    inline uint8 getSyncSegment () const;

    /**
     * Sets the value of the member "syncSegment".
     *
     * If the meaning of "syncSegment" isn't clear, then there should be a description here.
     *
     * @param syncSegment The value which will be set
     */
    inline void setSyncSegment (uint8 syncSegment_);

    // API of field "countSyncSegments"

    static const int kCountSyncSegments = 5;

    /**
     * Clears the field "countSyncSegments".
     *
     * The field will be set to its default value. The hasCountSyncSegments()
     * method will return false.
     */
    inline void clearCountSyncSegments();

    /**
     * Checks whether the field "countSyncSegments" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountSyncSegments()). Otherwise it will return false.
     */
    inline bool hasCountSyncSegments () const;

    /**
     * Returns the value of the member "countSyncSegments".
     *
     * If the meaning of "countSyncSegments" isn't clear, then there should be a description here.
     *
     * @return The value of the field "countSyncSegments"
     */
    inline uint8 getCountSyncSegments () const;

    /**
     * Sets the value of the member "countSyncSegments".
     *
     * If the meaning of "countSyncSegments" isn't clear, then there should be a description here.
     *
     * @param countSyncSegments The value which will be set
     */
    inline void setCountSyncSegments (uint8 countSyncSegments_);

    // API of field "speed"

    static const int kSpeed = 6;

    /**
     * Clears the field "speed".
     *
     * The field will be set to its default value. The hasSpeed()
     * method will return false.
     */
    inline void clearSpeed();

    /**
     * Checks whether the field "speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeed()). Otherwise it will return false.
     */
    inline bool hasSpeed () const;

    /**
     * Returns the value of the member "speed".
     *
     * If the meaning of "speed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speed"
     */
    inline uint8 getSpeed () const;

    /**
     * Sets the value of the member "speed".
     *
     * If the meaning of "speed" isn't clear, then there should be a description here.
     *
     * @param speed The value which will be set
     */
    inline void setSpeed (uint8 speed_);

    static const TripReplayStatusInfo &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_loopModeActive ();

    inline void clear_has_loopModeActive ();

    inline void set_has_tripFileName ();

    inline void clear_has_tripFileName ();

    inline void set_has_progress ();

    inline void clear_has_progress ();

    inline void set_has_syncSegment ();

    inline void clear_has_syncSegment ();

    inline void set_has_countSyncSegments ();

    inline void clear_has_countSyncSegments ();

    inline void set_has_speed ();

    inline void clear_has_speed ();

    uint32 _has_bits_[ (7 + 31) / 32];

    TripReplayStatus _status;

    bool _loopModeActive;

    ::std::string _tripFileName;

    uint8 _progress;

    uint8 _syncSegment;

    uint8 _countSyncSegments;

    uint8 _speed;

};

/**
 * If the meaning of "JamAheadListElement" isn't clear, then there should be a description here.
 */
class JamAheadListElement {
public:

    /**
     * Default constructor
     */
    inline  JamAheadListElement ();

    /**
     * Copy constructor
     */
    inline  JamAheadListElement (const JamAheadListElement &rhs);

    /**
     * All fields constructor
     */
    inline  JamAheadListElement (const ::std::string& distance_, const ::std::string& distanceWithoutUnit_, DistanceUnit distanceUnit_, bool isEnabled_);

    /**
     * Destructor
     */
    inline  ~JamAheadListElement();

    /**
     * Assignment operator
     */
    inline JamAheadListElement& operator = (const JamAheadListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JamAheadListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JamAheadListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JamAheadListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JamAheadListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "distance"

    static const int kDistance = 0;

    /**
     * Clears the field "distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "distance".
     *
     * If the meaning of "distance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distance"
     */
    inline const ::std::string& getDistance () const;

    /**
     * Retrieves the value of the field "distance" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distance".
     */
    inline ::std::string& getDistanceMutable ();

    /**
     * Sets the value of the member "distance".
     *
     * If the meaning of "distance" isn't clear, then there should be a description here.
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const ::std::string& distance_);

    /**
     * Sets the value of the member "distance".
     *
     * If the meaning of "distance" isn't clear, then there should be a description here.
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* distance_);

    /**
     * Sets the value of the member "distance".
     *
     * If the meaning of "distance" isn't clear, then there should be a description here.
     *
     * @param distance The value which will be set
     */
    inline void setDistance (const char* value, size_t size);

    // API of field "distanceWithoutUnit"

    static const int kDistanceWithoutUnit = 1;

    /**
     * Clears the field "distanceWithoutUnit".
     *
     * The field will be set to its default value. The hasDistanceWithoutUnit()
     * method will return false.
     */
    inline void clearDistanceWithoutUnit();

    /**
     * Checks whether the field "distanceWithoutUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceWithoutUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceWithoutUnit () const;

    /**
     * Returns the value of the member "distanceWithoutUnit".
     *
     * If the meaning of "distanceWithoutUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceWithoutUnit"
     */
    inline const ::std::string& getDistanceWithoutUnit () const;

    /**
     * Retrieves the value of the field "distanceWithoutUnit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distanceWithoutUnit".
     */
    inline ::std::string& getDistanceWithoutUnitMutable ();

    /**
     * Sets the value of the member "distanceWithoutUnit".
     *
     * If the meaning of "distanceWithoutUnit" isn't clear, then there should be a description here.
     *
     * @param distanceWithoutUnit The value which will be set
     */
    inline void setDistanceWithoutUnit (const ::std::string& distanceWithoutUnit_);

    /**
     * Sets the value of the member "distanceWithoutUnit".
     *
     * If the meaning of "distanceWithoutUnit" isn't clear, then there should be a description here.
     *
     * @param distanceWithoutUnit The value which will be set
     */
    inline void setDistanceWithoutUnit (const char* distanceWithoutUnit_);

    /**
     * Sets the value of the member "distanceWithoutUnit".
     *
     * If the meaning of "distanceWithoutUnit" isn't clear, then there should be a description here.
     *
     * @param distanceWithoutUnit The value which will be set
     */
    inline void setDistanceWithoutUnit (const char* value, size_t size);

    // API of field "distanceUnit"

    static const int kDistanceUnit = 2;

    /**
     * Clears the field "distanceUnit".
     *
     * The field will be set to its default value. The hasDistanceUnit()
     * method will return false.
     */
    inline void clearDistanceUnit();

    /**
     * Checks whether the field "distanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceUnit()). Otherwise it will return false.
     */
    inline bool hasDistanceUnit () const;

    /**
     * Returns the value of the member "distanceUnit".
     *
     * If the meaning of "distanceUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "distanceUnit"
     */
    inline DistanceUnit getDistanceUnit () const;

    /**
     * Sets the value of the member "distanceUnit".
     *
     * If the meaning of "distanceUnit" isn't clear, then there should be a description here.
     *
     * @param distanceUnit The value which will be set
     */
    inline void setDistanceUnit (DistanceUnit distanceUnit_);

    // API of field "isEnabled"

    static const int kIsEnabled = 3;

    /**
     * Clears the field "isEnabled".
     *
     * The field will be set to its default value. The hasIsEnabled()
     * method will return false.
     */
    inline void clearIsEnabled();

    /**
     * Checks whether the field "isEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsEnabled()). Otherwise it will return false.
     */
    inline bool hasIsEnabled () const;

    /**
     * Returns the value of the member "isEnabled".
     *
     * If the meaning of "isEnabled" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isEnabled"
     */
    inline bool getIsEnabled () const;

    /**
     * Sets the value of the member "isEnabled".
     *
     * If the meaning of "isEnabled" isn't clear, then there should be a description here.
     *
     * @param isEnabled The value which will be set
     */
    inline void setIsEnabled (bool isEnabled_);

    static const JamAheadListElement &getDefaultInstance();

private:

    inline void set_has_distance ();

    inline void clear_has_distance ();

    inline void set_has_distanceWithoutUnit ();

    inline void clear_has_distanceWithoutUnit ();

    inline void set_has_distanceUnit ();

    inline void clear_has_distanceUnit ();

    inline void set_has_isEnabled ();

    inline void clear_has_isEnabled ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _distance;

    ::std::string _distanceWithoutUnit;

    DistanceUnit _distanceUnit;

    bool _isEnabled;

};

/**
 * If the meaning of "JamAheadList" isn't clear, then there should be a description here.
 */
class JamAheadList {
public:

    /**
     * Default constructor
     */
    inline  JamAheadList ();

    /**
     * Copy constructor
     */
    inline  JamAheadList (const JamAheadList &rhs);

    /**
     * All fields constructor
     */
    inline  JamAheadList (JamAheadActivityStatus jamAheadActivityStatus_, const ::std::vector< JamAheadListElement >& jamAheadListElements_);

    /**
     * Destructor
     */
    inline  ~JamAheadList();

    /**
     * Assignment operator
     */
    inline JamAheadList& operator = (const JamAheadList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const JamAheadList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const JamAheadList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const JamAheadList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const JamAheadList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jamAheadActivityStatus"

    static const int kJamAheadActivityStatus = 0;

    /**
     * Clears the field "jamAheadActivityStatus".
     *
     * The field will be set to its default value. The hasJamAheadActivityStatus()
     * method will return false.
     */
    inline void clearJamAheadActivityStatus();

    /**
     * Checks whether the field "jamAheadActivityStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJamAheadActivityStatus()). Otherwise it will return false.
     */
    inline bool hasJamAheadActivityStatus () const;

    /**
     * Returns the value of the member "jamAheadActivityStatus".
     *
     * If the meaning of "jamAheadActivityStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jamAheadActivityStatus"
     */
    inline JamAheadActivityStatus getJamAheadActivityStatus () const;

    /**
     * Sets the value of the member "jamAheadActivityStatus".
     *
     * If the meaning of "jamAheadActivityStatus" isn't clear, then there should be a description here.
     *
     * @param jamAheadActivityStatus The value which will be set
     */
    inline void setJamAheadActivityStatus (JamAheadActivityStatus jamAheadActivityStatus_);

    // API of field "jamAheadListElements"

    static const int kJamAheadListElements = 1;

    /**
     * Clears the field "jamAheadListElements".
     *
     * The field will be set to its default value. The hasJamAheadListElements()
     * method will return false.
     */
    inline void clearJamAheadListElements();

    /**
     * Checks whether the field "jamAheadListElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJamAheadListElements()). Otherwise it will return false.
     */
    inline bool hasJamAheadListElements () const;

    /**
     * Returns the value of the member "jamAheadListElements".
     *
     * If the meaning of "jamAheadListElements" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jamAheadListElements"
     */
    inline const ::std::vector< JamAheadListElement >& getJamAheadListElements () const;

    /**
     * Retrieves the value of the field "jamAheadListElements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jamAheadListElements".
     */
    inline ::std::vector< JamAheadListElement >& getJamAheadListElementsMutable ();

    /**
     * Sets the value of the member "jamAheadListElements".
     *
     * If the meaning of "jamAheadListElements" isn't clear, then there should be a description here.
     *
     * @param jamAheadListElements The value which will be set
     */
    inline void setJamAheadListElements (const ::std::vector< JamAheadListElement >& jamAheadListElements_);

    static const JamAheadList &getDefaultInstance();

private:

    static const ::std::vector< JamAheadListElement >& getJamAheadListElementList_DefaultInstance ();

    inline void set_has_jamAheadActivityStatus ();

    inline void clear_has_jamAheadActivityStatus ();

    inline void set_has_jamAheadListElements ();

    inline void clear_has_jamAheadListElements ();

    uint32 _has_bits_[ (2 + 31) / 32];

    JamAheadActivityStatus _jamAheadActivityStatus;

    ::std::vector< JamAheadListElement > _jamAheadListElements;

};

/**
 * If the meaning of "MapCameraData" isn't clear, then there should be a description here.
 */
class MapCameraData {
public:

    /**
     * Default constructor
     */
    inline  MapCameraData ();

    /**
     * Copy constructor
     */
    inline  MapCameraData (const MapCameraData &rhs);

    /**
     * All fields constructor
     */
    inline  MapCameraData (uint16 scaleBarWidth_, const ::std::string& mapScale_, float cameraHeading_);

    /**
     * Destructor
     */
    inline  ~MapCameraData();

    /**
     * Assignment operator
     */
    inline MapCameraData& operator = (const MapCameraData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapCameraData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapCameraData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapCameraData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapCameraData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "scaleBarWidth"

    static const int kScaleBarWidth = 0;

    /**
     * Clears the field "scaleBarWidth".
     *
     * The field will be set to its default value. The hasScaleBarWidth()
     * method will return false.
     */
    inline void clearScaleBarWidth();

    /**
     * Checks whether the field "scaleBarWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScaleBarWidth()). Otherwise it will return false.
     */
    inline bool hasScaleBarWidth () const;

    /**
     * Returns the value of the member "scaleBarWidth".
     *
     * String scaleBarWidth represents the width of the zoom bar in pixels
     *
     * @return The value of the field "scaleBarWidth"
     */
    inline uint16 getScaleBarWidth () const;

    /**
     * Sets the value of the member "scaleBarWidth".
     *
     * String scaleBarWidth represents the width of the zoom bar in pixels
     *
     * @param scaleBarWidth The value which will be set
     */
    inline void setScaleBarWidth (uint16 scaleBarWidth_);

    // API of field "mapScale"

    static const int kMapScale = 1;

    /**
     * Clears the field "mapScale".
     *
     * The field will be set to its default value. The hasMapScale()
     * method will return false.
     */
    inline void clearMapScale();

    /**
     * Checks whether the field "mapScale" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapScale()). Otherwise it will return false.
     */
    inline bool hasMapScale () const;

    /**
     * Returns the value of the member "mapScale".
     *
     * String mapScale represents the zoom level where the unit is included as a part of the string
     *
     * @return The value of the field "mapScale"
     */
    inline const ::std::string& getMapScale () const;

    /**
     * Retrieves the value of the field "mapScale" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mapScale".
     */
    inline ::std::string& getMapScaleMutable ();

    /**
     * Sets the value of the member "mapScale".
     *
     * String mapScale represents the zoom level where the unit is included as a part of the string
     *
     * @param mapScale The value which will be set
     */
    inline void setMapScale (const ::std::string& mapScale_);

    /**
     * Sets the value of the member "mapScale".
     *
     * String mapScale represents the zoom level where the unit is included as a part of the string
     *
     * @param mapScale The value which will be set
     */
    inline void setMapScale (const char* mapScale_);

    /**
     * Sets the value of the member "mapScale".
     *
     * String mapScale represents the zoom level where the unit is included as a part of the string
     *
     * @param mapScale The value which will be set
     */
    inline void setMapScale (const char* value, size_t size);

    // API of field "cameraHeading"

    static const int kCameraHeading = 2;

    /**
     * Clears the field "cameraHeading".
     *
     * The field will be set to its default value. The hasCameraHeading()
     * method will return false.
     */
    inline void clearCameraHeading();

    /**
     * Checks whether the field "cameraHeading" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCameraHeading()). Otherwise it will return false.
     */
    inline bool hasCameraHeading () const;

    /**
     * Returns the value of the member "cameraHeading".
     *
     * Float cameraHeading represents the angle for the compass measured as North-up, clockwise
     *
     * @return The value of the field "cameraHeading"
     */
    inline float getCameraHeading () const;

    /**
     * Sets the value of the member "cameraHeading".
     *
     * Float cameraHeading represents the angle for the compass measured as North-up, clockwise
     *
     * @param cameraHeading The value which will be set
     */
    inline void setCameraHeading (float cameraHeading_);

    static const MapCameraData &getDefaultInstance();

private:

    inline void set_has_scaleBarWidth ();

    inline void clear_has_scaleBarWidth ();

    inline void set_has_mapScale ();

    inline void clear_has_mapScale ();

    inline void set_has_cameraHeading ();

    inline void clear_has_cameraHeading ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _scaleBarWidth;

    ::std::string _mapScale;

    float _cameraHeading;

};

/**
 * Request to show the nearby POI category
 */
class SelectPoiCategoryShortcutRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectPoiCategoryShortcutRequest ();

    /**
     * Copy constructor
     */
    inline  SelectPoiCategoryShortcutRequest (const SelectPoiCategoryShortcutRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectPoiCategoryShortcutRequest (uint8 shortcutIndex_);

    /**
     * Destructor
     */
    inline virtual  ~SelectPoiCategoryShortcutRequest();

    /**
     * Assignment operator
     */
    inline SelectPoiCategoryShortcutRequest& operator = (const SelectPoiCategoryShortcutRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectPoiCategoryShortcutRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectPoiCategoryShortcutRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectPoiCategoryShortcutRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectPoiCategoryShortcutRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "shortcutIndex"

    static const int kShortcutIndex = 0;

    /**
     * Clears the field "shortcutIndex".
     *
     * The field will be set to its default value. The hasShortcutIndex()
     * method will return false.
     */
    inline void clearShortcutIndex();

    /**
     * Checks whether the field "shortcutIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShortcutIndex()). Otherwise it will return false.
     */
    inline bool hasShortcutIndex () const;

    /**
     * Returns the value of the member "shortcutIndex".
     *
     * If the meaning of "shortcutIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "shortcutIndex"
     */
    inline uint8 getShortcutIndex () const;

    /**
     * Sets the value of the member "shortcutIndex".
     *
     * If the meaning of "shortcutIndex" isn't clear, then there should be a description here.
     *
     * @param shortcutIndex The value which will be set
     */
    inline void setShortcutIndex (uint8 shortcutIndex_);

    static const SelectPoiCategoryShortcutRequest &getDefaultInstance();

private:

    inline void set_has_shortcutIndex ();

    inline void clear_has_shortcutIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _shortcutIndex;

};

/**
 * Returns the customized preferred category shortcuts
 */
class GetPoiCategoryShortcutsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPoiCategoryShortcutsResponse ();

    /**
     * Copy constructor
     */
    inline  GetPoiCategoryShortcutsResponse (const GetPoiCategoryShortcutsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPoiCategoryShortcutsResponse (const ::std::vector< PoiCategoryShortcut >& poiCategoryShortcuts_);

    /**
     * Destructor
     */
    inline virtual  ~GetPoiCategoryShortcutsResponse();

    /**
     * Assignment operator
     */
    inline GetPoiCategoryShortcutsResponse& operator = (const GetPoiCategoryShortcutsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPoiCategoryShortcutsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPoiCategoryShortcutsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPoiCategoryShortcutsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPoiCategoryShortcutsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "poiCategoryShortcuts"

    static const int kPoiCategoryShortcuts = 0;

    /**
     * Clears the field "poiCategoryShortcuts".
     *
     * The field will be set to its default value. The hasPoiCategoryShortcuts()
     * method will return false.
     */
    inline void clearPoiCategoryShortcuts();

    /**
     * Checks whether the field "poiCategoryShortcuts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiCategoryShortcuts()). Otherwise it will return false.
     */
    inline bool hasPoiCategoryShortcuts () const;

    /**
     * Returns the value of the member "poiCategoryShortcuts".
     *
     * If the meaning of "poiCategoryShortcuts" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiCategoryShortcuts"
     */
    inline const ::std::vector< PoiCategoryShortcut >& getPoiCategoryShortcuts () const;

    /**
     * Retrieves the value of the field "poiCategoryShortcuts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiCategoryShortcuts".
     */
    inline ::std::vector< PoiCategoryShortcut >& getPoiCategoryShortcutsMutable ();

    /**
     * Sets the value of the member "poiCategoryShortcuts".
     *
     * If the meaning of "poiCategoryShortcuts" isn't clear, then there should be a description here.
     *
     * @param poiCategoryShortcuts The value which will be set
     */
    inline void setPoiCategoryShortcuts (const ::std::vector< PoiCategoryShortcut >& poiCategoryShortcuts_);

    static const GetPoiCategoryShortcutsResponse &getDefaultInstance();

private:

    static const ::std::vector< PoiCategoryShortcut >& getPoiCategoryShortcutList_DefaultInstance ();

    inline void set_has_poiCategoryShortcuts ();

    inline void clear_has_poiCategoryShortcuts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< PoiCategoryShortcut > _poiCategoryShortcuts;

};

/**
 * Request to set the latitude and longitude value
 */
class SetLocationWithCoordinatesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocationWithCoordinatesRequest ();

    /**
     * Copy constructor
     */
    inline  SetLocationWithCoordinatesRequest (const SetLocationWithCoordinatesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocationWithCoordinatesRequest (const PositionWGS84& location_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocationWithCoordinatesRequest();

    /**
     * Assignment operator
     */
    inline SetLocationWithCoordinatesRequest& operator = (const SetLocationWithCoordinatesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocationWithCoordinatesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocationWithCoordinatesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocationWithCoordinatesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocationWithCoordinatesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const PositionWGS84& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline PositionWGS84& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const PositionWGS84& location_);

    static const SetLocationWithCoordinatesRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionWGS84 _location;

};

/**
 * Request to set the latitude and longitude value and location details for further processing
 */
class SetLocationWithDetailsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocationWithDetailsRequest ();

    /**
     * Copy constructor
     */
    inline  SetLocationWithDetailsRequest (const SetLocationWithDetailsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocationWithDetailsRequest (const POILocation& location_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocationWithDetailsRequest();

    /**
     * Assignment operator
     */
    inline SetLocationWithDetailsRequest& operator = (const SetLocationWithDetailsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocationWithDetailsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocationWithDetailsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocationWithDetailsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocationWithDetailsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const POILocation& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline POILocation& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const POILocation& location_);

    static const SetLocationWithDetailsRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    POILocation _location;

};

/**
 * Request will provide the "Show POI location" from TCU
 */
class ShowPOILocationFromTCURequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowPOILocationFromTCURequest ();

    /**
     * Copy constructor
     */
    inline  ShowPOILocationFromTCURequest (const ShowPOILocationFromTCURequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowPOILocationFromTCURequest (const ::std::vector< POILocation >& poiLocations_);

    /**
     * Destructor
     */
    inline virtual  ~ShowPOILocationFromTCURequest();

    /**
     * Assignment operator
     */
    inline ShowPOILocationFromTCURequest& operator = (const ShowPOILocationFromTCURequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowPOILocationFromTCURequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowPOILocationFromTCURequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowPOILocationFromTCURequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowPOILocationFromTCURequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "poiLocations"

    static const int kPoiLocations = 0;

    /**
     * Clears the field "poiLocations".
     *
     * The field will be set to its default value. The hasPoiLocations()
     * method will return false.
     */
    inline void clearPoiLocations();

    /**
     * Checks whether the field "poiLocations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiLocations()). Otherwise it will return false.
     */
    inline bool hasPoiLocations () const;

    /**
     * Returns the value of the member "poiLocations".
     *
     * If the meaning of "poiLocations" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiLocations"
     */
    inline const ::std::vector< POILocation >& getPoiLocations () const;

    /**
     * Retrieves the value of the field "poiLocations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiLocations".
     */
    inline ::std::vector< POILocation >& getPoiLocationsMutable ();

    /**
     * Sets the value of the member "poiLocations".
     *
     * If the meaning of "poiLocations" isn't clear, then there should be a description here.
     *
     * @param poiLocations The value which will be set
     */
    inline void setPoiLocations (const ::std::vector< POILocation >& poiLocations_);

    static const ShowPOILocationFromTCURequest &getDefaultInstance();

private:

    static const ::std::vector< POILocation >& getPOILocationList_DefaultInstance ();

    inline void set_has_poiLocations ();

    inline void clear_has_poiLocations ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< POILocation > _poiLocations;

};

/**
 * Request to store POI location to navigation address book
 */
class StorePOILocationToAddressBookRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StorePOILocationToAddressBookRequest ();

    /**
     * Copy constructor
     */
    inline  StorePOILocationToAddressBookRequest (const StorePOILocationToAddressBookRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StorePOILocationToAddressBookRequest (const POILocation& poiLocation_);

    /**
     * Destructor
     */
    inline virtual  ~StorePOILocationToAddressBookRequest();

    /**
     * Assignment operator
     */
    inline StorePOILocationToAddressBookRequest& operator = (const StorePOILocationToAddressBookRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StorePOILocationToAddressBookRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StorePOILocationToAddressBookRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StorePOILocationToAddressBookRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StorePOILocationToAddressBookRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "poiLocation"

    static const int kPoiLocation = 0;

    /**
     * Clears the field "poiLocation".
     *
     * The field will be set to its default value. The hasPoiLocation()
     * method will return false.
     */
    inline void clearPoiLocation();

    /**
     * Checks whether the field "poiLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPoiLocation()). Otherwise it will return false.
     */
    inline bool hasPoiLocation () const;

    /**
     * Returns the value of the member "poiLocation".
     *
     * If the meaning of "poiLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "poiLocation"
     */
    inline const POILocation& getPoiLocation () const;

    /**
     * Retrieves the value of the field "poiLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "poiLocation".
     */
    inline POILocation& getPoiLocationMutable ();

    /**
     * Sets the value of the member "poiLocation".
     *
     * If the meaning of "poiLocation" isn't clear, then there should be a description here.
     *
     * @param poiLocation The value which will be set
     */
    inline void setPoiLocation (const POILocation& poiLocation_);

    static const StorePOILocationToAddressBookRequest &getDefaultInstance();

private:

    inline void set_has_poiLocation ();

    inline void clear_has_poiLocation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    POILocation _poiLocation;

};

/**
 * Request to store location to navigation address book
 */
class StoreLocationToAddressBookRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreLocationToAddressBookRequest ();

    /**
     * Copy constructor
     */
    inline  StoreLocationToAddressBookRequest (const StoreLocationToAddressBookRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StoreLocationToAddressBookRequest (const Location& location_);

    /**
     * Destructor
     */
    inline virtual  ~StoreLocationToAddressBookRequest();

    /**
     * Assignment operator
     */
    inline StoreLocationToAddressBookRequest& operator = (const StoreLocationToAddressBookRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreLocationToAddressBookRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreLocationToAddressBookRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreLocationToAddressBookRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreLocationToAddressBookRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const Location& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline Location& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const Location& location_);

    static const StoreLocationToAddressBookRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Location _location;

};

/**
 * Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.
 */
class ShowDestinationOverviewFromTCURequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowDestinationOverviewFromTCURequest ();

    /**
     * Copy constructor
     */
    inline  ShowDestinationOverviewFromTCURequest (const ShowDestinationOverviewFromTCURequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowDestinationOverviewFromTCURequest (const Location& currentPosition_, const Location& destination_);

    /**
     * Destructor
     */
    inline virtual  ~ShowDestinationOverviewFromTCURequest();

    /**
     * Assignment operator
     */
    inline ShowDestinationOverviewFromTCURequest& operator = (const ShowDestinationOverviewFromTCURequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowDestinationOverviewFromTCURequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowDestinationOverviewFromTCURequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowDestinationOverviewFromTCURequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowDestinationOverviewFromTCURequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "currentPosition"

    static const int kCurrentPosition = 0;

    /**
     * Clears the field "currentPosition".
     *
     * The field will be set to its default value. The hasCurrentPosition()
     * method will return false.
     */
    inline void clearCurrentPosition();

    /**
     * Checks whether the field "currentPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentPosition()). Otherwise it will return false.
     */
    inline bool hasCurrentPosition () const;

    /**
     * Returns the value of the member "currentPosition".
     *
     * If the meaning of "currentPosition" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentPosition"
     */
    inline const Location& getCurrentPosition () const;

    /**
     * Retrieves the value of the field "currentPosition" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentPosition".
     */
    inline Location& getCurrentPositionMutable ();

    /**
     * Sets the value of the member "currentPosition".
     *
     * If the meaning of "currentPosition" isn't clear, then there should be a description here.
     *
     * @param currentPosition The value which will be set
     */
    inline void setCurrentPosition (const Location& currentPosition_);

    // API of field "destination"

    static const int kDestination = 1;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const Location& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline Location& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const Location& destination_);

    static const ShowDestinationOverviewFromTCURequest &getDefaultInstance();

private:

    inline void set_has_currentPosition ();

    inline void clear_has_currentPosition ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    uint32 _has_bits_[ (2 + 31) / 32];

    Location _currentPosition;

    Location _destination;

};

/**
 * Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion
 */
class ShowCalculateTourRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowCalculateTourRequest ();

    /**
     * Copy constructor
     */
    inline  ShowCalculateTourRequest (const ShowCalculateTourRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowCalculateTourRequest (const ::std::vector< TourElement >& tour_, ScreenTransition screenTransition_);

    /**
     * Destructor
     */
    inline virtual  ~ShowCalculateTourRequest();

    /**
     * Assignment operator
     */
    inline ShowCalculateTourRequest& operator = (const ShowCalculateTourRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowCalculateTourRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowCalculateTourRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowCalculateTourRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowCalculateTourRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tour"

    static const int kTour = 0;

    /**
     * Clears the field "tour".
     *
     * The field will be set to its default value. The hasTour()
     * method will return false.
     */
    inline void clearTour();

    /**
     * Checks whether the field "tour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTour()). Otherwise it will return false.
     */
    inline bool hasTour () const;

    /**
     * Returns the value of the member "tour".
     *
     * If the meaning of "tour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tour"
     */
    inline const ::std::vector< TourElement >& getTour () const;

    /**
     * Retrieves the value of the field "tour" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tour".
     */
    inline ::std::vector< TourElement >& getTourMutable ();

    /**
     * Sets the value of the member "tour".
     *
     * If the meaning of "tour" isn't clear, then there should be a description here.
     *
     * @param tour The value which will be set
     */
    inline void setTour (const ::std::vector< TourElement >& tour_);

    // API of field "screenTransition"

    static const int kScreenTransition = 1;

    /**
     * Clears the field "screenTransition".
     *
     * The field will be set to its default value. The hasScreenTransition()
     * method will return false.
     */
    inline void clearScreenTransition();

    /**
     * Checks whether the field "screenTransition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenTransition()). Otherwise it will return false.
     */
    inline bool hasScreenTransition () const;

    /**
     * Returns the value of the member "screenTransition".
     *
     * switches the screen to different screens based on enum value
     *
     * @return The value of the field "screenTransition"
     */
    inline ScreenTransition getScreenTransition () const;

    /**
     * Sets the value of the member "screenTransition".
     *
     * switches the screen to different screens based on enum value
     *
     * @param screenTransition The value which will be set
     */
    inline void setScreenTransition (ScreenTransition screenTransition_);

    static const ShowCalculateTourRequest &getDefaultInstance();

private:

    static const ::std::vector< TourElement >& getTourElementList_DefaultInstance ();

    inline void set_has_tour ();

    inline void clear_has_tour ();

    inline void set_has_screenTransition ();

    inline void clear_has_screenTransition ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< TourElement > _tour;

    ScreenTransition _screenTransition;

};

/**
 * Request shows the given location on map
 */
class ShowOnMapRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowOnMapRequest ();

    /**
     * Copy constructor
     */
    inline  ShowOnMapRequest (const ShowOnMapRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowOnMapRequest (const PositionWGS84& location_);

    /**
     * Destructor
     */
    inline virtual  ~ShowOnMapRequest();

    /**
     * Assignment operator
     */
    inline ShowOnMapRequest& operator = (const ShowOnMapRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowOnMapRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowOnMapRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowOnMapRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowOnMapRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const PositionWGS84& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline PositionWGS84& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const PositionWGS84& location_);

    static const ShowOnMapRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionWGS84 _location;

};

/**
 * Request will respond with City center coordinates
 */
class ShowCityInputAndGetCityCoordinatesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowCityInputAndGetCityCoordinatesResponse ();

    /**
     * Copy constructor
     */
    inline  ShowCityInputAndGetCityCoordinatesResponse (const ShowCityInputAndGetCityCoordinatesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ShowCityInputAndGetCityCoordinatesResponse (const PositionWGS84& cityCenterCoordinate_, bool isValidAddress_);

    /**
     * Destructor
     */
    inline virtual  ~ShowCityInputAndGetCityCoordinatesResponse();

    /**
     * Assignment operator
     */
    inline ShowCityInputAndGetCityCoordinatesResponse& operator = (const ShowCityInputAndGetCityCoordinatesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowCityInputAndGetCityCoordinatesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowCityInputAndGetCityCoordinatesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowCityInputAndGetCityCoordinatesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowCityInputAndGetCityCoordinatesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cityCenterCoordinate"

    static const int kCityCenterCoordinate = 0;

    /**
     * Clears the field "cityCenterCoordinate".
     *
     * The field will be set to its default value. The hasCityCenterCoordinate()
     * method will return false.
     */
    inline void clearCityCenterCoordinate();

    /**
     * Checks whether the field "cityCenterCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityCenterCoordinate()). Otherwise it will return false.
     */
    inline bool hasCityCenterCoordinate () const;

    /**
     * Returns the value of the member "cityCenterCoordinate".
     *
     * If the meaning of "cityCenterCoordinate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityCenterCoordinate"
     */
    inline const PositionWGS84& getCityCenterCoordinate () const;

    /**
     * Retrieves the value of the field "cityCenterCoordinate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityCenterCoordinate".
     */
    inline PositionWGS84& getCityCenterCoordinateMutable ();

    /**
     * Sets the value of the member "cityCenterCoordinate".
     *
     * If the meaning of "cityCenterCoordinate" isn't clear, then there should be a description here.
     *
     * @param cityCenterCoordinate The value which will be set
     */
    inline void setCityCenterCoordinate (const PositionWGS84& cityCenterCoordinate_);

    // API of field "isValidAddress"

    static const int kIsValidAddress = 1;

    /**
     * Clears the field "isValidAddress".
     *
     * The field will be set to its default value. The hasIsValidAddress()
     * method will return false.
     */
    inline void clearIsValidAddress();

    /**
     * Checks whether the field "isValidAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsValidAddress()). Otherwise it will return false.
     */
    inline bool hasIsValidAddress () const;

    /**
     * Returns the value of the member "isValidAddress".
     *
     * If the meaning of "isValidAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isValidAddress"
     */
    inline bool getIsValidAddress () const;

    /**
     * Sets the value of the member "isValidAddress".
     *
     * If the meaning of "isValidAddress" isn't clear, then there should be a description here.
     *
     * @param isValidAddress The value which will be set
     */
    inline void setIsValidAddress (bool isValidAddress_);

    static const ShowCityInputAndGetCityCoordinatesResponse &getDefaultInstance();

private:

    inline void set_has_cityCenterCoordinate ();

    inline void clear_has_cityCenterCoordinate ();

    inline void set_has_isValidAddress ();

    inline void clear_has_isValidAddress ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PositionWGS84 _cityCenterCoordinate;

    bool _isValidAddress;

};

/**
 * Request will respond with location details belonging to given lat/long coordinates
 */
class RequestLocationDetailsForCoordinatesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestLocationDetailsForCoordinatesRequest ();

    /**
     * Copy constructor
     */
    inline  RequestLocationDetailsForCoordinatesRequest (const RequestLocationDetailsForCoordinatesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestLocationDetailsForCoordinatesRequest (const PositionWGS84& cityCoordinate_);

    /**
     * Destructor
     */
    inline virtual  ~RequestLocationDetailsForCoordinatesRequest();

    /**
     * Assignment operator
     */
    inline RequestLocationDetailsForCoordinatesRequest& operator = (const RequestLocationDetailsForCoordinatesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestLocationDetailsForCoordinatesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestLocationDetailsForCoordinatesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestLocationDetailsForCoordinatesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestLocationDetailsForCoordinatesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cityCoordinate"

    static const int kCityCoordinate = 0;

    /**
     * Clears the field "cityCoordinate".
     *
     * The field will be set to its default value. The hasCityCoordinate()
     * method will return false.
     */
    inline void clearCityCoordinate();

    /**
     * Checks whether the field "cityCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCityCoordinate()). Otherwise it will return false.
     */
    inline bool hasCityCoordinate () const;

    /**
     * Returns the value of the member "cityCoordinate".
     *
     * If the meaning of "cityCoordinate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cityCoordinate"
     */
    inline const PositionWGS84& getCityCoordinate () const;

    /**
     * Retrieves the value of the field "cityCoordinate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cityCoordinate".
     */
    inline PositionWGS84& getCityCoordinateMutable ();

    /**
     * Sets the value of the member "cityCoordinate".
     *
     * If the meaning of "cityCoordinate" isn't clear, then there should be a description here.
     *
     * @param cityCoordinate The value which will be set
     */
    inline void setCityCoordinate (const PositionWGS84& cityCoordinate_);

    static const RequestLocationDetailsForCoordinatesRequest &getDefaultInstance();

private:

    inline void set_has_cityCoordinate ();

    inline void clear_has_cityCoordinate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionWGS84 _cityCoordinate;

};

/**
 * Request will respond with location details belonging to given lat/long coordinates
 */
class RequestLocationDetailsForCoordinatesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestLocationDetailsForCoordinatesResponse ();

    /**
     * Copy constructor
     */
    inline  RequestLocationDetailsForCoordinatesResponse (const RequestLocationDetailsForCoordinatesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestLocationDetailsForCoordinatesResponse (const LocationDetails& locationDetails_);

    /**
     * Destructor
     */
    inline virtual  ~RequestLocationDetailsForCoordinatesResponse();

    /**
     * Assignment operator
     */
    inline RequestLocationDetailsForCoordinatesResponse& operator = (const RequestLocationDetailsForCoordinatesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestLocationDetailsForCoordinatesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestLocationDetailsForCoordinatesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestLocationDetailsForCoordinatesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestLocationDetailsForCoordinatesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationDetails"

    static const int kLocationDetails = 0;

    /**
     * Clears the field "locationDetails".
     *
     * The field will be set to its default value. The hasLocationDetails()
     * method will return false.
     */
    inline void clearLocationDetails();

    /**
     * Checks whether the field "locationDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationDetails()). Otherwise it will return false.
     */
    inline bool hasLocationDetails () const;

    /**
     * Returns the value of the member "locationDetails".
     *
     * If the meaning of "locationDetails" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationDetails"
     */
    inline const LocationDetails& getLocationDetails () const;

    /**
     * Retrieves the value of the field "locationDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "locationDetails".
     */
    inline LocationDetails& getLocationDetailsMutable ();

    /**
     * Sets the value of the member "locationDetails".
     *
     * If the meaning of "locationDetails" isn't clear, then there should be a description here.
     *
     * @param locationDetails The value which will be set
     */
    inline void setLocationDetails (const LocationDetails& locationDetails_);

    static const RequestLocationDetailsForCoordinatesResponse &getDefaultInstance();

private:

    inline void set_has_locationDetails ();

    inline void clear_has_locationDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    LocationDetails _locationDetails;

};

/**
 * Request to show map screen with the given settings for MapViewMode
 */
class ShowMapScreenWithMapViewModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowMapScreenWithMapViewModeRequest ();

    /**
     * Copy constructor
     */
    inline  ShowMapScreenWithMapViewModeRequest (const ShowMapScreenWithMapViewModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowMapScreenWithMapViewModeRequest (MapViewMode MapViewMode_);

    /**
     * Destructor
     */
    inline virtual  ~ShowMapScreenWithMapViewModeRequest();

    /**
     * Assignment operator
     */
    inline ShowMapScreenWithMapViewModeRequest& operator = (const ShowMapScreenWithMapViewModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowMapScreenWithMapViewModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowMapScreenWithMapViewModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowMapScreenWithMapViewModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowMapScreenWithMapViewModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MapViewMode"

    static const int kMapViewMode = 0;

    /**
     * Clears the field "MapViewMode".
     *
     * The field will be set to its default value. The hasMapViewMode()
     * method will return false.
     */
    inline void clearMapViewMode();

    /**
     * Checks whether the field "MapViewMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapViewMode()). Otherwise it will return false.
     */
    inline bool hasMapViewMode () const;

    /**
     * Returns the value of the member "MapViewMode".
     *
     * If the meaning of "MapViewMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MapViewMode"
     */
    inline MapViewMode getMapViewMode () const;

    /**
     * Sets the value of the member "MapViewMode".
     *
     * If the meaning of "MapViewMode" isn't clear, then there should be a description here.
     *
     * @param MapViewMode The value which will be set
     */
    inline void setMapViewMode (MapViewMode MapViewMode_);

    static const ShowMapScreenWithMapViewModeRequest &getDefaultInstance();

private:

    inline void set_has_MapViewMode ();

    inline void clear_has_MapViewMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapViewMode _MapViewMode;

};

/**
 * Request to show map screen with carsor locked mode
 */
class ShowMapScreenCarsorLockModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowMapScreenCarsorLockModeRequest ();

    /**
     * Copy constructor
     */
    inline  ShowMapScreenCarsorLockModeRequest (const ShowMapScreenCarsorLockModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowMapScreenCarsorLockModeRequest (MapCameraMode mapCameraMode_);

    /**
     * Destructor
     */
    inline virtual  ~ShowMapScreenCarsorLockModeRequest();

    /**
     * Assignment operator
     */
    inline ShowMapScreenCarsorLockModeRequest& operator = (const ShowMapScreenCarsorLockModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowMapScreenCarsorLockModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowMapScreenCarsorLockModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowMapScreenCarsorLockModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowMapScreenCarsorLockModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mapCameraMode"

    static const int kMapCameraMode = 0;

    /**
     * Clears the field "mapCameraMode".
     *
     * The field will be set to its default value. The hasMapCameraMode()
     * method will return false.
     */
    inline void clearMapCameraMode();

    /**
     * Checks whether the field "mapCameraMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapCameraMode()). Otherwise it will return false.
     */
    inline bool hasMapCameraMode () const;

    /**
     * Returns the value of the member "mapCameraMode".
     *
     * If the meaning of "mapCameraMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mapCameraMode"
     */
    inline MapCameraMode getMapCameraMode () const;

    /**
     * Sets the value of the member "mapCameraMode".
     *
     * If the meaning of "mapCameraMode" isn't clear, then there should be a description here.
     *
     * @param mapCameraMode The value which will be set
     */
    inline void setMapCameraMode (MapCameraMode mapCameraMode_);

    static const ShowMapScreenCarsorLockModeRequest &getDefaultInstance();

private:

    inline void set_has_mapCameraMode ();

    inline void clear_has_mapCameraMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapCameraMode _mapCameraMode;

};

/**
 * Request to zoom in the given step count
 */
class SetZoomInStepRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetZoomInStepRequest ();

    /**
     * Copy constructor
     */
    inline  SetZoomInStepRequest (const SetZoomInStepRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetZoomInStepRequest (uint8 zoomInStep_);

    /**
     * Destructor
     */
    inline virtual  ~SetZoomInStepRequest();

    /**
     * Assignment operator
     */
    inline SetZoomInStepRequest& operator = (const SetZoomInStepRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetZoomInStepRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetZoomInStepRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetZoomInStepRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetZoomInStepRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "zoomInStep"

    static const int kZoomInStep = 0;

    /**
     * Clears the field "zoomInStep".
     *
     * The field will be set to its default value. The hasZoomInStep()
     * method will return false.
     */
    inline void clearZoomInStep();

    /**
     * Checks whether the field "zoomInStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZoomInStep()). Otherwise it will return false.
     */
    inline bool hasZoomInStep () const;

    /**
     * Returns the value of the member "zoomInStep".
     *
     * If the meaning of "zoomInStep" isn't clear, then there should be a description here.
     *
     * @return The value of the field "zoomInStep"
     */
    inline uint8 getZoomInStep () const;

    /**
     * Sets the value of the member "zoomInStep".
     *
     * If the meaning of "zoomInStep" isn't clear, then there should be a description here.
     *
     * @param zoomInStep The value which will be set
     */
    inline void setZoomInStep (uint8 zoomInStep_);

    static const SetZoomInStepRequest &getDefaultInstance();

private:

    inline void set_has_zoomInStep ();

    inline void clear_has_zoomInStep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _zoomInStep;

};

/**
 * Request to zoom out the given step count
 */
class SetZoomOutStepRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetZoomOutStepRequest ();

    /**
     * Copy constructor
     */
    inline  SetZoomOutStepRequest (const SetZoomOutStepRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetZoomOutStepRequest (uint8 zoomOutStep_);

    /**
     * Destructor
     */
    inline virtual  ~SetZoomOutStepRequest();

    /**
     * Assignment operator
     */
    inline SetZoomOutStepRequest& operator = (const SetZoomOutStepRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetZoomOutStepRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetZoomOutStepRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetZoomOutStepRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetZoomOutStepRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "zoomOutStep"

    static const int kZoomOutStep = 0;

    /**
     * Clears the field "zoomOutStep".
     *
     * The field will be set to its default value. The hasZoomOutStep()
     * method will return false.
     */
    inline void clearZoomOutStep();

    /**
     * Checks whether the field "zoomOutStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZoomOutStep()). Otherwise it will return false.
     */
    inline bool hasZoomOutStep () const;

    /**
     * Returns the value of the member "zoomOutStep".
     *
     * If the meaning of "zoomOutStep" isn't clear, then there should be a description here.
     *
     * @return The value of the field "zoomOutStep"
     */
    inline uint8 getZoomOutStep () const;

    /**
     * Sets the value of the member "zoomOutStep".
     *
     * If the meaning of "zoomOutStep" isn't clear, then there should be a description here.
     *
     * @param zoomOutStep The value which will be set
     */
    inline void setZoomOutStep (uint8 zoomOutStep_);

    static const SetZoomOutStepRequest &getDefaultInstance();

private:

    inline void set_has_zoomOutStep ();

    inline void clear_has_zoomOutStep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _zoomOutStep;

};

/**
 * Request zooms to the given zoom level
 */
class SetZoomLevelRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetZoomLevelRequest ();

    /**
     * Copy constructor
     */
    inline  SetZoomLevelRequest (const SetZoomLevelRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetZoomLevelRequest (ZoomLevel zoomLevel_);

    /**
     * Destructor
     */
    inline virtual  ~SetZoomLevelRequest();

    /**
     * Assignment operator
     */
    inline SetZoomLevelRequest& operator = (const SetZoomLevelRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetZoomLevelRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetZoomLevelRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetZoomLevelRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetZoomLevelRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "zoomLevel"

    static const int kZoomLevel = 0;

    /**
     * Clears the field "zoomLevel".
     *
     * The field will be set to its default value. The hasZoomLevel()
     * method will return false.
     */
    inline void clearZoomLevel();

    /**
     * Checks whether the field "zoomLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZoomLevel()). Otherwise it will return false.
     */
    inline bool hasZoomLevel () const;

    /**
     * Returns the value of the member "zoomLevel".
     *
     * If the meaning of "zoomLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "zoomLevel"
     */
    inline ZoomLevel getZoomLevel () const;

    /**
     * Sets the value of the member "zoomLevel".
     *
     * If the meaning of "zoomLevel" isn't clear, then there should be a description here.
     *
     * @param zoomLevel The value which will be set
     */
    inline void setZoomLevel (ZoomLevel zoomLevel_);

    static const SetZoomLevelRequest &getDefaultInstance();

private:

    inline void set_has_zoomLevel ();

    inline void clear_has_zoomLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ZoomLevel _zoomLevel;

};

/**
 * Request will respond with the current NavMiddleware version string
 */
class GetVersionStringResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVersionStringResponse ();

    /**
     * Copy constructor
     */
    inline  GetVersionStringResponse (const GetVersionStringResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetVersionStringResponse (const ::std::string& versionString_);

    /**
     * Destructor
     */
    inline virtual  ~GetVersionStringResponse();

    /**
     * Assignment operator
     */
    inline GetVersionStringResponse& operator = (const GetVersionStringResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVersionStringResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVersionStringResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVersionStringResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVersionStringResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "versionString"

    static const int kVersionString = 0;

    /**
     * Clears the field "versionString".
     *
     * The field will be set to its default value. The hasVersionString()
     * method will return false.
     */
    inline void clearVersionString();

    /**
     * Checks whether the field "versionString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersionString()). Otherwise it will return false.
     */
    inline bool hasVersionString () const;

    /**
     * Returns the value of the member "versionString".
     *
     * If the meaning of "versionString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "versionString"
     */
    inline const ::std::string& getVersionString () const;

    /**
     * Retrieves the value of the field "versionString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "versionString".
     */
    inline ::std::string& getVersionStringMutable ();

    /**
     * Sets the value of the member "versionString".
     *
     * If the meaning of "versionString" isn't clear, then there should be a description here.
     *
     * @param versionString The value which will be set
     */
    inline void setVersionString (const ::std::string& versionString_);

    /**
     * Sets the value of the member "versionString".
     *
     * If the meaning of "versionString" isn't clear, then there should be a description here.
     *
     * @param versionString The value which will be set
     */
    inline void setVersionString (const char* versionString_);

    /**
     * Sets the value of the member "versionString".
     *
     * If the meaning of "versionString" isn't clear, then there should be a description here.
     *
     * @param versionString The value which will be set
     */
    inline void setVersionString (const char* value, size_t size);

    static const GetVersionStringResponse &getDefaultInstance();

private:

    inline void set_has_versionString ();

    inline void clear_has_versionString ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _versionString;

};

/**
 * Request will set the SXM travel link subscription status
 */
class SetSXMTravelLinkSubscriptionStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSXMTravelLinkSubscriptionStatusRequest ();

    /**
     * Copy constructor
     */
    inline  SetSXMTravelLinkSubscriptionStatusRequest (const SetSXMTravelLinkSubscriptionStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetSXMTravelLinkSubscriptionStatusRequest (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~SetSXMTravelLinkSubscriptionStatusRequest();

    /**
     * Assignment operator
     */
    inline SetSXMTravelLinkSubscriptionStatusRequest& operator = (const SetSXMTravelLinkSubscriptionStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSXMTravelLinkSubscriptionStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSXMTravelLinkSubscriptionStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSXMTravelLinkSubscriptionStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSXMTravelLinkSubscriptionStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const SetSXMTravelLinkSubscriptionStatusRequest &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * Request will start a guidance to the given WGS84 position
 */
class StartGuidanceToPosWGS84Request  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartGuidanceToPosWGS84Request ();

    /**
     * Copy constructor
     */
    inline  StartGuidanceToPosWGS84Request (const StartGuidanceToPosWGS84Request &rhs);

    /**
     * All fields constructor
     */
    inline  StartGuidanceToPosWGS84Request (const PositionWGS84& destination_);

    /**
     * Destructor
     */
    inline virtual  ~StartGuidanceToPosWGS84Request();

    /**
     * Assignment operator
     */
    inline StartGuidanceToPosWGS84Request& operator = (const StartGuidanceToPosWGS84Request& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartGuidanceToPosWGS84Request& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartGuidanceToPosWGS84Request& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartGuidanceToPosWGS84Request& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartGuidanceToPosWGS84Request& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destination"

    static const int kDestination = 0;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const PositionWGS84& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline PositionWGS84& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const PositionWGS84& destination_);

    static const StartGuidanceToPosWGS84Request &getDefaultInstance();

private:

    inline void set_has_destination ();

    inline void clear_has_destination ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionWGS84 _destination;

};

/**
 * Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface
 */
class SetLocationWithDestinationMemoryEntryRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocationWithDestinationMemoryEntryRequest ();

    /**
     * Copy constructor
     */
    inline  SetLocationWithDestinationMemoryEntryRequest (const SetLocationWithDestinationMemoryEntryRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocationWithDestinationMemoryEntryRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocationWithDestinationMemoryEntryRequest();

    /**
     * Assignment operator
     */
    inline SetLocationWithDestinationMemoryEntryRequest& operator = (const SetLocationWithDestinationMemoryEntryRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocationWithDestinationMemoryEntryRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocationWithDestinationMemoryEntryRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocationWithDestinationMemoryEntryRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocationWithDestinationMemoryEntryRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const SetLocationWithDestinationMemoryEntryRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * Inserts current location as new waypoint in current waypoint list.
 *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
 */
class InsertWaypointRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InsertWaypointRequest ();

    /**
     * Copy constructor
     */
    inline  InsertWaypointRequest (const InsertWaypointRequest &rhs);

    /**
     * All fields constructor
     */
    inline  InsertWaypointRequest (uint32 newIndex_);

    /**
     * Destructor
     */
    inline virtual  ~InsertWaypointRequest();

    /**
     * Assignment operator
     */
    inline InsertWaypointRequest& operator = (const InsertWaypointRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InsertWaypointRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InsertWaypointRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InsertWaypointRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InsertWaypointRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "newIndex"

    static const int kNewIndex = 0;

    /**
     * Clears the field "newIndex".
     *
     * The field will be set to its default value. The hasNewIndex()
     * method will return false.
     */
    inline void clearNewIndex();

    /**
     * Checks whether the field "newIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewIndex()). Otherwise it will return false.
     */
    inline bool hasNewIndex () const;

    /**
     * Returns the value of the member "newIndex".
     *
     * If the meaning of "newIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newIndex"
     */
    inline uint32 getNewIndex () const;

    /**
     * Sets the value of the member "newIndex".
     *
     * If the meaning of "newIndex" isn't clear, then there should be a description here.
     *
     * @param newIndex The value which will be set
     */
    inline void setNewIndex (uint32 newIndex_);

    static const InsertWaypointRequest &getDefaultInstance();

private:

    inline void set_has_newIndex ();

    inline void clear_has_newIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _newIndex;

};

/**
 * Uses current location to replace waypoint
 */
class ReplaceWaypointRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReplaceWaypointRequest ();

    /**
     * Copy constructor
     */
    inline  ReplaceWaypointRequest (const ReplaceWaypointRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReplaceWaypointRequest (uint32 index_);

    /**
     * Destructor
     */
    inline virtual  ~ReplaceWaypointRequest();

    /**
     * Assignment operator
     */
    inline ReplaceWaypointRequest& operator = (const ReplaceWaypointRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplaceWaypointRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplaceWaypointRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplaceWaypointRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplaceWaypointRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    static const ReplaceWaypointRequest &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _index;

};

/**
 * Delete the waypoints (including firstIndex and lastIndex)
 */
class DeleteWaypointsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteWaypointsRequest ();

    /**
     * Copy constructor
     */
    inline  DeleteWaypointsRequest (const DeleteWaypointsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteWaypointsRequest (uint32 firstIndex_, uint32 lastIndex_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteWaypointsRequest();

    /**
     * Assignment operator
     */
    inline DeleteWaypointsRequest& operator = (const DeleteWaypointsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteWaypointsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteWaypointsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteWaypointsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteWaypointsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "firstIndex"

    static const int kFirstIndex = 0;

    /**
     * Clears the field "firstIndex".
     *
     * The field will be set to its default value. The hasFirstIndex()
     * method will return false.
     */
    inline void clearFirstIndex();

    /**
     * Checks whether the field "firstIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirstIndex()). Otherwise it will return false.
     */
    inline bool hasFirstIndex () const;

    /**
     * Returns the value of the member "firstIndex".
     *
     * If the meaning of "firstIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "firstIndex"
     */
    inline uint32 getFirstIndex () const;

    /**
     * Sets the value of the member "firstIndex".
     *
     * If the meaning of "firstIndex" isn't clear, then there should be a description here.
     *
     * @param firstIndex The value which will be set
     */
    inline void setFirstIndex (uint32 firstIndex_);

    // API of field "lastIndex"

    static const int kLastIndex = 1;

    /**
     * Clears the field "lastIndex".
     *
     * The field will be set to its default value. The hasLastIndex()
     * method will return false.
     */
    inline void clearLastIndex();

    /**
     * Checks whether the field "lastIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastIndex()). Otherwise it will return false.
     */
    inline bool hasLastIndex () const;

    /**
     * Returns the value of the member "lastIndex".
     *
     * If the meaning of "lastIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "lastIndex"
     */
    inline uint32 getLastIndex () const;

    /**
     * Sets the value of the member "lastIndex".
     *
     * If the meaning of "lastIndex" isn't clear, then there should be a description here.
     *
     * @param lastIndex The value which will be set
     */
    inline void setLastIndex (uint32 lastIndex_);

    static const DeleteWaypointsRequest &getDefaultInstance();

private:

    inline void set_has_firstIndex ();

    inline void clear_has_firstIndex ();

    inline void set_has_lastIndex ();

    inline void clear_has_lastIndex ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _firstIndex;

    uint32 _lastIndex;

};

/**
 * Request for the free text search location type
 */
class RequestSetFreeTextSearchTypeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSetFreeTextSearchTypeRequest ();

    /**
     * Copy constructor
     */
    inline  RequestSetFreeTextSearchTypeRequest (const RequestSetFreeTextSearchTypeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSetFreeTextSearchTypeRequest (FTSLocationType locationType_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSetFreeTextSearchTypeRequest();

    /**
     * Assignment operator
     */
    inline RequestSetFreeTextSearchTypeRequest& operator = (const RequestSetFreeTextSearchTypeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSetFreeTextSearchTypeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSetFreeTextSearchTypeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSetFreeTextSearchTypeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSetFreeTextSearchTypeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationType"

    static const int kLocationType = 0;

    /**
     * Clears the field "locationType".
     *
     * The field will be set to its default value. The hasLocationType()
     * method will return false.
     */
    inline void clearLocationType();

    /**
     * Checks whether the field "locationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationType()). Otherwise it will return false.
     */
    inline bool hasLocationType () const;

    /**
     * Returns the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationType"
     */
    inline FTSLocationType getLocationType () const;

    /**
     * Sets the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @param locationType The value which will be set
     */
    inline void setLocationType (FTSLocationType locationType_);

    static const RequestSetFreeTextSearchTypeRequest &getDefaultInstance();

private:

    inline void set_has_locationType ();

    inline void clear_has_locationType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    FTSLocationType _locationType;

};

/**
 * Requests the specified range of free text search results for the search string and scope
 */
class RequestFreeTextSearchResultsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFreeTextSearchResultsRequest ();

    /**
     * Copy constructor
     */
    inline  RequestFreeTextSearchResultsRequest (const RequestFreeTextSearchResultsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFreeTextSearchResultsRequest (const ::std::string& searchString_, FreeTextSearchScope searchScope_, uint8 destinationIndex_, uint32 startIndex_, uint32 numElements_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFreeTextSearchResultsRequest();

    /**
     * Assignment operator
     */
    inline RequestFreeTextSearchResultsRequest& operator = (const RequestFreeTextSearchResultsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFreeTextSearchResultsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFreeTextSearchResultsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFreeTextSearchResultsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFreeTextSearchResultsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "searchString"

    static const int kSearchString = 0;

    /**
     * Clears the field "searchString".
     *
     * The field will be set to its default value. The hasSearchString()
     * method will return false.
     */
    inline void clearSearchString();

    /**
     * Checks whether the field "searchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchString()). Otherwise it will return false.
     */
    inline bool hasSearchString () const;

    /**
     * Returns the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchString"
     */
    inline const ::std::string& getSearchString () const;

    /**
     * Retrieves the value of the field "searchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchString".
     */
    inline ::std::string& getSearchStringMutable ();

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const ::std::string& searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* value, size_t size);

    // API of field "searchScope"

    static const int kSearchScope = 1;

    /**
     * Clears the field "searchScope".
     *
     * The field will be set to its default value. The hasSearchScope()
     * method will return false.
     */
    inline void clearSearchScope();

    /**
     * Checks whether the field "searchScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchScope()). Otherwise it will return false.
     */
    inline bool hasSearchScope () const;

    /**
     * Returns the value of the member "searchScope".
     *
     * If the meaning of "searchScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchScope"
     */
    inline FreeTextSearchScope getSearchScope () const;

    /**
     * Sets the value of the member "searchScope".
     *
     * If the meaning of "searchScope" isn't clear, then there should be a description here.
     *
     * @param searchScope The value which will be set
     */
    inline void setSearchScope (FreeTextSearchScope searchScope_);

    // API of field "destinationIndex"

    static const int kDestinationIndex = 2;

    /**
     * Clears the field "destinationIndex".
     *
     * The field will be set to its default value. The hasDestinationIndex()
     * method will return false.
     */
    inline void clearDestinationIndex();

    /**
     * Checks whether the field "destinationIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationIndex()). Otherwise it will return false.
     */
    inline bool hasDestinationIndex () const;

    /**
     * Returns the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationIndex"
     */
    inline uint8 getDestinationIndex () const;

    /**
     * Sets the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @param destinationIndex The value which will be set
     */
    inline void setDestinationIndex (uint8 destinationIndex_);

    // API of field "startIndex"

    static const int kStartIndex = 3;

    /**
     * Clears the field "startIndex".
     *
     * The field will be set to its default value. The hasStartIndex()
     * method will return false.
     */
    inline void clearStartIndex();

    /**
     * Checks whether the field "startIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartIndex()). Otherwise it will return false.
     */
    inline bool hasStartIndex () const;

    /**
     * Returns the value of the member "startIndex".
     *
     * If the meaning of "startIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "startIndex"
     */
    inline uint32 getStartIndex () const;

    /**
     * Sets the value of the member "startIndex".
     *
     * If the meaning of "startIndex" isn't clear, then there should be a description here.
     *
     * @param startIndex The value which will be set
     */
    inline void setStartIndex (uint32 startIndex_);

    // API of field "numElements"

    static const int kNumElements = 4;

    /**
     * Clears the field "numElements".
     *
     * The field will be set to its default value. The hasNumElements()
     * method will return false.
     */
    inline void clearNumElements();

    /**
     * Checks whether the field "numElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumElements()). Otherwise it will return false.
     */
    inline bool hasNumElements () const;

    /**
     * Returns the value of the member "numElements".
     *
     * If the meaning of "numElements" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numElements"
     */
    inline uint32 getNumElements () const;

    /**
     * Sets the value of the member "numElements".
     *
     * If the meaning of "numElements" isn't clear, then there should be a description here.
     *
     * @param numElements The value which will be set
     */
    inline void setNumElements (uint32 numElements_);

    static const RequestFreeTextSearchResultsRequest &getDefaultInstance();

private:

    inline void set_has_searchString ();

    inline void clear_has_searchString ();

    inline void set_has_searchScope ();

    inline void clear_has_searchScope ();

    inline void set_has_destinationIndex ();

    inline void clear_has_destinationIndex ();

    inline void set_has_startIndex ();

    inline void clear_has_startIndex ();

    inline void set_has_numElements ();

    inline void clear_has_numElements ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _searchString;

    FreeTextSearchScope _searchScope;

    uint8 _destinationIndex;

    uint32 _startIndex;

    uint32 _numElements;

};

/**
 * Requests the specified range of free text search results for the search string and scope
 */
class RequestFreeTextSearchResultsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFreeTextSearchResultsResponse ();

    /**
     * Copy constructor
     */
    inline  RequestFreeTextSearchResultsResponse (const RequestFreeTextSearchResultsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFreeTextSearchResultsResponse (const ::std::vector< AddressListElement >& searchResults_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFreeTextSearchResultsResponse();

    /**
     * Assignment operator
     */
    inline RequestFreeTextSearchResultsResponse& operator = (const RequestFreeTextSearchResultsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFreeTextSearchResultsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFreeTextSearchResultsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFreeTextSearchResultsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFreeTextSearchResultsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "searchResults"

    static const int kSearchResults = 0;

    /**
     * Clears the field "searchResults".
     *
     * The field will be set to its default value. The hasSearchResults()
     * method will return false.
     */
    inline void clearSearchResults();

    /**
     * Checks whether the field "searchResults" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchResults()). Otherwise it will return false.
     */
    inline bool hasSearchResults () const;

    /**
     * Returns the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchResults"
     */
    inline const ::std::vector< AddressListElement >& getSearchResults () const;

    /**
     * Retrieves the value of the field "searchResults" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchResults".
     */
    inline ::std::vector< AddressListElement >& getSearchResultsMutable ();

    /**
     * Sets the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param searchResults The value which will be set
     */
    inline void setSearchResults (const ::std::vector< AddressListElement >& searchResults_);

    static const RequestFreeTextSearchResultsResponse &getDefaultInstance();

private:

    static const ::std::vector< AddressListElement >& getAddressListElementList_DefaultInstance ();

    inline void set_has_searchResults ();

    inline void clear_has_searchResults ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< AddressListElement > _searchResults;

};

/**
 * Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()
 */
class SetLocationWithFreeTextSearchInputRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocationWithFreeTextSearchInputRequest ();

    /**
     * Copy constructor
     */
    inline  SetLocationWithFreeTextSearchInputRequest (const SetLocationWithFreeTextSearchInputRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocationWithFreeTextSearchInputRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocationWithFreeTextSearchInputRequest();

    /**
     * Assignment operator
     */
    inline SetLocationWithFreeTextSearchInputRequest& operator = (const SetLocationWithFreeTextSearchInputRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocationWithFreeTextSearchInputRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocationWithFreeTextSearchInputRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocationWithFreeTextSearchInputRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocationWithFreeTextSearchInputRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const SetLocationWithFreeTextSearchInputRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * Request will respond with a contextSwitch to Navigation Destination Free text search
 */
class ShowDestinationFreeTextSearchInputRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowDestinationFreeTextSearchInputRequest ();

    /**
     * Copy constructor
     */
    inline  ShowDestinationFreeTextSearchInputRequest (const ShowDestinationFreeTextSearchInputRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowDestinationFreeTextSearchInputRequest (FTSLocationType locationType_, FreeTextSearchScope locationSearchScope_, const ::std::string& searchString_);

    /**
     * Destructor
     */
    inline virtual  ~ShowDestinationFreeTextSearchInputRequest();

    /**
     * Assignment operator
     */
    inline ShowDestinationFreeTextSearchInputRequest& operator = (const ShowDestinationFreeTextSearchInputRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowDestinationFreeTextSearchInputRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowDestinationFreeTextSearchInputRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowDestinationFreeTextSearchInputRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowDestinationFreeTextSearchInputRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationType"

    static const int kLocationType = 0;

    /**
     * Clears the field "locationType".
     *
     * The field will be set to its default value. The hasLocationType()
     * method will return false.
     */
    inline void clearLocationType();

    /**
     * Checks whether the field "locationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationType()). Otherwise it will return false.
     */
    inline bool hasLocationType () const;

    /**
     * Returns the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationType"
     */
    inline FTSLocationType getLocationType () const;

    /**
     * Sets the value of the member "locationType".
     *
     * If the meaning of "locationType" isn't clear, then there should be a description here.
     *
     * @param locationType The value which will be set
     */
    inline void setLocationType (FTSLocationType locationType_);

    // API of field "locationSearchScope"

    static const int kLocationSearchScope = 1;

    /**
     * Clears the field "locationSearchScope".
     *
     * The field will be set to its default value. The hasLocationSearchScope()
     * method will return false.
     */
    inline void clearLocationSearchScope();

    /**
     * Checks whether the field "locationSearchScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationSearchScope()). Otherwise it will return false.
     */
    inline bool hasLocationSearchScope () const;

    /**
     * Returns the value of the member "locationSearchScope".
     *
     * If the meaning of "locationSearchScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationSearchScope"
     */
    inline FreeTextSearchScope getLocationSearchScope () const;

    /**
     * Sets the value of the member "locationSearchScope".
     *
     * If the meaning of "locationSearchScope" isn't clear, then there should be a description here.
     *
     * @param locationSearchScope The value which will be set
     */
    inline void setLocationSearchScope (FreeTextSearchScope locationSearchScope_);

    // API of field "searchString"

    static const int kSearchString = 2;

    /**
     * Clears the field "searchString".
     *
     * The field will be set to its default value. The hasSearchString()
     * method will return false.
     */
    inline void clearSearchString();

    /**
     * Checks whether the field "searchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchString()). Otherwise it will return false.
     */
    inline bool hasSearchString () const;

    /**
     * Returns the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchString"
     */
    inline const ::std::string& getSearchString () const;

    /**
     * Retrieves the value of the field "searchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchString".
     */
    inline ::std::string& getSearchStringMutable ();

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const ::std::string& searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* searchString_);

    /**
     * Sets the value of the member "searchString".
     *
     * If the meaning of "searchString" isn't clear, then there should be a description here.
     *
     * @param searchString The value which will be set
     */
    inline void setSearchString (const char* value, size_t size);

    static const ShowDestinationFreeTextSearchInputRequest &getDefaultInstance();

private:

    inline void set_has_locationType ();

    inline void clear_has_locationType ();

    inline void set_has_locationSearchScope ();

    inline void clear_has_locationSearchScope ();

    inline void set_has_searchString ();

    inline void clear_has_searchString ();

    uint32 _has_bits_[ (3 + 31) / 32];

    FTSLocationType _locationType;

    FreeTextSearchScope _locationSearchScope;

    ::std::string _searchString;

};

/**
 * Requests POI elements for the given fixed POI category and scope
 */
class RequestFixedPOICategorySearchResultsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFixedPOICategorySearchResultsRequest ();

    /**
     * Copy constructor
     */
    inline  RequestFixedPOICategorySearchResultsRequest (const RequestFixedPOICategorySearchResultsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFixedPOICategorySearchResultsRequest (FixedPOICategory fixedPOICategory_, FreeTextSearchScope locationSearchScope_, uint8 destinationIndex_, uint32 startIndex_, uint32 numElements_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFixedPOICategorySearchResultsRequest();

    /**
     * Assignment operator
     */
    inline RequestFixedPOICategorySearchResultsRequest& operator = (const RequestFixedPOICategorySearchResultsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFixedPOICategorySearchResultsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFixedPOICategorySearchResultsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFixedPOICategorySearchResultsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFixedPOICategorySearchResultsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "fixedPOICategory"

    static const int kFixedPOICategory = 0;

    /**
     * Clears the field "fixedPOICategory".
     *
     * The field will be set to its default value. The hasFixedPOICategory()
     * method will return false.
     */
    inline void clearFixedPOICategory();

    /**
     * Checks whether the field "fixedPOICategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFixedPOICategory()). Otherwise it will return false.
     */
    inline bool hasFixedPOICategory () const;

    /**
     * Returns the value of the member "fixedPOICategory".
     *
     * If the meaning of "fixedPOICategory" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fixedPOICategory"
     */
    inline FixedPOICategory getFixedPOICategory () const;

    /**
     * Sets the value of the member "fixedPOICategory".
     *
     * If the meaning of "fixedPOICategory" isn't clear, then there should be a description here.
     *
     * @param fixedPOICategory The value which will be set
     */
    inline void setFixedPOICategory (FixedPOICategory fixedPOICategory_);

    // API of field "locationSearchScope"

    static const int kLocationSearchScope = 1;

    /**
     * Clears the field "locationSearchScope".
     *
     * The field will be set to its default value. The hasLocationSearchScope()
     * method will return false.
     */
    inline void clearLocationSearchScope();

    /**
     * Checks whether the field "locationSearchScope" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationSearchScope()). Otherwise it will return false.
     */
    inline bool hasLocationSearchScope () const;

    /**
     * Returns the value of the member "locationSearchScope".
     *
     * If the meaning of "locationSearchScope" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationSearchScope"
     */
    inline FreeTextSearchScope getLocationSearchScope () const;

    /**
     * Sets the value of the member "locationSearchScope".
     *
     * If the meaning of "locationSearchScope" isn't clear, then there should be a description here.
     *
     * @param locationSearchScope The value which will be set
     */
    inline void setLocationSearchScope (FreeTextSearchScope locationSearchScope_);

    // API of field "destinationIndex"

    static const int kDestinationIndex = 2;

    /**
     * Clears the field "destinationIndex".
     *
     * The field will be set to its default value. The hasDestinationIndex()
     * method will return false.
     */
    inline void clearDestinationIndex();

    /**
     * Checks whether the field "destinationIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationIndex()). Otherwise it will return false.
     */
    inline bool hasDestinationIndex () const;

    /**
     * Returns the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationIndex"
     */
    inline uint8 getDestinationIndex () const;

    /**
     * Sets the value of the member "destinationIndex".
     *
     * If the meaning of "destinationIndex" isn't clear, then there should be a description here.
     *
     * @param destinationIndex The value which will be set
     */
    inline void setDestinationIndex (uint8 destinationIndex_);

    // API of field "startIndex"

    static const int kStartIndex = 3;

    /**
     * Clears the field "startIndex".
     *
     * The field will be set to its default value. The hasStartIndex()
     * method will return false.
     */
    inline void clearStartIndex();

    /**
     * Checks whether the field "startIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartIndex()). Otherwise it will return false.
     */
    inline bool hasStartIndex () const;

    /**
     * Returns the value of the member "startIndex".
     *
     * If the meaning of "startIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "startIndex"
     */
    inline uint32 getStartIndex () const;

    /**
     * Sets the value of the member "startIndex".
     *
     * If the meaning of "startIndex" isn't clear, then there should be a description here.
     *
     * @param startIndex The value which will be set
     */
    inline void setStartIndex (uint32 startIndex_);

    // API of field "numElements"

    static const int kNumElements = 4;

    /**
     * Clears the field "numElements".
     *
     * The field will be set to its default value. The hasNumElements()
     * method will return false.
     */
    inline void clearNumElements();

    /**
     * Checks whether the field "numElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumElements()). Otherwise it will return false.
     */
    inline bool hasNumElements () const;

    /**
     * Returns the value of the member "numElements".
     *
     * If the meaning of "numElements" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numElements"
     */
    inline uint32 getNumElements () const;

    /**
     * Sets the value of the member "numElements".
     *
     * If the meaning of "numElements" isn't clear, then there should be a description here.
     *
     * @param numElements The value which will be set
     */
    inline void setNumElements (uint32 numElements_);

    static const RequestFixedPOICategorySearchResultsRequest &getDefaultInstance();

private:

    inline void set_has_fixedPOICategory ();

    inline void clear_has_fixedPOICategory ();

    inline void set_has_locationSearchScope ();

    inline void clear_has_locationSearchScope ();

    inline void set_has_destinationIndex ();

    inline void clear_has_destinationIndex ();

    inline void set_has_startIndex ();

    inline void clear_has_startIndex ();

    inline void set_has_numElements ();

    inline void clear_has_numElements ();

    uint32 _has_bits_[ (5 + 31) / 32];

    FixedPOICategory _fixedPOICategory;

    FreeTextSearchScope _locationSearchScope;

    uint8 _destinationIndex;

    uint32 _startIndex;

    uint32 _numElements;

};

/**
 * Requests POI elements for the given fixed POI category and scope
 */
class RequestFixedPOICategorySearchResultsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFixedPOICategorySearchResultsResponse ();

    /**
     * Copy constructor
     */
    inline  RequestFixedPOICategorySearchResultsResponse (const RequestFixedPOICategorySearchResultsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFixedPOICategorySearchResultsResponse (const ::std::vector< AddressListElement >& searchResults_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFixedPOICategorySearchResultsResponse();

    /**
     * Assignment operator
     */
    inline RequestFixedPOICategorySearchResultsResponse& operator = (const RequestFixedPOICategorySearchResultsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFixedPOICategorySearchResultsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFixedPOICategorySearchResultsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFixedPOICategorySearchResultsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFixedPOICategorySearchResultsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "searchResults"

    static const int kSearchResults = 0;

    /**
     * Clears the field "searchResults".
     *
     * The field will be set to its default value. The hasSearchResults()
     * method will return false.
     */
    inline void clearSearchResults();

    /**
     * Checks whether the field "searchResults" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSearchResults()). Otherwise it will return false.
     */
    inline bool hasSearchResults () const;

    /**
     * Returns the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @return The value of the field "searchResults"
     */
    inline const ::std::vector< AddressListElement >& getSearchResults () const;

    /**
     * Retrieves the value of the field "searchResults" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "searchResults".
     */
    inline ::std::vector< AddressListElement >& getSearchResultsMutable ();

    /**
     * Sets the value of the member "searchResults".
     *
     * If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param searchResults The value which will be set
     */
    inline void setSearchResults (const ::std::vector< AddressListElement >& searchResults_);

    static const RequestFixedPOICategorySearchResultsResponse &getDefaultInstance();

private:

    static const ::std::vector< AddressListElement >& getAddressListElementList_DefaultInstance ();

    inline void set_has_searchResults ();

    inline void clear_has_searchResults ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< AddressListElement > _searchResults;

};

/**
 * Method to choose the selected POI for starting guidance and requesting details
 */
class SetLocationWithFixedPOICategoryInputRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLocationWithFixedPOICategoryInputRequest ();

    /**
     * Copy constructor
     */
    inline  SetLocationWithFixedPOICategoryInputRequest (const SetLocationWithFixedPOICategoryInputRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLocationWithFixedPOICategoryInputRequest (uint32 index_);

    /**
     * Destructor
     */
    inline virtual  ~SetLocationWithFixedPOICategoryInputRequest();

    /**
     * Assignment operator
     */
    inline SetLocationWithFixedPOICategoryInputRequest& operator = (const SetLocationWithFixedPOICategoryInputRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLocationWithFixedPOICategoryInputRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLocationWithFixedPOICategoryInputRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLocationWithFixedPOICategoryInputRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLocationWithFixedPOICategoryInputRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    static const SetLocationWithFixedPOICategoryInputRequest &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _index;

};

/**
 * Request will validate the given address,
 *        as result it update the attribute sdsAddressWithOptions
 */
class SdsCheckAddressRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsCheckAddressRequest ();

    /**
     * Copy constructor
     */
    inline  SdsCheckAddressRequest (const SdsCheckAddressRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsCheckAddressRequest (const ::std::vector< SDSAddressElement >& requestedAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SdsCheckAddressRequest();

    /**
     * Assignment operator
     */
    inline SdsCheckAddressRequest& operator = (const SdsCheckAddressRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsCheckAddressRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsCheckAddressRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsCheckAddressRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsCheckAddressRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "requestedAddress"

    static const int kRequestedAddress = 0;

    /**
     * Clears the field "requestedAddress".
     *
     * The field will be set to its default value. The hasRequestedAddress()
     * method will return false.
     */
    inline void clearRequestedAddress();

    /**
     * Checks whether the field "requestedAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestedAddress()). Otherwise it will return false.
     */
    inline bool hasRequestedAddress () const;

    /**
     * Returns the value of the member "requestedAddress".
     *
     * If the meaning of "requestedAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "requestedAddress"
     */
    inline const ::std::vector< SDSAddressElement >& getRequestedAddress () const;

    /**
     * Retrieves the value of the field "requestedAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestedAddress".
     */
    inline ::std::vector< SDSAddressElement >& getRequestedAddressMutable ();

    /**
     * Sets the value of the member "requestedAddress".
     *
     * If the meaning of "requestedAddress" isn't clear, then there should be a description here.
     *
     * @param requestedAddress The value which will be set
     */
    inline void setRequestedAddress (const ::std::vector< SDSAddressElement >& requestedAddress_);

    static const SdsCheckAddressRequest &getDefaultInstance();

private:

    static const ::std::vector< SDSAddressElement >& getSDSAddressElementList_DefaultInstance ();

    inline void set_has_requestedAddress ();

    inline void clear_has_requestedAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< SDSAddressElement > _requestedAddress;

};

/**
 * Request will get refinement list for the validated address
 */
class SdsGetRefinementListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsGetRefinementListRequest ();

    /**
     * Copy constructor
     */
    inline  SdsGetRefinementListRequest (const SdsGetRefinementListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsGetRefinementListRequest (SDSAddressElementType sdsAddressElementType_);

    /**
     * Destructor
     */
    inline virtual  ~SdsGetRefinementListRequest();

    /**
     * Assignment operator
     */
    inline SdsGetRefinementListRequest& operator = (const SdsGetRefinementListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsGetRefinementListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsGetRefinementListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsGetRefinementListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsGetRefinementListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsAddressElementType"

    static const int kSdsAddressElementType = 0;

    /**
     * Clears the field "sdsAddressElementType".
     *
     * The field will be set to its default value. The hasSdsAddressElementType()
     * method will return false.
     */
    inline void clearSdsAddressElementType();

    /**
     * Checks whether the field "sdsAddressElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsAddressElementType()). Otherwise it will return false.
     */
    inline bool hasSdsAddressElementType () const;

    /**
     * Returns the value of the member "sdsAddressElementType".
     *
     * If the meaning of "sdsAddressElementType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sdsAddressElementType"
     */
    inline SDSAddressElementType getSdsAddressElementType () const;

    /**
     * Sets the value of the member "sdsAddressElementType".
     *
     * If the meaning of "sdsAddressElementType" isn't clear, then there should be a description here.
     *
     * @param sdsAddressElementType The value which will be set
     */
    inline void setSdsAddressElementType (SDSAddressElementType sdsAddressElementType_);

    static const SdsGetRefinementListRequest &getDefaultInstance();

private:

    inline void set_has_sdsAddressElementType ();

    inline void clear_has_sdsAddressElementType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSAddressElementType _sdsAddressElementType;

};

/**
 * Request will get refinement list for the validated address
 */
class SdsGetRefinementListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsGetRefinementListResponse ();

    /**
     * Copy constructor
     */
    inline  SdsGetRefinementListResponse (const SdsGetRefinementListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements_);

    /**
     * Destructor
     */
    inline virtual  ~SdsGetRefinementListResponse();

    /**
     * Assignment operator
     */
    inline SdsGetRefinementListResponse& operator = (const SdsGetRefinementListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsGetRefinementListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "refinements"

    static const int kRefinements = 0;

    /**
     * Clears the field "refinements".
     *
     * The field will be set to its default value. The hasRefinements()
     * method will return false.
     */
    inline void clearRefinements();

    /**
     * Checks whether the field "refinements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRefinements()). Otherwise it will return false.
     */
    inline bool hasRefinements () const;

    /**
     * Returns the value of the member "refinements".
     *
     * If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @return The value of the field "refinements"
     */
    inline const ::std::vector< RefinementListElement >& getRefinements () const;

    /**
     * Retrieves the value of the field "refinements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "refinements".
     */
    inline ::std::vector< RefinementListElement >& getRefinementsMutable ();

    /**
     * Sets the value of the member "refinements".
     *
     * If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @param refinements The value which will be set
     */
    inline void setRefinements (const ::std::vector< RefinementListElement >& refinements_);

    static const SdsGetRefinementListResponse &getDefaultInstance();

private:

    static const ::std::vector< RefinementListElement >& getRefinementListElementList_DefaultInstance ();

    inline void set_has_refinements ();

    inline void clear_has_refinements ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< RefinementListElement > _refinements;

};

/**
 * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
 *        As result it update the attribute sdsAddressWithOptions
 */
class SelectSdsRefinementRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectSdsRefinementRequest ();

    /**
     * Copy constructor
     */
    inline  SelectSdsRefinementRequest (const SelectSdsRefinementRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectSdsRefinementRequest (uint32 id_);

    /**
     * Destructor
     */
    inline virtual  ~SelectSdsRefinementRequest();

    /**
     * Assignment operator
     */
    inline SelectSdsRefinementRequest& operator = (const SelectSdsRefinementRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectSdsRefinementRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "id"

    static const int kId = 0;

    /**
     * Clears the field "id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return The value of the field "id"
     */
    inline uint32 getId () const;

    /**
     * Sets the value of the member "id".
     *
     * If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param id The value which will be set
     */
    inline void setId (uint32 id_);

    static const SelectSdsRefinementRequest &getDefaultInstance();

private:

    inline void set_has_id ();

    inline void clear_has_id ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _id;

};

/**
 * Request will return DestinationMemory entries for the given category
 */
class RequestDestinationMemoryEntriesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDestinationMemoryEntriesRequest ();

    /**
     * Copy constructor
     */
    inline  RequestDestinationMemoryEntriesRequest (const RequestDestinationMemoryEntriesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDestinationMemoryEntriesRequest (DestinationMemoryCategoryType categoryType_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDestinationMemoryEntriesRequest();

    /**
     * Assignment operator
     */
    inline RequestDestinationMemoryEntriesRequest& operator = (const RequestDestinationMemoryEntriesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDestinationMemoryEntriesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDestinationMemoryEntriesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDestinationMemoryEntriesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDestinationMemoryEntriesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "categoryType"

    static const int kCategoryType = 0;

    /**
     * Clears the field "categoryType".
     *
     * The field will be set to its default value. The hasCategoryType()
     * method will return false.
     */
    inline void clearCategoryType();

    /**
     * Checks whether the field "categoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryType()). Otherwise it will return false.
     */
    inline bool hasCategoryType () const;

    /**
     * Returns the value of the member "categoryType".
     *
     * If the meaning of "categoryType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "categoryType"
     */
    inline DestinationMemoryCategoryType getCategoryType () const;

    /**
     * Sets the value of the member "categoryType".
     *
     * If the meaning of "categoryType" isn't clear, then there should be a description here.
     *
     * @param categoryType The value which will be set
     */
    inline void setCategoryType (DestinationMemoryCategoryType categoryType_);

    static const RequestDestinationMemoryEntriesRequest &getDefaultInstance();

private:

    inline void set_has_categoryType ();

    inline void clear_has_categoryType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DestinationMemoryCategoryType _categoryType;

};

/**
 * Request will return DestinationMemory entries for the given category
 */
class RequestDestinationMemoryEntriesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDestinationMemoryEntriesResponse ();

    /**
     * Copy constructor
     */
    inline  RequestDestinationMemoryEntriesResponse (const RequestDestinationMemoryEntriesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDestinationMemoryEntriesResponse (const ::std::vector< DestinationMemoryDetailListElement >& destinationMemoryEntries_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDestinationMemoryEntriesResponse();

    /**
     * Assignment operator
     */
    inline RequestDestinationMemoryEntriesResponse& operator = (const RequestDestinationMemoryEntriesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDestinationMemoryEntriesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDestinationMemoryEntriesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDestinationMemoryEntriesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDestinationMemoryEntriesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destinationMemoryEntries"

    static const int kDestinationMemoryEntries = 0;

    /**
     * Clears the field "destinationMemoryEntries".
     *
     * The field will be set to its default value. The hasDestinationMemoryEntries()
     * method will return false.
     */
    inline void clearDestinationMemoryEntries();

    /**
     * Checks whether the field "destinationMemoryEntries" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryEntries()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryEntries () const;

    /**
     * Returns the value of the member "destinationMemoryEntries".
     *
     * If the meaning of "destinationMemoryEntries" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryEntries"
     */
    inline const ::std::vector< DestinationMemoryDetailListElement >& getDestinationMemoryEntries () const;

    /**
     * Retrieves the value of the field "destinationMemoryEntries" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationMemoryEntries".
     */
    inline ::std::vector< DestinationMemoryDetailListElement >& getDestinationMemoryEntriesMutable ();

    /**
     * Sets the value of the member "destinationMemoryEntries".
     *
     * If the meaning of "destinationMemoryEntries" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryEntries The value which will be set
     */
    inline void setDestinationMemoryEntries (const ::std::vector< DestinationMemoryDetailListElement >& destinationMemoryEntries_);

    static const RequestDestinationMemoryEntriesResponse &getDefaultInstance();

private:

    static const ::std::vector< DestinationMemoryDetailListElement >& getDestinationMemoryDetailListElementList_DefaultInstance ();

    inline void set_has_destinationMemoryEntries ();

    inline void clear_has_destinationMemoryEntries ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DestinationMemoryDetailListElement > _destinationMemoryEntries;

};

/**
 * method to select map representation:  dimension/heading combination
 */
class SetMapRepresentationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMapRepresentationRequest ();

    /**
     * Copy constructor
     */
    inline  SetMapRepresentationRequest (const SetMapRepresentationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMapRepresentationRequest (MapRepresentation representation_);

    /**
     * Destructor
     */
    inline virtual  ~SetMapRepresentationRequest();

    /**
     * Assignment operator
     */
    inline SetMapRepresentationRequest& operator = (const SetMapRepresentationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMapRepresentationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMapRepresentationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMapRepresentationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMapRepresentationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "representation"

    static const int kRepresentation = 0;

    /**
     * Clears the field "representation".
     *
     * The field will be set to its default value. The hasRepresentation()
     * method will return false.
     */
    inline void clearRepresentation();

    /**
     * Checks whether the field "representation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRepresentation()). Otherwise it will return false.
     */
    inline bool hasRepresentation () const;

    /**
     * Returns the value of the member "representation".
     *
     * If the meaning of "representation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "representation"
     */
    inline MapRepresentation getRepresentation () const;

    /**
     * Sets the value of the member "representation".
     *
     * If the meaning of "representation" isn't clear, then there should be a description here.
     *
     * @param representation The value which will be set
     */
    inline void setRepresentation (MapRepresentation representation_);

    static const SetMapRepresentationRequest &getDefaultInstance();

private:

    inline void set_has_representation ();

    inline void clear_has_representation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapRepresentation _representation;

};

/**
 * Request will respond with location details for the selected location set via setLocationWithXYZ interface
 */
class RequestDetailsForSelectedLocationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDetailsForSelectedLocationResponse ();

    /**
     * Copy constructor
     */
    inline  RequestDetailsForSelectedLocationResponse (const RequestDetailsForSelectedLocationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDetailsForSelectedLocationResponse (const LocationDetails& locationDetail_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDetailsForSelectedLocationResponse();

    /**
     * Assignment operator
     */
    inline RequestDetailsForSelectedLocationResponse& operator = (const RequestDetailsForSelectedLocationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDetailsForSelectedLocationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDetailsForSelectedLocationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDetailsForSelectedLocationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDetailsForSelectedLocationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationDetail"

    static const int kLocationDetail = 0;

    /**
     * Clears the field "locationDetail".
     *
     * The field will be set to its default value. The hasLocationDetail()
     * method will return false.
     */
    inline void clearLocationDetail();

    /**
     * Checks whether the field "locationDetail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationDetail()). Otherwise it will return false.
     */
    inline bool hasLocationDetail () const;

    /**
     * Returns the value of the member "locationDetail".
     *
     * If the meaning of "locationDetail" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationDetail"
     */
    inline const LocationDetails& getLocationDetail () const;

    /**
     * Retrieves the value of the field "locationDetail" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "locationDetail".
     */
    inline LocationDetails& getLocationDetailMutable ();

    /**
     * Sets the value of the member "locationDetail".
     *
     * If the meaning of "locationDetail" isn't clear, then there should be a description here.
     *
     * @param locationDetail The value which will be set
     */
    inline void setLocationDetail (const LocationDetails& locationDetail_);

    static const RequestDetailsForSelectedLocationResponse &getDefaultInstance();

private:

    inline void set_has_locationDetail ();

    inline void clear_has_locationDetail ();

    uint32 _has_bits_[ (1 + 31) / 32];

    LocationDetails _locationDetail;

};

/**
 * method to trigger the sample voice Phrase
 */
class SpeakSamplePhraseRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeakSamplePhraseRequest ();

    /**
     * Copy constructor
     */
    inline  SpeakSamplePhraseRequest (const SpeakSamplePhraseRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SpeakSamplePhraseRequest (SampleVoicePhrase sampleVoicePhrase_);

    /**
     * Destructor
     */
    inline virtual  ~SpeakSamplePhraseRequest();

    /**
     * Assignment operator
     */
    inline SpeakSamplePhraseRequest& operator = (const SpeakSamplePhraseRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeakSamplePhraseRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeakSamplePhraseRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeakSamplePhraseRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeakSamplePhraseRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sampleVoicePhrase"

    static const int kSampleVoicePhrase = 0;

    /**
     * Clears the field "sampleVoicePhrase".
     *
     * The field will be set to its default value. The hasSampleVoicePhrase()
     * method will return false.
     */
    inline void clearSampleVoicePhrase();

    /**
     * Checks whether the field "sampleVoicePhrase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSampleVoicePhrase()). Otherwise it will return false.
     */
    inline bool hasSampleVoicePhrase () const;

    /**
     * Returns the value of the member "sampleVoicePhrase".
     *
     * If the meaning of "sampleVoicePhrase" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sampleVoicePhrase"
     */
    inline SampleVoicePhrase getSampleVoicePhrase () const;

    /**
     * Sets the value of the member "sampleVoicePhrase".
     *
     * If the meaning of "sampleVoicePhrase" isn't clear, then there should be a description here.
     *
     * @param sampleVoicePhrase The value which will be set
     */
    inline void setSampleVoicePhrase (SampleVoicePhrase sampleVoicePhrase_);

    static const SpeakSamplePhraseRequest &getDefaultInstance();

private:

    inline void set_has_sampleVoicePhrase ();

    inline void clear_has_sampleVoicePhrase ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SampleVoicePhrase _sampleVoicePhrase;

};

/**
 * set RouteCriterion settings and apply them to recalculate
 */
class SetRouteCriterionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRouteCriterionRequest ();

    /**
     * Copy constructor
     */
    inline  SetRouteCriterionRequest (const SetRouteCriterionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRouteCriterionRequest (RouteCriterion routeCriterion_);

    /**
     * Destructor
     */
    inline virtual  ~SetRouteCriterionRequest();

    /**
     * Assignment operator
     */
    inline SetRouteCriterionRequest& operator = (const SetRouteCriterionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRouteCriterionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRouteCriterionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRouteCriterionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRouteCriterionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "routeCriterion"

    static const int kRouteCriterion = 0;

    /**
     * Clears the field "routeCriterion".
     *
     * The field will be set to its default value. The hasRouteCriterion()
     * method will return false.
     */
    inline void clearRouteCriterion();

    /**
     * Checks whether the field "routeCriterion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCriterion()). Otherwise it will return false.
     */
    inline bool hasRouteCriterion () const;

    /**
     * Returns the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "routeCriterion"
     */
    inline RouteCriterion getRouteCriterion () const;

    /**
     * Sets the value of the member "routeCriterion".
     *
     * If the meaning of "routeCriterion" isn't clear, then there should be a description here.
     *
     * @param routeCriterion The value which will be set
     */
    inline void setRouteCriterion (RouteCriterion routeCriterion_);

    static const SetRouteCriterionRequest &getDefaultInstance();

private:

    inline void set_has_routeCriterion ();

    inline void clear_has_routeCriterion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RouteCriterion _routeCriterion;

};

/**
 * method to set and get the guidance settings element for voice
 */
class SetVoiceGuidanceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVoiceGuidanceRequest ();

    /**
     * Copy constructor
     */
    inline  SetVoiceGuidanceRequest (const SetVoiceGuidanceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetVoiceGuidanceRequest (bool active_);

    /**
     * Destructor
     */
    inline virtual  ~SetVoiceGuidanceRequest();

    /**
     * Assignment operator
     */
    inline SetVoiceGuidanceRequest& operator = (const SetVoiceGuidanceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVoiceGuidanceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVoiceGuidanceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVoiceGuidanceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVoiceGuidanceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "active"

    static const int kActive = 0;

    /**
     * Clears the field "active".
     *
     * The field will be set to its default value. The hasActive()
     * method will return false.
     */
    inline void clearActive();

    /**
     * Checks whether the field "active" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActive()). Otherwise it will return false.
     */
    inline bool hasActive () const;

    /**
     * Returns the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @return The value of the field "active"
     */
    inline bool getActive () const;

    /**
     * Sets the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @param active The value which will be set
     */
    inline void setActive (bool active_);

    static const SetVoiceGuidanceRequest &getDefaultInstance();

private:

    inline void set_has_active ();

    inline void clear_has_active ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _active;

};

/**
 * NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium
 */
class CheckNavDataCompatibilityRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckNavDataCompatibilityRequest ();

    /**
     * Copy constructor
     */
    inline  CheckNavDataCompatibilityRequest (const CheckNavDataCompatibilityRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CheckNavDataCompatibilityRequest (const ::std::string& navDataVersion_, const ::std::vector< uint8 >& compatibilityInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CheckNavDataCompatibilityRequest();

    /**
     * Assignment operator
     */
    inline CheckNavDataCompatibilityRequest& operator = (const CheckNavDataCompatibilityRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckNavDataCompatibilityRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckNavDataCompatibilityRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckNavDataCompatibilityRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckNavDataCompatibilityRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navDataVersion"

    static const int kNavDataVersion = 0;

    /**
     * Clears the field "navDataVersion".
     *
     * The field will be set to its default value. The hasNavDataVersion()
     * method will return false.
     */
    inline void clearNavDataVersion();

    /**
     * Checks whether the field "navDataVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavDataVersion()). Otherwise it will return false.
     */
    inline bool hasNavDataVersion () const;

    /**
     * Returns the value of the member "navDataVersion".
     *
     * If the meaning of "navDataVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "navDataVersion"
     */
    inline const ::std::string& getNavDataVersion () const;

    /**
     * Retrieves the value of the field "navDataVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "navDataVersion".
     */
    inline ::std::string& getNavDataVersionMutable ();

    /**
     * Sets the value of the member "navDataVersion".
     *
     * If the meaning of "navDataVersion" isn't clear, then there should be a description here.
     *
     * @param navDataVersion The value which will be set
     */
    inline void setNavDataVersion (const ::std::string& navDataVersion_);

    /**
     * Sets the value of the member "navDataVersion".
     *
     * If the meaning of "navDataVersion" isn't clear, then there should be a description here.
     *
     * @param navDataVersion The value which will be set
     */
    inline void setNavDataVersion (const char* navDataVersion_);

    /**
     * Sets the value of the member "navDataVersion".
     *
     * If the meaning of "navDataVersion" isn't clear, then there should be a description here.
     *
     * @param navDataVersion The value which will be set
     */
    inline void setNavDataVersion (const char* value, size_t size);

    // API of field "compatibilityInfo"

    static const int kCompatibilityInfo = 1;

    /**
     * Clears the field "compatibilityInfo".
     *
     * The field will be set to its default value. The hasCompatibilityInfo()
     * method will return false.
     */
    inline void clearCompatibilityInfo();

    /**
     * Checks whether the field "compatibilityInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCompatibilityInfo()). Otherwise it will return false.
     */
    inline bool hasCompatibilityInfo () const;

    /**
     * Returns the value of the member "compatibilityInfo".
     *
     * If the meaning of "compatibilityInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "compatibilityInfo"
     */
    inline const ::std::vector< uint8 >& getCompatibilityInfo () const;

    /**
     * Retrieves the value of the field "compatibilityInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "compatibilityInfo".
     */
    inline ::std::vector< uint8 >& getCompatibilityInfoMutable ();

    /**
     * Sets the value of the member "compatibilityInfo".
     *
     * If the meaning of "compatibilityInfo" isn't clear, then there should be a description here.
     *
     * @param compatibilityInfo The value which will be set
     */
    inline void setCompatibilityInfo (const ::std::vector< uint8 >& compatibilityInfo_);

    static const CheckNavDataCompatibilityRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_navDataVersion ();

    inline void clear_has_navDataVersion ();

    inline void set_has_compatibilityInfo ();

    inline void clear_has_compatibilityInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _navDataVersion;

    ::std::vector< uint8 > _compatibilityInfo;

};

/**
 * NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium
 */
class CheckNavDataCompatibilityResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckNavDataCompatibilityResponse ();

    /**
     * Copy constructor
     */
    inline  CheckNavDataCompatibilityResponse (const CheckNavDataCompatibilityResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CheckNavDataCompatibilityResponse (NavDataCompatibility compatibility_);

    /**
     * Destructor
     */
    inline virtual  ~CheckNavDataCompatibilityResponse();

    /**
     * Assignment operator
     */
    inline CheckNavDataCompatibilityResponse& operator = (const CheckNavDataCompatibilityResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckNavDataCompatibilityResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckNavDataCompatibilityResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckNavDataCompatibilityResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckNavDataCompatibilityResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "compatibility"

    static const int kCompatibility = 0;

    /**
     * Clears the field "compatibility".
     *
     * The field will be set to its default value. The hasCompatibility()
     * method will return false.
     */
    inline void clearCompatibility();

    /**
     * Checks whether the field "compatibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCompatibility()). Otherwise it will return false.
     */
    inline bool hasCompatibility () const;

    /**
     * Returns the value of the member "compatibility".
     *
     * If the meaning of "compatibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "compatibility"
     */
    inline NavDataCompatibility getCompatibility () const;

    /**
     * Sets the value of the member "compatibility".
     *
     * If the meaning of "compatibility" isn't clear, then there should be a description here.
     *
     * @param compatibility The value which will be set
     */
    inline void setCompatibility (NavDataCompatibility compatibility_);

    static const CheckNavDataCompatibilityResponse &getDefaultInstance();

private:

    inline void set_has_compatibility ();

    inline void clear_has_compatibility ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavDataCompatibility _compatibility;

};

/**
 * Method used to store/delete the VoiceTagId in the destination memory database
 */
class SdsUpdateVoiceTagRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsUpdateVoiceTagRequest ();

    /**
     * Copy constructor
     */
    inline  SdsUpdateVoiceTagRequest (const SdsUpdateVoiceTagRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SdsUpdateVoiceTagRequest (const SDSVoiceTagId& voiceTagID_);

    /**
     * Destructor
     */
    inline virtual  ~SdsUpdateVoiceTagRequest();

    /**
     * Assignment operator
     */
    inline SdsUpdateVoiceTagRequest& operator = (const SdsUpdateVoiceTagRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsUpdateVoiceTagRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "voiceTagID"

    static const int kVoiceTagID = 0;

    /**
     * Clears the field "voiceTagID".
     *
     * The field will be set to its default value. The hasVoiceTagID()
     * method will return false.
     */
    inline void clearVoiceTagID();

    /**
     * Checks whether the field "voiceTagID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceTagID()). Otherwise it will return false.
     */
    inline bool hasVoiceTagID () const;

    /**
     * Returns the value of the member "voiceTagID".
     *
     * If the meaning of "voiceTagID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "voiceTagID"
     */
    inline const SDSVoiceTagId& getVoiceTagID () const;

    /**
     * Retrieves the value of the field "voiceTagID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "voiceTagID".
     */
    inline SDSVoiceTagId& getVoiceTagIDMutable ();

    /**
     * Sets the value of the member "voiceTagID".
     *
     * If the meaning of "voiceTagID" isn't clear, then there should be a description here.
     *
     * @param voiceTagID The value which will be set
     */
    inline void setVoiceTagID (const SDSVoiceTagId& voiceTagID_);

    static const SdsUpdateVoiceTagRequest &getDefaultInstance();

private:

    inline void set_has_voiceTagID ();

    inline void clear_has_voiceTagID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSVoiceTagId _voiceTagID;

};

/**
 * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
 */
class SdsGetHouseNumberPatternResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsGetHouseNumberPatternResponse ();

    /**
     * Copy constructor
     */
    inline  SdsGetHouseNumberPatternResponse (const SdsGetHouseNumberPatternResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber_, const ::std::string& maxHouseNumber_, const ::std::vector< ::std::string >& patterns_);

    /**
     * Destructor
     */
    inline virtual  ~SdsGetHouseNumberPatternResponse();

    /**
     * Assignment operator
     */
    inline SdsGetHouseNumberPatternResponse& operator = (const SdsGetHouseNumberPatternResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsGetHouseNumberPatternResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "minHouseNumber"

    static const int kMinHouseNumber = 0;

    /**
     * Clears the field "minHouseNumber".
     *
     * The field will be set to its default value. The hasMinHouseNumber()
     * method will return false.
     */
    inline void clearMinHouseNumber();

    /**
     * Checks whether the field "minHouseNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinHouseNumber()). Otherwise it will return false.
     */
    inline bool hasMinHouseNumber () const;

    /**
     * Returns the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "minHouseNumber"
     */
    inline const ::std::string& getMinHouseNumber () const;

    /**
     * Retrieves the value of the field "minHouseNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "minHouseNumber".
     */
    inline ::std::string& getMinHouseNumberMutable ();

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const ::std::string& minHouseNumber_);

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const char* minHouseNumber_);

    /**
     * Sets the value of the member "minHouseNumber".
     *
     * If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param minHouseNumber The value which will be set
     */
    inline void setMinHouseNumber (const char* value, size_t size);

    // API of field "maxHouseNumber"

    static const int kMaxHouseNumber = 1;

    /**
     * Clears the field "maxHouseNumber".
     *
     * The field will be set to its default value. The hasMaxHouseNumber()
     * method will return false.
     */
    inline void clearMaxHouseNumber();

    /**
     * Checks whether the field "maxHouseNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxHouseNumber()). Otherwise it will return false.
     */
    inline bool hasMaxHouseNumber () const;

    /**
     * Returns the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "maxHouseNumber"
     */
    inline const ::std::string& getMaxHouseNumber () const;

    /**
     * Retrieves the value of the field "maxHouseNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "maxHouseNumber".
     */
    inline ::std::string& getMaxHouseNumberMutable ();

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const ::std::string& maxHouseNumber_);

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const char* maxHouseNumber_);

    /**
     * Sets the value of the member "maxHouseNumber".
     *
     * If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber The value which will be set
     */
    inline void setMaxHouseNumber (const char* value, size_t size);

    // API of field "patterns"

    static const int kPatterns = 2;

    /**
     * Clears the field "patterns".
     *
     * The field will be set to its default value. The hasPatterns()
     * method will return false.
     */
    inline void clearPatterns();

    /**
     * Checks whether the field "patterns" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPatterns()). Otherwise it will return false.
     */
    inline bool hasPatterns () const;

    /**
     * Returns the value of the member "patterns".
     *
     * If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @return The value of the field "patterns"
     */
    inline const ::std::vector< ::std::string >& getPatterns () const;

    /**
     * Retrieves the value of the field "patterns" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "patterns".
     */
    inline ::std::vector< ::std::string >& getPatternsMutable ();

    /**
     * Sets the value of the member "patterns".
     *
     * If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @param patterns The value which will be set
     */
    inline void setPatterns (const ::std::vector< ::std::string >& patterns_);

    static const SdsGetHouseNumberPatternResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_minHouseNumber ();

    inline void clear_has_minHouseNumber ();

    inline void set_has_maxHouseNumber ();

    inline void clear_has_maxHouseNumber ();

    inline void set_has_patterns ();

    inline void clear_has_patterns ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _minHouseNumber;

    ::std::string _maxHouseNumber;

    ::std::vector< ::std::string > _patterns;

};

/**
 * method to change the MAP color based on light mode request
 */
class SetMapLightModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMapLightModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetMapLightModeRequest (const SetMapLightModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMapLightModeRequest (bool active_);

    /**
     * Destructor
     */
    inline virtual  ~SetMapLightModeRequest();

    /**
     * Assignment operator
     */
    inline SetMapLightModeRequest& operator = (const SetMapLightModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMapLightModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMapLightModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMapLightModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMapLightModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "active"

    static const int kActive = 0;

    /**
     * Clears the field "active".
     *
     * The field will be set to its default value. The hasActive()
     * method will return false.
     */
    inline void clearActive();

    /**
     * Checks whether the field "active" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActive()). Otherwise it will return false.
     */
    inline bool hasActive () const;

    /**
     * Returns the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @return The value of the field "active"
     */
    inline bool getActive () const;

    /**
     * Sets the value of the member "active".
     *
     * If the meaning of "active" isn't clear, then there should be a description here.
     *
     * @param active The value which will be set
     */
    inline void setActive (bool active_);

    static const SetMapLightModeRequest &getDefaultInstance();

private:

    inline void set_has_active ();

    inline void clear_has_active ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _active;

};

/**
 * Starts the trip-replay for the given trip-file
 */
class StartTripReplayRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartTripReplayRequest ();

    /**
     * Copy constructor
     */
    inline  StartTripReplayRequest (const StartTripReplayRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartTripReplayRequest (const ::std::string& tripFileName_);

    /**
     * Destructor
     */
    inline virtual  ~StartTripReplayRequest();

    /**
     * Assignment operator
     */
    inline StartTripReplayRequest& operator = (const StartTripReplayRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartTripReplayRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartTripReplayRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartTripReplayRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartTripReplayRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tripFileName"

    static const int kTripFileName = 0;

    /**
     * Clears the field "tripFileName".
     *
     * The field will be set to its default value. The hasTripFileName()
     * method will return false.
     */
    inline void clearTripFileName();

    /**
     * Checks whether the field "tripFileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTripFileName()). Otherwise it will return false.
     */
    inline bool hasTripFileName () const;

    /**
     * Returns the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tripFileName"
     */
    inline const ::std::string& getTripFileName () const;

    /**
     * Retrieves the value of the field "tripFileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tripFileName".
     */
    inline ::std::string& getTripFileNameMutable ();

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const ::std::string& tripFileName_);

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const char* tripFileName_);

    /**
     * Sets the value of the member "tripFileName".
     *
     * If the meaning of "tripFileName" isn't clear, then there should be a description here.
     *
     * @param tripFileName The value which will be set
     */
    inline void setTripFileName (const char* value, size_t size);

    static const StartTripReplayRequest &getDefaultInstance();

private:

    inline void set_has_tripFileName ();

    inline void clear_has_tripFileName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _tripFileName;

};

/**
 * Seeks to the specified location, in the trip-replay
 */
class SeekTripReplayRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SeekTripReplayRequest ();

    /**
     * Copy constructor
     */
    inline  SeekTripReplayRequest (const SeekTripReplayRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SeekTripReplayRequest (int16 seekValue_);

    /**
     * Destructor
     */
    inline virtual  ~SeekTripReplayRequest();

    /**
     * Assignment operator
     */
    inline SeekTripReplayRequest& operator = (const SeekTripReplayRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SeekTripReplayRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SeekTripReplayRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SeekTripReplayRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SeekTripReplayRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "seekValue"

    static const int kSeekValue = 0;

    /**
     * Clears the field "seekValue".
     *
     * The field will be set to its default value. The hasSeekValue()
     * method will return false.
     */
    inline void clearSeekValue();

    /**
     * Checks whether the field "seekValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeekValue()). Otherwise it will return false.
     */
    inline bool hasSeekValue () const;

    /**
     * Returns the value of the member "seekValue".
     *
     * If the meaning of "seekValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "seekValue"
     */
    inline int16 getSeekValue () const;

    /**
     * Sets the value of the member "seekValue".
     *
     * If the meaning of "seekValue" isn't clear, then there should be a description here.
     *
     * @param seekValue The value which will be set
     */
    inline void setSeekValue (int16 seekValue_);

    static const SeekTripReplayRequest &getDefaultInstance();

private:

    inline void set_has_seekValue ();

    inline void clear_has_seekValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int16 _seekValue;

};

/**
 * Sets the mode of the trip-replay
 */
class SetTripReplayModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetTripReplayModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetTripReplayModeRequest (const SetTripReplayModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetTripReplayModeRequest (bool loopModeActive_, uint16 speed_);

    /**
     * Destructor
     */
    inline virtual  ~SetTripReplayModeRequest();

    /**
     * Assignment operator
     */
    inline SetTripReplayModeRequest& operator = (const SetTripReplayModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTripReplayModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTripReplayModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTripReplayModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTripReplayModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "loopModeActive"

    static const int kLoopModeActive = 0;

    /**
     * Clears the field "loopModeActive".
     *
     * The field will be set to its default value. The hasLoopModeActive()
     * method will return false.
     */
    inline void clearLoopModeActive();

    /**
     * Checks whether the field "loopModeActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoopModeActive()). Otherwise it will return false.
     */
    inline bool hasLoopModeActive () const;

    /**
     * Returns the value of the member "loopModeActive".
     *
     * If the meaning of "loopModeActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loopModeActive"
     */
    inline bool getLoopModeActive () const;

    /**
     * Sets the value of the member "loopModeActive".
     *
     * If the meaning of "loopModeActive" isn't clear, then there should be a description here.
     *
     * @param loopModeActive The value which will be set
     */
    inline void setLoopModeActive (bool loopModeActive_);

    // API of field "speed"

    static const int kSpeed = 1;

    /**
     * Clears the field "speed".
     *
     * The field will be set to its default value. The hasSpeed()
     * method will return false.
     */
    inline void clearSpeed();

    /**
     * Checks whether the field "speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeed()). Otherwise it will return false.
     */
    inline bool hasSpeed () const;

    /**
     * Returns the value of the member "speed".
     *
     * If the meaning of "speed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "speed"
     */
    inline uint16 getSpeed () const;

    /**
     * Sets the value of the member "speed".
     *
     * If the meaning of "speed" isn't clear, then there should be a description here.
     *
     * @param speed The value which will be set
     */
    inline void setSpeed (uint16 speed_);

    static const SetTripReplayModeRequest &getDefaultInstance();

private:

    inline void set_has_loopModeActive ();

    inline void clear_has_loopModeActive ();

    inline void set_has_speed ();

    inline void clear_has_speed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _loopModeActive;

    uint16 _speed;

};

/**
 * Request will respond with Address Details along with Destination Memory Id
 */
class ShowLocationSelectionAndGetAddressDetailsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowLocationSelectionAndGetAddressDetailsResponse ();

    /**
     * Copy constructor
     */
    inline  ShowLocationSelectionAndGetAddressDetailsResponse (const ShowLocationSelectionAndGetAddressDetailsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ShowLocationSelectionAndGetAddressDetailsResponse (const DestinationMemoryDetailListElement& destinationMemoryDetailListElement_);

    /**
     * Destructor
     */
    inline virtual  ~ShowLocationSelectionAndGetAddressDetailsResponse();

    /**
     * Assignment operator
     */
    inline ShowLocationSelectionAndGetAddressDetailsResponse& operator = (const ShowLocationSelectionAndGetAddressDetailsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowLocationSelectionAndGetAddressDetailsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowLocationSelectionAndGetAddressDetailsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowLocationSelectionAndGetAddressDetailsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowLocationSelectionAndGetAddressDetailsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destinationMemoryDetailListElement"

    static const int kDestinationMemoryDetailListElement = 0;

    /**
     * Clears the field "destinationMemoryDetailListElement".
     *
     * The field will be set to its default value. The hasDestinationMemoryDetailListElement()
     * method will return false.
     */
    inline void clearDestinationMemoryDetailListElement();

    /**
     * Checks whether the field "destinationMemoryDetailListElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationMemoryDetailListElement()). Otherwise it will return false.
     */
    inline bool hasDestinationMemoryDetailListElement () const;

    /**
     * Returns the value of the member "destinationMemoryDetailListElement".
     *
     * If the meaning of "destinationMemoryDetailListElement" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destinationMemoryDetailListElement"
     */
    inline const DestinationMemoryDetailListElement& getDestinationMemoryDetailListElement () const;

    /**
     * Retrieves the value of the field "destinationMemoryDetailListElement" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationMemoryDetailListElement".
     */
    inline DestinationMemoryDetailListElement& getDestinationMemoryDetailListElementMutable ();

    /**
     * Sets the value of the member "destinationMemoryDetailListElement".
     *
     * If the meaning of "destinationMemoryDetailListElement" isn't clear, then there should be a description here.
     *
     * @param destinationMemoryDetailListElement The value which will be set
     */
    inline void setDestinationMemoryDetailListElement (const DestinationMemoryDetailListElement& destinationMemoryDetailListElement_);

    static const ShowLocationSelectionAndGetAddressDetailsResponse &getDefaultInstance();

private:

    inline void set_has_destinationMemoryDetailListElement ();

    inline void clear_has_destinationMemoryDetailListElement ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DestinationMemoryDetailListElement _destinationMemoryDetailListElement;

};

/**
 * Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this
 */
class SelectJamAheadListEntryRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectJamAheadListEntryRequest ();

    /**
     * Copy constructor
     */
    inline  SelectJamAheadListEntryRequest (const SelectJamAheadListEntryRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SelectJamAheadListEntryRequest (int32 index_);

    /**
     * Destructor
     */
    inline virtual  ~SelectJamAheadListEntryRequest();

    /**
     * Assignment operator
     */
    inline SelectJamAheadListEntryRequest& operator = (const SelectJamAheadListEntryRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectJamAheadListEntryRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectJamAheadListEntryRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectJamAheadListEntryRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectJamAheadListEntryRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline int32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (int32 index_);

    static const SelectJamAheadListEntryRequest &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _index;

};

/**
 * Request will respond with list of location details for the given location and radius.
 */
class RequestDetailsForSelectedCoordinateWithRadiusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusRequest ();

    /**
     * Copy constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusRequest (const RequestDetailsForSelectedCoordinateWithRadiusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusRequest (const PositionWGS84& location_, uint16 radius_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDetailsForSelectedCoordinateWithRadiusRequest();

    /**
     * Assignment operator
     */
    inline RequestDetailsForSelectedCoordinateWithRadiusRequest& operator = (const RequestDetailsForSelectedCoordinateWithRadiusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDetailsForSelectedCoordinateWithRadiusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDetailsForSelectedCoordinateWithRadiusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDetailsForSelectedCoordinateWithRadiusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDetailsForSelectedCoordinateWithRadiusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const PositionWGS84& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline PositionWGS84& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const PositionWGS84& location_);

    // API of field "radius"

    static const int kRadius = 1;

    /**
     * Clears the field "radius".
     *
     * The field will be set to its default value. The hasRadius()
     * method will return false.
     */
    inline void clearRadius();

    /**
     * Checks whether the field "radius" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadius()). Otherwise it will return false.
     */
    inline bool hasRadius () const;

    /**
     * Returns the value of the member "radius".
     *
     * If the meaning of "radius" isn't clear, then there should be a description here.
     *
     * @return The value of the field "radius"
     */
    inline uint16 getRadius () const;

    /**
     * Sets the value of the member "radius".
     *
     * If the meaning of "radius" isn't clear, then there should be a description here.
     *
     * @param radius The value which will be set
     */
    inline void setRadius (uint16 radius_);

    static const RequestDetailsForSelectedCoordinateWithRadiusRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    inline void set_has_radius ();

    inline void clear_has_radius ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PositionWGS84 _location;

    uint16 _radius;

};

/**
 * Request will respond with list of location details for the given location and radius.
 */
class RequestDetailsForSelectedCoordinateWithRadiusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusResponse ();

    /**
     * Copy constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusResponse (const RequestDetailsForSelectedCoordinateWithRadiusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDetailsForSelectedCoordinateWithRadiusResponse (const ::std::vector< LocationDetails >& locationDetailsList_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDetailsForSelectedCoordinateWithRadiusResponse();

    /**
     * Assignment operator
     */
    inline RequestDetailsForSelectedCoordinateWithRadiusResponse& operator = (const RequestDetailsForSelectedCoordinateWithRadiusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDetailsForSelectedCoordinateWithRadiusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDetailsForSelectedCoordinateWithRadiusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDetailsForSelectedCoordinateWithRadiusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDetailsForSelectedCoordinateWithRadiusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "locationDetailsList"

    static const int kLocationDetailsList = 0;

    /**
     * Clears the field "locationDetailsList".
     *
     * The field will be set to its default value. The hasLocationDetailsList()
     * method will return false.
     */
    inline void clearLocationDetailsList();

    /**
     * Checks whether the field "locationDetailsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationDetailsList()). Otherwise it will return false.
     */
    inline bool hasLocationDetailsList () const;

    /**
     * Returns the value of the member "locationDetailsList".
     *
     * If the meaning of "locationDetailsList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "locationDetailsList"
     */
    inline const ::std::vector< LocationDetails >& getLocationDetailsList () const;

    /**
     * Retrieves the value of the field "locationDetailsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "locationDetailsList".
     */
    inline ::std::vector< LocationDetails >& getLocationDetailsListMutable ();

    /**
     * Sets the value of the member "locationDetailsList".
     *
     * If the meaning of "locationDetailsList" isn't clear, then there should be a description here.
     *
     * @param locationDetailsList The value which will be set
     */
    inline void setLocationDetailsList (const ::std::vector< LocationDetails >& locationDetailsList_);

    static const RequestDetailsForSelectedCoordinateWithRadiusResponse &getDefaultInstance();

private:

    static const ::std::vector< LocationDetails >& getLocationDetailsList_DefaultInstance ();

    inline void set_has_locationDetailsList ();

    inline void clear_has_locationDetailsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< LocationDetails > _locationDetailsList;

};

/**
 * Request to set the latitude and longitude value and location details for showing them and for further processing
 */
class ShowAndSetLocationWithDetailsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShowAndSetLocationWithDetailsRequest ();

    /**
     * Copy constructor
     */
    inline  ShowAndSetLocationWithDetailsRequest (const ShowAndSetLocationWithDetailsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShowAndSetLocationWithDetailsRequest (const POILocation& location_);

    /**
     * Destructor
     */
    inline virtual  ~ShowAndSetLocationWithDetailsRequest();

    /**
     * Assignment operator
     */
    inline ShowAndSetLocationWithDetailsRequest& operator = (const ShowAndSetLocationWithDetailsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShowAndSetLocationWithDetailsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShowAndSetLocationWithDetailsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShowAndSetLocationWithDetailsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShowAndSetLocationWithDetailsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "location"

    static const int kLocation = 0;

    /**
     * Clears the field "location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "location"
     */
    inline const POILocation& getLocation () const;

    /**
     * Retrieves the value of the field "location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "location".
     */
    inline POILocation& getLocationMutable ();

    /**
     * Sets the value of the member "location".
     *
     * If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param location The value which will be set
     */
    inline void setLocation (const POILocation& location_);

    static const ShowAndSetLocationWithDetailsRequest &getDefaultInstance();

private:

    inline void set_has_location ();

    inline void clear_has_location ();

    uint32 _has_bits_[ (1 + 31) / 32];

    POILocation _location;

};

/**
 * Attribute provides the navigation status like UNKNOWN, BUSY
 */
class NavStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  NavStatusUpdate (const NavStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NavStatusUpdate (NavStatus navStatus_);

    /**
     * Destructor
     */
    inline virtual  ~NavStatusUpdate();

    /**
     * Assignment operator
     */
    inline NavStatusUpdate& operator = (const NavStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "navStatus"

    static const int kNavStatus = 0;

    /**
     * Clears the field "navStatus".
     *
     * The field will be set to its default value. The hasNavStatus()
     * method will return false.
     */
    inline void clearNavStatus();

    /**
     * Checks whether the field "navStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavStatus()). Otherwise it will return false.
     */
    inline bool hasNavStatus () const;

    /**
     * Returns the value of the member "navStatus".
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     *
     * @return The value of the field "navStatus"
     */
    inline NavStatus getNavStatus () const;

    /**
     * Sets the value of the member "navStatus".
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     *
     * @param navStatus The value which will be set
     */
    inline void setNavStatus (NavStatus navStatus_);

    static const NavStatusUpdate &getDefaultInstance();

private:

    inline void set_has_navStatus ();

    inline void clear_has_navStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NavStatus _navStatus;

};

/**
 * Attribute provides the navigation status like UNKNOWN, BUSY
 */
class NavStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NavStatusRegister ();

    /**
     * Copy constructor
     */
    inline  NavStatusRegister (const NavStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NavStatusRegister();

    /**
     * Assignment operator
     */
    inline NavStatusRegister& operator = (const NavStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NavStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NavStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NavStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NavStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NavStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the Navi Data Set version in use
 */
class DatasetVersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DatasetVersionUpdate ();

    /**
     * Copy constructor
     */
    inline  DatasetVersionUpdate (const DatasetVersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DatasetVersionUpdate (const ::std::string& datasetVersion_);

    /**
     * Destructor
     */
    inline virtual  ~DatasetVersionUpdate();

    /**
     * Assignment operator
     */
    inline DatasetVersionUpdate& operator = (const DatasetVersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatasetVersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatasetVersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatasetVersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatasetVersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "datasetVersion"

    static const int kDatasetVersion = 0;

    /**
     * Clears the field "datasetVersion".
     *
     * The field will be set to its default value. The hasDatasetVersion()
     * method will return false.
     */
    inline void clearDatasetVersion();

    /**
     * Checks whether the field "datasetVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatasetVersion()). Otherwise it will return false.
     */
    inline bool hasDatasetVersion () const;

    /**
     * Returns the value of the member "datasetVersion".
     *
     * Attribute provides the Navi Data Set version in use
     *
     * @return The value of the field "datasetVersion"
     */
    inline const ::std::string& getDatasetVersion () const;

    /**
     * Retrieves the value of the field "datasetVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "datasetVersion".
     */
    inline ::std::string& getDatasetVersionMutable ();

    /**
     * Sets the value of the member "datasetVersion".
     *
     * Attribute provides the Navi Data Set version in use
     *
     * @param datasetVersion The value which will be set
     */
    inline void setDatasetVersion (const ::std::string& datasetVersion_);

    /**
     * Sets the value of the member "datasetVersion".
     *
     * Attribute provides the Navi Data Set version in use
     *
     * @param datasetVersion The value which will be set
     */
    inline void setDatasetVersion (const char* datasetVersion_);

    /**
     * Sets the value of the member "datasetVersion".
     *
     * Attribute provides the Navi Data Set version in use
     *
     * @param datasetVersion The value which will be set
     */
    inline void setDatasetVersion (const char* value, size_t size);

    static const DatasetVersionUpdate &getDefaultInstance();

private:

    inline void set_has_datasetVersion ();

    inline void clear_has_datasetVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _datasetVersion;

};

/**
 * Attribute provides the Navi Data Set version in use
 */
class DatasetVersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DatasetVersionRegister ();

    /**
     * Copy constructor
     */
    inline  DatasetVersionRegister (const DatasetVersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DatasetVersionRegister();

    /**
     * Assignment operator
     */
    inline DatasetVersionRegister& operator = (const DatasetVersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatasetVersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatasetVersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatasetVersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatasetVersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DatasetVersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the non premium TMC status
 */
class NonPremiumTMCStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NonPremiumTMCStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  NonPremiumTMCStatusUpdate (const NonPremiumTMCStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NonPremiumTMCStatusUpdate (bool nonPremiumTMCStatus_);

    /**
     * Destructor
     */
    inline virtual  ~NonPremiumTMCStatusUpdate();

    /**
     * Assignment operator
     */
    inline NonPremiumTMCStatusUpdate& operator = (const NonPremiumTMCStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NonPremiumTMCStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NonPremiumTMCStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NonPremiumTMCStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NonPremiumTMCStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nonPremiumTMCStatus"

    static const int kNonPremiumTMCStatus = 0;

    /**
     * Clears the field "nonPremiumTMCStatus".
     *
     * The field will be set to its default value. The hasNonPremiumTMCStatus()
     * method will return false.
     */
    inline void clearNonPremiumTMCStatus();

    /**
     * Checks whether the field "nonPremiumTMCStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNonPremiumTMCStatus()). Otherwise it will return false.
     */
    inline bool hasNonPremiumTMCStatus () const;

    /**
     * Returns the value of the member "nonPremiumTMCStatus".
     *
     * Attribute provides the non premium TMC status
     *
     * @return The value of the field "nonPremiumTMCStatus"
     */
    inline bool getNonPremiumTMCStatus () const;

    /**
     * Sets the value of the member "nonPremiumTMCStatus".
     *
     * Attribute provides the non premium TMC status
     *
     * @param nonPremiumTMCStatus The value which will be set
     */
    inline void setNonPremiumTMCStatus (bool nonPremiumTMCStatus_);

    static const NonPremiumTMCStatusUpdate &getDefaultInstance();

private:

    inline void set_has_nonPremiumTMCStatus ();

    inline void clear_has_nonPremiumTMCStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _nonPremiumTMCStatus;

};

/**
 * Attribute provides the non premium TMC status
 */
class NonPremiumTMCStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NonPremiumTMCStatusRegister ();

    /**
     * Copy constructor
     */
    inline  NonPremiumTMCStatusRegister (const NonPremiumTMCStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NonPremiumTMCStatusRegister();

    /**
     * Assignment operator
     */
    inline NonPremiumTMCStatusRegister& operator = (const NonPremiumTMCStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NonPremiumTMCStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NonPremiumTMCStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NonPremiumTMCStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NonPremiumTMCStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NonPremiumTMCStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides freeText search string and position information
 */
class CurrentFreeTextSearchInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentFreeTextSearchInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentFreeTextSearchInfoUpdate (const CurrentFreeTextSearchInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentFreeTextSearchInfoUpdate (const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentFreeTextSearchInfoUpdate();

    /**
     * Assignment operator
     */
    inline CurrentFreeTextSearchInfoUpdate& operator = (const CurrentFreeTextSearchInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentFreeTextSearchInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentFreeTextSearchInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentFreeTextSearchInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentFreeTextSearchInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "currentFreeTextSearchInfo"

    static const int kCurrentFreeTextSearchInfo = 0;

    /**
     * Clears the field "currentFreeTextSearchInfo".
     *
     * The field will be set to its default value. The hasCurrentFreeTextSearchInfo()
     * method will return false.
     */
    inline void clearCurrentFreeTextSearchInfo();

    /**
     * Checks whether the field "currentFreeTextSearchInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentFreeTextSearchInfo()). Otherwise it will return false.
     */
    inline bool hasCurrentFreeTextSearchInfo () const;

    /**
     * Returns the value of the member "currentFreeTextSearchInfo".
     *
     * Attribute provides freeText search string and position information
     *
     * @return The value of the field "currentFreeTextSearchInfo"
     */
    inline const CurrentFreeTextSearchInfo& getCurrentFreeTextSearchInfo () const;

    /**
     * Retrieves the value of the field "currentFreeTextSearchInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentFreeTextSearchInfo".
     */
    inline CurrentFreeTextSearchInfo& getCurrentFreeTextSearchInfoMutable ();

    /**
     * Sets the value of the member "currentFreeTextSearchInfo".
     *
     * Attribute provides freeText search string and position information
     *
     * @param currentFreeTextSearchInfo The value which will be set
     */
    inline void setCurrentFreeTextSearchInfo (const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo_);

    static const CurrentFreeTextSearchInfoUpdate &getDefaultInstance();

private:

    inline void set_has_currentFreeTextSearchInfo ();

    inline void clear_has_currentFreeTextSearchInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    CurrentFreeTextSearchInfo _currentFreeTextSearchInfo;

};

/**
 * Attribute provides freeText search string and position information
 */
class CurrentFreeTextSearchInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentFreeTextSearchInfoRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentFreeTextSearchInfoRegister (const CurrentFreeTextSearchInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentFreeTextSearchInfoRegister();

    /**
     * Assignment operator
     */
    inline CurrentFreeTextSearchInfoRegister& operator = (const CurrentFreeTextSearchInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentFreeTextSearchInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentFreeTextSearchInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentFreeTextSearchInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentFreeTextSearchInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentFreeTextSearchInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides current vehicle position information
 */
class PositionInformationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionInformationUpdate ();

    /**
     * Copy constructor
     */
    inline  PositionInformationUpdate (const PositionInformationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PositionInformationUpdate (const PositionInformation& positionInformation_);

    /**
     * Destructor
     */
    inline virtual  ~PositionInformationUpdate();

    /**
     * Assignment operator
     */
    inline PositionInformationUpdate& operator = (const PositionInformationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInformationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInformationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInformationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInformationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "positionInformation"

    static const int kPositionInformation = 0;

    /**
     * Clears the field "positionInformation".
     *
     * The field will be set to its default value. The hasPositionInformation()
     * method will return false.
     */
    inline void clearPositionInformation();

    /**
     * Checks whether the field "positionInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPositionInformation()). Otherwise it will return false.
     */
    inline bool hasPositionInformation () const;

    /**
     * Returns the value of the member "positionInformation".
     *
     * Attribute provides current vehicle position information
     *
     * @return The value of the field "positionInformation"
     */
    inline const PositionInformation& getPositionInformation () const;

    /**
     * Retrieves the value of the field "positionInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "positionInformation".
     */
    inline PositionInformation& getPositionInformationMutable ();

    /**
     * Sets the value of the member "positionInformation".
     *
     * Attribute provides current vehicle position information
     *
     * @param positionInformation The value which will be set
     */
    inline void setPositionInformation (const PositionInformation& positionInformation_);

    static const PositionInformationUpdate &getDefaultInstance();

private:

    inline void set_has_positionInformation ();

    inline void clear_has_positionInformation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PositionInformation _positionInformation;

};

/**
 * Attribute provides current vehicle position information
 */
class PositionInformationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PositionInformationRegister ();

    /**
     * Copy constructor
     */
    inline  PositionInformationRegister (const PositionInformationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PositionInformationRegister();

    /**
     * Assignment operator
     */
    inline PositionInformationRegister& operator = (const PositionInformationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PositionInformationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PositionInformationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PositionInformationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PositionInformationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PositionInformationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the distance to destination along with unit information
 */
class DistanceToDestinationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceToDestinationUpdate ();

    /**
     * Copy constructor
     */
    inline  DistanceToDestinationUpdate (const DistanceToDestinationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceToDestinationUpdate (const DistanceToDestination& distanceToDestination_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceToDestinationUpdate();

    /**
     * Assignment operator
     */
    inline DistanceToDestinationUpdate& operator = (const DistanceToDestinationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceToDestinationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceToDestinationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceToDestinationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceToDestinationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "distanceToDestination"

    static const int kDistanceToDestination = 0;

    /**
     * Clears the field "distanceToDestination".
     *
     * The field will be set to its default value. The hasDistanceToDestination()
     * method will return false.
     */
    inline void clearDistanceToDestination();

    /**
     * Checks whether the field "distanceToDestination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistanceToDestination()). Otherwise it will return false.
     */
    inline bool hasDistanceToDestination () const;

    /**
     * Returns the value of the member "distanceToDestination".
     *
     * Attribute provides the distance to destination along with unit information
     *
     * @return The value of the field "distanceToDestination"
     */
    inline const DistanceToDestination& getDistanceToDestination () const;

    /**
     * Retrieves the value of the field "distanceToDestination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "distanceToDestination".
     */
    inline DistanceToDestination& getDistanceToDestinationMutable ();

    /**
     * Sets the value of the member "distanceToDestination".
     *
     * Attribute provides the distance to destination along with unit information
     *
     * @param distanceToDestination The value which will be set
     */
    inline void setDistanceToDestination (const DistanceToDestination& distanceToDestination_);

    static const DistanceToDestinationUpdate &getDefaultInstance();

private:

    inline void set_has_distanceToDestination ();

    inline void clear_has_distanceToDestination ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DistanceToDestination _distanceToDestination;

};

/**
 * Attribute provides the distance to destination along with unit information
 */
class DistanceToDestinationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceToDestinationRegister ();

    /**
     * Copy constructor
     */
    inline  DistanceToDestinationRegister (const DistanceToDestinationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DistanceToDestinationRegister();

    /**
     * Assignment operator
     */
    inline DistanceToDestinationRegister& operator = (const DistanceToDestinationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceToDestinationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceToDestinationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceToDestinationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceToDestinationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DistanceToDestinationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the current street
 */
class CurrentStreetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentStreetUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentStreetUpdate (const CurrentStreetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentStreetUpdate (const ::std::string& currentStreet_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentStreetUpdate();

    /**
     * Assignment operator
     */
    inline CurrentStreetUpdate& operator = (const CurrentStreetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentStreetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentStreetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentStreetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentStreetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "currentStreet"

    static const int kCurrentStreet = 0;

    /**
     * Clears the field "currentStreet".
     *
     * The field will be set to its default value. The hasCurrentStreet()
     * method will return false.
     */
    inline void clearCurrentStreet();

    /**
     * Checks whether the field "currentStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentStreet()). Otherwise it will return false.
     */
    inline bool hasCurrentStreet () const;

    /**
     * Returns the value of the member "currentStreet".
     *
     * Attribute provides the current street
     *
     * @return The value of the field "currentStreet"
     */
    inline const ::std::string& getCurrentStreet () const;

    /**
     * Retrieves the value of the field "currentStreet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "currentStreet".
     */
    inline ::std::string& getCurrentStreetMutable ();

    /**
     * Sets the value of the member "currentStreet".
     *
     * Attribute provides the current street
     *
     * @param currentStreet The value which will be set
     */
    inline void setCurrentStreet (const ::std::string& currentStreet_);

    /**
     * Sets the value of the member "currentStreet".
     *
     * Attribute provides the current street
     *
     * @param currentStreet The value which will be set
     */
    inline void setCurrentStreet (const char* currentStreet_);

    /**
     * Sets the value of the member "currentStreet".
     *
     * Attribute provides the current street
     *
     * @param currentStreet The value which will be set
     */
    inline void setCurrentStreet (const char* value, size_t size);

    static const CurrentStreetUpdate &getDefaultInstance();

private:

    inline void set_has_currentStreet ();

    inline void clear_has_currentStreet ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _currentStreet;

};

/**
 * Attribute provides the current street
 */
class CurrentStreetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentStreetRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentStreetRegister (const CurrentStreetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentStreetRegister();

    /**
     * Assignment operator
     */
    inline CurrentStreetRegister& operator = (const CurrentStreetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentStreetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentStreetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentStreetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentStreetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentStreetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the turn to street info
 */
class TurntoStreetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TurntoStreetUpdate ();

    /**
     * Copy constructor
     */
    inline  TurntoStreetUpdate (const TurntoStreetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TurntoStreetUpdate (const TurnToStreet& turntoStreet_);

    /**
     * Destructor
     */
    inline virtual  ~TurntoStreetUpdate();

    /**
     * Assignment operator
     */
    inline TurntoStreetUpdate& operator = (const TurntoStreetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TurntoStreetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TurntoStreetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TurntoStreetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TurntoStreetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "turntoStreet"

    static const int kTurntoStreet = 0;

    /**
     * Clears the field "turntoStreet".
     *
     * The field will be set to its default value. The hasTurntoStreet()
     * method will return false.
     */
    inline void clearTurntoStreet();

    /**
     * Checks whether the field "turntoStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTurntoStreet()). Otherwise it will return false.
     */
    inline bool hasTurntoStreet () const;

    /**
     * Returns the value of the member "turntoStreet".
     *
     * Attribute provides the turn to street info
     *
     * @return The value of the field "turntoStreet"
     */
    inline const TurnToStreet& getTurntoStreet () const;

    /**
     * Retrieves the value of the field "turntoStreet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "turntoStreet".
     */
    inline TurnToStreet& getTurntoStreetMutable ();

    /**
     * Sets the value of the member "turntoStreet".
     *
     * Attribute provides the turn to street info
     *
     * @param turntoStreet The value which will be set
     */
    inline void setTurntoStreet (const TurnToStreet& turntoStreet_);

    static const TurntoStreetUpdate &getDefaultInstance();

private:

    inline void set_has_turntoStreet ();

    inline void clear_has_turntoStreet ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TurnToStreet _turntoStreet;

};

/**
 * Attribute provides the turn to street info
 */
class TurntoStreetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TurntoStreetRegister ();

    /**
     * Copy constructor
     */
    inline  TurntoStreetRegister (const TurntoStreetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TurntoStreetRegister();

    /**
     * Assignment operator
     */
    inline TurntoStreetRegister& operator = (const TurntoStreetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TurntoStreetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TurntoStreetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TurntoStreetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TurntoStreetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TurntoStreetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the round about Exit Number
 */
class RoundaboutExitNumberUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoundaboutExitNumberUpdate ();

    /**
     * Copy constructor
     */
    inline  RoundaboutExitNumberUpdate (const RoundaboutExitNumberUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RoundaboutExitNumberUpdate (uint16 roundaboutExitNumber_);

    /**
     * Destructor
     */
    inline virtual  ~RoundaboutExitNumberUpdate();

    /**
     * Assignment operator
     */
    inline RoundaboutExitNumberUpdate& operator = (const RoundaboutExitNumberUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoundaboutExitNumberUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoundaboutExitNumberUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoundaboutExitNumberUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoundaboutExitNumberUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "roundaboutExitNumber"

    static const int kRoundaboutExitNumber = 0;

    /**
     * Clears the field "roundaboutExitNumber".
     *
     * The field will be set to its default value. The hasRoundaboutExitNumber()
     * method will return false.
     */
    inline void clearRoundaboutExitNumber();

    /**
     * Checks whether the field "roundaboutExitNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoundaboutExitNumber()). Otherwise it will return false.
     */
    inline bool hasRoundaboutExitNumber () const;

    /**
     * Returns the value of the member "roundaboutExitNumber".
     *
     * Attribute provides the round about Exit Number
     *
     * @return The value of the field "roundaboutExitNumber"
     */
    inline uint16 getRoundaboutExitNumber () const;

    /**
     * Sets the value of the member "roundaboutExitNumber".
     *
     * Attribute provides the round about Exit Number
     *
     * @param roundaboutExitNumber The value which will be set
     */
    inline void setRoundaboutExitNumber (uint16 roundaboutExitNumber_);

    static const RoundaboutExitNumberUpdate &getDefaultInstance();

private:

    inline void set_has_roundaboutExitNumber ();

    inline void clear_has_roundaboutExitNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _roundaboutExitNumber;

};

/**
 * Attribute provides the round about Exit Number
 */
class RoundaboutExitNumberRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoundaboutExitNumberRegister ();

    /**
     * Copy constructor
     */
    inline  RoundaboutExitNumberRegister (const RoundaboutExitNumberRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RoundaboutExitNumberRegister();

    /**
     * Assignment operator
     */
    inline RoundaboutExitNumberRegister& operator = (const RoundaboutExitNumberRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoundaboutExitNumberRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoundaboutExitNumberRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoundaboutExitNumberRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoundaboutExitNumberRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RoundaboutExitNumberRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the next turn to street - DEPRECATED (no longer supported)
 */
class NextTurntoStreetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextTurntoStreetUpdate ();

    /**
     * Copy constructor
     */
    inline  NextTurntoStreetUpdate (const NextTurntoStreetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NextTurntoStreetUpdate (const ::std::string& nextTurntoStreet_);

    /**
     * Destructor
     */
    inline virtual  ~NextTurntoStreetUpdate();

    /**
     * Assignment operator
     */
    inline NextTurntoStreetUpdate& operator = (const NextTurntoStreetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextTurntoStreetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextTurntoStreetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextTurntoStreetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextTurntoStreetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nextTurntoStreet"

    static const int kNextTurntoStreet = 0;

    /**
     * Clears the field "nextTurntoStreet".
     *
     * The field will be set to its default value. The hasNextTurntoStreet()
     * method will return false.
     */
    inline void clearNextTurntoStreet();

    /**
     * Checks whether the field "nextTurntoStreet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextTurntoStreet()). Otherwise it will return false.
     */
    inline bool hasNextTurntoStreet () const;

    /**
     * Returns the value of the member "nextTurntoStreet".
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     *
     * @return The value of the field "nextTurntoStreet"
     */
    inline const ::std::string& getNextTurntoStreet () const;

    /**
     * Retrieves the value of the field "nextTurntoStreet" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "nextTurntoStreet".
     */
    inline ::std::string& getNextTurntoStreetMutable ();

    /**
     * Sets the value of the member "nextTurntoStreet".
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     *
     * @param nextTurntoStreet The value which will be set
     */
    inline void setNextTurntoStreet (const ::std::string& nextTurntoStreet_);

    /**
     * Sets the value of the member "nextTurntoStreet".
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     *
     * @param nextTurntoStreet The value which will be set
     */
    inline void setNextTurntoStreet (const char* nextTurntoStreet_);

    /**
     * Sets the value of the member "nextTurntoStreet".
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     *
     * @param nextTurntoStreet The value which will be set
     */
    inline void setNextTurntoStreet (const char* value, size_t size);

    static const NextTurntoStreetUpdate &getDefaultInstance();

private:

    inline void set_has_nextTurntoStreet ();

    inline void clear_has_nextTurntoStreet ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _nextTurntoStreet;

};

/**
 * Attribute provides the next turn to street - DEPRECATED (no longer supported)
 */
class NextTurntoStreetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextTurntoStreetRegister ();

    /**
     * Copy constructor
     */
    inline  NextTurntoStreetRegister (const NextTurntoStreetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NextTurntoStreetRegister();

    /**
     * Assignment operator
     */
    inline NextTurntoStreetRegister& operator = (const NextTurntoStreetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextTurntoStreetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextTurntoStreetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextTurntoStreetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextTurntoStreetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NextTurntoStreetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides barGraph value and state along with unit information
 */
class BarGraphInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BarGraphInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  BarGraphInfoUpdate (const BarGraphInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BarGraphInfoUpdate (const BarGraphInfo& barGraphInfo_);

    /**
     * Destructor
     */
    inline virtual  ~BarGraphInfoUpdate();

    /**
     * Assignment operator
     */
    inline BarGraphInfoUpdate& operator = (const BarGraphInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BarGraphInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BarGraphInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BarGraphInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BarGraphInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "barGraphInfo"

    static const int kBarGraphInfo = 0;

    /**
     * Clears the field "barGraphInfo".
     *
     * The field will be set to its default value. The hasBarGraphInfo()
     * method will return false.
     */
    inline void clearBarGraphInfo();

    /**
     * Checks whether the field "barGraphInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBarGraphInfo()). Otherwise it will return false.
     */
    inline bool hasBarGraphInfo () const;

    /**
     * Returns the value of the member "barGraphInfo".
     *
     * Attribute provides barGraph value and state along with unit information
     *
     * @return The value of the field "barGraphInfo"
     */
    inline const BarGraphInfo& getBarGraphInfo () const;

    /**
     * Retrieves the value of the field "barGraphInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "barGraphInfo".
     */
    inline BarGraphInfo& getBarGraphInfoMutable ();

    /**
     * Sets the value of the member "barGraphInfo".
     *
     * Attribute provides barGraph value and state along with unit information
     *
     * @param barGraphInfo The value which will be set
     */
    inline void setBarGraphInfo (const BarGraphInfo& barGraphInfo_);

    static const BarGraphInfoUpdate &getDefaultInstance();

private:

    inline void set_has_barGraphInfo ();

    inline void clear_has_barGraphInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    BarGraphInfo _barGraphInfo;

};

/**
 * Attribute provides barGraph value and state along with unit information
 */
class BarGraphInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BarGraphInfoRegister ();

    /**
     * Copy constructor
     */
    inline  BarGraphInfoRegister (const BarGraphInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BarGraphInfoRegister();

    /**
     * Assignment operator
     */
    inline BarGraphInfoRegister& operator = (const BarGraphInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BarGraphInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BarGraphInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BarGraphInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BarGraphInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BarGraphInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Destination straight ahead and further enum values indicate clockwise
 */
class ManeuverSymbolUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManeuverSymbolUpdate ();

    /**
     * Copy constructor
     */
    inline  ManeuverSymbolUpdate (const ManeuverSymbolUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ManeuverSymbolUpdate (ManeuverSymbol maneuverSymbol_);

    /**
     * Destructor
     */
    inline virtual  ~ManeuverSymbolUpdate();

    /**
     * Assignment operator
     */
    inline ManeuverSymbolUpdate& operator = (const ManeuverSymbolUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManeuverSymbolUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManeuverSymbolUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManeuverSymbolUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManeuverSymbolUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverSymbol"

    static const int kManeuverSymbol = 0;

    /**
     * Clears the field "maneuverSymbol".
     *
     * The field will be set to its default value. The hasManeuverSymbol()
     * method will return false.
     */
    inline void clearManeuverSymbol();

    /**
     * Checks whether the field "maneuverSymbol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverSymbol()). Otherwise it will return false.
     */
    inline bool hasManeuverSymbol () const;

    /**
     * Returns the value of the member "maneuverSymbol".
     *
     * Destination straight ahead and further enum values indicate clockwise
     *
     * @return The value of the field "maneuverSymbol"
     */
    inline ManeuverSymbol getManeuverSymbol () const;

    /**
     * Sets the value of the member "maneuverSymbol".
     *
     * Destination straight ahead and further enum values indicate clockwise
     *
     * @param maneuverSymbol The value which will be set
     */
    inline void setManeuverSymbol (ManeuverSymbol maneuverSymbol_);

    static const ManeuverSymbolUpdate &getDefaultInstance();

private:

    inline void set_has_maneuverSymbol ();

    inline void clear_has_maneuverSymbol ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ManeuverSymbol _maneuverSymbol;

};

/**
 * Destination straight ahead and further enum values indicate clockwise
 */
class ManeuverSymbolRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManeuverSymbolRegister ();

    /**
     * Copy constructor
     */
    inline  ManeuverSymbolRegister (const ManeuverSymbolRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ManeuverSymbolRegister();

    /**
     * Assignment operator
     */
    inline ManeuverSymbolRegister& operator = (const ManeuverSymbolRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManeuverSymbolRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManeuverSymbolRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManeuverSymbolRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManeuverSymbolRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ManeuverSymbolRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides satellite sensor information
 */
class SatelliteInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SatelliteInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  SatelliteInfoUpdate (const SatelliteInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SatelliteInfoUpdate (const SatelliteInfo& satelliteInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SatelliteInfoUpdate();

    /**
     * Assignment operator
     */
    inline SatelliteInfoUpdate& operator = (const SatelliteInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SatelliteInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SatelliteInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SatelliteInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SatelliteInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "satelliteInfo"

    static const int kSatelliteInfo = 0;

    /**
     * Clears the field "satelliteInfo".
     *
     * The field will be set to its default value. The hasSatelliteInfo()
     * method will return false.
     */
    inline void clearSatelliteInfo();

    /**
     * Checks whether the field "satelliteInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSatelliteInfo()). Otherwise it will return false.
     */
    inline bool hasSatelliteInfo () const;

    /**
     * Returns the value of the member "satelliteInfo".
     *
     * Attribute provides satellite sensor information
     *
     * @return The value of the field "satelliteInfo"
     */
    inline const SatelliteInfo& getSatelliteInfo () const;

    /**
     * Retrieves the value of the field "satelliteInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "satelliteInfo".
     */
    inline SatelliteInfo& getSatelliteInfoMutable ();

    /**
     * Sets the value of the member "satelliteInfo".
     *
     * Attribute provides satellite sensor information
     *
     * @param satelliteInfo The value which will be set
     */
    inline void setSatelliteInfo (const SatelliteInfo& satelliteInfo_);

    static const SatelliteInfoUpdate &getDefaultInstance();

private:

    inline void set_has_satelliteInfo ();

    inline void clear_has_satelliteInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SatelliteInfo _satelliteInfo;

};

/**
 * Attribute provides satellite sensor information
 */
class SatelliteInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SatelliteInfoRegister ();

    /**
     * Copy constructor
     */
    inline  SatelliteInfoRegister (const SatelliteInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SatelliteInfoRegister();

    /**
     * Assignment operator
     */
    inline SatelliteInfoRegister& operator = (const SatelliteInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SatelliteInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SatelliteInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SatelliteInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SatelliteInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SatelliteInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides destination information on the currently guided tour
 */
class DestinationInformationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestinationInformationUpdate ();

    /**
     * Copy constructor
     */
    inline  DestinationInformationUpdate (const DestinationInformationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationInformationUpdate (const ::std::vector< DestinationInfoElement >& destinationInformation_);

    /**
     * Destructor
     */
    inline virtual  ~DestinationInformationUpdate();

    /**
     * Assignment operator
     */
    inline DestinationInformationUpdate& operator = (const DestinationInformationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationInformationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationInformationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationInformationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationInformationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destinationInformation"

    static const int kDestinationInformation = 0;

    /**
     * Clears the field "destinationInformation".
     *
     * The field will be set to its default value. The hasDestinationInformation()
     * method will return false.
     */
    inline void clearDestinationInformation();

    /**
     * Checks whether the field "destinationInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationInformation()). Otherwise it will return false.
     */
    inline bool hasDestinationInformation () const;

    /**
     * Returns the value of the member "destinationInformation".
     *
     * Attribute provides destination information on the currently guided tour
     *
     * @return The value of the field "destinationInformation"
     */
    inline const ::std::vector< DestinationInfoElement >& getDestinationInformation () const;

    /**
     * Retrieves the value of the field "destinationInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destinationInformation".
     */
    inline ::std::vector< DestinationInfoElement >& getDestinationInformationMutable ();

    /**
     * Sets the value of the member "destinationInformation".
     *
     * Attribute provides destination information on the currently guided tour
     *
     * @param destinationInformation The value which will be set
     */
    inline void setDestinationInformation (const ::std::vector< DestinationInfoElement >& destinationInformation_);

    static const DestinationInformationUpdate &getDefaultInstance();

private:

    static const ::std::vector< DestinationInfoElement >& getDestinationInfoElementList_DefaultInstance ();

    inline void set_has_destinationInformation ();

    inline void clear_has_destinationInformation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< DestinationInfoElement > _destinationInformation;

};

/**
 * Attribute provides destination information on the currently guided tour
 */
class DestinationInformationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestinationInformationRegister ();

    /**
     * Copy constructor
     */
    inline  DestinationInformationRegister (const DestinationInformationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DestinationInformationRegister();

    /**
     * Assignment operator
     */
    inline DestinationInformationRegister& operator = (const DestinationInformationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationInformationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationInformationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationInformationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationInformationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DestinationInformationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides duration of Search and Guidance
 */
class RouteCalculationDurationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RouteCalculationDurationUpdate ();

    /**
     * Copy constructor
     */
    inline  RouteCalculationDurationUpdate (const RouteCalculationDurationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RouteCalculationDurationUpdate (const RouteCalculationDuration& routeCalculationDuration_);

    /**
     * Destructor
     */
    inline virtual  ~RouteCalculationDurationUpdate();

    /**
     * Assignment operator
     */
    inline RouteCalculationDurationUpdate& operator = (const RouteCalculationDurationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RouteCalculationDurationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RouteCalculationDurationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RouteCalculationDurationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RouteCalculationDurationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "routeCalculationDuration"

    static const int kRouteCalculationDuration = 0;

    /**
     * Clears the field "routeCalculationDuration".
     *
     * The field will be set to its default value. The hasRouteCalculationDuration()
     * method will return false.
     */
    inline void clearRouteCalculationDuration();

    /**
     * Checks whether the field "routeCalculationDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCalculationDuration()). Otherwise it will return false.
     */
    inline bool hasRouteCalculationDuration () const;

    /**
     * Returns the value of the member "routeCalculationDuration".
     *
     * Attribute provides duration of Search and Guidance
     *
     * @return The value of the field "routeCalculationDuration"
     */
    inline const RouteCalculationDuration& getRouteCalculationDuration () const;

    /**
     * Retrieves the value of the field "routeCalculationDuration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "routeCalculationDuration".
     */
    inline RouteCalculationDuration& getRouteCalculationDurationMutable ();

    /**
     * Sets the value of the member "routeCalculationDuration".
     *
     * Attribute provides duration of Search and Guidance
     *
     * @param routeCalculationDuration The value which will be set
     */
    inline void setRouteCalculationDuration (const RouteCalculationDuration& routeCalculationDuration_);

    static const RouteCalculationDurationUpdate &getDefaultInstance();

private:

    inline void set_has_routeCalculationDuration ();

    inline void clear_has_routeCalculationDuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RouteCalculationDuration _routeCalculationDuration;

};

/**
 * Attribute provides duration of Search and Guidance
 */
class RouteCalculationDurationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RouteCalculationDurationRegister ();

    /**
     * Copy constructor
     */
    inline  RouteCalculationDurationRegister (const RouteCalculationDurationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RouteCalculationDurationRegister();

    /**
     * Assignment operator
     */
    inline RouteCalculationDurationRegister& operator = (const RouteCalculationDurationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RouteCalculationDurationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RouteCalculationDurationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RouteCalculationDurationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RouteCalculationDurationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RouteCalculationDurationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides location of the navigation home location, if set
 */
class HomeLocationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HomeLocationUpdate ();

    /**
     * Copy constructor
     */
    inline  HomeLocationUpdate (const HomeLocationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HomeLocationUpdate (const Location& homeLocation_);

    /**
     * Destructor
     */
    inline virtual  ~HomeLocationUpdate();

    /**
     * Assignment operator
     */
    inline HomeLocationUpdate& operator = (const HomeLocationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HomeLocationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HomeLocationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HomeLocationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HomeLocationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "homeLocation"

    static const int kHomeLocation = 0;

    /**
     * Clears the field "homeLocation".
     *
     * The field will be set to its default value. The hasHomeLocation()
     * method will return false.
     */
    inline void clearHomeLocation();

    /**
     * Checks whether the field "homeLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHomeLocation()). Otherwise it will return false.
     */
    inline bool hasHomeLocation () const;

    /**
     * Returns the value of the member "homeLocation".
     *
     * Attribute provides location of the navigation home location, if set
     *
     * @return The value of the field "homeLocation"
     */
    inline const Location& getHomeLocation () const;

    /**
     * Retrieves the value of the field "homeLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "homeLocation".
     */
    inline Location& getHomeLocationMutable ();

    /**
     * Sets the value of the member "homeLocation".
     *
     * Attribute provides location of the navigation home location, if set
     *
     * @param homeLocation The value which will be set
     */
    inline void setHomeLocation (const Location& homeLocation_);

    static const HomeLocationUpdate &getDefaultInstance();

private:

    inline void set_has_homeLocation ();

    inline void clear_has_homeLocation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Location _homeLocation;

};

/**
 * Attribute provides location of the navigation home location, if set
 */
class HomeLocationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HomeLocationRegister ();

    /**
     * Copy constructor
     */
    inline  HomeLocationRegister (const HomeLocationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HomeLocationRegister();

    /**
     * Assignment operator
     */
    inline HomeLocationRegister& operator = (const HomeLocationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HomeLocationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HomeLocationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HomeLocationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HomeLocationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HomeLocationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides location of the navigation work location, if set
 */
class WorkLocationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WorkLocationUpdate ();

    /**
     * Copy constructor
     */
    inline  WorkLocationUpdate (const WorkLocationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WorkLocationUpdate (const Location& workLocation_);

    /**
     * Destructor
     */
    inline virtual  ~WorkLocationUpdate();

    /**
     * Assignment operator
     */
    inline WorkLocationUpdate& operator = (const WorkLocationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WorkLocationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WorkLocationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WorkLocationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WorkLocationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "workLocation"

    static const int kWorkLocation = 0;

    /**
     * Clears the field "workLocation".
     *
     * The field will be set to its default value. The hasWorkLocation()
     * method will return false.
     */
    inline void clearWorkLocation();

    /**
     * Checks whether the field "workLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWorkLocation()). Otherwise it will return false.
     */
    inline bool hasWorkLocation () const;

    /**
     * Returns the value of the member "workLocation".
     *
     * Attribute provides location of the navigation work location, if set
     *
     * @return The value of the field "workLocation"
     */
    inline const Location& getWorkLocation () const;

    /**
     * Retrieves the value of the field "workLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "workLocation".
     */
    inline Location& getWorkLocationMutable ();

    /**
     * Sets the value of the member "workLocation".
     *
     * Attribute provides location of the navigation work location, if set
     *
     * @param workLocation The value which will be set
     */
    inline void setWorkLocation (const Location& workLocation_);

    static const WorkLocationUpdate &getDefaultInstance();

private:

    inline void set_has_workLocation ();

    inline void clear_has_workLocation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Location _workLocation;

};

/**
 * Attribute provides location of the navigation work location, if set
 */
class WorkLocationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WorkLocationRegister ();

    /**
     * Copy constructor
     */
    inline  WorkLocationRegister (const WorkLocationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WorkLocationRegister();

    /**
     * Assignment operator
     */
    inline WorkLocationRegister& operator = (const WorkLocationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WorkLocationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WorkLocationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WorkLocationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WorkLocationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WorkLocationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the map representation (orientation and 2D / 3D)
 */
class MapRepresentationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapRepresentationUpdate ();

    /**
     * Copy constructor
     */
    inline  MapRepresentationUpdate (const MapRepresentationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MapRepresentationUpdate (MapRepresentation mapRepresentation_);

    /**
     * Destructor
     */
    inline virtual  ~MapRepresentationUpdate();

    /**
     * Assignment operator
     */
    inline MapRepresentationUpdate& operator = (const MapRepresentationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapRepresentationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapRepresentationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapRepresentationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapRepresentationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mapRepresentation"

    static const int kMapRepresentation = 0;

    /**
     * Clears the field "mapRepresentation".
     *
     * The field will be set to its default value. The hasMapRepresentation()
     * method will return false.
     */
    inline void clearMapRepresentation();

    /**
     * Checks whether the field "mapRepresentation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapRepresentation()). Otherwise it will return false.
     */
    inline bool hasMapRepresentation () const;

    /**
     * Returns the value of the member "mapRepresentation".
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     *
     * @return The value of the field "mapRepresentation"
     */
    inline MapRepresentation getMapRepresentation () const;

    /**
     * Sets the value of the member "mapRepresentation".
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     *
     * @param mapRepresentation The value which will be set
     */
    inline void setMapRepresentation (MapRepresentation mapRepresentation_);

    static const MapRepresentationUpdate &getDefaultInstance();

private:

    inline void set_has_mapRepresentation ();

    inline void clear_has_mapRepresentation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    MapRepresentation _mapRepresentation;

};

/**
 * Attribute provides the map representation (orientation and 2D / 3D)
 */
class MapRepresentationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapRepresentationRegister ();

    /**
     * Copy constructor
     */
    inline  MapRepresentationRegister (const MapRepresentationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MapRepresentationRegister();

    /**
     * Assignment operator
     */
    inline MapRepresentationRegister& operator = (const MapRepresentationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapRepresentationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapRepresentationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapRepresentationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapRepresentationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MapRepresentationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the current SDS address entry
 */
class SdsAddressWithOptionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsAddressWithOptionsUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsAddressWithOptionsUpdate (const SdsAddressWithOptionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsAddressWithOptionsUpdate (const SDSAddressWithOptions& sdsAddressWithOptions_);

    /**
     * Destructor
     */
    inline virtual  ~SdsAddressWithOptionsUpdate();

    /**
     * Assignment operator
     */
    inline SdsAddressWithOptionsUpdate& operator = (const SdsAddressWithOptionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsAddressWithOptionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsAddressWithOptions"

    static const int kSdsAddressWithOptions = 0;

    /**
     * Clears the field "sdsAddressWithOptions".
     *
     * The field will be set to its default value. The hasSdsAddressWithOptions()
     * method will return false.
     */
    inline void clearSdsAddressWithOptions();

    /**
     * Checks whether the field "sdsAddressWithOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsAddressWithOptions()). Otherwise it will return false.
     */
    inline bool hasSdsAddressWithOptions () const;

    /**
     * Returns the value of the member "sdsAddressWithOptions".
     *
     * Attribute provides the current SDS address entry
     *
     * @return The value of the field "sdsAddressWithOptions"
     */
    inline const SDSAddressWithOptions& getSdsAddressWithOptions () const;

    /**
     * Retrieves the value of the field "sdsAddressWithOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsAddressWithOptions".
     */
    inline SDSAddressWithOptions& getSdsAddressWithOptionsMutable ();

    /**
     * Sets the value of the member "sdsAddressWithOptions".
     *
     * Attribute provides the current SDS address entry
     *
     * @param sdsAddressWithOptions The value which will be set
     */
    inline void setSdsAddressWithOptions (const SDSAddressWithOptions& sdsAddressWithOptions_);

    static const SdsAddressWithOptionsUpdate &getDefaultInstance();

private:

    inline void set_has_sdsAddressWithOptions ();

    inline void clear_has_sdsAddressWithOptions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSAddressWithOptions _sdsAddressWithOptions;

};

/**
 * Attribute provides the current SDS address entry
 */
class SdsAddressWithOptionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsAddressWithOptionsRegister ();

    /**
     * Copy constructor
     */
    inline  SdsAddressWithOptionsRegister (const SdsAddressWithOptionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsAddressWithOptionsRegister();

    /**
     * Assignment operator
     */
    inline SdsAddressWithOptionsRegister& operator = (const SdsAddressWithOptionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsAddressWithOptionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsAddressWithOptionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsAddressWithOptionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsAddressWithOptionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsAddressWithOptionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
class WaypointListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaypointListUpdate ();

    /**
     * Copy constructor
     */
    inline  WaypointListUpdate (const WaypointListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WaypointListUpdate (const ::std::vector< WaypointListElement >& waypointList_);

    /**
     * Destructor
     */
    inline virtual  ~WaypointListUpdate();

    /**
     * Assignment operator
     */
    inline WaypointListUpdate& operator = (const WaypointListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaypointListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaypointListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaypointListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaypointListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "waypointList"

    static const int kWaypointList = 0;

    /**
     * Clears the field "waypointList".
     *
     * The field will be set to its default value. The hasWaypointList()
     * method will return false.
     */
    inline void clearWaypointList();

    /**
     * Checks whether the field "waypointList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWaypointList()). Otherwise it will return false.
     */
    inline bool hasWaypointList () const;

    /**
     * Returns the value of the member "waypointList".
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @return The value of the field "waypointList"
     */
    inline const ::std::vector< WaypointListElement >& getWaypointList () const;

    /**
     * Retrieves the value of the field "waypointList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "waypointList".
     */
    inline ::std::vector< WaypointListElement >& getWaypointListMutable ();

    /**
     * Sets the value of the member "waypointList".
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @param waypointList The value which will be set
     */
    inline void setWaypointList (const ::std::vector< WaypointListElement >& waypointList_);

    static const WaypointListUpdate &getDefaultInstance();

private:

    static const ::std::vector< WaypointListElement >& getWaypointListElementList_DefaultInstance ();

    inline void set_has_waypointList ();

    inline void clear_has_waypointList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< WaypointListElement > _waypointList;

};

/**
 * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
 */
class WaypointListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaypointListRegister ();

    /**
     * Copy constructor
     */
    inline  WaypointListRegister (const WaypointListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WaypointListRegister();

    /**
     * Assignment operator
     */
    inline WaypointListRegister& operator = (const WaypointListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaypointListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaypointListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaypointListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaypointListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WaypointListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the maneuver view information
 */
class ManeuverViewUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManeuverViewUpdate ();

    /**
     * Copy constructor
     */
    inline  ManeuverViewUpdate (const ManeuverViewUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ManeuverViewUpdate (const ManeuverView& maneuverView_);

    /**
     * Destructor
     */
    inline virtual  ~ManeuverViewUpdate();

    /**
     * Assignment operator
     */
    inline ManeuverViewUpdate& operator = (const ManeuverViewUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManeuverViewUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManeuverViewUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManeuverViewUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManeuverViewUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maneuverView"

    static const int kManeuverView = 0;

    /**
     * Clears the field "maneuverView".
     *
     * The field will be set to its default value. The hasManeuverView()
     * method will return false.
     */
    inline void clearManeuverView();

    /**
     * Checks whether the field "maneuverView" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManeuverView()). Otherwise it will return false.
     */
    inline bool hasManeuverView () const;

    /**
     * Returns the value of the member "maneuverView".
     *
     * Attribute provides the maneuver view information
     *
     * @return The value of the field "maneuverView"
     */
    inline const ManeuverView& getManeuverView () const;

    /**
     * Retrieves the value of the field "maneuverView" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "maneuverView".
     */
    inline ManeuverView& getManeuverViewMutable ();

    /**
     * Sets the value of the member "maneuverView".
     *
     * Attribute provides the maneuver view information
     *
     * @param maneuverView The value which will be set
     */
    inline void setManeuverView (const ManeuverView& maneuverView_);

    static const ManeuverViewUpdate &getDefaultInstance();

private:

    inline void set_has_maneuverView ();

    inline void clear_has_maneuverView ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ManeuverView _maneuverView;

};

/**
 * Attribute provides the maneuver view information
 */
class ManeuverViewRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManeuverViewRegister ();

    /**
     * Copy constructor
     */
    inline  ManeuverViewRegister (const ManeuverViewRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ManeuverViewRegister();

    /**
     * Assignment operator
     */
    inline ManeuverViewRegister& operator = (const ManeuverViewRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManeuverViewRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManeuverViewRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManeuverViewRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManeuverViewRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ManeuverViewRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the carsorPosition in the intersection map
 */
class IntersectionMapCarsorPositionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapCarsorPositionUpdate ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapCarsorPositionUpdate (const IntersectionMapCarsorPositionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IntersectionMapCarsorPositionUpdate (const IntersectionMapCarsorPosition& intersectionMapCarsorPosition_);

    /**
     * Destructor
     */
    inline virtual  ~IntersectionMapCarsorPositionUpdate();

    /**
     * Assignment operator
     */
    inline IntersectionMapCarsorPositionUpdate& operator = (const IntersectionMapCarsorPositionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapCarsorPositionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapCarsorPositionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapCarsorPositionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapCarsorPositionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "intersectionMapCarsorPosition"

    static const int kIntersectionMapCarsorPosition = 0;

    /**
     * Clears the field "intersectionMapCarsorPosition".
     *
     * The field will be set to its default value. The hasIntersectionMapCarsorPosition()
     * method will return false.
     */
    inline void clearIntersectionMapCarsorPosition();

    /**
     * Checks whether the field "intersectionMapCarsorPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIntersectionMapCarsorPosition()). Otherwise it will return false.
     */
    inline bool hasIntersectionMapCarsorPosition () const;

    /**
     * Returns the value of the member "intersectionMapCarsorPosition".
     *
     * Attribute provides the carsorPosition in the intersection map
     *
     * @return The value of the field "intersectionMapCarsorPosition"
     */
    inline const IntersectionMapCarsorPosition& getIntersectionMapCarsorPosition () const;

    /**
     * Retrieves the value of the field "intersectionMapCarsorPosition" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "intersectionMapCarsorPosition".
     */
    inline IntersectionMapCarsorPosition& getIntersectionMapCarsorPositionMutable ();

    /**
     * Sets the value of the member "intersectionMapCarsorPosition".
     *
     * Attribute provides the carsorPosition in the intersection map
     *
     * @param intersectionMapCarsorPosition The value which will be set
     */
    inline void setIntersectionMapCarsorPosition (const IntersectionMapCarsorPosition& intersectionMapCarsorPosition_);

    static const IntersectionMapCarsorPositionUpdate &getDefaultInstance();

private:

    inline void set_has_intersectionMapCarsorPosition ();

    inline void clear_has_intersectionMapCarsorPosition ();

    uint32 _has_bits_[ (1 + 31) / 32];

    IntersectionMapCarsorPosition _intersectionMapCarsorPosition;

};

/**
 * Attribute provides the carsorPosition in the intersection map
 */
class IntersectionMapCarsorPositionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapCarsorPositionRegister ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapCarsorPositionRegister (const IntersectionMapCarsorPositionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IntersectionMapCarsorPositionRegister();

    /**
     * Assignment operator
     */
    inline IntersectionMapCarsorPositionRegister& operator = (const IntersectionMapCarsorPositionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapCarsorPositionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapCarsorPositionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapCarsorPositionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapCarsorPositionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IntersectionMapCarsorPositionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the Speed limit details
 */
class SpeedLimitUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLimitUpdate ();

    /**
     * Copy constructor
     */
    inline  SpeedLimitUpdate (const SpeedLimitUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLimitUpdate (const SpeedLimit& speedLimit_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLimitUpdate();

    /**
     * Assignment operator
     */
    inline SpeedLimitUpdate& operator = (const SpeedLimitUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLimitUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLimitUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLimitUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLimitUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "speedLimit"

    static const int kSpeedLimit = 0;

    /**
     * Clears the field "speedLimit".
     *
     * The field will be set to its default value. The hasSpeedLimit()
     * method will return false.
     */
    inline void clearSpeedLimit();

    /**
     * Checks whether the field "speedLimit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLimit()). Otherwise it will return false.
     */
    inline bool hasSpeedLimit () const;

    /**
     * Returns the value of the member "speedLimit".
     *
     * Attribute provides the Speed limit details
     *
     * @return The value of the field "speedLimit"
     */
    inline const SpeedLimit& getSpeedLimit () const;

    /**
     * Retrieves the value of the field "speedLimit" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "speedLimit".
     */
    inline SpeedLimit& getSpeedLimitMutable ();

    /**
     * Sets the value of the member "speedLimit".
     *
     * Attribute provides the Speed limit details
     *
     * @param speedLimit The value which will be set
     */
    inline void setSpeedLimit (const SpeedLimit& speedLimit_);

    static const SpeedLimitUpdate &getDefaultInstance();

private:

    inline void set_has_speedLimit ();

    inline void clear_has_speedLimit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SpeedLimit _speedLimit;

};

/**
 * Attribute provides the Speed limit details
 */
class SpeedLimitRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLimitRegister ();

    /**
     * Copy constructor
     */
    inline  SpeedLimitRegister (const SpeedLimitRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpeedLimitRegister();

    /**
     * Assignment operator
     */
    inline SpeedLimitRegister& operator = (const SpeedLimitRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLimitRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLimitRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLimitRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLimitRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpeedLimitRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Indicates traffic/speed controlled areas
 */
class TrafficEnforcementUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficEnforcementUpdate ();

    /**
     * Copy constructor
     */
    inline  TrafficEnforcementUpdate (const TrafficEnforcementUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TrafficEnforcementUpdate (const TrafficEnforcement& trafficEnforcement_);

    /**
     * Destructor
     */
    inline virtual  ~TrafficEnforcementUpdate();

    /**
     * Assignment operator
     */
    inline TrafficEnforcementUpdate& operator = (const TrafficEnforcementUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficEnforcementUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficEnforcementUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficEnforcementUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficEnforcementUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "trafficEnforcement"

    static const int kTrafficEnforcement = 0;

    /**
     * Clears the field "trafficEnforcement".
     *
     * The field will be set to its default value. The hasTrafficEnforcement()
     * method will return false.
     */
    inline void clearTrafficEnforcement();

    /**
     * Checks whether the field "trafficEnforcement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficEnforcement()). Otherwise it will return false.
     */
    inline bool hasTrafficEnforcement () const;

    /**
     * Returns the value of the member "trafficEnforcement".
     *
     * Indicates traffic/speed controlled areas
     *
     * @return The value of the field "trafficEnforcement"
     */
    inline const TrafficEnforcement& getTrafficEnforcement () const;

    /**
     * Retrieves the value of the field "trafficEnforcement" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "trafficEnforcement".
     */
    inline TrafficEnforcement& getTrafficEnforcementMutable ();

    /**
     * Sets the value of the member "trafficEnforcement".
     *
     * Indicates traffic/speed controlled areas
     *
     * @param trafficEnforcement The value which will be set
     */
    inline void setTrafficEnforcement (const TrafficEnforcement& trafficEnforcement_);

    static const TrafficEnforcementUpdate &getDefaultInstance();

private:

    inline void set_has_trafficEnforcement ();

    inline void clear_has_trafficEnforcement ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TrafficEnforcement _trafficEnforcement;

};

/**
 * Indicates traffic/speed controlled areas
 */
class TrafficEnforcementRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficEnforcementRegister ();

    /**
     * Copy constructor
     */
    inline  TrafficEnforcementRegister (const TrafficEnforcementRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TrafficEnforcementRegister();

    /**
     * Assignment operator
     */
    inline TrafficEnforcementRegister& operator = (const TrafficEnforcementRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficEnforcementRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficEnforcementRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficEnforcementRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficEnforcementRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TrafficEnforcementRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the Maneuver details
 */
class NextManeuverDetailsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextManeuverDetailsUpdate ();

    /**
     * Copy constructor
     */
    inline  NextManeuverDetailsUpdate (const NextManeuverDetailsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NextManeuverDetailsUpdate (const NextManeuverDetails& nextManeuverDetails_);

    /**
     * Destructor
     */
    inline virtual  ~NextManeuverDetailsUpdate();

    /**
     * Assignment operator
     */
    inline NextManeuverDetailsUpdate& operator = (const NextManeuverDetailsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextManeuverDetailsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextManeuverDetailsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextManeuverDetailsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextManeuverDetailsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nextManeuverDetails"

    static const int kNextManeuverDetails = 0;

    /**
     * Clears the field "nextManeuverDetails".
     *
     * The field will be set to its default value. The hasNextManeuverDetails()
     * method will return false.
     */
    inline void clearNextManeuverDetails();

    /**
     * Checks whether the field "nextManeuverDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextManeuverDetails()). Otherwise it will return false.
     */
    inline bool hasNextManeuverDetails () const;

    /**
     * Returns the value of the member "nextManeuverDetails".
     *
     * Attribute provides the Maneuver details
     *
     * @return The value of the field "nextManeuverDetails"
     */
    inline const NextManeuverDetails& getNextManeuverDetails () const;

    /**
     * Retrieves the value of the field "nextManeuverDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "nextManeuverDetails".
     */
    inline NextManeuverDetails& getNextManeuverDetailsMutable ();

    /**
     * Sets the value of the member "nextManeuverDetails".
     *
     * Attribute provides the Maneuver details
     *
     * @param nextManeuverDetails The value which will be set
     */
    inline void setNextManeuverDetails (const NextManeuverDetails& nextManeuverDetails_);

    static const NextManeuverDetailsUpdate &getDefaultInstance();

private:

    inline void set_has_nextManeuverDetails ();

    inline void clear_has_nextManeuverDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    NextManeuverDetails _nextManeuverDetails;

};

/**
 * Attribute provides the Maneuver details
 */
class NextManeuverDetailsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextManeuverDetailsRegister ();

    /**
     * Copy constructor
     */
    inline  NextManeuverDetailsRegister (const NextManeuverDetailsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NextManeuverDetailsRegister();

    /**
     * Assignment operator
     */
    inline NextManeuverDetailsRegister& operator = (const NextManeuverDetailsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextManeuverDetailsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextManeuverDetailsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextManeuverDetailsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextManeuverDetailsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NextManeuverDetailsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the Lane recommendation list
 */
class LaneRecommendationListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LaneRecommendationListUpdate ();

    /**
     * Copy constructor
     */
    inline  LaneRecommendationListUpdate (const LaneRecommendationListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LaneRecommendationListUpdate (const ::std::vector< LaneRecommendation >& laneRecommendationList_);

    /**
     * Destructor
     */
    inline virtual  ~LaneRecommendationListUpdate();

    /**
     * Assignment operator
     */
    inline LaneRecommendationListUpdate& operator = (const LaneRecommendationListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LaneRecommendationListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LaneRecommendationListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LaneRecommendationListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LaneRecommendationListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "laneRecommendationList"

    static const int kLaneRecommendationList = 0;

    /**
     * Clears the field "laneRecommendationList".
     *
     * The field will be set to its default value. The hasLaneRecommendationList()
     * method will return false.
     */
    inline void clearLaneRecommendationList();

    /**
     * Checks whether the field "laneRecommendationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLaneRecommendationList()). Otherwise it will return false.
     */
    inline bool hasLaneRecommendationList () const;

    /**
     * Returns the value of the member "laneRecommendationList".
     *
     * Attribute provides the Lane recommendation list
     *
     * @return The value of the field "laneRecommendationList"
     */
    inline const ::std::vector< LaneRecommendation >& getLaneRecommendationList () const;

    /**
     * Retrieves the value of the field "laneRecommendationList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "laneRecommendationList".
     */
    inline ::std::vector< LaneRecommendation >& getLaneRecommendationListMutable ();

    /**
     * Sets the value of the member "laneRecommendationList".
     *
     * Attribute provides the Lane recommendation list
     *
     * @param laneRecommendationList The value which will be set
     */
    inline void setLaneRecommendationList (const ::std::vector< LaneRecommendation >& laneRecommendationList_);

    static const LaneRecommendationListUpdate &getDefaultInstance();

private:

    static const ::std::vector< LaneRecommendation >& getLaneRecommendationList_DefaultInstance ();

    inline void set_has_laneRecommendationList ();

    inline void clear_has_laneRecommendationList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< LaneRecommendation > _laneRecommendationList;

};

/**
 * Attribute provides the Lane recommendation list
 */
class LaneRecommendationListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LaneRecommendationListRegister ();

    /**
     * Copy constructor
     */
    inline  LaneRecommendationListRegister (const LaneRecommendationListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LaneRecommendationListRegister();

    /**
     * Assignment operator
     */
    inline LaneRecommendationListRegister& operator = (const LaneRecommendationListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LaneRecommendationListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LaneRecommendationListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LaneRecommendationListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LaneRecommendationListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LaneRecommendationListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides the Arrival infos array
 */
class ArrivalInformationListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ArrivalInformationListUpdate ();

    /**
     * Copy constructor
     */
    inline  ArrivalInformationListUpdate (const ArrivalInformationListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ArrivalInformationListUpdate (const ::std::vector< ArrivalInformation >& arrivalInformationList_);

    /**
     * Destructor
     */
    inline virtual  ~ArrivalInformationListUpdate();

    /**
     * Assignment operator
     */
    inline ArrivalInformationListUpdate& operator = (const ArrivalInformationListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ArrivalInformationListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ArrivalInformationListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ArrivalInformationListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ArrivalInformationListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arrivalInformationList"

    static const int kArrivalInformationList = 0;

    /**
     * Clears the field "arrivalInformationList".
     *
     * The field will be set to its default value. The hasArrivalInformationList()
     * method will return false.
     */
    inline void clearArrivalInformationList();

    /**
     * Checks whether the field "arrivalInformationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArrivalInformationList()). Otherwise it will return false.
     */
    inline bool hasArrivalInformationList () const;

    /**
     * Returns the value of the member "arrivalInformationList".
     *
     * Attribute provides the Arrival infos array
     *
     * @return The value of the field "arrivalInformationList"
     */
    inline const ::std::vector< ArrivalInformation >& getArrivalInformationList () const;

    /**
     * Retrieves the value of the field "arrivalInformationList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arrivalInformationList".
     */
    inline ::std::vector< ArrivalInformation >& getArrivalInformationListMutable ();

    /**
     * Sets the value of the member "arrivalInformationList".
     *
     * Attribute provides the Arrival infos array
     *
     * @param arrivalInformationList The value which will be set
     */
    inline void setArrivalInformationList (const ::std::vector< ArrivalInformation >& arrivalInformationList_);

    static const ArrivalInformationListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ArrivalInformation >& getArrivalInformationList_DefaultInstance ();

    inline void set_has_arrivalInformationList ();

    inline void clear_has_arrivalInformationList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ArrivalInformation > _arrivalInformationList;

};

/**
 * Attribute provides the Arrival infos array
 */
class ArrivalInformationListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ArrivalInformationListRegister ();

    /**
     * Copy constructor
     */
    inline  ArrivalInformationListRegister (const ArrivalInformationListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ArrivalInformationListRegister();

    /**
     * Assignment operator
     */
    inline ArrivalInformationListRegister& operator = (const ArrivalInformationListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ArrivalInformationListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ArrivalInformationListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ArrivalInformationListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ArrivalInformationListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ArrivalInformationListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides intersection map information for cluster
 */
class IntersectionMapUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapUpdate ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapUpdate (const IntersectionMapUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IntersectionMapUpdate (const IntersectionMap& intersectionMap_);

    /**
     * Destructor
     */
    inline virtual  ~IntersectionMapUpdate();

    /**
     * Assignment operator
     */
    inline IntersectionMapUpdate& operator = (const IntersectionMapUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "intersectionMap"

    static const int kIntersectionMap = 0;

    /**
     * Clears the field "intersectionMap".
     *
     * The field will be set to its default value. The hasIntersectionMap()
     * method will return false.
     */
    inline void clearIntersectionMap();

    /**
     * Checks whether the field "intersectionMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIntersectionMap()). Otherwise it will return false.
     */
    inline bool hasIntersectionMap () const;

    /**
     * Returns the value of the member "intersectionMap".
     *
     * Attribute provides intersection map information for cluster
     *
     * @return The value of the field "intersectionMap"
     */
    inline const IntersectionMap& getIntersectionMap () const;

    /**
     * Retrieves the value of the field "intersectionMap" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "intersectionMap".
     */
    inline IntersectionMap& getIntersectionMapMutable ();

    /**
     * Sets the value of the member "intersectionMap".
     *
     * Attribute provides intersection map information for cluster
     *
     * @param intersectionMap The value which will be set
     */
    inline void setIntersectionMap (const IntersectionMap& intersectionMap_);

    static const IntersectionMapUpdate &getDefaultInstance();

private:

    inline void set_has_intersectionMap ();

    inline void clear_has_intersectionMap ();

    uint32 _has_bits_[ (1 + 31) / 32];

    IntersectionMap _intersectionMap;

};

/**
 * Attribute provides intersection map information for cluster
 */
class IntersectionMapRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IntersectionMapRegister ();

    /**
     * Copy constructor
     */
    inline  IntersectionMapRegister (const IntersectionMapRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IntersectionMapRegister();

    /**
     * Assignment operator
     */
    inline IntersectionMapRegister& operator = (const IntersectionMapRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntersectionMapRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntersectionMapRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntersectionMapRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntersectionMapRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IntersectionMapRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
 */
class IsAddressBookChangedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsAddressBookChangedUpdate ();

    /**
     * Copy constructor
     */
    inline  IsAddressBookChangedUpdate (const IsAddressBookChangedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IsAddressBookChangedUpdate (bool isAddressBookChanged_);

    /**
     * Destructor
     */
    inline virtual  ~IsAddressBookChangedUpdate();

    /**
     * Assignment operator
     */
    inline IsAddressBookChangedUpdate& operator = (const IsAddressBookChangedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsAddressBookChangedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsAddressBookChangedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsAddressBookChangedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsAddressBookChangedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isAddressBookChanged"

    static const int kIsAddressBookChanged = 0;

    /**
     * Clears the field "isAddressBookChanged".
     *
     * The field will be set to its default value. The hasIsAddressBookChanged()
     * method will return false.
     */
    inline void clearIsAddressBookChanged();

    /**
     * Checks whether the field "isAddressBookChanged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAddressBookChanged()). Otherwise it will return false.
     */
    inline bool hasIsAddressBookChanged () const;

    /**
     * Returns the value of the member "isAddressBookChanged".
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     *
     * @return The value of the field "isAddressBookChanged"
     */
    inline bool getIsAddressBookChanged () const;

    /**
     * Sets the value of the member "isAddressBookChanged".
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     *
     * @param isAddressBookChanged The value which will be set
     */
    inline void setIsAddressBookChanged (bool isAddressBookChanged_);

    static const IsAddressBookChangedUpdate &getDefaultInstance();

private:

    inline void set_has_isAddressBookChanged ();

    inline void clear_has_isAddressBookChanged ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isAddressBookChanged;

};

/**
 * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
 */
class IsAddressBookChangedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsAddressBookChangedRegister ();

    /**
     * Copy constructor
     */
    inline  IsAddressBookChangedRegister (const IsAddressBookChangedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IsAddressBookChangedRegister();

    /**
     * Assignment operator
     */
    inline IsAddressBookChangedRegister& operator = (const IsAddressBookChangedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsAddressBookChangedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsAddressBookChangedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsAddressBookChangedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsAddressBookChangedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IsAddressBookChangedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides info if max allowed entries stored in addressbook
 */
class IsMaxAllowedAddressBookEntriesStoredUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsMaxAllowedAddressBookEntriesStoredUpdate ();

    /**
     * Copy constructor
     */
    inline  IsMaxAllowedAddressBookEntriesStoredUpdate (const IsMaxAllowedAddressBookEntriesStoredUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IsMaxAllowedAddressBookEntriesStoredUpdate (bool isMaxAllowedAddressBookEntriesStored_);

    /**
     * Destructor
     */
    inline virtual  ~IsMaxAllowedAddressBookEntriesStoredUpdate();

    /**
     * Assignment operator
     */
    inline IsMaxAllowedAddressBookEntriesStoredUpdate& operator = (const IsMaxAllowedAddressBookEntriesStoredUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsMaxAllowedAddressBookEntriesStoredUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsMaxAllowedAddressBookEntriesStoredUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsMaxAllowedAddressBookEntriesStoredUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsMaxAllowedAddressBookEntriesStoredUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isMaxAllowedAddressBookEntriesStored"

    static const int kIsMaxAllowedAddressBookEntriesStored = 0;

    /**
     * Clears the field "isMaxAllowedAddressBookEntriesStored".
     *
     * The field will be set to its default value. The hasIsMaxAllowedAddressBookEntriesStored()
     * method will return false.
     */
    inline void clearIsMaxAllowedAddressBookEntriesStored();

    /**
     * Checks whether the field "isMaxAllowedAddressBookEntriesStored" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMaxAllowedAddressBookEntriesStored()). Otherwise it will return false.
     */
    inline bool hasIsMaxAllowedAddressBookEntriesStored () const;

    /**
     * Returns the value of the member "isMaxAllowedAddressBookEntriesStored".
     *
     * Attribute provides info if max allowed entries stored in addressbook
     *
     * @return The value of the field "isMaxAllowedAddressBookEntriesStored"
     */
    inline bool getIsMaxAllowedAddressBookEntriesStored () const;

    /**
     * Sets the value of the member "isMaxAllowedAddressBookEntriesStored".
     *
     * Attribute provides info if max allowed entries stored in addressbook
     *
     * @param isMaxAllowedAddressBookEntriesStored The value which will be set
     */
    inline void setIsMaxAllowedAddressBookEntriesStored (bool isMaxAllowedAddressBookEntriesStored_);

    static const IsMaxAllowedAddressBookEntriesStoredUpdate &getDefaultInstance();

private:

    inline void set_has_isMaxAllowedAddressBookEntriesStored ();

    inline void clear_has_isMaxAllowedAddressBookEntriesStored ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isMaxAllowedAddressBookEntriesStored;

};

/**
 * Attribute provides info if max allowed entries stored in addressbook
 */
class IsMaxAllowedAddressBookEntriesStoredRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsMaxAllowedAddressBookEntriesStoredRegister ();

    /**
     * Copy constructor
     */
    inline  IsMaxAllowedAddressBookEntriesStoredRegister (const IsMaxAllowedAddressBookEntriesStoredRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IsMaxAllowedAddressBookEntriesStoredRegister();

    /**
     * Assignment operator
     */
    inline IsMaxAllowedAddressBookEntriesStoredRegister& operator = (const IsMaxAllowedAddressBookEntriesStoredRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsMaxAllowedAddressBookEntriesStoredRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsMaxAllowedAddressBookEntriesStoredRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsMaxAllowedAddressBookEntriesStoredRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsMaxAllowedAddressBookEntriesStoredRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IsMaxAllowedAddressBookEntriesStoredRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
 */
class IsLastDestinationListChangedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsLastDestinationListChangedUpdate ();

    /**
     * Copy constructor
     */
    inline  IsLastDestinationListChangedUpdate (const IsLastDestinationListChangedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IsLastDestinationListChangedUpdate (bool isLastDestinationListChanged_);

    /**
     * Destructor
     */
    inline virtual  ~IsLastDestinationListChangedUpdate();

    /**
     * Assignment operator
     */
    inline IsLastDestinationListChangedUpdate& operator = (const IsLastDestinationListChangedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsLastDestinationListChangedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsLastDestinationListChangedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsLastDestinationListChangedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsLastDestinationListChangedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isLastDestinationListChanged"

    static const int kIsLastDestinationListChanged = 0;

    /**
     * Clears the field "isLastDestinationListChanged".
     *
     * The field will be set to its default value. The hasIsLastDestinationListChanged()
     * method will return false.
     */
    inline void clearIsLastDestinationListChanged();

    /**
     * Checks whether the field "isLastDestinationListChanged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLastDestinationListChanged()). Otherwise it will return false.
     */
    inline bool hasIsLastDestinationListChanged () const;

    /**
     * Returns the value of the member "isLastDestinationListChanged".
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     *
     * @return The value of the field "isLastDestinationListChanged"
     */
    inline bool getIsLastDestinationListChanged () const;

    /**
     * Sets the value of the member "isLastDestinationListChanged".
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     *
     * @param isLastDestinationListChanged The value which will be set
     */
    inline void setIsLastDestinationListChanged (bool isLastDestinationListChanged_);

    static const IsLastDestinationListChangedUpdate &getDefaultInstance();

private:

    inline void set_has_isLastDestinationListChanged ();

    inline void clear_has_isLastDestinationListChanged ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isLastDestinationListChanged;

};

/**
 * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
 */
class IsLastDestinationListChangedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsLastDestinationListChangedRegister ();

    /**
     * Copy constructor
     */
    inline  IsLastDestinationListChangedRegister (const IsLastDestinationListChangedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IsLastDestinationListChangedRegister();

    /**
     * Assignment operator
     */
    inline IsLastDestinationListChangedRegister& operator = (const IsLastDestinationListChangedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsLastDestinationListChangedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsLastDestinationListChangedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsLastDestinationListChangedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsLastDestinationListChangedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IsLastDestinationListChangedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides voice guidance status
 */
class IsVoiceGuidanceActiveUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsVoiceGuidanceActiveUpdate ();

    /**
     * Copy constructor
     */
    inline  IsVoiceGuidanceActiveUpdate (const IsVoiceGuidanceActiveUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IsVoiceGuidanceActiveUpdate (bool isVoiceGuidanceActive_);

    /**
     * Destructor
     */
    inline virtual  ~IsVoiceGuidanceActiveUpdate();

    /**
     * Assignment operator
     */
    inline IsVoiceGuidanceActiveUpdate& operator = (const IsVoiceGuidanceActiveUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsVoiceGuidanceActiveUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsVoiceGuidanceActiveUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsVoiceGuidanceActiveUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsVoiceGuidanceActiveUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isVoiceGuidanceActive"

    static const int kIsVoiceGuidanceActive = 0;

    /**
     * Clears the field "isVoiceGuidanceActive".
     *
     * The field will be set to its default value. The hasIsVoiceGuidanceActive()
     * method will return false.
     */
    inline void clearIsVoiceGuidanceActive();

    /**
     * Checks whether the field "isVoiceGuidanceActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsVoiceGuidanceActive()). Otherwise it will return false.
     */
    inline bool hasIsVoiceGuidanceActive () const;

    /**
     * Returns the value of the member "isVoiceGuidanceActive".
     *
     * Attribute provides voice guidance status
     *
     * @return The value of the field "isVoiceGuidanceActive"
     */
    inline bool getIsVoiceGuidanceActive () const;

    /**
     * Sets the value of the member "isVoiceGuidanceActive".
     *
     * Attribute provides voice guidance status
     *
     * @param isVoiceGuidanceActive The value which will be set
     */
    inline void setIsVoiceGuidanceActive (bool isVoiceGuidanceActive_);

    static const IsVoiceGuidanceActiveUpdate &getDefaultInstance();

private:

    inline void set_has_isVoiceGuidanceActive ();

    inline void clear_has_isVoiceGuidanceActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _isVoiceGuidanceActive;

};

/**
 * Attribute provides voice guidance status
 */
class IsVoiceGuidanceActiveRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsVoiceGuidanceActiveRegister ();

    /**
     * Copy constructor
     */
    inline  IsVoiceGuidanceActiveRegister (const IsVoiceGuidanceActiveRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IsVoiceGuidanceActiveRegister();

    /**
     * Assignment operator
     */
    inline IsVoiceGuidanceActiveRegister& operator = (const IsVoiceGuidanceActiveRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsVoiceGuidanceActiveRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsVoiceGuidanceActiveRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsVoiceGuidanceActiveRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsVoiceGuidanceActiveRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IsVoiceGuidanceActiveRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
class SdsVoiceTagWithOptionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate (const SdsVoiceTagWithOptionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsVoiceTagWithOptionsUpdate (const SDSVoiceTagId& sdsVoiceTagWithOptions_);

    /**
     * Destructor
     */
    inline virtual  ~SdsVoiceTagWithOptionsUpdate();

    /**
     * Assignment operator
     */
    inline SdsVoiceTagWithOptionsUpdate& operator = (const SdsVoiceTagWithOptionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsVoiceTagWithOptionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsVoiceTagWithOptions"

    static const int kSdsVoiceTagWithOptions = 0;

    /**
     * Clears the field "sdsVoiceTagWithOptions".
     *
     * The field will be set to its default value. The hasSdsVoiceTagWithOptions()
     * method will return false.
     */
    inline void clearSdsVoiceTagWithOptions();

    /**
     * Checks whether the field "sdsVoiceTagWithOptions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsVoiceTagWithOptions()). Otherwise it will return false.
     */
    inline bool hasSdsVoiceTagWithOptions () const;

    /**
     * Returns the value of the member "sdsVoiceTagWithOptions".
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @return The value of the field "sdsVoiceTagWithOptions"
     */
    inline const SDSVoiceTagId& getSdsVoiceTagWithOptions () const;

    /**
     * Retrieves the value of the field "sdsVoiceTagWithOptions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsVoiceTagWithOptions".
     */
    inline SDSVoiceTagId& getSdsVoiceTagWithOptionsMutable ();

    /**
     * Sets the value of the member "sdsVoiceTagWithOptions".
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @param sdsVoiceTagWithOptions The value which will be set
     */
    inline void setSdsVoiceTagWithOptions (const SDSVoiceTagId& sdsVoiceTagWithOptions_);

    static const SdsVoiceTagWithOptionsUpdate &getDefaultInstance();

private:

    inline void set_has_sdsVoiceTagWithOptions ();

    inline void clear_has_sdsVoiceTagWithOptions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    SDSVoiceTagId _sdsVoiceTagWithOptions;

};

/**
 * Attribute used as a request by Navgation to Create/Play/Delete voice tags
 */
class SdsVoiceTagWithOptionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsVoiceTagWithOptionsRegister ();

    /**
     * Copy constructor
     */
    inline  SdsVoiceTagWithOptionsRegister (const SdsVoiceTagWithOptionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsVoiceTagWithOptionsRegister();

    /**
     * Assignment operator
     */
    inline SdsVoiceTagWithOptionsRegister& operator = (const SdsVoiceTagWithOptionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsVoiceTagWithOptionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsVoiceTagWithOptionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsVoiceTagWithOptionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsVoiceTagWithOptionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsVoiceTagWithOptionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides traffic message count
 */
class TrafficMessagesCountUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficMessagesCountUpdate ();

    /**
     * Copy constructor
     */
    inline  TrafficMessagesCountUpdate (const TrafficMessagesCountUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TrafficMessagesCountUpdate (uint8 trafficMessagesCount_);

    /**
     * Destructor
     */
    inline virtual  ~TrafficMessagesCountUpdate();

    /**
     * Assignment operator
     */
    inline TrafficMessagesCountUpdate& operator = (const TrafficMessagesCountUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficMessagesCountUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficMessagesCountUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficMessagesCountUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficMessagesCountUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "trafficMessagesCount"

    static const int kTrafficMessagesCount = 0;

    /**
     * Clears the field "trafficMessagesCount".
     *
     * The field will be set to its default value. The hasTrafficMessagesCount()
     * method will return false.
     */
    inline void clearTrafficMessagesCount();

    /**
     * Checks whether the field "trafficMessagesCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficMessagesCount()). Otherwise it will return false.
     */
    inline bool hasTrafficMessagesCount () const;

    /**
     * Returns the value of the member "trafficMessagesCount".
     *
     * Attribute provides traffic message count
     *
     * @return The value of the field "trafficMessagesCount"
     */
    inline uint8 getTrafficMessagesCount () const;

    /**
     * Sets the value of the member "trafficMessagesCount".
     *
     * Attribute provides traffic message count
     *
     * @param trafficMessagesCount The value which will be set
     */
    inline void setTrafficMessagesCount (uint8 trafficMessagesCount_);

    static const TrafficMessagesCountUpdate &getDefaultInstance();

private:

    inline void set_has_trafficMessagesCount ();

    inline void clear_has_trafficMessagesCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _trafficMessagesCount;

};

/**
 * Attribute provides traffic message count
 */
class TrafficMessagesCountRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficMessagesCountRegister ();

    /**
     * Copy constructor
     */
    inline  TrafficMessagesCountRegister (const TrafficMessagesCountRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TrafficMessagesCountRegister();

    /**
     * Assignment operator
     */
    inline TrafficMessagesCountRegister& operator = (const TrafficMessagesCountRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficMessagesCountRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficMessagesCountRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficMessagesCountRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficMessagesCountRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TrafficMessagesCountRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides Traffic service reception status
 */
class TrafficServiceReceptionStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficServiceReceptionStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  TrafficServiceReceptionStatusUpdate (const TrafficServiceReceptionStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TrafficServiceReceptionStatusUpdate (const TrafficServiceReceptionStatus& trafficServiceReceptionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~TrafficServiceReceptionStatusUpdate();

    /**
     * Assignment operator
     */
    inline TrafficServiceReceptionStatusUpdate& operator = (const TrafficServiceReceptionStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficServiceReceptionStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficServiceReceptionStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficServiceReceptionStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficServiceReceptionStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "trafficServiceReceptionStatus"

    static const int kTrafficServiceReceptionStatus = 0;

    /**
     * Clears the field "trafficServiceReceptionStatus".
     *
     * The field will be set to its default value. The hasTrafficServiceReceptionStatus()
     * method will return false.
     */
    inline void clearTrafficServiceReceptionStatus();

    /**
     * Checks whether the field "trafficServiceReceptionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrafficServiceReceptionStatus()). Otherwise it will return false.
     */
    inline bool hasTrafficServiceReceptionStatus () const;

    /**
     * Returns the value of the member "trafficServiceReceptionStatus".
     *
     * Attribute provides Traffic service reception status
     *
     * @return The value of the field "trafficServiceReceptionStatus"
     */
    inline const TrafficServiceReceptionStatus& getTrafficServiceReceptionStatus () const;

    /**
     * Retrieves the value of the field "trafficServiceReceptionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "trafficServiceReceptionStatus".
     */
    inline TrafficServiceReceptionStatus& getTrafficServiceReceptionStatusMutable ();

    /**
     * Sets the value of the member "trafficServiceReceptionStatus".
     *
     * Attribute provides Traffic service reception status
     *
     * @param trafficServiceReceptionStatus The value which will be set
     */
    inline void setTrafficServiceReceptionStatus (const TrafficServiceReceptionStatus& trafficServiceReceptionStatus_);

    static const TrafficServiceReceptionStatusUpdate &getDefaultInstance();

private:

    inline void set_has_trafficServiceReceptionStatus ();

    inline void clear_has_trafficServiceReceptionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TrafficServiceReceptionStatus _trafficServiceReceptionStatus;

};

/**
 * Attribute provides Traffic service reception status
 */
class TrafficServiceReceptionStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrafficServiceReceptionStatusRegister ();

    /**
     * Copy constructor
     */
    inline  TrafficServiceReceptionStatusRegister (const TrafficServiceReceptionStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TrafficServiceReceptionStatusRegister();

    /**
     * Assignment operator
     */
    inline TrafficServiceReceptionStatusRegister& operator = (const TrafficServiceReceptionStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrafficServiceReceptionStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrafficServiceReceptionStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrafficServiceReceptionStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrafficServiceReceptionStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TrafficServiceReceptionStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides POI category shortcut names in current selected language
 */
class SdsPOICategoryShortcutsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsPOICategoryShortcutsUpdate ();

    /**
     * Copy constructor
     */
    inline  SdsPOICategoryShortcutsUpdate (const SdsPOICategoryShortcutsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SdsPOICategoryShortcutsUpdate (const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts_);

    /**
     * Destructor
     */
    inline virtual  ~SdsPOICategoryShortcutsUpdate();

    /**
     * Assignment operator
     */
    inline SdsPOICategoryShortcutsUpdate& operator = (const SdsPOICategoryShortcutsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsPOICategoryShortcutsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsPOICategoryShortcutsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsPOICategoryShortcutsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsPOICategoryShortcutsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sdsPOICategoryShortcuts"

    static const int kSdsPOICategoryShortcuts = 0;

    /**
     * Clears the field "sdsPOICategoryShortcuts".
     *
     * The field will be set to its default value. The hasSdsPOICategoryShortcuts()
     * method will return false.
     */
    inline void clearSdsPOICategoryShortcuts();

    /**
     * Checks whether the field "sdsPOICategoryShortcuts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSdsPOICategoryShortcuts()). Otherwise it will return false.
     */
    inline bool hasSdsPOICategoryShortcuts () const;

    /**
     * Returns the value of the member "sdsPOICategoryShortcuts".
     *
     * Attribute provides POI category shortcut names in current selected language
     *
     * @return The value of the field "sdsPOICategoryShortcuts"
     */
    inline const ::std::vector< PoiCategoryShortcut >& getSdsPOICategoryShortcuts () const;

    /**
     * Retrieves the value of the field "sdsPOICategoryShortcuts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sdsPOICategoryShortcuts".
     */
    inline ::std::vector< PoiCategoryShortcut >& getSdsPOICategoryShortcutsMutable ();

    /**
     * Sets the value of the member "sdsPOICategoryShortcuts".
     *
     * Attribute provides POI category shortcut names in current selected language
     *
     * @param sdsPOICategoryShortcuts The value which will be set
     */
    inline void setSdsPOICategoryShortcuts (const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts_);

    static const SdsPOICategoryShortcutsUpdate &getDefaultInstance();

private:

    static const ::std::vector< PoiCategoryShortcut >& getPoiCategoryShortcutList_DefaultInstance ();

    inline void set_has_sdsPOICategoryShortcuts ();

    inline void clear_has_sdsPOICategoryShortcuts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< PoiCategoryShortcut > _sdsPOICategoryShortcuts;

};

/**
 * Attribute provides POI category shortcut names in current selected language
 */
class SdsPOICategoryShortcutsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SdsPOICategoryShortcutsRegister ();

    /**
     * Copy constructor
     */
    inline  SdsPOICategoryShortcutsRegister (const SdsPOICategoryShortcutsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SdsPOICategoryShortcutsRegister();

    /**
     * Assignment operator
     */
    inline SdsPOICategoryShortcutsRegister& operator = (const SdsPOICategoryShortcutsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SdsPOICategoryShortcutsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SdsPOICategoryShortcutsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SdsPOICategoryShortcutsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SdsPOICategoryShortcutsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SdsPOICategoryShortcutsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides POI Category Shortcut Names in current selected language
 */
class MenuPoiCategoryShortcutsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MenuPoiCategoryShortcutsUpdate ();

    /**
     * Copy constructor
     */
    inline  MenuPoiCategoryShortcutsUpdate (const MenuPoiCategoryShortcutsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MenuPoiCategoryShortcutsUpdate (const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts_);

    /**
     * Destructor
     */
    inline virtual  ~MenuPoiCategoryShortcutsUpdate();

    /**
     * Assignment operator
     */
    inline MenuPoiCategoryShortcutsUpdate& operator = (const MenuPoiCategoryShortcutsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MenuPoiCategoryShortcutsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MenuPoiCategoryShortcutsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MenuPoiCategoryShortcutsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MenuPoiCategoryShortcutsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "menuPoiCategoryShortcuts"

    static const int kMenuPoiCategoryShortcuts = 0;

    /**
     * Clears the field "menuPoiCategoryShortcuts".
     *
     * The field will be set to its default value. The hasMenuPoiCategoryShortcuts()
     * method will return false.
     */
    inline void clearMenuPoiCategoryShortcuts();

    /**
     * Checks whether the field "menuPoiCategoryShortcuts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMenuPoiCategoryShortcuts()). Otherwise it will return false.
     */
    inline bool hasMenuPoiCategoryShortcuts () const;

    /**
     * Returns the value of the member "menuPoiCategoryShortcuts".
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     *
     * @return The value of the field "menuPoiCategoryShortcuts"
     */
    inline const ::std::vector< PoiCategoryShortcut >& getMenuPoiCategoryShortcuts () const;

    /**
     * Retrieves the value of the field "menuPoiCategoryShortcuts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "menuPoiCategoryShortcuts".
     */
    inline ::std::vector< PoiCategoryShortcut >& getMenuPoiCategoryShortcutsMutable ();

    /**
     * Sets the value of the member "menuPoiCategoryShortcuts".
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     *
     * @param menuPoiCategoryShortcuts The value which will be set
     */
    inline void setMenuPoiCategoryShortcuts (const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts_);

    static const MenuPoiCategoryShortcutsUpdate &getDefaultInstance();

private:

    static const ::std::vector< PoiCategoryShortcut >& getPoiCategoryShortcutList_DefaultInstance ();

    inline void set_has_menuPoiCategoryShortcuts ();

    inline void clear_has_menuPoiCategoryShortcuts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< PoiCategoryShortcut > _menuPoiCategoryShortcuts;

};

/**
 * Attribute provides POI Category Shortcut Names in current selected language
 */
class MenuPoiCategoryShortcutsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MenuPoiCategoryShortcutsRegister ();

    /**
     * Copy constructor
     */
    inline  MenuPoiCategoryShortcutsRegister (const MenuPoiCategoryShortcutsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MenuPoiCategoryShortcutsRegister();

    /**
     * Assignment operator
     */
    inline MenuPoiCategoryShortcutsRegister& operator = (const MenuPoiCategoryShortcutsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MenuPoiCategoryShortcutsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MenuPoiCategoryShortcutsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MenuPoiCategoryShortcutsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MenuPoiCategoryShortcutsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MenuPoiCategoryShortcutsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides trip replay status information
 */
class TripReplayStatusInfoUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TripReplayStatusInfoUpdate ();

    /**
     * Copy constructor
     */
    inline  TripReplayStatusInfoUpdate (const TripReplayStatusInfoUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TripReplayStatusInfoUpdate (const TripReplayStatusInfo& tripReplayStatusInfo_);

    /**
     * Destructor
     */
    inline virtual  ~TripReplayStatusInfoUpdate();

    /**
     * Assignment operator
     */
    inline TripReplayStatusInfoUpdate& operator = (const TripReplayStatusInfoUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TripReplayStatusInfoUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TripReplayStatusInfoUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TripReplayStatusInfoUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TripReplayStatusInfoUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tripReplayStatusInfo"

    static const int kTripReplayStatusInfo = 0;

    /**
     * Clears the field "tripReplayStatusInfo".
     *
     * The field will be set to its default value. The hasTripReplayStatusInfo()
     * method will return false.
     */
    inline void clearTripReplayStatusInfo();

    /**
     * Checks whether the field "tripReplayStatusInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTripReplayStatusInfo()). Otherwise it will return false.
     */
    inline bool hasTripReplayStatusInfo () const;

    /**
     * Returns the value of the member "tripReplayStatusInfo".
     *
     * Attribute provides trip replay status information
     *
     * @return The value of the field "tripReplayStatusInfo"
     */
    inline const TripReplayStatusInfo& getTripReplayStatusInfo () const;

    /**
     * Retrieves the value of the field "tripReplayStatusInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tripReplayStatusInfo".
     */
    inline TripReplayStatusInfo& getTripReplayStatusInfoMutable ();

    /**
     * Sets the value of the member "tripReplayStatusInfo".
     *
     * Attribute provides trip replay status information
     *
     * @param tripReplayStatusInfo The value which will be set
     */
    inline void setTripReplayStatusInfo (const TripReplayStatusInfo& tripReplayStatusInfo_);

    static const TripReplayStatusInfoUpdate &getDefaultInstance();

private:

    inline void set_has_tripReplayStatusInfo ();

    inline void clear_has_tripReplayStatusInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TripReplayStatusInfo _tripReplayStatusInfo;

};

/**
 * Attribute provides trip replay status information
 */
class TripReplayStatusInfoRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TripReplayStatusInfoRegister ();

    /**
     * Copy constructor
     */
    inline  TripReplayStatusInfoRegister (const TripReplayStatusInfoRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TripReplayStatusInfoRegister();

    /**
     * Assignment operator
     */
    inline TripReplayStatusInfoRegister& operator = (const TripReplayStatusInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TripReplayStatusInfoRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TripReplayStatusInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TripReplayStatusInfoRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TripReplayStatusInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TripReplayStatusInfoRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Attribute provides ETC status information
 */
class EtcStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EtcStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  EtcStatusUpdate (const EtcStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EtcStatusUpdate (ETCStatus etcStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EtcStatusUpdate();

    /**
     * Assignment operator
     */
    inline EtcStatusUpdate& operator = (const EtcStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EtcStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EtcStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EtcStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline b