/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICESTUB_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

class NavigationDataUpdateServiceStubDelegate;

class NavigationDataUpdateServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NavigationDataUpdateServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NavigationDataUpdateServiceStub (const std::string& portName);

    /**
     * Create an instance of the NavigationDataUpdateServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NavigationDataUpdateServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NavigationDataUpdateServiceStub();

    // property 'favoriteUpdateRegions'

    /**
     * The method onFavoriteUpdateRegionsGet() is called by ASF when a client
     * invokes the read method for the property 'favoriteUpdateRegions'. The
     * onFavoriteUpdateRegionsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     */
    virtual void onFavoriteUpdateRegionsGet(const ::boost::shared_ptr< FavoriteUpdateRegionsGet >& payload);

    /**
     * Sends back the update to a previous onFavoriteUpdateRegionsGet().
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     *
     * @param act Identifies a previous invocation of
     * onFavoriteUpdateRegionsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFavoriteUpdateRegionsGetUpdate(const FavoriteUpdateRegions& favoriteUpdateRegions, act_t act = 0);

    /**
     * Set the value of the property 'favoriteUpdateRegions' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     */
    void setFavoriteUpdateRegions(const FavoriteUpdateRegions& favoriteUpdateRegions);

    /**
     * Returns the current value of the property 'favoriteUpdateRegions'.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     */
    const FavoriteUpdateRegions& getFavoriteUpdateRegions() const;

    /**
     * Returns the current value of the property 'favoriteUpdateRegions' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendFavoriteUpdateRegionsUpdate() method.
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     */
    FavoriteUpdateRegions& getFavoriteUpdateRegionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFavoriteUpdateRegionsUpdate().
     *
     * <b>Documentation of 'favoriteUpdateRegions'</b>:
     *
     * Attribute provides current favorite update regions and its storage status.
     *        Storage status informs about the reason for changing the favorite update regions.
     */
    void sendFavoriteUpdateRegionsUpdate();

    // property 'installationStatus'

    /**
     * The method onInstallationStatusGet() is called by ASF when a client
     * invokes the read method for the property 'installationStatus'. The
     * onInstallationStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     */
    virtual void onInstallationStatusGet(const ::boost::shared_ptr< InstallationStatusGet >& payload);

    /**
     * Sends back the update to a previous onInstallationStatusGet().
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     *
     * @param act Identifies a previous invocation of
     * onInstallationStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendInstallationStatusGetUpdate(const InstallationStatus& installationStatus, act_t act = 0);

    /**
     * Set the value of the property 'installationStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     */
    void setInstallationStatus(const InstallationStatus& installationStatus);

    /**
     * Returns the current value of the property 'installationStatus'.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     */
    const InstallationStatus& getInstallationStatus() const;

    /**
     * Returns the current value of the property 'installationStatus' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendInstallationStatusUpdate() method.
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     */
    InstallationStatus& getInstallationStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInstallationStatusUpdate().
     *
     * <b>Documentation of 'installationStatus'</b>:
     *
     * Attribute provides the installation status of a certain update region
     */
    void sendInstallationStatusUpdate();

    // property 'navDataStatus'

    /**
     * The method onNavDataStatusGet() is called by ASF when a client invokes
     * the read method for the property 'navDataStatus'. The
     * onNavDataStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     */
    virtual void onNavDataStatusGet(const ::boost::shared_ptr< NavDataStatusGet >& payload);

    /**
     * Sends back the update to a previous onNavDataStatusGet().
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     *
     * @param act Identifies a previous invocation of onNavDataStatusGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNavDataStatusGetUpdate(NavigationDataStatus navDataStatus, act_t act = 0);

    /**
     * Set the value of the property 'navDataStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     */
    void setNavDataStatus(NavigationDataStatus navDataStatus);

    /**
     * Returns the current value of the property 'navDataStatus'.
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     */
    NavigationDataStatus getNavDataStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNavDataStatusUpdate().
     *
     * <b>Documentation of 'navDataStatus'</b>:
     *
     * Attribute provides the navigation data status like UNKNOWN, OK,...
     */
    void sendNavDataStatusUpdate();

    // property 'navDataContext'

    /**
     * The method onNavDataContextGet() is called by ASF when a client invokes
     * the read method for the property 'navDataContext'. The
     * onNavDataContextGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     */
    virtual void onNavDataContextGet(const ::boost::shared_ptr< NavDataContextGet >& payload);

    /**
     * Sends back the update to a previous onNavDataContextGet().
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     *
     * @param act Identifies a previous invocation of onNavDataContextGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNavDataContextGetUpdate(const NavDataContext& navDataContext, act_t act = 0);

    /**
     * Set the value of the property 'navDataContext' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     */
    void setNavDataContext(const NavDataContext& navDataContext);

    /**
     * Returns the current value of the property 'navDataContext'.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     */
    const NavDataContext& getNavDataContext() const;

    /**
     * Returns the current value of the property 'navDataContext' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNavDataContextUpdate() method.
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     */
    NavDataContext& getNavDataContextMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNavDataContextUpdate().
     *
     * <b>Documentation of 'navDataContext'</b>:
     *
     * Attribute to get current NavData context (aka map context).
     *        It offers all products with their id's, space on ffs and their update regions.
     *        Also each update region with its own id's, space on ffs are part of the context.
     *        Furthermore the current version id for each product and region is shown.
     */
    void sendNavDataContextUpdate();

    // property 'navigationDataUpdateStatusInfo'

    /**
     * The method onNavigationDataUpdateStatusInfoGet() is called by ASF when
     * a client invokes the read method for the property
     * 'navigationDataUpdateStatusInfo'. The
     * onNavigationDataUpdateStatusInfoGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     */
    virtual void onNavigationDataUpdateStatusInfoGet(const ::boost::shared_ptr< NavigationDataUpdateStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous
     * onNavigationDataUpdateStatusInfoGet().
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     *
     * @param act Identifies a previous invocation of
     * onNavigationDataUpdateStatusInfoGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendNavigationDataUpdateStatusInfoGetUpdate(const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo, act_t act = 0);

    /**
     * Set the value of the property 'navigationDataUpdateStatusInfo' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     */
    void setNavigationDataUpdateStatusInfo(const NavigationDataUpdateStatusInfo& navigationDataUpdateStatusInfo);

    /**
     * Returns the current value of the property 'navigationDataUpdateStatusInfo'.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     */
    const NavigationDataUpdateStatusInfo& getNavigationDataUpdateStatusInfo() const;

    /**
     * Returns the current value of the property
     * 'navigationDataUpdateStatusInfo' as a mutable reference. If you change
     * the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendNavigationDataUpdateStatusInfoUpdate() method.
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     */
    NavigationDataUpdateStatusInfo& getNavigationDataUpdateStatusInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNavigationDataUpdateStatusInfoUpdate().
     *
     * <b>Documentation of 'navigationDataUpdateStatusInfo'</b>:
     *
     * Attribute to get current NavDataUpdateStatusInfo (status, progressValue, remainingTime)
     */
    void sendNavigationDataUpdateStatusInfoUpdate();

    // property 'catalogueStatus'

    /**
     * The method onCatalogueStatusGet() is called by ASF when a client
     * invokes the read method for the property 'catalogueStatus'. The
     * onCatalogueStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     */
    virtual void onCatalogueStatusGet(const ::boost::shared_ptr< CatalogueStatusGet >& payload);

    /**
     * Sends back the update to a previous onCatalogueStatusGet().
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     *
     * @param act Identifies a previous invocation of onCatalogueStatusGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCatalogueStatusGetUpdate(CatalogueStatus catalogueStatus, act_t act = 0);

    /**
     * Set the value of the property 'catalogueStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     */
    void setCatalogueStatus(CatalogueStatus catalogueStatus);

    /**
     * Returns the current value of the property 'catalogueStatus'.
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     */
    CatalogueStatus getCatalogueStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCatalogueStatusUpdate().
     *
     * <b>Documentation of 'catalogueStatus'</b>:
     *
     * Attribute to get current catalogue status
     */
    void sendCatalogueStatusUpdate();

    // property 'mapupdateExportStatus'

    /**
     * The method onMapupdateExportStatusGet() is called by ASF when a client
     * invokes the read method for the property 'mapupdateExportStatus'. The
     * onMapupdateExportStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     */
    virtual void onMapupdateExportStatusGet(const ::boost::shared_ptr< MapupdateExportStatusGet >& payload);

    /**
     * Sends back the update to a previous onMapupdateExportStatusGet().
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     *
     * @param act Identifies a previous invocation of
     * onMapupdateExportStatusGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapupdateExportStatusGetUpdate(MapupdateExportStatus mapupdateExportStatus, act_t act = 0);

    /**
     * Set the value of the property 'mapupdateExportStatus' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     */
    void setMapupdateExportStatus(MapupdateExportStatus mapupdateExportStatus);

    /**
     * Returns the current value of the property 'mapupdateExportStatus'.
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     */
    MapupdateExportStatus getMapupdateExportStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapupdateExportStatusUpdate().
     *
     * <b>Documentation of 'mapupdateExportStatus'</b>:
     *
     * Attribute to get mapdataExport Status
     */
    void sendMapupdateExportStatusUpdate();

    // property 'deviceInfos'

    /**
     * The method onDeviceInfosGet() is called by ASF when a client invokes
     * the read method for the property 'deviceInfos'. The onDeviceInfosGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     */
    virtual void onDeviceInfosGet(const ::boost::shared_ptr< DeviceInfosGet >& payload);

    /**
     * Sends back the update to a previous onDeviceInfosGet().
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     *
     * @param act Identifies a previous invocation of onDeviceInfosGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeviceInfosGetUpdate(const ::std::vector< DeviceInfo >& deviceInfos, act_t act = 0);

    /**
     * Set the value of the property 'deviceInfos' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     */
    void setDeviceInfos(const ::std::vector< DeviceInfo >& deviceInfos);

    /**
     * Returns the current value of the property 'deviceInfos'.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     */
    const ::std::vector< DeviceInfo >& getDeviceInfos() const;

    /**
     * Returns the current value of the property 'deviceInfos' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDeviceInfosUpdate() method.
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     */
    ::std::vector< DeviceInfo >& getDeviceInfosMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceInfosUpdate().
     *
     * <b>Documentation of 'deviceInfos'</b>:
     *
     * Attribute to get DeviceInfos Details
     */
    void sendDeviceInfosUpdate();

    // method 'DiagPerformFullUpdateViaUSB'

    /**
     * The method onDiagPerformFullUpdateViaUSB() is called by ASF when a
     * client invokes the method 'DiagPerformFullUpdateViaUSB'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendDiagPerformFullUpdateViaUSB() or
     * sendDiagPerformFullUpdateViaUSBError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'DiagPerformFullUpdateViaUSB'</b>:
     *
     * Diagnosis request full update via USB in Diagnostic mode
     *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDiagPerformFullUpdateViaUSBRequest (const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBRequest >& request) = 0;

    /**
     * The method sendDiagPerformFullUpdateViaUSBResponse() sends a response
     * of a previous method invocation of 'DiagPerformFullUpdateViaUSB' back
     * to the client.
     *
     * <b>Documentation of 'DiagPerformFullUpdateViaUSB'</b>:
     *
     * Diagnosis request full update via USB in Diagnostic mode
     *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
     *
     * @param ack If the meaning of "ack" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDiagPerformFullUpdateViaUSB(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDiagPerformFullUpdateViaUSBResponse (NavigationDataUpdateServiceAck ack, act_t act = 0);

    /**
     * The method sendDiagPerformFullUpdateViaUSBError() sends an error
     * response of a previous method invocation of
     * 'DiagPerformFullUpdateViaUSB' back to the client.
     *
     * <b>Documentation of 'DiagPerformFullUpdateViaUSB'</b>:
     *
     * Diagnosis request full update via USB in Diagnostic mode
     *       Response: Update result (SUCCESSFUL, FAILED, DECLINED)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDiagPerformFullUpdateViaUSB(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDiagPerformFullUpdateViaUSBError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getAvailableUpdates'

    /**
     * The method onGetAvailableUpdates() is called by ASF when a client
     * invokes the method 'getAvailableUpdates'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetAvailableUpdates() or sendGetAvailableUpdatesError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'getAvailableUpdates'</b>:
     *
     * Request to get a list of all available updates.
     *        For each update component one entry is contained if an update is available only.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAvailableUpdatesRequest (const ::boost::shared_ptr< GetAvailableUpdatesRequest >& request) = 0;

    /**
     * The method sendGetAvailableUpdatesResponse() sends a response of a
     * previous method invocation of 'getAvailableUpdates' back to the client.
     *
     * <b>Documentation of 'getAvailableUpdates'</b>:
     *
     * Request to get a list of all available updates.
     *        For each update component one entry is contained if an update is available only.
     *
     * @param availableUpdates If the meaning of "availableUpdates" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAvailableUpdates(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetAvailableUpdatesResponse (const AvailableUpdates& availableUpdates, act_t act = 0);

    /**
     * The method sendGetAvailableUpdatesError() sends an error response of a
     * previous method invocation of 'getAvailableUpdates' back to the client.
     *
     * <b>Documentation of 'getAvailableUpdates'</b>:
     *
     * Request to get a list of all available updates.
     *        For each update component one entry is contained if an update is available only.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetAvailableUpdates().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetAvailableUpdatesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'deleteUpdateComponent'

    /**
     * The method onDeleteUpdateComponent() is called by ASF when a client
     * invokes the method 'deleteUpdateComponent'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDeleteUpdateComponent() or sendDeleteUpdateComponentError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'deleteUpdateComponent'</b>:
     *
     * Request to remove an updateable component from the data.
     *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeleteUpdateComponentRequest (const ::boost::shared_ptr< DeleteUpdateComponentRequest >& request) = 0;

    /**
     * The method sendDeleteUpdateComponentResponse() sends a response of a
     * previous method invocation of 'deleteUpdateComponent' back to the
     * client.
     *
     * <b>Documentation of 'deleteUpdateComponent'</b>:
     *
     * Request to remove an updateable component from the data.
     *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeleteUpdateComponent(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeleteUpdateComponentResponse (DeleteUpdateComponentResult result, act_t act = 0);

    /**
     * The method sendDeleteUpdateComponentError() sends an error response of
     * a previous method invocation of 'deleteUpdateComponent' back to the
     * client.
     *
     * <b>Documentation of 'deleteUpdateComponent'</b>:
     *
     * Request to remove an updateable component from the data.
     *        The componentId refers to the componentId used in other all requests. It uniquely identifies the updatable component.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDeleteUpdateComponent(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeleteUpdateComponentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setFavoriteUpdateRegions'

    /**
     * The method onSetFavoriteUpdateRegions() is called by ASF when a client
     * invokes the method 'setFavoriteUpdateRegions'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetFavoriteUpdateRegions() or
     * sendSetFavoriteUpdateRegionsError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'setFavoriteUpdateRegions'</b>:
     *
     * Request to change the current favorite update regions (aka home regions).
     *        Usually the user can select a certain country as its favorite region on the HMI.
     *        Selected country can consists of one or more update regions. All update regions relates to the same product.
     *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetFavoriteUpdateRegionsRequest (const ::boost::shared_ptr< SetFavoriteUpdateRegionsRequest >& request) = 0;

    /**
     * The method sendSetFavoriteUpdateRegionsResponse() sends a response of a
     * previous method invocation of 'setFavoriteUpdateRegions' back to the
     * client.
     *
     * <b>Documentation of 'setFavoriteUpdateRegions'</b>:
     *
     * Request to change the current favorite update regions (aka home regions).
     *        Usually the user can select a certain country as its favorite region on the HMI.
     *        Selected country can consists of one or more update regions. All update regions relates to the same product.
     *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetFavoriteUpdateRegions(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFavoriteUpdateRegionsResponse (SetFavoriteUpdateRegionsResult result, act_t act = 0);

    /**
     * The method sendSetFavoriteUpdateRegionsError() sends an error response
     * of a previous method invocation of 'setFavoriteUpdateRegions' back to
     * the client.
     *
     * <b>Documentation of 'setFavoriteUpdateRegions'</b>:
     *
     * Request to change the current favorite update regions (aka home regions).
     *        Usually the user can select a certain country as its favorite region on the HMI.
     *        Selected country can consists of one or more update regions. All update regions relates to the same product.
     *        In case favorite updateRegions shall be deleted the list favoriteUpdateRegions is set to empty list.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetFavoriteUpdateRegions(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFavoriteUpdateRegionsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'clearFavoriteUpdateRegions'

    /**
     * The method onClearFavoriteUpdateRegions() is called by ASF when a
     * client invokes the method 'clearFavoriteUpdateRegions'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendClearFavoriteUpdateRegions() or
     * sendClearFavoriteUpdateRegionsError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'clearFavoriteUpdateRegions'</b>:
     *
     * Request to remove current favorite region setting.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearFavoriteUpdateRegionsRequest (const ::boost::shared_ptr< ClearFavoriteUpdateRegionsRequest >& request) = 0;

    /**
     * The method sendClearFavoriteUpdateRegionsResponse() sends a response of
     * a previous method invocation of 'clearFavoriteUpdateRegions' back to
     * the client.
     *
     * <b>Documentation of 'clearFavoriteUpdateRegions'</b>:
     *
     * Request to remove current favorite region setting.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClearFavoriteUpdateRegions(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendClearFavoriteUpdateRegionsResponse (ClearFavoriteUpdateRegionsResult result, act_t act = 0);

    /**
     * The method sendClearFavoriteUpdateRegionsError() sends an error
     * response of a previous method invocation of
     * 'clearFavoriteUpdateRegions' back to the client.
     *
     * <b>Documentation of 'clearFavoriteUpdateRegions'</b>:
     *
     * Request to remove current favorite region setting.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onClearFavoriteUpdateRegions(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendClearFavoriteUpdateRegionsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startFullUpdate'

    /**
     * The method onStartFullUpdate() is called by ASF when a client invokes
     * the method 'startFullUpdate'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStartFullUpdate() or sendStartFullUpdateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'startFullUpdate'</b>:
     *
     * Request to install a full navigation data update if USB full update data is available.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartFullUpdateRequest (const ::boost::shared_ptr< StartFullUpdateRequest >& request) = 0;

    /**
     * The method sendStartFullUpdateResponse() sends a response of a previous
     * method invocation of 'startFullUpdate' back to the client.
     *
     * <b>Documentation of 'startFullUpdate'</b>:
     *
     * Request to install a full navigation data update if USB full update data is available.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartFullUpdate(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartFullUpdateResponse (StartFullUpdateResult result, act_t act = 0);

    /**
     * The method sendStartFullUpdateError() sends an error response of a
     * previous method invocation of 'startFullUpdate' back to the client.
     *
     * <b>Documentation of 'startFullUpdate'</b>:
     *
     * Request to install a full navigation data update if USB full update data is available.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartFullUpdate(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartFullUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartMapDataExport'

    /**
     * The method onStartMapDataExport() is called by ASF when a client
     * invokes the method 'StartMapDataExport'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartMapDataExport() or sendStartMapDataExportError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'StartMapDataExport'</b>:
     *
     * Start MapData Export For A Device ID
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartMapDataExportRequest (const ::boost::shared_ptr< StartMapDataExportRequest >& request) = 0;

    /**
     * The method sendStartMapDataExportResponse() sends a response of a
     * previous method invocation of 'StartMapDataExport' back to the client.
     *
     * <b>Documentation of 'StartMapDataExport'</b>:
     *
     * Start MapData Export For A Device ID
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartMapDataExport(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartMapDataExportResponse (MapExportStartStatus result, act_t act = 0);

    /**
     * The method sendStartMapDataExportError() sends an error response of a
     * previous method invocation of 'StartMapDataExport' back to the client.
     *
     * <b>Documentation of 'StartMapDataExport'</b>:
     *
     * Start MapData Export For A Device ID
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartMapDataExport().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartMapDataExportError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    FavoriteUpdateRegionsUpdate _favoriteUpdateRegionsProperty;

    InstallationStatusUpdate _installationStatusProperty;

    NavDataStatusUpdate _navDataStatusProperty;

    NavDataContextUpdate _navDataContextProperty;

    NavigationDataUpdateStatusInfoUpdate _navigationDataUpdateStatusInfoProperty;

    CatalogueStatusUpdate _catalogueStatusProperty;

    MapupdateExportStatusUpdate _mapupdateExportStatusProperty;

    DeviceInfosUpdate _deviceInfosProperty;

    friend class NavigationDataUpdateServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONDATAUPDATESERVICESTUB_H
