/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceDBus.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceJson.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationDataUpdateService {

DEFINE_CLASS_LOGGER("/org/bosch/cm/navigation/org/bosch/cm/navigation/NavigationDataUpdateService", NavigationDataUpdateServiceProxy);

class NavigationDataUpdateServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NavigationDataUpdateServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxyShared = ::boost::static_pointer_cast< NavigationDataUpdateServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_favoriteUpdateRegions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FavoriteUpdateRegionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FavoriteUpdateRegionsError> payload = ::boost::static_pointer_cast<FavoriteUpdateRegionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FavoriteUpdateRegionsCallbackIF*) _callback)->onFavoriteUpdateRegionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FavoriteUpdateRegionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FavoriteUpdateRegionsUpdate> payload = ::boost::static_pointer_cast<FavoriteUpdateRegionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FavoriteUpdateRegionsCallbackIF*) _callback)->onFavoriteUpdateRegionsUpdate(proxyShared, payload);
                        proxyShared->_favoriteUpdateRegions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_installationStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InstallationStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InstallationStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InstallationStatusError> payload = ::boost::static_pointer_cast<InstallationStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InstallationStatusCallbackIF*) _callback)->onInstallationStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InstallationStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InstallationStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InstallationStatusUpdate> payload = ::boost::static_pointer_cast<InstallationStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InstallationStatusCallbackIF*) _callback)->onInstallationStatusUpdate(proxyShared, payload);
                        proxyShared->_installationStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_navDataStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDataStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDataStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDataStatusError> payload = ::boost::static_pointer_cast<NavDataStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NavDataStatusCallbackIF*) _callback)->onNavDataStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDataStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDataStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDataStatusUpdate> payload = ::boost::static_pointer_cast<NavDataStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NavDataStatusCallbackIF*) _callback)->onNavDataStatusUpdate(proxyShared, payload);
                        proxyShared->_navDataStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_navDataContext:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDataContextError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDataContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDataContextError> payload = ::boost::static_pointer_cast<NavDataContextError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NavDataContextCallbackIF*) _callback)->onNavDataContextError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavDataContextUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavDataContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavDataContextUpdate> payload = ::boost::static_pointer_cast<NavDataContextUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NavDataContextCallbackIF*) _callback)->onNavDataContextUpdate(proxyShared, payload);
                        proxyShared->_navDataContext = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_navigationDataUpdateStatusInfo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavigationDataUpdateStatusInfoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavigationDataUpdateStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavigationDataUpdateStatusInfoError> payload = ::boost::static_pointer_cast<NavigationDataUpdateStatusInfoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NavigationDataUpdateStatusInfoCallbackIF*) _callback)->onNavigationDataUpdateStatusInfoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NavigationDataUpdateStatusInfoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NavigationDataUpdateStatusInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NavigationDataUpdateStatusInfoUpdate> payload = ::boost::static_pointer_cast<NavigationDataUpdateStatusInfoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NavigationDataUpdateStatusInfoCallbackIF*) _callback)->onNavigationDataUpdateStatusInfoUpdate(proxyShared, payload);
                        proxyShared->_navigationDataUpdateStatusInfo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_catalogueStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CatalogueStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CatalogueStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CatalogueStatusError> payload = ::boost::static_pointer_cast<CatalogueStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CatalogueStatusCallbackIF*) _callback)->onCatalogueStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CatalogueStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CatalogueStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CatalogueStatusUpdate> payload = ::boost::static_pointer_cast<CatalogueStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CatalogueStatusCallbackIF*) _callback)->onCatalogueStatusUpdate(proxyShared, payload);
                        proxyShared->_catalogueStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_mapupdateExportStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapupdateExportStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapupdateExportStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapupdateExportStatusError> payload = ::boost::static_pointer_cast<MapupdateExportStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MapupdateExportStatusCallbackIF*) _callback)->onMapupdateExportStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapupdateExportStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapupdateExportStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapupdateExportStatusUpdate> payload = ::boost::static_pointer_cast<MapupdateExportStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MapupdateExportStatusCallbackIF*) _callback)->onMapupdateExportStatusUpdate(proxyShared, payload);
                        proxyShared->_mapupdateExportStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_deviceInfos:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceInfosError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceInfos", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceInfosError> payload = ::boost::static_pointer_cast<DeviceInfosError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeviceInfosCallbackIF*) _callback)->onDeviceInfosError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceInfosUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceInfos", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceInfosUpdate> payload = ::boost::static_pointer_cast<DeviceInfosUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeviceInfosCallbackIF*) _callback)->onDeviceInfosUpdate(proxyShared, payload);
                        proxyShared->_deviceInfos = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DiagPerformFullUpdateViaUSB:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DiagPerformFullUpdateViaUSBError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagPerformFullUpdateViaUSB", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiagPerformFullUpdateViaUSBError> payload = ::boost::static_pointer_cast<DiagPerformFullUpdateViaUSBError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DiagPerformFullUpdateViaUSBCallbackIF*) _callback)->onDiagPerformFullUpdateViaUSBError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiagPerformFullUpdateViaUSBResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagPerformFullUpdateViaUSB", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiagPerformFullUpdateViaUSBResponse> payload = ::boost::static_pointer_cast<DiagPerformFullUpdateViaUSBResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DiagPerformFullUpdateViaUSBCallbackIF*) _callback)->onDiagPerformFullUpdateViaUSBResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getAvailableUpdates:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailableUpdatesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAvailableUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAvailableUpdatesError> payload = ::boost::static_pointer_cast<GetAvailableUpdatesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAvailableUpdatesCallbackIF*) _callback)->onGetAvailableUpdatesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailableUpdatesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAvailableUpdates", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAvailableUpdatesResponse> payload = ::boost::static_pointer_cast<GetAvailableUpdatesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAvailableUpdatesCallbackIF*) _callback)->onGetAvailableUpdatesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_deleteUpdateComponent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeleteUpdateComponentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteUpdateComponent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteUpdateComponentError> payload = ::boost::static_pointer_cast<DeleteUpdateComponentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteUpdateComponentCallbackIF*) _callback)->onDeleteUpdateComponentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteUpdateComponentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeleteUpdateComponent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteUpdateComponentResponse> payload = ::boost::static_pointer_cast<DeleteUpdateComponentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeleteUpdateComponentCallbackIF*) _callback)->onDeleteUpdateComponentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setFavoriteUpdateRegions:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetFavoriteUpdateRegionsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFavoriteUpdateRegionsError> payload = ::boost::static_pointer_cast<SetFavoriteUpdateRegionsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFavoriteUpdateRegionsCallbackIF*) _callback)->onSetFavoriteUpdateRegionsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFavoriteUpdateRegionsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFavoriteUpdateRegionsResponse> payload = ::boost::static_pointer_cast<SetFavoriteUpdateRegionsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFavoriteUpdateRegionsCallbackIF*) _callback)->onSetFavoriteUpdateRegionsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_clearFavoriteUpdateRegions:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ClearFavoriteUpdateRegionsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearFavoriteUpdateRegionsError> payload = ::boost::static_pointer_cast<ClearFavoriteUpdateRegionsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearFavoriteUpdateRegionsCallbackIF*) _callback)->onClearFavoriteUpdateRegionsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearFavoriteUpdateRegionsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClearFavoriteUpdateRegionsResponse> payload = ::boost::static_pointer_cast<ClearFavoriteUpdateRegionsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClearFavoriteUpdateRegionsCallbackIF*) _callback)->onClearFavoriteUpdateRegionsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_startFullUpdate:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartFullUpdateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartFullUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartFullUpdateError> payload = ::boost::static_pointer_cast<StartFullUpdateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartFullUpdateCallbackIF*) _callback)->onStartFullUpdateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartFullUpdateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartFullUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartFullUpdateResponse> payload = ::boost::static_pointer_cast<StartFullUpdateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartFullUpdateCallbackIF*) _callback)->onStartFullUpdateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartMapDataExport:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartMapDataExportError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartMapDataExport", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartMapDataExportError> payload = ::boost::static_pointer_cast<StartMapDataExportError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartMapDataExportCallbackIF*) _callback)->onStartMapDataExportError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartMapDataExportResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartMapDataExport", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartMapDataExportResponse> payload = ::boost::static_pointer_cast<StartMapDataExportResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartMapDataExportCallbackIF*) _callback)->onStartMapDataExportResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_favoriteUpdateRegions: {
                ::boost::shared_ptr< FavoriteUpdateRegionsError > payload = ::boost::shared_ptr< FavoriteUpdateRegionsError >
                (new FavoriteUpdateRegionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FavoriteUpdateRegionsCallbackIF*) _callback)->onFavoriteUpdateRegionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_installationStatus: {
                ::boost::shared_ptr< InstallationStatusError > payload = ::boost::shared_ptr< InstallationStatusError >
                (new InstallationStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InstallationStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InstallationStatusCallbackIF*) _callback)->onInstallationStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_navDataStatus: {
                ::boost::shared_ptr< NavDataStatusError > payload = ::boost::shared_ptr< NavDataStatusError >
                (new NavDataStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NavDataStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NavDataStatusCallbackIF*) _callback)->onNavDataStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_navDataContext: {
                ::boost::shared_ptr< NavDataContextError > payload = ::boost::shared_ptr< NavDataContextError >
                (new NavDataContextError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NavDataContext", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NavDataContextCallbackIF*) _callback)->onNavDataContextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_navigationDataUpdateStatusInfo: {
                ::boost::shared_ptr< NavigationDataUpdateStatusInfoError > payload = ::boost::shared_ptr< NavigationDataUpdateStatusInfoError >
                (new NavigationDataUpdateStatusInfoError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NavigationDataUpdateStatusInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NavigationDataUpdateStatusInfoCallbackIF*) _callback)->onNavigationDataUpdateStatusInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_catalogueStatus: {
                ::boost::shared_ptr< CatalogueStatusError > payload = ::boost::shared_ptr< CatalogueStatusError >
                (new CatalogueStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CatalogueStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CatalogueStatusCallbackIF*) _callback)->onCatalogueStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_mapupdateExportStatus: {
                ::boost::shared_ptr< MapupdateExportStatusError > payload = ::boost::shared_ptr< MapupdateExportStatusError >
                (new MapupdateExportStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapupdateExportStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapupdateExportStatusCallbackIF*) _callback)->onMapupdateExportStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deviceInfos: {
                ::boost::shared_ptr< DeviceInfosError > payload = ::boost::shared_ptr< DeviceInfosError >
                (new DeviceInfosError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceInfos", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceInfosCallbackIF*) _callback)->onDeviceInfosError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DiagPerformFullUpdateViaUSB: {
                ::boost::shared_ptr< DiagPerformFullUpdateViaUSBError > payload = ::boost::shared_ptr< DiagPerformFullUpdateViaUSBError >
                (new DiagPerformFullUpdateViaUSBError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DiagPerformFullUpdateViaUSB", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiagPerformFullUpdateViaUSBCallbackIF*) _callback)->onDiagPerformFullUpdateViaUSBError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getAvailableUpdates: {
                ::boost::shared_ptr< GetAvailableUpdatesError > payload = ::boost::shared_ptr< GetAvailableUpdatesError >
                (new GetAvailableUpdatesError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAvailableUpdates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAvailableUpdatesCallbackIF*) _callback)->onGetAvailableUpdatesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deleteUpdateComponent: {
                ::boost::shared_ptr< DeleteUpdateComponentError > payload = ::boost::shared_ptr< DeleteUpdateComponentError >
                (new DeleteUpdateComponentError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeleteUpdateComponent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeleteUpdateComponentCallbackIF*) _callback)->onDeleteUpdateComponentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setFavoriteUpdateRegions: {
                ::boost::shared_ptr< SetFavoriteUpdateRegionsError > payload = ::boost::shared_ptr< SetFavoriteUpdateRegionsError >
                (new SetFavoriteUpdateRegionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetFavoriteUpdateRegionsCallbackIF*) _callback)->onSetFavoriteUpdateRegionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_clearFavoriteUpdateRegions: {
                ::boost::shared_ptr< ClearFavoriteUpdateRegionsError > payload = ::boost::shared_ptr< ClearFavoriteUpdateRegionsError >
                (new ClearFavoriteUpdateRegionsError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ClearFavoriteUpdateRegions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClearFavoriteUpdateRegionsCallbackIF*) _callback)->onClearFavoriteUpdateRegionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_startFullUpdate: {
                ::boost::shared_ptr< StartFullUpdateError > payload = ::boost::shared_ptr< StartFullUpdateError >
                (new StartFullUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartFullUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartFullUpdateCallbackIF*) _callback)->onStartFullUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartMapDataExport: {
                ::boost::shared_ptr< StartMapDataExportError > payload = ::boost::shared_ptr< StartMapDataExportError >
                (new StartMapDataExportError(DBUS_ERROR_NO_SERVER, "The DBus service NavigationDataUpdateService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartMapDataExport", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NavigationDataUpdateServiceProxy> proxyShared = ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartMapDataExportCallbackIF*) _callback)->onStartMapDataExportError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NavigationDataUpdateServiceProxyCallback::_logger (NavigationDataUpdateServiceProxy::_logger);

NavigationDataUpdateServiceProxy::NavigationDataUpdateServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.navigation.NavigationDataUpdateService", serviceAvailable, _logger) {
}

NavigationDataUpdateServiceProxy::~NavigationDataUpdateServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NavigationDataUpdateServiceProxy > NavigationDataUpdateServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NavigationDataUpdateServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NavigationDataUpdateServiceProxy > proxyNew(new NavigationDataUpdateServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t NavigationDataUpdateServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NavigationDataUpdateServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void NavigationDataUpdateServiceProxy::clearAllProperties ()
{
    _favoriteUpdateRegions = ::asf::core::nullable< FavoriteUpdateRegionsUpdate >();
    _installationStatus = ::asf::core::nullable< InstallationStatusUpdate >();
    _navDataStatus = ::asf::core::nullable< NavDataStatusUpdate >();
    _navDataContext = ::asf::core::nullable< NavDataContextUpdate >();
    _navigationDataUpdateStatusInfo = ::asf::core::nullable< NavigationDataUpdateStatusInfoUpdate >();
    _catalogueStatus = ::asf::core::nullable< CatalogueStatusUpdate >();
    _mapupdateExportStatus = ::asf::core::nullable< MapupdateExportStatusUpdate >();
    _deviceInfos = ::asf::core::nullable< DeviceInfosUpdate >();
}

void NavigationDataUpdateServiceProxy::sendDeregisterAll () const
{
    sendFavoriteUpdateRegionsDeregisterAll();
    sendInstallationStatusDeregisterAll();
    sendNavDataStatusDeregisterAll();
    sendNavDataContextDeregisterAll();
    sendNavigationDataUpdateStatusInfoDeregisterAll();
    sendCatalogueStatusDeregisterAll();
    sendMapupdateExportStatusDeregisterAll();
    sendDeviceInfosDeregisterAll();
}

act_t NavigationDataUpdateServiceProxy::sendFavoriteUpdateRegionsRegister(FavoriteUpdateRegionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_favoriteUpdateRegions, "favoriteUpdateRegions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FavoriteUpdateRegions", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendFavoriteUpdateRegionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("favoriteUpdateRegions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FavoriteUpdateRegions", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendFavoriteUpdateRegionsGet(FavoriteUpdateRegionsCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_favoriteUpdateRegions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FavoriteUpdateRegions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("favoriteUpdateRegions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const FavoriteUpdateRegions& NavigationDataUpdateServiceProxy::getFavoriteUpdateRegions() const {
    return _favoriteUpdateRegions.get().getFavoriteUpdateRegions();
}

bool NavigationDataUpdateServiceProxy::hasFavoriteUpdateRegions() const {
    return _favoriteUpdateRegions.hasValue();
}

void NavigationDataUpdateServiceProxy::sendFavoriteUpdateRegionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FavoriteUpdateRegions");
    _dbusProxyDelegate->deregisterSignalCallback("favoriteUpdateRegions", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendInstallationStatusRegister(InstallationStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_installationStatus, "installationStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InstallationStatus", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendInstallationStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("installationStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InstallationStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendInstallationStatusGet(InstallationStatusCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_installationStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InstallationStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("installationStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const InstallationStatus& NavigationDataUpdateServiceProxy::getInstallationStatus() const {
    return _installationStatus.get().getInstallationStatus();
}

bool NavigationDataUpdateServiceProxy::hasInstallationStatus() const {
    return _installationStatus.hasValue();
}

void NavigationDataUpdateServiceProxy::sendInstallationStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InstallationStatus");
    _dbusProxyDelegate->deregisterSignalCallback("installationStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendNavDataStatusRegister(NavDataStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_navDataStatus, "navDataStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NavDataStatus", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendNavDataStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("navDataStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NavDataStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendNavDataStatusGet(NavDataStatusCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_navDataStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NavDataStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("navDataStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


NavigationDataStatus NavigationDataUpdateServiceProxy::getNavDataStatus() const {
    return _navDataStatus.get().getNavDataStatus();
}

bool NavigationDataUpdateServiceProxy::hasNavDataStatus() const {
    return _navDataStatus.hasValue();
}

void NavigationDataUpdateServiceProxy::sendNavDataStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NavDataStatus");
    _dbusProxyDelegate->deregisterSignalCallback("navDataStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendNavDataContextRegister(NavDataContextCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_navDataContext, "navDataContext", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NavDataContext", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendNavDataContextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("navDataContext", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NavDataContext", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendNavDataContextGet(NavDataContextCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_navDataContext, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NavDataContext", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("navDataContext", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const NavDataContext& NavigationDataUpdateServiceProxy::getNavDataContext() const {
    return _navDataContext.get().getNavDataContext();
}

bool NavigationDataUpdateServiceProxy::hasNavDataContext() const {
    return _navDataContext.hasValue();
}

void NavigationDataUpdateServiceProxy::sendNavDataContextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NavDataContext");
    _dbusProxyDelegate->deregisterSignalCallback("navDataContext", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendNavigationDataUpdateStatusInfoRegister(NavigationDataUpdateStatusInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_navigationDataUpdateStatusInfo, "navigationDataUpdateStatusInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NavigationDataUpdateStatusInfo", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendNavigationDataUpdateStatusInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("navigationDataUpdateStatusInfo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NavigationDataUpdateStatusInfo", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendNavigationDataUpdateStatusInfoGet(NavigationDataUpdateStatusInfoCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_navigationDataUpdateStatusInfo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NavigationDataUpdateStatusInfo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("navigationDataUpdateStatusInfo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const NavigationDataUpdateStatusInfo& NavigationDataUpdateServiceProxy::getNavigationDataUpdateStatusInfo() const {
    return _navigationDataUpdateStatusInfo.get().getNavigationDataUpdateStatusInfo();
}

bool NavigationDataUpdateServiceProxy::hasNavigationDataUpdateStatusInfo() const {
    return _navigationDataUpdateStatusInfo.hasValue();
}

void NavigationDataUpdateServiceProxy::sendNavigationDataUpdateStatusInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NavigationDataUpdateStatusInfo");
    _dbusProxyDelegate->deregisterSignalCallback("navigationDataUpdateStatusInfo", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendCatalogueStatusRegister(CatalogueStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_catalogueStatus, "catalogueStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CatalogueStatus", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendCatalogueStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("catalogueStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CatalogueStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendCatalogueStatusGet(CatalogueStatusCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_catalogueStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CatalogueStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("catalogueStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


CatalogueStatus NavigationDataUpdateServiceProxy::getCatalogueStatus() const {
    return _catalogueStatus.get().getCatalogueStatus();
}

bool NavigationDataUpdateServiceProxy::hasCatalogueStatus() const {
    return _catalogueStatus.hasValue();
}

void NavigationDataUpdateServiceProxy::sendCatalogueStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CatalogueStatus");
    _dbusProxyDelegate->deregisterSignalCallback("catalogueStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendMapupdateExportStatusRegister(MapupdateExportStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_mapupdateExportStatus, "mapupdateExportStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapupdateExportStatus", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendMapupdateExportStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("mapupdateExportStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapupdateExportStatus", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendMapupdateExportStatusGet(MapupdateExportStatusCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_mapupdateExportStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MapupdateExportStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("mapupdateExportStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


MapupdateExportStatus NavigationDataUpdateServiceProxy::getMapupdateExportStatus() const {
    return _mapupdateExportStatus.get().getMapupdateExportStatus();
}

bool NavigationDataUpdateServiceProxy::hasMapupdateExportStatus() const {
    return _mapupdateExportStatus.hasValue();
}

void NavigationDataUpdateServiceProxy::sendMapupdateExportStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapupdateExportStatus");
    _dbusProxyDelegate->deregisterSignalCallback("mapupdateExportStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendDeviceInfosRegister(DeviceInfosCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_deviceInfos, "deviceInfos", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceInfos", &cb, act);
    return act;
}

bool NavigationDataUpdateServiceProxy::sendDeviceInfosDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("deviceInfos", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceInfos", act, static_cast<int>(rv));
    return rv;
}

act_t NavigationDataUpdateServiceProxy::sendDeviceInfosGet(DeviceInfosCallbackIF& cb) {
    NavigationDataUpdateServiceProxyCallback* callback = new NavigationDataUpdateServiceProxyCallback(ID_deviceInfos, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeviceInfos", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("deviceInfos", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< DeviceInfo >& NavigationDataUpdateServiceProxy::getDeviceInfos() const {
    return _deviceInfos.get().getDeviceInfos();
}

bool NavigationDataUpdateServiceProxy::hasDeviceInfos() const {
    return _deviceInfos.hasValue();
}

void NavigationDataUpdateServiceProxy::sendDeviceInfosDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceInfos");
    _dbusProxyDelegate->deregisterSignalCallback("deviceInfos", 0, _dbusDaemonProxy.get(), true);
}

act_t NavigationDataUpdateServiceProxy::sendDiagPerformFullUpdateViaUSBRequest(DiagPerformFullUpdateViaUSBCallbackIF& cb) const {
    DiagPerformFullUpdateViaUSBRequest* payload = new DiagPerformFullUpdateViaUSBRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "DiagPerformFullUpdateViaUSB", DiagPerformFullUpdateViaUSBRequest, payload, true)
    act_t act = addMethodCallback(ID_DiagPerformFullUpdateViaUSB, dbusMessage.getUniqueSerial(), "DiagPerformFullUpdateViaUSB", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DiagPerformFullUpdateViaUSB", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendGetAvailableUpdatesRequest(GetAvailableUpdatesCallbackIF& cb) const {
    GetAvailableUpdatesRequest* payload = new GetAvailableUpdatesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getAvailableUpdates", GetAvailableUpdatesRequest, payload, true)
    act_t act = addMethodCallback(ID_getAvailableUpdates, dbusMessage.getUniqueSerial(), "getAvailableUpdates", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAvailableUpdates", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendDeleteUpdateComponentRequest(DeleteUpdateComponentCallbackIF& cb, uint32 productId, uint32 supplierId, const ::std::vector< uint32 >& regionId) const {
    DeleteUpdateComponentRequest* payload = new DeleteUpdateComponentRequest();
    CHECK_ALLOCATION(payload);
    payload->setProductId(productId);
    payload->setSupplierId(supplierId);
    payload->setRegionId(regionId);
    DBUS_MESSAGE_CALL(dbusMessage, "deleteUpdateComponent", DeleteUpdateComponentRequest, payload, true)
    act_t act = addMethodCallback(ID_deleteUpdateComponent, dbusMessage.getUniqueSerial(), "deleteUpdateComponent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeleteUpdateComponent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendSetFavoriteUpdateRegionsRequest(SetFavoriteUpdateRegionsCallbackIF& cb, uint32 productId, uint32 supplierId, uint32 baselineMapId, const ::std::vector< uint32 >& updateRegionIds) const {
    SetFavoriteUpdateRegionsRequest* payload = new SetFavoriteUpdateRegionsRequest();
    CHECK_ALLOCATION(payload);
    payload->setProductId(productId);
    payload->setSupplierId(supplierId);
    payload->setBaselineMapId(baselineMapId);
    payload->setUpdateRegionIds(updateRegionIds);
    DBUS_MESSAGE_CALL(dbusMessage, "setFavoriteUpdateRegions", SetFavoriteUpdateRegionsRequest, payload, true)
    act_t act = addMethodCallback(ID_setFavoriteUpdateRegions, dbusMessage.getUniqueSerial(), "setFavoriteUpdateRegions", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetFavoriteUpdateRegions", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendClearFavoriteUpdateRegionsRequest(ClearFavoriteUpdateRegionsCallbackIF& cb) const {
    ClearFavoriteUpdateRegionsRequest* payload = new ClearFavoriteUpdateRegionsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "clearFavoriteUpdateRegions", ClearFavoriteUpdateRegionsRequest, payload, true)
    act_t act = addMethodCallback(ID_clearFavoriteUpdateRegions, dbusMessage.getUniqueSerial(), "clearFavoriteUpdateRegions", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ClearFavoriteUpdateRegions", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendStartFullUpdateRequest(StartFullUpdateCallbackIF& cb) const {
    StartFullUpdateRequest* payload = new StartFullUpdateRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "startFullUpdate", StartFullUpdateRequest, payload, true)
    act_t act = addMethodCallback(ID_startFullUpdate, dbusMessage.getUniqueSerial(), "startFullUpdate", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartFullUpdate", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NavigationDataUpdateServiceProxy::sendStartMapDataExportRequest(StartMapDataExportCallbackIF& cb, uint32 deviceId, Devicetype deviceType) const {
    StartMapDataExportRequest* payload = new StartMapDataExportRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceId(deviceId);
    payload->setDeviceType(deviceType);
    DBUS_MESSAGE_CALL(dbusMessage, "StartMapDataExport", StartMapDataExportRequest, payload, true)
    act_t act = addMethodCallback(ID_StartMapDataExport, dbusMessage.getUniqueSerial(), "StartMapDataExport", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartMapDataExport", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NavigationDataUpdateService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
