/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateService.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceConst.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of FavoriteUpdateRegionData

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint32 o1 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o1));
        uint32 o2 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o2));
        uint32 o3 = in.getBaselineMapId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o3));
        DBusMessageIter o4ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o0Struct, DBUS_TYPE_ARRAY, "u", &o4ArrayIter));
        const ::std::vector< uint32 >* o5 = &in.getUpdateRegionIds();
        ::std::vector< uint32 >::const_iterator o6 = o5->end();
        for (::std::vector< uint32 >::const_iterator o7 = o5->begin(); o7 != o6; ++o7) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o4ArrayIter, DBUS_TYPE_UINT32, &(*o7)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o0Struct, &o4ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData& out) {
    {
        DBusMessageIter o8;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o8);
                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o8, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

                {
                    uint32 supplierIdValue;
                    uint32 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o8, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

                {
                    uint32 baselineMapIdValue;
                    uint32 &baselineMapIdTmpValue = baselineMapIdValue;
                    dbus_message_iter_get_basic(&o8, &baselineMapIdTmpValue);
                    out.setBaselineMapId(baselineMapIdValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

                {
                    ::std::vector< uint32 > updateRegionIdsValue;

                    if (dbus_message_iter_get_arg_type(&o8) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o9ArrayIter;
                        dbus_message_iter_recurse (&o8, &o9ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o9ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint32 o10;
                                dbus_message_iter_get_basic(&o9ArrayIter, &o10);
                                updateRegionIdsValue.push_back(o10);
                            } while (dbus_message_iter_next(&o9ArrayIter));
                        }
                    }
                    out.setUpdateRegionIds(updateRegionIdsValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of FavoriteUpdateRegions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o11Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o11Struct));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus  o12 = in.getFavoriteUpdateRegionStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o11Struct, DBUS_TYPE_UINT32, &o12));
        serializeDBus(in.getFavoriteUpdateRegions(), &o11Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o11Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions& out) {
    {
        DBusMessageIter o13;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o13);
                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus favoriteUpdateRegionStatusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionStatus__UKNOWN_STATUS;
                    dbus_message_iter_get_basic(&o13, &favoriteUpdateRegionStatusValue);
                    out.setFavoriteUpdateRegionStatus(favoriteUpdateRegionStatusValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionData favoriteUpdateRegionsValue;
                    if (!deserializeDBus(&o13, favoriteUpdateRegionsValue)) {
                        return false;
                    }
                    out.setFavoriteUpdateRegions(favoriteUpdateRegionsValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NavigationDataUpdateStatusInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus  o15 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o15));
        uint8 o16 = in.getProgressValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_BYTE, &o16));
        uint32 o17 = in.getRemainingTimeInSecond();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o17));
        const char* o18 = in.getProductName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_STRING, &o18));
        const char* o19 = in.getRegionName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_STRING, &o19));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo& out) {
    {
        DBusMessageIter o20;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o20);
                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus statusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatus__IDLE;
                    dbus_message_iter_get_basic(&o20, &statusValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

                {
                    uint8 progressValueValue;
                    uint8 &progressValueTmpValue = progressValueValue;
                    dbus_message_iter_get_basic(&o20, &progressValueTmpValue);
                    out.setProgressValue(progressValueValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

                {
                    uint32 remainingTimeInSecondValue;
                    uint32 &remainingTimeInSecondTmpValue = remainingTimeInSecondValue;
                    dbus_message_iter_get_basic(&o20, &remainingTimeInSecondTmpValue);
                    out.setRemainingTimeInSecond(remainingTimeInSecondValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

                {
                    ::std::string productNameValue;
                    ::std::string &productNameTmpValue = productNameValue;
                    {
                        char* o21 = 0;
                        dbus_message_iter_get_basic(&o20, &o21);
                        productNameTmpValue.assign (o21);
                    }
                    out.setProductName(productNameValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

                {
                    ::std::string regionNameValue;
                    ::std::string &regionNameTmpValue = regionNameValue;
                    {
                        char* o22 = 0;
                        dbus_message_iter_get_basic(&o20, &o22);
                        regionNameTmpValue.assign (o22);
                    }
                    out.setRegionName(regionNameValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of InstallationStatus

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus& in, DBusMessageIter* out) {
    {
        DBusMessageIter o23Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o23Struct));
        uint32 o24 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_UINT32, &o24));
        uint32 o25 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_UINT32, &o25));
        uint32 o26 = in.getRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_UINT32, &o26));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep  o27 = in.getUpdateStep();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_UINT32, &o27));
        uint16 o28 = in.getPercentage();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_UINT16, &o28));
        dbus_bool_t o29 = in.getIsProductUpdate() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_BOOLEAN, &o29));
        const char* o30 = in.getProductName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_STRING, &o30));
        const char* o31 = in.getRegionName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o23Struct, DBUS_TYPE_STRING, &o31));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o23Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus& out) {
    {
        DBusMessageIter o32;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o32);
                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o32, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    uint32 supplierIdValue;
                    uint32 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o32, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    uint32 regionIdValue;
                    uint32 &regionIdTmpValue = regionIdValue;
                    dbus_message_iter_get_basic(&o32, &regionIdTmpValue);
                    out.setRegionId(regionIdValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep updateStepValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateStep__UPDATE_INACTIVE;
                    dbus_message_iter_get_basic(&o32, &updateStepValue);
                    out.setUpdateStep(updateStepValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    uint16 percentageValue;
                    uint16 &percentageTmpValue = percentageValue;
                    dbus_message_iter_get_basic(&o32, &percentageTmpValue);
                    out.setPercentage(percentageValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    bool isProductUpdateValue;
                    bool &isProductUpdateTmpValue = isProductUpdateValue;
                    {
                        dbus_bool_t o33;
                        dbus_message_iter_get_basic(&o32, &o33);
                        isProductUpdateTmpValue = o33 ? true : false;
                    }
                    out.setIsProductUpdate(isProductUpdateValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::std::string productNameValue;
                    ::std::string &productNameTmpValue = productNameValue;
                    {
                        char* o34 = 0;
                        dbus_message_iter_get_basic(&o32, &o34);
                        productNameTmpValue.assign (o34);
                    }
                    out.setProductName(productNameValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::std::string regionNameValue;
                    ::std::string &regionNameTmpValue = regionNameValue;
                    {
                        char* o35 = 0;
                        dbus_message_iter_get_basic(&o32, &o35);
                        regionNameTmpValue.assign (o35);
                    }
                    out.setRegionName(regionNameValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of StorageSpace

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace& in, DBusMessageIter* out) {
    {
        DBusMessageIter o36Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o36Struct));
        uint64 o37 = in.getSpaceTotalInBytes();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_UINT64, &o37));
        uint64 o38 = in.getSpaceLeftInBytes();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_UINT64, &o38));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o36Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace& out) {
    {
        DBusMessageIter o39;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o39);
                {
                    uint64 spaceTotalInBytesValue;
                    uint64 &spaceTotalInBytesTmpValue = spaceTotalInBytesValue;
                    dbus_message_iter_get_basic(&o39, &spaceTotalInBytesTmpValue);
                    out.setSpaceTotalInBytes(spaceTotalInBytesValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    uint64 spaceLeftInBytesValue;
                    uint64 &spaceLeftInBytesTmpValue = spaceLeftInBytesValue;
                    dbus_message_iter_get_basic(&o39, &spaceLeftInBytesTmpValue);
                    out.setSpaceLeftInBytes(spaceLeftInBytesValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateDescription

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription& in, DBusMessageIter* out) {
    {
        DBusMessageIter o40Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o40Struct));
        uint32 o41 = in.getUpdateVersionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_UINT32, &o41));
        uint64 o42 = in.getUpdateVersionDate();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_UINT64, &o42));
        uint64 o43 = in.getDownloadSizeInBytes();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_UINT64, &o43));
        uint64 o44 = in.getEstimatedInstallTimeInSeconds();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_UINT64, &o44));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o40Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription& out) {
    {
        DBusMessageIter o45;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o45);
                {
                    uint32 updateVersionIdValue;
                    uint32 &updateVersionIdTmpValue = updateVersionIdValue;
                    dbus_message_iter_get_basic(&o45, &updateVersionIdTmpValue);
                    out.setUpdateVersionId(updateVersionIdValue);
                }

                if (dbus_message_iter_has_next(&o45)) {
                    dbus_message_iter_next(&o45);
                } else {
                    return true;
                }

                {
                    uint64 updateVersionDateValue;
                    uint64 &updateVersionDateTmpValue = updateVersionDateValue;
                    dbus_message_iter_get_basic(&o45, &updateVersionDateTmpValue);
                    out.setUpdateVersionDate(updateVersionDateValue);
                }

                if (dbus_message_iter_has_next(&o45)) {
                    dbus_message_iter_next(&o45);
                } else {
                    return true;
                }

                {
                    uint64 downloadSizeInBytesValue;
                    uint64 &downloadSizeInBytesTmpValue = downloadSizeInBytesValue;
                    dbus_message_iter_get_basic(&o45, &downloadSizeInBytesTmpValue);
                    out.setDownloadSizeInBytes(downloadSizeInBytesValue);
                }

                if (dbus_message_iter_has_next(&o45)) {
                    dbus_message_iter_next(&o45);
                } else {
                    return true;
                }

                {
                    uint64 estimatedInstallTimeInSecondsValue;
                    uint64 &estimatedInstallTimeInSecondsTmpValue = estimatedInstallTimeInSecondsValue;
                    dbus_message_iter_get_basic(&o45, &estimatedInstallTimeInSecondsTmpValue);
                    out.setEstimatedInstallTimeInSeconds(estimatedInstallTimeInSecondsValue);
                }

                if (dbus_message_iter_has_next(&o45)) {
                    dbus_message_iter_next(&o45);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateRegionVersionInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o46Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o46Struct));
        uint32 o47 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o46Struct, DBUS_TYPE_UINT32, &o47));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState  o48 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o46Struct, DBUS_TYPE_UINT32, &o48));
        DBusMessageIter o49ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o46Struct, DBUS_TYPE_ARRAY, "(uttt)", &o49ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription >* o50 = &in.getUpdateDescription();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription >::const_iterator o51 = o50->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription >::const_iterator o52 = o50->begin(); o52 != o51; ++o52) {
            serializeDBus((*o52), &o49ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o46Struct, &o49ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o46Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo& out) {
    {
        DBusMessageIter o53;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o53);
                {
                    uint32 updateRegionIdValue;
                    uint32 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o53, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState statusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateState__UP_TO_DATE;
                    dbus_message_iter_get_basic(&o53, &statusValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription > updateDescriptionValue;

                    if (dbus_message_iter_get_arg_type(&o53) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o54ArrayIter;
                        dbus_message_iter_recurse (&o53, &o54ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o54ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateDescription o55;
                                if (!deserializeDBus(&o54ArrayIter, o55)) {
                                    return false;
                                }
                                updateDescriptionValue.push_back(o55);
                            } while (dbus_message_iter_next(&o54ArrayIter));
                        }
                    }
                    out.setUpdateDescription(updateDescriptionValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ProductVersionInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o56Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o56Struct));
        uint32 o57 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56Struct, DBUS_TYPE_UINT32, &o57));
        uint32 o58 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56Struct, DBUS_TYPE_UINT32, &o58));
        uint32 o59 = in.getBaselineMapId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56Struct, DBUS_TYPE_UINT32, &o59));
        DBusMessageIter o60ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o56Struct, DBUS_TYPE_ARRAY, "(uua(uttt))", &o60ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo >* o61 = &in.getUpdateRegions();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo >::const_iterator o62 = o61->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo >::const_iterator o63 = o61->begin(); o63 != o62; ++o63) {
            serializeDBus((*o63), &o60ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o56Struct, &o60ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o56Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo& out) {
    {
        DBusMessageIter o64;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o64);
                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o64, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o64)) {
                    dbus_message_iter_next(&o64);
                } else {
                    return true;
                }

                {
                    uint32 supplierIdValue;
                    uint32 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o64, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o64)) {
                    dbus_message_iter_next(&o64);
                } else {
                    return true;
                }

                {
                    uint32 baselineMapIdValue;
                    uint32 &baselineMapIdTmpValue = baselineMapIdValue;
                    dbus_message_iter_get_basic(&o64, &baselineMapIdTmpValue);
                    out.setBaselineMapId(baselineMapIdValue);
                }

                if (dbus_message_iter_has_next(&o64)) {
                    dbus_message_iter_next(&o64);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo > updateRegionsValue;

                    if (dbus_message_iter_get_arg_type(&o64) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o65ArrayIter;
                        dbus_message_iter_recurse (&o64, &o65ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o65ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegionVersionInfo o66;
                                if (!deserializeDBus(&o65ArrayIter, o66)) {
                                    return false;
                                }
                                updateRegionsValue.push_back(o66);
                            } while (dbus_message_iter_next(&o65ArrayIter));
                        }
                    }
                    out.setUpdateRegions(updateRegionsValue);
                }

                if (dbus_message_iter_has_next(&o64)) {
                    dbus_message_iter_next(&o64);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of AvailableUpdates

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates& in, DBusMessageIter* out) {
    {
        DBusMessageIter o67Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o67Struct));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult  o68 = in.getResult();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o67Struct, DBUS_TYPE_UINT32, &o68));
        DBusMessageIter o69ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o67Struct, DBUS_TYPE_ARRAY, "(uuua(uua(uttt)))", &o69ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo >* o70 = &in.getProducts();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo >::const_iterator o71 = o70->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo >::const_iterator o72 = o70->begin(); o72 != o71; ++o72) {
            serializeDBus((*o72), &o69ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o67Struct, &o69ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o67Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates& out) {
    {
        DBusMessageIter o73;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o73);
                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResult__SUCCESS;
                    dbus_message_iter_get_basic(&o73, &resultValue);
                    out.setResult(resultValue);
                }

                if (dbus_message_iter_has_next(&o73)) {
                    dbus_message_iter_next(&o73);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo > productsValue;

                    if (dbus_message_iter_get_arg_type(&o73) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o74ArrayIter;
                        dbus_message_iter_recurse (&o73, &o74ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o74ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::ProductVersionInfo o75;
                                if (!deserializeDBus(&o74ArrayIter, o75)) {
                                    return false;
                                }
                                productsValue.push_back(o75);
                            } while (dbus_message_iter_next(&o74ArrayIter));
                        }
                    }
                    out.setProducts(productsValue);
                }

                if (dbus_message_iter_has_next(&o73)) {
                    dbus_message_iter_next(&o73);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateRegion

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion& in, DBusMessageIter* out) {
    {
        DBusMessageIter o76Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o76Struct));
        const char* o77 = in.getComponentId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_STRING, &o77));
        uint32 o78 = in.getRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_UINT32, &o78));
        const char* o79 = in.getRegionName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_STRING, &o79));
        uint64 o80 = in.getCurrentSizeInBytes();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_UINT64, &o80));
        dbus_bool_t o81 = in.getIsRemovable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_BOOLEAN, &o81));
        dbus_bool_t o82 = in.getIsInstalled() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_BOOLEAN, &o82));
        uint64 o83 = in.getCurrentVersionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_UINT64, &o83));
        uint64 o84 = in.getCurrentVersionDate();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_UINT64, &o84));
        dbus_bool_t o85 = in.getIsSubscriptionActive() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_BOOLEAN, &o85));
        dbus_bool_t o86 = in.getIsFavorite() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o76Struct, DBUS_TYPE_BOOLEAN, &o86));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o76Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion& out) {
    {
        DBusMessageIter o87;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o87);
                {
                    ::std::string componentIdValue;
                    ::std::string &componentIdTmpValue = componentIdValue;
                    {
                        char* o88 = 0;
                        dbus_message_iter_get_basic(&o87, &o88);
                        componentIdTmpValue.assign (o88);
                    }
                    out.setComponentId(componentIdValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    uint32 regionIdValue;
                    uint32 &regionIdTmpValue = regionIdValue;
                    dbus_message_iter_get_basic(&o87, &regionIdTmpValue);
                    out.setRegionId(regionIdValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    ::std::string regionNameValue;
                    ::std::string &regionNameTmpValue = regionNameValue;
                    {
                        char* o89 = 0;
                        dbus_message_iter_get_basic(&o87, &o89);
                        regionNameTmpValue.assign (o89);
                    }
                    out.setRegionName(regionNameValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    uint64 currentSizeInBytesValue;
                    uint64 &currentSizeInBytesTmpValue = currentSizeInBytesValue;
                    dbus_message_iter_get_basic(&o87, &currentSizeInBytesTmpValue);
                    out.setCurrentSizeInBytes(currentSizeInBytesValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    bool isRemovableValue;
                    bool &isRemovableTmpValue = isRemovableValue;
                    {
                        dbus_bool_t o90;
                        dbus_message_iter_get_basic(&o87, &o90);
                        isRemovableTmpValue = o90 ? true : false;
                    }
                    out.setIsRemovable(isRemovableValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    bool isInstalledValue;
                    bool &isInstalledTmpValue = isInstalledValue;
                    {
                        dbus_bool_t o91;
                        dbus_message_iter_get_basic(&o87, &o91);
                        isInstalledTmpValue = o91 ? true : false;
                    }
                    out.setIsInstalled(isInstalledValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    uint64 currentVersionIdValue;
                    uint64 &currentVersionIdTmpValue = currentVersionIdValue;
                    dbus_message_iter_get_basic(&o87, &currentVersionIdTmpValue);
                    out.setCurrentVersionId(currentVersionIdValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    uint64 currentVersionDateValue;
                    uint64 &currentVersionDateTmpValue = currentVersionDateValue;
                    dbus_message_iter_get_basic(&o87, &currentVersionDateTmpValue);
                    out.setCurrentVersionDate(currentVersionDateValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    bool isSubscriptionActiveValue;
                    bool &isSubscriptionActiveTmpValue = isSubscriptionActiveValue;
                    {
                        dbus_bool_t o92;
                        dbus_message_iter_get_basic(&o87, &o92);
                        isSubscriptionActiveTmpValue = o92 ? true : false;
                    }
                    out.setIsSubscriptionActive(isSubscriptionActiveValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

                {
                    bool isFavoriteValue;
                    bool &isFavoriteTmpValue = isFavoriteValue;
                    {
                        dbus_bool_t o93;
                        dbus_message_iter_get_basic(&o87, &o93);
                        isFavoriteTmpValue = o93 ? true : false;
                    }
                    out.setIsFavorite(isFavoriteValue);
                }

                if (dbus_message_iter_has_next(&o87)) {
                    dbus_message_iter_next(&o87);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of RegionSet

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet& in, DBusMessageIter* out) {
    {
        DBusMessageIter o94Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o94Struct));
        uint32 o95 = in.getRegionSetId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_UINT32, &o95));
        const char* o96 = in.getRegionSetName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o94Struct, DBUS_TYPE_STRING, &o96));
        DBusMessageIter o97ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o94Struct, DBUS_TYPE_ARRAY, "u", &o97ArrayIter));
        const ::std::vector< uint32 >* o98 = &in.getUpdateRegionIds();
        ::std::vector< uint32 >::const_iterator o99 = o98->end();
        for (::std::vector< uint32 >::const_iterator o100 = o98->begin(); o100 != o99; ++o100) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o97ArrayIter, DBUS_TYPE_UINT32, &(*o100)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o94Struct, &o97ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o94Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet& out) {
    {
        DBusMessageIter o101;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o101);
                {
                    uint32 regionSetIdValue;
                    uint32 &regionSetIdTmpValue = regionSetIdValue;
                    dbus_message_iter_get_basic(&o101, &regionSetIdTmpValue);
                    out.setRegionSetId(regionSetIdValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::std::string regionSetNameValue;
                    ::std::string &regionSetNameTmpValue = regionSetNameValue;
                    {
                        char* o102 = 0;
                        dbus_message_iter_get_basic(&o101, &o102);
                        regionSetNameTmpValue.assign (o102);
                    }
                    out.setRegionSetName(regionSetNameValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::std::vector< uint32 > updateRegionIdsValue;

                    if (dbus_message_iter_get_arg_type(&o101) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o103ArrayIter;
                        dbus_message_iter_recurse (&o101, &o103ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o103ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint32 o104;
                                dbus_message_iter_get_basic(&o103ArrayIter, &o104);
                                updateRegionIdsValue.push_back(o104);
                            } while (dbus_message_iter_next(&o103ArrayIter));
                        }
                    }
                    out.setUpdateRegionIds(updateRegionIdsValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of Product

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::Product& in, DBusMessageIter* out) {
    {
        DBusMessageIter o105Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o105Struct));
        const char* o106 = in.getComponentId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_STRING, &o106));
        uint32 o107 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o107));
        uint32 o108 = in.getSupplierId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o108));
        uint32 o109 = in.getBaselineMapId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o109));
        uint32 o110 = in.getProductGroupId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o110));
        uint32 o111 = in.getProductVersionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o111));
        dbus_bool_t o112 = in.getProductVersionIsDirty() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_BOOLEAN, &o112));
        uint64 o113 = in.getProductVersionDate();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT64, &o113));
        const char* o114 = in.getProductName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_STRING, &o114));
        uint32 o115 = in.getProductTypeMask();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o105Struct, DBUS_TYPE_UINT32, &o115));
        DBusMessageIter o116ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o105Struct, DBUS_TYPE_ARRAY, "(usau)", &o116ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet >* o117 = &in.getRegionSet();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet >::const_iterator o118 = o117->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet >::const_iterator o119 = o117->begin(); o119 != o118; ++o119) {
            serializeDBus((*o119), &o116ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o105Struct, &o116ArrayIter));
        DBusMessageIter o120ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o105Struct, DBUS_TYPE_ARRAY, "(sustbbttbb)", &o120ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion >* o121 = &in.getUpdateRegions();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion >::const_iterator o122 = o121->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion >::const_iterator o123 = o121->begin(); o123 != o122; ++o123) {
            serializeDBus((*o123), &o120ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o105Struct, &o120ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o105Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::Product& out) {
    {
        DBusMessageIter o124;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o124);
                {
                    ::std::string componentIdValue;
                    ::std::string &componentIdTmpValue = componentIdValue;
                    {
                        char* o125 = 0;
                        dbus_message_iter_get_basic(&o124, &o125);
                        componentIdTmpValue.assign (o125);
                    }
                    out.setComponentId(componentIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 productIdValue;
                    uint32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o124, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 supplierIdValue;
                    uint32 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o124, &supplierIdTmpValue);
                    out.setSupplierId(supplierIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 baselineMapIdValue;
                    uint32 &baselineMapIdTmpValue = baselineMapIdValue;
                    dbus_message_iter_get_basic(&o124, &baselineMapIdTmpValue);
                    out.setBaselineMapId(baselineMapIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 productGroupIdValue;
                    uint32 &productGroupIdTmpValue = productGroupIdValue;
                    dbus_message_iter_get_basic(&o124, &productGroupIdTmpValue);
                    out.setProductGroupId(productGroupIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 productVersionIdValue;
                    uint32 &productVersionIdTmpValue = productVersionIdValue;
                    dbus_message_iter_get_basic(&o124, &productVersionIdTmpValue);
                    out.setProductVersionId(productVersionIdValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    bool productVersionIsDirtyValue;
                    bool &productVersionIsDirtyTmpValue = productVersionIsDirtyValue;
                    {
                        dbus_bool_t o126;
                        dbus_message_iter_get_basic(&o124, &o126);
                        productVersionIsDirtyTmpValue = o126 ? true : false;
                    }
                    out.setProductVersionIsDirty(productVersionIsDirtyValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint64 productVersionDateValue;
                    uint64 &productVersionDateTmpValue = productVersionDateValue;
                    dbus_message_iter_get_basic(&o124, &productVersionDateTmpValue);
                    out.setProductVersionDate(productVersionDateValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    ::std::string productNameValue;
                    ::std::string &productNameTmpValue = productNameValue;
                    {
                        char* o127 = 0;
                        dbus_message_iter_get_basic(&o124, &o127);
                        productNameTmpValue.assign (o127);
                    }
                    out.setProductName(productNameValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    uint32 productTypeMaskValue;
                    uint32 &productTypeMaskTmpValue = productTypeMaskValue;
                    dbus_message_iter_get_basic(&o124, &productTypeMaskTmpValue);
                    out.setProductTypeMask(productTypeMaskValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet > regionSetValue;

                    if (dbus_message_iter_get_arg_type(&o124) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o128ArrayIter;
                        dbus_message_iter_recurse (&o124, &o128ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o128ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::RegionSet o129;
                                if (!deserializeDBus(&o128ArrayIter, o129)) {
                                    return false;
                                }
                                regionSetValue.push_back(o129);
                            } while (dbus_message_iter_next(&o128ArrayIter));
                        }
                    }
                    out.setRegionSet(regionSetValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion > updateRegionsValue;

                    if (dbus_message_iter_get_arg_type(&o124) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o130ArrayIter;
                        dbus_message_iter_recurse (&o124, &o130ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o130ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::UpdateRegion o131;
                                if (!deserializeDBus(&o130ArrayIter, o131)) {
                                    return false;
                                }
                                updateRegionsValue.push_back(o131);
                            } while (dbus_message_iter_next(&o130ArrayIter));
                        }
                    }
                    out.setUpdateRegions(updateRegionsValue);
                }

                if (dbus_message_iter_has_next(&o124)) {
                    dbus_message_iter_next(&o124);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NavDataContext

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext& in, DBusMessageIter* out) {
    {
        DBusMessageIter o132Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o132Struct));
        const char* o133 = in.getNavigationSWVersion().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o132Struct, DBUS_TYPE_STRING, &o133));
        const char* o134 = in.getPackageId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o132Struct, DBUS_TYPE_STRING, &o134));
        DBusMessageIter o135ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o132Struct, DBUS_TYPE_ARRAY, "(suuuuubtsua(usau)a(sustbbttbb))", &o135ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product >* o136 = &in.getProducts();
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product >::const_iterator o137 = o136->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product >::const_iterator o138 = o136->begin(); o138 != o137; ++o138) {
            serializeDBus((*o138), &o135ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o132Struct, &o135ArrayIter));
        serializeDBus(in.getStorageSpace(), &o132Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o132Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext& out) {
    {
        DBusMessageIter o139;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o139);
                {
                    ::std::string navigationSWVersionValue;
                    ::std::string &navigationSWVersionTmpValue = navigationSWVersionValue;
                    {
                        char* o140 = 0;
                        dbus_message_iter_get_basic(&o139, &o140);
                        navigationSWVersionTmpValue.assign (o140);
                    }
                    out.setNavigationSWVersion(navigationSWVersionValue);
                }

                if (dbus_message_iter_has_next(&o139)) {
                    dbus_message_iter_next(&o139);
                } else {
                    return true;
                }

                {
                    ::std::string packageIdValue;
                    ::std::string &packageIdTmpValue = packageIdValue;
                    {
                        char* o141 = 0;
                        dbus_message_iter_get_basic(&o139, &o141);
                        packageIdTmpValue.assign (o141);
                    }
                    out.setPackageId(packageIdValue);
                }

                if (dbus_message_iter_has_next(&o139)) {
                    dbus_message_iter_next(&o139);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::Product > productsValue;

                    if (dbus_message_iter_get_arg_type(&o139) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o142ArrayIter;
                        dbus_message_iter_recurse (&o139, &o142ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o142ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationDataUpdateService::Product o143;
                                if (!deserializeDBus(&o142ArrayIter, o143)) {
                                    return false;
                                }
                                productsValue.push_back(o143);
                            } while (dbus_message_iter_next(&o142ArrayIter));
                        }
                    }
                    out.setProducts(productsValue);
                }

                if (dbus_message_iter_has_next(&o139)) {
                    dbus_message_iter_next(&o139);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::StorageSpace storageSpaceValue;
                    if (!deserializeDBus(&o139, storageSpaceValue)) {
                        return false;
                    }
                    out.setStorageSpace(storageSpaceValue);
                }

                if (dbus_message_iter_has_next(&o139)) {
                    dbus_message_iter_next(&o139);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DeviceInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o144Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o144Struct));
        uint32 o145 = in.getDeviceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o144Struct, DBUS_TYPE_UINT32, &o145));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype  o146 = in.getDeviceType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o144Struct, DBUS_TYPE_UINT32, &o146));
        const ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus  o147 = in.getDeviceStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o144Struct, DBUS_TYPE_UINT32, &o147));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o144Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo& out) {
    {
        DBusMessageIter o148;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o148);
                {
                    uint32 DeviceIdValue;
                    uint32 &DeviceIdTmpValue = DeviceIdValue;
                    dbus_message_iter_get_basic(&o148, &DeviceIdTmpValue);
                    out.setDeviceId(DeviceIdValue);
                }

                if (dbus_message_iter_has_next(&o148)) {
                    dbus_message_iter_next(&o148);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype DeviceTypeValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB;
                    dbus_message_iter_get_basic(&o148, &DeviceTypeValue);
                    out.setDeviceType(DeviceTypeValue);
                }

                if (dbus_message_iter_has_next(&o148)) {
                    dbus_message_iter_next(&o148);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus DeviceStatusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicestatus__DEVICESTATUS__AVAILABLE;
                    dbus_message_iter_get_basic(&o148, &DeviceStatusValue);
                    out.setDeviceStatus(DeviceStatusValue);
                }

                if (dbus_message_iter_has_next(&o148)) {
                    dbus_message_iter_next(&o148);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DiagPerformFullUpdateViaUSBResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck  o149 = in.getAck();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o149));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck ackValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceAck__ACCEPTED;
        dbus_message_iter_get_basic(in, &ackValue);
        out.setAck(ackValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetAvailableUpdatesResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getAvailableUpdates(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::AvailableUpdates availableUpdatesValue;
        if (!deserializeDBus(in, availableUpdatesValue)) {
            return false;
        }
        out.setAvailableUpdates(availableUpdatesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeleteUpdateComponentRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest& in, DBusMessageIter* out) {
    uint32 o150 = in.getProductId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o150));
    uint32 o151 = in.getSupplierId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o151));
    DBusMessageIter o152ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o152ArrayIter));
    const ::std::vector< uint32 >* o153 = &in.getRegionId();
    ::std::vector< uint32 >::const_iterator o154 = o153->end();
    for (::std::vector< uint32 >::const_iterator o155 = o153->begin(); o155 != o154; ++o155) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o152ArrayIter, DBUS_TYPE_UINT32, &(*o155)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o152ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest& out) {
    {
        uint32 productIdValue;
        uint32 &productIdTmpValue = productIdValue;
        dbus_message_iter_get_basic(in, &productIdTmpValue);
        out.setProductId(productIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 supplierIdValue;
        uint32 &supplierIdTmpValue = supplierIdValue;
        dbus_message_iter_get_basic(in, &supplierIdTmpValue);
        out.setSupplierId(supplierIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > regionIdValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o156ArrayIter;
            dbus_message_iter_recurse (in, &o156ArrayIter);

            if(dbus_message_iter_get_arg_type(&o156ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o157;
                    dbus_message_iter_get_basic(&o156ArrayIter, &o157);
                    regionIdValue.push_back(o157);
                } while (dbus_message_iter_next(&o156ArrayIter));
            }
        }
        out.setRegionId(regionIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeleteUpdateComponentResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult  o158 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o158));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentResult__DELETED;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetFavoriteUpdateRegionsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest& in, DBusMessageIter* out) {
    uint32 o159 = in.getProductId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o159));
    uint32 o160 = in.getSupplierId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o160));
    uint32 o161 = in.getBaselineMapId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o161));
    DBusMessageIter o162ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o162ArrayIter));
    const ::std::vector< uint32 >* o163 = &in.getUpdateRegionIds();
    ::std::vector< uint32 >::const_iterator o164 = o163->end();
    for (::std::vector< uint32 >::const_iterator o165 = o163->begin(); o165 != o164; ++o165) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o162ArrayIter, DBUS_TYPE_UINT32, &(*o165)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o162ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest& out) {
    {
        uint32 productIdValue;
        uint32 &productIdTmpValue = productIdValue;
        dbus_message_iter_get_basic(in, &productIdTmpValue);
        out.setProductId(productIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 supplierIdValue;
        uint32 &supplierIdTmpValue = supplierIdValue;
        dbus_message_iter_get_basic(in, &supplierIdTmpValue);
        out.setSupplierId(supplierIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 baselineMapIdValue;
        uint32 &baselineMapIdTmpValue = baselineMapIdValue;
        dbus_message_iter_get_basic(in, &baselineMapIdTmpValue);
        out.setBaselineMapId(baselineMapIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > updateRegionIdsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o166ArrayIter;
            dbus_message_iter_recurse (in, &o166ArrayIter);

            if(dbus_message_iter_get_arg_type(&o166ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o167;
                    dbus_message_iter_get_basic(&o166ArrayIter, &o167);
                    updateRegionIdsValue.push_back(o167);
                } while (dbus_message_iter_next(&o166ArrayIter));
            }
        }
        out.setUpdateRegionIds(updateRegionIdsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetFavoriteUpdateRegionsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult  o168 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o168));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsResult__OK;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ClearFavoriteUpdateRegionsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult  o169 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o169));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsResult__OK;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartFullUpdateResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult  o170 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o170));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateResult__ACCEPTED;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartMapDataExportRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest& in, DBusMessageIter* out) {
    uint32 o171 = in.getDeviceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o171));
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype  o172 = in.getDeviceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o172));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest& out) {
    {
        uint32 deviceIdValue;
        uint32 &deviceIdTmpValue = deviceIdValue;
        dbus_message_iter_get_basic(in, &deviceIdTmpValue);
        out.setDeviceId(deviceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype deviceTypeValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::Devicetype__DEVICETYPE__USB;
        dbus_message_iter_get_basic(in, &deviceTypeValue);
        out.setDeviceType(deviceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartMapDataExportResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus  o173 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o173));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus resultValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapExportStartStatus__EXPORT_TRIGGER_SUCCESSFULLY;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FavoriteUpdateRegionsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getFavoriteUpdateRegions(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegions favoriteUpdateRegionsValue;
        if (!deserializeDBus(in, favoriteUpdateRegionsValue)) {
            return false;
        }
        out.setFavoriteUpdateRegions(favoriteUpdateRegionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FavoriteUpdateRegionsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::FavoriteUpdateRegionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InstallationStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getInstallationStatus(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatus installationStatusValue;
        if (!deserializeDBus(in, installationStatusValue)) {
            return false;
        }
        out.setInstallationStatus(installationStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InstallationStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::InstallationStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NavDataStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus  o174 = in.getNavDataStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o174));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus navDataStatusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataStatus__NAVDATA_OK;
        dbus_message_iter_get_basic(in, &navDataStatusValue);
        out.setNavDataStatus(navDataStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavDataStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NavDataContextUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getNavDataContext(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContext navDataContextValue;
        if (!deserializeDBus(in, navDataContextValue)) {
            return false;
        }
        out.setNavDataContext(navDataContextValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavDataContextRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavDataContextRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NavigationDataUpdateStatusInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getNavigationDataUpdateStatusInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfo navigationDataUpdateStatusInfoValue;
        if (!deserializeDBus(in, navigationDataUpdateStatusInfoValue)) {
            return false;
        }
        out.setNavigationDataUpdateStatusInfo(navigationDataUpdateStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavigationDataUpdateStatusInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CatalogueStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus  o175 = in.getCatalogueStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o175));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus catalogueStatusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatus__UNKNOWN;
        dbus_message_iter_get_basic(in, &catalogueStatusValue);
        out.setCatalogueStatus(catalogueStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CatalogueStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::CatalogueStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MapupdateExportStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus  o176 = in.getMapupdateExportStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o176));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus mapupdateExportStatusValue = ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatus__USB_DEVICE_STATUS__SUCCESS;
        dbus_message_iter_get_basic(in, &mapupdateExportStatusValue);
        out.setMapupdateExportStatus(mapupdateExportStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MapupdateExportStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::MapupdateExportStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DeviceInfosUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o177ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uuu)", &o177ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo >* o178 = &in.getDeviceInfos();
    ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo >::const_iterator o179 = o178->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo >::const_iterator o180 = o178->begin(); o180 != o179; ++o180) {
        serializeDBus((*o180), &o177ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o177ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo > deviceInfosValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o181ArrayIter;
            dbus_message_iter_recurse (in, &o181ArrayIter);

            if(dbus_message_iter_get_arg_type(&o181ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfo o182;
                    if (!deserializeDBus(&o181ArrayIter, o182)) {
                        return false;
                    }
                    deviceInfosValue.push_back(o182);
                } while (dbus_message_iter_next(&o181ArrayIter));
            }
        }
        out.setDeviceInfos(deviceInfosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeviceInfosRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationDataUpdateService::DeviceInfosRegister& /*out*/) {
    return true;
}

