/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_NATIVESERVICE2STUB_H
#define COM_BOSCH_NATIVESERVICE2STUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/NativeService2.h"

namespace com {
namespace bosch {
namespace NativeService2 {

class NativeService2StubDelegate;

class NativeService2Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NativeService2Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NativeService2Stub (const std::string& portName);

    /**
     * Create an instance of the NativeService2Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NativeService2Stub (const std::string& portName, const std::string& objectPath);

    virtual ~NativeService2Stub();

    // method 'Service2Method1'

    /**
     * The method onService2Method1() is called by ASF when a client invokes
     * the method 'Service2Method1'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendService2Method1() or sendService2Method1Error() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'Service2Method1'</b>:
     *
     * If the meaning of "Service2Method1" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onService2Method1Request (const ::boost::shared_ptr< Service2Method1Request >& request) = 0;

    /**
     * The method sendService2Method1Response() sends a response of a previous
     * method invocation of 'Service2Method1' back to the client.
     *
     * <b>Documentation of 'Service2Method1'</b>:
     *
     * If the meaning of "Service2Method1" isn't clear, then there should be a description here.
     *
     * @param bOk return value bOk
     *
     * @param act The parameter act identifies a previous invocation of
     * onService2Method1(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendService2Method1Response (bool bOk, act_t act = 0);

    /**
     * The method sendService2Method1Error() sends an error response of a
     * previous method invocation of 'Service2Method1' back to the client.
     *
     * <b>Documentation of 'Service2Method1'</b>:
     *
     * If the meaning of "Service2Method1" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onService2Method1(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendService2Method1Error (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class NativeService2StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NativeService2
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_NATIVESERVICE2STUB_H
