/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_NATIVESERVICE2PROXY_H
#define COM_BOSCH_NATIVESERVICE2PROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/NativeService2.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace com {
namespace bosch {
namespace NativeService2 {

class NativeService2Proxy;

class Service2Method1CallbackIF {
public:
    virtual ~Service2Method1CallbackIF() {}

    virtual void onService2Method1Error(const ::boost::shared_ptr< NativeService2Proxy >& proxy, const ::boost::shared_ptr< Service2Method1Error >& error) = 0;

    virtual void onService2Method1Response(const ::boost::shared_ptr< NativeService2Proxy >& proxy, const ::boost::shared_ptr< Service2Method1Response >& response) = 0;
};


/**
 * NativeService2Proxy is the client side representation of the D-Bus
 * service interface 'com.bosch.NativeService2' (specified in file
 * NativeService_.xml).
 *
 * If the meaning of "com.bosch.NativeService2" isn't clear, then there should be a description here.
 */
class NativeService2Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of NativeService2Proxy.
     */
    static ::boost::shared_ptr< NativeService2Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of NativeService2Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< NativeService2Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of NativeService2Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< NativeService2Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< NativeService2Proxy > proxyNew(new NativeService2Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~NativeService2Proxy ();




    // Method 'Service2Method1'

    /**
     * Call the method 'Service2Method1'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'Service2Method1'</b>:
     *
     * If the meaning of "Service2Method1" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendService2Method1Request(Service2Method1CallbackIF& cb) const;


private:

    NativeService2Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class NativeService2ProxyCallback;
};

} // namespace NativeService2
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_NATIVESERVICE2PROXY_H
