/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/NativeService1.h"
#include "com/bosch/NativeService1DBus.h"
#include "com/bosch/NativeService1Json.h"
#include "com/bosch/NativeService1Stub.h"

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace NativeService1 {

DEFINE_CLASS_LOGGER("/com/bosch/com/bosch/NativeService1", NativeService1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 14, "mountNavishare", 0 },
    { 15, "umountNavishare", 1 },
};


class NativeService1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NativeService1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NativeService1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NativeService1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.NativeService1"),
          _logger(logger) {}

    virtual ~NativeService1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NativeService1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'mountNavishare'

            LOG_DEBUG_STUB("process method '%s'", "mountNavishare");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MountNavishareRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MountNavishare", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MountNavishareRequest > payload = ::boost::static_pointer_cast<MountNavishareRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NativeService1Stub*>(getStub())->onMountNavishareRequest(payload);
            return;
        }
        case 1: {

            // method 'umountNavishare'

            LOG_DEBUG_STUB("process method '%s'", "umountNavishare");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UmountNavishareRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UmountNavishare", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UmountNavishareRequest > payload = ::boost::static_pointer_cast<UmountNavishareRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NativeService1Stub*>(getStub())->onUmountNavishareRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NativeService1StubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.NativeService1\">\n"
            "    <method name=\"mountNavishare\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"umountNavishare\">\n"
            "      <arg direction=\"out\" name=\"bOk\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bOk = return value bOk</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void NativeService1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NativeService1Stub*>(getStub()))->onGetAll (properties);
}

void NativeService1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NativeService1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NativeService1Stub::NativeService1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NativeService1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NativeService1Stub::NativeService1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NativeService1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NativeService1Stub::~NativeService1Stub() {
    delete _stubDelegate;
}

void  NativeService1Stub::sendMountNavishareResponse (bool bOk, act_t act) {
    MountNavishareResponse* payload = new MountNavishareResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "mountNavishare", MountNavishareResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MountNavishare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NativeService1Stub::sendMountNavishareError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MountNavishareError* payload = new MountNavishareError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "mountNavishare", MountNavishareError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MountNavishare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NativeService1Stub::sendUmountNavishareResponse (bool bOk, act_t act) {
    UmountNavishareResponse* payload = new UmountNavishareResponse(bOk);
    DBUS_MESSAGE_REPLY(dbusMessage, "umountNavishare", UmountNavishareResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UmountNavishare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NativeService1Stub::sendUmountNavishareError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UmountNavishareError* payload = new UmountNavishareError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "umountNavishare", UmountNavishareError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UmountNavishare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NativeService1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace NativeService1
} // namespace bosch
} // namespace com
