/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgLCMInterface.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceJson.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgLCMInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgLCMInterface", NanoMsgLCMInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "ReqShutdown", 3 },
    { 13, "ReqHealthCare", 5 },
    { 15, "ReqGetPowerMode", 1 },
    { 15, "ReqSetChainMode", 4 },
    { 15, "ReqSetPowerMode", 0 },
    { 18, "ReqGetWakeupReason", 2 },
};


class NanoMsgLCMInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    NanoMsgLCMInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    NanoMsgLCMInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    NanoMsgLCMInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.di.NanoMsgLCMInterface"),
          _logger(logger) {}

    virtual ~NanoMsgLCMInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void NanoMsgLCMInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ReqSetPowerMode'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetPowerMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetPowerModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetPowerMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetPowerModeRequest > payload = ::boost::static_pointer_cast<ReqSetPowerModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqSetPowerModeRequest(payload);
            return;
        }
        case 1: {

            // method 'ReqGetPowerMode'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetPowerMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetPowerModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetPowerMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetPowerModeRequest > payload = ::boost::static_pointer_cast<ReqGetPowerModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqGetPowerModeRequest(payload);
            return;
        }
        case 2: {

            // method 'ReqGetWakeupReason'

            LOG_DEBUG_STUB("process method '%s'", "ReqGetWakeupReason");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetWakeupReasonRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqGetWakeupReason", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqGetWakeupReasonRequest > payload = ::boost::static_pointer_cast<ReqGetWakeupReasonRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqGetWakeupReasonRequest(payload);
            return;
        }
        case 3: {

            // method 'ReqShutdown'

            LOG_DEBUG_STUB("process method '%s'", "ReqShutdown");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqShutdownRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqShutdown", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqShutdownRequest > payload = ::boost::static_pointer_cast<ReqShutdownRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqShutdownRequest(payload);
            return;
        }
        case 4: {

            // method 'ReqSetChainMode'

            LOG_DEBUG_STUB("process method '%s'", "ReqSetChainMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetChainModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqSetChainMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqSetChainModeRequest > payload = ::boost::static_pointer_cast<ReqSetChainModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqSetChainModeRequest(payload);
            return;
        }
        case 5: {

            // method 'ReqHealthCare'

            LOG_DEBUG_STUB("process method '%s'", "ReqHealthCare");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqHealthCareRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqHealthCare", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqHealthCareRequest > payload = ::boost::static_pointer_cast<ReqHealthCareRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<NanoMsgLCMInterfaceStub*>(getStub())->onReqHealthCareRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* NanoMsgLCMInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.di.NanoMsgLCMInterface\">\n"
            "    <method name=\"ReqSetPowerMode\">\n"
            "      <doc>\n"
            "        <line>ReqSetPowerMode = ReqSetPowerMode = Method to request for setting Power Mode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"PowerMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>PowerMode (of type entPowerMode) = Description missing</line>\n"
            "          <line>enum[enPowerMode_OFF (0x0001), enPowerMode_Stand_By (0x0002), enPowerMode_User_Off (0x0003), enPowerMode_System_Start_Up (0x0004), enPowerMode_ON (0x0005), enPowerMode_Hour_Logic (0x0006), enPowerMode_Diagnosis (0x0007), enPowerMode_Software_Update (0x0008), enPowerMode_Protected_Off (0x0009), enPowerMode_Undefined (0x00FF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetPowerMode\">\n"
            "      <doc>\n"
            "        <line>ReqGetPowerMode = ReqGetPowerMode = Method to request for getting Power Mode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqGetWakeupReason\">\n"
            "      <doc>\n"
            "        <line>ReqGetWakeupReason = ReqGetWakeupReason = Method to request for getting WakeupReason</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqShutdown\">\n"
            "      <doc>\n"
            "        <line>ReqShutdown = ReqShutdown = Method to request for Shutdown</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"timeout\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>timeout = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqSetChainMode\">\n"
            "      <arg direction=\"in\" name=\"PowerMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>PowerMode (of type entPowerMode) = Description missing</line>\n"
            "          <line>enum[enPowerMode_OFF (0x0001), enPowerMode_Stand_By (0x0002), enPowerMode_User_Off (0x0003), enPowerMode_System_Start_Up (0x0004), enPowerMode_ON (0x0005), enPowerMode_Hour_Logic (0x0006), enPowerMode_Diagnosis (0x0007), enPowerMode_Software_Update (0x0008), enPowerMode_Protected_Off (0x0009), enPowerMode_Undefined (0x00FF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"tChain\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>tChain = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqHealthCare\">\n"
            "      <doc>\n"
            "        <line>ReqHealthCare = ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DestIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DestIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sig_RspSetPowerMode\">\n"
            "      <doc>\n"
            "        <line>sig_RspSetPowerMode = RspSetPowerMode = response to  ReqSetPowerMode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetPowerMode\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetPowerMode = RspGetPowerMode = response to  ReqGetPowerMode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"PowerMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>PowerMode (of type entPowerMode) = Description missing</line>\n"
            "          <line>enum[enPowerMode_OFF (0x0001), enPowerMode_Stand_By (0x0002), enPowerMode_User_Off (0x0003), enPowerMode_System_Start_Up (0x0004), enPowerMode_ON (0x0005), enPowerMode_Hour_Logic (0x0006), enPowerMode_Diagnosis (0x0007), enPowerMode_Software_Update (0x0008), enPowerMode_Protected_Off (0x0009), enPowerMode_Undefined (0x00FF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventPowerModeChange\">\n"
            "      <doc>\n"
            "        <line>sig_EventPowerModeChange = EventPowerModeChange = response to  EventPowerModeChange</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"PowerMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>PowerMode (of type entPowerMode) = Description missing</line>\n"
            "          <line>enum[enPowerMode_OFF (0x0001), enPowerMode_Stand_By (0x0002), enPowerMode_User_Off (0x0003), enPowerMode_System_Start_Up (0x0004), enPowerMode_ON (0x0005), enPowerMode_Hour_Logic (0x0006), enPowerMode_Diagnosis (0x0007), enPowerMode_Software_Update (0x0008), enPowerMode_Protected_Off (0x0009), enPowerMode_Undefined (0x00FF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspGetWakeupReason\">\n"
            "      <doc>\n"
            "        <line>sig_RspGetWakeupReason = RspGetWakeupReason = response to WakeupReason</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"WakeupReason\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>WakeupReason = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspShutdown\">\n"
            "      <doc>\n"
            "        <line>sig_RspShutdown = RspShutdown = response to Shutdown</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspSetChainMode\">\n"
            "      <arg direction=\"out\" name=\"tRet\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>tRet = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_RspHealthCare\">\n"
            "      <doc>\n"
            "        <line>sig_RspHealthCare = RspHealthCare = 0x0031 response to Request HealthCare</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"PowerMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>PowerMode (of type entPowerMode) = Description missing</line>\n"
            "          <line>enum[enPowerMode_OFF (0x0001), enPowerMode_Stand_By (0x0002), enPowerMode_User_Off (0x0003), enPowerMode_System_Start_Up (0x0004), enPowerMode_ON (0x0005), enPowerMode_Hour_Logic (0x0006), enPowerMode_Diagnosis (0x0007), enPowerMode_Software_Update (0x0008), enPowerMode_Protected_Off (0x0009), enPowerMode_Undefined (0x00FF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_EventDtcOccurance\">\n"
            "      <doc>\n"
            "        <line>sig_EventDtcOccurance = EventDtcOccurance = 0x0032 Any component sends an event EventDtcOccurance if a DTC status has changed, occurred or vanished</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DtcTable\" type=\"ay\">\n"
            "        <doc>\n"
            "          <line>DtcTable = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Msg_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Msg_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"RecevedIP\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>RecevedIP = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void NanoMsgLCMInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<NanoMsgLCMInterfaceStub*>(getStub()))->onGetAll (properties);
}

void NanoMsgLCMInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void NanoMsgLCMInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

NanoMsgLCMInterfaceStub::NanoMsgLCMInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgLCMInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgLCMInterfaceStub::NanoMsgLCMInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new NanoMsgLCMInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

NanoMsgLCMInterfaceStub::~NanoMsgLCMInterfaceStub() {
    delete _stubDelegate;
}

void NanoMsgLCMInterfaceStub::sendSig_RspSetPowerModeSignal(uint16 status, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspSetPowerModeSignal* payload = new Sig_RspSetPowerModeSignal(status, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspSetPowerMode", Sig_RspSetPowerModeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspSetPowerMode");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspSetPowerMode");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_RspGetPowerModeSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetPowerModeSignal* payload = new Sig_RspGetPowerModeSignal(powerMode, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetPowerMode", Sig_RspGetPowerModeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetPowerMode");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetPowerMode");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_EventPowerModeChangeSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventPowerModeChangeSignal* payload = new Sig_EventPowerModeChangeSignal(powerMode, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventPowerModeChange", Sig_EventPowerModeChangeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventPowerModeChange");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventPowerModeChange");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_RspGetWakeupReasonSignal(entWakeupReason wakeupReason, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspGetWakeupReasonSignal* payload = new Sig_RspGetWakeupReasonSignal(wakeupReason, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspGetWakeupReason", Sig_RspGetWakeupReasonSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspGetWakeupReason");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspGetWakeupReason");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_RspShutdownSignal(uint16 status, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspShutdownSignal* payload = new Sig_RspShutdownSignal(status, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspShutdown", Sig_RspShutdownSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspShutdown");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspShutdown");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_RspSetChainModeSignal(eniRet tRet, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspSetChainModeSignal* payload = new Sig_RspSetChainModeSignal(tRet, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspSetChainMode", Sig_RspSetChainModeSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspSetChainMode");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspSetChainMode");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_RspHealthCareSignal(entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_RspHealthCareSignal* payload = new Sig_RspHealthCareSignal(powerMode, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_RspHealthCare", Sig_RspHealthCareSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_RspHealthCare");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_RspHealthCare");
    }
}

void NanoMsgLCMInterfaceStub::sendSig_EventDtcOccuranceSignal(const ::std::vector< uint8 >& dtcTable, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& recevedIP) {
    if (_stubDelegate->isConnected()) {
        Sig_EventDtcOccuranceSignal* payload = new Sig_EventDtcOccuranceSignal(dtcTable, dev_ID, dev_Nr, msg_ID, recevedIP);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_EventDtcOccurance", Sig_EventDtcOccuranceSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_EventDtcOccurance");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_EventDtcOccurance");
    }
}

void  NanoMsgLCMInterfaceStub::sendReqSetPowerModeResponse (bool response, act_t act) {
    ReqSetPowerModeResponse* payload = new ReqSetPowerModeResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetPowerMode", ReqSetPowerModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetPowerMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqSetPowerModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetPowerModeError* payload = new ReqSetPowerModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetPowerMode", ReqSetPowerModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetPowerMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqGetPowerModeResponse (bool response, act_t act) {
    ReqGetPowerModeResponse* payload = new ReqGetPowerModeResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetPowerMode", ReqGetPowerModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetPowerMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqGetPowerModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetPowerModeError* payload = new ReqGetPowerModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetPowerMode", ReqGetPowerModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetPowerMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqGetWakeupReasonResponse (bool response, act_t act) {
    ReqGetWakeupReasonResponse* payload = new ReqGetWakeupReasonResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqGetWakeupReason", ReqGetWakeupReasonResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqGetWakeupReason", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqGetWakeupReasonError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqGetWakeupReasonError* payload = new ReqGetWakeupReasonError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqGetWakeupReason", ReqGetWakeupReasonError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqGetWakeupReason", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqShutdownResponse (bool response, act_t act) {
    ReqShutdownResponse* payload = new ReqShutdownResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqShutdown", ReqShutdownResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqShutdown", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqShutdownError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqShutdownError* payload = new ReqShutdownError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqShutdown", ReqShutdownError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqShutdown", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqSetChainModeResponse (bool response, act_t act) {
    ReqSetChainModeResponse* payload = new ReqSetChainModeResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqSetChainMode", ReqSetChainModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqSetChainMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqSetChainModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqSetChainModeError* payload = new ReqSetChainModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqSetChainMode", ReqSetChainModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqSetChainMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqHealthCareResponse (bool response, act_t act) {
    ReqHealthCareResponse* payload = new ReqHealthCareResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqHealthCare", ReqHealthCareResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqHealthCare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  NanoMsgLCMInterfaceStub::sendReqHealthCareError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqHealthCareError* payload = new ReqHealthCareError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqHealthCare", ReqHealthCareError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqHealthCare", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void NanoMsgLCMInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace NanoMsgLCMInterface
} // namespace di
} // namespace cm
} // namespace bosch
