/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGLCMINTERFACEPROXY_H
#define BOSCH_CM_DI_NANOMSGLCMINTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgLCMInterface.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgLCMInterface {

class NanoMsgLCMInterfaceProxy;

class ReqGetPowerModeCallbackIF {
public:
    virtual ~ReqGetPowerModeCallbackIF() {}

    virtual void onReqGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeError >& error) = 0;

    virtual void onReqGetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeResponse >& response) = 0;
};

class ReqGetWakeupReasonCallbackIF {
public:
    virtual ~ReqGetWakeupReasonCallbackIF() {}

    virtual void onReqGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonError >& error) = 0;

    virtual void onReqGetWakeupReasonResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonResponse >& response) = 0;
};

class ReqHealthCareCallbackIF {
public:
    virtual ~ReqHealthCareCallbackIF() {}

    virtual void onReqHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareError >& error) = 0;

    virtual void onReqHealthCareResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareResponse >& response) = 0;
};

class ReqSetChainModeCallbackIF {
public:
    virtual ~ReqSetChainModeCallbackIF() {}

    virtual void onReqSetChainModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetChainModeError >& error) = 0;

    virtual void onReqSetChainModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetChainModeResponse >& response) = 0;
};

class ReqSetPowerModeCallbackIF {
public:
    virtual ~ReqSetPowerModeCallbackIF() {}

    virtual void onReqSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeError >& error) = 0;

    virtual void onReqSetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeResponse >& response) = 0;
};

class ReqShutdownCallbackIF {
public:
    virtual ~ReqShutdownCallbackIF() {}

    virtual void onReqShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownError >& error) = 0;

    virtual void onReqShutdownResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownResponse >& response) = 0;
};

class Sig_EventDtcOccuranceCallbackIF {
public:
    virtual ~Sig_EventDtcOccuranceCallbackIF() {}

    virtual void onSig_EventDtcOccuranceError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceError >& error) = 0;

    virtual void onSig_EventDtcOccuranceSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceSignal >& signal) = 0;
};

class Sig_EventPowerModeChangeCallbackIF {
public:
    virtual ~Sig_EventPowerModeChangeCallbackIF() {}

    virtual void onSig_EventPowerModeChangeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeError >& error) = 0;

    virtual void onSig_EventPowerModeChangeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeSignal >& signal) = 0;
};

class Sig_RspGetPowerModeCallbackIF {
public:
    virtual ~Sig_RspGetPowerModeCallbackIF() {}

    virtual void onSig_RspGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeError >& error) = 0;

    virtual void onSig_RspGetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeSignal >& signal) = 0;
};

class Sig_RspGetWakeupReasonCallbackIF {
public:
    virtual ~Sig_RspGetWakeupReasonCallbackIF() {}

    virtual void onSig_RspGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonError >& error) = 0;

    virtual void onSig_RspGetWakeupReasonSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonSignal >& signal) = 0;
};

class Sig_RspHealthCareCallbackIF {
public:
    virtual ~Sig_RspHealthCareCallbackIF() {}

    virtual void onSig_RspHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareError >& error) = 0;

    virtual void onSig_RspHealthCareSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareSignal >& signal) = 0;
};

class Sig_RspSetChainModeCallbackIF {
public:
    virtual ~Sig_RspSetChainModeCallbackIF() {}

    virtual void onSig_RspSetChainModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetChainModeError >& error) = 0;

    virtual void onSig_RspSetChainModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetChainModeSignal >& signal) = 0;
};

class Sig_RspSetPowerModeCallbackIF {
public:
    virtual ~Sig_RspSetPowerModeCallbackIF() {}

    virtual void onSig_RspSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeError >& error) = 0;

    virtual void onSig_RspSetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeSignal >& signal) = 0;
};

class Sig_RspShutdownCallbackIF {
public:
    virtual ~Sig_RspShutdownCallbackIF() {}

    virtual void onSig_RspShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownError >& error) = 0;

    virtual void onSig_RspShutdownSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownSignal >& signal) = 0;
};


/**
 * NanoMsgLCMInterfaceProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.di.NanoMsgLCMInterface' (specified in file
 * LCMDBUSInterface_.xml).
 *
 * If the meaning of "bosch.cm.di.NanoMsgLCMInterface" isn't clear, then there should be a description here.
 */
class NanoMsgLCMInterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of NanoMsgLCMInterfaceProxy.
     */
    static ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of NanoMsgLCMInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of NanoMsgLCMInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > proxyNew(new NanoMsgLCMInterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~NanoMsgLCMInterfaceProxy ();


    // Signal 'sig_RspSetPowerMode'

    /**
     * Notify on the signal 'sig_RspSetPowerMode'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspSetPowerMode'</b>:
     *
     * RspSetPowerMode = response to  ReqSetPowerMode
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspSetPowerModeRegister(Sig_RspSetPowerModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspSetPowerMode'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspSetPowerMode'</b>:
     *
     * RspSetPowerMode = response to  ReqSetPowerMode
     *
     * @param act The act which was previously returned by the
     * sendSig_RspSetPowerModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspSetPowerModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspSetPowerMode'.
     */
    void sendSig_RspSetPowerModeDeregisterAll () const;

    // Signal 'sig_RspGetPowerMode'

    /**
     * Notify on the signal 'sig_RspGetPowerMode'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetPowerMode'</b>:
     *
     * RspGetPowerMode = response to  ReqGetPowerMode
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspGetPowerModeRegister(Sig_RspGetPowerModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspGetPowerMode'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetPowerMode'</b>:
     *
     * RspGetPowerMode = response to  ReqGetPowerMode
     *
     * @param act The act which was previously returned by the
     * sendSig_RspGetPowerModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspGetPowerModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspGetPowerMode'.
     */
    void sendSig_RspGetPowerModeDeregisterAll () const;

    // Signal 'sig_EventPowerModeChange'

    /**
     * Notify on the signal 'sig_EventPowerModeChange'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventPowerModeChange'</b>:
     *
     * EventPowerModeChange = response to  EventPowerModeChange
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventPowerModeChangeRegister(Sig_EventPowerModeChangeCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventPowerModeChange'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventPowerModeChange'</b>:
     *
     * EventPowerModeChange = response to  EventPowerModeChange
     *
     * @param act The act which was previously returned by the
     * sendSig_EventPowerModeChangeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventPowerModeChangeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_EventPowerModeChange'.
     */
    void sendSig_EventPowerModeChangeDeregisterAll () const;

    // Signal 'sig_RspGetWakeupReason'

    /**
     * Notify on the signal 'sig_RspGetWakeupReason'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetWakeupReason'</b>:
     *
     * RspGetWakeupReason = response to WakeupReason
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspGetWakeupReasonRegister(Sig_RspGetWakeupReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspGetWakeupReason'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetWakeupReason'</b>:
     *
     * RspGetWakeupReason = response to WakeupReason
     *
     * @param act The act which was previously returned by the
     * sendSig_RspGetWakeupReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspGetWakeupReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspGetWakeupReason'.
     */
    void sendSig_RspGetWakeupReasonDeregisterAll () const;

    // Signal 'sig_RspShutdown'

    /**
     * Notify on the signal 'sig_RspShutdown'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspShutdown'</b>:
     *
     * RspShutdown = response to Shutdown
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspShutdownRegister(Sig_RspShutdownCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspShutdown'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspShutdown'</b>:
     *
     * RspShutdown = response to Shutdown
     *
     * @param act The act which was previously returned by the
     * sendSig_RspShutdownRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspShutdownDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspShutdown'.
     */
    void sendSig_RspShutdownDeregisterAll () const;

    // Signal 'sig_RspSetChainMode'

    /**
     * Notify on the signal 'sig_RspSetChainMode'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspSetChainMode'</b>:
     *
     * If the meaning of "sig_RspSetChainMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspSetChainModeRegister(Sig_RspSetChainModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspSetChainMode'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspSetChainMode'</b>:
     *
     * If the meaning of "sig_RspSetChainMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSig_RspSetChainModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspSetChainModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspSetChainMode'.
     */
    void sendSig_RspSetChainModeDeregisterAll () const;

    // Signal 'sig_RspHealthCare'

    /**
     * Notify on the signal 'sig_RspHealthCare'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspHealthCare'</b>:
     *
     * RspHealthCare = 0x0031 response to Request HealthCare
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspHealthCareRegister(Sig_RspHealthCareCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspHealthCare'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspHealthCare'</b>:
     *
     * RspHealthCare = 0x0031 response to Request HealthCare
     *
     * @param act The act which was previously returned by the
     * sendSig_RspHealthCareRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspHealthCareDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspHealthCare'.
     */
    void sendSig_RspHealthCareDeregisterAll () const;

    // Signal 'sig_EventDtcOccurance'

    /**
     * Notify on the signal 'sig_EventDtcOccurance'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventDtcOccurance'</b>:
     *
     * EventDtcOccurance = 0x0032 Any component sends an event EventDtcOccurance if a DTC status has changed, occurred or vanished
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventDtcOccuranceRegister(Sig_EventDtcOccuranceCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventDtcOccurance'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventDtcOccurance'</b>:
     *
     * EventDtcOccurance = 0x0032 Any component sends an event EventDtcOccurance if a DTC status has changed, occurred or vanished
     *
     * @param act The act which was previously returned by the
     * sendSig_EventDtcOccuranceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventDtcOccuranceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_EventDtcOccurance'.
     */
    void sendSig_EventDtcOccuranceDeregisterAll () const;



    // Method 'ReqSetPowerMode'

    /**
     * Call the method 'ReqSetPowerMode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqSetPowerMode'</b>:
     *
     * ReqSetPowerMode = Method to request for setting Power Mode
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param PowerMode If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqSetPowerModeRequest(ReqSetPowerModeCallbackIF& cb, entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetPowerMode'

    /**
     * Call the method 'ReqGetPowerMode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqGetPowerMode'</b>:
     *
     * ReqGetPowerMode = Method to request for getting Power Mode
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetPowerModeRequest(ReqGetPowerModeCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetWakeupReason'

    /**
     * Call the method 'ReqGetWakeupReason'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqGetWakeupReason'</b>:
     *
     * ReqGetWakeupReason = Method to request for getting WakeupReason
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetWakeupReasonRequest(ReqGetWakeupReasonCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqShutdown'

    /**
     * Call the method 'ReqShutdown'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ReqShutdown'</b>:
     *
     * ReqShutdown = Method to request for Shutdown
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param timeout If the meaning of "timeout" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqShutdownRequest(ReqShutdownCallbackIF& cb, uint16 timeout, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqSetChainMode'

    /**
     * Call the method 'ReqSetChainMode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqSetChainMode'</b>:
     *
     * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param PowerMode If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param tChain If the meaning of "tChain" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqSetChainModeRequest(ReqSetChainModeCallbackIF& cb, entPowerMode powerMode, uint16 tChain, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqHealthCare'

    /**
     * Call the method 'ReqHealthCare'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqHealthCare'</b>:
     *
     * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqHealthCareRequest(ReqHealthCareCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    NanoMsgLCMInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class NanoMsgLCMInterfaceProxyCallback;
};

} // namespace NanoMsgLCMInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGLCMINTERFACEPROXY_H
