/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgLCMInterface.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceJson.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgLCMInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgLCMInterface", NanoMsgLCMInterfaceProxy);

class NanoMsgLCMInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NanoMsgLCMInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< NanoMsgLCMInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sig_RspSetPowerMode:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspSetPowerModeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspSetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspSetPowerModeSignal> payload = ::boost::static_pointer_cast<Sig_RspSetPowerModeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspSetPowerModeCallbackIF*) _callback)->onSig_RspSetPowerModeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetPowerMode:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetPowerModeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetPowerModeSignal> payload = ::boost::static_pointer_cast<Sig_RspGetPowerModeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetPowerModeCallbackIF*) _callback)->onSig_RspGetPowerModeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventPowerModeChange:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventPowerModeChangeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventPowerModeChange", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventPowerModeChangeSignal> payload = ::boost::static_pointer_cast<Sig_EventPowerModeChangeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventPowerModeChangeCallbackIF*) _callback)->onSig_EventPowerModeChangeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetWakeupReason:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetWakeupReasonSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetWakeupReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetWakeupReasonSignal> payload = ::boost::static_pointer_cast<Sig_RspGetWakeupReasonSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetWakeupReasonCallbackIF*) _callback)->onSig_RspGetWakeupReasonSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspShutdown:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspShutdownSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspShutdown", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspShutdownSignal> payload = ::boost::static_pointer_cast<Sig_RspShutdownSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspShutdownCallbackIF*) _callback)->onSig_RspShutdownSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspSetChainMode:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspSetChainModeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspSetChainMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspSetChainModeSignal> payload = ::boost::static_pointer_cast<Sig_RspSetChainModeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspSetChainModeCallbackIF*) _callback)->onSig_RspSetChainModeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspHealthCare:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspHealthCareSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspHealthCare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspHealthCareSignal> payload = ::boost::static_pointer_cast<Sig_RspHealthCareSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspHealthCareCallbackIF*) _callback)->onSig_RspHealthCareSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventDtcOccurance:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventDtcOccuranceSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventDtcOccurance", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventDtcOccuranceSignal> payload = ::boost::static_pointer_cast<Sig_EventDtcOccuranceSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventDtcOccuranceCallbackIF*) _callback)->onSig_EventDtcOccuranceSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ReqSetPowerMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetPowerModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetPowerModeError> payload = ::boost::static_pointer_cast<ReqSetPowerModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetPowerModeCallbackIF*) _callback)->onReqSetPowerModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetPowerModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetPowerModeResponse> payload = ::boost::static_pointer_cast<ReqSetPowerModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetPowerModeCallbackIF*) _callback)->onReqSetPowerModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetPowerMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetPowerModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetPowerModeError> payload = ::boost::static_pointer_cast<ReqGetPowerModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetPowerModeCallbackIF*) _callback)->onReqGetPowerModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetPowerModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetPowerMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetPowerModeResponse> payload = ::boost::static_pointer_cast<ReqGetPowerModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetPowerModeCallbackIF*) _callback)->onReqGetPowerModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetWakeupReason:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetWakeupReasonError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetWakeupReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetWakeupReasonError> payload = ::boost::static_pointer_cast<ReqGetWakeupReasonError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetWakeupReasonCallbackIF*) _callback)->onReqGetWakeupReasonError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetWakeupReasonResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetWakeupReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetWakeupReasonResponse> payload = ::boost::static_pointer_cast<ReqGetWakeupReasonResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetWakeupReasonCallbackIF*) _callback)->onReqGetWakeupReasonResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqShutdown:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqShutdownError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqShutdown", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqShutdownError> payload = ::boost::static_pointer_cast<ReqShutdownError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqShutdownCallbackIF*) _callback)->onReqShutdownError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqShutdownResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqShutdown", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqShutdownResponse> payload = ::boost::static_pointer_cast<ReqShutdownResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqShutdownCallbackIF*) _callback)->onReqShutdownResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqSetChainMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetChainModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetChainMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetChainModeError> payload = ::boost::static_pointer_cast<ReqSetChainModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetChainModeCallbackIF*) _callback)->onReqSetChainModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetChainModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetChainMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetChainModeResponse> payload = ::boost::static_pointer_cast<ReqSetChainModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetChainModeCallbackIF*) _callback)->onReqSetChainModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqHealthCare:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqHealthCareError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqHealthCare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqHealthCareError> payload = ::boost::static_pointer_cast<ReqHealthCareError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqHealthCareCallbackIF*) _callback)->onReqHealthCareError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqHealthCareResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqHealthCare", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqHealthCareResponse> payload = ::boost::static_pointer_cast<ReqHealthCareResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqHealthCareCallbackIF*) _callback)->onReqHealthCareResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sig_RspSetPowerMode: {
                ::boost::shared_ptr< Sig_RspSetPowerModeError > payload = ::boost::shared_ptr< Sig_RspSetPowerModeError >
                (new Sig_RspSetPowerModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspSetPowerMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspSetPowerModeCallbackIF*) _callback)->onSig_RspSetPowerModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetPowerMode: {
                ::boost::shared_ptr< Sig_RspGetPowerModeError > payload = ::boost::shared_ptr< Sig_RspGetPowerModeError >
                (new Sig_RspGetPowerModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetPowerMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetPowerModeCallbackIF*) _callback)->onSig_RspGetPowerModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventPowerModeChange: {
                ::boost::shared_ptr< Sig_EventPowerModeChangeError > payload = ::boost::shared_ptr< Sig_EventPowerModeChangeError >
                (new Sig_EventPowerModeChangeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventPowerModeChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventPowerModeChangeCallbackIF*) _callback)->onSig_EventPowerModeChangeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetWakeupReason: {
                ::boost::shared_ptr< Sig_RspGetWakeupReasonError > payload = ::boost::shared_ptr< Sig_RspGetWakeupReasonError >
                (new Sig_RspGetWakeupReasonError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetWakeupReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetWakeupReasonCallbackIF*) _callback)->onSig_RspGetWakeupReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspShutdown: {
                ::boost::shared_ptr< Sig_RspShutdownError > payload = ::boost::shared_ptr< Sig_RspShutdownError >
                (new Sig_RspShutdownError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspShutdown", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspShutdownCallbackIF*) _callback)->onSig_RspShutdownError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspSetChainMode: {
                ::boost::shared_ptr< Sig_RspSetChainModeError > payload = ::boost::shared_ptr< Sig_RspSetChainModeError >
                (new Sig_RspSetChainModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspSetChainMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspSetChainModeCallbackIF*) _callback)->onSig_RspSetChainModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspHealthCare: {
                ::boost::shared_ptr< Sig_RspHealthCareError > payload = ::boost::shared_ptr< Sig_RspHealthCareError >
                (new Sig_RspHealthCareError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspHealthCare", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspHealthCareCallbackIF*) _callback)->onSig_RspHealthCareError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventDtcOccurance: {
                ::boost::shared_ptr< Sig_EventDtcOccuranceError > payload = ::boost::shared_ptr< Sig_EventDtcOccuranceError >
                (new Sig_EventDtcOccuranceError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventDtcOccurance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventDtcOccuranceCallbackIF*) _callback)->onSig_EventDtcOccuranceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetPowerMode: {
                ::boost::shared_ptr< ReqSetPowerModeError > payload = ::boost::shared_ptr< ReqSetPowerModeError >
                (new ReqSetPowerModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetPowerMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetPowerModeCallbackIF*) _callback)->onReqSetPowerModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetPowerMode: {
                ::boost::shared_ptr< ReqGetPowerModeError > payload = ::boost::shared_ptr< ReqGetPowerModeError >
                (new ReqGetPowerModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetPowerMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetPowerModeCallbackIF*) _callback)->onReqGetPowerModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetWakeupReason: {
                ::boost::shared_ptr< ReqGetWakeupReasonError > payload = ::boost::shared_ptr< ReqGetWakeupReasonError >
                (new ReqGetWakeupReasonError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetWakeupReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetWakeupReasonCallbackIF*) _callback)->onReqGetWakeupReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqShutdown: {
                ::boost::shared_ptr< ReqShutdownError > payload = ::boost::shared_ptr< ReqShutdownError >
                (new ReqShutdownError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqShutdown", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqShutdownCallbackIF*) _callback)->onReqShutdownError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetChainMode: {
                ::boost::shared_ptr< ReqSetChainModeError > payload = ::boost::shared_ptr< ReqSetChainModeError >
                (new ReqSetChainModeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetChainMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetChainModeCallbackIF*) _callback)->onReqSetChainModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqHealthCare: {
                ::boost::shared_ptr< ReqHealthCareError > payload = ::boost::shared_ptr< ReqHealthCareError >
                (new ReqHealthCareError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgLCMInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqHealthCare", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgLCMInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqHealthCareCallbackIF*) _callback)->onReqHealthCareError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NanoMsgLCMInterfaceProxyCallback::_logger (NanoMsgLCMInterfaceProxy::_logger);

NanoMsgLCMInterfaceProxy::NanoMsgLCMInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.di.NanoMsgLCMInterface", serviceAvailable, _logger) {
}

NanoMsgLCMInterfaceProxy::~NanoMsgLCMInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NanoMsgLCMInterfaceProxy > NanoMsgLCMInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NanoMsgLCMInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > proxyNew(new NanoMsgLCMInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t NanoMsgLCMInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NanoMsgLCMInterfaceProxyCallback* callback = new NanoMsgLCMInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NanoMsgLCMInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NanoMsgLCMInterfaceProxyCallback* callback = new NanoMsgLCMInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void NanoMsgLCMInterfaceProxy::sendDeregisterAll () const
{
    sendSig_RspSetPowerModeDeregisterAll();
    sendSig_RspGetPowerModeDeregisterAll();
    sendSig_EventPowerModeChangeDeregisterAll();
    sendSig_RspGetWakeupReasonDeregisterAll();
    sendSig_RspShutdownDeregisterAll();
    sendSig_RspSetChainModeDeregisterAll();
    sendSig_RspHealthCareDeregisterAll();
    sendSig_EventDtcOccuranceDeregisterAll();
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspSetPowerModeRegister(Sig_RspSetPowerModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspSetPowerMode");
    act_t act = addSignalCallback(ID_sig_RspSetPowerMode, "sig_RspSetPowerMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspSetPowerMode", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspSetPowerModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspSetPowerMode", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspSetPowerMode", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspSetPowerModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspSetPowerMode");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspSetPowerMode", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspGetPowerModeRegister(Sig_RspGetPowerModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetPowerMode");
    act_t act = addSignalCallback(ID_sig_RspGetPowerMode, "sig_RspGetPowerMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetPowerMode", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspGetPowerModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetPowerMode", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetPowerMode", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspGetPowerModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetPowerMode");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetPowerMode", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_EventPowerModeChangeRegister(Sig_EventPowerModeChangeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventPowerModeChange");
    act_t act = addSignalCallback(ID_sig_EventPowerModeChange, "sig_EventPowerModeChange", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventPowerModeChange", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_EventPowerModeChangeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventPowerModeChange", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventPowerModeChange", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_EventPowerModeChangeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventPowerModeChange");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventPowerModeChange", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspGetWakeupReasonRegister(Sig_RspGetWakeupReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetWakeupReason");
    act_t act = addSignalCallback(ID_sig_RspGetWakeupReason, "sig_RspGetWakeupReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetWakeupReason", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspGetWakeupReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetWakeupReason", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetWakeupReason", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspGetWakeupReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetWakeupReason");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetWakeupReason", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspShutdownRegister(Sig_RspShutdownCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspShutdown");
    act_t act = addSignalCallback(ID_sig_RspShutdown, "sig_RspShutdown", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspShutdown", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspShutdownDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspShutdown", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspShutdown", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspShutdownDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspShutdown");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspShutdown", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspSetChainModeRegister(Sig_RspSetChainModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspSetChainMode");
    act_t act = addSignalCallback(ID_sig_RspSetChainMode, "sig_RspSetChainMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspSetChainMode", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspSetChainModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspSetChainMode", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspSetChainMode", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspSetChainModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspSetChainMode");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspSetChainMode", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_RspHealthCareRegister(Sig_RspHealthCareCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspHealthCare");
    act_t act = addSignalCallback(ID_sig_RspHealthCare, "sig_RspHealthCare", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspHealthCare", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_RspHealthCareDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspHealthCare", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspHealthCare", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_RspHealthCareDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspHealthCare");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspHealthCare", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendSig_EventDtcOccuranceRegister(Sig_EventDtcOccuranceCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventDtcOccurance");
    act_t act = addSignalCallback(ID_sig_EventDtcOccurance, "sig_EventDtcOccurance", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventDtcOccurance", &cb, act);
    return act;
}

bool NanoMsgLCMInterfaceProxy::sendSig_EventDtcOccuranceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventDtcOccurance", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventDtcOccurance", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgLCMInterfaceProxy::sendSig_EventDtcOccuranceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventDtcOccurance");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventDtcOccurance", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgLCMInterfaceProxy::sendReqSetPowerModeRequest(ReqSetPowerModeCallbackIF& cb, entPowerMode powerMode, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetPowerModeRequest* payload = new ReqSetPowerModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setPowerMode(powerMode);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetPowerMode", ReqSetPowerModeRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetPowerMode, dbusMessage.getUniqueSerial(), "ReqSetPowerMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetPowerMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgLCMInterfaceProxy::sendReqGetPowerModeRequest(ReqGetPowerModeCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetPowerModeRequest* payload = new ReqGetPowerModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetPowerMode", ReqGetPowerModeRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetPowerMode, dbusMessage.getUniqueSerial(), "ReqGetPowerMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetPowerMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgLCMInterfaceProxy::sendReqGetWakeupReasonRequest(ReqGetWakeupReasonCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetWakeupReasonRequest* payload = new ReqGetWakeupReasonRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetWakeupReason", ReqGetWakeupReasonRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetWakeupReason, dbusMessage.getUniqueSerial(), "ReqGetWakeupReason", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetWakeupReason", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgLCMInterfaceProxy::sendReqShutdownRequest(ReqShutdownCallbackIF& cb, uint16 timeout, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqShutdownRequest* payload = new ReqShutdownRequest();
    CHECK_ALLOCATION(payload);
    payload->setTimeout(timeout);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqShutdown", ReqShutdownRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqShutdown, dbusMessage.getUniqueSerial(), "ReqShutdown", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqShutdown", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgLCMInterfaceProxy::sendReqSetChainModeRequest(ReqSetChainModeCallbackIF& cb, entPowerMode powerMode, uint16 tChain, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetChainModeRequest* payload = new ReqSetChainModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setPowerMode(powerMode);
    payload->setTChain(tChain);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetChainMode", ReqSetChainModeRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetChainMode, dbusMessage.getUniqueSerial(), "ReqSetChainMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetChainMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgLCMInterfaceProxy::sendReqHealthCareRequest(ReqHealthCareCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqHealthCareRequest* payload = new ReqHealthCareRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqHealthCare", ReqHealthCareRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqHealthCare, dbusMessage.getUniqueSerial(), "ReqHealthCare", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqHealthCare", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NanoMsgLCMInterface
} // namespace di
} // namespace cm
} // namespace bosch
