#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGLCMINTERFACE_H
#define BOSCH_CM_DI_NANOMSGLCMINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/di/NanoMsgLCMInterfaceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "bosch.cm.di.NanoMsgLCMInterface" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgLCMInterface {

// method IDs
static const uint16 ID_ReqSetPowerMode = 0;
static const uint16 ID_ReqGetPowerMode = 1;
static const uint16 ID_ReqGetWakeupReason = 2;
static const uint16 ID_ReqShutdown = 3;
static const uint16 ID_ReqSetChainMode = 4;
static const uint16 ID_ReqHealthCare = 5;

// signal IDs
static const uint16 ID_sig_RspSetPowerMode = 6;
static const uint16 ID_sig_RspGetPowerMode = 7;
static const uint16 ID_sig_EventPowerModeChange = 8;
static const uint16 ID_sig_RspGetWakeupReason = 9;
static const uint16 ID_sig_RspShutdown = 10;
static const uint16 ID_sig_RspSetChainMode = 11;
static const uint16 ID_sig_RspHealthCare = 12;
static const uint16 ID_sig_EventDtcOccurance = 13;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ReqSetPowerModeRequest;

class ReqSetPowerModeResponse;

class ReqGetPowerModeRequest;

class ReqGetPowerModeResponse;

class ReqGetWakeupReasonRequest;

class ReqGetWakeupReasonResponse;

class ReqShutdownRequest;

class ReqShutdownResponse;

class ReqSetChainModeRequest;

class ReqSetChainModeResponse;

class ReqHealthCareRequest;

class ReqHealthCareResponse;

class Sig_RspSetPowerModeSignal;

class Sig_RspGetPowerModeSignal;

class Sig_EventPowerModeChangeSignal;

class Sig_RspGetWakeupReasonSignal;

class Sig_RspShutdownSignal;

class Sig_RspSetChainModeSignal;

class Sig_RspHealthCareSignal;

class Sig_EventDtcOccuranceSignal;

// type definitions
/**
 * If the meaning of "ReqSetPowerModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetPowerModeError;

/**
 * If the meaning of "ReqGetPowerModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetPowerModeError;

/**
 * If the meaning of "ReqGetWakeupReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetWakeupReasonError;

/**
 * If the meaning of "ReqShutdownError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqShutdownError;

/**
 * If the meaning of "ReqSetChainModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetChainModeError;

/**
 * If the meaning of "ReqHealthCareError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqHealthCareError;

/**
 * If the meaning of "Sig_RspSetPowerModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspSetPowerModeError;

/**
 * If the meaning of "Sig_RspGetPowerModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetPowerModeError;

/**
 * If the meaning of "Sig_EventPowerModeChangeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventPowerModeChangeError;

/**
 * If the meaning of "Sig_RspGetWakeupReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetWakeupReasonError;

/**
 * If the meaning of "Sig_RspShutdownError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspShutdownError;

/**
 * If the meaning of "Sig_RspSetChainModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspSetChainModeError;

/**
 * If the meaning of "Sig_RspHealthCareError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspHealthCareError;

/**
 * If the meaning of "Sig_EventDtcOccuranceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventDtcOccuranceError;


/**
 * ReqSetPowerMode = Method to request for setting Power Mode
 */
class ReqSetPowerModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetPowerModeRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetPowerModeRequest (const ReqSetPowerModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetPowerModeRequest (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetPowerModeRequest();

    /**
     * Assignment operator
     */
    inline ReqSetPowerModeRequest& operator = (const ReqSetPowerModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetPowerModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetPowerModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetPowerModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetPowerModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerMode"

    static const int kPowerMode = 0;

    /**
     * Clears the field "PowerMode".
     *
     * The field will be set to its default value. The hasPowerMode()
     * method will return false.
     */
    inline void clearPowerMode();

    /**
     * Checks whether the field "PowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerMode()). Otherwise it will return false.
     */
    inline bool hasPowerMode () const;

    /**
     * Returns the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerMode"
     */
    inline entPowerMode getPowerMode () const;

    /**
     * Sets the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param PowerMode The value which will be set
     */
    inline void setPowerMode (entPowerMode PowerMode_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetPowerModeRequest &getDefaultInstance();

private:

    inline void set_has_PowerMode ();

    inline void clear_has_PowerMode ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entPowerMode _PowerMode;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqSetPowerMode = Method to request for setting Power Mode
 */
class ReqSetPowerModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetPowerModeResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetPowerModeResponse (const ReqSetPowerModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetPowerModeResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetPowerModeResponse();

    /**
     * Assignment operator
     */
    inline ReqSetPowerModeResponse& operator = (const ReqSetPowerModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetPowerModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetPowerModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetPowerModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetPowerModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetPowerModeResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetPowerMode = Method to request for getting Power Mode
 */
class ReqGetPowerModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetPowerModeRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetPowerModeRequest (const ReqGetPowerModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetPowerModeRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetPowerModeRequest();

    /**
     * Assignment operator
     */
    inline ReqGetPowerModeRequest& operator = (const ReqGetPowerModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetPowerModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetPowerModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetPowerModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetPowerModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetPowerModeRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetPowerMode = Method to request for getting Power Mode
 */
class ReqGetPowerModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetPowerModeResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetPowerModeResponse (const ReqGetPowerModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetPowerModeResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetPowerModeResponse();

    /**
     * Assignment operator
     */
    inline ReqGetPowerModeResponse& operator = (const ReqGetPowerModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetPowerModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetPowerModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetPowerModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetPowerModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetPowerModeResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqGetWakeupReason = Method to request for getting WakeupReason
 */
class ReqGetWakeupReasonRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetWakeupReasonRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetWakeupReasonRequest (const ReqGetWakeupReasonRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetWakeupReasonRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetWakeupReasonRequest();

    /**
     * Assignment operator
     */
    inline ReqGetWakeupReasonRequest& operator = (const ReqGetWakeupReasonRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetWakeupReasonRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetWakeupReasonRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetWakeupReasonRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetWakeupReasonRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetWakeupReasonRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqGetWakeupReason = Method to request for getting WakeupReason
 */
class ReqGetWakeupReasonResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetWakeupReasonResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetWakeupReasonResponse (const ReqGetWakeupReasonResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetWakeupReasonResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetWakeupReasonResponse();

    /**
     * Assignment operator
     */
    inline ReqGetWakeupReasonResponse& operator = (const ReqGetWakeupReasonResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetWakeupReasonResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetWakeupReasonResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetWakeupReasonResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetWakeupReasonResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetWakeupReasonResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqShutdown = Method to request for Shutdown
 */
class ReqShutdownRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqShutdownRequest ();

    /**
     * Copy constructor
     */
    inline  ReqShutdownRequest (const ReqShutdownRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqShutdownRequest (uint16 timeout_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqShutdownRequest();

    /**
     * Assignment operator
     */
    inline ReqShutdownRequest& operator = (const ReqShutdownRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqShutdownRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqShutdownRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqShutdownRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqShutdownRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "timeout"

    static const int kTimeout = 0;

    /**
     * Clears the field "timeout".
     *
     * The field will be set to its default value. The hasTimeout()
     * method will return false.
     */
    inline void clearTimeout();

    /**
     * Checks whether the field "timeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeout()). Otherwise it will return false.
     */
    inline bool hasTimeout () const;

    /**
     * Returns the value of the member "timeout".
     *
     * If the meaning of "timeout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeout"
     */
    inline uint16 getTimeout () const;

    /**
     * Sets the value of the member "timeout".
     *
     * If the meaning of "timeout" isn't clear, then there should be a description here.
     *
     * @param timeout The value which will be set
     */
    inline void setTimeout (uint16 timeout_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqShutdownRequest &getDefaultInstance();

private:

    inline void set_has_timeout ();

    inline void clear_has_timeout ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _timeout;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqShutdown = Method to request for Shutdown
 */
class ReqShutdownResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqShutdownResponse ();

    /**
     * Copy constructor
     */
    inline  ReqShutdownResponse (const ReqShutdownResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqShutdownResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqShutdownResponse();

    /**
     * Assignment operator
     */
    inline ReqShutdownResponse& operator = (const ReqShutdownResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqShutdownResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqShutdownResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqShutdownResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqShutdownResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqShutdownResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
 */
class ReqSetChainModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetChainModeRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetChainModeRequest (const ReqSetChainModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetChainModeRequest (entPowerMode PowerMode_, uint16 tChain_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetChainModeRequest();

    /**
     * Assignment operator
     */
    inline ReqSetChainModeRequest& operator = (const ReqSetChainModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetChainModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetChainModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetChainModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetChainModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerMode"

    static const int kPowerMode = 0;

    /**
     * Clears the field "PowerMode".
     *
     * The field will be set to its default value. The hasPowerMode()
     * method will return false.
     */
    inline void clearPowerMode();

    /**
     * Checks whether the field "PowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerMode()). Otherwise it will return false.
     */
    inline bool hasPowerMode () const;

    /**
     * Returns the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerMode"
     */
    inline entPowerMode getPowerMode () const;

    /**
     * Sets the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param PowerMode The value which will be set
     */
    inline void setPowerMode (entPowerMode PowerMode_);

    // API of field "tChain"

    static const int kTChain = 1;

    /**
     * Clears the field "tChain".
     *
     * The field will be set to its default value. The hasTChain()
     * method will return false.
     */
    inline void clearTChain();

    /**
     * Checks whether the field "tChain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTChain()). Otherwise it will return false.
     */
    inline bool hasTChain () const;

    /**
     * Returns the value of the member "tChain".
     *
     * If the meaning of "tChain" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tChain"
     */
    inline uint16 getTChain () const;

    /**
     * Sets the value of the member "tChain".
     *
     * If the meaning of "tChain" isn't clear, then there should be a description here.
     *
     * @param tChain The value which will be set
     */
    inline void setTChain (uint16 tChain_);

    // API of field "Dev_ID"

    static const int kDev_ID = 2;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 3;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 4;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 5;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetChainModeRequest &getDefaultInstance();

private:

    inline void set_has_PowerMode ();

    inline void clear_has_PowerMode ();

    inline void set_has_tChain ();

    inline void clear_has_tChain ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (6 + 31) / 32];

    entPowerMode _PowerMode;

    uint16 _tChain;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * If the meaning of "ReqSetChainMode" isn't clear, then there should be a description here.
 */
class ReqSetChainModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetChainModeResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetChainModeResponse (const ReqSetChainModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetChainModeResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetChainModeResponse();

    /**
     * Assignment operator
     */
    inline ReqSetChainModeResponse& operator = (const ReqSetChainModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetChainModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetChainModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetChainModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetChainModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetChainModeResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
 */
class ReqHealthCareRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqHealthCareRequest ();

    /**
     * Copy constructor
     */
    inline  ReqHealthCareRequest (const ReqHealthCareRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqHealthCareRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqHealthCareRequest();

    /**
     * Assignment operator
     */
    inline ReqHealthCareRequest& operator = (const ReqHealthCareRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqHealthCareRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqHealthCareRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqHealthCareRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqHealthCareRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqHealthCareRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * ReqHealthCare = 0x0030 Method to request HealthCare periodic send by power master.
 */
class ReqHealthCareResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqHealthCareResponse ();

    /**
     * Copy constructor
     */
    inline  ReqHealthCareResponse (const ReqHealthCareResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqHealthCareResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqHealthCareResponse();

    /**
     * Assignment operator
     */
    inline ReqHealthCareResponse& operator = (const ReqHealthCareResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqHealthCareResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqHealthCareResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqHealthCareResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqHealthCareResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqHealthCareResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * RspSetPowerMode = response to  ReqSetPowerMode
 */
class Sig_RspSetPowerModeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspSetPowerModeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspSetPowerModeSignal (const Sig_RspSetPowerModeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspSetPowerModeSignal (uint16 status_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspSetPowerModeSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspSetPowerModeSignal& operator = (const Sig_RspSetPowerModeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspSetPowerModeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspSetPowerModeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspSetPowerModeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspSetPowerModeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspSetPowerModeSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _status;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * RspGetPowerMode = response to  ReqGetPowerMode
 */
class Sig_RspGetPowerModeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetPowerModeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetPowerModeSignal (const Sig_RspGetPowerModeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetPowerModeSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetPowerModeSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetPowerModeSignal& operator = (const Sig_RspGetPowerModeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetPowerModeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetPowerModeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetPowerModeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetPowerModeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerMode"

    static const int kPowerMode = 0;

    /**
     * Clears the field "PowerMode".
     *
     * The field will be set to its default value. The hasPowerMode()
     * method will return false.
     */
    inline void clearPowerMode();

    /**
     * Checks whether the field "PowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerMode()). Otherwise it will return false.
     */
    inline bool hasPowerMode () const;

    /**
     * Returns the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerMode"
     */
    inline entPowerMode getPowerMode () const;

    /**
     * Sets the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param PowerMode The value which will be set
     */
    inline void setPowerMode (entPowerMode PowerMode_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspGetPowerModeSignal &getDefaultInstance();

private:

    inline void set_has_PowerMode ();

    inline void clear_has_PowerMode ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entPowerMode _PowerMode;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * EventPowerModeChange = response to  EventPowerModeChange
 */
class Sig_EventPowerModeChangeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventPowerModeChangeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventPowerModeChangeSignal (const Sig_EventPowerModeChangeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventPowerModeChangeSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventPowerModeChangeSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventPowerModeChangeSignal& operator = (const Sig_EventPowerModeChangeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventPowerModeChangeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventPowerModeChangeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventPowerModeChangeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventPowerModeChangeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerMode"

    static const int kPowerMode = 0;

    /**
     * Clears the field "PowerMode".
     *
     * The field will be set to its default value. The hasPowerMode()
     * method will return false.
     */
    inline void clearPowerMode();

    /**
     * Checks whether the field "PowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerMode()). Otherwise it will return false.
     */
    inline bool hasPowerMode () const;

    /**
     * Returns the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerMode"
     */
    inline entPowerMode getPowerMode () const;

    /**
     * Sets the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param PowerMode The value which will be set
     */
    inline void setPowerMode (entPowerMode PowerMode_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventPowerModeChangeSignal &getDefaultInstance();

private:

    inline void set_has_PowerMode ();

    inline void clear_has_PowerMode ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entPowerMode _PowerMode;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * RspGetWakeupReason = response to WakeupReason
 */
class Sig_RspGetWakeupReasonSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetWakeupReasonSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetWakeupReasonSignal (const Sig_RspGetWakeupReasonSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetWakeupReasonSignal (entWakeupReason WakeupReason_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetWakeupReasonSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetWakeupReasonSignal& operator = (const Sig_RspGetWakeupReasonSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetWakeupReasonSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetWakeupReasonSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetWakeupReasonSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetWakeupReasonSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupReason"

    static const int kWakeupReason = 0;

    /**
     * Clears the field "WakeupReason".
     *
     * The field will be set to its default value. The hasWakeupReason()
     * method will return false.
     */
    inline void clearWakeupReason();

    /**
     * Checks whether the field "WakeupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupReason()). Otherwise it will return false.
     */
    inline bool hasWakeupReason () const;

    /**
     * Returns the value of the member "WakeupReason".
     *
     * If the meaning of "WakeupReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WakeupReason"
     */
    inline entWakeupReason getWakeupReason () const;

    /**
     * Sets the value of the member "WakeupReason".
     *
     * If the meaning of "WakeupReason" isn't clear, then there should be a description here.
     *
     * @param WakeupReason The value which will be set
     */
    inline void setWakeupReason (entWakeupReason WakeupReason_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspGetWakeupReasonSignal &getDefaultInstance();

private:

    inline void set_has_WakeupReason ();

    inline void clear_has_WakeupReason ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entWakeupReason _WakeupReason;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * RspShutdown = response to Shutdown
 */
class Sig_RspShutdownSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspShutdownSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspShutdownSignal (const Sig_RspShutdownSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspShutdownSignal (uint16 status_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspShutdownSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspShutdownSignal& operator = (const Sig_RspShutdownSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspShutdownSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspShutdownSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspShutdownSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspShutdownSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspShutdownSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _status;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * If the meaning of "sig_RspSetChainMode" isn't clear, then there should be a description here.
 */
class Sig_RspSetChainModeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspSetChainModeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspSetChainModeSignal (const Sig_RspSetChainModeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspSetChainModeSignal (eniRet tRet_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspSetChainModeSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspSetChainModeSignal& operator = (const Sig_RspSetChainModeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspSetChainModeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspSetChainModeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspSetChainModeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspSetChainModeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tRet"

    static const int kTRet = 0;

    /**
     * Clears the field "tRet".
     *
     * The field will be set to its default value. The hasTRet()
     * method will return false.
     */
    inline void clearTRet();

    /**
     * Checks whether the field "tRet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTRet()). Otherwise it will return false.
     */
    inline bool hasTRet () const;

    /**
     * Returns the value of the member "tRet".
     *
     * If the meaning of "tRet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tRet"
     */
    inline eniRet getTRet () const;

    /**
     * Sets the value of the member "tRet".
     *
     * If the meaning of "tRet" isn't clear, then there should be a description here.
     *
     * @param tRet The value which will be set
     */
    inline void setTRet (eniRet tRet_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspSetChainModeSignal &getDefaultInstance();

private:

    inline void set_has_tRet ();

    inline void clear_has_tRet ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    eniRet _tRet;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * RspHealthCare = 0x0031 response to Request HealthCare
 */
class Sig_RspHealthCareSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspHealthCareSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspHealthCareSignal (const Sig_RspHealthCareSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspHealthCareSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspHealthCareSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspHealthCareSignal& operator = (const Sig_RspHealthCareSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspHealthCareSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspHealthCareSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspHealthCareSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspHealthCareSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerMode"

    static const int kPowerMode = 0;

    /**
     * Clears the field "PowerMode".
     *
     * The field will be set to its default value. The hasPowerMode()
     * method will return false.
     */
    inline void clearPowerMode();

    /**
     * Checks whether the field "PowerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerMode()). Otherwise it will return false.
     */
    inline bool hasPowerMode () const;

    /**
     * Returns the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerMode"
     */
    inline entPowerMode getPowerMode () const;

    /**
     * Sets the value of the member "PowerMode".
     *
     * If the meaning of "PowerMode" isn't clear, then there should be a description here.
     *
     * @param PowerMode The value which will be set
     */
    inline void setPowerMode (entPowerMode PowerMode_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspHealthCareSignal &getDefaultInstance();

private:

    inline void set_has_PowerMode ();

    inline void clear_has_PowerMode ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entPowerMode _PowerMode;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

/**
 * EventDtcOccurance = 0x0032 Any component sends an event EventDtcOccurance if a DTC status has changed, occurred or vanished
 */
class Sig_EventDtcOccuranceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventDtcOccuranceSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventDtcOccuranceSignal (const Sig_EventDtcOccuranceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventDtcOccuranceSignal (const ::std::vector< uint8 >& DtcTable_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventDtcOccuranceSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventDtcOccuranceSignal& operator = (const Sig_EventDtcOccuranceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventDtcOccuranceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventDtcOccuranceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventDtcOccuranceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventDtcOccuranceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DtcTable"

    static const int kDtcTable = 0;

    /**
     * Clears the field "DtcTable".
     *
     * The field will be set to its default value. The hasDtcTable()
     * method will return false.
     */
    inline void clearDtcTable();

    /**
     * Checks whether the field "DtcTable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDtcTable()). Otherwise it will return false.
     */
    inline bool hasDtcTable () const;

    /**
     * Returns the value of the member "DtcTable".
     *
     * If the meaning of "DtcTable" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DtcTable"
     */
    inline const ::std::vector< uint8 >& getDtcTable () const;

    /**
     * Retrieves the value of the field "DtcTable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DtcTable".
     */
    inline ::std::vector< uint8 >& getDtcTableMutable ();

    /**
     * Sets the value of the member "DtcTable".
     *
     * If the meaning of "DtcTable" isn't clear, then there should be a description here.
     *
     * @param DtcTable The value which will be set
     */
    inline void setDtcTable (const ::std::vector< uint8 >& DtcTable_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 4;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventDtcOccuranceSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DtcTable ();

    inline void clear_has_DtcTable ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::vector< uint8 > _DtcTable;

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _RecevedIP;

};

inline  ReqSetPowerModeRequest::ReqSetPowerModeRequest ()  :
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetPowerModeRequest::ReqSetPowerModeRequest (const ReqSetPowerModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetPowerModeRequest::ReqSetPowerModeRequest (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _PowerMode (PowerMode_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "ReqSetPowerModeRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqSetPowerModeRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetPowerModeRequest::~ReqSetPowerModeRequest() {
}

inline ReqSetPowerModeRequest& ReqSetPowerModeRequest::operator = (const ReqSetPowerModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerMode()) {
            setPowerMode(rhs.getPowerMode());
        } else {
            clearPowerMode();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetPowerModeRequest::operator == (const ReqSetPowerModeRequest& rhs) const {
    return (((!hasPowerMode() && !rhs.hasPowerMode()) || getPowerMode() == rhs.getPowerMode()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetPowerModeRequest::operator != (const ReqSetPowerModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetPowerModeRequest::operator < (const ReqSetPowerModeRequest& rhs) const {
    if (hasPowerMode() || rhs.hasPowerMode()) {
        if ((uint32)getPowerMode() < (uint32)rhs.getPowerMode()) return true;
        if ((uint32)getPowerMode() > (uint32)rhs.getPowerMode()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetPowerModeRequest::clone() {
    return new ReqSetPowerModeRequest(*this);
}

inline bool ReqSetPowerModeRequest::operator > (const ReqSetPowerModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetPowerModeRequest::clear() {
    clearPowerMode();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetPowerModeRequest::clearPowerMode() {
    if (hasPowerMode()) {
         clear_has_PowerMode();
        _PowerMode = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
     }
}

inline bool ReqSetPowerModeRequest::hasPowerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entPowerMode ReqSetPowerModeRequest::getPowerMode () const {
    return _PowerMode;
}

inline void ReqSetPowerModeRequest::setPowerMode (entPowerMode PowerMode_) {
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "ReqSetPowerModeRequest");
    }
    #endif
    set_has_PowerMode();
    this->_PowerMode = PowerMode_;
}

inline void ReqSetPowerModeRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqSetPowerModeRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID ReqSetPowerModeRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetPowerModeRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqSetPowerModeRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetPowerModeRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetPowerModeRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqSetPowerModeRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetPowerModeRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetPowerModeRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetPowerModeRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqSetPowerModeRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetPowerModeRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetPowerModeRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetPowerModeRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqSetPowerModeRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetPowerModeRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetPowerModeRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetPowerModeRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetPowerModeRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetPowerModeRequest::set_has_PowerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetPowerModeRequest::clear_has_PowerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetPowerModeRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetPowerModeRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetPowerModeRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetPowerModeRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetPowerModeRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetPowerModeRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqSetPowerModeRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqSetPowerModeRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqSetPowerModeResponse::ReqSetPowerModeResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetPowerModeResponse::ReqSetPowerModeResponse (const ReqSetPowerModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetPowerModeResponse::ReqSetPowerModeResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetPowerModeResponse::~ReqSetPowerModeResponse() {
}

inline ReqSetPowerModeResponse& ReqSetPowerModeResponse::operator = (const ReqSetPowerModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetPowerModeResponse::operator == (const ReqSetPowerModeResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetPowerModeResponse::operator != (const ReqSetPowerModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetPowerModeResponse::operator < (const ReqSetPowerModeResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetPowerModeResponse::clone() {
    return new ReqSetPowerModeResponse(*this);
}

inline bool ReqSetPowerModeResponse::operator > (const ReqSetPowerModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetPowerModeResponse::clear() {
    clearResponse();
}

inline void ReqSetPowerModeResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetPowerModeResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetPowerModeResponse::getResponse () const {
    return _response;
}

inline void ReqSetPowerModeResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetPowerModeResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetPowerModeResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetPowerModeRequest::ReqGetPowerModeRequest ()  :
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetPowerModeRequest::ReqGetPowerModeRequest (const ReqGetPowerModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetPowerModeRequest::ReqGetPowerModeRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqGetPowerModeRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetPowerModeRequest::~ReqGetPowerModeRequest() {
}

inline ReqGetPowerModeRequest& ReqGetPowerModeRequest::operator = (const ReqGetPowerModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetPowerModeRequest::operator == (const ReqGetPowerModeRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetPowerModeRequest::operator != (const ReqGetPowerModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetPowerModeRequest::operator < (const ReqGetPowerModeRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetPowerModeRequest::clone() {
    return new ReqGetPowerModeRequest(*this);
}

inline bool ReqGetPowerModeRequest::operator > (const ReqGetPowerModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetPowerModeRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetPowerModeRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqGetPowerModeRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline enDevID ReqGetPowerModeRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetPowerModeRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqGetPowerModeRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetPowerModeRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetPowerModeRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetPowerModeRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetPowerModeRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetPowerModeRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetPowerModeRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetPowerModeRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetPowerModeRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetPowerModeRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetPowerModeRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetPowerModeRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetPowerModeRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetPowerModeRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetPowerModeRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetPowerModeRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetPowerModeRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetPowerModeRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetPowerModeRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetPowerModeRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetPowerModeRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetPowerModeRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetPowerModeRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetPowerModeRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetPowerModeResponse::ReqGetPowerModeResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetPowerModeResponse::ReqGetPowerModeResponse (const ReqGetPowerModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetPowerModeResponse::ReqGetPowerModeResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetPowerModeResponse::~ReqGetPowerModeResponse() {
}

inline ReqGetPowerModeResponse& ReqGetPowerModeResponse::operator = (const ReqGetPowerModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetPowerModeResponse::operator == (const ReqGetPowerModeResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetPowerModeResponse::operator != (const ReqGetPowerModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetPowerModeResponse::operator < (const ReqGetPowerModeResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetPowerModeResponse::clone() {
    return new ReqGetPowerModeResponse(*this);
}

inline bool ReqGetPowerModeResponse::operator > (const ReqGetPowerModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetPowerModeResponse::clear() {
    clearResponse();
}

inline void ReqGetPowerModeResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetPowerModeResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetPowerModeResponse::getResponse () const {
    return _response;
}

inline void ReqGetPowerModeResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetPowerModeResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetPowerModeResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetWakeupReasonRequest::ReqGetWakeupReasonRequest ()  :
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetWakeupReasonRequest::ReqGetWakeupReasonRequest (const ReqGetWakeupReasonRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetWakeupReasonRequest::ReqGetWakeupReasonRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqGetWakeupReasonRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetWakeupReasonRequest::~ReqGetWakeupReasonRequest() {
}

inline ReqGetWakeupReasonRequest& ReqGetWakeupReasonRequest::operator = (const ReqGetWakeupReasonRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetWakeupReasonRequest::operator == (const ReqGetWakeupReasonRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetWakeupReasonRequest::operator != (const ReqGetWakeupReasonRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetWakeupReasonRequest::operator < (const ReqGetWakeupReasonRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetWakeupReasonRequest::clone() {
    return new ReqGetWakeupReasonRequest(*this);
}

inline bool ReqGetWakeupReasonRequest::operator > (const ReqGetWakeupReasonRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetWakeupReasonRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetWakeupReasonRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqGetWakeupReasonRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline enDevID ReqGetWakeupReasonRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetWakeupReasonRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqGetWakeupReasonRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetWakeupReasonRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetWakeupReasonRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetWakeupReasonRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetWakeupReasonRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetWakeupReasonRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetWakeupReasonRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetWakeupReasonRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetWakeupReasonRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetWakeupReasonRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetWakeupReasonRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetWakeupReasonRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetWakeupReasonRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetWakeupReasonRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetWakeupReasonRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetWakeupReasonRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetWakeupReasonRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetWakeupReasonRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetWakeupReasonRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetWakeupReasonRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetWakeupReasonRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetWakeupReasonRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetWakeupReasonRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetWakeupReasonRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetWakeupReasonResponse::ReqGetWakeupReasonResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetWakeupReasonResponse::ReqGetWakeupReasonResponse (const ReqGetWakeupReasonResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetWakeupReasonResponse::ReqGetWakeupReasonResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetWakeupReasonResponse::~ReqGetWakeupReasonResponse() {
}

inline ReqGetWakeupReasonResponse& ReqGetWakeupReasonResponse::operator = (const ReqGetWakeupReasonResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetWakeupReasonResponse::operator == (const ReqGetWakeupReasonResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetWakeupReasonResponse::operator != (const ReqGetWakeupReasonResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetWakeupReasonResponse::operator < (const ReqGetWakeupReasonResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetWakeupReasonResponse::clone() {
    return new ReqGetWakeupReasonResponse(*this);
}

inline bool ReqGetWakeupReasonResponse::operator > (const ReqGetWakeupReasonResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetWakeupReasonResponse::clear() {
    clearResponse();
}

inline void ReqGetWakeupReasonResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetWakeupReasonResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetWakeupReasonResponse::getResponse () const {
    return _response;
}

inline void ReqGetWakeupReasonResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetWakeupReasonResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetWakeupReasonResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqShutdownRequest::ReqShutdownRequest ()  :
    _timeout (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqShutdownRequest::ReqShutdownRequest (const ReqShutdownRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _timeout (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqShutdownRequest::ReqShutdownRequest (uint16 timeout_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _timeout (timeout_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqShutdownRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqShutdownRequest::~ReqShutdownRequest() {
}

inline ReqShutdownRequest& ReqShutdownRequest::operator = (const ReqShutdownRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTimeout()) {
            setTimeout(rhs.getTimeout());
        } else {
            clearTimeout();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqShutdownRequest::operator == (const ReqShutdownRequest& rhs) const {
    return (((!hasTimeout() && !rhs.hasTimeout()) || getTimeout() == rhs.getTimeout()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqShutdownRequest::operator != (const ReqShutdownRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqShutdownRequest::operator < (const ReqShutdownRequest& rhs) const {
    if (hasTimeout() || rhs.hasTimeout()) {
        if (getTimeout() < rhs.getTimeout()) return true;
        if (getTimeout() > rhs.getTimeout()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqShutdownRequest::clone() {
    return new ReqShutdownRequest(*this);
}

inline bool ReqShutdownRequest::operator > (const ReqShutdownRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqShutdownRequest::clear() {
    clearTimeout();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqShutdownRequest::clearTimeout() {
    if (hasTimeout()) {
         clear_has_timeout();
        _timeout = 0u;
     }
}

inline bool ReqShutdownRequest::hasTimeout () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ReqShutdownRequest::getTimeout () const {
    return _timeout;
}

inline void ReqShutdownRequest::setTimeout (uint16 timeout_) {
    set_has_timeout();
    this->_timeout = timeout_;
}

inline void ReqShutdownRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqShutdownRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID ReqShutdownRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqShutdownRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqShutdownRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqShutdownRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqShutdownRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqShutdownRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqShutdownRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqShutdownRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqShutdownRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqShutdownRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqShutdownRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqShutdownRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqShutdownRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqShutdownRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqShutdownRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqShutdownRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqShutdownRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqShutdownRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqShutdownRequest::set_has_timeout () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqShutdownRequest::clear_has_timeout () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqShutdownRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqShutdownRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqShutdownRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqShutdownRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqShutdownRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqShutdownRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqShutdownRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqShutdownRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqShutdownResponse::ReqShutdownResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqShutdownResponse::ReqShutdownResponse (const ReqShutdownResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqShutdownResponse::ReqShutdownResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqShutdownResponse::~ReqShutdownResponse() {
}

inline ReqShutdownResponse& ReqShutdownResponse::operator = (const ReqShutdownResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqShutdownResponse::operator == (const ReqShutdownResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqShutdownResponse::operator != (const ReqShutdownResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqShutdownResponse::operator < (const ReqShutdownResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqShutdownResponse::clone() {
    return new ReqShutdownResponse(*this);
}

inline bool ReqShutdownResponse::operator > (const ReqShutdownResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqShutdownResponse::clear() {
    clearResponse();
}

inline void ReqShutdownResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqShutdownResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqShutdownResponse::getResponse () const {
    return _response;
}

inline void ReqShutdownResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqShutdownResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqShutdownResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqSetChainModeRequest::ReqSetChainModeRequest ()  :
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _tChain (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetChainModeRequest::ReqSetChainModeRequest (const ReqSetChainModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _tChain (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetChainModeRequest::ReqSetChainModeRequest (entPowerMode PowerMode_, uint16 tChain_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _PowerMode (PowerMode_),
    _tChain (tChain_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "ReqSetChainModeRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqSetChainModeRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetChainModeRequest::~ReqSetChainModeRequest() {
}

inline ReqSetChainModeRequest& ReqSetChainModeRequest::operator = (const ReqSetChainModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerMode()) {
            setPowerMode(rhs.getPowerMode());
        } else {
            clearPowerMode();
        }
        if (rhs.hasTChain()) {
            setTChain(rhs.getTChain());
        } else {
            clearTChain();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetChainModeRequest::operator == (const ReqSetChainModeRequest& rhs) const {
    return (((!hasPowerMode() && !rhs.hasPowerMode()) || getPowerMode() == rhs.getPowerMode()) &&
        ((!hasTChain() && !rhs.hasTChain()) || getTChain() == rhs.getTChain()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetChainModeRequest::operator != (const ReqSetChainModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetChainModeRequest::operator < (const ReqSetChainModeRequest& rhs) const {
    if (hasPowerMode() || rhs.hasPowerMode()) {
        if ((uint32)getPowerMode() < (uint32)rhs.getPowerMode()) return true;
        if ((uint32)getPowerMode() > (uint32)rhs.getPowerMode()) return false;
    }
    if (hasTChain() || rhs.hasTChain()) {
        if (getTChain() < rhs.getTChain()) return true;
        if (getTChain() > rhs.getTChain()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetChainModeRequest::clone() {
    return new ReqSetChainModeRequest(*this);
}

inline bool ReqSetChainModeRequest::operator > (const ReqSetChainModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetChainModeRequest::clear() {
    clearPowerMode();
    clearTChain();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetChainModeRequest::clearPowerMode() {
    if (hasPowerMode()) {
         clear_has_PowerMode();
        _PowerMode = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
     }
}

inline bool ReqSetChainModeRequest::hasPowerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entPowerMode ReqSetChainModeRequest::getPowerMode () const {
    return _PowerMode;
}

inline void ReqSetChainModeRequest::setPowerMode (entPowerMode PowerMode_) {
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "ReqSetChainModeRequest");
    }
    #endif
    set_has_PowerMode();
    this->_PowerMode = PowerMode_;
}

inline void ReqSetChainModeRequest::clearTChain() {
    if (hasTChain()) {
         clear_has_tChain();
        _tChain = 0u;
     }
}

inline bool ReqSetChainModeRequest::hasTChain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ReqSetChainModeRequest::getTChain () const {
    return _tChain;
}

inline void ReqSetChainModeRequest::setTChain (uint16 tChain_) {
    set_has_tChain();
    this->_tChain = tChain_;
}

inline void ReqSetChainModeRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqSetChainModeRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline enDevID ReqSetChainModeRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetChainModeRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqSetChainModeRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetChainModeRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetChainModeRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ReqSetChainModeRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetChainModeRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetChainModeRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetChainModeRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 ReqSetChainModeRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetChainModeRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetChainModeRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetChainModeRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& ReqSetChainModeRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetChainModeRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetChainModeRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetChainModeRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetChainModeRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetChainModeRequest::set_has_PowerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetChainModeRequest::clear_has_PowerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetChainModeRequest::set_has_tChain () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetChainModeRequest::clear_has_tChain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetChainModeRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetChainModeRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetChainModeRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetChainModeRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqSetChainModeRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqSetChainModeRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void ReqSetChainModeRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 5;
}

inline void ReqSetChainModeRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  ReqSetChainModeResponse::ReqSetChainModeResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetChainModeResponse::ReqSetChainModeResponse (const ReqSetChainModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetChainModeResponse::ReqSetChainModeResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetChainModeResponse::~ReqSetChainModeResponse() {
}

inline ReqSetChainModeResponse& ReqSetChainModeResponse::operator = (const ReqSetChainModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetChainModeResponse::operator == (const ReqSetChainModeResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetChainModeResponse::operator != (const ReqSetChainModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetChainModeResponse::operator < (const ReqSetChainModeResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetChainModeResponse::clone() {
    return new ReqSetChainModeResponse(*this);
}

inline bool ReqSetChainModeResponse::operator > (const ReqSetChainModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetChainModeResponse::clear() {
    clearResponse();
}

inline void ReqSetChainModeResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetChainModeResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetChainModeResponse::getResponse () const {
    return _response;
}

inline void ReqSetChainModeResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetChainModeResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetChainModeResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqHealthCareRequest::ReqHealthCareRequest ()  :
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqHealthCareRequest::ReqHealthCareRequest (const ReqHealthCareRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqHealthCareRequest::ReqHealthCareRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqHealthCareRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqHealthCareRequest::~ReqHealthCareRequest() {
}

inline ReqHealthCareRequest& ReqHealthCareRequest::operator = (const ReqHealthCareRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqHealthCareRequest::operator == (const ReqHealthCareRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqHealthCareRequest::operator != (const ReqHealthCareRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqHealthCareRequest::operator < (const ReqHealthCareRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqHealthCareRequest::clone() {
    return new ReqHealthCareRequest(*this);
}

inline bool ReqHealthCareRequest::operator > (const ReqHealthCareRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqHealthCareRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqHealthCareRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool ReqHealthCareRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline enDevID ReqHealthCareRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqHealthCareRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "ReqHealthCareRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqHealthCareRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqHealthCareRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqHealthCareRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqHealthCareRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqHealthCareRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqHealthCareRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqHealthCareRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqHealthCareRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqHealthCareRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqHealthCareRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqHealthCareRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqHealthCareRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqHealthCareRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqHealthCareRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqHealthCareRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqHealthCareRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqHealthCareRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqHealthCareRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqHealthCareRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqHealthCareRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqHealthCareRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqHealthCareRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqHealthCareRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqHealthCareResponse::ReqHealthCareResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqHealthCareResponse::ReqHealthCareResponse (const ReqHealthCareResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqHealthCareResponse::ReqHealthCareResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqHealthCareResponse::~ReqHealthCareResponse() {
}

inline ReqHealthCareResponse& ReqHealthCareResponse::operator = (const ReqHealthCareResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqHealthCareResponse::operator == (const ReqHealthCareResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqHealthCareResponse::operator != (const ReqHealthCareResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqHealthCareResponse::operator < (const ReqHealthCareResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqHealthCareResponse::clone() {
    return new ReqHealthCareResponse(*this);
}

inline bool ReqHealthCareResponse::operator > (const ReqHealthCareResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqHealthCareResponse::clear() {
    clearResponse();
}

inline void ReqHealthCareResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqHealthCareResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqHealthCareResponse::getResponse () const {
    return _response;
}

inline void ReqHealthCareResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqHealthCareResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqHealthCareResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_RspSetPowerModeSignal::Sig_RspSetPowerModeSignal ()  :
    _status (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspSetPowerModeSignal::Sig_RspSetPowerModeSignal (const Sig_RspSetPowerModeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspSetPowerModeSignal::Sig_RspSetPowerModeSignal (uint16 status_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _status (status_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspSetPowerModeSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspSetPowerModeSignal::~Sig_RspSetPowerModeSignal() {
}

inline Sig_RspSetPowerModeSignal& Sig_RspSetPowerModeSignal::operator = (const Sig_RspSetPowerModeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspSetPowerModeSignal::operator == (const Sig_RspSetPowerModeSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspSetPowerModeSignal::operator != (const Sig_RspSetPowerModeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspSetPowerModeSignal::operator < (const Sig_RspSetPowerModeSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspSetPowerModeSignal::clone() {
    return new Sig_RspSetPowerModeSignal(*this);
}

inline bool Sig_RspSetPowerModeSignal::operator > (const Sig_RspSetPowerModeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspSetPowerModeSignal::clear() {
    clearStatus();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspSetPowerModeSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool Sig_RspSetPowerModeSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Sig_RspSetPowerModeSignal::getStatus () const {
    return _status;
}

inline void Sig_RspSetPowerModeSignal::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_RspSetPowerModeSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspSetPowerModeSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspSetPowerModeSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspSetPowerModeSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspSetPowerModeSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspSetPowerModeSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspSetPowerModeSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspSetPowerModeSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspSetPowerModeSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspSetPowerModeSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspSetPowerModeSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspSetPowerModeSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspSetPowerModeSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspSetPowerModeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspSetPowerModeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspSetPowerModeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspSetPowerModeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspSetPowerModeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspSetPowerModeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspSetPowerModeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspSetPowerModeSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspSetPowerModeSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspSetPowerModeSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspSetPowerModeSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspSetPowerModeSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspSetPowerModeSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspSetPowerModeSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspSetPowerModeSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspSetPowerModeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspSetPowerModeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_RspGetPowerModeSignal::Sig_RspGetPowerModeSignal ()  :
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetPowerModeSignal::Sig_RspGetPowerModeSignal (const Sig_RspGetPowerModeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetPowerModeSignal::Sig_RspGetPowerModeSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _PowerMode (PowerMode_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_RspGetPowerModeSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspGetPowerModeSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetPowerModeSignal::~Sig_RspGetPowerModeSignal() {
}

inline Sig_RspGetPowerModeSignal& Sig_RspGetPowerModeSignal::operator = (const Sig_RspGetPowerModeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerMode()) {
            setPowerMode(rhs.getPowerMode());
        } else {
            clearPowerMode();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetPowerModeSignal::operator == (const Sig_RspGetPowerModeSignal& rhs) const {
    return (((!hasPowerMode() && !rhs.hasPowerMode()) || getPowerMode() == rhs.getPowerMode()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspGetPowerModeSignal::operator != (const Sig_RspGetPowerModeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetPowerModeSignal::operator < (const Sig_RspGetPowerModeSignal& rhs) const {
    if (hasPowerMode() || rhs.hasPowerMode()) {
        if ((uint32)getPowerMode() < (uint32)rhs.getPowerMode()) return true;
        if ((uint32)getPowerMode() > (uint32)rhs.getPowerMode()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetPowerModeSignal::clone() {
    return new Sig_RspGetPowerModeSignal(*this);
}

inline bool Sig_RspGetPowerModeSignal::operator > (const Sig_RspGetPowerModeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetPowerModeSignal::clear() {
    clearPowerMode();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspGetPowerModeSignal::clearPowerMode() {
    if (hasPowerMode()) {
         clear_has_PowerMode();
        _PowerMode = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
     }
}

inline bool Sig_RspGetPowerModeSignal::hasPowerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entPowerMode Sig_RspGetPowerModeSignal::getPowerMode () const {
    return _PowerMode;
}

inline void Sig_RspGetPowerModeSignal::setPowerMode (entPowerMode PowerMode_) {
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_RspGetPowerModeSignal");
    }
    #endif
    set_has_PowerMode();
    this->_PowerMode = PowerMode_;
}

inline void Sig_RspGetPowerModeSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspGetPowerModeSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspGetPowerModeSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspGetPowerModeSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspGetPowerModeSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspGetPowerModeSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspGetPowerModeSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspGetPowerModeSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspGetPowerModeSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspGetPowerModeSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspGetPowerModeSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspGetPowerModeSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspGetPowerModeSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspGetPowerModeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspGetPowerModeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspGetPowerModeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspGetPowerModeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspGetPowerModeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspGetPowerModeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspGetPowerModeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspGetPowerModeSignal::set_has_PowerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetPowerModeSignal::clear_has_PowerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetPowerModeSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetPowerModeSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspGetPowerModeSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspGetPowerModeSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspGetPowerModeSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspGetPowerModeSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspGetPowerModeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspGetPowerModeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_EventPowerModeChangeSignal::Sig_EventPowerModeChangeSignal ()  :
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventPowerModeChangeSignal::Sig_EventPowerModeChangeSignal (const Sig_EventPowerModeChangeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventPowerModeChangeSignal::Sig_EventPowerModeChangeSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _PowerMode (PowerMode_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_EventPowerModeChangeSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_EventPowerModeChangeSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventPowerModeChangeSignal::~Sig_EventPowerModeChangeSignal() {
}

inline Sig_EventPowerModeChangeSignal& Sig_EventPowerModeChangeSignal::operator = (const Sig_EventPowerModeChangeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerMode()) {
            setPowerMode(rhs.getPowerMode());
        } else {
            clearPowerMode();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventPowerModeChangeSignal::operator == (const Sig_EventPowerModeChangeSignal& rhs) const {
    return (((!hasPowerMode() && !rhs.hasPowerMode()) || getPowerMode() == rhs.getPowerMode()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventPowerModeChangeSignal::operator != (const Sig_EventPowerModeChangeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventPowerModeChangeSignal::operator < (const Sig_EventPowerModeChangeSignal& rhs) const {
    if (hasPowerMode() || rhs.hasPowerMode()) {
        if ((uint32)getPowerMode() < (uint32)rhs.getPowerMode()) return true;
        if ((uint32)getPowerMode() > (uint32)rhs.getPowerMode()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventPowerModeChangeSignal::clone() {
    return new Sig_EventPowerModeChangeSignal(*this);
}

inline bool Sig_EventPowerModeChangeSignal::operator > (const Sig_EventPowerModeChangeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventPowerModeChangeSignal::clear() {
    clearPowerMode();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_EventPowerModeChangeSignal::clearPowerMode() {
    if (hasPowerMode()) {
         clear_has_PowerMode();
        _PowerMode = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
     }
}

inline bool Sig_EventPowerModeChangeSignal::hasPowerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entPowerMode Sig_EventPowerModeChangeSignal::getPowerMode () const {
    return _PowerMode;
}

inline void Sig_EventPowerModeChangeSignal::setPowerMode (entPowerMode PowerMode_) {
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_EventPowerModeChangeSignal");
    }
    #endif
    set_has_PowerMode();
    this->_PowerMode = PowerMode_;
}

inline void Sig_EventPowerModeChangeSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_EventPowerModeChangeSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_EventPowerModeChangeSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_EventPowerModeChangeSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_EventPowerModeChangeSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_EventPowerModeChangeSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_EventPowerModeChangeSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_EventPowerModeChangeSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_EventPowerModeChangeSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_EventPowerModeChangeSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_EventPowerModeChangeSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_EventPowerModeChangeSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_EventPowerModeChangeSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_EventPowerModeChangeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventPowerModeChangeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_EventPowerModeChangeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventPowerModeChangeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventPowerModeChangeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventPowerModeChangeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventPowerModeChangeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventPowerModeChangeSignal::set_has_PowerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventPowerModeChangeSignal::clear_has_PowerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventPowerModeChangeSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventPowerModeChangeSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_EventPowerModeChangeSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_EventPowerModeChangeSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_EventPowerModeChangeSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_EventPowerModeChangeSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_EventPowerModeChangeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_EventPowerModeChangeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_RspGetWakeupReasonSignal::Sig_RspGetWakeupReasonSignal ()  :
    _WakeupReason (::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason__entWakeupReason_No_reason),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetWakeupReasonSignal::Sig_RspGetWakeupReasonSignal (const Sig_RspGetWakeupReasonSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _WakeupReason (::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason__entWakeupReason_No_reason),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetWakeupReasonSignal::Sig_RspGetWakeupReasonSignal (entWakeupReason WakeupReason_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _WakeupReason (WakeupReason_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(entWakeupReason_IsValid(WakeupReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WakeupReason_, "entWakeupReason", "WakeupReason", "Sig_RspGetWakeupReasonSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspGetWakeupReasonSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetWakeupReasonSignal::~Sig_RspGetWakeupReasonSignal() {
}

inline Sig_RspGetWakeupReasonSignal& Sig_RspGetWakeupReasonSignal::operator = (const Sig_RspGetWakeupReasonSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWakeupReason()) {
            setWakeupReason(rhs.getWakeupReason());
        } else {
            clearWakeupReason();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetWakeupReasonSignal::operator == (const Sig_RspGetWakeupReasonSignal& rhs) const {
    return (((!hasWakeupReason() && !rhs.hasWakeupReason()) || getWakeupReason() == rhs.getWakeupReason()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspGetWakeupReasonSignal::operator != (const Sig_RspGetWakeupReasonSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetWakeupReasonSignal::operator < (const Sig_RspGetWakeupReasonSignal& rhs) const {
    if (hasWakeupReason() || rhs.hasWakeupReason()) {
        if ((uint32)getWakeupReason() < (uint32)rhs.getWakeupReason()) return true;
        if ((uint32)getWakeupReason() > (uint32)rhs.getWakeupReason()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetWakeupReasonSignal::clone() {
    return new Sig_RspGetWakeupReasonSignal(*this);
}

inline bool Sig_RspGetWakeupReasonSignal::operator > (const Sig_RspGetWakeupReasonSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetWakeupReasonSignal::clear() {
    clearWakeupReason();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspGetWakeupReasonSignal::clearWakeupReason() {
    if (hasWakeupReason()) {
         clear_has_WakeupReason();
        _WakeupReason = ::bosch::cm::di::NanoMsgLCMInterface::entWakeupReason__entWakeupReason_No_reason;
     }
}

inline bool Sig_RspGetWakeupReasonSignal::hasWakeupReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entWakeupReason Sig_RspGetWakeupReasonSignal::getWakeupReason () const {
    return _WakeupReason;
}

inline void Sig_RspGetWakeupReasonSignal::setWakeupReason (entWakeupReason WakeupReason_) {
    #ifndef NDEBUG
    if (!(entWakeupReason_IsValid(WakeupReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WakeupReason_, "entWakeupReason", "WakeupReason", "Sig_RspGetWakeupReasonSignal");
    }
    #endif
    set_has_WakeupReason();
    this->_WakeupReason = WakeupReason_;
}

inline void Sig_RspGetWakeupReasonSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspGetWakeupReasonSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspGetWakeupReasonSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspGetWakeupReasonSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspGetWakeupReasonSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspGetWakeupReasonSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspGetWakeupReasonSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspGetWakeupReasonSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspGetWakeupReasonSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspGetWakeupReasonSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspGetWakeupReasonSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspGetWakeupReasonSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspGetWakeupReasonSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspGetWakeupReasonSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspGetWakeupReasonSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspGetWakeupReasonSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspGetWakeupReasonSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspGetWakeupReasonSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspGetWakeupReasonSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspGetWakeupReasonSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspGetWakeupReasonSignal::set_has_WakeupReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetWakeupReasonSignal::clear_has_WakeupReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetWakeupReasonSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetWakeupReasonSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspGetWakeupReasonSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspGetWakeupReasonSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspGetWakeupReasonSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspGetWakeupReasonSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspGetWakeupReasonSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspGetWakeupReasonSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_RspShutdownSignal::Sig_RspShutdownSignal ()  :
    _status (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspShutdownSignal::Sig_RspShutdownSignal (const Sig_RspShutdownSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspShutdownSignal::Sig_RspShutdownSignal (uint16 status_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _status (status_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspShutdownSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspShutdownSignal::~Sig_RspShutdownSignal() {
}

inline Sig_RspShutdownSignal& Sig_RspShutdownSignal::operator = (const Sig_RspShutdownSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspShutdownSignal::operator == (const Sig_RspShutdownSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspShutdownSignal::operator != (const Sig_RspShutdownSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspShutdownSignal::operator < (const Sig_RspShutdownSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspShutdownSignal::clone() {
    return new Sig_RspShutdownSignal(*this);
}

inline bool Sig_RspShutdownSignal::operator > (const Sig_RspShutdownSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspShutdownSignal::clear() {
    clearStatus();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspShutdownSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool Sig_RspShutdownSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Sig_RspShutdownSignal::getStatus () const {
    return _status;
}

inline void Sig_RspShutdownSignal::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_RspShutdownSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspShutdownSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspShutdownSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspShutdownSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspShutdownSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspShutdownSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspShutdownSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspShutdownSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspShutdownSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspShutdownSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspShutdownSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspShutdownSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspShutdownSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspShutdownSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspShutdownSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspShutdownSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspShutdownSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspShutdownSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspShutdownSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspShutdownSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspShutdownSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspShutdownSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspShutdownSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspShutdownSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspShutdownSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspShutdownSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspShutdownSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspShutdownSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspShutdownSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspShutdownSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_RspSetChainModeSignal::Sig_RspSetChainModeSignal ()  :
    _tRet (::bosch::cm::di::NanoMsgLCMInterface::eniRet__eniRet_Ok),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspSetChainModeSignal::Sig_RspSetChainModeSignal (const Sig_RspSetChainModeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _tRet (::bosch::cm::di::NanoMsgLCMInterface::eniRet__eniRet_Ok),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspSetChainModeSignal::Sig_RspSetChainModeSignal (eniRet tRet_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _tRet (tRet_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eniRet_IsValid(tRet_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tRet_, "eniRet", "tRet", "Sig_RspSetChainModeSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspSetChainModeSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspSetChainModeSignal::~Sig_RspSetChainModeSignal() {
}

inline Sig_RspSetChainModeSignal& Sig_RspSetChainModeSignal::operator = (const Sig_RspSetChainModeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTRet()) {
            setTRet(rhs.getTRet());
        } else {
            clearTRet();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspSetChainModeSignal::operator == (const Sig_RspSetChainModeSignal& rhs) const {
    return (((!hasTRet() && !rhs.hasTRet()) || getTRet() == rhs.getTRet()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspSetChainModeSignal::operator != (const Sig_RspSetChainModeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspSetChainModeSignal::operator < (const Sig_RspSetChainModeSignal& rhs) const {
    if (hasTRet() || rhs.hasTRet()) {
        if ((uint32)getTRet() < (uint32)rhs.getTRet()) return true;
        if ((uint32)getTRet() > (uint32)rhs.getTRet()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspSetChainModeSignal::clone() {
    return new Sig_RspSetChainModeSignal(*this);
}

inline bool Sig_RspSetChainModeSignal::operator > (const Sig_RspSetChainModeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspSetChainModeSignal::clear() {
    clearTRet();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspSetChainModeSignal::clearTRet() {
    if (hasTRet()) {
         clear_has_tRet();
        _tRet = ::bosch::cm::di::NanoMsgLCMInterface::eniRet__eniRet_Ok;
     }
}

inline bool Sig_RspSetChainModeSignal::hasTRet () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eniRet Sig_RspSetChainModeSignal::getTRet () const {
    return _tRet;
}

inline void Sig_RspSetChainModeSignal::setTRet (eniRet tRet_) {
    #ifndef NDEBUG
    if (!(eniRet_IsValid(tRet_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tRet_, "eniRet", "tRet", "Sig_RspSetChainModeSignal");
    }
    #endif
    set_has_tRet();
    this->_tRet = tRet_;
}

inline void Sig_RspSetChainModeSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspSetChainModeSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspSetChainModeSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspSetChainModeSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspSetChainModeSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspSetChainModeSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspSetChainModeSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspSetChainModeSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspSetChainModeSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspSetChainModeSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspSetChainModeSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspSetChainModeSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspSetChainModeSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspSetChainModeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspSetChainModeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspSetChainModeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspSetChainModeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspSetChainModeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspSetChainModeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspSetChainModeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspSetChainModeSignal::set_has_tRet () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspSetChainModeSignal::clear_has_tRet () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspSetChainModeSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspSetChainModeSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspSetChainModeSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspSetChainModeSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspSetChainModeSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspSetChainModeSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspSetChainModeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspSetChainModeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_RspHealthCareSignal::Sig_RspHealthCareSignal ()  :
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspHealthCareSignal::Sig_RspHealthCareSignal (const Sig_RspHealthCareSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerMode (::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspHealthCareSignal::Sig_RspHealthCareSignal (entPowerMode PowerMode_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _PowerMode (PowerMode_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_RspHealthCareSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspHealthCareSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspHealthCareSignal::~Sig_RspHealthCareSignal() {
}

inline Sig_RspHealthCareSignal& Sig_RspHealthCareSignal::operator = (const Sig_RspHealthCareSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerMode()) {
            setPowerMode(rhs.getPowerMode());
        } else {
            clearPowerMode();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspHealthCareSignal::operator == (const Sig_RspHealthCareSignal& rhs) const {
    return (((!hasPowerMode() && !rhs.hasPowerMode()) || getPowerMode() == rhs.getPowerMode()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspHealthCareSignal::operator != (const Sig_RspHealthCareSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspHealthCareSignal::operator < (const Sig_RspHealthCareSignal& rhs) const {
    if (hasPowerMode() || rhs.hasPowerMode()) {
        if ((uint32)getPowerMode() < (uint32)rhs.getPowerMode()) return true;
        if ((uint32)getPowerMode() > (uint32)rhs.getPowerMode()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspHealthCareSignal::clone() {
    return new Sig_RspHealthCareSignal(*this);
}

inline bool Sig_RspHealthCareSignal::operator > (const Sig_RspHealthCareSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspHealthCareSignal::clear() {
    clearPowerMode();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_RspHealthCareSignal::clearPowerMode() {
    if (hasPowerMode()) {
         clear_has_PowerMode();
        _PowerMode = ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode__enPowerMode_OFF;
     }
}

inline bool Sig_RspHealthCareSignal::hasPowerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entPowerMode Sig_RspHealthCareSignal::getPowerMode () const {
    return _PowerMode;
}

inline void Sig_RspHealthCareSignal::setPowerMode (entPowerMode PowerMode_) {
    #ifndef NDEBUG
    if (!(entPowerMode_IsValid(PowerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PowerMode_, "entPowerMode", "PowerMode", "Sig_RspHealthCareSignal");
    }
    #endif
    set_has_PowerMode();
    this->_PowerMode = PowerMode_;
}

inline void Sig_RspHealthCareSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_RspHealthCareSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_RspHealthCareSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_RspHealthCareSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_RspHealthCareSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_RspHealthCareSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_RspHealthCareSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspHealthCareSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_RspHealthCareSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_RspHealthCareSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_RspHealthCareSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_RspHealthCareSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_RspHealthCareSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_RspHealthCareSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspHealthCareSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_RspHealthCareSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspHealthCareSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspHealthCareSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspHealthCareSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspHealthCareSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspHealthCareSignal::set_has_PowerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspHealthCareSignal::clear_has_PowerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspHealthCareSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspHealthCareSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspHealthCareSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspHealthCareSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspHealthCareSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspHealthCareSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_RspHealthCareSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_RspHealthCareSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Sig_EventDtcOccuranceSignal::Sig_EventDtcOccuranceSignal ()  :
    _DtcTable (),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventDtcOccuranceSignal::Sig_EventDtcOccuranceSignal (const Sig_EventDtcOccuranceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DtcTable (),
    _Dev_ID (::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventDtcOccuranceSignal::Sig_EventDtcOccuranceSignal (const ::std::vector< uint8 >& DtcTable_, enDevID Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& RecevedIP_)  :
    _DtcTable (DtcTable_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_EventDtcOccuranceSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventDtcOccuranceSignal::~Sig_EventDtcOccuranceSignal() {
}

inline Sig_EventDtcOccuranceSignal& Sig_EventDtcOccuranceSignal::operator = (const Sig_EventDtcOccuranceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDtcTable()) {
            setDtcTable(rhs.getDtcTable());
        } else {
            clearDtcTable();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventDtcOccuranceSignal::operator == (const Sig_EventDtcOccuranceSignal& rhs) const {
    return (((!hasDtcTable() && !rhs.hasDtcTable()) || getDtcTable() == rhs.getDtcTable()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventDtcOccuranceSignal::operator != (const Sig_EventDtcOccuranceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventDtcOccuranceSignal::operator < (const Sig_EventDtcOccuranceSignal& rhs) const {
    if (hasDtcTable() || rhs.hasDtcTable()) {
        if (getDtcTable() < rhs.getDtcTable()) return true;
        if (getDtcTable() > rhs.getDtcTable()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventDtcOccuranceSignal::clone() {
    return new Sig_EventDtcOccuranceSignal(*this);
}

inline bool Sig_EventDtcOccuranceSignal::operator > (const Sig_EventDtcOccuranceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventDtcOccuranceSignal::clear() {
    clearDtcTable();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearRecevedIP();
}

inline void Sig_EventDtcOccuranceSignal::clearDtcTable() {
    if (hasDtcTable()) {
         clear_has_DtcTable();
        _DtcTable.clear();
     }
}

inline bool Sig_EventDtcOccuranceSignal::hasDtcTable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& Sig_EventDtcOccuranceSignal::getDtcTable () const {
    return _DtcTable;
}

inline ::std::vector< uint8 >& Sig_EventDtcOccuranceSignal::getDtcTableMutable () {
    set_has_DtcTable();
    return _DtcTable;
}

inline void Sig_EventDtcOccuranceSignal::setDtcTable (const ::std::vector< uint8 >& DtcTable_) {
    set_has_DtcTable();
    this->_DtcTable = DtcTable_;
}

inline void Sig_EventDtcOccuranceSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::di::NanoMsgLCMInterface::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_EventDtcOccuranceSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline enDevID Sig_EventDtcOccuranceSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_EventDtcOccuranceSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_EventDtcOccuranceSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_EventDtcOccuranceSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_EventDtcOccuranceSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_EventDtcOccuranceSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_EventDtcOccuranceSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_EventDtcOccuranceSignal::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool Sig_EventDtcOccuranceSignal::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_EventDtcOccuranceSignal::getMsg_ID () const {
    return _Msg_ID;
}

inline void Sig_EventDtcOccuranceSignal::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void Sig_EventDtcOccuranceSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventDtcOccuranceSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_EventDtcOccuranceSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventDtcOccuranceSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventDtcOccuranceSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventDtcOccuranceSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventDtcOccuranceSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventDtcOccuranceSignal::set_has_DtcTable () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventDtcOccuranceSignal::clear_has_DtcTable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventDtcOccuranceSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventDtcOccuranceSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_EventDtcOccuranceSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_EventDtcOccuranceSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_EventDtcOccuranceSignal::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_EventDtcOccuranceSignal::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_EventDtcOccuranceSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_EventDtcOccuranceSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace NanoMsgLCMInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGLCMINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
