/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgIntercomInterface.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceConst.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceJson.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgIntercomInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgIntercomInterface", NanoMsgIntercomInterfaceProxy);

class NanoMsgIntercomInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NanoMsgIntercomInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< NanoMsgIntercomInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sig_RspPhoneStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspPhoneStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspPhoneStatusSignal> payload = ::boost::static_pointer_cast<Sig_RspPhoneStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspPhoneStatusCallbackIF*) _callback)->onSig_RspPhoneStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventPhoneStatusChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventPhoneStatusChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventPhoneStatusChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventPhoneStatusChangedSignal> payload = ::boost::static_pointer_cast<Sig_EventPhoneStatusChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventPhoneStatusChangedCallbackIF*) _callback)->onSig_EventPhoneStatusChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventIntercomCall:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventIntercomCallSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventIntercomCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventIntercomCallSignal> payload = ::boost::static_pointer_cast<Sig_EventIntercomCallSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventIntercomCallCallbackIF*) _callback)->onSig_EventIntercomCallSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventCancelIntercomCall:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventCancelIntercomCallSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventCancelIntercomCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventCancelIntercomCallSignal> payload = ::boost::static_pointer_cast<Sig_EventCancelIntercomCallSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventCancelIntercomCallCallbackIF*) _callback)->onSig_EventCancelIntercomCallSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventAcceptIntercomCall:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventAcceptIntercomCallSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventAcceptIntercomCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventAcceptIntercomCallSignal> payload = ::boost::static_pointer_cast<Sig_EventAcceptIntercomCallSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventAcceptIntercomCallCallbackIF*) _callback)->onSig_EventAcceptIntercomCallSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetVolume:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetVolumeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetVolumeSignal> payload = ::boost::static_pointer_cast<Sig_RspGetVolumeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetVolumeCallbackIF*) _callback)->onSig_RspGetVolumeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventSetVolume:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventSetVolumeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventSetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventSetVolumeSignal> payload = ::boost::static_pointer_cast<Sig_EventSetVolumeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventSetVolumeCallbackIF*) _callback)->onSig_EventSetVolumeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetVersion:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetVersionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetVersionSignal> payload = ::boost::static_pointer_cast<Sig_RspGetVersionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetVersionCallbackIF*) _callback)->onSig_RspGetVersionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetIntercomAvailable:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetIntercomAvailableSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetIntercomAvailableSignal> payload = ::boost::static_pointer_cast<Sig_RspGetIntercomAvailableSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetIntercomAvailableCallbackIF*) _callback)->onSig_RspGetIntercomAvailableSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventIntercomAvailable:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventIntercomAvailableSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventIntercomAvailableSignal> payload = ::boost::static_pointer_cast<Sig_EventIntercomAvailableSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventIntercomAvailableCallbackIF*) _callback)->onSig_EventIntercomAvailableSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventHUCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EventHUCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventHUCallError> payload = ::boost::static_pointer_cast<EventHUCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventHUCallCallbackIF*) _callback)->onEventHUCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventHUCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventHUCallResponse> payload = ::boost::static_pointer_cast<EventHUCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventHUCallCallbackIF*) _callback)->onEventHUCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_EventAcceptHUCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EventAcceptHUCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventAcceptHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventAcceptHUCallError> payload = ::boost::static_pointer_cast<EventAcceptHUCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventAcceptHUCallCallbackIF*) _callback)->onEventAcceptHUCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventAcceptHUCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventAcceptHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventAcceptHUCallResponse> payload = ::boost::static_pointer_cast<EventAcceptHUCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventAcceptHUCallCallbackIF*) _callback)->onEventAcceptHUCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_EventCancelHUCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EventCancelHUCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventCancelHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventCancelHUCallError> payload = ::boost::static_pointer_cast<EventCancelHUCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventCancelHUCallCallbackIF*) _callback)->onEventCancelHUCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventCancelHUCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "EventCancelHUCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EventCancelHUCallResponse> payload = ::boost::static_pointer_cast<EventCancelHUCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EventCancelHUCallCallbackIF*) _callback)->onEventCancelHUCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqPhoneStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqPhoneStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqPhoneStatusError> payload = ::boost::static_pointer_cast<ReqPhoneStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqPhoneStatusCallbackIF*) _callback)->onReqPhoneStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqPhoneStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqPhoneStatusResponse> payload = ::boost::static_pointer_cast<ReqPhoneStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqPhoneStatusCallbackIF*) _callback)->onReqPhoneStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqSetVolumeUp:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeUpError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolumeUp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeUpError> payload = ::boost::static_pointer_cast<ReqSetVolumeUpError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeUpCallbackIF*) _callback)->onReqSetVolumeUpError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeUpResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolumeUp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeUpResponse> payload = ::boost::static_pointer_cast<ReqSetVolumeUpResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeUpCallbackIF*) _callback)->onReqSetVolumeUpResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqSetVolumeDown:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeDownError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolumeDown", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeDownError> payload = ::boost::static_pointer_cast<ReqSetVolumeDownError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeDownCallbackIF*) _callback)->onReqSetVolumeDownError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeDownResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolumeDown", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeDownResponse> payload = ::boost::static_pointer_cast<ReqSetVolumeDownResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeDownCallbackIF*) _callback)->onReqSetVolumeDownResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetVolume:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVolumeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVolumeError> payload = ::boost::static_pointer_cast<ReqGetVolumeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVolumeCallbackIF*) _callback)->onReqGetVolumeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVolumeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVolumeResponse> payload = ::boost::static_pointer_cast<ReqGetVolumeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVolumeCallbackIF*) _callback)->onReqGetVolumeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqSetVolume:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeError> payload = ::boost::static_pointer_cast<ReqSetVolumeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeCallbackIF*) _callback)->onReqSetVolumeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetVolumeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetVolume", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetVolumeResponse> payload = ::boost::static_pointer_cast<ReqSetVolumeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetVolumeCallbackIF*) _callback)->onReqSetVolumeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetVersion:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVersionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVersionError> payload = ::boost::static_pointer_cast<ReqGetVersionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVersionCallbackIF*) _callback)->onReqGetVersionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVersionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVersionResponse> payload = ::boost::static_pointer_cast<ReqGetVersionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVersionCallbackIF*) _callback)->onReqGetVersionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetIntercomAvailable:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetIntercomAvailableError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetIntercomAvailableError> payload = ::boost::static_pointer_cast<ReqGetIntercomAvailableError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetIntercomAvailableCallbackIF*) _callback)->onReqGetIntercomAvailableError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetIntercomAvailableResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetIntercomAvailableResponse> payload = ::boost::static_pointer_cast<ReqGetIntercomAvailableResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetIntercomAvailableCallbackIF*) _callback)->onReqGetIntercomAvailableResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sig_RspPhoneStatus: {
                ::boost::shared_ptr< Sig_RspPhoneStatusError > payload = ::boost::shared_ptr< Sig_RspPhoneStatusError >
                (new Sig_RspPhoneStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspPhoneStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspPhoneStatusCallbackIF*) _callback)->onSig_RspPhoneStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventPhoneStatusChanged: {
                ::boost::shared_ptr< Sig_EventPhoneStatusChangedError > payload = ::boost::shared_ptr< Sig_EventPhoneStatusChangedError >
                (new Sig_EventPhoneStatusChangedError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventPhoneStatusChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventPhoneStatusChangedCallbackIF*) _callback)->onSig_EventPhoneStatusChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventIntercomCall: {
                ::boost::shared_ptr< Sig_EventIntercomCallError > payload = ::boost::shared_ptr< Sig_EventIntercomCallError >
                (new Sig_EventIntercomCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventIntercomCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventIntercomCallCallbackIF*) _callback)->onSig_EventIntercomCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventCancelIntercomCall: {
                ::boost::shared_ptr< Sig_EventCancelIntercomCallError > payload = ::boost::shared_ptr< Sig_EventCancelIntercomCallError >
                (new Sig_EventCancelIntercomCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventCancelIntercomCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventCancelIntercomCallCallbackIF*) _callback)->onSig_EventCancelIntercomCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventAcceptIntercomCall: {
                ::boost::shared_ptr< Sig_EventAcceptIntercomCallError > payload = ::boost::shared_ptr< Sig_EventAcceptIntercomCallError >
                (new Sig_EventAcceptIntercomCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventAcceptIntercomCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventAcceptIntercomCallCallbackIF*) _callback)->onSig_EventAcceptIntercomCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetVolume: {
                ::boost::shared_ptr< Sig_RspGetVolumeError > payload = ::boost::shared_ptr< Sig_RspGetVolumeError >
                (new Sig_RspGetVolumeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetVolumeCallbackIF*) _callback)->onSig_RspGetVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventSetVolume: {
                ::boost::shared_ptr< Sig_EventSetVolumeError > payload = ::boost::shared_ptr< Sig_EventSetVolumeError >
                (new Sig_EventSetVolumeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventSetVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventSetVolumeCallbackIF*) _callback)->onSig_EventSetVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetVersion: {
                ::boost::shared_ptr< Sig_RspGetVersionError > payload = ::boost::shared_ptr< Sig_RspGetVersionError >
                (new Sig_RspGetVersionError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetVersionCallbackIF*) _callback)->onSig_RspGetVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetIntercomAvailable: {
                ::boost::shared_ptr< Sig_RspGetIntercomAvailableError > payload = ::boost::shared_ptr< Sig_RspGetIntercomAvailableError >
                (new Sig_RspGetIntercomAvailableError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetIntercomAvailable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetIntercomAvailableCallbackIF*) _callback)->onSig_RspGetIntercomAvailableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventIntercomAvailable: {
                ::boost::shared_ptr< Sig_EventIntercomAvailableError > payload = ::boost::shared_ptr< Sig_EventIntercomAvailableError >
                (new Sig_EventIntercomAvailableError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventIntercomAvailable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventIntercomAvailableCallbackIF*) _callback)->onSig_EventIntercomAvailableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventHUCall: {
                ::boost::shared_ptr< EventHUCallError > payload = ::boost::shared_ptr< EventHUCallError >
                (new EventHUCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventHUCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventHUCallCallbackIF*) _callback)->onEventHUCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventAcceptHUCall: {
                ::boost::shared_ptr< EventAcceptHUCallError > payload = ::boost::shared_ptr< EventAcceptHUCallError >
                (new EventAcceptHUCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventAcceptHUCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventAcceptHUCallCallbackIF*) _callback)->onEventAcceptHUCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventCancelHUCall: {
                ::boost::shared_ptr< EventCancelHUCallError > payload = ::boost::shared_ptr< EventCancelHUCallError >
                (new EventCancelHUCallError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventCancelHUCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventCancelHUCallCallbackIF*) _callback)->onEventCancelHUCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqPhoneStatus: {
                ::boost::shared_ptr< ReqPhoneStatusError > payload = ::boost::shared_ptr< ReqPhoneStatusError >
                (new ReqPhoneStatusError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqPhoneStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqPhoneStatusCallbackIF*) _callback)->onReqPhoneStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetVolumeUp: {
                ::boost::shared_ptr< ReqSetVolumeUpError > payload = ::boost::shared_ptr< ReqSetVolumeUpError >
                (new ReqSetVolumeUpError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetVolumeUp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetVolumeUpCallbackIF*) _callback)->onReqSetVolumeUpError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetVolumeDown: {
                ::boost::shared_ptr< ReqSetVolumeDownError > payload = ::boost::shared_ptr< ReqSetVolumeDownError >
                (new ReqSetVolumeDownError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetVolumeDown", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetVolumeDownCallbackIF*) _callback)->onReqSetVolumeDownError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetVolume: {
                ::boost::shared_ptr< ReqGetVolumeError > payload = ::boost::shared_ptr< ReqGetVolumeError >
                (new ReqGetVolumeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetVolumeCallbackIF*) _callback)->onReqGetVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetVolume: {
                ::boost::shared_ptr< ReqSetVolumeError > payload = ::boost::shared_ptr< ReqSetVolumeError >
                (new ReqSetVolumeError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetVolumeCallbackIF*) _callback)->onReqSetVolumeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetVersion: {
                ::boost::shared_ptr< ReqGetVersionError > payload = ::boost::shared_ptr< ReqGetVersionError >
                (new ReqGetVersionError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetVersionCallbackIF*) _callback)->onReqGetVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetIntercomAvailable: {
                ::boost::shared_ptr< ReqGetIntercomAvailableError > payload = ::boost::shared_ptr< ReqGetIntercomAvailableError >
                (new ReqGetIntercomAvailableError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgIntercomInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetIntercomAvailable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgIntercomInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetIntercomAvailableCallbackIF*) _callback)->onReqGetIntercomAvailableError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NanoMsgIntercomInterfaceProxyCallback::_logger (NanoMsgIntercomInterfaceProxy::_logger);

NanoMsgIntercomInterfaceProxy::NanoMsgIntercomInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.di.NanoMsgIntercomInterface", serviceAvailable, _logger) {
}

NanoMsgIntercomInterfaceProxy::~NanoMsgIntercomInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NanoMsgIntercomInterfaceProxy > NanoMsgIntercomInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NanoMsgIntercomInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy > proxyNew(new NanoMsgIntercomInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t NanoMsgIntercomInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NanoMsgIntercomInterfaceProxyCallback* callback = new NanoMsgIntercomInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NanoMsgIntercomInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NanoMsgIntercomInterfaceProxyCallback* callback = new NanoMsgIntercomInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void NanoMsgIntercomInterfaceProxy::sendDeregisterAll () const
{
    sendSig_RspPhoneStatusDeregisterAll();
    sendSig_EventPhoneStatusChangedDeregisterAll();
    sendSig_EventIntercomCallDeregisterAll();
    sendSig_EventCancelIntercomCallDeregisterAll();
    sendSig_EventAcceptIntercomCallDeregisterAll();
    sendSig_RspGetVolumeDeregisterAll();
    sendSig_EventSetVolumeDeregisterAll();
    sendSig_RspGetVersionDeregisterAll();
    sendSig_RspGetIntercomAvailableDeregisterAll();
    sendSig_EventIntercomAvailableDeregisterAll();
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_RspPhoneStatusRegister(Sig_RspPhoneStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspPhoneStatus");
    act_t act = addSignalCallback(ID_sig_RspPhoneStatus, "sig_RspPhoneStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspPhoneStatus", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_RspPhoneStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspPhoneStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspPhoneStatus", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_RspPhoneStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspPhoneStatus");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspPhoneStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventPhoneStatusChangedRegister(Sig_EventPhoneStatusChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventPhoneStatusChanged");
    act_t act = addSignalCallback(ID_sig_EventPhoneStatusChanged, "sig_EventPhoneStatusChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventPhoneStatusChanged", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventPhoneStatusChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventPhoneStatusChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventPhoneStatusChanged", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventPhoneStatusChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventPhoneStatusChanged");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventPhoneStatusChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomCallRegister(Sig_EventIntercomCallCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventIntercomCall");
    act_t act = addSignalCallback(ID_sig_EventIntercomCall, "sig_EventIntercomCall", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventIntercomCall", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomCallDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventIntercomCall", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventIntercomCall", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomCallDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventIntercomCall");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventIntercomCall", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventCancelIntercomCallRegister(Sig_EventCancelIntercomCallCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventCancelIntercomCall");
    act_t act = addSignalCallback(ID_sig_EventCancelIntercomCall, "sig_EventCancelIntercomCall", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventCancelIntercomCall", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventCancelIntercomCallDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventCancelIntercomCall", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventCancelIntercomCall", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventCancelIntercomCallDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventCancelIntercomCall");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventCancelIntercomCall", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventAcceptIntercomCallRegister(Sig_EventAcceptIntercomCallCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventAcceptIntercomCall");
    act_t act = addSignalCallback(ID_sig_EventAcceptIntercomCall, "sig_EventAcceptIntercomCall", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventAcceptIntercomCall", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventAcceptIntercomCallDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventAcceptIntercomCall", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventAcceptIntercomCall", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventAcceptIntercomCallDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventAcceptIntercomCall");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventAcceptIntercomCall", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_RspGetVolumeRegister(Sig_RspGetVolumeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetVolume");
    act_t act = addSignalCallback(ID_sig_RspGetVolume, "sig_RspGetVolume", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetVolume", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_RspGetVolumeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetVolume", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetVolume", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_RspGetVolumeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetVolume");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetVolume", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventSetVolumeRegister(Sig_EventSetVolumeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventSetVolume");
    act_t act = addSignalCallback(ID_sig_EventSetVolume, "sig_EventSetVolume", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventSetVolume", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventSetVolumeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventSetVolume", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventSetVolume", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventSetVolumeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventSetVolume");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventSetVolume", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_RspGetVersionRegister(Sig_RspGetVersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetVersion");
    act_t act = addSignalCallback(ID_sig_RspGetVersion, "sig_RspGetVersion", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetVersion", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_RspGetVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetVersion", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetVersion", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_RspGetVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetVersion");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetVersion", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_RspGetIntercomAvailableRegister(Sig_RspGetIntercomAvailableCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetIntercomAvailable");
    act_t act = addSignalCallback(ID_sig_RspGetIntercomAvailable, "sig_RspGetIntercomAvailable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetIntercomAvailable", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_RspGetIntercomAvailableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetIntercomAvailable", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetIntercomAvailable", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_RspGetIntercomAvailableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetIntercomAvailable");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetIntercomAvailable", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomAvailableRegister(Sig_EventIntercomAvailableCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventIntercomAvailable");
    act_t act = addSignalCallback(ID_sig_EventIntercomAvailable, "sig_EventIntercomAvailable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventIntercomAvailable", &cb, act);
    return act;
}

bool NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomAvailableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventIntercomAvailable", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventIntercomAvailable", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgIntercomInterfaceProxy::sendSig_EventIntercomAvailableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventIntercomAvailable");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventIntercomAvailable", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgIntercomInterfaceProxy::sendEventHUCallRequest(EventHUCallCallbackIF& cb, eTPhoneNumber phoneNumber, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    EventHUCallRequest* payload = new EventHUCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setPhoneNumber(phoneNumber);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "EventHUCall", EventHUCallRequest, payload, true)
    act_t act = addMethodCallback(ID_EventHUCall, dbusMessage.getUniqueSerial(), "EventHUCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EventHUCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendEventAcceptHUCallRequest(EventAcceptHUCallCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    EventAcceptHUCallRequest* payload = new EventAcceptHUCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "EventAcceptHUCall", EventAcceptHUCallRequest, payload, true)
    act_t act = addMethodCallback(ID_EventAcceptHUCall, dbusMessage.getUniqueSerial(), "EventAcceptHUCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EventAcceptHUCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendEventCancelHUCallRequest(EventCancelHUCallCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    EventCancelHUCallRequest* payload = new EventCancelHUCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "EventCancelHUCall", EventCancelHUCallRequest, payload, true)
    act_t act = addMethodCallback(ID_EventCancelHUCall, dbusMessage.getUniqueSerial(), "EventCancelHUCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "EventCancelHUCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqPhoneStatusRequest(ReqPhoneStatusCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqPhoneStatusRequest* payload = new ReqPhoneStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqPhoneStatus", ReqPhoneStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqPhoneStatus, dbusMessage.getUniqueSerial(), "ReqPhoneStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqPhoneStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqSetVolumeUpRequest(ReqSetVolumeUpCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetVolumeUpRequest* payload = new ReqSetVolumeUpRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetVolumeUp", ReqSetVolumeUpRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetVolumeUp, dbusMessage.getUniqueSerial(), "ReqSetVolumeUp", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetVolumeUp", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqSetVolumeDownRequest(ReqSetVolumeDownCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetVolumeDownRequest* payload = new ReqSetVolumeDownRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetVolumeDown", ReqSetVolumeDownRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetVolumeDown, dbusMessage.getUniqueSerial(), "ReqSetVolumeDown", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetVolumeDown", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqGetVolumeRequest(ReqGetVolumeCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetVolumeRequest* payload = new ReqGetVolumeRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetVolume", ReqGetVolumeRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetVolume, dbusMessage.getUniqueSerial(), "ReqGetVolume", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetVolume", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqSetVolumeRequest(ReqSetVolumeCallbackIF& cb, uint8 volumevalue, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetVolumeRequest* payload = new ReqSetVolumeRequest();
    CHECK_ALLOCATION(payload);
    payload->setVolumevalue(volumevalue);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetVolume", ReqSetVolumeRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetVolume, dbusMessage.getUniqueSerial(), "ReqSetVolume", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetVolume", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqGetVersionRequest(ReqGetVersionCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetVersionRequest* payload = new ReqGetVersionRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetVersion", ReqGetVersionRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetVersion, dbusMessage.getUniqueSerial(), "ReqGetVersion", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetVersion", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgIntercomInterfaceProxy::sendReqGetIntercomAvailableRequest(ReqGetIntercomAvailableCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetIntercomAvailableRequest* payload = new ReqGetIntercomAvailableRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetIntercomAvailable", ReqGetIntercomAvailableRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetIntercomAvailable, dbusMessage.getUniqueSerial(), "ReqGetIntercomAvailable", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetIntercomAvailable", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NanoMsgIntercomInterface
} // namespace di
} // namespace cm
} // namespace bosch
