#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGINTERCOMINTERFACE_H
#define BOSCH_CM_DI_NANOMSGINTERCOMINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "bosch.cm.di.NanoMsgIntercomInterface" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgIntercomInterface {

// method IDs
static const uint16 ID_EventHUCall = 0;
static const uint16 ID_EventAcceptHUCall = 1;
static const uint16 ID_EventCancelHUCall = 2;
static const uint16 ID_ReqPhoneStatus = 3;
static const uint16 ID_ReqSetVolumeUp = 4;
static const uint16 ID_ReqSetVolumeDown = 5;
static const uint16 ID_ReqGetVolume = 6;
static const uint16 ID_ReqSetVolume = 7;
static const uint16 ID_ReqGetVersion = 8;
static const uint16 ID_ReqGetIntercomAvailable = 9;

// signal IDs
static const uint16 ID_sig_RspPhoneStatus = 10;
static const uint16 ID_sig_EventPhoneStatusChanged = 11;
static const uint16 ID_sig_EventIntercomCall = 12;
static const uint16 ID_sig_EventCancelIntercomCall = 13;
static const uint16 ID_sig_EventAcceptIntercomCall = 14;
static const uint16 ID_sig_RspGetVolume = 15;
static const uint16 ID_sig_EventSetVolume = 16;
static const uint16 ID_sig_RspGetVersion = 17;
static const uint16 ID_sig_RspGetIntercomAvailable = 18;
static const uint16 ID_sig_EventIntercomAvailable = 19;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class EventHUCallRequest;

class EventHUCallResponse;

class EventAcceptHUCallRequest;

class EventAcceptHUCallResponse;

class EventCancelHUCallRequest;

class EventCancelHUCallResponse;

class ReqPhoneStatusRequest;

class ReqPhoneStatusResponse;

class ReqSetVolumeUpRequest;

class ReqSetVolumeUpResponse;

class ReqSetVolumeDownRequest;

class ReqSetVolumeDownResponse;

class ReqGetVolumeRequest;

class ReqGetVolumeResponse;

class ReqSetVolumeRequest;

class ReqSetVolumeResponse;

class ReqGetVersionRequest;

class ReqGetVersionResponse;

class ReqGetIntercomAvailableRequest;

class ReqGetIntercomAvailableResponse;

class Sig_RspPhoneStatusSignal;

class Sig_EventPhoneStatusChangedSignal;

class Sig_EventIntercomCallSignal;

class Sig_EventCancelIntercomCallSignal;

class Sig_EventAcceptIntercomCallSignal;

class Sig_RspGetVolumeSignal;

class Sig_EventSetVolumeSignal;

class Sig_RspGetVersionSignal;

class Sig_RspGetIntercomAvailableSignal;

class Sig_EventIntercomAvailableSignal;

// type definitions
/**
 * If the meaning of "EventHUCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventHUCallError;

/**
 * If the meaning of "EventAcceptHUCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventAcceptHUCallError;

/**
 * If the meaning of "EventCancelHUCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventCancelHUCallError;

/**
 * If the meaning of "ReqPhoneStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqPhoneStatusError;

/**
 * If the meaning of "ReqSetVolumeUpError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetVolumeUpError;

/**
 * If the meaning of "ReqSetVolumeDownError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetVolumeDownError;

/**
 * If the meaning of "ReqGetVolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetVolumeError;

/**
 * If the meaning of "ReqSetVolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqSetVolumeError;

/**
 * If the meaning of "ReqGetVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetVersionError;

/**
 * If the meaning of "ReqGetIntercomAvailableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqGetIntercomAvailableError;

/**
 * If the meaning of "Sig_RspPhoneStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspPhoneStatusError;

/**
 * If the meaning of "Sig_EventPhoneStatusChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventPhoneStatusChangedError;

/**
 * If the meaning of "Sig_EventIntercomCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventIntercomCallError;

/**
 * If the meaning of "Sig_EventCancelIntercomCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventCancelIntercomCallError;

/**
 * If the meaning of "Sig_EventAcceptIntercomCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventAcceptIntercomCallError;

/**
 * If the meaning of "Sig_RspGetVolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetVolumeError;

/**
 * If the meaning of "Sig_EventSetVolumeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventSetVolumeError;

/**
 * If the meaning of "Sig_RspGetVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetVersionError;

/**
 * If the meaning of "Sig_RspGetIntercomAvailableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_RspGetIntercomAvailableError;

/**
 * If the meaning of "Sig_EventIntercomAvailableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_EventIntercomAvailableError;


/**
 * xxxx  CMC -- CMA
 */
class EventHUCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventHUCallRequest ();

    /**
     * Copy constructor
     */
    inline  EventHUCallRequest (const EventHUCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EventHUCallRequest (eTPhoneNumber phoneNumber_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~EventHUCallRequest();

    /**
     * Assignment operator
     */
    inline EventHUCallRequest& operator = (const EventHUCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventHUCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventHUCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventHUCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventHUCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNumber"
     */
    inline eTPhoneNumber getPhoneNumber () const;

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (eTPhoneNumber phoneNumber_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const EventHUCallRequest &getDefaultInstance();

private:

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    eTPhoneNumber _phoneNumber;

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class EventHUCallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventHUCallResponse ();

    /**
     * Copy constructor
     */
    inline  EventHUCallResponse (const EventHUCallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EventHUCallResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~EventHUCallResponse();

    /**
     * Assignment operator
     */
    inline EventHUCallResponse& operator = (const EventHUCallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventHUCallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventHUCallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventHUCallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventHUCallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const EventHUCallResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class EventAcceptHUCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventAcceptHUCallRequest ();

    /**
     * Copy constructor
     */
    inline  EventAcceptHUCallRequest (const EventAcceptHUCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EventAcceptHUCallRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~EventAcceptHUCallRequest();

    /**
     * Assignment operator
     */
    inline EventAcceptHUCallRequest& operator = (const EventAcceptHUCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventAcceptHUCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventAcceptHUCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventAcceptHUCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventAcceptHUCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const EventAcceptHUCallRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class EventAcceptHUCallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventAcceptHUCallResponse ();

    /**
     * Copy constructor
     */
    inline  EventAcceptHUCallResponse (const EventAcceptHUCallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EventAcceptHUCallResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~EventAcceptHUCallResponse();

    /**
     * Assignment operator
     */
    inline EventAcceptHUCallResponse& operator = (const EventAcceptHUCallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventAcceptHUCallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventAcceptHUCallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventAcceptHUCallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventAcceptHUCallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const EventAcceptHUCallResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx CMC -- CMA
 */
class EventCancelHUCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventCancelHUCallRequest ();

    /**
     * Copy constructor
     */
    inline  EventCancelHUCallRequest (const EventCancelHUCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  EventCancelHUCallRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~EventCancelHUCallRequest();

    /**
     * Assignment operator
     */
    inline EventCancelHUCallRequest& operator = (const EventCancelHUCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventCancelHUCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventCancelHUCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventCancelHUCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventCancelHUCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const EventCancelHUCallRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx CMC -- CMA
 */
class EventCancelHUCallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventCancelHUCallResponse ();

    /**
     * Copy constructor
     */
    inline  EventCancelHUCallResponse (const EventCancelHUCallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EventCancelHUCallResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~EventCancelHUCallResponse();

    /**
     * Assignment operator
     */
    inline EventCancelHUCallResponse& operator = (const EventCancelHUCallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventCancelHUCallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventCancelHUCallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventCancelHUCallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventCancelHUCallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const EventCancelHUCallResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx CMC -- CMA
 */
class ReqPhoneStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqPhoneStatusRequest ();

    /**
     * Copy constructor
     */
    inline  ReqPhoneStatusRequest (const ReqPhoneStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqPhoneStatusRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqPhoneStatusRequest();

    /**
     * Assignment operator
     */
    inline ReqPhoneStatusRequest& operator = (const ReqPhoneStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqPhoneStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqPhoneStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqPhoneStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqPhoneStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqPhoneStatusRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx CMC -- CMA
 */
class ReqPhoneStatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqPhoneStatusResponse ();

    /**
     * Copy constructor
     */
    inline  ReqPhoneStatusResponse (const ReqPhoneStatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqPhoneStatusResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqPhoneStatusResponse();

    /**
     * Assignment operator
     */
    inline ReqPhoneStatusResponse& operator = (const ReqPhoneStatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqPhoneStatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqPhoneStatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqPhoneStatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqPhoneStatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqPhoneStatusResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx CMC -- CMA
 */
class ReqSetVolumeUpRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeUpRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeUpRequest (const ReqSetVolumeUpRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeUpRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeUpRequest();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeUpRequest& operator = (const ReqSetVolumeUpRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeUpRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeUpRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeUpRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeUpRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetVolumeUpRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx CMC -- CMA
 */
class ReqSetVolumeUpResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeUpResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeUpResponse (const ReqSetVolumeUpResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeUpResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeUpResponse();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeUpResponse& operator = (const ReqSetVolumeUpResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeUpResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeUpResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeUpResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeUpResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetVolumeUpResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqSetVolumeDownRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeDownRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeDownRequest (const ReqSetVolumeDownRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeDownRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeDownRequest();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeDownRequest& operator = (const ReqSetVolumeDownRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeDownRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeDownRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeDownRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeDownRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetVolumeDownRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqSetVolumeDownResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeDownResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeDownResponse (const ReqSetVolumeDownResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeDownResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeDownResponse();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeDownResponse& operator = (const ReqSetVolumeDownResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeDownResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeDownResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeDownResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeDownResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetVolumeDownResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetVolumeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVolumeRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetVolumeRequest (const ReqGetVolumeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVolumeRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVolumeRequest();

    /**
     * Assignment operator
     */
    inline ReqGetVolumeRequest& operator = (const ReqGetVolumeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVolumeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVolumeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVolumeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVolumeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetVolumeRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetVolumeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVolumeResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetVolumeResponse (const ReqGetVolumeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVolumeResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVolumeResponse();

    /**
     * Assignment operator
     */
    inline ReqGetVolumeResponse& operator = (const ReqGetVolumeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVolumeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVolumeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVolumeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVolumeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetVolumeResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqSetVolumeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeRequest ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeRequest (const ReqSetVolumeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeRequest (uint8 Volumevalue_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeRequest();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeRequest& operator = (const ReqSetVolumeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volumevalue"

    static const int kVolumevalue = 0;

    /**
     * Clears the field "Volumevalue".
     *
     * The field will be set to its default value. The hasVolumevalue()
     * method will return false.
     */
    inline void clearVolumevalue();

    /**
     * Checks whether the field "Volumevalue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumevalue()). Otherwise it will return false.
     */
    inline bool hasVolumevalue () const;

    /**
     * Returns the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Volumevalue"
     */
    inline uint8 getVolumevalue () const;

    /**
     * Sets the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @param Volumevalue The value which will be set
     */
    inline void setVolumevalue (uint8 Volumevalue_);

    // API of field "Dev_ID"

    static const int kDev_ID = 1;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 2;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 3;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 4;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqSetVolumeRequest &getDefaultInstance();

private:

    inline void set_has_Volumevalue ();

    inline void clear_has_Volumevalue ();

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _Volumevalue;

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqSetVolumeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqSetVolumeResponse ();

    /**
     * Copy constructor
     */
    inline  ReqSetVolumeResponse (const ReqSetVolumeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqSetVolumeResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqSetVolumeResponse();

    /**
     * Assignment operator
     */
    inline ReqSetVolumeResponse& operator = (const ReqSetVolumeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqSetVolumeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqSetVolumeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqSetVolumeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqSetVolumeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqSetVolumeResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetVersionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVersionRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetVersionRequest (const ReqGetVersionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVersionRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVersionRequest();

    /**
     * Assignment operator
     */
    inline ReqGetVersionRequest& operator = (const ReqGetVersionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVersionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVersionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVersionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVersionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetVersionRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetVersionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetVersionResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetVersionResponse (const ReqGetVersionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetVersionResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetVersionResponse();

    /**
     * Assignment operator
     */
    inline ReqGetVersionResponse& operator = (const ReqGetVersionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetVersionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetVersionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetVersionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetVersionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetVersionResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetIntercomAvailableRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetIntercomAvailableRequest ();

    /**
     * Copy constructor
     */
    inline  ReqGetIntercomAvailableRequest (const ReqGetIntercomAvailableRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetIntercomAvailableRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetIntercomAvailableRequest();

    /**
     * Assignment operator
     */
    inline ReqGetIntercomAvailableRequest& operator = (const ReqGetIntercomAvailableRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetIntercomAvailableRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetIntercomAvailableRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetIntercomAvailableRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetIntercomAvailableRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline uint8 getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (uint8 Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "Msg_ID"

    static const int kMsg_ID = 2;

    /**
     * Clears the field "Msg_ID".
     *
     * The field will be set to its default value. The hasMsg_ID()
     * method will return false.
     */
    inline void clearMsg_ID();

    /**
     * Checks whether the field "Msg_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsg_ID()). Otherwise it will return false.
     */
    inline bool hasMsg_ID () const;

    /**
     * Returns the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Msg_ID"
     */
    inline uint16 getMsg_ID () const;

    /**
     * Sets the value of the member "Msg_ID".
     *
     * If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param Msg_ID The value which will be set
     */
    inline void setMsg_ID (uint16 Msg_ID_);

    // API of field "DestIP"

    static const int kDestIP = 3;

    /**
     * Clears the field "DestIP".
     *
     * The field will be set to its default value. The hasDestIP()
     * method will return false.
     */
    inline void clearDestIP();

    /**
     * Checks whether the field "DestIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestIP()). Otherwise it will return false.
     */
    inline bool hasDestIP () const;

    /**
     * Returns the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestIP"
     */
    inline const ::std::string& getDestIP () const;

    /**
     * Retrieves the value of the field "DestIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestIP".
     */
    inline ::std::string& getDestIPMutable ();

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const ::std::string& DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* DestIP_);

    /**
     * Sets the value of the member "DestIP".
     *
     * If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @param DestIP The value which will be set
     */
    inline void setDestIP (const char* value, size_t size);

    static const ReqGetIntercomAvailableRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_Msg_ID ();

    inline void clear_has_Msg_ID ();

    inline void set_has_DestIP ();

    inline void clear_has_DestIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Dev_ID;

    uint8 _Dev_Nr;

    uint16 _Msg_ID;

    ::std::string _DestIP;

};

/**
 * xxxx  CMC -- CMA
 */
class ReqGetIntercomAvailableResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqGetIntercomAvailableResponse ();

    /**
     * Copy constructor
     */
    inline  ReqGetIntercomAvailableResponse (const ReqGetIntercomAvailableResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqGetIntercomAvailableResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqGetIntercomAvailableResponse();

    /**
     * Assignment operator
     */
    inline ReqGetIntercomAvailableResponse& operator = (const ReqGetIntercomAvailableResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqGetIntercomAvailableResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqGetIntercomAvailableResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqGetIntercomAvailableResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqGetIntercomAvailableResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqGetIntercomAvailableResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * xxxx   CMA -- CMC
 */
class Sig_RspPhoneStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspPhoneStatusSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspPhoneStatusSignal (const Sig_RspPhoneStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspPhoneStatusSignal (uint8 phonestatus1_, uint8 phonestatus2_, uint8 phonestatus3_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspPhoneStatusSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspPhoneStatusSignal& operator = (const Sig_RspPhoneStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspPhoneStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspPhoneStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspPhoneStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspPhoneStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phonestatus1"

    static const int kPhonestatus1 = 0;

    /**
     * Clears the field "phonestatus1".
     *
     * The field will be set to its default value. The hasPhonestatus1()
     * method will return false.
     */
    inline void clearPhonestatus1();

    /**
     * Checks whether the field "phonestatus1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonestatus1()). Otherwise it will return false.
     */
    inline bool hasPhonestatus1 () const;

    /**
     * Returns the value of the member "phonestatus1".
     *
     * If the meaning of "phonestatus1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonestatus1"
     */
    inline uint8 getPhonestatus1 () const;

    /**
     * Sets the value of the member "phonestatus1".
     *
     * If the meaning of "phonestatus1" isn't clear, then there should be a description here.
     *
     * @param phonestatus1 The value which will be set
     */
    inline void setPhonestatus1 (uint8 phonestatus1_);

    // API of field "phonestatus2"

    static const int kPhonestatus2 = 1;

    /**
     * Clears the field "phonestatus2".
     *
     * The field will be set to its default value. The hasPhonestatus2()
     * method will return false.
     */
    inline void clearPhonestatus2();

    /**
     * Checks whether the field "phonestatus2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonestatus2()). Otherwise it will return false.
     */
    inline bool hasPhonestatus2 () const;

    /**
     * Returns the value of the member "phonestatus2".
     *
     * If the meaning of "phonestatus2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonestatus2"
     */
    inline uint8 getPhonestatus2 () const;

    /**
     * Sets the value of the member "phonestatus2".
     *
     * If the meaning of "phonestatus2" isn't clear, then there should be a description here.
     *
     * @param phonestatus2 The value which will be set
     */
    inline void setPhonestatus2 (uint8 phonestatus2_);

    // API of field "phonestatus3"

    static const int kPhonestatus3 = 2;

    /**
     * Clears the field "phonestatus3".
     *
     * The field will be set to its default value. The hasPhonestatus3()
     * method will return false.
     */
    inline void clearPhonestatus3();

    /**
     * Checks whether the field "phonestatus3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonestatus3()). Otherwise it will return false.
     */
    inline bool hasPhonestatus3 () const;

    /**
     * Returns the value of the member "phonestatus3".
     *
     * If the meaning of "phonestatus3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonestatus3"
     */
    inline uint8 getPhonestatus3 () const;

    /**
     * Sets the value of the member "phonestatus3".
     *
     * If the meaning of "phonestatus3" isn't clear, then there should be a description here.
     *
     * @param phonestatus3 The value which will be set
     */
    inline void setPhonestatus3 (uint8 phonestatus3_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 3;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspPhoneStatusSignal &getDefaultInstance();

private:

    inline void set_has_phonestatus1 ();

    inline void clear_has_phonestatus1 ();

    inline void set_has_phonestatus2 ();

    inline void clear_has_phonestatus2 ();

    inline void set_has_phonestatus3 ();

    inline void clear_has_phonestatus3 ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _phonestatus1;

    uint8 _phonestatus2;

    uint8 _phonestatus3;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventPhoneStatusChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventPhoneStatusChangedSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventPhoneStatusChangedSignal (const Sig_EventPhoneStatusChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventPhoneStatusChangedSignal (eTPhoneNumber phoneNumber_, uint8 phonestatus_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventPhoneStatusChangedSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventPhoneStatusChangedSignal& operator = (const Sig_EventPhoneStatusChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNumber"
     */
    inline eTPhoneNumber getPhoneNumber () const;

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (eTPhoneNumber phoneNumber_);

    // API of field "phonestatus"

    static const int kPhonestatus = 1;

    /**
     * Clears the field "phonestatus".
     *
     * The field will be set to its default value. The hasPhonestatus()
     * method will return false.
     */
    inline void clearPhonestatus();

    /**
     * Checks whether the field "phonestatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonestatus()). Otherwise it will return false.
     */
    inline bool hasPhonestatus () const;

    /**
     * Returns the value of the member "phonestatus".
     *
     * If the meaning of "phonestatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phonestatus"
     */
    inline uint8 getPhonestatus () const;

    /**
     * Sets the value of the member "phonestatus".
     *
     * If the meaning of "phonestatus" isn't clear, then there should be a description here.
     *
     * @param phonestatus The value which will be set
     */
    inline void setPhonestatus (uint8 phonestatus_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 2;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventPhoneStatusChangedSignal &getDefaultInstance();

private:

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_phonestatus ();

    inline void clear_has_phonestatus ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (3 + 31) / 32];

    eTPhoneNumber _phoneNumber;

    uint8 _phonestatus;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventIntercomCallSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventIntercomCallSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventIntercomCallSignal (const Sig_EventIntercomCallSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventIntercomCallSignal (eTPhoneNumber phoneNumber_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventIntercomCallSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventIntercomCallSignal& operator = (const Sig_EventIntercomCallSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventIntercomCallSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventIntercomCallSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventIntercomCallSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventIntercomCallSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNumber"
     */
    inline eTPhoneNumber getPhoneNumber () const;

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (eTPhoneNumber phoneNumber_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventIntercomCallSignal &getDefaultInstance();

private:

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    eTPhoneNumber _phoneNumber;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventCancelIntercomCallSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventCancelIntercomCallSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventCancelIntercomCallSignal (const Sig_EventCancelIntercomCallSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventCancelIntercomCallSignal (bool response_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventCancelIntercomCallSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventCancelIntercomCallSignal& operator = (const Sig_EventCancelIntercomCallSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventCancelIntercomCallSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventCancelIntercomCallSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventCancelIntercomCallSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventCancelIntercomCallSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventCancelIntercomCallSignal &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _response;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventAcceptIntercomCallSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventAcceptIntercomCallSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventAcceptIntercomCallSignal (const Sig_EventAcceptIntercomCallSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventAcceptIntercomCallSignal (eTPhoneNumber phoneNumber_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventAcceptIntercomCallSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventAcceptIntercomCallSignal& operator = (const Sig_EventAcceptIntercomCallSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventAcceptIntercomCallSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventAcceptIntercomCallSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventAcceptIntercomCallSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventAcceptIntercomCallSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNumber"

    static const int kPhoneNumber = 0;

    /**
     * Clears the field "phoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "phoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNumber"
     */
    inline eTPhoneNumber getPhoneNumber () const;

    /**
     * Sets the value of the member "phoneNumber".
     *
     * If the meaning of "phoneNumber" isn't clear, then there should be a description here.
     *
     * @param phoneNumber The value which will be set
     */
    inline void setPhoneNumber (eTPhoneNumber phoneNumber_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventAcceptIntercomCallSignal &getDefaultInstance();

private:

    inline void set_has_phoneNumber ();

    inline void clear_has_phoneNumber ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    eTPhoneNumber _phoneNumber;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_RspGetVolumeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetVolumeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetVolumeSignal (const Sig_RspGetVolumeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetVolumeSignal (uint8 Volumevalue_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetVolumeSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetVolumeSignal& operator = (const Sig_RspGetVolumeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetVolumeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetVolumeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetVolumeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetVolumeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volumevalue"

    static const int kVolumevalue = 0;

    /**
     * Clears the field "Volumevalue".
     *
     * The field will be set to its default value. The hasVolumevalue()
     * method will return false.
     */
    inline void clearVolumevalue();

    /**
     * Checks whether the field "Volumevalue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumevalue()). Otherwise it will return false.
     */
    inline bool hasVolumevalue () const;

    /**
     * Returns the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Volumevalue"
     */
    inline uint8 getVolumevalue () const;

    /**
     * Sets the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @param Volumevalue The value which will be set
     */
    inline void setVolumevalue (uint8 Volumevalue_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspGetVolumeSignal &getDefaultInstance();

private:

    inline void set_has_Volumevalue ();

    inline void clear_has_Volumevalue ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Volumevalue;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventSetVolumeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventSetVolumeSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventSetVolumeSignal (const Sig_EventSetVolumeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventSetVolumeSignal (uint8 Volumevalue_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventSetVolumeSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventSetVolumeSignal& operator = (const Sig_EventSetVolumeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventSetVolumeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventSetVolumeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventSetVolumeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventSetVolumeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volumevalue"

    static const int kVolumevalue = 0;

    /**
     * Clears the field "Volumevalue".
     *
     * The field will be set to its default value. The hasVolumevalue()
     * method will return false.
     */
    inline void clearVolumevalue();

    /**
     * Checks whether the field "Volumevalue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumevalue()). Otherwise it will return false.
     */
    inline bool hasVolumevalue () const;

    /**
     * Returns the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Volumevalue"
     */
    inline uint8 getVolumevalue () const;

    /**
     * Sets the value of the member "Volumevalue".
     *
     * If the meaning of "Volumevalue" isn't clear, then there should be a description here.
     *
     * @param Volumevalue The value which will be set
     */
    inline void setVolumevalue (uint8 Volumevalue_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventSetVolumeSignal &getDefaultInstance();

private:

    inline void set_has_Volumevalue ();

    inline void clear_has_Volumevalue ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Volumevalue;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_RspGetVersionSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetVersionSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetVersionSignal (const Sig_RspGetVersionSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetVersionSignal (uint32 Swversion_, uint32 Hwversion_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetVersionSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetVersionSignal& operator = (const Sig_RspGetVersionSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetVersionSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetVersionSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetVersionSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetVersionSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Swversion"

    static const int kSwversion = 0;

    /**
     * Clears the field "Swversion".
     *
     * The field will be set to its default value. The hasSwversion()
     * method will return false.
     */
    inline void clearSwversion();

    /**
     * Checks whether the field "Swversion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwversion()). Otherwise it will return false.
     */
    inline bool hasSwversion () const;

    /**
     * Returns the value of the member "Swversion".
     *
     * If the meaning of "Swversion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Swversion"
     */
    inline uint32 getSwversion () const;

    /**
     * Sets the value of the member "Swversion".
     *
     * If the meaning of "Swversion" isn't clear, then there should be a description here.
     *
     * @param Swversion The value which will be set
     */
    inline void setSwversion (uint32 Swversion_);

    // API of field "Hwversion"

    static const int kHwversion = 1;

    /**
     * Clears the field "Hwversion".
     *
     * The field will be set to its default value. The hasHwversion()
     * method will return false.
     */
    inline void clearHwversion();

    /**
     * Checks whether the field "Hwversion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwversion()). Otherwise it will return false.
     */
    inline bool hasHwversion () const;

    /**
     * Returns the value of the member "Hwversion".
     *
     * If the meaning of "Hwversion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Hwversion"
     */
    inline uint32 getHwversion () const;

    /**
     * Sets the value of the member "Hwversion".
     *
     * If the meaning of "Hwversion" isn't clear, then there should be a description here.
     *
     * @param Hwversion The value which will be set
     */
    inline void setHwversion (uint32 Hwversion_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 2;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspGetVersionSignal &getDefaultInstance();

private:

    inline void set_has_Swversion ();

    inline void clear_has_Swversion ();

    inline void set_has_Hwversion ();

    inline void clear_has_Hwversion ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _Swversion;

    uint32 _Hwversion;

    ::std::string _RecevedIP;

};

/**
 * xxxx   CMA -- CMC
 */
class Sig_RspGetIntercomAvailableSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_RspGetIntercomAvailableSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_RspGetIntercomAvailableSignal (const Sig_RspGetIntercomAvailableSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_RspGetIntercomAvailableSignal (eTIntercomAvailable Availability_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_RspGetIntercomAvailableSignal();

    /**
     * Assignment operator
     */
    inline Sig_RspGetIntercomAvailableSignal& operator = (const Sig_RspGetIntercomAvailableSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_RspGetIntercomAvailableSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_RspGetIntercomAvailableSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_RspGetIntercomAvailableSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_RspGetIntercomAvailableSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Availability"

    static const int kAvailability = 0;

    /**
     * Clears the field "Availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "Availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "Availability".
     *
     * If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Availability"
     */
    inline eTIntercomAvailable getAvailability () const;

    /**
     * Sets the value of the member "Availability".
     *
     * If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @param Availability The value which will be set
     */
    inline void setAvailability (eTIntercomAvailable Availability_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_RspGetIntercomAvailableSignal &getDefaultInstance();

private:

    inline void set_has_Availability ();

    inline void clear_has_Availability ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    eTIntercomAvailable _Availability;

    ::std::string _RecevedIP;

};

/**
 * xxxx  CMA -- CMC
 */
class Sig_EventIntercomAvailableSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_EventIntercomAvailableSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_EventIntercomAvailableSignal (const Sig_EventIntercomAvailableSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_EventIntercomAvailableSignal (eTIntercomAvailable Availability_, const ::std::string& RecevedIP_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_EventIntercomAvailableSignal();

    /**
     * Assignment operator
     */
    inline Sig_EventIntercomAvailableSignal& operator = (const Sig_EventIntercomAvailableSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_EventIntercomAvailableSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_EventIntercomAvailableSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_EventIntercomAvailableSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_EventIntercomAvailableSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Availability"

    static const int kAvailability = 0;

    /**
     * Clears the field "Availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "Availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "Availability".
     *
     * If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Availability"
     */
    inline eTIntercomAvailable getAvailability () const;

    /**
     * Sets the value of the member "Availability".
     *
     * If the meaning of "Availability" isn't clear, then there should be a description here.
     *
     * @param Availability The value which will be set
     */
    inline void setAvailability (eTIntercomAvailable Availability_);

    // API of field "RecevedIP"

    static const int kRecevedIP = 1;

    /**
     * Clears the field "RecevedIP".
     *
     * The field will be set to its default value. The hasRecevedIP()
     * method will return false.
     */
    inline void clearRecevedIP();

    /**
     * Checks whether the field "RecevedIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecevedIP()). Otherwise it will return false.
     */
    inline bool hasRecevedIP () const;

    /**
     * Returns the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RecevedIP"
     */
    inline const ::std::string& getRecevedIP () const;

    /**
     * Retrieves the value of the field "RecevedIP" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RecevedIP".
     */
    inline ::std::string& getRecevedIPMutable ();

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const ::std::string& RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* RecevedIP_);

    /**
     * Sets the value of the member "RecevedIP".
     *
     * If the meaning of "RecevedIP" isn't clear, then there should be a description here.
     *
     * @param RecevedIP The value which will be set
     */
    inline void setRecevedIP (const char* value, size_t size);

    static const Sig_EventIntercomAvailableSignal &getDefaultInstance();

private:

    inline void set_has_Availability ();

    inline void clear_has_Availability ();

    inline void set_has_RecevedIP ();

    inline void clear_has_RecevedIP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    eTIntercomAvailable _Availability;

    ::std::string _RecevedIP;

};

inline  EventHUCallRequest::EventHUCallRequest ()  :
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventHUCallRequest::EventHUCallRequest (const EventHUCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventHUCallRequest::EventHUCallRequest (eTPhoneNumber phoneNumber_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _phoneNumber (phoneNumber_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "EventHUCallRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventHUCallRequest::~EventHUCallRequest() {
}

inline EventHUCallRequest& EventHUCallRequest::operator = (const EventHUCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool EventHUCallRequest::operator == (const EventHUCallRequest& rhs) const {
    return (((!hasPhoneNumber() && !rhs.hasPhoneNumber()) || getPhoneNumber() == rhs.getPhoneNumber()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool EventHUCallRequest::operator != (const EventHUCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EventHUCallRequest::operator < (const EventHUCallRequest& rhs) const {
    if (hasPhoneNumber() || rhs.hasPhoneNumber()) {
        if ((uint32)getPhoneNumber() < (uint32)rhs.getPhoneNumber()) return true;
        if ((uint32)getPhoneNumber() > (uint32)rhs.getPhoneNumber()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventHUCallRequest::clone() {
    return new EventHUCallRequest(*this);
}

inline bool EventHUCallRequest::operator > (const EventHUCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventHUCallRequest::clear() {
    clearPhoneNumber();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void EventHUCallRequest::clearPhoneNumber() {
    if (hasPhoneNumber()) {
         clear_has_phoneNumber();
        _phoneNumber = ::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom;
     }
}

inline bool EventHUCallRequest::hasPhoneNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTPhoneNumber EventHUCallRequest::getPhoneNumber () const {
    return _phoneNumber;
}

inline void EventHUCallRequest::setPhoneNumber (eTPhoneNumber phoneNumber_) {
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "EventHUCallRequest");
    }
    #endif
    set_has_phoneNumber();
    this->_phoneNumber = phoneNumber_;
}

inline void EventHUCallRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool EventHUCallRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EventHUCallRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void EventHUCallRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void EventHUCallRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool EventHUCallRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 EventHUCallRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void EventHUCallRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void EventHUCallRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool EventHUCallRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 EventHUCallRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void EventHUCallRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void EventHUCallRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool EventHUCallRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& EventHUCallRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& EventHUCallRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void EventHUCallRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void EventHUCallRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void EventHUCallRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void EventHUCallRequest::set_has_phoneNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventHUCallRequest::clear_has_phoneNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventHUCallRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventHUCallRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EventHUCallRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void EventHUCallRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EventHUCallRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void EventHUCallRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void EventHUCallRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void EventHUCallRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  EventHUCallResponse::EventHUCallResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventHUCallResponse::EventHUCallResponse (const EventHUCallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventHUCallResponse::EventHUCallResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventHUCallResponse::~EventHUCallResponse() {
}

inline EventHUCallResponse& EventHUCallResponse::operator = (const EventHUCallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool EventHUCallResponse::operator == (const EventHUCallResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool EventHUCallResponse::operator != (const EventHUCallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EventHUCallResponse::operator < (const EventHUCallResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventHUCallResponse::clone() {
    return new EventHUCallResponse(*this);
}

inline bool EventHUCallResponse::operator > (const EventHUCallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventHUCallResponse::clear() {
    clearResponse();
}

inline void EventHUCallResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool EventHUCallResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EventHUCallResponse::getResponse () const {
    return _response;
}

inline void EventHUCallResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void EventHUCallResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventHUCallResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventAcceptHUCallRequest::EventAcceptHUCallRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventAcceptHUCallRequest::EventAcceptHUCallRequest (const EventAcceptHUCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventAcceptHUCallRequest::EventAcceptHUCallRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventAcceptHUCallRequest::~EventAcceptHUCallRequest() {
}

inline EventAcceptHUCallRequest& EventAcceptHUCallRequest::operator = (const EventAcceptHUCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool EventAcceptHUCallRequest::operator == (const EventAcceptHUCallRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool EventAcceptHUCallRequest::operator != (const EventAcceptHUCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EventAcceptHUCallRequest::operator < (const EventAcceptHUCallRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventAcceptHUCallRequest::clone() {
    return new EventAcceptHUCallRequest(*this);
}

inline bool EventAcceptHUCallRequest::operator > (const EventAcceptHUCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventAcceptHUCallRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void EventAcceptHUCallRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool EventAcceptHUCallRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventAcceptHUCallRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void EventAcceptHUCallRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void EventAcceptHUCallRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool EventAcceptHUCallRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EventAcceptHUCallRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void EventAcceptHUCallRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void EventAcceptHUCallRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool EventAcceptHUCallRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 EventAcceptHUCallRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void EventAcceptHUCallRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void EventAcceptHUCallRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool EventAcceptHUCallRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& EventAcceptHUCallRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& EventAcceptHUCallRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void EventAcceptHUCallRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void EventAcceptHUCallRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void EventAcceptHUCallRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void EventAcceptHUCallRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventAcceptHUCallRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventAcceptHUCallRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventAcceptHUCallRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EventAcceptHUCallRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void EventAcceptHUCallRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EventAcceptHUCallRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void EventAcceptHUCallRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EventAcceptHUCallResponse::EventAcceptHUCallResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventAcceptHUCallResponse::EventAcceptHUCallResponse (const EventAcceptHUCallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventAcceptHUCallResponse::EventAcceptHUCallResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventAcceptHUCallResponse::~EventAcceptHUCallResponse() {
}

inline EventAcceptHUCallResponse& EventAcceptHUCallResponse::operator = (const EventAcceptHUCallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool EventAcceptHUCallResponse::operator == (const EventAcceptHUCallResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool EventAcceptHUCallResponse::operator != (const EventAcceptHUCallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EventAcceptHUCallResponse::operator < (const EventAcceptHUCallResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventAcceptHUCallResponse::clone() {
    return new EventAcceptHUCallResponse(*this);
}

inline bool EventAcceptHUCallResponse::operator > (const EventAcceptHUCallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventAcceptHUCallResponse::clear() {
    clearResponse();
}

inline void EventAcceptHUCallResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool EventAcceptHUCallResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EventAcceptHUCallResponse::getResponse () const {
    return _response;
}

inline void EventAcceptHUCallResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void EventAcceptHUCallResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventAcceptHUCallResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventCancelHUCallRequest::EventCancelHUCallRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventCancelHUCallRequest::EventCancelHUCallRequest (const EventCancelHUCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventCancelHUCallRequest::EventCancelHUCallRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventCancelHUCallRequest::~EventCancelHUCallRequest() {
}

inline EventCancelHUCallRequest& EventCancelHUCallRequest::operator = (const EventCancelHUCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool EventCancelHUCallRequest::operator == (const EventCancelHUCallRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool EventCancelHUCallRequest::operator != (const EventCancelHUCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool EventCancelHUCallRequest::operator < (const EventCancelHUCallRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventCancelHUCallRequest::clone() {
    return new EventCancelHUCallRequest(*this);
}

inline bool EventCancelHUCallRequest::operator > (const EventCancelHUCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventCancelHUCallRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void EventCancelHUCallRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool EventCancelHUCallRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventCancelHUCallRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void EventCancelHUCallRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void EventCancelHUCallRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool EventCancelHUCallRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EventCancelHUCallRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void EventCancelHUCallRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void EventCancelHUCallRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool EventCancelHUCallRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 EventCancelHUCallRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void EventCancelHUCallRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void EventCancelHUCallRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool EventCancelHUCallRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& EventCancelHUCallRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& EventCancelHUCallRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void EventCancelHUCallRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void EventCancelHUCallRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void EventCancelHUCallRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void EventCancelHUCallRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventCancelHUCallRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventCancelHUCallRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventCancelHUCallRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void EventCancelHUCallRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void EventCancelHUCallRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void EventCancelHUCallRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void EventCancelHUCallRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EventCancelHUCallResponse::EventCancelHUCallResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventCancelHUCallResponse::EventCancelHUCallResponse (const EventCancelHUCallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventCancelHUCallResponse::EventCancelHUCallResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventCancelHUCallResponse::~EventCancelHUCallResponse() {
}

inline EventCancelHUCallResponse& EventCancelHUCallResponse::operator = (const EventCancelHUCallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool EventCancelHUCallResponse::operator == (const EventCancelHUCallResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool EventCancelHUCallResponse::operator != (const EventCancelHUCallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool EventCancelHUCallResponse::operator < (const EventCancelHUCallResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventCancelHUCallResponse::clone() {
    return new EventCancelHUCallResponse(*this);
}

inline bool EventCancelHUCallResponse::operator > (const EventCancelHUCallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventCancelHUCallResponse::clear() {
    clearResponse();
}

inline void EventCancelHUCallResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool EventCancelHUCallResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EventCancelHUCallResponse::getResponse () const {
    return _response;
}

inline void EventCancelHUCallResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void EventCancelHUCallResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventCancelHUCallResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqPhoneStatusRequest::ReqPhoneStatusRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqPhoneStatusRequest::ReqPhoneStatusRequest (const ReqPhoneStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqPhoneStatusRequest::ReqPhoneStatusRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqPhoneStatusRequest::~ReqPhoneStatusRequest() {
}

inline ReqPhoneStatusRequest& ReqPhoneStatusRequest::operator = (const ReqPhoneStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqPhoneStatusRequest::operator == (const ReqPhoneStatusRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqPhoneStatusRequest::operator != (const ReqPhoneStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqPhoneStatusRequest::operator < (const ReqPhoneStatusRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqPhoneStatusRequest::clone() {
    return new ReqPhoneStatusRequest(*this);
}

inline bool ReqPhoneStatusRequest::operator > (const ReqPhoneStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqPhoneStatusRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqPhoneStatusRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqPhoneStatusRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqPhoneStatusRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqPhoneStatusRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqPhoneStatusRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqPhoneStatusRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqPhoneStatusRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqPhoneStatusRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqPhoneStatusRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqPhoneStatusRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqPhoneStatusRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqPhoneStatusRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqPhoneStatusRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqPhoneStatusRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqPhoneStatusRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqPhoneStatusRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqPhoneStatusRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqPhoneStatusRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqPhoneStatusRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqPhoneStatusRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqPhoneStatusRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqPhoneStatusRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqPhoneStatusRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqPhoneStatusRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqPhoneStatusRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqPhoneStatusRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqPhoneStatusRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqPhoneStatusResponse::ReqPhoneStatusResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqPhoneStatusResponse::ReqPhoneStatusResponse (const ReqPhoneStatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqPhoneStatusResponse::ReqPhoneStatusResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqPhoneStatusResponse::~ReqPhoneStatusResponse() {
}

inline ReqPhoneStatusResponse& ReqPhoneStatusResponse::operator = (const ReqPhoneStatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqPhoneStatusResponse::operator == (const ReqPhoneStatusResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqPhoneStatusResponse::operator != (const ReqPhoneStatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqPhoneStatusResponse::operator < (const ReqPhoneStatusResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqPhoneStatusResponse::clone() {
    return new ReqPhoneStatusResponse(*this);
}

inline bool ReqPhoneStatusResponse::operator > (const ReqPhoneStatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqPhoneStatusResponse::clear() {
    clearResponse();
}

inline void ReqPhoneStatusResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqPhoneStatusResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqPhoneStatusResponse::getResponse () const {
    return _response;
}

inline void ReqPhoneStatusResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqPhoneStatusResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqPhoneStatusResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqSetVolumeUpRequest::ReqSetVolumeUpRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeUpRequest::ReqSetVolumeUpRequest (const ReqSetVolumeUpRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeUpRequest::ReqSetVolumeUpRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeUpRequest::~ReqSetVolumeUpRequest() {
}

inline ReqSetVolumeUpRequest& ReqSetVolumeUpRequest::operator = (const ReqSetVolumeUpRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetVolumeUpRequest::operator == (const ReqSetVolumeUpRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetVolumeUpRequest::operator != (const ReqSetVolumeUpRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeUpRequest::operator < (const ReqSetVolumeUpRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeUpRequest::clone() {
    return new ReqSetVolumeUpRequest(*this);
}

inline bool ReqSetVolumeUpRequest::operator > (const ReqSetVolumeUpRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeUpRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetVolumeUpRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqSetVolumeUpRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqSetVolumeUpRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetVolumeUpRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetVolumeUpRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetVolumeUpRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqSetVolumeUpRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetVolumeUpRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetVolumeUpRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetVolumeUpRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqSetVolumeUpRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetVolumeUpRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetVolumeUpRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetVolumeUpRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqSetVolumeUpRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetVolumeUpRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetVolumeUpRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetVolumeUpRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetVolumeUpRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetVolumeUpRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeUpRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetVolumeUpRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetVolumeUpRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetVolumeUpRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetVolumeUpRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetVolumeUpRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetVolumeUpRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqSetVolumeUpResponse::ReqSetVolumeUpResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeUpResponse::ReqSetVolumeUpResponse (const ReqSetVolumeUpResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeUpResponse::ReqSetVolumeUpResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeUpResponse::~ReqSetVolumeUpResponse() {
}

inline ReqSetVolumeUpResponse& ReqSetVolumeUpResponse::operator = (const ReqSetVolumeUpResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetVolumeUpResponse::operator == (const ReqSetVolumeUpResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetVolumeUpResponse::operator != (const ReqSetVolumeUpResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeUpResponse::operator < (const ReqSetVolumeUpResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeUpResponse::clone() {
    return new ReqSetVolumeUpResponse(*this);
}

inline bool ReqSetVolumeUpResponse::operator > (const ReqSetVolumeUpResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeUpResponse::clear() {
    clearResponse();
}

inline void ReqSetVolumeUpResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetVolumeUpResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetVolumeUpResponse::getResponse () const {
    return _response;
}

inline void ReqSetVolumeUpResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetVolumeUpResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeUpResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqSetVolumeDownRequest::ReqSetVolumeDownRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeDownRequest::ReqSetVolumeDownRequest (const ReqSetVolumeDownRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeDownRequest::ReqSetVolumeDownRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeDownRequest::~ReqSetVolumeDownRequest() {
}

inline ReqSetVolumeDownRequest& ReqSetVolumeDownRequest::operator = (const ReqSetVolumeDownRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetVolumeDownRequest::operator == (const ReqSetVolumeDownRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetVolumeDownRequest::operator != (const ReqSetVolumeDownRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeDownRequest::operator < (const ReqSetVolumeDownRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeDownRequest::clone() {
    return new ReqSetVolumeDownRequest(*this);
}

inline bool ReqSetVolumeDownRequest::operator > (const ReqSetVolumeDownRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeDownRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetVolumeDownRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqSetVolumeDownRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqSetVolumeDownRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetVolumeDownRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetVolumeDownRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetVolumeDownRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqSetVolumeDownRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetVolumeDownRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetVolumeDownRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetVolumeDownRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqSetVolumeDownRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetVolumeDownRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetVolumeDownRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetVolumeDownRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqSetVolumeDownRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetVolumeDownRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetVolumeDownRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetVolumeDownRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetVolumeDownRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetVolumeDownRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeDownRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetVolumeDownRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetVolumeDownRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetVolumeDownRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetVolumeDownRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetVolumeDownRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetVolumeDownRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqSetVolumeDownResponse::ReqSetVolumeDownResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeDownResponse::ReqSetVolumeDownResponse (const ReqSetVolumeDownResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeDownResponse::ReqSetVolumeDownResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeDownResponse::~ReqSetVolumeDownResponse() {
}

inline ReqSetVolumeDownResponse& ReqSetVolumeDownResponse::operator = (const ReqSetVolumeDownResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetVolumeDownResponse::operator == (const ReqSetVolumeDownResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetVolumeDownResponse::operator != (const ReqSetVolumeDownResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeDownResponse::operator < (const ReqSetVolumeDownResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeDownResponse::clone() {
    return new ReqSetVolumeDownResponse(*this);
}

inline bool ReqSetVolumeDownResponse::operator > (const ReqSetVolumeDownResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeDownResponse::clear() {
    clearResponse();
}

inline void ReqSetVolumeDownResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetVolumeDownResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetVolumeDownResponse::getResponse () const {
    return _response;
}

inline void ReqSetVolumeDownResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetVolumeDownResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeDownResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetVolumeRequest::ReqGetVolumeRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVolumeRequest::ReqGetVolumeRequest (const ReqGetVolumeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVolumeRequest::ReqGetVolumeRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVolumeRequest::~ReqGetVolumeRequest() {
}

inline ReqGetVolumeRequest& ReqGetVolumeRequest::operator = (const ReqGetVolumeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetVolumeRequest::operator == (const ReqGetVolumeRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetVolumeRequest::operator != (const ReqGetVolumeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVolumeRequest::operator < (const ReqGetVolumeRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVolumeRequest::clone() {
    return new ReqGetVolumeRequest(*this);
}

inline bool ReqGetVolumeRequest::operator > (const ReqGetVolumeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVolumeRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetVolumeRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetVolumeRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetVolumeRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetVolumeRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetVolumeRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetVolumeRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetVolumeRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetVolumeRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetVolumeRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetVolumeRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetVolumeRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetVolumeRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetVolumeRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetVolumeRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetVolumeRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetVolumeRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetVolumeRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetVolumeRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetVolumeRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetVolumeRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVolumeRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetVolumeRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetVolumeRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetVolumeRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetVolumeRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetVolumeRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetVolumeRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetVolumeResponse::ReqGetVolumeResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVolumeResponse::ReqGetVolumeResponse (const ReqGetVolumeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVolumeResponse::ReqGetVolumeResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVolumeResponse::~ReqGetVolumeResponse() {
}

inline ReqGetVolumeResponse& ReqGetVolumeResponse::operator = (const ReqGetVolumeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetVolumeResponse::operator == (const ReqGetVolumeResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetVolumeResponse::operator != (const ReqGetVolumeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVolumeResponse::operator < (const ReqGetVolumeResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVolumeResponse::clone() {
    return new ReqGetVolumeResponse(*this);
}

inline bool ReqGetVolumeResponse::operator > (const ReqGetVolumeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVolumeResponse::clear() {
    clearResponse();
}

inline void ReqGetVolumeResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetVolumeResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetVolumeResponse::getResponse () const {
    return _response;
}

inline void ReqGetVolumeResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetVolumeResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVolumeResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqSetVolumeRequest::ReqSetVolumeRequest ()  :
    _Volumevalue (0u),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeRequest::ReqSetVolumeRequest (const ReqSetVolumeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Volumevalue (0u),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeRequest::ReqSetVolumeRequest (uint8 Volumevalue_, uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Volumevalue (Volumevalue_),
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeRequest::~ReqSetVolumeRequest() {
}

inline ReqSetVolumeRequest& ReqSetVolumeRequest::operator = (const ReqSetVolumeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumevalue()) {
            setVolumevalue(rhs.getVolumevalue());
        } else {
            clearVolumevalue();
        }
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqSetVolumeRequest::operator == (const ReqSetVolumeRequest& rhs) const {
    return (((!hasVolumevalue() && !rhs.hasVolumevalue()) || getVolumevalue() == rhs.getVolumevalue()) &&
        ((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqSetVolumeRequest::operator != (const ReqSetVolumeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeRequest::operator < (const ReqSetVolumeRequest& rhs) const {
    if (hasVolumevalue() || rhs.hasVolumevalue()) {
        if (getVolumevalue() < rhs.getVolumevalue()) return true;
        if (getVolumevalue() > rhs.getVolumevalue()) return false;
    }
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeRequest::clone() {
    return new ReqSetVolumeRequest(*this);
}

inline bool ReqSetVolumeRequest::operator > (const ReqSetVolumeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeRequest::clear() {
    clearVolumevalue();
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqSetVolumeRequest::clearVolumevalue() {
    if (hasVolumevalue()) {
         clear_has_Volumevalue();
        _Volumevalue = 0u;
     }
}

inline bool ReqSetVolumeRequest::hasVolumevalue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqSetVolumeRequest::getVolumevalue () const {
    return _Volumevalue;
}

inline void ReqSetVolumeRequest::setVolumevalue (uint8 Volumevalue_) {
    set_has_Volumevalue();
    this->_Volumevalue = Volumevalue_;
}

inline void ReqSetVolumeRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqSetVolumeRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqSetVolumeRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqSetVolumeRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqSetVolumeRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqSetVolumeRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqSetVolumeRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqSetVolumeRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqSetVolumeRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqSetVolumeRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqSetVolumeRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqSetVolumeRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqSetVolumeRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqSetVolumeRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqSetVolumeRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqSetVolumeRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqSetVolumeRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqSetVolumeRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqSetVolumeRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqSetVolumeRequest::set_has_Volumevalue () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeRequest::clear_has_Volumevalue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqSetVolumeRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqSetVolumeRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqSetVolumeRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqSetVolumeRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqSetVolumeRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqSetVolumeRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqSetVolumeRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqSetVolumeRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqSetVolumeResponse::ReqSetVolumeResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqSetVolumeResponse::ReqSetVolumeResponse (const ReqSetVolumeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqSetVolumeResponse::ReqSetVolumeResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqSetVolumeResponse::~ReqSetVolumeResponse() {
}

inline ReqSetVolumeResponse& ReqSetVolumeResponse::operator = (const ReqSetVolumeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqSetVolumeResponse::operator == (const ReqSetVolumeResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqSetVolumeResponse::operator != (const ReqSetVolumeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqSetVolumeResponse::operator < (const ReqSetVolumeResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqSetVolumeResponse::clone() {
    return new ReqSetVolumeResponse(*this);
}

inline bool ReqSetVolumeResponse::operator > (const ReqSetVolumeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqSetVolumeResponse::clear() {
    clearResponse();
}

inline void ReqSetVolumeResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqSetVolumeResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqSetVolumeResponse::getResponse () const {
    return _response;
}

inline void ReqSetVolumeResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqSetVolumeResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqSetVolumeResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetVersionRequest::ReqGetVersionRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVersionRequest::ReqGetVersionRequest (const ReqGetVersionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVersionRequest::ReqGetVersionRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVersionRequest::~ReqGetVersionRequest() {
}

inline ReqGetVersionRequest& ReqGetVersionRequest::operator = (const ReqGetVersionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetVersionRequest::operator == (const ReqGetVersionRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetVersionRequest::operator != (const ReqGetVersionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVersionRequest::operator < (const ReqGetVersionRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVersionRequest::clone() {
    return new ReqGetVersionRequest(*this);
}

inline bool ReqGetVersionRequest::operator > (const ReqGetVersionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVersionRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetVersionRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetVersionRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetVersionRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetVersionRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetVersionRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetVersionRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetVersionRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetVersionRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetVersionRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetVersionRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetVersionRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetVersionRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetVersionRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetVersionRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetVersionRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetVersionRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetVersionRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetVersionRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetVersionRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetVersionRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVersionRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetVersionRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetVersionRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetVersionRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetVersionRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetVersionRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetVersionRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetVersionResponse::ReqGetVersionResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetVersionResponse::ReqGetVersionResponse (const ReqGetVersionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetVersionResponse::ReqGetVersionResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetVersionResponse::~ReqGetVersionResponse() {
}

inline ReqGetVersionResponse& ReqGetVersionResponse::operator = (const ReqGetVersionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetVersionResponse::operator == (const ReqGetVersionResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetVersionResponse::operator != (const ReqGetVersionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetVersionResponse::operator < (const ReqGetVersionResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetVersionResponse::clone() {
    return new ReqGetVersionResponse(*this);
}

inline bool ReqGetVersionResponse::operator > (const ReqGetVersionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetVersionResponse::clear() {
    clearResponse();
}

inline void ReqGetVersionResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetVersionResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetVersionResponse::getResponse () const {
    return _response;
}

inline void ReqGetVersionResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetVersionResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetVersionResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqGetIntercomAvailableRequest::ReqGetIntercomAvailableRequest ()  :
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetIntercomAvailableRequest::ReqGetIntercomAvailableRequest (const ReqGetIntercomAvailableRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (0u),
    _Dev_Nr (0u),
    _Msg_ID (0u),
    _DestIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetIntercomAvailableRequest::ReqGetIntercomAvailableRequest (uint8 Dev_ID_, uint8 Dev_Nr_, uint16 Msg_ID_, const ::std::string& DestIP_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _Msg_ID (Msg_ID_),
    _DestIP (DestIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetIntercomAvailableRequest::~ReqGetIntercomAvailableRequest() {
}

inline ReqGetIntercomAvailableRequest& ReqGetIntercomAvailableRequest::operator = (const ReqGetIntercomAvailableRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasMsg_ID()) {
            setMsg_ID(rhs.getMsg_ID());
        } else {
            clearMsg_ID();
        }
        if (rhs.hasDestIP()) {
            setDestIP(rhs.getDestIP());
        } else {
            clearDestIP();
        }
    }
    return *this;
}

inline bool ReqGetIntercomAvailableRequest::operator == (const ReqGetIntercomAvailableRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasMsg_ID() && !rhs.hasMsg_ID()) || getMsg_ID() == rhs.getMsg_ID()) &&
        ((!hasDestIP() && !rhs.hasDestIP()) || getDestIP() == rhs.getDestIP()));
}

inline bool ReqGetIntercomAvailableRequest::operator != (const ReqGetIntercomAvailableRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetIntercomAvailableRequest::operator < (const ReqGetIntercomAvailableRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if (getDev_ID() < rhs.getDev_ID()) return true;
        if (getDev_ID() > rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasMsg_ID() || rhs.hasMsg_ID()) {
        if (getMsg_ID() < rhs.getMsg_ID()) return true;
        if (getMsg_ID() > rhs.getMsg_ID()) return false;
    }
    if (hasDestIP() || rhs.hasDestIP()) {
        if (getDestIP() < rhs.getDestIP()) return true;
        if (getDestIP() > rhs.getDestIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetIntercomAvailableRequest::clone() {
    return new ReqGetIntercomAvailableRequest(*this);
}

inline bool ReqGetIntercomAvailableRequest::operator > (const ReqGetIntercomAvailableRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetIntercomAvailableRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearMsg_ID();
    clearDestIP();
}

inline void ReqGetIntercomAvailableRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = 0u;
     }
}

inline bool ReqGetIntercomAvailableRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReqGetIntercomAvailableRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void ReqGetIntercomAvailableRequest::setDev_ID (uint8 Dev_ID_) {
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void ReqGetIntercomAvailableRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool ReqGetIntercomAvailableRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqGetIntercomAvailableRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void ReqGetIntercomAvailableRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void ReqGetIntercomAvailableRequest::clearMsg_ID() {
    if (hasMsg_ID()) {
         clear_has_Msg_ID();
        _Msg_ID = 0u;
     }
}

inline bool ReqGetIntercomAvailableRequest::hasMsg_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqGetIntercomAvailableRequest::getMsg_ID () const {
    return _Msg_ID;
}

inline void ReqGetIntercomAvailableRequest::setMsg_ID (uint16 Msg_ID_) {
    set_has_Msg_ID();
    this->_Msg_ID = Msg_ID_;
}

inline void ReqGetIntercomAvailableRequest::clearDestIP() {
    if (hasDestIP()) {
         clear_has_DestIP();
        _DestIP.clear();
     }
}

inline bool ReqGetIntercomAvailableRequest::hasDestIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& ReqGetIntercomAvailableRequest::getDestIP () const {
    return _DestIP;
}

inline ::std::string& ReqGetIntercomAvailableRequest::getDestIPMutable () {
    set_has_DestIP();
    return _DestIP;
}

inline void ReqGetIntercomAvailableRequest::setDestIP (const ::std::string& DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP = DestIP_;
}

inline void ReqGetIntercomAvailableRequest::setDestIP (const char* DestIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DestIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(DestIP_);
}

inline void ReqGetIntercomAvailableRequest::setDestIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DestIP();
    this->_DestIP.assign(value, size);
}

inline void ReqGetIntercomAvailableRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetIntercomAvailableRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqGetIntercomAvailableRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqGetIntercomAvailableRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqGetIntercomAvailableRequest::set_has_Msg_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqGetIntercomAvailableRequest::clear_has_Msg_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqGetIntercomAvailableRequest::set_has_DestIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqGetIntercomAvailableRequest::clear_has_DestIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqGetIntercomAvailableResponse::ReqGetIntercomAvailableResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqGetIntercomAvailableResponse::ReqGetIntercomAvailableResponse (const ReqGetIntercomAvailableResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqGetIntercomAvailableResponse::ReqGetIntercomAvailableResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqGetIntercomAvailableResponse::~ReqGetIntercomAvailableResponse() {
}

inline ReqGetIntercomAvailableResponse& ReqGetIntercomAvailableResponse::operator = (const ReqGetIntercomAvailableResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqGetIntercomAvailableResponse::operator == (const ReqGetIntercomAvailableResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqGetIntercomAvailableResponse::operator != (const ReqGetIntercomAvailableResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqGetIntercomAvailableResponse::operator < (const ReqGetIntercomAvailableResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqGetIntercomAvailableResponse::clone() {
    return new ReqGetIntercomAvailableResponse(*this);
}

inline bool ReqGetIntercomAvailableResponse::operator > (const ReqGetIntercomAvailableResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqGetIntercomAvailableResponse::clear() {
    clearResponse();
}

inline void ReqGetIntercomAvailableResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqGetIntercomAvailableResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqGetIntercomAvailableResponse::getResponse () const {
    return _response;
}

inline void ReqGetIntercomAvailableResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqGetIntercomAvailableResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqGetIntercomAvailableResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_RspPhoneStatusSignal::Sig_RspPhoneStatusSignal ()  :
    _phonestatus1 (0u),
    _phonestatus2 (0u),
    _phonestatus3 (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspPhoneStatusSignal::Sig_RspPhoneStatusSignal (const Sig_RspPhoneStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phonestatus1 (0u),
    _phonestatus2 (0u),
    _phonestatus3 (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspPhoneStatusSignal::Sig_RspPhoneStatusSignal (uint8 phonestatus1_, uint8 phonestatus2_, uint8 phonestatus3_, const ::std::string& RecevedIP_)  :
    _phonestatus1 (phonestatus1_),
    _phonestatus2 (phonestatus2_),
    _phonestatus3 (phonestatus3_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspPhoneStatusSignal::~Sig_RspPhoneStatusSignal() {
}

inline Sig_RspPhoneStatusSignal& Sig_RspPhoneStatusSignal::operator = (const Sig_RspPhoneStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhonestatus1()) {
            setPhonestatus1(rhs.getPhonestatus1());
        } else {
            clearPhonestatus1();
        }
        if (rhs.hasPhonestatus2()) {
            setPhonestatus2(rhs.getPhonestatus2());
        } else {
            clearPhonestatus2();
        }
        if (rhs.hasPhonestatus3()) {
            setPhonestatus3(rhs.getPhonestatus3());
        } else {
            clearPhonestatus3();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspPhoneStatusSignal::operator == (const Sig_RspPhoneStatusSignal& rhs) const {
    return (((!hasPhonestatus1() && !rhs.hasPhonestatus1()) || getPhonestatus1() == rhs.getPhonestatus1()) &&
        ((!hasPhonestatus2() && !rhs.hasPhonestatus2()) || getPhonestatus2() == rhs.getPhonestatus2()) &&
        ((!hasPhonestatus3() && !rhs.hasPhonestatus3()) || getPhonestatus3() == rhs.getPhonestatus3()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspPhoneStatusSignal::operator != (const Sig_RspPhoneStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspPhoneStatusSignal::operator < (const Sig_RspPhoneStatusSignal& rhs) const {
    if (hasPhonestatus1() || rhs.hasPhonestatus1()) {
        if (getPhonestatus1() < rhs.getPhonestatus1()) return true;
        if (getPhonestatus1() > rhs.getPhonestatus1()) return false;
    }
    if (hasPhonestatus2() || rhs.hasPhonestatus2()) {
        if (getPhonestatus2() < rhs.getPhonestatus2()) return true;
        if (getPhonestatus2() > rhs.getPhonestatus2()) return false;
    }
    if (hasPhonestatus3() || rhs.hasPhonestatus3()) {
        if (getPhonestatus3() < rhs.getPhonestatus3()) return true;
        if (getPhonestatus3() > rhs.getPhonestatus3()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspPhoneStatusSignal::clone() {
    return new Sig_RspPhoneStatusSignal(*this);
}

inline bool Sig_RspPhoneStatusSignal::operator > (const Sig_RspPhoneStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspPhoneStatusSignal::clear() {
    clearPhonestatus1();
    clearPhonestatus2();
    clearPhonestatus3();
    clearRecevedIP();
}

inline void Sig_RspPhoneStatusSignal::clearPhonestatus1() {
    if (hasPhonestatus1()) {
         clear_has_phonestatus1();
        _phonestatus1 = 0u;
     }
}

inline bool Sig_RspPhoneStatusSignal::hasPhonestatus1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_RspPhoneStatusSignal::getPhonestatus1 () const {
    return _phonestatus1;
}

inline void Sig_RspPhoneStatusSignal::setPhonestatus1 (uint8 phonestatus1_) {
    set_has_phonestatus1();
    this->_phonestatus1 = phonestatus1_;
}

inline void Sig_RspPhoneStatusSignal::clearPhonestatus2() {
    if (hasPhonestatus2()) {
         clear_has_phonestatus2();
        _phonestatus2 = 0u;
     }
}

inline bool Sig_RspPhoneStatusSignal::hasPhonestatus2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Sig_RspPhoneStatusSignal::getPhonestatus2 () const {
    return _phonestatus2;
}

inline void Sig_RspPhoneStatusSignal::setPhonestatus2 (uint8 phonestatus2_) {
    set_has_phonestatus2();
    this->_phonestatus2 = phonestatus2_;
}

inline void Sig_RspPhoneStatusSignal::clearPhonestatus3() {
    if (hasPhonestatus3()) {
         clear_has_phonestatus3();
        _phonestatus3 = 0u;
     }
}

inline bool Sig_RspPhoneStatusSignal::hasPhonestatus3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_RspPhoneStatusSignal::getPhonestatus3 () const {
    return _phonestatus3;
}

inline void Sig_RspPhoneStatusSignal::setPhonestatus3 (uint8 phonestatus3_) {
    set_has_phonestatus3();
    this->_phonestatus3 = phonestatus3_;
}

inline void Sig_RspPhoneStatusSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspPhoneStatusSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& Sig_RspPhoneStatusSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspPhoneStatusSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspPhoneStatusSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspPhoneStatusSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspPhoneStatusSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspPhoneStatusSignal::set_has_phonestatus1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspPhoneStatusSignal::clear_has_phonestatus1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspPhoneStatusSignal::set_has_phonestatus2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspPhoneStatusSignal::clear_has_phonestatus2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspPhoneStatusSignal::set_has_phonestatus3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspPhoneStatusSignal::clear_has_phonestatus3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_RspPhoneStatusSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_RspPhoneStatusSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Sig_EventPhoneStatusChangedSignal::Sig_EventPhoneStatusChangedSignal ()  :
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _phonestatus (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventPhoneStatusChangedSignal::Sig_EventPhoneStatusChangedSignal (const Sig_EventPhoneStatusChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _phonestatus (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventPhoneStatusChangedSignal::Sig_EventPhoneStatusChangedSignal (eTPhoneNumber phoneNumber_, uint8 phonestatus_, const ::std::string& RecevedIP_)  :
    _phoneNumber (phoneNumber_),
    _phonestatus (phonestatus_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventPhoneStatusChangedSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventPhoneStatusChangedSignal::~Sig_EventPhoneStatusChangedSignal() {
}

inline Sig_EventPhoneStatusChangedSignal& Sig_EventPhoneStatusChangedSignal::operator = (const Sig_EventPhoneStatusChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
        if (rhs.hasPhonestatus()) {
            setPhonestatus(rhs.getPhonestatus());
        } else {
            clearPhonestatus();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventPhoneStatusChangedSignal::operator == (const Sig_EventPhoneStatusChangedSignal& rhs) const {
    return (((!hasPhoneNumber() && !rhs.hasPhoneNumber()) || getPhoneNumber() == rhs.getPhoneNumber()) &&
        ((!hasPhonestatus() && !rhs.hasPhonestatus()) || getPhonestatus() == rhs.getPhonestatus()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventPhoneStatusChangedSignal::operator != (const Sig_EventPhoneStatusChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventPhoneStatusChangedSignal::operator < (const Sig_EventPhoneStatusChangedSignal& rhs) const {
    if (hasPhoneNumber() || rhs.hasPhoneNumber()) {
        if ((uint32)getPhoneNumber() < (uint32)rhs.getPhoneNumber()) return true;
        if ((uint32)getPhoneNumber() > (uint32)rhs.getPhoneNumber()) return false;
    }
    if (hasPhonestatus() || rhs.hasPhonestatus()) {
        if (getPhonestatus() < rhs.getPhonestatus()) return true;
        if (getPhonestatus() > rhs.getPhonestatus()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventPhoneStatusChangedSignal::clone() {
    return new Sig_EventPhoneStatusChangedSignal(*this);
}

inline bool Sig_EventPhoneStatusChangedSignal::operator > (const Sig_EventPhoneStatusChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventPhoneStatusChangedSignal::clear() {
    clearPhoneNumber();
    clearPhonestatus();
    clearRecevedIP();
}

inline void Sig_EventPhoneStatusChangedSignal::clearPhoneNumber() {
    if (hasPhoneNumber()) {
         clear_has_phoneNumber();
        _phoneNumber = ::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom;
     }
}

inline bool Sig_EventPhoneStatusChangedSignal::hasPhoneNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTPhoneNumber Sig_EventPhoneStatusChangedSignal::getPhoneNumber () const {
    return _phoneNumber;
}

inline void Sig_EventPhoneStatusChangedSignal::setPhoneNumber (eTPhoneNumber phoneNumber_) {
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventPhoneStatusChangedSignal");
    }
    #endif
    set_has_phoneNumber();
    this->_phoneNumber = phoneNumber_;
}

inline void Sig_EventPhoneStatusChangedSignal::clearPhonestatus() {
    if (hasPhonestatus()) {
         clear_has_phonestatus();
        _phonestatus = 0u;
     }
}

inline bool Sig_EventPhoneStatusChangedSignal::hasPhonestatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Sig_EventPhoneStatusChangedSignal::getPhonestatus () const {
    return _phonestatus;
}

inline void Sig_EventPhoneStatusChangedSignal::setPhonestatus (uint8 phonestatus_) {
    set_has_phonestatus();
    this->_phonestatus = phonestatus_;
}

inline void Sig_EventPhoneStatusChangedSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventPhoneStatusChangedSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& Sig_EventPhoneStatusChangedSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventPhoneStatusChangedSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventPhoneStatusChangedSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventPhoneStatusChangedSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventPhoneStatusChangedSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventPhoneStatusChangedSignal::set_has_phoneNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventPhoneStatusChangedSignal::clear_has_phoneNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventPhoneStatusChangedSignal::set_has_phonestatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventPhoneStatusChangedSignal::clear_has_phonestatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_EventPhoneStatusChangedSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_EventPhoneStatusChangedSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_EventIntercomCallSignal::Sig_EventIntercomCallSignal ()  :
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventIntercomCallSignal::Sig_EventIntercomCallSignal (const Sig_EventIntercomCallSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventIntercomCallSignal::Sig_EventIntercomCallSignal (eTPhoneNumber phoneNumber_, const ::std::string& RecevedIP_)  :
    _phoneNumber (phoneNumber_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventIntercomCallSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventIntercomCallSignal::~Sig_EventIntercomCallSignal() {
}

inline Sig_EventIntercomCallSignal& Sig_EventIntercomCallSignal::operator = (const Sig_EventIntercomCallSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventIntercomCallSignal::operator == (const Sig_EventIntercomCallSignal& rhs) const {
    return (((!hasPhoneNumber() && !rhs.hasPhoneNumber()) || getPhoneNumber() == rhs.getPhoneNumber()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventIntercomCallSignal::operator != (const Sig_EventIntercomCallSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventIntercomCallSignal::operator < (const Sig_EventIntercomCallSignal& rhs) const {
    if (hasPhoneNumber() || rhs.hasPhoneNumber()) {
        if ((uint32)getPhoneNumber() < (uint32)rhs.getPhoneNumber()) return true;
        if ((uint32)getPhoneNumber() > (uint32)rhs.getPhoneNumber()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventIntercomCallSignal::clone() {
    return new Sig_EventIntercomCallSignal(*this);
}

inline bool Sig_EventIntercomCallSignal::operator > (const Sig_EventIntercomCallSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventIntercomCallSignal::clear() {
    clearPhoneNumber();
    clearRecevedIP();
}

inline void Sig_EventIntercomCallSignal::clearPhoneNumber() {
    if (hasPhoneNumber()) {
         clear_has_phoneNumber();
        _phoneNumber = ::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom;
     }
}

inline bool Sig_EventIntercomCallSignal::hasPhoneNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTPhoneNumber Sig_EventIntercomCallSignal::getPhoneNumber () const {
    return _phoneNumber;
}

inline void Sig_EventIntercomCallSignal::setPhoneNumber (eTPhoneNumber phoneNumber_) {
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventIntercomCallSignal");
    }
    #endif
    set_has_phoneNumber();
    this->_phoneNumber = phoneNumber_;
}

inline void Sig_EventIntercomCallSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventIntercomCallSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventIntercomCallSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventIntercomCallSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventIntercomCallSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventIntercomCallSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventIntercomCallSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventIntercomCallSignal::set_has_phoneNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventIntercomCallSignal::clear_has_phoneNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventIntercomCallSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventIntercomCallSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventCancelIntercomCallSignal::Sig_EventCancelIntercomCallSignal ()  :
    _response (false),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventCancelIntercomCallSignal::Sig_EventCancelIntercomCallSignal (const Sig_EventCancelIntercomCallSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventCancelIntercomCallSignal::Sig_EventCancelIntercomCallSignal (bool response_, const ::std::string& RecevedIP_)  :
    _response (response_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventCancelIntercomCallSignal::~Sig_EventCancelIntercomCallSignal() {
}

inline Sig_EventCancelIntercomCallSignal& Sig_EventCancelIntercomCallSignal::operator = (const Sig_EventCancelIntercomCallSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventCancelIntercomCallSignal::operator == (const Sig_EventCancelIntercomCallSignal& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventCancelIntercomCallSignal::operator != (const Sig_EventCancelIntercomCallSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventCancelIntercomCallSignal::operator < (const Sig_EventCancelIntercomCallSignal& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventCancelIntercomCallSignal::clone() {
    return new Sig_EventCancelIntercomCallSignal(*this);
}

inline bool Sig_EventCancelIntercomCallSignal::operator > (const Sig_EventCancelIntercomCallSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventCancelIntercomCallSignal::clear() {
    clearResponse();
    clearRecevedIP();
}

inline void Sig_EventCancelIntercomCallSignal::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool Sig_EventCancelIntercomCallSignal::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_EventCancelIntercomCallSignal::getResponse () const {
    return _response;
}

inline void Sig_EventCancelIntercomCallSignal::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void Sig_EventCancelIntercomCallSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventCancelIntercomCallSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventCancelIntercomCallSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventCancelIntercomCallSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventCancelIntercomCallSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventCancelIntercomCallSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventCancelIntercomCallSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventCancelIntercomCallSignal::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventCancelIntercomCallSignal::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventCancelIntercomCallSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventCancelIntercomCallSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventAcceptIntercomCallSignal::Sig_EventAcceptIntercomCallSignal ()  :
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventAcceptIntercomCallSignal::Sig_EventAcceptIntercomCallSignal (const Sig_EventAcceptIntercomCallSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNumber (::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventAcceptIntercomCallSignal::Sig_EventAcceptIntercomCallSignal (eTPhoneNumber phoneNumber_, const ::std::string& RecevedIP_)  :
    _phoneNumber (phoneNumber_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventAcceptIntercomCallSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventAcceptIntercomCallSignal::~Sig_EventAcceptIntercomCallSignal() {
}

inline Sig_EventAcceptIntercomCallSignal& Sig_EventAcceptIntercomCallSignal::operator = (const Sig_EventAcceptIntercomCallSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventAcceptIntercomCallSignal::operator == (const Sig_EventAcceptIntercomCallSignal& rhs) const {
    return (((!hasPhoneNumber() && !rhs.hasPhoneNumber()) || getPhoneNumber() == rhs.getPhoneNumber()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventAcceptIntercomCallSignal::operator != (const Sig_EventAcceptIntercomCallSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventAcceptIntercomCallSignal::operator < (const Sig_EventAcceptIntercomCallSignal& rhs) const {
    if (hasPhoneNumber() || rhs.hasPhoneNumber()) {
        if ((uint32)getPhoneNumber() < (uint32)rhs.getPhoneNumber()) return true;
        if ((uint32)getPhoneNumber() > (uint32)rhs.getPhoneNumber()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventAcceptIntercomCallSignal::clone() {
    return new Sig_EventAcceptIntercomCallSignal(*this);
}

inline bool Sig_EventAcceptIntercomCallSignal::operator > (const Sig_EventAcceptIntercomCallSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventAcceptIntercomCallSignal::clear() {
    clearPhoneNumber();
    clearRecevedIP();
}

inline void Sig_EventAcceptIntercomCallSignal::clearPhoneNumber() {
    if (hasPhoneNumber()) {
         clear_has_phoneNumber();
        _phoneNumber = ::bosch::cm::di::NanoMsgIntercomInterface::eTPhoneNumber__eTPhoneNumber_RestRoom;
     }
}

inline bool Sig_EventAcceptIntercomCallSignal::hasPhoneNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTPhoneNumber Sig_EventAcceptIntercomCallSignal::getPhoneNumber () const {
    return _phoneNumber;
}

inline void Sig_EventAcceptIntercomCallSignal::setPhoneNumber (eTPhoneNumber phoneNumber_) {
    #ifndef NDEBUG
    if (!(eTPhoneNumber_IsValid(phoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", phoneNumber_, "eTPhoneNumber", "phoneNumber", "Sig_EventAcceptIntercomCallSignal");
    }
    #endif
    set_has_phoneNumber();
    this->_phoneNumber = phoneNumber_;
}

inline void Sig_EventAcceptIntercomCallSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventAcceptIntercomCallSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventAcceptIntercomCallSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventAcceptIntercomCallSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventAcceptIntercomCallSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventAcceptIntercomCallSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventAcceptIntercomCallSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventAcceptIntercomCallSignal::set_has_phoneNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventAcceptIntercomCallSignal::clear_has_phoneNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventAcceptIntercomCallSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventAcceptIntercomCallSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_RspGetVolumeSignal::Sig_RspGetVolumeSignal ()  :
    _Volumevalue (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetVolumeSignal::Sig_RspGetVolumeSignal (const Sig_RspGetVolumeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Volumevalue (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetVolumeSignal::Sig_RspGetVolumeSignal (uint8 Volumevalue_, const ::std::string& RecevedIP_)  :
    _Volumevalue (Volumevalue_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetVolumeSignal::~Sig_RspGetVolumeSignal() {
}

inline Sig_RspGetVolumeSignal& Sig_RspGetVolumeSignal::operator = (const Sig_RspGetVolumeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumevalue()) {
            setVolumevalue(rhs.getVolumevalue());
        } else {
            clearVolumevalue();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetVolumeSignal::operator == (const Sig_RspGetVolumeSignal& rhs) const {
    return (((!hasVolumevalue() && !rhs.hasVolumevalue()) || getVolumevalue() == rhs.getVolumevalue()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspGetVolumeSignal::operator != (const Sig_RspGetVolumeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetVolumeSignal::operator < (const Sig_RspGetVolumeSignal& rhs) const {
    if (hasVolumevalue() || rhs.hasVolumevalue()) {
        if (getVolumevalue() < rhs.getVolumevalue()) return true;
        if (getVolumevalue() > rhs.getVolumevalue()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetVolumeSignal::clone() {
    return new Sig_RspGetVolumeSignal(*this);
}

inline bool Sig_RspGetVolumeSignal::operator > (const Sig_RspGetVolumeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetVolumeSignal::clear() {
    clearVolumevalue();
    clearRecevedIP();
}

inline void Sig_RspGetVolumeSignal::clearVolumevalue() {
    if (hasVolumevalue()) {
         clear_has_Volumevalue();
        _Volumevalue = 0u;
     }
}

inline bool Sig_RspGetVolumeSignal::hasVolumevalue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_RspGetVolumeSignal::getVolumevalue () const {
    return _Volumevalue;
}

inline void Sig_RspGetVolumeSignal::setVolumevalue (uint8 Volumevalue_) {
    set_has_Volumevalue();
    this->_Volumevalue = Volumevalue_;
}

inline void Sig_RspGetVolumeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspGetVolumeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspGetVolumeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspGetVolumeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspGetVolumeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspGetVolumeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspGetVolumeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspGetVolumeSignal::set_has_Volumevalue () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetVolumeSignal::clear_has_Volumevalue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetVolumeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetVolumeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventSetVolumeSignal::Sig_EventSetVolumeSignal ()  :
    _Volumevalue (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventSetVolumeSignal::Sig_EventSetVolumeSignal (const Sig_EventSetVolumeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Volumevalue (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventSetVolumeSignal::Sig_EventSetVolumeSignal (uint8 Volumevalue_, const ::std::string& RecevedIP_)  :
    _Volumevalue (Volumevalue_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventSetVolumeSignal::~Sig_EventSetVolumeSignal() {
}

inline Sig_EventSetVolumeSignal& Sig_EventSetVolumeSignal::operator = (const Sig_EventSetVolumeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumevalue()) {
            setVolumevalue(rhs.getVolumevalue());
        } else {
            clearVolumevalue();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventSetVolumeSignal::operator == (const Sig_EventSetVolumeSignal& rhs) const {
    return (((!hasVolumevalue() && !rhs.hasVolumevalue()) || getVolumevalue() == rhs.getVolumevalue()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventSetVolumeSignal::operator != (const Sig_EventSetVolumeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventSetVolumeSignal::operator < (const Sig_EventSetVolumeSignal& rhs) const {
    if (hasVolumevalue() || rhs.hasVolumevalue()) {
        if (getVolumevalue() < rhs.getVolumevalue()) return true;
        if (getVolumevalue() > rhs.getVolumevalue()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventSetVolumeSignal::clone() {
    return new Sig_EventSetVolumeSignal(*this);
}

inline bool Sig_EventSetVolumeSignal::operator > (const Sig_EventSetVolumeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventSetVolumeSignal::clear() {
    clearVolumevalue();
    clearRecevedIP();
}

inline void Sig_EventSetVolumeSignal::clearVolumevalue() {
    if (hasVolumevalue()) {
         clear_has_Volumevalue();
        _Volumevalue = 0u;
     }
}

inline bool Sig_EventSetVolumeSignal::hasVolumevalue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_EventSetVolumeSignal::getVolumevalue () const {
    return _Volumevalue;
}

inline void Sig_EventSetVolumeSignal::setVolumevalue (uint8 Volumevalue_) {
    set_has_Volumevalue();
    this->_Volumevalue = Volumevalue_;
}

inline void Sig_EventSetVolumeSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventSetVolumeSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventSetVolumeSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventSetVolumeSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventSetVolumeSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventSetVolumeSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventSetVolumeSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventSetVolumeSignal::set_has_Volumevalue () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventSetVolumeSignal::clear_has_Volumevalue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventSetVolumeSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventSetVolumeSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_RspGetVersionSignal::Sig_RspGetVersionSignal ()  :
    _Swversion (0u),
    _Hwversion (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetVersionSignal::Sig_RspGetVersionSignal (const Sig_RspGetVersionSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Swversion (0u),
    _Hwversion (0u),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetVersionSignal::Sig_RspGetVersionSignal (uint32 Swversion_, uint32 Hwversion_, const ::std::string& RecevedIP_)  :
    _Swversion (Swversion_),
    _Hwversion (Hwversion_),
    _RecevedIP (RecevedIP_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetVersionSignal::~Sig_RspGetVersionSignal() {
}

inline Sig_RspGetVersionSignal& Sig_RspGetVersionSignal::operator = (const Sig_RspGetVersionSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSwversion()) {
            setSwversion(rhs.getSwversion());
        } else {
            clearSwversion();
        }
        if (rhs.hasHwversion()) {
            setHwversion(rhs.getHwversion());
        } else {
            clearHwversion();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetVersionSignal::operator == (const Sig_RspGetVersionSignal& rhs) const {
    return (((!hasSwversion() && !rhs.hasSwversion()) || getSwversion() == rhs.getSwversion()) &&
        ((!hasHwversion() && !rhs.hasHwversion()) || getHwversion() == rhs.getHwversion()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspGetVersionSignal::operator != (const Sig_RspGetVersionSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetVersionSignal::operator < (const Sig_RspGetVersionSignal& rhs) const {
    if (hasSwversion() || rhs.hasSwversion()) {
        if (getSwversion() < rhs.getSwversion()) return true;
        if (getSwversion() > rhs.getSwversion()) return false;
    }
    if (hasHwversion() || rhs.hasHwversion()) {
        if (getHwversion() < rhs.getHwversion()) return true;
        if (getHwversion() > rhs.getHwversion()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetVersionSignal::clone() {
    return new Sig_RspGetVersionSignal(*this);
}

inline bool Sig_RspGetVersionSignal::operator > (const Sig_RspGetVersionSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetVersionSignal::clear() {
    clearSwversion();
    clearHwversion();
    clearRecevedIP();
}

inline void Sig_RspGetVersionSignal::clearSwversion() {
    if (hasSwversion()) {
         clear_has_Swversion();
        _Swversion = 0u;
     }
}

inline bool Sig_RspGetVersionSignal::hasSwversion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Sig_RspGetVersionSignal::getSwversion () const {
    return _Swversion;
}

inline void Sig_RspGetVersionSignal::setSwversion (uint32 Swversion_) {
    set_has_Swversion();
    this->_Swversion = Swversion_;
}

inline void Sig_RspGetVersionSignal::clearHwversion() {
    if (hasHwversion()) {
         clear_has_Hwversion();
        _Hwversion = 0u;
     }
}

inline bool Sig_RspGetVersionSignal::hasHwversion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 Sig_RspGetVersionSignal::getHwversion () const {
    return _Hwversion;
}

inline void Sig_RspGetVersionSignal::setHwversion (uint32 Hwversion_) {
    set_has_Hwversion();
    this->_Hwversion = Hwversion_;
}

inline void Sig_RspGetVersionSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspGetVersionSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& Sig_RspGetVersionSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspGetVersionSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspGetVersionSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspGetVersionSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspGetVersionSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspGetVersionSignal::set_has_Swversion () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetVersionSignal::clear_has_Swversion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetVersionSignal::set_has_Hwversion () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetVersionSignal::clear_has_Hwversion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_RspGetVersionSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_RspGetVersionSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_RspGetIntercomAvailableSignal::Sig_RspGetIntercomAvailableSignal ()  :
    _Availability (::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_RspGetIntercomAvailableSignal::Sig_RspGetIntercomAvailableSignal (const Sig_RspGetIntercomAvailableSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Availability (::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_RspGetIntercomAvailableSignal::Sig_RspGetIntercomAvailableSignal (eTIntercomAvailable Availability_, const ::std::string& RecevedIP_)  :
    _Availability (Availability_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eTIntercomAvailable_IsValid(Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Availability_, "eTIntercomAvailable", "Availability", "Sig_RspGetIntercomAvailableSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_RspGetIntercomAvailableSignal::~Sig_RspGetIntercomAvailableSignal() {
}

inline Sig_RspGetIntercomAvailableSignal& Sig_RspGetIntercomAvailableSignal::operator = (const Sig_RspGetIntercomAvailableSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_RspGetIntercomAvailableSignal::operator == (const Sig_RspGetIntercomAvailableSignal& rhs) const {
    return (((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_RspGetIntercomAvailableSignal::operator != (const Sig_RspGetIntercomAvailableSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_RspGetIntercomAvailableSignal::operator < (const Sig_RspGetIntercomAvailableSignal& rhs) const {
    if (hasAvailability() || rhs.hasAvailability()) {
        if ((uint32)getAvailability() < (uint32)rhs.getAvailability()) return true;
        if ((uint32)getAvailability() > (uint32)rhs.getAvailability()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_RspGetIntercomAvailableSignal::clone() {
    return new Sig_RspGetIntercomAvailableSignal(*this);
}

inline bool Sig_RspGetIntercomAvailableSignal::operator > (const Sig_RspGetIntercomAvailableSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_RspGetIntercomAvailableSignal::clear() {
    clearAvailability();
    clearRecevedIP();
}

inline void Sig_RspGetIntercomAvailableSignal::clearAvailability() {
    if (hasAvailability()) {
         clear_has_Availability();
        _Availability = ::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable;
     }
}

inline bool Sig_RspGetIntercomAvailableSignal::hasAvailability () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTIntercomAvailable Sig_RspGetIntercomAvailableSignal::getAvailability () const {
    return _Availability;
}

inline void Sig_RspGetIntercomAvailableSignal::setAvailability (eTIntercomAvailable Availability_) {
    #ifndef NDEBUG
    if (!(eTIntercomAvailable_IsValid(Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Availability_, "eTIntercomAvailable", "Availability", "Sig_RspGetIntercomAvailableSignal");
    }
    #endif
    set_has_Availability();
    this->_Availability = Availability_;
}

inline void Sig_RspGetIntercomAvailableSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_RspGetIntercomAvailableSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_RspGetIntercomAvailableSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_RspGetIntercomAvailableSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_RspGetIntercomAvailableSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_RspGetIntercomAvailableSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_RspGetIntercomAvailableSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_RspGetIntercomAvailableSignal::set_has_Availability () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_RspGetIntercomAvailableSignal::clear_has_Availability () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_RspGetIntercomAvailableSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_RspGetIntercomAvailableSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_EventIntercomAvailableSignal::Sig_EventIntercomAvailableSignal ()  :
    _Availability (::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_EventIntercomAvailableSignal::Sig_EventIntercomAvailableSignal (const Sig_EventIntercomAvailableSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Availability (::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable),
    _RecevedIP ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_EventIntercomAvailableSignal::Sig_EventIntercomAvailableSignal (eTIntercomAvailable Availability_, const ::std::string& RecevedIP_)  :
    _Availability (Availability_),
    _RecevedIP (RecevedIP_)
{
    #ifndef NDEBUG
    if (!(eTIntercomAvailable_IsValid(Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Availability_, "eTIntercomAvailable", "Availability", "Sig_EventIntercomAvailableSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_EventIntercomAvailableSignal::~Sig_EventIntercomAvailableSignal() {
}

inline Sig_EventIntercomAvailableSignal& Sig_EventIntercomAvailableSignal::operator = (const Sig_EventIntercomAvailableSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
        if (rhs.hasRecevedIP()) {
            setRecevedIP(rhs.getRecevedIP());
        } else {
            clearRecevedIP();
        }
    }
    return *this;
}

inline bool Sig_EventIntercomAvailableSignal::operator == (const Sig_EventIntercomAvailableSignal& rhs) const {
    return (((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()) &&
        ((!hasRecevedIP() && !rhs.hasRecevedIP()) || getRecevedIP() == rhs.getRecevedIP()));
}

inline bool Sig_EventIntercomAvailableSignal::operator != (const Sig_EventIntercomAvailableSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_EventIntercomAvailableSignal::operator < (const Sig_EventIntercomAvailableSignal& rhs) const {
    if (hasAvailability() || rhs.hasAvailability()) {
        if ((uint32)getAvailability() < (uint32)rhs.getAvailability()) return true;
        if ((uint32)getAvailability() > (uint32)rhs.getAvailability()) return false;
    }
    if (hasRecevedIP() || rhs.hasRecevedIP()) {
        if (getRecevedIP() < rhs.getRecevedIP()) return true;
        if (getRecevedIP() > rhs.getRecevedIP()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_EventIntercomAvailableSignal::clone() {
    return new Sig_EventIntercomAvailableSignal(*this);
}

inline bool Sig_EventIntercomAvailableSignal::operator > (const Sig_EventIntercomAvailableSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_EventIntercomAvailableSignal::clear() {
    clearAvailability();
    clearRecevedIP();
}

inline void Sig_EventIntercomAvailableSignal::clearAvailability() {
    if (hasAvailability()) {
         clear_has_Availability();
        _Availability = ::bosch::cm::di::NanoMsgIntercomInterface::eTIntercomAvailable__eTIntercomAvailable_Unavailable;
     }
}

inline bool Sig_EventIntercomAvailableSignal::hasAvailability () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline eTIntercomAvailable Sig_EventIntercomAvailableSignal::getAvailability () const {
    return _Availability;
}

inline void Sig_EventIntercomAvailableSignal::setAvailability (eTIntercomAvailable Availability_) {
    #ifndef NDEBUG
    if (!(eTIntercomAvailable_IsValid(Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Availability_, "eTIntercomAvailable", "Availability", "Sig_EventIntercomAvailableSignal");
    }
    #endif
    set_has_Availability();
    this->_Availability = Availability_;
}

inline void Sig_EventIntercomAvailableSignal::clearRecevedIP() {
    if (hasRecevedIP()) {
         clear_has_RecevedIP();
        _RecevedIP.clear();
     }
}

inline bool Sig_EventIntercomAvailableSignal::hasRecevedIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& Sig_EventIntercomAvailableSignal::getRecevedIP () const {
    return _RecevedIP;
}

inline ::std::string& Sig_EventIntercomAvailableSignal::getRecevedIPMutable () {
    set_has_RecevedIP();
    return _RecevedIP;
}

inline void Sig_EventIntercomAvailableSignal::setRecevedIP (const ::std::string& RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP = RecevedIP_;
}

inline void Sig_EventIntercomAvailableSignal::setRecevedIP (const char* RecevedIP_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RecevedIP_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(RecevedIP_);
}

inline void Sig_EventIntercomAvailableSignal::setRecevedIP (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RecevedIP();
    this->_RecevedIP.assign(value, size);
}

inline void Sig_EventIntercomAvailableSignal::set_has_Availability () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_EventIntercomAvailableSignal::clear_has_Availability () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_EventIntercomAvailableSignal::set_has_RecevedIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_EventIntercomAvailableSignal::clear_has_RecevedIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace NanoMsgIntercomInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGINTERCOMINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
