/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_NANOMSGGENERICINTERFACEPROXY_H
#define BOSCH_CM_DI_NANOMSGGENERICINTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgGenericInterface.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgGenericInterface {

class NanoMsgGenericInterfaceProxy;

class EventThermalStateCallbackIF {
public:
    virtual ~EventThermalStateCallbackIF() {}

    virtual void onEventThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateError >& error) = 0;

    virtual void onEventThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateSignal >& signal) = 0;
};

class EventVoltageCallbackIF {
public:
    virtual ~EventVoltageCallbackIF() {}

    virtual void onEventVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageError >& error) = 0;

    virtual void onEventVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageSignal >& signal) = 0;
};

class ReqCMGSvivelPositionCallbackIF {
public:
    virtual ~ReqCMGSvivelPositionCallbackIF() {}

    virtual void onReqCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionError >& error) = 0;

    virtual void onReqCMGSvivelPositionResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionResponse >& response) = 0;
};

class ReqGetDigitalInputCMGCallbackIF {
public:
    virtual ~ReqGetDigitalInputCMGCallbackIF() {}

    virtual void onReqGetDigitalInputCMGError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMGError >& error) = 0;

    virtual void onReqGetDigitalInputCMGResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMGResponse >& response) = 0;
};

class ReqGetDigitalInputCMPCallbackIF {
public:
    virtual ~ReqGetDigitalInputCMPCallbackIF() {}

    virtual void onReqGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPError >& error) = 0;

    virtual void onReqGetDigitalInputCMPResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputCMPResponse >& response) = 0;
};

class ReqGetDigitalInputCallbackIF {
public:
    virtual ~ReqGetDigitalInputCallbackIF() {}

    virtual void onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error) = 0;

    virtual void onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response) = 0;
};

class ReqGetThermalStateCallbackIF {
public:
    virtual ~ReqGetThermalStateCallbackIF() {}

    virtual void onReqGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateError >& error) = 0;

    virtual void onReqGetThermalStateResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateResponse >& response) = 0;
};

class ReqGetVoltageCallbackIF {
public:
    virtual ~ReqGetVoltageCallbackIF() {}

    virtual void onReqGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageError >& error) = 0;

    virtual void onReqGetVoltageResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageResponse >& response) = 0;
};

class ReqSetAnnouncementOutCallbackIF {
public:
    virtual ~ReqSetAnnouncementOutCallbackIF() {}

    virtual void onReqSetAnnouncementOutError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetAnnouncementOutError >& error) = 0;

    virtual void onReqSetAnnouncementOutResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetAnnouncementOutResponse >& response) = 0;
};

class RspGetThermalStateCallbackIF {
public:
    virtual ~RspGetThermalStateCallbackIF() {}

    virtual void onRspGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateError >& error) = 0;

    virtual void onRspGetThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateSignal >& signal) = 0;
};

class RspGetVoltageCallbackIF {
public:
    virtual ~RspGetVoltageCallbackIF() {}

    virtual void onRspGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageError >& error) = 0;

    virtual void onRspGetVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageSignal >& signal) = 0;
};

class RspSetAnnouncementOutCallbackIF {
public:
    virtual ~RspSetAnnouncementOutCallbackIF() {}

    virtual void onRspSetAnnouncementOutError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspSetAnnouncementOutError >& error) = 0;

    virtual void onRspSetAnnouncementOutSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspSetAnnouncementOutSignal >& signal) = 0;
};

class Sig_EventCMGSwivelPositionCallbackIF {
public:
    virtual ~Sig_EventCMGSwivelPositionCallbackIF() {}

    virtual void onSig_EventCMGSwivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventCMGSwivelPositionError >& error) = 0;

    virtual void onSig_EventCMGSwivelPositionSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventCMGSwivelPositionSignal >& signal) = 0;
};

class Sig_EventDigitalInputCMGCallbackIF {
public:
    virtual ~Sig_EventDigitalInputCMGCallbackIF() {}

    virtual void onSig_EventDigitalInputCMGError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMGError >& error) = 0;

    virtual void onSig_EventDigitalInputCMGSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMGSignal >& signal) = 0;
};

class Sig_EventDigitalInputCMPCallbackIF {
public:
    virtual ~Sig_EventDigitalInputCMPCallbackIF() {}

    virtual void onSig_EventDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPError >& error) = 0;

    virtual void onSig_EventDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputCMPSignal >& signal) = 0;
};

class Sig_EventDigitalInputCallbackIF {
public:
    virtual ~Sig_EventDigitalInputCallbackIF() {}

    virtual void onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error) = 0;

    virtual void onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal) = 0;
};

class Sig_RspCMGSvivelPositionCallbackIF {
public:
    virtual ~Sig_RspCMGSvivelPositionCallbackIF() {}

    virtual void onSig_RspCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionError >& error) = 0;

    virtual void onSig_RspCMGSvivelPositionSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionSignal >& signal) = 0;
};

class Sig_RspGetDigitalInputCMGCallbackIF {
public:
    virtual ~Sig_RspGetDigitalInputCMGCallbackIF() {}

    virtual void onSig_RspGetDigitalInputCMGError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMGError >& error) = 0;

    virtual void onSig_RspGetDigitalInputCMGSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMGSignal >& signal) = 0;
};

class Sig_RspGetDigitalInputCMPCallbackIF {
public:
    virtual ~Sig_RspGetDigitalInputCMPCallbackIF() {}

    virtual void onSig_RspGetDigitalInputCMPError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPError >& error) = 0;

    virtual void onSig_RspGetDigitalInputCMPSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputCMPSignal >& signal) = 0;
};

class Sig_RspGetDigitalInputCallbackIF {
public:
    virtual ~Sig_RspGetDigitalInputCallbackIF() {}

    virtual void onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error) = 0;

    virtual void onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal) = 0;
};


/**
 * NanoMsgGenericInterfaceProxy is the client side representation of the
 * D-Bus service interface 'bosch.cm.di.NanoMsgGenericInterface'
 * (specified in file GenericNanoMessageInterface_.xml).
 *
 * If the meaning of "bosch.cm.di.NanoMsgGenericInterface" isn't clear, then there should be a description here.
 */
class NanoMsgGenericInterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of NanoMsgGenericInterfaceProxy.
     */
    static ::boost::shared_ptr< NanoMsgGenericInterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of NanoMsgGenericInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< NanoMsgGenericInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of NanoMsgGenericInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< NanoMsgGenericInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< NanoMsgGenericInterfaceProxy > proxyNew(new NanoMsgGenericInterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~NanoMsgGenericInterfaceProxy ();


    // Signal 'sig_RspCMGSvivelPosition'

    /**
     * Notify on the signal 'sig_RspCMGSvivelPosition'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspCMGSvivelPosition'</b>:
     *
     * RspCMGSvivelPosition =0x0065, Response to ReqCMGSvivelPosition
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspCMGSvivelPositionRegister(Sig_RspCMGSvivelPositionCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspCMGSvivelPosition'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspCMGSvivelPosition'</b>:
     *
     * RspCMGSvivelPosition =0x0065, Response to ReqCMGSvivelPosition
     *
     * @param act The act which was previously returned by the
     * sendSig_RspCMGSvivelPositionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspCMGSvivelPositionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspCMGSvivelPosition'.
     */
    void sendSig_RspCMGSvivelPositionDeregisterAll () const;

    // Signal 'sig_RspGetDigitalInput'

    /**
     * Notify on the signal 'sig_RspGetDigitalInput'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInput'</b>:
     *
     * RspGetDigitalInput = 0x0017 response to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspGetDigitalInputRegister(Sig_RspGetDigitalInputCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspGetDigitalInput'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInput'</b>:
     *
     * RspGetDigitalInput = 0x0017 response to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_RspGetDigitalInputRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspGetDigitalInputDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_RspGetDigitalInput'.
     */
    void sendSig_RspGetDigitalInputDeregisterAll () const;

    // Signal 'sig_EventDigitalInput'

    /**
     * Notify on the signal 'sig_EventDigitalInput'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInput'</b>:
     *
     * EventDigitalInput = 0x0015 Event to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventDigitalInputRegister(Sig_EventDigitalInputCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventDigitalInput'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInput'</b>:
     *
     * EventDigitalInput = 0x0015 Event to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_EventDigitalInputRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventDigitalInputDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_EventDigitalInput'.
     */
    void sendSig_EventDigitalInputDeregisterAll () const;

    // Signal 'sig_RspGetDigitalInputCMP'

    /**
     * Notify on the signal 'sig_RspGetDigitalInputCMP'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMP'</b>:
     *
     * RspGetDigitalInputCMP = 0x0020 response to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspGetDigitalInputCMPRegister(Sig_RspGetDigitalInputCMPCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspGetDigitalInputCMP'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMP'</b>:
     *
     * RspGetDigitalInputCMP = 0x0020 response to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_RspGetDigitalInputCMPRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspGetDigitalInputCMPDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'sig_RspGetDigitalInputCMP'.
     */
    void sendSig_RspGetDigitalInputCMPDeregisterAll () const;

    // Signal 'sig_EventDigitalInputCMP'

    /**
     * Notify on the signal 'sig_EventDigitalInputCMP'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMP'</b>:
     *
     * EventDigitalInputCMP = 0x0018 Event to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventDigitalInputCMPRegister(Sig_EventDigitalInputCMPCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventDigitalInputCMP'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMP'</b>:
     *
     * EventDigitalInputCMP = 0x0018 Event to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_EventDigitalInputCMPRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventDigitalInputCMPDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_EventDigitalInputCMP'.
     */
    void sendSig_EventDigitalInputCMPDeregisterAll () const;

    // Signal 'sig_RspGetDigitalInputCMG'

    /**
     * Notify on the signal 'sig_RspGetDigitalInputCMG'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMG'</b>:
     *
     * RspGetDigitalInputCMG = 0x0023 response to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_RspGetDigitalInputCMGRegister(Sig_RspGetDigitalInputCMGCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_RspGetDigitalInputCMG'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_RspGetDigitalInputCMG'</b>:
     *
     * RspGetDigitalInputCMG = 0x0023 response to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_RspGetDigitalInputCMGRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_RspGetDigitalInputCMGDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'sig_RspGetDigitalInputCMG'.
     */
    void sendSig_RspGetDigitalInputCMGDeregisterAll () const;

    // Signal 'sig_EventDigitalInputCMG'

    /**
     * Notify on the signal 'sig_EventDigitalInputCMG'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMG'</b>:
     *
     * EventDigitalInputCMG = 0x0021 Event to  Request Digital IO's
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventDigitalInputCMGRegister(Sig_EventDigitalInputCMGCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventDigitalInputCMG'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventDigitalInputCMG'</b>:
     *
     * EventDigitalInputCMG = 0x0021 Event to  Request Digital IO's
     *
     * @param act The act which was previously returned by the
     * sendSig_EventDigitalInputCMGRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventDigitalInputCMGDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_EventDigitalInputCMG'.
     */
    void sendSig_EventDigitalInputCMGDeregisterAll () const;

    // Signal 'RspGetVoltage'

    /**
     * Notify on the signal 'RspGetVoltage'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'RspGetVoltage'</b>:
     *
     * RspGetVoltage = 0x0014
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRspGetVoltageRegister(RspGetVoltageCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'RspGetVoltage'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'RspGetVoltage'</b>:
     *
     * RspGetVoltage = 0x0014
     *
     * @param act The act which was previously returned by the
     * sendRspGetVoltageRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRspGetVoltageDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'RspGetVoltage'.
     */
    void sendRspGetVoltageDeregisterAll () const;

    // Signal 'EventVoltage'

    /**
     * Notify on the signal 'EventVoltage'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'EventVoltage'</b>:
     *
     * EventVoltage = 0x0012
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventVoltageRegister(EventVoltageCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventVoltage'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventVoltage'</b>:
     *
     * EventVoltage = 0x0012
     *
     * @param act The act which was previously returned by the
     * sendEventVoltageRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventVoltageDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventVoltage'.
     */
    void sendEventVoltageDeregisterAll () const;

    // Signal 'RspGetThermalState'

    /**
     * Notify on the signal 'RspGetThermalState'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'RspGetThermalState'</b>:
     *
     * RspGetThermalState = 0x0045
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRspGetThermalStateRegister(RspGetThermalStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'RspGetThermalState'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'RspGetThermalState'</b>:
     *
     * RspGetThermalState = 0x0045
     *
     * @param act The act which was previously returned by the
     * sendRspGetThermalStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRspGetThermalStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'RspGetThermalState'.
     */
    void sendRspGetThermalStateDeregisterAll () const;

    // Signal 'EventThermalState'

    /**
     * Notify on the signal 'EventThermalState'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventThermalState'</b>:
     *
     * EventThermalState = 0x0043
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventThermalStateRegister(EventThermalStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventThermalState'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventThermalState'</b>:
     *
     * EventThermalState = 0x0043
     *
     * @param act The act which was previously returned by the
     * sendEventThermalStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventThermalStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventThermalState'.
     */
    void sendEventThermalStateDeregisterAll () const;

    // Signal 'RspSetAnnouncementOut'

    /**
     * Notify on the signal 'RspSetAnnouncementOut'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'RspSetAnnouncementOut'</b>:
     *
     * RspSetAnnouncementOut = 0x0021
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRspSetAnnouncementOutRegister(RspSetAnnouncementOutCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'RspSetAnnouncementOut'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'RspSetAnnouncementOut'</b>:
     *
     * RspSetAnnouncementOut = 0x0021
     *
     * @param act The act which was previously returned by the
     * sendRspSetAnnouncementOutRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRspSetAnnouncementOutDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'RspSetAnnouncementOut'.
     */
    void sendRspSetAnnouncementOutDeregisterAll () const;

    // Signal 'sig_EventCMGSwivelPosition'

    /**
     * Notify on the signal 'sig_EventCMGSwivelPosition'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_EventCMGSwivelPosition'</b>:
     *
     * EventCMGSwivelPosition = 0x0063 Any component sends an event EventCMGSwivelPosition if a swivel position has changed
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_EventCMGSwivelPositionRegister(Sig_EventCMGSwivelPositionCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_EventCMGSwivelPosition'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_EventCMGSwivelPosition'</b>:
     *
     * EventCMGSwivelPosition = 0x0063 Any component sends an event EventCMGSwivelPosition if a swivel position has changed
     *
     * @param act The act which was previously returned by the
     * sendSig_EventCMGSwivelPositionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_EventCMGSwivelPositionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'sig_EventCMGSwivelPosition'.
     */
    void sendSig_EventCMGSwivelPositionDeregisterAll () const;



    // Method 'ReqGetDigitalInput'

    /**
     * Call the method 'ReqGetDigitalInput'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqGetDigitalInput'</b>:
     *
     * ReqGetDigitalInput = Method to Request Digital IO's
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetDigitalInputRequest(ReqGetDigitalInputCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetDigitalInputCMP'

    /**
     * Call the method 'ReqGetDigitalInputCMP'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMP'</b>:
     *
     * ReqGetDigitalInputCMP = 0x0019 Method to request to Request Digital IO's
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetDigitalInputCMPRequest(ReqGetDigitalInputCMPCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetDigitalInputCMG'

    /**
     * Call the method 'ReqGetDigitalInputCMG'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqGetDigitalInputCMG'</b>:
     *
     * ReqGetDigitalInputCMG = 0x0022 Method to request to Request Digital IO's
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetDigitalInputCMGRequest(ReqGetDigitalInputCMGCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetVoltage'

    /**
     * Call the method 'ReqGetVoltage'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqGetVoltage'</b>:
     *
     * ReqGetVoltage = 0x0013
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param VoltageSensor If the meaning of "VoltageSensor" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetVoltageRequest(ReqGetVoltageCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, entVoltageSensor voltageSensor, const ::std::string& destIP) const;

    // Method 'ReqSetAnnouncementOut'

    /**
     * Call the method 'ReqSetAnnouncementOut'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqSetAnnouncementOut'</b>:
     *
     * ReqSetAnnouncementOut = 0x0020 Method to Request AnnouncementState
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param AnnouncementState If the meaning of "AnnouncementState" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqSetAnnouncementOutRequest(ReqSetAnnouncementOutCallbackIF& cb, entAnnouncementState announcementState, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqGetThermalState'

    /**
     * Call the method 'ReqGetThermalState'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqGetThermalState'</b>:
     *
     * ReqGetThermalState = 0x0044
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqGetThermalStateRequest(ReqGetThermalStateCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    // Method 'ReqCMGSvivelPosition'

    /**
     * Call the method 'ReqCMGSvivelPosition'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReqCMGSvivelPosition'</b>:
     *
     * ReqCMGSvivelPosition = 0x0064, Method to request open/close the position of the svivel of the glasses.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SvivelRequest If the meaning of "SvivelRequest" isn't clear, then there should be a description here.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Msg_ID If the meaning of "Msg_ID" isn't clear, then there should be a description here.
     *
     * @param DestIP If the meaning of "DestIP" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqCMGSvivelPositionRequest(ReqCMGSvivelPositionCallbackIF& cb, entSvivelRequest svivelRequest, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    NanoMsgGenericInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class NanoMsgGenericInterfaceProxyCallback;
};

} // namespace NanoMsgGenericInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_NANOMSGGENERICINTERFACEPROXY_H
