/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/NanoMsgGenericInterface.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceConst.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceJson.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace NanoMsgGenericInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/NanoMsgGenericInterface", NanoMsgGenericInterfaceProxy);

class NanoMsgGenericInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    NanoMsgGenericInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< NanoMsgGenericInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sig_RspCMGSvivelPosition:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspCMGSvivelPositionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspCMGSvivelPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspCMGSvivelPositionSignal> payload = ::boost::static_pointer_cast<Sig_RspCMGSvivelPositionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspCMGSvivelPositionCallbackIF*) _callback)->onSig_RspCMGSvivelPositionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetDigitalInput:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetDigitalInputSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetDigitalInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetDigitalInputSignal> payload = ::boost::static_pointer_cast<Sig_RspGetDigitalInputSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetDigitalInputCallbackIF*) _callback)->onSig_RspGetDigitalInputSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventDigitalInput:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventDigitalInputSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventDigitalInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventDigitalInputSignal> payload = ::boost::static_pointer_cast<Sig_EventDigitalInputSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventDigitalInputCallbackIF*) _callback)->onSig_EventDigitalInputSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetDigitalInputCMP:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetDigitalInputCMPSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetDigitalInputCMPSignal> payload = ::boost::static_pointer_cast<Sig_RspGetDigitalInputCMPSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetDigitalInputCMPCallbackIF*) _callback)->onSig_RspGetDigitalInputCMPSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventDigitalInputCMP:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventDigitalInputCMPSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventDigitalInputCMPSignal> payload = ::boost::static_pointer_cast<Sig_EventDigitalInputCMPSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventDigitalInputCMPCallbackIF*) _callback)->onSig_EventDigitalInputCMPSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_RspGetDigitalInputCMG:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_RspGetDigitalInputCMGSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_RspGetDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_RspGetDigitalInputCMGSignal> payload = ::boost::static_pointer_cast<Sig_RspGetDigitalInputCMGSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_RspGetDigitalInputCMGCallbackIF*) _callback)->onSig_RspGetDigitalInputCMGSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventDigitalInputCMG:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventDigitalInputCMGSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventDigitalInputCMGSignal> payload = ::boost::static_pointer_cast<Sig_EventDigitalInputCMGSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventDigitalInputCMGCallbackIF*) _callback)->onSig_EventDigitalInputCMGSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RspGetVoltage:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RspGetVoltageSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RspGetVoltage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RspGetVoltageSignal> payload = ::boost::static_pointer_cast<RspGetVoltageSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RspGetVoltageCallbackIF*) _callback)->onRspGetVoltageSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventVoltage:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventVoltageSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventVoltage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventVoltageSignal> payload = ::boost::static_pointer_cast<EventVoltageSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventVoltageCallbackIF*) _callback)->onEventVoltageSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RspGetThermalState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RspGetThermalStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RspGetThermalState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RspGetThermalStateSignal> payload = ::boost::static_pointer_cast<RspGetThermalStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RspGetThermalStateCallbackIF*) _callback)->onRspGetThermalStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventThermalState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventThermalStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventThermalState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventThermalStateSignal> payload = ::boost::static_pointer_cast<EventThermalStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventThermalStateCallbackIF*) _callback)->onEventThermalStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RspSetAnnouncementOut:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RspSetAnnouncementOutSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RspSetAnnouncementOut", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RspSetAnnouncementOutSignal> payload = ::boost::static_pointer_cast<RspSetAnnouncementOutSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RspSetAnnouncementOutCallbackIF*) _callback)->onRspSetAnnouncementOutSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_EventCMGSwivelPosition:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_EventCMGSwivelPositionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_EventCMGSwivelPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_EventCMGSwivelPositionSignal> payload = ::boost::static_pointer_cast<Sig_EventCMGSwivelPositionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_EventCMGSwivelPositionCallbackIF*) _callback)->onSig_EventCMGSwivelPositionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ReqGetDigitalInput:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputError> payload = ::boost::static_pointer_cast<ReqGetDigitalInputError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCallbackIF*) _callback)->onReqGetDigitalInputError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputResponse> payload = ::boost::static_pointer_cast<ReqGetDigitalInputResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCallbackIF*) _callback)->onReqGetDigitalInputResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetDigitalInputCMP:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMPError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputCMPError> payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMPError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCMPCallbackIF*) _callback)->onReqGetDigitalInputCMPError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMPResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputCMPResponse> payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMPResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCMPCallbackIF*) _callback)->onReqGetDigitalInputCMPResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetDigitalInputCMG:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMGError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputCMGError> payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMGError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCMGCallbackIF*) _callback)->onReqGetDigitalInputCMGError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetDigitalInputCMGResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetDigitalInputCMGResponse> payload = ::boost::static_pointer_cast<ReqGetDigitalInputCMGResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetDigitalInputCMGCallbackIF*) _callback)->onReqGetDigitalInputCMGResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetVoltage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVoltageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVoltage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVoltageError> payload = ::boost::static_pointer_cast<ReqGetVoltageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVoltageCallbackIF*) _callback)->onReqGetVoltageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetVoltageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetVoltage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetVoltageResponse> payload = ::boost::static_pointer_cast<ReqGetVoltageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetVoltageCallbackIF*) _callback)->onReqGetVoltageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqSetAnnouncementOut:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetAnnouncementOutError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetAnnouncementOut", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetAnnouncementOutError> payload = ::boost::static_pointer_cast<ReqSetAnnouncementOutError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetAnnouncementOutCallbackIF*) _callback)->onReqSetAnnouncementOutError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqSetAnnouncementOutResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqSetAnnouncementOut", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqSetAnnouncementOutResponse> payload = ::boost::static_pointer_cast<ReqSetAnnouncementOutResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqSetAnnouncementOutCallbackIF*) _callback)->onReqSetAnnouncementOutResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqGetThermalState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetThermalStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetThermalState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetThermalStateError> payload = ::boost::static_pointer_cast<ReqGetThermalStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetThermalStateCallbackIF*) _callback)->onReqGetThermalStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqGetThermalStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqGetThermalState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqGetThermalStateResponse> payload = ::boost::static_pointer_cast<ReqGetThermalStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqGetThermalStateCallbackIF*) _callback)->onReqGetThermalStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqCMGSvivelPosition:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqCMGSvivelPositionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCMGSvivelPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCMGSvivelPositionError> payload = ::boost::static_pointer_cast<ReqCMGSvivelPositionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCMGSvivelPositionCallbackIF*) _callback)->onReqCMGSvivelPositionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCMGSvivelPositionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCMGSvivelPosition", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCMGSvivelPositionResponse> payload = ::boost::static_pointer_cast<ReqCMGSvivelPositionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCMGSvivelPositionCallbackIF*) _callback)->onReqCMGSvivelPositionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sig_RspCMGSvivelPosition: {
                ::boost::shared_ptr< Sig_RspCMGSvivelPositionError > payload = ::boost::shared_ptr< Sig_RspCMGSvivelPositionError >
                (new Sig_RspCMGSvivelPositionError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspCMGSvivelPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspCMGSvivelPositionCallbackIF*) _callback)->onSig_RspCMGSvivelPositionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetDigitalInput: {
                ::boost::shared_ptr< Sig_RspGetDigitalInputError > payload = ::boost::shared_ptr< Sig_RspGetDigitalInputError >
                (new Sig_RspGetDigitalInputError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetDigitalInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetDigitalInputCallbackIF*) _callback)->onSig_RspGetDigitalInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventDigitalInput: {
                ::boost::shared_ptr< Sig_EventDigitalInputError > payload = ::boost::shared_ptr< Sig_EventDigitalInputError >
                (new Sig_EventDigitalInputError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventDigitalInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventDigitalInputCallbackIF*) _callback)->onSig_EventDigitalInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetDigitalInputCMP: {
                ::boost::shared_ptr< Sig_RspGetDigitalInputCMPError > payload = ::boost::shared_ptr< Sig_RspGetDigitalInputCMPError >
                (new Sig_RspGetDigitalInputCMPError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetDigitalInputCMPCallbackIF*) _callback)->onSig_RspGetDigitalInputCMPError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventDigitalInputCMP: {
                ::boost::shared_ptr< Sig_EventDigitalInputCMPError > payload = ::boost::shared_ptr< Sig_EventDigitalInputCMPError >
                (new Sig_EventDigitalInputCMPError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventDigitalInputCMPCallbackIF*) _callback)->onSig_EventDigitalInputCMPError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_RspGetDigitalInputCMG: {
                ::boost::shared_ptr< Sig_RspGetDigitalInputCMGError > payload = ::boost::shared_ptr< Sig_RspGetDigitalInputCMGError >
                (new Sig_RspGetDigitalInputCMGError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_RspGetDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_RspGetDigitalInputCMGCallbackIF*) _callback)->onSig_RspGetDigitalInputCMGError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventDigitalInputCMG: {
                ::boost::shared_ptr< Sig_EventDigitalInputCMGError > payload = ::boost::shared_ptr< Sig_EventDigitalInputCMGError >
                (new Sig_EventDigitalInputCMGError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventDigitalInputCMGCallbackIF*) _callback)->onSig_EventDigitalInputCMGError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RspGetVoltage: {
                ::boost::shared_ptr< RspGetVoltageError > payload = ::boost::shared_ptr< RspGetVoltageError >
                (new RspGetVoltageError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RspGetVoltage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RspGetVoltageCallbackIF*) _callback)->onRspGetVoltageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventVoltage: {
                ::boost::shared_ptr< EventVoltageError > payload = ::boost::shared_ptr< EventVoltageError >
                (new EventVoltageError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventVoltage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventVoltageCallbackIF*) _callback)->onEventVoltageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RspGetThermalState: {
                ::boost::shared_ptr< RspGetThermalStateError > payload = ::boost::shared_ptr< RspGetThermalStateError >
                (new RspGetThermalStateError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RspGetThermalState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RspGetThermalStateCallbackIF*) _callback)->onRspGetThermalStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventThermalState: {
                ::boost::shared_ptr< EventThermalStateError > payload = ::boost::shared_ptr< EventThermalStateError >
                (new EventThermalStateError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventThermalState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventThermalStateCallbackIF*) _callback)->onEventThermalStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RspSetAnnouncementOut: {
                ::boost::shared_ptr< RspSetAnnouncementOutError > payload = ::boost::shared_ptr< RspSetAnnouncementOutError >
                (new RspSetAnnouncementOutError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RspSetAnnouncementOut", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RspSetAnnouncementOutCallbackIF*) _callback)->onRspSetAnnouncementOutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_EventCMGSwivelPosition: {
                ::boost::shared_ptr< Sig_EventCMGSwivelPositionError > payload = ::boost::shared_ptr< Sig_EventCMGSwivelPositionError >
                (new Sig_EventCMGSwivelPositionError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_EventCMGSwivelPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_EventCMGSwivelPositionCallbackIF*) _callback)->onSig_EventCMGSwivelPositionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetDigitalInput: {
                ::boost::shared_ptr< ReqGetDigitalInputError > payload = ::boost::shared_ptr< ReqGetDigitalInputError >
                (new ReqGetDigitalInputError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetDigitalInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetDigitalInputCallbackIF*) _callback)->onReqGetDigitalInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetDigitalInputCMP: {
                ::boost::shared_ptr< ReqGetDigitalInputCMPError > payload = ::boost::shared_ptr< ReqGetDigitalInputCMPError >
                (new ReqGetDigitalInputCMPError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetDigitalInputCMP", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetDigitalInputCMPCallbackIF*) _callback)->onReqGetDigitalInputCMPError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetDigitalInputCMG: {
                ::boost::shared_ptr< ReqGetDigitalInputCMGError > payload = ::boost::shared_ptr< ReqGetDigitalInputCMGError >
                (new ReqGetDigitalInputCMGError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetDigitalInputCMG", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetDigitalInputCMGCallbackIF*) _callback)->onReqGetDigitalInputCMGError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetVoltage: {
                ::boost::shared_ptr< ReqGetVoltageError > payload = ::boost::shared_ptr< ReqGetVoltageError >
                (new ReqGetVoltageError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetVoltage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetVoltageCallbackIF*) _callback)->onReqGetVoltageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqSetAnnouncementOut: {
                ::boost::shared_ptr< ReqSetAnnouncementOutError > payload = ::boost::shared_ptr< ReqSetAnnouncementOutError >
                (new ReqSetAnnouncementOutError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqSetAnnouncementOut", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqSetAnnouncementOutCallbackIF*) _callback)->onReqSetAnnouncementOutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqGetThermalState: {
                ::boost::shared_ptr< ReqGetThermalStateError > payload = ::boost::shared_ptr< ReqGetThermalStateError >
                (new ReqGetThermalStateError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqGetThermalState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqGetThermalStateCallbackIF*) _callback)->onReqGetThermalStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqCMGSvivelPosition: {
                ::boost::shared_ptr< ReqCMGSvivelPositionError > payload = ::boost::shared_ptr< ReqCMGSvivelPositionError >
                (new ReqCMGSvivelPositionError(DBUS_ERROR_NO_SERVER, "The DBus service NanoMsgGenericInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqCMGSvivelPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<NanoMsgGenericInterfaceProxy> proxyShared = ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqCMGSvivelPositionCallbackIF*) _callback)->onReqCMGSvivelPositionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& NanoMsgGenericInterfaceProxyCallback::_logger (NanoMsgGenericInterfaceProxy::_logger);

NanoMsgGenericInterfaceProxy::NanoMsgGenericInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.di.NanoMsgGenericInterface", serviceAvailable, _logger) {
}

NanoMsgGenericInterfaceProxy::~NanoMsgGenericInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< NanoMsgGenericInterfaceProxy > NanoMsgGenericInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<NanoMsgGenericInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< NanoMsgGenericInterfaceProxy > proxyNew(new NanoMsgGenericInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t NanoMsgGenericInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    NanoMsgGenericInterfaceProxyCallback* callback = new NanoMsgGenericInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t NanoMsgGenericInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    NanoMsgGenericInterfaceProxyCallback* callback = new NanoMsgGenericInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void NanoMsgGenericInterfaceProxy::sendDeregisterAll () const
{
    sendSig_RspCMGSvivelPositionDeregisterAll();
    sendSig_RspGetDigitalInputDeregisterAll();
    sendSig_EventDigitalInputDeregisterAll();
    sendSig_RspGetDigitalInputCMPDeregisterAll();
    sendSig_EventDigitalInputCMPDeregisterAll();
    sendSig_RspGetDigitalInputCMGDeregisterAll();
    sendSig_EventDigitalInputCMGDeregisterAll();
    sendRspGetVoltageDeregisterAll();
    sendEventVoltageDeregisterAll();
    sendRspGetThermalStateDeregisterAll();
    sendEventThermalStateDeregisterAll();
    sendRspSetAnnouncementOutDeregisterAll();
    sendSig_EventCMGSwivelPositionDeregisterAll();
}

act_t NanoMsgGenericInterfaceProxy::sendSig_RspCMGSvivelPositionRegister(Sig_RspCMGSvivelPositionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspCMGSvivelPosition");
    act_t act = addSignalCallback(ID_sig_RspCMGSvivelPosition, "sig_RspCMGSvivelPosition", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspCMGSvivelPosition", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_RspCMGSvivelPositionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspCMGSvivelPosition", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspCMGSvivelPosition", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_RspCMGSvivelPositionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspCMGSvivelPosition");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspCMGSvivelPosition", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputRegister(Sig_RspGetDigitalInputCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetDigitalInput");
    act_t act = addSignalCallback(ID_sig_RspGetDigitalInput, "sig_RspGetDigitalInput", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetDigitalInput", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetDigitalInput", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetDigitalInput", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetDigitalInput");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetDigitalInput", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputRegister(Sig_EventDigitalInputCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventDigitalInput");
    act_t act = addSignalCallback(ID_sig_EventDigitalInput, "sig_EventDigitalInput", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventDigitalInput", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventDigitalInput", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventDigitalInput", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventDigitalInput");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventDigitalInput", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMPRegister(Sig_RspGetDigitalInputCMPCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetDigitalInputCMP");
    act_t act = addSignalCallback(ID_sig_RspGetDigitalInputCMP, "sig_RspGetDigitalInputCMP", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetDigitalInputCMP", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMPDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetDigitalInputCMP", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetDigitalInputCMP", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMPDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetDigitalInputCMP");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetDigitalInputCMP", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMPRegister(Sig_EventDigitalInputCMPCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventDigitalInputCMP");
    act_t act = addSignalCallback(ID_sig_EventDigitalInputCMP, "sig_EventDigitalInputCMP", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventDigitalInputCMP", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMPDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventDigitalInputCMP", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventDigitalInputCMP", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMPDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventDigitalInputCMP");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventDigitalInputCMP", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMGRegister(Sig_RspGetDigitalInputCMGCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_RspGetDigitalInputCMG");
    act_t act = addSignalCallback(ID_sig_RspGetDigitalInputCMG, "sig_RspGetDigitalInputCMG", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_RspGetDigitalInputCMG", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMGDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_RspGetDigitalInputCMG", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_RspGetDigitalInputCMG", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_RspGetDigitalInputCMGDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_RspGetDigitalInputCMG");
    _dbusProxyDelegate->deregisterSignalCallback("sig_RspGetDigitalInputCMG", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMGRegister(Sig_EventDigitalInputCMGCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventDigitalInputCMG");
    act_t act = addSignalCallback(ID_sig_EventDigitalInputCMG, "sig_EventDigitalInputCMG", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventDigitalInputCMG", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMGDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventDigitalInputCMG", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventDigitalInputCMG", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_EventDigitalInputCMGDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventDigitalInputCMG");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventDigitalInputCMG", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendRspGetVoltageRegister(RspGetVoltageCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RspGetVoltage");
    act_t act = addSignalCallback(ID_RspGetVoltage, "RspGetVoltage", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RspGetVoltage", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendRspGetVoltageDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RspGetVoltage", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RspGetVoltage", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendRspGetVoltageDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RspGetVoltage");
    _dbusProxyDelegate->deregisterSignalCallback("RspGetVoltage", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendEventVoltageRegister(EventVoltageCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventVoltage");
    act_t act = addSignalCallback(ID_EventVoltage, "EventVoltage", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventVoltage", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendEventVoltageDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventVoltage", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventVoltage", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendEventVoltageDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventVoltage");
    _dbusProxyDelegate->deregisterSignalCallback("EventVoltage", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendRspGetThermalStateRegister(RspGetThermalStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RspGetThermalState");
    act_t act = addSignalCallback(ID_RspGetThermalState, "RspGetThermalState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RspGetThermalState", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendRspGetThermalStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RspGetThermalState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RspGetThermalState", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendRspGetThermalStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RspGetThermalState");
    _dbusProxyDelegate->deregisterSignalCallback("RspGetThermalState", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendEventThermalStateRegister(EventThermalStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventThermalState");
    act_t act = addSignalCallback(ID_EventThermalState, "EventThermalState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventThermalState", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendEventThermalStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventThermalState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventThermalState", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendEventThermalStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventThermalState");
    _dbusProxyDelegate->deregisterSignalCallback("EventThermalState", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendRspSetAnnouncementOutRegister(RspSetAnnouncementOutCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RspSetAnnouncementOut");
    act_t act = addSignalCallback(ID_RspSetAnnouncementOut, "RspSetAnnouncementOut", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RspSetAnnouncementOut", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendRspSetAnnouncementOutDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RspSetAnnouncementOut", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RspSetAnnouncementOut", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendRspSetAnnouncementOutDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RspSetAnnouncementOut");
    _dbusProxyDelegate->deregisterSignalCallback("RspSetAnnouncementOut", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendSig_EventCMGSwivelPositionRegister(Sig_EventCMGSwivelPositionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_EventCMGSwivelPosition");
    act_t act = addSignalCallback(ID_sig_EventCMGSwivelPosition, "sig_EventCMGSwivelPosition", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_EventCMGSwivelPosition", &cb, act);
    return act;
}

bool NanoMsgGenericInterfaceProxy::sendSig_EventCMGSwivelPositionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_EventCMGSwivelPosition", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_EventCMGSwivelPosition", act, static_cast<int>(rv));
    return rv;
}

void NanoMsgGenericInterfaceProxy::sendSig_EventCMGSwivelPositionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_EventCMGSwivelPosition");
    _dbusProxyDelegate->deregisterSignalCallback("sig_EventCMGSwivelPosition", 0, _dbusDaemonProxy.get(), false);
}

act_t NanoMsgGenericInterfaceProxy::sendReqGetDigitalInputRequest(ReqGetDigitalInputCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetDigitalInputRequest* payload = new ReqGetDigitalInputRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetDigitalInput", ReqGetDigitalInputRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetDigitalInput, dbusMessage.getUniqueSerial(), "ReqGetDigitalInput", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetDigitalInput", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqGetDigitalInputCMPRequest(ReqGetDigitalInputCMPCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetDigitalInputCMPRequest* payload = new ReqGetDigitalInputCMPRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetDigitalInputCMP", ReqGetDigitalInputCMPRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetDigitalInputCMP, dbusMessage.getUniqueSerial(), "ReqGetDigitalInputCMP", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetDigitalInputCMP", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqGetDigitalInputCMGRequest(ReqGetDigitalInputCMGCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetDigitalInputCMGRequest* payload = new ReqGetDigitalInputCMGRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetDigitalInputCMG", ReqGetDigitalInputCMGRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetDigitalInputCMG, dbusMessage.getUniqueSerial(), "ReqGetDigitalInputCMG", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetDigitalInputCMG", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqGetVoltageRequest(ReqGetVoltageCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, entVoltageSensor voltageSensor, const ::std::string& destIP) const {
    ReqGetVoltageRequest* payload = new ReqGetVoltageRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setVoltageSensor(voltageSensor);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetVoltage", ReqGetVoltageRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetVoltage, dbusMessage.getUniqueSerial(), "ReqGetVoltage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetVoltage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqSetAnnouncementOutRequest(ReqSetAnnouncementOutCallbackIF& cb, entAnnouncementState announcementState, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqSetAnnouncementOutRequest* payload = new ReqSetAnnouncementOutRequest();
    CHECK_ALLOCATION(payload);
    payload->setAnnouncementState(announcementState);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqSetAnnouncementOut", ReqSetAnnouncementOutRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqSetAnnouncementOut, dbusMessage.getUniqueSerial(), "ReqSetAnnouncementOut", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqSetAnnouncementOut", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqGetThermalStateRequest(ReqGetThermalStateCallbackIF& cb, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqGetThermalStateRequest* payload = new ReqGetThermalStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqGetThermalState", ReqGetThermalStateRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqGetThermalState, dbusMessage.getUniqueSerial(), "ReqGetThermalState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqGetThermalState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t NanoMsgGenericInterfaceProxy::sendReqCMGSvivelPositionRequest(ReqCMGSvivelPositionCallbackIF& cb, entSvivelRequest svivelRequest, uint8 dev_ID, uint8 dev_Nr, uint16 msg_ID, const ::std::string& destIP) const {
    ReqCMGSvivelPositionRequest* payload = new ReqCMGSvivelPositionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSvivelRequest(svivelRequest);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setMsg_ID(msg_ID);
    payload->setDestIP(destIP);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqCMGSvivelPosition", ReqCMGSvivelPositionRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqCMGSvivelPosition, dbusMessage.getUniqueSerial(), "ReqCMGSvivelPosition", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqCMGSvivelPosition", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace NanoMsgGenericInterface
} // namespace di
} // namespace cm
} // namespace bosch
