/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERPROXY_H
#define MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERPROXY_H

#include "MessageTunnelService/BlobMessageReceiverJson.h"
#include "MessageTunnelService/BlobMessageReceiverProxyStreamerCmsBin.h"
#include "MessageTunnelService/BlobMessageReceiverProxyStreamerJson.h"
#include "asf/cms/CmsProxyDelegate.h"
#include "asf/cms/CmsTypesJson.h"
#include "asf/core/Blob.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"

namespace MessageTunnelService {
namespace BlobMessageReceiver {

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 *  ==> MessageTunnelService = CourierTunnelService, QtTunnelService
 *  ==> BlobMessageReceiver  = CourierMessageReceiver, QtMessageReceiver
 *  ==> BlobMessageReceiverProxy = CourierMessageReceiverProxy
 * _messageProxy = _courierProxy, qtProxy
 *  receiveBlobMessage = receiveCourierMessage, receiveQtMessage
 */



class BlobMessageReceiverProxy;

class BlobMessageReceiverClientBase
{
public:

    virtual ~BlobMessageReceiverClientBase() {}


private:

    DECLARE_CLASS_LOGGER();
};

/**
 * BlobMessageReceiverProxy is the client side representation of the
 * 'BlobMessageReceiver' Car Multimedia Service. The interface is
 * specified in the file 'BlobMessageReceiver.cms'.
 */
class BlobMessageReceiverProxy : public ::asf::cms::CmsProxy
{
public:

    /**
     * Create a new instance of BlobMessageReceiverProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description. Additionally it is necessary to pass a reference on a
     * implementation of the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< BlobMessageReceiverProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of BlobMessageReceiverProxy. The caller has to
     * pass the port name and the address of the service (e.g.
     * cms-json://localhost:12345). It is only possible to use this function
     * if the port is defined in the CMC model as "wired at runtime"-port.
     * Additionally it is necessary to pass a reference on a implementation of
     * the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< BlobMessageReceiverProxy > createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of BlobMessageReceiverProxy. The destructor will send
     * messages for all existing property notifications. Additionally it will
     * call the error callback of all pending method invocations.
     */
    virtual ~BlobMessageReceiverProxy();

    // Request 'receiveBlobMessage'

    /**
     * Call the Request 'receiveBlobMessage'. This method sends a Request
     * message to the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'receiveBlobMessage'</b>:
     *
     * Sends a message from the client to the service provider
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReceiveBlobMessageRequest(const ::asf::core::Blob& message);

    ::asf::cms::CmsServiceStreamer* getStreamer();

private:

    BlobMessageReceiverProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);


    BlobMessageReceiverProxyStreamerJson _streamerJson;

    BlobMessageReceiverProxyStreamerCmsBin _streamerCmsBin;

    DECLARE_CLASS_LOGGER();
};

} // namespace BlobMessageReceiver
} // namespace MessageTunnelService

#endif // MESSAGETUNNELSERVICE_BLOBMESSAGERECEIVERPROXY_H
