/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESSTUB_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include <map>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace SoundProperties {

class SoundPropertiesStubDelegate;

class SoundPropertiesStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SoundPropertiesStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SoundPropertiesStub (const std::string& portName);

    /**
     * Create an instance of the SoundPropertiesStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SoundPropertiesStub (const std::string& portName, const std::string& objectPath);

    virtual ~SoundPropertiesStub();

    // signal 'MainSinkSoundPropertyChanged'

    /**
     * Raise the signal 'MainSinkSoundPropertyChanged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'MainSinkSoundPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in MainSinkSoundProperty
     *
     * @param PropertyType If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param sinkId If the meaning of "sinkId" isn't clear, then there should be a description here.
     */
    void sendMainSinkSoundPropertyChangedSignal(int32 propertyType, int32 value, uint16 sinkId);

    // signal 'SystemPropertyChanged'

    /**
     * Raise the signal 'SystemPropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SystemPropertyChanged'</b>:
     *
     * Signal to indicate that there is a change in SystemProperty
     *
     * @param PropertyType If the meaning of "PropertyType" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     */
    void sendSystemPropertyChangedSignal(int32 propertyType, int32 value);

    // property 'volume'

    /**
     * The method onVolumeGet() is called by ASF when a client invokes the
     * read method for the property 'volume'. The onVolumeGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     */
    virtual void onVolumeGet(const ::boost::shared_ptr< VolumeGet >& payload);

    /**
     * Sends back the update to a previous onVolumeGet().
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     *
     * @param act Identifies a previous invocation of onVolumeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVolumeGetUpdate(uint8 volume, act_t act = 0);

    /**
     * Set the value of the property 'volume' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     */
    void setVolume(uint8 volume);

    /**
     * Returns the current value of the property 'volume'.
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     */
    uint8 getVolume() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVolumeUpdate().
     *
     * <b>Documentation of 'volume'</b>:
     *
     * DEPRECATED: holds the current volume value of DEFAULT_MAIN_SINK
     */
    void sendVolumeUpdate();

    // property 'volumeMap'

    /**
     * The method onVolumeMapGet() is called by ASF when a client invokes the
     * read method for the property 'volumeMap'. The onVolumeMapGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     */
    virtual void onVolumeMapGet(const ::boost::shared_ptr< VolumeMapGet >& payload);

    /**
     * Sends back the update to a previous onVolumeMapGet().
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     *
     * @param act Identifies a previous invocation of onVolumeMapGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVolumeMapGetUpdate(const ::std::map< uint16, uint8 >& volumeMap, act_t act = 0);

    /**
     * Set the value of the property 'volumeMap' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     */
    void setVolumeMap(const ::std::map< uint16, uint8 >& volumeMap);

    /**
     * Returns the current value of the property 'volumeMap'.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     */
    const ::std::map< uint16, uint8 >& getVolumeMap() const;

    /**
     * Returns the current value of the property 'volumeMap' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendVolumeMapUpdate() method.
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     */
    ::std::map< uint16, uint8 >& getVolumeMapMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVolumeMapUpdate().
     *
     * <b>Documentation of 'volumeMap'</b>:
     *
     * holds the current volume value
     */
    void sendVolumeMapUpdate();

    // property 'muteState'

    /**
     * The method onMuteStateGet() is called by ASF when a client invokes the
     * read method for the property 'muteState'. The onMuteStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     */
    virtual void onMuteStateGet(const ::boost::shared_ptr< MuteStateGet >& payload);

    /**
     * Sends back the update to a previous onMuteStateGet().
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     *
     * @param act Identifies a previous invocation of onMuteStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMuteStateGetUpdate(bool muteState, act_t act = 0);

    /**
     * Set the value of the property 'muteState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     */
    void setMuteState(bool muteState);

    /**
     * Returns the current value of the property 'muteState'.
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     */
    bool getMuteState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMuteStateUpdate().
     *
     * <b>Documentation of 'muteState'</b>:
     *
     * DEPRECATED: holds the current mute state of DEFAULT_MAIN_SINK
     */
    void sendMuteStateUpdate();

    // property 'muteStateMap'

    /**
     * The method onMuteStateMapGet() is called by ASF when a client invokes
     * the read method for the property 'muteStateMap'. The
     * onMuteStateMapGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     */
    virtual void onMuteStateMapGet(const ::boost::shared_ptr< MuteStateMapGet >& payload);

    /**
     * Sends back the update to a previous onMuteStateMapGet().
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     *
     * @param act Identifies a previous invocation of onMuteStateMapGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMuteStateMapGetUpdate(const ::std::map< uint16, bool >& muteStateMap, act_t act = 0);

    /**
     * Set the value of the property 'muteStateMap' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     */
    void setMuteStateMap(const ::std::map< uint16, bool >& muteStateMap);

    /**
     * Returns the current value of the property 'muteStateMap'.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     */
    const ::std::map< uint16, bool >& getMuteStateMap() const;

    /**
     * Returns the current value of the property 'muteStateMap' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMuteStateMapUpdate() method.
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     */
    ::std::map< uint16, bool >& getMuteStateMapMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMuteStateMapUpdate().
     *
     * <b>Documentation of 'muteStateMap'</b>:
     *
     * holds the current mute state
     */
    void sendMuteStateMapUpdate();

    // property 'audioStateInfo'

    /**
     * The method onAudioStateInfoGet() is called by ASF when a client invokes
     * the read method for the property 'audioStateInfo'. The
     * onAudioStateInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     */
    virtual void onAudioStateInfoGet(const ::boost::shared_ptr< AudioStateInfoGet >& payload);

    /**
     * Sends back the update to a previous onAudioStateInfoGet().
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     *
     * @param act Identifies a previous invocation of onAudioStateInfoGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAudioStateInfoGetUpdate(const AudioStateInfo& audioStateInfo, act_t act = 0);

    /**
     * Set the value of the property 'audioStateInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     */
    void setAudioStateInfo(const AudioStateInfo& audioStateInfo);

    /**
     * Returns the current value of the property 'audioStateInfo'.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     */
    const AudioStateInfo& getAudioStateInfo() const;

    /**
     * Returns the current value of the property 'audioStateInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAudioStateInfoUpdate() method.
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     */
    AudioStateInfo& getAudioStateInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAudioStateInfoUpdate().
     *
     * <b>Documentation of 'audioStateInfo'</b>:
     *
     * DEPRECATED: holds the current mute and audio state of DEFAULT_MAIN_SINK
     */
    void sendAudioStateInfoUpdate();

    // property 'audioStateInfoMap'

    /**
     * The method onAudioStateInfoMapGet() is called by ASF when a client
     * invokes the read method for the property 'audioStateInfoMap'. The
     * onAudioStateInfoMapGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     */
    virtual void onAudioStateInfoMapGet(const ::boost::shared_ptr< AudioStateInfoMapGet >& payload);

    /**
     * Sends back the update to a previous onAudioStateInfoMapGet().
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     *
     * @param act Identifies a previous invocation of
     * onAudioStateInfoMapGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAudioStateInfoMapGetUpdate(const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap, act_t act = 0);

    /**
     * Set the value of the property 'audioStateInfoMap' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     */
    void setAudioStateInfoMap(const ::std::map< uint16, AudioStateInfo >& audioStateInfoMap);

    /**
     * Returns the current value of the property 'audioStateInfoMap'.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     */
    const ::std::map< uint16, AudioStateInfo >& getAudioStateInfoMap() const;

    /**
     * Returns the current value of the property 'audioStateInfoMap' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendAudioStateInfoMapUpdate() method.
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     */
    ::std::map< uint16, AudioStateInfo >& getAudioStateInfoMapMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAudioStateInfoMapUpdate().
     *
     * <b>Documentation of 'audioStateInfoMap'</b>:
     *
     * holds the current mute and audio state
     */
    void sendAudioStateInfoMapUpdate();

    // property 'systemPropertyList'

    /**
     * The method onSystemPropertyListGet() is called by ASF when a client
     * invokes the read method for the property 'systemPropertyList'. The
     * onSystemPropertyListGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     */
    virtual void onSystemPropertyListGet(const ::boost::shared_ptr< SystemPropertyListGet >& payload);

    /**
     * Sends back the update to a previous onSystemPropertyListGet().
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     *
     * @param act Identifies a previous invocation of
     * onSystemPropertyListGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSystemPropertyListGetUpdate(const ::std::vector< SystemProperty >& systemPropertyList, act_t act = 0);

    /**
     * Set the value of the property 'systemPropertyList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     */
    void setSystemPropertyList(const ::std::vector< SystemProperty >& systemPropertyList);

    /**
     * Returns the current value of the property 'systemPropertyList'.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     */
    const ::std::vector< SystemProperty >& getSystemPropertyList() const;

    /**
     * Returns the current value of the property 'systemPropertyList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSystemPropertyListUpdate() method.
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     */
    ::std::vector< SystemProperty >& getSystemPropertyListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemPropertyListUpdate().
     *
     * <b>Documentation of 'systemPropertyList'</b>:
     *
     * List of System properties to registered clients
     */
    void sendSystemPropertyListUpdate();

    // property 'soundPropertyList'

    /**
     * The method onSoundPropertyListGet() is called by ASF when a client
     * invokes the read method for the property 'soundPropertyList'. The
     * onSoundPropertyListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     */
    virtual void onSoundPropertyListGet(const ::boost::shared_ptr< SoundPropertyListGet >& payload);

    /**
     * Sends back the update to a previous onSoundPropertyListGet().
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     *
     * @param act Identifies a previous invocation of
     * onSoundPropertyListGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSoundPropertyListGetUpdate(const SoundPropertyData& soundPropertyList, act_t act = 0);

    /**
     * Set the value of the property 'soundPropertyList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     */
    void setSoundPropertyList(const SoundPropertyData& soundPropertyList);

    /**
     * Returns the current value of the property 'soundPropertyList'.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     */
    const SoundPropertyData& getSoundPropertyList() const;

    /**
     * Returns the current value of the property 'soundPropertyList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSoundPropertyListUpdate() method.
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     */
    SoundPropertyData& getSoundPropertyListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSoundPropertyListUpdate().
     *
     * <b>Documentation of 'soundPropertyList'</b>:
     *
     * List of sound properties to registered clients
     */
    void sendSoundPropertyListUpdate();

    // method 'setMuteState'

    /**
     * The method onSetMuteState() is called by ASF when a client invokes the
     * method 'setMuteState'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetMuteState() or
     * sendSetMuteStateError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'setMuteState'</b>:
     *
     * Method to activate or deactivate mute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMuteStateRequest (const ::boost::shared_ptr< SetMuteStateRequest >& request) = 0;

    /**
     * The method sendSetMuteStateResponse() sends a response of a previous
     * method invocation of 'setMuteState' back to the client.
     *
     * <b>Documentation of 'setMuteState'</b>:
     *
     * Method to activate or deactivate mute
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMuteState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetMuteStateResponse (act_t act = 0);

    /**
     * The method sendSetMuteStateError() sends an error response of a
     * previous method invocation of 'setMuteState' back to the client.
     *
     * <b>Documentation of 'setMuteState'</b>:
     *
     * Method to activate or deactivate mute
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetMuteState(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setAudioState'

    /**
     * The method onSetAudioState() is called by ASF when a client invokes the
     * method 'setAudioState'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetAudioState()
     * or sendSetAudioStateError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'setAudioState'</b>:
     *
     * Method to activate or deactivate audio off for main sink
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetAudioStateRequest (const ::boost::shared_ptr< SetAudioStateRequest >& request) = 0;

    /**
     * The method sendSetAudioStateResponse() sends a response of a previous
     * method invocation of 'setAudioState' back to the client.
     *
     * <b>Documentation of 'setAudioState'</b>:
     *
     * Method to activate or deactivate audio off for main sink
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetAudioState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetAudioStateResponse (act_t act = 0);

    /**
     * The method sendSetAudioStateError() sends an error response of a
     * previous method invocation of 'setAudioState' back to the client.
     *
     * <b>Documentation of 'setAudioState'</b>:
     *
     * Method to activate or deactivate audio off for main sink
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetAudioState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetAudioStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setMainSinkSoundProperty'

    /**
     * The method onSetMainSinkSoundProperty() is called by ASF when a client
     * invokes the method 'setMainSinkSoundProperty'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetMainSinkSoundProperty() or
     * sendSetMainSinkSoundPropertyError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'setMainSinkSoundProperty'</b>:
     *
     * Method for Converting static sink ID to dynamic and send the same to Audio
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMainSinkSoundPropertyRequest (const ::boost::shared_ptr< SetMainSinkSoundPropertyRequest >& request) = 0;

    /**
     * The method sendSetMainSinkSoundPropertyResponse() sends a response of a
     * previous method invocation of 'setMainSinkSoundProperty' back to the
     * client.
     *
     * <b>Documentation of 'setMainSinkSoundProperty'</b>:
     *
     * Method for Converting static sink ID to dynamic and send the same to Audio
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMainSinkSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSinkSoundPropertyResponse (act_t act = 0);

    /**
     * The method sendSetMainSinkSoundPropertyError() sends an error response
     * of a previous method invocation of 'setMainSinkSoundProperty' back to
     * the client.
     *
     * <b>Documentation of 'setMainSinkSoundProperty'</b>:
     *
     * Method for Converting static sink ID to dynamic and send the same to Audio
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetMainSinkSoundProperty(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMainSinkSoundPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetSystemProperty'

    /**
     * The method onSetSystemProperty() is called by ASF when a client invokes
     * the method 'SetSystemProperty'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetSystemProperty() or sendSetSystemPropertyError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Method for setting system property
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSystemPropertyRequest (const ::boost::shared_ptr< SetSystemPropertyRequest >& request) = 0;

    /**
     * The method sendSetSystemPropertyResponse() sends a response of a
     * previous method invocation of 'SetSystemProperty' back to the client.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Method for setting system property
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSystemProperty(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetSystemPropertyResponse (act_t act = 0);

    /**
     * The method sendSetSystemPropertyError() sends an error response of a
     * previous method invocation of 'SetSystemProperty' back to the client.
     *
     * <b>Documentation of 'SetSystemProperty'</b>:
     *
     * Method for setting system property
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetSystemProperty().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetSystemPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestMainSinkSoundPropertyList'

    /**
     * The method onRequestMainSinkSoundPropertyList() is called by ASF when a
     * client invokes the method 'RequestMainSinkSoundPropertyList'.  Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'RequestMainSinkSoundPropertyList'</b>:
     *
     * Method for requesting List of MainSinkSoundProperties
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestMainSinkSoundPropertyListRequest (const ::boost::shared_ptr< RequestMainSinkSoundPropertyListRequest >& request) = 0;

    // method 'RequestSystemPropertyList'

    /**
     * The method onRequestSystemPropertyList() is called by ASF when a client
     * invokes the method 'RequestSystemPropertyList'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'RequestSystemPropertyList'</b>:
     *
     * Method for requesting List of System properties
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestSystemPropertyListRequest (const ::boost::shared_ptr< RequestSystemPropertyListRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    VolumeUpdate _volumeProperty;

    VolumeMapUpdate _volumeMapProperty;

    MuteStateUpdate _muteStateProperty;

    MuteStateMapUpdate _muteStateMapProperty;

    AudioStateInfoUpdate _audioStateInfoProperty;

    AudioStateInfoMapUpdate _audioStateInfoMapProperty;

    SystemPropertyListUpdate _systemPropertyListProperty;

    SoundPropertyListUpdate _soundPropertyListProperty;

    friend class SoundPropertiesStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace SoundProperties
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_SOUNDPROPERTIESSTUB_H
