/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of AudioStateInfo

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        dbus_bool_t o1 = in.getMuteState() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BOOLEAN, &o1));
        dbus_bool_t o2 = in.getAudioOnOffState() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BOOLEAN, &o2));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo& out) {
    {
        DBusMessageIter o3;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o3);
                {
                    bool muteStateValue;
                    bool &muteStateTmpValue = muteStateValue;
                    {
                        dbus_bool_t o4;
                        dbus_message_iter_get_basic(&o3, &o4);
                        muteStateTmpValue = o4 ? true : false;
                    }
                    out.setMuteState(muteStateValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

                {
                    bool audioOnOffStateValue;
                    bool &audioOnOffStateTmpValue = audioOnOffStateValue;
                    {
                        dbus_bool_t o5;
                        dbus_message_iter_get_basic(&o3, &o5);
                        audioOnOffStateTmpValue = o5 ? true : false;
                    }
                    out.setAudioOnOffState(audioOnOffStateValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SoundProperty

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty& in, DBusMessageIter* out) {
    {
        DBusMessageIter o6Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o6Struct));
        int32 o7 = in.getPropertyType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o6Struct, DBUS_TYPE_INT32, &o7));
        int32 o8 = in.getValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o6Struct, DBUS_TYPE_INT32, &o8));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o6Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty& out) {
    {
        DBusMessageIter o9;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o9);
                {
                    int32 PropertyTypeValue;
                    int32 &PropertyTypeTmpValue = PropertyTypeValue;
                    dbus_message_iter_get_basic(&o9, &PropertyTypeTmpValue);
                    out.setPropertyType(PropertyTypeValue);
                }

                if (dbus_message_iter_has_next(&o9)) {
                    dbus_message_iter_next(&o9);
                } else {
                    return true;
                }

                {
                    int32 valueValue;
                    int32 &valueTmpValue = valueValue;
                    dbus_message_iter_get_basic(&o9, &valueTmpValue);
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o9)) {
                    dbus_message_iter_next(&o9);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SystemProperty

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty& in, DBusMessageIter* out) {
    {
        DBusMessageIter o10Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o10Struct));
        int32 o11 = in.getPropertyType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_INT32, &o11));
        int32 o12 = in.getValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_INT32, &o12));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o10Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty& out) {
    {
        DBusMessageIter o13;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o13);
                {
                    int32 PropertyTypeValue;
                    int32 &PropertyTypeTmpValue = PropertyTypeValue;
                    dbus_message_iter_get_basic(&o13, &PropertyTypeTmpValue);
                    out.setPropertyType(PropertyTypeValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

                {
                    int32 valueValue;
                    int32 &valueTmpValue = valueValue;
                    dbus_message_iter_get_basic(&o13, &valueTmpValue);
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SoundPropertyData

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        DBusMessageIter o15ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o14Struct, DBUS_TYPE_ARRAY, "(ii)", &o15ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty >* o16 = &in.getSoundData();
        ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty >::const_iterator o17 = o16->end();
        for (::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty >::const_iterator o18 = o16->begin(); o18 != o17; ++o18) {
            serializeDBus((*o18), &o15ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o14Struct, &o15ArrayIter));
        uint16 o19 = in.getSinkId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT16, &o19));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyData& out) {
    {
        DBusMessageIter o20;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o20);
                {
                    ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty > SoundDataValue;

                    if (dbus_message_iter_get_arg_type(&o20) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o21ArrayIter;
                        dbus_message_iter_recurse (&o20, &o21ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o21ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundProperty o22;
                                if (!deserializeDBus(&o21ArrayIter, o22)) {
                                    return false;
                                }
                                SoundDataValue.push_back(o22);
                            } while (dbus_message_iter_next(&o21ArrayIter));
                        }
                    }
                    out.setSoundData(SoundDataValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

                {
                    uint16 SinkIdValue;
                    uint16 &SinkIdTmpValue = SinkIdValue;
                    dbus_message_iter_get_basic(&o20, &SinkIdTmpValue);
                    out.setSinkId(SinkIdValue);
                }

                if (dbus_message_iter_has_next(&o20)) {
                    dbus_message_iter_next(&o20);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SetMuteStateRequest

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMuteStateRequest& in, DBusMessageIter* out) {
    dbus_bool_t o23 = in.getMuteState() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o23));
    uint16 o24 = in.getSinkId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o24));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMuteStateRequest& out) {
    {
        bool muteStateValue;
        bool &muteStateTmpValue = muteStateValue;
        {
            dbus_bool_t o25;
            dbus_message_iter_get_basic(in, &o25);
            muteStateTmpValue = o25 ? true : false;
        }
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIdValue;
        uint16 &sinkIdTmpValue = sinkIdValue;
        dbus_message_iter_get_basic(in, &sinkIdTmpValue);
        out.setSinkId(sinkIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetAudioStateRequest

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetAudioStateRequest& in, DBusMessageIter* out) {
    dbus_bool_t o26 = in.getAudioState() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o26));
    uint16 o27 = in.getSinkId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o27));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetAudioStateRequest& out) {
    {
        bool audioStateValue;
        bool &audioStateTmpValue = audioStateValue;
        {
            dbus_bool_t o28;
            dbus_message_iter_get_basic(in, &o28);
            audioStateTmpValue = o28 ? true : false;
        }
        out.setAudioState(audioStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIdValue;
        uint16 &sinkIdTmpValue = sinkIdValue;
        dbus_message_iter_get_basic(in, &sinkIdTmpValue);
        out.setSinkId(sinkIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyRequest

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMainSinkSoundPropertyRequest& in, DBusMessageIter* out) {
    uint16 o29 = in.getPropertyType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o29));
    int32 o30 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o30));
    uint16 o31 = in.getSinkId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o31));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetMainSinkSoundPropertyRequest& out) {
    {
        uint16 PropertyTypeValue;
        uint16 &PropertyTypeTmpValue = PropertyTypeValue;
        dbus_message_iter_get_basic(in, &PropertyTypeTmpValue);
        out.setPropertyType(PropertyTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 valueValue;
        int32 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIdValue;
        uint16 &sinkIdTmpValue = sinkIdValue;
        dbus_message_iter_get_basic(in, &sinkIdTmpValue);
        out.setSinkId(sinkIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyRequest

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetSystemPropertyRequest& in, DBusMessageIter* out) {
    uint16 o32 = in.getPropertyType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o32));
    int32 o33 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o33));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SetSystemPropertyRequest& out) {
    {
        uint16 propertyTypeValue;
        uint16 &propertyTypeTmpValue = propertyTypeValue;
        dbus_message_iter_get_basic(in, &propertyTypeTmpValue);
        out.setPropertyType(propertyTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 valueValue;
        int32 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestMainSinkSoundPropertyListRequest

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestMainSinkSoundPropertyListRequest& in, DBusMessageIter* out) {
    uint16 o34 = in.getSinkId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o34));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::RequestMainSinkSoundPropertyListRequest& out) {
    {
        uint16 sinkIdValue;
        uint16 &sinkIdTmpValue = sinkIdValue;
        dbus_message_iter_get_basic(in, &sinkIdTmpValue);
        out.setSinkId(sinkIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeUpdate& in, DBusMessageIter* out) {
    uint8 o35 = in.getVolume();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o35));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeUpdate& out) {
    {
        uint8 volumeValue;
        uint8 &volumeTmpValue = volumeValue;
        dbus_message_iter_get_basic(in, &volumeTmpValue);
        out.setVolume(volumeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of VolumeMapUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeMapUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o36ArrayIter;
    DBusMessageIter o37DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{qy}", &o36ArrayIter));
    const ::std::map< uint16, uint8 >* o38 = &in.getVolumeMap();
    ::std::map< uint16, uint8 >::const_iterator o39 = o38->end();
    for (::std::map< uint16, uint8 >::const_iterator o40 = o38->begin(); o40 != o39; ++o40) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o36ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o37DictIter));
        uint16 o41 = o40->first;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o37DictIter, DBUS_TYPE_UINT16, &o41));
        uint8 o42 = o40->second;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o37DictIter, DBUS_TYPE_BYTE, &o42));
        DBUS_ASSERT(dbus_message_iter_close_container(&o36ArrayIter, &o37DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o36ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeMapUpdate& out) {
    {
        ::std::map< uint16, uint8 > volumeMapValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o43ArrayIter;
            DBusMessageIter o44DictIter;
            dbus_message_iter_recurse (in, &o43ArrayIter);

            if (dbus_message_iter_get_arg_type(&o43ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o45Key;
                    uint8 o45Value;
                    dbus_message_iter_recurse (&o43ArrayIter, &o44DictIter);
                    dbus_message_iter_get_basic(&o44DictIter, &o45Key);
                    dbus_message_iter_next(&o44DictIter);
                    dbus_message_iter_get_basic(&o44DictIter, &o45Value);
                    volumeMapValue.insert(std::pair< uint16, uint8 >(o45Key, o45Value));
                } while (dbus_message_iter_next(&o43ArrayIter));
            }
        }
        out.setVolumeMap(volumeMapValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeMapRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeMapRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::VolumeMapRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MuteStateUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o46 = in.getMuteState() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o46));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateUpdate& out) {
    {
        bool muteStateValue;
        bool &muteStateTmpValue = muteStateValue;
        {
            dbus_bool_t o47;
            dbus_message_iter_get_basic(in, &o47);
            muteStateTmpValue = o47 ? true : false;
        }
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MuteStateRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MuteStateMapUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o48ArrayIter;
    DBusMessageIter o49DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{qb}", &o48ArrayIter));
    const ::std::map< uint16, bool >* o50 = &in.getMuteStateMap();
    ::std::map< uint16, bool >::const_iterator o51 = o50->end();
    for (::std::map< uint16, bool >::const_iterator o52 = o50->begin(); o52 != o51; ++o52) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o48ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o49DictIter));
        uint16 o53 = o52->first;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49DictIter, DBUS_TYPE_UINT16, &o53));
        dbus_bool_t o54 = o52->second ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49DictIter, DBUS_TYPE_BOOLEAN, &o54));
        DBUS_ASSERT(dbus_message_iter_close_container(&o48ArrayIter, &o49DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o48ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapUpdate& out) {
    {
        ::std::map< uint16, bool > muteStateMapValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o55ArrayIter;
            DBusMessageIter o56DictIter;
            dbus_message_iter_recurse (in, &o55ArrayIter);

            if (dbus_message_iter_get_arg_type(&o55ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o57Key;
                    bool o57Value;
                    dbus_message_iter_recurse (&o55ArrayIter, &o56DictIter);
                    dbus_message_iter_get_basic(&o56DictIter, &o57Key);
                    dbus_message_iter_next(&o56DictIter);
                    {
                        dbus_bool_t o58;
                        dbus_message_iter_get_basic(&o56DictIter, &o58);
                        o57Value = o58 ? true : false;
                    }
                    muteStateMapValue.insert(std::pair< uint16, bool >(o57Key, o57Value));
                } while (dbus_message_iter_next(&o55ArrayIter));
            }
        }
        out.setMuteStateMap(muteStateMapValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MuteStateMapRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AudioStateInfoUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getAudioStateInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoUpdate& out) {
    {
        ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo audioStateInfoValue;
        if (!deserializeDBus(in, audioStateInfoValue)) {
            return false;
        }
        out.setAudioStateInfo(audioStateInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudioStateInfoRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AudioStateInfoMapUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoMapUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o59ArrayIter;
    DBusMessageIter o60DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{q(bb)}", &o59ArrayIter));
    const ::std::map< uint16, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo >* o61 = &in.getAudioStateInfoMap();
    ::std::map< uint16, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo >::const_iterator o62 = o61->end();
    for (::std::map< uint16, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo >::const_iterator o63 = o61->begin(); o63 != o62; ++o63) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o59ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o60DictIter));
        uint16 o64 = o63->first;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o60DictIter, DBUS_TYPE_UINT16, &o64));
        serializeDBus(o63->second, &o60DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o59ArrayIter, &o60DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o59ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoMapUpdate& out) {
    {
        ::std::map< uint16, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo > audioStateInfoMapValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o65ArrayIter;
            DBusMessageIter o66DictIter;
            dbus_message_iter_recurse (in, &o65ArrayIter);

            if (dbus_message_iter_get_arg_type(&o65ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o67Key;
                    ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo o67Value;
                    dbus_message_iter_recurse (&o65ArrayIter, &o66DictIter);
                    dbus_message_iter_get_basic(&o66DictIter, &o67Key);
                    dbus_message_iter_next(&o66DictIter);
                    if (!deserializeDBus(&o66DictIter, o67Value)) {
                        return false;
                    }
                    audioStateInfoMapValue.insert(std::pair< uint16, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfo >(o67Key, o67Value));
                } while (dbus_message_iter_next(&o65ArrayIter));
            }
        }
        out.setAudioStateInfoMap(audioStateInfoMapValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AudioStateInfoMapRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoMapRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::AudioStateInfoMapRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyListUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o68ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ii)", &o68ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty >* o69 = &in.getSystemPropertyList();
    ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty >::const_iterator o70 = o69->end();
    for (::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty >::const_iterator o71 = o69->begin(); o71 != o70; ++o71) {
        serializeDBus((*o71), &o68ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o68ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyListUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty > systemPropertyListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o72ArrayIter;
            dbus_message_iter_recurse (in, &o72ArrayIter);

            if(dbus_message_iter_get_arg_type(&o72ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemProperty o73;
                    if (!deserializeDBus(&o72ArrayIter, o73)) {
                        return false;
                    }
                    systemPropertyListValue.push_back(o73);
                } while (dbus_message_iter_next(&o72ArrayIter));
            }
        }
        out.setSystemPropertyList(systemPropertyListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyListRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SoundPropertyListUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyListUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSoundPropertyList(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyListUpdate& out) {
    {
        ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyData soundPropertyListValue;
        if (!deserializeDBus(in, soundPropertyListValue)) {
            return false;
        }
        out.setSoundPropertyList(soundPropertyListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SoundPropertyListRegister

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertyListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MainSinkSoundPropertyChangedSignal

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MainSinkSoundPropertyChangedSignal& in, DBusMessageIter* out) {
    int32 o74 = in.getPropertyType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o74));
    int32 o75 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o75));
    uint16 o76 = in.getSinkId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MainSinkSoundPropertyChangedSignal& out) {
    {
        int32 PropertyTypeValue;
        int32 &PropertyTypeTmpValue = PropertyTypeValue;
        dbus_message_iter_get_basic(in, &PropertyTypeTmpValue);
        out.setPropertyType(PropertyTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 valueValue;
        int32 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIdValue;
        uint16 &sinkIdTmpValue = sinkIdValue;
        dbus_message_iter_get_basic(in, &sinkIdTmpValue);
        out.setSinkId(sinkIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyChangedSignal

void serializeDBus (const ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyChangedSignal& in, DBusMessageIter* out) {
    int32 o77 = in.getPropertyType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o77));
    int32 o78 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SystemPropertyChangedSignal& out) {
    {
        int32 PropertyTypeValue;
        int32 &PropertyTypeTmpValue = PropertyTypeValue;
        dbus_message_iter_get_basic(in, &PropertyTypeTmpValue);
        out.setPropertyType(PropertyTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 valueValue;
        int32 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

