/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeDBus.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeJson.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace AudioSourceChange {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/masteraudioservice/bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange", AudioSourceChangeProxy);

class AudioSourceChangeProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AudioSourceChangeProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AudioSourceChangeProxy >& proxyShared = ::boost::static_pointer_cast< AudioSourceChangeProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sourceActivated:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceActivatedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceActivated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceActivatedSignal> payload = ::boost::static_pointer_cast<SourceActivatedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceActivatedCallbackIF*) _callback)->onSourceActivatedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sourceListChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceListChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceListChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceListChangedSignal> payload = ::boost::static_pointer_cast<SourceListChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceListChangedCallbackIF*) _callback)->onSourceListChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sourceAvailabilityChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceAvailabilityChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceAvailabilityChangedSignal> payload = ::boost::static_pointer_cast<SourceAvailabilityChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceAvailabilityChangedCallbackIF*) _callback)->onSourceAvailabilityChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_activeSource:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveSourceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveSourceError> payload = ::boost::static_pointer_cast<ActiveSourceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveSourceCallbackIF*) _callback)->onActiveSourceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveSourceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveSourceUpdate> payload = ::boost::static_pointer_cast<ActiveSourceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveSourceCallbackIF*) _callback)->onActiveSourceUpdate(proxyShared, payload);
                        proxyShared->_activeSource = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_activeSourceList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveSourceListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveSourceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveSourceListError> payload = ::boost::static_pointer_cast<ActiveSourceListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveSourceListCallbackIF*) _callback)->onActiveSourceListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveSourceListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveSourceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveSourceListUpdate> payload = ::boost::static_pointer_cast<ActiveSourceListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveSourceListCallbackIF*) _callback)->onActiveSourceListUpdate(proxyShared, payload);
                        proxyShared->_activeSourceList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_activateSource:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ActivateSourceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateSourceError> payload = ::boost::static_pointer_cast<ActivateSourceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateSourceCallbackIF*) _callback)->onActivateSourceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateSourceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateSourceResponse> payload = ::boost::static_pointer_cast<ActivateSourceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateSourceCallbackIF*) _callback)->onActivateSourceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_deactivateSource:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateSourceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeactivateSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeactivateSourceError> payload = ::boost::static_pointer_cast<DeactivateSourceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeactivateSourceCallbackIF*) _callback)->onDeactivateSourceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeactivateSourceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeactivateSource", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeactivateSourceResponse> payload = ::boost::static_pointer_cast<DeactivateSourceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeactivateSourceCallbackIF*) _callback)->onDeactivateSourceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getSourceList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetSourceListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSourceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSourceListError> payload = ::boost::static_pointer_cast<GetSourceListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSourceListCallbackIF*) _callback)->onGetSourceListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSourceListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSourceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSourceListResponse> payload = ::boost::static_pointer_cast<GetSourceListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSourceListCallbackIF*) _callback)->onGetSourceListResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sourceActivated: {
                ::boost::shared_ptr< SourceActivatedError > payload = ::boost::shared_ptr< SourceActivatedError >
                (new SourceActivatedError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceActivated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceActivatedCallbackIF*) _callback)->onSourceActivatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sourceListChanged: {
                ::boost::shared_ptr< SourceListChangedError > payload = ::boost::shared_ptr< SourceListChangedError >
                (new SourceListChangedError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceListChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceListChangedCallbackIF*) _callback)->onSourceListChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sourceAvailabilityChanged: {
                ::boost::shared_ptr< SourceAvailabilityChangedError > payload = ::boost::shared_ptr< SourceAvailabilityChangedError >
                (new SourceAvailabilityChangedError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceAvailabilityChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceAvailabilityChangedCallbackIF*) _callback)->onSourceAvailabilityChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeSource: {
                ::boost::shared_ptr< ActiveSourceError > payload = ::boost::shared_ptr< ActiveSourceError >
                (new ActiveSourceError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveSourceCallbackIF*) _callback)->onActiveSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeSourceList: {
                ::boost::shared_ptr< ActiveSourceListError > payload = ::boost::shared_ptr< ActiveSourceListError >
                (new ActiveSourceListError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveSourceList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveSourceListCallbackIF*) _callback)->onActiveSourceListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activateSource: {
                ::boost::shared_ptr< ActivateSourceError > payload = ::boost::shared_ptr< ActivateSourceError >
                (new ActivateSourceError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateSourceCallbackIF*) _callback)->onActivateSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deactivateSource: {
                ::boost::shared_ptr< DeactivateSourceError > payload = ::boost::shared_ptr< DeactivateSourceError >
                (new DeactivateSourceError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeactivateSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeactivateSourceCallbackIF*) _callback)->onDeactivateSourceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getSourceList: {
                ::boost::shared_ptr< GetSourceListError > payload = ::boost::shared_ptr< GetSourceListError >
                (new GetSourceListError(DBUS_ERROR_NO_SERVER, "The DBus service AudioSourceChange is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetSourceList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioSourceChangeProxy> proxyShared = ::boost::static_pointer_cast<AudioSourceChangeProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetSourceListCallbackIF*) _callback)->onGetSourceListError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AudioSourceChangeProxyCallback::_logger (AudioSourceChangeProxy::_logger);

AudioSourceChangeProxy::AudioSourceChangeProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", serviceAvailable, _logger) {
}

AudioSourceChangeProxy::~AudioSourceChangeProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AudioSourceChangeProxy > AudioSourceChangeProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AudioSourceChangeProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AudioSourceChangeProxy > proxyNew(new AudioSourceChangeProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t AudioSourceChangeProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AudioSourceChangeProxyCallback* callback = new AudioSourceChangeProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AudioSourceChangeProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AudioSourceChangeProxyCallback* callback = new AudioSourceChangeProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AudioSourceChangeProxy::clearAllProperties ()
{
    _activeSource = ::asf::core::nullable< ActiveSourceUpdate >();
    _activeSourceList = ::asf::core::nullable< ActiveSourceListUpdate >();
}

void AudioSourceChangeProxy::sendDeregisterAll () const
{
    sendActiveSourceDeregisterAll();
    sendActiveSourceListDeregisterAll();
    sendSourceActivatedDeregisterAll();
    sendSourceListChangedDeregisterAll();
    sendSourceAvailabilityChangedDeregisterAll();
}

act_t AudioSourceChangeProxy::sendSourceActivatedRegister(SourceActivatedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sourceActivated");
    act_t act = addSignalCallback(ID_sourceActivated, "sourceActivated", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceActivated", &cb, act);
    return act;
}

bool AudioSourceChangeProxy::sendSourceActivatedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sourceActivated", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceActivated", act, static_cast<int>(rv));
    return rv;
}

void AudioSourceChangeProxy::sendSourceActivatedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceActivated");
    _dbusProxyDelegate->deregisterSignalCallback("sourceActivated", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioSourceChangeProxy::sendSourceListChangedRegister(SourceListChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sourceListChanged");
    act_t act = addSignalCallback(ID_sourceListChanged, "sourceListChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceListChanged", &cb, act);
    return act;
}

bool AudioSourceChangeProxy::sendSourceListChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sourceListChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceListChanged", act, static_cast<int>(rv));
    return rv;
}

void AudioSourceChangeProxy::sendSourceListChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceListChanged");
    _dbusProxyDelegate->deregisterSignalCallback("sourceListChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioSourceChangeProxy::sendSourceAvailabilityChangedRegister(SourceAvailabilityChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sourceAvailabilityChanged");
    act_t act = addSignalCallback(ID_sourceAvailabilityChanged, "sourceAvailabilityChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceAvailabilityChanged", &cb, act);
    return act;
}

bool AudioSourceChangeProxy::sendSourceAvailabilityChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sourceAvailabilityChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceAvailabilityChanged", act, static_cast<int>(rv));
    return rv;
}

void AudioSourceChangeProxy::sendSourceAvailabilityChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceAvailabilityChanged");
    _dbusProxyDelegate->deregisterSignalCallback("sourceAvailabilityChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioSourceChangeProxy::sendActiveSourceRegister(ActiveSourceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeSource, "activeSource", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveSource", &cb, act);
    return act;
}

bool AudioSourceChangeProxy::sendActiveSourceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeSource", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveSource", act, static_cast<int>(rv));
    return rv;
}

act_t AudioSourceChangeProxy::sendActiveSourceGet(ActiveSourceCallbackIF& cb) {
    AudioSourceChangeProxyCallback* callback = new AudioSourceChangeProxyCallback(ID_activeSource, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveSource", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeSource", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const sourceData& AudioSourceChangeProxy::getActiveSource() const {
    return _activeSource.get().getActiveSource();
}

bool AudioSourceChangeProxy::hasActiveSource() const {
    return _activeSource.hasValue();
}

void AudioSourceChangeProxy::sendActiveSourceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveSource");
    _dbusProxyDelegate->deregisterSignalCallback("activeSource", 0, _dbusDaemonProxy.get(), true);
}

act_t AudioSourceChangeProxy::sendActiveSourceListRegister(ActiveSourceListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeSourceList, "activeSourceList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveSourceList", &cb, act);
    return act;
}

bool AudioSourceChangeProxy::sendActiveSourceListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeSourceList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveSourceList", act, static_cast<int>(rv));
    return rv;
}

act_t AudioSourceChangeProxy::sendActiveSourceListGet(ActiveSourceListCallbackIF& cb) {
    AudioSourceChangeProxyCallback* callback = new AudioSourceChangeProxyCallback(ID_activeSourceList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveSourceList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeSourceList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< sourceData >& AudioSourceChangeProxy::getActiveSourceList() const {
    return _activeSourceList.get().getActiveSourceList();
}

bool AudioSourceChangeProxy::hasActiveSourceList() const {
    return _activeSourceList.hasValue();
}

void AudioSourceChangeProxy::sendActiveSourceListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveSourceList");
    _dbusProxyDelegate->deregisterSignalCallback("activeSourceList", 0, _dbusDaemonProxy.get(), true);
}

act_t AudioSourceChangeProxy::sendActivateSourceRequest(ActivateSourceCallbackIF& cb, const sourceData& sourceInfo, bool forceViewChange) const {
    ActivateSourceRequest* payload = new ActivateSourceRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceInfo(sourceInfo);
    payload->setForceViewChange(forceViewChange);
    DBUS_MESSAGE_CALL(dbusMessage, "activateSource", ActivateSourceRequest, payload, true)
    act_t act = addMethodCallback(ID_activateSource, dbusMessage.getUniqueSerial(), "activateSource", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ActivateSource", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AudioSourceChangeProxy::sendDeactivateSourceRequest(DeactivateSourceCallbackIF& cb, const sourceData& sourceInfo) const {
    DeactivateSourceRequest* payload = new DeactivateSourceRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceInfo(sourceInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "deactivateSource", DeactivateSourceRequest, payload, true)
    act_t act = addMethodCallback(ID_deactivateSource, dbusMessage.getUniqueSerial(), "deactivateSource", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeactivateSource", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AudioSourceChangeProxy::sendGetSourceListRequest(GetSourceListCallbackIF& cb, int32 srcGroupId) const {
    GetSourceListRequest* payload = new GetSourceListRequest();
    CHECK_ALLOCATION(payload);
    payload->setSrcGroupId(srcGroupId);
    DBUS_MESSAGE_CALL(dbusMessage, "getSourceList", GetSourceListRequest, payload, true)
    act_t act = addMethodCallback(ID_getSourceList, dbusMessage.getUniqueSerial(), "getSourceList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetSourceList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace AudioSourceChange
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
